# coding: utf-8

"""
    マネーフォワード クラウド経費API

    このページは[マネーフォワード クラウド経費](https://expense.moneyforward.com)（クラウド型の経費精算・ワークフローサービス）のAPIドキュメントです。ご利用開始の手順については、[github](https://github.com/moneyforward/expense-api-doc) をご覧ください。バグ報告や改善要望はgithub上からissue登録をして頂ければ幸いです。このドキュメントは[Swagger](http://swagger.io)の仕様で作成されています。実際にこのページでAPIの試打を行うことができます。試打を行いたい場合は、APIを利用するアプリケーションの登録の際に、Redirect URIを`https://expense.moneyforward.com/api/oauth2-redirect.html`に指定してお試しください。  # noqa: E501

    The version of the OpenAPI document: 1
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from moneyforward_ex.api_client import ApiClient
from moneyforward_ex.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class ExReportApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def find_ex_report_ex_transactions(self, office_id, ex_report_id, **kwargs):  # noqa: E501
        """経費申請に含まれる経費明細リストを返す  # noqa: E501

        経費申請に含まれる経費明細リストを返す  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_ex_report_ex_transactions(office_id, ex_report_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str office_id: 事業所id (required)
        :param str ex_report_id: 申請id (required)
        :param int page: ページ番号
        :param str query_object_dept_id: 部門idでフィルタ
        :param str query_object_project_code_id: プロジェクトidでフィルタ
        :param str query_object_ex_item_id: 経費科目idでフィルタ
        :param str query_object_office_member_id: メンバーidでフィルタ
        :param int query_object_number: 経費明細番号でフィルタ
        :param int query_object_number_from: 指定番号以上の経費明細番号でフィルタ
        :param int query_object_number_to: 指定番号以下の経費明細番号でフィルタ
        :param float query_object_value_min: 金額下限でフィルタ
        :param float query_object_value_max: 金額上限でフィルタ
        :param bool query_object_is_exported: 仕訳出力済みかどうかでフィルタ
        :param bool query_object_is_reported: 経費申請に含まれるかどうかでフィルタ
        :param datetime query_object_approved_at_from: 申請の承認時刻について指定時刻以降でフィルタ ex.`2018-09-30 00:00:00 +0900`
        :param datetime query_object_approved_at_to: 申請の承認時刻について指定時刻以前でフィルタ ex.`2018-09-30 23:59:59 +0900`
        :param date query_object_recognized_at_from: 日付に指定日付以降でフィルタ ex.`2018-09-30`
        :param date query_object_recognized_at_to: 日付に指定日付以前でフィルタ ex.`2018-09-30`
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.find_ex_report_ex_transactions_with_http_info(office_id, ex_report_id, **kwargs)  # noqa: E501

    def find_ex_report_ex_transactions_with_http_info(self, office_id, ex_report_id, **kwargs):  # noqa: E501
        """経費申請に含まれる経費明細リストを返す  # noqa: E501

        経費申請に含まれる経費明細リストを返す  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_ex_report_ex_transactions_with_http_info(office_id, ex_report_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str office_id: 事業所id (required)
        :param str ex_report_id: 申請id (required)
        :param int page: ページ番号
        :param str query_object_dept_id: 部門idでフィルタ
        :param str query_object_project_code_id: プロジェクトidでフィルタ
        :param str query_object_ex_item_id: 経費科目idでフィルタ
        :param str query_object_office_member_id: メンバーidでフィルタ
        :param int query_object_number: 経費明細番号でフィルタ
        :param int query_object_number_from: 指定番号以上の経費明細番号でフィルタ
        :param int query_object_number_to: 指定番号以下の経費明細番号でフィルタ
        :param float query_object_value_min: 金額下限でフィルタ
        :param float query_object_value_max: 金額上限でフィルタ
        :param bool query_object_is_exported: 仕訳出力済みかどうかでフィルタ
        :param bool query_object_is_reported: 経費申請に含まれるかどうかでフィルタ
        :param datetime query_object_approved_at_from: 申請の承認時刻について指定時刻以降でフィルタ ex.`2018-09-30 00:00:00 +0900`
        :param datetime query_object_approved_at_to: 申請の承認時刻について指定時刻以前でフィルタ ex.`2018-09-30 23:59:59 +0900`
        :param date query_object_recognized_at_from: 日付に指定日付以降でフィルタ ex.`2018-09-30`
        :param date query_object_recognized_at_to: 日付に指定日付以前でフィルタ ex.`2018-09-30`
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(object, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'office_id',
            'ex_report_id',
            'page',
            'query_object_dept_id',
            'query_object_project_code_id',
            'query_object_ex_item_id',
            'query_object_office_member_id',
            'query_object_number',
            'query_object_number_from',
            'query_object_number_to',
            'query_object_value_min',
            'query_object_value_max',
            'query_object_is_exported',
            'query_object_is_reported',
            'query_object_approved_at_from',
            'query_object_approved_at_to',
            'query_object_recognized_at_from',
            'query_object_recognized_at_to'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method find_ex_report_ex_transactions" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'office_id' is set
        if self.api_client.client_side_validation and ('office_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['office_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `office_id` when calling `find_ex_report_ex_transactions`")  # noqa: E501
        # verify the required parameter 'ex_report_id' is set
        if self.api_client.client_side_validation and ('ex_report_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['ex_report_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `ex_report_id` when calling `find_ex_report_ex_transactions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'office_id' in local_var_params:
            path_params['office_id'] = local_var_params['office_id']  # noqa: E501
        if 'ex_report_id' in local_var_params:
            path_params['ex_report_id'] = local_var_params['ex_report_id']  # noqa: E501

        query_params = []
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501
        if 'query_object_dept_id' in local_var_params and local_var_params['query_object_dept_id'] is not None:  # noqa: E501
            query_params.append(('query_object[dept_id]', local_var_params['query_object_dept_id']))  # noqa: E501
        if 'query_object_project_code_id' in local_var_params and local_var_params['query_object_project_code_id'] is not None:  # noqa: E501
            query_params.append(('query_object[project_code_id]', local_var_params['query_object_project_code_id']))  # noqa: E501
        if 'query_object_ex_item_id' in local_var_params and local_var_params['query_object_ex_item_id'] is not None:  # noqa: E501
            query_params.append(('query_object[ex_item_id]', local_var_params['query_object_ex_item_id']))  # noqa: E501
        if 'query_object_office_member_id' in local_var_params and local_var_params['query_object_office_member_id'] is not None:  # noqa: E501
            query_params.append(('query_object[office_member_id]', local_var_params['query_object_office_member_id']))  # noqa: E501
        if 'query_object_number' in local_var_params and local_var_params['query_object_number'] is not None:  # noqa: E501
            query_params.append(('query_object[number]', local_var_params['query_object_number']))  # noqa: E501
        if 'query_object_number_from' in local_var_params and local_var_params['query_object_number_from'] is not None:  # noqa: E501
            query_params.append(('query_object[number_from]', local_var_params['query_object_number_from']))  # noqa: E501
        if 'query_object_number_to' in local_var_params and local_var_params['query_object_number_to'] is not None:  # noqa: E501
            query_params.append(('query_object[number_to]', local_var_params['query_object_number_to']))  # noqa: E501
        if 'query_object_value_min' in local_var_params and local_var_params['query_object_value_min'] is not None:  # noqa: E501
            query_params.append(('query_object[value_min]', local_var_params['query_object_value_min']))  # noqa: E501
        if 'query_object_value_max' in local_var_params and local_var_params['query_object_value_max'] is not None:  # noqa: E501
            query_params.append(('query_object[value_max]', local_var_params['query_object_value_max']))  # noqa: E501
        if 'query_object_is_exported' in local_var_params and local_var_params['query_object_is_exported'] is not None:  # noqa: E501
            query_params.append(('query_object[is_exported]', local_var_params['query_object_is_exported']))  # noqa: E501
        if 'query_object_is_reported' in local_var_params and local_var_params['query_object_is_reported'] is not None:  # noqa: E501
            query_params.append(('query_object[is_reported]', local_var_params['query_object_is_reported']))  # noqa: E501
        if 'query_object_approved_at_from' in local_var_params and local_var_params['query_object_approved_at_from'] is not None:  # noqa: E501
            query_params.append(('query_object[approved_at_from]', local_var_params['query_object_approved_at_from']))  # noqa: E501
        if 'query_object_approved_at_to' in local_var_params and local_var_params['query_object_approved_at_to'] is not None:  # noqa: E501
            query_params.append(('query_object[approved_at_to]', local_var_params['query_object_approved_at_to']))  # noqa: E501
        if 'query_object_recognized_at_from' in local_var_params and local_var_params['query_object_recognized_at_from'] is not None:  # noqa: E501
            query_params.append(('query_object[recognized_at_from]', local_var_params['query_object_recognized_at_from']))  # noqa: E501
        if 'query_object_recognized_at_to' in local_var_params and local_var_params['query_object_recognized_at_to'] is not None:  # noqa: E501
            query_params.append(('query_object[recognized_at_to]', local_var_params['query_object_recognized_at_to']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['mf_expense_oauth']  # noqa: E501

        return self.api_client.call_api(
            '/api/external/v1/offices/{office_id}/ex_reports/{ex_report_id}/ex_transactions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def find_office_approving_ex_reports(self, office_id, **kwargs):  # noqa: E501
        """事業所全体の承認待ちリストを返す  # noqa: E501

        事業所全体の承認待ちリストを返す  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_office_approving_ex_reports(office_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str office_id: 事業所id (required)
        :param int page: ページ番号
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.find_office_approving_ex_reports_with_http_info(office_id, **kwargs)  # noqa: E501

    def find_office_approving_ex_reports_with_http_info(self, office_id, **kwargs):  # noqa: E501
        """事業所全体の承認待ちリストを返す  # noqa: E501

        事業所全体の承認待ちリストを返す  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_office_approving_ex_reports_with_http_info(office_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str office_id: 事業所id (required)
        :param int page: ページ番号
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(object, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'office_id',
            'page'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method find_office_approving_ex_reports" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'office_id' is set
        if self.api_client.client_side_validation and ('office_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['office_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `office_id` when calling `find_office_approving_ex_reports`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'office_id' in local_var_params:
            path_params['office_id'] = local_var_params['office_id']  # noqa: E501

        query_params = []
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['mf_expense_oauth']  # noqa: E501

        return self.api_client.call_api(
            '/api/external/v1/offices/{office_id}/approving_ex_reports', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def find_office_ex_journals_by_ex_reports(self, office_id, **kwargs):  # noqa: E501
        """事業所全体の申請に紐づく仕訳リストを返す  # noqa: E501

        事業所全体の申請に紐づく仕訳リストを返す  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_office_ex_journals_by_ex_reports(office_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str office_id: 事業所id (required)
        :param int page: ページ番号
        :param date query_object_recognized_at_from: 仕訳の計上日について指定日以降でフィルタ (recognized_at_to との期間は最大で 3 ヶ月) ex.`2019-09-30`
        :param date query_object_recognized_at_to: 仕訳の計上日について指定日以前でフィルタ (recognized_at_from との期間は最大で 3 ヶ月) ex.`2019-09-30`
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.find_office_ex_journals_by_ex_reports_with_http_info(office_id, **kwargs)  # noqa: E501

    def find_office_ex_journals_by_ex_reports_with_http_info(self, office_id, **kwargs):  # noqa: E501
        """事業所全体の申請に紐づく仕訳リストを返す  # noqa: E501

        事業所全体の申請に紐づく仕訳リストを返す  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_office_ex_journals_by_ex_reports_with_http_info(office_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str office_id: 事業所id (required)
        :param int page: ページ番号
        :param date query_object_recognized_at_from: 仕訳の計上日について指定日以降でフィルタ (recognized_at_to との期間は最大で 3 ヶ月) ex.`2019-09-30`
        :param date query_object_recognized_at_to: 仕訳の計上日について指定日以前でフィルタ (recognized_at_from との期間は最大で 3 ヶ月) ex.`2019-09-30`
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(object, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'office_id',
            'page',
            'query_object_recognized_at_from',
            'query_object_recognized_at_to'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method find_office_ex_journals_by_ex_reports" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'office_id' is set
        if self.api_client.client_side_validation and ('office_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['office_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `office_id` when calling `find_office_ex_journals_by_ex_reports`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'office_id' in local_var_params:
            path_params['office_id'] = local_var_params['office_id']  # noqa: E501

        query_params = []
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501
        if 'query_object_recognized_at_from' in local_var_params and local_var_params['query_object_recognized_at_from'] is not None:  # noqa: E501
            query_params.append(('query_object[recognized_at_from]', local_var_params['query_object_recognized_at_from']))  # noqa: E501
        if 'query_object_recognized_at_to' in local_var_params and local_var_params['query_object_recognized_at_to'] is not None:  # noqa: E501
            query_params.append(('query_object[recognized_at_to]', local_var_params['query_object_recognized_at_to']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['mf_expense_oauth']  # noqa: E501

        return self.api_client.call_api(
            '/api/external/v1/offices/{office_id}/ex_journals_by_ex_reports', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def find_office_ex_report(self, office_id, id, **kwargs):  # noqa: E501
        """事業所全体の申請を返す  # noqa: E501

        事業所全体の申請を返す  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_office_ex_report(office_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str office_id: 事業所id (required)
        :param str id: id (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ExReport
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.find_office_ex_report_with_http_info(office_id, id, **kwargs)  # noqa: E501

    def find_office_ex_report_with_http_info(self, office_id, id, **kwargs):  # noqa: E501
        """事業所全体の申請を返す  # noqa: E501

        事業所全体の申請を返す  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_office_ex_report_with_http_info(office_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str office_id: 事業所id (required)
        :param str id: id (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ExReport, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'office_id',
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method find_office_ex_report" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'office_id' is set
        if self.api_client.client_side_validation and ('office_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['office_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `office_id` when calling `find_office_ex_report`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `find_office_ex_report`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'office_id' in local_var_params:
            path_params['office_id'] = local_var_params['office_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['mf_expense_oauth']  # noqa: E501

        return self.api_client.call_api(
            '/api/external/v1/offices/{office_id}/ex_reports/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ExReport',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def find_office_ex_report_journal(self, office_id, ex_report_id, **kwargs):  # noqa: E501
        """申請に対応する仕訳を返す  # noqa: E501

        申請に対応する仕訳を返す  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_office_ex_report_journal(office_id, ex_report_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str office_id: 事業所id (required)
        :param str ex_report_id: 申請id (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ExJournal
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.find_office_ex_report_journal_with_http_info(office_id, ex_report_id, **kwargs)  # noqa: E501

    def find_office_ex_report_journal_with_http_info(self, office_id, ex_report_id, **kwargs):  # noqa: E501
        """申請に対応する仕訳を返す  # noqa: E501

        申請に対応する仕訳を返す  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_office_ex_report_journal_with_http_info(office_id, ex_report_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str office_id: 事業所id (required)
        :param str ex_report_id: 申請id (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ExJournal, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'office_id',
            'ex_report_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method find_office_ex_report_journal" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'office_id' is set
        if self.api_client.client_side_validation and ('office_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['office_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `office_id` when calling `find_office_ex_report_journal`")  # noqa: E501
        # verify the required parameter 'ex_report_id' is set
        if self.api_client.client_side_validation and ('ex_report_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['ex_report_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `ex_report_id` when calling `find_office_ex_report_journal`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'office_id' in local_var_params:
            path_params['office_id'] = local_var_params['office_id']  # noqa: E501
        if 'ex_report_id' in local_var_params:
            path_params['ex_report_id'] = local_var_params['ex_report_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['mf_expense_oauth']  # noqa: E501

        return self.api_client.call_api(
            '/api/external/v1/offices/{office_id}/ex_reports/{ex_report_id}/ex_journal', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ExJournal',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def find_office_ex_report_me(self, office_id, id, **kwargs):  # noqa: E501
        """自分の申請を返す  # noqa: E501

        自分の申請を返す  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_office_ex_report_me(office_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str office_id: 事業所id (required)
        :param str id: id (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ExReport
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.find_office_ex_report_me_with_http_info(office_id, id, **kwargs)  # noqa: E501

    def find_office_ex_report_me_with_http_info(self, office_id, id, **kwargs):  # noqa: E501
        """自分の申請を返す  # noqa: E501

        自分の申請を返す  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_office_ex_report_me_with_http_info(office_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str office_id: 事業所id (required)
        :param str id: id (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ExReport, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'office_id',
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method find_office_ex_report_me" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'office_id' is set
        if self.api_client.client_side_validation and ('office_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['office_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `office_id` when calling `find_office_ex_report_me`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `find_office_ex_report_me`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'office_id' in local_var_params:
            path_params['office_id'] = local_var_params['office_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['mf_expense_oauth']  # noqa: E501

        return self.api_client.call_api(
            '/api/external/v1/offices/{office_id}/me/ex_reports/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ExReport',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def find_office_ex_reports(self, office_id, **kwargs):  # noqa: E501
        """事業所全体の申請リストを返す  # noqa: E501

        事業所全体の申請リストを返す  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_office_ex_reports(office_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str office_id: 事業所id (required)
        :param int page: ページ番号
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.find_office_ex_reports_with_http_info(office_id, **kwargs)  # noqa: E501

    def find_office_ex_reports_with_http_info(self, office_id, **kwargs):  # noqa: E501
        """事業所全体の申請リストを返す  # noqa: E501

        事業所全体の申請リストを返す  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_office_ex_reports_with_http_info(office_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str office_id: 事業所id (required)
        :param int page: ページ番号
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(object, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'office_id',
            'page'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method find_office_ex_reports" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'office_id' is set
        if self.api_client.client_side_validation and ('office_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['office_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `office_id` when calling `find_office_ex_reports`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'office_id' in local_var_params:
            path_params['office_id'] = local_var_params['office_id']  # noqa: E501

        query_params = []
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['mf_expense_oauth']  # noqa: E501

        return self.api_client.call_api(
            '/api/external/v1/offices/{office_id}/ex_reports', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def find_office_ex_reports_me(self, office_id, **kwargs):  # noqa: E501
        """自分の申請リストを返す  # noqa: E501

        自分の申請リストを返す  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_office_ex_reports_me(office_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str office_id: 事業所id (required)
        :param int page: ページ番号
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.find_office_ex_reports_me_with_http_info(office_id, **kwargs)  # noqa: E501

    def find_office_ex_reports_me_with_http_info(self, office_id, **kwargs):  # noqa: E501
        """自分の申請リストを返す  # noqa: E501

        自分の申請リストを返す  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_office_ex_reports_me_with_http_info(office_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str office_id: 事業所id (required)
        :param int page: ページ番号
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(object, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'office_id',
            'page'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method find_office_ex_reports_me" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'office_id' is set
        if self.api_client.client_side_validation and ('office_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['office_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `office_id` when calling `find_office_ex_reports_me`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'office_id' in local_var_params:
            path_params['office_id'] = local_var_params['office_id']  # noqa: E501

        query_params = []
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['mf_expense_oauth']  # noqa: E501

        return self.api_client.call_api(
            '/api/external/v1/offices/{office_id}/me/ex_reports', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def find_office_member_approving_ex_reports(self, office_id, **kwargs):  # noqa: E501
        """自分の承認待ちリストを返す  # noqa: E501

        自分の承認待ちリストを返す  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_office_member_approving_ex_reports(office_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str office_id: 事業所id (required)
        :param int page: ページ番号
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.find_office_member_approving_ex_reports_with_http_info(office_id, **kwargs)  # noqa: E501

    def find_office_member_approving_ex_reports_with_http_info(self, office_id, **kwargs):  # noqa: E501
        """自分の承認待ちリストを返す  # noqa: E501

        自分の承認待ちリストを返す  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_office_member_approving_ex_reports_with_http_info(office_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str office_id: 事業所id (required)
        :param int page: ページ番号
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(object, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'office_id',
            'page'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method find_office_member_approving_ex_reports" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'office_id' is set
        if self.api_client.client_side_validation and ('office_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['office_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `office_id` when calling `find_office_member_approving_ex_reports`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'office_id' in local_var_params:
            path_params['office_id'] = local_var_params['office_id']  # noqa: E501

        query_params = []
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['mf_expense_oauth']  # noqa: E501

        return self.api_client.call_api(
            '/api/external/v1/offices/{office_id}/me/approving_ex_reports', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
