import { IResource, Resource } from 'aws-cdk-lib';
import { Construct } from 'constructs';
import { IComputeEnvironment } from './compute-environment';
/**
 * (experimental) Properties for mapping a compute environment to a job queue.
 *
 * @experimental
 */
export interface JobQueueComputeEnvironment {
    /**
     * (experimental) The batch compute environment to use for processing submitted jobs to this queue.
     *
     * @experimental
     */
    readonly computeEnvironment: IComputeEnvironment;
    /**
     * (experimental) The order in which this compute environment will be selected for dynamic allocation of resources to process submitted jobs.
     *
     * @experimental
     */
    readonly order: number;
}
/**
 * (experimental) Properties of a batch job queue.
 *
 * @experimental
 */
export interface JobQueueProps {
    /**
     * (experimental) A name for the job queue.
     *
     * Up to 128 letters (uppercase and lowercase), numbers, hyphens, and underscores are allowed.
     *
     * @default - Cloudformation-generated name
     * @experimental
     */
    readonly jobQueueName?: string;
    /**
     * (experimental) The set of compute environments mapped to a job queue and their order relative to each other.
     *
     * The job scheduler uses this parameter to
     * determine which compute environment should execute a given job. Compute environments must be in the VALID state before you can associate them
     * with a job queue. You can associate up to three compute environments with a job queue.
     *
     * @experimental
     */
    readonly computeEnvironments: JobQueueComputeEnvironment[];
    /**
     * (experimental) The priority of the job queue.
     *
     * Job queues with a higher priority (or a higher integer value for the priority parameter) are evaluated first
     * when associated with the same compute environment. Priority is determined in descending order, for example, a job queue with a priority value
     * of 10 is given scheduling preference over a job queue with a priority value of 1.
     *
     * @default 1
     * @experimental
     */
    readonly priority?: number;
    /**
     * (experimental) The state of the job queue.
     *
     * If set to true, it is able to accept jobs.
     *
     * @default true
     * @experimental
     */
    readonly enabled?: boolean;
}
/**
 * (experimental) Properties of a Job Queue.
 *
 * @experimental
 */
export interface IJobQueue extends IResource {
    /**
     * (experimental) The ARN of this batch job queue.
     *
     * @experimental
     * @attribute true
     */
    readonly jobQueueArn: string;
    /**
     * (experimental) A name for the job queue.
     *
     * Up to 128 letters (uppercase and lowercase), numbers, hyphens, and underscores are allowed.
     *
     * @experimental
     * @attribute true
     */
    readonly jobQueueName: string;
}
/**
 * (experimental) Batch Job Queue.
 *
 * Defines a batch job queue to define how submitted batch jobs
 * should be ran based on specified batch compute environments.
 *
 * @experimental
 */
export declare class JobQueue extends Resource implements IJobQueue {
    /**
     * (experimental) Fetches an existing batch job queue by its amazon resource name.
     *
     * @experimental
     */
    static fromJobQueueArn(scope: Construct, id: string, jobQueueArn: string): IJobQueue;
    /**
     * (experimental) The ARN of this batch job queue.
     *
     * @experimental
     */
    readonly jobQueueArn: string;
    /**
     * (experimental) A name for the job queue.
     *
     * Up to 128 letters (uppercase and lowercase), numbers, hyphens, and underscores are allowed.
     *
     * @experimental
     */
    readonly jobQueueName: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: JobQueueProps);
}
