#!/usr/bin/env python

"""The setup script."""

from setuptools import setup, find_packages

with open('README.rst') as readme_file:
    readme = readme_file.read()

with open('HISTORY.rst') as history_file:
    history = history_file.read()

requirements = [
    "scapy",
    "logstash_formatter"
]

setup_requirements = [ ]

test_requirements = [ ]

setup(
    author="Andres Kepler",
    author_email='andres.kepler@entigo.com',
    python_requires='>=3.5',
    classifiers=[
        'Development Status :: 2 - Pre-Alpha',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: MIT License',
        'Natural Language :: English',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.5',
        'Programming Language :: Python :: 3.6',
        'Programming Language :: Python :: 3.7',
        'Programming Language :: Python :: 3.8',
    ],
    description="Python PCAP file parser for FC drivers",
    entry_points={
        'console_scripts': [
            'driver_pcap_parser=driver_pcap_parser.cli:main',
        ],
    },
    install_requires=requirements,
    license="MIT license",
    long_description=readme + '\n\n' + history,
    include_package_data=True,
    keywords='driver_pcap_parser',
    name='driver_pcap_parser',
    packages=find_packages(include=['driver_pcap_parser', 'driver_pcap_parser.*']),
    setup_requires=setup_requirements,
    test_suite='tests',
    tests_require=test_requirements,
    url='https://github.com/andrke/driver_pcap_parser',
    version='0.1.16',
    zip_safe=False,
)
