from PyQt5.QtWidgets import QGraphicsLineItem
from PyQt5.QtCore import Qt, QPointF


class BaseEdge(QGraphicsLineItem):
    def __init__(self, source_node, destination_node, metadata, nx_pos):
        """
        Create an arc between two nodes

        :param str source_node: Source node id of the arc
        :param str destination_node: Destination node id of the arc
        :param dict metadata: Edge metadata
        :param dict nx_pos: The position generated by nx_graph
        """
        super().__init__()

        self.metadata = metadata
        self.source = source_node
        self.destination = destination_node

        self.status = self.metadata["status"]

        self.source_point = QPointF(nx_pos[self.source][0], nx_pos[self.source][1])
        self.destination_point = QPointF(
            nx_pos[self.destination][0], nx_pos[self.destination][1]
        )

        self.setAcceptedMouseButtons(Qt.NoButton)
