import setuptools


with open("README.md", "r") as fh:
    long_description = fh.read()

setuptools.setup(
    name="cycle_prediction",  # Replace with your own username
    version="1.0.2",
    author="Fadi Baskharon",
    author_email="nzfadi@gmail.com",
    description="A package to train and predict the end of a process from history logs",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/fazaki/time-to-event/tree/master",
    packages=setuptools.find_packages(),
    install_requires=[
        'absl-py==0.9.0',
        'alabaster==0.7.12',
        'argh==0.26.2',
        'argon2-cffi==20.1.0',
        'astor==0.8.1',
        'astroid==2.4.2',
        'async-generator==1.10',
        'atomicwrites==1.4.0',
        'attrs==20.1.0',
        'Babel==2.8.0',
        'backcall==0.1.0',
        'bleach==3.1.5',
        'cachetools==4.0.0',
        'certifi==2020.4.5.1',
        'cffi==1.14.2',
        'chardet==3.0.4',
        'colorama==0.4.3',
        'cycler==0.10.0',
        'decorator==4.4.2',
        'defusedxml==0.6.0',
        'docutils==0.16',
        'entrypoints==0.3',
        'gast==0.2.2',
        'google-auth==1.12.0',
        'google-auth-oauthlib==0.4.1',
        'google-pasta==0.2.0',
        'grpcio==1.27.2',
        'h5py==2.10.0',
        'idna==2.9',
        'imagesize==1.2.0',
        'importlib-metadata==1.7.0',
        'iniconfig==1.0.1',
        'ipykernel==5.3.4',
        'ipython==7.13.0',
        'ipython-genutils==0.2.0',
        'isort==5.4.2',
        'jedi==0.17.0',
        'Jinja2==2.11.2',
        'joblib==0.14.1',
        'jsonschema==3.2.0',
        'jupyter-client==6.1.0',
        'jupyter-core==4.6.3',
        'jupyterlab-pygments==0.1.1',
        'jupyterthemes==0.20.0',
        'Keras==2.3.1',
        'Keras-Applications==1.0.8',
        'Keras-Preprocessing==1.1.0',
        'kiwisolver==1.2.0',
        'lazy-object-proxy==1.4.3',
        'lesscpy==0.13.0',
        'livereload==2.6.3',
        'Markdown==3.2.1',
        'MarkupSafe==1.1.1',
        'matplotlib==3.2.1',
        'mccabe==0.6.1',
        'mistune==0.8.4',
        'more-itertools==8.2.0',
        'nbclient==0.5.0',
        'nbconvert==6.0.1',
        'nbformat==5.0.7',
        'nest-asyncio==1.4.0',
        'notebook==6.1.4',
        'numpy==1.18.2',
        'oauthlib==3.1.0',
        'opt-einsum==3.2.0',
        'packaging==20.4',
        'pandas==1.0.3',
        'pandocfilters==1.4.2',
        'parso==0.7.0',
        'pathtools==0.1.2',
        'pickleshare==0.7.5',
        'pluggy==0.13.1',
        'ply==3.11',
        'pockets==0.9.1',
        'port-for==0.3.1',
        'prometheus-client==0.8.0',
        'prompt-toolkit==3.0.5',
        'protobuf==3.11.3',
        'py==1.9.0',
        'pyasn1==0.4.8',
        'pyasn1-modules==0.2.8',
        'pycodestyle==2.6.0',
        'pycparser==2.20',
        'pylint==2.6.0',
        'pyparsing==2.4.7',
        'pyrsistent==0.16.0',
        'pytest==6.0.1',
        'pytest-docs==0.1.0',
        'python-dateutil==2.8.1',
        'pytz==2019.3',
        'pywinpty==0.5.7',
        'PyYAML==5.3.1',
        'pyzmq==19.0.0',
        'requests==2.23.0',
        'requests-oauthlib==1.3.0',
        'rsa==4.0',
        'rstcheck==3.3.1',
        'scikit-learn==0.22.2.post1',
        'scipy==1.4.1',
        'seaborn==0.10.0',
        'Send2Trash==1.5.0',
        'six==1.14.0',
        'snowballstemmer==2.0.0',
        'tensorboard==2.0.2',
        'tensorflow==2.0.1',
        'tensorflow-estimator==2.0.1',
        'termcolor==1.1.0',
        'terminado==0.8.3',
        'testpath==0.4.4',
        'toml==0.10.1',
        'tornado==6.0.4',
        'traitlets==4.3.3',
        'typed-ast==1.4.1',
        'urllib3==1.25.8',
        'watchdog==0.10.3',
        'wcwidth==0.1.9',
        'webencodings==0.5.1',
        'Werkzeug==1.0.0',
        'wincertstore==0.2',
        'wrapt==1.12.1',
        'wtte==1.1.1',
        'zipp==3.1.0'
    ], 
    classifiers=[
        "Programming Language :: Python :: 3.7",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
    ],
    python_requires='>=3.7',
)
