# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['FusionAuthApplicationRoleArgs', 'FusionAuthApplicationRole']

@pulumi.input_type
class FusionAuthApplicationRoleArgs:
    def __init__(__self__, *,
                 application_id: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 is_default: Optional[pulumi.Input[bool]] = None,
                 is_super_role: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a FusionAuthApplicationRole resource.
        :param pulumi.Input[str] application_id: ID of the application that this role is for.
        :param pulumi.Input[str] description: A description for the role.
        :param pulumi.Input[bool] is_default: Whether or not the Role is a default role. A default role is automatically assigned to a user during registration if no roles are provided.
        :param pulumi.Input[bool] is_super_role: Whether or not the Role is a considered to be a super user role. This is a marker to indicate that it supersedes all other roles. FusionAuth will attempt to enforce this contract when using the web UI, it is not enforced programmatically when using the API.
        :param pulumi.Input[str] name: The name of the Role.
        """
        pulumi.set(__self__, "application_id", application_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if is_default is not None:
            pulumi.set(__self__, "is_default", is_default)
        if is_super_role is not None:
            pulumi.set(__self__, "is_super_role", is_super_role)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Input[str]:
        """
        ID of the application that this role is for.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "application_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description for the role.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not the Role is a default role. A default role is automatically assigned to a user during registration if no roles are provided.
        """
        return pulumi.get(self, "is_default")

    @is_default.setter
    def is_default(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_default", value)

    @property
    @pulumi.getter(name="isSuperRole")
    def is_super_role(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not the Role is a considered to be a super user role. This is a marker to indicate that it supersedes all other roles. FusionAuth will attempt to enforce this contract when using the web UI, it is not enforced programmatically when using the API.
        """
        return pulumi.get(self, "is_super_role")

    @is_super_role.setter
    def is_super_role(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_super_role", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Role.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _FusionAuthApplicationRoleState:
    def __init__(__self__, *,
                 application_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 is_default: Optional[pulumi.Input[bool]] = None,
                 is_super_role: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering FusionAuthApplicationRole resources.
        :param pulumi.Input[str] application_id: ID of the application that this role is for.
        :param pulumi.Input[str] description: A description for the role.
        :param pulumi.Input[bool] is_default: Whether or not the Role is a default role. A default role is automatically assigned to a user during registration if no roles are provided.
        :param pulumi.Input[bool] is_super_role: Whether or not the Role is a considered to be a super user role. This is a marker to indicate that it supersedes all other roles. FusionAuth will attempt to enforce this contract when using the web UI, it is not enforced programmatically when using the API.
        :param pulumi.Input[str] name: The name of the Role.
        """
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if is_default is not None:
            pulumi.set(__self__, "is_default", is_default)
        if is_super_role is not None:
            pulumi.set(__self__, "is_super_role", is_super_role)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the application that this role is for.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "application_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description for the role.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not the Role is a default role. A default role is automatically assigned to a user during registration if no roles are provided.
        """
        return pulumi.get(self, "is_default")

    @is_default.setter
    def is_default(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_default", value)

    @property
    @pulumi.getter(name="isSuperRole")
    def is_super_role(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not the Role is a considered to be a super user role. This is a marker to indicate that it supersedes all other roles. FusionAuth will attempt to enforce this contract when using the web UI, it is not enforced programmatically when using the API.
        """
        return pulumi.get(self, "is_super_role")

    @is_super_role.setter
    def is_super_role(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_super_role", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Role.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


class FusionAuthApplicationRole(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 is_default: Optional[pulumi.Input[bool]] = None,
                 is_super_role: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## # Application Role Resource

        This Resource is used to create a role for an Application.

        [Application Roles API](https://fusionauth.io/docs/v1/tech/apis/applications)

        ## Example Usage

        ```python
        import pulumi
        import theogravity_pulumi-fusionauth as fusionauth

        my_app_admin_role = fusionauth.FusionAuthApplicationRole("myAppAdminRole",
            application_id=fusionauth_application["my_app"]["id"],
            description="",
            is_default=False,
            is_super_role=True)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] application_id: ID of the application that this role is for.
        :param pulumi.Input[str] description: A description for the role.
        :param pulumi.Input[bool] is_default: Whether or not the Role is a default role. A default role is automatically assigned to a user during registration if no roles are provided.
        :param pulumi.Input[bool] is_super_role: Whether or not the Role is a considered to be a super user role. This is a marker to indicate that it supersedes all other roles. FusionAuth will attempt to enforce this contract when using the web UI, it is not enforced programmatically when using the API.
        :param pulumi.Input[str] name: The name of the Role.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FusionAuthApplicationRoleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## # Application Role Resource

        This Resource is used to create a role for an Application.

        [Application Roles API](https://fusionauth.io/docs/v1/tech/apis/applications)

        ## Example Usage

        ```python
        import pulumi
        import theogravity_pulumi-fusionauth as fusionauth

        my_app_admin_role = fusionauth.FusionAuthApplicationRole("myAppAdminRole",
            application_id=fusionauth_application["my_app"]["id"],
            description="",
            is_default=False,
            is_super_role=True)
        ```

        :param str resource_name: The name of the resource.
        :param FusionAuthApplicationRoleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FusionAuthApplicationRoleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 is_default: Optional[pulumi.Input[bool]] = None,
                 is_super_role: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.plugin_download_url is None:
            opts.plugin_download_url = _utilities.get_plugin_download_url()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FusionAuthApplicationRoleArgs.__new__(FusionAuthApplicationRoleArgs)

            if application_id is None and not opts.urn:
                raise TypeError("Missing required property 'application_id'")
            __props__.__dict__["application_id"] = application_id
            __props__.__dict__["description"] = description
            __props__.__dict__["is_default"] = is_default
            __props__.__dict__["is_super_role"] = is_super_role
            __props__.__dict__["name"] = name
        super(FusionAuthApplicationRole, __self__).__init__(
            'fusionauth:index/fusionAuthApplicationRole:FusionAuthApplicationRole',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_id: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            is_default: Optional[pulumi.Input[bool]] = None,
            is_super_role: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None) -> 'FusionAuthApplicationRole':
        """
        Get an existing FusionAuthApplicationRole resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] application_id: ID of the application that this role is for.
        :param pulumi.Input[str] description: A description for the role.
        :param pulumi.Input[bool] is_default: Whether or not the Role is a default role. A default role is automatically assigned to a user during registration if no roles are provided.
        :param pulumi.Input[bool] is_super_role: Whether or not the Role is a considered to be a super user role. This is a marker to indicate that it supersedes all other roles. FusionAuth will attempt to enforce this contract when using the web UI, it is not enforced programmatically when using the API.
        :param pulumi.Input[str] name: The name of the Role.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FusionAuthApplicationRoleState.__new__(_FusionAuthApplicationRoleState)

        __props__.__dict__["application_id"] = application_id
        __props__.__dict__["description"] = description
        __props__.__dict__["is_default"] = is_default
        __props__.__dict__["is_super_role"] = is_super_role
        __props__.__dict__["name"] = name
        return FusionAuthApplicationRole(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Output[str]:
        """
        ID of the application that this role is for.
        """
        return pulumi.get(self, "application_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        A description for the role.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether or not the Role is a default role. A default role is automatically assigned to a user during registration if no roles are provided.
        """
        return pulumi.get(self, "is_default")

    @property
    @pulumi.getter(name="isSuperRole")
    def is_super_role(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether or not the Role is a considered to be a super user role. This is a marker to indicate that it supersedes all other roles. FusionAuth will attempt to enforce this contract when using the web UI, it is not enforced programmatically when using the API.
        """
        return pulumi.get(self, "is_super_role")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the Role.
        """
        return pulumi.get(self, "name")

