# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FusionAuthApplicationArgs', 'FusionAuthApplication']

@pulumi.input_type
class FusionAuthApplicationArgs:
    def __init__(__self__, *,
                 tenant_id: pulumi.Input[str],
                 access_control_configuration: Optional[pulumi.Input['FusionAuthApplicationAccessControlConfigurationArgs']] = None,
                 application_id: Optional[pulumi.Input[str]] = None,
                 authentication_token_configuration_enabled: Optional[pulumi.Input[bool]] = None,
                 clean_speak_configuration: Optional[pulumi.Input['FusionAuthApplicationCleanSpeakConfigurationArgs']] = None,
                 data: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 email_configuration: Optional[pulumi.Input['FusionAuthApplicationEmailConfigurationArgs']] = None,
                 form_configuration: Optional[pulumi.Input['FusionAuthApplicationFormConfigurationArgs']] = None,
                 jwt_configuration: Optional[pulumi.Input['FusionAuthApplicationJwtConfigurationArgs']] = None,
                 lambda_configuration: Optional[pulumi.Input['FusionAuthApplicationLambdaConfigurationArgs']] = None,
                 login_configuration: Optional[pulumi.Input['FusionAuthApplicationLoginConfigurationArgs']] = None,
                 multi_factor_configuration: Optional[pulumi.Input['FusionAuthApplicationMultiFactorConfigurationArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 oauth_configuration: Optional[pulumi.Input['FusionAuthApplicationOauthConfigurationArgs']] = None,
                 passwordless_configuration_enabled: Optional[pulumi.Input[bool]] = None,
                 registration_configuration: Optional[pulumi.Input['FusionAuthApplicationRegistrationConfigurationArgs']] = None,
                 registration_delete_policy: Optional[pulumi.Input['FusionAuthApplicationRegistrationDeletePolicyArgs']] = None,
                 samlv2_configuration: Optional[pulumi.Input['FusionAuthApplicationSamlv2ConfigurationArgs']] = None,
                 theme_id: Optional[pulumi.Input[str]] = None,
                 verification_email_template_id: Optional[pulumi.Input[str]] = None,
                 verify_registration: Optional[pulumi.Input[bool]] = None,
                 webhook_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a FusionAuthApplication resource.
        :param pulumi.Input[str] application_id: The Id of the CleanSpeak application that usernames are sent to for moderation.
        :param pulumi.Input[bool] authentication_token_configuration_enabled: Determines if Users can have Authentication Tokens associated with this Application. This feature may not be enabled for the FusionAuth application.
        :param pulumi.Input[Mapping[str, Any]] data: An object that can hold any information about the Application that should be persisted.
        :param pulumi.Input[str] name: The name of the Application.
        :param pulumi.Input[bool] passwordless_configuration_enabled: Determines if passwordless login is enabled for this application.
        :param pulumi.Input[str] theme_id: The unique Id of the theme to be used to style the login page and other end user templates.
        :param pulumi.Input[str] verification_email_template_id: The Id of the Email Template that is used to send the Registration Verification emails to users. If the verifyRegistration field is true this field is required.
        :param pulumi.Input[bool] verify_registration: Whether or not registrations to this Application may be verified. When this is set to true the verificationEmailTemplateId parameter is also required.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] webhook_ids: An array of Webhook Ids. For Webhooks that are not already configured for All Applications, specifying an Id on this request will indicate the associated Webhook should handle events for this application.
        """
        pulumi.set(__self__, "tenant_id", tenant_id)
        if access_control_configuration is not None:
            pulumi.set(__self__, "access_control_configuration", access_control_configuration)
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if authentication_token_configuration_enabled is not None:
            pulumi.set(__self__, "authentication_token_configuration_enabled", authentication_token_configuration_enabled)
        if clean_speak_configuration is not None:
            pulumi.set(__self__, "clean_speak_configuration", clean_speak_configuration)
        if data is not None:
            pulumi.set(__self__, "data", data)
        if email_configuration is not None:
            pulumi.set(__self__, "email_configuration", email_configuration)
        if form_configuration is not None:
            pulumi.set(__self__, "form_configuration", form_configuration)
        if jwt_configuration is not None:
            pulumi.set(__self__, "jwt_configuration", jwt_configuration)
        if lambda_configuration is not None:
            pulumi.set(__self__, "lambda_configuration", lambda_configuration)
        if login_configuration is not None:
            pulumi.set(__self__, "login_configuration", login_configuration)
        if multi_factor_configuration is not None:
            pulumi.set(__self__, "multi_factor_configuration", multi_factor_configuration)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if oauth_configuration is not None:
            pulumi.set(__self__, "oauth_configuration", oauth_configuration)
        if passwordless_configuration_enabled is not None:
            pulumi.set(__self__, "passwordless_configuration_enabled", passwordless_configuration_enabled)
        if registration_configuration is not None:
            pulumi.set(__self__, "registration_configuration", registration_configuration)
        if registration_delete_policy is not None:
            pulumi.set(__self__, "registration_delete_policy", registration_delete_policy)
        if samlv2_configuration is not None:
            pulumi.set(__self__, "samlv2_configuration", samlv2_configuration)
        if theme_id is not None:
            pulumi.set(__self__, "theme_id", theme_id)
        if verification_email_template_id is not None:
            pulumi.set(__self__, "verification_email_template_id", verification_email_template_id)
        if verify_registration is not None:
            pulumi.set(__self__, "verify_registration", verify_registration)
        if webhook_ids is not None:
            pulumi.set(__self__, "webhook_ids", webhook_ids)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="accessControlConfiguration")
    def access_control_configuration(self) -> Optional[pulumi.Input['FusionAuthApplicationAccessControlConfigurationArgs']]:
        return pulumi.get(self, "access_control_configuration")

    @access_control_configuration.setter
    def access_control_configuration(self, value: Optional[pulumi.Input['FusionAuthApplicationAccessControlConfigurationArgs']]):
        pulumi.set(self, "access_control_configuration", value)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Id of the CleanSpeak application that usernames are sent to for moderation.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "application_id", value)

    @property
    @pulumi.getter(name="authenticationTokenConfigurationEnabled")
    def authentication_token_configuration_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines if Users can have Authentication Tokens associated with this Application. This feature may not be enabled for the FusionAuth application.
        """
        return pulumi.get(self, "authentication_token_configuration_enabled")

    @authentication_token_configuration_enabled.setter
    def authentication_token_configuration_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "authentication_token_configuration_enabled", value)

    @property
    @pulumi.getter(name="cleanSpeakConfiguration")
    def clean_speak_configuration(self) -> Optional[pulumi.Input['FusionAuthApplicationCleanSpeakConfigurationArgs']]:
        return pulumi.get(self, "clean_speak_configuration")

    @clean_speak_configuration.setter
    def clean_speak_configuration(self, value: Optional[pulumi.Input['FusionAuthApplicationCleanSpeakConfigurationArgs']]):
        pulumi.set(self, "clean_speak_configuration", value)

    @property
    @pulumi.getter
    def data(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        An object that can hold any information about the Application that should be persisted.
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "data", value)

    @property
    @pulumi.getter(name="emailConfiguration")
    def email_configuration(self) -> Optional[pulumi.Input['FusionAuthApplicationEmailConfigurationArgs']]:
        return pulumi.get(self, "email_configuration")

    @email_configuration.setter
    def email_configuration(self, value: Optional[pulumi.Input['FusionAuthApplicationEmailConfigurationArgs']]):
        pulumi.set(self, "email_configuration", value)

    @property
    @pulumi.getter(name="formConfiguration")
    def form_configuration(self) -> Optional[pulumi.Input['FusionAuthApplicationFormConfigurationArgs']]:
        return pulumi.get(self, "form_configuration")

    @form_configuration.setter
    def form_configuration(self, value: Optional[pulumi.Input['FusionAuthApplicationFormConfigurationArgs']]):
        pulumi.set(self, "form_configuration", value)

    @property
    @pulumi.getter(name="jwtConfiguration")
    def jwt_configuration(self) -> Optional[pulumi.Input['FusionAuthApplicationJwtConfigurationArgs']]:
        return pulumi.get(self, "jwt_configuration")

    @jwt_configuration.setter
    def jwt_configuration(self, value: Optional[pulumi.Input['FusionAuthApplicationJwtConfigurationArgs']]):
        pulumi.set(self, "jwt_configuration", value)

    @property
    @pulumi.getter(name="lambdaConfiguration")
    def lambda_configuration(self) -> Optional[pulumi.Input['FusionAuthApplicationLambdaConfigurationArgs']]:
        return pulumi.get(self, "lambda_configuration")

    @lambda_configuration.setter
    def lambda_configuration(self, value: Optional[pulumi.Input['FusionAuthApplicationLambdaConfigurationArgs']]):
        pulumi.set(self, "lambda_configuration", value)

    @property
    @pulumi.getter(name="loginConfiguration")
    def login_configuration(self) -> Optional[pulumi.Input['FusionAuthApplicationLoginConfigurationArgs']]:
        return pulumi.get(self, "login_configuration")

    @login_configuration.setter
    def login_configuration(self, value: Optional[pulumi.Input['FusionAuthApplicationLoginConfigurationArgs']]):
        pulumi.set(self, "login_configuration", value)

    @property
    @pulumi.getter(name="multiFactorConfiguration")
    def multi_factor_configuration(self) -> Optional[pulumi.Input['FusionAuthApplicationMultiFactorConfigurationArgs']]:
        return pulumi.get(self, "multi_factor_configuration")

    @multi_factor_configuration.setter
    def multi_factor_configuration(self, value: Optional[pulumi.Input['FusionAuthApplicationMultiFactorConfigurationArgs']]):
        pulumi.set(self, "multi_factor_configuration", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Application.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="oauthConfiguration")
    def oauth_configuration(self) -> Optional[pulumi.Input['FusionAuthApplicationOauthConfigurationArgs']]:
        return pulumi.get(self, "oauth_configuration")

    @oauth_configuration.setter
    def oauth_configuration(self, value: Optional[pulumi.Input['FusionAuthApplicationOauthConfigurationArgs']]):
        pulumi.set(self, "oauth_configuration", value)

    @property
    @pulumi.getter(name="passwordlessConfigurationEnabled")
    def passwordless_configuration_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines if passwordless login is enabled for this application.
        """
        return pulumi.get(self, "passwordless_configuration_enabled")

    @passwordless_configuration_enabled.setter
    def passwordless_configuration_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "passwordless_configuration_enabled", value)

    @property
    @pulumi.getter(name="registrationConfiguration")
    def registration_configuration(self) -> Optional[pulumi.Input['FusionAuthApplicationRegistrationConfigurationArgs']]:
        return pulumi.get(self, "registration_configuration")

    @registration_configuration.setter
    def registration_configuration(self, value: Optional[pulumi.Input['FusionAuthApplicationRegistrationConfigurationArgs']]):
        pulumi.set(self, "registration_configuration", value)

    @property
    @pulumi.getter(name="registrationDeletePolicy")
    def registration_delete_policy(self) -> Optional[pulumi.Input['FusionAuthApplicationRegistrationDeletePolicyArgs']]:
        return pulumi.get(self, "registration_delete_policy")

    @registration_delete_policy.setter
    def registration_delete_policy(self, value: Optional[pulumi.Input['FusionAuthApplicationRegistrationDeletePolicyArgs']]):
        pulumi.set(self, "registration_delete_policy", value)

    @property
    @pulumi.getter(name="samlv2Configuration")
    def samlv2_configuration(self) -> Optional[pulumi.Input['FusionAuthApplicationSamlv2ConfigurationArgs']]:
        return pulumi.get(self, "samlv2_configuration")

    @samlv2_configuration.setter
    def samlv2_configuration(self, value: Optional[pulumi.Input['FusionAuthApplicationSamlv2ConfigurationArgs']]):
        pulumi.set(self, "samlv2_configuration", value)

    @property
    @pulumi.getter(name="themeId")
    def theme_id(self) -> Optional[pulumi.Input[str]]:
        """
        The unique Id of the theme to be used to style the login page and other end user templates.
        """
        return pulumi.get(self, "theme_id")

    @theme_id.setter
    def theme_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "theme_id", value)

    @property
    @pulumi.getter(name="verificationEmailTemplateId")
    def verification_email_template_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Id of the Email Template that is used to send the Registration Verification emails to users. If the verifyRegistration field is true this field is required.
        """
        return pulumi.get(self, "verification_email_template_id")

    @verification_email_template_id.setter
    def verification_email_template_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "verification_email_template_id", value)

    @property
    @pulumi.getter(name="verifyRegistration")
    def verify_registration(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not registrations to this Application may be verified. When this is set to true the verificationEmailTemplateId parameter is also required.
        """
        return pulumi.get(self, "verify_registration")

    @verify_registration.setter
    def verify_registration(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "verify_registration", value)

    @property
    @pulumi.getter(name="webhookIds")
    def webhook_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An array of Webhook Ids. For Webhooks that are not already configured for All Applications, specifying an Id on this request will indicate the associated Webhook should handle events for this application.
        """
        return pulumi.get(self, "webhook_ids")

    @webhook_ids.setter
    def webhook_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "webhook_ids", value)


@pulumi.input_type
class _FusionAuthApplicationState:
    def __init__(__self__, *,
                 access_control_configuration: Optional[pulumi.Input['FusionAuthApplicationAccessControlConfigurationArgs']] = None,
                 application_id: Optional[pulumi.Input[str]] = None,
                 authentication_token_configuration_enabled: Optional[pulumi.Input[bool]] = None,
                 clean_speak_configuration: Optional[pulumi.Input['FusionAuthApplicationCleanSpeakConfigurationArgs']] = None,
                 data: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 email_configuration: Optional[pulumi.Input['FusionAuthApplicationEmailConfigurationArgs']] = None,
                 form_configuration: Optional[pulumi.Input['FusionAuthApplicationFormConfigurationArgs']] = None,
                 jwt_configuration: Optional[pulumi.Input['FusionAuthApplicationJwtConfigurationArgs']] = None,
                 lambda_configuration: Optional[pulumi.Input['FusionAuthApplicationLambdaConfigurationArgs']] = None,
                 login_configuration: Optional[pulumi.Input['FusionAuthApplicationLoginConfigurationArgs']] = None,
                 multi_factor_configuration: Optional[pulumi.Input['FusionAuthApplicationMultiFactorConfigurationArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 oauth_configuration: Optional[pulumi.Input['FusionAuthApplicationOauthConfigurationArgs']] = None,
                 passwordless_configuration_enabled: Optional[pulumi.Input[bool]] = None,
                 registration_configuration: Optional[pulumi.Input['FusionAuthApplicationRegistrationConfigurationArgs']] = None,
                 registration_delete_policy: Optional[pulumi.Input['FusionAuthApplicationRegistrationDeletePolicyArgs']] = None,
                 samlv2_configuration: Optional[pulumi.Input['FusionAuthApplicationSamlv2ConfigurationArgs']] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 theme_id: Optional[pulumi.Input[str]] = None,
                 verification_email_template_id: Optional[pulumi.Input[str]] = None,
                 verify_registration: Optional[pulumi.Input[bool]] = None,
                 webhook_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering FusionAuthApplication resources.
        :param pulumi.Input[str] application_id: The Id of the CleanSpeak application that usernames are sent to for moderation.
        :param pulumi.Input[bool] authentication_token_configuration_enabled: Determines if Users can have Authentication Tokens associated with this Application. This feature may not be enabled for the FusionAuth application.
        :param pulumi.Input[Mapping[str, Any]] data: An object that can hold any information about the Application that should be persisted.
        :param pulumi.Input[str] name: The name of the Application.
        :param pulumi.Input[bool] passwordless_configuration_enabled: Determines if passwordless login is enabled for this application.
        :param pulumi.Input[str] theme_id: The unique Id of the theme to be used to style the login page and other end user templates.
        :param pulumi.Input[str] verification_email_template_id: The Id of the Email Template that is used to send the Registration Verification emails to users. If the verifyRegistration field is true this field is required.
        :param pulumi.Input[bool] verify_registration: Whether or not registrations to this Application may be verified. When this is set to true the verificationEmailTemplateId parameter is also required.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] webhook_ids: An array of Webhook Ids. For Webhooks that are not already configured for All Applications, specifying an Id on this request will indicate the associated Webhook should handle events for this application.
        """
        if access_control_configuration is not None:
            pulumi.set(__self__, "access_control_configuration", access_control_configuration)
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if authentication_token_configuration_enabled is not None:
            pulumi.set(__self__, "authentication_token_configuration_enabled", authentication_token_configuration_enabled)
        if clean_speak_configuration is not None:
            pulumi.set(__self__, "clean_speak_configuration", clean_speak_configuration)
        if data is not None:
            pulumi.set(__self__, "data", data)
        if email_configuration is not None:
            pulumi.set(__self__, "email_configuration", email_configuration)
        if form_configuration is not None:
            pulumi.set(__self__, "form_configuration", form_configuration)
        if jwt_configuration is not None:
            pulumi.set(__self__, "jwt_configuration", jwt_configuration)
        if lambda_configuration is not None:
            pulumi.set(__self__, "lambda_configuration", lambda_configuration)
        if login_configuration is not None:
            pulumi.set(__self__, "login_configuration", login_configuration)
        if multi_factor_configuration is not None:
            pulumi.set(__self__, "multi_factor_configuration", multi_factor_configuration)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if oauth_configuration is not None:
            pulumi.set(__self__, "oauth_configuration", oauth_configuration)
        if passwordless_configuration_enabled is not None:
            pulumi.set(__self__, "passwordless_configuration_enabled", passwordless_configuration_enabled)
        if registration_configuration is not None:
            pulumi.set(__self__, "registration_configuration", registration_configuration)
        if registration_delete_policy is not None:
            pulumi.set(__self__, "registration_delete_policy", registration_delete_policy)
        if samlv2_configuration is not None:
            pulumi.set(__self__, "samlv2_configuration", samlv2_configuration)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if theme_id is not None:
            pulumi.set(__self__, "theme_id", theme_id)
        if verification_email_template_id is not None:
            pulumi.set(__self__, "verification_email_template_id", verification_email_template_id)
        if verify_registration is not None:
            pulumi.set(__self__, "verify_registration", verify_registration)
        if webhook_ids is not None:
            pulumi.set(__self__, "webhook_ids", webhook_ids)

    @property
    @pulumi.getter(name="accessControlConfiguration")
    def access_control_configuration(self) -> Optional[pulumi.Input['FusionAuthApplicationAccessControlConfigurationArgs']]:
        return pulumi.get(self, "access_control_configuration")

    @access_control_configuration.setter
    def access_control_configuration(self, value: Optional[pulumi.Input['FusionAuthApplicationAccessControlConfigurationArgs']]):
        pulumi.set(self, "access_control_configuration", value)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Id of the CleanSpeak application that usernames are sent to for moderation.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "application_id", value)

    @property
    @pulumi.getter(name="authenticationTokenConfigurationEnabled")
    def authentication_token_configuration_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines if Users can have Authentication Tokens associated with this Application. This feature may not be enabled for the FusionAuth application.
        """
        return pulumi.get(self, "authentication_token_configuration_enabled")

    @authentication_token_configuration_enabled.setter
    def authentication_token_configuration_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "authentication_token_configuration_enabled", value)

    @property
    @pulumi.getter(name="cleanSpeakConfiguration")
    def clean_speak_configuration(self) -> Optional[pulumi.Input['FusionAuthApplicationCleanSpeakConfigurationArgs']]:
        return pulumi.get(self, "clean_speak_configuration")

    @clean_speak_configuration.setter
    def clean_speak_configuration(self, value: Optional[pulumi.Input['FusionAuthApplicationCleanSpeakConfigurationArgs']]):
        pulumi.set(self, "clean_speak_configuration", value)

    @property
    @pulumi.getter
    def data(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        An object that can hold any information about the Application that should be persisted.
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "data", value)

    @property
    @pulumi.getter(name="emailConfiguration")
    def email_configuration(self) -> Optional[pulumi.Input['FusionAuthApplicationEmailConfigurationArgs']]:
        return pulumi.get(self, "email_configuration")

    @email_configuration.setter
    def email_configuration(self, value: Optional[pulumi.Input['FusionAuthApplicationEmailConfigurationArgs']]):
        pulumi.set(self, "email_configuration", value)

    @property
    @pulumi.getter(name="formConfiguration")
    def form_configuration(self) -> Optional[pulumi.Input['FusionAuthApplicationFormConfigurationArgs']]:
        return pulumi.get(self, "form_configuration")

    @form_configuration.setter
    def form_configuration(self, value: Optional[pulumi.Input['FusionAuthApplicationFormConfigurationArgs']]):
        pulumi.set(self, "form_configuration", value)

    @property
    @pulumi.getter(name="jwtConfiguration")
    def jwt_configuration(self) -> Optional[pulumi.Input['FusionAuthApplicationJwtConfigurationArgs']]:
        return pulumi.get(self, "jwt_configuration")

    @jwt_configuration.setter
    def jwt_configuration(self, value: Optional[pulumi.Input['FusionAuthApplicationJwtConfigurationArgs']]):
        pulumi.set(self, "jwt_configuration", value)

    @property
    @pulumi.getter(name="lambdaConfiguration")
    def lambda_configuration(self) -> Optional[pulumi.Input['FusionAuthApplicationLambdaConfigurationArgs']]:
        return pulumi.get(self, "lambda_configuration")

    @lambda_configuration.setter
    def lambda_configuration(self, value: Optional[pulumi.Input['FusionAuthApplicationLambdaConfigurationArgs']]):
        pulumi.set(self, "lambda_configuration", value)

    @property
    @pulumi.getter(name="loginConfiguration")
    def login_configuration(self) -> Optional[pulumi.Input['FusionAuthApplicationLoginConfigurationArgs']]:
        return pulumi.get(self, "login_configuration")

    @login_configuration.setter
    def login_configuration(self, value: Optional[pulumi.Input['FusionAuthApplicationLoginConfigurationArgs']]):
        pulumi.set(self, "login_configuration", value)

    @property
    @pulumi.getter(name="multiFactorConfiguration")
    def multi_factor_configuration(self) -> Optional[pulumi.Input['FusionAuthApplicationMultiFactorConfigurationArgs']]:
        return pulumi.get(self, "multi_factor_configuration")

    @multi_factor_configuration.setter
    def multi_factor_configuration(self, value: Optional[pulumi.Input['FusionAuthApplicationMultiFactorConfigurationArgs']]):
        pulumi.set(self, "multi_factor_configuration", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Application.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="oauthConfiguration")
    def oauth_configuration(self) -> Optional[pulumi.Input['FusionAuthApplicationOauthConfigurationArgs']]:
        return pulumi.get(self, "oauth_configuration")

    @oauth_configuration.setter
    def oauth_configuration(self, value: Optional[pulumi.Input['FusionAuthApplicationOauthConfigurationArgs']]):
        pulumi.set(self, "oauth_configuration", value)

    @property
    @pulumi.getter(name="passwordlessConfigurationEnabled")
    def passwordless_configuration_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines if passwordless login is enabled for this application.
        """
        return pulumi.get(self, "passwordless_configuration_enabled")

    @passwordless_configuration_enabled.setter
    def passwordless_configuration_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "passwordless_configuration_enabled", value)

    @property
    @pulumi.getter(name="registrationConfiguration")
    def registration_configuration(self) -> Optional[pulumi.Input['FusionAuthApplicationRegistrationConfigurationArgs']]:
        return pulumi.get(self, "registration_configuration")

    @registration_configuration.setter
    def registration_configuration(self, value: Optional[pulumi.Input['FusionAuthApplicationRegistrationConfigurationArgs']]):
        pulumi.set(self, "registration_configuration", value)

    @property
    @pulumi.getter(name="registrationDeletePolicy")
    def registration_delete_policy(self) -> Optional[pulumi.Input['FusionAuthApplicationRegistrationDeletePolicyArgs']]:
        return pulumi.get(self, "registration_delete_policy")

    @registration_delete_policy.setter
    def registration_delete_policy(self, value: Optional[pulumi.Input['FusionAuthApplicationRegistrationDeletePolicyArgs']]):
        pulumi.set(self, "registration_delete_policy", value)

    @property
    @pulumi.getter(name="samlv2Configuration")
    def samlv2_configuration(self) -> Optional[pulumi.Input['FusionAuthApplicationSamlv2ConfigurationArgs']]:
        return pulumi.get(self, "samlv2_configuration")

    @samlv2_configuration.setter
    def samlv2_configuration(self, value: Optional[pulumi.Input['FusionAuthApplicationSamlv2ConfigurationArgs']]):
        pulumi.set(self, "samlv2_configuration", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="themeId")
    def theme_id(self) -> Optional[pulumi.Input[str]]:
        """
        The unique Id of the theme to be used to style the login page and other end user templates.
        """
        return pulumi.get(self, "theme_id")

    @theme_id.setter
    def theme_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "theme_id", value)

    @property
    @pulumi.getter(name="verificationEmailTemplateId")
    def verification_email_template_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Id of the Email Template that is used to send the Registration Verification emails to users. If the verifyRegistration field is true this field is required.
        """
        return pulumi.get(self, "verification_email_template_id")

    @verification_email_template_id.setter
    def verification_email_template_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "verification_email_template_id", value)

    @property
    @pulumi.getter(name="verifyRegistration")
    def verify_registration(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not registrations to this Application may be verified. When this is set to true the verificationEmailTemplateId parameter is also required.
        """
        return pulumi.get(self, "verify_registration")

    @verify_registration.setter
    def verify_registration(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "verify_registration", value)

    @property
    @pulumi.getter(name="webhookIds")
    def webhook_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An array of Webhook Ids. For Webhooks that are not already configured for All Applications, specifying an Id on this request will indicate the associated Webhook should handle events for this application.
        """
        return pulumi.get(self, "webhook_ids")

    @webhook_ids.setter
    def webhook_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "webhook_ids", value)


class FusionAuthApplication(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_control_configuration: Optional[pulumi.Input[pulumi.InputType['FusionAuthApplicationAccessControlConfigurationArgs']]] = None,
                 application_id: Optional[pulumi.Input[str]] = None,
                 authentication_token_configuration_enabled: Optional[pulumi.Input[bool]] = None,
                 clean_speak_configuration: Optional[pulumi.Input[pulumi.InputType['FusionAuthApplicationCleanSpeakConfigurationArgs']]] = None,
                 data: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 email_configuration: Optional[pulumi.Input[pulumi.InputType['FusionAuthApplicationEmailConfigurationArgs']]] = None,
                 form_configuration: Optional[pulumi.Input[pulumi.InputType['FusionAuthApplicationFormConfigurationArgs']]] = None,
                 jwt_configuration: Optional[pulumi.Input[pulumi.InputType['FusionAuthApplicationJwtConfigurationArgs']]] = None,
                 lambda_configuration: Optional[pulumi.Input[pulumi.InputType['FusionAuthApplicationLambdaConfigurationArgs']]] = None,
                 login_configuration: Optional[pulumi.Input[pulumi.InputType['FusionAuthApplicationLoginConfigurationArgs']]] = None,
                 multi_factor_configuration: Optional[pulumi.Input[pulumi.InputType['FusionAuthApplicationMultiFactorConfigurationArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 oauth_configuration: Optional[pulumi.Input[pulumi.InputType['FusionAuthApplicationOauthConfigurationArgs']]] = None,
                 passwordless_configuration_enabled: Optional[pulumi.Input[bool]] = None,
                 registration_configuration: Optional[pulumi.Input[pulumi.InputType['FusionAuthApplicationRegistrationConfigurationArgs']]] = None,
                 registration_delete_policy: Optional[pulumi.Input[pulumi.InputType['FusionAuthApplicationRegistrationDeletePolicyArgs']]] = None,
                 samlv2_configuration: Optional[pulumi.Input[pulumi.InputType['FusionAuthApplicationSamlv2ConfigurationArgs']]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 theme_id: Optional[pulumi.Input[str]] = None,
                 verification_email_template_id: Optional[pulumi.Input[str]] = None,
                 verify_registration: Optional[pulumi.Input[bool]] = None,
                 webhook_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        ## # Application Resource

        [Applications API](https://fusionauth.io/docs/v1/tech/apis/applications)

        ## Example Usage

        ```python
        import pulumi
        import theogravity_pulumi-fusionauth as fusionauth

        forum = fusionauth.FusionAuthApplication("forum",
            tenant_id=fusionauth_tenant["portal"]["id"],
            authentication_token_configuration_enabled=False,
            form_configuration=fusionauth.FusionAuthApplicationFormConfigurationArgs(
                admin_registration_form_id=fusionauth_form["admin_registration"]["id"],
                self_service_form_id=fusionauth_form["self_service"]["id"],
            ),
            jwt_configuration=fusionauth.FusionAuthApplicationJwtConfigurationArgs(
                access_token_id=fusionauth_key["access_token"]["id"],
                enabled=True,
                id_token_key_id=fusionauth_key["id_token"]["id"],
                refresh_token_ttl_minutes=43200,
                ttl_seconds=3600,
            ),
            lambda_configuration=fusionauth.FusionAuthApplicationLambdaConfigurationArgs(
                access_token_populate_id=fusionauth_lambda["token_populate"]["id"],
                id_token_populate_id=fusionauth_lambda["id_token_populate"]["id"],
            ),
            login_configuration=fusionauth.FusionAuthApplicationLoginConfigurationArgs(
                allow_token_refresh=False,
                generate_refresh_tokens=False,
                require_authentication=True,
            ),
            oauth_configuration=fusionauth.FusionAuthApplicationOauthConfigurationArgs(
                authorized_origin_urls=["http://www.example.com/oauth-callback"],
                enabled_grants=[
                    "authorization_code",
                    "implicit",
                ],
                generate_refresh_tokens=False,
                logout_behavior="AllApplications",
                logout_url="http://www.example.com/logout",
                require_client_authentication=False,
            ),
            registration_configuration=fusionauth.FusionAuthApplicationRegistrationConfigurationArgs(
                birth_date=fusionauth.FusionAuthApplicationRegistrationConfigurationBirthDateArgs(
                    enabled=False,
                    required=False,
                ),
                confirm_password=False,
                enabled=False,
                first_name=fusionauth.FusionAuthApplicationRegistrationConfigurationFirstNameArgs(
                    enabled=False,
                    required=False,
                ),
                full_name=fusionauth.FusionAuthApplicationRegistrationConfigurationFullNameArgs(
                    enabled=False,
                    required=False,
                ),
                last_name=fusionauth.FusionAuthApplicationRegistrationConfigurationLastNameArgs(
                    enabled=False,
                    required=False,
                ),
                login_id_type="",
                middle_name=fusionauth.FusionAuthApplicationRegistrationConfigurationMiddleNameArgs(
                    enabled=False,
                    required=False,
                ),
                mobile_phone=fusionauth.FusionAuthApplicationRegistrationConfigurationMobilePhoneArgs(
                    enabled=False,
                    required=False,
                ),
                type="",
            ),
            passwordless_configuration_enabled=False,
            registration_delete_policy=fusionauth.FusionAuthApplicationRegistrationDeletePolicyArgs(
                unverified_enabled=True,
                unverified_number_of_days_to_retain=30,
            ))
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] application_id: The Id of the CleanSpeak application that usernames are sent to for moderation.
        :param pulumi.Input[bool] authentication_token_configuration_enabled: Determines if Users can have Authentication Tokens associated with this Application. This feature may not be enabled for the FusionAuth application.
        :param pulumi.Input[Mapping[str, Any]] data: An object that can hold any information about the Application that should be persisted.
        :param pulumi.Input[str] name: The name of the Application.
        :param pulumi.Input[bool] passwordless_configuration_enabled: Determines if passwordless login is enabled for this application.
        :param pulumi.Input[str] theme_id: The unique Id of the theme to be used to style the login page and other end user templates.
        :param pulumi.Input[str] verification_email_template_id: The Id of the Email Template that is used to send the Registration Verification emails to users. If the verifyRegistration field is true this field is required.
        :param pulumi.Input[bool] verify_registration: Whether or not registrations to this Application may be verified. When this is set to true the verificationEmailTemplateId parameter is also required.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] webhook_ids: An array of Webhook Ids. For Webhooks that are not already configured for All Applications, specifying an Id on this request will indicate the associated Webhook should handle events for this application.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FusionAuthApplicationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## # Application Resource

        [Applications API](https://fusionauth.io/docs/v1/tech/apis/applications)

        ## Example Usage

        ```python
        import pulumi
        import theogravity_pulumi-fusionauth as fusionauth

        forum = fusionauth.FusionAuthApplication("forum",
            tenant_id=fusionauth_tenant["portal"]["id"],
            authentication_token_configuration_enabled=False,
            form_configuration=fusionauth.FusionAuthApplicationFormConfigurationArgs(
                admin_registration_form_id=fusionauth_form["admin_registration"]["id"],
                self_service_form_id=fusionauth_form["self_service"]["id"],
            ),
            jwt_configuration=fusionauth.FusionAuthApplicationJwtConfigurationArgs(
                access_token_id=fusionauth_key["access_token"]["id"],
                enabled=True,
                id_token_key_id=fusionauth_key["id_token"]["id"],
                refresh_token_ttl_minutes=43200,
                ttl_seconds=3600,
            ),
            lambda_configuration=fusionauth.FusionAuthApplicationLambdaConfigurationArgs(
                access_token_populate_id=fusionauth_lambda["token_populate"]["id"],
                id_token_populate_id=fusionauth_lambda["id_token_populate"]["id"],
            ),
            login_configuration=fusionauth.FusionAuthApplicationLoginConfigurationArgs(
                allow_token_refresh=False,
                generate_refresh_tokens=False,
                require_authentication=True,
            ),
            oauth_configuration=fusionauth.FusionAuthApplicationOauthConfigurationArgs(
                authorized_origin_urls=["http://www.example.com/oauth-callback"],
                enabled_grants=[
                    "authorization_code",
                    "implicit",
                ],
                generate_refresh_tokens=False,
                logout_behavior="AllApplications",
                logout_url="http://www.example.com/logout",
                require_client_authentication=False,
            ),
            registration_configuration=fusionauth.FusionAuthApplicationRegistrationConfigurationArgs(
                birth_date=fusionauth.FusionAuthApplicationRegistrationConfigurationBirthDateArgs(
                    enabled=False,
                    required=False,
                ),
                confirm_password=False,
                enabled=False,
                first_name=fusionauth.FusionAuthApplicationRegistrationConfigurationFirstNameArgs(
                    enabled=False,
                    required=False,
                ),
                full_name=fusionauth.FusionAuthApplicationRegistrationConfigurationFullNameArgs(
                    enabled=False,
                    required=False,
                ),
                last_name=fusionauth.FusionAuthApplicationRegistrationConfigurationLastNameArgs(
                    enabled=False,
                    required=False,
                ),
                login_id_type="",
                middle_name=fusionauth.FusionAuthApplicationRegistrationConfigurationMiddleNameArgs(
                    enabled=False,
                    required=False,
                ),
                mobile_phone=fusionauth.FusionAuthApplicationRegistrationConfigurationMobilePhoneArgs(
                    enabled=False,
                    required=False,
                ),
                type="",
            ),
            passwordless_configuration_enabled=False,
            registration_delete_policy=fusionauth.FusionAuthApplicationRegistrationDeletePolicyArgs(
                unverified_enabled=True,
                unverified_number_of_days_to_retain=30,
            ))
        ```

        :param str resource_name: The name of the resource.
        :param FusionAuthApplicationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FusionAuthApplicationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_control_configuration: Optional[pulumi.Input[pulumi.InputType['FusionAuthApplicationAccessControlConfigurationArgs']]] = None,
                 application_id: Optional[pulumi.Input[str]] = None,
                 authentication_token_configuration_enabled: Optional[pulumi.Input[bool]] = None,
                 clean_speak_configuration: Optional[pulumi.Input[pulumi.InputType['FusionAuthApplicationCleanSpeakConfigurationArgs']]] = None,
                 data: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 email_configuration: Optional[pulumi.Input[pulumi.InputType['FusionAuthApplicationEmailConfigurationArgs']]] = None,
                 form_configuration: Optional[pulumi.Input[pulumi.InputType['FusionAuthApplicationFormConfigurationArgs']]] = None,
                 jwt_configuration: Optional[pulumi.Input[pulumi.InputType['FusionAuthApplicationJwtConfigurationArgs']]] = None,
                 lambda_configuration: Optional[pulumi.Input[pulumi.InputType['FusionAuthApplicationLambdaConfigurationArgs']]] = None,
                 login_configuration: Optional[pulumi.Input[pulumi.InputType['FusionAuthApplicationLoginConfigurationArgs']]] = None,
                 multi_factor_configuration: Optional[pulumi.Input[pulumi.InputType['FusionAuthApplicationMultiFactorConfigurationArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 oauth_configuration: Optional[pulumi.Input[pulumi.InputType['FusionAuthApplicationOauthConfigurationArgs']]] = None,
                 passwordless_configuration_enabled: Optional[pulumi.Input[bool]] = None,
                 registration_configuration: Optional[pulumi.Input[pulumi.InputType['FusionAuthApplicationRegistrationConfigurationArgs']]] = None,
                 registration_delete_policy: Optional[pulumi.Input[pulumi.InputType['FusionAuthApplicationRegistrationDeletePolicyArgs']]] = None,
                 samlv2_configuration: Optional[pulumi.Input[pulumi.InputType['FusionAuthApplicationSamlv2ConfigurationArgs']]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 theme_id: Optional[pulumi.Input[str]] = None,
                 verification_email_template_id: Optional[pulumi.Input[str]] = None,
                 verify_registration: Optional[pulumi.Input[bool]] = None,
                 webhook_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.plugin_download_url is None:
            opts.plugin_download_url = _utilities.get_plugin_download_url()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FusionAuthApplicationArgs.__new__(FusionAuthApplicationArgs)

            __props__.__dict__["access_control_configuration"] = access_control_configuration
            __props__.__dict__["application_id"] = application_id
            __props__.__dict__["authentication_token_configuration_enabled"] = authentication_token_configuration_enabled
            __props__.__dict__["clean_speak_configuration"] = clean_speak_configuration
            __props__.__dict__["data"] = data
            __props__.__dict__["email_configuration"] = email_configuration
            __props__.__dict__["form_configuration"] = form_configuration
            __props__.__dict__["jwt_configuration"] = jwt_configuration
            __props__.__dict__["lambda_configuration"] = lambda_configuration
            __props__.__dict__["login_configuration"] = login_configuration
            __props__.__dict__["multi_factor_configuration"] = multi_factor_configuration
            __props__.__dict__["name"] = name
            __props__.__dict__["oauth_configuration"] = oauth_configuration
            __props__.__dict__["passwordless_configuration_enabled"] = passwordless_configuration_enabled
            __props__.__dict__["registration_configuration"] = registration_configuration
            __props__.__dict__["registration_delete_policy"] = registration_delete_policy
            __props__.__dict__["samlv2_configuration"] = samlv2_configuration
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["theme_id"] = theme_id
            __props__.__dict__["verification_email_template_id"] = verification_email_template_id
            __props__.__dict__["verify_registration"] = verify_registration
            __props__.__dict__["webhook_ids"] = webhook_ids
        super(FusionAuthApplication, __self__).__init__(
            'fusionauth:index/fusionAuthApplication:FusionAuthApplication',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_control_configuration: Optional[pulumi.Input[pulumi.InputType['FusionAuthApplicationAccessControlConfigurationArgs']]] = None,
            application_id: Optional[pulumi.Input[str]] = None,
            authentication_token_configuration_enabled: Optional[pulumi.Input[bool]] = None,
            clean_speak_configuration: Optional[pulumi.Input[pulumi.InputType['FusionAuthApplicationCleanSpeakConfigurationArgs']]] = None,
            data: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            email_configuration: Optional[pulumi.Input[pulumi.InputType['FusionAuthApplicationEmailConfigurationArgs']]] = None,
            form_configuration: Optional[pulumi.Input[pulumi.InputType['FusionAuthApplicationFormConfigurationArgs']]] = None,
            jwt_configuration: Optional[pulumi.Input[pulumi.InputType['FusionAuthApplicationJwtConfigurationArgs']]] = None,
            lambda_configuration: Optional[pulumi.Input[pulumi.InputType['FusionAuthApplicationLambdaConfigurationArgs']]] = None,
            login_configuration: Optional[pulumi.Input[pulumi.InputType['FusionAuthApplicationLoginConfigurationArgs']]] = None,
            multi_factor_configuration: Optional[pulumi.Input[pulumi.InputType['FusionAuthApplicationMultiFactorConfigurationArgs']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            oauth_configuration: Optional[pulumi.Input[pulumi.InputType['FusionAuthApplicationOauthConfigurationArgs']]] = None,
            passwordless_configuration_enabled: Optional[pulumi.Input[bool]] = None,
            registration_configuration: Optional[pulumi.Input[pulumi.InputType['FusionAuthApplicationRegistrationConfigurationArgs']]] = None,
            registration_delete_policy: Optional[pulumi.Input[pulumi.InputType['FusionAuthApplicationRegistrationDeletePolicyArgs']]] = None,
            samlv2_configuration: Optional[pulumi.Input[pulumi.InputType['FusionAuthApplicationSamlv2ConfigurationArgs']]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None,
            theme_id: Optional[pulumi.Input[str]] = None,
            verification_email_template_id: Optional[pulumi.Input[str]] = None,
            verify_registration: Optional[pulumi.Input[bool]] = None,
            webhook_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'FusionAuthApplication':
        """
        Get an existing FusionAuthApplication resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] application_id: The Id of the CleanSpeak application that usernames are sent to for moderation.
        :param pulumi.Input[bool] authentication_token_configuration_enabled: Determines if Users can have Authentication Tokens associated with this Application. This feature may not be enabled for the FusionAuth application.
        :param pulumi.Input[Mapping[str, Any]] data: An object that can hold any information about the Application that should be persisted.
        :param pulumi.Input[str] name: The name of the Application.
        :param pulumi.Input[bool] passwordless_configuration_enabled: Determines if passwordless login is enabled for this application.
        :param pulumi.Input[str] theme_id: The unique Id of the theme to be used to style the login page and other end user templates.
        :param pulumi.Input[str] verification_email_template_id: The Id of the Email Template that is used to send the Registration Verification emails to users. If the verifyRegistration field is true this field is required.
        :param pulumi.Input[bool] verify_registration: Whether or not registrations to this Application may be verified. When this is set to true the verificationEmailTemplateId parameter is also required.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] webhook_ids: An array of Webhook Ids. For Webhooks that are not already configured for All Applications, specifying an Id on this request will indicate the associated Webhook should handle events for this application.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FusionAuthApplicationState.__new__(_FusionAuthApplicationState)

        __props__.__dict__["access_control_configuration"] = access_control_configuration
        __props__.__dict__["application_id"] = application_id
        __props__.__dict__["authentication_token_configuration_enabled"] = authentication_token_configuration_enabled
        __props__.__dict__["clean_speak_configuration"] = clean_speak_configuration
        __props__.__dict__["data"] = data
        __props__.__dict__["email_configuration"] = email_configuration
        __props__.__dict__["form_configuration"] = form_configuration
        __props__.__dict__["jwt_configuration"] = jwt_configuration
        __props__.__dict__["lambda_configuration"] = lambda_configuration
        __props__.__dict__["login_configuration"] = login_configuration
        __props__.__dict__["multi_factor_configuration"] = multi_factor_configuration
        __props__.__dict__["name"] = name
        __props__.__dict__["oauth_configuration"] = oauth_configuration
        __props__.__dict__["passwordless_configuration_enabled"] = passwordless_configuration_enabled
        __props__.__dict__["registration_configuration"] = registration_configuration
        __props__.__dict__["registration_delete_policy"] = registration_delete_policy
        __props__.__dict__["samlv2_configuration"] = samlv2_configuration
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["theme_id"] = theme_id
        __props__.__dict__["verification_email_template_id"] = verification_email_template_id
        __props__.__dict__["verify_registration"] = verify_registration
        __props__.__dict__["webhook_ids"] = webhook_ids
        return FusionAuthApplication(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessControlConfiguration")
    def access_control_configuration(self) -> pulumi.Output['outputs.FusionAuthApplicationAccessControlConfiguration']:
        return pulumi.get(self, "access_control_configuration")

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Output[Optional[str]]:
        """
        The Id of the CleanSpeak application that usernames are sent to for moderation.
        """
        return pulumi.get(self, "application_id")

    @property
    @pulumi.getter(name="authenticationTokenConfigurationEnabled")
    def authentication_token_configuration_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Determines if Users can have Authentication Tokens associated with this Application. This feature may not be enabled for the FusionAuth application.
        """
        return pulumi.get(self, "authentication_token_configuration_enabled")

    @property
    @pulumi.getter(name="cleanSpeakConfiguration")
    def clean_speak_configuration(self) -> pulumi.Output['outputs.FusionAuthApplicationCleanSpeakConfiguration']:
        return pulumi.get(self, "clean_speak_configuration")

    @property
    @pulumi.getter
    def data(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        An object that can hold any information about the Application that should be persisted.
        """
        return pulumi.get(self, "data")

    @property
    @pulumi.getter(name="emailConfiguration")
    def email_configuration(self) -> pulumi.Output['outputs.FusionAuthApplicationEmailConfiguration']:
        return pulumi.get(self, "email_configuration")

    @property
    @pulumi.getter(name="formConfiguration")
    def form_configuration(self) -> pulumi.Output['outputs.FusionAuthApplicationFormConfiguration']:
        return pulumi.get(self, "form_configuration")

    @property
    @pulumi.getter(name="jwtConfiguration")
    def jwt_configuration(self) -> pulumi.Output['outputs.FusionAuthApplicationJwtConfiguration']:
        return pulumi.get(self, "jwt_configuration")

    @property
    @pulumi.getter(name="lambdaConfiguration")
    def lambda_configuration(self) -> pulumi.Output['outputs.FusionAuthApplicationLambdaConfiguration']:
        return pulumi.get(self, "lambda_configuration")

    @property
    @pulumi.getter(name="loginConfiguration")
    def login_configuration(self) -> pulumi.Output['outputs.FusionAuthApplicationLoginConfiguration']:
        return pulumi.get(self, "login_configuration")

    @property
    @pulumi.getter(name="multiFactorConfiguration")
    def multi_factor_configuration(self) -> pulumi.Output['outputs.FusionAuthApplicationMultiFactorConfiguration']:
        return pulumi.get(self, "multi_factor_configuration")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the Application.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="oauthConfiguration")
    def oauth_configuration(self) -> pulumi.Output['outputs.FusionAuthApplicationOauthConfiguration']:
        return pulumi.get(self, "oauth_configuration")

    @property
    @pulumi.getter(name="passwordlessConfigurationEnabled")
    def passwordless_configuration_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Determines if passwordless login is enabled for this application.
        """
        return pulumi.get(self, "passwordless_configuration_enabled")

    @property
    @pulumi.getter(name="registrationConfiguration")
    def registration_configuration(self) -> pulumi.Output['outputs.FusionAuthApplicationRegistrationConfiguration']:
        return pulumi.get(self, "registration_configuration")

    @property
    @pulumi.getter(name="registrationDeletePolicy")
    def registration_delete_policy(self) -> pulumi.Output['outputs.FusionAuthApplicationRegistrationDeletePolicy']:
        return pulumi.get(self, "registration_delete_policy")

    @property
    @pulumi.getter(name="samlv2Configuration")
    def samlv2_configuration(self) -> pulumi.Output['outputs.FusionAuthApplicationSamlv2Configuration']:
        return pulumi.get(self, "samlv2_configuration")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="themeId")
    def theme_id(self) -> pulumi.Output[Optional[str]]:
        """
        The unique Id of the theme to be used to style the login page and other end user templates.
        """
        return pulumi.get(self, "theme_id")

    @property
    @pulumi.getter(name="verificationEmailTemplateId")
    def verification_email_template_id(self) -> pulumi.Output[Optional[str]]:
        """
        The Id of the Email Template that is used to send the Registration Verification emails to users. If the verifyRegistration field is true this field is required.
        """
        return pulumi.get(self, "verification_email_template_id")

    @property
    @pulumi.getter(name="verifyRegistration")
    def verify_registration(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether or not registrations to this Application may be verified. When this is set to true the verificationEmailTemplateId parameter is also required.
        """
        return pulumi.get(self, "verify_registration")

    @property
    @pulumi.getter(name="webhookIds")
    def webhook_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        An array of Webhook Ids. For Webhooks that are not already configured for All Applications, specifying an Id on this request will indicate the associated Webhook should handle events for this application.
        """
        return pulumi.get(self, "webhook_ids")

