# noinspection PyPep8
# noinspection PyArgumentList

"""
AUTO-GENERATED BY `scripts/generate_protocol.py` using `data/browser_protocol.json`
and `data/js_protocol.json` as inputs! Please do not modify this file.
"""

import logging
from typing import Any, Optional, Union

from chromewhip.helpers import PayloadMixin, BaseEvent, ChromeTypeBase

log = logging.getLogger(__name__)
from chromewhip.protocol import debugger as Debugger
from chromewhip.protocol import runtime as Runtime
from chromewhip.protocol import security as Security
from chromewhip.protocol import page as Page

# ResourceType: Resource type as it was perceived by the rendering engine.
ResourceType = str

# LoaderId: Unique loader identifier.
LoaderId = str

# RequestId: Unique request identifier.
RequestId = str

# InterceptionId: Unique intercepted request identifier.
InterceptionId = str

# ErrorReason: Network level fetch failure reason.
ErrorReason = str

# TimeSinceEpoch: UTC time in seconds, counted from January 1, 1970.
TimeSinceEpoch = float

# MonotonicTime: Monotonically increasing time in seconds since an arbitrary point in the past.
MonotonicTime = float

# Headers: Request / response headers as keys / values of JSON object.
Headers = dict

# ConnectionType: The underlying connection technology that the browser is supposedly using.
ConnectionType = str

# CookieSameSite: Represents the cookie's 'SameSite' status:https://tools.ietf.org/html/draft-west-first-party-cookies
CookieSameSite = str

# ResourceTiming: Timing information for the request.
class ResourceTiming(ChromeTypeBase):
    def __init__(self,
                 requestTime: Union['float'],
                 proxyStart: Union['float'],
                 proxyEnd: Union['float'],
                 dnsStart: Union['float'],
                 dnsEnd: Union['float'],
                 connectStart: Union['float'],
                 connectEnd: Union['float'],
                 sslStart: Union['float'],
                 sslEnd: Union['float'],
                 workerStart: Union['float'],
                 workerReady: Union['float'],
                 sendStart: Union['float'],
                 sendEnd: Union['float'],
                 pushStart: Union['float'],
                 pushEnd: Union['float'],
                 receiveHeadersEnd: Union['float'],
                 ):

        self.requestTime = requestTime
        self.proxyStart = proxyStart
        self.proxyEnd = proxyEnd
        self.dnsStart = dnsStart
        self.dnsEnd = dnsEnd
        self.connectStart = connectStart
        self.connectEnd = connectEnd
        self.sslStart = sslStart
        self.sslEnd = sslEnd
        self.workerStart = workerStart
        self.workerReady = workerReady
        self.sendStart = sendStart
        self.sendEnd = sendEnd
        self.pushStart = pushStart
        self.pushEnd = pushEnd
        self.receiveHeadersEnd = receiveHeadersEnd


# ResourcePriority: Loading priority of a resource request.
ResourcePriority = str

# Request: HTTP request data.
class Request(ChromeTypeBase):
    def __init__(self,
                 url: Union['str'],
                 method: Union['str'],
                 headers: Union['Headers'],
                 initialPriority: Union['ResourcePriority'],
                 referrerPolicy: Union['str'],
                 urlFragment: Optional['str'] = None,
                 postData: Optional['str'] = None,
                 hasPostData: Optional['bool'] = None,
                 mixedContentType: Optional['Security.MixedContentType'] = None,
                 isLinkPreload: Optional['bool'] = None,
                 ):

        self.url = url
        self.urlFragment = urlFragment
        self.method = method
        self.headers = headers
        self.postData = postData
        self.hasPostData = hasPostData
        self.mixedContentType = mixedContentType
        self.initialPriority = initialPriority
        self.referrerPolicy = referrerPolicy
        self.isLinkPreload = isLinkPreload


# SignedCertificateTimestamp: Details of a signed certificate timestamp (SCT).
class SignedCertificateTimestamp(ChromeTypeBase):
    def __init__(self,
                 status: Union['str'],
                 origin: Union['str'],
                 logDescription: Union['str'],
                 logId: Union['str'],
                 timestamp: Union['TimeSinceEpoch'],
                 hashAlgorithm: Union['str'],
                 signatureAlgorithm: Union['str'],
                 signatureData: Union['str'],
                 ):

        self.status = status
        self.origin = origin
        self.logDescription = logDescription
        self.logId = logId
        self.timestamp = timestamp
        self.hashAlgorithm = hashAlgorithm
        self.signatureAlgorithm = signatureAlgorithm
        self.signatureData = signatureData


# SecurityDetails: Security details about a request.
class SecurityDetails(ChromeTypeBase):
    def __init__(self,
                 protocol: Union['str'],
                 keyExchange: Union['str'],
                 cipher: Union['str'],
                 certificateId: Union['Security.CertificateId'],
                 subjectName: Union['str'],
                 sanList: Union['[]'],
                 issuer: Union['str'],
                 validFrom: Union['TimeSinceEpoch'],
                 validTo: Union['TimeSinceEpoch'],
                 signedCertificateTimestampList: Union['[SignedCertificateTimestamp]'],
                 certificateTransparencyCompliance: Union['CertificateTransparencyCompliance'],
                 keyExchangeGroup: Optional['str'] = None,
                 mac: Optional['str'] = None,
                 ):

        self.protocol = protocol
        self.keyExchange = keyExchange
        self.keyExchangeGroup = keyExchangeGroup
        self.cipher = cipher
        self.mac = mac
        self.certificateId = certificateId
        self.subjectName = subjectName
        self.sanList = sanList
        self.issuer = issuer
        self.validFrom = validFrom
        self.validTo = validTo
        self.signedCertificateTimestampList = signedCertificateTimestampList
        self.certificateTransparencyCompliance = certificateTransparencyCompliance


# CertificateTransparencyCompliance: Whether the request complied with Certificate Transparency policy.
CertificateTransparencyCompliance = str

# BlockedReason: The reason why request was blocked.
BlockedReason = str

# Response: HTTP response data.
class Response(ChromeTypeBase):
    def __init__(self,
                 url: Union['str'],
                 status: Union['int'],
                 statusText: Union['str'],
                 headers: Union['Headers'],
                 mimeType: Union['str'],
                 connectionReused: Union['bool'],
                 connectionId: Union['float'],
                 encodedDataLength: Union['float'],
                 securityState: Union['Security.SecurityState'],
                 headersText: Optional['str'] = None,
                 requestHeaders: Optional['Headers'] = None,
                 requestHeadersText: Optional['str'] = None,
                 remoteIPAddress: Optional['str'] = None,
                 remotePort: Optional['int'] = None,
                 fromDiskCache: Optional['bool'] = None,
                 fromServiceWorker: Optional['bool'] = None,
                 fromPrefetchCache: Optional['bool'] = None,
                 timing: Optional['ResourceTiming'] = None,
                 protocol: Optional['str'] = None,
                 securityDetails: Optional['SecurityDetails'] = None,
                 ):

        self.url = url
        self.status = status
        self.statusText = statusText
        self.headers = headers
        self.headersText = headersText
        self.mimeType = mimeType
        self.requestHeaders = requestHeaders
        self.requestHeadersText = requestHeadersText
        self.connectionReused = connectionReused
        self.connectionId = connectionId
        self.remoteIPAddress = remoteIPAddress
        self.remotePort = remotePort
        self.fromDiskCache = fromDiskCache
        self.fromServiceWorker = fromServiceWorker
        self.fromPrefetchCache = fromPrefetchCache
        self.encodedDataLength = encodedDataLength
        self.timing = timing
        self.protocol = protocol
        self.securityState = securityState
        self.securityDetails = securityDetails


# WebSocketRequest: WebSocket request data.
class WebSocketRequest(ChromeTypeBase):
    def __init__(self,
                 headers: Union['Headers'],
                 ):

        self.headers = headers


# WebSocketResponse: WebSocket response data.
class WebSocketResponse(ChromeTypeBase):
    def __init__(self,
                 status: Union['int'],
                 statusText: Union['str'],
                 headers: Union['Headers'],
                 headersText: Optional['str'] = None,
                 requestHeaders: Optional['Headers'] = None,
                 requestHeadersText: Optional['str'] = None,
                 ):

        self.status = status
        self.statusText = statusText
        self.headers = headers
        self.headersText = headersText
        self.requestHeaders = requestHeaders
        self.requestHeadersText = requestHeadersText


# WebSocketFrame: WebSocket message data. This represents an entire WebSocket message, not just a fragmented frame as the name suggests.
class WebSocketFrame(ChromeTypeBase):
    def __init__(self,
                 opcode: Union['float'],
                 mask: Union['bool'],
                 payloadData: Union['str'],
                 ):

        self.opcode = opcode
        self.mask = mask
        self.payloadData = payloadData


# CachedResource: Information about the cached resource.
class CachedResource(ChromeTypeBase):
    def __init__(self,
                 url: Union['str'],
                 type: Union['ResourceType'],
                 bodySize: Union['float'],
                 response: Optional['Response'] = None,
                 ):

        self.url = url
        self.type = type
        self.response = response
        self.bodySize = bodySize


# Initiator: Information about the request initiator.
class Initiator(ChromeTypeBase):
    def __init__(self,
                 type: Union['str'],
                 stack: Optional['Runtime.StackTrace'] = None,
                 url: Optional['str'] = None,
                 lineNumber: Optional['float'] = None,
                 ):

        self.type = type
        self.stack = stack
        self.url = url
        self.lineNumber = lineNumber


# Cookie: Cookie object
class Cookie(ChromeTypeBase):
    def __init__(self,
                 name: Union['str'],
                 value: Union['str'],
                 domain: Union['str'],
                 path: Union['str'],
                 expires: Union['float'],
                 size: Union['int'],
                 httpOnly: Union['bool'],
                 secure: Union['bool'],
                 session: Union['bool'],
                 sameSite: Optional['CookieSameSite'] = None,
                 ):

        self.name = name
        self.value = value
        self.domain = domain
        self.path = path
        self.expires = expires
        self.size = size
        self.httpOnly = httpOnly
        self.secure = secure
        self.session = session
        self.sameSite = sameSite


# SetCookieBlockedReason: Types of reasons why a cookie may not be stored from a response.
SetCookieBlockedReason = str

# CookieBlockedReason: Types of reasons why a cookie may not be sent with a request.
CookieBlockedReason = str

# BlockedSetCookieWithReason: A cookie which was not stored from a response with the corresponding reason.
class BlockedSetCookieWithReason(ChromeTypeBase):
    def __init__(self,
                 blockedReasons: Union['[SetCookieBlockedReason]'],
                 cookieLine: Union['str'],
                 cookie: Optional['Cookie'] = None,
                 ):

        self.blockedReasons = blockedReasons
        self.cookieLine = cookieLine
        self.cookie = cookie


# BlockedCookieWithReason: A cookie with was not sent with a request with the corresponding reason.
class BlockedCookieWithReason(ChromeTypeBase):
    def __init__(self,
                 blockedReasons: Union['[CookieBlockedReason]'],
                 cookie: Union['Cookie'],
                 ):

        self.blockedReasons = blockedReasons
        self.cookie = cookie


# CookieParam: Cookie parameter object
class CookieParam(ChromeTypeBase):
    def __init__(self,
                 name: Union['str'],
                 value: Union['str'],
                 url: Optional['str'] = None,
                 domain: Optional['str'] = None,
                 path: Optional['str'] = None,
                 secure: Optional['bool'] = None,
                 httpOnly: Optional['bool'] = None,
                 sameSite: Optional['CookieSameSite'] = None,
                 expires: Optional['TimeSinceEpoch'] = None,
                 ):

        self.name = name
        self.value = value
        self.url = url
        self.domain = domain
        self.path = path
        self.secure = secure
        self.httpOnly = httpOnly
        self.sameSite = sameSite
        self.expires = expires


# AuthChallenge: Authorization challenge for HTTP status code 401 or 407.
class AuthChallenge(ChromeTypeBase):
    def __init__(self,
                 origin: Union['str'],
                 scheme: Union['str'],
                 realm: Union['str'],
                 source: Optional['str'] = None,
                 ):

        self.source = source
        self.origin = origin
        self.scheme = scheme
        self.realm = realm


# AuthChallengeResponse: Response to an AuthChallenge.
class AuthChallengeResponse(ChromeTypeBase):
    def __init__(self,
                 response: Union['str'],
                 username: Optional['str'] = None,
                 password: Optional['str'] = None,
                 ):

        self.response = response
        self.username = username
        self.password = password


# InterceptionStage: Stages of the interception to begin intercepting. Request will intercept before the request issent. Response will intercept after the response is received.
InterceptionStage = str

# RequestPattern: Request pattern for interception.
class RequestPattern(ChromeTypeBase):
    def __init__(self,
                 urlPattern: Optional['str'] = None,
                 resourceType: Optional['ResourceType'] = None,
                 interceptionStage: Optional['InterceptionStage'] = None,
                 ):

        self.urlPattern = urlPattern
        self.resourceType = resourceType
        self.interceptionStage = interceptionStage


# SignedExchangeSignature: Information about a signed exchange signature.https://wicg.github.io/webpackage/draft-yasskin-httpbis-origin-signed-exchanges-impl.html#rfc.section.3.1
class SignedExchangeSignature(ChromeTypeBase):
    def __init__(self,
                 label: Union['str'],
                 signature: Union['str'],
                 integrity: Union['str'],
                 validityUrl: Union['str'],
                 date: Union['int'],
                 expires: Union['int'],
                 certUrl: Optional['str'] = None,
                 certSha256: Optional['str'] = None,
                 certificates: Optional['[]'] = None,
                 ):

        self.label = label
        self.signature = signature
        self.integrity = integrity
        self.certUrl = certUrl
        self.certSha256 = certSha256
        self.validityUrl = validityUrl
        self.date = date
        self.expires = expires
        self.certificates = certificates


# SignedExchangeHeader: Information about a signed exchange header.https://wicg.github.io/webpackage/draft-yasskin-httpbis-origin-signed-exchanges-impl.html#cbor-representation
class SignedExchangeHeader(ChromeTypeBase):
    def __init__(self,
                 requestUrl: Union['str'],
                 responseCode: Union['int'],
                 responseHeaders: Union['Headers'],
                 signatures: Union['[SignedExchangeSignature]'],
                 headerIntegrity: Union['str'],
                 ):

        self.requestUrl = requestUrl
        self.responseCode = responseCode
        self.responseHeaders = responseHeaders
        self.signatures = signatures
        self.headerIntegrity = headerIntegrity


# SignedExchangeErrorField: Field type for a signed exchange related error.
SignedExchangeErrorField = str

# SignedExchangeError: Information about a signed exchange response.
class SignedExchangeError(ChromeTypeBase):
    def __init__(self,
                 message: Union['str'],
                 signatureIndex: Optional['int'] = None,
                 errorField: Optional['SignedExchangeErrorField'] = None,
                 ):

        self.message = message
        self.signatureIndex = signatureIndex
        self.errorField = errorField


# SignedExchangeInfo: Information about a signed exchange response.
class SignedExchangeInfo(ChromeTypeBase):
    def __init__(self,
                 outerResponse: Union['Response'],
                 header: Optional['SignedExchangeHeader'] = None,
                 securityDetails: Optional['SecurityDetails'] = None,
                 errors: Optional['[SignedExchangeError]'] = None,
                 ):

        self.outerResponse = outerResponse
        self.header = header
        self.securityDetails = securityDetails
        self.errors = errors


class Network(PayloadMixin):
    """ Network domain allows tracking network activities of the page. It exposes information about http,
file, data and other requests and responses, their headers, bodies, timing, etc.
    """
    @classmethod
    def canClearBrowserCache(cls):
        """Tells whether clearing browser cache is supported.
        """
        return (
            cls.build_send_payload("canClearBrowserCache", {
            }),
            cls.convert_payload({
                "result": {
                    "class": bool,
                    "optional": False
                },
            })
        )

    @classmethod
    def canClearBrowserCookies(cls):
        """Tells whether clearing browser cookies is supported.
        """
        return (
            cls.build_send_payload("canClearBrowserCookies", {
            }),
            cls.convert_payload({
                "result": {
                    "class": bool,
                    "optional": False
                },
            })
        )

    @classmethod
    def canEmulateNetworkConditions(cls):
        """Tells whether emulation of network conditions is supported.
        """
        return (
            cls.build_send_payload("canEmulateNetworkConditions", {
            }),
            cls.convert_payload({
                "result": {
                    "class": bool,
                    "optional": False
                },
            })
        )

    @classmethod
    def clearBrowserCache(cls):
        """Clears browser cache.
        """
        return (
            cls.build_send_payload("clearBrowserCache", {
            }),
            None
        )

    @classmethod
    def clearBrowserCookies(cls):
        """Clears browser cookies.
        """
        return (
            cls.build_send_payload("clearBrowserCookies", {
            }),
            None
        )

    @classmethod
    def continueInterceptedRequest(cls,
                                   interceptionId: Union['InterceptionId'],
                                   errorReason: Optional['ErrorReason'] = None,
                                   rawResponse: Optional['str'] = None,
                                   url: Optional['str'] = None,
                                   method: Optional['str'] = None,
                                   postData: Optional['str'] = None,
                                   headers: Optional['Headers'] = None,
                                   authChallengeResponse: Optional['AuthChallengeResponse'] = None,
                                   ):
        """Response to Network.requestIntercepted which either modifies the request to continue with any
modifications, or blocks it, or completes it with the provided response bytes. If a network
fetch occurs as a result which encounters a redirect an additional Network.requestIntercepted
event will be sent with the same InterceptionId.
Deprecated, use Fetch.continueRequest, Fetch.fulfillRequest and Fetch.failRequest instead.
        :param interceptionId: 
        :type interceptionId: InterceptionId
        :param errorReason: If set this causes the request to fail with the given reason. Passing `Aborted` for requests
marked with `isNavigationRequest` also cancels the navigation. Must not be set in response
to an authChallenge.
        :type errorReason: ErrorReason
        :param rawResponse: If set the requests completes using with the provided base64 encoded raw response, including
HTTP status line and headers etc... Must not be set in response to an authChallenge.
        :type rawResponse: str
        :param url: If set the request url will be modified in a way that's not observable by page. Must not be
set in response to an authChallenge.
        :type url: str
        :param method: If set this allows the request method to be overridden. Must not be set in response to an
authChallenge.
        :type method: str
        :param postData: If set this allows postData to be set. Must not be set in response to an authChallenge.
        :type postData: str
        :param headers: If set this allows the request headers to be changed. Must not be set in response to an
authChallenge.
        :type headers: Headers
        :param authChallengeResponse: Response to a requestIntercepted with an authChallenge. Must not be set otherwise.
        :type authChallengeResponse: AuthChallengeResponse
        """
        return (
            cls.build_send_payload("continueInterceptedRequest", {
                "interceptionId": interceptionId,
                "errorReason": errorReason,
                "rawResponse": rawResponse,
                "url": url,
                "method": method,
                "postData": postData,
                "headers": headers,
                "authChallengeResponse": authChallengeResponse,
            }),
            None
        )

    @classmethod
    def deleteCookies(cls,
                      name: Union['str'],
                      url: Optional['str'] = None,
                      domain: Optional['str'] = None,
                      path: Optional['str'] = None,
                      ):
        """Deletes browser cookies with matching name and url or domain/path pair.
        :param name: Name of the cookies to remove.
        :type name: str
        :param url: If specified, deletes all the cookies with the given name where domain and path match
provided URL.
        :type url: str
        :param domain: If specified, deletes only cookies with the exact domain.
        :type domain: str
        :param path: If specified, deletes only cookies with the exact path.
        :type path: str
        """
        return (
            cls.build_send_payload("deleteCookies", {
                "name": name,
                "url": url,
                "domain": domain,
                "path": path,
            }),
            None
        )

    @classmethod
    def disable(cls):
        """Disables network tracking, prevents network events from being sent to the client.
        """
        return (
            cls.build_send_payload("disable", {
            }),
            None
        )

    @classmethod
    def emulateNetworkConditions(cls,
                                 offline: Union['bool'],
                                 latency: Union['float'],
                                 downloadThroughput: Union['float'],
                                 uploadThroughput: Union['float'],
                                 connectionType: Optional['ConnectionType'] = None,
                                 ):
        """Activates emulation of network conditions.
        :param offline: True to emulate internet disconnection.
        :type offline: bool
        :param latency: Minimum latency from request sent to response headers received (ms).
        :type latency: float
        :param downloadThroughput: Maximal aggregated download throughput (bytes/sec). -1 disables download throttling.
        :type downloadThroughput: float
        :param uploadThroughput: Maximal aggregated upload throughput (bytes/sec).  -1 disables upload throttling.
        :type uploadThroughput: float
        :param connectionType: Connection type if known.
        :type connectionType: ConnectionType
        """
        return (
            cls.build_send_payload("emulateNetworkConditions", {
                "offline": offline,
                "latency": latency,
                "downloadThroughput": downloadThroughput,
                "uploadThroughput": uploadThroughput,
                "connectionType": connectionType,
            }),
            None
        )

    @classmethod
    def enable(cls,
               maxTotalBufferSize: Optional['int'] = None,
               maxResourceBufferSize: Optional['int'] = None,
               maxPostDataSize: Optional['int'] = None,
               ):
        """Enables network tracking, network events will now be delivered to the client.
        :param maxTotalBufferSize: Buffer size in bytes to use when preserving network payloads (XHRs, etc).
        :type maxTotalBufferSize: int
        :param maxResourceBufferSize: Per-resource buffer size in bytes to use when preserving network payloads (XHRs, etc).
        :type maxResourceBufferSize: int
        :param maxPostDataSize: Longest post body size (in bytes) that would be included in requestWillBeSent notification
        :type maxPostDataSize: int
        """
        return (
            cls.build_send_payload("enable", {
                "maxTotalBufferSize": maxTotalBufferSize,
                "maxResourceBufferSize": maxResourceBufferSize,
                "maxPostDataSize": maxPostDataSize,
            }),
            None
        )

    @classmethod
    def getAllCookies(cls):
        """Returns all browser cookies. Depending on the backend support, will return detailed cookie
information in the `cookies` field.
        """
        return (
            cls.build_send_payload("getAllCookies", {
            }),
            cls.convert_payload({
                "cookies": {
                    "class": [Cookie],
                    "optional": False
                },
            })
        )

    @classmethod
    def getCertificate(cls,
                       origin: Union['str'],
                       ):
        """Returns the DER-encoded certificate.
        :param origin: Origin to get certificate for.
        :type origin: str
        """
        return (
            cls.build_send_payload("getCertificate", {
                "origin": origin,
            }),
            cls.convert_payload({
                "tableNames": {
                    "class": [],
                    "optional": False
                },
            })
        )

    @classmethod
    def getCookies(cls,
                   urls: Optional['[]'] = None,
                   ):
        """Returns all browser cookies for the current URL. Depending on the backend support, will return
detailed cookie information in the `cookies` field.
        :param urls: The list of URLs for which applicable cookies will be fetched
        :type urls: []
        """
        return (
            cls.build_send_payload("getCookies", {
                "urls": urls,
            }),
            cls.convert_payload({
                "cookies": {
                    "class": [Cookie],
                    "optional": False
                },
            })
        )

    @classmethod
    def getResponseBody(cls,
                        requestId: Union['RequestId'],
                        ):
        """Returns content served for the given request.
        :param requestId: Identifier of the network request to get content for.
        :type requestId: RequestId
        """
        return (
            cls.build_send_payload("getResponseBody", {
                "requestId": requestId,
            }),
            cls.convert_payload({
                "body": {
                    "class": str,
                    "optional": False
                },
                "base64Encoded": {
                    "class": bool,
                    "optional": False
                },
            })
        )

    @classmethod
    def getRequestPostData(cls,
                           requestId: Union['RequestId'],
                           ):
        """Returns post data sent with the request. Returns an error when no data was sent with the request.
        :param requestId: Identifier of the network request to get content for.
        :type requestId: RequestId
        """
        return (
            cls.build_send_payload("getRequestPostData", {
                "requestId": requestId,
            }),
            cls.convert_payload({
                "postData": {
                    "class": str,
                    "optional": False
                },
            })
        )

    @classmethod
    def getResponseBodyForInterception(cls,
                                       interceptionId: Union['InterceptionId'],
                                       ):
        """Returns content served for the given currently intercepted request.
        :param interceptionId: Identifier for the intercepted request to get body for.
        :type interceptionId: InterceptionId
        """
        return (
            cls.build_send_payload("getResponseBodyForInterception", {
                "interceptionId": interceptionId,
            }),
            cls.convert_payload({
                "body": {
                    "class": str,
                    "optional": False
                },
                "base64Encoded": {
                    "class": bool,
                    "optional": False
                },
            })
        )

    @classmethod
    def takeResponseBodyForInterceptionAsStream(cls,
                                                interceptionId: Union['InterceptionId'],
                                                ):
        """Returns a handle to the stream representing the response body. Note that after this command,
the intercepted request can't be continued as is -- you either need to cancel it or to provide
the response body. The stream only supports sequential read, IO.read will fail if the position
is specified.
        :param interceptionId: 
        :type interceptionId: InterceptionId
        """
        return (
            cls.build_send_payload("takeResponseBodyForInterceptionAsStream", {
                "interceptionId": interceptionId,
            }),
            cls.convert_payload({
                "stream": {
                    "class": IO.StreamHandle,
                    "optional": False
                },
            })
        )

    @classmethod
    def replayXHR(cls,
                  requestId: Union['RequestId'],
                  ):
        """This method sends a new XMLHttpRequest which is identical to the original one. The following
parameters should be identical: method, url, async, request body, extra headers, withCredentials
attribute, user, password.
        :param requestId: Identifier of XHR to replay.
        :type requestId: RequestId
        """
        return (
            cls.build_send_payload("replayXHR", {
                "requestId": requestId,
            }),
            None
        )

    @classmethod
    def searchInResponseBody(cls,
                             requestId: Union['RequestId'],
                             query: Union['str'],
                             caseSensitive: Optional['bool'] = None,
                             isRegex: Optional['bool'] = None,
                             ):
        """Searches for given string in response content.
        :param requestId: Identifier of the network response to search.
        :type requestId: RequestId
        :param query: String to search for.
        :type query: str
        :param caseSensitive: If true, search is case sensitive.
        :type caseSensitive: bool
        :param isRegex: If true, treats string parameter as regex.
        :type isRegex: bool
        """
        return (
            cls.build_send_payload("searchInResponseBody", {
                "requestId": requestId,
                "query": query,
                "caseSensitive": caseSensitive,
                "isRegex": isRegex,
            }),
            cls.convert_payload({
                "result": {
                    "class": [Debugger.SearchMatch],
                    "optional": False
                },
            })
        )

    @classmethod
    def setBlockedURLs(cls,
                       urls: Union['[]'],
                       ):
        """Blocks URLs from loading.
        :param urls: URL patterns to block. Wildcards ('*') are allowed.
        :type urls: []
        """
        return (
            cls.build_send_payload("setBlockedURLs", {
                "urls": urls,
            }),
            None
        )

    @classmethod
    def setBypassServiceWorker(cls,
                               bypass: Union['bool'],
                               ):
        """Toggles ignoring of service worker for each request.
        :param bypass: Bypass service worker and load from network.
        :type bypass: bool
        """
        return (
            cls.build_send_payload("setBypassServiceWorker", {
                "bypass": bypass,
            }),
            None
        )

    @classmethod
    def setCacheDisabled(cls,
                         cacheDisabled: Union['bool'],
                         ):
        """Toggles ignoring cache for each request. If `true`, cache will not be used.
        :param cacheDisabled: Cache disabled state.
        :type cacheDisabled: bool
        """
        return (
            cls.build_send_payload("setCacheDisabled", {
                "cacheDisabled": cacheDisabled,
            }),
            None
        )

    @classmethod
    def setCookie(cls,
                  name: Union['str'],
                  value: Union['str'],
                  url: Optional['str'] = None,
                  domain: Optional['str'] = None,
                  path: Optional['str'] = None,
                  secure: Optional['bool'] = None,
                  httpOnly: Optional['bool'] = None,
                  sameSite: Optional['CookieSameSite'] = None,
                  expires: Optional['TimeSinceEpoch'] = None,
                  ):
        """Sets a cookie with the given cookie data; may overwrite equivalent cookies if they exist.
        :param name: Cookie name.
        :type name: str
        :param value: Cookie value.
        :type value: str
        :param url: The request-URI to associate with the setting of the cookie. This value can affect the
default domain and path values of the created cookie.
        :type url: str
        :param domain: Cookie domain.
        :type domain: str
        :param path: Cookie path.
        :type path: str
        :param secure: True if cookie is secure.
        :type secure: bool
        :param httpOnly: True if cookie is http-only.
        :type httpOnly: bool
        :param sameSite: Cookie SameSite type.
        :type sameSite: CookieSameSite
        :param expires: Cookie expiration date, session cookie if not set
        :type expires: TimeSinceEpoch
        """
        return (
            cls.build_send_payload("setCookie", {
                "name": name,
                "value": value,
                "url": url,
                "domain": domain,
                "path": path,
                "secure": secure,
                "httpOnly": httpOnly,
                "sameSite": sameSite,
                "expires": expires,
            }),
            cls.convert_payload({
                "success": {
                    "class": bool,
                    "optional": False
                },
            })
        )

    @classmethod
    def setCookies(cls,
                   cookies: Union['[CookieParam]'],
                   ):
        """Sets given cookies.
        :param cookies: Cookies to be set.
        :type cookies: [CookieParam]
        """
        return (
            cls.build_send_payload("setCookies", {
                "cookies": cookies,
            }),
            None
        )

    @classmethod
    def setDataSizeLimitsForTest(cls,
                                 maxTotalSize: Union['int'],
                                 maxResourceSize: Union['int'],
                                 ):
        """For testing.
        :param maxTotalSize: Maximum total buffer size.
        :type maxTotalSize: int
        :param maxResourceSize: Maximum per-resource size.
        :type maxResourceSize: int
        """
        return (
            cls.build_send_payload("setDataSizeLimitsForTest", {
                "maxTotalSize": maxTotalSize,
                "maxResourceSize": maxResourceSize,
            }),
            None
        )

    @classmethod
    def setExtraHTTPHeaders(cls,
                            headers: Union['Headers'],
                            ):
        """Specifies whether to always send extra HTTP headers with the requests from this page.
        :param headers: Map with extra HTTP headers.
        :type headers: Headers
        """
        return (
            cls.build_send_payload("setExtraHTTPHeaders", {
                "headers": headers,
            }),
            None
        )

    @classmethod
    def setRequestInterception(cls,
                               patterns: Union['[RequestPattern]'],
                               ):
        """Sets the requests to intercept that match the provided patterns and optionally resource types.
Deprecated, please use Fetch.enable instead.
        :param patterns: Requests matching any of these patterns will be forwarded and wait for the corresponding
continueInterceptedRequest call.
        :type patterns: [RequestPattern]
        """
        return (
            cls.build_send_payload("setRequestInterception", {
                "patterns": patterns,
            }),
            None
        )

    @classmethod
    def setUserAgentOverride(cls,
                             userAgent: Union['str'],
                             acceptLanguage: Optional['str'] = None,
                             platform: Optional['str'] = None,
                             ):
        """Allows overriding user agent with the given string.
        :param userAgent: User agent to use.
        :type userAgent: str
        :param acceptLanguage: Browser langugage to emulate.
        :type acceptLanguage: str
        :param platform: The platform navigator.platform should return.
        :type platform: str
        """
        return (
            cls.build_send_payload("setUserAgentOverride", {
                "userAgent": userAgent,
                "acceptLanguage": acceptLanguage,
                "platform": platform,
            }),
            None
        )



class DataReceivedEvent(BaseEvent):

    js_name = 'Network.dataReceived'
    hashable = ['requestId']
    is_hashable = True

    def __init__(self,
                 requestId: Union['RequestId', dict],
                 timestamp: Union['MonotonicTime', dict],
                 dataLength: Union['int', dict],
                 encodedDataLength: Union['int', dict],
                 ):
        if isinstance(requestId, dict):
            requestId = RequestId(**requestId)
        self.requestId = requestId
        if isinstance(timestamp, dict):
            timestamp = MonotonicTime(**timestamp)
        self.timestamp = timestamp
        if isinstance(dataLength, dict):
            dataLength = int(**dataLength)
        self.dataLength = dataLength
        if isinstance(encodedDataLength, dict):
            encodedDataLength = int(**encodedDataLength)
        self.encodedDataLength = encodedDataLength

    @classmethod
    def build_hash(cls, requestId):
        kwargs = locals()
        kwargs.pop('cls')
        serialized_id_params = ','.join(['='.join([p, str(v)]) for p, v in kwargs.items()])
        h = '{}:{}'.format(cls.js_name, serialized_id_params)
        log.debug('generated hash = %s' % h)
        return h


class EventSourceMessageReceivedEvent(BaseEvent):

    js_name = 'Network.eventSourceMessageReceived'
    hashable = ['eventId', 'requestId']
    is_hashable = True

    def __init__(self,
                 requestId: Union['RequestId', dict],
                 timestamp: Union['MonotonicTime', dict],
                 eventName: Union['str', dict],
                 eventId: Union['str', dict],
                 data: Union['str', dict],
                 ):
        if isinstance(requestId, dict):
            requestId = RequestId(**requestId)
        self.requestId = requestId
        if isinstance(timestamp, dict):
            timestamp = MonotonicTime(**timestamp)
        self.timestamp = timestamp
        if isinstance(eventName, dict):
            eventName = str(**eventName)
        self.eventName = eventName
        if isinstance(eventId, dict):
            eventId = str(**eventId)
        self.eventId = eventId
        if isinstance(data, dict):
            data = str(**data)
        self.data = data

    @classmethod
    def build_hash(cls, eventId, requestId):
        kwargs = locals()
        kwargs.pop('cls')
        serialized_id_params = ','.join(['='.join([p, str(v)]) for p, v in kwargs.items()])
        h = '{}:{}'.format(cls.js_name, serialized_id_params)
        log.debug('generated hash = %s' % h)
        return h


class LoadingFailedEvent(BaseEvent):

    js_name = 'Network.loadingFailed'
    hashable = ['requestId']
    is_hashable = True

    def __init__(self,
                 requestId: Union['RequestId', dict],
                 timestamp: Union['MonotonicTime', dict],
                 type: Union['ResourceType', dict],
                 errorText: Union['str', dict],
                 canceled: Union['bool', dict, None] = None,
                 blockedReason: Union['BlockedReason', dict, None] = None,
                 ):
        if isinstance(requestId, dict):
            requestId = RequestId(**requestId)
        self.requestId = requestId
        if isinstance(timestamp, dict):
            timestamp = MonotonicTime(**timestamp)
        self.timestamp = timestamp
        if isinstance(type, dict):
            type = ResourceType(**type)
        self.type = type
        if isinstance(errorText, dict):
            errorText = str(**errorText)
        self.errorText = errorText
        if isinstance(canceled, dict):
            canceled = bool(**canceled)
        self.canceled = canceled
        if isinstance(blockedReason, dict):
            blockedReason = BlockedReason(**blockedReason)
        self.blockedReason = blockedReason

    @classmethod
    def build_hash(cls, requestId):
        kwargs = locals()
        kwargs.pop('cls')
        serialized_id_params = ','.join(['='.join([p, str(v)]) for p, v in kwargs.items()])
        h = '{}:{}'.format(cls.js_name, serialized_id_params)
        log.debug('generated hash = %s' % h)
        return h


class LoadingFinishedEvent(BaseEvent):

    js_name = 'Network.loadingFinished'
    hashable = ['requestId']
    is_hashable = True

    def __init__(self,
                 requestId: Union['RequestId', dict],
                 timestamp: Union['MonotonicTime', dict],
                 encodedDataLength: Union['float', dict],
                 shouldReportCorbBlocking: Union['bool', dict, None] = None,
                 ):
        if isinstance(requestId, dict):
            requestId = RequestId(**requestId)
        self.requestId = requestId
        if isinstance(timestamp, dict):
            timestamp = MonotonicTime(**timestamp)
        self.timestamp = timestamp
        if isinstance(encodedDataLength, dict):
            encodedDataLength = float(**encodedDataLength)
        self.encodedDataLength = encodedDataLength
        if isinstance(shouldReportCorbBlocking, dict):
            shouldReportCorbBlocking = bool(**shouldReportCorbBlocking)
        self.shouldReportCorbBlocking = shouldReportCorbBlocking

    @classmethod
    def build_hash(cls, requestId):
        kwargs = locals()
        kwargs.pop('cls')
        serialized_id_params = ','.join(['='.join([p, str(v)]) for p, v in kwargs.items()])
        h = '{}:{}'.format(cls.js_name, serialized_id_params)
        log.debug('generated hash = %s' % h)
        return h


class RequestInterceptedEvent(BaseEvent):

    js_name = 'Network.requestIntercepted'
    hashable = ['interceptionId', 'frameId', 'requestId']
    is_hashable = True

    def __init__(self,
                 interceptionId: Union['InterceptionId', dict],
                 request: Union['Request', dict],
                 frameId: Union['Page.FrameId', dict],
                 resourceType: Union['ResourceType', dict],
                 isNavigationRequest: Union['bool', dict],
                 isDownload: Union['bool', dict, None] = None,
                 redirectUrl: Union['str', dict, None] = None,
                 authChallenge: Union['AuthChallenge', dict, None] = None,
                 responseErrorReason: Union['ErrorReason', dict, None] = None,
                 responseStatusCode: Union['int', dict, None] = None,
                 responseHeaders: Union['Headers', dict, None] = None,
                 requestId: Union['RequestId', dict, None] = None,
                 ):
        if isinstance(interceptionId, dict):
            interceptionId = InterceptionId(**interceptionId)
        self.interceptionId = interceptionId
        if isinstance(request, dict):
            request = Request(**request)
        self.request = request
        if isinstance(frameId, dict):
            frameId = Page.FrameId(**frameId)
        self.frameId = frameId
        if isinstance(resourceType, dict):
            resourceType = ResourceType(**resourceType)
        self.resourceType = resourceType
        if isinstance(isNavigationRequest, dict):
            isNavigationRequest = bool(**isNavigationRequest)
        self.isNavigationRequest = isNavigationRequest
        if isinstance(isDownload, dict):
            isDownload = bool(**isDownload)
        self.isDownload = isDownload
        if isinstance(redirectUrl, dict):
            redirectUrl = str(**redirectUrl)
        self.redirectUrl = redirectUrl
        if isinstance(authChallenge, dict):
            authChallenge = AuthChallenge(**authChallenge)
        self.authChallenge = authChallenge
        if isinstance(responseErrorReason, dict):
            responseErrorReason = ErrorReason(**responseErrorReason)
        self.responseErrorReason = responseErrorReason
        if isinstance(responseStatusCode, dict):
            responseStatusCode = int(**responseStatusCode)
        self.responseStatusCode = responseStatusCode
        if isinstance(responseHeaders, dict):
            responseHeaders = Headers(**responseHeaders)
        self.responseHeaders = responseHeaders
        if isinstance(requestId, dict):
            requestId = RequestId(**requestId)
        self.requestId = requestId

    @classmethod
    def build_hash(cls, interceptionId, frameId, requestId):
        kwargs = locals()
        kwargs.pop('cls')
        serialized_id_params = ','.join(['='.join([p, str(v)]) for p, v in kwargs.items()])
        h = '{}:{}'.format(cls.js_name, serialized_id_params)
        log.debug('generated hash = %s' % h)
        return h


class RequestServedFromCacheEvent(BaseEvent):

    js_name = 'Network.requestServedFromCache'
    hashable = ['requestId']
    is_hashable = True

    def __init__(self,
                 requestId: Union['RequestId', dict],
                 ):
        if isinstance(requestId, dict):
            requestId = RequestId(**requestId)
        self.requestId = requestId

    @classmethod
    def build_hash(cls, requestId):
        kwargs = locals()
        kwargs.pop('cls')
        serialized_id_params = ','.join(['='.join([p, str(v)]) for p, v in kwargs.items()])
        h = '{}:{}'.format(cls.js_name, serialized_id_params)
        log.debug('generated hash = %s' % h)
        return h


class RequestWillBeSentEvent(BaseEvent):

    js_name = 'Network.requestWillBeSent'
    hashable = ['loaderId', 'frameId', 'requestId']
    is_hashable = True

    def __init__(self,
                 requestId: Union['RequestId', dict],
                 loaderId: Union['LoaderId', dict],
                 documentURL: Union['str', dict],
                 request: Union['Request', dict],
                 timestamp: Union['MonotonicTime', dict],
                 wallTime: Union['TimeSinceEpoch', dict],
                 initiator: Union['Initiator', dict],
                 redirectResponse: Union['Response', dict, None] = None,
                 type: Union['ResourceType', dict, None] = None,
                 frameId: Union['Page.FrameId', dict, None] = None,
                 hasUserGesture: Union['bool', dict, None] = None,
                 ):
        if isinstance(requestId, dict):
            requestId = RequestId(**requestId)
        self.requestId = requestId
        if isinstance(loaderId, dict):
            loaderId = LoaderId(**loaderId)
        self.loaderId = loaderId
        if isinstance(documentURL, dict):
            documentURL = str(**documentURL)
        self.documentURL = documentURL
        if isinstance(request, dict):
            request = Request(**request)
        self.request = request
        if isinstance(timestamp, dict):
            timestamp = MonotonicTime(**timestamp)
        self.timestamp = timestamp
        if isinstance(wallTime, dict):
            wallTime = TimeSinceEpoch(**wallTime)
        self.wallTime = wallTime
        if isinstance(initiator, dict):
            initiator = Initiator(**initiator)
        self.initiator = initiator
        if isinstance(redirectResponse, dict):
            redirectResponse = Response(**redirectResponse)
        self.redirectResponse = redirectResponse
        if isinstance(type, dict):
            type = ResourceType(**type)
        self.type = type
        if isinstance(frameId, dict):
            frameId = Page.FrameId(**frameId)
        self.frameId = frameId
        if isinstance(hasUserGesture, dict):
            hasUserGesture = bool(**hasUserGesture)
        self.hasUserGesture = hasUserGesture

    @classmethod
    def build_hash(cls, loaderId, frameId, requestId):
        kwargs = locals()
        kwargs.pop('cls')
        serialized_id_params = ','.join(['='.join([p, str(v)]) for p, v in kwargs.items()])
        h = '{}:{}'.format(cls.js_name, serialized_id_params)
        log.debug('generated hash = %s' % h)
        return h


class ResourceChangedPriorityEvent(BaseEvent):

    js_name = 'Network.resourceChangedPriority'
    hashable = ['requestId']
    is_hashable = True

    def __init__(self,
                 requestId: Union['RequestId', dict],
                 newPriority: Union['ResourcePriority', dict],
                 timestamp: Union['MonotonicTime', dict],
                 ):
        if isinstance(requestId, dict):
            requestId = RequestId(**requestId)
        self.requestId = requestId
        if isinstance(newPriority, dict):
            newPriority = ResourcePriority(**newPriority)
        self.newPriority = newPriority
        if isinstance(timestamp, dict):
            timestamp = MonotonicTime(**timestamp)
        self.timestamp = timestamp

    @classmethod
    def build_hash(cls, requestId):
        kwargs = locals()
        kwargs.pop('cls')
        serialized_id_params = ','.join(['='.join([p, str(v)]) for p, v in kwargs.items()])
        h = '{}:{}'.format(cls.js_name, serialized_id_params)
        log.debug('generated hash = %s' % h)
        return h


class SignedExchangeReceivedEvent(BaseEvent):

    js_name = 'Network.signedExchangeReceived'
    hashable = ['requestId']
    is_hashable = True

    def __init__(self,
                 requestId: Union['RequestId', dict],
                 info: Union['SignedExchangeInfo', dict],
                 ):
        if isinstance(requestId, dict):
            requestId = RequestId(**requestId)
        self.requestId = requestId
        if isinstance(info, dict):
            info = SignedExchangeInfo(**info)
        self.info = info

    @classmethod
    def build_hash(cls, requestId):
        kwargs = locals()
        kwargs.pop('cls')
        serialized_id_params = ','.join(['='.join([p, str(v)]) for p, v in kwargs.items()])
        h = '{}:{}'.format(cls.js_name, serialized_id_params)
        log.debug('generated hash = %s' % h)
        return h


class ResponseReceivedEvent(BaseEvent):

    js_name = 'Network.responseReceived'
    hashable = ['loaderId', 'frameId', 'requestId']
    is_hashable = True

    def __init__(self,
                 requestId: Union['RequestId', dict],
                 loaderId: Union['LoaderId', dict],
                 timestamp: Union['MonotonicTime', dict],
                 type: Union['ResourceType', dict],
                 response: Union['Response', dict],
                 frameId: Union['Page.FrameId', dict, None] = None,
                 ):
        if isinstance(requestId, dict):
            requestId = RequestId(**requestId)
        self.requestId = requestId
        if isinstance(loaderId, dict):
            loaderId = LoaderId(**loaderId)
        self.loaderId = loaderId
        if isinstance(timestamp, dict):
            timestamp = MonotonicTime(**timestamp)
        self.timestamp = timestamp
        if isinstance(type, dict):
            type = ResourceType(**type)
        self.type = type
        if isinstance(response, dict):
            response = Response(**response)
        self.response = response
        if isinstance(frameId, dict):
            frameId = Page.FrameId(**frameId)
        self.frameId = frameId

    @classmethod
    def build_hash(cls, loaderId, frameId, requestId):
        kwargs = locals()
        kwargs.pop('cls')
        serialized_id_params = ','.join(['='.join([p, str(v)]) for p, v in kwargs.items()])
        h = '{}:{}'.format(cls.js_name, serialized_id_params)
        log.debug('generated hash = %s' % h)
        return h


class WebSocketClosedEvent(BaseEvent):

    js_name = 'Network.webSocketClosed'
    hashable = ['requestId']
    is_hashable = True

    def __init__(self,
                 requestId: Union['RequestId', dict],
                 timestamp: Union['MonotonicTime', dict],
                 ):
        if isinstance(requestId, dict):
            requestId = RequestId(**requestId)
        self.requestId = requestId
        if isinstance(timestamp, dict):
            timestamp = MonotonicTime(**timestamp)
        self.timestamp = timestamp

    @classmethod
    def build_hash(cls, requestId):
        kwargs = locals()
        kwargs.pop('cls')
        serialized_id_params = ','.join(['='.join([p, str(v)]) for p, v in kwargs.items()])
        h = '{}:{}'.format(cls.js_name, serialized_id_params)
        log.debug('generated hash = %s' % h)
        return h


class WebSocketCreatedEvent(BaseEvent):

    js_name = 'Network.webSocketCreated'
    hashable = ['requestId']
    is_hashable = True

    def __init__(self,
                 requestId: Union['RequestId', dict],
                 url: Union['str', dict],
                 initiator: Union['Initiator', dict, None] = None,
                 ):
        if isinstance(requestId, dict):
            requestId = RequestId(**requestId)
        self.requestId = requestId
        if isinstance(url, dict):
            url = str(**url)
        self.url = url
        if isinstance(initiator, dict):
            initiator = Initiator(**initiator)
        self.initiator = initiator

    @classmethod
    def build_hash(cls, requestId):
        kwargs = locals()
        kwargs.pop('cls')
        serialized_id_params = ','.join(['='.join([p, str(v)]) for p, v in kwargs.items()])
        h = '{}:{}'.format(cls.js_name, serialized_id_params)
        log.debug('generated hash = %s' % h)
        return h


class WebSocketFrameErrorEvent(BaseEvent):

    js_name = 'Network.webSocketFrameError'
    hashable = ['requestId']
    is_hashable = True

    def __init__(self,
                 requestId: Union['RequestId', dict],
                 timestamp: Union['MonotonicTime', dict],
                 errorMessage: Union['str', dict],
                 ):
        if isinstance(requestId, dict):
            requestId = RequestId(**requestId)
        self.requestId = requestId
        if isinstance(timestamp, dict):
            timestamp = MonotonicTime(**timestamp)
        self.timestamp = timestamp
        if isinstance(errorMessage, dict):
            errorMessage = str(**errorMessage)
        self.errorMessage = errorMessage

    @classmethod
    def build_hash(cls, requestId):
        kwargs = locals()
        kwargs.pop('cls')
        serialized_id_params = ','.join(['='.join([p, str(v)]) for p, v in kwargs.items()])
        h = '{}:{}'.format(cls.js_name, serialized_id_params)
        log.debug('generated hash = %s' % h)
        return h


class WebSocketFrameReceivedEvent(BaseEvent):

    js_name = 'Network.webSocketFrameReceived'
    hashable = ['requestId']
    is_hashable = True

    def __init__(self,
                 requestId: Union['RequestId', dict],
                 timestamp: Union['MonotonicTime', dict],
                 response: Union['WebSocketFrame', dict],
                 ):
        if isinstance(requestId, dict):
            requestId = RequestId(**requestId)
        self.requestId = requestId
        if isinstance(timestamp, dict):
            timestamp = MonotonicTime(**timestamp)
        self.timestamp = timestamp
        if isinstance(response, dict):
            response = WebSocketFrame(**response)
        self.response = response

    @classmethod
    def build_hash(cls, requestId):
        kwargs = locals()
        kwargs.pop('cls')
        serialized_id_params = ','.join(['='.join([p, str(v)]) for p, v in kwargs.items()])
        h = '{}:{}'.format(cls.js_name, serialized_id_params)
        log.debug('generated hash = %s' % h)
        return h


class WebSocketFrameSentEvent(BaseEvent):

    js_name = 'Network.webSocketFrameSent'
    hashable = ['requestId']
    is_hashable = True

    def __init__(self,
                 requestId: Union['RequestId', dict],
                 timestamp: Union['MonotonicTime', dict],
                 response: Union['WebSocketFrame', dict],
                 ):
        if isinstance(requestId, dict):
            requestId = RequestId(**requestId)
        self.requestId = requestId
        if isinstance(timestamp, dict):
            timestamp = MonotonicTime(**timestamp)
        self.timestamp = timestamp
        if isinstance(response, dict):
            response = WebSocketFrame(**response)
        self.response = response

    @classmethod
    def build_hash(cls, requestId):
        kwargs = locals()
        kwargs.pop('cls')
        serialized_id_params = ','.join(['='.join([p, str(v)]) for p, v in kwargs.items()])
        h = '{}:{}'.format(cls.js_name, serialized_id_params)
        log.debug('generated hash = %s' % h)
        return h


class WebSocketHandshakeResponseReceivedEvent(BaseEvent):

    js_name = 'Network.webSocketHandshakeResponseReceived'
    hashable = ['requestId']
    is_hashable = True

    def __init__(self,
                 requestId: Union['RequestId', dict],
                 timestamp: Union['MonotonicTime', dict],
                 response: Union['WebSocketResponse', dict],
                 ):
        if isinstance(requestId, dict):
            requestId = RequestId(**requestId)
        self.requestId = requestId
        if isinstance(timestamp, dict):
            timestamp = MonotonicTime(**timestamp)
        self.timestamp = timestamp
        if isinstance(response, dict):
            response = WebSocketResponse(**response)
        self.response = response

    @classmethod
    def build_hash(cls, requestId):
        kwargs = locals()
        kwargs.pop('cls')
        serialized_id_params = ','.join(['='.join([p, str(v)]) for p, v in kwargs.items()])
        h = '{}:{}'.format(cls.js_name, serialized_id_params)
        log.debug('generated hash = %s' % h)
        return h


class WebSocketWillSendHandshakeRequestEvent(BaseEvent):

    js_name = 'Network.webSocketWillSendHandshakeRequest'
    hashable = ['requestId']
    is_hashable = True

    def __init__(self,
                 requestId: Union['RequestId', dict],
                 timestamp: Union['MonotonicTime', dict],
                 wallTime: Union['TimeSinceEpoch', dict],
                 request: Union['WebSocketRequest', dict],
                 ):
        if isinstance(requestId, dict):
            requestId = RequestId(**requestId)
        self.requestId = requestId
        if isinstance(timestamp, dict):
            timestamp = MonotonicTime(**timestamp)
        self.timestamp = timestamp
        if isinstance(wallTime, dict):
            wallTime = TimeSinceEpoch(**wallTime)
        self.wallTime = wallTime
        if isinstance(request, dict):
            request = WebSocketRequest(**request)
        self.request = request

    @classmethod
    def build_hash(cls, requestId):
        kwargs = locals()
        kwargs.pop('cls')
        serialized_id_params = ','.join(['='.join([p, str(v)]) for p, v in kwargs.items()])
        h = '{}:{}'.format(cls.js_name, serialized_id_params)
        log.debug('generated hash = %s' % h)
        return h


class RequestWillBeSentExtraInfoEvent(BaseEvent):

    js_name = 'Network.requestWillBeSentExtraInfo'
    hashable = ['requestId']
    is_hashable = True

    def __init__(self,
                 requestId: Union['RequestId', dict],
                 blockedCookies: Union['[BlockedCookieWithReason]', dict],
                 headers: Union['Headers', dict],
                 ):
        if isinstance(requestId, dict):
            requestId = RequestId(**requestId)
        self.requestId = requestId
        if isinstance(blockedCookies, dict):
            blockedCookies = [BlockedCookieWithReason](**blockedCookies)
        self.blockedCookies = blockedCookies
        if isinstance(headers, dict):
            headers = Headers(**headers)
        self.headers = headers

    @classmethod
    def build_hash(cls, requestId):
        kwargs = locals()
        kwargs.pop('cls')
        serialized_id_params = ','.join(['='.join([p, str(v)]) for p, v in kwargs.items()])
        h = '{}:{}'.format(cls.js_name, serialized_id_params)
        log.debug('generated hash = %s' % h)
        return h


class ResponseReceivedExtraInfoEvent(BaseEvent):

    js_name = 'Network.responseReceivedExtraInfo'
    hashable = ['requestId']
    is_hashable = True

    def __init__(self,
                 requestId: Union['RequestId', dict],
                 blockedCookies: Union['[BlockedSetCookieWithReason]', dict],
                 headers: Union['Headers', dict],
                 headersText: Union['str', dict, None] = None,
                 ):
        if isinstance(requestId, dict):
            requestId = RequestId(**requestId)
        self.requestId = requestId
        if isinstance(blockedCookies, dict):
            blockedCookies = [BlockedSetCookieWithReason](**blockedCookies)
        self.blockedCookies = blockedCookies
        if isinstance(headers, dict):
            headers = Headers(**headers)
        self.headers = headers
        if isinstance(headersText, dict):
            headersText = str(**headersText)
        self.headersText = headersText

    @classmethod
    def build_hash(cls, requestId):
        kwargs = locals()
        kwargs.pop('cls')
        serialized_id_params = ','.join(['='.join([p, str(v)]) for p, v in kwargs.items()])
        h = '{}:{}'.format(cls.js_name, serialized_id_params)
        log.debug('generated hash = %s' % h)
        return h
