# noinspection PyPep8
# noinspection PyArgumentList

"""
AUTO-GENERATED BY `scripts/generate_protocol.py` using `data/browser_protocol.json`
and `data/js_protocol.json` as inputs! Please do not modify this file.
"""

import logging
from typing import Any, Optional, Union

from chromewhip.helpers import PayloadMixin, BaseEvent, ChromeTypeBase

log = logging.getLogger(__name__)

# PressureLevel: Memory pressure level.
PressureLevel = str

# SamplingProfileNode: Heap profile sample.
class SamplingProfileNode(ChromeTypeBase):
    def __init__(self,
                 size: Union['float'],
                 total: Union['float'],
                 stack: Union['[]'],
                 ):

        self.size = size
        self.total = total
        self.stack = stack


# SamplingProfile: Array of heap profile samples.
class SamplingProfile(ChromeTypeBase):
    def __init__(self,
                 samples: Union['[SamplingProfileNode]'],
                 modules: Union['[Module]'],
                 ):

        self.samples = samples
        self.modules = modules


# Module: Executable module information
class Module(ChromeTypeBase):
    def __init__(self,
                 name: Union['str'],
                 uuid: Union['str'],
                 baseAddress: Union['str'],
                 size: Union['float'],
                 ):

        self.name = name
        self.uuid = uuid
        self.baseAddress = baseAddress
        self.size = size


class Memory(PayloadMixin):
    """ 
    """
    @classmethod
    def getDOMCounters(cls):
        """
        """
        return (
            cls.build_send_payload("getDOMCounters", {
            }),
            cls.convert_payload({
                "documents": {
                    "class": int,
                    "optional": False
                },
                "nodes": {
                    "class": int,
                    "optional": False
                },
                "jsEventListeners": {
                    "class": int,
                    "optional": False
                },
            })
        )

    @classmethod
    def prepareForLeakDetection(cls):
        """
        """
        return (
            cls.build_send_payload("prepareForLeakDetection", {
            }),
            None
        )

    @classmethod
    def forciblyPurgeJavaScriptMemory(cls):
        """Simulate OomIntervention by purging V8 memory.
        """
        return (
            cls.build_send_payload("forciblyPurgeJavaScriptMemory", {
            }),
            None
        )

    @classmethod
    def setPressureNotificationsSuppressed(cls,
                                           suppressed: Union['bool'],
                                           ):
        """Enable/disable suppressing memory pressure notifications in all processes.
        :param suppressed: If true, memory pressure notifications will be suppressed.
        :type suppressed: bool
        """
        return (
            cls.build_send_payload("setPressureNotificationsSuppressed", {
                "suppressed": suppressed,
            }),
            None
        )

    @classmethod
    def simulatePressureNotification(cls,
                                     level: Union['PressureLevel'],
                                     ):
        """Simulate a memory pressure notification in all processes.
        :param level: Memory pressure level of the notification.
        :type level: PressureLevel
        """
        return (
            cls.build_send_payload("simulatePressureNotification", {
                "level": level,
            }),
            None
        )

    @classmethod
    def startSampling(cls,
                      samplingInterval: Optional['int'] = None,
                      suppressRandomness: Optional['bool'] = None,
                      ):
        """Start collecting native memory profile.
        :param samplingInterval: Average number of bytes between samples.
        :type samplingInterval: int
        :param suppressRandomness: Do not randomize intervals between samples.
        :type suppressRandomness: bool
        """
        return (
            cls.build_send_payload("startSampling", {
                "samplingInterval": samplingInterval,
                "suppressRandomness": suppressRandomness,
            }),
            None
        )

    @classmethod
    def stopSampling(cls):
        """Stop collecting native memory profile.
        """
        return (
            cls.build_send_payload("stopSampling", {
            }),
            None
        )

    @classmethod
    def getAllTimeSamplingProfile(cls):
        """Retrieve native memory allocations profile
collected since renderer process startup.
        """
        return (
            cls.build_send_payload("getAllTimeSamplingProfile", {
            }),
            cls.convert_payload({
                "profile": {
                    "class": SamplingProfile,
                    "optional": False
                },
            })
        )

    @classmethod
    def getBrowserSamplingProfile(cls):
        """Retrieve native memory allocations profile
collected since browser process startup.
        """
        return (
            cls.build_send_payload("getBrowserSamplingProfile", {
            }),
            cls.convert_payload({
                "profile": {
                    "class": SamplingProfile,
                    "optional": False
                },
            })
        )

    @classmethod
    def getSamplingProfile(cls):
        """Retrieve native memory allocations profile collected since last
`startSampling` call.
        """
        return (
            cls.build_send_payload("getSamplingProfile", {
            }),
            cls.convert_payload({
                "profile": {
                    "class": SamplingProfile,
                    "optional": False
                },
            })
        )

