Библиотека выполняет конвертацию строки cron-формата в набор объектов datetime


|   п | Блок       |  Формат      |           Описание            |    Пример    |                    Пояснение                     |
|----:|------------|:------------:|:-----------------------------:|:------------:|:------------------------------------------------:|
|   1 | секунды    |      *       |    Все возможные значения     |      *       |       Даты сгенерируются на каждую секунду       |
|   2 |            |      ,       | Только перечисленные значения |  1,2,3,4,5   |        Каждую минуту в 1,2,3,4 и 5 секунд        |
|   3 |            |      -       |    Все значения диапазона     |     1-3      |          Каждую минуту в 1,2 и 3 секунд          |
|   4 |            |      /       | Каждое значение с инкрементом |     */5      | Каждую минуту c интервалом в 0,5,10,..,55 секунд |
|   5 |            |              |                               |     X/5      |      X - точка отсчета, логика как в п. 4*       |
|   6 | минуты     | п. 1,2,3,4,5 |         п. 1,2,3,4,5          | п. 1,2,3,4,5 |                   п. 1,2,3,4,5                   |
|   7 | часы       | п. 1,2,3,4,5 |         п. 1,2,3,4,5          | п. 1,2,3,4,5 |                   п. 1,2,3,4,5                   |
|   8 | дни месяца | п. 1,2,3,4,5 |         п. 1,2,3,4,5          | п. 1,2,3,4,5 |                   п. 1,2,3,4,5                   |
|   9 |            |      L       |     Последний день месяца     |      L       |       Последний день из указанных месяцев        |
|  10 | месяцы     | п. 1,2,3,4,5 |         п. 1,2,3,4,5          | п. 1,2,3,4,5 |                   п. 1,2,3,4,5                   |
|  11 | дни недели | п. 1,2,3,4,5 |         п. 1,2,3,4,5          | п. 1,2,3,4,5 |                   п. 1,2,3,4,5                   |
|  12 |            |      L       |   Последняя неделя месяца     |      L       |       Все дни месяца на последней неделе**       |
|  13 |            |      XL      | Последний день недели месяца  |      5L      |             Последняя пятница месяца             |
|  14 |            |      #       |        Итератор недель        |     5#2      |             Во вторую пятницу месяца             |
|  15 | годы       | п. 1,2,3,4,5 |         п. 1,2,3,4,5          | п. 1,2,3,4,5 |                   п. 1,2,3,4,5                   |

\* При использовании нескольких значений X (1,2,3 | 1-3) значение повторится один раз.\
Например:

* в блоке секунд указано "0,5/5" значения будут 0,5,10,15,...,55;
* в блоке секунд указано "0,1/2" значения будут 0,1,2,3,4,5,6,...,59.\

\** Месяц может занимать не всю неделю.\
  Например:
* август 2022 будет содержать "29,30,31" или "28,29,30,31"(если первый день недели воскресенье).

## Покрытие тестами (отметка у конкретного теста):

Секунды:
- [x] \*
- [x] \,
- [x] \-
- [x] \/
- [x] X\/
- [x] X

Минуты:
- [x] \*
- [x] \,
- [x] \-
- [x] \/
- [x] X\/
- [x] X

Часы:
- [x] \*
- [x] \,
- [x] \-
- [x] \/
- [x] X\/
- [x] X

Дни месяца:
- [x] \*
- [x] \,
- [x] \-
- [x] \/
- [x] X\/
- [x] L
- [x] X

Месяцы:
- [x] \* 
- [x] \,
- [x] \-
- [x] \/
- [x] X\/
- [x] X

Дни недели:
- [ ] \* - проводились в тестах дней месяца
- [x] \,
- [x] \-
- [x] \/
- [x] X\/
- [x] L
- [x] XL
- [x] \#
- [x] X

Годы:
- [ ] \* - проводились в тестах месяцев
- [x] \,
- [x] \-
- [x] \/
- [x] X\/
- [x] X