"""
Module: colors.py

This module provides functionality for working with a predefined list of named colors.
It includes methods to search for the closest color name given a hex value and to retrieve 
color information such as RGB and HEX values.

Classes:
    - ColorManager: Manages predefined color data and provides search functionality.

Methods:
    - ColorManager.__init__: Initializes the color manager with a predefined list of colors.
    - ColorManager.hex_to_rgb: Converts a hex color code to RGB.
    - ColorManager.rgb_to_hex: Converts RGB values to a hex color code.
    - ColorManager.closest_color_name: Finds the closest color name given a hex value.
    - ColorManager.get_color_by_name: Returns the hex and RGB values of a color based on its name.
"""


class ColorManager:
    """
    Manages a collection of predefined named colors and provides methods for color search
    and conversion between different color formats.

    Attributes:
        color_list (list): A predefined list of dictionaries containing 'hex' and 'name' keys.

    Methods:
        __init__(): Initializes the ColorManager with a predefined list of colors.
        hex_to_rgb(hex_value): Converts a hex color code to an RGB tuple.
        rgb_to_hex(r, g, b): Converts RGB values to a hex color code.
        closest_color_name(hex_value): Finds the closest color name to the given hex value.
        get_color_by_name(name): Returns the hex and RGB values of a color based on its name.
    """

    def __init__(self):
        """
        Initializes the ColorManager with a predefined list of color data.
        """

        self.color_list = [
            {"name": "Absolute zero", "hex": "#0048BA"},
            {"name": "Acid green", "hex": "#B0BF1A"},
            {"name": "Aero", "hex": "#7CB9E8"},
            {"name": "Aero blue", "hex": "#C9FFE5"},
            {"name": "African violet", "hex": "#B284BE"},
            {"name": "Air Force blue (RAF)", "hex": "#5D8AA8"},
            {"name": "Air Force blue (USAF)", "hex": "#00308F"},
            {"name": "Air superiority blue", "hex": "#72A0C1"},
            {"name": "Alabama crimson", "hex": "#AF002A"},
            {"name": "Alabaster", "hex": "#F2F0E6"},
            {"name": "Alice blue", "hex": "#F0F8FF"},
            {"name": "Alien Armpit", "hex": "#84DE02"},
            {"name": "Alizarin crimson", "hex": "#E32636"},
            {"name": "Alloy orange", "hex": "#C46210"},
            {"name": "Almond", "hex": "#EFDECD"},
            {"name": "Amaranth", "hex": "#E52B50"},
            {"name": "Amaranth deep purple", "hex": "#9F2B68"},
            {"name": "Amaranth pink", "hex": "#F19CBB"},
            {"name": "Amaranth purple", "hex": "#AB274F"},
            {"name": "Amaranth red", "hex": "#D3212D"},
            {"name": "Amazon", "hex": "#3B7A57"},
            {"name": "Amazonite", "hex": "#00C4B0"},
            {"name": "Amber", "hex": "#FFBF00"},
            {"name": "Amber (SAE/ECE)", "hex": "#FF7E00"},
            {"name": "American rose", "hex": "#FF033E"},
            {"name": "Amethyst", "hex": "#9966CC"},
            {"name": "Android green", "hex": "#A4C639"},
            {"name": "Anti-flash white", "hex": "#F2F3F4"},
            {"name": "Antique brass", "hex": "#CD9575"},
            {"name": "Antique bronze", "hex": "#665D1E"},
            {"name": "Antique fuchsia", "hex": "#915C83"},
            {"name": "Antique ruby", "hex": "#841B2D"},
            {"name": "Antique white", "hex": "#FAEBD7"},
            {"name": "Ao (English)", "hex": "#008000"},
            {"name": "Apple green", "hex": "#8DB600"},
            {"name": "Apricot", "hex": "#FBCEB1"},
            {"name": "Aqua", "hex": "#00FFFF"},
            {"name": "Aquamarine", "hex": "#7FFFD4"},
            {"name": "Arctic lime", "hex": "#D0FF14"},
            {"name": "Army green", "hex": "#4B5320"},
            {"name": "Arsenic", "hex": "#3B444B"},
            {"name": "Artichoke", "hex": "#8F9779"},
            {"name": "Arylide yellow", "hex": "#E9D66B"},
            {"name": "Ash grey", "hex": "#B2BEB5"},
            {"name": "Asparagus", "hex": "#87A96B"},
            {"name": "Atomic tangerine", "hex": "#FF9966"},
            {"name": "Auburn", "hex": "#A52A2A"},
            {"name": "Aureolin", "hex": "#FDEE00"},
            {"name": "AuroMetalSaurus", "hex": "#6E7F80"},
            {"name": "Avocado", "hex": "#568203"},
            {"name": "Awesome", "hex": "#FF2052"},
            {"name": "Aztec Gold", "hex": "#C39953"},
            {"name": "Azure", "hex": "#007FFF"},
            {"name": "Azure (web color)", "hex": "#F0FFFF"},
            {"name": "Azure mist", "hex": "#F0FFFF"},
            {"name": "Azureish white", "hex": "#DBE9F4"},
            {"name": "Baby blue", "hex": "#89CFF0"},
            {"name": "Baby blue eyes", "hex": "#A1CAF1"},
            {"name": "Baby pink", "hex": "#F4C2C2"},
            {"name": "Baby powder", "hex": "#FEFEFA"},
            {"name": "Baker-Miller pink", "hex": "#FF91AF"},
            {"name": "Ball blue", "hex": "#21ABCD"},
            {"name": "Banana Mania", "hex": "#FAE7B5"},
            {"name": "Banana yellow", "hex": "#FFE135"},
            {"name": "Bangladesh green", "hex": "#006A4E"},
            {"name": "Barbie pink", "hex": "#E0218A"},
            {"name": "Barn red", "hex": "#7C0A02"},
            {"name": "Battery Charged Blue", "hex": "#1DACD6"},
            {"name": "Battleship grey", "hex": "#848482"},
            {"name": "Bazaar", "hex": "#98777B"},
            {"name": "Beau blue", "hex": "#BCD4E6"},
            {"name": "Beaver", "hex": "#9F8170"},
            {"name": "Begonia", "hex": "#FA6E79"},
            {"name": "Beige", "hex": "#F5F5DC"},
            {"name": "B'dazzled blue", "hex": "#2E5894"},
            {"name": "Big dip o’ruby", "hex": "#9C2542"},
            {"name": "Big Foot Feet", "hex": "#E88E5A"},
            {"name": "Bisque", "hex": "#FFE4C4"},
            {"name": "Bistre", "hex": "#3D2B1F"},
            {"name": "Bistre brown", "hex": "#967117"},
            {"name": "Bitter lemon", "hex": "#CAE00D"},
            {"name": "Bitter lime", "hex": "#BFFF00"},
            {"name": "Bittersweet", "hex": "#FE6F5E"},
            {"name": "Bittersweet shimmer", "hex": "#BF4F51"},
            {"name": "Black", "hex": "#000000"},
            {"name": "Black bean", "hex": "#3D0C02"},
            {"name": "Black Coral", "hex": "#54626F"},
            {"name": "Black leather jacket", "hex": "#253529"},
            {"name": "Black olive", "hex": "#3B3C36"},
            {"name": "Black Shadows", "hex": "#BFAFB2"},
            {"name": "Blanched almond", "hex": "#FFEBCD"},
            {"name": "Blast-off bronze", "hex": "#A57164"},
            {"name": "Bleu de France", "hex": "#318CE7"},
            {"name": "Blizzard Blue", "hex": "#ACE5EE"},
            {"name": "Blond", "hex": "#FAF0BE"},
            {"name": "Blue", "hex": "#0000FF"},
            {"name": "Blue (Crayola)", "hex": "#1F75FE"},
            {"name": "Blue (Munsell)", "hex": "#0093AF"},
            {"name": "Blue (NCS)", "hex": "#0087BD"},
            {"name": "Blue (Pantone)", "hex": "#0018A8"},
            {"name": "Blue (pigment)", "hex": "#333399"},
            {"name": "Blue (RYB)", "hex": "#0247FE"},
            {"name": "Blue Bell", "hex": "#A2A2D0"},
            {"name": "Blue Bolt", "hex": "#00B9FB"},
            {"name": "Blue-gray", "hex": "#6699CC"},
            {"name": "Blue-green", "hex": "#0D98BA"},
            {"name": "Blue Jeans", "hex": "#5DADEC"},
            {"name": "Blue Lagoon", "hex": "#ACE5EE"},
            {"name": "Blue-magenta violet", "hex": "#553592"},
            {"name": "Blue sapphire", "hex": "#126180"},
            {"name": "Blue-violet", "hex": "#8A2BE2"},
            {"name": "Blue yonder", "hex": "#5072A7"},
            {"name": "Blueberry", "hex": "#4F86F7"},
            {"name": "Bluebonnet", "hex": "#1C1CF0"},
            {"name": "Blush", "hex": "#DE5D83"},
            {"name": "Bole", "hex": "#79443B"},
            {"name": "Bondi blue", "hex": "#0095B6"},
            {"name": "Bone", "hex": "#E3DAC9"},
            {"name": "Booger Buster", "hex": "#DDE26A"},
            {"name": "Boston University Red", "hex": "#CC0000"},
            {"name": "Bottle green", "hex": "#006A4E"},
            {"name": "Boysenberry", "hex": "#873260"},
            {"name": "Brandeis blue", "hex": "#0070FF"},
            {"name": "Brass", "hex": "#B5A642"},
            {"name": "Brick red", "hex": "#CB4154"},
            {"name": "Bright cerulean", "hex": "#1DACD6"},
            {"name": "Bright green", "hex": "#66FF00"},
            {"name": "Bright lavender", "hex": "#BF94E4"},
            {"name": "Bright lilac", "hex": "#D891EF"},
            {"name": "Bright maroon", "hex": "#C32148"},
            {"name": "Bright navy blue", "hex": "#1974D2"},
            {"name": "Bright pink", "hex": "#FF007F"},
            {"name": "Bright turquoise", "hex": "#08E8DE"},
            {"name": "Bright ube", "hex": "#D19FE8"},
            {"name": "Bright Yellow (Crayola)", "hex": "#FFAA1D"},
            {"name": "Brilliant azure", "hex": "#3399FF"},
            {"name": "Brilliant lavender", "hex": "#F4BBFF"},
            {"name": "Brilliant rose", "hex": "#FF55A3"},
            {"name": "Brink pink", "hex": "#FB607F"},
            {"name": "British racing green", "hex": "#004225"},
            {"name": "Bronze", "hex": "#CD7F32"},
            {"name": "Bronze Yellow", "hex": "#737000"},
            {"name": "Brown (traditional)", "hex": "#964B00"},
            {"name": "Brown (web)", "hex": "#A52A2A"},
            {"name": "Brown-nose", "hex": "#6B4423"},
            {"name": "Brown Sugar", "hex": "#AF6E4D"},
            {"name": "Brown Yellow", "hex": "#cc9966"},
            {"name": "Brunswick green", "hex": "#1B4D3E"},
            {"name": "Bubble gum", "hex": "#FFC1CC"},
            {"name": "Bubbles", "hex": "#E7FEFF"},
            {"name": "Bud green", "hex": "#7BB661"},
            {"name": "Buff", "hex": "#F0DC82"},
            {"name": "Bulgarian rose", "hex": "#480607"},
            {"name": "Burgundy", "hex": "#800020"},
            {"name": "Burlywood", "hex": "#DEB887"},
            {"name": "Burnished Brown", "hex": "#A17A74"},
            {"name": "Burnt orange", "hex": "#CC5500"},
            {"name": "Burnt sienna", "hex": "#E97451"},
            {"name": "Burnt umber", "hex": "#8A3324"},
            {"name": "Byzantine", "hex": "#BD33A4"},
            {"name": "Byzantium", "hex": "#702963"},
            {"name": "Cadet", "hex": "#536872"},
            {"name": "Cadet blue", "hex": "#5F9EA0"},
            {"name": "Cadet grey", "hex": "#91A3B0"},
            {"name": "Cadmium green", "hex": "#006B3C"},
            {"name": "Cadmium orange", "hex": "#ED872D"},
            {"name": "Cadmium red", "hex": "#E30022"},
            {"name": "Cadmium yellow", "hex": "#FFF600"},
            {"name": "Café au lait", "hex": "#A67B5B"},
            {"name": "Café noir", "hex": "#4B3621"},
            {"name": "Cal Poly Pomona green", "hex": "#1E4D2B"},
            {"name": "Cambridge Blue", "hex": "#A3C1AD"},
            {"name": "Camel", "hex": "#C19A6B"},
            {"name": "Cameo pink", "hex": "#EFBBCC"},
            {"name": "Camouflage green", "hex": "#78866B"},
            {"name": "Canary", "hex": "#FFFF99"},
            {"name": "Canary yellow", "hex": "#FFEF00"},
            {"name": "Candy apple red", "hex": "#FF0800"},
            {"name": "Candy pink", "hex": "#E4717A"},
            {"name": "Capri", "hex": "#00BFFF"},
            {"name": "Caput mortuum", "hex": "#592720"},
            {"name": "Cardinal", "hex": "#C41E3A"},
            {"name": "Caribbean green", "hex": "#00CC99"},
            {"name": "Carmine", "hex": "#960018"},
            {"name": "Carmine (M&P)", "hex": "#D70040"},
            {"name": "Carmine pink", "hex": "#EB4C42"},
            {"name": "Carmine red", "hex": "#FF0038"},
            {"name": "Carnation pink", "hex": "#FFA6C9"},
            {"name": "Carnelian", "hex": "#B31B1B"},
            {"name": "Carolina blue", "hex": "#56A0D3"},
            {"name": "Carrot orange", "hex": "#ED9121"},
            {"name": "Castleton green", "hex": "#00563F"},
            {"name": "Catalina blue", "hex": "#062A78"},
            {"name": "Catawba", "hex": "#703642"},
            {"name": "Cedar Chest", "hex": "#C95A49"},
            {"name": "Ceil", "hex": "#92A1CF"},
            {"name": "Celadon", "hex": "#ACE1AF"},
            {"name": "Celadon blue", "hex": "#007BA7"},
            {"name": "Celadon green", "hex": "#2F847C"},
            {"name": "Celeste", "hex": "#B2FFFF"},
            {"name": "Celestial blue", "hex": "#4997D0"},
            {"name": "Cerise", "hex": "#DE3163"},
            {"name": "Cerise pink", "hex": "#EC3B83"},
            {"name": "Cerulean", "hex": "#007BA7"},
            {"name": "Cerulean blue", "hex": "#2A52BE"},
            {"name": "Cerulean frost", "hex": "#6D9BC3"},
            {"name": "CG Blue", "hex": "#007AA5"},
            {"name": "CG Red", "hex": "#E03C31"},
            {"name": "Chamoisee", "hex": "#A0785A"},
            {"name": "Champagne", "hex": "#F7E7CE"},
            {"name": "Champagne pink", "hex": "#F1DDCF"},
            {"name": "Charcoal", "hex": "#36454F"},
            {"name": "Charleston green", "hex": "#232B2B"},
            {"name": "Charm pink", "hex": "#E68FAC"},
            {"name": "Chartreuse (traditional)", "hex": "#DFFF00"},
            {"name": "Chartreuse (web)", "hex": "#7FFF00"},
            {"name": "Cherry", "hex": "#DE3163"},
            {"name": "Cherry blossom pink", "hex": "#FFB7C5"},
            {"name": "Chestnut", "hex": "#954535"},
            {"name": "China pink", "hex": "#DE6FA1"},
            {"name": "China rose", "hex": "#A8516E"},
            {"name": "Chinese red", "hex": "#AA381E"},
            {"name": "Chinese violet", "hex": "#856088"},
            {"name": "Chlorophyll green", "hex": "#4AFF00"},
            {"name": "Chocolate (traditional)", "hex": "#7B3F00"},
            {"name": "Chocolate (web)", "hex": "#D2691E"},
            {"name": "Chrome yellow", "hex": "#FFA700"},
            {"name": "Cinereous", "hex": "#98817B"},
            {"name": "Cinnabar", "hex": "#E34234"},
            {"name": "Cinnamon[citation needed]", "hex": "#D2691E"},
            {"name": "Cinnamon Satin", "hex": "#CD607E"},
            {"name": "Citrine", "hex": "#E4D00A"},
            {"name": "Citron", "hex": "#9FA91F"},
            {"name": "Claret", "hex": "#7F1734"},
            {"name": "Classic rose", "hex": "#FBCCE7"},
            {"name": "Cobalt Blue", "hex": "#0047AB"},
            {"name": "Cocoa brown", "hex": "#D2691E"},
            {"name": "Coconut", "hex": "#965A3E"},
            {"name": "Coffee", "hex": "#6F4E37"},
            {"name": "Columbia Blue", "hex": "#C4D8E2"},
            {"name": "Congo pink", "hex": "#F88379"},
            {"name": "Cool Black", "hex": "#002E63"},
            {"name": "Cool grey", "hex": "#8C92AC"},
            {"name": "Copper", "hex": "#B87333"},
            {"name": "Copper (Crayola)", "hex": "#DA8A67"},
            {"name": "Copper penny", "hex": "#AD6F69"},
            {"name": "Copper red", "hex": "#CB6D51"},
            {"name": "Copper rose", "hex": "#996666"},
            {"name": "Coquelicot", "hex": "#FF3800"},
            {"name": "Coral", "hex": "#FF7F50"},
            {"name": "Coral pink", "hex": "#F88379"},
            {"name": "Coral red", "hex": "#FF4040"},
            {"name": "Coral Reef", "hex": "#FD7C6E"},
            {"name": "Cordovan", "hex": "#893F45"},
            {"name": "Corn", "hex": "#FBEC5D"},
            {"name": "Cornell Red", "hex": "#B31B1B"},
            {"name": "Cornflower blue", "hex": "#6495ED"},
            {"name": "Cornsilk", "hex": "#FFF8DC"},
            {"name": "Cosmic Cobalt", "hex": "#2E2D88"},
            {"name": "Cosmic latte", "hex": "#FFF8E7"},
            {"name": "Coyote brown", "hex": "#81613C"},
            {"name": "Cotton candy", "hex": "#FFBCD9"},
            {"name": "Cream", "hex": "#FFFDD0"},
            {"name": "Crimson", "hex": "#DC143C"},
            {"name": "Crimson glory", "hex": "#BE0032"},
            {"name": "Crimson red", "hex": "#990000"},
            {"name": "Cultured", "hex": "#F5F5F5"},
            {"name": "Cyan", "hex": "#00FFFF"},
            {"name": "Cyan azure", "hex": "#4E82B4"},
            {"name": "Cyan-blue azure", "hex": "#4682BF"},
            {"name": "Cyan cobalt blue", "hex": "#28589C"},
            {"name": "Cyan cornflower blue", "hex": "#188BC2"},
            {"name": "Cyan (process)", "hex": "#00B7EB"},
            {"name": "Cyber grape", "hex": "#58427C"},
            {"name": "Cyber yellow", "hex": "#FFD300"},
            {"name": "Cyclamen", "hex": "#F56FA1"},
            {"name": "Daffodil", "hex": "#FFFF31"},
            {"name": "Dandelion", "hex": "#F0E130"},
            {"name": "Dark blue", "hex": "#00008B"},
            {"name": "Dark blue-gray", "hex": "#666699"},
            {"name": "Dark brown", "hex": "#654321"},
            {"name": "Dark brown-tangelo", "hex": "#88654E"},
            {"name": "Dark byzantium", "hex": "#5D3954"},
            {"name": "Dark candy apple red", "hex": "#A40000"},
            {"name": "Dark cerulean", "hex": "#08457E"},
            {"name": "Dark chestnut", "hex": "#986960"},
            {"name": "Dark coral", "hex": "#CD5B45"},
            {"name": "Dark cyan", "hex": "#008B8B"},
            {"name": "Dark electric blue", "hex": "#536878"},
            {"name": "Dark goldenrod", "hex": "#B8860B"},
            {"name": "Dark gray (X11)", "hex": "#A9A9A9"},
            {"name": "Dark green", "hex": "#013220"},
            {"name": "Dark green (X11)", "hex": "#006400"},
            {"name": "Dark gunmetal", "hex": "#1F262A"},
            {"name": "Dark imperial blue", "hex": "#00416A"},
            {"name": "Dark imperial blue", "hex": "#00147E"},
            {"name": "Dark jungle green", "hex": "#1A2421"},
            {"name": "Dark khaki", "hex": "#BDB76B"},
            {"name": "Dark lava", "hex": "#483C32"},
            {"name": "Dark lavender", "hex": "#734F96"},
            {"name": "Dark liver", "hex": "#534B4F"},
            {"name": "Dark liver (horses)", "hex": "#543D37"},
            {"name": "Dark magenta", "hex": "#8B008B"},
            {"name": "Dark medium gray", "hex": "#A9A9A9"},
            {"name": "Dark midnight blue", "hex": "#003366"},
            {"name": "Dark moss green", "hex": "#4A5D23"},
            {"name": "Dark olive green", "hex": "#556B2F"},
            {"name": "Dark orange", "hex": "#FF8C00"},
            {"name": "Dark orchid", "hex": "#9932CC"},
            {"name": "Dark pastel blue", "hex": "#779ECB"},
            {"name": "Dark pastel green", "hex": "#03C03C"},
            {"name": "Dark pastel purple", "hex": "#966FD6"},
            {"name": "Dark pastel red", "hex": "#C23B22"},
            {"name": "Dark pink", "hex": "#E75480"},
            {"name": "Dark powder blue", "hex": "#003399"},
            {"name": "Dark puce", "hex": "#4F3A3C"},
            {"name": "Dark purple", "hex": "#301934"},
            {"name": "Dark raspberry", "hex": "#872657"},
            {"name": "Dark red", "hex": "#8B0000"},
            {"name": "Dark salmon", "hex": "#E9967A"},
            {"name": "Dark scarlet", "hex": "#560319"},
            {"name": "Dark sea green", "hex": "#8FBC8F"},
            {"name": "Dark sienna", "hex": "#3C1414"},
            {"name": "Dark sky blue", "hex": "#8CBED6"},
            {"name": "Dark slate blue", "hex": "#483D8B"},
            {"name": "Dark slate gray", "hex": "#2F4F4F"},
            {"name": "Dark spring green", "hex": "#177245"},
            {"name": "Dark tan", "hex": "#918151"},
            {"name": "Dark tangerine", "hex": "#FFA812"},
            {"name": "Dark taupe", "hex": "#483C32"},
            {"name": "Dark terra cotta", "hex": "#CC4E5C"},
            {"name": "Dark turquoise", "hex": "#00CED1"},
            {"name": "Dark vanilla", "hex": "#D1BEA8"},
            {"name": "Dark violet", "hex": "#9400D3"},
            {"name": "Dark yellow", "hex": "#9B870C"},
            {"name": "Dartmouth green", "hex": "#00703C"},
            {"name": "Davy's grey", "hex": "#555555"},
            {"name": "Debian red", "hex": "#D70A53"},
            {"name": "Deep aquamarine", "hex": "#40826D"},
            {"name": "Deep carmine", "hex": "#A9203E"},
            {"name": "Deep carmine pink", "hex": "#EF3038"},
            {"name": "Deep carrot orange", "hex": "#E9692C"},
            {"name": "Deep cerise", "hex": "#DA3287"},
            {"name": "Deep champagne", "hex": "#FAD6A5"},
            {"name": "Deep chestnut", "hex": "#B94E48"},
            {"name": "Deep coffee", "hex": "#704241"},
            {"name": "Deep fuchsia", "hex": "#C154C1"},
            {"name": "Deep Green", "hex": "#056608"},
            {"name": "Deep green-cyan turquoise", "hex": "#0E7C61"},
            {"name": "Deep jungle green", "hex": "#004B49"},
            {"name": "Deep koamaru", "hex": "#333366"},
            {"name": "Deep lemon", "hex": "#F5C71A"},
            {"name": "Deep lilac", "hex": "#9955BB"},
            {"name": "Deep magenta", "hex": "#CC00CC"},
            {"name": "Deep maroon", "hex": "#820000"},
            {"name": "Deep mauve", "hex": "#D473D4"},
            {"name": "Deep moss green", "hex": "#355E3B"},
            {"name": "Deep peach", "hex": "#FFCBA4"},
            {"name": "Deep pink", "hex": "#FF1493"},
            {"name": "Deep puce", "hex": "#A95C68"},
            {"name": "Deep Red", "hex": "#850101"},
            {"name": "Deep ruby", "hex": "#843F5B"},
            {"name": "Deep saffron", "hex": "#FF9933"},
            {"name": "Deep sky blue", "hex": "#00BFFF"},
            {"name": "Deep Space Sparkle", "hex": "#4A646C"},
            {"name": "Deep spring bud", "hex": "#556B2F"},
            {"name": "Deep Taupe", "hex": "#7E5E60"},
            {"name": "Deep Tuscan red", "hex": "#66424D"},
            {"name": "Deep violet", "hex": "#330066"},
            {"name": "Deer", "hex": "#BA8759"},
            {"name": "Denim", "hex": "#1560BD"},
            {"name": "Denim Blue", "hex": "#2243B6"},
            {"name": "Desaturated cyan", "hex": "#669999"},
            {"name": "Desert", "hex": "#C19A6B"},
            {"name": "Desert sand", "hex": "#EDC9AF"},
            {"name": "Desire", "hex": "#EA3C53"},
            {"name": "Diamond", "hex": "#B9F2FF"},
            {"name": "Dim gray", "hex": "#696969"},
            {"name": "Dingy Dungeon", "hex": "#C53151"},
            {"name": "Dirt", "hex": "#9B7653"},
            {"name": "Dodger blue", "hex": "#1E90FF"},
            {"name": "Dogwood rose", "hex": "#D71868"},
            {"name": "Dollar bill", "hex": "#85BB65"},
            {"name": "Dolphin Gray", "hex": "#828E84"},
            {"name": "Donkey brown", "hex": "#664C28"},
            {"name": "Drab", "hex": "#967117"},
            {"name": "Duke blue", "hex": "#00009C"},
            {"name": "Dust storm", "hex": "#E5CCC9"},
            {"name": "Dutch white", "hex": "#EFDFBB"},
            {"name": "Earth yellow", "hex": "#E1A95F"},
            {"name": "Ebony", "hex": "#555D50"},
            {"name": "Ecru", "hex": "#C2B280"},
            {"name": "Eerie black", "hex": "#1B1B1B"},
            {"name": "Eggplant", "hex": "#614051"},
            {"name": "Eggshell", "hex": "#F0EAD6"},
            {"name": "Egyptian blue", "hex": "#1034A6"},
            {"name": "Electric blue", "hex": "#7DF9FF"},
            {"name": "Electric crimson", "hex": "#FF003F"},
            {"name": "Electric cyan", "hex": "#00FFFF"},
            {"name": "Electric green", "hex": "#00FF00"},
            {"name": "Electric indigo", "hex": "#6F00FF"},
            {"name": "Electric lavender", "hex": "#F4BBFF"},
            {"name": "Electric lime", "hex": "#CCFF00"},
            {"name": "Electric purple", "hex": "#BF00FF"},
            {"name": "Electric ultramarine", "hex": "#3F00FF"},
            {"name": "Electric violet", "hex": "#8F00FF"},
            {"name": "Electric yellow", "hex": "#FFFF33"},
            {"name": "Emerald", "hex": "#50C878"},
            {"name": "Eminence", "hex": "#6C3082"},
            {"name": "English green", "hex": "#1B4D3E"},
            {"name": "English lavender", "hex": "#B48395"},
            {"name": "English red", "hex": "#AB4B52"},
            {"name": "English vermillion", "hex": "#CC474B"},
            {"name": "English violet", "hex": "#563C5C"},
            {"name": "Eton blue", "hex": "#96C8A2"},
            {"name": "Eucalyptus", "hex": "#44D7A8"},
            {"name": "Fallow", "hex": "#C19A6B"},
            {"name": "Falu red", "hex": "#801818"},
            {"name": "Fandango", "hex": "#B53389"},
            {"name": "Fandango pink", "hex": "#DE5285"},
            {"name": "Fashion fuchsia", "hex": "#F400A1"},
            {"name": "Fawn", "hex": "#E5AA70"},
            {"name": "Feldgrau", "hex": "#4D5D53"},
            {"name": "Feldspar", "hex": "#FDD5B1"},
            {"name": "Fern green", "hex": "#4F7942"},
            {"name": "Ferrari Red", "hex": "#FF2800"},
            {"name": "Field drab", "hex": "#6C541E"},
            {"name": "Fiery Rose", "hex": "#FF5470"},
            {"name": "Firebrick", "hex": "#B22222"},
            {"name": "Fire engine red", "hex": "#CE2029"},
            {"name": "Flame", "hex": "#E25822"},
            {"name": "Flamingo pink", "hex": "#FC8EAC"},
            {"name": "Flattery", "hex": "#6B4423"},
            {"name": "Flavescent", "hex": "#F7E98E"},
            {"name": "Flax", "hex": "#EEDC82"},
            {"name": "Flirt", "hex": "#A2006D"},
            {"name": "Floral white", "hex": "#FFFAF0"},
            {"name": "Fluorescent orange", "hex": "#FFBF00"},
            {"name": "Fluorescent pink", "hex": "#FF1493"},
            {"name": "Fluorescent yellow", "hex": "#CCFF00"},
            {"name": "Folly", "hex": "#FF004F"},
            {"name": "Forest green (traditional)", "hex": "#014421"},
            {"name": "Forest green (web)", "hex": "#228B22"},
            {"name": "French beige", "hex": "#A67B5B"},
            {"name": "French bistre", "hex": "#856D4D"},
            {"name": "French blue", "hex": "#0072BB"},
            {"name": "French fuchsia", "hex": "#FD3F92"},
            {"name": "French lilac", "hex": "#86608E"},
            {"name": "French lime", "hex": "#9EFD38"},
            {"name": "French mauve", "hex": "#D473D4"},
            {"name": "French pink", "hex": "#FD6C9E"},
            {"name": "French plum", "hex": "#811453"},
            {"name": "French puce", "hex": "#4E1609"},
            {"name": "French raspberry", "hex": "#C72C48"},
            {"name": "French rose", "hex": "#F64A8A"},
            {"name": "French sky blue", "hex": "#77B5FE"},
            {"name": "French violet", "hex": "#8806CE"},
            {"name": "French wine", "hex": "#AC1E44"},
            {"name": "Fresh Air", "hex": "#A6E7FF"},
            {"name": "Frostbite", "hex": "#E936A7"},
            {"name": "Fuchsia", "hex": "#FF00FF"},
            {"name": "Fuchsia (Crayola)", "hex": "#C154C1"},
            {"name": "Fuchsia pink", "hex": "#FF77FF"},
            {"name": "Fuchsia purple", "hex": "#CC397B"},
            {"name": "Fuchsia rose", "hex": "#C74375"},
            {"name": "Fulvous", "hex": "#E48400"},
            {"name": "Fuzzy Wuzzy", "hex": "#CC6666"},
            {"name": "Gainsboro", "hex": "#DCDCDC"},
            {"name": "Gamboge", "hex": "#E49B0F"},
            {"name": "Gamboge orange (brown)", "hex": "#996600"},
            {"name": "Gargoyle Gas", "hex": "#FFDF46"},
            {"name": "Generic viridian", "hex": "#007F66"},
            {"name": "Ghost white", "hex": "#F8F8FF"},
            {"name": "Giant's Club", "hex": "#B05C52"},
            {"name": "Giants orange", "hex": "#FE5A1D"},
            {"name": "Ginger", "hex": "#B06500"},
            {"name": "Glaucous", "hex": "#6082B6"},
            {"name": "Glitter", "hex": "#E6E8FA"},
            {"name": "Glossy Grape", "hex": "#AB92B3"},
            {"name": "GO green", "hex": "#00AB66"},
            {"name": "Gold (metallic)", "hex": "#D4AF37"},
            {"name": "Gold (web) (Golden)", "hex": "#FFD700"},
            {"name": "Gold Fusion", "hex": "#85754E"},
            {"name": "Golden brown", "hex": "#996515"},
            {"name": "Golden poppy", "hex": "#FCC200"},
            {"name": "Golden yellow", "hex": "#FFDF00"},
            {"name": "Goldenrod", "hex": "#DAA520"},
            {"name": "Granite Gray", "hex": "#676767"},
            {"name": "Granny Smith Apple", "hex": "#A8E4A0"},
            {"name": "Grape", "hex": "#6F2DA8"},
            {"name": "Gray", "hex": "#808080"},
            {"name": "Gray (HTML/CSS gray)", "hex": "#808080"},
            {"name": "Gray (X11 gray)", "hex": "#BEBEBE"},
            {"name": "Gray-asparagus", "hex": "#465945"},
            {"name": "Gray-blue", "hex": "#8C92AC"},
            {"name": "Green (Color Wheel) (X11 green)", "hex": "#00FF00"},
            {"name": "Green (Crayola)", "hex": "#1CAC78"},
            {"name": "Green (HTML/CSS color)", "hex": "#008000"},
            {"name": "Green (Munsell)", "hex": "#00A877"},
            {"name": "Green (NCS)", "hex": "#009F6B"},
            {"name": "Green (Pantone)", "hex": "#00AD43"},
            {"name": "Green (pigment)", "hex": "#00A550"},
            {"name": "Green (RYB)", "hex": "#66B032"},
            {"name": "Green-blue", "hex": "#1164B4"},
            {"name": "Green-cyan", "hex": "#009966"},
            {"name": "Green Lizard", "hex": "#A7F432"},
            {"name": "Green Sheen", "hex": "#6EAEA1"},
            {"name": "Green-yellow", "hex": "#ADFF2F"},
            {"name": "Grizzly", "hex": "#885818"},
            {"name": "Grullo", "hex": "#A99A86"},
            {"name": "Guppie green", "hex": "#00FF7F"},
            {"name": "Gunmetal", "hex": "#2a3439"},
            {"name": "Halayà úbe", "hex": "#663854"},
            {"name": "Han blue", "hex": "#446CCF"},
            {"name": "Han purple", "hex": "#5218FA"},
            {"name": "Hansa yellow", "hex": "#E9D66B"},
            {"name": "Harlequin", "hex": "#3FFF00"},
            {"name": "Harlequin green", "hex": "#46CB18"},
            {"name": "Harvard crimson", "hex": "#C90016"},
            {"name": "Harvest gold", "hex": "#DA9100"},
            {"name": "Heart Gold", "hex": "#808000"},
            {"name": "Heat Wave", "hex": "#FF7A00"},
            {"name": "Heidelberg Red[2]", "hex": "#960018"},
            {"name": "Heliotrope", "hex": "#DF73FF"},
            {"name": "Heliotrope gray", "hex": "#AA98A9"},
            {"name": "Heliotrope magenta", "hex": "#AA00BB"},
            {"name": "Hollywood cerise", "hex": "#F400A1"},
            {"name": "Honeydew", "hex": "#F0FFF0"},
            {"name": "Honolulu blue", "hex": "#006DB0"},
            {"name": "Hooker's green", "hex": "#49796B"},
            {"name": "Hot magenta", "hex": "#FF1DCE"},
            {"name": "Hot pink", "hex": "#FF69B4"},
            {"name": "Hunter green", "hex": "#355E3B"},
            {"name": "Iceberg", "hex": "#71A6D2"},
            {"name": "Icterine", "hex": "#FCF75E"},
            {"name": "Iguana Green", "hex": "#71BC78"},
            {"name": "Illuminating Emerald", "hex": "#319177"},
            {"name": "Imperial", "hex": "#602F6B"},
            {"name": "Imperial blue", "hex": "#002395"},
            {"name": "Imperial purple", "hex": "#66023C"},
            {"name": "Imperial red", "hex": "#ED2939"},
            {"name": "Inchworm", "hex": "#B2EC5D"},
            {"name": "Independence", "hex": "#4C516D"},
            {"name": "India green", "hex": "#138808"},
            {"name": "Indian red", "hex": "#CD5C5C"},
            {"name": "Indian yellow", "hex": "#E3A857"},
            {"name": "Indigo", "hex": "#4B0082"},
            {"name": "Indigo dye", "hex": "#091F92"},
            {"name": "Indigo (web)", "hex": "#4B0082"},
            {"name": "Infra Red", "hex": "#FF496C"},
            {"name": "Interdimensional Blue", "hex": "#360CCC"},
            {"name": "International Klein Blue", "hex": "#002FA7"},
            {"name": "International orange (aerospace)", "hex": "#FF4F00"},
            {"name": "International orange (engineering)", "hex": "#BA160C"},
            {"name": "International orange (Golden Gate Bridge)",
             "hex": "#C0362C"},
            {"name": "Iris", "hex": "#5A4FCF"},
            {"name": "Irresistible", "hex": "#B3446C"},
            {"name": "Isabelline", "hex": "#F4F0EC"},
            {"name": "Islamic green", "hex": "#009000"},
            {"name": "Italian sky blue", "hex": "#B2FFFF"},
            {"name": "Ivory", "hex": "#FFFFF0"},
            {"name": "Jade", "hex": "#00A86B"},
            {"name": "Japanese carmine", "hex": "#9D2933"},
            {"name": "Japanese indigo", "hex": "#264348"},
            {"name": "Japanese violet", "hex": "#5B3256"},
            {"name": "Jasmine", "hex": "#F8DE7E"},
            {"name": "Jasper", "hex": "#D73B3E"},
            {"name": "Jazzberry jam", "hex": "#A50B5E"},
            {"name": "Jelly Bean", "hex": "#DA614E"},
            {"name": "Jet", "hex": "#343434"},
            {"name": "Jonquil", "hex": "#F4CA16"},
            {"name": "Jordy blue", "hex": "#8AB9F1"},
            {"name": "June bud", "hex": "#BDDA57"},
            {"name": "Jungle green", "hex": "#29AB87"},
            {"name": "Kelly green", "hex": "#4CBB17"},
            {"name": "Kenyan copper", "hex": "#7C1C05"},
            {"name": "Keppel", "hex": "#3AB09E"},
            {"name": "Key Lime", "hex": "#E8F48C"},
            {"name": "Khaki (HTML/CSS) (Khaki)", "hex": "#C3B091"},
            {"name": "Khaki (X11) (Light khaki)", "hex": "#F0E68C"},
            {"name": "Kiwi", "hex": "#8EE53F"},
            {"name": "Kobe", "hex": "#882D17"},
            {"name": "Kobi", "hex": "#E79FC4"},
            {"name": "Kobicha", "hex": "#6B4423"},
            {"name": "Kombu green", "hex": "#354230"},
            {"name": "KSU Purple", "hex": "#512888"},
            {"name": "KU Crimson", "hex": "#E8000D"},
            {"name": "La Salle Green", "hex": "#087830"},
            {"name": "Languid lavender", "hex": "#D6CADD"},
            {"name": "Lapis lazuli", "hex": "#26619C"},
            {"name": "Laser Lemon", "hex": "#FFFF66"},
            {"name": "Laurel green", "hex": "#A9BA9D"},
            {"name": "Lava", "hex": "#CF1020"},
            {"name": "Lavender (floral)", "hex": "#B57EDC"},
            {"name": "Lavender (web)", "hex": "#E6E6FA"},
            {"name": "Lavender blue", "hex": "#CCCCFF"},
            {"name": "Lavender blush", "hex": "#FFF0F5"},
            {"name": "Lavender gray", "hex": "#C4C3D0"},
            {"name": "Lavender indigo", "hex": "#9457EB"},
            {"name": "Lavender magenta", "hex": "#EE82EE"},
            {"name": "Lavender mist", "hex": "#E6E6FA"},
            {"name": "Lavender pink", "hex": "#FBAED2"},
            {"name": "Lavender purple", "hex": "#967BB6"},
            {"name": "Lavender rose", "hex": "#FBA0E3"},
            {"name": "Lawn green", "hex": "#7CFC00"},
            {"name": "Lemon", "hex": "#FFF700"},
            {"name": "Lemon chiffon", "hex": "#FFFACD"},
            {"name": "Lemon curry", "hex": "#CCA01D"},
            {"name": "Lemon glacier", "hex": "#FDFF00"},
            {"name": "Lemon lime", "hex": "#E3FF00"},
            {"name": "Lemon meringue", "hex": "#F6EABE"},
            {"name": "Lemon yellow", "hex": "#FFF44F"},
            {"name": "Licorice", "hex": "#1A1110"},
            {"name": "Liberty", "hex": "#545AA7"},
            {"name": "Light apricot", "hex": "#FDD5B1"},
            {"name": "Light blue", "hex": "#ADD8E6"},
            {"name": "Light brown", "hex": "#B5651D"},
            {"name": "Light carmine pink", "hex": "#E66771"},
            {"name": "Light cobalt blue", "hex": "#88ACE0"},
            {"name": "Light coral", "hex": "#F08080"},
            {"name": "Light cornflower blue", "hex": "#93CCEA"},
            {"name": "Light crimson", "hex": "#F56991"},
            {"name": "Light cyan", "hex": "#E0FFFF"},
            {"name": "Light deep pink", "hex": "#FF5CCD"},
            {"name": "Light French beige", "hex": "#C8AD7F"},
            {"name": "Light fuchsia pink", "hex": "#F984EF"},
            {"name": "Light goldenrod yellow", "hex": "#FAFAD2"},
            {"name": "Light gray", "hex": "#D3D3D3"},
            {"name": "Light grayish magenta", "hex": "#CC99CC"},
            {"name": "Light green", "hex": "#90EE90"},
            {"name": "Light hot pink", "hex": "#FFB3DE"},
            {"name": "Light khaki", "hex": "#F0E68C"},
            {"name": "Light medium orchid", "hex": "#D39BCB"},
            {"name": "Light moss green", "hex": "#ADDFAD"},
            {"name": "Light orchid", "hex": "#E6A8D7"},
            {"name": "Light pastel purple", "hex": "#B19CD9"},
            {"name": "Light pink", "hex": "#FFB6C1"},
            {"name": "Light red ochre", "hex": "#E97451"},
            {"name": "Light salmon", "hex": "#FFA07A"},
            {"name": "Light salmon pink", "hex": "#FF9999"},
            {"name": "Light sea green", "hex": "#20B2AA"},
            {"name": "Light sky blue", "hex": "#87CEFA"},
            {"name": "Light slate gray", "hex": "#778899"},
            {"name": "Light steel blue", "hex": "#B0C4DE"},
            {"name": "Light taupe", "hex": "#B38B6D"},
            {"name": "Light Thulian pink", "hex": "#E68FAC"},
            {"name": "Light yellow", "hex": "#FFFFE0"},
            {"name": "Lilac", "hex": "#C8A2C8"},
            {"name": "Lilac Luster", "hex": "#AE98AA"},
            {"name": "Lime (color wheel)", "hex": "#BFFF00"},
            {"name": "Lime (web) (X11 green)", "hex": "#00FF00"},
            {"name": "Lime green", "hex": "#32CD32"},
            {"name": "Limerick", "hex": "#9DC209"},
            {"name": "Lincoln green", "hex": "#195905"},
            {"name": "Linen", "hex": "#FAF0E6"},
            {"name": "Loeen(lopen)look/vomit+indogo+Lopen+Gabriel",
             "hex": "#15F2FD"},
            {"name": "Liseran Purple", "hex": "#DE6FA1"},
            {"name": "Little boy blue", "hex": "#6CA0DC"},
            {"name": "Liver", "hex": "#674C47"},
            {"name": "Liver (dogs)", "hex": "#B86D29"},
            {"name": "Liver (organ)", "hex": "#6C2E1F"},
            {"name": "Liver chestnut", "hex": "#987456"},
            {"name": "Livid", "hex": "#6699CC"},
            {"name": "Lumber", "hex": "#FFE4CD"},
            {"name": "Lust", "hex": "#E62020"},
            {"name": "Maastricht Blue", "hex": "#001C3D"},
            {"name": "Macaroni and Cheese", "hex": "#FFBD88"},
            {"name": "Madder Lake", "hex": "#CC3336"},
            {"name": "Magenta", "hex": "#FF00FF"},
            {"name": "Magenta (Crayola)", "hex": "#FF55A3"},
            {"name": "Magenta (dye)", "hex": "#CA1F7B"},
            {"name": "Magenta (Pantone)", "hex": "#D0417E"},
            {"name": "Magenta (process)", "hex": "#FF0090"},
            {"name": "Magenta haze", "hex": "#9F4576"},
            {"name": "Magenta-pink", "hex": "#CC338B"},
            {"name": "Magic mint", "hex": "#AAF0D1"},
            {"name": "Magic Potion", "hex": "#FF4466"},
            {"name": "Magnolia", "hex": "#F8F4FF"},
            {"name": "Mahogany", "hex": "#C04000"},
            {"name": "Maize", "hex": "#FBEC5D"},
            {"name": "Majorelle Blue", "hex": "#6050DC"},
            {"name": "Malachite", "hex": "#0BDA51"},
            {"name": "Manatee", "hex": "#979AAA"},
            {"name": "Mandarin", "hex": "#F37A48"},
            {"name": "Mango Tango", "hex": "#FF8243"},
            {"name": "Mantis", "hex": "#74C365"},
            {"name": "Mardi Gras", "hex": "#880085"},
            {"name": "Marigold", "hex": "#EAA221"},
            {"name": "Maroon (Crayola)", "hex": "#C32148"},
            {"name": "Maroon (HTML/CSS)", "hex": "#800000"},
            {"name": "Maroon (X11)", "hex": "#B03060"},
            {"name": "Mauve", "hex": "#E0B0FF"},
            {"name": "Mauve taupe", "hex": "#915F6D"},
            {"name": "Mauvelous", "hex": "#EF98AA"},
            {"name": "Maximum Blue", "hex": "#47ABCC"},
            {"name": "Maximum Blue Green", "hex": "#30BFBF"},
            {"name": "Maximum Blue Purple", "hex": "#ACACE6"},
            {"name": "Maximum Green", "hex": "#5E8C31"},
            {"name": "Maximum Green Yellow", "hex": "#D9E650"},
            {"name": "Maximum Purple", "hex": "#733380"},
            {"name": "Maximum Red", "hex": "#D92121"},
            {"name": "Maximum Red Purple", "hex": "#A63A79"},
            {"name": "Maximum Yellow", "hex": "#FAFA37"},
            {"name": "Maximum Yellow Red", "hex": "#F2BA49"},
            {"name": "May green", "hex": "#4C9141"},
            {"name": "Maya blue", "hex": "#73C2FB"},
            {"name": "Meat brown", "hex": "#E5B73B"},
            {"name": "Medium aquamarine", "hex": "#66DDAA"},
            {"name": "Medium blue", "hex": "#0000CD"},
            {"name": "Medium candy apple red", "hex": "#E2062C"},
            {"name": "Medium carmine", "hex": "#AF4035"},
            {"name": "Medium champagne", "hex": "#F3E5AB"},
            {"name": "Medium electric blue", "hex": "#035096"},
            {"name": "Medium jungle green", "hex": "#1C352D"},
            {"name": "Medium lavender magenta", "hex": "#DDA0DD"},
            {"name": "Medium orchid", "hex": "#BA55D3"},
            {"name": "Medium Persian blue", "hex": "#0067A5"},
            {"name": "Medium purple", "hex": "#9370DB"},
            {"name": "Medium red-violet", "hex": "#BB3385"},
            {"name": "Medium ruby", "hex": "#AA4069"},
            {"name": "Medium sea green", "hex": "#3CB371"},
            {"name": "Medium sky blue", "hex": "#80DAEB"},
            {"name": "Medium slate blue", "hex": "#7B68EE"},
            {"name": "Medium spring bud", "hex": "#C9DC87"},
            {"name": "Medium spring green", "hex": "#00FA9A"},
            {"name": "Medium taupe", "hex": "#674C47"},
            {"name": "Medium turquoise", "hex": "#48D1CC"},
            {"name": "Medium Tuscan red", "hex": "#79443B"},
            {"name": "Medium vermilion", "hex": "#D9603B"},
            {"name": "Medium violet-red", "hex": "#C71585"},
            {"name": "Mellow apricot", "hex": "#F8B878"},
            {"name": "Mellow yellow", "hex": "#F8DE7E"},
            {"name": "Melon", "hex": "#FDBCB4"},
            {"name": "Metallic Seaweed", "hex": "#0A7E8C"},
            {"name": "Metallic Sunburst", "hex": "#9C7C38"},
            {"name": "Mexican pink", "hex": "#E4007C"},
            {"name": "Middle Blue", "hex": "#7ED4E6"},
            {"name": "Middle Blue Green", "hex": "#8DD9CC"},
            {"name": "Middle Blue Purple", "hex": "#8B72BE"},
            {"name": "Middle Red Purple", "hex": "#210837"},
            {"name": "Middle Green", "hex": "#4D8C57"},
            {"name": "Middle Green Yellow", "hex": "#ACBF60"},
            {"name": "Middle Purple", "hex": "#D982B5"},
            {"name": "Middle Red", "hex": "#E58E73"},
            {"name": "Middle Red Purple", "hex": "#A55353"},
            {"name": "Middle Yellow", "hex": "#FFEB00"},
            {"name": "Middle Yellow Red", "hex": "#ECB176"},
            {"name": "Midnight", "hex": "#702670"},
            {"name": "Midnight blue", "hex": "#191970"},
            {"name": "Midnight green (eagle green)", "hex": "#004953"},
            {"name": "Mikado yellow", "hex": "#FFC40C"},
            {"name": "Milk", "hex": "#FDFFF5"},
            {"name": "Mimi Pink", "hex": "#FFDAE9"},
            {"name": "Mindaro", "hex": "#E3F988"},
            {"name": "Ming", "hex": "#36747D"},
            {"name": "Minion Yellow", "hex": "#F5E050"},
            {"name": "Mint", "hex": "#3EB489"},
            {"name": "Mint cream", "hex": "#F5FFFA"},
            {"name": "Mint green", "hex": "#98FF98"},
            {"name": "Misty Moss", "hex": "#BBB477"},
            {"name": "Misty rose", "hex": "#FFE4E1"},
            {"name": "Moccasin", "hex": "#FAEBD7"},
            {"name": "Mode beige", "hex": "#967117"},
            {"name": "Moonstone blue", "hex": "#73A9C2"},
            {"name": "Mordant red 19", "hex": "#AE0C00"},
            {"name": "Moss green", "hex": "#8A9A5B"},
            {"name": "Mountain Meadow", "hex": "#30BA8F"},
            {"name": "Mountbatten pink", "hex": "#997A8D"},
            {"name": "MSU Green", "hex": "#18453B"},
            {"name": "Mughal green", "hex": "#306030"},
            {"name": "Mulberry", "hex": "#C54B8C"},
            {"name": "Mummy's Tomb", "hex": "#828E84"},
            {"name": "Mustard", "hex": "#FFDB58"},
            {"name": "Myrtle green", "hex": "#317873"},
            {"name": "Mystic", "hex": "#D65282"},
            {"name": "Mystic Maroon", "hex": "#AD4379"},
            {"name": "Nadeshiko pink", "hex": "#F6ADC6"},
            {"name": "Napier green", "hex": "#2A8000"},
            {"name": "Naples yellow", "hex": "#FADA5E"},
            {"name": "Navajo white", "hex": "#FFDEAD"},
            {"name": "Navy", "hex": "#000080"},
            {"name": "Navy purple", "hex": "#9457EB"},
            {"name": "Neon Carrot", "hex": "#FFA343"},
            {"name": "Neon fuchsia", "hex": "#FE4164"},
            {"name": "Neon green", "hex": "#39FF14"},
            {"name": "New Car", "hex": "#214FC6"},
            {"name": "New York pink", "hex": "#D7837F"},
            {"name": "Nickel", "hex": "#727472"},
            {"name": "Non-photo blue", "hex": "#A4DDED"},
            {"name": "North Texas Green", "hex": "#059033"},
            {"name": "Nyanza", "hex": "#E9FFDB"},
            {"name": "Ocean Blue", "hex": "#4F42B5"},
            {"name": "Ocean Boat Blue", "hex": "#0077BE"},
            {"name": "Ocean Green", "hex": "#48BF91"},
            {"name": "Ochre", "hex": "#CC7722"},
            {"name": "Office green", "hex": "#008000"},
            {"name": "Ogre Odor", "hex": "#FD5240"},
            {"name": "Old burgundy", "hex": "#43302E"},
            {"name": "Old gold", "hex": "#CFB53B"},
            {"name": "Old heliotrope", "hex": "#563C5C"},
            {"name": "Old lace", "hex": "#FDF5E6"},
            {"name": "Old lavender", "hex": "#796878"},
            {"name": "Old mauve", "hex": "#673147"},
            {"name": "Old moss green", "hex": "#867E36"},
            {"name": "Old rose", "hex": "#C08081"},
            {"name": "Old silver", "hex": "#848482"},
            {"name": "Olive", "hex": "#808000"},
            {"name": "Olive Drab (#3)", "hex": "#6B8E23"},
            {"name": "Olive Drab #7", "hex": "#3C341F"},
            {"name": "Olivine", "hex": "#9AB973"},
            {"name": "Onyx", "hex": "#353839"},
            {"name": "Opera mauve", "hex": "#B784A7"},
            {"name": "Orange (color wheel)", "hex": "#FF7F00"},
            {"name": "Orange (Crayola)", "hex": "#FF7538"},
            {"name": "Orange (Pantone)", "hex": "#FF5800"},
            {"name": "Orange (RYB)", "hex": "#FB9902"},
            {"name": "Orange (web)", "hex": "#FFA500"},
            {"name": "Orange peel", "hex": "#FF9F00"},
            {"name": "Orange-red", "hex": "#FF4500"},
            {"name": "Orange Soda", "hex": "#FA5B3D"},
            {"name": "Orange-yellow", "hex": "#F8D568"},
            {"name": "Orchid", "hex": "#DA70D6"},
            {"name": "Orchid pink", "hex": "#F2BDCD"},
            {"name": "Orioles orange", "hex": "#FB4F14"},
            {"name": "Otter brown", "hex": "#654321"},
            {"name": "Outer Space", "hex": "#414A4C"},
            {"name": "Outrageous Orange", "hex": "#FF6E4A"},
            {"name": "Oxford Blue", "hex": "#002147"},
            {"name": "OU Crimson Red", "hex": "#990000"},
            {"name": "Pacific Blue", "hex": "#1CA9C9"},
            {"name": "Pakistan green", "hex": "#006600"},
            {"name": "Palatinate blue", "hex": "#273BE2"},
            {"name": "Palatinate purple", "hex": "#682860"},
            {"name": "Pale aqua", "hex": "#BCD4E6"},
            {"name": "Pale blue", "hex": "#AFEEEE"},
            {"name": "Pale brown", "hex": "#987654"},
            {"name": "Pale carmine", "hex": "#AF4035"},
            {"name": "Pale cerulean", "hex": "#9BC4E2"},
            {"name": "Pale chestnut", "hex": "#DDADAF"},
            {"name": "Pale copper", "hex": "#DA8A67"},
            {"name": "Pale cornflower blue", "hex": "#ABCDEF"},
            {"name": "Pale cyan", "hex": "#87D3F8"},
            {"name": "Pale gold", "hex": "#E6BE8A"},
            {"name": "Pale goldenrod", "hex": "#EEE8AA"},
            {"name": "Pale green", "hex": "#98FB98"},
            {"name": "Pale lavender", "hex": "#DCD0FF"},
            {"name": "Pale magenta", "hex": "#F984E5"},
            {"name": "Pale magenta-pink", "hex": "#FF99CC"},
            {"name": "Pale pink", "hex": "#FADADD"},
            {"name": "Pale plum", "hex": "#DDA0DD"},
            {"name": "Pale red-violet", "hex": "#DB7093"},
            {"name": "Pale robin egg blue", "hex": "#96DED1"},
            {"name": "Pale silver", "hex": "#C9C0BB"},
            {"name": "Pale spring bud", "hex": "#ECEBBD"},
            {"name": "Pale taupe", "hex": "#BC987E"},
            {"name": "Pale turquoise", "hex": "#AFEEEE"},
            {"name": "Pale violet", "hex": "#CC99FF"},
            {"name": "Pale violet-red", "hex": "#DB7093"},
            {"name": "Palm Leaf", "hex": "#6F9940"},
            {"name": "Pansy purple", "hex": "#78184A"},
            {"name": "Paolo Veronese green", "hex": "#009B7D"},
            {"name": "Papaya whip", "hex": "#FFEFD5"},
            {"name": "Paradise pink", "hex": "#E63E62"},
            {"name": "Paris Green", "hex": "#50C878"},
            {"name": "Parrot Pink", "hex": "#D998A0"},
            {"name": "Pastel blue", "hex": "#AEC6CF"},
            {"name": "Pastel brown", "hex": "#836953"},
            {"name": "Pastel gray", "hex": "#CFCFC4"},
            {"name": "Pastel green", "hex": "#77DD77"},
            {"name": "Pastel magenta", "hex": "#F49AC2"},
            {"name": "Pastel orange", "hex": "#FFB347"},
            {"name": "Pastel pink", "hex": "#DEA5A4"},
            {"name": "Pastel purple", "hex": "#B39EB5"},
            {"name": "Pastel red", "hex": "#FF6961"},
            {"name": "Pastel violet", "hex": "#CB99C9"},
            {"name": "Pastel yellow", "hex": "#FDFD96"},
            {"name": "Patriarch", "hex": "#800080"},
            {"name": "Payne's grey", "hex": "#536878"},
            {"name": "Peach", "hex": "#FFE5B4"},
            {"name": "Peach", "hex": "#FFCBA4"},
            {"name": "Peach-orange", "hex": "#FFCC99"},
            {"name": "Peach puff", "hex": "#FFDAB9"},
            {"name": "Peach-yellow", "hex": "#FADFAD"},
            {"name": "Pear", "hex": "#D1E231"},
            {"name": "Pearl", "hex": "#EAE0C8"},
            {"name": "Pearl Aqua", "hex": "#88D8C0"},
            {"name": "Pearly purple", "hex": "#B768A2"},
            {"name": "Peridot", "hex": "#E6E200"},
            {"name": "Periwinkle", "hex": "#CCCCFF"},
            {"name": "Permanent Geranium Lake", "hex": "#E12C2C"},
            {"name": "Persian blue", "hex": "#1C39BB"},
            {"name": "Persian green", "hex": "#00A693"},
            {"name": "Persian indigo", "hex": "#32127A"},
            {"name": "Persian orange", "hex": "#D99058"},
            {"name": "Persian pink", "hex": "#F77FBE"},
            {"name": "Persian plum", "hex": "#701C1C"},
            {"name": "Persian red", "hex": "#CC3333"},
            {"name": "Persian rose", "hex": "#FE28A2"},
            {"name": "Persimmon", "hex": "#EC5800"},
            {"name": "Peru", "hex": "#CD853F"},
            {"name": "Pewter Blue", "hex": "#8BA8B7"},
            {"name": "Phlox", "hex": "#DF00FF"},
            {"name": "Phthalo blue", "hex": "#000F89"},
            {"name": "Phthalo green", "hex": "#123524"},
            {"name": "Picton blue", "hex": "#45B1E8"},
            {"name": "Pictorial carmine", "hex": "#C30B4E"},
            {"name": "Piggy pink", "hex": "#FDDDE6"},
            {"name": "Pine green", "hex": "#01796F"},
            {"name": "Pineapple", "hex": "#563C5C"},
            {"name": "Pink", "hex": "#FFC0CB"},
            {"name": "Pink (Pantone)", "hex": "#D74894"},
            {"name": "Pink Flamingo", "hex": "#FC74FD"},
            {"name": "Pink lace", "hex": "#FFDDF4"},
            {"name": "Pink lavender", "hex": "#D8B2D1"},
            {"name": "Pink-orange", "hex": "#FF9966"},
            {"name": "Pink pearl", "hex": "#E7ACCF"},
            {"name": "Pink raspberry", "hex": "#980036"},
            {"name": "Pink Sherbet", "hex": "#F78FA7"},
            {"name": "Pistachio", "hex": "#93C572"},
            {"name": "Pixie Powder", "hex": "#391285"},
            {"name": "Platinum", "hex": "#E5E4E2"},
            {"name": "Plum", "hex": "#8E4585"},
            {"name": "Plum (web)", "hex": "#DDA0DD"},
            {"name": "Plump Purple", "hex": "#5946B2"},
            {"name": "Polished Pine", "hex": "#5DA493"},
            {"name": "Pomp and Power", "hex": "#86608E"},
            {"name": "Popstar", "hex": "#BE4F62"},
            {"name": "Portland Orange", "hex": "#FF5A36"},
            {"name": "Powder blue", "hex": "#B0E0E6"},
            {"name": "Princess Perfume", "hex": "#FF85CF"},
            {"name": "Princeton orange", "hex": "#F58025"},
            {"name": "Prune", "hex": "#701C1C"},
            {"name": "Prussian blue", "hex": "#003153"},
            {"name": "Psychedelic purple", "hex": "#DF00FF"},
            {"name": "Puce", "hex": "#CC8899"},
            {"name": "Puce red", "hex": "#722F37"},
            {"name": "Pullman Brown (UPS Brown)", "hex": "#644117"},
            {"name": "Pullman Green", "hex": "#3B331C"},
            {"name": "Pumpkin", "hex": "#FF7518"},
            {"name": "Purple (HTML)", "hex": "#800080"},
            {"name": "Purple (Munsell)", "hex": "#9F00C5"},
            {"name": "Purple (X11)", "hex": "#A020F0"},
            {"name": "Purple Heart", "hex": "#69359C"},
            {"name": "Purple mountain majesty", "hex": "#9678B6"},
            {"name": "Purple navy", "hex": "#4E5180"},
            {"name": "Purple pizzazz", "hex": "#FE4EDA"},
            {"name": "Purple Plum", "hex": "#9C51B6"},
            {"name": "Purple taupe", "hex": "#50404D"},
            {"name": "Purpureus", "hex": "#9A4EAE"},
            {"name": "Quartz", "hex": "#51484F"},
            {"name": "Queen blue", "hex": "#436B95"},
            {"name": "Queen pink", "hex": "#E8CCD7"},
            {"name": "Quick Silver", "hex": "#A6A6A6"},
            {"name": "Quinacridone magenta", "hex": "#8E3A59"},
            {"name": "Rackley", "hex": "#5D8AA8"},
            {"name": "Radical Red", "hex": "#FF355E"},
            {"name": "Raisin black", "hex": "#242124"},
            {"name": "Rajah", "hex": "#FBAB60"},
            {"name": "Raspberry", "hex": "#E30B5D"},
            {"name": "Raspberry glace", "hex": "#915F6D"},
            {"name": "Raspberry pink", "hex": "#E25098"},
            {"name": "Raspberry rose", "hex": "#B3446C"},
            {"name": "Raw Sienna", "hex": "#D68A59"},
            {"name": "Raw umber", "hex": "#826644"},
            {"name": "Razzle dazzle rose", "hex": "#FF33CC"},
            {"name": "Razzmatazz", "hex": "#E3256B"},
            {"name": "Razzmic Berry", "hex": "#8D4E85"},
            {"name": "Rebecca Purple", "hex": "#663399"},
            {"name": "Red", "hex": "#FF0000"},
            {"name": "Red (Crayola)", "hex": "#EE204D"},
            {"name": "Red (Munsell)", "hex": "#F2003C"},
            {"name": "Red (NCS)", "hex": "#C40233"},
            {"name": "Red (Pantone)", "hex": "#ED2939"},
            {"name": "Red (pigment)", "hex": "#ED1C24"},
            {"name": "Red (RYB)", "hex": "#FE2712"},
            {"name": "Red-brown", "hex": "#A52A2A"},
            {"name": "Red devil", "hex": "#860111"},
            {"name": "Red-orange", "hex": "#FF5349"},
            {"name": "Red-purple", "hex": "#E40078"},
            {"name": "Red Salsa", "hex": "#FD3A4A"},
            {"name": "Red-violet", "hex": "#C71585"},
            {"name": "Redwood", "hex": "#A45A52"},
            {"name": "Regalia", "hex": "#522D80"},
            {"name": "Registration black", "hex": "#000000"},
            {"name": "Resolution blue", "hex": "#002387"},
            {"name": "Rhythm", "hex": "#777696"},
            {"name": "Rich black", "hex": "#004040"},
            {"name": "Rich black (FOGRA29)", "hex": "#010B13"},
            {"name": "Rich black (FOGRA39)", "hex": "#010203"},
            {"name": "Rich brilliant lavender", "hex": "#F1A7FE"},
            {"name": "Rich carmine", "hex": "#D70040"},
            {"name": "Rich electric blue", "hex": "#0892D0"},
            {"name": "Rich lavender", "hex": "#A76BCF"},
            {"name": "Rich lilac", "hex": "#B666D2"},
            {"name": "Rich maroon", "hex": "#B03060"},
            {"name": "Rifle green", "hex": "#444C38"},
            {"name": "Roast coffee", "hex": "#704241"},
            {"name": "Robin egg blue", "hex": "#00CCCC"},
            {"name": "Rocket metallic", "hex": "#8A7F80"},
            {"name": "Roman silver", "hex": "#838996"},
            {"name": "Rose", "hex": "#FF007F"},
            {"name": "Rose bonbon", "hex": "#F9429E"},
            {"name": "Rose Dust", "hex": "#9E5E6F"},
            {"name": "Rose ebony", "hex": "#674846"},
            {"name": "Rose gold", "hex": "#B76E79"},
            {"name": "Rose madder", "hex": "#E32636"},
            {"name": "Rose pink", "hex": "#FF66CC"},
            {"name": "Rose quartz", "hex": "#AA98A9"},
            {"name": "Rose red", "hex": "#C21E56"},
            {"name": "Rose taupe", "hex": "#905D5D"},
            {"name": "Rose vale", "hex": "#AB4E52"},
            {"name": "Rosewood", "hex": "#65000B"},
            {"name": "Rosso corsa", "hex": "#D40000"},
            {"name": "Rosy brown", "hex": "#BC8F8F"},
            {"name": "Royal azure", "hex": "#0038A8"},
            {"name": "Royal blue", "hex": "#002366"},
            {"name": "Royal blue", "hex": "#4169E1"},
            {"name": "Royal fuchsia", "hex": "#CA2C92"},
            {"name": "Royal purple", "hex": "#7851A9"},
            {"name": "Royal yellow", "hex": "#FADA5E"},
            {"name": "Ruber", "hex": "#CE4676"},
            {"name": "Rubine red", "hex": "#D10056"},
            {"name": "Ruby", "hex": "#E0115F"},
            {"name": "Ruby red", "hex": "#9B111E"},
            {"name": "Ruddy", "hex": "#FF0028"},
            {"name": "Ruddy brown", "hex": "#BB6528"},
            {"name": "Ruddy pink", "hex": "#E18E96"},
            {"name": "Rufous", "hex": "#A81C07"},
            {"name": "Russet", "hex": "#80461B"},
            {"name": "Russian green", "hex": "#679267"},
            {"name": "Russian violet", "hex": "#32174D"},
            {"name": "Rust", "hex": "#B7410E"},
            {"name": "Rusty red", "hex": "#DA2C43"},
            {"name": "Sacramento State green", "hex": "#00563F"},
            {"name": "Saddle brown", "hex": "#8B4513"},
            {"name": "Safety orange", "hex": "#FF7800"},
            {"name": "Safety orange (blaze orange)", "hex": "#FF6700"},
            {"name": "Safety yellow", "hex": "#EED202"},
            {"name": "Saffron", "hex": "#F4C430"},
            {"name": "Sage", "hex": "#BCB88A"},
            {"name": "St. Patrick's blue", "hex": "#23297A"},
            {"name": "Salmon", "hex": "#FA8072"},
            {"name": "Salmon pink", "hex": "#FF91A4"},
            {"name": "Sand", "hex": "#C2B280"},
            {"name": "Sand dune", "hex": "#967117"},
            {"name": "Sandstorm", "hex": "#ECD540"},
            {"name": "Sandy brown", "hex": "#F4A460"},
            {"name": "Sandy Tan", "hex": "#FDD9B5"},
            {"name": "Sandy taupe", "hex": "#967117"},
            {"name": "Sangria", "hex": "#92000A"},
            {"name": "Sap green", "hex": "#507D2A"},
            {"name": "Sapphire", "hex": "#0F52BA"},
            {"name": "Sapphire blue", "hex": "#0067A5"},
            {"name": "Sasquatch Socks", "hex": "#FF4681"},
            {"name": "Satin sheen gold", "hex": "#CBA135"},
            {"name": "Scarlet", "hex": "#FF2400"},
            {"name": "Scarlet", "hex": "#FD0E35"},
            {"name": "Schauss pink", "hex": "#FF91AF"},
            {"name": "School bus yellow", "hex": "#FFD800"},
            {"name": "Screamin' Green", "hex": "#66FF66"},
            {"name": "Sea blue", "hex": "#006994"},
            {"name": "Sea Foam Green", "hex": "#9FE2BF"},
            {"name": "Sea green", "hex": "#2E8B57"},
            {"name": "Sea Serpent", "hex": "#4BC7CF"},
            {"name": "Seal brown", "hex": "#59260B"},
            {"name": "Seashell", "hex": "#FFF5EE"},
            {"name": "Selective yellow", "hex": "#FFBA00"},
            {"name": "Sepia", "hex": "#704214"},
            {"name": "Shadow", "hex": "#8A795D"},
            {"name": "Shadow blue", "hex": "#778BA5"},
            {"name": "Shampoo", "hex": "#FFCFF1"},
            {"name": "Shamrock green", "hex": "#009E60"},
            {"name": "Sheen Green", "hex": "#8FD400"},
            {"name": "Shimmering Blush", "hex": "#D98695"},
            {"name": "Shiny Shamrock", "hex": "#5FA778"},
            {"name": "Shocking pink", "hex": "#FC0FC0"},
            {"name": "Shocking pink (Crayola)", "hex": "#FF6FFF"},
            {"name": "Sienna", "hex": "#882D17"},
            {"name": "Silver", "hex": "#C0C0C0"},
            {"name": "Silver chalice", "hex": "#ACACAC"},
            {"name": "Silver Lake blue", "hex": "#5D89BA"},
            {"name": "Silver pink", "hex": "#C4AEAD"},
            {"name": "Silver sand", "hex": "#BFC1C2"},
            {"name": "Sinopia", "hex": "#CB410B"},
            {"name": "Sizzling Red", "hex": "#FF3855"},
            {"name": "Sizzling Sunrise", "hex": "#FFDB00"},
            {"name": "Skobeloff", "hex": "#007474"},
            {"name": "Sky blue", "hex": "#87CEEB"},
            {"name": "Sky magenta", "hex": "#CF71AF"},
            {"name": "Slate blue", "hex": "#6A5ACD"},
            {"name": "Slate gray", "hex": "#708090"},
            {"name": "Smalt (Dark powder blue)", "hex": "#003399"},
            {"name": "Slimy Green", "hex": "#299617"},
            {"name": "Smashed Pumpkin", "hex": "#FF6D3A"},
            {"name": "Smitten", "hex": "#C84186"},
            {"name": "Smoke", "hex": "#738276"},
            {"name": "Smokey Topaz", "hex": "#832A0D"},
            {"name": "Smoky black", "hex": "#100C08"},
            {"name": "Smoky Topaz", "hex": "#933D41"},
            {"name": "Snow", "hex": "#FFFAFA"},
            {"name": "Soap", "hex": "#CEC8EF"},
            {"name": "Solid pink", "hex": "#893843"},
            {"name": "Sonic silver", "hex": "#757575"},
            {"name": "Spartan Crimson", "hex": "#9E1316"},
            {"name": "Space cadet", "hex": "#1D2951"},
            {"name": "Spanish bistre", "hex": "#807532"},
            {"name": "Spanish blue", "hex": "#0070B8"},
            {"name": "Spanish carmine", "hex": "#D10047"},
            {"name": "Spanish crimson", "hex": "#E51A4C"},
            {"name": "Spanish gray", "hex": "#989898"},
            {"name": "Spanish green", "hex": "#009150"},
            {"name": "Spanish orange", "hex": "#E86100"},
            {"name": "Spanish pink", "hex": "#F7BFBE"},
            {"name": "Spanish red", "hex": "#E60026"},
            {"name": "Spanish sky blue", "hex": "#00FFFF"},
            {"name": "Spanish violet", "hex": "#4C2882"},
            {"name": "Spanish viridian", "hex": "#007F5C"},
            {"name": "Spicy mix", "hex": "#8B5f4D"},
            {"name": "Spiro Disco Ball", "hex": "#0FC0FC"},
            {"name": "Spring bud", "hex": "#A7FC00"},
            {"name": "Spring Frost", "hex": "#87FF2A"},
            {"name": "Spring green", "hex": "#00FF7F"},
            {"name": "Star command blue", "hex": "#007BB8"},
            {"name": "Steel blue", "hex": "#4682B4"},
            {"name": "Steel pink", "hex": "#CC33CC"},
            {"name": "Steel Teal", "hex": "#5F8A8B"},
            {"name": "Stil de grain yellow", "hex": "#FADA5E"},
            {"name": "Stizza", "hex": "#990000"},
            {"name": "Stormcloud", "hex": "#4F666A"},
            {"name": "Straw", "hex": "#E4D96F"},
            {"name": "Strawberry", "hex": "#FC5A8D"},
            {"name": "Sugar Plum", "hex": "#914E75"},
            {"name": "Sunburnt Cyclops", "hex": "#FF404C"},
            {"name": "Sunglow", "hex": "#FFCC33"},
            {"name": "Sunny", "hex": "#F2F27A"},
            {"name": "Sunray", "hex": "#E3AB57"},
            {"name": "Sunset", "hex": "#FAD6A5"},
            {"name": "Sunset orange", "hex": "#FD5E53"},
            {"name": "Super pink", "hex": "#CF6BA9"},
            {"name": "Sweet Brown", "hex": "#A83731"},
            {"name": "Tan", "hex": "#D2B48C"},
            {"name": "Tangelo", "hex": "#F94D00"},
            {"name": "Tangerine", "hex": "#F28500"},
            {"name": "Tangerine yellow", "hex": "#FFCC00"},
            {"name": "Tango pink", "hex": "#E4717A"},
            {"name": "Tart Orange", "hex": "#FB4D46"},
            {"name": "Taupe", "hex": "#483C32"},
            {"name": "Taupe gray", "hex": "#8B8589"},
            {"name": "Tea green", "hex": "#D0F0C0"},
            {"name": "Tea rose", "hex": "#F88379"},
            {"name": "Tea rose", "hex": "#F4C2C2"},
            {"name": "Teal", "hex": "#008080"},
            {"name": "Teal blue", "hex": "#367588"},
            {"name": "Teal deer", "hex": "#99E6B3"},
            {"name": "Teal green", "hex": "#00827F"},
            {"name": "Telemagenta", "hex": "#CF3476"},
            {"name": "Tenné (tawny)", "hex": "#CD5700"},
            {"name": "Terra cotta", "hex": "#E2725B"},
            {"name": "Thistle", "hex": "#D8BFD8"},
            {"name": "Thulian pink", "hex": "#DE6FA1"},
            {"name": "Tickle Me Pink", "hex": "#FC89AC"},
            {"name": "Tiffany Blue", "hex": "#0ABAB5"},
            {"name": "Tiger's eye", "hex": "#E08D3C"},
            {"name": "Timberwolf", "hex": "#DBD7D2"},
            {"name": "Titanium yellow", "hex": "#EEE600"},
            {"name": "Tomato", "hex": "#FF6347"},
            {"name": "Toolbox", "hex": "#746CC0"},
            {"name": "Topaz", "hex": "#FFC87C"},
            {"name": "Tractor red", "hex": "#FD0E35"},
            {"name": "Trolley Grey", "hex": "#808080"},
            {"name": "Tropical rain forest", "hex": "#00755E"},
            {"name": "Tropical violet", "hex": "#CDA4DE"},
            {"name": "True Blue", "hex": "#0073CF"},
            {"name": "Tufts Blue", "hex": "#3E8EDE"},
            {"name": "Tulip", "hex": "#FF878D"},
            {"name": "Tumbleweed", "hex": "#DEAA88"},
            {"name": "Turkish rose", "hex": "#B57281"},
            {"name": "Turquoise", "hex": "#40E0D0"},
            {"name": "Turquoise blue", "hex": "#00FFEF"},
            {"name": "Turquoise green", "hex": "#A0D6B4"},
            {"name": "Turquoise Surf", "hex": "#00C5CD"},
            {"name": "Turtle green", "hex": "#8A9A5B"},
            {"name": "Tuscan", "hex": "#FAD6A5"},
            {"name": "Tuscan brown", "hex": "#6F4E37"},
            {"name": "Tuscan red", "hex": "#7C4848"},
            {"name": "Tuscan tan", "hex": "#A67B5B"},
            {"name": "Tuscany", "hex": "#C09999"},
            {"name": "Twilight lavender", "hex": "#8A496B"},
            {"name": "Tyrian purple", "hex": "#66023C"},
            {"name": "UA blue", "hex": "#0033AA"},
            {"name": "UA red", "hex": "#D9004C"},
            {"name": "Ube", "hex": "#8878C3"},
            {"name": "UCLA Blue", "hex": "#536895"},
            {"name": "UCLA Gold", "hex": "#FFB300"},
            {"name": "UFO Green", "hex": "#3CD070"},
            {"name": "Ultramarine", "hex": "#3F00FF"},
            {"name": "Ultramarine blue", "hex": "#4166F5"},
            {"name": "Ultra pink", "hex": "#FF6FFF"},
            {"name": "Ultra red", "hex": "#FC6C85"},
            {"name": "Umber", "hex": "#635147"},
            {"name": "Unbleached silk", "hex": "#FFDDCA"},
            {"name": "United Nations blue", "hex": "#5B92E5"},
            {"name": "University of California Gold", "hex": "#B78727"},
            {"name": "Unmellow yellow", "hex": "#FFFF66"},
            {"name": "UP Forest green", "hex": "#014421"},
            {"name": "UP Maroon", "hex": "#7B1113"},
            {"name": "Upsdell red", "hex": "#AE2029"},
            {"name": "Urobilin", "hex": "#E1AD21"},
            {"name": "USAFA blue", "hex": "#004F98"},
            {"name": "USC Cardinal", "hex": "#990000"},
            {"name": "USC Gold", "hex": "#FFCC00"},
            {"name": "University of Tennessee Orange", "hex": "#F77F00"},
            {"name": "Utah Crimson", "hex": "#D3003F"},
            {"name": "Van Dyke Brown", "hex": "#664228"},
            {"name": "Vanilla", "hex": "#F3E5AB"},
            {"name": "Vanilla ice", "hex": "#F38FA9"},
            {"name": "Vegas gold", "hex": "#C5B358"},
            {"name": "Venetian red", "hex": "#C80815"},
            {"name": "Verdigris", "hex": "#43B3AE"},
            {"name": "Vermilion", "hex": "#E34234"},
            {"name": "Vermilion", "hex": "#D9381E"},
            {"name": "Veronica", "hex": "#A020F0"},
            {"name": "Very light azure", "hex": "#74BBFB"},
            {"name": "Very light blue", "hex": "#6666FF"},
            {"name": "Very light malachite green", "hex": "#64E986"},
            {"name": "Very light tangelo", "hex": "#FFB077"},
            {"name": "Very pale orange", "hex": "#FFDFBF"},
            {"name": "Very pale yellow", "hex": "#FFFFBF"},
            {"name": "Violet", "hex": "#8F00FF"},
            {"name": "Violet (color wheel)", "hex": "#7F00FF"},
            {"name": "Violet (RYB)", "hex": "#8601AF"},
            {"name": "Violet (web)", "hex": "#EE82EE"},
            {"name": "Violet-blue", "hex": "#324AB2"},
            {"name": "Violet-red", "hex": "#F75394"},
            {"name": "Viridian", "hex": "#40826D"},
            {"name": "Viridian green", "hex": "#009698"},
            {"name": "Vista blue", "hex": "#7C9ED9"},
            {"name": "Vivid amber", "hex": "#CC9900"},
            {"name": "Vivid auburn", "hex": "#922724"},
            {"name": "Vivid burgundy", "hex": "#9F1D35"},
            {"name": "Vivid cerise", "hex": "#DA1D81"},
            {"name": "Vivid cerulean", "hex": "#00AAEE"},
            {"name": "Vivid crimson", "hex": "#CC0033"},
            {"name": "Vivid gamboge", "hex": "#FF9900"},
            {"name": "Vivid lime green", "hex": "#A6D608"},
            {"name": "Vivid malachite", "hex": "#00CC33"},
            {"name": "Vivid mulberry", "hex": "#B80CE3"},
            {"name": "Vivid orange", "hex": "#FF5F00"},
            {"name": "Vivid orange peel", "hex": "#FFA000"},
            {"name": "Vivid orchid", "hex": "#CC00FF"},
            {"name": "Vivid raspberry", "hex": "#FF006C"},
            {"name": "Vivid red", "hex": "#F70D1A"},
            {"name": "Vivid red-tangelo", "hex": "#DF6124"},
            {"name": "Vivid sky blue", "hex": "#00CCFF"},
            {"name": "Vivid tangelo", "hex": "#F07427"},
            {"name": "Vivid tangerine", "hex": "#FFA089"},
            {"name": "Vivid vermilion", "hex": "#E56024"},
            {"name": "Vivid violet", "hex": "#9F00FF"},
            {"name": "Vivid yellow", "hex": "#FFE302"},
            {"name": "Volt", "hex": "#CEFF00"},
            {"name": "Wageningen Green", "hex": "#34B233"},
            {"name": "Warm black", "hex": "#004242"},
            {"name": "Waterspout", "hex": "#A4F4F9"},
            {"name": "Weldon Blue", "hex": "#7C98AB"},
            {"name": "Wenge", "hex": "#645452"},
            {"name": "Wheat", "hex": "#F5DEB3"},
            {"name": "White", "hex": "#FFFFFF"},
            {"name": "White smoke", "hex": "#F5F5F5"},
            {"name": "Wild blue yonder", "hex": "#A2ADD0"},
            {"name": "Wild orchid", "hex": "#D470A2"},
            {"name": "Wild Strawberry", "hex": "#FF43A4"},
            {"name": "Wild watermelon", "hex": "#FC6C85"},
            {"name": "Willpower orange", "hex": "#FD5800"},
            {"name": "Windsor tan", "hex": "#A75502"},
            {"name": "Wine", "hex": "#722F37"},
            {"name": "Wine dregs", "hex": "#673147"},
            {"name": "Winter Sky", "hex": "#FF007C"},
            {"name": "Winter Wizard", "hex": "#A0E6FF"},
            {"name": "Wintergreen Dream", "hex": "#56887D"},
            {"name": "Wisteria", "hex": "#C9A0DC"},
            {"name": "Wood brown", "hex": "#C19A6B"},
            {"name": "Xanadu", "hex": "#738678"},
            {"name": "Yale Blue", "hex": "#0F4D92"},
            {"name": "Yankees blue", "hex": "#1C2841"},
            {"name": "Yellow", "hex": "#FFFF00"},
            {"name": "Yellow (Crayola)", "hex": "#FCE883"},
            {"name": "Yellow (Munsell)", "hex": "#EFCC00"},
            {"name": "Yellow (NCS)", "hex": "#FFD300"},
            {"name": "Yellow (Pantone)", "hex": "#FEDF00"},
            {"name": "Yellow (process)", "hex": "#FFEF00"},
            {"name": "Yellow (RYB)", "hex": "#FEFE33"},
            {"name": "Yellow-green", "hex": "#9ACD32"},
            {"name": "Yellow Orange", "hex": "#FFAE42"},
            {"name": "Yellow rose", "hex": "#FFF000"},
            {"name": "Yellow Sunshine", "hex": "#FFF700"},
            {"name": "Zaffre", "hex": "#0014A8"},
            {"name": "Zinnwaldite brown", "hex": "#2C1608"},
            {"name": "Zomp", "hex": "#39A78E"}
        ]

    def hex_to_rgb(self, hex_value):
        """
        Converts a hex color code to an RGB tuple.

        Parameters:
            hex_value (str): A string representing a hex color code (e.g., "#FFFFFF").

        Returns:
            tuple: A tuple representing the RGB values (e.g., (255, 255, 255)).
        """
        hex_value = hex_value.lstrip('#')
        return tuple(int(hex_value[i:i+2], 16) for i in (0, 2, 4))

    def rgb_to_hex(self, r, g, b):
        """
        Converts RGB values to a hex color code.

        Parameters:
            r (int): Red value (0-255).
            g (int): Green value (0-255).
            b (int): Blue value (0-255).

        Returns:
            str: A string representing the hex color code (e.g., "#FFFFFF").
        """
        return f"#{r:02X}{g:02X}{b:02X}"

    def closest_color_name(self, hex_value):
        """
        Finds the closest named color to the given hex value.

        Parameters:
            hex_value (str): A string representing a hex color code (e.g., "#FFFFFF").

        Returns:
            str: The name of the closest color from the list.
        """
        target_rgb = self.hex_to_rgb(hex_value)
        closest_color = None
        min_distance = float('inf')

        for color in self.color_list:
            current_rgb = self.hex_to_rgb(color['hex'])
            distance = sum((c1 - c2) ** 2 for c1,
                           c2 in zip(target_rgb, current_rgb))
            if distance < min_distance:
                min_distance = distance
                closest_color = color['name']

        return closest_color

    def get_color_by_name(self, name):
        """
        Returns the hex and RGB values of a color based on its name.

        Parameters:
            name (str): The name of the color to look up (e.g., "red").

        Returns:
            dict: A dictionary containing:
                - 'Name' (str): The color name in title case.
                - 'Hex' (str): The uppercase hex value (e.g., "#FF0000").
                - 'RGB' (tuple): The RGB values (e.g., (255, 0, 0)).
        """
        name = name.lower()
        for color in self.color_list:
            if color['name'].lower() == name:
                hex_value = color['hex'].upper()
                rgb_value = self.hex_to_rgb(color['hex'])
                return {
                    'Name': color['name'].title(),
                    'Hex': hex_value,
                    'RGB': rgb_value
                }
        return None
