<div align="center">

[![Botstrap Logo](https://raw.githubusercontent.com/nuztalgia/botstrap/main/docs/images/logo-192.png)](https://botstrap.readthedocs.io)

# Botstrap

[![License](https://img.shields.io/github/license/nuztalgia/botstrap)](https://github.com/nuztalgia/botstrap/blob/main/LICENSE)
[![Python Version](https://img.shields.io/pypi/pyversions/botstrap)](https://pypi.org/project/botstrap/)
[![PyPI Release](https://img.shields.io/pypi/v/botstrap)](https://pypi.org/project/botstrap/)
[![Read the Docs](https://img.shields.io/readthedocs/botstrap)](https://botstrap.readthedocs.io)
<br>
[![LGTM Lines of Code](https://badgen.net/lgtm/lines/g/nuztalgia/botstrap/python?label=lines%20of%20code&color=33aadd)](https://lgtm.com/projects/g/nuztalgia/botstrap/latest/files/botstrap/)
[![LGTM Code Quality](https://img.shields.io/lgtm/grade/python/github/nuztalgia/botstrap?label=code%20quality)](https://lgtm.com/projects/g/nuztalgia/botstrap/context:python)
[![Black Code Style](https://img.shields.io/badge/code%20style-black-000000)](https://github.com/psf/black)

An easy-to-use utility toolbelt for Discord bots written in Python.<br>
[**Read the docs »**](https://botstrap.readthedocs.io)

</div>

## Overview

Do you store your Discord bot token in
[plaintext](https://en.wikipedia.org/wiki/Plaintext)? Don't get caught with your pants
down. Strap in!

**Botstrap** is a ~~Python library~~ suit of power armor that perfectly fits your
Discord bot. It offers:

- 🔐 **Secure encryption** and password protection to keep your bot tokens safe
- 🤹 A straightforward way to **manage multiple tokens** and/or bot configurations
- 🌈 An intuitive, colorful, and easily-customizable **command-line interface**
- 🤝 Out-of-the-box **compatibility** with all of the most popular Python
  [Discord libraries](https://discord.com/developers/docs/topics/community-resources#libraries)
- ... and more to come!

## Installation

Python **3.10** or higher is required. It's also generally a good idea to upgrade pip
(`python -m pip install -U pip`).

```sh
pip install -U botstrap
```

For additional/alternative installation instructions, see the
[documentation](https://botstrap.readthedocs.io/en/latest/getting-started/).
