// -----------------------------------------------------------------------------
//
//  Gmsh GEO
//
//  Mesh size fields
//
// -----------------------------------------------------------------------------

//Use the following line to generate the mesh (.inp (abaqus))
//gmsh ThreePointBending.geo  -3 -o mesh.inp

h     =  1e-1;
hcrack= 0.005;


// ------------------------------------------------------
// ------------------------------------------------------
// A)Geometry Definition: 1)Points 
//                        2)Lines 
//                        3)Curve 
//                        4)Surface 

// ------------------------------------------------------
// A1)Points Definitions:                                  
//                                                     
//           7*-------------------------------*6 
//            |                               | 
//            |                               |
//            |                               |
//            |                *3             |
//            |               /\              | 
//            *--------------*  *-------------*
//            1             2    4            5
//    |Y               
//    |                
//    ---X          Dimensions:   8 x 2 x 0.01   
// Z /  

//           -----Coordinates--
//Points:    ----X,------Y,---Z,
Point(1)   ={ -4.0,    0.0,   0,  h};
Point(2)   ={ -0.2,    0.0,   0,  h};
Point(3)   ={  0.0,    0.4,   0,  h};
Point(4)   ={  0.2,    0.0,   0,  h};
Point(5)   ={  4.0,    0.0,   0,  h};
Point(6)   ={  4.0,    2.0,   0,  h};
Point(7)   ={ -4.0,    2.0,   0,  h};

// ------------------------------------------------------
// A2)Lines Definition
//
//                            <-L6
//            *-------------------------------* 
//            |                               | 
//            |                               | ^
//          L7|                               | L5
//          \/|                               |
//            |          L2 ^ /\ L3\/         | 
//            *--------------*  *-------------*
//                  L1->             L4->

Line(1) = {1, 2};
Line(2) = {2, 3};
Line(3) = {3, 4};
Line(4) = {4, 5};
Line(5) = {5, 6};
Line(6) = {6, 7};
Line(7) = {7, 1};


// ------------------------------------------------------
// A3)Curve Definition
//                            
//            *---------------<---------------* 
//            |                               | 
//            |                               | 
//           \/                               /\ 
//            |                               |
//            |               /\              | 
//            *------>-------*  *------>------*
//                              

Curve Loop(5) = {1,2,3,4,5,6,7}; //C5: through lines L1,L2,...,L7


// ------------------------------------------------------
// A4)Surface Definition
//                           
//            *-------------------------------* 
//            |                               | 
//            |                               | 
//            |      S6                       | 
//            |                               |
//            |               /\              | 
//            *--------------*  *-------------*
//                  

Plane Surface(6) = {5};


// ------------------------------------------------------
// ------------------------------------------------------
// B)Mesh Definition: 1)Mesh size Box1 
//                    2)Mesh size Box2
//                    3)Mesh size Box3
//                    4)Mesh size Box4
//                    5)Mesh min(Box1,Box2)
//                    6)Extrude Mesh 
//                    7)Mesh Algorithm  



// ------------------------------------------------------
// B1) Mesh size Box1
//
//            *-------------------------------* 
//            |              |A |             |  
//            |              |  |             |  A: Field[6] hcrack
//            |              |  |             | 
//            |              |  |             |
//            |              |/\|             | 
//            *--------------*  *-------------*
//

Field[6]      =    Box;
Field[6].VIn  = hcrack;
Field[6].VOut =      h;

Field[6].XMin = -0.2;
Field[6].XMax =  0.2;
Field[6].YMin =  0.0;
Field[6].YMax =  2.0;

// ------------------------------------------------------
// B2) Mesh size Box2
//
//            *-------------------------------* 
//            |            |B     |           |  
//            |            |      |           |  B: Field[7] hcrack*10
//            |            |      |           | 
//            |            |      |           |
//            |            |  /\  |           | 
//            *--------------*  *-------------*
//

Field[7]      =       Box;
Field[7].VIn  = hcrack*10;
Field[7].VOut =         h;

Field[7].XMin =      -0.4;
Field[7].XMax =       0.4;
Field[7].YMin =       0.0;
Field[7].YMax =       2.0;

// ------------------------------------------------------
// B3) Mesh size Box3
//
//            *-------------------------------* 
//            |                               |  
//            |                               |  C: Field[8] hcrack
//            |                               | 
//            |___                            |
//            | C |           /\              | 
//            *--------------*  *-------------*
//

Field[8]      =       Box;
Field[8].VIn  =    hcrack;
Field[8].VOut =         h;

Field[8].XMin =      -4.0;
Field[8].XMax =      -3.9;
Field[8].YMin =       0.0;
Field[8].YMax =       0.1;


// ------------------------------------------------------
// B4) Mesh size Box4
//
//            *-------------------------------* 
//            |                               |  
//            |                               |  D: Field[8] hcrack
//            |                               | 
//            |                            ___|
//            |               /\          | D | 
//            *--------------*  *-------------*
//

Field[9]      =       Box;
Field[9].VIn  =    hcrack;
Field[9].VOut =         h;

Field[9].XMin =       3.9;
Field[9].XMax =       4.0;
Field[9].YMin =       0.0;
Field[9].YMax =       0.1;


// ------------------------------------------------------
// B5) Mesh min(Box1,Box2,Box3,Box4)
//
//            *-------------------------------* 
//            |            |B| A| |           |  
//            |            | |  | |           | 
//            |            | |  | |           | Field[10]
//            |___         | |  | |        ___|
//            | C |        | |/\| |       | D | 
//            *--------------*  *-------------*
//

Field[10] = Min;
Field[10].FieldsList = {6,7,8,9};
Background Field = 10;


// ------------------------------------------------------
// B4)Extrude Mesh

//      {X, Y,    Z} Surface
Extrude {0, 0, 0.01}{Surface{6}; Layers{1};Recombine;}

// ------------------------------------------------------
// B5)Mesh Algorithm

Geometry.Tolerance = 1e-12;
Mesh.Algorithm3D   = 1;



