# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['xfers_sdk',
 'xfers_sdk.models',
 'xfers_sdk.models.balance',
 'xfers_sdk.models.balance.entity',
 'xfers_sdk.models.bank',
 'xfers_sdk.models.bank.entity',
 'xfers_sdk.models.disbursements',
 'xfers_sdk.models.disbursements.entity',
 'xfers_sdk.models.payment',
 'xfers_sdk.models.payment.entity',
 'xfers_sdk.models.payment_link',
 'xfers_sdk.models.payment_link.entity',
 'xfers_sdk.models.payment_methods',
 'xfers_sdk.models.payment_methods.entity',
 'xfers_sdk.network']

package_data = \
{'': ['*']}

install_requires = \
['dacite>=1.6.0,<2.0.0', 'pyhumps>=3.5.3,<4.0.0', 'requests>=2.27.1,<3.0.0']

setup_kwargs = {
    'name': 'xfers-sdk',
    'version': '1.0.1',
    'description': 'Xfers REST API Client for Python',
    'long_description': '# Xfers Python Library\n\nThis library is the abstraction of Xfers API for access from applications written with Python.\n\n## Table of Contents\n\n- [API Documentation](#api-documentation)\n- [Requirements](#requirements)\n- [Installation](#installation)\n- [Usage](#usage)\n  - [API Key](#api-key)\n  - [Using Custom HTTP Client](#using-custom-http-client)\n  - [Balance](#balance)\n    - [Get Balance](#get-balance)\n  - [Bank](#bank)\n    - [Bank Account Validation](#bank-account-validation)\n    - [List Disbursement Banks](#list-disbursement-bank)\n  - [Payment](#payment)\n    - [Virtual Account](#virtual-account)\n    - [QRIS](#qris)\n    - [Retail Outlet](#retail-outlet)\n    - [E-Wallet](#e-wallet)\n  - [Retrieve a Payment](#retrieve-a-payment)\n  - [Managing Payments](#managing-payments)\n  - [Disbursements](#disbursements)\n\n    \n## API Documentation\nPlease check [Xfers API Reference](https://docs.xfers.com/reference).\n\n## Requirements\n\nPython 3.7 or later\n\n## Installation\n\nTo use the package, run ```pip install xfers-sdk```\n\n## Usage\n\n### API Key\n\n```python\nfrom landx_xfers_sdk import Xfers\nxfers = Xfers(api_key="test-key123", secret_key="12345678")\n\n# Then access each class from x attribute\nbalance = xfers.Balance\nbalance.get()\n```\n\n\n### Balance\n\n#### Get Balance\n\n```python\nbalance = xfers.Balance\nbalance.get()\n```\n\nUsage example:\n\n```python\nfrom landx_xfers_sdk import Xfers\nxfers = Xfers(api_key="test-key123", secret_key="12345678", production=False)\n\n# Then access each class from x attribute\nbalance = xfers.Balance\nprint(balance.get())\n``` \n\nReference: https://docs.xfers.com/reference/account-balance\n\n### Bank Service\n\n#### Bank Account Validation\n\n```python\nbank = xfers.Bank\nbank.account_validation(account_no="123456", bank_short_code="BNI")\n```\n\nReference: https://docs.xfers.com/reference/bank-account-validation\n\n#### List Disbursement Banks\n```python\nbank = xfers.Bank\nbank.list()\n```\n\nReference: https://docs.xfers.com/reference/list-disbursement-banks\n\n### Payment\n\nThere are 2 main ways to accept payments with Xfers.\n\n-  One time payment\n  Use `xfers.Payment` instance\n- Persistent payment method linked to one of your customers\n  Use `xfers.PaymentMethod` instance\n\nReference: https://docs.xfers.com/docs/accepting-payments\n\n\n\n#### Virtual Account\n\n\n##### Create One Time Payment\n\n```python\npayment = xfers.Payment\npayment.create(\n  type="virtual_bank_account",\n  amount=10000,\n  expired_at=datetime.now() +  timedelta(days=1), # One Day\n  reference_id="va_12345678",\n  bank_short_code="SAHABAT_SAMPOERNA",\n  display_name="Your preferred name",\n  description="Payment Description"\n  # suffix_no="12345678"\n)\n```\n\nAPI Reference: https://docs.xfers.com/reference/create-payment\n\n##### Create Persistent Payment\n\n```python\npayment_method = xfers.PaymentMethod\npayment_method.create(\n  type="virtual_bank_accounts",\n  reference_id="12345678",\n  bank_short_code="SAHABAT_SAMPOERNA",\n  display_name="Your preferred name",\n  # suffix_no="12345678"\n)\n```\n\nAPI Reference: https://docs.xfers.com/reference/create-payment-method\n\n\n\n#### QRIS\n\n##### Create One Time Payment\n\n```python\npayment = xfers.Payment\npayment.create(\n  type="qris",\n  amount=10000,\n  expired_at=datetime.now() +  timedelta(days=1), # One Day\n  reference_id="qris_12345678",\n  display_name="Your preferred name",\n  description="Payment Description"\n)\n```\n\nAPI Reference: https://docs.xfers.com/reference/create-payment\n\n##### Create Persistent Payment\n\n```python\npayment_method = xfers.PaymentMethod\npayment_method.create(\n  type="qris",\n  reference_id="12345678",\n  display_name="Your preferred name"\n)\n```\n\nAPI Reference: https://docs.xfers.com/reference/create-payment-method\n\n\n\n#### Retail Outlet\n\n##### Create Payment\n\n```python\npayment = xfers.Payment\npayment.create(\n  type="retail_outlet",\n  amount=10000,\n  expired_at=datetime.now() +  timedelta(days=1), # One Day\n  reference_id="qris_12345678",\n  retail_outlet_name="ALFAMART",\n  display_name="Your preferred name",\n  description="Payment Description"\n)\n```\nAvailable Outlets: https://docs.xfers.com/docs/retail-store#available-outlets\n\nAPI Reference: https://docs.xfers.com/reference/create-payment\n\n\n\n####  E-Wallet\n\n##### Create Payment\n\n```python\npayment = xfers.Payment\npayment.create(\n  type="e-wallet",\n  amount=10000,\n  expired_at=datetime.now() +  timedelta(days=1), # One Day\n  reference_id="qris_12345678",\n  provider_code="SHOPEEPAY",\n  after_settlement_return_url="https://pay.examplessee.co.id/return-pay-here?0340450",\n  display_name="Your preferred name",\n  description="Payment Description"\n)\n```\nList of E-Wallet: https://docs.xfers.com/docs/e-wallet#list-of-e-wallet\n\nAPI Reference: https://docs.xfers.com/reference/create-payment\n\n#### Retrieve a Payment\n\nRetrieves a Payment object that was previously requested.\n\n###### One time payment\n\n```python\npayment = xfers.Payment\npayment.get(payment_id="va_1234567")\n```\n\nAPI Reference: https://docs.xfers.com/reference/retrieve-payment\n\n###### Persistent payment\n\ntype = The type of payment method. Currently support "virtual_bank_accounts" and "qris".\n\n```python\npayment_method = xfers.PaymentMethod\npayment_method.get(type="virtual_bank_accounts", payment_id="va_1234567")\n```\n\nAPI Reference: https://docs.xfers.com/reference/retrieve-payment-method\n\n\n\n### Managing Payments\n\n#### Persistent Payment (PaymentMethod)\n\n##### Receive Payment\n\nSimulates a payment received from the customer for a given payment. Status will be changed to \'paid\'.\n\n```python\npayment_method = xfers.PaymentMethod\npayment_method.receive_payment(\n  payment_method_id="va_123456789",\n  amount=90000\n)\n```\n\n#### One Time Payment (Payment)\n\n##### Receive Payment [Sandbox Mode]\n\nSimulates a payment received from the customer for a given payment. Status will be changed to \'paid\'.\n\n```python\npayment = xfers.Payment\npayment.receive_payment(\n  payment_method_id="va_123456789",\n)\n```\n\n##### Receive Payment [Sandbox Mode]\n\nSimulates a payment received from the customer for a given payment. Status will be changed to \'paid\'.\n\n```python\npayment = xfers.Payment\npayment.receive_payment(\n  payment_method_id="va_123456789",\n)\n```\n\n##### Cancel Payment\n\nCancel a payment when it is still in pending state. Status will be changed to \'cancelled\'.\n(This is only available for One-off Virtual Account at the moment.)\n\n\n```python\npayment = xfers.Payment\npayment.cancel(\n  payment_method_id="va_123456789",\n)\n```\n\n##### Settle Payment [Sandbox Mode]\n\nSimulates funds for a payment being made available for transfer or withdrawal. Status will be changed to \'completed\'.\n\n\n```python\npayment = xfers.Payment\npayment.settle(\n  payment_method_id="va_123456789",\n)\n```\n\n### Disbursements\n\n#### Create Disbursements\nCreates a Disbursement object that will send funds from your Xfers account to an intended recipient.\n\n```python\nxfers.Disbursements.create(amount="10000",\n                      reference_id="123",\n                      bank_shortcode="BCA",\n                      bank_account_no="0123123123",\n                      bank_account_holder_name="john doe")\n```\n\n### Retrieve a Disbursement\nRetrieves a Disbursement object that was previously requested.\n\n```python\nxfers.Disbursements.get(disbursement_id="id")\n```\n\n### List All Disbursement\nReturns a list of Disbursements.\n\n```python\nxfers.Disbursements.list(created_after="2022-04-15")\n```\n',
    'author': 'LandX Engineering',
    'author_email': 'tech@landx.id',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
