# Copyright (C) 2022 - 2024 ANSYS, Inc. and/or its affiliates.
# SPDX-License-Identifier: MIT
#
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

# DO NOT EDIT.
# This file is automatically generated from the JMS schemas.

"""Module providing the task definition template resource."""
from datetime import datetime
from typing import Any, Dict, List, Union

from marshmallow.utils import missing

from ansys.hps.client.common import Object

from ..schema.task_definition_template import (
    TaskDefinitionTemplateSchema,
    TemplateInputFileSchema,
    TemplateOutputFileSchema,
    TemplatePropertySchema,
    TemplateResourceRequirementsSchema,
)
from .task_definition import HpcResources, Software, WorkerContext


class TemplateProperty(Object):
    """Provides the template property resource.

    Parameters
    ----------
    default : any, optional
        Default value.
    description : str, optional
        Description of the property's purpose.
    type : str, optional
        Type of the property. Options are ``bool``, ``float``, ``int``, and ``string``.
    value_list : any, optional
        List of possible values for the property.
    """

    class Meta:
        schema = TemplatePropertySchema
        rest_name = "None"

    def __init__(
        self,
        default: Any = missing,
        description: str = missing,
        type: str = missing,
        value_list: Any = missing,
        **kwargs,
    ):
        self.default = default
        self.description = description
        self.type = type
        self.value_list = value_list

        self.obj_type = self.__class__.__name__


TemplatePropertySchema.Meta.object_class = TemplateProperty


class TemplateResourceRequirements(Object):
    """Provides the template resource requirements resource.

    Parameters
    ----------
    platform : TemplateProperty, optional
    memory : TemplateProperty, optional
    num_cores : TemplateProperty, optional
    disk_space : TemplateProperty, optional
    distributed : TemplateProperty, optional
    compute_resource_set_id : TemplateProperty, optional
    evaluator_id : TemplateProperty, optional
    custom : dict[str, TemplateProperty], optional
    hpc_resources : HpcResources, optional
    """

    class Meta:
        schema = TemplateResourceRequirementsSchema
        rest_name = "None"

    def __init__(
        self,
        platform: TemplateProperty = missing,
        memory: TemplateProperty = missing,
        num_cores: TemplateProperty = missing,
        disk_space: TemplateProperty = missing,
        distributed: TemplateProperty = missing,
        compute_resource_set_id: TemplateProperty = missing,
        evaluator_id: TemplateProperty = missing,
        custom: Dict[str, TemplateProperty] = missing,
        hpc_resources: HpcResources = missing,
        **kwargs,
    ):
        self.platform = platform
        self.memory = memory
        self.num_cores = num_cores
        self.disk_space = disk_space
        self.distributed = distributed
        self.compute_resource_set_id = compute_resource_set_id
        self.evaluator_id = evaluator_id
        self.custom = custom
        self.hpc_resources = hpc_resources

        self.obj_type = self.__class__.__name__


TemplateResourceRequirementsSchema.Meta.object_class = TemplateResourceRequirements


class TemplateInputFile(Object):
    """Provides the template input file resource.

    Parameters
    ----------
    name : str
        Name of the file.
    type : str, optional
        MIME type of the file. For example, ``text/plain``.
    evaluation_path : str, optional
        Path that the file is expected to be found under during evaluation.
    description : str
        Description of the file's purpose.
    required : bool
        Whether the file is required by the task.
    """

    class Meta:
        schema = TemplateInputFileSchema
        rest_name = "None"

    def __init__(
        self,
        name: str = missing,
        type: str = missing,
        evaluation_path: str = missing,
        description: str = missing,
        required: bool = missing,
        **kwargs,
    ):
        self.name = name
        self.type = type
        self.evaluation_path = evaluation_path
        self.description = description
        self.required = required

        self.obj_type = self.__class__.__name__


TemplateInputFileSchema.Meta.object_class = TemplateInputFile


class TemplateOutputFile(Object):
    """Provides the template output file resource.

    Parameters
    ----------
    name : str
        Name of the file.
    type : str, optional
        MIME type of the file. For example, ``text/plain``.
    evaluation_path : str, optional
        Path that the file is expected to be found under during evaluation.
    description : str
        Description of the file's purpose.
    required : bool
        Whether the file is required by the task.
    monitor : bool, optional
        Whether to live monitor the file's contents.
    collect : bool, optional
        Whether to collect files per job.
    """

    class Meta:
        schema = TemplateOutputFileSchema
        rest_name = "None"

    def __init__(
        self,
        name: str = missing,
        type: str = missing,
        evaluation_path: str = missing,
        description: str = missing,
        required: bool = missing,
        monitor: bool = missing,
        collect: bool = missing,
        **kwargs,
    ):
        self.name = name
        self.type = type
        self.evaluation_path = evaluation_path
        self.description = description
        self.required = required
        self.monitor = monitor
        self.collect = collect

        self.obj_type = self.__class__.__name__


TemplateOutputFileSchema.Meta.object_class = TemplateOutputFile


class TaskDefinitionTemplate(Object):
    """Provides the task definition template resource.

    Parameters
    ----------
    id : str, optional
        Unique ID to access the resource, generated internally by the server on creation.
    modification_time : datetime, optional
        Last time in UTC (Coordinated Universal Time) that the object was modified.
    creation_time : datetime, optional
        Time in UTC when the object was created.
    name : str
        Name of the template.
    version : str, optional
        Version of the template.
    description : str, optional
        Description of the template.
    software_requirements : list[Software], optional
        List of required software.
    resource_requirements : TemplateResourceRequirements, optional
        Hardware requirements such as the number of cores, memory, and disk space.
    worker_context : WorkerContext, optional
        :class:`WorkerContext` object.
    execution_context : dict[str, TemplateProperty], optional
        Dictionary of additional arguments to pass to the executing command.
    environment : dict[str, TemplateProperty], optional
        Dictionary of environment variables to set for the executed process.
    execution_command : str, optional
        Command to execute. A command or execution script is required.
    use_execution_script : bool, optional
        Whether to run the task with the execution script or the execution command.
    execution_script_storage_id : str, optional
        Storage ID of the script to execute (command or execution script is required).
    execution_script_storage_bucket : str, optional
        File storage bucket where the execution script is located.
    input_files : list[TemplateInputFile], optional
        List of predefined input files.
    output_files : list[TemplateOutputFile], optional
        List of predefined output files.
    """

    class Meta:
        schema = TaskDefinitionTemplateSchema
        rest_name = "task_definition_templates"

    def __init__(
        self,
        id: str = missing,
        modification_time: datetime = missing,
        creation_time: datetime = missing,
        name: str = missing,
        version: str = missing,
        description: str = missing,
        software_requirements: List[Software] = missing,
        resource_requirements: TemplateResourceRequirements = missing,
        worker_context: WorkerContext = missing,
        execution_context: Dict[str, TemplateProperty] = missing,
        environment: Dict[str, TemplateProperty] = missing,
        execution_command: str = missing,
        use_execution_script: bool = missing,
        execution_script_storage_id: str = missing,
        execution_script_storage_bucket: str = missing,
        input_files: List[TemplateInputFile] = missing,
        output_files: List[TemplateOutputFile] = missing,
        **kwargs,
    ):
        self.id = id
        self.modification_time = modification_time
        self.creation_time = creation_time
        self.name = name
        self.version = version
        self.description = description
        self.software_requirements = software_requirements
        self.resource_requirements = resource_requirements
        self.worker_context = worker_context
        self.execution_context = execution_context
        self.environment = environment
        self.execution_command = execution_command
        self.use_execution_script = use_execution_script
        self.execution_script_storage_id = execution_script_storage_id
        self.execution_script_storage_bucket = execution_script_storage_bucket
        self.input_files = input_files
        self.output_files = output_files

        self.obj_type = self.__class__.__name__


TaskDefinitionTemplateSchema.Meta.object_class = TaskDefinitionTemplate
