# Copyright (C) 2022 - 2024 ANSYS, Inc. and/or its affiliates.
# SPDX-License-Identifier: MIT
#
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

# DO NOT EDIT.
# This file is automatically generated from the JMS schemas.

"""Module providing the task definition resource."""
from datetime import datetime
from typing import Any, Dict, List, Union

from marshmallow.utils import missing

from ansys.hps.client.common import Object

from ..schema.task_definition import (
    HpcResourcesSchema,
    LicensingSchema,
    ResourceRequirementsSchema,
    SoftwareSchema,
    SuccessCriteriaSchema,
    TaskDefinitionSchema,
    WorkerContextSchema,
)


class HpcResources(Object):
    """Provides the hpc resources resource.

    Parameters
    ----------
    num_cores_per_node : int, optional
        Number of cores per node.
    num_gpus_per_node : int, optional
        Number of GPUs per node.
    exclusive : bool, optional
        Whether a job can't share resources with other running jobs.
    queue : str, optional
        Name of the job scheduler queue.
    use_local_scratch : bool, optional
        Whether to use node local storage.
    native_submit_options : str, optional
        Additional command line options to pass directly to the scheduler.
    custom_orchestration_options : dict[str, Union[int, float, str, bool]], optional
        Dictionary of custom orchestration options.
    """

    class Meta:
        schema = HpcResourcesSchema
        rest_name = "None"

    def __init__(
        self,
        num_cores_per_node: int = missing,
        num_gpus_per_node: int = missing,
        exclusive: bool = missing,
        queue: str = missing,
        use_local_scratch: bool = missing,
        native_submit_options: str = missing,
        custom_orchestration_options: Dict[str, Union[int, float, str, bool]] = missing,
        **kwargs,
    ):
        self.num_cores_per_node = num_cores_per_node
        self.num_gpus_per_node = num_gpus_per_node
        self.exclusive = exclusive
        self.queue = queue
        self.use_local_scratch = use_local_scratch
        self.native_submit_options = native_submit_options
        self.custom_orchestration_options = custom_orchestration_options

        self.obj_type = self.__class__.__name__


HpcResourcesSchema.Meta.object_class = HpcResources


class ResourceRequirements(Object):
    """Provides the resource requirements resource.

    Parameters
    ----------
    platform : str, optional
        Basic platform information. Options are ``'linux'`` and ``'windows'``.
    memory : int, optional
        Amount of RAM in bytes.
    num_cores : float, optional
        Number of cores.
    disk_space : int, optional
        Amount of disk space in bytes.
    distributed : bool, optional
        Whether to enable distributed parallel processing.
    compute_resource_set_id : str, optional
        ID of the compute resource set that this task should run on.
    evaluator_id : str, optional
        ID of the evaluator that this task should run on.
    custom : dict[str, Union[int, float, str, bool]], optional
        Dictionary of custom resource requirements.
    hpc_resources : HpcResources, optional
        HPC resource requirements.
    """

    class Meta:
        schema = ResourceRequirementsSchema
        rest_name = "None"

    def __init__(
        self,
        platform: str = missing,
        memory: int = missing,
        num_cores: float = missing,
        disk_space: int = missing,
        distributed: bool = missing,
        compute_resource_set_id: str = missing,
        evaluator_id: str = missing,
        custom: Dict[str, Union[int, float, str, bool]] = missing,
        hpc_resources: HpcResources = missing,
        **kwargs,
    ):
        self.platform = platform
        self.memory = memory
        self.num_cores = num_cores
        self.disk_space = disk_space
        self.distributed = distributed
        self.compute_resource_set_id = compute_resource_set_id
        self.evaluator_id = evaluator_id
        self.custom = custom
        self.hpc_resources = hpc_resources

        self.obj_type = self.__class__.__name__


ResourceRequirementsSchema.Meta.object_class = ResourceRequirements


class Software(Object):
    """Provides the software resource.

    Parameters
    ----------
    name : str
        Name of the app.
    version : str, optional
        Version of the app.
    """

    class Meta:
        schema = SoftwareSchema
        rest_name = "None"

    def __init__(self, name: str = missing, version: str = missing, **kwargs):
        self.name = name
        self.version = version

        self.obj_type = self.__class__.__name__


SoftwareSchema.Meta.object_class = Software


class WorkerContext(Object):
    """Provides the worker context resource.

    Parameters
    ----------
    max_runtime : int, optional
        Maximum run time (in seconds) for an ephemeral evaluator.
    max_num_parallel_tasks : int, optional
        Maximum number of tasks that an ephemeral evaluator can run in parallel.
    """

    class Meta:
        schema = WorkerContextSchema
        rest_name = "None"

    def __init__(self, max_runtime: int = missing, max_num_parallel_tasks: int = missing, **kwargs):
        self.max_runtime = max_runtime
        self.max_num_parallel_tasks = max_num_parallel_tasks

        self.obj_type = self.__class__.__name__


WorkerContextSchema.Meta.object_class = WorkerContext


class SuccessCriteria(Object):
    """Provides the success criteria resource.

    Parameters
    ----------
    return_code : int, optional
        Process exit code that must be returned by the executed command.
    expressions : list, optional
        List of expressions to evaluate.
    required_output_file_ids : list[str], optional
        List of IDs of the required output files.
    require_all_output_files : bool, optional
        Whether to require all output files.
    required_output_parameter_ids : list[str], optional
        List of names of the required output parameters.
    require_all_output_parameters : bool, optional
        Whether to require all output parameters.
    """

    class Meta:
        schema = SuccessCriteriaSchema
        rest_name = "None"

    def __init__(
        self,
        return_code: int = missing,
        expressions: List = missing,
        required_output_file_ids: List[str] = missing,
        require_all_output_files: bool = missing,
        required_output_parameter_ids: List[str] = missing,
        require_all_output_parameters: bool = missing,
        **kwargs,
    ):
        self.return_code = return_code
        self.expressions = expressions
        self.required_output_file_ids = required_output_file_ids
        self.require_all_output_files = require_all_output_files
        self.required_output_parameter_ids = required_output_parameter_ids
        self.require_all_output_parameters = require_all_output_parameters

        self.obj_type = self.__class__.__name__


SuccessCriteriaSchema.Meta.object_class = SuccessCriteria


class Licensing(Object):
    """Provides the licensing resource.

    Parameters
    ----------
    enable_shared_licensing : bool, optional
        Whether to enable shared licensing contexts for Ansys simulations.
    """

    class Meta:
        schema = LicensingSchema
        rest_name = "None"

    def __init__(self, enable_shared_licensing: bool = missing, **kwargs):
        self.enable_shared_licensing = enable_shared_licensing

        self.obj_type = self.__class__.__name__


LicensingSchema.Meta.object_class = Licensing


class TaskDefinition(Object):
    """Provides the task definition resource.

    Parameters
    ----------
    id : str, optional
        Unique ID to access the resource, generated internally by the server on creation.
    creation_time : datetime, optional
        Date and time that the resource was created.
    modification_time : datetime, optional
        Date and time that the resource was last modified.
    created_by : str, optional
        ID of the user who created the object.
    modified_by : str, optional
        ID of the user who last modified the object.
    name : str, optional
        Name.
    execution_command : str, optional
        Command to execute. A command or execution script is required.
    use_execution_script : bool, optional
        Whether to run the task with the execution script or the execution command.
    execution_script_id : str, optional
        Script to execute. A command or execution script is required.
    execution_level : int
        Execution level for the task.
    execution_context : dict[str, Union[int, float, str, bool]], optional
        Additional arguments to pass to the executing command.
    environment : dict[str, str], optional
        Environment variables to set for the executed process.
    max_execution_time : float, optional
        Maximum time in seconds for executing the task.
    num_trials : int, optional
        Maximum number of attempts for executing the task.
    store_output : bool, optional
        Whether to store the standard output of the task.
    input_file_ids : list[str]
        List of IDs of input files.
    output_file_ids : list[str]
        List of IDs of output files.
    success_criteria : SuccessCriteria, optional
    licensing : Licensing, optional
        :class:`Licensing` object.
    software_requirements : list[Software], optional
        List of :class:`Software` objects.
    resource_requirements : ResourceRequirements, optional
        :class:`ResourceRequirements` object.
    worker_context : WorkerContext, optional
        :class:`WorkerContext` object.
    """

    class Meta:
        schema = TaskDefinitionSchema
        rest_name = "task_definitions"

    def __init__(
        self,
        id: str = missing,
        creation_time: datetime = missing,
        modification_time: datetime = missing,
        created_by: str = missing,
        modified_by: str = missing,
        name: str = missing,
        execution_command: str = missing,
        use_execution_script: bool = missing,
        execution_script_id: str = missing,
        execution_level: int = missing,
        execution_context: Dict[str, Union[int, float, str, bool]] = missing,
        environment: Dict[str, str] = missing,
        max_execution_time: float = missing,
        num_trials: int = missing,
        store_output: bool = missing,
        input_file_ids: List[str] = missing,
        output_file_ids: List[str] = missing,
        success_criteria: SuccessCriteria = missing,
        licensing: Licensing = missing,
        software_requirements: List[Software] = missing,
        resource_requirements: ResourceRequirements = missing,
        worker_context: WorkerContext = missing,
        **kwargs,
    ):
        self.id = id
        self.creation_time = creation_time
        self.modification_time = modification_time
        self.created_by = created_by
        self.modified_by = modified_by
        self.name = name
        self.execution_command = execution_command
        self.use_execution_script = use_execution_script
        self.execution_script_id = execution_script_id
        self.execution_level = execution_level
        self.execution_context = execution_context
        self.environment = environment
        self.max_execution_time = max_execution_time
        self.num_trials = num_trials
        self.store_output = store_output
        self.input_file_ids = input_file_ids
        self.output_file_ids = output_file_ids
        self.success_criteria = success_criteria
        self.licensing = licensing
        self.software_requirements = software_requirements
        self.resource_requirements = resource_requirements
        self.worker_context = worker_context

        self.obj_type = self.__class__.__name__


TaskDefinitionSchema.Meta.object_class = TaskDefinition
