# Copyright (C) 2022 - 2024 ANSYS, Inc. and/or its affiliates.
# SPDX-License-Identifier: MIT
#
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

# DO NOT EDIT.
# This file is automatically generated from the JMS schemas.

"""Module providing the parameter definition resource."""
from datetime import datetime
from typing import Any, Dict, List, Union

from marshmallow.utils import missing

from ansys.hps.client.common import Object

from ..schema.parameter_definition import (
    BoolParameterDefinitionSchema,
    FloatParameterDefinitionSchema,
    IntParameterDefinitionSchema,
    ParameterDefinitionSchema,
    StringParameterDefinitionSchema,
)


class ParameterDefinition(Object):
    """Provides the parameter definition resource.

    Parameters
    ----------

    """

    class Meta:
        schema = ParameterDefinitionSchema
        rest_name = "parameter_definitions"

    def __init__(self, **kwargs):

        self.obj_type = self.__class__.__name__


ParameterDefinitionSchema.Meta.object_class = ParameterDefinition


class FloatParameterDefinition(ParameterDefinition):
    """Provides the float parameter definition resource.

    Parameters
    ----------
    id : str, optional
        Unique ID to access the resource, generated internally by the server on creation.
    creation_time : datetime, optional
        Date and time that the resource was created.
    modification_time : datetime, optional
        Date and time that the resource was last modified.
    created_by : str, optional
        ID of the user who created the object.
    modified_by : str, optional
        ID of the user who last modified the object.
    name : str, optional
        Name (ID) of the parameter.
    quantity_name : str, optional
        Name of the quantity that the parameter represents. For example, ``Length``.
    units : str, optional
        Units for the parameter.
    display_text : str, optional
        Text to display as the parameter name.
    mode : str
        Indicates whether it's an input or output parameter. The mode is filled server-side.
    type : str
    default : float, optional
        Default parameter value.
    lower_limit : float, optional
        Lower bound for the parameter value.
    upper_limit : float, optional
        Upper bound for the parameter value.
    step : float, optional
        If provided, allowable values are given by: AllowableValue = lower_limit + n * step, where n is an integer and AllowableValue <= upper_limit.
    cyclic : bool, optional
        Whether the parameter is cyclic.
    value_list : list, optional
        List of allowed values. This parameter provides an alternative to specifying upper and lower limits.
    """

    class Meta:
        schema = FloatParameterDefinitionSchema
        rest_name = "parameter_definitions"

    def __init__(
        self,
        id: str = missing,
        creation_time: datetime = missing,
        modification_time: datetime = missing,
        created_by: str = missing,
        modified_by: str = missing,
        name: str = missing,
        quantity_name: str = missing,
        units: str = missing,
        display_text: str = missing,
        mode: str = missing,
        type: str = missing,
        default: float = missing,
        lower_limit: float = missing,
        upper_limit: float = missing,
        step: float = missing,
        cyclic: bool = missing,
        value_list: List = missing,
        **kwargs,
    ):
        self.id = id
        self.creation_time = creation_time
        self.modification_time = modification_time
        self.created_by = created_by
        self.modified_by = modified_by
        self.name = name
        self.quantity_name = quantity_name
        self.units = units
        self.display_text = display_text
        self.mode = mode
        self.type = type
        self.default = default
        self.lower_limit = lower_limit
        self.upper_limit = upper_limit
        self.step = step
        self.cyclic = cyclic
        self.value_list = value_list

        self.obj_type = self.__class__.__name__


FloatParameterDefinitionSchema.Meta.object_class = FloatParameterDefinition


class IntParameterDefinition(ParameterDefinition):
    """Provides the int parameter definition resource.

    Parameters
    ----------
    id : str, optional
        Unique ID to access the resource, generated internally by the server on creation.
    creation_time : datetime, optional
        Date and time that the resource was created.
    modification_time : datetime, optional
        Date and time that the resource was last modified.
    created_by : str, optional
        ID of the user who created the object.
    modified_by : str, optional
        ID of the user who last modified the object.
    name : str, optional
        Name (ID) of the parameter.
    quantity_name : str, optional
        Name of the quantity that the parameter represents. For example, ``Length``.
    units : str, optional
        Units for the parameter.
    display_text : str, optional
        Text to display as the parameter name.
    mode : str
        Indicates whether it's an input or output parameter. The mode is filled server-side.
    type : str
    default : int, optional
        Default parameter value.
    lower_limit : int, optional
        Lower bound for the parameter value.
    upper_limit : int, optional
        Upper bound for the parameter value.
    step : int, optional
        The default is ``1``.
    cyclic : bool, optional
        Whether the parameter is cyclic.
    """

    class Meta:
        schema = IntParameterDefinitionSchema
        rest_name = "parameter_definitions"

    def __init__(
        self,
        id: str = missing,
        creation_time: datetime = missing,
        modification_time: datetime = missing,
        created_by: str = missing,
        modified_by: str = missing,
        name: str = missing,
        quantity_name: str = missing,
        units: str = missing,
        display_text: str = missing,
        mode: str = missing,
        type: str = missing,
        default: int = missing,
        lower_limit: int = missing,
        upper_limit: int = missing,
        step: int = missing,
        cyclic: bool = missing,
        **kwargs,
    ):
        self.id = id
        self.creation_time = creation_time
        self.modification_time = modification_time
        self.created_by = created_by
        self.modified_by = modified_by
        self.name = name
        self.quantity_name = quantity_name
        self.units = units
        self.display_text = display_text
        self.mode = mode
        self.type = type
        self.default = default
        self.lower_limit = lower_limit
        self.upper_limit = upper_limit
        self.step = step
        self.cyclic = cyclic

        self.obj_type = self.__class__.__name__


IntParameterDefinitionSchema.Meta.object_class = IntParameterDefinition


class BoolParameterDefinition(ParameterDefinition):
    """Provides the bool parameter definition resource.

    Parameters
    ----------
    id : str, optional
        Unique ID to access the resource, generated internally by the server on creation.
    creation_time : datetime, optional
        Date and time that the resource was created.
    modification_time : datetime, optional
        Date and time that the resource was last modified.
    created_by : str, optional
        ID of the user who created the object.
    modified_by : str, optional
        ID of the user who last modified the object.
    name : str, optional
        Name (ID) of the parameter.
    quantity_name : str, optional
        Name of the quantity that the parameter represents. For example, ``Length``.
    units : str, optional
        Units for the parameter.
    display_text : str, optional
        Text to display as the parameter name.
    mode : str
        Indicates whether it's an input or output parameter. The mode is filled server-side.
    type : str
    default : bool, optional
        Default parameter value.
    """

    class Meta:
        schema = BoolParameterDefinitionSchema
        rest_name = "parameter_definitions"

    def __init__(
        self,
        id: str = missing,
        creation_time: datetime = missing,
        modification_time: datetime = missing,
        created_by: str = missing,
        modified_by: str = missing,
        name: str = missing,
        quantity_name: str = missing,
        units: str = missing,
        display_text: str = missing,
        mode: str = missing,
        type: str = missing,
        default: bool = missing,
        **kwargs,
    ):
        self.id = id
        self.creation_time = creation_time
        self.modification_time = modification_time
        self.created_by = created_by
        self.modified_by = modified_by
        self.name = name
        self.quantity_name = quantity_name
        self.units = units
        self.display_text = display_text
        self.mode = mode
        self.type = type
        self.default = default

        self.obj_type = self.__class__.__name__


BoolParameterDefinitionSchema.Meta.object_class = BoolParameterDefinition


class StringParameterDefinition(ParameterDefinition):
    """Provides the string parameter definition resource.

    Parameters
    ----------
    id : str, optional
        Unique ID to access the resource, generated internally by the server on creation.
    creation_time : datetime, optional
        Date and time that the resource was created.
    modification_time : datetime, optional
        Date and time that the resource was last modified.
    created_by : str, optional
        ID of the user who created the object.
    modified_by : str, optional
        ID of the user who last modified the object.
    name : str, optional
        Name (ID) of the parameter.
    quantity_name : str, optional
        Name of the quantity that the parameter represents. For example, ``Length``.
    units : str, optional
        Units for the parameter.
    display_text : str, optional
        Text to display as the parameter name.
    mode : str
        Indicates whether it's an input or output parameter. The mode is filled server-side.
    type : str
    default : str, optional
        Default parameter value.
    value_list : list, optional
        List of allowed values.
    """

    class Meta:
        schema = StringParameterDefinitionSchema
        rest_name = "parameter_definitions"

    def __init__(
        self,
        id: str = missing,
        creation_time: datetime = missing,
        modification_time: datetime = missing,
        created_by: str = missing,
        modified_by: str = missing,
        name: str = missing,
        quantity_name: str = missing,
        units: str = missing,
        display_text: str = missing,
        mode: str = missing,
        type: str = missing,
        default: str = missing,
        value_list: List = missing,
        **kwargs,
    ):
        self.id = id
        self.creation_time = creation_time
        self.modification_time = modification_time
        self.created_by = created_by
        self.modified_by = modified_by
        self.name = name
        self.quantity_name = quantity_name
        self.units = units
        self.display_text = display_text
        self.mode = mode
        self.type = type
        self.default = default
        self.value_list = value_list

        self.obj_type = self.__class__.__name__


StringParameterDefinitionSchema.Meta.object_class = StringParameterDefinition
