# Copyright (C) 2022 - 2024 ANSYS, Inc. and/or its affiliates.
# SPDX-License-Identifier: MIT
#
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

# DO NOT EDIT.
# This file is automatically generated from the JMS schemas.

"""Module providing the operation resource."""
from datetime import datetime
from typing import Any, Dict, List, Union

from marshmallow.utils import missing

from ansys.hps.client.common import Object

from ..schema.operation import OperationSchema


class Operation(Object):
    """Provides the operation resource.

    Parameters
    ----------
    id : str, optional
        Unique ID to access the resource, generated internally by the server on creation.
    name : str, optional
    target : list, optional
    finished : bool, optional
    succeeded : bool, optional
    progress : float, optional
    status : str, optional
    result : dict, optional
    messages : list, optional
    start_time : datetime, optional
    end_time : datetime, optional
    """

    class Meta:
        schema = OperationSchema
        rest_name = "operations"

    def __init__(
        self,
        id: str = missing,
        name: str = missing,
        target: List = missing,
        finished: bool = missing,
        succeeded: bool = missing,
        progress: float = missing,
        status: str = missing,
        result: Dict = missing,
        messages: List = missing,
        start_time: datetime = missing,
        end_time: datetime = missing,
        **kwargs,
    ):
        self.id = id
        self.name = name
        self.target = target
        self.finished = finished
        self.succeeded = succeeded
        self.progress = progress
        self.status = status
        self.result = result
        self.messages = messages
        self.start_time = start_time
        self.end_time = end_time

        self.obj_type = self.__class__.__name__


OperationSchema.Meta.object_class = Operation
