# Copyright (C) 2022 - 2024 ANSYS, Inc. and/or its affiliates.
# SPDX-License-Identifier: MIT
#
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

# DO NOT EDIT.
# This file is automatically generated from the JMS schemas.

"""Module providing the job definition resource."""
from datetime import datetime
from typing import Any, Dict, List, Union

from marshmallow.utils import missing

from ansys.hps.client.common import Object

from ..schema.job_definition import JobDefinitionSchema
from .fitness_definition import FitnessDefinition


class JobDefinition(Object):
    """Provides the job definition resource.

    Parameters
    ----------
    id : str, optional
        Unique ID to access the resource, generated internally by the server on creation.
    creation_time : datetime, optional
        Date and time that the resource was created.
    modification_time : datetime, optional
        Date and time that the resource was last modified.
    created_by : str, optional
        ID of the user who created the object.
    modified_by : str, optional
        ID of the user who last modified the object.
    name : str, optional
        Name of the job definition.
    active : bool
        Whether this job definition is active.
    client_hash : str, optional
    parameter_definition_ids : list[str]
        List of parameter definition IDs.
    parameter_mapping_ids : list[str]
        List of parameter mapping IDs.
    task_definition_ids : list[str]
        List of task definition IDs.
    fitness_definition : FitnessDefinition, optional
        A :class:`FitnessDefinition` object.
    """

    class Meta:
        schema = JobDefinitionSchema
        rest_name = "job_definitions"

    def __init__(
        self,
        id: str = missing,
        creation_time: datetime = missing,
        modification_time: datetime = missing,
        created_by: str = missing,
        modified_by: str = missing,
        name: str = missing,
        active: bool = missing,
        client_hash: str = missing,
        parameter_definition_ids: List[str] = missing,
        parameter_mapping_ids: List[str] = missing,
        task_definition_ids: List[str] = missing,
        fitness_definition: FitnessDefinition = missing,
        **kwargs,
    ):
        self.id = id
        self.creation_time = creation_time
        self.modification_time = modification_time
        self.created_by = created_by
        self.modified_by = modified_by
        self.name = name
        self.active = active
        self.client_hash = client_hash
        self.parameter_definition_ids = parameter_definition_ids
        self.parameter_mapping_ids = parameter_mapping_ids
        self.task_definition_ids = task_definition_ids
        self.fitness_definition = fitness_definition

        self.obj_type = self.__class__.__name__


JobDefinitionSchema.Meta.object_class = JobDefinition
