/*
 * Decompiled with CFR 0.152.
 */
package org.pyjxslt;

import java.io.File;
import java.util.HashMap;
import org.pyjxslt.XSLTTransformer;

public class XSLTTransformerFactory {
    String basePath;
    HashMap<String, XSLTTransformer> transformers = new HashMap();
    Boolean debug = false;

    public XSLTTransformerFactory(String basePath) {
        this.basePath = basePath;
    }

    public void setDebug(Boolean val) {
        this.debug = val;
    }

    public XSLTTransformer transformer(String xsltFileName) {
        if (!this.transformers.containsKey(xsltFileName)) {
            XSLTTransformer xform = new XSLTTransformer(this.basePath + File.separator + xsltFileName);
            if (xform.isOK()) {
                this.transformers.put(xsltFileName, xform);
            } else {
                return null;
            }
        }
        return this.transformers.get(xsltFileName);
    }

    public Boolean removeTransformer(String key) {
        if (this.transformers.containsKey(key)) {
            this.transformers.remove(key);
            return true;
        }
        return false;
    }

    public XSLTTransformer transformer(String key, String xsltText) {
        if (!this.transformers.containsKey(key)) {
            XSLTTransformer xform = new XSLTTransformer(xsltText, true);
            if (xform.isOK()) {
                this.transformers.put(key, xform);
            } else {
                return null;
            }
        }
        return this.transformers.get(key);
    }
}

