/*
 * Decompiled with CFR 0.152.
 */
package org.pyjxslt;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Map;
import java.util.Scanner;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class XSLTTransformer {
    Transformer transformer = null;
    String transformerURL = null;

    public XSLTTransformer(String xsltURL) {
        this.transformerURL = xsltURL;
        TransformerFactory tFactory = TransformerFactory.newInstance();
        try {
            this.transformer = tFactory.newTransformer(new StreamSource(this.transformerURL));
        }
        catch (TransformerConfigurationException e) {
            System.err.println("Unable to load transformation: " + this.transformerURL);
        }
    }

    public XSLTTransformer(String xsltText, Boolean isText) {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        try {
            this.transformer = tFactory.newTransformer(new StreamSource(new StringReader(xsltText)));
        }
        catch (TransformerConfigurationException e) {
            System.err.println("Unable to load transformation: " + xsltText.substring(0, 20) + "...");
        }
    }

    public boolean isOK() {
        return this.transformer != null;
    }

    public String transform(String xml) {
        StringWriter xformOut = new StringWriter();
        if (this.transformer == null) {
            return "Missing transformer: " + this.transformerURL;
        }
        try {
            this.transformer.transform(new StreamSource(new StringReader(xml)), new StreamResult(xformOut));
        }
        catch (TransformerException e) {
            return "Transformer exception: " + e.getLocalizedMessage();
        }
        return this.prettify(xformOut.toString());
    }

    public String transform(String xml, Map<String, String> parms) {
        this.transformer.clearParameters();
        for (Map.Entry<String, String> pairs : parms.entrySet()) {
            this.transformer.setParameter(pairs.getKey(), pairs.getValue());
        }
        return this.transform(xml);
    }

    protected String prettify(String xformOut) {
        return xformOut;
    }

    public static void main(String[] args) throws TransformerException, IOException {
        Scanner scanner = new Scanner(new File(args[1]));
        scanner.useDelimiter("\\Z");
        System.out.println(new XSLTTransformer(args[0]).transform(scanner.next()).toString());
        scanner.close();
    }
}

