/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import java.io.File;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Configuration;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.PackageVersion;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.CompilerInfo;
import net.sf.saxon.trans.XPathException;

public class XsltPackage {
    private Processor processor;
    private StylesheetPackage stylesheetPackage;

    protected XsltPackage(Processor p, StylesheetPackage pp) {
        this.processor = p;
        this.stylesheetPackage = pp;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public String getName() {
        return this.stylesheetPackage.getPackageName();
    }

    public String getVersion() {
        return this.stylesheetPackage.getPackageVersion().toString();
    }

    public PackageVersion getPackageVersion() {
        return this.stylesheetPackage.getPackageVersion();
    }

    public XsltExecutable link() throws SaxonApiException {
        try {
            Configuration config = this.processor.getUnderlyingConfiguration();
            CompilerInfo info = config.makeCompilerInfo();
            Compilation compilation = new Compilation(config, info);
            this.stylesheetPackage.checkForAbstractComponents();
            PreparedStylesheet pss = new PreparedStylesheet(compilation);
            this.stylesheetPackage.updatePreparedStylesheet(pss);
            pss.addPackage(compilation.getPackageData());
            return new XsltExecutable(this.processor, pss);
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
    }

    public void save(File file) throws SaxonApiException {
        StreamResult destination = new StreamResult(file);
        ExpressionPresenter out = new ExpressionPresenter(this.processor.getUnderlyingConfiguration(), destination, true);
        try {
            this.stylesheetPackage.export(out);
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
    }

    public StylesheetPackage getUnderlyingPreparedPackage() {
        return this.stylesheetPackage;
    }
}

