/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.ReceivingContentHandler;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.StreamWriterToReceiver;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.ResultDocument;
import net.sf.saxon.lib.SaxonOutputKeys;
import net.sf.saxon.lib.SerializerFactory;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.query.QueryResult;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.serialize.CharacterMapIndex;
import net.sf.saxon.trans.XPathException;
import org.xml.sax.ContentHandler;

public class Serializer
implements Destination {
    private Processor processor;
    private Map<StructuredQName, String> properties = new HashMap<StructuredQName, String>(10);
    private StreamResult result = new StreamResult();
    private Properties defaultOutputProperties = null;
    private CharacterMapIndex characterMap = null;
    private boolean mustClose = false;
    private static Map<String, Property> standardProperties = new HashMap<String, Property>();

    private static void z(Property prop) {
        standardProperties.put(prop.name, prop);
    }

    public Serializer() {
    }

    public Serializer(OutputStream stream) {
        this.setOutputStream(stream);
    }

    public Serializer(Writer writer) {
        this.setOutputWriter(writer);
    }

    public Serializer(File file) {
        this.setOutputFile(file);
    }

    protected Serializer(Processor processor) {
        this.setProcessor(processor);
    }

    public void setProcessor(Processor processor) {
        if (processor == null) {
            throw new NullPointerException();
        }
        this.processor = processor;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    protected void setDefaultOutputProperties(Properties defaultProperties) {
        this.defaultOutputProperties = defaultProperties;
    }

    protected void setCharacterMap(CharacterMapIndex characterMap) {
        this.characterMap = characterMap;
    }

    public void setOutputProperty(Property property, String value) {
        try {
            value = SaxonOutputKeys.checkOutputProperty(property.toString(), value, null, true);
        }
        catch (XPathException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        if (value == null) {
            this.properties.remove(property.getQName().getStructuredQName());
        } else {
            this.properties.put(property.getQName().getStructuredQName(), value);
        }
    }

    public String getOutputProperty(Property property) {
        return this.properties.get(property.getQName().getStructuredQName());
    }

    public void setOutputProperty(QName property, String value) {
        String uri = property.getNamespaceURI();
        if (uri.isEmpty() || uri.equals("http://saxon.sf.net/")) {
            try {
                value = SaxonOutputKeys.checkOutputProperty(property.getClarkName(), value, null, true);
            }
            catch (XPathException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
            if (uri.equals("http://saxon.sf.net/") && property.getLocalName().equals("next-in-chain")) {
                return;
            }
        }
        if (value == null) {
            this.properties.remove(property.getStructuredQName());
        } else {
            this.properties.put(property.getStructuredQName(), value);
        }
    }

    public String getOutputProperty(QName property) {
        return this.properties.get(property.getStructuredQName());
    }

    public void setOutputWriter(Writer writer) {
        this.result.setOutputStream(null);
        this.result.setSystemId((String)null);
        this.result.setWriter(writer);
        this.mustClose = false;
    }

    public void setOutputStream(OutputStream stream) {
        this.result.setWriter(null);
        this.result.setSystemId((String)null);
        this.result.setOutputStream(stream);
        this.mustClose = false;
    }

    public void setOutputFile(File file) {
        this.result.setOutputStream(null);
        this.result.setWriter(null);
        this.result.setSystemId(file);
        this.mustClose = true;
    }

    public void serializeNode(XdmNode node) throws SaxonApiException {
        StreamResult res = this.result;
        if (res.getOutputStream() == null && res.getWriter() == null && res.getSystemId() == null) {
            throw new IllegalStateException("Either an outputStream, or a Writer, or a File must be supplied");
        }
        this.serializeNodeToResult(node, res);
    }

    public void serializeXdmValue(XdmValue value) throws SaxonApiException {
        if (value instanceof XdmNode) {
            this.serializeNode((XdmNode)value);
        } else {
            if (this.processor == null) {
                throw new IllegalStateException("The Serializer is not associated with any s9api Processor");
            }
            try {
                QueryResult.serializeSequence(value.getUnderlyingValue().iterate(), this.processor.getUnderlyingConfiguration(), this.result, this.getOutputProperties());
            }
            catch (XPathException e) {
                throw new SaxonApiException(e);
            }
        }
    }

    public String serializeNodeToString(XdmNode node) throws SaxonApiException {
        StringWriter sw = new StringWriter();
        StreamResult sr = new StreamResult(sw);
        this.serializeNodeToResult(node, sr);
        return sw.toString();
    }

    private void serializeNodeToResult(XdmNode node, Result res) throws SaxonApiException {
        try {
            QueryResult.serialize(node.getUnderlyingNode(), res, this.getOutputProperties());
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
    }

    public StreamWriterToReceiver getXMLStreamWriter() throws SaxonApiException {
        if (this.processor == null) {
            throw new IllegalStateException("This method is available only if a Processor has been set");
        }
        Receiver r = this.getReceiver(this.processor.getUnderlyingConfiguration());
        r = new NamespaceReducer(r);
        return new StreamWriterToReceiver(r);
    }

    public ContentHandler getContentHandler() throws SaxonApiException {
        if (this.processor == null) {
            throw new IllegalStateException("This method is available only if a Processor has been set");
        }
        Receiver r = this.getReceiver(this.processor.getUnderlyingConfiguration());
        r = new NamespaceReducer(r);
        ReceivingContentHandler rch = new ReceivingContentHandler();
        rch.setReceiver(r);
        return rch;
    }

    public Object getOutputDestination() {
        if (this.result.getOutputStream() != null) {
            return this.result.getOutputStream();
        }
        if (this.result.getWriter() != null) {
            return this.result.getWriter();
        }
        String systemId = this.result.getSystemId();
        if (systemId != null) {
            try {
                return new File(new URI(systemId));
            }
            catch (URISyntaxException e) {
                return null;
            }
        }
        return null;
    }

    public Receiver getReceiver(Configuration config) throws SaxonApiException {
        try {
            SerializerFactory sf = config.getSerializerFactory();
            PipelineConfiguration pipe = config.makePipelineConfiguration();
            Properties props = this.getOutputProperties();
            SequenceReceiver target = sf.getReceiver(this.result, pipe, props, this.characterMap);
            if (target.getSystemId() == null) {
                target.setSystemId(this.result.getSystemId());
            }
            return target;
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
    }

    public Receiver getReceiver(PipelineConfiguration pipe) throws SaxonApiException {
        try {
            Configuration config = pipe.getConfiguration();
            SerializerFactory sf = config.getSerializerFactory();
            Properties props = this.getOutputProperties();
            SequenceReceiver target = sf.getReceiver(this.result, pipe, props, this.characterMap);
            if (target.getSystemId() == null) {
                target.setSystemId(this.result.getSystemId());
            }
            return target;
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
    }

    protected Receiver getReceiver(Executable executable) throws SaxonApiException {
        try {
            Configuration config = executable.getConfiguration();
            SerializerFactory sf = config.getSerializerFactory();
            PipelineConfiguration pipe = config.makePipelineConfiguration();
            pipe.setHostLanguage(executable.getHostLanguage());
            Properties baseProps = executable.getDefaultOutputProperties();
            for (Map.Entry<StructuredQName, String> entry : this.properties.entrySet()) {
                StructuredQName name = entry.getKey();
                ResultDocument.setSerializationProperty(baseProps, name.getURI(), name.getLocalPart(), entry.getValue(), null, true, config);
            }
            SequenceReceiver target = sf.getReceiver(this.result, pipe, baseProps, executable.getCharacterMapIndex());
            if (target.getSystemId() == null) {
                target.setSystemId(this.result.getSystemId());
            }
            return target;
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
    }

    protected Properties getOutputProperties() {
        Properties props = this.defaultOutputProperties == null ? new Properties() : new Properties(this.defaultOutputProperties);
        for (StructuredQName p : this.properties.keySet()) {
            String value = this.properties.get(p);
            props.setProperty(p.getClarkName(), value);
        }
        return props;
    }

    protected Properties getLocalOutputProperties() {
        Properties props = new Properties();
        for (StructuredQName p : this.properties.keySet()) {
            String value = this.properties.get(p);
            props.setProperty(p.getClarkName(), value);
        }
        return props;
    }

    protected Result getResult() {
        return this.result;
    }

    public void close() throws SaxonApiException {
        if (this.mustClose) {
            Writer writer;
            OutputStream stream = this.result.getOutputStream();
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException err) {
                    throw new SaxonApiException("Failed while closing output file", err);
                }
            }
            if ((writer = this.result.getWriter()) != null) {
                try {
                    writer.close();
                }
                catch (IOException err) {
                    throw new SaxonApiException("Failed while closing output file", err);
                }
            }
        }
    }

    public static Property getProperty(QName name) {
        String clarkName = name.getClarkName();
        Property prop = standardProperties.get(clarkName);
        if (prop != null) {
            return prop;
        }
        throw new IllegalArgumentException("Unknown serialization property " + clarkName);
    }

    static {
        Serializer.z(Property.METHOD);
        Serializer.z(Property.VERSION);
        Serializer.z(Property.ENCODING);
        Serializer.z(Property.OMIT_XML_DECLARATION);
        Serializer.z(Property.STANDALONE);
        Serializer.z(Property.DOCTYPE_PUBLIC);
        Serializer.z(Property.DOCTYPE_SYSTEM);
        Serializer.z(Property.CDATA_SECTION_ELEMENTS);
        Serializer.z(Property.INDENT);
        Serializer.z(Property.MEDIA_TYPE);
        Serializer.z(Property.USE_CHARACTER_MAPS);
        Serializer.z(Property.INCLUDE_CONTENT_TYPE);
        Serializer.z(Property.UNDECLARE_PREFIXES);
        Serializer.z(Property.ESCAPE_URI_ATTRIBUTES);
        Serializer.z(Property.BYTE_ORDER_MARK);
        Serializer.z(Property.NORMALIZATION_FORM);
        Serializer.z(Property.ITEM_SEPARATOR);
        Serializer.z(Property.SAXON_INDENT_SPACES);
        Serializer.z(Property.SAXON_ATTRIBUTE_ORDER);
        Serializer.z(Property.SAXON_CHARACTER_REPRESENTATION);
        Serializer.z(Property.SAXON_DOUBLE_SPACE);
        Serializer.z(Property.SAXON_IMPLICIT_RESULT_DOCUMENT);
        Serializer.z(Property.SAXON_LINE_LENGTH);
        Serializer.z(Property.SAXON_RECOGNIZE_BINARY);
        Serializer.z(Property.SAXON_REQUIRE_WELL_FORMED);
        Serializer.z(Property.SAXON_STYLESHEET_VERSION);
        Serializer.z(Property.SAXON_SUPPLY_SOURCE_LOCATOR);
        Serializer.z(Property.SAXON_SUPPRESS_INDENTATION);
        Serializer.z(Property.SAXON_WRAP);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Property {
        METHOD("method"),
        VERSION("version"),
        ENCODING("encoding"),
        OMIT_XML_DECLARATION("omit-xml-declaration"),
        STANDALONE("standalone"),
        DOCTYPE_PUBLIC("doctype-public"),
        DOCTYPE_SYSTEM("doctype-system"),
        CDATA_SECTION_ELEMENTS("cdata-section-elements"),
        INDENT("indent"),
        MEDIA_TYPE("media-type"),
        USE_CHARACTER_MAPS("use-character-maps"),
        INCLUDE_CONTENT_TYPE("include-content-type"),
        UNDECLARE_PREFIXES("undeclare-prefixes"),
        ESCAPE_URI_ATTRIBUTES("escape-uri-attributes"),
        BYTE_ORDER_MARK("byte-order-mark"),
        NORMALIZATION_FORM("normalization-form"),
        ITEM_SEPARATOR("item-separator"),
        HTML_VERSION("html-version"),
        SAXON_INDENT_SPACES("{http://saxon.sf.net/}indent-spaces"),
        SAXON_LINE_LENGTH("{http://saxon.sf.net/}line-length"),
        SAXON_ATTRIBUTE_ORDER("{http://saxon.sf.net/}attribute-order"),
        SAXON_NEWLINE("{http://saxon.sf.net/}newline"),
        SAXON_SUPPRESS_INDENTATION("suppress-indentation"),
        SAXON_DOUBLE_SPACE("{http://saxon.sf.net/}double-space"),
        SAXON_STYLESHEET_VERSION("{http://saxon.sf.net/}stylesheet-version"),
        SAXON_CHARACTER_REPRESENTATION("{http://saxon.sf.net/}character-representation"),
        SAXON_RECOGNIZE_BINARY("{http://saxon.sf.net/}recognize-binary"),
        SAXON_REQUIRE_WELL_FORMED("{http://saxon.sf.net/}require-well-formed"),
        SAXON_WRAP("{http://saxon.sf.net/}wrap-result-sequence"),
        SAXON_IMPLICIT_RESULT_DOCUMENT("{http://saxon.sf.net/}implicit-result-document"),
        SAXON_SUPPLY_SOURCE_LOCATOR("{http://saxon.sf.net/}supply-source-locator");

        private String name;

        private Property(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public QName getQName() {
            return QName.fromClarkName(this.name);
        }

        public static Property get(String s) {
            for (Property p : Property.values()) {
                if (!p.name.equals(s)) continue;
                return p;
            }
            return null;
        }
    }
}

