/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.AugmentedSource;
import net.sf.saxon.lib.StandardOutputResolver;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.ma.arrays.ArrayItemType;
import net.sf.saxon.ma.map.HashTrieMap;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.ma.map.MapType;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmDestination;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.s9api.Xslt30Transformer;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.trans.StylesheetCache;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AtomicIterator;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import org.xml.sax.InputSource;

public class TransformFn
extends SystemFunction
implements Callable {
    private String[] transformOptionNames = new String[]{"xslt-version", "stylesheet-location", "stylesheet-node", "stylesheet-text", "stylesheet-base-uri", "base-output-uri", "stylesheet-params", "source-node", "initial-mode", "initial-template", "delivery-format", "serialization-params", "vendor-options", "cache", "package-name", "package-version", "package-node", "package-location", "static-params", "global-context-item", "template-params", "tunnel-params", "initial-function", "function-params"};
    private String[] transformOptionNames30 = new String[]{"package-name", "package-version", "package-node", "package-location", "static-params", "global-context-item", "template-params", "tunnel-params", "initial-function", "function-params"};
    private static final Map<String, SequenceType> requiredTypes = new HashMap<String, SequenceType>(40);

    private boolean isTransformOptionName(String string) {
        for (String s : this.transformOptionNames) {
            if (!s.equals(string)) continue;
            return true;
        }
        return false;
    }

    private boolean isTransformOptionName30(String string) {
        for (String s : this.transformOptionNames30) {
            if (!s.equals(string)) continue;
            return true;
        }
        return false;
    }

    private MapItem checkTransformOptions(MapItem map, XPathContext context, boolean isXslt30Processor) throws XPathException {
        AtomicValue key;
        HashTrieMap result = new HashTrieMap(context);
        if (map.size() == 0) {
            if (!isXslt30Processor) {
                throw new XPathException("A transform must be supplied with some options: exactly one of stylesheet-location|stylesheet-node|stylesheet-text, and source-node|initial-template", "FOXT0002");
            }
            throw new XPathException("A transform must be supplied with some options: providing some stylesheet or package, and invocation method", "FOXT0002");
        }
        TypeHierarchy th = context.getConfiguration().getTypeHierarchy();
        AtomicIterator keysIterator = map.keys();
        while ((key = keysIterator.next()) != null && key instanceof StringValue) {
            String keyName = key.getStringValue();
            if (this.isTransformOptionName30(keyName) && !isXslt30Processor) {
                throw new XPathException("The transform option " + keyName + " is only available when using an XSLT 3.0 processor", "FOXT0002");
            }
            if (!this.isTransformOptionName(keyName)) continue;
            RoleDiagnostic role = new RoleDiagnostic(15, keyName, 0);
            role.setErrorCode("FOXT0002");
            Sequence converted = th.applyFunctionConversionRules(map.get(key), requiredTypes.get(keyName), role, ExplicitLocation.UNKNOWN_LOCATION);
            converted = SequenceTool.toGroundedValue(converted);
            result = result.addEntry(key, converted);
        }
        return result;
    }

    private AtomicValue checkStylesheetMutualExclusion(AtomicIterator keysIterator) throws XPathException {
        AtomicValue key;
        boolean stylesheetOptionFound = false;
        AtomicValue styleOption = null;
        while ((key = keysIterator.next()) != null && key instanceof StringValue) {
            String name = key.getStringValue();
            if (!name.equals("stylesheet-location") && !name.equals("stylesheet-node") && !name.equals("stylesheet-text")) continue;
            if (stylesheetOptionFound) {
                throw new XPathException("The following transform options are mutually exclusive: stylesheet-location|stylesheet-node|stylesheet-text", "FOXT0002");
            }
            stylesheetOptionFound = true;
            styleOption = key;
        }
        if (styleOption == null) {
            throw new XPathException("A transform must be supplied with one of: stylesheet-location|stylesheet-node|stylesheet-text", "FOXT0002");
        }
        return styleOption;
    }

    private AtomicValue checkStylesheetMutualExclusion30(AtomicIterator keysIterator) throws XPathException {
        AtomicValue key;
        boolean stylesheetOptionFound = false;
        AtomicValue styleOption = null;
        while ((key = keysIterator.next()) != null && key instanceof StringValue) {
            String name = key.getStringValue();
            if (!name.equals("stylesheet-location") && !name.equals("stylesheet-node") && !name.equals("stylesheet-text") && !name.equals("package-name") && !name.equals("package-node") && !name.equals("package-location")) continue;
            if (stylesheetOptionFound) {
                throw new XPathException("The following transform options are mutually exclusive: stylesheet-location|stylesheet-node|stylesheet-text|package-name|package-node|package-location", "FOXT0002");
            }
            stylesheetOptionFound = true;
            styleOption = key;
        }
        if (styleOption == null) {
            throw new XPathException("A transform must be supplied with one of: stylesheet-location|stylesheet-node|stylesheet-text|package-name|package-node|package-location", "FOXT0002");
        }
        if (styleOption.getStringValue().equals("package-node") || styleOption.getStringValue().equals("package-location")) {
            throw new XPathException("The transform option " + styleOption.getStringValue() + " is not implemented in Saxon", "FOXT0002");
        }
        return styleOption;
    }

    private AtomicValue checkInvocationMutualExclusion(AtomicIterator keysIterator) throws XPathException {
        AtomicValue key;
        boolean invocationOptionFound = false;
        AtomicValue invocationOption = null;
        while ((key = keysIterator.next()) != null && key instanceof StringValue) {
            String name = key.getStringValue();
            if (!name.equals("initial-mode") && !name.equals("initial-template")) continue;
            if (invocationOptionFound) {
                throw new XPathException("The following transform options are mutually exclusive: initial-mode|initial-template", "FOXT0002");
            }
            invocationOptionFound = true;
            invocationOption = key;
        }
        return invocationOption;
    }

    private AtomicValue checkInvocationMutualExclusion30(AtomicIterator keysIterator) throws XPathException {
        AtomicValue key;
        boolean invocationOptionFound = false;
        AtomicValue invocationOption = null;
        while ((key = keysIterator.next()) != null && key instanceof StringValue) {
            String name = key.getStringValue();
            if (!name.equals("initial-mode") && !name.equals("initial-template") && !name.equals("initial-function")) continue;
            if (invocationOptionFound) {
                throw new XPathException("The following transform options are mutually exclusive: initial-mode|initial-template|initial-function", "FOXT0002");
            }
            invocationOptionFound = true;
            invocationOption = key;
        }
        return invocationOption;
    }

    private void setVendorOptions(MapItem map, Processor processor) throws XPathException {
        AtomicValue option;
        MapItem options = (MapItem)map.get(new StringValue("vendor-options")).head();
        AtomicIterator optionIterator = options.keys();
        while ((option = optionIterator.next()) != null) {
            QName optionName = new QName(((QNameValue)option.head()).getStructuredQName());
            XdmValue optionVal = XdmValue.wrap(options.get(option));
            if (!((QNameValue)option.head()).getNamespaceURI().equals("http://saxon.sf.net/feature/")) continue;
            processor.setConfigurationProperty(optionName.getNamespaceURI().concat(optionName.getLocalName()), optionVal.toString());
        }
    }

    private void setStaticParams(MapItem map, XsltCompiler xsltCompiler) throws XPathException {
        AtomicValue param;
        MapItem staticParamsMap = (MapItem)map.get(new StringValue("static-params")).head();
        AtomicIterator paramIterator = staticParamsMap.keys();
        while ((param = paramIterator.next()) != null) {
            QName paramName = new QName(((QNameValue)param.head()).getStructuredQName());
            XdmValue paramVal = XdmValue.wrap(staticParamsMap.get(param));
            xsltCompiler.setParameter(paramName, paramVal);
        }
    }

    private XsltExecutable getStylesheet(MapItem map, XsltCompiler xsltCompiler, AtomicValue styleOption, XPathContext context) throws XPathException {
        URI styleBase;
        String styleOptionStr = styleOption.getStringValue();
        Item styleOptionItem = map.get(styleOption).head();
        StringValue styleBaseUri = null;
        Sequence seq = map.get(new StringValue("stylesheet-base-uri"));
        if (seq != null && !(styleBase = URI.create((styleBaseUri = (StringValue)seq.head()).getStringValue())).isAbsolute()) {
            throw new XPathException("The transform option stylesheet-base-uri is not an absolute URI", "FOXT0002");
        }
        BooleanValue cacheBool = BooleanValue.TRUE;
        if (map.get(new StringValue("cache")) != null) {
            cacheBool = (BooleanValue)map.get(new StringValue("cache")).head();
        }
        StylesheetCache cache = context.getController().getStylesheetCache();
        XsltExecutable executable = null;
        if (styleOptionStr.equals("stylesheet-location")) {
            String stylesheetLocation = styleOptionItem.getStringValue();
            executable = cache.getStylesheetByLocation(stylesheetLocation);
            if (executable == null) {
                Source style;
                try {
                    String base = this.getStaticBaseUriString();
                    style = xsltCompiler.getURIResolver().resolve(stylesheetLocation, base);
                    if (style == null) {
                        style = xsltCompiler.getProcessor().getUnderlyingConfiguration().getSystemURIResolver().resolve(stylesheetLocation, base);
                    }
                    if (styleBaseUri != null) {
                        style.setSystemId(styleBaseUri.getStringValue());
                    }
                }
                catch (TransformerException e) {
                    throw new XPathException(e);
                }
                try {
                    executable = xsltCompiler.compile(style);
                }
                catch (SaxonApiException e) {
                    if (e.getCause() instanceof XPathException) {
                        throw (XPathException)e.getCause();
                    }
                    throw new XPathException(e);
                }
                if (cacheBool == BooleanValue.TRUE) {
                    cache.setStylesheetByLocation(stylesheetLocation, executable);
                }
            }
        } else if (styleOptionStr.equals("stylesheet-node")) {
            NodeInfo stylesheetNode = (NodeInfo)styleOptionItem;
            if (styleBaseUri != null && !stylesheetNode.getBaseURI().equals(styleBaseUri.getStringValue())) {
                final String sysId = styleBaseUri.getStringValue();
                Builder builder = context.getController().makeBuilder();
                builder.setSystemId(sysId);
                final ExplicitLocation fixedLocation = new ExplicitLocation(sysId, -1, -1);
                ProxyReceiver filter = new ProxyReceiver(builder){

                    public void startElement(NodeName elemName, SchemaType typeCode, Location location, int properties) throws XPathException {
                        super.startElement(elemName, typeCode, fixedLocation, properties);
                    }

                    public void setSystemId(String systemId) {
                        super.setSystemId(sysId);
                    }
                };
                builder.open();
                stylesheetNode.copy(filter, 0, ExplicitLocation.UNKNOWN_LOCATION);
                builder.close();
                stylesheetNode = builder.getCurrentRoot();
            }
            if ((executable = cache.getStylesheetByNode(stylesheetNode)) == null) {
                Source source = stylesheetNode;
                if (styleBaseUri != null) {
                    source = AugmentedSource.makeAugmentedSource(source);
                    source.setSystemId(styleBaseUri.getStringValue());
                }
                try {
                    executable = xsltCompiler.compile(source);
                }
                catch (SaxonApiException e) {
                    if (e.getCause() instanceof XPathException) {
                        throw (XPathException)e.getCause();
                    }
                    throw new XPathException(e);
                }
                if (cacheBool == BooleanValue.TRUE) {
                    cache.setStylesheetByNode(stylesheetNode, executable);
                }
            }
        } else if (styleOptionStr.equals("stylesheet-text")) {
            String stylesheetText = styleOptionItem.getStringValue();
            executable = cache.getStylesheetByText(stylesheetText);
            if (executable == null) {
                StringReader sr = new StringReader(stylesheetText);
                SAXSource style = new SAXSource(new InputSource(sr));
                if (styleBaseUri != null) {
                    style.setSystemId(styleBaseUri.getStringValue());
                }
                try {
                    executable = xsltCompiler.compile(style);
                }
                catch (SaxonApiException e) {
                    if (e.getCause() instanceof XPathException) {
                        throw (XPathException)e.getCause();
                    }
                    throw new XPathException(e);
                }
                if (cacheBool == BooleanValue.TRUE) {
                    cache.setStylesheetByText(stylesheetText, executable);
                }
            }
        } else if (styleOptionStr.equals("package-name")) {
            String packageName = styleOptionItem.getStringValue();
            String packageVersion = null;
            if (map.get(new StringValue("package-version")) != null) {
                packageVersion = map.get(new StringValue("package-version")).head().getStringValue();
            }
        }
        return executable;
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        AtomicValue key;
        AtomicValue styleOption;
        AtomicValue invocationOption;
        DecimalValue xsltVersion;
        MapItem map = (MapItem)arguments[0].head();
        assert (map != null);
        Processor processor = new Processor(false);
        processor.setConfigurationProperty("http://saxon.sf.net/feature/configuration", context.getConfiguration());
        boolean isXslt30Processor = context.getConfiguration().isLicensedFeature(8);
        map = this.checkTransformOptions(map, context, isXslt30Processor);
        StringValue xsltVersionStr = new StringValue("xslt-version");
        if (map.get(xsltVersionStr) != null && ((xsltVersion = (DecimalValue)map.get(xsltVersionStr).head()).compareTo(DecimalValue.THREE) >= 0 && !isXslt30Processor || xsltVersion.compareTo(DecimalValue.THREE) > 0 && isXslt30Processor)) {
            throw new XPathException("The transform option xslt-version is higher than the XSLT version supported by this processor", "FOXT0002");
        }
        String invocationName = new String("invocation");
        if (isXslt30Processor) {
            invocationOption = this.checkInvocationMutualExclusion30(map.keys());
            if (invocationOption != null) {
                invocationName = invocationOption.getStringValue();
            }
            if (!invocationName.equals("initial-template") && !invocationName.equals("initial-function") && map.get(new StringValue("source-node")) == null) {
                throw new XPathException("A transform must have at least one of the following options: source-node|initial-template|initial-function", "FOXT0002");
            }
            if (invocationName.equals("initial-function") && map.get(new StringValue("function-params")) == null) {
                throw new XPathException("Use of the transform option initial-function requires the function parameters to be supplied using the option function-params", "FOXT0002");
            }
            if (!invocationName.equals("initial-function") && map.get(new StringValue("function-params")) != null) {
                throw new XPathException("The transform option function-params can only be used if the option initial-function is also used", "FOXT0002");
            }
            styleOption = this.checkStylesheetMutualExclusion30(map.keys());
        } else {
            invocationOption = this.checkInvocationMutualExclusion(map.keys());
            if (invocationOption != null) {
                invocationName = invocationOption.getStringValue();
            }
            if (!invocationName.equals("initial-template") && map.get(new StringValue("source-node")) == null) {
                throw new XPathException("A transform must have at least one of the following options: source-node|initial-template", "FOXT0002");
            }
            styleOption = this.checkStylesheetMutualExclusion(map.keys());
        }
        if (map.get(new StringValue("vendor-options")) != null) {
            this.setVendorOptions(map, processor);
        }
        XsltCompiler xsltCompiler = processor.newXsltCompiler();
        xsltCompiler.setURIResolver(context.getURIResolver());
        if (map.get(new StringValue("static-params")) != null) {
            this.setStaticParams(map, xsltCompiler);
        }
        XsltExecutable sheet = this.getStylesheet(map, xsltCompiler, styleOption, context);
        Xslt30Transformer transformer = sheet.load30();
        Destination destination = new XdmDestination();
        String deliveryFormat = "document";
        NodeInfo sourceNode = null;
        QName initialTemplate = null;
        QName initialMode = null;
        StringValue baseOutputUri = null;
        HashMap<QName, XdmValue> stylesheetParams = new HashMap<QName, XdmValue>();
        MapItem serializationParamsMap = null;
        StringWriter serializedResult = null;
        File serializedResultFile = null;
        XdmItem globalContextItem = null;
        HashMap<QName, XdmValue> templateParams = new HashMap<QName, XdmValue>();
        HashMap<QName, XdmValue> tunnelParams = new HashMap<QName, XdmValue>();
        QName initialFunction = null;
        XdmValue[] functionParams = null;
        XdmValue rawResult = null;
        AtomicIterator keysIterator = map.keys();
        while ((key = keysIterator.next()) != null) {
            XdmValue paramVal;
            QName paramName;
            AtomicValue param;
            MapItem params;
            if (!(key instanceof StringValue)) continue;
            String name = key.getStringValue();
            if (name.equals("source-node")) {
                Sequence source = map.get(key);
                sourceNode = (NodeInfo)source.head();
                continue;
            }
            if (name.equals("initial-template")) {
                initialTemplate = new QName(((QNameValue)map.get(key).head()).getStructuredQName());
                continue;
            }
            if (name.equals("initial-mode")) {
                initialMode = new QName(((QNameValue)map.get(key).head()).getStructuredQName());
                continue;
            }
            if (name.equals("delivery-format")) {
                deliveryFormat = map.get(key).head().getStringValue();
                if (!isXslt30Processor) {
                    if (deliveryFormat.equals("document") || deliveryFormat.equals("serialized") || deliveryFormat.equals("saved")) continue;
                    throw new XPathException("The transform option delivery-format should be one of: document|serialized|saved ", "FOXT0002");
                }
                if (deliveryFormat.equals("document") || deliveryFormat.equals("serialized") || deliveryFormat.equals("saved") || deliveryFormat.equals("raw")) continue;
                throw new XPathException("The transform option delivery-format should be one of: document|serialized|saved|raw ", "FOXT0002");
            }
            if (name.equals("base-output-uri")) {
                baseOutputUri = (StringValue)map.get(key).head();
                continue;
            }
            if (name.equals("serialization-params")) {
                serializationParamsMap = (MapItem)map.get(key).head();
                continue;
            }
            if (name.equals("stylesheet-params")) {
                params = (MapItem)map.get(key).head();
                AtomicIterator paramIterator = params.keys();
                while ((param = paramIterator.next()) != null) {
                    paramName = new QName(((QNameValue)param.head()).getStructuredQName());
                    paramVal = XdmValue.wrap(params.get(param));
                    stylesheetParams.put(paramName, paramVal);
                }
                continue;
            }
            if (name.equals("global-context-item")) {
                globalContextItem = (XdmItem)((Object)map.get(key).head());
                continue;
            }
            if (name.equals("template-params")) {
                params = (MapItem)map.get(key).head();
                AtomicIterator paramIterator = params.keys();
                while ((param = paramIterator.next()) != null) {
                    paramName = new QName(((QNameValue)param.head()).getStructuredQName());
                    paramVal = XdmValue.wrap(params.get(param));
                    templateParams.put(paramName, paramVal);
                }
                continue;
            }
            if (name.equals("tunnel-params")) {
                params = (MapItem)map.get(key).head();
                AtomicIterator paramIterator = params.keys();
                while ((param = paramIterator.next()) != null) {
                    paramName = new QName(((QNameValue)param.head()).getStructuredQName());
                    paramVal = XdmValue.wrap(params.get(param));
                    tunnelParams.put(paramName, paramVal);
                }
                continue;
            }
            if (name.equals("initial-function")) {
                initialFunction = new QName(((QNameValue)map.get(key).head()).getStructuredQName());
                continue;
            }
            if (!name.equals("function-params")) continue;
            ArrayItem functionParamsArray = (ArrayItem)map.get(key).head();
            functionParams = new XdmValue[functionParamsArray.size()];
            for (int i = 0; i < functionParams.length; ++i) {
                functionParams[i] = XdmValue.wrap(functionParamsArray.get(i));
            }
        }
        Controller controller = transformer.getUnderlyingController();
        ConcurrentHashMap<String, TreeInfo> secondaryResultsForDocument = new ConcurrentHashMap<String, TreeInfo>();
        ConcurrentHashMap<String, String> secondaryResultsForSerialized = new ConcurrentHashMap<String, String>();
        ConcurrentHashMap<String, String> secondaryResultsForSaved = new ConcurrentHashMap<String, String>();
        ConcurrentHashMap<String, XdmValue> secondaryResultsForRaw = new ConcurrentHashMap<String, XdmValue>();
        if (deliveryFormat.equals("document")) {
            controller.setOutputURIResolver(new SecondaryOutputResolverForDocument(controller, secondaryResultsForDocument));
        } else if (deliveryFormat.equals("serialized")) {
            controller.setOutputURIResolver(new SecondaryOutputResolverForSerialized(secondaryResultsForSerialized));
        } else if (deliveryFormat.equals("saved")) {
            controller.setOutputURIResolver(new SecondaryOutputResolverForSaved(secondaryResultsForSaved));
        } else if (deliveryFormat.equals("raw")) {
            controller.setOutputURIResolver(new SecondaryOutputResolverForRaw(secondaryResultsForRaw));
        }
        try {
            transformer.setStylesheetParameters(stylesheetParams);
            transformer.setInitialTemplateParameters(templateParams, false);
            transformer.setInitialTemplateParameters(tunnelParams, true);
            if (baseOutputUri != null) {
                transformer.setBaseOutputURI(baseOutputUri.getStringValue());
            }
            if (baseOutputUri == null && deliveryFormat.equals("document")) {
                transformer.setBaseOutputURI("http://saxonica.com/output-document/output");
            }
            if (deliveryFormat.equals("serialized") || deliveryFormat.equals("saved")) {
                URI outputUri;
                Serializer serializer = processor.newSerializer();
                if (serializationParamsMap != null) {
                    AtomicValue param;
                    AtomicIterator paramIterator = serializationParamsMap.keys();
                    while ((param = paramIterator.next()) != null) {
                        QName paramName = new QName(((QNameValue)param.head()).getStructuredQName());
                        StringValue paramVal = (StringValue)serializationParamsMap.get(param);
                        Serializer.Property prop = Serializer.getProperty(paramName);
                        serializer.setOutputProperty(prop, paramVal.getStringValue());
                    }
                }
                if (deliveryFormat.equals("serialized")) {
                    if (baseOutputUri == null) {
                        outputUri = URI.create("http://saxonica.com/output-serialized/output");
                        transformer.setBaseOutputURI(outputUri.toString());
                    }
                    serializedResult = new StringWriter();
                    serializer.setOutputWriter(serializedResult);
                } else if (deliveryFormat.equals("saved")) {
                    if (baseOutputUri == null) {
                        outputUri = URI.create("file:///saxon-dummy-output-file-984hvds3sfmixxak22/output");
                        serializedResultFile = new File(outputUri);
                    } else if (baseOutputUri != null) {
                        outputUri = URI.create(baseOutputUri.getStringValue());
                        if (!outputUri.isAbsolute()) {
                            throw new XPathException("The transform option base-output-uri is not an absolute URI", "FOXT0002");
                        }
                        serializedResultFile = new File(outputUri);
                    }
                    serializer.setOutputFile(serializedResultFile);
                }
                destination = serializer;
            } else if (deliveryFormat.equals("raw")) {
                transformer.setBaseOutputURI("http://saxonica.com/output-raw/output");
            }
            if (initialTemplate != null) {
                if (sourceNode != null) {
                    transformer.setGlobalContextItem(new XdmNode(sourceNode));
                }
                if (deliveryFormat.equals("raw")) {
                    rawResult = transformer.callTemplate(initialTemplate);
                } else {
                    transformer.callTemplate(initialTemplate, destination);
                }
            } else if (initialFunction != null) {
                if (sourceNode != null) {
                    transformer.setGlobalContextItem(new XdmNode(sourceNode));
                }
                if (deliveryFormat.equals("raw")) {
                    rawResult = transformer.callFunction(initialFunction, functionParams);
                } else {
                    transformer.callFunction(initialFunction, functionParams, destination);
                }
            } else {
                if (initialMode != null) {
                    transformer.setInitialMode(initialMode);
                }
                if (deliveryFormat.equals("raw")) {
                    rawResult = transformer.applyTemplates(sourceNode);
                } else {
                    transformer.applyTemplates(sourceNode, destination);
                }
            }
        }
        catch (SaxonApiException e) {
            if (e.getCause() instanceof XPathException) {
                throw (XPathException)e.getCause();
            }
            throw new XPathException(e);
        }
        HashTrieMap resultMap = new HashTrieMap(context);
        if (deliveryFormat.equals("document")) {
            for (Map.Entry entry : secondaryResultsForDocument.entrySet()) {
                resultMap = resultMap.addEntry(new StringValue((CharSequence)entry.getKey()), ((TreeInfo)entry.getValue()).getRootNode());
            }
        } else if (deliveryFormat.equals("serialized")) {
            for (Map.Entry entry : secondaryResultsForSerialized.entrySet()) {
                resultMap = resultMap.addEntry(new StringValue((CharSequence)entry.getKey()), new StringValue((CharSequence)entry.getValue()));
            }
        } else if (deliveryFormat.equals("saved")) {
            for (Map.Entry entry : secondaryResultsForSaved.entrySet()) {
                resultMap = resultMap.addEntry(new StringValue((CharSequence)entry.getKey()), new StringValue((CharSequence)entry.getValue()));
            }
        } else if (deliveryFormat.equals("raw")) {
            for (Map.Entry entry : secondaryResultsForRaw.entrySet()) {
                resultMap = resultMap.addEntry(new StringValue((CharSequence)entry.getKey()), ((XdmValue)entry.getValue()).getUnderlyingValue());
            }
        }
        StringValue resultKey = baseOutputUri == null ? new StringValue("output") : baseOutputUri;
        Sequence value = null;
        if (deliveryFormat.equals("document")) {
            XdmNode xdmNode = ((XdmDestination)destination).getXdmNode();
            if (xdmNode != null) {
                value = xdmNode.getUnderlyingNode();
            }
        } else if (deliveryFormat.equals("serialized")) {
            String result = serializedResult.toString();
            if (!result.equals("")) {
                value = new StringValue(result);
            }
        } else if (deliveryFormat.equals("saved")) {
            if (serializedResultFile.isFile() && !serializedResultFile.getAbsolutePath().contains("saxon-dummy-output-file-984hvds3sfmixxak22")) {
                value = resultKey;
            }
        } else if (deliveryFormat.equals("raw")) {
            value = rawResult.getUnderlyingValue();
        }
        if (value != null) {
            resultMap = resultMap.addEntry(resultKey, value);
        }
        return resultMap;
    }

    static {
        requiredTypes.put("xslt-version", SequenceType.SINGLE_DECIMAL);
        requiredTypes.put("stylesheet-location", SequenceType.SINGLE_STRING);
        requiredTypes.put("stylesheet-node", SequenceType.SINGLE_NODE);
        requiredTypes.put("stylesheet-text", SequenceType.SINGLE_STRING);
        requiredTypes.put("stylesheet-base-uri", SequenceType.SINGLE_STRING);
        requiredTypes.put("base-output-uri", SequenceType.SINGLE_STRING);
        requiredTypes.put("stylesheet-params", SequenceType.makeSequenceType(MapType.ANY_MAP_TYPE, 16384));
        requiredTypes.put("source-node", SequenceType.SINGLE_NODE);
        requiredTypes.put("initial-mode", SequenceType.SINGLE_QNAME);
        requiredTypes.put("initial-template", SequenceType.SINGLE_QNAME);
        requiredTypes.put("delivery-format", SequenceType.SINGLE_STRING);
        requiredTypes.put("serialization-params", SequenceType.makeSequenceType(MapType.ANY_MAP_TYPE, 16384));
        requiredTypes.put("vendor-options", SequenceType.makeSequenceType(MapType.ANY_MAP_TYPE, 16384));
        requiredTypes.put("cache", SequenceType.SINGLE_BOOLEAN);
        requiredTypes.put("package-name", SequenceType.SINGLE_STRING);
        requiredTypes.put("package-version", SequenceType.SINGLE_DECIMAL);
        requiredTypes.put("package-node", SequenceType.SINGLE_NODE);
        requiredTypes.put("package-location", SequenceType.SINGLE_STRING);
        requiredTypes.put("static-params", SequenceType.makeSequenceType(MapType.ANY_MAP_TYPE, 16384));
        requiredTypes.put("global-context-item", SequenceType.SINGLE_ITEM);
        requiredTypes.put("template-params", SequenceType.makeSequenceType(MapType.ANY_MAP_TYPE, 16384));
        requiredTypes.put("tunnel-params", SequenceType.makeSequenceType(MapType.ANY_MAP_TYPE, 16384));
        requiredTypes.put("initial-function", SequenceType.SINGLE_QNAME);
        requiredTypes.put("function-params", SequenceType.makeSequenceType(ArrayItemType.ANY_ARRAY_TYPE, 16384));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SecondaryOutputResolverForRaw
    extends StandardOutputResolver {
        private Map<String, XdmValue> results;

        public SecondaryOutputResolverForRaw(Map<String, XdmValue> results) {
            this.results = results;
        }

        @Override
        protected Result createResult(URI absoluteURI) throws XPathException, IOException {
            if (absoluteURI.toString().contains("http://saxonica.com/output-raw/output")) {
                throw new XPathException("The location of output documents is undefined: use the transform option base-output-uri", "FOXT0002");
            }
            return new StreamResult(new File(absoluteURI));
        }

        @Override
        public void close(Result result) throws XPathException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SecondaryOutputResolverForSaved
    extends StandardOutputResolver {
        private Map<String, String> results;

        public SecondaryOutputResolverForSaved(Map<String, String> results) {
            this.results = results;
        }

        @Override
        protected Result createResult(URI absoluteURI) throws XPathException, IOException {
            if (absoluteURI.toString().contains("/saxon-dummy-output-file-984hvds3sfmixxak22/")) {
                throw new XPathException("The location of output documents is undefined: use the transform option base-output-uri", "FOXT0002");
            }
            return new StreamResult(new File(absoluteURI));
        }

        @Override
        public void close(Result result) throws XPathException {
            this.results.put(result.getSystemId(), result.getSystemId());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SecondaryOutputResolverForSerialized
    extends StandardOutputResolver {
        private Map<String, String> results;
        private Map<String, StringWriter> workInProgress = new ConcurrentHashMap<String, StringWriter>();

        public SecondaryOutputResolverForSerialized(Map<String, String> results) {
            this.results = results;
        }

        @Override
        protected Result createResult(URI absoluteURI) throws XPathException, IOException {
            StringWriter writer = new StringWriter();
            if (absoluteURI.toString().contains("http://saxonica.com/output-serialized")) {
                throw new XPathException("The location of output documents is undefined: use the transform option base-output-uri", "FOXT0002");
            }
            this.workInProgress.put(absoluteURI.toString(), writer);
            StreamResult streamResult = new StreamResult(writer);
            streamResult.setSystemId(absoluteURI.toString());
            return streamResult;
        }

        @Override
        public void close(Result result) throws XPathException {
            String output = this.workInProgress.get(result.getSystemId()).toString();
            this.results.put(result.getSystemId(), output);
            this.workInProgress.remove(result.getSystemId());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SecondaryOutputResolverForDocument
    extends StandardOutputResolver {
        private Controller controller;
        private Map<String, TreeInfo> results;

        public SecondaryOutputResolverForDocument(Controller controller, Map<String, TreeInfo> results) {
            this.controller = controller;
            this.results = results;
        }

        @Override
        protected Result createResult(URI absoluteURI) throws XPathException, IOException {
            Builder builder = this.controller.makeBuilder();
            if (absoluteURI.toString().contains("http://saxonica.com/output-document")) {
                throw new XPathException("The location of output documents is undefined: use the transform option base-output-uri", "FOXT0002");
            }
            builder.setSystemId(absoluteURI.toString());
            return builder;
        }

        @Override
        public void close(Result result) throws XPathException {
            NodeInfo doc = ((Builder)result).getCurrentRoot();
            this.results.put(doc.getSystemId(), doc.getTreeInfo());
        }
    }
}

