/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.HashSet;
import java.util.Set;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.AndExpression;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.BooleanExpression;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.DifferenceEnumeration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.IntersectionEnumeration;
import net.sf.saxon.expr.ItemChecker;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.OrExpression;
import net.sf.saxon.expr.SingletonIntersectExpression;
import net.sf.saxon.expr.SlashExpression;
import net.sf.saxon.expr.UnionEnumeration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.Token;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.expr.sort.DocumentSorter;
import net.sf.saxon.expr.sort.GlobalOrderComparer;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.CombinedNodeTest;
import net.sf.saxon.pattern.ExceptPattern;
import net.sf.saxon.pattern.IntersectPattern;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.pattern.UnionPattern;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VennExpression
extends BinaryExpression {
    public VennExpression(Expression p1, int op, Expression p2) {
        super(p1, op, p2);
    }

    @Override
    public Expression simplify() throws XPathException {
        if (!(this.getLhsExpression() instanceof DocumentSorter)) {
            this.setLhsExpression(new DocumentSorter(this.getLhsExpression()));
        }
        if (!(this.getRhsExpression() instanceof DocumentSorter)) {
            this.setRhsExpression(new DocumentSorter(this.getRhsExpression()));
        }
        super.simplify();
        return this;
    }

    @Override
    public String getExpressionName() {
        switch (this.operator) {
            case 1: {
                return "union";
            }
            case 23: {
                return "intersect";
            }
            case 24: {
                return "except";
            }
        }
        return "unknown";
    }

    @Override
    public final ItemType getItemType() {
        ItemType t1 = this.getLhsExpression().getItemType();
        if (this.operator == 1) {
            ItemType t2 = this.getRhsExpression().getItemType();
            TypeHierarchy th = this.getConfiguration().getTypeHierarchy();
            return Type.getCommonSuperType(t1, t2, th);
        }
        return t1;
    }

    @Override
    public final int computeCardinality() {
        int c1 = this.getLhsExpression().getCardinality();
        int c2 = this.getRhsExpression().getCardinality();
        switch (this.operator) {
            case 1: {
                if (Literal.isEmptySequence(this.getLhsExpression())) {
                    return c2;
                }
                if (Literal.isEmptySequence(this.getRhsExpression())) {
                    return c1;
                }
                return c1 | c2 | 0x4000 | 0x8000;
            }
            case 23: {
                if (Literal.isEmptySequence(this.getLhsExpression())) {
                    return 8192;
                }
                if (Literal.isEmptySequence(this.getRhsExpression())) {
                    return 8192;
                }
                return c1 & c2 | 0x2000 | 0x4000;
            }
            case 24: {
                if (Literal.isEmptySequence(this.getLhsExpression())) {
                    return 8192;
                }
                if (Literal.isEmptySequence(this.getRhsExpression())) {
                    return c1;
                }
                return c1 | 0x2000 | 0x4000;
            }
        }
        return 57344;
    }

    @Override
    public int computeSpecialProperties() {
        int prop0 = this.getLhsExpression().getSpecialProperties();
        int prop1 = this.getRhsExpression().getSpecialProperties();
        int props = 131072;
        if (this.testContextDocumentNodeSet(prop0, prop1)) {
            props |= 0x10000;
        }
        if (this.testSubTree(prop0, prop1)) {
            props |= 0x100000;
        }
        if (!this.testCreative(prop0, prop1)) {
            props |= 0x400000;
        }
        return props;
    }

    private boolean testContextDocumentNodeSet(int prop0, int prop1) {
        switch (this.operator) {
            case 1: {
                return (prop0 & prop1 & 0x10000) != 0;
            }
            case 23: {
                return ((prop0 | prop1) & 0x10000) != 0;
            }
            case 24: {
                return (prop0 & 0x10000) != 0;
            }
        }
        return false;
    }

    public void gatherComponents(int operator, Set<Expression> set) {
        if (this.getLhsExpression() instanceof VennExpression && ((VennExpression)this.getLhsExpression()).operator == operator) {
            ((VennExpression)this.getLhsExpression()).gatherComponents(operator, set);
        } else {
            set.add(this.getLhsExpression());
        }
        if (this.getRhsExpression() instanceof VennExpression && ((VennExpression)this.getRhsExpression()).operator == operator) {
            ((VennExpression)this.getRhsExpression()).gatherComponents(operator, set);
        } else {
            set.add(this.getRhsExpression());
        }
    }

    private boolean testSubTree(int prop0, int prop1) {
        switch (this.operator) {
            case 1: {
                return (prop0 & prop1 & 0x100000) != 0;
            }
            case 23: {
                return ((prop0 | prop1) & 0x100000) != 0;
            }
            case 24: {
                return (prop0 & 0x100000) != 0;
            }
        }
        return false;
    }

    private boolean testCreative(int prop0, int prop1) {
        return (prop0 & 0x400000) == 0 || (prop1 & 0x400000) == 0;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        ItemType t1;
        ItemType t0;
        TypeHierarchy th;
        this.typeCheckChildren(visitor, contextInfo);
        if (!(this.getLhsExpression() instanceof Pattern)) {
            RoleDiagnostic role0 = new RoleDiagnostic(1, Token.tokens[this.operator], 0);
            this.setLhsExpression(TypeChecker.staticTypeCheck(this.getLhsExpression(), SequenceType.NODE_SEQUENCE, false, role0, visitor));
        }
        if (!(this.getRhsExpression() instanceof Pattern)) {
            RoleDiagnostic role1 = new RoleDiagnostic(1, Token.tokens[this.operator], 1);
            this.setRhsExpression(TypeChecker.staticTypeCheck(this.getRhsExpression(), SequenceType.NODE_SEQUENCE, false, role1, visitor));
        }
        if (this.operator != 1 && (th = this.getConfiguration().getTypeHierarchy()).relationship(t0 = this.getLhsExpression().getItemType(), t1 = this.getRhsExpression().getItemType()) == 4) {
            if (this.operator == 23) {
                return Literal.makeEmptySequence();
            }
            if ((this.getLhsExpression().getSpecialProperties() & 0x20000) != 0) {
                return this.getLhsExpression();
            }
            return new DocumentSorter(this.getLhsExpression());
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        Expression e = super.optimize(visitor, contextItemType);
        if (e != this) {
            return e;
        }
        Configuration config = this.getConfiguration();
        TypeHierarchy th = config.getTypeHierarchy();
        switch (this.operator) {
            case 1: {
                if (Literal.isEmptySequence(this.getLhsExpression()) && (this.getRhsExpression().getSpecialProperties() & 0x20000) != 0) {
                    return this.getRhsExpression();
                }
                if (!Literal.isEmptySequence(this.getRhsExpression()) || (this.getLhsExpression().getSpecialProperties() & 0x20000) == 0) break;
                return this.getLhsExpression();
            }
            case 23: {
                if (Literal.isEmptySequence(this.getLhsExpression())) {
                    return this.getLhsExpression();
                }
                if (!Literal.isEmptySequence(this.getRhsExpression())) break;
                return this.getRhsExpression();
            }
            case 24: {
                if (Literal.isEmptySequence(this.getLhsExpression())) {
                    return this.getLhsExpression();
                }
                if (!Literal.isEmptySequence(this.getRhsExpression()) || (this.getLhsExpression().getSpecialProperties() & 0x20000) == 0) break;
                return this.getLhsExpression();
            }
        }
        if (this.getLhsExpression() instanceof AxisExpression && this.getRhsExpression() instanceof AxisExpression) {
            AxisExpression a1 = (AxisExpression)this.getLhsExpression();
            AxisExpression a2 = (AxisExpression)this.getRhsExpression();
            if (a1.getAxis() == a2.getAxis()) {
                AxisExpression ax = new AxisExpression(a1.getAxis(), new CombinedNodeTest(a1.getNodeTest(), this.operator, a2.getNodeTest()));
                ExpressionTool.copyLocationInfo(this, ax);
                return ax;
            }
        }
        if (this.getLhsExpression() instanceof SlashExpression && this.getRhsExpression() instanceof SlashExpression && this.operator == 1) {
            SlashExpression path1 = (SlashExpression)this.getLhsExpression();
            SlashExpression path2 = (SlashExpression)this.getRhsExpression();
            if (path1.getFirstStep().equals(path2.getFirstStep())) {
                VennExpression venn = new VennExpression(path1.getRemainingSteps(), this.operator, path2.getRemainingSteps());
                ExpressionTool.copyLocationInfo(this, venn);
                Expression path = ExpressionTool.makePathExpression(path1.getFirstStep(), venn, false);
                ExpressionTool.copyLocationInfo(this, path);
                return path.optimize(visitor, contextItemType);
            }
        }
        if (this.getLhsExpression() instanceof FilterExpression && this.getRhsExpression() instanceof FilterExpression) {
            FilterExpression exp0 = (FilterExpression)this.getLhsExpression();
            FilterExpression exp1 = (FilterExpression)this.getRhsExpression();
            if (!exp0.isPositional(th) && !exp1.isPositional(th) && exp0.getSelectExpression().equals(exp1.getSelectExpression())) {
                BooleanExpression filter;
                switch (this.operator) {
                    case 1: {
                        filter = new OrExpression(exp0.getFilter(), exp1.getFilter());
                        break;
                    }
                    case 23: {
                        filter = new AndExpression(exp0.getFilter(), exp1.getFilter());
                        break;
                    }
                    case 24: {
                        Expression negate2 = SystemFunction.makeCall("not", this.getRetainedStaticContext(), exp1.getFilter());
                        filter = new AndExpression(exp0.getFilter(), negate2);
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Unknown operator " + this.operator));
                    }
                }
                ExpressionTool.copyLocationInfo(this, filter);
                FilterExpression f = new FilterExpression(exp0.getSelectExpression(), filter);
                ExpressionTool.copyLocationInfo(this, f);
                return f.simplify().typeCheck(visitor, contextItemType).optimize(visitor, contextItemType);
            }
        }
        if (!visitor.isOptimizeForStreaming() && this.operator == 1 && this.getLhsExpression() instanceof AxisExpression && this.getRhsExpression() instanceof AxisExpression) {
            AxisExpression a0 = (AxisExpression)this.getLhsExpression();
            AxisExpression a1 = (AxisExpression)this.getRhsExpression();
            if (a0.getAxis() == 2 && a1.getAxis() == 3) {
                return new Block(new Expression[]{this.getLhsExpression(), this.getRhsExpression()});
            }
            if (a1.getAxis() == 2 && a0.getAxis() == 3) {
                return new Block(new Expression[]{this.getRhsExpression(), this.getLhsExpression()});
            }
        }
        if (this.operator == 23 && !Cardinality.allowsMany(this.getLhsExpression().getCardinality())) {
            return new SingletonIntersectExpression(this.getLhsExpression(), this.operator, this.getRhsExpression().unordered(false, false));
        }
        if (this.operator == 23 && !Cardinality.allowsMany(this.getRhsExpression().getCardinality())) {
            return new SingletonIntersectExpression(this.getRhsExpression(), this.operator, this.getLhsExpression().unordered(false, false));
        }
        if (this.operandsAreDisjoint(th)) {
            if (this.operator == 23) {
                return Literal.makeEmptySequence();
            }
            if (this.operator == 24) {
                if ((this.getLhsExpression().getSpecialProperties() & 0x20000) != 0) {
                    return this.getLhsExpression();
                }
                return new DocumentSorter(this.getLhsExpression());
            }
        }
        return this;
    }

    private boolean operandsAreDisjoint(TypeHierarchy th) {
        return th.relationship(this.getLhsExpression().getItemType(), this.getRhsExpression().getItemType()) == 4;
    }

    @Override
    public Expression unordered(boolean retainAllNodes, boolean forStreaming) throws XPathException {
        if (this.operator == 1 && !forStreaming && this.operandsAreDisjoint(this.getConfiguration().getTypeHierarchy())) {
            Block block = new Block(new Expression[]{this.getLhsExpression(), this.getRhsExpression()});
            ExpressionTool.copyLocationInfo(this, block);
            return block;
        }
        return this;
    }

    @Override
    public Expression copy() {
        VennExpression exp = new VennExpression(this.getLhsExpression().copy(), this.operator, this.getRhsExpression().copy());
        ExpressionTool.copyLocationInfo(this, exp);
        return exp;
    }

    @Override
    public int getImplementationMethod() {
        return 2;
    }

    @Override
    protected OperandRole getOperandRole(int arg) {
        return OperandRole.SAME_FOCUS_ACTION;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof VennExpression) {
            VennExpression b = (VennExpression)other;
            if (this.operator != b.operator) {
                return false;
            }
            if (this.getLhsExpression().equals(b.getLhsExpression()) && this.getRhsExpression().equals(b.getRhsExpression())) {
                return true;
            }
            if (this.operator == 1 || this.operator == 23) {
                HashSet<Expression> s0 = new HashSet<Expression>(10);
                this.gatherComponents(this.operator, s0);
                HashSet<Expression> s1 = new HashSet<Expression>(10);
                ((VennExpression)other).gatherComponents(this.operator, s1);
                return s0.equals(s1);
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getLhsExpression().hashCode() ^ this.getRhsExpression().hashCode();
    }

    @Override
    public Pattern toPattern(Configuration config, boolean is30) throws XPathException {
        if (this.isPredicatePattern(this.getLhsExpression()) || this.isPredicatePattern(this.getRhsExpression())) {
            throw new XPathException("Cannot use a predicate pattern as an operand of a union, intersect, or except operator", "XTSE0340");
        }
        if (this.operator == 1) {
            return new UnionPattern(this.getLhsExpression().toPattern(config, is30), this.getRhsExpression().toPattern(config, is30));
        }
        if (is30) {
            if (this.operator == 24) {
                return new ExceptPattern(this.getLhsExpression().toPattern(config, is30), this.getRhsExpression().toPattern(config, is30));
            }
            return new IntersectPattern(this.getLhsExpression().toPattern(config, is30), this.getRhsExpression().toPattern(config, is30));
        }
        throw new XPathException("Cannot use intersect or except in an XSLT 2.0 pattern", "XTSE0340");
    }

    private boolean isPredicatePattern(Expression exp) {
        if (exp instanceof ItemChecker) {
            exp = ((ItemChecker)exp).getBaseExpression();
        }
        return exp instanceof FilterExpression && ((FilterExpression)exp).getSelectExpression() instanceof ContextItemExpression;
    }

    @Override
    protected String tag() {
        if (this.operator == 1) {
            return "union";
        }
        return Token.tokens[this.operator];
    }

    @Override
    public SequenceIterator iterate(XPathContext c) throws XPathException {
        SequenceIterator i1 = this.getLhsExpression().iterate(c);
        SequenceIterator i2 = this.getRhsExpression().iterate(c);
        switch (this.operator) {
            case 1: {
                return new UnionEnumeration(i1, i2, GlobalOrderComparer.getInstance());
            }
            case 23: {
                return new IntersectionEnumeration(i1, i2, GlobalOrderComparer.getInstance());
            }
            case 24: {
                return new DifferenceEnumeration(i1, i2, GlobalOrderComparer.getInstance());
            }
        }
        throw new UnsupportedOperationException("Unknown operator in Venn Expression");
    }

    @Override
    public boolean effectiveBooleanValue(XPathContext context) throws XPathException {
        if (this.operator == 1) {
            return this.getLhsExpression().effectiveBooleanValue(context) || this.getRhsExpression().effectiveBooleanValue(context);
        }
        return super.effectiveBooleanValue(context);
    }
}

