"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebSocketLambdaIntegration = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_apigatewayv2_alpha_1 = require("@aws-cdk/aws-apigatewayv2-alpha");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const aws_cdk_lib_1 = require("aws-cdk-lib");
/**
 * (experimental) Lambda WebSocket Integration.
 *
 * @experimental
 */
class WebSocketLambdaIntegration extends aws_apigatewayv2_alpha_1.WebSocketRouteIntegration {
    /**
     * @param id id of the underlying integration construct.
     * @param handler the Lambda function handler.
     * @experimental
     */
    constructor(id, handler) {
        super(id);
        this.handler = handler;
        this._id = id;
    }
    /**
     * (experimental) (experimental) Bind this integration to the route.
     *
     * @experimental
     */
    bind(options) {
        const route = options.route;
        this.handler.addPermission(`${this._id}-Permission`, {
            scope: options.scope,
            principal: new aws_iam_1.ServicePrincipal('apigateway.amazonaws.com'),
            sourceArn: aws_cdk_lib_1.Stack.of(route).formatArn({
                service: 'execute-api',
                resource: route.webSocketApi.apiId,
                resourceName: `*/*${route.routeKey}`,
            }),
        });
        const integrationUri = aws_cdk_lib_1.Stack.of(route).formatArn({
            service: 'apigateway',
            account: 'lambda',
            resource: 'path/2015-03-31/functions',
            resourceName: `${this.handler.functionArn}/invocations`,
        });
        return {
            type: aws_apigatewayv2_alpha_1.WebSocketIntegrationType.AWS_PROXY,
            uri: integrationUri,
        };
    }
}
exports.WebSocketLambdaIntegration = WebSocketLambdaIntegration;
_a = JSII_RTTI_SYMBOL_1;
WebSocketLambdaIntegration[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-integrations-alpha.WebSocketLambdaIntegration", version: "2.9.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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