![Codecov](https://codecov.io/gh/nawah-io/nawah_framework/graphs/badge.svg)

# Nawah Framework
Nawah is a framework that is designed for rapid app development. It uses `HTTP/2 Websocket` as primary protocol of communication with clients. However, it also provides an `HTTP/1 GET`, `POST` interfaces for additional communication windows.

# Features
## Modern
Nawah is based on modern approaches of apps development. It enables both backend developers and front-end developers with set of tools to achieve better and more from very simple and powerful set of tools.

## Type Driven
Nawah has sophisticated workflow to handle types. It has the tools to convert types when needed. And, it has the process to reject wrong data types. This gives developers huge relieve and peace of mind when developing complicated apps that require type accuracy.

## Advanced Users, Sessions and Privileges Control Out-of-the-Box
Apps development platforms and frameworks provide users and privileges control in various forms and levels. What makes Nawah approach unique and developer-friendly is the fact user-management has endless aspects, with the ability to extend it to your needs without a single edit on the original structure of Nawah. This means your app can always keep up-to-date with Nawah upstream, without compromising on your requirements for advanced user management options. All using simple tools that are available to all.

## Multi-Environment Ready
Nawah gives the developers the ability to get started with single app that is having the ability to run the exact same app on different [environments](https://github.com/nawah-io/nawah_docs/blob/master/api-package.md#envs) without any custom configurations.

## Test-Driven Development Out-of-the-Box
That's correct! You can now develop your app and [test](https://github.com/nawah-io/nawah_docs/blob/master/tests.md) it with minimal set of instructions in under 5 minutes.

## Easy to Install, Upgrade and deploy
Nawah has simple workflow to [set it up](https://github.com/nawah-io/nawah_docs/blob/master/quick-start.md). Upgrading it is also as simple as pulling latest version of Nawah from this repository, as well as the latest version of the packages your app uses for its functionalities. Deploying is as a simple as creating a [Docker](https://www.docker.com) image using the provided `Dockerfile`.

## Multi-language and Localisation-ready
Yes! No more dealing with custom handlers for multi-language apps. Your app is multi-language out-of-the-box. Not only this, but your app can keep adding locales and change them along the way. This is a paradise for developers working on global scale apps.

## Cache-able Responses
Nawah Cache Workflow gives developers the power to cache queries without having a hassle. Simple instructions, and condition checkers and developers get apps with dynamic cache feature.

## The Cron we All Like!
Nawah has Cron-like Jobs Workflow that allows developers to run background tasks using Cron timing expression. The jobs can be Nawah calls, or simple Python function that can be run for any purpose.

## Analytics that just Work
Nawah offers module-level Analytics Workflow that allow you developers to insert sample instructions which generate `Analytic` docs which can be later used programmatically by other modules, or for handy data researches.

# Docs Index
> Nawah docs are available at [https://github.com/nawah-io/nawah_docs](https://github.com/nawah-io/nawah_docs).