# Contributing to Merlin Models

If you are interested in contributing to Merlin Models, your contributions will fall
into three categories:

1. You want to report a bug, feature request, or documentation issue:
   - File an [issue](https://github.com/NVIDIA-Merlin/models/issues/new/choose)
     and describe what you encountered or what you want to see changed.
   - The NVIDIA-Merlin team evaluates the issues and triages them, scheduling
     them for a release. If you believe the issue needs priority attention,
     comment on the issue to notify the team.
2. You want to propose a new feature and implement it:
   - Post about your intended feature to discuss the design and
     implementation with the NVIDIA-Merlin team.
   - Once we agree that the plan looks good, go ahead and implement it, using
     the [code contributions](#code-contributions) guide below.
3. You want to implement a feature or bug-fix for an outstanding issue:
   - Follow the [code contributions](#code-contributions) guide below.
   - If you need more context on a particular issue, please ask and the
     NVIDIA-Merlin team will provide the context.

## Code contributions

### Your first issue

1. Read the project's [README.md](https://github.com/NVIDIA-Merlin/models/blob/main/README.md)
   to learn how to setup the development environment.
2. Find an issue to work on. The best way is to look for the [good first issue](https://github.com/NVIDIA-Merlin/models/issues?q=is%3Aissue+is%3Aopen+label%3A%22good+first+issue%22)
   or [help wanted](https://github.com/NVIDIA-Merlin/models/issues?q=is%3Aissue+is%3Aopen+label%3A%22help+wanted%22) labels.
3. Comment on the issue to say that you are going to work on it.
4. Code! Make sure to update unit tests!
5. When done, [create your pull request](https://github.com/NVIDIA-Merlin/models/compare).
6. Verify that CI passes all [status checks](https://help.github.com/articles/about-status-checks/). Fix if needed.
7. Wait for other developers to review your code and update code as needed.
8. After your pull request is reviewed and approved, an NVIDIA-Merlin team member merges it.

Remember, if you are unsure about anything, don't hesitate to comment on issues
and ask for clarifications!

### Seasoned developers

After you have your feet wet and are comfortable with the code, you
can look at the prioritized issues of our next release in our [project boards](https://github.com/NVIDIA-Merlin/models/projects).

> **Pro Tip:** Always look at the release board with the highest number for
> issues to work on. This is where the NVIDIA-Merlin developers also focus their efforts.

Look at the unassigned issues, and find an issue you are comfortable with
contributing to. Start with _Step 3_ from above, commenting on the issue to let
others know that you are working on it. If you have any questions related to the
implementation of the issue, ask them in the issue instead of the PR.

## Attribution

Portions adopted from https://github.com/pytorch/pytorch/blob/master/CONTRIBUTING.md
