import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::FSx::FileSystem`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html
 */
export interface CfnFileSystemProps {
    /**
     * `AWS::FSx::FileSystem.FileSystemType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-filesystemtype
     */
    readonly fileSystemType: string;
    /**
     * `AWS::FSx::FileSystem.SubnetIds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-subnetids
     */
    readonly subnetIds: string[];
    /**
     * `AWS::FSx::FileSystem.BackupId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-backupid
     */
    readonly backupId?: string;
    /**
     * `AWS::FSx::FileSystem.FileSystemTypeVersion`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-filesystemtypeversion
     */
    readonly fileSystemTypeVersion?: string;
    /**
     * `AWS::FSx::FileSystem.KmsKeyId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-kmskeyid
     */
    readonly kmsKeyId?: string;
    /**
     * `AWS::FSx::FileSystem.LustreConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-lustreconfiguration
     */
    readonly lustreConfiguration?: CfnFileSystem.LustreConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::FSx::FileSystem.OntapConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-ontapconfiguration
     */
    readonly ontapConfiguration?: CfnFileSystem.OntapConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::FSx::FileSystem.OpenZFSConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-openzfsconfiguration
     */
    readonly openZfsConfiguration?: CfnFileSystem.OpenZFSConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::FSx::FileSystem.SecurityGroupIds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-securitygroupids
     */
    readonly securityGroupIds?: string[];
    /**
     * `AWS::FSx::FileSystem.StorageCapacity`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-storagecapacity
     */
    readonly storageCapacity?: number;
    /**
     * `AWS::FSx::FileSystem.StorageType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-storagetype
     */
    readonly storageType?: string;
    /**
     * `AWS::FSx::FileSystem.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::FSx::FileSystem.WindowsConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-windowsconfiguration
     */
    readonly windowsConfiguration?: CfnFileSystem.WindowsConfigurationProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::FSx::FileSystem`.
 *
 * @external
 * @cloudformationResource AWS::FSx::FileSystem
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html
 */
export declare class CfnFileSystem extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::FSx::FileSystem";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnFileSystem;
    /**
     * @external
     * @cloudformationAttribute DNSName
     */
    readonly attrDnsName: string;
    /**
     * @external
     * @cloudformationAttribute LustreMountName
     */
    readonly attrLustreMountName: string;
    /**
     * @external
     * @cloudformationAttribute RootVolumeId
     */
    readonly attrRootVolumeId: string;
    /**
     * `AWS::FSx::FileSystem.FileSystemType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-filesystemtype
     */
    fileSystemType: string;
    /**
     * `AWS::FSx::FileSystem.SubnetIds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-subnetids
     */
    subnetIds: string[];
    /**
     * `AWS::FSx::FileSystem.BackupId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-backupid
     */
    backupId: string | undefined;
    /**
     * `AWS::FSx::FileSystem.FileSystemTypeVersion`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-filesystemtypeversion
     */
    fileSystemTypeVersion: string | undefined;
    /**
     * `AWS::FSx::FileSystem.KmsKeyId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-kmskeyid
     */
    kmsKeyId: string | undefined;
    /**
     * `AWS::FSx::FileSystem.LustreConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-lustreconfiguration
     */
    lustreConfiguration: CfnFileSystem.LustreConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::FSx::FileSystem.OntapConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-ontapconfiguration
     */
    ontapConfiguration: CfnFileSystem.OntapConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::FSx::FileSystem.OpenZFSConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-openzfsconfiguration
     */
    openZfsConfiguration: CfnFileSystem.OpenZFSConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::FSx::FileSystem.SecurityGroupIds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-securitygroupids
     */
    securityGroupIds: string[] | undefined;
    /**
     * `AWS::FSx::FileSystem.StorageCapacity`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-storagecapacity
     */
    storageCapacity: number | undefined;
    /**
     * `AWS::FSx::FileSystem.StorageType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-storagetype
     */
    storageType: string | undefined;
    /**
     * `AWS::FSx::FileSystem.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::FSx::FileSystem.WindowsConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-windowsconfiguration
     */
    windowsConfiguration: CfnFileSystem.WindowsConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::FSx::FileSystem`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnFileSystemProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::FSx::FileSystem`.
 *
 * @external
 * @cloudformationResource AWS::FSx::FileSystem
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html
 */
export declare namespace CfnFileSystem {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration-auditlogconfiguration.html
     */
    interface AuditLogConfigurationProperty {
        /**
         * `CfnFileSystem.AuditLogConfigurationProperty.AuditLogDestination`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration-auditlogconfiguration.html#cfn-fsx-filesystem-windowsconfiguration-auditlogconfiguration-auditlogdestination
         */
        readonly auditLogDestination?: string;
        /**
         * `CfnFileSystem.AuditLogConfigurationProperty.FileAccessAuditLogLevel`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration-auditlogconfiguration.html#cfn-fsx-filesystem-windowsconfiguration-auditlogconfiguration-fileaccessauditloglevel
         */
        readonly fileAccessAuditLogLevel: string;
        /**
         * `CfnFileSystem.AuditLogConfigurationProperty.FileShareAccessAuditLogLevel`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration-auditlogconfiguration.html#cfn-fsx-filesystem-windowsconfiguration-auditlogconfiguration-fileshareaccessauditloglevel
         */
        readonly fileShareAccessAuditLogLevel: string;
    }
}
/**
 * A CloudFormation `AWS::FSx::FileSystem`.
 *
 * @external
 * @cloudformationResource AWS::FSx::FileSystem
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html
 */
export declare namespace CfnFileSystem {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-openzfsconfiguration-rootvolumeconfiguration-nfsexports-clientconfigurations.html
     */
    interface ClientConfigurationsProperty {
        /**
         * `CfnFileSystem.ClientConfigurationsProperty.Clients`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-openzfsconfiguration-rootvolumeconfiguration-nfsexports-clientconfigurations.html#cfn-fsx-filesystem-openzfsconfiguration-rootvolumeconfiguration-nfsexports-clientconfigurations-clients
         */
        readonly clients?: string;
        /**
         * `CfnFileSystem.ClientConfigurationsProperty.Options`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-openzfsconfiguration-rootvolumeconfiguration-nfsexports-clientconfigurations.html#cfn-fsx-filesystem-openzfsconfiguration-rootvolumeconfiguration-nfsexports-clientconfigurations-options
         */
        readonly options?: string[];
    }
}
/**
 * A CloudFormation `AWS::FSx::FileSystem`.
 *
 * @external
 * @cloudformationResource AWS::FSx::FileSystem
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html
 */
export declare namespace CfnFileSystem {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-openzfsconfiguration-diskiopsconfiguration.html
     */
    interface DiskIopsConfigurationProperty {
        /**
         * `CfnFileSystem.DiskIopsConfigurationProperty.Iops`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-openzfsconfiguration-diskiopsconfiguration.html#cfn-fsx-filesystem-openzfsconfiguration-diskiopsconfiguration-iops
         */
        readonly iops?: number;
        /**
         * `CfnFileSystem.DiskIopsConfigurationProperty.Mode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-openzfsconfiguration-diskiopsconfiguration.html#cfn-fsx-filesystem-openzfsconfiguration-diskiopsconfiguration-mode
         */
        readonly mode?: string;
    }
}
/**
 * A CloudFormation `AWS::FSx::FileSystem`.
 *
 * @external
 * @cloudformationResource AWS::FSx::FileSystem
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html
 */
export declare namespace CfnFileSystem {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-lustreconfiguration.html
     */
    interface LustreConfigurationProperty {
        /**
         * `CfnFileSystem.LustreConfigurationProperty.AutoImportPolicy`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-lustreconfiguration.html#cfn-fsx-filesystem-lustreconfiguration-autoimportpolicy
         */
        readonly autoImportPolicy?: string;
        /**
         * `CfnFileSystem.LustreConfigurationProperty.AutomaticBackupRetentionDays`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-lustreconfiguration.html#cfn-fsx-filesystem-lustreconfiguration-automaticbackupretentiondays
         */
        readonly automaticBackupRetentionDays?: number;
        /**
         * `CfnFileSystem.LustreConfigurationProperty.CopyTagsToBackups`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-lustreconfiguration.html#cfn-fsx-filesystem-lustreconfiguration-copytagstobackups
         */
        readonly copyTagsToBackups?: boolean | cdk.IResolvable;
        /**
         * `CfnFileSystem.LustreConfigurationProperty.DailyAutomaticBackupStartTime`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-lustreconfiguration.html#cfn-fsx-filesystem-lustreconfiguration-dailyautomaticbackupstarttime
         */
        readonly dailyAutomaticBackupStartTime?: string;
        /**
         * `CfnFileSystem.LustreConfigurationProperty.DataCompressionType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-lustreconfiguration.html#cfn-fsx-filesystem-lustreconfiguration-datacompressiontype
         */
        readonly dataCompressionType?: string;
        /**
         * `CfnFileSystem.LustreConfigurationProperty.DeploymentType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-lustreconfiguration.html#cfn-fsx-filesystem-lustreconfiguration-deploymenttype
         */
        readonly deploymentType?: string;
        /**
         * `CfnFileSystem.LustreConfigurationProperty.DriveCacheType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-lustreconfiguration.html#cfn-fsx-filesystem-lustreconfiguration-drivecachetype
         */
        readonly driveCacheType?: string;
        /**
         * `CfnFileSystem.LustreConfigurationProperty.ExportPath`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-lustreconfiguration.html#cfn-fsx-filesystem-lustreconfiguration-exportpath
         */
        readonly exportPath?: string;
        /**
         * `CfnFileSystem.LustreConfigurationProperty.ImportPath`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-lustreconfiguration.html#cfn-fsx-filesystem-lustreconfiguration-importpath
         */
        readonly importPath?: string;
        /**
         * `CfnFileSystem.LustreConfigurationProperty.ImportedFileChunkSize`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-lustreconfiguration.html#cfn-fsx-filesystem-lustreconfiguration-importedfilechunksize
         */
        readonly importedFileChunkSize?: number;
        /**
         * `CfnFileSystem.LustreConfigurationProperty.PerUnitStorageThroughput`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-lustreconfiguration.html#cfn-fsx-filesystem-lustreconfiguration-perunitstoragethroughput
         */
        readonly perUnitStorageThroughput?: number;
        /**
         * `CfnFileSystem.LustreConfigurationProperty.WeeklyMaintenanceStartTime`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-lustreconfiguration.html#cfn-fsx-filesystem-lustreconfiguration-weeklymaintenancestarttime
         */
        readonly weeklyMaintenanceStartTime?: string;
    }
}
/**
 * A CloudFormation `AWS::FSx::FileSystem`.
 *
 * @external
 * @cloudformationResource AWS::FSx::FileSystem
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html
 */
export declare namespace CfnFileSystem {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-openzfsconfiguration-rootvolumeconfiguration-nfsexports.html
     */
    interface NfsExportsProperty {
        /**
         * `CfnFileSystem.NfsExportsProperty.ClientConfigurations`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-openzfsconfiguration-rootvolumeconfiguration-nfsexports.html#cfn-fsx-filesystem-openzfsconfiguration-rootvolumeconfiguration-nfsexports-clientconfigurations
         */
        readonly clientConfigurations?: Array<CfnFileSystem.ClientConfigurationsProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::FSx::FileSystem`.
 *
 * @external
 * @cloudformationResource AWS::FSx::FileSystem
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html
 */
export declare namespace CfnFileSystem {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-ontapconfiguration.html
     */
    interface OntapConfigurationProperty {
        /**
         * `CfnFileSystem.OntapConfigurationProperty.AutomaticBackupRetentionDays`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-ontapconfiguration.html#cfn-fsx-filesystem-ontapconfiguration-automaticbackupretentiondays
         */
        readonly automaticBackupRetentionDays?: number;
        /**
         * `CfnFileSystem.OntapConfigurationProperty.DailyAutomaticBackupStartTime`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-ontapconfiguration.html#cfn-fsx-filesystem-ontapconfiguration-dailyautomaticbackupstarttime
         */
        readonly dailyAutomaticBackupStartTime?: string;
        /**
         * `CfnFileSystem.OntapConfigurationProperty.DeploymentType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-ontapconfiguration.html#cfn-fsx-filesystem-ontapconfiguration-deploymenttype
         */
        readonly deploymentType: string;
        /**
         * `CfnFileSystem.OntapConfigurationProperty.DiskIopsConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-ontapconfiguration.html#cfn-fsx-filesystem-ontapconfiguration-diskiopsconfiguration
         */
        readonly diskIopsConfiguration?: CfnFileSystem.DiskIopsConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnFileSystem.OntapConfigurationProperty.EndpointIpAddressRange`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-ontapconfiguration.html#cfn-fsx-filesystem-ontapconfiguration-endpointipaddressrange
         */
        readonly endpointIpAddressRange?: string;
        /**
         * `CfnFileSystem.OntapConfigurationProperty.FsxAdminPassword`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-ontapconfiguration.html#cfn-fsx-filesystem-ontapconfiguration-fsxadminpassword
         */
        readonly fsxAdminPassword?: string;
        /**
         * `CfnFileSystem.OntapConfigurationProperty.PreferredSubnetId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-ontapconfiguration.html#cfn-fsx-filesystem-ontapconfiguration-preferredsubnetid
         */
        readonly preferredSubnetId?: string;
        /**
         * `CfnFileSystem.OntapConfigurationProperty.RouteTableIds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-ontapconfiguration.html#cfn-fsx-filesystem-ontapconfiguration-routetableids
         */
        readonly routeTableIds?: string[];
        /**
         * `CfnFileSystem.OntapConfigurationProperty.ThroughputCapacity`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-ontapconfiguration.html#cfn-fsx-filesystem-ontapconfiguration-throughputcapacity
         */
        readonly throughputCapacity?: number;
        /**
         * `CfnFileSystem.OntapConfigurationProperty.WeeklyMaintenanceStartTime`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-ontapconfiguration.html#cfn-fsx-filesystem-ontapconfiguration-weeklymaintenancestarttime
         */
        readonly weeklyMaintenanceStartTime?: string;
    }
}
/**
 * A CloudFormation `AWS::FSx::FileSystem`.
 *
 * @external
 * @cloudformationResource AWS::FSx::FileSystem
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html
 */
export declare namespace CfnFileSystem {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-openzfsconfiguration.html
     */
    interface OpenZFSConfigurationProperty {
        /**
         * `CfnFileSystem.OpenZFSConfigurationProperty.AutomaticBackupRetentionDays`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-openzfsconfiguration.html#cfn-fsx-filesystem-openzfsconfiguration-automaticbackupretentiondays
         */
        readonly automaticBackupRetentionDays?: number;
        /**
         * `CfnFileSystem.OpenZFSConfigurationProperty.CopyTagsToBackups`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-openzfsconfiguration.html#cfn-fsx-filesystem-openzfsconfiguration-copytagstobackups
         */
        readonly copyTagsToBackups?: boolean | cdk.IResolvable;
        /**
         * `CfnFileSystem.OpenZFSConfigurationProperty.CopyTagsToVolumes`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-openzfsconfiguration.html#cfn-fsx-filesystem-openzfsconfiguration-copytagstovolumes
         */
        readonly copyTagsToVolumes?: boolean | cdk.IResolvable;
        /**
         * `CfnFileSystem.OpenZFSConfigurationProperty.DailyAutomaticBackupStartTime`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-openzfsconfiguration.html#cfn-fsx-filesystem-openzfsconfiguration-dailyautomaticbackupstarttime
         */
        readonly dailyAutomaticBackupStartTime?: string;
        /**
         * `CfnFileSystem.OpenZFSConfigurationProperty.DeploymentType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-openzfsconfiguration.html#cfn-fsx-filesystem-openzfsconfiguration-deploymenttype
         */
        readonly deploymentType: string;
        /**
         * `CfnFileSystem.OpenZFSConfigurationProperty.DiskIopsConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-openzfsconfiguration.html#cfn-fsx-filesystem-openzfsconfiguration-diskiopsconfiguration
         */
        readonly diskIopsConfiguration?: CfnFileSystem.DiskIopsConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnFileSystem.OpenZFSConfigurationProperty.RootVolumeConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-openzfsconfiguration.html#cfn-fsx-filesystem-openzfsconfiguration-rootvolumeconfiguration
         */
        readonly rootVolumeConfiguration?: CfnFileSystem.RootVolumeConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnFileSystem.OpenZFSConfigurationProperty.ThroughputCapacity`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-openzfsconfiguration.html#cfn-fsx-filesystem-openzfsconfiguration-throughputcapacity
         */
        readonly throughputCapacity?: number;
        /**
         * `CfnFileSystem.OpenZFSConfigurationProperty.WeeklyMaintenanceStartTime`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-openzfsconfiguration.html#cfn-fsx-filesystem-openzfsconfiguration-weeklymaintenancestarttime
         */
        readonly weeklyMaintenanceStartTime?: string;
    }
}
/**
 * A CloudFormation `AWS::FSx::FileSystem`.
 *
 * @external
 * @cloudformationResource AWS::FSx::FileSystem
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html
 */
export declare namespace CfnFileSystem {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-openzfsconfiguration-rootvolumeconfiguration.html
     */
    interface RootVolumeConfigurationProperty {
        /**
         * `CfnFileSystem.RootVolumeConfigurationProperty.CopyTagsToSnapshots`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-openzfsconfiguration-rootvolumeconfiguration.html#cfn-fsx-filesystem-openzfsconfiguration-rootvolumeconfiguration-copytagstosnapshots
         */
        readonly copyTagsToSnapshots?: boolean | cdk.IResolvable;
        /**
         * `CfnFileSystem.RootVolumeConfigurationProperty.DataCompressionType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-openzfsconfiguration-rootvolumeconfiguration.html#cfn-fsx-filesystem-openzfsconfiguration-rootvolumeconfiguration-datacompressiontype
         */
        readonly dataCompressionType?: string;
        /**
         * `CfnFileSystem.RootVolumeConfigurationProperty.NfsExports`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-openzfsconfiguration-rootvolumeconfiguration.html#cfn-fsx-filesystem-openzfsconfiguration-rootvolumeconfiguration-nfsexports
         */
        readonly nfsExports?: Array<CfnFileSystem.NfsExportsProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnFileSystem.RootVolumeConfigurationProperty.ReadOnly`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-openzfsconfiguration-rootvolumeconfiguration.html#cfn-fsx-filesystem-openzfsconfiguration-rootvolumeconfiguration-readonly
         */
        readonly readOnly?: boolean | cdk.IResolvable;
        /**
         * `CfnFileSystem.RootVolumeConfigurationProperty.UserAndGroupQuotas`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-openzfsconfiguration-rootvolumeconfiguration.html#cfn-fsx-filesystem-openzfsconfiguration-rootvolumeconfiguration-userandgroupquotas
         */
        readonly userAndGroupQuotas?: Array<CfnFileSystem.UserAndGroupQuotasProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::FSx::FileSystem`.
 *
 * @external
 * @cloudformationResource AWS::FSx::FileSystem
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html
 */
export declare namespace CfnFileSystem {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration-selfmanagedactivedirectoryconfiguration.html
     */
    interface SelfManagedActiveDirectoryConfigurationProperty {
        /**
         * `CfnFileSystem.SelfManagedActiveDirectoryConfigurationProperty.DnsIps`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration-selfmanagedactivedirectoryconfiguration.html#cfn-fsx-filesystem-windowsconfiguration-selfmanagedactivedirectoryconfiguration-dnsips
         */
        readonly dnsIps?: string[];
        /**
         * `CfnFileSystem.SelfManagedActiveDirectoryConfigurationProperty.DomainName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration-selfmanagedactivedirectoryconfiguration.html#cfn-fsx-filesystem-windowsconfiguration-selfmanagedactivedirectoryconfiguration-domainname
         */
        readonly domainName?: string;
        /**
         * `CfnFileSystem.SelfManagedActiveDirectoryConfigurationProperty.FileSystemAdministratorsGroup`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration-selfmanagedactivedirectoryconfiguration.html#cfn-fsx-filesystem-windowsconfiguration-selfmanagedactivedirectoryconfiguration-filesystemadministratorsgroup
         */
        readonly fileSystemAdministratorsGroup?: string;
        /**
         * `CfnFileSystem.SelfManagedActiveDirectoryConfigurationProperty.OrganizationalUnitDistinguishedName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration-selfmanagedactivedirectoryconfiguration.html#cfn-fsx-filesystem-windowsconfiguration-selfmanagedactivedirectoryconfiguration-organizationalunitdistinguishedname
         */
        readonly organizationalUnitDistinguishedName?: string;
        /**
         * `CfnFileSystem.SelfManagedActiveDirectoryConfigurationProperty.Password`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration-selfmanagedactivedirectoryconfiguration.html#cfn-fsx-filesystem-windowsconfiguration-selfmanagedactivedirectoryconfiguration-password
         */
        readonly password?: string;
        /**
         * `CfnFileSystem.SelfManagedActiveDirectoryConfigurationProperty.UserName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration-selfmanagedactivedirectoryconfiguration.html#cfn-fsx-filesystem-windowsconfiguration-selfmanagedactivedirectoryconfiguration-username
         */
        readonly userName?: string;
    }
}
/**
 * A CloudFormation `AWS::FSx::FileSystem`.
 *
 * @external
 * @cloudformationResource AWS::FSx::FileSystem
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html
 */
export declare namespace CfnFileSystem {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-openzfsconfiguration-rootvolumeconfiguration-userandgroupquotas.html
     */
    interface UserAndGroupQuotasProperty {
        /**
         * `CfnFileSystem.UserAndGroupQuotasProperty.Id`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-openzfsconfiguration-rootvolumeconfiguration-userandgroupquotas.html#cfn-fsx-filesystem-openzfsconfiguration-rootvolumeconfiguration-userandgroupquotas-id
         */
        readonly id?: number;
        /**
         * `CfnFileSystem.UserAndGroupQuotasProperty.StorageCapacityQuotaGiB`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-openzfsconfiguration-rootvolumeconfiguration-userandgroupquotas.html#cfn-fsx-filesystem-openzfsconfiguration-rootvolumeconfiguration-userandgroupquotas-storagecapacityquotagib
         */
        readonly storageCapacityQuotaGiB?: number;
        /**
         * `CfnFileSystem.UserAndGroupQuotasProperty.Type`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-openzfsconfiguration-rootvolumeconfiguration-userandgroupquotas.html#cfn-fsx-filesystem-openzfsconfiguration-rootvolumeconfiguration-userandgroupquotas-type
         */
        readonly type?: string;
    }
}
/**
 * A CloudFormation `AWS::FSx::FileSystem`.
 *
 * @external
 * @cloudformationResource AWS::FSx::FileSystem
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html
 */
export declare namespace CfnFileSystem {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration.html
     */
    interface WindowsConfigurationProperty {
        /**
         * `CfnFileSystem.WindowsConfigurationProperty.ActiveDirectoryId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration.html#cfn-fsx-filesystem-windowsconfiguration-activedirectoryid
         */
        readonly activeDirectoryId?: string;
        /**
         * `CfnFileSystem.WindowsConfigurationProperty.Aliases`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration.html#cfn-fsx-filesystem-windowsconfiguration-aliases
         */
        readonly aliases?: string[];
        /**
         * `CfnFileSystem.WindowsConfigurationProperty.AuditLogConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration.html#cfn-fsx-filesystem-windowsconfiguration-auditlogconfiguration
         */
        readonly auditLogConfiguration?: CfnFileSystem.AuditLogConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnFileSystem.WindowsConfigurationProperty.AutomaticBackupRetentionDays`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration.html#cfn-fsx-filesystem-windowsconfiguration-automaticbackupretentiondays
         */
        readonly automaticBackupRetentionDays?: number;
        /**
         * `CfnFileSystem.WindowsConfigurationProperty.CopyTagsToBackups`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration.html#cfn-fsx-filesystem-windowsconfiguration-copytagstobackups
         */
        readonly copyTagsToBackups?: boolean | cdk.IResolvable;
        /**
         * `CfnFileSystem.WindowsConfigurationProperty.DailyAutomaticBackupStartTime`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration.html#cfn-fsx-filesystem-windowsconfiguration-dailyautomaticbackupstarttime
         */
        readonly dailyAutomaticBackupStartTime?: string;
        /**
         * `CfnFileSystem.WindowsConfigurationProperty.DeploymentType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration.html#cfn-fsx-filesystem-windowsconfiguration-deploymenttype
         */
        readonly deploymentType?: string;
        /**
         * `CfnFileSystem.WindowsConfigurationProperty.PreferredSubnetId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration.html#cfn-fsx-filesystem-windowsconfiguration-preferredsubnetid
         */
        readonly preferredSubnetId?: string;
        /**
         * `CfnFileSystem.WindowsConfigurationProperty.SelfManagedActiveDirectoryConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration.html#cfn-fsx-filesystem-windowsconfiguration-selfmanagedactivedirectoryconfiguration
         */
        readonly selfManagedActiveDirectoryConfiguration?: CfnFileSystem.SelfManagedActiveDirectoryConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnFileSystem.WindowsConfigurationProperty.ThroughputCapacity`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration.html#cfn-fsx-filesystem-windowsconfiguration-throughputcapacity
         */
        readonly throughputCapacity: number;
        /**
         * `CfnFileSystem.WindowsConfigurationProperty.WeeklyMaintenanceStartTime`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration.html#cfn-fsx-filesystem-windowsconfiguration-weeklymaintenancestarttime
         */
        readonly weeklyMaintenanceStartTime?: string;
    }
}
