"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApplicationSettings = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings gitlab_application_settings}
*/
class ApplicationSettings extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings gitlab_application_settings} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApplicationSettingsConfig = {}
    */
    constructor(scope, id, config = {}) {
        super(scope, id, {
            terraformResourceType: 'gitlab_application_settings',
            terraformGeneratorMetadata: {
                providerName: 'gitlab',
                providerVersion: '3.17.0',
                providerVersionConstraint: '~> 3.14'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        this._abuseNotificationEmail = config.abuseNotificationEmail;
        this._adminMode = config.adminMode;
        this._afterSignOutPath = config.afterSignOutPath;
        this._afterSignUpText = config.afterSignUpText;
        this._akismetApiKey = config.akismetApiKey;
        this._akismetEnabled = config.akismetEnabled;
        this._allowGroupOwnersToManageLdap = config.allowGroupOwnersToManageLdap;
        this._allowLocalRequestsFromSystemHooks = config.allowLocalRequestsFromSystemHooks;
        this._allowLocalRequestsFromWebHooksAndServices = config.allowLocalRequestsFromWebHooksAndServices;
        this._archiveBuildsInHumanReadable = config.archiveBuildsInHumanReadable;
        this._assetProxyAllowlist = config.assetProxyAllowlist;
        this._assetProxyEnabled = config.assetProxyEnabled;
        this._assetProxySecretKey = config.assetProxySecretKey;
        this._assetProxyUrl = config.assetProxyUrl;
        this._authorizedKeysEnabled = config.authorizedKeysEnabled;
        this._autoDevopsDomain = config.autoDevopsDomain;
        this._autoDevopsEnabled = config.autoDevopsEnabled;
        this._automaticPurchasedStorageAllocation = config.automaticPurchasedStorageAllocation;
        this._checkNamespacePlan = config.checkNamespacePlan;
        this._commitEmailHostname = config.commitEmailHostname;
        this._containerExpirationPoliciesEnableHistoricEntries = config.containerExpirationPoliciesEnableHistoricEntries;
        this._containerRegistryCleanupTagsServiceMaxListSize = config.containerRegistryCleanupTagsServiceMaxListSize;
        this._containerRegistryDeleteTagsServiceTimeout = config.containerRegistryDeleteTagsServiceTimeout;
        this._containerRegistryExpirationPoliciesCaching = config.containerRegistryExpirationPoliciesCaching;
        this._containerRegistryExpirationPoliciesWorkerCapacity = config.containerRegistryExpirationPoliciesWorkerCapacity;
        this._containerRegistryTokenExpireDelay = config.containerRegistryTokenExpireDelay;
        this._deactivateDormantUsers = config.deactivateDormantUsers;
        this._defaultArtifactsExpireIn = config.defaultArtifactsExpireIn;
        this._defaultBranchName = config.defaultBranchName;
        this._defaultBranchProtection = config.defaultBranchProtection;
        this._defaultCiConfigPath = config.defaultCiConfigPath;
        this._defaultGroupVisibility = config.defaultGroupVisibility;
        this._defaultProjectCreation = config.defaultProjectCreation;
        this._defaultProjectVisibility = config.defaultProjectVisibility;
        this._defaultProjectsLimit = config.defaultProjectsLimit;
        this._defaultSnippetVisibility = config.defaultSnippetVisibility;
        this._delayedGroupDeletion = config.delayedGroupDeletion;
        this._delayedProjectDeletion = config.delayedProjectDeletion;
        this._deleteInactiveProjects = config.deleteInactiveProjects;
        this._deletionAdjournedPeriod = config.deletionAdjournedPeriod;
        this._diffMaxFiles = config.diffMaxFiles;
        this._diffMaxLines = config.diffMaxLines;
        this._diffMaxPatchBytes = config.diffMaxPatchBytes;
        this._disableFeedToken = config.disableFeedToken;
        this._disabledOauthSignInSources = config.disabledOauthSignInSources;
        this._dnsRebindingProtectionEnabled = config.dnsRebindingProtectionEnabled;
        this._domainAllowlist = config.domainAllowlist;
        this._domainDenylist = config.domainDenylist;
        this._domainDenylistEnabled = config.domainDenylistEnabled;
        this._dsaKeyRestriction = config.dsaKeyRestriction;
        this._ecdsaKeyRestriction = config.ecdsaKeyRestriction;
        this._ecdsaSkKeyRestriction = config.ecdsaSkKeyRestriction;
        this._ed25519KeyRestriction = config.ed25519KeyRestriction;
        this._ed25519SkKeyRestriction = config.ed25519SkKeyRestriction;
        this._eksAccessKeyId = config.eksAccessKeyId;
        this._eksAccountId = config.eksAccountId;
        this._eksIntegrationEnabled = config.eksIntegrationEnabled;
        this._eksSecretAccessKey = config.eksSecretAccessKey;
        this._elasticsearchAws = config.elasticsearchAws;
        this._elasticsearchAwsAccessKey = config.elasticsearchAwsAccessKey;
        this._elasticsearchAwsRegion = config.elasticsearchAwsRegion;
        this._elasticsearchAwsSecretAccessKey = config.elasticsearchAwsSecretAccessKey;
        this._elasticsearchIndexedFieldLengthLimit = config.elasticsearchIndexedFieldLengthLimit;
        this._elasticsearchIndexedFileSizeLimitKb = config.elasticsearchIndexedFileSizeLimitKb;
        this._elasticsearchIndexing = config.elasticsearchIndexing;
        this._elasticsearchLimitIndexing = config.elasticsearchLimitIndexing;
        this._elasticsearchMaxBulkConcurrency = config.elasticsearchMaxBulkConcurrency;
        this._elasticsearchMaxBulkSizeMb = config.elasticsearchMaxBulkSizeMb;
        this._elasticsearchNamespaceIds = config.elasticsearchNamespaceIds;
        this._elasticsearchPassword = config.elasticsearchPassword;
        this._elasticsearchProjectIds = config.elasticsearchProjectIds;
        this._elasticsearchSearch = config.elasticsearchSearch;
        this._elasticsearchUrl = config.elasticsearchUrl;
        this._elasticsearchUsername = config.elasticsearchUsername;
        this._emailAdditionalText = config.emailAdditionalText;
        this._emailAuthorInBody = config.emailAuthorInBody;
        this._enabledGitAccessProtocol = config.enabledGitAccessProtocol;
        this._enforceNamespaceStorageLimit = config.enforceNamespaceStorageLimit;
        this._enforceTerms = config.enforceTerms;
        this._externalAuthClientCert = config.externalAuthClientCert;
        this._externalAuthClientKey = config.externalAuthClientKey;
        this._externalAuthClientKeyPass = config.externalAuthClientKeyPass;
        this._externalAuthorizationServiceDefaultLabel = config.externalAuthorizationServiceDefaultLabel;
        this._externalAuthorizationServiceEnabled = config.externalAuthorizationServiceEnabled;
        this._externalAuthorizationServiceTimeout = config.externalAuthorizationServiceTimeout;
        this._externalAuthorizationServiceUrl = config.externalAuthorizationServiceUrl;
        this._externalPipelineValidationServiceTimeout = config.externalPipelineValidationServiceTimeout;
        this._externalPipelineValidationServiceToken = config.externalPipelineValidationServiceToken;
        this._externalPipelineValidationServiceUrl = config.externalPipelineValidationServiceUrl;
        this._fileTemplateProjectId = config.fileTemplateProjectId;
        this._firstDayOfWeek = config.firstDayOfWeek;
        this._geoNodeAllowedIps = config.geoNodeAllowedIps;
        this._geoStatusTimeout = config.geoStatusTimeout;
        this._gitRateLimitUsersAllowlist = config.gitRateLimitUsersAllowlist;
        this._gitTwoFactorSessionExpiry = config.gitTwoFactorSessionExpiry;
        this._gitalyTimeoutDefault = config.gitalyTimeoutDefault;
        this._gitalyTimeoutFast = config.gitalyTimeoutFast;
        this._gitalyTimeoutMedium = config.gitalyTimeoutMedium;
        this._grafanaEnabled = config.grafanaEnabled;
        this._grafanaUrl = config.grafanaUrl;
        this._gravatarEnabled = config.gravatarEnabled;
        this._hashedStorageEnabled = config.hashedStorageEnabled;
        this._helpPageHideCommercialContent = config.helpPageHideCommercialContent;
        this._helpPageSupportUrl = config.helpPageSupportUrl;
        this._helpPageText = config.helpPageText;
        this._helpText = config.helpText;
        this._hideThirdPartyOffers = config.hideThirdPartyOffers;
        this._homePageUrl = config.homePageUrl;
        this._housekeepingEnabled = config.housekeepingEnabled;
        this._housekeepingFullRepackPeriod = config.housekeepingFullRepackPeriod;
        this._housekeepingGcPeriod = config.housekeepingGcPeriod;
        this._housekeepingIncrementalRepackPeriod = config.housekeepingIncrementalRepackPeriod;
        this._htmlEmailsEnabled = config.htmlEmailsEnabled;
        this._id = config.id;
        this._importSources = config.importSources;
        this._inProductMarketingEmailsEnabled = config.inProductMarketingEmailsEnabled;
        this._inactiveProjectsDeleteAfterMonths = config.inactiveProjectsDeleteAfterMonths;
        this._inactiveProjectsMinSizeMb = config.inactiveProjectsMinSizeMb;
        this._inactiveProjectsSendWarningEmailAfterMonths = config.inactiveProjectsSendWarningEmailAfterMonths;
        this._invisibleCaptchaEnabled = config.invisibleCaptchaEnabled;
        this._issuesCreateLimit = config.issuesCreateLimit;
        this._keepLatestArtifact = config.keepLatestArtifact;
        this._localMarkdownVersion = config.localMarkdownVersion;
        this._mailgunEventsEnabled = config.mailgunEventsEnabled;
        this._mailgunSigningKey = config.mailgunSigningKey;
        this._maintenanceMode = config.maintenanceMode;
        this._maintenanceModeMessage = config.maintenanceModeMessage;
        this._maxArtifactsSize = config.maxArtifactsSize;
        this._maxAttachmentSize = config.maxAttachmentSize;
        this._maxExportSize = config.maxExportSize;
        this._maxImportSize = config.maxImportSize;
        this._maxNumberOfRepositoryDownloads = config.maxNumberOfRepositoryDownloads;
        this._maxNumberOfRepositoryDownloadsWithinTimePeriod = config.maxNumberOfRepositoryDownloadsWithinTimePeriod;
        this._maxPagesSize = config.maxPagesSize;
        this._maxPersonalAccessTokenLifetime = config.maxPersonalAccessTokenLifetime;
        this._maxSshKeyLifetime = config.maxSshKeyLifetime;
        this._metricsMethodCallThreshold = config.metricsMethodCallThreshold;
        this._mirrorAvailable = config.mirrorAvailable;
        this._mirrorCapacityThreshold = config.mirrorCapacityThreshold;
        this._mirrorMaxCapacity = config.mirrorMaxCapacity;
        this._mirrorMaxDelay = config.mirrorMaxDelay;
        this._npmPackageRequestsForwarding = config.npmPackageRequestsForwarding;
        this._outboundLocalRequestsWhitelist = config.outboundLocalRequestsWhitelist;
        this._packageRegistryCleanupPoliciesWorkerCapacity = config.packageRegistryCleanupPoliciesWorkerCapacity;
        this._pagesDomainVerificationEnabled = config.pagesDomainVerificationEnabled;
        this._passwordAuthenticationEnabledForGit = config.passwordAuthenticationEnabledForGit;
        this._passwordAuthenticationEnabledForWeb = config.passwordAuthenticationEnabledForWeb;
        this._passwordLowercaseRequired = config.passwordLowercaseRequired;
        this._passwordNumberRequired = config.passwordNumberRequired;
        this._passwordSymbolRequired = config.passwordSymbolRequired;
        this._passwordUppercaseRequired = config.passwordUppercaseRequired;
        this._performanceBarAllowedGroupPath = config.performanceBarAllowedGroupPath;
        this._personalAccessTokenPrefix = config.personalAccessTokenPrefix;
        this._pipelineLimitPerProjectUserSha = config.pipelineLimitPerProjectUserSha;
        this._plantumlEnabled = config.plantumlEnabled;
        this._plantumlUrl = config.plantumlUrl;
        this._pollingIntervalMultiplier = config.pollingIntervalMultiplier;
        this._projectExportEnabled = config.projectExportEnabled;
        this._prometheusMetricsEnabled = config.prometheusMetricsEnabled;
        this._protectedCiVariables = config.protectedCiVariables;
        this._pushEventActivitiesLimit = config.pushEventActivitiesLimit;
        this._pushEventHooksLimit = config.pushEventHooksLimit;
        this._pypiPackageRequestsForwarding = config.pypiPackageRequestsForwarding;
        this._rateLimitingResponseText = config.rateLimitingResponseText;
        this._rawBlobRequestLimit = config.rawBlobRequestLimit;
        this._recaptchaEnabled = config.recaptchaEnabled;
        this._recaptchaPrivateKey = config.recaptchaPrivateKey;
        this._recaptchaSiteKey = config.recaptchaSiteKey;
        this._receiveMaxInputSize = config.receiveMaxInputSize;
        this._repositoryChecksEnabled = config.repositoryChecksEnabled;
        this._repositorySizeLimit = config.repositorySizeLimit;
        this._repositoryStorages = config.repositoryStorages;
        this._repositoryStoragesWeighted = config.repositoryStoragesWeighted;
        this._requireAdminApprovalAfterUserSignup = config.requireAdminApprovalAfterUserSignup;
        this._requireTwoFactorAuthentication = config.requireTwoFactorAuthentication;
        this._restrictedVisibilityLevels = config.restrictedVisibilityLevels;
        this._rsaKeyRestriction = config.rsaKeyRestriction;
        this._searchRateLimit = config.searchRateLimit;
        this._searchRateLimitUnauthenticated = config.searchRateLimitUnauthenticated;
        this._sendUserConfirmationEmail = config.sendUserConfirmationEmail;
        this._sessionExpireDelay = config.sessionExpireDelay;
        this._sharedRunnersEnabled = config.sharedRunnersEnabled;
        this._sharedRunnersMinutes = config.sharedRunnersMinutes;
        this._sharedRunnersText = config.sharedRunnersText;
        this._sidekiqJobLimiterCompressionThresholdBytes = config.sidekiqJobLimiterCompressionThresholdBytes;
        this._sidekiqJobLimiterLimitBytes = config.sidekiqJobLimiterLimitBytes;
        this._sidekiqJobLimiterMode = config.sidekiqJobLimiterMode;
        this._signInText = config.signInText;
        this._signupEnabled = config.signupEnabled;
        this._slackAppEnabled = config.slackAppEnabled;
        this._slackAppId = config.slackAppId;
        this._slackAppSecret = config.slackAppSecret;
        this._slackAppSigningSecret = config.slackAppSigningSecret;
        this._slackAppVerificationToken = config.slackAppVerificationToken;
        this._snippetSizeLimit = config.snippetSizeLimit;
        this._snowplowAppId = config.snowplowAppId;
        this._snowplowCollectorHostname = config.snowplowCollectorHostname;
        this._snowplowCookieDomain = config.snowplowCookieDomain;
        this._snowplowEnabled = config.snowplowEnabled;
        this._sourcegraphEnabled = config.sourcegraphEnabled;
        this._sourcegraphPublicOnly = config.sourcegraphPublicOnly;
        this._sourcegraphUrl = config.sourcegraphUrl;
        this._spamCheckApiKey = config.spamCheckApiKey;
        this._spamCheckEndpointEnabled = config.spamCheckEndpointEnabled;
        this._spamCheckEndpointUrl = config.spamCheckEndpointUrl;
        this._suggestPipelineEnabled = config.suggestPipelineEnabled;
        this._terminalMaxSessionTime = config.terminalMaxSessionTime;
        this._terms = config.terms;
        this._throttleAuthenticatedApiEnabled = config.throttleAuthenticatedApiEnabled;
        this._throttleAuthenticatedApiPeriodInSeconds = config.throttleAuthenticatedApiPeriodInSeconds;
        this._throttleAuthenticatedApiRequestsPerPeriod = config.throttleAuthenticatedApiRequestsPerPeriod;
        this._throttleAuthenticatedPackagesApiEnabled = config.throttleAuthenticatedPackagesApiEnabled;
        this._throttleAuthenticatedPackagesApiPeriodInSeconds = config.throttleAuthenticatedPackagesApiPeriodInSeconds;
        this._throttleAuthenticatedPackagesApiRequestsPerPeriod = config.throttleAuthenticatedPackagesApiRequestsPerPeriod;
        this._throttleAuthenticatedWebEnabled = config.throttleAuthenticatedWebEnabled;
        this._throttleAuthenticatedWebPeriodInSeconds = config.throttleAuthenticatedWebPeriodInSeconds;
        this._throttleAuthenticatedWebRequestsPerPeriod = config.throttleAuthenticatedWebRequestsPerPeriod;
        this._throttleUnauthenticatedApiEnabled = config.throttleUnauthenticatedApiEnabled;
        this._throttleUnauthenticatedApiPeriodInSeconds = config.throttleUnauthenticatedApiPeriodInSeconds;
        this._throttleUnauthenticatedApiRequestsPerPeriod = config.throttleUnauthenticatedApiRequestsPerPeriod;
        this._throttleUnauthenticatedPackagesApiEnabled = config.throttleUnauthenticatedPackagesApiEnabled;
        this._throttleUnauthenticatedPackagesApiPeriodInSeconds = config.throttleUnauthenticatedPackagesApiPeriodInSeconds;
        this._throttleUnauthenticatedPackagesApiRequestsPerPeriod = config.throttleUnauthenticatedPackagesApiRequestsPerPeriod;
        this._throttleUnauthenticatedWebEnabled = config.throttleUnauthenticatedWebEnabled;
        this._throttleUnauthenticatedWebPeriodInSeconds = config.throttleUnauthenticatedWebPeriodInSeconds;
        this._throttleUnauthenticatedWebRequestsPerPeriod = config.throttleUnauthenticatedWebRequestsPerPeriod;
        this._timeTrackingLimitToHours = config.timeTrackingLimitToHours;
        this._twoFactorGracePeriod = config.twoFactorGracePeriod;
        this._uniqueIpsLimitEnabled = config.uniqueIpsLimitEnabled;
        this._uniqueIpsLimitPerUser = config.uniqueIpsLimitPerUser;
        this._uniqueIpsLimitTimeWindow = config.uniqueIpsLimitTimeWindow;
        this._usagePingEnabled = config.usagePingEnabled;
        this._userDeactivationEmailsEnabled = config.userDeactivationEmailsEnabled;
        this._userDefaultExternal = config.userDefaultExternal;
        this._userDefaultInternalRegex = config.userDefaultInternalRegex;
        this._userOauthApplications = config.userOauthApplications;
        this._userShowAddSshKeyMessage = config.userShowAddSshKeyMessage;
        this._versionCheckEnabled = config.versionCheckEnabled;
        this._webIdeClientsidePreviewEnabled = config.webIdeClientsidePreviewEnabled;
        this._whatsNewVariant = config.whatsNewVariant;
        this._wikiPageMaxContentBytes = config.wikiPageMaxContentBytes;
    }
    get abuseNotificationEmail() {
        return this.getStringAttribute('abuse_notification_email');
    }
    set abuseNotificationEmail(value) {
        this._abuseNotificationEmail = value;
    }
    resetAbuseNotificationEmail() {
        this._abuseNotificationEmail = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get abuseNotificationEmailInput() {
        return this._abuseNotificationEmail;
    }
    get adminMode() {
        return this.getBooleanAttribute('admin_mode');
    }
    set adminMode(value) {
        this._adminMode = value;
    }
    resetAdminMode() {
        this._adminMode = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get adminModeInput() {
        return this._adminMode;
    }
    get afterSignOutPath() {
        return this.getStringAttribute('after_sign_out_path');
    }
    set afterSignOutPath(value) {
        this._afterSignOutPath = value;
    }
    resetAfterSignOutPath() {
        this._afterSignOutPath = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get afterSignOutPathInput() {
        return this._afterSignOutPath;
    }
    get afterSignUpText() {
        return this.getStringAttribute('after_sign_up_text');
    }
    set afterSignUpText(value) {
        this._afterSignUpText = value;
    }
    resetAfterSignUpText() {
        this._afterSignUpText = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get afterSignUpTextInput() {
        return this._afterSignUpText;
    }
    get akismetApiKey() {
        return this.getStringAttribute('akismet_api_key');
    }
    set akismetApiKey(value) {
        this._akismetApiKey = value;
    }
    resetAkismetApiKey() {
        this._akismetApiKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get akismetApiKeyInput() {
        return this._akismetApiKey;
    }
    get akismetEnabled() {
        return this.getBooleanAttribute('akismet_enabled');
    }
    set akismetEnabled(value) {
        this._akismetEnabled = value;
    }
    resetAkismetEnabled() {
        this._akismetEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get akismetEnabledInput() {
        return this._akismetEnabled;
    }
    get allowGroupOwnersToManageLdap() {
        return this.getBooleanAttribute('allow_group_owners_to_manage_ldap');
    }
    set allowGroupOwnersToManageLdap(value) {
        this._allowGroupOwnersToManageLdap = value;
    }
    resetAllowGroupOwnersToManageLdap() {
        this._allowGroupOwnersToManageLdap = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowGroupOwnersToManageLdapInput() {
        return this._allowGroupOwnersToManageLdap;
    }
    get allowLocalRequestsFromSystemHooks() {
        return this.getBooleanAttribute('allow_local_requests_from_system_hooks');
    }
    set allowLocalRequestsFromSystemHooks(value) {
        this._allowLocalRequestsFromSystemHooks = value;
    }
    resetAllowLocalRequestsFromSystemHooks() {
        this._allowLocalRequestsFromSystemHooks = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowLocalRequestsFromSystemHooksInput() {
        return this._allowLocalRequestsFromSystemHooks;
    }
    get allowLocalRequestsFromWebHooksAndServices() {
        return this.getBooleanAttribute('allow_local_requests_from_web_hooks_and_services');
    }
    set allowLocalRequestsFromWebHooksAndServices(value) {
        this._allowLocalRequestsFromWebHooksAndServices = value;
    }
    resetAllowLocalRequestsFromWebHooksAndServices() {
        this._allowLocalRequestsFromWebHooksAndServices = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowLocalRequestsFromWebHooksAndServicesInput() {
        return this._allowLocalRequestsFromWebHooksAndServices;
    }
    get archiveBuildsInHumanReadable() {
        return this.getStringAttribute('archive_builds_in_human_readable');
    }
    set archiveBuildsInHumanReadable(value) {
        this._archiveBuildsInHumanReadable = value;
    }
    resetArchiveBuildsInHumanReadable() {
        this._archiveBuildsInHumanReadable = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get archiveBuildsInHumanReadableInput() {
        return this._archiveBuildsInHumanReadable;
    }
    get assetProxyAllowlist() {
        return this.getListAttribute('asset_proxy_allowlist');
    }
    set assetProxyAllowlist(value) {
        this._assetProxyAllowlist = value;
    }
    resetAssetProxyAllowlist() {
        this._assetProxyAllowlist = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get assetProxyAllowlistInput() {
        return this._assetProxyAllowlist;
    }
    get assetProxyEnabled() {
        return this.getBooleanAttribute('asset_proxy_enabled');
    }
    set assetProxyEnabled(value) {
        this._assetProxyEnabled = value;
    }
    resetAssetProxyEnabled() {
        this._assetProxyEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get assetProxyEnabledInput() {
        return this._assetProxyEnabled;
    }
    get assetProxySecretKey() {
        return this.getStringAttribute('asset_proxy_secret_key');
    }
    set assetProxySecretKey(value) {
        this._assetProxySecretKey = value;
    }
    resetAssetProxySecretKey() {
        this._assetProxySecretKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get assetProxySecretKeyInput() {
        return this._assetProxySecretKey;
    }
    get assetProxyUrl() {
        return this.getStringAttribute('asset_proxy_url');
    }
    set assetProxyUrl(value) {
        this._assetProxyUrl = value;
    }
    resetAssetProxyUrl() {
        this._assetProxyUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get assetProxyUrlInput() {
        return this._assetProxyUrl;
    }
    get authorizedKeysEnabled() {
        return this.getBooleanAttribute('authorized_keys_enabled');
    }
    set authorizedKeysEnabled(value) {
        this._authorizedKeysEnabled = value;
    }
    resetAuthorizedKeysEnabled() {
        this._authorizedKeysEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get authorizedKeysEnabledInput() {
        return this._authorizedKeysEnabled;
    }
    get autoDevopsDomain() {
        return this.getStringAttribute('auto_devops_domain');
    }
    set autoDevopsDomain(value) {
        this._autoDevopsDomain = value;
    }
    resetAutoDevopsDomain() {
        this._autoDevopsDomain = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get autoDevopsDomainInput() {
        return this._autoDevopsDomain;
    }
    get autoDevopsEnabled() {
        return this.getBooleanAttribute('auto_devops_enabled');
    }
    set autoDevopsEnabled(value) {
        this._autoDevopsEnabled = value;
    }
    resetAutoDevopsEnabled() {
        this._autoDevopsEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get autoDevopsEnabledInput() {
        return this._autoDevopsEnabled;
    }
    get automaticPurchasedStorageAllocation() {
        return this.getBooleanAttribute('automatic_purchased_storage_allocation');
    }
    set automaticPurchasedStorageAllocation(value) {
        this._automaticPurchasedStorageAllocation = value;
    }
    resetAutomaticPurchasedStorageAllocation() {
        this._automaticPurchasedStorageAllocation = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get automaticPurchasedStorageAllocationInput() {
        return this._automaticPurchasedStorageAllocation;
    }
    get checkNamespacePlan() {
        return this.getBooleanAttribute('check_namespace_plan');
    }
    set checkNamespacePlan(value) {
        this._checkNamespacePlan = value;
    }
    resetCheckNamespacePlan() {
        this._checkNamespacePlan = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get checkNamespacePlanInput() {
        return this._checkNamespacePlan;
    }
    get commitEmailHostname() {
        return this.getStringAttribute('commit_email_hostname');
    }
    set commitEmailHostname(value) {
        this._commitEmailHostname = value;
    }
    resetCommitEmailHostname() {
        this._commitEmailHostname = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get commitEmailHostnameInput() {
        return this._commitEmailHostname;
    }
    get containerExpirationPoliciesEnableHistoricEntries() {
        return this.getBooleanAttribute('container_expiration_policies_enable_historic_entries');
    }
    set containerExpirationPoliciesEnableHistoricEntries(value) {
        this._containerExpirationPoliciesEnableHistoricEntries = value;
    }
    resetContainerExpirationPoliciesEnableHistoricEntries() {
        this._containerExpirationPoliciesEnableHistoricEntries = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get containerExpirationPoliciesEnableHistoricEntriesInput() {
        return this._containerExpirationPoliciesEnableHistoricEntries;
    }
    get containerRegistryCleanupTagsServiceMaxListSize() {
        return this.getNumberAttribute('container_registry_cleanup_tags_service_max_list_size');
    }
    set containerRegistryCleanupTagsServiceMaxListSize(value) {
        this._containerRegistryCleanupTagsServiceMaxListSize = value;
    }
    resetContainerRegistryCleanupTagsServiceMaxListSize() {
        this._containerRegistryCleanupTagsServiceMaxListSize = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get containerRegistryCleanupTagsServiceMaxListSizeInput() {
        return this._containerRegistryCleanupTagsServiceMaxListSize;
    }
    get containerRegistryDeleteTagsServiceTimeout() {
        return this.getNumberAttribute('container_registry_delete_tags_service_timeout');
    }
    set containerRegistryDeleteTagsServiceTimeout(value) {
        this._containerRegistryDeleteTagsServiceTimeout = value;
    }
    resetContainerRegistryDeleteTagsServiceTimeout() {
        this._containerRegistryDeleteTagsServiceTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get containerRegistryDeleteTagsServiceTimeoutInput() {
        return this._containerRegistryDeleteTagsServiceTimeout;
    }
    get containerRegistryExpirationPoliciesCaching() {
        return this.getBooleanAttribute('container_registry_expiration_policies_caching');
    }
    set containerRegistryExpirationPoliciesCaching(value) {
        this._containerRegistryExpirationPoliciesCaching = value;
    }
    resetContainerRegistryExpirationPoliciesCaching() {
        this._containerRegistryExpirationPoliciesCaching = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get containerRegistryExpirationPoliciesCachingInput() {
        return this._containerRegistryExpirationPoliciesCaching;
    }
    get containerRegistryExpirationPoliciesWorkerCapacity() {
        return this.getNumberAttribute('container_registry_expiration_policies_worker_capacity');
    }
    set containerRegistryExpirationPoliciesWorkerCapacity(value) {
        this._containerRegistryExpirationPoliciesWorkerCapacity = value;
    }
    resetContainerRegistryExpirationPoliciesWorkerCapacity() {
        this._containerRegistryExpirationPoliciesWorkerCapacity = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get containerRegistryExpirationPoliciesWorkerCapacityInput() {
        return this._containerRegistryExpirationPoliciesWorkerCapacity;
    }
    get containerRegistryTokenExpireDelay() {
        return this.getNumberAttribute('container_registry_token_expire_delay');
    }
    set containerRegistryTokenExpireDelay(value) {
        this._containerRegistryTokenExpireDelay = value;
    }
    resetContainerRegistryTokenExpireDelay() {
        this._containerRegistryTokenExpireDelay = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get containerRegistryTokenExpireDelayInput() {
        return this._containerRegistryTokenExpireDelay;
    }
    get deactivateDormantUsers() {
        return this.getBooleanAttribute('deactivate_dormant_users');
    }
    set deactivateDormantUsers(value) {
        this._deactivateDormantUsers = value;
    }
    resetDeactivateDormantUsers() {
        this._deactivateDormantUsers = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deactivateDormantUsersInput() {
        return this._deactivateDormantUsers;
    }
    get defaultArtifactsExpireIn() {
        return this.getStringAttribute('default_artifacts_expire_in');
    }
    set defaultArtifactsExpireIn(value) {
        this._defaultArtifactsExpireIn = value;
    }
    resetDefaultArtifactsExpireIn() {
        this._defaultArtifactsExpireIn = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get defaultArtifactsExpireInInput() {
        return this._defaultArtifactsExpireIn;
    }
    get defaultBranchName() {
        return this.getStringAttribute('default_branch_name');
    }
    set defaultBranchName(value) {
        this._defaultBranchName = value;
    }
    resetDefaultBranchName() {
        this._defaultBranchName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get defaultBranchNameInput() {
        return this._defaultBranchName;
    }
    get defaultBranchProtection() {
        return this.getNumberAttribute('default_branch_protection');
    }
    set defaultBranchProtection(value) {
        this._defaultBranchProtection = value;
    }
    resetDefaultBranchProtection() {
        this._defaultBranchProtection = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get defaultBranchProtectionInput() {
        return this._defaultBranchProtection;
    }
    get defaultCiConfigPath() {
        return this.getStringAttribute('default_ci_config_path');
    }
    set defaultCiConfigPath(value) {
        this._defaultCiConfigPath = value;
    }
    resetDefaultCiConfigPath() {
        this._defaultCiConfigPath = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get defaultCiConfigPathInput() {
        return this._defaultCiConfigPath;
    }
    get defaultGroupVisibility() {
        return this.getStringAttribute('default_group_visibility');
    }
    set defaultGroupVisibility(value) {
        this._defaultGroupVisibility = value;
    }
    resetDefaultGroupVisibility() {
        this._defaultGroupVisibility = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get defaultGroupVisibilityInput() {
        return this._defaultGroupVisibility;
    }
    get defaultProjectCreation() {
        return this.getNumberAttribute('default_project_creation');
    }
    set defaultProjectCreation(value) {
        this._defaultProjectCreation = value;
    }
    resetDefaultProjectCreation() {
        this._defaultProjectCreation = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get defaultProjectCreationInput() {
        return this._defaultProjectCreation;
    }
    get defaultProjectVisibility() {
        return this.getStringAttribute('default_project_visibility');
    }
    set defaultProjectVisibility(value) {
        this._defaultProjectVisibility = value;
    }
    resetDefaultProjectVisibility() {
        this._defaultProjectVisibility = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get defaultProjectVisibilityInput() {
        return this._defaultProjectVisibility;
    }
    get defaultProjectsLimit() {
        return this.getNumberAttribute('default_projects_limit');
    }
    set defaultProjectsLimit(value) {
        this._defaultProjectsLimit = value;
    }
    resetDefaultProjectsLimit() {
        this._defaultProjectsLimit = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get defaultProjectsLimitInput() {
        return this._defaultProjectsLimit;
    }
    get defaultSnippetVisibility() {
        return this.getStringAttribute('default_snippet_visibility');
    }
    set defaultSnippetVisibility(value) {
        this._defaultSnippetVisibility = value;
    }
    resetDefaultSnippetVisibility() {
        this._defaultSnippetVisibility = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get defaultSnippetVisibilityInput() {
        return this._defaultSnippetVisibility;
    }
    get delayedGroupDeletion() {
        return this.getBooleanAttribute('delayed_group_deletion');
    }
    set delayedGroupDeletion(value) {
        this._delayedGroupDeletion = value;
    }
    resetDelayedGroupDeletion() {
        this._delayedGroupDeletion = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get delayedGroupDeletionInput() {
        return this._delayedGroupDeletion;
    }
    get delayedProjectDeletion() {
        return this.getBooleanAttribute('delayed_project_deletion');
    }
    set delayedProjectDeletion(value) {
        this._delayedProjectDeletion = value;
    }
    resetDelayedProjectDeletion() {
        this._delayedProjectDeletion = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get delayedProjectDeletionInput() {
        return this._delayedProjectDeletion;
    }
    get deleteInactiveProjects() {
        return this.getBooleanAttribute('delete_inactive_projects');
    }
    set deleteInactiveProjects(value) {
        this._deleteInactiveProjects = value;
    }
    resetDeleteInactiveProjects() {
        this._deleteInactiveProjects = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deleteInactiveProjectsInput() {
        return this._deleteInactiveProjects;
    }
    get deletionAdjournedPeriod() {
        return this.getNumberAttribute('deletion_adjourned_period');
    }
    set deletionAdjournedPeriod(value) {
        this._deletionAdjournedPeriod = value;
    }
    resetDeletionAdjournedPeriod() {
        this._deletionAdjournedPeriod = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deletionAdjournedPeriodInput() {
        return this._deletionAdjournedPeriod;
    }
    get diffMaxFiles() {
        return this.getNumberAttribute('diff_max_files');
    }
    set diffMaxFiles(value) {
        this._diffMaxFiles = value;
    }
    resetDiffMaxFiles() {
        this._diffMaxFiles = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get diffMaxFilesInput() {
        return this._diffMaxFiles;
    }
    get diffMaxLines() {
        return this.getNumberAttribute('diff_max_lines');
    }
    set diffMaxLines(value) {
        this._diffMaxLines = value;
    }
    resetDiffMaxLines() {
        this._diffMaxLines = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get diffMaxLinesInput() {
        return this._diffMaxLines;
    }
    get diffMaxPatchBytes() {
        return this.getNumberAttribute('diff_max_patch_bytes');
    }
    set diffMaxPatchBytes(value) {
        this._diffMaxPatchBytes = value;
    }
    resetDiffMaxPatchBytes() {
        this._diffMaxPatchBytes = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get diffMaxPatchBytesInput() {
        return this._diffMaxPatchBytes;
    }
    get disableFeedToken() {
        return this.getBooleanAttribute('disable_feed_token');
    }
    set disableFeedToken(value) {
        this._disableFeedToken = value;
    }
    resetDisableFeedToken() {
        this._disableFeedToken = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get disableFeedTokenInput() {
        return this._disableFeedToken;
    }
    get disabledOauthSignInSources() {
        return this.getListAttribute('disabled_oauth_sign_in_sources');
    }
    set disabledOauthSignInSources(value) {
        this._disabledOauthSignInSources = value;
    }
    resetDisabledOauthSignInSources() {
        this._disabledOauthSignInSources = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get disabledOauthSignInSourcesInput() {
        return this._disabledOauthSignInSources;
    }
    get dnsRebindingProtectionEnabled() {
        return this.getBooleanAttribute('dns_rebinding_protection_enabled');
    }
    set dnsRebindingProtectionEnabled(value) {
        this._dnsRebindingProtectionEnabled = value;
    }
    resetDnsRebindingProtectionEnabled() {
        this._dnsRebindingProtectionEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get dnsRebindingProtectionEnabledInput() {
        return this._dnsRebindingProtectionEnabled;
    }
    get domainAllowlist() {
        return this.getListAttribute('domain_allowlist');
    }
    set domainAllowlist(value) {
        this._domainAllowlist = value;
    }
    resetDomainAllowlist() {
        this._domainAllowlist = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get domainAllowlistInput() {
        return this._domainAllowlist;
    }
    get domainDenylist() {
        return this.getListAttribute('domain_denylist');
    }
    set domainDenylist(value) {
        this._domainDenylist = value;
    }
    resetDomainDenylist() {
        this._domainDenylist = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get domainDenylistInput() {
        return this._domainDenylist;
    }
    get domainDenylistEnabled() {
        return this.getBooleanAttribute('domain_denylist_enabled');
    }
    set domainDenylistEnabled(value) {
        this._domainDenylistEnabled = value;
    }
    resetDomainDenylistEnabled() {
        this._domainDenylistEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get domainDenylistEnabledInput() {
        return this._domainDenylistEnabled;
    }
    get dsaKeyRestriction() {
        return this.getNumberAttribute('dsa_key_restriction');
    }
    set dsaKeyRestriction(value) {
        this._dsaKeyRestriction = value;
    }
    resetDsaKeyRestriction() {
        this._dsaKeyRestriction = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get dsaKeyRestrictionInput() {
        return this._dsaKeyRestriction;
    }
    get ecdsaKeyRestriction() {
        return this.getNumberAttribute('ecdsa_key_restriction');
    }
    set ecdsaKeyRestriction(value) {
        this._ecdsaKeyRestriction = value;
    }
    resetEcdsaKeyRestriction() {
        this._ecdsaKeyRestriction = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ecdsaKeyRestrictionInput() {
        return this._ecdsaKeyRestriction;
    }
    get ecdsaSkKeyRestriction() {
        return this.getNumberAttribute('ecdsa_sk_key_restriction');
    }
    set ecdsaSkKeyRestriction(value) {
        this._ecdsaSkKeyRestriction = value;
    }
    resetEcdsaSkKeyRestriction() {
        this._ecdsaSkKeyRestriction = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ecdsaSkKeyRestrictionInput() {
        return this._ecdsaSkKeyRestriction;
    }
    get ed25519KeyRestriction() {
        return this.getNumberAttribute('ed25519_key_restriction');
    }
    set ed25519KeyRestriction(value) {
        this._ed25519KeyRestriction = value;
    }
    resetEd25519KeyRestriction() {
        this._ed25519KeyRestriction = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ed25519KeyRestrictionInput() {
        return this._ed25519KeyRestriction;
    }
    get ed25519SkKeyRestriction() {
        return this.getNumberAttribute('ed25519_sk_key_restriction');
    }
    set ed25519SkKeyRestriction(value) {
        this._ed25519SkKeyRestriction = value;
    }
    resetEd25519SkKeyRestriction() {
        this._ed25519SkKeyRestriction = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ed25519SkKeyRestrictionInput() {
        return this._ed25519SkKeyRestriction;
    }
    get eksAccessKeyId() {
        return this.getStringAttribute('eks_access_key_id');
    }
    set eksAccessKeyId(value) {
        this._eksAccessKeyId = value;
    }
    resetEksAccessKeyId() {
        this._eksAccessKeyId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get eksAccessKeyIdInput() {
        return this._eksAccessKeyId;
    }
    get eksAccountId() {
        return this.getStringAttribute('eks_account_id');
    }
    set eksAccountId(value) {
        this._eksAccountId = value;
    }
    resetEksAccountId() {
        this._eksAccountId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get eksAccountIdInput() {
        return this._eksAccountId;
    }
    get eksIntegrationEnabled() {
        return this.getBooleanAttribute('eks_integration_enabled');
    }
    set eksIntegrationEnabled(value) {
        this._eksIntegrationEnabled = value;
    }
    resetEksIntegrationEnabled() {
        this._eksIntegrationEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get eksIntegrationEnabledInput() {
        return this._eksIntegrationEnabled;
    }
    get eksSecretAccessKey() {
        return this.getStringAttribute('eks_secret_access_key');
    }
    set eksSecretAccessKey(value) {
        this._eksSecretAccessKey = value;
    }
    resetEksSecretAccessKey() {
        this._eksSecretAccessKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get eksSecretAccessKeyInput() {
        return this._eksSecretAccessKey;
    }
    get elasticsearchAws() {
        return this.getBooleanAttribute('elasticsearch_aws');
    }
    set elasticsearchAws(value) {
        this._elasticsearchAws = value;
    }
    resetElasticsearchAws() {
        this._elasticsearchAws = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get elasticsearchAwsInput() {
        return this._elasticsearchAws;
    }
    get elasticsearchAwsAccessKey() {
        return this.getStringAttribute('elasticsearch_aws_access_key');
    }
    set elasticsearchAwsAccessKey(value) {
        this._elasticsearchAwsAccessKey = value;
    }
    resetElasticsearchAwsAccessKey() {
        this._elasticsearchAwsAccessKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get elasticsearchAwsAccessKeyInput() {
        return this._elasticsearchAwsAccessKey;
    }
    get elasticsearchAwsRegion() {
        return this.getStringAttribute('elasticsearch_aws_region');
    }
    set elasticsearchAwsRegion(value) {
        this._elasticsearchAwsRegion = value;
    }
    resetElasticsearchAwsRegion() {
        this._elasticsearchAwsRegion = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get elasticsearchAwsRegionInput() {
        return this._elasticsearchAwsRegion;
    }
    get elasticsearchAwsSecretAccessKey() {
        return this.getStringAttribute('elasticsearch_aws_secret_access_key');
    }
    set elasticsearchAwsSecretAccessKey(value) {
        this._elasticsearchAwsSecretAccessKey = value;
    }
    resetElasticsearchAwsSecretAccessKey() {
        this._elasticsearchAwsSecretAccessKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get elasticsearchAwsSecretAccessKeyInput() {
        return this._elasticsearchAwsSecretAccessKey;
    }
    get elasticsearchIndexedFieldLengthLimit() {
        return this.getNumberAttribute('elasticsearch_indexed_field_length_limit');
    }
    set elasticsearchIndexedFieldLengthLimit(value) {
        this._elasticsearchIndexedFieldLengthLimit = value;
    }
    resetElasticsearchIndexedFieldLengthLimit() {
        this._elasticsearchIndexedFieldLengthLimit = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get elasticsearchIndexedFieldLengthLimitInput() {
        return this._elasticsearchIndexedFieldLengthLimit;
    }
    get elasticsearchIndexedFileSizeLimitKb() {
        return this.getNumberAttribute('elasticsearch_indexed_file_size_limit_kb');
    }
    set elasticsearchIndexedFileSizeLimitKb(value) {
        this._elasticsearchIndexedFileSizeLimitKb = value;
    }
    resetElasticsearchIndexedFileSizeLimitKb() {
        this._elasticsearchIndexedFileSizeLimitKb = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get elasticsearchIndexedFileSizeLimitKbInput() {
        return this._elasticsearchIndexedFileSizeLimitKb;
    }
    get elasticsearchIndexing() {
        return this.getBooleanAttribute('elasticsearch_indexing');
    }
    set elasticsearchIndexing(value) {
        this._elasticsearchIndexing = value;
    }
    resetElasticsearchIndexing() {
        this._elasticsearchIndexing = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get elasticsearchIndexingInput() {
        return this._elasticsearchIndexing;
    }
    get elasticsearchLimitIndexing() {
        return this.getBooleanAttribute('elasticsearch_limit_indexing');
    }
    set elasticsearchLimitIndexing(value) {
        this._elasticsearchLimitIndexing = value;
    }
    resetElasticsearchLimitIndexing() {
        this._elasticsearchLimitIndexing = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get elasticsearchLimitIndexingInput() {
        return this._elasticsearchLimitIndexing;
    }
    get elasticsearchMaxBulkConcurrency() {
        return this.getNumberAttribute('elasticsearch_max_bulk_concurrency');
    }
    set elasticsearchMaxBulkConcurrency(value) {
        this._elasticsearchMaxBulkConcurrency = value;
    }
    resetElasticsearchMaxBulkConcurrency() {
        this._elasticsearchMaxBulkConcurrency = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get elasticsearchMaxBulkConcurrencyInput() {
        return this._elasticsearchMaxBulkConcurrency;
    }
    get elasticsearchMaxBulkSizeMb() {
        return this.getNumberAttribute('elasticsearch_max_bulk_size_mb');
    }
    set elasticsearchMaxBulkSizeMb(value) {
        this._elasticsearchMaxBulkSizeMb = value;
    }
    resetElasticsearchMaxBulkSizeMb() {
        this._elasticsearchMaxBulkSizeMb = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get elasticsearchMaxBulkSizeMbInput() {
        return this._elasticsearchMaxBulkSizeMb;
    }
    get elasticsearchNamespaceIds() {
        return this.getListAttribute('elasticsearch_namespace_ids');
    }
    set elasticsearchNamespaceIds(value) {
        this._elasticsearchNamespaceIds = value;
    }
    resetElasticsearchNamespaceIds() {
        this._elasticsearchNamespaceIds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get elasticsearchNamespaceIdsInput() {
        return this._elasticsearchNamespaceIds;
    }
    get elasticsearchPassword() {
        return this.getStringAttribute('elasticsearch_password');
    }
    set elasticsearchPassword(value) {
        this._elasticsearchPassword = value;
    }
    resetElasticsearchPassword() {
        this._elasticsearchPassword = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get elasticsearchPasswordInput() {
        return this._elasticsearchPassword;
    }
    get elasticsearchProjectIds() {
        return this.getListAttribute('elasticsearch_project_ids');
    }
    set elasticsearchProjectIds(value) {
        this._elasticsearchProjectIds = value;
    }
    resetElasticsearchProjectIds() {
        this._elasticsearchProjectIds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get elasticsearchProjectIdsInput() {
        return this._elasticsearchProjectIds;
    }
    get elasticsearchSearch() {
        return this.getBooleanAttribute('elasticsearch_search');
    }
    set elasticsearchSearch(value) {
        this._elasticsearchSearch = value;
    }
    resetElasticsearchSearch() {
        this._elasticsearchSearch = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get elasticsearchSearchInput() {
        return this._elasticsearchSearch;
    }
    get elasticsearchUrl() {
        return this.getListAttribute('elasticsearch_url');
    }
    set elasticsearchUrl(value) {
        this._elasticsearchUrl = value;
    }
    resetElasticsearchUrl() {
        this._elasticsearchUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get elasticsearchUrlInput() {
        return this._elasticsearchUrl;
    }
    get elasticsearchUsername() {
        return this.getStringAttribute('elasticsearch_username');
    }
    set elasticsearchUsername(value) {
        this._elasticsearchUsername = value;
    }
    resetElasticsearchUsername() {
        this._elasticsearchUsername = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get elasticsearchUsernameInput() {
        return this._elasticsearchUsername;
    }
    get emailAdditionalText() {
        return this.getStringAttribute('email_additional_text');
    }
    set emailAdditionalText(value) {
        this._emailAdditionalText = value;
    }
    resetEmailAdditionalText() {
        this._emailAdditionalText = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get emailAdditionalTextInput() {
        return this._emailAdditionalText;
    }
    get emailAuthorInBody() {
        return this.getBooleanAttribute('email_author_in_body');
    }
    set emailAuthorInBody(value) {
        this._emailAuthorInBody = value;
    }
    resetEmailAuthorInBody() {
        this._emailAuthorInBody = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get emailAuthorInBodyInput() {
        return this._emailAuthorInBody;
    }
    get enabledGitAccessProtocol() {
        return this.getStringAttribute('enabled_git_access_protocol');
    }
    set enabledGitAccessProtocol(value) {
        this._enabledGitAccessProtocol = value;
    }
    resetEnabledGitAccessProtocol() {
        this._enabledGitAccessProtocol = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enabledGitAccessProtocolInput() {
        return this._enabledGitAccessProtocol;
    }
    get enforceNamespaceStorageLimit() {
        return this.getBooleanAttribute('enforce_namespace_storage_limit');
    }
    set enforceNamespaceStorageLimit(value) {
        this._enforceNamespaceStorageLimit = value;
    }
    resetEnforceNamespaceStorageLimit() {
        this._enforceNamespaceStorageLimit = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enforceNamespaceStorageLimitInput() {
        return this._enforceNamespaceStorageLimit;
    }
    get enforceTerms() {
        return this.getBooleanAttribute('enforce_terms');
    }
    set enforceTerms(value) {
        this._enforceTerms = value;
    }
    resetEnforceTerms() {
        this._enforceTerms = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enforceTermsInput() {
        return this._enforceTerms;
    }
    get externalAuthClientCert() {
        return this.getStringAttribute('external_auth_client_cert');
    }
    set externalAuthClientCert(value) {
        this._externalAuthClientCert = value;
    }
    resetExternalAuthClientCert() {
        this._externalAuthClientCert = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get externalAuthClientCertInput() {
        return this._externalAuthClientCert;
    }
    get externalAuthClientKey() {
        return this.getStringAttribute('external_auth_client_key');
    }
    set externalAuthClientKey(value) {
        this._externalAuthClientKey = value;
    }
    resetExternalAuthClientKey() {
        this._externalAuthClientKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get externalAuthClientKeyInput() {
        return this._externalAuthClientKey;
    }
    get externalAuthClientKeyPass() {
        return this.getStringAttribute('external_auth_client_key_pass');
    }
    set externalAuthClientKeyPass(value) {
        this._externalAuthClientKeyPass = value;
    }
    resetExternalAuthClientKeyPass() {
        this._externalAuthClientKeyPass = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get externalAuthClientKeyPassInput() {
        return this._externalAuthClientKeyPass;
    }
    get externalAuthorizationServiceDefaultLabel() {
        return this.getStringAttribute('external_authorization_service_default_label');
    }
    set externalAuthorizationServiceDefaultLabel(value) {
        this._externalAuthorizationServiceDefaultLabel = value;
    }
    resetExternalAuthorizationServiceDefaultLabel() {
        this._externalAuthorizationServiceDefaultLabel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get externalAuthorizationServiceDefaultLabelInput() {
        return this._externalAuthorizationServiceDefaultLabel;
    }
    get externalAuthorizationServiceEnabled() {
        return this.getBooleanAttribute('external_authorization_service_enabled');
    }
    set externalAuthorizationServiceEnabled(value) {
        this._externalAuthorizationServiceEnabled = value;
    }
    resetExternalAuthorizationServiceEnabled() {
        this._externalAuthorizationServiceEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get externalAuthorizationServiceEnabledInput() {
        return this._externalAuthorizationServiceEnabled;
    }
    get externalAuthorizationServiceTimeout() {
        return this.getNumberAttribute('external_authorization_service_timeout');
    }
    set externalAuthorizationServiceTimeout(value) {
        this._externalAuthorizationServiceTimeout = value;
    }
    resetExternalAuthorizationServiceTimeout() {
        this._externalAuthorizationServiceTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get externalAuthorizationServiceTimeoutInput() {
        return this._externalAuthorizationServiceTimeout;
    }
    get externalAuthorizationServiceUrl() {
        return this.getStringAttribute('external_authorization_service_url');
    }
    set externalAuthorizationServiceUrl(value) {
        this._externalAuthorizationServiceUrl = value;
    }
    resetExternalAuthorizationServiceUrl() {
        this._externalAuthorizationServiceUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get externalAuthorizationServiceUrlInput() {
        return this._externalAuthorizationServiceUrl;
    }
    get externalPipelineValidationServiceTimeout() {
        return this.getNumberAttribute('external_pipeline_validation_service_timeout');
    }
    set externalPipelineValidationServiceTimeout(value) {
        this._externalPipelineValidationServiceTimeout = value;
    }
    resetExternalPipelineValidationServiceTimeout() {
        this._externalPipelineValidationServiceTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get externalPipelineValidationServiceTimeoutInput() {
        return this._externalPipelineValidationServiceTimeout;
    }
    get externalPipelineValidationServiceToken() {
        return this.getStringAttribute('external_pipeline_validation_service_token');
    }
    set externalPipelineValidationServiceToken(value) {
        this._externalPipelineValidationServiceToken = value;
    }
    resetExternalPipelineValidationServiceToken() {
        this._externalPipelineValidationServiceToken = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get externalPipelineValidationServiceTokenInput() {
        return this._externalPipelineValidationServiceToken;
    }
    get externalPipelineValidationServiceUrl() {
        return this.getStringAttribute('external_pipeline_validation_service_url');
    }
    set externalPipelineValidationServiceUrl(value) {
        this._externalPipelineValidationServiceUrl = value;
    }
    resetExternalPipelineValidationServiceUrl() {
        this._externalPipelineValidationServiceUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get externalPipelineValidationServiceUrlInput() {
        return this._externalPipelineValidationServiceUrl;
    }
    get fileTemplateProjectId() {
        return this.getNumberAttribute('file_template_project_id');
    }
    set fileTemplateProjectId(value) {
        this._fileTemplateProjectId = value;
    }
    resetFileTemplateProjectId() {
        this._fileTemplateProjectId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get fileTemplateProjectIdInput() {
        return this._fileTemplateProjectId;
    }
    get firstDayOfWeek() {
        return this.getNumberAttribute('first_day_of_week');
    }
    set firstDayOfWeek(value) {
        this._firstDayOfWeek = value;
    }
    resetFirstDayOfWeek() {
        this._firstDayOfWeek = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get firstDayOfWeekInput() {
        return this._firstDayOfWeek;
    }
    get geoNodeAllowedIps() {
        return this.getStringAttribute('geo_node_allowed_ips');
    }
    set geoNodeAllowedIps(value) {
        this._geoNodeAllowedIps = value;
    }
    resetGeoNodeAllowedIps() {
        this._geoNodeAllowedIps = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get geoNodeAllowedIpsInput() {
        return this._geoNodeAllowedIps;
    }
    get geoStatusTimeout() {
        return this.getNumberAttribute('geo_status_timeout');
    }
    set geoStatusTimeout(value) {
        this._geoStatusTimeout = value;
    }
    resetGeoStatusTimeout() {
        this._geoStatusTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get geoStatusTimeoutInput() {
        return this._geoStatusTimeout;
    }
    get gitRateLimitUsersAllowlist() {
        return this.getListAttribute('git_rate_limit_users_allowlist');
    }
    set gitRateLimitUsersAllowlist(value) {
        this._gitRateLimitUsersAllowlist = value;
    }
    resetGitRateLimitUsersAllowlist() {
        this._gitRateLimitUsersAllowlist = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get gitRateLimitUsersAllowlistInput() {
        return this._gitRateLimitUsersAllowlist;
    }
    get gitTwoFactorSessionExpiry() {
        return this.getNumberAttribute('git_two_factor_session_expiry');
    }
    set gitTwoFactorSessionExpiry(value) {
        this._gitTwoFactorSessionExpiry = value;
    }
    resetGitTwoFactorSessionExpiry() {
        this._gitTwoFactorSessionExpiry = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get gitTwoFactorSessionExpiryInput() {
        return this._gitTwoFactorSessionExpiry;
    }
    get gitalyTimeoutDefault() {
        return this.getNumberAttribute('gitaly_timeout_default');
    }
    set gitalyTimeoutDefault(value) {
        this._gitalyTimeoutDefault = value;
    }
    resetGitalyTimeoutDefault() {
        this._gitalyTimeoutDefault = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get gitalyTimeoutDefaultInput() {
        return this._gitalyTimeoutDefault;
    }
    get gitalyTimeoutFast() {
        return this.getNumberAttribute('gitaly_timeout_fast');
    }
    set gitalyTimeoutFast(value) {
        this._gitalyTimeoutFast = value;
    }
    resetGitalyTimeoutFast() {
        this._gitalyTimeoutFast = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get gitalyTimeoutFastInput() {
        return this._gitalyTimeoutFast;
    }
    get gitalyTimeoutMedium() {
        return this.getNumberAttribute('gitaly_timeout_medium');
    }
    set gitalyTimeoutMedium(value) {
        this._gitalyTimeoutMedium = value;
    }
    resetGitalyTimeoutMedium() {
        this._gitalyTimeoutMedium = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get gitalyTimeoutMediumInput() {
        return this._gitalyTimeoutMedium;
    }
    get grafanaEnabled() {
        return this.getBooleanAttribute('grafana_enabled');
    }
    set grafanaEnabled(value) {
        this._grafanaEnabled = value;
    }
    resetGrafanaEnabled() {
        this._grafanaEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get grafanaEnabledInput() {
        return this._grafanaEnabled;
    }
    get grafanaUrl() {
        return this.getStringAttribute('grafana_url');
    }
    set grafanaUrl(value) {
        this._grafanaUrl = value;
    }
    resetGrafanaUrl() {
        this._grafanaUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get grafanaUrlInput() {
        return this._grafanaUrl;
    }
    get gravatarEnabled() {
        return this.getBooleanAttribute('gravatar_enabled');
    }
    set gravatarEnabled(value) {
        this._gravatarEnabled = value;
    }
    resetGravatarEnabled() {
        this._gravatarEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get gravatarEnabledInput() {
        return this._gravatarEnabled;
    }
    get hashedStorageEnabled() {
        return this.getBooleanAttribute('hashed_storage_enabled');
    }
    set hashedStorageEnabled(value) {
        this._hashedStorageEnabled = value;
    }
    resetHashedStorageEnabled() {
        this._hashedStorageEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get hashedStorageEnabledInput() {
        return this._hashedStorageEnabled;
    }
    get helpPageHideCommercialContent() {
        return this.getBooleanAttribute('help_page_hide_commercial_content');
    }
    set helpPageHideCommercialContent(value) {
        this._helpPageHideCommercialContent = value;
    }
    resetHelpPageHideCommercialContent() {
        this._helpPageHideCommercialContent = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get helpPageHideCommercialContentInput() {
        return this._helpPageHideCommercialContent;
    }
    get helpPageSupportUrl() {
        return this.getStringAttribute('help_page_support_url');
    }
    set helpPageSupportUrl(value) {
        this._helpPageSupportUrl = value;
    }
    resetHelpPageSupportUrl() {
        this._helpPageSupportUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get helpPageSupportUrlInput() {
        return this._helpPageSupportUrl;
    }
    get helpPageText() {
        return this.getStringAttribute('help_page_text');
    }
    set helpPageText(value) {
        this._helpPageText = value;
    }
    resetHelpPageText() {
        this._helpPageText = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get helpPageTextInput() {
        return this._helpPageText;
    }
    get helpText() {
        return this.getStringAttribute('help_text');
    }
    set helpText(value) {
        this._helpText = value;
    }
    resetHelpText() {
        this._helpText = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get helpTextInput() {
        return this._helpText;
    }
    get hideThirdPartyOffers() {
        return this.getBooleanAttribute('hide_third_party_offers');
    }
    set hideThirdPartyOffers(value) {
        this._hideThirdPartyOffers = value;
    }
    resetHideThirdPartyOffers() {
        this._hideThirdPartyOffers = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get hideThirdPartyOffersInput() {
        return this._hideThirdPartyOffers;
    }
    get homePageUrl() {
        return this.getStringAttribute('home_page_url');
    }
    set homePageUrl(value) {
        this._homePageUrl = value;
    }
    resetHomePageUrl() {
        this._homePageUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get homePageUrlInput() {
        return this._homePageUrl;
    }
    get housekeepingEnabled() {
        return this.getBooleanAttribute('housekeeping_enabled');
    }
    set housekeepingEnabled(value) {
        this._housekeepingEnabled = value;
    }
    resetHousekeepingEnabled() {
        this._housekeepingEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get housekeepingEnabledInput() {
        return this._housekeepingEnabled;
    }
    get housekeepingFullRepackPeriod() {
        return this.getNumberAttribute('housekeeping_full_repack_period');
    }
    set housekeepingFullRepackPeriod(value) {
        this._housekeepingFullRepackPeriod = value;
    }
    resetHousekeepingFullRepackPeriod() {
        this._housekeepingFullRepackPeriod = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get housekeepingFullRepackPeriodInput() {
        return this._housekeepingFullRepackPeriod;
    }
    get housekeepingGcPeriod() {
        return this.getNumberAttribute('housekeeping_gc_period');
    }
    set housekeepingGcPeriod(value) {
        this._housekeepingGcPeriod = value;
    }
    resetHousekeepingGcPeriod() {
        this._housekeepingGcPeriod = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get housekeepingGcPeriodInput() {
        return this._housekeepingGcPeriod;
    }
    get housekeepingIncrementalRepackPeriod() {
        return this.getNumberAttribute('housekeeping_incremental_repack_period');
    }
    set housekeepingIncrementalRepackPeriod(value) {
        this._housekeepingIncrementalRepackPeriod = value;
    }
    resetHousekeepingIncrementalRepackPeriod() {
        this._housekeepingIncrementalRepackPeriod = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get housekeepingIncrementalRepackPeriodInput() {
        return this._housekeepingIncrementalRepackPeriod;
    }
    get htmlEmailsEnabled() {
        return this.getBooleanAttribute('html_emails_enabled');
    }
    set htmlEmailsEnabled(value) {
        this._htmlEmailsEnabled = value;
    }
    resetHtmlEmailsEnabled() {
        this._htmlEmailsEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get htmlEmailsEnabledInput() {
        return this._htmlEmailsEnabled;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get importSources() {
        return this.getListAttribute('import_sources');
    }
    set importSources(value) {
        this._importSources = value;
    }
    resetImportSources() {
        this._importSources = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get importSourcesInput() {
        return this._importSources;
    }
    get inProductMarketingEmailsEnabled() {
        return this.getBooleanAttribute('in_product_marketing_emails_enabled');
    }
    set inProductMarketingEmailsEnabled(value) {
        this._inProductMarketingEmailsEnabled = value;
    }
    resetInProductMarketingEmailsEnabled() {
        this._inProductMarketingEmailsEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get inProductMarketingEmailsEnabledInput() {
        return this._inProductMarketingEmailsEnabled;
    }
    get inactiveProjectsDeleteAfterMonths() {
        return this.getNumberAttribute('inactive_projects_delete_after_months');
    }
    set inactiveProjectsDeleteAfterMonths(value) {
        this._inactiveProjectsDeleteAfterMonths = value;
    }
    resetInactiveProjectsDeleteAfterMonths() {
        this._inactiveProjectsDeleteAfterMonths = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get inactiveProjectsDeleteAfterMonthsInput() {
        return this._inactiveProjectsDeleteAfterMonths;
    }
    get inactiveProjectsMinSizeMb() {
        return this.getNumberAttribute('inactive_projects_min_size_mb');
    }
    set inactiveProjectsMinSizeMb(value) {
        this._inactiveProjectsMinSizeMb = value;
    }
    resetInactiveProjectsMinSizeMb() {
        this._inactiveProjectsMinSizeMb = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get inactiveProjectsMinSizeMbInput() {
        return this._inactiveProjectsMinSizeMb;
    }
    get inactiveProjectsSendWarningEmailAfterMonths() {
        return this.getNumberAttribute('inactive_projects_send_warning_email_after_months');
    }
    set inactiveProjectsSendWarningEmailAfterMonths(value) {
        this._inactiveProjectsSendWarningEmailAfterMonths = value;
    }
    resetInactiveProjectsSendWarningEmailAfterMonths() {
        this._inactiveProjectsSendWarningEmailAfterMonths = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get inactiveProjectsSendWarningEmailAfterMonthsInput() {
        return this._inactiveProjectsSendWarningEmailAfterMonths;
    }
    get invisibleCaptchaEnabled() {
        return this.getBooleanAttribute('invisible_captcha_enabled');
    }
    set invisibleCaptchaEnabled(value) {
        this._invisibleCaptchaEnabled = value;
    }
    resetInvisibleCaptchaEnabled() {
        this._invisibleCaptchaEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get invisibleCaptchaEnabledInput() {
        return this._invisibleCaptchaEnabled;
    }
    get issuesCreateLimit() {
        return this.getNumberAttribute('issues_create_limit');
    }
    set issuesCreateLimit(value) {
        this._issuesCreateLimit = value;
    }
    resetIssuesCreateLimit() {
        this._issuesCreateLimit = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get issuesCreateLimitInput() {
        return this._issuesCreateLimit;
    }
    get keepLatestArtifact() {
        return this.getBooleanAttribute('keep_latest_artifact');
    }
    set keepLatestArtifact(value) {
        this._keepLatestArtifact = value;
    }
    resetKeepLatestArtifact() {
        this._keepLatestArtifact = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get keepLatestArtifactInput() {
        return this._keepLatestArtifact;
    }
    get localMarkdownVersion() {
        return this.getNumberAttribute('local_markdown_version');
    }
    set localMarkdownVersion(value) {
        this._localMarkdownVersion = value;
    }
    resetLocalMarkdownVersion() {
        this._localMarkdownVersion = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get localMarkdownVersionInput() {
        return this._localMarkdownVersion;
    }
    get mailgunEventsEnabled() {
        return this.getBooleanAttribute('mailgun_events_enabled');
    }
    set mailgunEventsEnabled(value) {
        this._mailgunEventsEnabled = value;
    }
    resetMailgunEventsEnabled() {
        this._mailgunEventsEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mailgunEventsEnabledInput() {
        return this._mailgunEventsEnabled;
    }
    get mailgunSigningKey() {
        return this.getStringAttribute('mailgun_signing_key');
    }
    set mailgunSigningKey(value) {
        this._mailgunSigningKey = value;
    }
    resetMailgunSigningKey() {
        this._mailgunSigningKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mailgunSigningKeyInput() {
        return this._mailgunSigningKey;
    }
    get maintenanceMode() {
        return this.getBooleanAttribute('maintenance_mode');
    }
    set maintenanceMode(value) {
        this._maintenanceMode = value;
    }
    resetMaintenanceMode() {
        this._maintenanceMode = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maintenanceModeInput() {
        return this._maintenanceMode;
    }
    get maintenanceModeMessage() {
        return this.getStringAttribute('maintenance_mode_message');
    }
    set maintenanceModeMessage(value) {
        this._maintenanceModeMessage = value;
    }
    resetMaintenanceModeMessage() {
        this._maintenanceModeMessage = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maintenanceModeMessageInput() {
        return this._maintenanceModeMessage;
    }
    get maxArtifactsSize() {
        return this.getNumberAttribute('max_artifacts_size');
    }
    set maxArtifactsSize(value) {
        this._maxArtifactsSize = value;
    }
    resetMaxArtifactsSize() {
        this._maxArtifactsSize = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxArtifactsSizeInput() {
        return this._maxArtifactsSize;
    }
    get maxAttachmentSize() {
        return this.getNumberAttribute('max_attachment_size');
    }
    set maxAttachmentSize(value) {
        this._maxAttachmentSize = value;
    }
    resetMaxAttachmentSize() {
        this._maxAttachmentSize = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxAttachmentSizeInput() {
        return this._maxAttachmentSize;
    }
    get maxExportSize() {
        return this.getNumberAttribute('max_export_size');
    }
    set maxExportSize(value) {
        this._maxExportSize = value;
    }
    resetMaxExportSize() {
        this._maxExportSize = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxExportSizeInput() {
        return this._maxExportSize;
    }
    get maxImportSize() {
        return this.getNumberAttribute('max_import_size');
    }
    set maxImportSize(value) {
        this._maxImportSize = value;
    }
    resetMaxImportSize() {
        this._maxImportSize = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxImportSizeInput() {
        return this._maxImportSize;
    }
    get maxNumberOfRepositoryDownloads() {
        return this.getNumberAttribute('max_number_of_repository_downloads');
    }
    set maxNumberOfRepositoryDownloads(value) {
        this._maxNumberOfRepositoryDownloads = value;
    }
    resetMaxNumberOfRepositoryDownloads() {
        this._maxNumberOfRepositoryDownloads = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxNumberOfRepositoryDownloadsInput() {
        return this._maxNumberOfRepositoryDownloads;
    }
    get maxNumberOfRepositoryDownloadsWithinTimePeriod() {
        return this.getNumberAttribute('max_number_of_repository_downloads_within_time_period');
    }
    set maxNumberOfRepositoryDownloadsWithinTimePeriod(value) {
        this._maxNumberOfRepositoryDownloadsWithinTimePeriod = value;
    }
    resetMaxNumberOfRepositoryDownloadsWithinTimePeriod() {
        this._maxNumberOfRepositoryDownloadsWithinTimePeriod = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxNumberOfRepositoryDownloadsWithinTimePeriodInput() {
        return this._maxNumberOfRepositoryDownloadsWithinTimePeriod;
    }
    get maxPagesSize() {
        return this.getNumberAttribute('max_pages_size');
    }
    set maxPagesSize(value) {
        this._maxPagesSize = value;
    }
    resetMaxPagesSize() {
        this._maxPagesSize = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxPagesSizeInput() {
        return this._maxPagesSize;
    }
    get maxPersonalAccessTokenLifetime() {
        return this.getNumberAttribute('max_personal_access_token_lifetime');
    }
    set maxPersonalAccessTokenLifetime(value) {
        this._maxPersonalAccessTokenLifetime = value;
    }
    resetMaxPersonalAccessTokenLifetime() {
        this._maxPersonalAccessTokenLifetime = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxPersonalAccessTokenLifetimeInput() {
        return this._maxPersonalAccessTokenLifetime;
    }
    get maxSshKeyLifetime() {
        return this.getNumberAttribute('max_ssh_key_lifetime');
    }
    set maxSshKeyLifetime(value) {
        this._maxSshKeyLifetime = value;
    }
    resetMaxSshKeyLifetime() {
        this._maxSshKeyLifetime = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxSshKeyLifetimeInput() {
        return this._maxSshKeyLifetime;
    }
    get metricsMethodCallThreshold() {
        return this.getNumberAttribute('metrics_method_call_threshold');
    }
    set metricsMethodCallThreshold(value) {
        this._metricsMethodCallThreshold = value;
    }
    resetMetricsMethodCallThreshold() {
        this._metricsMethodCallThreshold = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get metricsMethodCallThresholdInput() {
        return this._metricsMethodCallThreshold;
    }
    get mirrorAvailable() {
        return this.getBooleanAttribute('mirror_available');
    }
    set mirrorAvailable(value) {
        this._mirrorAvailable = value;
    }
    resetMirrorAvailable() {
        this._mirrorAvailable = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mirrorAvailableInput() {
        return this._mirrorAvailable;
    }
    get mirrorCapacityThreshold() {
        return this.getNumberAttribute('mirror_capacity_threshold');
    }
    set mirrorCapacityThreshold(value) {
        this._mirrorCapacityThreshold = value;
    }
    resetMirrorCapacityThreshold() {
        this._mirrorCapacityThreshold = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mirrorCapacityThresholdInput() {
        return this._mirrorCapacityThreshold;
    }
    get mirrorMaxCapacity() {
        return this.getNumberAttribute('mirror_max_capacity');
    }
    set mirrorMaxCapacity(value) {
        this._mirrorMaxCapacity = value;
    }
    resetMirrorMaxCapacity() {
        this._mirrorMaxCapacity = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mirrorMaxCapacityInput() {
        return this._mirrorMaxCapacity;
    }
    get mirrorMaxDelay() {
        return this.getNumberAttribute('mirror_max_delay');
    }
    set mirrorMaxDelay(value) {
        this._mirrorMaxDelay = value;
    }
    resetMirrorMaxDelay() {
        this._mirrorMaxDelay = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mirrorMaxDelayInput() {
        return this._mirrorMaxDelay;
    }
    get npmPackageRequestsForwarding() {
        return this.getBooleanAttribute('npm_package_requests_forwarding');
    }
    set npmPackageRequestsForwarding(value) {
        this._npmPackageRequestsForwarding = value;
    }
    resetNpmPackageRequestsForwarding() {
        this._npmPackageRequestsForwarding = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get npmPackageRequestsForwardingInput() {
        return this._npmPackageRequestsForwarding;
    }
    get outboundLocalRequestsWhitelist() {
        return this.getListAttribute('outbound_local_requests_whitelist');
    }
    set outboundLocalRequestsWhitelist(value) {
        this._outboundLocalRequestsWhitelist = value;
    }
    resetOutboundLocalRequestsWhitelist() {
        this._outboundLocalRequestsWhitelist = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get outboundLocalRequestsWhitelistInput() {
        return this._outboundLocalRequestsWhitelist;
    }
    get packageRegistryCleanupPoliciesWorkerCapacity() {
        return this.getNumberAttribute('package_registry_cleanup_policies_worker_capacity');
    }
    set packageRegistryCleanupPoliciesWorkerCapacity(value) {
        this._packageRegistryCleanupPoliciesWorkerCapacity = value;
    }
    resetPackageRegistryCleanupPoliciesWorkerCapacity() {
        this._packageRegistryCleanupPoliciesWorkerCapacity = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get packageRegistryCleanupPoliciesWorkerCapacityInput() {
        return this._packageRegistryCleanupPoliciesWorkerCapacity;
    }
    get pagesDomainVerificationEnabled() {
        return this.getBooleanAttribute('pages_domain_verification_enabled');
    }
    set pagesDomainVerificationEnabled(value) {
        this._pagesDomainVerificationEnabled = value;
    }
    resetPagesDomainVerificationEnabled() {
        this._pagesDomainVerificationEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pagesDomainVerificationEnabledInput() {
        return this._pagesDomainVerificationEnabled;
    }
    get passwordAuthenticationEnabledForGit() {
        return this.getBooleanAttribute('password_authentication_enabled_for_git');
    }
    set passwordAuthenticationEnabledForGit(value) {
        this._passwordAuthenticationEnabledForGit = value;
    }
    resetPasswordAuthenticationEnabledForGit() {
        this._passwordAuthenticationEnabledForGit = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passwordAuthenticationEnabledForGitInput() {
        return this._passwordAuthenticationEnabledForGit;
    }
    get passwordAuthenticationEnabledForWeb() {
        return this.getBooleanAttribute('password_authentication_enabled_for_web');
    }
    set passwordAuthenticationEnabledForWeb(value) {
        this._passwordAuthenticationEnabledForWeb = value;
    }
    resetPasswordAuthenticationEnabledForWeb() {
        this._passwordAuthenticationEnabledForWeb = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passwordAuthenticationEnabledForWebInput() {
        return this._passwordAuthenticationEnabledForWeb;
    }
    get passwordLowercaseRequired() {
        return this.getBooleanAttribute('password_lowercase_required');
    }
    set passwordLowercaseRequired(value) {
        this._passwordLowercaseRequired = value;
    }
    resetPasswordLowercaseRequired() {
        this._passwordLowercaseRequired = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passwordLowercaseRequiredInput() {
        return this._passwordLowercaseRequired;
    }
    get passwordNumberRequired() {
        return this.getBooleanAttribute('password_number_required');
    }
    set passwordNumberRequired(value) {
        this._passwordNumberRequired = value;
    }
    resetPasswordNumberRequired() {
        this._passwordNumberRequired = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passwordNumberRequiredInput() {
        return this._passwordNumberRequired;
    }
    get passwordSymbolRequired() {
        return this.getBooleanAttribute('password_symbol_required');
    }
    set passwordSymbolRequired(value) {
        this._passwordSymbolRequired = value;
    }
    resetPasswordSymbolRequired() {
        this._passwordSymbolRequired = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passwordSymbolRequiredInput() {
        return this._passwordSymbolRequired;
    }
    get passwordUppercaseRequired() {
        return this.getBooleanAttribute('password_uppercase_required');
    }
    set passwordUppercaseRequired(value) {
        this._passwordUppercaseRequired = value;
    }
    resetPasswordUppercaseRequired() {
        this._passwordUppercaseRequired = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passwordUppercaseRequiredInput() {
        return this._passwordUppercaseRequired;
    }
    get performanceBarAllowedGroupPath() {
        return this.getStringAttribute('performance_bar_allowed_group_path');
    }
    set performanceBarAllowedGroupPath(value) {
        this._performanceBarAllowedGroupPath = value;
    }
    resetPerformanceBarAllowedGroupPath() {
        this._performanceBarAllowedGroupPath = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get performanceBarAllowedGroupPathInput() {
        return this._performanceBarAllowedGroupPath;
    }
    get personalAccessTokenPrefix() {
        return this.getStringAttribute('personal_access_token_prefix');
    }
    set personalAccessTokenPrefix(value) {
        this._personalAccessTokenPrefix = value;
    }
    resetPersonalAccessTokenPrefix() {
        this._personalAccessTokenPrefix = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get personalAccessTokenPrefixInput() {
        return this._personalAccessTokenPrefix;
    }
    get pipelineLimitPerProjectUserSha() {
        return this.getNumberAttribute('pipeline_limit_per_project_user_sha');
    }
    set pipelineLimitPerProjectUserSha(value) {
        this._pipelineLimitPerProjectUserSha = value;
    }
    resetPipelineLimitPerProjectUserSha() {
        this._pipelineLimitPerProjectUserSha = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pipelineLimitPerProjectUserShaInput() {
        return this._pipelineLimitPerProjectUserSha;
    }
    get plantumlEnabled() {
        return this.getBooleanAttribute('plantuml_enabled');
    }
    set plantumlEnabled(value) {
        this._plantumlEnabled = value;
    }
    resetPlantumlEnabled() {
        this._plantumlEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get plantumlEnabledInput() {
        return this._plantumlEnabled;
    }
    get plantumlUrl() {
        return this.getStringAttribute('plantuml_url');
    }
    set plantumlUrl(value) {
        this._plantumlUrl = value;
    }
    resetPlantumlUrl() {
        this._plantumlUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get plantumlUrlInput() {
        return this._plantumlUrl;
    }
    get pollingIntervalMultiplier() {
        return this.getNumberAttribute('polling_interval_multiplier');
    }
    set pollingIntervalMultiplier(value) {
        this._pollingIntervalMultiplier = value;
    }
    resetPollingIntervalMultiplier() {
        this._pollingIntervalMultiplier = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pollingIntervalMultiplierInput() {
        return this._pollingIntervalMultiplier;
    }
    get projectExportEnabled() {
        return this.getBooleanAttribute('project_export_enabled');
    }
    set projectExportEnabled(value) {
        this._projectExportEnabled = value;
    }
    resetProjectExportEnabled() {
        this._projectExportEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get projectExportEnabledInput() {
        return this._projectExportEnabled;
    }
    get prometheusMetricsEnabled() {
        return this.getBooleanAttribute('prometheus_metrics_enabled');
    }
    set prometheusMetricsEnabled(value) {
        this._prometheusMetricsEnabled = value;
    }
    resetPrometheusMetricsEnabled() {
        this._prometheusMetricsEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get prometheusMetricsEnabledInput() {
        return this._prometheusMetricsEnabled;
    }
    get protectedCiVariables() {
        return this.getBooleanAttribute('protected_ci_variables');
    }
    set protectedCiVariables(value) {
        this._protectedCiVariables = value;
    }
    resetProtectedCiVariables() {
        this._protectedCiVariables = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get protectedCiVariablesInput() {
        return this._protectedCiVariables;
    }
    get pushEventActivitiesLimit() {
        return this.getNumberAttribute('push_event_activities_limit');
    }
    set pushEventActivitiesLimit(value) {
        this._pushEventActivitiesLimit = value;
    }
    resetPushEventActivitiesLimit() {
        this._pushEventActivitiesLimit = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pushEventActivitiesLimitInput() {
        return this._pushEventActivitiesLimit;
    }
    get pushEventHooksLimit() {
        return this.getNumberAttribute('push_event_hooks_limit');
    }
    set pushEventHooksLimit(value) {
        this._pushEventHooksLimit = value;
    }
    resetPushEventHooksLimit() {
        this._pushEventHooksLimit = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pushEventHooksLimitInput() {
        return this._pushEventHooksLimit;
    }
    get pypiPackageRequestsForwarding() {
        return this.getBooleanAttribute('pypi_package_requests_forwarding');
    }
    set pypiPackageRequestsForwarding(value) {
        this._pypiPackageRequestsForwarding = value;
    }
    resetPypiPackageRequestsForwarding() {
        this._pypiPackageRequestsForwarding = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pypiPackageRequestsForwardingInput() {
        return this._pypiPackageRequestsForwarding;
    }
    get rateLimitingResponseText() {
        return this.getStringAttribute('rate_limiting_response_text');
    }
    set rateLimitingResponseText(value) {
        this._rateLimitingResponseText = value;
    }
    resetRateLimitingResponseText() {
        this._rateLimitingResponseText = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get rateLimitingResponseTextInput() {
        return this._rateLimitingResponseText;
    }
    get rawBlobRequestLimit() {
        return this.getNumberAttribute('raw_blob_request_limit');
    }
    set rawBlobRequestLimit(value) {
        this._rawBlobRequestLimit = value;
    }
    resetRawBlobRequestLimit() {
        this._rawBlobRequestLimit = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get rawBlobRequestLimitInput() {
        return this._rawBlobRequestLimit;
    }
    get recaptchaEnabled() {
        return this.getBooleanAttribute('recaptcha_enabled');
    }
    set recaptchaEnabled(value) {
        this._recaptchaEnabled = value;
    }
    resetRecaptchaEnabled() {
        this._recaptchaEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get recaptchaEnabledInput() {
        return this._recaptchaEnabled;
    }
    get recaptchaPrivateKey() {
        return this.getStringAttribute('recaptcha_private_key');
    }
    set recaptchaPrivateKey(value) {
        this._recaptchaPrivateKey = value;
    }
    resetRecaptchaPrivateKey() {
        this._recaptchaPrivateKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get recaptchaPrivateKeyInput() {
        return this._recaptchaPrivateKey;
    }
    get recaptchaSiteKey() {
        return this.getStringAttribute('recaptcha_site_key');
    }
    set recaptchaSiteKey(value) {
        this._recaptchaSiteKey = value;
    }
    resetRecaptchaSiteKey() {
        this._recaptchaSiteKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get recaptchaSiteKeyInput() {
        return this._recaptchaSiteKey;
    }
    get receiveMaxInputSize() {
        return this.getNumberAttribute('receive_max_input_size');
    }
    set receiveMaxInputSize(value) {
        this._receiveMaxInputSize = value;
    }
    resetReceiveMaxInputSize() {
        this._receiveMaxInputSize = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get receiveMaxInputSizeInput() {
        return this._receiveMaxInputSize;
    }
    get repositoryChecksEnabled() {
        return this.getBooleanAttribute('repository_checks_enabled');
    }
    set repositoryChecksEnabled(value) {
        this._repositoryChecksEnabled = value;
    }
    resetRepositoryChecksEnabled() {
        this._repositoryChecksEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get repositoryChecksEnabledInput() {
        return this._repositoryChecksEnabled;
    }
    get repositorySizeLimit() {
        return this.getNumberAttribute('repository_size_limit');
    }
    set repositorySizeLimit(value) {
        this._repositorySizeLimit = value;
    }
    resetRepositorySizeLimit() {
        this._repositorySizeLimit = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get repositorySizeLimitInput() {
        return this._repositorySizeLimit;
    }
    get repositoryStorages() {
        return this.getListAttribute('repository_storages');
    }
    set repositoryStorages(value) {
        this._repositoryStorages = value;
    }
    resetRepositoryStorages() {
        this._repositoryStorages = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get repositoryStoragesInput() {
        return this._repositoryStorages;
    }
    get repositoryStoragesWeighted() {
        return this.getNumberMapAttribute('repository_storages_weighted');
    }
    set repositoryStoragesWeighted(value) {
        this._repositoryStoragesWeighted = value;
    }
    resetRepositoryStoragesWeighted() {
        this._repositoryStoragesWeighted = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get repositoryStoragesWeightedInput() {
        return this._repositoryStoragesWeighted;
    }
    get requireAdminApprovalAfterUserSignup() {
        return this.getBooleanAttribute('require_admin_approval_after_user_signup');
    }
    set requireAdminApprovalAfterUserSignup(value) {
        this._requireAdminApprovalAfterUserSignup = value;
    }
    resetRequireAdminApprovalAfterUserSignup() {
        this._requireAdminApprovalAfterUserSignup = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get requireAdminApprovalAfterUserSignupInput() {
        return this._requireAdminApprovalAfterUserSignup;
    }
    get requireTwoFactorAuthentication() {
        return this.getBooleanAttribute('require_two_factor_authentication');
    }
    set requireTwoFactorAuthentication(value) {
        this._requireTwoFactorAuthentication = value;
    }
    resetRequireTwoFactorAuthentication() {
        this._requireTwoFactorAuthentication = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get requireTwoFactorAuthenticationInput() {
        return this._requireTwoFactorAuthentication;
    }
    get restrictedVisibilityLevels() {
        return this.getListAttribute('restricted_visibility_levels');
    }
    set restrictedVisibilityLevels(value) {
        this._restrictedVisibilityLevels = value;
    }
    resetRestrictedVisibilityLevels() {
        this._restrictedVisibilityLevels = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get restrictedVisibilityLevelsInput() {
        return this._restrictedVisibilityLevels;
    }
    get rsaKeyRestriction() {
        return this.getNumberAttribute('rsa_key_restriction');
    }
    set rsaKeyRestriction(value) {
        this._rsaKeyRestriction = value;
    }
    resetRsaKeyRestriction() {
        this._rsaKeyRestriction = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get rsaKeyRestrictionInput() {
        return this._rsaKeyRestriction;
    }
    get searchRateLimit() {
        return this.getNumberAttribute('search_rate_limit');
    }
    set searchRateLimit(value) {
        this._searchRateLimit = value;
    }
    resetSearchRateLimit() {
        this._searchRateLimit = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get searchRateLimitInput() {
        return this._searchRateLimit;
    }
    get searchRateLimitUnauthenticated() {
        return this.getNumberAttribute('search_rate_limit_unauthenticated');
    }
    set searchRateLimitUnauthenticated(value) {
        this._searchRateLimitUnauthenticated = value;
    }
    resetSearchRateLimitUnauthenticated() {
        this._searchRateLimitUnauthenticated = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get searchRateLimitUnauthenticatedInput() {
        return this._searchRateLimitUnauthenticated;
    }
    get sendUserConfirmationEmail() {
        return this.getBooleanAttribute('send_user_confirmation_email');
    }
    set sendUserConfirmationEmail(value) {
        this._sendUserConfirmationEmail = value;
    }
    resetSendUserConfirmationEmail() {
        this._sendUserConfirmationEmail = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sendUserConfirmationEmailInput() {
        return this._sendUserConfirmationEmail;
    }
    get sessionExpireDelay() {
        return this.getNumberAttribute('session_expire_delay');
    }
    set sessionExpireDelay(value) {
        this._sessionExpireDelay = value;
    }
    resetSessionExpireDelay() {
        this._sessionExpireDelay = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sessionExpireDelayInput() {
        return this._sessionExpireDelay;
    }
    get sharedRunnersEnabled() {
        return this.getBooleanAttribute('shared_runners_enabled');
    }
    set sharedRunnersEnabled(value) {
        this._sharedRunnersEnabled = value;
    }
    resetSharedRunnersEnabled() {
        this._sharedRunnersEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sharedRunnersEnabledInput() {
        return this._sharedRunnersEnabled;
    }
    get sharedRunnersMinutes() {
        return this.getNumberAttribute('shared_runners_minutes');
    }
    set sharedRunnersMinutes(value) {
        this._sharedRunnersMinutes = value;
    }
    resetSharedRunnersMinutes() {
        this._sharedRunnersMinutes = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sharedRunnersMinutesInput() {
        return this._sharedRunnersMinutes;
    }
    get sharedRunnersText() {
        return this.getStringAttribute('shared_runners_text');
    }
    set sharedRunnersText(value) {
        this._sharedRunnersText = value;
    }
    resetSharedRunnersText() {
        this._sharedRunnersText = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sharedRunnersTextInput() {
        return this._sharedRunnersText;
    }
    get sidekiqJobLimiterCompressionThresholdBytes() {
        return this.getNumberAttribute('sidekiq_job_limiter_compression_threshold_bytes');
    }
    set sidekiqJobLimiterCompressionThresholdBytes(value) {
        this._sidekiqJobLimiterCompressionThresholdBytes = value;
    }
    resetSidekiqJobLimiterCompressionThresholdBytes() {
        this._sidekiqJobLimiterCompressionThresholdBytes = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sidekiqJobLimiterCompressionThresholdBytesInput() {
        return this._sidekiqJobLimiterCompressionThresholdBytes;
    }
    get sidekiqJobLimiterLimitBytes() {
        return this.getNumberAttribute('sidekiq_job_limiter_limit_bytes');
    }
    set sidekiqJobLimiterLimitBytes(value) {
        this._sidekiqJobLimiterLimitBytes = value;
    }
    resetSidekiqJobLimiterLimitBytes() {
        this._sidekiqJobLimiterLimitBytes = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sidekiqJobLimiterLimitBytesInput() {
        return this._sidekiqJobLimiterLimitBytes;
    }
    get sidekiqJobLimiterMode() {
        return this.getStringAttribute('sidekiq_job_limiter_mode');
    }
    set sidekiqJobLimiterMode(value) {
        this._sidekiqJobLimiterMode = value;
    }
    resetSidekiqJobLimiterMode() {
        this._sidekiqJobLimiterMode = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sidekiqJobLimiterModeInput() {
        return this._sidekiqJobLimiterMode;
    }
    get signInText() {
        return this.getStringAttribute('sign_in_text');
    }
    set signInText(value) {
        this._signInText = value;
    }
    resetSignInText() {
        this._signInText = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get signInTextInput() {
        return this._signInText;
    }
    get signupEnabled() {
        return this.getBooleanAttribute('signup_enabled');
    }
    set signupEnabled(value) {
        this._signupEnabled = value;
    }
    resetSignupEnabled() {
        this._signupEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get signupEnabledInput() {
        return this._signupEnabled;
    }
    get slackAppEnabled() {
        return this.getBooleanAttribute('slack_app_enabled');
    }
    set slackAppEnabled(value) {
        this._slackAppEnabled = value;
    }
    resetSlackAppEnabled() {
        this._slackAppEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get slackAppEnabledInput() {
        return this._slackAppEnabled;
    }
    get slackAppId() {
        return this.getStringAttribute('slack_app_id');
    }
    set slackAppId(value) {
        this._slackAppId = value;
    }
    resetSlackAppId() {
        this._slackAppId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get slackAppIdInput() {
        return this._slackAppId;
    }
    get slackAppSecret() {
        return this.getStringAttribute('slack_app_secret');
    }
    set slackAppSecret(value) {
        this._slackAppSecret = value;
    }
    resetSlackAppSecret() {
        this._slackAppSecret = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get slackAppSecretInput() {
        return this._slackAppSecret;
    }
    get slackAppSigningSecret() {
        return this.getStringAttribute('slack_app_signing_secret');
    }
    set slackAppSigningSecret(value) {
        this._slackAppSigningSecret = value;
    }
    resetSlackAppSigningSecret() {
        this._slackAppSigningSecret = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get slackAppSigningSecretInput() {
        return this._slackAppSigningSecret;
    }
    get slackAppVerificationToken() {
        return this.getStringAttribute('slack_app_verification_token');
    }
    set slackAppVerificationToken(value) {
        this._slackAppVerificationToken = value;
    }
    resetSlackAppVerificationToken() {
        this._slackAppVerificationToken = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get slackAppVerificationTokenInput() {
        return this._slackAppVerificationToken;
    }
    get snippetSizeLimit() {
        return this.getNumberAttribute('snippet_size_limit');
    }
    set snippetSizeLimit(value) {
        this._snippetSizeLimit = value;
    }
    resetSnippetSizeLimit() {
        this._snippetSizeLimit = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get snippetSizeLimitInput() {
        return this._snippetSizeLimit;
    }
    get snowplowAppId() {
        return this.getStringAttribute('snowplow_app_id');
    }
    set snowplowAppId(value) {
        this._snowplowAppId = value;
    }
    resetSnowplowAppId() {
        this._snowplowAppId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get snowplowAppIdInput() {
        return this._snowplowAppId;
    }
    get snowplowCollectorHostname() {
        return this.getStringAttribute('snowplow_collector_hostname');
    }
    set snowplowCollectorHostname(value) {
        this._snowplowCollectorHostname = value;
    }
    resetSnowplowCollectorHostname() {
        this._snowplowCollectorHostname = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get snowplowCollectorHostnameInput() {
        return this._snowplowCollectorHostname;
    }
    get snowplowCookieDomain() {
        return this.getStringAttribute('snowplow_cookie_domain');
    }
    set snowplowCookieDomain(value) {
        this._snowplowCookieDomain = value;
    }
    resetSnowplowCookieDomain() {
        this._snowplowCookieDomain = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get snowplowCookieDomainInput() {
        return this._snowplowCookieDomain;
    }
    get snowplowEnabled() {
        return this.getBooleanAttribute('snowplow_enabled');
    }
    set snowplowEnabled(value) {
        this._snowplowEnabled = value;
    }
    resetSnowplowEnabled() {
        this._snowplowEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get snowplowEnabledInput() {
        return this._snowplowEnabled;
    }
    get sourcegraphEnabled() {
        return this.getBooleanAttribute('sourcegraph_enabled');
    }
    set sourcegraphEnabled(value) {
        this._sourcegraphEnabled = value;
    }
    resetSourcegraphEnabled() {
        this._sourcegraphEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sourcegraphEnabledInput() {
        return this._sourcegraphEnabled;
    }
    get sourcegraphPublicOnly() {
        return this.getBooleanAttribute('sourcegraph_public_only');
    }
    set sourcegraphPublicOnly(value) {
        this._sourcegraphPublicOnly = value;
    }
    resetSourcegraphPublicOnly() {
        this._sourcegraphPublicOnly = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sourcegraphPublicOnlyInput() {
        return this._sourcegraphPublicOnly;
    }
    get sourcegraphUrl() {
        return this.getStringAttribute('sourcegraph_url');
    }
    set sourcegraphUrl(value) {
        this._sourcegraphUrl = value;
    }
    resetSourcegraphUrl() {
        this._sourcegraphUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sourcegraphUrlInput() {
        return this._sourcegraphUrl;
    }
    get spamCheckApiKey() {
        return this.getStringAttribute('spam_check_api_key');
    }
    set spamCheckApiKey(value) {
        this._spamCheckApiKey = value;
    }
    resetSpamCheckApiKey() {
        this._spamCheckApiKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get spamCheckApiKeyInput() {
        return this._spamCheckApiKey;
    }
    get spamCheckEndpointEnabled() {
        return this.getBooleanAttribute('spam_check_endpoint_enabled');
    }
    set spamCheckEndpointEnabled(value) {
        this._spamCheckEndpointEnabled = value;
    }
    resetSpamCheckEndpointEnabled() {
        this._spamCheckEndpointEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get spamCheckEndpointEnabledInput() {
        return this._spamCheckEndpointEnabled;
    }
    get spamCheckEndpointUrl() {
        return this.getStringAttribute('spam_check_endpoint_url');
    }
    set spamCheckEndpointUrl(value) {
        this._spamCheckEndpointUrl = value;
    }
    resetSpamCheckEndpointUrl() {
        this._spamCheckEndpointUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get spamCheckEndpointUrlInput() {
        return this._spamCheckEndpointUrl;
    }
    get suggestPipelineEnabled() {
        return this.getBooleanAttribute('suggest_pipeline_enabled');
    }
    set suggestPipelineEnabled(value) {
        this._suggestPipelineEnabled = value;
    }
    resetSuggestPipelineEnabled() {
        this._suggestPipelineEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get suggestPipelineEnabledInput() {
        return this._suggestPipelineEnabled;
    }
    get terminalMaxSessionTime() {
        return this.getNumberAttribute('terminal_max_session_time');
    }
    set terminalMaxSessionTime(value) {
        this._terminalMaxSessionTime = value;
    }
    resetTerminalMaxSessionTime() {
        this._terminalMaxSessionTime = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get terminalMaxSessionTimeInput() {
        return this._terminalMaxSessionTime;
    }
    get terms() {
        return this.getStringAttribute('terms');
    }
    set terms(value) {
        this._terms = value;
    }
    resetTerms() {
        this._terms = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get termsInput() {
        return this._terms;
    }
    get throttleAuthenticatedApiEnabled() {
        return this.getBooleanAttribute('throttle_authenticated_api_enabled');
    }
    set throttleAuthenticatedApiEnabled(value) {
        this._throttleAuthenticatedApiEnabled = value;
    }
    resetThrottleAuthenticatedApiEnabled() {
        this._throttleAuthenticatedApiEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get throttleAuthenticatedApiEnabledInput() {
        return this._throttleAuthenticatedApiEnabled;
    }
    get throttleAuthenticatedApiPeriodInSeconds() {
        return this.getNumberAttribute('throttle_authenticated_api_period_in_seconds');
    }
    set throttleAuthenticatedApiPeriodInSeconds(value) {
        this._throttleAuthenticatedApiPeriodInSeconds = value;
    }
    resetThrottleAuthenticatedApiPeriodInSeconds() {
        this._throttleAuthenticatedApiPeriodInSeconds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get throttleAuthenticatedApiPeriodInSecondsInput() {
        return this._throttleAuthenticatedApiPeriodInSeconds;
    }
    get throttleAuthenticatedApiRequestsPerPeriod() {
        return this.getNumberAttribute('throttle_authenticated_api_requests_per_period');
    }
    set throttleAuthenticatedApiRequestsPerPeriod(value) {
        this._throttleAuthenticatedApiRequestsPerPeriod = value;
    }
    resetThrottleAuthenticatedApiRequestsPerPeriod() {
        this._throttleAuthenticatedApiRequestsPerPeriod = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get throttleAuthenticatedApiRequestsPerPeriodInput() {
        return this._throttleAuthenticatedApiRequestsPerPeriod;
    }
    get throttleAuthenticatedPackagesApiEnabled() {
        return this.getBooleanAttribute('throttle_authenticated_packages_api_enabled');
    }
    set throttleAuthenticatedPackagesApiEnabled(value) {
        this._throttleAuthenticatedPackagesApiEnabled = value;
    }
    resetThrottleAuthenticatedPackagesApiEnabled() {
        this._throttleAuthenticatedPackagesApiEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get throttleAuthenticatedPackagesApiEnabledInput() {
        return this._throttleAuthenticatedPackagesApiEnabled;
    }
    get throttleAuthenticatedPackagesApiPeriodInSeconds() {
        return this.getNumberAttribute('throttle_authenticated_packages_api_period_in_seconds');
    }
    set throttleAuthenticatedPackagesApiPeriodInSeconds(value) {
        this._throttleAuthenticatedPackagesApiPeriodInSeconds = value;
    }
    resetThrottleAuthenticatedPackagesApiPeriodInSeconds() {
        this._throttleAuthenticatedPackagesApiPeriodInSeconds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get throttleAuthenticatedPackagesApiPeriodInSecondsInput() {
        return this._throttleAuthenticatedPackagesApiPeriodInSeconds;
    }
    get throttleAuthenticatedPackagesApiRequestsPerPeriod() {
        return this.getNumberAttribute('throttle_authenticated_packages_api_requests_per_period');
    }
    set throttleAuthenticatedPackagesApiRequestsPerPeriod(value) {
        this._throttleAuthenticatedPackagesApiRequestsPerPeriod = value;
    }
    resetThrottleAuthenticatedPackagesApiRequestsPerPeriod() {
        this._throttleAuthenticatedPackagesApiRequestsPerPeriod = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get throttleAuthenticatedPackagesApiRequestsPerPeriodInput() {
        return this._throttleAuthenticatedPackagesApiRequestsPerPeriod;
    }
    get throttleAuthenticatedWebEnabled() {
        return this.getBooleanAttribute('throttle_authenticated_web_enabled');
    }
    set throttleAuthenticatedWebEnabled(value) {
        this._throttleAuthenticatedWebEnabled = value;
    }
    resetThrottleAuthenticatedWebEnabled() {
        this._throttleAuthenticatedWebEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get throttleAuthenticatedWebEnabledInput() {
        return this._throttleAuthenticatedWebEnabled;
    }
    get throttleAuthenticatedWebPeriodInSeconds() {
        return this.getNumberAttribute('throttle_authenticated_web_period_in_seconds');
    }
    set throttleAuthenticatedWebPeriodInSeconds(value) {
        this._throttleAuthenticatedWebPeriodInSeconds = value;
    }
    resetThrottleAuthenticatedWebPeriodInSeconds() {
        this._throttleAuthenticatedWebPeriodInSeconds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get throttleAuthenticatedWebPeriodInSecondsInput() {
        return this._throttleAuthenticatedWebPeriodInSeconds;
    }
    get throttleAuthenticatedWebRequestsPerPeriod() {
        return this.getNumberAttribute('throttle_authenticated_web_requests_per_period');
    }
    set throttleAuthenticatedWebRequestsPerPeriod(value) {
        this._throttleAuthenticatedWebRequestsPerPeriod = value;
    }
    resetThrottleAuthenticatedWebRequestsPerPeriod() {
        this._throttleAuthenticatedWebRequestsPerPeriod = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get throttleAuthenticatedWebRequestsPerPeriodInput() {
        return this._throttleAuthenticatedWebRequestsPerPeriod;
    }
    get throttleUnauthenticatedApiEnabled() {
        return this.getBooleanAttribute('throttle_unauthenticated_api_enabled');
    }
    set throttleUnauthenticatedApiEnabled(value) {
        this._throttleUnauthenticatedApiEnabled = value;
    }
    resetThrottleUnauthenticatedApiEnabled() {
        this._throttleUnauthenticatedApiEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get throttleUnauthenticatedApiEnabledInput() {
        return this._throttleUnauthenticatedApiEnabled;
    }
    get throttleUnauthenticatedApiPeriodInSeconds() {
        return this.getNumberAttribute('throttle_unauthenticated_api_period_in_seconds');
    }
    set throttleUnauthenticatedApiPeriodInSeconds(value) {
        this._throttleUnauthenticatedApiPeriodInSeconds = value;
    }
    resetThrottleUnauthenticatedApiPeriodInSeconds() {
        this._throttleUnauthenticatedApiPeriodInSeconds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get throttleUnauthenticatedApiPeriodInSecondsInput() {
        return this._throttleUnauthenticatedApiPeriodInSeconds;
    }
    get throttleUnauthenticatedApiRequestsPerPeriod() {
        return this.getNumberAttribute('throttle_unauthenticated_api_requests_per_period');
    }
    set throttleUnauthenticatedApiRequestsPerPeriod(value) {
        this._throttleUnauthenticatedApiRequestsPerPeriod = value;
    }
    resetThrottleUnauthenticatedApiRequestsPerPeriod() {
        this._throttleUnauthenticatedApiRequestsPerPeriod = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get throttleUnauthenticatedApiRequestsPerPeriodInput() {
        return this._throttleUnauthenticatedApiRequestsPerPeriod;
    }
    get throttleUnauthenticatedPackagesApiEnabled() {
        return this.getBooleanAttribute('throttle_unauthenticated_packages_api_enabled');
    }
    set throttleUnauthenticatedPackagesApiEnabled(value) {
        this._throttleUnauthenticatedPackagesApiEnabled = value;
    }
    resetThrottleUnauthenticatedPackagesApiEnabled() {
        this._throttleUnauthenticatedPackagesApiEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get throttleUnauthenticatedPackagesApiEnabledInput() {
        return this._throttleUnauthenticatedPackagesApiEnabled;
    }
    get throttleUnauthenticatedPackagesApiPeriodInSeconds() {
        return this.getNumberAttribute('throttle_unauthenticated_packages_api_period_in_seconds');
    }
    set throttleUnauthenticatedPackagesApiPeriodInSeconds(value) {
        this._throttleUnauthenticatedPackagesApiPeriodInSeconds = value;
    }
    resetThrottleUnauthenticatedPackagesApiPeriodInSeconds() {
        this._throttleUnauthenticatedPackagesApiPeriodInSeconds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get throttleUnauthenticatedPackagesApiPeriodInSecondsInput() {
        return this._throttleUnauthenticatedPackagesApiPeriodInSeconds;
    }
    get throttleUnauthenticatedPackagesApiRequestsPerPeriod() {
        return this.getNumberAttribute('throttle_unauthenticated_packages_api_requests_per_period');
    }
    set throttleUnauthenticatedPackagesApiRequestsPerPeriod(value) {
        this._throttleUnauthenticatedPackagesApiRequestsPerPeriod = value;
    }
    resetThrottleUnauthenticatedPackagesApiRequestsPerPeriod() {
        this._throttleUnauthenticatedPackagesApiRequestsPerPeriod = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get throttleUnauthenticatedPackagesApiRequestsPerPeriodInput() {
        return this._throttleUnauthenticatedPackagesApiRequestsPerPeriod;
    }
    get throttleUnauthenticatedWebEnabled() {
        return this.getBooleanAttribute('throttle_unauthenticated_web_enabled');
    }
    set throttleUnauthenticatedWebEnabled(value) {
        this._throttleUnauthenticatedWebEnabled = value;
    }
    resetThrottleUnauthenticatedWebEnabled() {
        this._throttleUnauthenticatedWebEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get throttleUnauthenticatedWebEnabledInput() {
        return this._throttleUnauthenticatedWebEnabled;
    }
    get throttleUnauthenticatedWebPeriodInSeconds() {
        return this.getNumberAttribute('throttle_unauthenticated_web_period_in_seconds');
    }
    set throttleUnauthenticatedWebPeriodInSeconds(value) {
        this._throttleUnauthenticatedWebPeriodInSeconds = value;
    }
    resetThrottleUnauthenticatedWebPeriodInSeconds() {
        this._throttleUnauthenticatedWebPeriodInSeconds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get throttleUnauthenticatedWebPeriodInSecondsInput() {
        return this._throttleUnauthenticatedWebPeriodInSeconds;
    }
    get throttleUnauthenticatedWebRequestsPerPeriod() {
        return this.getNumberAttribute('throttle_unauthenticated_web_requests_per_period');
    }
    set throttleUnauthenticatedWebRequestsPerPeriod(value) {
        this._throttleUnauthenticatedWebRequestsPerPeriod = value;
    }
    resetThrottleUnauthenticatedWebRequestsPerPeriod() {
        this._throttleUnauthenticatedWebRequestsPerPeriod = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get throttleUnauthenticatedWebRequestsPerPeriodInput() {
        return this._throttleUnauthenticatedWebRequestsPerPeriod;
    }
    get timeTrackingLimitToHours() {
        return this.getBooleanAttribute('time_tracking_limit_to_hours');
    }
    set timeTrackingLimitToHours(value) {
        this._timeTrackingLimitToHours = value;
    }
    resetTimeTrackingLimitToHours() {
        this._timeTrackingLimitToHours = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timeTrackingLimitToHoursInput() {
        return this._timeTrackingLimitToHours;
    }
    get twoFactorGracePeriod() {
        return this.getNumberAttribute('two_factor_grace_period');
    }
    set twoFactorGracePeriod(value) {
        this._twoFactorGracePeriod = value;
    }
    resetTwoFactorGracePeriod() {
        this._twoFactorGracePeriod = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get twoFactorGracePeriodInput() {
        return this._twoFactorGracePeriod;
    }
    get uniqueIpsLimitEnabled() {
        return this.getBooleanAttribute('unique_ips_limit_enabled');
    }
    set uniqueIpsLimitEnabled(value) {
        this._uniqueIpsLimitEnabled = value;
    }
    resetUniqueIpsLimitEnabled() {
        this._uniqueIpsLimitEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get uniqueIpsLimitEnabledInput() {
        return this._uniqueIpsLimitEnabled;
    }
    get uniqueIpsLimitPerUser() {
        return this.getNumberAttribute('unique_ips_limit_per_user');
    }
    set uniqueIpsLimitPerUser(value) {
        this._uniqueIpsLimitPerUser = value;
    }
    resetUniqueIpsLimitPerUser() {
        this._uniqueIpsLimitPerUser = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get uniqueIpsLimitPerUserInput() {
        return this._uniqueIpsLimitPerUser;
    }
    get uniqueIpsLimitTimeWindow() {
        return this.getNumberAttribute('unique_ips_limit_time_window');
    }
    set uniqueIpsLimitTimeWindow(value) {
        this._uniqueIpsLimitTimeWindow = value;
    }
    resetUniqueIpsLimitTimeWindow() {
        this._uniqueIpsLimitTimeWindow = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get uniqueIpsLimitTimeWindowInput() {
        return this._uniqueIpsLimitTimeWindow;
    }
    get usagePingEnabled() {
        return this.getBooleanAttribute('usage_ping_enabled');
    }
    set usagePingEnabled(value) {
        this._usagePingEnabled = value;
    }
    resetUsagePingEnabled() {
        this._usagePingEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get usagePingEnabledInput() {
        return this._usagePingEnabled;
    }
    get userDeactivationEmailsEnabled() {
        return this.getBooleanAttribute('user_deactivation_emails_enabled');
    }
    set userDeactivationEmailsEnabled(value) {
        this._userDeactivationEmailsEnabled = value;
    }
    resetUserDeactivationEmailsEnabled() {
        this._userDeactivationEmailsEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get userDeactivationEmailsEnabledInput() {
        return this._userDeactivationEmailsEnabled;
    }
    get userDefaultExternal() {
        return this.getBooleanAttribute('user_default_external');
    }
    set userDefaultExternal(value) {
        this._userDefaultExternal = value;
    }
    resetUserDefaultExternal() {
        this._userDefaultExternal = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get userDefaultExternalInput() {
        return this._userDefaultExternal;
    }
    get userDefaultInternalRegex() {
        return this.getStringAttribute('user_default_internal_regex');
    }
    set userDefaultInternalRegex(value) {
        this._userDefaultInternalRegex = value;
    }
    resetUserDefaultInternalRegex() {
        this._userDefaultInternalRegex = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get userDefaultInternalRegexInput() {
        return this._userDefaultInternalRegex;
    }
    get userOauthApplications() {
        return this.getBooleanAttribute('user_oauth_applications');
    }
    set userOauthApplications(value) {
        this._userOauthApplications = value;
    }
    resetUserOauthApplications() {
        this._userOauthApplications = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get userOauthApplicationsInput() {
        return this._userOauthApplications;
    }
    get userShowAddSshKeyMessage() {
        return this.getBooleanAttribute('user_show_add_ssh_key_message');
    }
    set userShowAddSshKeyMessage(value) {
        this._userShowAddSshKeyMessage = value;
    }
    resetUserShowAddSshKeyMessage() {
        this._userShowAddSshKeyMessage = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get userShowAddSshKeyMessageInput() {
        return this._userShowAddSshKeyMessage;
    }
    get versionCheckEnabled() {
        return this.getBooleanAttribute('version_check_enabled');
    }
    set versionCheckEnabled(value) {
        this._versionCheckEnabled = value;
    }
    resetVersionCheckEnabled() {
        this._versionCheckEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get versionCheckEnabledInput() {
        return this._versionCheckEnabled;
    }
    get webIdeClientsidePreviewEnabled() {
        return this.getBooleanAttribute('web_ide_clientside_preview_enabled');
    }
    set webIdeClientsidePreviewEnabled(value) {
        this._webIdeClientsidePreviewEnabled = value;
    }
    resetWebIdeClientsidePreviewEnabled() {
        this._webIdeClientsidePreviewEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get webIdeClientsidePreviewEnabledInput() {
        return this._webIdeClientsidePreviewEnabled;
    }
    get whatsNewVariant() {
        return this.getStringAttribute('whats_new_variant');
    }
    set whatsNewVariant(value) {
        this._whatsNewVariant = value;
    }
    resetWhatsNewVariant() {
        this._whatsNewVariant = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get whatsNewVariantInput() {
        return this._whatsNewVariant;
    }
    get wikiPageMaxContentBytes() {
        return this.getNumberAttribute('wiki_page_max_content_bytes');
    }
    set wikiPageMaxContentBytes(value) {
        this._wikiPageMaxContentBytes = value;
    }
    resetWikiPageMaxContentBytes() {
        this._wikiPageMaxContentBytes = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get wikiPageMaxContentBytesInput() {
        return this._wikiPageMaxContentBytes;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            abuse_notification_email: cdktf.stringToTerraform(this._abuseNotificationEmail),
            admin_mode: cdktf.booleanToTerraform(this._adminMode),
            after_sign_out_path: cdktf.stringToTerraform(this._afterSignOutPath),
            after_sign_up_text: cdktf.stringToTerraform(this._afterSignUpText),
            akismet_api_key: cdktf.stringToTerraform(this._akismetApiKey),
            akismet_enabled: cdktf.booleanToTerraform(this._akismetEnabled),
            allow_group_owners_to_manage_ldap: cdktf.booleanToTerraform(this._allowGroupOwnersToManageLdap),
            allow_local_requests_from_system_hooks: cdktf.booleanToTerraform(this._allowLocalRequestsFromSystemHooks),
            allow_local_requests_from_web_hooks_and_services: cdktf.booleanToTerraform(this._allowLocalRequestsFromWebHooksAndServices),
            archive_builds_in_human_readable: cdktf.stringToTerraform(this._archiveBuildsInHumanReadable),
            asset_proxy_allowlist: cdktf.listMapper(cdktf.stringToTerraform, false)(this._assetProxyAllowlist),
            asset_proxy_enabled: cdktf.booleanToTerraform(this._assetProxyEnabled),
            asset_proxy_secret_key: cdktf.stringToTerraform(this._assetProxySecretKey),
            asset_proxy_url: cdktf.stringToTerraform(this._assetProxyUrl),
            authorized_keys_enabled: cdktf.booleanToTerraform(this._authorizedKeysEnabled),
            auto_devops_domain: cdktf.stringToTerraform(this._autoDevopsDomain),
            auto_devops_enabled: cdktf.booleanToTerraform(this._autoDevopsEnabled),
            automatic_purchased_storage_allocation: cdktf.booleanToTerraform(this._automaticPurchasedStorageAllocation),
            check_namespace_plan: cdktf.booleanToTerraform(this._checkNamespacePlan),
            commit_email_hostname: cdktf.stringToTerraform(this._commitEmailHostname),
            container_expiration_policies_enable_historic_entries: cdktf.booleanToTerraform(this._containerExpirationPoliciesEnableHistoricEntries),
            container_registry_cleanup_tags_service_max_list_size: cdktf.numberToTerraform(this._containerRegistryCleanupTagsServiceMaxListSize),
            container_registry_delete_tags_service_timeout: cdktf.numberToTerraform(this._containerRegistryDeleteTagsServiceTimeout),
            container_registry_expiration_policies_caching: cdktf.booleanToTerraform(this._containerRegistryExpirationPoliciesCaching),
            container_registry_expiration_policies_worker_capacity: cdktf.numberToTerraform(this._containerRegistryExpirationPoliciesWorkerCapacity),
            container_registry_token_expire_delay: cdktf.numberToTerraform(this._containerRegistryTokenExpireDelay),
            deactivate_dormant_users: cdktf.booleanToTerraform(this._deactivateDormantUsers),
            default_artifacts_expire_in: cdktf.stringToTerraform(this._defaultArtifactsExpireIn),
            default_branch_name: cdktf.stringToTerraform(this._defaultBranchName),
            default_branch_protection: cdktf.numberToTerraform(this._defaultBranchProtection),
            default_ci_config_path: cdktf.stringToTerraform(this._defaultCiConfigPath),
            default_group_visibility: cdktf.stringToTerraform(this._defaultGroupVisibility),
            default_project_creation: cdktf.numberToTerraform(this._defaultProjectCreation),
            default_project_visibility: cdktf.stringToTerraform(this._defaultProjectVisibility),
            default_projects_limit: cdktf.numberToTerraform(this._defaultProjectsLimit),
            default_snippet_visibility: cdktf.stringToTerraform(this._defaultSnippetVisibility),
            delayed_group_deletion: cdktf.booleanToTerraform(this._delayedGroupDeletion),
            delayed_project_deletion: cdktf.booleanToTerraform(this._delayedProjectDeletion),
            delete_inactive_projects: cdktf.booleanToTerraform(this._deleteInactiveProjects),
            deletion_adjourned_period: cdktf.numberToTerraform(this._deletionAdjournedPeriod),
            diff_max_files: cdktf.numberToTerraform(this._diffMaxFiles),
            diff_max_lines: cdktf.numberToTerraform(this._diffMaxLines),
            diff_max_patch_bytes: cdktf.numberToTerraform(this._diffMaxPatchBytes),
            disable_feed_token: cdktf.booleanToTerraform(this._disableFeedToken),
            disabled_oauth_sign_in_sources: cdktf.listMapper(cdktf.stringToTerraform, false)(this._disabledOauthSignInSources),
            dns_rebinding_protection_enabled: cdktf.booleanToTerraform(this._dnsRebindingProtectionEnabled),
            domain_allowlist: cdktf.listMapper(cdktf.stringToTerraform, false)(this._domainAllowlist),
            domain_denylist: cdktf.listMapper(cdktf.stringToTerraform, false)(this._domainDenylist),
            domain_denylist_enabled: cdktf.booleanToTerraform(this._domainDenylistEnabled),
            dsa_key_restriction: cdktf.numberToTerraform(this._dsaKeyRestriction),
            ecdsa_key_restriction: cdktf.numberToTerraform(this._ecdsaKeyRestriction),
            ecdsa_sk_key_restriction: cdktf.numberToTerraform(this._ecdsaSkKeyRestriction),
            ed25519_key_restriction: cdktf.numberToTerraform(this._ed25519KeyRestriction),
            ed25519_sk_key_restriction: cdktf.numberToTerraform(this._ed25519SkKeyRestriction),
            eks_access_key_id: cdktf.stringToTerraform(this._eksAccessKeyId),
            eks_account_id: cdktf.stringToTerraform(this._eksAccountId),
            eks_integration_enabled: cdktf.booleanToTerraform(this._eksIntegrationEnabled),
            eks_secret_access_key: cdktf.stringToTerraform(this._eksSecretAccessKey),
            elasticsearch_aws: cdktf.booleanToTerraform(this._elasticsearchAws),
            elasticsearch_aws_access_key: cdktf.stringToTerraform(this._elasticsearchAwsAccessKey),
            elasticsearch_aws_region: cdktf.stringToTerraform(this._elasticsearchAwsRegion),
            elasticsearch_aws_secret_access_key: cdktf.stringToTerraform(this._elasticsearchAwsSecretAccessKey),
            elasticsearch_indexed_field_length_limit: cdktf.numberToTerraform(this._elasticsearchIndexedFieldLengthLimit),
            elasticsearch_indexed_file_size_limit_kb: cdktf.numberToTerraform(this._elasticsearchIndexedFileSizeLimitKb),
            elasticsearch_indexing: cdktf.booleanToTerraform(this._elasticsearchIndexing),
            elasticsearch_limit_indexing: cdktf.booleanToTerraform(this._elasticsearchLimitIndexing),
            elasticsearch_max_bulk_concurrency: cdktf.numberToTerraform(this._elasticsearchMaxBulkConcurrency),
            elasticsearch_max_bulk_size_mb: cdktf.numberToTerraform(this._elasticsearchMaxBulkSizeMb),
            elasticsearch_namespace_ids: cdktf.listMapper(cdktf.stringToTerraform, false)(this._elasticsearchNamespaceIds),
            elasticsearch_password: cdktf.stringToTerraform(this._elasticsearchPassword),
            elasticsearch_project_ids: cdktf.listMapper(cdktf.stringToTerraform, false)(this._elasticsearchProjectIds),
            elasticsearch_search: cdktf.booleanToTerraform(this._elasticsearchSearch),
            elasticsearch_url: cdktf.listMapper(cdktf.stringToTerraform, false)(this._elasticsearchUrl),
            elasticsearch_username: cdktf.stringToTerraform(this._elasticsearchUsername),
            email_additional_text: cdktf.stringToTerraform(this._emailAdditionalText),
            email_author_in_body: cdktf.booleanToTerraform(this._emailAuthorInBody),
            enabled_git_access_protocol: cdktf.stringToTerraform(this._enabledGitAccessProtocol),
            enforce_namespace_storage_limit: cdktf.booleanToTerraform(this._enforceNamespaceStorageLimit),
            enforce_terms: cdktf.booleanToTerraform(this._enforceTerms),
            external_auth_client_cert: cdktf.stringToTerraform(this._externalAuthClientCert),
            external_auth_client_key: cdktf.stringToTerraform(this._externalAuthClientKey),
            external_auth_client_key_pass: cdktf.stringToTerraform(this._externalAuthClientKeyPass),
            external_authorization_service_default_label: cdktf.stringToTerraform(this._externalAuthorizationServiceDefaultLabel),
            external_authorization_service_enabled: cdktf.booleanToTerraform(this._externalAuthorizationServiceEnabled),
            external_authorization_service_timeout: cdktf.numberToTerraform(this._externalAuthorizationServiceTimeout),
            external_authorization_service_url: cdktf.stringToTerraform(this._externalAuthorizationServiceUrl),
            external_pipeline_validation_service_timeout: cdktf.numberToTerraform(this._externalPipelineValidationServiceTimeout),
            external_pipeline_validation_service_token: cdktf.stringToTerraform(this._externalPipelineValidationServiceToken),
            external_pipeline_validation_service_url: cdktf.stringToTerraform(this._externalPipelineValidationServiceUrl),
            file_template_project_id: cdktf.numberToTerraform(this._fileTemplateProjectId),
            first_day_of_week: cdktf.numberToTerraform(this._firstDayOfWeek),
            geo_node_allowed_ips: cdktf.stringToTerraform(this._geoNodeAllowedIps),
            geo_status_timeout: cdktf.numberToTerraform(this._geoStatusTimeout),
            git_rate_limit_users_allowlist: cdktf.listMapper(cdktf.stringToTerraform, false)(this._gitRateLimitUsersAllowlist),
            git_two_factor_session_expiry: cdktf.numberToTerraform(this._gitTwoFactorSessionExpiry),
            gitaly_timeout_default: cdktf.numberToTerraform(this._gitalyTimeoutDefault),
            gitaly_timeout_fast: cdktf.numberToTerraform(this._gitalyTimeoutFast),
            gitaly_timeout_medium: cdktf.numberToTerraform(this._gitalyTimeoutMedium),
            grafana_enabled: cdktf.booleanToTerraform(this._grafanaEnabled),
            grafana_url: cdktf.stringToTerraform(this._grafanaUrl),
            gravatar_enabled: cdktf.booleanToTerraform(this._gravatarEnabled),
            hashed_storage_enabled: cdktf.booleanToTerraform(this._hashedStorageEnabled),
            help_page_hide_commercial_content: cdktf.booleanToTerraform(this._helpPageHideCommercialContent),
            help_page_support_url: cdktf.stringToTerraform(this._helpPageSupportUrl),
            help_page_text: cdktf.stringToTerraform(this._helpPageText),
            help_text: cdktf.stringToTerraform(this._helpText),
            hide_third_party_offers: cdktf.booleanToTerraform(this._hideThirdPartyOffers),
            home_page_url: cdktf.stringToTerraform(this._homePageUrl),
            housekeeping_enabled: cdktf.booleanToTerraform(this._housekeepingEnabled),
            housekeeping_full_repack_period: cdktf.numberToTerraform(this._housekeepingFullRepackPeriod),
            housekeeping_gc_period: cdktf.numberToTerraform(this._housekeepingGcPeriod),
            housekeeping_incremental_repack_period: cdktf.numberToTerraform(this._housekeepingIncrementalRepackPeriod),
            html_emails_enabled: cdktf.booleanToTerraform(this._htmlEmailsEnabled),
            id: cdktf.stringToTerraform(this._id),
            import_sources: cdktf.listMapper(cdktf.stringToTerraform, false)(this._importSources),
            in_product_marketing_emails_enabled: cdktf.booleanToTerraform(this._inProductMarketingEmailsEnabled),
            inactive_projects_delete_after_months: cdktf.numberToTerraform(this._inactiveProjectsDeleteAfterMonths),
            inactive_projects_min_size_mb: cdktf.numberToTerraform(this._inactiveProjectsMinSizeMb),
            inactive_projects_send_warning_email_after_months: cdktf.numberToTerraform(this._inactiveProjectsSendWarningEmailAfterMonths),
            invisible_captcha_enabled: cdktf.booleanToTerraform(this._invisibleCaptchaEnabled),
            issues_create_limit: cdktf.numberToTerraform(this._issuesCreateLimit),
            keep_latest_artifact: cdktf.booleanToTerraform(this._keepLatestArtifact),
            local_markdown_version: cdktf.numberToTerraform(this._localMarkdownVersion),
            mailgun_events_enabled: cdktf.booleanToTerraform(this._mailgunEventsEnabled),
            mailgun_signing_key: cdktf.stringToTerraform(this._mailgunSigningKey),
            maintenance_mode: cdktf.booleanToTerraform(this._maintenanceMode),
            maintenance_mode_message: cdktf.stringToTerraform(this._maintenanceModeMessage),
            max_artifacts_size: cdktf.numberToTerraform(this._maxArtifactsSize),
            max_attachment_size: cdktf.numberToTerraform(this._maxAttachmentSize),
            max_export_size: cdktf.numberToTerraform(this._maxExportSize),
            max_import_size: cdktf.numberToTerraform(this._maxImportSize),
            max_number_of_repository_downloads: cdktf.numberToTerraform(this._maxNumberOfRepositoryDownloads),
            max_number_of_repository_downloads_within_time_period: cdktf.numberToTerraform(this._maxNumberOfRepositoryDownloadsWithinTimePeriod),
            max_pages_size: cdktf.numberToTerraform(this._maxPagesSize),
            max_personal_access_token_lifetime: cdktf.numberToTerraform(this._maxPersonalAccessTokenLifetime),
            max_ssh_key_lifetime: cdktf.numberToTerraform(this._maxSshKeyLifetime),
            metrics_method_call_threshold: cdktf.numberToTerraform(this._metricsMethodCallThreshold),
            mirror_available: cdktf.booleanToTerraform(this._mirrorAvailable),
            mirror_capacity_threshold: cdktf.numberToTerraform(this._mirrorCapacityThreshold),
            mirror_max_capacity: cdktf.numberToTerraform(this._mirrorMaxCapacity),
            mirror_max_delay: cdktf.numberToTerraform(this._mirrorMaxDelay),
            npm_package_requests_forwarding: cdktf.booleanToTerraform(this._npmPackageRequestsForwarding),
            outbound_local_requests_whitelist: cdktf.listMapper(cdktf.stringToTerraform, false)(this._outboundLocalRequestsWhitelist),
            package_registry_cleanup_policies_worker_capacity: cdktf.numberToTerraform(this._packageRegistryCleanupPoliciesWorkerCapacity),
            pages_domain_verification_enabled: cdktf.booleanToTerraform(this._pagesDomainVerificationEnabled),
            password_authentication_enabled_for_git: cdktf.booleanToTerraform(this._passwordAuthenticationEnabledForGit),
            password_authentication_enabled_for_web: cdktf.booleanToTerraform(this._passwordAuthenticationEnabledForWeb),
            password_lowercase_required: cdktf.booleanToTerraform(this._passwordLowercaseRequired),
            password_number_required: cdktf.booleanToTerraform(this._passwordNumberRequired),
            password_symbol_required: cdktf.booleanToTerraform(this._passwordSymbolRequired),
            password_uppercase_required: cdktf.booleanToTerraform(this._passwordUppercaseRequired),
            performance_bar_allowed_group_path: cdktf.stringToTerraform(this._performanceBarAllowedGroupPath),
            personal_access_token_prefix: cdktf.stringToTerraform(this._personalAccessTokenPrefix),
            pipeline_limit_per_project_user_sha: cdktf.numberToTerraform(this._pipelineLimitPerProjectUserSha),
            plantuml_enabled: cdktf.booleanToTerraform(this._plantumlEnabled),
            plantuml_url: cdktf.stringToTerraform(this._plantumlUrl),
            polling_interval_multiplier: cdktf.numberToTerraform(this._pollingIntervalMultiplier),
            project_export_enabled: cdktf.booleanToTerraform(this._projectExportEnabled),
            prometheus_metrics_enabled: cdktf.booleanToTerraform(this._prometheusMetricsEnabled),
            protected_ci_variables: cdktf.booleanToTerraform(this._protectedCiVariables),
            push_event_activities_limit: cdktf.numberToTerraform(this._pushEventActivitiesLimit),
            push_event_hooks_limit: cdktf.numberToTerraform(this._pushEventHooksLimit),
            pypi_package_requests_forwarding: cdktf.booleanToTerraform(this._pypiPackageRequestsForwarding),
            rate_limiting_response_text: cdktf.stringToTerraform(this._rateLimitingResponseText),
            raw_blob_request_limit: cdktf.numberToTerraform(this._rawBlobRequestLimit),
            recaptcha_enabled: cdktf.booleanToTerraform(this._recaptchaEnabled),
            recaptcha_private_key: cdktf.stringToTerraform(this._recaptchaPrivateKey),
            recaptcha_site_key: cdktf.stringToTerraform(this._recaptchaSiteKey),
            receive_max_input_size: cdktf.numberToTerraform(this._receiveMaxInputSize),
            repository_checks_enabled: cdktf.booleanToTerraform(this._repositoryChecksEnabled),
            repository_size_limit: cdktf.numberToTerraform(this._repositorySizeLimit),
            repository_storages: cdktf.listMapper(cdktf.stringToTerraform, false)(this._repositoryStorages),
            repository_storages_weighted: cdktf.hashMapper(cdktf.numberToTerraform)(this._repositoryStoragesWeighted),
            require_admin_approval_after_user_signup: cdktf.booleanToTerraform(this._requireAdminApprovalAfterUserSignup),
            require_two_factor_authentication: cdktf.booleanToTerraform(this._requireTwoFactorAuthentication),
            restricted_visibility_levels: cdktf.listMapper(cdktf.stringToTerraform, false)(this._restrictedVisibilityLevels),
            rsa_key_restriction: cdktf.numberToTerraform(this._rsaKeyRestriction),
            search_rate_limit: cdktf.numberToTerraform(this._searchRateLimit),
            search_rate_limit_unauthenticated: cdktf.numberToTerraform(this._searchRateLimitUnauthenticated),
            send_user_confirmation_email: cdktf.booleanToTerraform(this._sendUserConfirmationEmail),
            session_expire_delay: cdktf.numberToTerraform(this._sessionExpireDelay),
            shared_runners_enabled: cdktf.booleanToTerraform(this._sharedRunnersEnabled),
            shared_runners_minutes: cdktf.numberToTerraform(this._sharedRunnersMinutes),
            shared_runners_text: cdktf.stringToTerraform(this._sharedRunnersText),
            sidekiq_job_limiter_compression_threshold_bytes: cdktf.numberToTerraform(this._sidekiqJobLimiterCompressionThresholdBytes),
            sidekiq_job_limiter_limit_bytes: cdktf.numberToTerraform(this._sidekiqJobLimiterLimitBytes),
            sidekiq_job_limiter_mode: cdktf.stringToTerraform(this._sidekiqJobLimiterMode),
            sign_in_text: cdktf.stringToTerraform(this._signInText),
            signup_enabled: cdktf.booleanToTerraform(this._signupEnabled),
            slack_app_enabled: cdktf.booleanToTerraform(this._slackAppEnabled),
            slack_app_id: cdktf.stringToTerraform(this._slackAppId),
            slack_app_secret: cdktf.stringToTerraform(this._slackAppSecret),
            slack_app_signing_secret: cdktf.stringToTerraform(this._slackAppSigningSecret),
            slack_app_verification_token: cdktf.stringToTerraform(this._slackAppVerificationToken),
            snippet_size_limit: cdktf.numberToTerraform(this._snippetSizeLimit),
            snowplow_app_id: cdktf.stringToTerraform(this._snowplowAppId),
            snowplow_collector_hostname: cdktf.stringToTerraform(this._snowplowCollectorHostname),
            snowplow_cookie_domain: cdktf.stringToTerraform(this._snowplowCookieDomain),
            snowplow_enabled: cdktf.booleanToTerraform(this._snowplowEnabled),
            sourcegraph_enabled: cdktf.booleanToTerraform(this._sourcegraphEnabled),
            sourcegraph_public_only: cdktf.booleanToTerraform(this._sourcegraphPublicOnly),
            sourcegraph_url: cdktf.stringToTerraform(this._sourcegraphUrl),
            spam_check_api_key: cdktf.stringToTerraform(this._spamCheckApiKey),
            spam_check_endpoint_enabled: cdktf.booleanToTerraform(this._spamCheckEndpointEnabled),
            spam_check_endpoint_url: cdktf.stringToTerraform(this._spamCheckEndpointUrl),
            suggest_pipeline_enabled: cdktf.booleanToTerraform(this._suggestPipelineEnabled),
            terminal_max_session_time: cdktf.numberToTerraform(this._terminalMaxSessionTime),
            terms: cdktf.stringToTerraform(this._terms),
            throttle_authenticated_api_enabled: cdktf.booleanToTerraform(this._throttleAuthenticatedApiEnabled),
            throttle_authenticated_api_period_in_seconds: cdktf.numberToTerraform(this._throttleAuthenticatedApiPeriodInSeconds),
            throttle_authenticated_api_requests_per_period: cdktf.numberToTerraform(this._throttleAuthenticatedApiRequestsPerPeriod),
            throttle_authenticated_packages_api_enabled: cdktf.booleanToTerraform(this._throttleAuthenticatedPackagesApiEnabled),
            throttle_authenticated_packages_api_period_in_seconds: cdktf.numberToTerraform(this._throttleAuthenticatedPackagesApiPeriodInSeconds),
            throttle_authenticated_packages_api_requests_per_period: cdktf.numberToTerraform(this._throttleAuthenticatedPackagesApiRequestsPerPeriod),
            throttle_authenticated_web_enabled: cdktf.booleanToTerraform(this._throttleAuthenticatedWebEnabled),
            throttle_authenticated_web_period_in_seconds: cdktf.numberToTerraform(this._throttleAuthenticatedWebPeriodInSeconds),
            throttle_authenticated_web_requests_per_period: cdktf.numberToTerraform(this._throttleAuthenticatedWebRequestsPerPeriod),
            throttle_unauthenticated_api_enabled: cdktf.booleanToTerraform(this._throttleUnauthenticatedApiEnabled),
            throttle_unauthenticated_api_period_in_seconds: cdktf.numberToTerraform(this._throttleUnauthenticatedApiPeriodInSeconds),
            throttle_unauthenticated_api_requests_per_period: cdktf.numberToTerraform(this._throttleUnauthenticatedApiRequestsPerPeriod),
            throttle_unauthenticated_packages_api_enabled: cdktf.booleanToTerraform(this._throttleUnauthenticatedPackagesApiEnabled),
            throttle_unauthenticated_packages_api_period_in_seconds: cdktf.numberToTerraform(this._throttleUnauthenticatedPackagesApiPeriodInSeconds),
            throttle_unauthenticated_packages_api_requests_per_period: cdktf.numberToTerraform(this._throttleUnauthenticatedPackagesApiRequestsPerPeriod),
            throttle_unauthenticated_web_enabled: cdktf.booleanToTerraform(this._throttleUnauthenticatedWebEnabled),
            throttle_unauthenticated_web_period_in_seconds: cdktf.numberToTerraform(this._throttleUnauthenticatedWebPeriodInSeconds),
            throttle_unauthenticated_web_requests_per_period: cdktf.numberToTerraform(this._throttleUnauthenticatedWebRequestsPerPeriod),
            time_tracking_limit_to_hours: cdktf.booleanToTerraform(this._timeTrackingLimitToHours),
            two_factor_grace_period: cdktf.numberToTerraform(this._twoFactorGracePeriod),
            unique_ips_limit_enabled: cdktf.booleanToTerraform(this._uniqueIpsLimitEnabled),
            unique_ips_limit_per_user: cdktf.numberToTerraform(this._uniqueIpsLimitPerUser),
            unique_ips_limit_time_window: cdktf.numberToTerraform(this._uniqueIpsLimitTimeWindow),
            usage_ping_enabled: cdktf.booleanToTerraform(this._usagePingEnabled),
            user_deactivation_emails_enabled: cdktf.booleanToTerraform(this._userDeactivationEmailsEnabled),
            user_default_external: cdktf.booleanToTerraform(this._userDefaultExternal),
            user_default_internal_regex: cdktf.stringToTerraform(this._userDefaultInternalRegex),
            user_oauth_applications: cdktf.booleanToTerraform(this._userOauthApplications),
            user_show_add_ssh_key_message: cdktf.booleanToTerraform(this._userShowAddSshKeyMessage),
            version_check_enabled: cdktf.booleanToTerraform(this._versionCheckEnabled),
            web_ide_clientside_preview_enabled: cdktf.booleanToTerraform(this._webIdeClientsidePreviewEnabled),
            whats_new_variant: cdktf.stringToTerraform(this._whatsNewVariant),
            wiki_page_max_content_bytes: cdktf.numberToTerraform(this._wikiPageMaxContentBytes),
        };
    }
}
exports.ApplicationSettings = ApplicationSettings;
_a = JSII_RTTI_SYMBOL_1;
ApplicationSettings[_a] = { fqn: "@cdktf/provider-gitlab.ApplicationSettings", version: "2.0.37" };
// =================
// STATIC PROPERTIES
// =================
ApplicationSettings.tfResourceType = "gitlab_application_settings";
//# sourceMappingURL=data:application/json;base64,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