# coding: utf-8

"""
    EXACT - API

    API to interact with the EXACT Server  # noqa: E501

    OpenAPI spec version: 1.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import
from exact_sync.v1.api.pagination_base_api import PaginationBaseAPI
import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from exact_sync.v1.api_client import ApiClient


class ProcessingApi(PaginationBaseAPI):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_plugin(self, **kwargs):  # noqa: E501
        """create_plugin  # noqa: E501

        API endpoint that allows Plugins to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_plugin(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id:
        :param str name:
        :param str author:
        :param str contact:
        :param str abouturl:
        :param str icon:
        :param list[int] products:
        :param list[int] results:
        :return: Plugin
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_plugin_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.create_plugin_with_http_info(**kwargs)  # noqa: E501
            return data

    def create_plugin_with_http_info(self, **kwargs):  # noqa: E501
        """create_plugin  # noqa: E501

        API endpoint that allows Plugins to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_plugin_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id:
        :param str name:
        :param str author:
        :param str contact:
        :param str abouturl:
        :param str icon:
        :param list[int] products:
        :param list[int] results:
        :return: Plugin
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = [ 'id', 'name', 'author', 'contact', 'abouturl', 'icon', 'products', 'results']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_plugin" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'id' in params:
            form_params.append(('id', params['id']))  # noqa: E501
        if 'name' in params:
            form_params.append(('name', params['name']))  # noqa: E501
        if 'author' in params:
            form_params.append(('author', params['author']))  # noqa: E501
        if 'contact' in params:
            form_params.append(('contact', params['contact']))  # noqa: E501
        if 'abouturl' in params:
            form_params.append(('abouturl', params['abouturl']))  # noqa: E501
        if 'icon' in params:
            local_var_files['icon'] = params['icon']  # noqa: E501
        if 'products' in params:
            form_params.append(('products', params['products']))  # noqa: E501
            collection_formats['products'] = 'multi'  # noqa: E501
        if 'results' in params:
            form_params.append(('results', params['results']))  # noqa: E501
            collection_formats['results'] = 'multi'  # noqa: E501
        if 'id' in params:
            form_params.append(('id', params['id']))  # noqa: E501
        if 'name' in params:
            form_params.append(('name', params['name']))  # noqa: E501
        if 'author' in params:
            form_params.append(('author', params['author']))  # noqa: E501
        if 'contact' in params:
            form_params.append(('contact', params['contact']))  # noqa: E501
        if 'abouturl' in params:
            form_params.append(('abouturl', params['abouturl']))  # noqa: E501
        if 'icon' in params:
            local_var_files['icon'] = params['icon']  # noqa: E501
        if 'products' in params:
            form_params.append(('products', params['products']))  # noqa: E501
            collection_formats['products'] = 'multi'  # noqa: E501
        if 'results' in params:
            form_params.append(('results', params['results']))  # noqa: E501
            collection_formats['results'] = 'multi'  # noqa: E501

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']
  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/processing/plugins/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Plugin',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_plugin_job(self, **kwargs):  # noqa: E501
        """create_plugin_job  # noqa: E501

        API endpoint that allows PluginJobs to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_plugin_job(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id:
        :param int creator:
        :param int plugin:
        :param datetime created_time:
        :param datetime eta_time:
        :param float processing_complete:
        :param datetime updated_time:
        :param int result:
        :return: PluginJob
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_plugin_job_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.create_plugin_job_with_http_info(**kwargs)  # noqa: E501
            return data

    def create_plugin_job_with_http_info(self, **kwargs):  # noqa: E501
        """create_plugin_job  # noqa: E501

        API endpoint that allows PluginJobs to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_plugin_job_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id:
        :param int creator:
        :param int plugin:
        :param datetime created_time:
        :param datetime eta_time:
        :param float processing_complete:
        :param datetime updated_time:
        :param int result:
        :return: PluginJob
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'creator', 'plugin', 'created_time', 'eta_time', 'processing_complete', 'updated_time', 'result']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_plugin_job" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'id' in params:
            form_params.append(('id', params['id']))  # noqa: E501
        if 'creator' in params:
            form_params.append(('creator', params['creator']))  # noqa: E501
        if 'plugin' in params:
            form_params.append(('plugin', params['plugin']))  # noqa: E501
        if 'created_time' in params:
            form_params.append(('created_time', params['created_time']))  # noqa: E501
        if 'eta_time' in params:
            form_params.append(('eta_time', params['eta_time']))  # noqa: E501
        if 'processing_complete' in params:
            form_params.append(('processing_complete', params['processing_complete']))  # noqa: E501
        if 'updated_time' in params:
            form_params.append(('updated_time', params['updated_time']))  # noqa: E501
        if 'result' in params:
            form_params.append(('result', params['result']))  # noqa: E501

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']   # noqa: E501

        return self.api_client.call_api(
            '/api/v1/processing/pluginjobs/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PluginJob',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_plugin_result(self, **kwargs):  # noqa: E501
        """create_plugin_result  # noqa: E501

        API endpoint that allows PluginResultss to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_plugin_result(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PluginResult body:
        :return: PluginResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_plugin_result_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.create_plugin_result_with_http_info(**kwargs)  # noqa: E501
            return data

    def create_plugin_result_with_http_info(self, **kwargs):  # noqa: E501
        """create_plugin_result  # noqa: E501

        API endpoint that allows PluginResultss to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_plugin_result_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PluginResult body:
        :return: PluginResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_plugin_result" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'id' in params:
            form_params.append(('id', params['id']))  # noqa: E501
        if 'image' in params:
            form_params.append(('image', params['image']))  # noqa: E501
        if 'job' in params:
            form_params.append(('job', params['job']))  # noqa: E501
        if 'plugin' in params:
            form_params.append(('plugin', params['plugin']))  # noqa: E501
        if 'completed_time' in params:
            form_params.append(('completed_time', params['completed_time']))  # noqa: E501
        if 'created_time' in params:
            form_params.append(('created_time', params['created_time']))  # noqa: E501
        if 'entries' in params:
            form_params.append(('entries', params['entries']))  # noqa: E501
            collection_formats['entries'] = 'multi'  # noqa: E501

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']   # noqa: E501

        return self.api_client.call_api(
            '/api/v1/processing/pluginresults/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PluginResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_plugin_result_annotation(self, **kwargs):  # noqa: E501
        """create_plugin_result_annotation  # noqa: E501

        API endpoint that allows PluginResultAnnotations to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_plugin_result_annotation(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PluginResultAnnotation body:
        :return: PluginResultAnnotation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_plugin_result_annotation_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.create_plugin_result_annotation_with_http_info(**kwargs)  # noqa: E501
            return data

    def create_plugin_result_annotation_with_http_info(self, **kwargs):  # noqa: E501
        """create_plugin_result_annotation  # noqa: E501

        API endpoint that allows PluginResultAnnotations to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_plugin_result_annotation_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PluginResultAnnotation body:
        :return: PluginResultAnnotation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_plugin_result_annotation" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'id' in params:
            form_params.append(('id', params['id']))  # noqa: E501
        if 'annotation_type' in params:
            form_params.append(('annotation_type', params['annotation_type']))  # noqa: E501
        if 'pluginresultentry' in params:
            form_params.append(('pluginresultentry', params['pluginresultentry']))  # noqa: E501
        if 'meta_data' in params:
            form_params.append(('meta_data', params['meta_data']))  # noqa: E501
        if 'vector' in params:
            form_params.append(('vector', params['vector']))  # noqa: E501
        if 'unique_identifier' in params:
            form_params.append(('unique_identifier', params['unique_identifier']))  # noqa: E501
        if 'generated' in params:
            form_params.append(('generated', params['generated']))  # noqa: E501
        if 'image' in params:
            form_params.append(('image', params['image']))  # noqa: E501
        if 'time' in params:
            form_params.append(('time', params['time']))  # noqa: E501

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']   # noqa: E501

        return self.api_client.call_api(
            '/api/v1/processing/pluginresultannotations/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PluginResultAnnotation',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_plugin_result_bitmap(self, **kwargs):  # noqa: E501
        """create_plugin_result_bitmap  # noqa: E501

        API endpoint that allows PluginResultBitmaps to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_plugin_result_bitmap(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PluginResultBitmap body:
        :return: PluginResultBitmap
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_plugin_result_bitmap_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.create_plugin_result_bitmap_with_http_info(**kwargs)  # noqa: E501
            return data

    def create_plugin_result_bitmap_with_http_info(self, **kwargs):  # noqa: E501
        """create_plugin_result_bitmap  # noqa: E501

        API endpoint that allows PluginResultBitmaps to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_plugin_result_bitmap_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PluginResultBitmap body:
        :return: PluginResultBitmap
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_plugin_result_bitmap" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'id' in params:
            form_params.append(('id', params['id']))  # noqa: E501
        if 'bitmap' in params:
            local_var_files['bitmap'] = params['bitmap']  # noqa: E501
        if 'channels' in params:
            form_params.append(('channels', params['channels']))  # noqa: E501
        if 'default_alpha' in params:
            form_params.append(('default_alpha', params['default_alpha']))  # noqa: E501
        if 'default_threshold' in params:
            form_params.append(('default_threshold', params['default_threshold']))  # noqa: E501
        if 'meta_data' in params:
            form_params.append(('meta_data', params['meta_data']))  # noqa: E501
        if 'name' in params:
            form_params.append(('name', params['name']))  # noqa: E501
        if 'scale_max' in params:
            form_params.append(('scale_max', params['scale_max']))  # noqa: E501
        if 'scale_min' in params:
            form_params.append(('scale_min', params['scale_min']))  # noqa: E501
        if 'transformation_matrix' in params:
            form_params.append(('transformation_matrix', params['transformation_matrix']))  # noqa: E501
        if 'pluginresultentry' in params:
            form_params.append(('pluginresultentry', params['pluginresultentry']))  # noqa: E501
        if 'image' in params:
            form_params.append(('image', params['image']))  # noqa: E501

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']   # noqa: E501

        return self.api_client.call_api(
            '/api/v1/processing/pluginresultbitmaps/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PluginResultBitmap',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_plugin_result_entry(self, **kwargs):  # noqa: E501
        """create_plugin_result_entry  # noqa: E501

        API endpoint that allows PluginResultsEntrys to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_plugin_result_entry(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PluginResultEntry body:
        :return: PluginResultEntry
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_plugin_result_entry_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.create_plugin_result_entry_with_http_info(**kwargs)  # noqa: E501
            return data

    def create_plugin_result_entry_with_http_info(self, **kwargs):  # noqa: E501
        """create_plugin_result_entry  # noqa: E501

        API endpoint that allows PluginResultsEntrys to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_plugin_result_entry_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PluginResultEntry body:
        :return: PluginResultEntry
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_plugin_result_entry" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'id' in params:
            form_params.append(('id', params['id']))  # noqa: E501
        if 'pluginresult' in params:
            form_params.append(('pluginresult', params['pluginresult']))  # noqa: E501
        if 'created_time' in params:
            form_params.append(('created_time', params['created_time']))  # noqa: E501
        if 'name' in params:
            form_params.append(('name', params['name']))  # noqa: E501
        if 'visible' in params:
            form_params.append(('visible', params['visible']))  # noqa: E501
        if 'annotation_results' in params:
            form_params.append(('annotation_results', params['annotation_results']))  # noqa: E501
            collection_formats['annotation_results'] = 'multi'  # noqa: E501
        if 'bitmap_results' in params:
            form_params.append(('bitmap_results', params['bitmap_results']))  # noqa: E501
            collection_formats['bitmap_results'] = 'multi'  # noqa: E501


        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']   # noqa: E501

        return self.api_client.call_api(
            '/api/v1/processing/pluginresultentrys/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PluginResultEntry',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def partial_update_plugin(self, id, **kwargs):  # noqa: E501
        """partial_update_plugin  # noqa: E501

        API endpoint that allows Plugins to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.partial_update_plugin(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: A unique integer value identifying this plugin. (required)
        :param Plugin body:
        :return: Plugin
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.partial_update_plugin_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.partial_update_plugin_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def partial_update_plugin_with_http_info(self, id, **kwargs):  # noqa: E501
        """partial_update_plugin  # noqa: E501

        API endpoint that allows Plugins to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.partial_update_plugin_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: A unique integer value identifying this plugin. (required)
        :param Plugin body:
        :return: Plugin
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id',
            'name',
            'author',
            'package',
            'contact', 
            'abouturl',
            'icon',
            'products',
            'results']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method partial_update_plugin" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `partial_update_plugin`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = {}

        for p in all_params[0:-4]:
            if p in params:
                body_params[p] = params[p]

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']   # noqa: E501

        return self.api_client.call_api(
            '/api/v1/processing/plugins/{id}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Plugin',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
    def partial_update_plugin_job(self, id, **kwargs):  # noqa: E501
        """partial_update_plugin_job  # noqa: E501

        API endpoint that allows PluginJobs to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.partial_update_plugin_job(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: A unique integer value identifying this plugin job. (required)
        :param PluginJob body:
        :return: PluginJob
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.partial_update_plugin_job_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.partial_update_plugin_job_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def partial_update_plugin_job_with_http_info(self, id, **kwargs):  # noqa: E501
        """partial_update_plugin_job  # noqa: E501

        API endpoint that allows PluginJobs to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.partial_update_plugin_job_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: A unique integer value identifying this plugin job. (required)
        :param PluginJob body:
        :return: PluginJob
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'creator', 'plugin', 'created_time', 'image', 'eta_time',
            'processing_complete', 'updated_time', 'result', 'error_message', 'error_detail', 'attached_worker']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method partial_update_plugin_job" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `partial_update_plugin_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = {}


        for p in all_params[0:-4]:
            if p in params:
                body_params[p] = params[p]


        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']   # noqa: E501

        return self.api_client.call_api(
            '/api/v1/processing/pluginjobs/{id}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PluginJob',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def partial_update_plugin_result(self, id, **kwargs):  # noqa: E501
        """partial_update_plugin_result  # noqa: E501

        API endpoint that allows PluginResultss to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.partial_update_plugin_result(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :param PluginResult body:
        :return: PluginResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.partial_update_plugin_result_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.partial_update_plugin_result_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def partial_update_plugin_result_with_http_info(self, id, **kwargs):  # noqa: E501
        """partial_update_plugin_result  # noqa: E501

        API endpoint that allows PluginResultss to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.partial_update_plugin_result_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :param PluginResult body:
        :return: PluginResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id','image',
            'job',
            'plugin',
            'completed_time',
            'created_time',
            'entries']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method partial_update_plugin_result" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `partial_update_plugin_result`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = {}

        for p in all_params[0:-4]:
            if p in params:
                body_params[p] = params[p]

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']   # noqa: E501

        return self.api_client.call_api(
            '/api/v1/processing/pluginresults/{id}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PluginResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def partial_update_plugin_result_annotation(self, id, **kwargs):  # noqa: E501
        """partial_update_plugin_result_annotation  # noqa: E501

        API endpoint that allows PluginResultAnnotations to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.partial_update_plugin_result_annotation(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: A unique integer value identifying this plugin result annotation. (required)
        :param PluginResultAnnotation body:
        :return: PluginResultAnnotation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.partial_update_plugin_result_annotation_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.partial_update_plugin_result_annotation_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def partial_update_plugin_result_annotation_with_http_info(self, id, **kwargs):  # noqa: E501
        """partial_update_plugin_result_annotation  # noqa: E501

        API endpoint that allows PluginResultAnnotations to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.partial_update_plugin_result_annotation_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: A unique integer value identifying this plugin result annotation. (required)
        :param PluginResultAnnotation body:
        :return: PluginResultAnnotation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id',
            'annotation_type',
            'pluginresultentry',
            'meta_data',
            'vector',
            'unique_identifier',
            'image',
            'time']  # noqa: E501

        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method partial_update_plugin_result_annotation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `partial_update_plugin_result_annotation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}


        body_params = {}

        for p in all_params[0:-4]:
            if p in params:
                body_params[p] = params[p]

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']   # noqa: E501

        return self.api_client.call_api(
            '/api/v1/processing/pluginresultannotations/{id}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PluginResultAnnotation',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def partial_update_plugin_result_bitmap(self, id, **kwargs):  # noqa: E501
        """partial_update_plugin_result_bitmap  # noqa: E501

        API endpoint that allows PluginResultBitmaps to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.partial_update_plugin_result_bitmap(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: A unique integer value identifying this plugin result bitmap. (required)
        :param PluginResultBitmap body:
        :return: PluginResultBitmap
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.partial_update_plugin_result_bitmap_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.partial_update_plugin_result_bitmap_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def partial_update_plugin_result_bitmap_with_http_info(self, id, **kwargs):  # noqa: E501
        """partial_update_plugin_result_bitmap  # noqa: E501

        API endpoint that allows PluginResultBitmaps to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.partial_update_plugin_result_bitmap_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: A unique integer value identifying this plugin result bitmap. (required)
        :param PluginResultBitmap body:
        :return: PluginResultBitmap
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id',
            'bitmap',
            'channels',
            'default_alpha',
            'default_threshold',
            'meta_data',
            'name',
            'scale_max',
            'scale_min',
            'transformation_matrix',
            'pluginresultentry',
            'image']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method partial_update_plugin_result_bitmap" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `partial_update_plugin_result_bitmap`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = {}

        for p in all_params[0:-4]:
            if p in params:
                body_params[p] = params[p]

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']   # noqa: E501

        return self.api_client.call_api(
            '/api/v1/processing/pluginresultbitmaps/{id}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PluginResultBitmap',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
    
    def partial_update_plugin_result_entry(self, id, **kwargs):  # noqa: E501
        """partial_update_plugin_result_entry  # noqa: E501

        API endpoint that allows PluginResultsEntrys to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.partial_update_plugin_result_entry(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: A unique integer value identifying this plugin result entry. (required)
        :param PluginResultEntry body:
        :return: PluginResultEntry
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.partial_update_plugin_result_entry_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.partial_update_plugin_result_entry_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def partial_update_plugin_result_entry_with_http_info(self, id, **kwargs):  # noqa: E501
        """partial_update_plugin_result_entry  # noqa: E501

        API endpoint that allows PluginResultsEntrys to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.partial_update_plugin_result_entry_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: A unique integer value identifying this plugin result entry. (required)
        :param PluginResultEntry body:
        :return: PluginResultEntry
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id',
            'pluginresult',
            'created_time',
            'name',
            'visible',
            'annotation_results',
            'bitmap_results']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method partial_update_plugin_result_entry" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `partial_update_plugin_result_entry`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}


        body_params = {}

        for p in all_params[0:-4]:
            if p in params:
                body_params[p] = params[p]

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']   # noqa: E501

        return self.api_client.call_api(
            '/api/v1/processing/pluginresultentrys/{id}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PluginResultEntry',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_plugin_jobs(self, **kwargs):  # noqa: E501
        """list_plugin_jobs  # noqa: E501

        API endpoint that allows PluginJobs to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_plugin_jobs(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :return: PluginJobs
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_plugin_jobs_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_plugin_jobs_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_plugin_jobs_with_http_info(self, **kwargs):  # noqa: E501
        """list_plugin_jobs  # noqa: E501

        API endpoint that allows PluginJobs to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_plugin_jobs_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :return: PluginJobs
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['limit', 'offset']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_plugin_jobs" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']   # noqa: E501

        return self.api_client.call_api(
            '/api/v1/processing/pluginjobs/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PluginJobs',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_plugin_result_annotations(self, **kwargs):  # noqa: E501
        """list_plugin_result_annotations  # noqa: E501

        API endpoint that allows PluginResultAnnotations to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_plugin_result_annotations(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :return: PluginResultAnnotations
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_plugin_result_annotations_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_plugin_result_annotations_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_plugin_result_annotations_with_http_info(self, **kwargs):  # noqa: E501
        """list_plugin_result_annotations  # noqa: E501

        API endpoint that allows PluginResultAnnotations to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_plugin_result_annotations_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :return: PluginResultAnnotations
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['limit', 'offset']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_plugin_result_annotations" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']   # noqa: E501

        return self.api_client.call_api(
            '/api/v1/processing/pluginresultannotations/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PluginResultAnnotations',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_plugins(self, **kwargs):  # noqa: E501
        """list_plugins  # noqa: E501

        API endpoint that allows Plugins to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_plugins(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :return: Plugins
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_plugins_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_plugins_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_plugins_with_http_info(self, **kwargs):  # noqa: E501
        """list_plugins  # noqa: E501

        API endpoint that allows Plugins to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_plugins_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :return: Plugins
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['limit', 'offset']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_plugins" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/processing/plugins/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Plugins',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_plugin_result_bitmaps(self, **kwargs):  # noqa: E501
        """list_plugin_result_bitmaps  # noqa: E501

        API endpoint that allows PluginResultBitmaps to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_plugin_result_bitmaps(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :return: PluginResultBitmaps
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_plugin_result_bitmaps_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_plugin_result_bitmaps_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_plugin_result_bitmaps_with_http_info(self, **kwargs):  # noqa: E501
        """list_plugin_result_bitmaps  # noqa: E501

        API endpoint that allows PluginResultBitmaps to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_plugin_result_bitmaps_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :return: PluginResultBitmaps
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['limit', 'offset']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_plugin_result_bitmaps" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']   # noqa: E501

        return self.api_client.call_api(
            '/api/v1/processing/pluginresultbitmaps/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PluginResultBitmaps',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_plugin_result_entrys(self, **kwargs):  # noqa: E501
        """list_plugin_result_entrys  # noqa: E501

        API endpoint that allows PluginResultsEntrys to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_plugin_result_entrys(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :return: PluginResultEntries
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_plugin_result_entrys_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_plugin_result_entrys_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_plugin_result_entrys_with_http_info(self, **kwargs):  # noqa: E501
        """list_plugin_result_entrys  # noqa: E501

        API endpoint that allows PluginResultsEntrys to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_plugin_result_entrys_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :return: PluginResultEntries
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['limit', 'offset']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_plugin_result_entrys" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']   # noqa: E501

        return self.api_client.call_api(
            '/api/v1/processing/pluginresultentrys/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PluginResultEntries',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_plugin_results(self, **kwargs):  # noqa: E501
        """list_plugin_results  # noqa: E501

        API endpoint that allows PluginResultss to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_plugin_results(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :return: PluginResults
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_plugin_results_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_plugin_results_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_plugin_results_with_http_info(self, **kwargs):  # noqa: E501
        """list_plugin_results  # noqa: E501

        API endpoint that allows PluginResultss to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_plugin_results_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :return: PluginResults
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['limit', 'offset']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_plugin_results" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']   # noqa: E501

        return self.api_client.call_api(
            '/api/v1/processing/pluginresults/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PluginResults',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def destroy_plugin(self, id, **kwargs):  # noqa: E501
        """destroy_plugin  # noqa: E501

        API endpoint that allows Plugins to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.destroy_plugin(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: A unique integer value identifying this plugin. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.destroy_plugin_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.destroy_plugin_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def destroy_plugin_with_http_info(self, id, **kwargs):  # noqa: E501
        """destroy_plugin  # noqa: E501

        API endpoint that allows Plugins to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.destroy_plugin_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: A unique integer value identifying this plugin. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method destroy_plugin" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `destroy_plugin`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']   # noqa: E501

        return self.api_client.call_api(
            '/api/v1/processing/plugins/{id}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def destroy_plugin_job(self, id, **kwargs):  # noqa: E501
        """destroy_plugin_job  # noqa: E501

        API endpoint that allows PluginJobs to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.destroy_plugin_job(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: A unique integer value identifying this plugin job. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.destroy_plugin_job_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.destroy_plugin_job_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def destroy_plugin_job_with_http_info(self, id, **kwargs):  # noqa: E501
        """destroy_plugin_job  # noqa: E501

        API endpoint that allows PluginJobs to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.destroy_plugin_job_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: A unique integer value identifying this plugin job. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method destroy_plugin_job" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `destroy_plugin_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']   # noqa: E501

        return self.api_client.call_api(
            '/api/v1/processing/pluginjobs/{id}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def destroy_plugin_result(self, id, **kwargs):  # noqa: E501
        """destroy_plugin_result  # noqa: E501

        API endpoint that allows PluginResultss to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.destroy_plugin_result(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.destroy_plugin_result_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.destroy_plugin_result_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def destroy_plugin_result_with_http_info(self, id, **kwargs):  # noqa: E501
        """destroy_plugin_result  # noqa: E501

        API endpoint that allows PluginResultss to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.destroy_plugin_result_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method destroy_plugin_result" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `destroy_plugin_result`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']   # noqa: E501

        return self.api_client.call_api(
            '/api/v1/processing/pluginresults/{id}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def destroy_plugin_result_annotation(self, id, **kwargs):  # noqa: E501
        """destroy_plugin_result_annotation  # noqa: E501

        API endpoint that allows PluginResultAnnotations to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.destroy_plugin_result_annotation(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: A unique integer value identifying this plugin result annotation. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.destroy_plugin_result_annotation_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.destroy_plugin_result_annotation_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def destroy_plugin_result_annotation_with_http_info(self, id, **kwargs):  # noqa: E501
        """destroy_plugin_result_annotation  # noqa: E501

        API endpoint that allows PluginResultAnnotations to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.destroy_plugin_result_annotation_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: A unique integer value identifying this plugin result annotation. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method destroy_plugin_result_annotation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `destroy_plugin_result_annotation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']   # noqa: E501

        return self.api_client.call_api(
            '/api/v1/processing/pluginresultannotations/{id}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def destroy_plugin_result_bitmap(self, id, **kwargs):  # noqa: E501
        """destroy_plugin_result_bitmap  # noqa: E501

        API endpoint that allows PluginResultBitmaps to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.destroy_plugin_result_bitmap(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: A unique integer value identifying this plugin result bitmap. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.destroy_plugin_result_bitmap_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.destroy_plugin_result_bitmap_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def destroy_plugin_result_bitmap_with_http_info(self, id, **kwargs):  # noqa: E501
        """destroy_plugin_result_bitmap  # noqa: E501

        API endpoint that allows PluginResultBitmaps to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.destroy_plugin_result_bitmap_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: A unique integer value identifying this plugin result bitmap. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method destroy_plugin_result_bitmap" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `destroy_plugin_result_bitmap`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']   # noqa: E501

        return self.api_client.call_api(
            '/api/v1/processing/pluginresultbitmaps/{id}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def destroy_plugin_result_entry(self, id, **kwargs):  # noqa: E501
        """destroy_plugin_result_entry  # noqa: E501

        API endpoint that allows PluginResultsEntrys to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.destroy_plugin_result_entry(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: A unique integer value identifying this plugin result entry. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.destroy_plugin_result_entry_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.destroy_plugin_result_entry_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def destroy_plugin_result_entry_with_http_info(self, id, **kwargs):  # noqa: E501
        """destroy_plugin_result_entry  # noqa: E501

        API endpoint that allows PluginResultsEntrys to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.destroy_plugin_result_entry_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: A unique integer value identifying this plugin result entry. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method destroy_plugin_result_entry" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `destroy_plugin_result_entry`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']   # noqa: E501

        return self.api_client.call_api(
            '/api/v1/processing/pluginresultentrys/{id}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_plugin(self, id, **kwargs):  # noqa: E501
        """update_plugin  # noqa: E501

        API endpoint that allows Plugins to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_plugin(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: A unique integer value identifying this plugin. (required)
        :param Plugin body:
        :return: Plugin
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_plugin_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_plugin_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def update_plugin_with_http_info(self, id, **kwargs):  # noqa: E501
        """update_plugin  # noqa: E501

        API endpoint that allows Plugins to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_plugin_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: A unique integer value identifying this plugin. (required)
        :param Plugin body:
        :return: Plugin
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_plugin" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_plugin`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']   # noqa: E501

        return self.api_client.call_api(
            '/api/v1/processing/plugins/{id}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Plugin',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_plugin_job(self, id, **kwargs):  # noqa: E501
        """update_plugin_job  # noqa: E501

        API endpoint that allows PluginJobs to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_plugin_job(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: A unique integer value identifying this plugin job. (required)
        :param PluginJob body:
        :return: PluginJob
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_plugin_job_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_plugin_job_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def update_plugin_job_with_http_info(self, id, **kwargs):  # noqa: E501
        """update_plugin_job  # noqa: E501

        API endpoint that allows PluginJobs to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_plugin_job_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: A unique integer value identifying this plugin job. (required)
        :param PluginJob body:
        :return: PluginJob
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_plugin_job" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_plugin_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
 

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']   # noqa: E501

        return self.api_client.call_api(
            '/api/v1/processing/pluginjobs/{id}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PluginJob',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_plugin_result(self, id, **kwargs):  # noqa: E501
        """update_plugin_result  # noqa: E501

        API endpoint that allows PluginResultss to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_plugin_result(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :param PluginResult body:
        :return: PluginResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_plugin_result_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_plugin_result_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def update_plugin_result_with_http_info(self, id, **kwargs):  # noqa: E501
        """update_plugin_result  # noqa: E501

        API endpoint that allows PluginResultss to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_plugin_result_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :param PluginResult body:
        :return: PluginResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_plugin_result" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_plugin_result`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']   # noqa: E501

        return self.api_client.call_api(
            '/api/v1/processing/pluginresults/{id}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PluginResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_plugin_result_annotation(self, id, **kwargs):  # noqa: E501
        """update_plugin_result_annotation  # noqa: E501

        API endpoint that allows PluginResultAnnotations to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_plugin_result_annotation(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: A unique integer value identifying this plugin result annotation. (required)
        :param PluginResultAnnotation body:
        :return: PluginResultAnnotation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_plugin_result_annotation_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_plugin_result_annotation_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def update_plugin_result_annotation_with_http_info(self, id, **kwargs):  # noqa: E501
        """update_plugin_result_annotation  # noqa: E501

        API endpoint that allows PluginResultAnnotations to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_plugin_result_annotation_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: A unique integer value identifying this plugin result annotation. (required)
        :param PluginResultAnnotation body:
        :return: PluginResultAnnotation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_plugin_result_annotation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_plugin_result_annotation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
 
        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']   # noqa: E501

        return self.api_client.call_api(
            '/api/v1/processing/pluginresultannotations/{id}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PluginResultAnnotation',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
    def update_plugin_result_bitmap(self, id, **kwargs):  # noqa: E501
        """update_plugin_result_bitmap  # noqa: E501

        API endpoint that allows PluginResultBitmaps to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_plugin_result_bitmap(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: A unique integer value identifying this plugin result bitmap. (required)
        :param int id2:
        :param str bitmap2:
        :param int channels2:
        :param float default_alpha2:
        :param float default_threshold2:
        :param object meta_data2:
        :param str name2:
        :param float scale_max2:
        :param float scale_min2:
        :param object transformation_matrix2:
        :param int pluginresultentry2:
        :param int image2:
        :param int id2:
        :param str bitmap:
        :param int channels:
        :param float default_alpha:
        :param float default_threshold:
        :param object meta_data:
        :param str name:
        :param float scale_max:
        :param float scale_min:
        :param object transformation_matrix:
        :param int pluginresultentry:
        :param int image:
        :return: PluginResultBitmap
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_plugin_result_bitmap_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_plugin_result_bitmap_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def update_plugin_result_bitmap_with_http_info(self, id, **kwargs):  # noqa: E501
        """update_plugin_result_bitmap  # noqa: E501

        API endpoint that allows PluginResultBitmaps to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_plugin_result_bitmap_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: A unique integer value identifying this plugin result bitmap. (required)
        :param int id2:
        :param str bitmap2:
        :param int channels2:
        :param float default_alpha2:
        :param float default_threshold2:
        :param object meta_data2:
        :param str name2:
        :param float scale_max2:
        :param float scale_min2:
        :param object transformation_matrix2:
        :param int pluginresultentry2:
        :param int image2:
        :param int id2:
        :param str bitmap:
        :param int channels:
        :param float default_alpha:
        :param float default_threshold:
        :param object meta_data:
        :param str name:
        :param float scale_max:
        :param float scale_min:
        :param object transformation_matrix:
        :param int pluginresultentry:
        :param int image:
        :return: PluginResultBitmap
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'id2', 'bitmap2', 'channels2', 'default_alpha2', 'default_threshold2', 'meta_data2', 'name2', 'scale_max2', 'scale_min2', 'transformation_matrix2', 'pluginresultentry2', 'image2', 'id2', 'bitmap', 'channels', 'default_alpha', 'default_threshold', 'meta_data', 'name', 'scale_max', 'scale_min', 'transformation_matrix', 'pluginresultentry', 'image']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_plugin_result_bitmap" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_plugin_result_bitmap`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}


        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']   # noqa: E501

        return self.api_client.call_api(
            '/api/v1/processing/pluginresultbitmaps/{id}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PluginResultBitmap',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_plugin_result_entry(self, id, **kwargs):  # noqa: E501
        """update_plugin_result_entry  # noqa: E501

        API endpoint that allows PluginResultsEntrys to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_plugin_result_entry(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: A unique integer value identifying this plugin result entry. (required)
        :param PluginResultEntry body:
        :return: PluginResultEntry
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_plugin_result_entry_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_plugin_result_entry_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def update_plugin_result_entry_with_http_info(self, id, **kwargs):  # noqa: E501
        """update_plugin_result_entry  # noqa: E501

        API endpoint that allows PluginResultsEntrys to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_plugin_result_entry_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: A unique integer value identifying this plugin result entry. (required)
        :param PluginResultEntry body:
        :return: PluginResultEntry
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_plugin_result_entry" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_plugin_result_entry`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}


        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/processing/pluginresultentrys/{id}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PluginResultEntry',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def retrieve_plugin(self, id, **kwargs):  # noqa: E501
        """retrieve_plugin  # noqa: E501

        API endpoint that allows Plugins to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.retrieve_plugin(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: A unique integer value identifying this plugin. (required)
        :return: Plugin
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.retrieve_plugin_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.retrieve_plugin_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def retrieve_plugin_with_http_info(self, id, **kwargs):  # noqa: E501
        """retrieve_plugin  # noqa: E501

        API endpoint that allows Plugins to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.retrieve_plugin_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: A unique integer value identifying this plugin. (required)
        :return: Plugin
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method retrieve_plugin" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `retrieve_plugin`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/processing/plugins/{id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Plugin',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def retrieve_plugin_job(self, id, **kwargs):  # noqa: E501
        """retrieve_plugin_job  # noqa: E501

        API endpoint that allows PluginJobs to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.retrieve_plugin_job(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: A unique integer value identifying this plugin job. (required)
        :return: PluginJob
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.retrieve_plugin_job_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.retrieve_plugin_job_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def retrieve_plugin_job_with_http_info(self, id, **kwargs):  # noqa: E501
        """retrieve_plugin_job  # noqa: E501

        API endpoint that allows PluginJobs to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.retrieve_plugin_job_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: A unique integer value identifying this plugin job. (required)
        :return: PluginJob
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method retrieve_plugin_job" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `retrieve_plugin_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/processing/pluginjobs/{id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PluginJob',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def retrieve_plugin_result(self, id, **kwargs):  # noqa: E501
        """retrieve_plugin_result  # noqa: E501

        API endpoint that allows PluginResultss to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.retrieve_plugin_result(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :return: PluginResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.retrieve_plugin_result_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.retrieve_plugin_result_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def retrieve_plugin_result_with_http_info(self, id, **kwargs):  # noqa: E501
        """retrieve_plugin_result  # noqa: E501

        API endpoint that allows PluginResultss to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.retrieve_plugin_result_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :return: PluginResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method retrieve_plugin_result" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `retrieve_plugin_result`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/processing/pluginresults/{id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PluginResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def retrieve_plugin_result_annotation(self, id, **kwargs):  # noqa: E501
        """retrieve_plugin_result_annotation  # noqa: E501

        API endpoint that allows PluginResultAnnotations to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.retrieve_plugin_result_annotation(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: A unique integer value identifying this plugin result annotation. (required)
        :return: PluginResultAnnotation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.retrieve_plugin_result_annotation_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.retrieve_plugin_result_annotation_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def retrieve_plugin_result_annotation_with_http_info(self, id, **kwargs):  # noqa: E501
        """retrieve_plugin_result_annotation  # noqa: E501

        API endpoint that allows PluginResultAnnotations to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.retrieve_plugin_result_annotation_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: A unique integer value identifying this plugin result annotation. (required)
        :return: PluginResultAnnotation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method retrieve_plugin_result_annotation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `retrieve_plugin_result_annotation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/processing/pluginresultannotations/{id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PluginResultAnnotation',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def retrieve_plugin_result_bitmap(self, id, **kwargs):  # noqa: E501
        """retrieve_plugin_result_bitmap  # noqa: E501

        API endpoint that allows PluginResultBitmaps to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.retrieve_plugin_result_bitmap(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: A unique integer value identifying this plugin result bitmap. (required)
        :return: PluginResultBitmap
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.retrieve_plugin_result_bitmap_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.retrieve_plugin_result_bitmap_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def retrieve_plugin_result_bitmap_with_http_info(self, id, **kwargs):  # noqa: E501
        """retrieve_plugin_result_bitmap  # noqa: E501

        API endpoint that allows PluginResultBitmaps to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.retrieve_plugin_result_bitmap_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: A unique integer value identifying this plugin result bitmap. (required)
        :return: PluginResultBitmap
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method retrieve_plugin_result_bitmap" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `retrieve_plugin_result_bitmap`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/processing/pluginresultbitmaps/{id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PluginResultBitmap',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def retrieve_plugin_result_entry(self, id, **kwargs):  # noqa: E501
        """retrieve_plugin_result_entry  # noqa: E501

        API endpoint that allows PluginResultsEntrys to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.retrieve_plugin_result_entry(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: A unique integer value identifying this plugin result entry. (required)
        :return: PluginResultEntry
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.retrieve_plugin_result_entry_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.retrieve_plugin_result_entry_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def retrieve_plugin_result_entry_with_http_info(self, id, **kwargs):  # noqa: E501
        """retrieve_plugin_result_entry  # noqa: E501

        API endpoint that allows PluginResultsEntrys to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.retrieve_plugin_result_entry_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: A unique integer value identifying this plugin result entry. (required)
        :return: PluginResultEntry
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method retrieve_plugin_result_entry" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `retrieve_plugin_result_entry`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/processing/pluginresultentrys/{id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PluginResultEntry',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
