# bootstrap-index

1. The aim of this package is to produce indexes of dataset used for Walk Forward Optimization.
2. Walk Forward Analysis optimizes on a training set; test on a period after the set and then rolls it all forward and repeats the process. There are multiple out-of-sample periods and the combined results can be analyzed.
3. To facilitate Walk Forward Analysis, the package produces start and end of block bootstrap indexes within each training set data chunk.
4. Block bootstrap indexes basically represents continuous chunks of time series indexes that are sampled with replacement within a training set data chunk. You may optimize your parameters within each of these block bootstrapped data chunks and averaged them to be tested on testing dataset. 
5. There is a 'window' argument that allows you to divide the data through a sliding or expanding window. See <a href="https://stackoverflow.com/questions/59854723/backtesting-which-is-better-sliding-window-or-expanding-window#:~:text=When%20you%20come%20up%20to,the%20Expanding%20Window%20form%20better.">here</a> for further explanations on sliding and expanding window.

## Set up

- pip install bootstrapindex
- required packages: pandas, numpy, random, io, requests

## Project homepage

- https://github.com/jironghuang/bootstrap-index

## Examples

### Initiating class

```
import pandas as pd
import numpy as np
import random
import io
import requests
from bootstrapindex import bootstrapindex

url="https://github.com/jironghuang/trend_following/raw/main/quantopian_data/futures_incl_2016.csv"
s=requests.get(url).content
data=pd.read_csv(io.StringIO(s.decode('utf-8')))    
data['Date'] = pd.to_datetime(data['Date'], format='%Y-%m-%d')
data.set_index('Date', inplace=True)    

bootstrap = bootstrapindex(data, window='sliding', #expanding
                            num_samples_per_period=10, 
                            min_sample_size=300, 
                            prop_block_bootstrap=0.25, 
                            days_block=252, 
                            starting_index = 5
                            )   
```
### Creating in-sample and out-of-sample index

```
import pandas as pd
import numpy as np
import random
import io
import requests
from bootstrapindex import bootstrapindex

url="https://github.com/jironghuang/trend_following/raw/main/quantopian_data/futures_incl_2016.csv"
s=requests.get(url).content
data=pd.read_csv(io.StringIO(s.decode('utf-8')))    
data['Date'] = pd.to_datetime(data['Date'], format='%Y-%m-%d')
data.set_index('Date', inplace=True)           
bootstrap = bootstrapindex(data, window='sliding', 
                            num_samples_per_period=10, 
                            min_sample_size=300, 
                            prop_block_bootstrap=0.25, 
                            days_block=252, 
                            starting_index = 5
                            )        
bootstrap = bootstrap_index(data)
bootstrap.create_window_index()
Out[93]: 
[[[5, 256], [257, 508]],
 [[257, 508], [509, 760]],
 [[509, 760], [761, 1012]],   
...             
```

### Producing block boostrap indexes from a data chunk

```
import pandas as pd
import numpy as np
import random
import io
import requests
from bootstrapindex import bootstrapindex

url="https://github.com/jironghuang/trend_following/raw/main/quantopian_data/futures_incl_2016.csv"
s=requests.get(url).content
data=pd.read_csv(io.StringIO(s.decode('utf-8')))    
data['Date'] = pd.to_datetime(data['Date'], format='%Y-%m-%d')
data.set_index('Date', inplace=True)       
bootstrap = bootstrapindex(data, window='sliding', 
                            num_samples_per_period=10, 
                            min_sample_size=300, 
                            prop_block_bootstrap=0.25, 
                            days_block=252, 
                            starting_index = 5
                            )        
bootstrap.extract_block_bootstrap_periods(sample_size = 100, start_sample_index = 50, end_sample_index = 500)
Out[143]: 
{'start_index': array([247, 118,  78, 171, 170, 368, 343, 215, 166, 287]),
 'end_index': array([372, 243, 203, 296, 295, 493, 468, 340, 291, 412])}  
```


### Producing block boostrap indexes from all training set data chunks for sliding window

```
import pandas as pd
import numpy as np
import random
import io
import requests
from bootstrapindex import bootstrapindex

url="https://github.com/jironghuang/trend_following/raw/main/quantopian_data/futures_incl_2016.csv"
s=requests.get(url).content
data=pd.read_csv(io.StringIO(s.decode('utf-8')))    
data['Date'] = pd.to_datetime(data['Date'], format='%Y-%m-%d')
data.set_index('Date', inplace=True)    

bootstrap = bootstrapindex(data, window='sliding', 
                            num_samples_per_period=10, 
                            min_sample_size=60, 
                            prop_block_bootstrap=0.25, 
                            days_block=252, 
                            starting_index = 5
                            )
bootstrap.create_dictionary_window_n_bootstrap_index()
bootstrap.expanding_windows_w_bootstrap_info   
{1: {'in_sample_index': [5, 256],
  'out_sample_index': [257, 508],
  'bootstrap_index': {'start_index': array([103,  39,  19,  65,  65, 164, 151,  87,  63, 123]),
   'end_index': array([166, 102,  82, 128, 128, 227, 214, 150, 126, 186])}},
 2: {'in_sample_index': [257, 508],
  'out_sample_index': [509, 760],
  'bootstrap_index': {'start_index': array([355, 291, 271, 317, 317, 416, 403, 339, 315, 375]),
   'end_index': array([418, 354, 334, 380, 380, 479, 466, 402, 378, 438])}},
 3: {'in_sample_index': [509, 760],
  'out_sample_index': [761, 1012],
  'bootstrap_index': {'start_index': array([607, 543, 523, 569, 569, 668, 655, 591, 567, 627]),
   'end_index': array([670, 606, 586, 632, 632, 731, 718, 654, 630, 690])}},
 4: {'in_sample_index': [761, 1012],
  'out_sample_index': [1013, 1264],
  'bootstrap_index': {'start_index': array([859, 795, 775, 821, 821, 920, 907, 843, 819, 879]),    
...
```

### Producing block boostrap indexes from all training set data chunks for expanding window

```
import pandas as pd
import numpy as np
import random
import io
import requests
from bootstrapindex import bootstrapindex

url="https://github.com/jironghuang/trend_following/raw/main/quantopian_data/futures_incl_2016.csv"
s=requests.get(url).content
data=pd.read_csv(io.StringIO(s.decode('utf-8')))    
data['Date'] = pd.to_datetime(data['Date'], format='%Y-%m-%d')
data.set_index('Date', inplace=True)    

bootstrap = bootstrapindex(data, window='expanding', 
                            num_samples_per_period=10, 
                            min_sample_size=60, 
                            prop_block_bootstrap=0.25, 
                            days_block=252, 
                            starting_index = 5
                            )
bootstrap.create_dictionary_window_n_bootstrap_index()
bootstrap.expanding_windows_w_bootstrap_info   
{1: {'in_sample_index': [5, 256],
  'out_sample_index': [257, 508],
  'bootstrap_index': {'start_index': array([103,  39,  19,  65,  65, 164, 151,  87,  63, 123]),
   'end_index': array([166, 102,  82, 128, 128, 227, 214, 150, 126, 186])}},
 2: {'in_sample_index': [5, 508],
  'out_sample_index': [509, 760],
  'bootstrap_index': {'start_index': array([202,  73,  33, 126, 125, 323, 298, 170, 121, 242]),
   'end_index': array([328, 199, 159, 252, 251, 449, 424, 296, 247, 368])}},
 3: {'in_sample_index': [5, 760],
  'out_sample_index': [761, 1012],
  'bootstrap_index': {'start_index': array([399, 142,  62, 248, 246, 266,  87, 336, 237, 479]),
   'end_index': array([588, 331, 251, 437, 435, 455, 276, 525, 426, 668])}},
 4: {'in_sample_index': [5, 1012],
  'out_sample_index': [1013, 1264],
  'bootstrap_index': {'start_index': array([399, 142,  62, 248, 246, 642, 592, 336, 237, 479]),
...
```
