# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class ScimError(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        ScimError - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'status': 'str',
            'scim_type': 'str',
            'detail': 'str',
            'schemas': 'list[str]'
        }

        self.attribute_map = {
            'status': 'status',
            'scim_type': 'scimType',
            'detail': 'detail',
            'schemas': 'schemas'
        }

        self._status = None
        self._scim_type = None
        self._detail = None
        self._schemas = None

    @property
    def status(self):
        """
        Gets the status of this ScimError.
        The HTTP status code returned for the SCIM error.

        :return: The status of this ScimError.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this ScimError.
        The HTTP status code returned for the SCIM error.

        :param status: The status of this ScimError.
        :type: str
        """
        
        self._status = status

    @property
    def scim_type(self):
        """
        Gets the scim_type of this ScimError.
        The type of SCIM error when httpStatus is a \"400\" error.

        :return: The scim_type of this ScimError.
        :rtype: str
        """
        return self._scim_type

    @scim_type.setter
    def scim_type(self, scim_type):
        """
        Sets the scim_type of this ScimError.
        The type of SCIM error when httpStatus is a \"400\" error.

        :param scim_type: The scim_type of this ScimError.
        :type: str
        """
        allowed_values = ["invalidFilter", "tooMany", "uniqueness", "mutability", "invalidSyntax", "invalidPath", "noTarget", "invalidValue", "invalidVers", "sensitive"]
        if scim_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for scim_type -> " + scim_type)
            self._scim_type = "outdated_sdk_version"
        else:
            self._scim_type = scim_type

    @property
    def detail(self):
        """
        Gets the detail of this ScimError.
        The detailed description of the SCIM error.

        :return: The detail of this ScimError.
        :rtype: str
        """
        return self._detail

    @detail.setter
    def detail(self, detail):
        """
        Sets the detail of this ScimError.
        The detailed description of the SCIM error.

        :param detail: The detail of this ScimError.
        :type: str
        """
        
        self._detail = detail

    @property
    def schemas(self):
        """
        Gets the schemas of this ScimError.
        The list of schemas for the SCIM error.

        :return: The schemas of this ScimError.
        :rtype: list[str]
        """
        return self._schemas

    @schemas.setter
    def schemas(self, schemas):
        """
        Sets the schemas of this ScimError.
        The list of schemas for the SCIM error.

        :param schemas: The schemas of this ScimError.
        :type: list[str]
        """
        
        self._schemas = schemas

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

