"""

A realm process specialization.

For further information goto http://wordpress.es-doc.org/cmip6-model-specializations.
"""
# --------------------------------------------------------------------
# INTERNAL (do not change)
# --------------------------------------------------------------------
from collections import OrderedDict

DETAILS = OrderedDict()
ENUMERATIONS = OrderedDict()

# --------------------------------------------------------------------
# DESCRIPTION: Short description of the specialization.
# --------------------------------------------------------------------
DESCRIPTION = 'Characteristics of the parameterised gravity waves in the atmosphere, ' \
              'whether from orography or other sources'

# --------------------------------------------------------------------
# PROCESS: top level properties
# --------------------------------------------------------------------
DETAILS['toplevel'] = {
    'description': "General attributes of the gravity wave parameterisation",
    'properties': [
        ('sponge_layer', 'ENUM:sponge_layer_attributes', '1.1',
            'Sponge layer in the upper levels in order to avoid gravity wave reflection at the top.'),
        ('background', 'ENUM:background_attributes', '1.1',
            'Background wave distribution'),
        ('subgrid_scale_orography', 'ENUM:subgrid_scale_orography_attributes', '1.N',
            'Subgrid scale orography effects taken into account.'),
        ]
    }

# --------------------------------------------------------------------
# SUB-PROCESS: orographic_gravity_waves
# --------------------------------------------------------------------
DETAILS['orographic_gravity_waves'] = {
    'description': 'Gravity waves generated due to the presence of orography',
    'properties': [
        ('name', 'str', '0.1',
            'Commonly used name for the orographic gravity wave scheme'),
        ('source_mechanisms', 'ENUM:orographic_gravity_wave_source_mechanisms', '1.N',
            'Orographic gravity wave source mechanisms'),
        ('calculation_method', 'ENUM:orographic_gravity_wave_calculation_method', '1.N',
            'Orographic gravity wave calculation method'),
        ('propagation_scheme', 'ENUM:orographic_gravity_wave_propagation_scheme', '1.1',
            'Orographic gravity wave propogation scheme'),
        ('dissipation_scheme', 'ENUM:orographic_gravity_wave_dissipation_scheme', '1.1',
            'Orographic gravity wave dissipation scheme'),
        ]
    }


# --------------------------------------------------------------------
# SUB-PROCESS: non_orographic_gravity_waves
# --------------------------------------------------------------------
DETAILS['non_orographic_gravity_waves'] = {
    'description': 'Gravity waves generated by non-orographic processes.',
    'properties': [
        ('name', 'str', '0.1',
            'Commonly used name for the non-orographic gravity wave scheme'),
        ('source_mechanisms', 'ENUM:non_orographic_gravity_wave_source_mechanisms', '1.N',
            'Non-orographic gravity wave source mechanisms'),
        ('calculation_method', 'ENUM:non_orographic_gravity_wave_calculation_method', '1.N',
            'Non-orographic gravity wave calculation method'),
        ('propagation_scheme', 'ENUM:non_orographic_gravity_wave_propagation_scheme', '1.1',
            'Non-orographic gravity wave propogation scheme'),
        ('dissipation_scheme', 'ENUM:non_orographic_gravity_wave_dissipation_scheme', '1.1',
            'Non-orographic gravity wave dissipation scheme'),
        ]
    }

# --------------------------------------------------------------------
# PROCESS: ENUMERATIONS
# --------------------------------------------------------------------

ENUMERATIONS['sponge_layer_attributes'] = {
    'description': 'Gravity waves sponge layer attributes',
    'is_open': True,
    'members': [
        ('Rayleigh friction', None),
        ('Diffusive sponge layer', None)
        ]
    }

ENUMERATIONS['background_attributes'] = {
    'description': 'Gravity waves background attributes',
    'is_open': True,
    'members': [
        ('continuous spectrum', None),
        ('discrete spectrum', None),
        ]
    }

ENUMERATIONS['subgrid_scale_orography_attributes'] = {
    'description': 'Gravity waves subgrid scale orography attributes',
    'is_open': True,
    'members': [
        ('effect on drag', None),
        ('effect on lifting', None),
        ('enhanced topography', 'To enhance the generation of long waves in the atmosphere'),
        ]
    }

ENUMERATIONS['orographic_gravity_wave_source_mechanisms'] = {
    'description': 'Physical mechanisms generating orographic gravity waves.',
    'is_open': True,
    'members': [
        ('linear mountain waves', None),
        ('hydraulic jump', None),
        ('envelope orography', None),
        ('low level flow blocking', None),
        ('statistical sub-grid scale variance', None),
        ]
    }

ENUMERATIONS['orographic_gravity_wave_calculation_method'] = {
    'description': 'Calculation method for orographic gravity waves.',
    'is_open': True,
    'members': [
        ('non-linear calculation', None),
        ('more than two cardinal directions', None),
        ]
    }

ENUMERATIONS['orographic_gravity_wave_propagation_scheme'] = {
    'description': 'Type of propagation scheme for orgraphic gravity waves',
    'is_open': True,
    'members': [
        ('linear theory', None),
        ('non-linear theory', None),
        ('includes boundary layer ducting', None),
        ]
    }

ENUMERATIONS['orographic_gravity_wave_dissipation_scheme'] = {
    'description': 'Type of dissipation scheme for orographic gravity waves.',
    'is_open': True,
    'members': [
        ('total wave', None),
        ('single wave', None),
        ('spectral', None),
        ('linear', None),
        ('wave saturation vs Richardson number', None),
        ]
    }

ENUMERATIONS['non_orographic_gravity_wave_source_mechanisms'] = {
    'description': 'Physical mechanisms generating non-orographic gravity waves',
    'is_open': True,
    'members': [
        ('convection', None),
        ('precipitation', None),
        ('background spectrum', None),
        ]
    }

ENUMERATIONS['non_orographic_gravity_wave_calculation_method'] = {
    'description': 'Calculation method for non-orographic gravity waves',
    'is_open': False,
    'members': [
        ('spatially dependent', None),
        ('temporally dependent', None),
        ]
    }

ENUMERATIONS['non_orographic_gravity_wave_propagation_scheme'] = {
    'description': 'Type of propagation scheme for non-orographic gravity waves.',
    'is_open': True,
    'members': [
        ('linear theory', None),
        ('non-linear theory', None),
        ]
    }

ENUMERATIONS['non_orographic_gravity_wave_dissipation_scheme'] = {
    'description': 'Type of dissipation scheme for non-orographic gravity waves.',
    'is_open': True,
    'members': [
        ('total wave', None),
        ('single wave', None),
        ('spectral', None),
        ('linear', None),
        ('wave saturation vs Richardson number', None),
        ]
    }
