/*! 
* DevExtreme (Web Widgets)
* Version: 14.1.7
* Build date: Sep 22, 2014
*
* Copyright (c) 2012 - 2014 Developer Express Inc. ALL RIGHTS RESERVED
* EULA: https://www.devexpress.com/Support/EULAs/DevExtreme.xml
*/
"use strict";if(!DevExpress.MOD_WIDGETS_WEB){if(!DevExpress.MOD_WIDGETS_BASE)throw Error("Required module is not referenced: widgets-base");(function(n,t,i){var e=t.ui,r=t.utils,o=e.events,l=t.Class,u=4,a="dx-pager",s="dx-page",v="dx-pages",h="dx-selection",y="dx-separator",p="dx-page-sizes",c="dx-page-size",f=l.inherit({ctor:function(t,i){var r=this;r.index=i,r.element=n("<div />").text(t).addClass(s)},value:function(n){var i=this,t;if(r.isDefined(n))i.element.text(n);else return t=i.element.text(),r.isNumber(t)?parseInt(t):t},select:function(n){this.element.toggleClass(h,n)},render:function(n,t){t?this.element.prependTo(n):this.element.appendTo(n)}});t.registerComponent("dxPager",t.DOMComponent.inherit({NAMESPACE:e,_setDefaultOptions:function(){this.callBase(),this.option({visible:!0,pageIndex:1,maxPagesCount:10,pagesCount:10,pageSize:5,showPageSizes:!0,pageSizes:[5,10],hasKnownLastPage:!0,pageIndexChanged:n.noop,pageSizeChanged:n.noop})},_toggleVisibility:function(n){var t=this._element();t&&t.css("display",n?"":"none")},_getPages:function(n,t){var r=[],e=!this.option("hasKnownLastPage"),o,i;if(t>1||e)if(t<=this.option("maxPagesCount")){for(i=1;i<=t;i++)r.push(new f(i,i-1));e&&r.push(new f(">",i-1))}else{for(r.push(new f(1,0)),o=n?n.value()-n.index:1,i=1;i<=u;i++)r.push(new f(o+i,i));r.push(new f(t,u+1)),e&&r.push(new f(">",u+1))}return r},_getPageByValue:function(n){for(var r=this,i,t=0;t<r._pages.length;t++)if(i=r._pages[t],i.value()===n)return i},_processSelectedPage:function(t,i,e){var o=this,s=!1,h;o._pages&&(n.each(o._pages,function(n,t){i===t.value()&&(s=!0)}),s||(o.selectedPage=null)),r.isDefined(o.selectedPage)?i===e&&e>t&&o.selectedPage.index!==u+1&&(o.selectedPage.index=u+1):i>u&&i<e&&(h=e-u<i?u-(e-i)+1:2,o.selectedPage=new f(i,h))},_selectPageByValue:function(n){var u=this,f,t=u._getPageByValue(n),h=u._pages,o=h.length,s,e,c;if(r.isDefined(t)){if(s=u._pages[t.index-1],e=u._pages[t.index+1],e&&e.value()===">"&&(c=e,e=i,o--,h.pop()),u.selectedPage&&u.selectedPage.select(!1),t.select(!0),u.selectedPage=t,e&&e.value()-n>1)if(t.index!==0)for(s.value(n+1),u._pages.splice(t.index,1),u._pages.splice(t.index-1,0,t),u._pages[t.index].index=t.index,t.index=t.index-1,f=t.index-1;f>0;f--)u._pages[f].value(u._pages[f+1].value()-1);else for(f=0;f<o-1;f++)u._pages[f].value(f+1);if(s&&n-s.value()>1)if(t.index!==o-1)for(e.value(n-1),u._pages.splice(t.index,1),u._pages.splice(t.index+1,0,t),u._pages[t.index].index=t.index,t.index=t.index+1,f=t.index+1;f<o-1;f++)u._pages[f].value(u._pages[f-1].value()+1);else for(f=1;f<=o-2;f++)u._pages[o-1-f].value(u._pages[o-1].value()-f);c&&h.push(c)}},_renderPagesChooser:function(){var t=this,u,h=t.option("pageIndexChanged"),i,e=t._element(),f;if(e){if(t._clickPagesIndexAction=t._createAction(function(i){var f=i.jQueryEvent,r=n(f.target).text(),u=r===">"?t.option("pagesCount")+1:Number(r);t.option("pageIndex",u),h(u)}),r.isDefined(t.pagesChooserElement)?t.pagesChooserElement.empty():t.pagesChooserElement=n("<div />").addClass(v).on(o.addNamespace("dxclick",t.Name+"Pages"),"."+s,function(n){t._clickPagesIndexAction({jQueryEvent:n})}),t._pages.length===0){t.selectedPage=null;return}for(i=0;i<t._pages.length;i++)u=t._pages[i],u.render(t.pagesChooserElement,t.option("rtlEnabled")),t._pages[i+1]&&t._pages[i+1].value()-u.value()>1&&(f=n("<div>. . .<\/div>").addClass(y).attr("style","-webkit-user-select: none"),t.option("rtlEnabled")?f.prependTo(t.pagesChooserElement):f.appendTo(t.pagesChooserElement));r.isDefined(t.pagesChooserElement[0].parentElement)||t.pagesChooserElement.appendTo(e)}},_renderPagesSizeChooser:function(){var t=this,i,u,a=t.option("pageSize"),f=t.option("pageSizes"),v=t.option("showPageSizes"),y=t.option("pageSizeChanged"),e,s=f&&f.length,l=t._element();if(l&&(t._clickPagesSizeAction=t._createAction(function(i){var r=i.jQueryEvent;e=parseInt(n(r.target).text()),t.option("pageSize",e),y(e)}),r.isDefined(t.pagesSizeChooserElement)?t.pagesSizeChooserElement.empty():t.pagesSizeChooserElement=n("<div />").addClass(p).on(o.addNamespace("dxclick",t.Name+"PageSize"),"."+c,function(n){t._clickPagesSizeAction({jQueryEvent:n})}),v&&s)){for(i=0;i<s;i++)u=n("<div />").text(f[i]).addClass(c),a===f[i]&&u.addClass(h),t.option("rtlEnabled")?t.pagesSizeChooserElement.prepend(u):t.pagesSizeChooserElement.append(u);r.isDefined(t.pagesSizeChooserElement[0].parentElement)||t.pagesSizeChooserElement.appendTo(l)}},_render:function(){this._update(),this._element().addClass(a),this._toggleVisibility(this.option("visible")),this._renderPagesSizeChooser(),this._renderPagesChooser()},_update:function(){var n=this.option("pagesCount"),t=this.option("pageIndex");this._processSelectedPage(this.option("maxPagesCount"),t,n),this._pages=this._getPages(this.selectedPage,n),this._selectPageByValue(t)},_optionChanged:function(n,t){switch(n){case"visible":this._toggleVisibility(t);break;case"pageIndex":case"maxPagesCount":case"pagesCount":case"hasKnownLastPage":this._update(),this._renderPagesChooser();break;case"pageSize":case"pageSizes":this._renderPagesSizeChooser();break;default:this._invalidate()}},getHeight:function(){return this.option("visible")?this._element().outerHeight():0}}))})(jQuery,DevExpress),function(n,t){var o=t.ui,f=o.events,ei=t.utils,a="dx-color-picker",v="dx-color-picker-input-container",y="dx-color-picker-input",p="dx-color-picker-color-result-preview",w="dx-color-picker-overlay",b="dx-color-picker-without-alpha-channel",k="dx-color-picker-container",u="dx-color-picker-container-row",d="dx-color-picker-container-cell",g="dx-color-picker-palette",s="dx-color-picker-palette-gradient",nt="dx-white",tt="dx-black",it="dx-color-picker-hue-scale",rt="dx-color-picker-hue-scale-handle",h="dx-hue-scale-wrapper",ut="dx-color-picker-controls-container",ft="dx-color-picker-buttons-container",et="dx-color-picker-apply-button",ot="dx-color-picker-cancel-button",st="dx-color-picker-color-chooser",ht="dx-color-picker-red-label",ct="dx-color-picker-green-label",lt="dx-color-picker-blue-label",at="dx-color-picker-hex-label",vt="dx-color-picker-red-input",yt="dx-color-picker-green-input",pt="dx-color-picker-blue-input",wt="dx-color-picker-hex-input",bt="dx-color-picker-alpha-scale-wrapper",kt="dx-color-picker-alpha-scale",dt="dx-color-picker-alpha-input",gt="dx-color-picker-alpha-label",ni="dx-color-picker-alpha-handle",c="dx-alpha-channel-cell",ti="dx-alpha-channel-border",ii="dx-color-picker-color-preview-container",ri="dx-color-picker-color-preview-container-inner",l="dx-color-preview",ui="dx-current-color",fi="dx-new-color",r,e;n.fn.colorPickerDrag=function(t){return this.each(function(i,r){var p=function(){var n,i,r,u,f=a-c,e=v-h;return t.enableStripHalfOfWidth?(i=0,n=a):(i=c,n=f),t.enableStripHalfOfHeight?(u=0,r=v):(u=h,r=e),{x:{min:i,max:n},y:{min:u,max:r}}},e=n(r),o=e.parent(),a=o.outerWidth(),v=o.outerHeight(),w=e.height(),b=e.width(),s=!1,h=w/2,c=b/2,u=p(),k={enableVerticalMotion:!0,enableHorizontalMotion:!0,moveByClick:!0,enableStripHalfOfWidth:!1,enableStripHalfOfHeight:!1,verticalMotionCallback:n.noop,horizontalMotionCallback:n.noop,_coordinatesUpdater:n.noop},l,y;t=n.extend(!0,k,t),l=function(n){var i=t._coordinatesUpdater(n).x,r=t._coordinatesUpdater(n).y;y(i,r)},y=function(n,i){t.enableVerticalMotion&&(i<u.y.min&&(i=u.y.min),i>u.y.max&&(i=u.y.max),e.css("top",i-h),t.verticalMotionCallback(i)),t.enableHorizontalMotion&&(n<u.x.min&&(n=u.x.min),n>u.x.max&&(n=u.x.max),e.css("right","auto"),e.css("left",n-c),t.horizontalMotionCallback(n))},t._coordinatesUpdater||(t._coordinatesUpdater=function(n){return{x:n.pageX-o.offset().left,y:n.pageY-o.offset().top}});e.on(f.addNamespace("dxpointerdown","dxColorPicker"),function(){s=!0});n("*").on(f.addNamespace("dxpointerup","dxColorPicker"),function(){s=!1});n("body").on(f.addNamespace("dxpointermove","dxColorPicker"),function(n){s&&(n.preventDefault(),n.stopPropagation(),l(n))});if(t.moveByClick)o.on(f.addNamespace("dxpointerdown","dxColorPicker"),function(n){s=!0,l(n)})})},r={createElement:function(i,r,u){var e=document.createElement(i),f=n(e);return t.utils.isArray(r)&&(r=r.join(" ")),r&&f.addClass(r),u?f.appendTo(u):f},createHtmlRows:function(n){for(var i=[],t=0;t<n;t++)i.push(this.createElement("div",u));return i},createHtmlCellInsideRow:function(n,i,r){var f,o=i.find("."+u),e;return t.utils.isNumber(n)?f=o.eq(n):t.utils.isString(n)&&(f=o[n]()),e=this.createElement("div",d,f),r&&e.addClass(r),e},createInputWithLabel:function(n,t,i){return this.createElement("label",t).text(n+":").append(this.createElement("input",i))}},e={makeCSSLinearGradient:function(n){var t=this._currentColor,i=[t.r,t.g,t.b].join(","),r=t.toHex().replace("#",""),u=function(n,t){var u=this.option("rtlEnabled"),i="rgba("+n+", "+(u?"1":"0")+")",r="rgba("+n+", "+(u?"0":"1")+")",f="'#"+(u?"00":"")+t+"'",e="'#"+(u?"":"00")+t+"'";return["background-image: -webkit-linear-gradient(180deg, "+i+", "+r+")","background-image: -moz-linear-gradient(-90deg, "+i+", "+r+")","background-image: -ms-linear-gradient(-90deg, "+i+", "+r+")","background-image: -o-linear-gradient(-90deg, "+i+", "+r+")","background-image: linear-gradient(-90deg, "+i+", "+r+")","filter: progid:DXImageTransform.Microsoft.gradient(GradientType=1,startColorstr="+f+", endColorstr="+e+")","-ms-filter: progid:DXImageTransform.Microsoft.gradient(GradientType=1,startColorstr="+f+", endColorstr="+e+")"].join(";")};n.attr("style",u.call(this,i,r))}},t.registerComponent("dxColorPicker",o.dxDropDownEditor.inherit({_setDefaultOptions:function(){this.callBase(),this.option({_dragCoordinatesUpdater:null,_standAlone:!1,value:"#000000",editAlphaChannel:!1,applyButtonText:Globalize.localize("OK"),cancelButtonText:Globalize.localize("Cancel")})},_setCurrentColor:function(n){var i=new t.Color(n);i.colorIsInvalid?this.option("value",this._currentColor.baseColor):(this._currentColor=new t.Color(n),this._alpha=this._currentColor.a)},_initColorAndOpacity:function(){this._setCurrentColor(this.option("value"))},_init:function(){this.callBase(),this._initColorAndOpacity()},_render:function(){this.callBase(),this._element().addClass(a),this.option("_standAlone")&&(this._element().addClass("dx-standalone-colorpicker"),this._element().find(".dx-dropdowneditor-button").trigger("dxclick"))},_optionChanged:function(n,t){switch(n){case"value":this._input().val(t),this._setCurrentColor(t),this._makeTransparentBackground(this._$colorResultPreview),this.callBase.apply(this,arguments);break;case"applyButtonText":this._$applyButton.dxButton("instance").option("text",t);break;case"cancelButtonText":this._$cancelButton.dxButton("instance").option("text",t);break;case"editAlphaChannel":this._$colorPickerContainer&&(this._renderHtmlRows(),this._toggleContainerClass(),this._renderAlphaChannelElements());break;default:this.callBase.apply(this,arguments)}},_handleValueChangeEvent:function(n){this._dropDownVisible()&&(this._setCurrentColor(this._input().val()),this._refreshDropDown()),this.callBase(n)},_makeRgba:function(){return"rgba("+[this._currentColor.r,this._currentColor.g,this._currentColor.b,this._alpha].join(", ")+")"},_makeTransparentBackground:function(n){t.browser.msie&&t.browser.version==="8.0"?n.css({background:this._currentColor.toHex(),filter:"progid:DXImageTransform.Microsoft.Alpha(Opacity="+this._alpha*100+")"}):n.css("backgroundColor",this._makeRgba())},_renderInput:function(){this._$colorPickerInputContainer=n("<div/>").addClass(v),this._$colorResultPreview=r.createElement("div",p,this._$colorPickerInputContainer),this._makeTransparentBackground(this._$colorResultPreview),this.callBase(this._$colorPickerInputContainer),this._input().addClass(y)},_renderValue:function(){this.callBase(this.option("editAlphaChannel")?this._makeRgba():this.option("value"))},_closeOutsideDropDownHandler:function(n){this.callBase(n,!0)},_hideOnBlur:function(){return!1},_createDropDown:function(){var n=this;this.callBase({height:"",width:"",contentReadyAction:function(){n._createColorPickerContainer()}})},_showDropDown:function(){this._dropDownVisible()||(this.callBase(),this._refreshDropDown())},_hideDropDown:function(){this._dropDownVisible()&&(this._initColorAndOpacity(),this.callBase())},_calculateRowsCount:function(){var n=this.option("editAlphaChannel")?3:2,t=this._$colorPickerContainer.find("."+u);return this.option("editAlphaChannel")&&t.length===2&&(n=1),this.option("editAlphaChannel")||t.length!==3||(n=0),n},_renderHtmlRows:function(){var i=this._$colorPickerContainer.find("."+u),n=this._calculateRowsCount(i),t;n?(t=r.createHtmlRows(n),n===1?this._$colorPickerContainer.find("."+u).eq(0).after(t):this._$colorPickerContainer.append(t)):i.eq(1).remove()},_toggleContainerClass:function(){this._$colorPickerContainer.toggleClass(b,!this.option("editAlphaChannel"))},_renderAlphaChannelElements:function(){this.option("editAlphaChannel")&&(this._renderAlphaChannelScale(),this._renderAlphaChannelInput())},_createColorPickerContainer:function(){var n=this._dropDown.content();this.option("_standAlone")?(this._dropDown.hide(),n=this._element()):this._dropDown.content().addClass(w),this._$colorPickerContainer=r.createElement("div",k,n),this._renderHtmlRows(),this._toggleContainerClass(),this._createPalette(),this._renderHueScale(),this._renderControlsContainer(),this._renderControls(),this._renderAlphaChannelElements(),this._renderButtons()},_createPalette:function(){var n=r.createHtmlCellInsideRow("first",this._$colorPickerContainer,"dx-palette-cell"),t=r.createElement("div",[s,nt]),i=r.createElement("div",[s,tt]);this._$palette=r.createElement("div",g,n).css("backgroundColor",this._currentColor.getPureColor().toHex()),this._createColorChooser(),this._$palette.append([t,i])},_updateColor:function(n){var i,r;n?r=this._validateHex("#"+this._$hexInput.val()):(i=this._validateRgb(),this._$alphaChannelInput?(i.push(this._$alphaChannelInput.val()),r="rgba("+i.join(", ")+")"):r="rgb("+i.join(", ")+")"),this._currentColor=new t.Color(r),this._refreshDropDown()},_refreshDropDown:function(){this._placeHueMarker(),this._placeColorChooser(),this._updateColorParamsAndColorPreview(),this._$palette.css("backgroundColor",this._currentColor.getPureColor().toHex()),this._$alphaChannelHandle&&(this._updateColorTransparence(this._currentColor.a),this._placeAlphaChannelHandle())},_validateHex:function(n){return this._currentColor.isValidHex(n)?n:this._currentColor.toHex()},_validateRgb:function(){var n=Number(this._$rgbInputs[0].val()),t=Number(this._$rgbInputs[1].val()),i=Number(this._$rgbInputs[2].val());return this._currentColor.isValidRGB(n,t,i)||(n=this._currentColor.r,t=this._currentColor.g,i=this._currentColor.b),[n,t,i]},_placeHueMarker:function(){var t=this._$hueScale.parent().outerHeight(),i=this._$hueScaleHandle.height(),n=t-t*this._currentColor.hsv.h/360-i/2;t<n+i&&(n=t-i),n<0&&(n=0),this._$hueScaleHandle.css("top",Math.round(n))},_updateColorSaturation:function(n){var t=this._currentColor.hsv.h,i=Math.round(n*100/this._$palette.width()),n=this._currentColor.hsv.v;this._updateColorFromHsv(t,i,n)},_updateColorValue:function(n){var t=this._currentColor.hsv.h,i=this._currentColor.hsv.s,n=100-Math.round(n*100/this._$palette.height());this._updateColorFromHsv(t,i,n)},_updateColorHue:function(n){var t=360-Math.round((n+this._$hueScaleHandle.outerHeight()/2)*360/this._$hueScale.height()),i=this._currentColor.hsv.s,n=this._currentColor.hsv.v;t=t<0?0:t,this._updateColorFromHsv(t,i,n),this._$palette.css("backgroundColor",this._currentColor.getPureColor().toHex())},_updateColorTransparence:function(n){this._$alphaChannelInput.val(n),this._alpha=n,this._makeTransparentBackground(this._$newColor)},_calculateColorTransparenceByScaleWidth:function(n){var r=this._$alphaChannelHandle.width()/2,u=this._$alphaChannelScale.width(),i=this.option("rtlEnabled"),t=n/this._$alphaChannelScale.width();t=i?t:1-t,r===n?t=i?0:1:n>=u-r?t=i?1:0:t<1&&(t=t.toFixed(2)),this._updateColorTransparence(t)},_updateColorFromHsv:function(n,i,r){this._currentColor=new t.Color("hsv("+[n,i,r].join(",")+")"),this._updateColorParamsAndColorPreview()},_updateColorParamsAndColorPreview:function(){this._$hexInput.val(this._currentColor.toHex().replace("#","")),this._$rgbInputs[0].val(this._currentColor.r),this._$rgbInputs[1].val(this._currentColor.g),this._$rgbInputs[2].val(this._currentColor.b),this._makeTransparentBackground(this._$newColor),this.option("editAlphaChannel")&&e.makeCSSLinearGradient.call(this,this._$alphaChannelScale)},_createColorChooser:function(){this._$colorChooser=r.createElement("div",st,this._$palette).colorPickerDrag({verticalMotionCallback:n.proxy(this._updateColorValue,this),horizontalMotionCallback:n.proxy(this._updateColorSaturation,this),enableStripHalfOfWidth:!0,enableStripHalfOfHeight:!0,_coordinatesUpdater:this.option("_dragCoordinatesUpdater")}),this._placeColorChooser()},_placeColorChooser:function(){var n=this._$palette.height(),t={x:Math.round(this._$palette.width()*this._currentColor.hsv.s/100-this._$colorChooser.width()/2),y:Math.round(n-n*this._currentColor.hsv.v/100-this._$colorChooser.height()/2)};this._$colorChooser.css({left:t.x,top:t.y})},_renderHueScale:function(){var n=r.createHtmlCellInsideRow("first",this._$colorPickerContainer,"dx-hue-scale-cell");this._$hueScale=r.createElement("div",it,n),this._$hueScale.wrap('<div class="'+h+'"/>'),this._renderHueScaleHandle()},_renderHueScaleHandle:function(){this._$hueScaleHandle=r.createElement("div",rt,this._$hueScale.closest("."+h)).colorPickerDrag({enableHorizontalMotion:!1,verticalMotionCallback:n.proxy(this._updateColorHue,this),_coordinatesUpdater:this.option("_dragCoordinatesUpdater")}),this._placeHueMarker()},_renderControlsContainer:function(){var n=r.createHtmlCellInsideRow("first",this._$colorPickerContainer);this._$controlsContainer=r.createElement("div",ut,n)},_renderControls:function(){this._renderColorsPreview(),this._renderRgbInputs(),this._renderHexInput()},_renderButtons:function(){var n=r.createHtmlCellInsideRow("last",this._$colorPickerContainer,"dx-buttons-cell");this._$buttonContainer=r.createElement("div",ft,n),this._renderApplyButton(),this._renderCancelButton()},_renderApplyButton:function(){this._$applyButton=r.createElement("div",et,this._$buttonContainer).dxButton({text:this.option("applyButtonText"),clickAction:n.proxy(this._applyColor,this)})},_applyColor:function(){var n=this.option("editAlphaChannel")?this._makeRgba():this._currentColor.toHex();this._input().val(n),this._makeTransparentBackground(this._$colorResultPreview),this._makeTransparentBackground(this._$currentColor),this.option("value",n),this._hideDropDown()},_cancelChanges:function(){this.option("_standAlone")?(this._initColorAndOpacity(),this._refreshDropDown()):this._hideDropDown()},_renderCancelButton:function(){this._$cancelButton=r.createElement("div",ot,this._$buttonContainer).dxButton({text:this.option("cancelButtonText"),clickAction:n.proxy(this._cancelChanges,this)})},_renderRgbInputs:function(){this._$rgbInputsWithLabels=[r.createInputWithLabel("R",ht,vt),r.createInputWithLabel("G",ct,yt),r.createInputWithLabel("B",lt,pt)],this._$rgbInputs=[this._$rgbInputsWithLabels[0].find("input").val(this._currentColor.r).on("change",n.proxy(this._updateColor,this,!1)),this._$rgbInputsWithLabels[1].find("input").val(this._currentColor.g).on("change",n.proxy(this._updateColor,this,!1)),this._$rgbInputsWithLabels[2].find("input").val(this._currentColor.b).on("change",n.proxy(this._updateColor,this,!1))],this._$controlsContainer.append(this._$rgbInputsWithLabels)},_renderHexInput:function(){var t=r.createInputWithLabel("#",at,wt).appendTo(this._$controlsContainer);this._$hexInput=t.find("input").val(this._currentColor.toHex().replace("#","")).on("change",n.proxy(this._updateColor,this,!0))},_renderColorsPreview:function(){var n=r.createElement("div",ii,this._$controlsContainer),t=r.createElement("div",ri,n);this._$currentColor=r.createElement("div",[l,ui]),this._$newColor=r.createElement("div",[l,fi]),this._makeTransparentBackground(this._$currentColor),this._makeTransparentBackground(this._$newColor),t.append([this._$currentColor,this._$newColor])},_renderAlphaChannelScale:function(){var n=r.createHtmlCellInsideRow(1,this._$colorPickerContainer,c),t=r.createElement("div",ti,n),i=r.createElement("div",bt,t);this._$alphaChannelScale=r.createElement("div",kt,i),e.makeCSSLinearGradient.call(this,this._$alphaChannelScale),this._renderAlphaChannelHandle(n)},_renderAlphaChannelInput:function(){var t=this,i=r.createHtmlCellInsideRow(1,this._$colorPickerContainer),u=r.createInputWithLabel("Alpha",gt,dt).appendTo(i);this._$alphaChannelInput=u.find("input").val(this._alpha).on("change",function(){var i=Number(n(this).val());i=t._currentColor.isValidAlpha(i)?i:t._alpha,t._updateColorTransparence(i),t._placeAlphaChannelHandle()})},_renderAlphaChannelHandle:function(t){this._$alphaChannelHandle=r.createElement("div",ni,t).colorPickerDrag({enableVerticalMotion:!1,horizontalMotionCallback:n.proxy(this._calculateColorTransparenceByScaleWidth,this),_coordinatesUpdater:this.option("_dragCoordinatesUpdater")}),this._placeAlphaChannelHandle()},_placeAlphaChannelHandle:function(){var t=this._$alphaChannelScale.closest("."+c).outerWidth(),i=this._$alphaChannelHandle.width(),n=t-t*this._alpha-i/2;n<0&&(n=0),t<n+i&&(n=t-i),this._$alphaChannelHandle.css(this.option("rtlEnabled")?"right":"left",n)}}))}(jQuery,DevExpress),function(n,t,i){var u=t.ui,f=t.utils,e=u.events,o="dx-menu",r=o+"-item",a="dx-state-hover",v=r+"-text",s=r+"-popout",y=s+"-container",p=r+"-disabled",h=r+"-selected",c=r+"-wrapper",w=o+"-rtl",l="dx-icon",b=u.CollectionContainerWidget.inherit({_itemRenderDefault:function(t,r,u){var e,o;f.isDefined(t)&&(t.visible===i||t.visible||u.hide(),t.disabled&&u.addClass(p),o=!!this.option("rtlEnabled"),o&&u.addClass(w),e=n("<div>").addClass("dx-menu-item-content").appendTo(u),this._renderImage(t,e),this._renderCaption(t,e),this._renderPopout(t,e))},_renderImage:function(t,i){var r,u;t.icon?r=n("<span>").addClass(l+"-"+t.icon).appendTo(i):t.iconSrc&&(r=n("<img>").attr("src",t.iconSrc).appendTo(i)),r&&r.addClass(l)},_renderPopout:function(t,i){var u,r;this._hasChildren(t)&&(r=n("<span>").addClass(y).appendTo(i),u=n("<div>").addClass(s).appendTo(r))},_renderCaption:function(t,i){var r;r=n("<span>").addClass(v),n.isPlainObject(t)?t.text&&r.text(t.text):r.html(String(t)),i.append(r)},_renderItemHotTrack:function(n,t){var i,r;(r=n.data(this._itemDataKey()),r==this.option("selectedItem")&&t)||!this.option("hoverStateEnabled")||(i=n.parents("."+c).eq(0),i.length&&i.toggleClass(a,t))},_itemDataKey:function(){return"dxMenuItemDataKey"},_itemClass:function(){return r},_itemWrapperSelector:function(){return"."+c},_attachItemHoverEvents:function(){var t=this._itemWrapperSelector(),i,r,u=this._createAction(n.proxy(function(n){this._handleItemMouseEnter(n.jQueryEvent)},this)),f=this._createAction(n.proxy(function(n){this._handleItemMouseLeave(n.jQueryEvent)},this));i=e.addNamespace("mouseenter",this.NAME),r=e.addNamespace("mouseleave",this.NAME);this._itemContainer().off(i,t).on(i,t,n.proxy(function(n){u({jQueryEvent:n})},this));this._itemContainer().off(r,t).on(r,t,n.proxy(function(n){f({jQueryEvent:n})},this))},_handleItemMouseMove:function(n){var t=this,i=t._getItemElementByEventArgs(n);t._itemX||(t._itemX=0),t._itemY||(t._itemY=0),(Math.abs(event.pageX-t._itemX)>4||Math.abs(event.pageY-t._itemY)>4)&&(t._itemX=event.pageX,t._itemY=event.pageY,t._handleItemMouseMoveCore(i))},_hasChildren:function(n){return n.items&&n.items.length>0},_addCustomCssClass:function(t){var i=n.trim(this.option("cssClass"));i&&t.addClass(i)},_init:function(){var n=this.option("items");(this.callBase(),this.selectedItem=this.option("selectedItem"),this.enableSelection=this.option("allowSelection"),f.isDefined(this.selectedItem)&&this.selectedItem!=null)||(this.selectedItem=this._getLastSelectedItem(n),this.selectedItem&&this._setOptionInternal("selectedItem",this.selectedItem))},_setOptionInternal:function(n,t){this._optionChangedInternalFlag=!0,this.option(n,t),this._optionChangedInternalFlag=!1},_getLastSelectedItem:function(t){var u=this,i=null,r;return n.each(t,function(n,t){t&&(t.selected&&t.selectable&&(i=t),f.isArray(t.items)&&(r=u._getLastSelectedItem(t.items),r&&(i=r)))}),i},_updateSelectedItemOnClick:function(n,t){var r=this.$selectedItemWrapper?this.$selectedItemWrapper.children(".dx-menu-item").eq(0).data(this._itemDataKey()):null,i={selectedItem:t,previousSelectedItem:r,itemElement:n,itemData:t},u=this._createActionByOption("itemSelectAction",i);this.option("allowSelectOnClick")&&t.selectable&&(this.$selectedItemWrapper&&(this.$selectedItemWrapper.removeClass(h),this.$selectedItemWrapper.children(".dx-menu-item").eq(0).data(this._itemDataKey())&&(this.$selectedItemWrapper.children(".dx-menu-item").eq(0).data(this._itemDataKey()).selected=!1)),this._setOptionInternal("selectedItem",null),this.$selectedItemWrapper=n.parents(".dx-menu-item-wrapper").eq(0),this.$selectedItemWrapper.addClass(h),this._setOptionInternal("selectedItem",t),t.selected=!0,u(i))},_handleItemClick:function(t){var i=this._createAction(n.proxy(this._updateOverlayVisibilityOnClick,this));this._handleItemJQueryEvent(t,"itemClickAction",{},{afterExecute:n.proxy(i,this)})},_getItemElementByEventArgs:function(t){return n(t.currentTarget).children(this._itemSelector()).first()}});u.dxMenuBase=b}(jQuery,DevExpress),function(n,t,i){var o=t.ui,l=t.utils,r=o.events,s=t.fx,g="dxContextMenu",f="dx-menu",e=f+"-item",nt=e+"-popout",a=e+"-selected",u="dx-state-hover",v="dx-menu-phone-overlay",y=f+"-items-container",h=e+"-wrapper",p="dx-submenu",w="dxSubMenuLevel",c="dx-context-menu",b="dx-widget",k=f+"-separator",d=c+"-content-delimiter";t.registerComponent("dxContextMenu",o.dxMenuBase.inherit({_deprecatedOptions:{direction:{since:"14.1",message:"Use the 'submenuDirection' option instead."},allowSelectItem:{since:"14.1",message:"Use the 'allowSelection' option instead."}},_optionAliases:{direction:"submenuDirection",allowSelectItem:"allowSelection"},_setDefaultOptions:function(){this.callBase(),this.option({items:[],showSubmenuMode:"onHover",cssClass:"",invokeOnlyFromCode:!1,position:{at:"top left",my:"top left"},hoverStateEnabled:!0,allowSelection:!0,allowSelectItem:!0,allowSelectOnClick:!0,selectedItem:null,itemSelectAction:null,animation:{show:{type:"fade",from:0,to:1,duration:100},hide:{type:"fade",from:1,to:0,duration:100}},showingAction:null,shownAction:null,hidingAction:null,hiddenAction:null,positioningAction:null,submenuDirection:"auto",direction:"auto",visible:!1,target:window})},_optionsByReference:function(){return n.extend(this.callBase(),{animation:!0,position:!0,selectedItem:!0})},_itemContainer:function(){return this._overlay.content()},_clean:function(){this._overlay&&(this._overlay._element().remove(),this._overlay=null),this._target.off(r.addNamespace("dxhold",this.NAME)),this._target.off(r.addNamespace("contextmenu",this.NAME))},_optionChanged:function(n,t){if(!this._optionChangedInternalFlag)switch(n){case"visible":this._toggleVisibility(t);break;case"disable":break;case"invokeOnlyFromCode":break;case"items":this._overlay.option("visible")&&this._overlay.toggle(!1),this.selectedItem=this._getLastSelectedItem(t),this._setOptionInternal("selectedItem",this.selectedItem),this.callBase.apply(this,arguments);break;case"selectedItem":this.selectedItem=t;break;default:this._overlay.option("visible")&&this._overlay.toggle(!1),this.callBase.apply(this,arguments)}},_toggleVisibility:function(n){n?this.show():this.hide()},_render:function(){this._target=n(this.option("target")),this.option("position"),this.callBase()},_renderContentImpl:function(){this._renderContextMenuOverlay(),this._renderAdditionGraphicsElements(),this._attachItemHoverEvents(),this._attachShowContextMenuEvents(),this._addCustomCssClass(this._element()),this.callBase()},_renderDimensions:function(){},_renderContextMenuOverlay:function(){var i,t,r=this._getOverlayOptions();i=n("<div>").appendTo(this._$element),i.dxOverlay(r),this._overlay=i.dxOverlay("instance"),t=this._overlay.content(),t.addClass(c).addClass(b),this._addCustomCssClass(t),this._addPlatformDependentClass(t),this.option("visible")&&this.show()},_addPlatformDependentClass:function(n){t.devices.current().phone&&n.addClass(v)},_renderAdditionGraphicsElements:function(){this.option("showAdditionalElements")&&(this.$contentDelimiter=n("<div>").appendTo(this._itemContainer()),this.$contentDelimiter.addClass(d),this.$contentDelimiter.css("position","absolute").css("display","none").css("z-index","2000"))},_attachShowContextMenuEvents:function(){var t=this,i=r.addNamespace("dxhold",this.NAME),u=r.addNamespace("contextmenu",this.NAME),f=this._createAction(n.proxy(function(n){t.option("invokeOnlyFromCode")||n.jQueryEvent.originalEvent&&n.jQueryEvent.originalEvent.pointerType!=="mouse"&&t.show(n.jQueryEvent)},this)),e=this._createAction(n.proxy(function(n){t.option("invokeOnlyFromCode")||t.show(n.jQueryEvent)&&(n.jQueryEvent.preventDefault(),n.jQueryEvent.originalEvent&&(n.jQueryEvent.originalEvent.returnValue=!1))},this));this._target.off(i).on(i,n.proxy(function(n){f({jQueryEvent:n})},this));this._target.off(u).on(u,n.proxy(function(n){e({jQueryEvent:n})},this))},_renderItems:function(n){var t=1;this._renderSubMenu(n,this._itemContainer(),t)},_renderSubMenu:function(t,i,r){var u=this,e,f,o,s;e=n("<div>").appendTo(i),e.addClass(p),e.data(w,r),e.css("display",r===1?"block":"none"),f=n("<ul>").appendTo(e),f.addClass(y),r===1&&(u.option("width")&&f.css("min-width",u.option("width")),u.option("height")&&f.css("min-height",u.option("height"))),n.each(t,function(t,i){i&&(u._renderSeparator(i,t,f),o=n("<li>").appendTo(f),o.addClass(h),s=u._renderItem(t,i,o),u.enableSelection&&i===u.selectedItem&&(o.addClass(a),u.$selectedItemWrapper=o),u._hasChildren(i)&&u._renderSubMenu(i.items,s,++r))})},_renderSeparator:function(t,i,r){var u;t.beginGroup&&i>0&&(u=n("<li>").appendTo(r),u.addClass(k))},_showAdditionalGraphicsElements:function(){var r=this._itemContainer().children(".dx-submenu").eq(0),i=this.option("position").of,u=this.option("position").at,f=this.option("position").my,n={of:r};this.$contentDelimiter&&(this.$contentDelimiter.css("display","block"),u==="left bottom"&&f==="left top"||u==="right bottom"&&f==="right top"?(this.$contentDelimiter.width(i.width()<r.width()?i.width()-2:r.width()-2),this._itemContainer().offset().top>i.offset().top?(this.$contentDelimiter.height(2),Math.round(this._itemContainer().offset().left)<Math.round(i.offset().left)?(n.offset="-1 -1",n.at="right top",n.my="right top"):(n.offset="1 -1",n.at="left top",n.my="left top")):(this.$contentDelimiter.height(3),Math.round(this._itemContainer().offset().left)<Math.round(i.offset().left)?(n.offset="-1 2",n.at="right bottom",n.my="right bottom"):(n.offset="1 2",n.at="left bottom",n.my="left bottom"))):(this.$contentDelimiter.width(2),this.$contentDelimiter.height(i.height()<r.height()?i.height()-2:r.height()-2),this._itemContainer().offset().top<i.offset().top?(n.offset=u==="right top"?"-1 -1":"1 -1",n.at=u==="right top"?"left bottom":"right bottom",n.my=n.at):(n.offset=u==="right top"?"-1 1":"1 1",n.at=f,n.my=f)),t.position(this.$contentDelimiter,n))},_getOverlayOptions:function(){var t=this,i=this.option("animation");return{animation:i,closeOnOutsideClick:n.proxy(t._closeOnOutsideClickHandler,t),closeOnTargetScroll:!0,deferRendering:!1,disabled:this.option("disabled"),position:{at:this.option("position").at,my:this.option("position").my,of:this._target},shading:!1,showTitle:!1,height:"auto",width:"auto",rtlEnabled:this.option("rtlEnabled"),showingAction:n.proxy(t._overlayShowingActionHandler,t),shownAction:n.proxy(t._overlayShownActionHandler,t),hidingAction:n.proxy(t._overlayHidingActionHandler,t),hiddenAction:n.proxy(t._overlayHiddenActionHandler,t),positionedAction:n.proxy(t._overlayPositionedActionHandler,t)}},_removeHoverClass:function(){var t=this,i=t._overlay._$container.find(".dx-state-hover");n.each(i,function(t,i){n(i).removeClass(u)})},_searchActiveItem:function(t){return n(t.parentElement.parentElement).hasClass("dx-menu-item-content")?t.parentElement.parentElement.parentElement:n(t.parentElement).hasClass("dx-menu-item-content")?t.parentElement.parentElement:n(t).hasClass("dx-menu-item-content")?t.parentElement:i},_closeOnOutsideClickHandler:function(t){var f=this,h=f._overlay._$container.find(".dx-state-hover"),r=i,o=!1,c=n.extend([],f._shownSubMenus),s,e;return t.target===document?(this._removeHoverClass(),!0):(r=this._searchActiveItem(t.target),r!==i?(n.each(h,function(t,i){r.parentElement.parentElement===i.parentElement&&(o=!0),o&&r.parentElement!==i&&n(i).removeClass(u)}),this.option("showSubmenuMode")==="onclick"&&(s=n(r).find(".dx-submenu"),s.length>0&&n.each(c,function(t,i){e=f._searchActiveItem(i.context).parentElement,e.parentElement===n(r)[0].parentElement.parentElement&&e!==n(r)[0].parentElement&&f._hideChildrenSubMenus(i)})),!1):(this._removeHoverClass(),!0))},_overlayShowingActionHandler:function(n){var t=this._createActionByOption("showingAction",{});t(n)},_overlayShownActionHandler:function(n){var t=this._createActionByOption("shownAction",{});t(n)},_overlayHidingActionHandler:function(n){var t=this._createActionByOption("hidingAction",{});t(n),this._hideAllShownSubMenus()},_overlayHiddenActionHandler:function(n){var t=this._createActionByOption("hiddenAction",{});t(n),this._setOptionInternal("visible",!1)},_overlayPositionedActionHandler:function(){this._showAdditionalGraphicsElements()},_handleItemMouseEnter:function(t){var i=this,c=r.addNamespace("mousemove",i.NAME),f=i._getItemElementByEventArgs(t),l=f.children(".dx-submenu"),a=i.option("showSubmenuMode"),y=n.extend([],i._shownSubMenus),o,e,p=f.parents("."+h).eq(0),v,s;if((n.each(y,function(r,f){o=i._getItemElementByEventArgs(t),e=n(f.context),s=!1,f.context.parentElement===o[0].parentElement.parentElement&&f.context!==o[0].parentElement&&(v=i._overlay._$container.find(".dx-state-hover"),n.each(v,function(t,i){i.parentElement===e.context.parentElement&&(s=!0),s&&i.parentElement!==e.context.parentElement&&n(i).removeClass(u)}),i._hideChildrenSubMenus(f),e.removeClass(u))}),!f.data(this._itemDataKey()).disabled)&&(i._renderItemHotTrack(f,!0),this.option("showSubmenuMode")!=="onclick"&&l.length>0&&(i._showSubMenuGroup(l,f),p.addClass(u),a&&a.toLowerCase()==="onhoverstay")))f.off(c).on(c,function(n){i._handleItemMouseMove(n)})},_handleItemMouseLeave:function(n){var i=this,t=i._getItemElementByEventArgs(n),r=t.children(".dx-submenu");t.data(this._itemDataKey()).disabled||r.is(":visible")||i._renderItemHotTrack(t,!1)},_handleItemMouseMoveCore:function(n){var t=n.children(".dx-submenu");this._showSubMenuGroup(t,n)},_hideSubMenuGroup:function(n){var t=this;this._isSubMenuVisible(n)&&t._hideSubMenuCore(n)},_showSubMenuGroup:function(n,t,i){var r=this;(i||!this._isSubMenuVisible(n))&&r._showSubMenuCore(n,r._getSubMenuPosition(t))},_getSubMenuPosition:function(n){var f,i,r,t,u;r=!!this.option("rtlEnabled"),i=this.option("submenuDirection").toLowerCase(),u=n.parent(".dx-menu-item-wrapper"),t={collision:"flip",of:u,offset:{h:0,v:-1}};switch(i){case"left":t.at="left top",t.my="right top";break;case"right":t.at="right top",t.my="left top";break;default:r?(t.at="left top",t.my="right top"):(t.at="right top",t.my="left top")}return t},_isSubMenuVisible:function(n){return n.css("display")!=="none"},_animate:function(n,t){s.animate(n,t)},_stopAnimate:function(n){s.stop(n,!0)},_showSubMenuCore:function(t,i){var r=this.option("animation")?this.option("animation").show:{};this._overlay&&this._overlay.option("visible")&&(l.isDefined(this._shownSubMenus)||(this._shownSubMenus=[]),n.inArray(t,this._shownSubMenus)&&this._shownSubMenus.push(t),t.css("display","block"),DevExpress.position(t,i),this._stopAnimate(t),this._animate(t,r))},_hideSubMenuCore:function(t){var i=n.inArray(t,this._shownSubMenus),r=this.option("animation")?this.option("animation").hide:{};i>=0&&this._shownSubMenus.splice(i,1),this._stopAnimate(t),this._animate(t,r.hide),t.css("display","none")},_updateOverlayVisibilityOnClick:function(t){var i,r,u;if(t.args.length&&t.args[0]){if(t.args[0].jQueryEvent.stopPropagation(),i=t.args[0].itemElement,r=i.children(".dx-submenu"),i.context===r.context&&r.is(":visible"))return;if(!i.data(this._itemDataKey())||i.data(this._itemDataKey()).disabled)return;this._updateSelectedItemOnClick(i,t.args[0].itemData),r.length===0?(u=n(i.parents(".dx-submenu")[0]),this._hideChildrenSubMenus(u),!t.canceled&&this._overlay&&this._overlay.option("visible")&&this.option("visible",!1)):(this._shownSubMenus&&this._shownSubMenus.length>0&&(this._shownSubMenus[0].is(r)||this._shownSubMenus[0].has(r).length===1?this._hideChildrenSubMenus(r):this._hideAllShownSubMenus()),this._showSubMenuGroup(r,i))}},_hideChildrenSubMenus:function(t){var i=this,r=n.extend([],i._shownSubMenus);n.each(r,function(n,r){(t.is(r)||t.has(r).length)&&i._hideSubMenuCore(r)})},_hideAllShownSubMenus:function(){var t=this,i=n.extend([],t._shownSubMenus);n.each(i,function(n,i){t._hideSubMenuCore(i)})},show:function(n){var t=this.option("position"),i,r;return n&&n.preventDefault&&(t={at:"top left",my:"top left",of:n}),t.of||(t.of=this._target),i={position:t,jQueryEvent:n},r=this._createActionByOption("positioningAction",i),r(i),!i.canceled&&this._overlay&&(t&&(this._overlay.option("position",null),this._overlay.option("position",t)),this._overlay.toggle(!0),this._setOptionInternal("visible",!0)),this.option("visible")},hide:function(){this._overlay&&(this._overlay.toggle(!1),this._setOptionInternal("visible",!1))}}))}(jQuery,DevExpress),function(n,t,i){var o=t.ui,c=t.utils,u=o.events,b=t.fx,k="<div />",d="<ul />",g="dxMenu",nt=50,r="dx-menu",l=r+"-vertical",a=r+"-horizontal",f=r+"-item",v=f+"-selected",y=r+"-items-container",s=f+"-with-submenu",p=f+"-wrapper",h="dx-context-menu",w=r+"-separator",e=h+"-container-border";t.registerComponent("dxMenu",o.dxMenuBase.inherit({_deprecatedOptions:{firstSubMenuDirection:{since:"14.1",message:"Use the 'submenuDirection' option instead."},showPopupMode:{since:"14.1",message:"Use the 'showFirstSubmenuMode' option instead."},allowSelectItem:{since:"14.1",message:"Use the 'allowSelection' option instead."}},_optionAliases:{firstSubMenuDirection:"submenuDirection",showPopupMode:"showFirstSubmenuMode",allowSelectItem:"allowSelection"},_setDefaultOptions:function(){this.callBase(),this.option({orientation:"horizontal",submenuDirection:"auto",firstSubMenuDirection:"auto",showFirstSubmenuMode:"onclick",showPopupMode:"onclick",showSubmenuMode:"auto",items:[],hoverStateEnabled:!0,allowSelection:!0,allowSelectItem:!0,allowSelectOnClick:!0,selectedItem:null,cssClass:"",animation:{show:{type:"fade",from:0,to:1,duration:100},hide:{type:"fade",from:1,to:0,duration:100}},submenuShowingAction:null,submenuShownAction:null,submenuHidingAction:null,submenuHiddenAction:null,itemSelectAction:null})},_optionsByReference:function(){return n.extend(this.callBase(),{animation:!0,selectedItem:!0})},_render:function(){this.callBase(),this._element().addClass(r),this._addCustomCssClass(this._element()),this._attachItemHoverEvents()},_renderItems:function(t){var i=this,e,u,r,f,o,s,h;e=i.option("orientation")==="vertical",u=n("<div>").appendTo(i._element()),u.addClass(e?l:a),r=n("<ul>").appendTo(u),r.addClass(y),r.css("min-height",this._getValueHeight(u)),n.each(t,function(t,u){u&&(i._renderSeparator(u,t,r),f=n("<li>").appendTo(r),f.addClass(p),o=i._renderItem(t,u,f),i._renderSelectedItem(u,f),i._renderChildrenItems(u,o))})},_renderSeparator:function(t,i,r){var u;t.beginGroup&&i>0&&(u=n("<li>").appendTo(r),u.addClass(w))},_renderSelectedItem:function(n,t){this.option("allowSelection")&&n===this.selectedItem&&(t.addClass(v),this.$selectedItemWrapper=t)},_renderChildrenItems:function(n,t){this._hasChildren(n)&&(this._createPopupMenu(n.items,t,this.selectedItem).appendTo(t),this._renderBorderElement(t))},_renderBorderElement:function(t){var i=n("<div>").appendTo(t);i.addClass(e),i.css("display","none")},_getValueHeight:function(t){var i=n("<div>").html("Jj").css({width:"auto",position:"fixed",top:"-3000px",left:"-3000px"}).appendTo(t),r=i.height();return i.remove(),r},_handleItemMouseEnter:function(t){var i=this,h=300,e,r,f,o,s;if((r=i._getItemElementByEventArgs(t),!r.data(this._itemDataKey()).disabled)&&(i._renderItemHotTrack(r,!0),f=i._getPopupMenuByRootElement(r),o=i.option("showFirstSubmenuMode").toLowerCase(),o!=="onclick"&&f))if(clearTimeout(i._hidePopupMenuTimer),clearTimeout(i._showPopupMenuTimer),s=i.option("showFirstSubmenuMode")!=="onhover",s&&i.visiblePopupMenu==f&&!f._overlay.option("visible")){e=u.addNamespace("mousemove",i.NAME);r.off(e).on(e,n.proxy(i._handleItemMouseMove,i));i._showPopupMenuTimer=setTimeout(function(){i._showPopupMenu(f,r)},h)}else i._showPopupMenu(f,r)},_handleItemMouseLeave:function(n){var t=this,e=50,o=300,i,r,u,f;(u=t.option("showFirstSubmenuMode").toLowerCase(),f=t.option("showFirstSubmenuMode")!=="onhover"?o:e,i=t._getItemElementByEventArgs(n),i.data(this._itemDataKey()).disabled)||(t._renderItemHotTrack(i,!1),u!=="onclick"&&(clearTimeout(t._showPopupMenuTimer),clearTimeout(t._hidePopupMenuTimer),t._hidePopupMenuTimer=setTimeout(function(){r=t._getPopupMenuByRootElement(i),t._hidePopupMenu(r),t.visiblePopupMenu==r&&(t.visiblePopupMenu=null)},f)))},_handleItemMouseMoveCore:function(n){var t=this,r=300,i;t._showPopupMenuTimer&&(clearTimeout(t._hidePopupMenuTimer),clearTimeout(t._showPopupMenuTimer),i=t._getPopupMenuByRootElement(n),t._showPopupMenuTimer=setTimeout(function(){t._showPopupMenu(i,n)},r))},_updateOverlayVisibilityOnClick:function(n){var r=this,t,i;if(n.args.length&&n.args[0]){if(n.args[0].jQueryEvent.stopPropagation(),t=n.args[0].itemElement,t.data(this._itemDataKey()).disabled)return;i=r._getPopupMenuByRootElement(t),this._updateSelectedItemOnClick(t,n.args[0].itemData),i&&(i._overlay.option("visible")?r.option("showFirstSubmenuMode")==="onclick"&&r._hidePopupMenu(i):r._showPopupMenu(i,t))}},_createPopupMenu:function(t,i,r){var o=this,f,e=n("<div>"),a=n("<div>"),s,c,l;c=u.addNamespace("mouseenter",o.NAME+"_popupMenu"),l=u.addNamespace("mouseleave",o.NAME+"_popupMenu"),e.dxContextMenu({_templates:this.option("_templates"),target:a,items:t,position:o._getPopupMenuPosition(i),showAdditionalElements:!0,selectedItem:r,cssClass:this.option("cssClass"),animation:this.option("animation"),rtlEnabled:this.option("rtlEnabled"),disabled:this.option("disabled"),showSubmenuMode:this.option("showSubmenuMode")==="auto"?this.option("showFirstSubmenuMode"):this.option("showSubmenuMode"),itemSelectAction:n.proxy(this._nestedItemSelectActionHandler,this),itemClickAction:n.proxy(this._nestedItemClickActionHandler,this),showingAction:n.proxy(this._contextMenuShowingActionHandler,this,i,f),shownAction:n.proxy(this._contextMenuShownActionHandler,this,i,f),hidingAction:n.proxy(this._contextMenuHidingActionHandler,this,i,f),hiddenAction:n.proxy(this._contextMenuHiddenActionHandler,this,i,f)}),e.addClass(h),f=e.dxContextMenu("instance"),s=f._overlay.content();s.off(c).on(c,null,n.proxy(this._handlePopupMenuMouseEnter,this,i));s.off(l).on(l,null,n.proxy(this._handlePopupMenuMouseLeave,this,i));return e},_getPopupMenuPosition:function(n){var i,u,r,t;r=!!this.option("rtlEnabled"),i=this.option("orientation").toLowerCase()=="vertical",u=this.option("submenuDirection").toLowerCase(),t={collision:"flip",of:n};switch(u){case"leftOrTop":t.at=i?"left top":"left top",t.my=i?"right top":"left bottom";break;case"rightOrBottom":t.at=i?"right top":"left bottom",t.my=i?"left top":"left top";break;case"auto":default:i?(t.at=r?"left top":"right top",t.my=r?"right top":"left top"):(t.at=r?"right bottom":"left bottom",t.my=r?"right top":"left top")}return t},_nestedItemSelectActionHandler:function(n){this._updateSelectedItemOnClick(n.itemElement,n.itemData)},_nestedItemClickActionHandler:function(n){var t=this._createActionByOption("itemClickAction",{});t(n)},_contextMenuShowingActionHandler:function(n,r){var f,u,o;f=this._createActionByOption("submenuShowingAction",{}),f({rootItem:n,popupMenu:r}),u=n.children("."+e),this._options.width!==i&&(this._options.rtlEnabled?u.width(this._$element.width()-n.position().right):u.width(this._$element.width()-n.position().left)),u.css("display","block"),t.fx.stop(u,!0),o=this.option("animation")?this.option("animation").show:{},t.fx.animate(u,o),n.addClass(s)},_contextMenuShownActionHandler:function(n,t){var i=this._createActionByOption("submenuShownAction",{});i({rootItem:n,popupMenu:t})},_contextMenuHidingActionHandler:function(n,i){var u,r,f;u=this._createActionByOption("submenuHidingAction",{}),u({rootItem:n,popupMenu:i}),r=n.children("."+e),f=this.option("animation")?this.option("animation").hide:{},t.fx.animate(r,f),r.css("display","none"),n.removeClass(s)},_contextMenuHiddenActionHandler:function(n,t){var i=this._createActionByOption("submenuHiddenAction",{});i({rootItem:n,popupMenu:t})},_handlePopupMenuMouseEnter:function(n){this._hoveredPopupMenuContainer=n},_handlePopupMenuMouseLeave:function(n){var t=this,i,r=50;setTimeout(function(){t._hoveredPopupMenuContainer&&t._hoveredPopupMenuContainer.is(t._hoveredRootItem)||(i=t._getPopupMenuByRootElement(n),i&&i.hide()),t._hoveredPopupMenuContainer=null},r)},_showPopupMenu:function(n,t){c.isDefined(this.visiblePopupMenu)&&this.visiblePopupMenu!==n&&this.visiblePopupMenu.hide(),this._renderItemHotTrack(t,!1),n.show(),this.visiblePopupMenu=n,this._hoveredRootItem=t},_hidePopupMenu:function(n){this._hoveredRootItem&&this._hoveredRootItem.is(this._hoveredPopupMenuContainer)||n&&n.hide(),this._hoveredRootItem=null},_optionChanged:function(n,t){if(!this._optionChangedInternalFlag){this.visiblePopupMenu&&this.visiblePopupMenu.hide();switch(n){case"items":this.selectedItem=this._getLastSelectedItem(t),this._setOptionInternal("selectedItem",this.selectedItem),this.callBase.apply(this,arguments);break;case"selectedItem":this.selectedItem=t;break;default:this.callBase.apply(this,arguments)}}},_getPopupMenuByRootElement:function(n){var i=null,t;return n&&(t=n.children(".dx-context-menu"),t.length>0&&(i=t.dxContextMenu("instance"))),i},_containNode:function(t,i){var f=this,u=!1,r=!1;return n.each(t,function(n,t){t==i&&(r=!0),t.items&&(u=f._containNode(t.items,i),u?r=u:r)}),r}}))}(jQuery,DevExpress),function(n,t){var r=t.ui,s=t.utils,h=".dx-row",c=t.Class.inherit({ctor:function(t){var i=this;i.component=t,i.disposing=t.disposing,i._actions={},n.each(this.callbackNames()||[],function(t,r){var u=i.callbackFlags(r);i[this]=n.Callbacks(u)})},callbackNames:function(){},callbackFlags:function(){},publicMethods:function(){},init:function(){},option:function(){return this.component.option.apply(this.component,arguments)},optionChanged:function(){},getController:function(n){return this.component._controllers[n]},getView:function(n){return this.component._views[n]},createAction:function(t,i){var r;if(s.isFunction(t))return r=this.component._createAction(n.proxy(t,this),i),function(n){r({jQueryEvent:n})};this._actions[t]=this.option(t)?this.component._createActionByOption(t,i):null},executeAction:function(n,t){var i=this._actions[n];return i&&i(t)},dispose:function(){var t=this;n.each(t.callbackNames()||[],function(){t[this].empty()})}}),i=c,u=i,f=u.inherit({_element:function(){return this._$element},_renderCore:function(){},_afterRender:function(){},_parentElement:function(){return this._$parent},ctor:function(t){this.callBase(t),this.renderCompleted=n.Callbacks(),this.resizeCompleted=n.Callbacks()},isVisible:function(){return!0},getTemplate:function(n){return this.component._getTemplate(n)},render:function(t,i){var r=this._$element,u=this.isVisible();this._$parent=t,r||(r=this._$element=n("<div />").appendTo(t)),r.toggle(u),u&&(this._renderCore(i),this._afterRender(t),this.renderCompleted.fire())},resize:function(){this.isResizing=!0,this.resizeCompleted.fire(),this.isResizing=!1},focus:function(){this._element().focus()}}),e=function(t,r){var u={},e={},o;t._controllers={},t._views={},n.each(r,function(){var r=this.controllers,t=this.name,o=this.views;r&&n.each(r,function(n,r){if(u[n])throw'Module "'+t+'". Controller "'+n+'" is already registered';else if(!(r&&r.subclassOf&&r.subclassOf(i))){r.subclassOf(i);throw'Module "'+t+'". Controller "'+n+'" must be inheritor of DevExpress.ui.dataGrid.Controller';}u[n]=r}),o&&n.each(o,function(n,i){if(e[n])throw'Module "'+t+'". View "'+n+'" is already registered';else if(!(i&&i.subclassOf&&i.subclassOf(f)))throw'Module "'+t+'". View "'+n+'" must be inheritor of DevExpress.ui.dataGrid.View';e[n]=i})}),n.each(r,function(){var t=this.extenders;t&&(t.controllers&&n.each(t.controllers,function(n,t){u[n]&&(u[n]=u[n].inherit(t))}),t.views&&n.each(t.views,function(n,t){e[n]&&(e[n]=e[n].inherit(t))}))}),o=function(t,i,r){var u=r.publicMethods();u&&n.each(u,function(n,u){if(r[u])if(t[u])throw'Public method "'+u+'" is already registered';else t[u]=function(){return r[u].apply(r,arguments)};else throw'Public method "'+i+"."+u+'" is not exists';})},n.each(u,function(n,i){var r=new i(t);r.name=n,o(t,n,r),t._controllers[n]=r}),n.each(e,function(n,i){var r=new i(t);r.name=n,o(t,n,r),t._views[n]=r})},o=r.dataGrid={__internals:{},modules:[],View:f,ViewController:u,Controller:i,registerModule:function(n,t){for(var r=this.modules,i=0;i<r.length;i++)if(r[i].name===n)return;t.name=n,r.push(t)},unregisterModule:function(t){this.modules=n.grep(this.modules,function(n){return n.name!==t})},processModules:e};t.registerComponent("dxDataGrid",r.Widget.inherit(function(){return{_activeStateUnit:h,_deprecatedOptions:{"editing.texts.recoverRow":{since:"14.1",message:"Use the 'undeleteRow' option instead."}},_optionAliases:{"editing.texts.recoverRow":"editing.texts.undeleteRow"},_setDefaultOptions:function(){var t=this;t.callBase(),n.each(o.modules,function(){n.isFunction(this.defaultOptions)&&t.option(this.defaultOptions())})},_defaultOptionsRules:function(){return this.callBase().slice(0).concat([{device:[{platform:"ios"},{platform:"ios7"}],options:{showRowLines:!0}},{device:function(){return DevExpress.browser.webkit},options:{loadPanel:{animation:{show:{easing:"cubic-bezier(1, 0, 1, 0)",duration:500,from:{opacity:0},to:{opacity:1}}}}}},{device:function(){return t.devices.real().ios},options:{loadingTimeout:30}}])},_init:function(){var t=this;t.callBase(),e(t,o.modules),n.each(t._controllers,function(){this.init()}),n.each(t._views,function(){this.init()}),t._gridView=t._views.gridView},_clean:n.noop,_optionChanged:function(t,i,r){var u=this;u.callBase(t,i,r),n.each(u._controllers,function(){this.optionChanged(t,i,r)}),n.each(u._views,function(){this.optionChanged(t,i,r)})},_dimensionChanged:function(){this.resize()},_visibilityChanged:function(){this.resize()},_renderContentImpl:function(){var n=this;n._gridView.render(n._element())},_renderContent:function(){this._renderContentImpl()},_getTemplate:function(t){var u,r,i;return this.option("_templates")[t]||(i=n(t),i.length===1&&(r=this._templateProvider.getTemplateClass(),this.option("_templates")[t]=new r(i))),this.callBase(t)},_dispose:function(){var t=this;t.callBase(),n.each(t._controllers,function(){this.dispose()}),n.each(t._views,function(){this.dispose()})},beginUpdate:function(){var t=this;t.callBase(),t._controllers&&n.each(t._controllers,function(){this.beginUpdate&&this.beginUpdate()}),t._views&&n.each(t._views,function(){this.beginUpdate&&this.beginUpdate()})},endUpdate:function(){var t=this;t._controllers&&n.each(t._controllers,function(){this.endUpdate&&this.endUpdate()}),t._views&&n.each(t._views,function(){this.endUpdate&&this.endUpdate()}),t.callBase()},getController:function(n){return this._controllers[n]},getView:function(n){return this._views[n]},resize:function(){this._gridView.resize()}}}()))}(jQuery,DevExpress),function(n,t){var i=t.data.utils.normalizeSortingInfo;t.ui.dataGrid.GroupingHelperBase=t.Class.inherit(function(){var r=function(n,i){for(var r=0;r<n.length;r++)if(t.data.utils.keysEqual(null,n[r].key,i))return n[r]},u=function(n,t){for(var i=0;i<n.length;i++)if(n[i].offset>t)break;return i},f=function(n){for(var t,r,i=0;i<n.length;i++)t=n[i],t.data&&t.data.offset!==t.offset&&(n.splice(i,1),t.offset=t.data.offset,r=u(n,t.offset),n.splice(r,0,t),r>i&&i--)},e=function(n,t,i){for(var r=0;r<n.length;r++)t+1>=i?n[r].children=[]:e(n[r].children,t+1,i)};return{ctor:function(n){this._dataSource=n,this.reset()},reset:function(){this._groupsInfo=[],this._totalCountCorrection=0},totalItemsCount:function(){var n=this,t=n._dataSource.totalCount();return t>0?t+n._totalCountCorrection:0},itemsCount:function(){return this._itemsCount||0},mergeLoadedData:function(n,t){var i=this.mergeLoadedDataCore(n,t);return this._itemsCount=this.calculateItemsCount(i),i},updateTotalItemsCount:function(n){this._totalCountCorrection=n||0},_isGroupItemCountable:function(n){return!this._isVirtualPaging()||!n.isContinuation},_isVirtualPaging:function(){var t=this._dataSource,n=t&&t._options,i=n&&n.scrolling&&n.scrolling.mode;return i==="virtual"||i==="infinite"},updateItemsCount:function(n,t){function i(n,t,r){var u,f=0;if(t)if(r)for(u=0;u<t.length;u++)n._isGroupItemCountable(t[u])&&f++,f+=i(n,t[u].items,r-1);else f=t.length;return f}this._itemsCount=i(this,n,t)},foreachGroups:function(t,i){function r(t,i,u,e){function c(n,t,i,r){var u=t&&n(t,i);return r.push(u),u}for(var h,s=[],o=0;o<t.length;o++){if((e.push(t[o].data),!u&&c(i,t[o].data,e,s)===!1)||(!t[o].data||t[o].data.isExpanded)&&(h=r(t[o].children,i,u,e),s.push(h),h===!1)||u&&c(i,t[o].data,e,s)===!1)return!1;e.pop()}return n.when.apply(n,s).always(function(){f(t)})}var u=this;return r(u._groupsInfo,t,i,[])},findGroupInfo:function(n){for(var f=this,e,t,u=f._groupsInfo,i=0;u&&i<n.length;i++)t=r(u,n[i]),u=t&&t.children;return t&&t.data},addGroupInfo:function(n){for(var h=this,s,t,o=n.path,e=h._groupsInfo,i=0;i<o.length;i++)t=r(e,o[i]),t||(t={key:o[i],offset:n.offset,children:[]},s=u(e,n.offset),e.splice(s,0,t)),i===o.length-1&&(t.data=n,f(e)),e=t.children},allowCollapseAll:function(){return!0},collapseAll:function(n){return this.allowCollapseAll()?this._collapseExpandAll(n,!1):(t.utils.logger.error("The collapseAll method cannot be called when using a remote data source"),!1)},expandAll:function(n){return this._collapseExpandAll(n,!0)},_collapseExpandAll:function(n,t){var e=this,o=e._dataSource,f=o.group(),u=i(f||[]),r;if(u.length){for(r=0;r<u.length;r++)n===undefined||n===r?u[r].isExpanded=t:f&&f[r]&&(u[r].isExpanded=f[r].isExpanded);o.group(u),e.foreachGroups(function(i,r){(n===undefined||n===r.length-1)&&(i.isExpanded=t)}),e.updateItemsCount()}return!0},processLoadOptions:function(n){this._group=n.group},refresh:function(n){var r=this,t,f=i(r._group||[]),o=i(n.group||[]),u=Math.min(f.length,o.length);for(r._group=n.group,t=0;t<u;t++)if(f[t].selector!==o[t].selector){u=t;break}u?e(r._groupsInfo,0,u):r.reset()}}}())}(jQuery,DevExpress),function(n,t){var f=t.utils,i=t.data.utils.normalizeSortingInfo,u=t.data.utils.keysEqual,r=function(t,i){var r=n.Deferred(),u=n.extend({skip:0,take:0,requireTotalCount:!0},i);return t.load(u).done(function(u,f){f&&isFinite(f.totalCount)?r.resolve(f.totalCount):t.totalCount(i).done(n.proxy(r.resolve,r)).fail(n.proxy(r.reject,r))}).fail(n.proxy(r.reject,r)),r};t.ui.dataGrid.GroupingHelper=t.ui.dataGrid.GroupingHelperBase.inherit(function(){var f=function(n,t){return n.foreachGroups(function(n){if(!n.isExpanded)return t(n)})},o=function(n,t){var i=0,r=t||0;return t&&(f(n,function(n){if(n.offset-i>=t)return!1;i+=n.count-1}),r+=i),r},s=function(n,t,i,r,u,f){for(var e,h,o=0,c=!1,a,l=0;l<t.length;l++)e=t[l],"key"in e&&e.items!==undefined?(i.push(e.key),a=n.findGroupInfo(i),a&&!a.isExpanded?(e.items=null,r+=a.count,f--,f<0&&o++,u&&(c=!0)):e.items&&(h=s(n,e.items,i,r,u,f),u&&(h.offset-r>1?e.isContinuation=!0:c=!0),r=h.offset,f=h.take,f<0&&(e.items.length?e.isContinuationOnNextPage=!0:o++)),i.pop()):(u&&(c=!0),r++,f--,f<0&&o++),u=!1;return c&&t.splice(0,1),o&&t.splice(-o,o),{offset:r,take:f}},c=function(n,t){var i;if(n.length!==t.length)return!1;for(i=0;i<n.length;i++)if(!u(null,n[i],t[i]))return!1;return!0},e=function(n,t,i,r,u){for(var f,h=n._groupsInfo,o,s=0;s<t.length;s++)f=t[s],"key"in f&&f.items!==undefined?(i.push(f.key),u&&c(u.path,i)&&(u.offset=r),o=n.findGroupInfo(i),o&&!o.isExpanded?(o.offset=r,r+=o.count):r=e(n,f.items,i,r,u),i.pop()):r++;return r},l=function(n){n.group&&(n.sort=i(n.group||[]).concat(i(n.sort||[])),delete n.group)},h=function(n,t){for(var f=i(t.group||[]),u=[],r=0;r<n.length;r++)u.push([f[r].selector,"=",n[r]]);return t.filter&&u.push(t.filter),u},a=function(n,t){for(var o=i(t.group||[]),r,e,u=[],f=0;f<n.length;f++){for(e=[],r=0;r<=f;r++)e.push([o[r].selector,f===r?o[r].desc?">":"<":"=",n[r]]);u.length&&u.push("or"),u.push(e)}return t.filter&&u.push(t.filter),u};return{processLoadOptions:function(t){var s=this,e,i,r=[],h=[],a=!1,v,y,c=t.group,u=[];return s.callBase(t),l(t),i=n.extend({},t),i.skip=o(s,t.skip),i.skip&&i.take&&c&&(i.skip--,i.take++,a=!0),i.take&&c&&(v=i.take,i.take++),y=i.skip||0,i.take?(f(s,function(t){if(t.offset>=i.skip+i.take)return!1;t.offset>=i.skip&&t.count&&(e=t.offset-i.skip,e>0&&(u.push(n.extend({},i,{skip:i.skip,take:e})),i.take-=e,h.push(r),r=[]),i.skip=t.offset+t.count,i.take--,r.push(t.path))}),(!u.length||i.take>0)&&u.push(i),r.length&&h.push(r)):u.push(i),{loads:u,data:{collapsedPathsByLoads:h,offset:y,skipFirstItem:a,take:v,group:c}}},updateTotalItemsCount:function(){var n=0;f(this,function(t){t.count&&(n-=t.count-1)}),this.callBase(n)},changeGroupExpand:function(t){var u=this,i=u._dataSource,c=i.basePageIndex&&i.basePageIndex()||i.pageIndex(),f=o(u,c*i.pageSize()),s;return s=r(i.store(),{filter:h(t,{filter:i.filter(),group:i.group()})}),n.when(s).done(function(n){var r;n=parseInt(n.length?n[0]:n),r=u.findGroupInfo(t),r?(e(u,i.items(),[],f),r.isExpanded=!r.isExpanded,r.count=n):(r={offset:-1,count:n,path:t,isExpanded:!1},e(u,i.items(),[],f,r),r.offset>=0&&u.addGroupInfo(r)),u.updateTotalItemsCount()}).fail(n.proxy(i.loadError.fire,i.loadError))},mergeLoadedData:function(n,r){function b(n){for(var r={},t,i=0;i<n.length;i++)t?(t.items.push({}),t=t.items[0]):t=r,t.key=n[i],t.items=[];return r}function c(n,t){var i=0;if(t)for(n.length&&t.length&&u(null,n[n.length-1].key,t[0].key)&&(c(n[n.length-1].items,t[0].items),i=1);i<t.length;)n.push(t[i]),i++}for(var l=this,e=[],h,a,v=r.collapsedPathsByLoads,o,y=i(r.group||[]),p=y.length,w=Math.max(n.length,v.length),f=0;f<w;f++){if(o=v[f],o&&o.length)for(h=0;h<o.length;h++)c(e,[b(o[h])]);n[f]&&(a=t.data.query(n[f]),t.data.utils.multiLevelGroup(a,y).enumerate().done(function(n){c(e,n)}))}return s(l,e,[],r.offset,r.skipFirstItem,r.take),l.updateItemsCount(e,p),e},allowCollapseAll:function(){return!1},refresh:function(t){var i=this,u=i._dataSource.store();return i.callBase(t),f(i,function(f){var e=r(u,{filter:h(f.path,t)}),o=r(u,{filter:a(f.path,t)});return n.when(o,e).done(function(n,t){n=parseInt(n.length?n[0]:n),t=parseInt(t.length?t[0]:t),f.offset=n,f.count!==t&&(f.count=t,i.updateTotalItemsCount())}).fail(n.proxy(i._dataSource.loadError.fire,i._dataSource.loadError))})}}}())}(jQuery,DevExpress),function(n,t){var r=t.utils,i=t.data.utils.normalizeSortingInfo,u=t.data.utils.keysEqual;t.ui.dataGrid.GroupingHelperWithNativeGrouping=t.ui.dataGrid.GroupingHelperBase.inherit(function(){var t=function(n,t){return n.foreachGroups(function(n,i){if(n.isExpanded)return t(n,i)},!0)},f=function(n,t,i,r){var e,u,o;if(r)for(e=0;e<t.length;e++)u=t[e],"key"in u&&u.items!==undefined&&(i.push(u.key),o=n.findGroupInfo(i),o&&o.isExpanded?f(n,u.items,i,r-1):u.items=null,i.pop())},e=function(n,t){for(var u=!1,f=i(t||[]).length,r=0;r<f;r++)n._isGroupExpanded(r)&&(u=!0);return u},o=function(n,t,i,r){s(n,t,0,i,[],r)},s=function(n,t,i,r,u,f){var e,o,h;if(!(i>=r))for(o=0;o<t.length;o++)e=t[o],e&&(u.push(e.key),h=n.findGroupInfo(u),h?(h.count=e.items.length,h.offset=f+o):n.addGroupInfo({isExpanded:n._isGroupExpanded(i),path:u.slice(0),offset:f+o,count:e.items.length}),s(n,e.items,i+1,r,u,0),u.pop())},r=function(n,t){return n&&n.length&&n[t]&&!!n[t].isExpanded},h=function(n,t,i){for(var o=0,f,e=i,r=0;r<n.length;r++)f=n[r].offset+1,r>0&&(f+=n[r-1].childrenTotalCount,t&&(f+=u(e,t,f,r-1)*r)),e+=f;return e},u=function(n,t,i,r){if(r=r||0,t>1&&i>0){var u=n-Math.floor(n/t)*t||t;return u+=i-r-2,u<0&&(u+=t),Math.floor(u/(t-r-1))}return 0};return{updateTotalItemsCount:function(){var n=0,i=this._dataSource.pageSize(),r=this._isVirtualPaging();t(this,function(n){n.childrenTotalCount=0}),t(this,function(t,f){var o=h(f,r?0:i,n),e=t.count+t.childrenTotalCount,s;r||(e+=u(o,i,e,f.length-1)),f[f.length-2]?f[f.length-2].childrenTotalCount+=e:n+=e}),this.callBase(n)},_isGroupExpanded:function(n){var t=this._dataSource.group();return r(t,n)},processLoadOptions:function(r,f){var s=this,w=this._dataSource,y=s._isVirtualPaging(),c=w.pageSize(),b=i(r.group||[]),p=[],l=[],a=0,v=0,o=n.extend({},r);return s.callBase(r),e(s,b)&&!f?(delete o.skip,delete o.take):o.take&&(t(this,function(n){n.childrenTotalCount=0,n.skipChildrenTotalCount=0}),t(s,function(n,t){var r,e,b=0,k=0,f=h(t,y?0:c,v),d=0,s=0,i=n.count+n.childrenTotalCount,w=i;f<=o.skip+o.take&&i&&(r=o.skip-f,e=o.take,y||(d=u(f,c,i,t.length-1),i+=d*t.length,w+=d,c&&r>=0&&(b=t.length,k=t.length-1,s=Math.floor(r/c))),r>=0?(f+i>o.skip&&p.unshift(r-s*b-n.skipChildrenTotalCount),f+i>=o.skip+e&&l.unshift(e-b-n.childrenTotalCount+n.skipChildrenTotalCount)):f+i>=o.skip+e&&l.unshift(e+r-n.childrenTotalCount)),f<=o.skip&&(t[t.length-2]?t[t.length-2].skipChildrenTotalCount+=Math.min(w,r+1-s*k):a+=Math.min(w,r+1)),f<=o.skip+e&&(i=Math.min(w,r+e-(s+1)*k),t[t.length-2]?t[t.length-2].childrenTotalCount+=i:v+=i)}),o.skip-=a,o.take-=v-a),{loads:[o],data:{skip:o.skip,take:o.take,skips:p,takes:l,storeLoadOptions:r}}},changeGroupExpand:function(t){var r=this,i=r.findGroupInfo(t);return i?(i.isExpanded=!i.isExpanded,r.updateTotalItemsCount(),n.Deferred().resolve()):n.Deferred().reject()},mergeLoadedData:function(n,t){var c=this,s=n[0],y=i(t.storeLoadOptions.group||[]),l=y.length,v,a,u,h,r;for(o(c,s,l,t.skip||0),c.updateTotalItemsCount(),e(c,y)&&(t=c.processLoadOptions(t.storeLoadOptions,!0).data,t.skip&&(s=s.slice(t.skip)),t.take&&(s=s.slice(0,t.take))),v=t.skips,a=t.takes,r=s,u=0;r&&u<l;u++)h=r[0],r=h&&h.items,r&&v[u]!==undefined&&(h.isContinuation=!0,r=r.slice(v[u]),h.items=r);for(r=s,u=0;r&&u<l;u++)h=r[r.length-1],r=h&&h.items,r&&a[u]!==undefined&&r.length>a[u]&&(h.isContinuationOnNextPage=!0,r=r.slice(0,a[u]),h.items=r);return f(c,s,[],l),c.updateItemsCount(s,l),s},refresh:function(t){for(var u=this,s=i(u._group||[]),e=i(t.group||[]),f=0;f<s.length;f++)if(r(u._group,f)!==r(t.group,f)){u.reset();return}return u.callBase(t),u.foreachGroups(function(n){n.count=0}),e.length?u._dataSource.store().load(t).done(function(n){o(u,n,e.length,0)}).fail(n.proxy(u._dataSource.loadError.fire,u._dataSource.loadError)):void 0}}}())}(jQuery,DevExpress),function(n,t){var i=t.ui.dataGrid,r=t.utils;i.ScrollingDataSourceWrapper=t.Class.inherit(function(){var e=function(n){var t=n._options.scrolling;return t&&t.preloadEnabled?2:1},t=function(n){return n._options.scrolling&&n._options.scrolling.mode==="virtual"},r=function(n){return n._options.scrolling&&n._options.scrolling.mode==="infinite"},u=function(n){return n._cache[0]?n._cache[0].pageIndex:-1},f=function(n){var i=u(n),r=n._cache.length;t(n)&&(i<0||n._viewportItemIndex>=0&&(i*n.pageSize()>n._viewportItemIndex||i*n.pageSize()+n.itemsCount()<n._viewportItemIndex+n._viewportSize)&&n._dataSource.isLoading()?n._isLoading||(n._isLoading=!0,n.loadingChanged.fire(!0)):n._isLoading&&(n._isLoading=!1,n.loadingChanged.fire(!1)))};return{ctor:function(e){var o=this,s=new i.DataSource(e,o),h,c;o._dataSource=s,o.loadError=s.loadError,o.changed=n.Callbacks(),o.loadingChanged=n.Callbacks(),o._isLoading=!0,o._pageIndex=s.pageIndex(),o._lastPageIndex=o._pageIndex,o._viewportSize=0,o._viewportItemIndex=-1,o._userPageSize=e.pageSize,o._items=[],o._isLoaded=!0,s.loadingChanged.add(function(n){t(o)||(o._isLoading=n,o.loadingChanged.fire(n))}),h=function(n,t,i){var u=n._dataSource,r=u.items();t==="append"?n._items.push.apply(n._items,r):t==="prepend"?n._items.unshift.apply(n._items,r):n._items=r,f(n),n._lastPageIndex=n.pageIndex(),n._isDelayChanged=i,i||n.changed.fire(t&&{changeType:t,items:r})},c=function(n){n._isDelayChanged&&(n._isDelayChanged=!1,n.changed.fire())},s.changed.add(function(){var n,e=o._cache.length,i,f;t(o)?(n=u(o),n>=0&&(n+o._cache.length===s.pageIndex()||n-1===s.pageIndex()||(o._cache=[])),f={pageIndex:s.pageIndex(),itemsCount:s.itemsCount()},c(o),n===s.pageIndex()+1?(i="prepend",o._cache.unshift(f)):(i="append",o._cache.push(f)),h(o,o._cache.length>1?i:undefined,e===0),o.load().done(function(){c(o)})):h(o,r(o)&&s.pageIndex()!==0?"append":undefined)}),n.each(s,function(t,i){!o[t]&&n.isFunction(i)&&(o[t]=function(){return this._dataSource[t].apply(this._dataSource,arguments)})}),o._cache=[],o._options=e},items:function(){return this._items},itemsCount:function(){var i=0;return t(this)?n.each(this._cache,function(){i+=this.itemsCount}):i=this._dataSource.itemsCount(),i},virtualItemsCount:function(){var n=this,i,f=0,o,r,e;if(t(n))return i=u(n),i<0&&(i=0),r=i*n.pageSize(),f=n._cache.length*n.pageSize(),e=Math.max(0,n.totalItemsCount()-f-r),{begin:r,end:e}},setViewportItemIndex:function(n){var i=this,f=i.pageSize(),v=i._dataSource,e=i.pagesCount(),c=t(i),l=r(i),s=i.totalItemsCount(),o,a=i._viewportItemIndex<0,h,u;i._viewportItemIndex=n,f&&(c||l)&&(i._viewportSize&&n+i._viewportSize>=s?i.hasKnownLastPage()?(u=e-1,o=s%f,u>0&&o>0&&o<f/2&&u--):i.pageIndex()<e&&(u=e):(u=Math.floor(n/f),h=e-1,u=Math.max(u,0),u=Math.min(u,h)),(i.pageIndex()!==u||a)&&(i.pageIndex(u),i.load()))},setViewportSize:function(n){var i=this,u;i._viewportSize!==n&&(i._viewportSize=n,(t(i)||r(i))&&!i._userPageSize&&(u=Math.ceil(n/5)*10,u!==i.pageSize()&&(i.pageSize(u),i.reload())))},pageIndex:function(n){return t(this)||r(this)?(n!==undefined&&(this._pageIndex=n),this._pageIndex):this._dataSource.pageIndex(n)},basePageIndex:function(){var n=u(this);return n>0?n:0},load:function(){var i=u(this),o=-1,s=this._dataSource,h,c=function(n,t){var i=n._dataSource;if(t===n.pageIndex()||!i.isLoading()&&t<i.pagesCount()||!i.hasKnownLastPage()&&t===i.pagesCount())return i.pageIndex(t),i.load()};return t(this)?((i<0||!this._cache[this._pageIndex-i])&&(o=this._pageIndex),i>=0&&o<0&&this._viewportItemIndex>=0&&i+this._cache.length<=this._pageIndex+e(this)&&(o=i+this._cache.length),o>=0&&(h=c(this,o)),f(this)):r(this)?s.isLoaded()&&this.pageIndex()!==s.pagesCount()||(s.pageIndex(this.pageIndex()),h=s.load()):h=s.load(),h||this._lastPageIndex===this.pageIndex()||this.changed.fire({changeType:"pageIndex"}),h||n.Deferred().resolve()},isLoading:function(){return this._isLoading},isLoaded:function(){return this._dataSource.isLoaded()&&this._isLoaded},changeGroupExpand:function(n){this._cache=[],f(this),this._dataSource.changeGroupExpand(n)},reload:function(){var n=this,t=n._dataSource;return n._cache=[],n._isLoaded=!1,f(n),n._isLoaded=!0,r(n)?(n.pageIndex(0),t.pageIndex(0)):t.pageIndex(n.pageIndex()),t.reload()}}}())}(jQuery,DevExpress),function(n,t){var i=t.ui.dataGrid;i.DataSource=t.data.DataSource.inherit(function(){var r=function(n){return!!n._storeLoadOptions.group};return{ctor:function(n,r){var u=this;u.callBase(n),u._pageIndex=n.pageIndex||0,u._asyncLoadEnabled=!!n.asyncLoadEnabled,u._loadingTimeout=n.loadingTimeout,n.useNativeGrouping==="auto"&&(n.useNativeGrouping=u.store()instanceof t.data.ArrayStore),u._groupingHelper=n.useNativeGrouping?new i.GroupingHelperWithNativeGrouping(r||u):new i.GroupingHelper(r||u),u._hasLastPage=!1,u._currentTotalCount=0,u._options=n,u.map(u._mapFunc)},map:function(n){var r=this,i,u=r.store();if(n)if(u instanceof t.data.ArrayStore){for(i=0;i<u._array.length;i++)u._array[i]=n(u._array[i]);delete r._mapFunc}else r._mapFunc=n;else return r._mapFunc},pageSize:function(n){if(n===undefined)return this._paginate?this._pageSize:0;this._pageSize=n||20},totalCount:function(){return parseInt(this._currentTotalCount||this._totalCount)},totalItemsCount:function(){var n=this;return r(n)&&n._storeLoadOptions.requireTotalCount?n._groupingHelper.totalItemsCount():n.totalCount()},itemsCount:function(){var n=this;return r(n)?n._groupingHelper.itemsCount():n.items().length},collapseAll:function(n){return this._groupingHelper.collapseAll(n)},expandAll:function(n){return this._groupingHelper.expandAll(n)},pagesCount:function(){var n=this,t=n.totalItemsCount(),i=n.pageSize();return i&&t>0?Math.max(1,Math.ceil(t/i)):1},_reloadCore:function(){var n=this,t,i=n._userData;for(t in i)i.hasOwnProperty(t)&&delete i[t];return n._isLastPage=!n._paginate,n._currentTotalCount=0,n._totalCount=-1,n._hasLastPage=n._isLastPage,n._isLoaded=!1,n.load()},reload:function(){var t=this,i=n.Deferred(),r;return t.isLoading()?(r=function(){t.loadingChanged.remove(r),setTimeout(function(){t.reload().done(i.resolve).fail(i.reject)})},t.loadingChanged.add(r)):n.when(t._groupingHelper.refresh(t._createStoreLoadOptions())).always(function(){t._reloadCore().done(i.resolve).fail(i.reject)}),i},hasKnownLastPage:function(){return this._hasLastPage||this._totalCount>=0},changeGroupExpand:function(n){var t=this,i=t._groupingHelper;r(t)?(t._changeLoadingCount(1),i.changeGroupExpand(n).always(function(){t._changeLoadingCount(-1)}).done(function(){t.load()})):t.load()},_createLoadQueue:function(){return t.createQueue(!0)},_scheduleChangedCallbacks:function(n){var t=this,i=t.pageIndex();t._lastLoadDeferred=n,n.done(function(){var r,n=t.itemsCount();t._isLastPage=!n||!t._paginate||t._pageSize&&n<t._pageSize,t.isLastPage()&&(t._hasLastPage=!0),t._totalCount>=0?t._pageIndex>=t.pagesCount()&&(t.pageIndex(t.pagesCount()-1),t.load()):(r=t.pageIndex()*t.pageSize()+n,t._currentTotalCount=Math.max(t._currentTotalCount,r),n===0&&t.pageIndex()>=t.pagesCount()&&(t.pageIndex(t.pagesCount()-1),t.load())),i!==t.pageIndex()||t.isLoading()||t.changed.fire()})},_loadFromStore:function(t,i){var u=this,f=function(){var f,o,s,c=u._groupingHelper,e=[],h=[];if(!u._disposed){if(r(u))for(o=c.processLoadOptions(t),s=o.loads,f=0;f<s.length;f++)e.push(u.store().load(s[f])),function(n){e[n].done(function(t){h[n]=t})}(f);else e.push(u.store().load(t));n.when.apply(n,e).done(function(n,f){u._disposed||(r(u)&&(h.length>1&&(f=undefined),n=c.mergeLoadedData(h,o.data)),f=f||{totalCount:u._totalCount>=0?u._totalCount:undefined},u._processStoreLoadResult(n,f,t,i))}).fail(n.proxy(i.reject,i))}};u._asyncLoadEnabled?window.setTimeout(f,u._loadingTimeout):f()}}}())}(jQuery,DevExpress),function(n,t){var r=t.ui,u=t.utils,i=r.dataGrid;i.StateStoringController=i.ViewController.inherit(function(){var i=function(n){var t=n.type==="sessionStorage"?sessionStorage:localStorage;if(!t)throw new Error("State storing can not be provided due to the restrictions of your browser.");return t},r=function(n){return"dx_datagrid_"+(u.isDefined(n.storageKey)?n.storageKey:"storage")},f=function(n,t){var i;return typeof t=="string"&&(i=/^(\d{4})-(\d{2})-(\d{2})T(\d{2}):(\d{2}):(\d{2}(?:\.\d*)?)Z$/.exec(t),i)?new Date(Date.UTC(+i[1],+i[2]-1,+i[3],+i[4],+i[5],+i[6])):t},e=function(n,t){var u=t.allowedPageSizes,f=t.searchText,e=t.selectedRowKeys,r=n.getController("columns"),o=n.getController("selection"),i=n.getController("data"),s=n.getView("pagerView");r&&(r.setUserState(t.columns),r.columnsChanged.add(function(){n.state({columns:r.getUserState()}),n.save()})),e&&n.option("selectedRowKeys",e),o&&o.selectionChanged.add(function(t){n.state({selectedRowKeys:t}),n.save()}),i&&(u&&n.option("pager.allowedPageSizes")==="auto"&&u&&(n.option("pager").allowedPageSizes=u),f&&i.searchByText(f),i.changed.add(function(){n.state({searchText:i.getSearchText(),pageIndex:i.pageIndex(),pageSize:i.pageSize(),allowedPageSizes:s.getPageSizes()}),n.save()}))};return{_loadState:function(){var n=this.option("stateStoring");if(n.type==="custom")return n.customLoad&&n.customLoad();try{return JSON.parse(i(n).getItem(r(n)),f)}catch(u){t.utils.logger.error(u.message)}},_saveState:function(n){var t=this.option("stateStoring");if(t.type==="custom"){t.customSave&&t.customSave(n);return}try{i(t).setItem(r(t),JSON.stringify(n))}catch(u){}},publicMethods:function(){return["state"]},isEnabled:function(){var n=this.option("stateStoring");return n&&n.enabled},init:function(){var n=this;n._state={},n._isLoaded=!1,n._isLoading=!1},isLoaded:function(){return this._isLoaded},isLoading:function(){return this._isLoading},load:function(){var t=this,i;return t._isLoading=!0,i=t._loadState(),i&&n.isFunction(i.done)||(i=n.Deferred().resolve(i)),i.done(function(n){t._isLoaded=!0,t._isLoading=!1,t._state=n||{},e(t,t._state)}),i},state:function(t){var i=this;if(t===undefined)return i._state;n.extend(i._state,t)},save:function(){var n=this;clearTimeout(n._savingTimeoutID),n._savingTimeoutID=setTimeout(function(){n._saveState(n.state())},n.option("stateStoring.savingTimeout"))},dispose:function(){clearTimeout(this._savingTimeoutID)}}}()),i.registerModule("stateStoring",{defaultOptions:function(){return{stateStoring:{enabled:!1,storageKey:null,type:"localStorage",customLoad:null,customSave:null,savingTimeout:2e3}}},controllers:{stateStoring:r.dataGrid.StateStoringController},extenders:{controllers:{columns:{getVisibleColumns:function(){var n=this.callBase();return this.getController("stateStoring").isLoading()?[]:n}},data:{_refreshDataSource:function(){var n=this,i=n.callBase,t=n.getController("stateStoring");t.isEnabled()&&!t.isLoaded()?t.load().done(function(){i.call(n)}):i.call(n)},isLoading:function(){var n=this,t=n.getController("stateStoring");return this.callBase()||t.isLoading()},_dataSourceOptions:function(){var i=this,t=i.callBase(),r=i.getController("stateStoring"),n;return r.isEnabled()&&(n=r.state(),n.pageIndex!==undefined&&(t.pageIndex=n.pageIndex),n.pageSize!==undefined&&(t.pageSize=n.pageSize)),t}}}}})}(jQuery,DevExpress),function(n,t,i){var h=t.ui,o=h.dataGrid,u=t.utils,f=t.data.utils,e=f.normalizeSortingInfo,r=u.isDefined,c=["initialIndex","dataField","width","visible","sortOrder","sortIndex","groupIndex","filterValue","selectedFilterOperation"],l=/^(\{{0,1}([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}\}{0,1})$/,s;o.checkChanges=function(n,t){for(var r=0,i=0;i<t.length;i++)n[t[i]]&&r++;return n.length&&n.length===r},s=o.Controller.inherit(function(){var et={visible:!0},ot={number:["=","<>","<",">","<=",">="],date:["=","<>","<",">","<=",">="],string:["contains","notcontains","startswith","endswith","=","<>"]},st={allowResizing:!1,allowGrouping:!1,allowReordering:!1,allowSorting:!1,allowHiding:!1},ht=30,o="group",s="columnChooser",ct=function(n){for(var u=[],t,f=!1,i=!1,r=0;r<n.length;r++)t=n.charAt(r),i=t===t.toUpperCase()||t in["0","1","2","3","4","5","6","7","8","9"],t==="_"||t==="."?(t=" ",i=!0):r===0?(t=t.toUpperCase(),i=!0):!f&&i&&u.length>0&&u.push(" "),u.push(t),f=i;return u.join("")},p=function(t,i){var e,r,f;if(i)return u.isString(i)&&(i={dataField:i}),r=t.getCommonSettings(),f=t._createCalculatedColumnOptions(i),n.extend(!0,{},et,r,f,i)},w=function(t,r){var u=[];return r&&n.each(r,function(n,r){var f=p(t,r);f&&(f.initialIndex===i&&(f.initialIndex=n),u.push(f))}),u},nt=function(t){var r=n.type(t);return r==="string"?u.isNumber(t)?r="number":l.test(t)&&(r="guid"):r!=="boolean"&&r!=="number"&&r!=="date"&&(r=i),r},lt=function(n,t){switch(n){case"number":return"right";case"boolean":return"center";case"date":return"left";default:return t?"right":"left"}},at=function(n){switch(n){case"date":return"shortDate"}},vt=function(n){if(n==="boolean")return function(n){return n.value===!0?this.trueText||"true":n.value===!1?this.falseText||"false":n.valueText||""}},yt=function(t,i){for(var u=b(i),s,f={},o=0,e=[],r=0;r<u.length;r++)u[r]&&n.each(u[r],function(n){f[n]=!0});return n.each(f,function(n){if(n.indexOf("__")!==0){var i=p(t,n);i.initialIndex=o++,e.push(i)}}),e},v=function(t,i){var r;if(n.isArray(t)&&n.isArray(i)){if(t.length!==i.length)return!1;for(r=0;r<t.length;r++)if(t[r].selector!==i[r].selector||t[r].desc!==i[r].desc||!t[r].isExpanded!=!i[r].isExpanded)return!1;return!0}return(!t||!t.length)==(!i||!i.length)},b=function(n){var t,u,i=[],r=function(n,t){var i,u;if(!n||!t)return n;for(i=0;i<n.length;i++)if(u=r(n[i].items,t-1),u&&u.length)return u};return n&&n.items().length>0&&(t=e(n.group()||[]).length,i=r(n.items(),t)||[]),i},tt=function(t){n.each(t._columns,function(n,t){t.index=n})},it=function(t,i,u){var f=[],e=0;return n.each(t._columns,function(n,t){var n=t[i];r(n)&&(f[n]||(f[n]=[]),t===u?f[n].unshift(t):f[n].push(t),delete t[i])}),n.each(f,function(t,r){r&&n.each(r,function(){this[i]=e++})}),e},rt=function(t,i){var u="groupIndex",f=it(t,u,i);n.each(t._columns,function(n,t){!r(t[u])&&t.grouped&&(t[u]=f++),delete t.grouped})},ut=function(t,i){n.each(t._columns,function(n,t){r(t.sortIndex)&&!y(t.sortOrder)&&delete t.sortIndex});var u=it(t,"sortIndex",i);n.each(t._columns,function(n,t){r(t.sortIndex)||r(t.groupIndex)||!y(t.sortOrder)||(t.sortIndex=u++)})},pt=function(n){var t;return u.isDate(n)||(u.isNumber(n)?n=new Date(n):(t=Date.parse(n),t&&(n=new Date(t)))),n},wt=function(t,i){var f,h=t._columns,o=b(i)[0],r,c,l,a,p,v=[],y=[],s;if(i&&i.map){for(f=0;f<h.length;f++)if(r=h[f].dataField,r)switch(h[f].dataType){case"date":o&&u.isDate(o[r])||v.push(r);break;case"number":(!o||u.isString(o[r]))&&y.push(r)}if(s=function(t,i,r,f){var e,o;if(r&&u.isDefined(t.items))n.each(t.items,function(n,t){s(t,i,r-1,f)});else for(e=0;e<i.length;e++)o=t[i[e]],o&&(t[i[e]]=f(o))},v.length>0||y.length>0)return c=i.map(),l=function(n){var t;return n&&(t=e(i.group()||[]).length,s(n,v,t,pt),s(n,y,t,Number)),n},a=function(n){return n=c?c(n):n,l(n)},i.map(a),i.map()?n.each(i.items(),function(){l(this)}):(i.store().inserting.remove(t._insertingHandler),t._insertingHandler=function(n){a(n)},i.store().inserting.add(t._insertingHandler)),i.load()}},k=function(n,t,i){var f=i===o?n.getGroupColumns():i===s?n.getHiddenColumns():n.getVisibleColumns(),u=f[t];return u&&r(u.index)?u.index:-1},bt=function(n,t,i){var u=n.getGroupColumns(),r;if(i>=0)for(r=0;r<u.length;r++)u[r].groupIndex>=i&&u[r].groupIndex++;else for(i=0,r=0;r<u.length;r++)i=Math.max(i,u[r].groupIndex+1);t.groupIndex=i},ft=function(t){var u=t._columnsUserState,f=t._columns,e=[],o=[],r,i;if(u){if(f.length!==u.length)return;for(i=0;i<f.length;i++)o[f[i].initialIndex]=f[i];for(i=0;i<u.length;i++)if(r=o[u[i].initialIndex],r&&u[i].dataField===r.dataField)r=n.extend({},r),n.each(c,function(n,t){r[t]=u[i][t]}),e.push(r);else return;t._columns=e}},d=function(n,t){tt(n),rt(n,t),ut(n,t)},h=function(n,t,r,u){var f=n._columnChanges||{optionNames:{length:0},changeTypes:{length:0},columnIndex:u&&u.initialIndex,column:u},o=f.changeTypes,e;t&&!o[t]&&(o[t]=!0,o.length++),e=f.optionNames,r&&!e[r]&&(e[r]=!0,e.length++),(u===i||u!==f.column)&&(delete f.column,delete f.columnIndex),n._columnChanges=f,n._visibleColumns=i},a=function(n,t){t&&h(n,t),!n._updateLockCount&&n._columnChanges&&(n.columnsChanged.fire(n._columnChanges),n._columnChanges=i)},g=function(n,t,i,r){var e=f.compileGetter(i),u;if(arguments.length===3)return e(t,{functionsAsIs:!0});e(t,{functionsAsIs:!0})!==r&&(u=i==="groupIndex"?"grouping":i==="sortIndex"||i==="sortOrder"?"sorting":"columns",f.compileSetter(i)(t,r,{functionsAsIs:!0}),h(n,u,i,t))},y=function(n){return n==="asc"||n==="desc"};return{init:function(){var n=this,t=n.option("columns");n._columns=t?w(n,t):[],n._updateLockCount=n._updateLockCount||0,n._isColumnsFromOptions=!!t,n._isColumnsFromOptions?ft(n):n._columns=n._columnsUserState||n._columns,n._dataSourceApplied?n.applyDataSource(n._dataSource,!0):d(n)},callbackNames:function(){return["columnsChanged"]},optionChanged:function(n){switch(n){case"columns":case"commonColumnSettings":case"columnAutoWidth":case"allowColumnResizing":case"allowColumnReordering":case"grouping":case"groupPanel":case"regenerateColumnsByVisibleItems":case"customizeColumns":case"editing":case"rtlEnabled":this._columnsUserState=this.getUserState(),this.init()}},publicMethods:function(){return["addColumn","columnOption","columnCount"]},applyDataSource:function(n,t){var i=this,r=n&&n.isLoaded(),u;return i._dataSource=n,(!i._dataSourceApplied||i._dataSourceColumnsCount===0||t||i.option("regenerateColumnsByVisibleItems"))&&r?(i._isColumnsFromOptions||(i._columns=yt(i,n),i._dataSourceColumnsCount=i._columns.length,ft(i)),i.updateColumns(n)):void 0},reset:function(){this._dataSourceApplied=!1,this._dataSourceColumnsCount=i},isInitialized:function(){return!!this._columns.length},isDataSourceApplied:function(){return this._dataSourceApplied},beginUpdate:function(){this._updateLockCount++},endUpdate:function(){var n=this,t={},i;n._updateLockCount--,n._updateLockCount||a(n)},getCommonSettings:function(){var r=this.option("commonColumnSettings")||{},t=this.option("grouping")||{},i=this.option("groupPanel")||{};return n.extend({allowResizing:this.option("allowColumnResizing"),allowReordering:this.option("allowColumnReordering"),autoExpandGroup:t.autoExpandAll,allowCollapsing:t.allowCollapsing,allowGrouping:i.allowColumnDragging&&i.visible},r)},isColumnOptionUsed:function(n){for(var t=0;t<this._columns.length;t++)if(this._columns[t][n])return!0},getColumns:function(){return n.extend(!0,[],this._columns)},getGroupColumns:function(){var t=[];return n.each(this._columns,function(){var n=this;r(n.groupIndex)&&(t[n.groupIndex]=n)}),t},getVisibleColumns:function(){var t=n.map(this.getGroupColumns(),function(t){return n.extend({},t,{width:ht},st)}),i=0;return n.each(this._columns,function(){var u=this;u.visible&&!r(u.groupIndex)&&(u=n.extend(!0,{},u),t.push(u),i++)}),!i&&this._columns.length&&t.push({command:"empty"}),t},getHiddenColumns:function(){var t=[];return n.each(this._columns,function(n,i){i.visible||t.push(i)}),t},allowMoveColumn:function(n,t,i,r){var f=this,e=k(f,n,i),u=f._columns[e];return u&&(u.allowReordering||u.allowGrouping||u.allowHiding)?i===r?i===s?!1:n!==t&&n+1!==t:i===o&&r!==s||r===o?u&&u.allowGrouping:i===s||r===s?u&&u.allowHiding:!0:!1},moveColumn:function(n,t,i,u){var f=this,c,h,l,y=i===o||u===o,e,v;c=k(f,n,i),h=k(f,t,u),c>=0&&(e=f._columns[c],l=h>=0?f._columns[h].groupIndex:-1,r(e.groupIndex)&&(l>e.groupIndex&&l--,delete e.groupIndex,delete e.sortOrder,rt(f)),u===o?bt(f,e,l):t>=0&&(f._columns.splice(c,1),h<0?f._columns.push(e):(v=h>c?h-1:h,f._columns.splice(v,0,e)),tt(f)),e.visible=u===s?!1:!0,a(f,y?"grouping":"columns"))},changeSortOrder:function(t,i){var f=this,v=f.getCommonSettings(),s=f.option("sorting"),o=s&&s.mode,h=o==="single"||!i,c=o==="single"||o==="multiple",u=f._columns[t],l=function(n){i==="ctrl"?(delete n.sortOrder,delete n.sortIndex):n.sortOrder=r(n.groupIndex)||r(n.sortIndex)?n.sortOrder==="desc"?"asc":"desc":"asc"},e=!1;c&&u&&u.allowSorting&&(h&&!r(u.groupIndex)&&n.each(f._columns,function(n){n!==t&&this.sortOrder&&!r(this.groupIndex)&&(delete this.sortOrder,delete this.sortIndex,e=!0)}),y(i)?u.sortOrder!==i&&(u.sortOrder=i,e=!0):i==="none"?u.sortOrder&&(delete u.sortIndex,delete u.sortOrder,e=!0):(l(u),e=!0)),e&&(ut(f),a(f,"sorting"))},getSortDataSourceParameters:function(){var u=this,i=[],t=[];return n.each(u._columns,function(){this.dataField&&this.visible&&r(this.sortIndex)&&!r(this.groupIndex)&&(i[this.sortIndex]=this)}),n.each(i,function(){var n=this&&this.sortOrder;y(n)&&t.push({selector:this.dataField,desc:this.sortOrder==="desc"})}),t.length>0?t:null},getGroupDataSourceParameters:function(){var t=[];return n.each(this.getGroupColumns(),function(){this.dataField&&t.push({selector:this.dataField,desc:this.sortOrder==="desc",isExpanded:!!this.autoExpandGroup})}),t.length>0?t:null},refresh:function(t){var i=[];return n.each(this._columns,function(){var n=this.lookup;if(n){if(t&&n.valueMap)return;n.update&&i.push(n.update())}}),n.when.apply(n,i)},_updateColumnDataTypes:function(t){var i=b(t),u=this.option("rtlEnabled");n.each(this._columns,function(n,t){var o,s,e,f=t.lookup;if(t.dataField&&i.length)for(o=0;(!t.dataType||f&&!f.dataType)&&o<i.length;o++)s=t.calculateCellValue(i[o]),t.dataType=nt(s),f&&(f.dataType=nt(f.calculateCellValue(s)));e=f?f.dataType:t.dataType,e&&(t.alignment=t.alignment||lt(e,u),t.format=t.format||at(e),t.customizeText=t.customizeText||vt(e),r(t.filterOperations)||(t.filterOperations=!f&&ot[e]||[]),t.defaultFilterOperation=t.filterOperations&&t.filterOperations[0]||"=")})},updateColumns:function(t){var i=this,r=i.option("customizeColumns"),u,f;return i.updateSortingGrouping(t),!t||t.isLoaded()?(u=t?t.sort()||[]:i.getSortDataSourceParameters(),f=t?t.group()||[]:i.getGroupDataSourceParameters(),r&&(r(i._columns),i._columns=w(i,i._columns)),d(i),i._updateColumnDataTypes(t),n.when(i.refresh(!0),wt(i,t)).always(function(){i._updateColumnDataTypes(t),i._dataSourceApplied=!0,v(u,i.getSortDataSourceParameters())?v(f,i.getGroupDataSourceParameters())?h(i,"columns"):h(i,"grouping"):h(i,"sorting"),a(i)})):void 0},updateSortingGrouping:function(t){var i=this,r,u,f,o,s=function(t,i,r){var u;n.each(t,function(n,t){if(t.dataField&&(delete t[r],i&&i.length))for(u=0;u<i.length;u++)if(i[u].selector===t.dataField){t.sortOrder=t.sortOrder||(i[u].desc?"desc":"asc"),t[r]=u;break}})};t&&(r=e(t.sort()||[]),u=e(t.group()||[]),f=i.getGroupDataSourceParameters(),o=i.getSortDataSourceParameters(),i._columns.length||(n.each(u,function(n,t){i._columns.push(t.selector)}),n.each(r,function(n,t){i._columns.push(t.selector)}),i._columns=w(i,i._columns)),f||v(u,f)||s(i._columns,u,"groupIndex"),o||v(r,o)||s(i._columns,r,"sortIndex"))},columnCount:function(){return this._columns.length},columnOption:function(t,i,r){for(var o=this,h,s=o._columns,f,e=0;e<s.length;e++)if(s[e].initialIndex===t||s[e].dataField===t||s[e].caption===t){f=s[e];break}if(f){if(arguments.length===1)return n.extend({},f);if(u.isString(i)){if(arguments.length===2)return g(o,f,i);g(o,f,i,r)}else u.isObject(i)&&n.each(i,function(n,t){g(o,f,n,t)});d(o,f),a(o)}},getVisibleIndex:function(n){for(var i=this.getVisibleColumns(),t=0;t<i.length;t++)if(i[t].initialIndex===n)return t;return-1},addColumn:function(n){var t=this;t._columns.push(p(t,n)),t.updateColumns()},getUserState:function(){for(var r=this._columns,u=[],t=0;t<r.length;t++)u[t]={},n.each(c,function(n,f){r[t][f]!==i&&(u[t][f]=r[t][f])});return u},setUserState:function(n){this._columnsUserState=n,this.init()},_createCalculatedColumnOptions:function(r){var e={};return r.dataField?(e={caption:ct(r.dataField),calculateCellValue:f.compileGetter(r.dataField),validate:function(n){return typeof n=="string"?!n||!this.parseValue||this.parseValue(n)!==i:!0},parseValue:function(n){var i=this,t,r;return i.dataType==="number"?u.isString(n)?(r=Globalize.parseFloat(n),u.isNumber(r)&&(t=r)):u.isDefined(n)&&(t=Number(n)):i.dataType==="boolean"?n===i.trueText?t=!0:n===i.falseText&&(t=!1):i.dataType==="date"?(r=Globalize.parseDate(n),r&&(t=r)):i.dataType==="guid"?l.test(n)&&(t=n):t=n,t}},r.lookup&&(e.lookup={calculateCellValue:function(n){return this.valueMap&&this.valueMap[n]},updateValueMap:function(){var i,r,t,n;if(this.valueMap={},this.items)for(i=f.compileGetter(this.valueExpr),r=f.compileGetter(this.displayExpr),n=0;n<this.items.length;n++)t=this.items[n],this.valueMap[i(t)]=r(t)},update:function(){var i=this,r=i.dataSource;if(r){if(u.isObject(r)||u.isArray(r))return r=new t.data.DataSource(n.extend(!0,{paginate:!1,_preferSync:!0},f.normalizeDataSourceOptions(r))),r.load().done(function(n){i.items=n,i.updateValueMap&&i.updateValueMap()});t.utils.logger.error("Unexpected type of data source is provided for a lookup column. For the list of supported types, see http://js.devexpress.com/Documentation/ApiReference/UI_Widgets/dxDataGrid/Configuration/columns/lookup#dataSource")}else i.updateValueMap&&i.updateValueMap()}})):n.extend(!0,e,{allowSorting:!1,calculateCellValue:function(){return null}}),e.resizedCallbacks=n.Callbacks(),r.resized&&e.resizedCallbacks.add(n.proxy(r.resized,r)),e}}}()),h.dataGrid.ColumnsController=s,o.registerModule("columns",{defaultOptions:function(){return{commonColumnSettings:{allowFiltering:!0,allowHiding:!0,allowSorting:!0,allowEditing:!0,encodeHtml:!0,trueText:Globalize.localize("dxDataGrid-trueText"),falseText:Globalize.localize("dxDataGrid-falseText")},grouping:{autoExpandAll:!0,allowCollapsing:!0,groupContinuesMessage:Globalize.localize("dxDataGrid-groupContinuesMessage"),groupContinuedMessage:Globalize.localize("dxDataGrid-groupContinuedMessage")},allowColumnReordering:!1,allowColumnResizing:!1,columns:i,regenerateColumnsByVisibleItems:!1,sorting:{mode:"single",ascendingText:Globalize.localize("dxDataGrid-sortingAscendingText"),descendingText:Globalize.localize("dxDataGrid-sortingDescendingText"),clearText:Globalize.localize("dxDataGrid-sortingClearText")},customizeColumns:null}},controllers:{columns:s}})}(jQuery,DevExpress),function(n,t){var r=t.ui.dataGrid,f=t.ui.events,i=t.utils,e="dx-editor-cell",o="dx-selection",s="dx-select-checkbox",h=500,c=3,u="selection.showCheckBoxesInMultipleMode";r.equalKeys=function(n,t,u){var f,e;if(u=u||0,u<c){if(i.isObject(n)&&i.isObject(t)){for(f in n)if(n.hasOwnProperty(f)&&!r.equalKeys(n[f],t[f],u+1))return!1;for(f in t)if(!(f in n))return!1;return!0}if(i.isArray(n)&&i.isArray(t)){if(n.length!==t.length)return!1;for(e=0;e<n.length;e++)if(!r.equalKeys(n[e],t[e],u+1))return!1;return!0}return i.isDate(n)&&i.isDate(t)?n.getTime()===t.getTime():n===t}return!0},r.SelectionController=r.Controller.inherit(function(){var o="selection.mode",y=function(n){return n==="single"||n==="multiple"},f=function(t,r,u){var f,e=u?t._unselectedItemKeys:t._selectedItemKeys;if(i.isObject(r)){for(f=0;f<e.length;f++)if(c(e[f],r))return f;return-1}return n.inArray(r,e)},l=function(n,t){var i=n.getController("data").keyOf(t),r;f(n,i)===-1&&(n._selectedItemKeys.push(i),n._addedItemKeys.push(i),n._selectedItems.push(t)),n._isSelectAll&&(r=f(n,i,!0),n._unselectedItemKeys.splice(r,1))},a=function(n,t){var i=f(n,t);i>=0&&(n._selectedItemKeys.splice(i,1),n._removedItemKeys.push(t),n._selectedItems.splice(i,1),n._isSelectAll&&f(n,t,!0)===-1&&n._unselectedItemKeys.push(t))},p=function(n){h(n,[],[])},h=function(t,i,r,u){var f,e=t._selectedItemKeys;for(t._selectedItemKeys=i,t._selectedItems=r,t._unselectedItemKeys=[],t._isSelectAll=!!u,f=0;f<e.length;f++)n.inArray(e[f],i)===-1&&t._removedItemKeys.push(e[f]);for(f=0;f<i.length;f++)n.inArray(i[f],e)===-1&&t._addedItemKeys.push(i[f])},c=r.equalKeys,v=function(n){delete n._shiftFocusedItemIndex},e=function(n){return n&&n.rowType==="data"},w=function(n,t,r){var f=!1,o,u,h=n.getController("data"),c=r[n._focusedItemIndex]&&n.isSelectedItem(h.keyOf(r[n._focusedItemIndex].data)),s=function(n,t,i){i?a(n,h.keyOf(t)):l(n,t)};if(i.isDefined(n._shiftFocusedItemIndex)||(n._shiftFocusedItemIndex=n._focusedItemIndex),n._shiftFocusedItemIndex!==n._focusedItemIndex)for(o=n._focusedItemIndex<n._shiftFocusedItemIndex?1:-1,u=n._focusedItemIndex;u!==n._shiftFocusedItemIndex;u+=o)e(r[u])&&(s(n,r[u].data,!0),f=!0);if(t!==n._shiftFocusedItemIndex)for(o=t<n._shiftFocusedItemIndex?1:-1,u=t;u!==n._shiftFocusedItemIndex;u+=o)e(r[u])&&(s(n,r[u].data,!1),f=!0);return e(r[n._focusedItemIndex])&&!c&&(s(n,r[n._focusedItemIndex].data,!1),f=!0),f},b=function(t,i,r){var o,f,e=t&&t.key(),u=[];return t&&(e?n.each(i,function(t,i){if(u.length>0&&u.push(r?"and":"or"),n.isArray(e)){for(o=[],f=0;f<e.length;f++)f>0&&o.push(r?"or":"and"),o.push([e[f],r?"<>":"=",i[e[f]]]);u.push(o)}else u.push([e,r?"<>":"=",i])}):u=function(n){for(var t=0;t<i.length;t++)if(c(i[t],n))return!r;return r}),u.length>0||n.isFunction(u)?u:void 0},s=function(t){var i=[],r=t.getController("data"),f,o;r&&(n.each(r.items(),function(n,u){var f=r.keyOf(u.data);e(u)&&u.isSelected!==t.isSelectedItem(f)&&i.push(n)}),t.option(u)==="onClick"&&(t._selectedItemKeys.length>1?t.startSelectionWithCheckboxes():t._selectedItemKeys.length===0&&i.length&&t.stopSelectionWithCheckboxes()),i.length&&r.updateItems({changeType:"updateSelection",itemIndexes:i}),f=t._addedItemKeys,o=t._removedItemKeys,(f.length||o.length)&&(t._selectedItemsInternalChange=!0,t.option("selectedRowKeys",t._selectedItemKeys.slice(0)),t._selectedItemsInternalChange=!1,t.selectionChanged.fire(t._selectedItemKeys),t.executeAction("selectionChanged",{selectedRowsData:t._selectedItems,selectedRowKeys:t._selectedItemKeys,currentSelectedRowKeys:f,currentDeselectedRowKeys:o})),t._addedItemKeys=[],t._removedItemKeys=[])};return{init:function(){var n=this;n._isSelectionWithCheckboxes=!1,n._focusedItemIndex=-1,n._selectedItemKeys=[],n._unselectedItemKeys=[],n._selectedItems=[],n._addedItemKeys=[],n._removedItemKeys=[],n._isSelectAll=!1,n.createAction("selectionChanged")},callbackNames:function(){return["selectionChanged"]},optionChanged:function(n,t){switch(n){case"selection":this.init(),this.getController("columns").updateColumns();break;case"selectedRowKeys":i.isArray(t)&&!this._selectedItemsInternalChange&&this.selectRows(t);break;case"selectionChanged":this.createAction("selectionChanged")}},publicMethods:function(){return["selectRows","selectRowsByIndexes","getSelectedRowKeys","getSelectedRowsData","clearSelection","selectAll","startSelectionWithCheckboxes","stopSelectionWithCheckboxes"]},isSelectedItem:function(n){var t=f(this,n);return t!==-1},isSelectColumnVisible:function(){var n=this.option(u);return this.option(o)==="multiple"&&(n==="always"||n==="onClick"||this._isSelectionWithCheckboxes)},isSelectAll:function(){return this._isSelectAll&&!this._unselectedItemKeys.length},selectAll:function(){return this.option(u)==="onClick"&&this.startSelectionWithCheckboxes(),this.selectedItemKeys([],!0)},clearSelection:function(){this.selectedItemKeys([])},refresh:function(){var n=this,t;return t=n.isSelectAll()?n.selectAll():n.selectedItemKeys(n.option("selectedRowKeys")||[]),t.done(function(){s(n)})},selectedItemKeys:function(r,u){var c=this,y,f,p,e,w=c.getController("data"),a=w.dataSource(),v=a&&a.store(),l,o;return i.isDefined(r)?(v&&(y=n.isArray(r)?n.extend(!0,[],r):[r],c._isSelectAll=u,(y.length||u)&&(f=b(a,y,u),p=n.isFunction(f),(f||u)&&(l=a.filter(),f&&!p&&l?(o=[],o.push(f),o.push(l)):l?o=l:f&&!p&&(o=f),e=n.Deferred(),w.setSelectionLoading(!0),v.load({filter:o}).done(function(n){new t.data.ArrayStore(n).load({filter:f}).done(function(n){e.resolve(n)})}).fail(n.proxy(e.reject,e)).always(function(){w.setSelectionLoading(!1)})))),e=e||n.Deferred().resolve([]),e.done(function(n){var t,i,r=[];if(v&&n.length>0)for(t=0;t<n.length;t++)i=v.keyOf(n[t]),r.push(i);h(c,r,n,u),s(c)}),e):c._selectedItemKeys},getSelectedRowKeys:function(){return this.selectedItemKeys()},selectRows:function(n){return this.selectedItemKeys(n)},selectRowsByIndexes:function(t){var u=this.getController("data").items(),f,r=[];return i.isArray(t)||(t=Array.prototype.slice.call(arguments,0)),n.each(t,function(){var n=u[this];n&&n.rowType==="data"&&r.push(n.key)}),this.selectRows(r)},getSelectedRowsData:function(){return this._selectedItems},changeItemSelection:function(n,t){var i=this,d=i.getController("data"),g=d.items(),f=g[n],b=f&&f.data,k=i.option(o),u,nt,r;return y(k)&&e(f)&&(r=d.keyOf(b),t=t||{},i.isSelectionWithCheckboxes()&&(t.control=!0),t.shift&&k==="multiple"&&i._focusedItemIndex>=0?u=w(i,n,g):t.control?(v(i),nt=i.isSelectedItem(r),k==="single"&&p(i),nt?a(i,r):l(i,b),u=!0):(v(i),i._selectedItemKeys.length===1&&c(i._selectedItemKeys[0],r)||(h(i,[r],[b]),u=!0)),u)?(i._focusedItemIndex=n,s(i),!0):!1},focusedItemIndex:function(n){var t=this;if(i.isDefined(n))t._focusedItemIndex=n;else return t._focusedItemIndex},isSelectionWithCheckboxes:function(){var n=this.option(o),t=this.option(u);return n==="multiple"&&(t==="always"||this._isSelectionWithCheckboxes)},startSelectionWithCheckboxes:function(){var n=this,t=n.isSelectColumnVisible();return n.option(o)==="multiple"&&!n.isSelectionWithCheckboxes()?(n._isSelectionWithCheckboxes=!0,t!==n.isSelectColumnVisible()?n.getController("columns").updateColumns():n.option(u)==="onClick"&&s(n),!0):!1},stopSelectionWithCheckboxes:function(){var n=this,t=n.isSelectColumnVisible();return n._isSelectionWithCheckboxes?(n._isSelectionWithCheckboxes=!1,t!==n.isSelectColumnVisible()&&n.getController("columns").updateColumns(),!0):!1}}}()),r.registerModule("selection",{defaultOptions:function(){return{selection:{mode:"none",showCheckBoxesInMultipleMode:"onClick",allowSelectAll:!0},selectionChanged:null,selectedRowKeys:[]}},controllers:{selection:r.SelectionController},extenders:{controllers:{data:{setDataSource:function(n){this.callBase(n),this.getController("selection").refresh()},setSelectionLoading:function(n){this._isSelectionLoading=n,this._fireLoadingChanged()},isLoading:function(){var n=this.callBase();return n||!!this._isSelectionLoading},pageIndex:function(n){var t=this,i=t._dataSource;return i&&n&&i.pageIndex()!==n&&t.getController("selection").focusedItemIndex(-1),t.callBase(n)},_processDataItem:function(){var i=this,t=i.getController("selection"),r=t.isSelectColumnVisible(),n=this.callBase.apply(this,arguments);return n.isSelected=t.isSelectedItem(n.key),r&&n.values&&(n.values[0]=n.isSelected),n}},columns:{getVisibleColumns:function(){var i=this,r=i.getController("selection"),t=i.callBase();return t=n.grep(t,function(n){return n.command!=="select"}),r.isSelectColumnVisible()&&t.length&&t.unshift({visible:!0,command:"select",dataType:"boolean",alignment:"center",width:70}),t}}},views:{columnHeadersView:{_renderCore:function(n){var t=this;t.getController("selection").selectionChanged.remove(t._selectionChangedHandler),t.callBase(n)},_renderHeaderContent:function(t,i,r){var u=this,o,f=u.getController("selection"),s=function(n){if(n.isSelectAll()||n.getSelectedRowKeys().length===0)return n.isSelectAll()};if(i.command==="select"){t.addClass(e),o=n("<div />").appendTo(t),u.getController("editorFactory").createEditor(o,n.extend({},i,{parentType:"headerRow",value:s(f),setValue:function(n,t){t.jQueryEvent&&s(f)!==n&&((t.previousValue===undefined||t.previousValue)&&(f.clearSelection(),t.component.option("value",!1)),t.previousValue===!1&&(u.option("selection.allowSelectAll")?f.selectAll():t.component.option("value",!1)),t.jQueryEvent.preventDefault())}}));t.on("dxclick",u.createAction(function(t){var i=t.jQueryEvent;n(i.target).closest(".dx-checkbox").length||n(i.currentTarget).children().trigger("dxclick"),i.preventDefault()}));u._selectionChangedHandler=function(){o.dxCheckBox("instance").option("value",s(f))},f.selectionChanged.add(u._selectionChangedHandler)}else u.callBase(t,i,r)}},rowsView:{_getDefaultTemplate:function(t){var i=this,r;return t.command==="select"?function(u,f){u.addClass(e);u.on("dxclick",i.createAction(function(t){var r=i.getController("selection"),u=t.jQueryEvent,f=i.getRowIndex(n(u.currentTarget).closest(".dx-row"));f>=0&&(r.startSelectionWithCheckboxes(),r.changeItemSelection(f,{shift:u.shiftKey}))}));r=n("<div />").addClass(s).appendTo(u),i.getController("editorFactory").createEditor(r,n.extend({},t,{parentType:"dataRow",value:f.value}))}:i.callBase(t)},_update:function(t){var i=this;t.changeType==="updateSelection"?(i._tableElement.length>0&&n.each(t.itemIndexes||[],function(n,r){var u,f;t.items[r]&&(u=i._getRowElements().eq(r),f=!!t.items[r].isSelected,u.toggleClass(o,f),u.find(".dx-checkbox").dxCheckBox("option","value",f))}),i._updateCheckboxesClass()):i.callBase(t)},_createTable:function(){var t=this,i=t.callBase();return i.on(f.addNamespace("dxpointerdown","dxDataGridRowsView"),t.createAction(function(n){t._isTouchEvent=f.isTouchEvent(n.jQueryEvent)})).on(f.addNamespace("dxhold","dxDataGridRowsView"),{timeout:t.option("selection.longTapTime")||h},t.createAction(function(i){var r=t.getController("selection"),f=i.jQueryEvent;t.option(u)==="onLongTap"&&(r.isSelectionWithCheckboxes()?r.stopSelectionWithCheckboxes():r.startSelectionWithCheckboxes()),t.option(u)==="onClick"&&n(f.target).closest(".dx-row").find(s).parent().trigger("dxclick")})).on("mousedown selectstart",t.createAction(function(n){var t=n.jQueryEvent;t.shiftKey&&t.preventDefault()}))},_createRow:function(n){var t=this.callBase(n);return n&&t.toggleClass(o,!!n.isSelected),t},_rowClick:function(n,t){var i=this;i.getController("selection").changeItemSelection(n,{control:t.ctrlKey,shift:t.shiftKey}),i.callBase(n,t)},_renderCore:function(n){this.callBase(n),this._updateCheckboxesClass()},_updateCheckboxesClass:function(){var n=this.getController("selection");this._element().toggleClass("dx-select-checkboxes-hidden",n.isSelectColumnVisible()&&!n.isSelectionWithCheckboxes())}}}}})}(jQuery,DevExpress),function(n,t){var i=t.ui.dataGrid,e=t.ui.events.addNamespace,o=700,s="dx-datagrid-checkbox-size",h="dxDataGridEditorFactory",f=e("focusin dxpointerdown dxclick",h),c=13,l=9,r="dx-datagrid-focus-overlay",u="dx-focused",a="dx-datagrid-content";i.EditorFactoryController=i.Controller.inherit(function(){var e=function(n,i){n.dxDateBox({value:i.value,useCalendar:!0,customOverlayCssClass:"dx-datagrid",formatString:t.utils.isString(i.format)&&t.DateTimeFormat[i.format.toLowerCase()]||i.format,formatWidthCalculator:null,rtlEnabled:i.rtlEnabled,disabled:i.disabled}),n.dxDateBox("instance").optionChanged.add(function(n,t){n==="value"&&i.setValue(t)})},h=function(n,i){var r=function(n){return t.utils.isDefined(n)?n.toString():""},f=i.parentType==="filterRow",u=i.parentType==="searchPanel";n.dxTextBox({placeholder:i.placeholder,width:i.width,value:r(i.value),valueChangeAction:function(t){var u=function(n,t){var u;!i.validate||i.validate(n.value)?(u=i.parseValue?i.parseValue(n.value):n.value,i.setValue(u!==undefined?u:null,n)):t||n.component.option("value",r(n.previousValue))};window.clearTimeout(n._valueChangeTimeoutID),t.jQueryEvent&&t.jQueryEvent.type==="keyup"?n._valueChangeTimeoutID=window.setTimeout(function(){u(t,!0)},o):t.jQueryEvent&&t.jQueryEvent.type==="keydown"?(t.jQueryEvent.which===c||t.jQueryEvent.which===l)&&u(t):u(t)},mode:u?"search":"text",valueChangeEvent:"change keydown"+(f?" keyup":"")+(u?" keyup search":""),rtlEnabled:i.rtlEnabled,disabled:i.disabled})},v=function(t,r){r.parentType==="filterRow"?i(t,n.extend({lookup:{displayExpr:function(n){return n===!0?r.trueText||"true":n===!1?r.falseText||"false":void 0},items:[!0,!1],rtlEnabled:r.rtlEnabled,disabled:r.disabled}},r)):y(t,r)},i=function(n,i){var u=i.lookup,r,f,e=i.parentType==="filterRow";u&&(r=u.items,f=t.data.utils.compileGetter(u.displayExpr),e&&r&&(r=r.slice(0),r.unshift(null)),n.dxSelectBox({value:i.value||null,valueExpr:i.lookup.valueExpr,showClearButton:u.allowClearing&&!e,displayExpr:function(n){return n===null?i.showAllText:f(n)},items:r,valueChangeAction:function(n){i.setValue(n.value,n)},rtlEnabled:i.rtlEnabled,disabled:i.disabled}))},y=function(n,t){n.addClass(s).dxCheckBox({value:t.value,valueChangeAction:function(n){t.setValue&&t.setValue(n.value,n)},rtlEnabled:t.rtlEnabled})};return{_updateFocusCore:function(){var n=this._$focusedElement,t=this.component&&this.component._element();if(t&&(n=t.find("[tabindex]:focus, input:focus"),n.length&&(n=n.closest(".dx-editor-cell > *, .dx-row > td"),n.length))){this.focus(n);return}this.loseFocus()},_updateFocus:function(t){var i=this,u=t.jQueryEvent&&n(t.jQueryEvent.target).hasClass(r);i._isFocusOverlay=i._isFocusOverlay||u,clearTimeout(i._updateFocusTimeoutID),i._updateFocusTimeoutID=setTimeout(function(){delete i._updateFocusTimeoutID,i._isFocusOverlay||i._updateFocusCore(),i._isFocusOverlay=!1})},focus:function(i){var f=this;if(i===undefined)return f._$focusedElement;i&&setTimeout(function(){var e=f._$focusOverlay=f._$focusOverlay||n("<div>").addClass(r),o=!parseInt(i.css("border-left-width"))&&parseInt(i.css("border-right-width"))?"right bottom":"left top";e.show(),e.css("visibility","hidden"),e.appendTo(i.closest("."+a)),e.outerWidth(i.outerWidth()+1),e.outerHeight(i.outerHeight()+1),t.position(e,{my:o,at:o,of:i}),e.css("visibility","visible"),f._$focusedElement&&f._$focusedElement.removeClass(u),i.addClass(u),f._$focusedElement=i})},loseFocus:function(){this._$focusedElement&&this._$focusedElement.removeClass(u),this._$focusedElement=null,this._$focusOverlay&&this._$focusOverlay.hide()},init:function(){var t=this,i=t.component&&t.component._element();n(document).on(f,this.createAction(n.proxy(this._updateFocus,this)));i&&i.on("dxclick","."+r,function(i){var r=n(i.target),u;r.hide(),u=document.elementFromPoint(i.pageX,i.pageY),r.show(),n(u).trigger("dxclick"),t._$focusedElement&&t._$focusedElement.find("input").focus()})},dispose:function(){n(document).off(f)},createEditor:function(n,t){var r=this.option("editorPreparing"),u=this.option("editorPrepared");if(t.rtlEnabled=this.option("rtlEnabled"),t.disabled=this.option("disabled"),t.cancel=!1,r&&r(n,t),!t.cancel){if(t.lookup)i(n,t);else switch(t.dataType){case"date":e(n,t);break;case"boolean":v(n,t);break;default:h(n,t)}u&&u(n,t)}}}}()),i.registerModule("editorFactory",{defaultOptions:function(){return{}},controllers:{editorFactory:i.EditorFactoryController}})}(jQuery,DevExpress),function(n,t){var f=t.ui,e=t.utils,i=f.dataGrid,o="dx-datagrid-column-chooser",r="dx-datagrid-column-chooser-button",s="column-chooser",u="dx-column-chooser-item",h="dx-column-chooser-message",c="dx-datagrid-action-cursor";i.ColumnChooserView=i.View.inherit({_updateItems:function(){var r=this._columnsController.getHiddenColumns(),u=this.option("columnChooser"),t=this._popupContainer.content();t.dxScrollable(i.createScrollableOptions(this)),this._renderColumnChooserItems(t,r),r.length||n("<span />").addClass(h).text(u?u.emptyPanelText:"").appendTo(t.dxScrollable("instance").content())},_initializePopupContainer:function(){var r=this,u=this._element().addClass(o),n=this.option("columnChooser"),t=DevExpress.ui.themes.current(),i=t&&t.indexOf("generic")>-1;e.isDefined(this._popupContainer)||(this._popupContainer=u.dxPopup({visible:!1,shading:!1,closeButton:i,cancelButton:!i,width:n.width,height:n.height,title:n.title,targetContainer:this._element().parent(),rtlEnabled:this.option("rtlEnabled")}).data("dxPopup"),this._popupContainer.optionChanged.add(function(n){n==="visible"&&r.renderCompleted.fire()}))},_renderCore:function(){this.option("columnChooser.enabled")&&this._initializePopupContainer(),this._popupContainer&&this._updateItems()},_renderColumnChooserItems:function(t,i){var r=t.dxScrollable("instance"),f=r.content(),e;f.empty(),n.each(i,function(t,i){e=n("<div />").addClass(i.cssClass).addClass(u).toggleClass(c,i.allowHiding).text(i.caption).appendTo(f)}),r.update()},init:function(){var n=this;n._columnsController=n.getController("columns"),n._columnsController.columnsChanged.add(function(t){i.checkChanges(t.optionNames,["width"])||n.render()})},renderShowColumnChooserButton:function(t){var i=this,f=i.option("columnChooser")||{},u=t.find("."+r);f.enabled?u.length?u.show():n("<div />").addClass(r).appendTo(t).dxButton({icon:s,clickAction:function(){i._popupContainer.toggle(!i._popupContainer.option("visible"))}}):u.hide()},getColumnElements:function(){var n=this._popupContainer&&this._popupContainer.content();return n&&n.find("."+u)},getName:function(){return"columnChooser"},getColumns:function(){return this._columnsController.getHiddenColumns()},allowDragging:function(n){var t=this._popupContainer;return t&&t.option("visible")&&n&&n.allowHiding},getBoundingRect:function(){var i=this,n=i._popupContainer&&i._popupContainer._container(),t;return n&&n.is(":visible")?(t=n.offset(),{left:t.left,top:t.top,right:t.left+n.outerWidth(),bottom:t.top+n.outerHeight()}):null},showColumnChooser:function(){this._popupContainer||(this._initializePopupContainer(),this.render()),this._popupContainer.show()},hideColumnChooser:function(){this._popupContainer&&this._popupContainer.hide()},publicMethods:function(){return["showColumnChooser","hideColumnChooser"]}}),i.registerModule("columnChooser",{defaultOptions:function(){return{columnChooser:{enabled:!1,width:250,height:260,title:Globalize.localize("dxDataGrid-columnChooserTitle"),emptyPanelText:Globalize.localize("dxDataGrid-columnChooserEmptyText")}}},views:{columnChooserView:i.ColumnChooserView},extenders:{views:{headerPanel:{_renderShowColumnChooserButton:function(){this.getView("columnChooserView").renderShowColumnChooserButton(this._element())},_renderCore:function(){this.callBase(),this._renderShowColumnChooserButton()},optionChanged:function(n,t,i){this.callBase(n,t,i);switch(n){case"columnChooser":this._renderShowColumnChooserButton()}},isVisible:function(){var n=this,t=n.getView("columnChooserView").option("columnChooser");return n.callBase()||t&&t.enabled}}}}})}(jQuery,DevExpress),function(n,t){var f=t.ui.dataGrid,l=t.ui.events,a=l.addNamespace,tt=t.utils,v="dx-link",y="dx-editor-cell",s="dx-selection",h="dx-edit-row",c="dx-edit-button",r="__DX_INSERT_INDEX__",p="dx-row-removed",w="dx-row-inserted",b="dx-row-modified",k="dx-cell-modified",d="dx-highlight-outline",g="dxDataGridEditing",nt="dx-datagrid-focus-overlay",u="batch",o="row",i=function(n){var t=n.option("editing.editMode");return t===u?t:o},e=function(t,i){var u=-1;return n.each(i,function(n,i){if(t&&t[r]&&t===i.key||f.equalKeys(t,i.key))return u=n,!1}),u};f.EditingController=f.ViewController.inherit(function(){var f=function(n){return n.getController("data")},s=function(t){return function(i,r){var u=n("<div/>").appendTo(i);t.getController("editorFactory").createEditor(u,n.extend({},r.column,{value:r.value,setValue:r.setValue,parentType:"dataRow",width:null}))}};return{init:function(){var t=this;if(t._insertIndex=1,t._editRowIndex=-1,t._editData=[],t._editColumnIndex=-1,t._columnsController=t.getController("columns"),!t._saveEditorHandler){t._saveEditorHandler=t.createAction(function(r){var f=r.jQueryEvent,s,h,c,e,l,o;i(t)===u&&t.isEditing()&&!t._editCellInProgress&&(h=n(f.target).closest(".dx-overlay-wrapper").length,c=n(f.target).hasClass(nt),o=n(f.target).closest(".dx-data-row").length,s=t._columnsController.getVisibleColumns(),e=n(f.target).closest("td"),l=e.length&&s[e[0].cellIndex].allowEditing,o&&(!o||l)||h||c||t.closeEditCell())});n(document).on("dxclick",t._saveEditorHandler)}t._updateEditButtons()},getEditMode:function(){return i(this)},hasChanges:function(){return this._editData.length},dispose:function(){this.callBase(),n(document).off("dxclick",this._saveEditorHandler)},optionChanged:function(){},publicMethods:function(){return["insertRow","editRow","editCell","closeEditCell","removeRow","saveEditData","recoverRow","undeleteRow","cancelEditData"]},refresh:function(){i(this)===u?(this._editRowIndex=-1,this._editColumnIndex=-1):this.init()},isEditing:function(){return this._editRowIndex>-1},isEditRow:function(n){return this._editRowIndex===n&&this._editColumnIndex===-1},isEditCell:function(n,t){return this._editRowIndex===n&&this._editColumnIndex===t},processItems:function(n){var u=this,f=u._editData,i,t;for(u.update(),i=0;i<f.length;i++)t=f[i].key,t&&t[r]&&t.pageIndex===u._pageIndex&&n.splice(t.rowIndex,0,t);return n},processDataItem:function(t,i,u){var h=this,s,f,o=t.data[r]?t.data:t.key;s=e(o,h._editData),s>=0&&(f=h._editData[s].data,o&&o[r]?(t.inserted=!0,t.key=o,t.data=f):f?(t.modified=!0,t.data=n.extend(!0,{},t.data,f),t.modifiedValues=u(f,i)):t.removed=!0)},insertRow:function(){var n=this,u=f(n),e=n.getView("rowsView"),s=n.option("initNewRow"),h={data:{}},t={pageIndex:u.pageIndex(),rowIndex:e?e.getTopVisibleItemIndex():0};n.refresh(),i(n)===o&&(n._editRowIndex=t.rowIndex),s&&s(h),t[r]=n._insertIndex++,n._editData.push({key:t,data:h.data}),u.updateItems()},editRow:function(n){var t=this,r=f(t),i=r.items()[n],e=t.option("editingStart"),u={data:i.data,key:i.key,cancel:!1};(i.inserted||(u.key=i.key),e&&e(u),u.cancel)||(t.init(),t._editRowIndex=n,t._pageIndex=r.pageIndex(),r.updateItems())},editCell:function(n,t){var r=this,c=r.getView("rowsView"),o=f(r),e=o.items()[n],h=r.option("editingStart"),s={data:e.data,cancel:!1,column:r._columnsController.getVisibleColumns()[t]};return e&&e.rowType==="data"&&!e.removed&&i(r)===u?(e.inserted||(s.key=e.key),h&&h(s),s.cancel)?void 0:(r._editRowIndex=n,r._editColumnIndex=t,r._pageIndex=o.pageIndex(),r._editCellInProgress=!0,o.updateItems(),setTimeout(function(){r._editCellInProgress=!1,c._focusEditor()}),!0):!1},removeRow:function(n){var i=this,o=i.option("editing"),s=o&&o.texts,p=s&&s.confirmDeleteTitle,l=o&&o.editMode===u,a=s&&s.confirmDeleteMessage,v=f(i),c,h=v.items()[n],y=h&&h.key;h&&(c=function(n){i.refresh();var t=e(n,i._editData);t>=0?n&&n[r]?i._editData.splice(t,1):i._editData[t].data=null:i._editData.push({key:n,oldData:h.data}),l?v.updateItems():i.saveEditData()},l||!a?c(y):t.ui.dialog.confirm(a,p).done(function(n){n&&c(y)}))},recoverRow:function(n){return t.utils.logger.warn("'recoverRow' method is deprecated since 14.1. Use the 'undeleteRow' method instead."),this.undeleteRow(n)},undeleteRow:function(n){var t=this,u=f(t),i=u.items()[n],o=i&&i.key,r;i&&(r=e(o,t._editData),r>=0&&(t._editData.splice(r,1),u.updateItems()))},saveEditData:function(){var n=this;n._editRowIndex=-1,n._editColumnIndex=-1,n._saveEditData()},_saveEditData:function(){var t=this,i=f(t),u=i.store(),b,k,h=t.option("rowInserting"),c=t.option("rowInserted"),l=t.option("rowUpdating"),a=t.option("rowUpdated"),v=t.option("rowRemoving"),y=t.option("rowRemoved"),o=[],s=[],p=n.extend({},t._editData),w=function(t,i){n.each(i,function(n,i){var r=e(i,t._editData);r>=0&&t._editData.splice(r,1)})};t._editData.length?(n.each(t._editData,function(t,i){var c=i.data,y=i.oldData,e=i.key,a,f;if(c)if(e&&e[r]){if(f={data:c,cancel:!1},h&&h(f),f.cancel)return;a=u.insert(c)}else{if(f={newData:n.extend({},y,c),oldData:y,key:e,cancel:!1},l&&l(f),f.cancel)return;a=u.update(e,c)}else{if(f={data:y,key:e,cancel:!1},v&&v(f),f.cancel)return;a=u.remove(e)}a.done(n.proxy(o.push,o,e)),s.push(a)}),s.length&&n.when.apply(n,s).always(function(u){var f=u&&u.name==="Error";f||w(t,o),n.when(i.refresh()).always(function(){n.each(p,function(t,i){var s=i.data,o=i.key,e={key:o,data:s};f&&(e.error=u),s?o&&o[r]?c&&c(e):a&&a(e):y&&y(n.extend({},e,{data:i.oldData}))})}),f&&i.dataErrorOccurred.fire(u)})):i.updateItems()},_updateEditButtons:function(){var n=this,t=n._saveChangesButton,i=n._cancelChangesButton,r=n.hasChanges();t&&t.option("disabled",!r),i&&i.option("disabled",!r)},cancelEditData:function(){var n=this,t=f(n);n.init(),t.updateItems()},closeEditCell:function(){var n=this,t=f(n);setTimeout(function(){n._editRowIndex=-1,n._editColumnIndex=-1,t.updateItems()})},update:function(){var n=this,t=f(n);n._pageIndex!==t.pageIndex()&&(n.refresh(),n._pageIndex=t.pageIndex()),n._updateEditButtons()},updateFieldValue:function(n){var t=this,r=n.key,u=n.column.dataField,f=n.column.serializeValue?n.column.serializeValue(n.value):n.value,i;r!==undefined&&(i=e(r,t._editData),i<0&&(i=t._editData.length,t._editData.push({data:{},key:r,oldData:n.data})),t._editData[i]&&(t._editData[i].data[u]=f),t._updateEditButtons())},getColumnTemplate:function(t){var r=this,f=t.column,h,c,e,u;return f.allowEditing&&f.dataField&&!f.command&&r._editRowIndex===t.rowIndex&&(r._editColumnIndex<0||r._editColumnIndex===t.columnIndex)&&t.rowType==="data"?(t.setValue=function(n){t.value=n,r.updateFieldValue(t)},h=f.editCellTemplate||s(r)):f.command==="edit"&&(h=function(t,f){var s=function(t,i,u,f){var e=n("<a />").addClass(v).text(i).on(a("dxclick",g),r.createAction(function(){setTimeout(function(){r[u](f.rowIndex)})}));f.rtlEnabled?t.prepend(e,"&nbsp;"):t.append(e,"&nbsp;")};c=i(r)===o,t.css("text-align","center"),f.rtlEnabled=r.option("rtlEnabled"),e=r.option("editing")||{},u=e.texts||{},r._editRowIndex===f.rowIndex&&c?(s(t,u.saveRowChanges,"saveEditData",f),s(t,u.cancelRowChanges,"cancelEditData",f)):(e.editEnabled&&c&&s(t,u.editRow,"editRow",f),e.removeEnabled&&(f.row.removed?s(t,u.undeleteRow,"undeleteRow",f):s(t,u.deleteRow,"removeRow",f)))}),h},renderEditButtons:function(t){var r=this,o=t.find("."+c),f=r.option("editing")||{},e=function(t,i,u){return n("<div />").addClass(c).addClass("dx-datagrid-"+i+"-button").appendTo(t).dxButton({icon:"edit-button-"+i,clickAction:n.proxy(r,u)}).dxButton("instance")};o.length&&o.remove(),(f.editEnabled||f.insertEnabled||f.removeEnabled)&&i(r)===u&&(r._cancelChangesButton=e(t,"cancel","cancelEditData"),r._saveChangesButton=e(t,"save","saveEditData"),r._updateEditButtons()),f.insertEnabled&&e(t,"addrow","insertRow")}}}()),f.registerModule("editing",{defaultOptions:function(){return{editing:{editMode:"row",insertEnabled:!1,editEnabled:!1,removeEnabled:!1,texts:{editRow:Globalize.localize("dxDataGrid-editingEditRow"),saveRowChanges:Globalize.localize("dxDataGrid-editingSaveRowChanges"),cancelRowChanges:Globalize.localize("dxDataGrid-editingCancelRowChanges"),deleteRow:Globalize.localize("dxDataGrid-editingDeleteRow"),recoverRow:Globalize.localize("dxDataGrid-editingUndeleteRow"),undeleteRow:Globalize.localize("dxDataGrid-editingUndeleteRow"),confirmDeleteMessage:Globalize.localize("dxDataGrid-editingConfirmDeleteMessage"),confirmDeleteTitle:Globalize.localize("dxDataGrid-editingConfirmDeleteTitle")}}}},controllers:{editing:f.EditingController},extenders:{controllers:{data:{init:function(){this._editingController=this.getController("editing"),this.callBase()},reload:function(){return this._editingController.refresh(),this.callBase()},_processItems:function(n){return n=this._editingController.processItems(n),this.callBase(n)},_processDataItem:function(n,t){return this._editingController.processDataItem(n,t,this._generateDataValues),this.callBase(n,t)}},columns:{getVisibleColumns:function(){var u=this,r=u.option("editing"),t=u.callBase();return t=n.grep(t,function(n){return n.command!=="edit"}),r&&((r.editEnabled||r.insertEnabled)&&i(u)===o||r.removeEnabled)&&t.length&&t.push({visible:!0,command:"edit",width:100}),t}}},views:{rowsView:{_getColumnTemplate:function(n){var t=this,i=t.getController("editing").getColumnTemplate(n);return i||t.callBase(n)},_createRow:function(n){var t=this.callBase(n),c,r,f,e,o;return n&&(c=this.getController("editing"),r=c.isEditRow(n.rowIndex),f=!!n.removed,e=!!n.inserted,o=!!n.modified,i(this)===u?t.toggleClass(p,f):t.toggleClass(h,r),t.toggleClass(w,e),t.toggleClass(b,o),(r||e||f||o)&&t.removeClass(s)),t},_rowClick:function(t,i){var r=this,f=r.getController("editing"),e=r.option("editing"),o=n(i.target).closest("td"),u=o.length?o[0].cellIndex:-1,s=r._columnsController.getVisibleColumns()[u],h=u>=0&&e&&e.editEnabled&&s&&s.allowEditing&&f.editCell(t,u);h||f.isEditRow(t)||r.callBase(t,i)},_cellPrepared:function(t,i){var u=i.row&&(i.row.inserted?i.row.values:i.row.modifiedValues),f=i.columnIndex,e=i.column.alignment,o=this.getController("editing"),r;i.isEditing=o.isEditCell(i.rowIndex,f)||o.isEditRow(i.rowIndex)&&i.column.allowEditing,i.isEditing&&(t.addClass(y),e&&t.find("input").first().css("text-align",e)),u&&i.column&&i.column.allowEditing&&u[f]!==undefined&&(i.isEditing||(t.addClass(k),r=t.contents(),n("<div>").addClass(d).append(!r.length||r.length===1&&!r.eq(0).text().length?"&nbsp;":r).appendTo(t))),this.callBase.apply(this,arguments)},_update:function(n){this.callBase(n),n.changeType==="updateSelection"&&this._element().find("."+h).removeClass(s)},_focusEditor:function(){this._tableElement.find("input").first().focus()}},headerPanel:{_renderCore:function(){this.callBase(),this.getController("editing").renderEditButtons(this._element())},isVisible:function(){var t=this,n=t.getController("editing").option("editing");return t.callBase()||n&&(n.insertEnabled||(n.editEnabled||n.removeEnabled)&&n.editMode===u)}}}}})}(jQuery,DevExpress),function(n,t){var u=t.ui,i=u.dataGrid,r=t.utils;i.DataController=i.Controller.inherit({}).include(u.DataHelperMixin).inherit(function(){var u=function(n,t,i){var r=n.option("scrolling.mode"),u=[],f=function(n,t,i,r,u,e){var s,h,o;if(i>=r)t.push.apply(t,n);else for(s=0;s<n.length;s++)o=n[s],"key"in o&&o.items!==undefined?(u.push(o.key),h=!!o.items,(e||!o.isContinuation)&&t.push({rowType:"group",groupIndex:i,data:o,isExpanded:h,values:u.slice(0)}),h&&f(o.items,t,i+1,r,u,e),u.pop()):t.push(o)};return f(t,u,0,i,[],r!=="virtual"&&r!=="infinite"),u};return{init:function(){var t=this;t._items=[],t._columnsController=t.getController("columns"),t._columnsChangedHandler=function(n){var f=n.changeTypes,u=n.optionNames,e=function(){t._columnsController.columnsChanged.remove(e),t.updateItems()};f.sorting||f.grouping?t._dataSource&&(t._dataSource.group(t._columnsController.getGroupDataSourceParameters()),t._dataSource.sort(t._columnsController.getSortDataSourceParameters()),t.reload()):f.columns&&((u.filterValue||u.selectedFilterOperation)&&(!n.column||r.isDefined(n.column.filterValue)||!u.selectedFilterOperation||u.filterValue)&&t._applyFilter(),t._needApplyFilter||i.checkChanges(u,["width","filterValue","selectedFilterOperation"])||t._columnsController.columnsChanged.add(e))},t._gridDataSourceChangedHandler=function(i){var r=t._dataSource,u;r&&!t._isDataSourceApplying&&(t._isDataSourceApplying=!0,n.when(t._columnsController.applyDataSource(r)).done(function(){t._isDataSourceApplying=!1;var n=t._calculateAdditionalFilter(),r=t._needApplyFilter;t._needApplyFilter=!1,r&&n&&n.length?t._applyFilter():t.updateItems(i)}),t._needApplyFilter=!t._columnsController.isDataSourceApplied())},t._columnsController.columnsChanged.add(t._columnsChangedHandler),t._loadingChangedHandler=function(n){t._isLoading=n,t._fireLoadingChanged()},t._loadErrorHandler=function(n){t.dataErrorOccurred.fire(n)},t._viewportSize=20,t._isLoading=!1,t._isCustomLoading=!1,t._refreshDataSource(),t.createAction("dataErrorOccurred",{excludeValidators:["gesture"]}),t.dataErrorOccurred.add(function(n){return t.executeAction("dataErrorOccurred",n)})},callbackNames:function(){return["changed","loadingChanged","dataErrorOccurred"]},callbackFlags:function(n){if(n==="dataErrorOccurred")return"stopOnFalse"},publicMethods:function(){return["beginCustomLoading","endCustomLoading","refresh","filter","clearFilter","keyOf","byKey","getDataByKeys","collapseAll","expandAll","pageIndex","pageSize","pageCount","totalCount","_disposeDataSource"]},optionChanged:function(n){var r=this;switch(n){case"dataSource":case"grouping":case"scrolling":case"rtlEnabled":case"paging":case"columns":r._columnsController.reset(),r._refreshDataSource();break;case"dataErrorOccurred":r.createAction("dataErrorOccurred")}},_dataSourceType:function(){var n=this.option("scrolling");return n&&(n.mode==="virtual"||n.mode==="infinite")?i.ScrollingDataSourceWrapper:i.DataSource},_dataSourceOptions:function(){var i=this,n=i.option("paging"),t=i.option("scrolling"),u=!!(t&&t.mode==="virtual"),r=!!(t&&t.mode==="infinite");return{paginate:n&&n.enabled||u||r,loadingTimeout:i.option("loadingTimeout"),asyncLoadEnabled:!0,pageIndex:n&&n.pageIndex,pageSize:n&&n.pageSize,requireTotalCount:!r,useNativeGrouping:"auto",scrolling:t}},_initDataSource:function(){var i=this._columnsController,r,u,n;if(this.option("dataSource")instanceof t.data.DataSource){t.utils.logger.error("The dataSource option cannot take the DevExpress.data.DataSource instance directly. Assign a DataSource configuration object (see http://js.devexpress.com/Documentation/ApiReference/Data_Library/DataSource/Configuration) or a simple array instead.");return}this.callBase(),n=this._dataSource,n&&(i.updateSortingGrouping(n),r=i.getSortDataSourceParameters(),r&&n.sort(r),u=i.getGroupDataSourceParameters(),u&&n.group(u),this.setDataSource(n))},_processItems:function(t){var i=this,s=i._columnsController.getVisibleColumns(),f=i._columnsController.getGroupColumns(),e=[],o=0;return t.length>0&&i._columnsController.isInitialized()&&(f.length>0&&(t=u(i,t,f.length)),n.each(t,function(n,t){r.isDefined(t)&&(r.isDefined(t.groupIndex)?o=0:(t=i._generateDataItem(t),t=i._processDataItem(t,s),t.dataIndex=o++),e.push(t))})),e},_generateDataItem:function(n){return{rowType:"data",data:n,key:this.keyOf(n)}},_processDataItem:function(n,t){return n.values=this._generateDataValues(n.data,t),n},_generateDataValues:function(t,i){var u=[];return n.each(i,function(){var n=null;r.isDefined(this.groupIndex)?n=null:this.calculateCellValue?n=this.calculateCellValue(t):this.dataField&&(n=t[this.dataField]),u.push(n)}),u},_updateItemsCore:function(n){var t=this,i,r=t._dataSource,f=[],u=n.changeType;if(r){i=n.items||r.items(),i=t._processItems(i.slice(0)),n.items=i,n.changeType=u||"refresh";switch(u){case"prepend":t._items.unshift.apply(t._items,i);break;case"append":t._items.push.apply(t._items,i);break;default:t._items=i}}},updateItems:function(n){var t=this;n=n||{},t._dataSource&&t._columnsController.isDataSourceApplied()&&(t._updateItemsCore(n),t.changed.fire(n))},changeGroupExpand:function(n){this._dataSource&&this._dataSource.changeGroupExpand(n)},getGroupPathByRowIndex:function(n){var t=this.items()[n];if(t&&t.rowType==="group")return t.values},isLoading:function(){return this._isLoading||this._isCustomLoading},_fireLoadingChanged:function(n){this.loadingChanged.fire(this.isLoading(),n)},_calculateAdditionalFilter:function(){return null},_applyFilter:function(){var t=this,r=t._dataSource,i,n=t._filter;if(r)return i=t._calculateAdditionalFilter(),i&&(n=n?[n,"and",i]:i),r.filter(n&&n.length?n:null),r.pageIndex(0),t.reload()},filter:function(n){this._filter=arguments.length>1?Array.prototype.slice.call(arguments,0):n,this._applyFilter()},clearFilter:function(){this._filter=null,this._applyFilter()},setDataSource:function(n){var t=this;t._dataSource&&(t._dataSource.changed.remove(t._gridDataSourceChangedHandler),t._dataSource.loadingChanged.remove(t._loadingChangedHandler),t._dataSource.loadError.remove(t._loadErrorHandler)),t._dataSource=n,n&&(t._isLoading=!n.isLoaded(),t._filter=n.filter(),n.changed.add(t._gridDataSourceChangedHandler),n.loadingChanged.add(t._loadingChangedHandler),n.loadError.add(t._loadErrorHandler),t._needApplyFilter=!0,n.isLoaded()&&t._gridDataSourceChangedHandler())},items:function(){return this._items},virtualItemsCount:function(){var n=this._dataSource;return n&&n.virtualItemsCount&&n.virtualItemsCount()},setViewportSize:function(n){var t=this._dataSource;return t&&t.setViewportSize&&t.setViewportSize(n)},setViewportItemIndex:function(n){var t=this._dataSource;t&&t.setViewportItemIndex&&t.setViewportItemIndex(n)},collapseAll:function(n){var t=this._dataSource;t&&t.collapseAll(n)&&(t.pageIndex(0),t.reload())},expandAll:function(n){var t=this._dataSource;t&&t.expandAll(n)&&(t.pageIndex(0),t.reload())},totalItemsCount:function(){return this._dataSource?this._dataSource.totalItemsCount():0},hasKnownLastPage:function(){return this._dataSource?this._dataSource.hasKnownLastPage():!0},isLoaded:function(){return this._dataSource?this._dataSource.isLoaded():!1},totalCount:function(){return this._dataSource?this._dataSource.totalCount():0},pageCount:function(){return this._dataSource?this._dataSource.pagesCount():1},dataSource:function(){return this._dataSource},store:function(){var n=this._dataSource;return n&&n.store()},keyOf:function(n){var t=this.store();return t&&t.keyOf(n)},byKey:function(t){var i=this.store(),r;if(i)return n.each(this._items,function(i,u){if(u.key===t)return r=n.Deferred().resolve(u.data),!1}),r||i.byKey(t)},getDataByKeys:function(t){var f=this,i=n.Deferred(),r=[],u=[];return n.each(t,function(n,t){r.push(f.byKey(t).done(function(t){u[n]=t}))}),n.when.apply(n,r).always(function(){i.resolve(u)}),i},pageIndex:function(n){var i=this,t=i._dataSource;return t?n!==undefined&&t.pageIndex()!==n?(t.pageIndex(n),t.load()):t.pageIndex():0},pageSize:function(n){var i=this,t=i._dataSource;return n===undefined?t?t.pageSize():0:t?(t.pageIndex(0),t.pageSize(n),t.reload()):void 0},beginCustomLoading:function(n){this._isCustomLoading=!0,this._fireLoadingChanged(n)},endCustomLoading:function(){this._isCustomLoading=!1,this._fireLoadingChanged()},refresh:function(){var i=this,t=n.Deferred();return n.when(this._columnsController.refresh()).always(function(){n.when(i.reload()).done(t.resolve).fail(t.reject)}),t},reload:function(){var n=this._dataSource;return n&&n.reload()},dispose:function(){var n=this,t=n._dataSource;n.callBase(),t&&(t.changed.remove(n._gridDataSourceChangedHandler),t.loadingChanged.remove(n._loadingChangedHandler))}}}()),i.registerModule("data",{defaultOptions:function(){return{dataSource:null,dataErrorOccurred:null}},controllers:{data:u.dataGrid.DataController}})}(jQuery,DevExpress),function(n,t){var o=t.ui,s=t.utils,u=o.dataGrid,r="dx-sort",h="dx-sort-up",c="dx-sort-down",l="dx-sort-alignment-",a="dx-datagrid-text-content",f="dx-datagrid-table-content",v="dx-row",y="dx-group-row",e="dx-datagrid-table";u.ColumnsView=u.View.inherit({_applySorting:function(t,i,u){function a(n){return n==="right"?"left":"right"}var f,e,o;t.find("."+r).remove(),s.isDefined(i.sortOrder)&&(i.alignment==="center"&&(o=this.option("rtlEnabled")?"right":"left",n("<span />").addClass(r).css("float",o).prependTo(t)),e=i.alignment||"left",f=n("<span />").addClass(r).css("float",u?a(i.alignment):e).toggleClass(h,i.sortOrder==="asc").toggleClass(c,i.sortOrder==="desc"),this.option("showColumnLines")?f.prependTo(t):f.addClass(l+e).appendTo(t))},_updateSortIndicatorPositions:function(t){if(t){var i=t.find("."+r);n.each(i,function(){var t=n(this),i=t.parent(),r=i.find("."+a);t.height(r.height()||i.height())})}},_createRow:function(){return n("<tr />").addClass(v)},_createTable:function(){return n("<table />").toggleClass(e,!this.option("columnAutoWidth"))},init:function(){var n=this;n._columnsController=n.getController("columns")},getColumnWidths:function(){var r=this,u,f=[],t,i;return r._tableElement&&(u=r._tableElement.find("tr").filter(":not(."+y+")").first().find("td"),n.each(u,function(r,u){u.getBoundingClientRect?(i=u.getBoundingClientRect(),t=Math.floor(i.right-i.left)):t=n(u).outerWidth(!0),f.push(t)})),f},setColumnWidths:function(n){this._setColumnWidthsCore(this._tableElement,n)},_setColumnWidthsCore:function(t,i){var f,r,u;if(t)for(r=0;r<t.length;r++)if(t.eq(r).addClass(e),i)for(this._columnWidths=i,f=t.eq(r).find("colgroup").first(),f.empty(),u=0;u<i.length;u++)n("<col />").width(i[u]||"auto").appendTo(f)},resetColumnWidths:function(){for(var n=this,i,e=n._columnsController.getVisibleColumns(),o=[],u,t,s,h,r=0;r<e.length;r++)o.push(e[r].width);n.setColumnWidths(o),n._tableElement&&(u=n._tableElement.find(":focus"),t=u.get(0),t&&(s=t.selectionStart,h=t.selectionEnd),i=n._createTable(),i.append(n._tableElement.children()),i.toggleClass(f,n._tableElement.hasClass(f)),i.attr("style",n._tableElement.attr("style")),n._tableElement.replaceWith(i),n._tableElement=i,t&&t.setSelectionRange&&t.setSelectionRange(s,h),u.focus())},getColumnElements:function(){},getColumns:function(){},getCell:function(t,i){var r;if(this._tableElement&&this._tableElement.length===1)return r=this._tableElement[0].rows[i],r?n(r.cells[t]):null},getRowsCount:function(){return this._tableElement&&this._tableElement.length===1?this._tableElement[0].rows.length:0},getBoundingRect:function(){},getName:function(){}})}(jQuery,DevExpress),function(n,t){var f=t.ui,s=f.events,i=t.utils,r=f.dataGrid,e="dx-datagrid-text-content",h="dx-datagrid-action-cursor",o="dx-datagrid-headers-container",c="dx-datagrid-headers",u="dx-header-row",l="dx-datagrid-nowrap",a="dx-datagrid-group-space",v="dx-datagrid-content",y="dx-column-lines",p="context-menu-sort-asc",w="context-menu-sort-desc",b="context-menu-sort-none",k="dx-sort",d="dxDataGridColumnHeadersView";r.ColumnHeadersView=r.ColumnsView.inherit({_renderHeaderContent:function(t,r,u){var s=this,c=n("<div />"),f=r.headerCellTemplate,o,h;r.command==="empty"||r.command==="edit"?t.html("&nbsp;"):i.isDefined(r.groupIndex)?t.addClass(a):(s._applySorting(t,r,s.option("showColumnLines")),o=n("<div />").addClass(e),s.option("showColumnLines")?o.appendTo(t):o.css("float",r.alignment||"left").prependTo(t),h={column:r,columnIndex:u},n.isFunction(f)?f(o,h):i.isString(f)?(f=s.getTemplate(f),f&&f.render(o,h)):o.text(r.caption))},_renderHeader:function(t,r,u){var e=this,o=e.option("sorting"),s=o&&o.mode,f;f=n("<td />").css("text-align",r.alignment||"left").toggleClass(r.cssClass,!i.isDefined(r.groupIndex)),e._renderHeaderContent(f,r,u),((s==="single"||s==="multiple")&&r.allowSorting||r.allowReordering||r.allowHiding)&&!i.isDefined(r.groupIndex)&&f.addClass(h),f.appendTo(t)},_renderCore:function(){var t=this,a=t._element(),e=t._columnsController.getVisibleColumns(),p=t._scrollLeft,w=e.length,f,h;if(t._tableElement=t._createTable().attr("style","-webkit-user-select: none").append(r.createColGroup(e)),t.option("showColumnHeaders")){h=t._createRow().addClass(u).toggleClass(y,t.option("showColumnLines"));h.on(s.addNamespace("dxclick",d),"td",t.createAction(function(n){var u=null,r=n.jQueryEvent;r.stopPropagation(),setTimeout(function(){var n=e[r.currentTarget.cellIndex];r.shiftKey?u="shift":r.ctrlKey&&(u="ctrl"),n&&!i.isDefined(n.groupIndex)&&t._columnsController.changeSortOrder(n.index,u)})}));for(f=0;f<w;f++)t._renderHeader(h,e[f],f);t._tableElement.append(h)}a.addClass(c).addClass(v).toggleClass(l,!!t.option("columnAutoWidth")||!t.option("wordWrapEnabled")).empty(),n("<div/>").addClass(o).append(t._tableElement).appendTo(a),t._scrollLeft=0,t.scrollOffset(p)},setColumnWidths:function(n){var t=this,i=t._scrollLeft;t.callBase(n),t._scrollLeft=0,t.scrollOffset(i)},_afterRender:function(n){var t=this;n||t.setColumnWidths(t._columnWidths&&t._columnWidths.length===t._columnsController.getVisibleColumns().length?t._columnWidths:null),t._updateSortIndicatorPositions(t._element()),t.processSizeChanged()},_updateSortIndicatorPositions:function(t){var i=this,u=i.getColumnElements(),r,f;if(i.callBase(t),!i.option("showColumnLines")&&u)for(r=0;r<u.length;r++)f=n(u[r]),i._setColumnTextWidth(f,f.outerWidth())},_updateSortIndicators:function(){for(var t=this,r=t._columnsController.getVisibleColumns(),f=t._element(),e=f.find("."+u+" > td"),n=0;n<r.length;n++)i.isDefined(r[n].groupIndex)||t._applySorting(e.eq(n),r[n],t.option("showColumnLines"));t._updateSortIndicatorPositions(f)},_processColumnsChanged:function(t){var i;if(r.checkChanges(t.changeTypes,["sorting"])){this._updateSortIndicators();return}if(r.checkChanges(t.optionNames,["width"])){i=this._columnsController.getVisibleIndex(t.columnIndex),i!==-1&&(this._tableElement.find("col").eq(i).css("width",t.column.width),this._updateSortIndicatorPositions(this._element()),this.option("showColumnLines")||this._setColumnTextWidth(n(this._tableElement.find("."+u+" td")[i]),t.column.width)),this._columnWidths&&(this._columnWidths[i]=t.column.width);return}this.render()},_setColumnTextWidth:function(n,t){var i=n.find("."+k),r=i.outerWidth(),u=n.outerWidth()-n.width(),f=r+u;n.find("."+e).css("max-width",t-f)},_isElementVisible:function(n){return n&&n.visible},processSizeChanged:function(){var n=this,t=n._element();i.isDefined(n._headersHeight)&&n._headersHeight===t.height()||(n._headersHeight=t.height(),n.sizeChanged.fire())},getHeaderElement:function(n){var t=this.getColumnElements();return t&&t.eq(n)},getColumnElements:function(){var t=this,n;return t._tableElement&&(n=t._tableElement.find("."+u).find("td"),n.length)?n:null},allowDragging:function(n,t){for(var e=!1,r=this.getColumns(),u=0,f=function(n){return n.allowReordering||n.allowGrouping||n.allowHiding},i=0;i<r.length;i++)f(r[i])&&u++;if(u<=1)return!1;if(!t)return(this.option("allowColumnReordering")||this._columnsController.isColumnOptionUsed("allowReordering"))&&n&&n.allowReordering;for(i=0;i<t.length;i++)if(t[i].allowDragging(n))return!0;return!1},getColumns:function(){return this._columnsController.getVisibleColumns()},getBoundingRect:function(){var n=this,t;return n._tableElement.length>0&&n._tableElement[0].rows.length>0&&n._tableElement[0].rows[0].cells.length>0?(t=n._tableElement.offset(),{top:t.top}):null},getName:function(){return"headers"},getHeadersLength:function(){var n=this;return n._tableElement.length>0&&n._tableElement[0].rows.length>0?n._tableElement[0].rows[0].cells.length:0},tableElement:function(){return this._tableElement},init:function(){var t=this,i=t.getController("data");t.callBase(),t._columnsController.columnsChanged.add(function(n){var r=function(){i.changed.remove(r),t._processColumnsChanged(n)};n.changeTypes.grouping?i.changed.add(r):t._processColumnsChanged(n)}),t._scrollerWidth=0,t.sizeChanged=n.Callbacks()},isVisible:function(){return this.option("showColumnHeaders")},scrollOffset:function(n){var i=this,r=i._element(),t=r&&r.find("."+o);if(n===undefined)return t&&t.scrollLeft();i._scrollLeft!==n&&(i._scrollLeft=n,t&&t.scrollLeft(n))},setScrollerSpacing:function(n){var t=this,i=t._element(),r=t.option("rtlEnabled");t._scrollerWidth=n,i&&i.css(r?{paddingLeft:n}:{paddingRight:n})},optionChanged:function(n){var r=this;switch(n){case"showColumnHeaders":case"wordWrapEnabled":case"showColumnLines":r.render()}},resize:function(){this.callBase(),this._updateSortIndicatorPositions(this._element())},getHeight:function(){var t=this,n=t._element();return n?n.height():0},getContextMenuItems:function(n){var f=this,e,i,r,t;return n.closest("."+u).length&&(e=n.closest("td"),i=e.length&&f.getColumns()[e[0].cellIndex],t=f.option("sorting"),t&&t.mode!=="none"&&i&&i.allowSorting)?(r=function(n){setTimeout(function(){f._columnsController.changeSortOrder(i.index,n.itemData.value)})},[{text:t.ascendingText,value:"asc",icon:p,itemClickAction:r},{text:t.descendingText,value:"desc",icon:w,itemClickAction:r},{text:t.clearText,value:"none",icon:b,itemClickAction:r}]):[]}}),r.registerModule("columnHeaders",{defaultOptions:function(){return{showColumnHeaders:!0}},views:{columnHeadersView:r.ColumnHeadersView}})}(jQuery,DevExpress),function(n,t){var f=t.ui,w=f.events,i=t.utils,r=f.dataGrid,u={"=":"filter-operation-equals","<>":"filter-operation-not-equals","<":"filter-operation-less","<=":"filter-operation-less-equal",">":"filter-operation-greater",">=":"filter-operation-greater-equal","default":"filter-operation-default",notcontains:"filter-operation-not-contains",contains:"filter-operation-contains",startswith:"filter-operation-starts-with",endswith:"filter-operation-ends-with"},e="dx-datagrid-filter-row",h="dx-menu",b="dx-menu-image",k="dx-datagrid-text-content",c="dx-datagrid-group-space",l="dx-editor-with-menu",a="dx-editor-container",v="dx-column-lines",y="dx-editor-cell",o={_processColumnsChanged:function(n){var t=this,u,f,o,i;r.checkChanges(n.optionNames,["filterValue"])||(r.checkChanges(n.optionNames,["selectedFilterOperation"])?(u=t.getController("columns").getVisibleIndex(n.columnIndex),o=n.column,u>=0&&(i=t._element().find("."+e).children().eq(u).find("."+h),i.length&&(t._updateFilterOperationChooser(i,o),f=i.prev().children().data("dxTextBox"),f&&f.option("value",o.filterValue)))):t.callBase(n))},isFilterRowVisible:function(){return this._isElementVisible(this.option("filterRow"))},isVisible:function(){return this.callBase()||this.isFilterRowVisible()},_renderCore:function(){this.callBase();var n=this,r=n._columnsController.getVisibleColumns(),t,i;if(n.isFilterRowVisible())for(i=n._createRow().appendTo(n._tableElement),i.addClass(e).toggleClass(v,n.option("showColumnLines")),t=0;t<r.length;t++)n._renderFilterRowCell(i,r[t])},_updateFilterOperationChooser:function(n,t){var i=this;n.dxMenu({highlightActiveItem:!0,cssClass:"dx-datagrid dx-widget",showFirstSubmenuMode:"onhover",items:[{disabled:t.filterOperations&&t.filterOperations.length?!1:!0,icon:u[t.selectedFilterOperation||"default"],items:i._getFilterOperationMenuItems(t)}],itemClickAction:function(n){var r=n.itemData.name;n.itemData.items||(r?i._columnsController.columnOption(t.initialIndex,"selectedFilterOperation",r):i._columnsController.columnOption(t.initialIndex,{selectedFilterOperation:null,filterValue:null}))},rtlEnabled:i.option("rtlEnabled")})},_renderFilterOperationChooser:function(t,i){var r=this,u;r.option("filterRow.showOperationChooser")&&(t.addClass(l),u=n("<div />").appendTo(t),r._updateFilterOperationChooser(u,i))},_getFilterOperationMenuItems:function(t){var f=this,r=[{}],i=f.option("filterRow"),e=i&&i.operationDescriptions||{};return t.filterOperations&&t.filterOperations.length&&(r=n.map(t.filterOperations,function(n){return{name:n,selectable:!0,selected:(t.selectedFilterOperation||t.defaultFilterOperation)===n,text:e[n],icon:u[n]}}),r.push({name:null,text:i&&i.resetOperationText,allowSelectOnclick:!1,icon:u["default"]})),r},_renderFilterRowCell:function(t,r){var u=this,f=n("<td />").toggleClass(r.cssClass,!i.isDefined(r.groupIndex)).appendTo(t),o=u._columnsController,e,s,h,l=function(n,t,r){var u,f=r;(r===""&&(r=undefined),i.isDefined(t.filterValue)||i.isDefined(r))&&(t.filterValue=r,o.columnOption(t.initialIndex,"filterValue",r))};r.command==="empty"?f.html("&nbsp;"):i.isDefined(r.groupIndex)?f.addClass(c):r.allowFiltering&&(f.addClass(y),e=n("<div />").appendTo(f),s=n("<div />").addClass(a).appendTo(e),h=n("<div />").appendTo(s),u.getController("editorFactory").createEditor(h,n.extend({},r,{value:o.isDataSourceApplied()?r.filterValue:undefined,setValue:function(n){l(u,r,n)},parentType:"filterRow",showAllText:u.option("filterRow.showAllText"),width:null})),r.alignment&&f.find("input").first().css("text-align",r.alignment),r.filterOperations&&r.filterOperations.length&&u._renderFilterOperationChooser(e,r))},optionChanged:function(n){var r=this;switch(n){case"filterRow":case"showColumnLines":case"disabled":r.render();break;default:r.callBase(n)}}},s={_calculateAdditionalFilter:function(){var e=this,f=e.callBase(),r,u=[],t=[],o=e._columnsController.getVisibleColumns();if(n.each(o,function(){var t,n;this.allowFiltering&&this.calculateFilterExpression&&i.isDefined(this.filterValue)&&(n=this.calculateFilterExpression(this.filterValue,this.selectedFilterOperation||this.defaultFilterOperation),n&&u.push(n))}),u.length)for(f&&f.length&&u.unshift(f),r=0;r<u.length;r++)r>0&&t.push("and"),t.push(u[r]);else t=f;return t&&t.length?t:null}},p={_createCalculatedColumnOptions:function(t){var r=this.callBase(t);return t.dataField?n.extend(r,{calculateFilterExpression:function(n,t){var e=this,r=e.dataField,o=null,u,f;if(i.isDefined(n))if(e.dataType!=="string"||e.lookup)if(e.dataType==="date"){if(i.isDate(n)){u=new Date(n.getFullYear(),n.getMonth(),n.getDate()),f=new Date(n.getFullYear(),n.getMonth(),n.getDate()+1);switch(t){case"<":return[r,"<",u];case"<=":return[r,"<",f];case">":return[r,">=",f];case">=":return[r,">=",u];case"<>":return[[r,"<",u],"or",[r,">=",f]];default:return[[r,">=",u],"and",[r,"<",f]]}}}else o=[r,t||"=",n];else o=[r,t||"contains",n];return o},allowFiltering:!0}):n.extend(r,{allowFiltering:!!t.calculateFilterExpression}),r}};r.registerModule("filterRow",{defaultOptions:function(){return{filterRow:{visible:!1,showOperationChooser:!0,showAllText:Globalize.localize("dxDataGrid-filterRowShowAllText"),resetOperationText:Globalize.localize("dxDataGrid-filterRowResetOperationText"),operationDescriptions:{"=":Globalize.localize("dxDataGrid-filterRowOperationEquals"),"<>":Globalize.localize("dxDataGrid-filterRowOperationNotEquals"),"<":Globalize.localize("dxDataGrid-filterRowOperationLess"),"<=":Globalize.localize("dxDataGrid-filterRowOperationLessOrEquals"),">":Globalize.localize("dxDataGrid-filterRowOperationGreater"),">=":Globalize.localize("dxDataGrid-filterRowOperationGreaterOrEquals"),startswith:Globalize.localize("dxDataGrid-filterRowOperationStartsWith"),contains:Globalize.localize("dxDataGrid-filterRowOperationContains"),notcontains:Globalize.localize("dxDataGrid-filterRowOperationNotContains"),endswith:Globalize.localize("dxDataGrid-filterRowOperationEndsWith")}}}},extenders:{controllers:{data:s,columns:p},views:{columnHeadersView:o}}}),r.ColumnHeadersViewFilterRowExtender=o,r.DataControllerFilterRowExtender=s}(jQuery,DevExpress),function(n,t){var u=t.ui,e=u.events,i=u.dataGrid,o="dx-datagrid-header-panel",r="dx-datagrid-group-panel",s="dx-group-panel-message",f="dx-group-panel-item",h="dx-datagrid-action-cursor";i.HeaderPanel=i.ColumnsView.inherit({_renderGroupPanel:function(){var i=this,f=i._element(),u=i.option("groupPanel"),t,e=i.getController("columns").getGroupColumns();t=f.find("."+r),u&&u.visible?(t.length?t.show():t=n("<div />").addClass(r).prependTo(f),i._renderGroupPanelItems(t,e),u.allowColumnDragging&&!e.length&&n("<div />").addClass(s).text(u.emptyPanelText).appendTo(t)):t.hide()},_renderGroupPanelItems:function(t,i){var r=this,u;t.empty(),n.each(i,function(i,o){u=n("<div />").addClass(o.cssClass).addClass(f).toggleClass(h,o.allowSorting||o.allowReordering).appendTo(t).text(o.caption).on(e.addNamespace("dxclick","dxDataGridHeaderPanel"),r.createAction(function(){setTimeout(function(){r.getController("columns").changeSortOrder(o.index)})})),r._applySorting(u,{alignment:"left",sortOrder:o.sortOrder==="desc"?"desc":"asc"},!0)}),r._updateSortIndicatorPositions(t)},_renderCore:function(){var n=this;n._element().addClass(o),n._renderGroupPanel()},getHeaderPanel:function(){return this._element()},allowDragging:function(n){var t=this.option("groupPanel");return t&&t.visible&&t.allowColumnDragging&&n&&n.allowGrouping},getColumnElements:function(){var n=this._element();return n&&n.find("."+f)},getColumns:function(){return this.getController("columns").getGroupColumns()},getBoundingRect:function(){var i=this,n=i._element(),t;return n&&n.find("."+r).length?(t=n.offset(),{top:t.top,bottom:t.top+n.height()}):null},getName:function(){return"group"},init:function(){var n=this;n.callBase(),n.getController("columns").columnsChanged.add(function(t){i.checkChanges(t.optionNames,["width"])||n.render()})},isVisible:function(){var n=this.option("groupPanel");return n&&n.visible},getHeight:function(){var n=this._element();return n?n.outerHeight(!0):0},optionChanged:function(n){var r=this;switch(n){case"searchPanel":r._renderSearchPanel();break;case"groupPanel":r._renderGroupPanel();break;case"disabled":r.render()}},resize:function(){var n=this,t=n._element(),i=t&&t.find("."+r),u=n.option("groupPanel");n.callBase(),n._updateSortIndicatorPositions(i)}}),i.registerModule("headerPanel",{defaultOptions:function(){return{groupPanel:{visible:!1,emptyPanelText:Globalize.localize("dxDataGrid-groupPanelEmptyText"),allowColumnDragging:!0}}},views:{headerPanel:i.HeaderPanel}})}(jQuery,DevExpress),function(n,t){var i=t.ui,f=i.events,e=t.utils,r=i.dataGrid,u="dx-datagrid-search-panel",o=10;r.registerModule("search",{defaultOptions:function(){return{searchPanel:{visible:!1,width:160,placeholder:Globalize.localize("dxDataGrid-searchPanelPlaceholder"),highlightSearchText:!0}}},extenders:{controllers:{data:function(){var n=function(n,i){var o,r,h=n._columnsController.getColumns(),s,e,u,f=[];if(!i)return null;for(o=0;o<h.length;o++)s=null,r=h[o],r.allowFiltering&&r.calculateFilterExpression&&(u=r.lookup,u&&u.items?(e=r.parseValue.call(u,i),t.data.query(u.items).filter(r.calculateFilterExpression.call({dataField:u.displayExpr,dataType:u.dataType},e)).enumerate().done(function(n){for(var o=t.data.utils.compileGetter(u.valueExpr),e,i=0;i<n.length;i++)f.length>0&&f.push("or"),e=o(n[i]),f.push(r.calculateFilterExpression(e))})):(e=r.parseValue?r.parseValue(i):i,e!==undefined&&(s=r.calculateFilterExpression(e),s&&(f.length>0&&f.push("or"),f.push(s)))));return f};return{publicMethods:function(){return this.callBase().concat(["searchByText"])},_calculateAdditionalFilter:function(){var i=this,t=i.callBase(),r=n(i,i._searchText);return r&&(t=t?[t,"and",r]:r),t},searchByText:function(n){var t=this;t._searchText!==n&&(t._searchText=n,t._applyFilter())},getSearchText:function(){return this._searchText||""}}}()},views:{headerPanel:function(){var t=function(n){return n.option("searchPanel")};return{_renderSearchPanel:function(){var i=this,e=i._element(),f=i.getController("data"),r=t(i);r&&r.visible?(i._$searchPanel?i._$searchPanel.show():i._$searchPanel=n("<div/>").addClass(u).prependTo(e),i.getController("editorFactory").createEditor(i._$searchPanel,{width:r.width,placeholder:r.placeholder,parentType:"searchPanel",value:f.getSearchText(),setValue:function(n){f.searchByText(n)}}),i.resize()):i._$searchPanel&&i._$searchPanel.hide()},_renderCore:function(){this.callBase(),this._renderSearchPanel()},focus:function(){var n=this._$searchPanel.dxTextBox("instance");n&&n.focus()},isVisible:function(){var n=t(this);return this.callBase()||n&&n.visible}}}()}}})}(jQuery,DevExpress),function(n,t){var w=t.ui,i=t.utils,r=w.dataGrid,st="dx-datagrid-text-content",o="dx-group-row",s="dx-datagrid-search-text",h="dx-datagrid-rowsview",b="dx-datagrid-table-content",c="dx-datagrid-table",k="dx-row",d="dx-data-row",u="dx-freespace-row",l="dx-datagrid-bottom-load-panel",a="dx-datagrid-nodata",v="dx-datagrid-group-space",g="dx-datagrid-group-opened",nt="dx-datagrid-group-closed",y="dx-datagrid-content",tt="dx-datagrid-nowrap",it="dx-row-lines",f="dx-column-lines",rt="dx-row-alt",ut="dx-editor-cell",e=25e4,ft=200,et=function(n,i){var r={value:n,valueText:t.formatHelper.format(n,i.format,i.precision)||""};return i.customizeText?i.customizeText.call(i,r):r.valueText},ot={render:function(n,t){n.append(t)}},p=function(n){var i=n.option("scrolling.useNativeScrolling"),r={direction:"both",rtlEnabled:n.option("rtlEnabled")||t.rtlEnabled,disabled:n.option("disabled"),bounceEnabled:!1,useKeyboard:!1};return i===undefined&&(i=!0),i!=="auto"&&(r.useNative=!!i,r.useSimulatedScrollbar=!i),r};r.createScrollableOptions=p,r.RowsView=r.ColumnsView.inherit({_getDefaultTemplate:function(n){var t=this;switch(n.command){case"group":return function(n,r){if(!i.isDefined(r.value)||r.data&&r.data.isContinuation)n.addClass(v);else n.addClass(r.value?g:nt).on("dxclick",t.createAction(function(){t._dataController.changeGroupExpand(r.values)}))};case"empty":return function(n){n.html("&nbsp;")};default:return function(t,i){var r=!i.text&&i.rowType==="data",u=r?"&nbsp;":i.text;n.encodeHtml&&!r?t.text(u):t.html(u)}}},_getDefaultGroupTemplate:function(){var n=this;return function(t,i){var u=i.data,r=i.column.caption+": "+i.text;u&&(i.groupContinuedMessage&&i.groupContinuesMessage?r+=" ("+i.groupContinuedMessage+". "+i.groupContinuesMessage+")":i.groupContinuesMessage?r+=" ("+i.groupContinuesMessage+")":i.groupContinuedMessage&&(r+=" ("+i.groupContinuedMessage+")")),t.css("text-align",n.option("rtlEnabled")?"right":"left").text(r)}},_update:function(){},_createRow:function(n){var i=this.callBase(),r,t;return n&&(r=n.rowType==="group",t=n.rowType==="data",i.toggleClass(d,t).toggleClass(rt,t&&n.dataIndex%2==1&&this.option("rowAlternationEnabled")).toggleClass(it,t&&this.option("showRowLines")).toggleClass(f,this.option("showColumnLines")).toggleClass(o,r)),i},_highlightSearchText:function(t,i){var f=this,u,e,r=f._dataController.getSearchText();r&&f.option("searchPanel.highlightSearchText")&&(e=n("<div>").text(r).html(),u=t.parent(),u.length||(u=n("<div>").append(t)),n.each(u.find(":dxicontains('"+r+"')"),function(t,u){n.each(n(u).contents(),function(t,u){if(u.nodeType===3){var f=function(t,i){var e=n("<span />").addClass(s),r=t.text(),u=r.toLowerCase().indexOf(i.toLowerCase());if(u>=0)return t[0].textContent?t[0].textContent=r.substr(0,u):t[0].nodeValue=r.substr(0,u),t.after(e.text(r.substr(u,i.length))),t=n(document.createTextNode(r.substr(u+i.length))).insertAfter(e),f(t,i)};i?n(u).text().toLowerCase()===r.toLowerCase()&&n(this).replaceWith(n("<span />").addClass(s).text(n(u).text())):f(n(u),r)}})}))},_renderTemplate:function(t,r,u){var f=this;if(n.isFunction(r))return r(t,u),!0;if(i.isString(r)&&(f._templatesCache[r]||(f._templatesCache[r]=f.getTemplate(r)),r=f._templatesCache[r],r)){if(r.allowRenderToDetachedContainer)return r.render(t,u),!0;f._delayedTemplates.push({template:r,container:t,options:u})}return!1},_getColumnTemplate:function(n){var r=this,t=n.column,i;return i=t.groupIndex!==undefined?t.groupCellTemplate||r._getDefaultGroupTemplate():t.cellTemplate||r._getDefaultTemplate(t)},_updateCell:function(n,t){var r=this,i=t.column,u=i.dataType!=="string";i.allowFiltering&&r._highlightSearchText(n,u),t.rowType==="data"&&i.groupIndex===undefined&&r._cellPrepared(n,t)},_createCell:function(t,r,u,f,e){var h=this,a,c=h.option("grouping"),v=this.option("scrolling.mode"),o=r&&r.data,y=f.lookup?f.lookup.calculateCellValue(t):t,l=n("<td />").addClass(f.cssClass),s={value:t,displayValue:y,row:r,key:r&&r.key,data:o,rowType:r&&r.rowType,values:r&&r.values,text:et(y,f),rowIndex:u,columnIndex:e,column:f,resized:f.resizedCallbacks};return i.isDefined(f.groupIndex)&&v!=="virtual"&&v!=="infinite"&&(s.groupContinuesMessage=o&&o.isContinuationOnNextPage&&c&&c.groupContinuesMessage,s.groupContinuedMessage=o&&o.isContinuation&&c&&c.groupContinuedMessage),a=h._getColumnTemplate(s),h._renderTemplate(l,a,s)&&h._updateCell(l,s),l},_cellPrepared:function(t,r){var u=this,e=u.option("cellPrepared"),o=r.column.alignment,f=function(t){return{cellElement:n(t.target).closest("td"),jQueryEvent:t,eventType:t.type}};if(o&&(t[0].style.textAlign=o),u.option("cellClick"))t.on("dxclick",function(t){u.executeAction("cellClick",n.extend({},r,f(t)))});if(u.option("cellHoverChanged")){t.on("mouseover",function(t){u.executeAction("cellHoverChanged",n.extend({},r,f(t)))});t.on("mouseout",function(t){u.executeAction("cellHoverChanged",n.extend({},r,f(t)))})}i.isFunction(e)&&e(t,r)},_rowPrepared:function(n,t){var u=this,r=u.option("rowPrepared");i.isFunction(r)&&r(n,t)},_renderScrollable:function(n){var t=this,r=t._element();i.isDefined(t._tableElement)||(t._tableElement=n,r.children().length||r.append("<div />"),t._renderLoadPanel(r),t._renderScrollableCore(r),t._subscribeToWindowScrollEvents(r))},_renderScrollableCore:function(n){var t=this,i=p(t),r=function(n){var i=t._findContentElement();t._hasHeight&&t._rowHeight&&(t._scrollTop=n.scrollOffset.top,t._dataController.setViewportItemIndex(t._scrollTop/t._rowHeight)),t.scrollOffsetChanged.fire(n.scrollOffset)};i.scrollAction=r,i.stopAction=r,n.dxScrollable(i),t._scrollable=n.data("dxScrollable"),t._scrollableContainer=t._scrollable._$container},_renderLoadPanel:function(t){var r=this,i;t.dxLoadPanel&&(i=r.option("loadPanel"),i&&i.enabled?(i=n.extend({shading:!1,message:i.text,position:{of:t},targetContainer:t},i),r._loadPanel?r._loadPanel.option(i):r._loadPanel=n("<div />").appendTo(t.parent()).dxLoadPanel(i).dxLoadPanel("instance")):(r._loadPanel&&r._loadPanel._element().remove(),r._loadPanel=null))},_subscribeToWindowScrollEvents:function(t){var i=this,u=i.disposing,o=i.component._element(),r,f,e;if(o&&!i._windowScrollEvents)for(i._windowScrollEvents=!0,f=function(n,r){var u=function(){var f,u=n.scrollTop();!i._hasHeight&&i._rowHeight&&(u-=t.offset().top,u=u>0?u:0,i._scrollTop=u,i._dataController.setViewportItemIndex(u/i._rowHeight))};return r?function(n){u(n),r(n)}:u},e=function(t){var r=t.data("dxScrollable"),i,e;if(r)e=r.option("scrollAction"),i=f(t,e),r.option("scrollAction",i),u&&u.add(function(){r.option("scrollAction")===i&&r.option("scrollAction",e)});else if(t.is(document)||t.css("overflow-y")==="auto"){t.is(document)&&(t=n(window)),i=f(t);t.on("scroll",i);u&&u.add(function(){t.off("scroll",i)})}},r=i.component._element().parent();r.length;r=r.parent())e(r)},_renderContent:function(t,i){var r=this,t,f,u=r._dataController.virtualItemsCount();return r._tableElement=i,t.addClass(y),u?(i.addClass(b),t.children().length?t.children().first().replaceWith(i):t.append(i),t.children().length===1&&(t.append(r._createTable()),r._contentHeight=0)):t.replaceWith(n("<div>").addClass(y).append(i)),t},_updateContentPosition:function(){var n=this,r,i,f=n._rowHeight||20,u=n._dataController.virtualItemsCount();u&&(r=n._findContentElement(),t.translator.move(r.children().first(),{top:Math.floor(u.begin*f)}),i=(u.begin+u.end)*f+r.children().first().outerHeight(),(n._contentHeight!==i||i===0)&&(n._contentHeight=i,n._updateContainerHeight(r.children().eq(1),i)))},setColumnWidths:function(n){this._setColumnWidthsCore(this._findContentElement().children(),n)},_updateContent:function(n,t){var i=this,r=i._findContentElement(),f=i._rowHeight||20,u,e=i._dataController.virtualItemsCount();i.setColumnWidths(),t==="append"||t==="prepend"?(u=r.children().first(),n.find("tr")[t==="append"?"appendTo":"prependTo"](u)):i._renderContent(r,n),i._updateBottomLoading()},_renderFreeSpaceRow:function(n,t){var e=this,r,o=e._createRow().hide(),s;for(o.addClass(u).toggleClass(f,e.option("showColumnLines")),r=0;r<t.length;r++)s={command:i.isDefined(t[r].groupIndex)?"group":"",cssClass:i.isDefined(t[r].cssClass)?t[r].cssClass:""},o.append(e._createCell(null,null,null,s));e._appendRow(n,o),e._freeSpaceRowElement=o},_updateRowHeight:function(){var t=this,i,r=t._element(),u=t._dataController.items().length,f=t._rowHeight,e;r&&u>0&&(!f||t.option("scrolling.mode")==="infinite")&&(i=t._tableElement.outerHeight(),t._freeSpaceRowElement&&t._freeSpaceRowElement.is(":visible")&&(i-=t._freeSpaceRowElement.outerHeight()),t._rowHeight=i/u,!f&&t._rowHeight&&(t._updateContentPosition(),e=t._hasHeight?r.outerHeight():n(window).outerHeight(),t._dataController.setViewportSize(Math.round(e/t._rowHeight))))},_updateContainerHeight:function(n,t){for(var l=this,s=l._columnsController.getVisibleColumns(),h=n.find("colgroup").prop("outerHTML")||r.createColGroup(s).prop("outerHTML"),a="",p=l.option("showColumnLines")?f:"",y=function(n){return'<tr style="height:'+n+'px;" class="'+u+" "+k+" "+p+'" >'+a+"<\/tr>"},o=0;o<s.length;o++)a+=i.isDefined(s[o].groupIndex)?'<td class="'+v+'"/>':"<td />";while(t>e)h+=y(e),t-=e;h+=y(t),n.addClass(c),n.html(h)},_findContentElement:function(){var t=this._element(),n;if(t)return n=t.find(".dx-scrollable-content"),n||(n=t),n.children().first()},_findBottomLoadPanel:function(){var n=this._element().find("."+l);if(n.length)return n},_getRowElements:function(){return this._element().find(".dx-row:not(."+u+")")},_updateBottomLoading:function(){var i=this,r=i.option("scrolling"),u=r&&r.mode==="virtual",f=r&&r.mode==="infinite",e=!i._dataController.hasKnownLastPage()&&i._dataController.isLoaded()&&(u||f),t=i._findBottomLoadPanel();e?(t=t||n("<div />").addClass(l).append(n("<div />").dxLoadIndicator()),t.appendTo(i._findContentElement()),t.show()):t&&t.hide()},_appendRow:function(n,t){var i=this;i.option("rowTemplate")&&i._delayedTemplates.length&&t?i._delayedTemplates.push({container:n,template:ot,options:t}):n.append(t)},_updateNoDataText:function(){var t=this._element().find("."+a),u=!this._dataController.items().length,f=this._dataController.isLoading(),i=this.option("rtlEnabled"),r={};t.length||(t=n("<span>").addClass(a).hide().appendTo(this._element())),t.text(this.option("noDataText")),r={marginTop:-Math.floor(t.height()/2),marginRight:i?-Math.floor(t.width()/2):0,marginLeft:i?0:-Math.floor(t.width()/2)},t.css(r),u&&!f?t.show():t.hide()},_createTable:function(){var t=this;return t.callBase().on("dxclick",".dx-row",t.createAction(function(i){var r=i.jQueryEvent;n(r.target).closest("."+ut).length||n(r.target).closest("a").length||(t._rowClick(t.getRowIndex(r.currentTarget),r),r.preventDefault())}))},_rowClick:function(i,r){var u=this._dataController.items()[i]||{};this.executeAction("rowClick",n.extend({rowIndex:i,columns:this._columnsController.getVisibleColumns(),jQueryEvent:r,rowElement:n(r.target).closest(".dx-row"),evaluate:function(n){var i=t.data.utils.compileGetter(n);return i(u.data)}},u))},_renderTable:function(t){var f=this,k=t.length,u,c,v,p,w,e,s,a,h=[],b=0,o=f._columnsController.getVisibleColumns(),y=f.option("rowTemplate"),d=f.option("scrolling.mode"),l=f._createTable();for(l.append(r.createColGroup(o)),e=0;e<o.length;e++)if(o[e].groupIndex!==undefined){b=e;break}for(e=0;e<k;e++){if(u=t[e],u.rowIndex=e,h=[],u.groupIndex!==undefined){for(c=f._createRow(u),a=u.groupIndex+b,s=0;s<a;s++)h.push(f._createCell(null,u,e,{command:"group"}));o[a].allowCollapsing&&d!=="infinite"?h.push(f._createCell(!!u.isExpanded,u,e,{command:"group"})):h.push(f._createCell(null,u,e,{command:"group"})),v=f._createCell(u.values[u.groupIndex],u,e,o[a]),v.attr("colspan",o.length-a-1),h.push(v)}else if(y)f._renderTemplate(l,y,n.extend({columns:o},u));else for(p=u.values,w=o.length,c=f._createRow(u),s=0;s<w;s++)h.push(f._createCell(p[s],u,e,i.isDefined(o[s].groupIndex)?{command:"group"}:o[s],s));h.length&&c.append(h),c&&f._rowPrepared(c,n.extend({columns:o},u)),f._appendRow(l,c)}return y&&f._highlightSearchText(l),f._renderFreeSpaceRow(l,o),l},_renderCore:function(n){var t=this,f=n&&n.items||t._dataController.items(),e=n&&n.changeType,r=t._element(),u=r.parent(),i;r.addClass(h).toggleClass(tt,!t.option("wordWrapEnabled")),i=t._renderTable(f),t._renderScrollable(i),t._updateContent(i,e),(!u||u.parent().length)&&t.renderDelayedTemplates(),t._updateContentPosition(),t._lastColumnWidths=null},getRowIndex:function(n){return this._getRowElements().index(n)},getRow:function(t){var i=this._getRowElements();if(i.length>t)return n(i[t])},getCell:function(t,i){var u=this._getRowElements(),r;if(u.length>0&&i>=0&&(i=i<u.length?i:u.length-1,r=u[i].cells,r&&r.length>0))return n(r[r.length>t?t:r.length-1])},getTableFromCell:function(n){return n.closest("."+h+" ."+c)},updateFreeSpaceRowHeight:function(){var n=this,u,f=n._findContentElement(),e=0,t,i,r;n._freeSpaceRowElement&&f&&(n._freeSpaceRowElement.hide(),u=n._element().height(),e=f.outerHeight(),r=u-e-n.getScrollbarWidth(!0),n._dataController.items().length>0&&(r>0?(n._freeSpaceRowElement.height(r),n._freeSpaceRowElement.show()):n._hasHeight||(t=n._dataController.pageSize()-n._dataController.items().length,i=n.option("scrolling.mode"),t>0&&n._dataController.pageCount()>1&&i!=="virtual"&&i!=="infinite"&&(n._freeSpaceRowElement.height(t*n._rowHeight),n._freeSpaceRowElement.show()))))},ctor:function(t){this.callBase(t),this.scrollOffsetChanged=n.Callbacks()},init:function(){var t=this,i;t.callBase(),t._dataController=t.getController("data"),t._columnsController.columnsChanged.add(function(u){var f,e,o;r.checkChanges(u.optionNames,["width"])&&(e=u.column,i=t._columnsController.getVisibleIndex(u.columnIndex),i!==-1&&(o=t._findContentElement().children(),n.each(o,function(t,r){n(r).find("col").eq(i).css("width",e.width)}),u.column.resizedCallbacks&&u.column.resizedCallbacks.fire(e.width),f=t.getController("editorFactory"),f&&f.focus(f.focus())))}),t._rowHeight=0,t._scrollTop=0,t._hasHeight=!1,t._dataController.changed.add(function(n){switch(n.changeType){case"refresh":case"prepend":case"append":t.render(null,n);break;default:t._update(n)}}),t._dataController.loadingChanged.add(function(n,i){t.setLoading(n,i)}),t._delayedTemplates=[],t._templatesCache={},t.createAction("rowClick"),t.createAction("cellClick"),t.createAction("cellHoverChanged",{excludeValidators:["gesture"]})},publicMethods:function(){return["isScrollbarVisible","getTopVisibleRowData"]},renderDelayedTemplates:function(){for(var n,t=this._delayedTemplates;t.length;)n=t.shift(),n.template.render(n.container,n.options),n.options.column&&this._updateCell(n.container,n.options)},getScrollbarWidth:function(n){var t=this._scrollableContainer&&this._scrollableContainer.get(0),i=0;return t&&(i=n?t.offsetHeight-t.clientHeight:t.offsetWidth-t.clientWidth),i},resize:function(){for(var n=this,e=n._lastColumnWidths||[],u=n.getColumnWidths(),r=n._columnsController.getVisibleColumns(),f,t=0;t<r.length;t++)r[t].resizedCallbacks&&!i.isDefined(r[t].groupIndex)&&e[t]!==u[t]&&r[t].resizedCallbacks.fire(u[t]);n._lastColumnWidths=u,n._updateRowHeight(),n._updateNoDataText(),n.updateFreeSpaceRowHeight(),f=n._element().data("dxScrollable"),f&&f.update(),n.callBase()},scrollToPage:function(n){var t=this,r=t.option("scrolling.mode"),u=t._dataController,f=u?u.pageSize():0,i;i=r==="virtual"||r==="infinite"?n*t._rowHeight*f:0,t.scrollTo({y:i,x:0})},scrollTo:function(n){var t=this._element(),i=t&&t.data("dxScrollable");i&&i.scrollTo(n)},height:function(n){var r=this,t=this._element();if(i.isDefined(n))r._hasHeight=n!=="auto",t&&t.height(n),r._freeSpaceRowElement&&r._freeSpaceRowElement.hide();else return t?t.height():0},setLoading:function(n,t){var i=this,r=i._loadPanel,f=i._dataController,s=!!i._findBottomLoadPanel()&&f.isLoaded(),e=i.option("loadPanel")||{},h=f.isLoaded()?e.animation:null,o=s?!1:n,u;r&&(u={message:t||e.text,animation:h,visible:o},clearTimeout(i._hideLoadingTimeoutID),r.option("visible")&&!o?i._hideLoadingTimeoutID=setTimeout(function(){r.option(u)},ft):r.option(u),i._updateNoDataText())},isScrollbarVisible:function(){var n=this._element();return n?this._findContentElement().outerHeight()-n.height()>0:!1},setRowsOpacity:function(t,i){var r=this,u=r._getRowElements().not("."+o)||[];n.each(u,function(r,u){n(u).children().eq(t).css({opacity:i})})},getTopVisibleItemIndex:function(){for(var t=this,r=0,i=0,e=t._getRowElements(),u=t._scrollTop,o=t._findContentElement().offset().top,f=t._dataController.items(),n=0;n<f.length;n++)if(r=i,i=e.eq(n).offset().top-o,i>u){u*2<i+r&&n&&n--;break}return n&&n===f.length&&n--,n},getTopVisibleRowData:function(){var n=this.getTopVisibleItemIndex(),t=this._dataController.items();if(t[n])return t[n].data},optionChanged:function(n){var r=this;switch(n){case"wordWrapEnabled":case"hoverStateEnabled":case"showColumnLines":case"showRowLines":case"rowAlternationEnabled":case"rowTemplate":case"cellPrepared":case"rowPrepared":r.render(),r.component.resize();break;case"scrolling":case"rtlEnabled":r._rowHeight=null,r._tableElement=null;break;case"disabled":case"loadPanel":r._tableElement=null,r.render(),r.component.resize();break;case"noDataText":r._updateNoDataText();break;case"cellHoverChanged":r.createAction("cellHoverChanged",{excludeValidators:["gesture"]}),r.render(),r.component.resize();break;case"rowClick":r.createAction("rowClick");break;case"cellClick":r.createAction("cellClick")}},dispose:function(){clearTimeout(this._hideLoadingTimeoutID)}}),r.registerModule("rows",{defaultOptions:function(){return{hoverStateEnabled:!1,cellHoverChanged:null,scrolling:{mode:"standard",preloadEnabled:!1,useNativeScrolling:"auto"},loadPanel:{enabled:!0,text:Globalize.localize("Loading"),width:200,height:70,showIndicator:!0,indicatorSrc:"",showPane:!0},rowClick:null,cellClick:null,rowTemplate:null,columnAutoWidth:!1,noDataText:Globalize.localize("dxDataGrid-noDataText"),wordWrapEnabled:!1,showColumnLines:!0,showRowLines:!1,rowAlternationEnabled:!1,cellPrepared:null,rowPrepared:null,activeStateEnabled:!1}},views:{rowsView:r.RowsView},extenders:{controllers:{data:{_applyFilter:function(){var t=this,n=t.callBase();return n&&n.done&&n.done(function(){t.getView("rowsView").scrollToPage(0)}),n},pageIndex:function(n){var i=this,t=i.callBase(n);return t&&t.done&&t.done(function(){i.getView("rowsView").scrollToPage(i.pageIndex())}),t},pageSize:function(n){var i=this,t=i.callBase(n);return t&&t.done&&t.done(function(){i.getView("rowsView").scrollToPage(i.pageIndex())}),t},_refreshDataSource:function(){var n=this,t=function(){n.changed.remove(t),n.getView("rowsView").scrollToPage(0)};n.changed.add(t),n.callBase()}}}}})}(jQuery,DevExpress),function(n,t){var r=t.ui,o=r.events,u=t.utils,i=r.dataGrid,f="dx-datagrid-pager",e=10;i.PagerView=i.View.inherit({init:function(){var n=this,t=n.getController("data");n._isVisible=!1,t.changed.add(function(){n.render()})},_getPager:function(){var n=this._element();return n&&n.data("dxPager")},_renderCore:function(){var t=this,r=t._element().addClass(f),i=t.option("pager"),n=t.getController("data"),u=t.option("rtlEnabled");r.dxPager({maxPagesCount:e,pageIndex:n.pageIndex()+1,pagesCount:n.pageCount(),pageSize:n.pageSize(),showPageSizes:i&&i.showPageSizeSelector,pageSizes:t.getPageSizes(),rtlEnabled:u,hasKnownLastPage:n.hasKnownLastPage(),pageIndexChanged:function(t){window.setTimeout(function(){n.pageIndex(t-1)})},pageSizeChanged:function(t){window.setTimeout(function(){n.pageSize(t)})}})},getPageSizes:function(){var t=this,e=t.getController("data"),r=t.option("pager"),f=r&&r.allowedPageSizes,i=e.pageSize();return u.isDefined(t._pageSizes)&&n.inArray(i,t._pageSizes)!==-1||(t._pageSizes=[],r&&(n.isArray(f)?t._pageSizes=f:f&&i>1&&(t._pageSizes=[Math.floor(i/2),i,i*2]))),t._pageSizes},isVisible:function(){var n=this,i=n.getController("data"),u=n.option("pager"),t=u&&u.visible,r=n.option("scrolling");return n._isVisible?!0:(t==="auto"&&(t=r&&(r.mode==="virtual"||r.mode==="infinite")?!1:i.pageCount()>1||i.isLoaded()&&!i.hasKnownLastPage()),n._isVisible=t,t)},getHeight:function(){var n=this._getPager();return n&&this.isVisible()?n.getHeight():0},optionChanged:function(n){var r=this;switch(n){case"paging":case"pager":r._pageSizes=null;case"scrolling":r._isVisible=!1,r.render(),n==="pager"&&r.component&&r.component.resize()}}}),i.registerModule("pager",{defaultOptions:function(){return{paging:{enabled:!0,pageSize:undefined,pageIndex:undefined},pager:{visible:"auto",showPageSizeSelector:!1,allowedPageSizes:"auto"}}},views:{pagerView:i.PagerView}})}(jQuery,DevExpress),function(n,t){var i=t.ui.dataGrid,f=t.utils,e="dx-datagrid",o=100,s=50,r=["columnsSeparatorView","blockSeparatorView","trackerView","headerPanel","columnHeadersView","rowsView","columnChooserView","pagerView","draggingHeaderView","contextMenuView","errorView"],h=function(n,t){var r=[],i;if(n&&t&&n.length&&n.length===t.length)for(i=0;i<n.length;i++)r.push(n[i]>t[i]?n[i]:t[i]);return r},u=function(n){return f.isString(n)&&n.slice(-1)==="%"};i.createColGroup=function(t){for(var r=n("<colgroup />"),u=t.length,i=0;i<u;i++)n("<col />").width(t[i].width).appendTo(r);return r},i.GridView=i.View.inherit({_initResizeHandlers:function(){var n=this;n._refreshSizesHandler||(n._refreshSizesHandler=function(t){t&&t.changeType!=="refresh"&&t.changeType!=="append"||n.resize()},n._dataController.changed.add(n._refreshSizesHandler),n._columnHeadersView.sizeChanged.add(n._refreshSizesHandler))},_synchronizeColumns:function(){var t=this,o=t._rowsView.getColumnWidths(),s=t._columnHeadersView.getColumnWidths(),r={length:0},c=!1,l=!1,f=t.component._element(),a=t.option("width"),i=s?h(o,s):o,e;n.each(t._columnsController.getVisibleColumns(),function(n){this.width&&this.width!=="auto"||(c=!0),u(this.width)&&(l=!0),this.width&&this.width!=="auto"&&(i[n]=this.width,r[n]=!0,r.length++)}),f&&f.css("max-width",""),!c&&i.length&&(e=t._getTotalWidth(i,t._groupElement.width()-t._rowsView.getScrollbarWidth()),e<t._groupElement.width()-t._rowsView.getScrollbarWidth()&&(i[i.length-1]="auto",f.css("max-width",a&&a!=="auto"||l?"":e))),t.option("columnAutoWidth")&&i.length>0&&t._processStretch(i,t._groupElement.width()-t._rowsView.getScrollbarWidth(),r),t._rowsView.setColumnWidths(i),t._columnHeadersView.setColumnWidths(i)},_processStretch:function(n,t,i){var o=this._getTotalWidth(n,t),u,f,e,r;if(u=t-o,f=Math.floor(u/(n.length-i.length)),e=u-f*(n.length-i.length),u>=0)for(r=0;r<n.length;r++)i[r]||(n[r]+=f,r<e&&n[r]++)},_getTotalWidth:function(n,t){for(var f=0,i,r=0;r<n.length;r++)i=n[r],i&&(f+=u(i)?parseInt(i)*t/100:parseInt(i));return Math.round(f)},getView:function(n){return this.component._views[n]},getViews:function(){return this.component._views},resize:function(){var t=this,c=t._dataController,h=t._rootElement.height(),i=t.option("loadPanel"),u=t.option("height"),f,e;u&&t._hasHeight^u!=="auto"&&(e=n("<div>").height(u).appendTo(t._rootElement),t._hasHeight=!!e.height(),e.remove()),t._hasHeight&&h>0&&t.option("scrolling")?t._rowsView.height(h-t._headerPanel.getHeight()-t._columnHeadersView.getHeight()-t._pagerView.getHeight()):f=t._hasHeight||c.items().length!==0?"auto":i&&i.visible?i.height+s:o,t._rowsView.height(f),t._rowsView.resetColumnWidths(),t._columnHeadersView.resetColumnWidths(),t._columnHeadersView.setScrollerSpacing(t._rowsView.getScrollbarWidth()),t._synchronizeColumns(),n.each(r,function(n,i){var r=t.getView(i);r&&r.resize()})},optionChanged:function(n){switch(n){case"width":case"height":this.resize()}},init:function(){var n=this;n._dataController=n.getController("data"),n._columnsController=n.getController("columns"),n._columnHeadersView=n.getView("columnHeadersView"),n._headerPanel=n.getView("headerPanel"),n._rowsView=n.getView("rowsView"),n._pagerView=n.getView("pagerView"),n._rowsView.scrollOffsetChanged.add(function(t){n._columnHeadersView.scrollOffset(t.left)}),n._dataController.changed.add(function(){n.component._fireContentReadyAction()}),n._options={}},element:function(){return this._groupElement},render:function(t){var i=this,o,f,u=i._groupElement||n("<div />").addClass(e);i._rootElement=t||i._rootElement,o=!i._groupElement,i._groupElement=u,n.each(r,function(n,t){var r=i.getView(t);r&&r.render(u)}),o&&(i._hasHeight=!!i._rootElement.height(),i._groupElement=u,u.appendTo(i._rootElement),i._rowsView.renderDelayedTemplates()),i._initResizeHandlers(),i.resize(),f=i._dataController.isLoading(),f||i.component._fireContentReadyAction(),i._rowsView.setLoading(f)}}),i.registerModule("gridView",{views:{gridView:i.GridView}})}(jQuery,DevExpress),function(n,t){var s=t.ui,f=s.events,r=f.addNamespace,o=t.utils,i=s.dataGrid,h=t.fx,k="dx-datagrid-columns-separator",c="dx-datagrid-columns-separator-transparent",l="dx-datagrid-drag-header",d="dx-datagrid-text-content",g="dx-datagrid-action-cursor",a="dx-datagrid-tracker",v="dx-block-separator",y="dx-datagrid-drop-highlight",p="dx-header-row",nt="dx-widget",u="dxDataGridResizingReordering",tt=10,w=5,e=function(n){return n.option("allowColumnResizing")||n.getController("columns").isColumnOptionUsed("allowResizing")},b=function(n){return n.option("allowColumnReordering")||n.getController("columns").isColumnOptionUsed("allowReordering")};i.getPointsByColumns=function(n,t,i){for(var e=n.length,h=!1,o,u,f,c=[],l,s=0,r=0;r<=e;r++)r<e&&(u=n.eq(s),f=u.offset(),l=u.css("direction")==="rtl"),o={index:r,x:f?f.left+(!i&&l^r===e?u.outerWidth():0):0,y:f?f.top+(i&&r===e?u.outerHeight():0):0,columnIndex:s},t&&(h=t(o)),h||c.push(o),s++;return c},i.TrackerView=i.View.inherit({_renderCore:function(){this.callBase(),this._element().addClass(a),this.hide()},init:function(){var t=this,n;t.callBase(),t.getController("tablePosition").positionChanged.add(function(i){n=t._element(),n&&n.hasClass(a)&&(n.css({top:i.top}),n.height(i.height))})},isVisible:function(){return e(this)},show:function(){this._element().show()},hide:function(){this._element().hide()},setHeight:function(n){this._element().height(n)}}),i.ColumnsSeparatorView=i.View.inherit({_isShown:!0,_renderCore:function(n){this.callBase(n),this._element().addClass(k),this._isShown=!0,this.hide()},_subscribeToEvent:function(){var t=this,n;t.getController("tablePosition").positionChanged.add(function(i){n=t._element(),n&&(n.css({top:i.top}),n.height(i.height))})},isVisible:function(){return this.option("showColumnHeaders")&&(b(this)||e(this))},init:function(){this.callBase(),this._isTransparent=e(this),this.isVisible()&&this._subscribeToEvent()},show:function(n){var i=this,t=this._element(),r=function(n){h.stop(t,!0),h.animate(t,{type:"slide",from:{width:0,display:n.display},to:n,duration:300,easing:"swing"})};t&&!i._isShown&&(n==="group"?r({width:"50px",display:"inline-block"}):n==="columnChooser"?r({width:"100%",display:"block"}):i._isTransparent?t.removeClass(c):t.show()),i._isShown=!0},hide:function(){var n=this._element();n&&this._isShown&&(this._isTransparent?n.addClass(c):n.hide()),this._isShown=!1},height:function(n){var t=this._element();if(t)if(o.isDefined(n))t.height(n);else return t.height()},width:function(n){var t=this._element();if(t)if(o.isDefined(n))t.width(n);else return t.width()},moveByX:function(n){var t=this._element();t&&t.css("left",n-this._parentElement().offset().left)},changeCursor:function(n){n=o.isDefined(n)?n:"";var t=this._element();t&&t.css("cursor",n)}}),i.BlockSeparatorView=i.ColumnsSeparatorView.inherit({_subscribeToEvent:function(){},_renderCore:function(n){this._isTransparent=!1,this.callBase(n),this._element().addClass(v).html("&nbsp;")},hide:function(){var t=this,n=this._parentElement();t.callBase(),n&&!n.children("."+v).length&&n.prepend(t._element())},isVisible:function(){var n=this.option("groupPanel"),t=this.option("columnChooser");return n&&n.visible||t&&t.enabled}}),i.DraggingHeaderView=i.View.inherit({_isDragging:!1,_getDropOptions:function(){var n=this;if(n._dragOptions)return{sourceColumnIndex:n._dragOptions.columnIndex,sourceColumnElement:n._dragOptions.columnElement,sourceLocation:n._dragOptions.sourceLocation,targetColumnIndex:n._dropColumnIndex,targetLocation:n._dropLocation}},_dropHeader:function(n){var r=n.jQueryEvent,t=r.data.that,i=t._controller;t._element().hide(),i&&t._isDragging&&i.drop(t._getDropOptions()),t._element().appendTo(t._parentElement()),t._dragOptions=null,t._isDragging=!1,document.onselectstart=t._onSelectStart||null},_getDraggingPanelByPos:function(t){var r=this,i;return n.each(r._dragOptions.draggingPanels,function(n,r){if(r){var u=r.getBoundingRect();if(u&&(u.bottom===undefined||t.y<u.bottom)&&(u.top===undefined||t.y>u.top)&&(u.left===undefined||t.x>u.left)&&(u.right===undefined||t.x<u.right))return i=r,!1}}),i},_pointCreated:function(n,t,i,r){var u=t[n.columnIndex],f=t[n.columnIndex-1];switch(i){case"columnChooser":return!0;case"headers":return r&&!r.allowReordering||(!u||!u.allowReordering)&&(!f||!f.allowReordering);default:return t.length===0}},_moveHeader:function(n){var v=n.jQueryEvent,t=v.data.that,l,u,y,p,b,k,o=f.eventData(v),s,d=t._controller,r,e,h=t._dragOptions,g,a,c,nt;if(t._isDragging){if(b=Math.abs(o.x-h.columnElement.offset().left-h.deltaX),k=Math.abs(o.y-h.columnElement.offset().top-h.deltaY),(t._element().is(":visible")||b>w||k>w)&&(t._element().show(),y=o.x-h.deltaX,p=o.y-h.deltaY,t._element().offset({left:y,top:p}),s=t._getDraggingPanelByPos(o),s))if(nt=t.option("rtlEnabled"),g=s.getName()==="columnChooser",c=g?"y":"x",l=s.getColumnElements()||[],u=i.getPointsByColumns(l,function(n){return t._pointCreated(n,s.getColumns(),s.getName(),h.sourceColumn)},c==="y"),t._dropLocation=s.getName(),u.length>0){for(r=0;r<u.length;r++)if(a=u[r+1]&&(u[r][c]+u[r+1][c])/2,a===undefined||(nt&&c==="x"?o[c]>a:o[c]<a)){t._dropColumnIndex=u[r].columnIndex,e=t._getDropOptions(),l[r]?e.targetColumnElement=l.eq(r):(e.targetColumnElement=l.last(),e.isLast=!0),e.posX=u[r].x,d.dock(e);break}}else t._dropColumnIndex=-1,e=t._getDropOptions(),d.dock(e);v.preventDefault()}},_subscribeToEvents:function(t){var i=this;i._moveHeaderAction=this.createAction(this._moveHeader,{excludeValidators:["gesture"]}),i._dropHeaderAction=this.createAction(this._dropHeader,{excludeValidators:["gesture"]});n(document).on(r("dxpointermove",u),{that:i,rootElement:t},i._moveHeaderAction);i._element().on(r("dxpointerup",u),{that:i},i._dropHeaderAction);n(document).on(r("dxpointerup",u),{that:i},i._dropHeaderAction)},_renderCore:function(){this._element().addClass(l+" "+d+" "+nt).css("display","none")},_afterRender:function(n){this._unsubscribeFromEvents(),this._subscribeToEvents(n)},_unsubscribeFromEvents:function(){this._dropHeaderAction&&(this._element().off(r("dxpointerup",u),this._dropHeaderAction),n(document).off(r("dxpointerup",u),this._dropHeaderAction)),this._moveHeaderAction&&n(document).off(r("dxpointermove",u),this._moveHeaderAction)},dispose:function(){this._dragOptions=null,this._unsubscribeFromEvents(),this._element().parent().find("."+l).remove()},isVisible:function(){var t=this.getController("columns"),n=t.getCommonSettings();return this.option("showColumnHeaders")&&(b(this)||n.allowGrouping||n.allowHiding)},init:function(){this.callBase(),this._controller=this.getController("draggingHeader")},drag:function(t){var r=this,i=t.columnElement;r._dragOptions=t,r._isDragging=!0,r._dropColumnIndex=t.columnIndex,r._dropLocation=t.sourceLocation,r._onSelectStart=document.onselectstart,document.onselectstart=function(){return!1},r._element().css({textAlign:i&&i.css("text-align"),height:i&&i.height(),width:i&&i.width(),whiteSpace:i&&i.css("white-space")}).addClass(g).text(t.sourceColumn.caption),r._element().appendTo(n(document.body))}}),i.ColumnsResizerViewController=i.ViewController.inherit({_pointCreated:function(n,t,i){var r,u;return n.index>0&&n.index<t?(n.columnIndex-=1,r=i[n.columnIndex]||{},u=i[n.columnIndex+1]||{},!(r.allowResizing&&u.allowResizing)):!0},_getTargetPoint:function(n,t,i){if(n)for(var r=0;r<n.length;r++)if(n[r].x-i<=t&&t<=n[r].x+i)return n[r];return null},_moveSeparator:function(n){var r=n.jQueryEvent,t=r.data,s=t._pointsByColumns,u=t._columnsSeparatorView.width(),e=t._columnsSeparatorView._element().offset(),h=u/2,o=t._$parentContainer.offset().left,i=f.eventData(r);t._isResizing?o<=i.x&&i.x<=o+t._$parentContainer.width()&&t._updateColumnsWidthIfNeeded(t._targetPoint.columnIndex,i.x)&&(t._columnsSeparatorView.moveByX(t._targetPoint.x+(i.x-t._resizingInfo.startPosX)),t._tablePositionController.update(),r.preventDefault()):(t._targetPoint=t._getTargetPoint(s,i.x,u),t._isReadyResizing=!1,t._columnsSeparatorView.changeCursor(),t._targetPoint&&e.top<=i.y&&e.top+t._columnsSeparatorView.height()>=i.y&&(t._columnsSeparatorView.changeCursor("col-resize"),t._columnsSeparatorView.moveByX(t._targetPoint.x-h),t._isReadyResizing=!0,r.preventDefault()))},_endResizing:function(n){var i=n.jQueryEvent,t=i.data;t._isResizing&&(t._updatePointsByColumns(),t._resizingInfo=null,t._columnsSeparatorView.hide(),t._columnsSeparatorView.changeCursor(),t._trackerView.hide(),t._isReadyResizing=!1,t._isResizing=!1)},_setupResizingInfo:function(n){var t=this,i=t._columnHeadersView.getHeaderElement(t._targetPoint.columnIndex),r=t._columnHeadersView.getHeaderElement(t._targetPoint.columnIndex+1);t._resizingInfo={startPosX:n,currentColumnWidth:i&&i.length>0?i.outerWidth():0,nextColumnWidth:r&&r.length>0?r.outerWidth():0}},_startResizing:function(n){var i=n.jQueryEvent,t=i.data,r=f.eventData(i);f.isTouchEvent(i)&&(t._targetPoint=t._getTargetPoint(t._pointsByColumns,r.x,tt),t._targetPoint&&(t._columnsSeparatorView.moveByX(t._targetPoint.x-t._columnsSeparatorView.width()/2),t._isReadyResizing=!0)),t._isReadyResizing&&(t._targetPoint,t._setupResizingInfo(r.x),t._columnsSeparatorView.show(),t._trackerView.show(),t._isResizing=!0,i.preventDefault())},_generatePointsByColumns:function(){var n=this,u=n._columnsController?n._columnsController.getVisibleColumns():[],t=n._columnHeadersView.getColumnElements(),r=[];t&&t.length>0&&(r=i.getPointsByColumns(t,function(i){return n._pointCreated(i,t.length,u)})),n._pointsByColumns=r},_unsubscribeFromEvents:function(){this._moveSeparatorHandler&&this._$parentContainer.off(r("dxpointermove",u),this._moveSeparatorHandler),this._startResizingHandler&&this._columnsSeparatorView._element().off(r("dxpointerdown",u),this._startResizingHandler),this._endResizingHandler&&(this._columnsSeparatorView._element().off(r("dxpointerup",u),this._endResizingHandler),n(document).off(r("dxpointerup",u),this._endResizingHandler))},_subscribeToEvents:function(){this._moveSeparatorHandler=this.createAction(this._moveSeparator,{excludeValidators:["gesture"]}),this._startResizingHandler=this.createAction(this._startResizing),this._endResizingHandler=this.createAction(this._endResizing,{excludeValidators:["gesture"]});this._$parentContainer.on(r("dxpointermove",u),this,this._moveSeparatorHandler);this._$parentContainer.on(r("dxpointerdown",u),this,this._startResizingHandler);this._columnsSeparatorView._element().on(r("dxpointerup",u),this,this._endResizingHandler);n(document).on(r("dxpointerup",u),this,this._endResizingHandler)},_updateColumnsWidthIfNeeded:function(n,t){var i,u=!1,f,r=this._columnsController.getVisibleColumns(),o=this._columnsSeparatorView.width(),e;return i=t-this._resizingInfo.startPosX,this.option("rtlEnabled")&&(i=-i),e=this._resizingInfo.currentColumnWidth+i,f=this._resizingInfo.nextColumnWidth-i,u=!(e<=o||f<=o),u&&(r[n]&&this._columnsController.columnOption(r[n].initialIndex,"width",Math.floor(e)),r[n+1]&&this._columnsController.columnOption(r[n+1].initialIndex,"width",Math.floor(f))),u},_updatePointsByColumns:function(){for(var i,r=this.option("rtlEnabled"),n,t=0;t<this._pointsByColumns.length;t++)i=this._pointsByColumns[t],n=this._columnHeadersView.getHeaderElement(i.columnIndex+1),n&&n.length>0&&(i.x=n.offset().left+(r?n.outerWidth():0))},init:function(){var n=this,i,t,r=function(t){n._scrollLeft!==t.left&&(n._scrollLeft=t.left,n._generatePointsByColumns())},u=function(){n._generatePointsByColumns()};n.callBase(),e(n)&&(n._columnsSeparatorView=n.getView("columnsSeparatorView"),n._columnHeadersView=n.getView("columnHeadersView"),n._trackerView=n.getView("trackerView"),n._rowsView=n.getView("rowsView"),n._columnsController=n.getController("columns"),n._tablePositionController=n.getController("tablePosition"),n._$parentContainer=n._columnsSeparatorView.component._element(),n._columnHeadersView.renderCompleted.add(u),n._columnHeadersView.resizeCompleted.add(u),n._columnsSeparatorView.renderCompleted.add(function(){n._unsubscribeFromEvents(),n._subscribeToEvents()}),n._rowsView.renderCompleted.add(function(){n._rowsView.scrollOffsetChanged.remove(r),n._rowsView.scrollOffsetChanged.add(r)}),i=n.getView("gridView"),t=n._rowsView.getScrollbarWidth()!==0,n.getController("tablePosition").positionChanged.add(function(){if(n._isResizing&&!n._rowsView.isResizing){var r=n._rowsView.getScrollbarWidth()!==0;t!==r?(t=r,i.resize()):(n._rowsView.updateFreeSpaceRowHeight(),n._columnHeadersView.processSizeChanged())}}))},dispose:function(){this._unsubscribeFromEvents()}}),i.TablePositionViewController=i.ViewController.inherit({update:function(){var n=this._columnHeadersView._element(),t=this._columnHeadersView?this._columnHeadersView.getHeight():0,i=this._rowsView?this._rowsView.height()-this._rowsView.getScrollbarWidth(!0):0;this.positionChanged.fire({height:t+i,top:n&&n.length>0?Math.floor(n[0].offsetTop):0})},init:function(){var n=this;n.callBase(),n._columnHeadersView=this.getView("columnHeadersView"),n._rowsView=this.getView("rowsView"),n._pagerView=this.getView("pagerView"),n._rowsView.resizeCompleted.add(function(){n.update()})},ctor:function(t){this.callBase(t),this.positionChanged=n.Callbacks()}}),i.DraggingHeaderViewController=i.ViewController.inherit({_subscribeToEvent:function(t,i){var e=this;n.each(i,function(o,s){if(s){var c=s.getColumnElements()||[],l=s.getName(),h=s.getColumns()||[];n.each(c,function(o,c){if(n(c).off(r("dxpointerdown",u)),s.allowDragging(h[o],i))n(c).on(r("dxpointerdown",u),e.createAction(function(r){var u=r.jQueryEvent,e=f.eventData(u);u.preventDefault(),t.drag({deltaX:e.x-n(u.currentTarget).offset().left,deltaY:e.y-n(u.currentTarget).offset().top,sourceColumn:h[o],columnIndex:o,columnElement:n(c),sourceLocation:s.getName(),draggingPanels:i})}))})}})},_getSeparator:function(n){return n==="headers"?this._columnsSeparatorView:this._blockSeparatorView},hideSeparators:function(){var n=this._blockSeparatorView,t=this._columnsSeparatorView;this._animationColumnIndex=null,n&&n.hide(),t&&t.hide()},init:function(){var n=this,t;n.callBase(),n._columnsController=n.getController("columns"),n._columnHeadersView=n.getView("columnHeadersView"),n._columnsSeparatorView=n.getView("columnsSeparatorView"),n._draggingHeaderView=n.getView("draggingHeaderView"),n._rowsView=n.getView("rowsView"),n._blockSeparatorView=n.getView("blockSeparatorView"),n._headerPanelView=n.getView("headerPanel"),n._columnChooserView=n.getView("columnChooserView"),t=function(){n._draggingHeaderView&&n._subscribeToEvent(n._draggingHeaderView,[n._columnChooserView,n._columnHeadersView,n._headerPanelView])},n._columnHeadersView.renderCompleted.add(t),n._headerPanelView.renderCompleted.add(t),n._columnChooserView.renderCompleted.add(t)},allowDrop:function(n){return this._columnsController.allowMoveColumn(n.sourceColumnIndex,n.targetColumnIndex,n.sourceLocation,n.targetLocation)},allowDragColumn:function(n,t,i){var r=n[t],u,f=0,e=function(n){return n.allowReordering||n.allowGrouping||n.allowHiding};if(!r)return!1;switch(i){case"headers":for(u=0;u<n.length;u++)e(n[u])&&f++;return f>1&&e(r);case"group":return r.allowGrouping;case"columnChooser":return r.allowHiding}},dock:function(n){var t=this,u=n.targetColumnIndex,f=n.sourceLocation,s=n.sourceColumnIndex,e=n.sourceColumnElement,r=n.targetLocation,i=t._getSeparator(r),o=u>=0,h=function(){t._animationColumnIndex!==u&&(t.hideSeparators(),i._element()[n.isLast?"insertAfter":"insertBefore"](n.targetColumnElement),t._animationColumnIndex=u,i.show(r))};t._columnHeadersView._element().find("."+p).first().toggleClass(y,f!=="headers"&&r==="headers"&&!o),i&&(e&&(e.css({opacity:.5}),f==="headers"&&t._rowsView.setRowsOpacity(s,.5)),t.allowDrop(n)&&o?r==="group"||r==="columnChooser"?h():(t.hideSeparators(),i.moveByX(n.posX-i.width()),i.show()):t.hideSeparators())},drop:function(n){var i=n.sourceColumnElement,t;i&&(i.css({opacity:""}),this._rowsView.setRowsOpacity(n.sourceColumnIndex,""),this._columnHeadersView._element().find("."+p).first().removeClass(y)),this.allowDrop(n)&&(t=this._getSeparator(n.targetLocation),t&&t.hide(),this._columnsController.moveColumn(n.sourceColumnIndex,n.targetColumnIndex,n.sourceLocation,n.targetLocation))}}),i.registerModule("columnsResizingReordering",{views:{columnsSeparatorView:i.ColumnsSeparatorView,blockSeparatorView:i.BlockSeparatorView,draggingHeaderView:i.DraggingHeaderView,trackerView:i.TrackerView},controllers:{draggingHeader:i.DraggingHeaderViewController,tablePosition:i.TablePositionViewController,columnsResizer:i.ColumnsResizerViewController}})}(jQuery,DevExpress),function(n,t){var r=t.ui,e=t.utils,i=r.dataGrid,u="dx-datagrid",f="dx-context-menu";i.ContextMenuView=i.View.inherit({viewNames:function(){return["columnHeadersView"]},_renderCore:function(){var t=this;t._element().addClass(f).dxContextMenu({positioningAction:function(i){var u=i.jQueryEvent,f=n(u.target),e=i.component,r=[];n.each(t.viewNames(),function(n,i){var e=t.getView(i),u=e.getContextMenuItems(f);if(u.length)return r=u,!1}),r.length?e.option("items",r):i.canceled=!0},itemClickAction:function(n){n.itemData.itemClickAction&&n.itemData.itemClickAction(n)},rtlEnabled:t.option("rtlEnabled"),cssClass:u,target:t.component._element()})}}),i.registerModule("contextMenu",{views:{contextMenuView:i.ContextMenuView}})}(jQuery,DevExpress),function(n,t){var f=t.ui,e=t.utils,i=f.events,r=f.dataGrid,o="dx-row",s="dx-group-row",u="batch",h="dx-datagrid-rowsview",c=["rowsView"];r.KeyboardNavigationController=r.ViewController.inherit({_focusView:function(n,t){n.focus(),this._focusedViews.viewIndex=t,this._focusedView=n},_initFocusedViews:function(){var t=this,r,u,f=t.createAction(function(i){var r=i.jQueryEvent,u=n(r.currentTarget);t._editingController.isEditing()||(t._isCellValid(u)?(u.focus(),t._focusView(r.data.view,r.data.viewIndex),t._updateFocusedCellPosition(u)):t._resetFocusedCell(t))});t._focusedViews=[],n.each(c,function(n,i){var r=t.getView(i);r.isVisible()&&t._focusedViews.push(r)}),n.each(t._focusedViews,function(n,e){e&&e.renderCompleted.add(function(){var s=e._element();s.off(i.addNamespace("dxpointerdown","dxDataGridKeyboardNavigation"),f);s.on(i.addNamespace("dxpointerdown","dxDataGridKeyboardNavigation"),"."+o+" td",{viewIndex:n,view:e},f);t._initKeyDownProcessor(t,s,t._keyDownHandler),t._focusedView&&t._focusedView.name===e.name&&t._isKeyDown&&(r=t._getFocusedCell(),r&&r.length>0&&(t._focusView(e,n),t.getController("editorFactory").focus()&&t._focus(r),setTimeout(function(){t._editingController.isEditing()?(u=r.find("input").first(),u.focus()):(r.attr("tabindex",0),r.focus())})))})})},_initKeyDownProcessor:function(n,t,i){this._keyDownProcessor&&(this._keyDownProcessor.dispose(),this._keyDownProcessor=null),this._keyDownProcessor=new f.HierarchicalKeyDownProcessor({element:t,context:n,handler:i})},_focusCell:function(n){var t=this;n&&(t.getController("editorFactory").focus(n),t._updateFocusedCellPosition(n))},_focusGroupRow:function(n){n&&(this.getController("editorFactory").focus(n),this._focusedCellPosition.rowIndex=this._focusedView.getRowIndex(n))},_getFocusedCell:function(){if(this._focusedView&&this._focusedCellPosition)return this._focusedView.getCell(this._focusedCellPosition.columnIndex,this._focusedCellPosition.rowIndex)},_moveScrollbar:function(n){var t=this._focusedView?this._focusedView._scrollable:null,i,r,f,e,o,u;if(t&&(r=this._getFocusedCell(),r)){f=this._focusedView.getTableFromCell(r)[0],e=r[0].offsetTop+f.offsetTop,o=r[0].offsetLeft+f.offsetLeft,i=t.scrollOffset(),u={x:i.left,y:i.top};switch(n){case"downArrow":e+r.height()>i.top+t.clientHeight()&&(u.y+=t.clientHeight());break;case"upArrow":e<i.top&&(u.y-=t.clientHeight());break;case"leftArrow":o<i.left&&(u.x-=t.clientWidth());break;case"rightArrow":o+r.width()>i.left+t.clientWidth()&&(u.x+=t.clientWidth())}t.scrollTo(u)}},_updateFocusedCellPosition:function(n){var t=this;n.length>0&&(this._focusedCellPosition={columnIndex:n[0].cellIndex,rowIndex:n.parent().length>0&&t._focusedView?t._focusedView.getRowIndex(n.parent()):null})},_isCellValid:function(n){var t=this._columnsController.getVisibleColumns(),i=n[0].cellIndex;return t.length>i&&!(t[i].command||e.isDefined(t[i].groupIndex))},_isGroupRow:function(n){return n&&n.hasClass(s)},_focus:function(n){var t=n&&n.parent();this._isGroupRow(t)?this._focusGroupRow(t):this._focusCell(n)},_keyDownHandler:function(t){var s=this.option("editing"),f=this._editingController.isEditing(),e=this._dataController.pageIndex(),c=this._dataController.pageCount(),r=this._focusedCellPosition?this._focusedCellPosition.rowIndex:null,h=this._focusedView&&this._focusedView.getRow(r),i,o;this._isKeyDown=!0;switch(t.key){case"leftArrow":case"rightArrow":f||this._isGroupRow(h)||(i=this._getNextCell(t.key),i&&this._isCellValid(i)&&(this._focusCell(i),this._moveScrollbar(t.key)),t.originalEvent.preventDefault());break;case"upArrow":case"downArrow":f||(r===0||r===this._focusedView.getRowsCount()-1,i=this._getNextCell(t.key),i&&this._isCellValid(i)&&(this._focus(i),this._moveScrollbar(t.key)),t.originalEvent.preventDefault());break;case"pageUp":e>0&&(this._dataController.pageIndex(e-1),t.originalEvent.preventDefault());break;case"pageDown":e<c-1&&(this._dataController.pageIndex(e+1),t.originalEvent.preventDefault());break;case"space":this.option("selection")&&this.option("selection").mode!=="none"&&!f&&this._selectionController.changeItemSelection(r,{shift:t.shift,control:t.ctrl});break;case"A":t.ctrl&&this.option("selection.mode")==="multiple"&&this.option("selection.allowSelectAll")&&(this._selectionController.selectAll(),t.originalEvent.preventDefault());break;case"tab":f&&this._editingController.getEditMode()===u&&t.originalEvent.target&&(this._updateFocusedCellPosition(n(t.originalEvent.target).closest("td")),i=this._getNextCell("rightArrow"),this._focusCell(i),this._editingController.editCell(this._focusedCellPosition.rowIndex,this._focusedCellPosition.columnIndex),t.originalEvent.preventDefault());break;case"enter":this._isGroupRow(h)?this.option("grouping")&&this.option("grouping").allowCollapsing&&(o=this._dataController.getGroupPathByRowIndex(r),o&&this._dataController.changeGroupExpand(o)):s.editEnabled&&(f?(this._updateFocusedCellPosition(n(t.originalEvent.target).closest("td")),this._editingController.getEditMode()===u?this._editingController.closeEditCell():setTimeout(n.proxy(this._editingController.saveEditData,this._editingController))):this._editingController.getEditMode()===u?this._editingController.editCell(r,this._focusedCellPosition.columnIndex):this._editingController.editRow(r));break;case"escape":s.editEnabled&&f&&(this._updateFocusedCellPosition(n(t.originalEvent.target).closest("td")),this._editingController.getEditMode()===u?this._editingController.closeEditCell():this._editingController.cancelEditData(),t.originalEvent.preventDefault());break;case"F":t.ctrl&&this.option("searchPanel")&&this.option("searchPanel").visible&&(this._headerPanel.focus(),t.originalEvent.preventDefault())}},_getNextCell:function(n){if(this._focusedView&&this._focusedCellPosition){var t=this._focusedCellPosition.columnIndex,r=this.getController("columns").getVisibleColumns().length,i=this._focusedCellPosition.rowIndex;switch(n){case"rightArrow":t=t<r-1?t+1:t;break;case"leftArrow":t=t>0?t-1:t;break;case"upArrow":i=i>0?i-1:i;break;case"downArrow":i=i<this._dataController.items().length-1?i+1:i}return this._focusedView.getCell(t,i)}return null},_resetFocusedCell:function(n){var t=n._getFocusedCell();t&&t.attr("tabindex",null),n._focusedCellPosition=null,n._isKeyDown=!1},init:function(){var t=this;if(t.option("useKeyboard")){t._dataController=t.getController("data"),t._selectionController=t.getController("selection"),t._editingController=t.getController("editing"),t._headerPanel=t.getView("headerPanel"),t._pagerView=t.getView("pagerView"),t._columnsController=t.getController("columns"),t._focusedCellPosition={columnIndex:0,rowIndex:0},t._dataController.changed.add(function(n){t._focusedCellPosition&&n&&n.changeType==="prepend"&&(t._focusedCellPosition.rowIndex+=n.items.length)}),t._initFocusedViews(),t._documentClickHandler=t.createAction(function(i){n(i.jQueryEvent.target).closest("."+h).length||t._resetFocusedCell(t)});n(document).on(i.addNamespace("dxpointerdown","dxDataGridKeyboardNavigation"),t._documentClickHandler)}},dispose:function(){this.callBase(),this._focusedView=null,this._focusedViews=null,this._keyDownProcessor&&this._keyDownProcessor.dispose(),n(document).off(i.addNamespace("dxpointerdown","dxDataGridKeyboardNavigation"),this._documentClickHandler)}}),r.registerModule("keyboardNavigation",{defaultOptions:function(){return{useKeyboard:!0}},controllers:{keyboardNavigation:r.KeyboardNavigationController}})}(jQuery,DevExpress),function(n,t){var r=t.ui,u=t.utils,i=r.dataGrid;i.ErrorView=i.View.inherit({_renderCore:function(){this.toast({type:"error",displayTime:1e6,position:{my:"center",at:"center"},contentReadyAction:function(n){this.content().on("dxclick",function(){n.component.hide()})}})},toast:function(n){return this._element().dxToast(n||"instance")},isVisible:function(){return this.option("dataErrorVisible")},init:function(){var n=this,t=n.getController("data");t.dataErrorOccurred.add(function(t){var i=t&&t.message||t;n.isVisible()&&(n.toast({message:i}),n.toast().show())})}}),i.registerModule("errorHandling",{views:{errorView:i.ErrorView}})}(jQuery,DevExpress),DevExpress.MOD_WIDGETS_WEB=!0}