/*! 
* DevExtreme (Charts)
* Version: 14.1.7
* Build date: Sep 22, 2014
*
* Copyright (c) 2012 - 2014 Developer Express Inc. ALL RIGHTS RESERVED
* EULA: https://www.devexpress.com/Support/EULAs/DevExtreme.xml
*/
"use strict";if(!DevExpress.MOD_VIZ_CHARTS){if(!DevExpress.MOD_VIZ_CORE)throw Error("Required module is not referenced: viz-core");(function(n,t){var r=t.utils.isDefined,e=function(n,t){return n.substr(n.length-t.length)===t},f=function(n,t){return n.indexOf(t)===0},o=DevExpress.viz.core.utils.decreaseGaps,u=10;t.viz.charts.ChartTitle=t.Class.inherit({ctor:function(n,t,i,r){var u=this;u._init(t,i),u.renderer=n,u.titleGroup=r},dispose:function(){var n=this;n.renderer=null,n.clipRect=null,n.title=null,n.innerTitleGroup=null,n.titleGroup=null,n.options=null},update:function(n,t){this._init(n,t)},_init:function(n,t){var i=this;n&&(i._parseAlignments(n),i.horizontalAlignment=n.horizontalAlignment,i.verticalAlignment=n.verticalAlignment,i._parseMargins(n),i.margin=n.margin,i.options=n),i.setSize({width:t})},_parseMargins:function(n){n.margin=r(n.margin)?n.margin:{},typeof n.margin=="number"?(n.margin=n.margin>=0?n.margin:u,n.margin={top:n.margin,bottom:n.margin,left:n.margin,right:n.margin}):(n.margin.top=n.margin.top>=0?n.margin.top:u,n.margin.bottom=n.margin.bottom>=0?n.margin.bottom:u,n.margin.left=n.margin.left>=0?n.margin.left:u,n.margin.right=n.margin.right>=0?n.margin.right:u)},_parseAlignments:function(n){if(r(n.position)&&!(r(n.verticalAlignment)&&r(n.horizontalAlignment))){n.position=n.position.toLowerCase(),n.verticalAlignment=e(n.position,"top")?"top":"bottom",n.horizontalAlignment=f(n.position,"left")?"left":f(n.position,"center")&&"center"||"right";return}n.verticalAlignment=(n.verticalAlignment||"").toLowerCase(),n.horizontalAlignment=(n.horizontalAlignment||"").toLowerCase(),n.verticalAlignment!=="top"&&n.verticalAlignment!=="bottom"&&(n.verticalAlignment="top"),n.horizontalAlignment!=="left"&&n.horizontalAlignment!=="center"&&n.horizontalAlignment!=="right"&&(n.horizontalAlignment="center")},_setBoundingRect:function(){var t=this,u=t.options,i=t.changedMargin||t.margin,n;t.innerTitleGroup&&(n=t.innerTitleGroup.getBBox(),n.height+=i.top+i.bottom,n.width+=i.left+i.right,n.x-=i.left,n.y-=i.top,r(u.placeholderSize)&&(n.height=u.placeholderSize),t.boundingRect=n)},draw:function(){var n=this,t=n.options,i=n.renderer,r;t.text&&(n.changedMargin=null,n.innerTitleGroup?n.innerTitleGroup.clear():(n.innerTitleGroup=i.createGroup(),n.clipRect=n.createClipRect(),n.titleGroup&&n.clipRect&&n.titleGroup.applySettings({clipId:n.clipRect.id})),n.innerTitleGroup.append(n.titleGroup),r={font:t.font,align:n.horizontalAlignment,style:t.fontStyle},n.title=i.createText(t.text,0,0,r).append(n.innerTitleGroup),n.title.text=t.text,n._correctTitleLength(),n._setClipRectSettings())},_correctTitleLength:function(){var n=this,t=n.title.text,r,u,i;(n.title.updateText(t),n._setBoundingRect(),i=n.getLayoutOptions(),n._width>i.width||t.indexOf("<br/>")!==-1)||(u=t.length*n._width/i.width,r=t.substr(0,~~u-4)+"...",n.title.updateText(r),n._setBoundingRect())},changeSize:function(t){var i=this,r=n.extend(!0,{},i.margin);r.top+r.bottom<t.height?(this.innerTitleGroup&&(i.options._incidentOccured("W2103"),this.innerTitleGroup.remove(),this.innerTitleGroup=null),i.clipRect&&(i.clipRect.remove(),i.clipRect=null)):t.height>0&&(o(r,["top","bottom"],t.height),t.height&&(i.changedMargin=r)),i._correctTitleLength(),i._setBoundingRect(),i._setClipRectSettings()},getLayoutOptions:function(){var t=this.options,n=this.innerTitleGroup?this.boundingRect:{width:0,height:0,x:0,y:0};return n.verticalAlignment=t.verticalAlignment,n.horizontalAlignment=t.horizontalAlignment,n.cutLayoutSide=t.verticalAlignment,n},setSize:function(n){this._width=n.width||this._width},shift:function(n,t){var i=this,r=i.getLayoutOptions();n-=r.x,t-=r.y,i.innerTitleGroup&&i.innerTitleGroup.move(n,t),i.clipRect&&i.clipRect.updateRectangle({translateX:n,translateY:t})},createClipRect:function(){if(r(this.options.placeholderSize))return this.renderer.createClipRect(0,0,0,0)},_setClipRectSettings:function(){var n=this.getLayoutOptions(),t=this.clipRect;t&&(t.append(),t.updateRectangle({x:n.x,y:n.y,width:n.width,height:n.height}))}})})(jQuery,DevExpress),function(n,t,i){var l=t.utils,o=l.isDefined,p=l.isDate,c=Math.abs,w=t.viz.core,b=100,g=5,k=2,d=4,h="canvas_position_",a="canvas_position_start",v="canvas_position_end",s="top",f="bottom",r="left",u="right",e="center",nt=function(n){var i=n.label,t=n.position;n.isHorizontal?t===f||t===s||(t=f):t===r||t===u||(t=r),n.position=t,t!==u||i.userAlignment||(i.alignment=r)},y=function(n,i,r){var u={value:n,valueText:t.formatHelper.format(n,i.format,i.precision)||""};return r&&(u.min=r.min,u.max=r.max),i.customizeText?i.customizeText.call(u,u):u.valueText},tt=function(n){switch(n){case"overlap":return"stagger";case"stagger":return"rotate";case"rotate":default:return"end"}};t.viz.charts.Axis=function(n,t){this.renderer=n,this._init(t)},n.extend(t.viz.charts.Axis.prototype,{dispose:function(){var t=this;t._axisElementsGroup&&t._axisElementsGroup.dispose(),n.each(t.labels||[],function(n,t){t.removeData()}),t.labels=null,t.title=null,t.stripLabels=null,t.stripRects=null,t.constantLineLabels=null,t.constantLines=null,t._axisStripGroup=null,t._axisConstantLineGroup=null,t._axisLableGroup=null,t._axisLineGroup=null,t._axisElementsGroup=null,t._axisGridGroup=null,t._axisGroup=null,t.axesContainerGroup=null,t.stripsGroup=null,t.constantLinesGroup=null,t._axisTitleGroup=null,t.renderer=null,t.translator=null,t.orthogonalTranslator=null,t.options=null,t.textOptions=null,t._tickValues=null,t._fullTickValues=null,t._fullTickPositions=null},_init:function(n){var i=this,r=n.categories,t=n.label;n.hoverMode=n.hoverMode?n.hoverMode.toLowerCase():"none",i.hasLabelFormat=t.format!==""&&o(t.format),i.options=n,i.staggered=t.staggered,t.minSpacing=o(t.minSpacing)?t.minSpacing:g,nt(n),r&&(i.labelsNumber=r.length,i.ticksNumber=i.labelsNumber),n.range={min:n.min,max:n.max,categories:n.categories&&n.categories.slice(0)},i.pane=n.pane,i.textOptions={align:t.alignment,font:t.font,opacity:t.opacity,style:t.style},n.type==="logarithmic"&&(n.logarithmBaseError&&(n.incidentOccured("E2104"),delete n.logarithmBaseError),i.calcInterval=function(t,i){return l.getLog(t/i,n.logarithmBase)})},updateSize:function(n){var t=this,i=t.options,r=i.isHorizontal?"horizontal":"vertical";t.title&&t._axisTitleGroup&&(i.incidentOccured("W2105",[r]),t._axisTitleGroup.remove(),t._axisTitleGroup=null),n&&t._axisElementsGroup&&t.labels&&(i.incidentOccured("W2106",[r]),t._axisElementsGroup.remove(),t._axisElementsGroup=null),t._setBoundingRect()},_updateTranslatorInterval:function(){var i=this,n,t,r=i.translator.getBusinessRange();if(r&&r.addRange&&!i.options.categories)for(t=i.getTickValues(),n=0;n<t.length-1;n++)r.addRange({interval:c(t[n]-t[n+1])})},setTranslator:function(n,t){var i=this;i.translator=n,t&&(i.orthogonalTranslator=t),i.resetTicks(),i._updateTranslatorInterval()},resetTicks:function(){var n=this;n._tickValues=n._tickPositions=n._fullTickValues=n._fullTickPositions=null},setRange:function(n){var t=this.options;t.min=n.minVisible,t.max=n.maxVisible,t.categories=n.categories,t.stubData=n.stubData,this.resetTicks()},_drawAxis:function(){var t=this,e=t.translator,n=t.options,s=!!n.categories,o=t.axisPosition,i,u,r,f;n.visible&&(i=e.translateSpecialCase(a),r=e.translateSpecialCase(v),n.isHorizontal?u=f=o:(u=i,f=r,i=r=o),t.renderer.createLine(i,u,r,f,{strokeWidth:n.width,stroke:n.color,strokeOpacity:n.opacity}).append(t._axisLineGroup))},_getOptimalRotationAngle:function(n,t,i){var r=this,f=r.options.isHorizontal?r.translator:r.orthogonalTranslator,e=r.renderer,u=w.outOfScreen,o=r.textOptions,s=e.createText(y(n,i),u.x+f.translate(n),u.y,o).append(),h=e.createText(y(t,i),u.x+f.translate(t),u.y,o).append(),c=s.getBBox(),a=h.getBBox(),l=Math.asin((c.height+i.minSpacing)/(a.x-c.x))*180/Math.PI;return s.remove(),h.remove(),isNaN(l)?90:Math.ceil(l)},_applyOptimalOverlappingBehavior:function(t,i){for(var f=this,o=f.overlappingBehavior,s=!1,u=null,h=null,e=n.extend({},i),r="overlap";r!=="end";){s=u&&u!==90?!1:f.options.tickProvider.isOverlappedTicks(t,e),r=tt(s?r:null);switch(r){case"stagger":e.screenDelta*=k,h=r;break;case"rotate":u=f._getOptimalRotationAngle(t[0],t[1],f.options.label),e.screenDelta=i.screenDelta,e.textOptions.rotate=u,h=r}}o.isOverlapped=s,o.mode=h,o.rotationAngle=u},_getTicksOptions:function(){var u=this,t=u.options,e=u.translator,s=c(e.translateSpecialCase(a)-e.translateSpecialCase(v)),r=t.min,f=t.max,h=l.getSignificantDigitPosition(c(f-r)/s),o,p=function(){return""};return l.isNumber(r)&&t.type!=="logarithmic"&&(r=l.roundValue(t.min,h),r<t.min&&(o=Math.pow(10,-h),r=l.applyPrecisionByMinDelta(r,o,r+o)),r>f&&(r=t.min)),t.stubData||(p=function(n){return y(n,t.label,{min:r,max:f})}),{min:r,max:f,base:t.type==="logarithmic"?t.logarithmBase:i,axisType:t.type,dataType:t.dataType,customTicks:n.isArray(t.categories)?t.categories:u._tickValues,useTicksAutoArrangement:!1,textOptions:u.textOptions,getText:p,renderer:u.renderer,textSpacing:t.label.minSpacing,translator:e,tickInterval:t.stubData?null:t.tickInterval,screenDelta:s,gridSpacingFactor:t.axisDivisionFactor,isHorizontal:t.isHorizontal,setTicksAtUnitBeginning:t.setTicksAtUnitBeginning,incidentOccured:t.incidentOccured}},getTickValues:function(){var i=this,o,e=i.options,s=e.tickProvider,f=e.label,h=e.categories,u=i._getTicksOptions();return(i._fullTickValues=i._tickValues=s.getTicks(u),(p(e.min)||p(h&&h[0]))&&!i.hasLabelFormat&&i._tickValues.length&&(f.format=t.formatHelper.getDateFormatByTicks(i._tickValues)),i.overlappingBehavior=f.overlappingBehavior?n.extend({},f.overlappingBehavior):null,i.overlappingBehavior&&(e.isHorizontal||i.overlappingBehavior.mode==="ignore"||(i.overlappingBehavior.mode="enlargeTickInterval"),u.useTicksAutoArrangement=i.overlappingBehavior.mode!=="ignore",u.useTicksAutoArrangement&&(i._fullTickValues=i._tickValues=s.getCorrectedTicks(i._fullTickValues,u)),i.overlappingBehavior.mode==="auto"&&(i.textOptions.rotate=0,i._applyOptimalOverlappingBehavior(i._fullTickValues,u),u.useTicksAutoArrangement=i.overlappingBehavior.isOverlapped),i.overlappingBehavior.mode==="rotate"?(i.textOptions.rotate=i.overlappingBehavior.rotationAngle,f.userAlignment||(i.textOptions.align=r)):f.userAlignment||(i.textOptions.align=f.alignment)),u.useTicksAutoArrangement&&(o=i._tickValues.length?i.translator.translate(i._tickValues[i._tickValues.length-1])-i.translator.translate(i._tickValues[0]):null,o?(u.screenDelta=c(o),u.ticksCount=i._tickValues.length-1):u.ticksCount=i._tickValues.length,i.overlappingBehavior&&i.overlappingBehavior.mode==="stagger"&&(u.screenDelta*=k),u.customTicks=i._tickValues,i._tickValues=s.getTicks(u)),i.options.stubData)?i._tickValues:(n.isArray(h)||(i._fullTickValues=i._tickValues),i._tickValues)},setTickValues:function(n){this.resetTicks(),this._fullTickValues=this._tickValues=n},_prepareLabelsToDraw:function(){var i=this,t=i.getTickValues(),r=[],n;for((t.hideLabels||i.options.stubData)&&(r.hideLabels=!0),n=0;n<t.length;n++)r.push({text:t[n],pos:i.translator.translate(t[n])});return r},_correctTicksPosition:function(n){var u=this,t=u.options,r=u.translator.getInterval()/2,i;if(t.categories&&(t.discreteAxisDivisionMode!=="crossLabels"||!t.discreteAxisDivisionMode))for(t.isHorizontal?t.valueMarginsEnabled||(n=n.slice(0,n.length-1)):(r=-r,t.valueMarginsEnabled||(n=n.slice(1,n.length))),i=0;i<n.length;i++)n[i].pos=n[i].pos+r;return n},_prepareFullTicksToDraw:function(){var n=this,t=n._fullTickValues,r=[],i;if(!n._fullTickPositions){for(t||(n.getTickValues(),t=n._fullTickValues||[]),i=0;i<t.length;i++)r.push({pos:n.translator.translate(t[i])});n._fullTickPositions=n._correctTicksPosition(r)}return n._fullTickPositions},_drawTicks:function(){var i=this,e=i.options,u=e.tick,n,o=i.axisPosition,s=o-4,h=o+4,t,r,f;if(u.visible)if(f=function(n,t,r,f){i.renderer.createLine(n,t,r,f,{strokeWidth:1,stroke:u.color,strokeOpacity:u.opacity}).append(i._axisLineGroup)},r=i._prepareFullTicksToDraw(),e.isHorizontal)for(n=0;n<r.length;n++)t=r[n],f(t.pos,s,t.pos,h);else for(n=0;n<r.length;n++)t=r[n],f(s,t.pos,h,t.pos)},setPercentLabelFormat:function(){var n=this.options.label;this.hasLabelFormat||(n.format="percent")},resetAutoLabelFormat:function(){var n=this.options.label;this.hasLabelFormat||delete n.format},_drawLabels:function(){var n=this,f,t=n.options,l=n.renderer,a=n.axisPosition,c=t.label,v=c.indentFromAxis,i,e,h,p=[],w=t.isHorizontal?l.createText:function(n,t,i,r){return this.createText(n,i,t,r)},b=/^\s+$/,k=t.position===s||t.position===r?a-v:a+v,u;if(c.visible&&n._axisElementsGroup){if(i=n._prepareLabelsToDraw(),i.length===0||i.hideLabels)return!0;for(f=0;f<i.length;f++)e=i[f],u=y(e.text,c,{min:t.min,max:t.max}),o(u)&&u!==""&&!b.test(u)&&(h=w.call(l,u,e.pos,k,n.textOptions),p.push(h),h.append(n._axisElementsGroup),h.data({argument:e.text}));n.labels=p}},getMultipleAxesSpacing:function(){return this.options.multipleAxesSpacing||0},_drawTitle:function(){var n=this,a,i=n.options,l=n.renderer,s=n.axisPosition,t=i.title,v,u={font:t.font,opacity:t.opacity,align:e,"class":"dx-chart-axis-title"},c=n.translator.translateSpecialCase(h+e),f,o;t.text&&n._axisTitleGroup&&(i.isHorizontal?(f=c,o=s):(u.rotate=i.position===r?270:90,f=s,o=c),n.title=l.createText(t.text,f,o,u).append(n._axisTitleGroup))},_drawGrid:function(n){var t=this,l,y=t.options,e=y.grid,o,p;if(e.visible)for(n=n||{visible:!1},p=function(){var l=t.translator,p=t.orthogonalTranslator,o=y.isHorizontal,w=o?r:s,b=o?u:f,k=p.translateSpecialCase(a),g=p.translateSpecialCase(v),nt=n.visible&&n[w]?l.translateSpecialCase(h+w):i,tt=n.visible&&n[b]?l.translateSpecialCase(h+b):i;return function(n){if(!(c(n.pos-nt)<d)&&!(c(n.pos-tt)<d)){var i=n.pos,r=k,u=n.pos,f=g;o||(i=k,r=f=n.pos,u=g),t.renderer.createLine(i,r,u,f,{strokeWidth:e.width,stroke:e.color,strokeOpacity:e.opacity}).append(t._axisGridGroup)}}}(),l=t._prepareFullTicksToDraw(),o=0;o<l.length;o++)p(l[o])},_drawConstantLine:function(){for(var t=this,h=t._axisConstantLineGroup,c=t.renderer,l=t.options,y=l.constantLines,r=t.translator,p=t.orthogonalTranslator,g=l.isHorizontal,e=[],u=[],w=p.translateSpecialCase(a),b=p.translateSpecialCase(v),k=r.translateSpecialCase(a),d=r.translateSpecialCase(v),s=r.getBusinessRange(),nt=function(i){var f=t.validateUnit(i,"E2105","constantLine"),u=r.translate(f),e=!!(s.minVisible||s.maxVisible);return!e&&n.inArray(i,s.categories||[])===-1||!o(u)||u<Math.min(k,d)||u>Math.max(k,d)?{}:{value:u,parsedValue:f}},tt=function(n){if(n.value!==i){var s=nt(n.value),f=n.label||{},r=s.value,l,a={stroke:n.color,strokeWidth:n.width,dashStyle:n.dashStyle};if(!o(r)){e.push(null),f.visible&&u.push(null);return}l=g?c.createLine(r,b,r,w,a):c.createLine(w,r,b,r,a),e.push(l.append(h)),f.visible?u.push(t._drawConstantLineLabels(s.parsedValue,f,r,h)):u.push(null)}},f=0;f<y.length;f++)tt(y[f]);t.constantLines=e,t.constantLineLabels=u},_checkAlignmentConstantLineLabels:function(n){var t=this.options;n.verticalAlignment=(n.verticalAlignment||"").toLowerCase(),n.horizontalAlignment=(n.horizontalAlignment||"").toLowerCase(),t.isHorizontal&&n.position==="outside"&&(n.verticalAlignment=n.verticalAlignment===f?f:s,n.horizontalAlignment=e),t.isHorizontal&&n.position==="inside"&&(n.verticalAlignment=n.verticalAlignment===e?e:n.verticalAlignment===f?f:s,n.horizontalAlignment=n.horizontalAlignment===r?r:u),t.isHorizontal||n.position!=="outside"||(n.verticalAlignment=e,n.horizontalAlignment=n.horizontalAlignment===r?r:u),t.isHorizontal||n.position!=="inside"||(n.verticalAlignment=n.verticalAlignment===f?f:s,n.horizontalAlignment=n.horizontalAlignment===u?u:n.horizontalAlignment===e?e:r)},_drawConstantLineLabels:function(t,i,f,s){var l=this,a=i.text,w=l.orthogonalTranslator,b=l.options,k=b.label,c={align:e,font:n.extend({},k.font,i.font)},v,p;if(l._checkAlignmentConstantLineLabels(i),a=o(a)?a:y(t,k),b.isHorizontal){v=f;switch(i.horizontalAlignment){case r:c.align=u;break;case u:c.align=r}p=w.translateSpecialCase(h+i.verticalAlignment)}else{p=f,v=w.translateSpecialCase(h+i.horizontalAlignment);switch(i.horizontalAlignment){case r:c.align=i.position==="inside"?r:u;break;case e:c.align=e;break;case u:c.align=i.position==="inside"?u:r}}return l.renderer.createText(a,v,p,c).append(s)},_adjustConstantLineLabels:function(){var p=this,k=p.options,d=k.isHorizontal,g=p.constantLines,b=p.constantLineLabels,w,nt,v,n,o,t,l,c,y,a=d?{top:0,bottom:0}:{left:0,right:0};if(b!==i||g!==i){for(y=0;y<b.length;y++)if(l=c=0,n=k.constantLines[y],o=n.label,w=b[y],w!==null){if(nt=g[y],t=w.getBBox(),v=nt.getBBox(),d)if(o.position==="inside"){switch(o.horizontalAlignment){case r:l-=n.paddingLeftRight;break;default:l+=n.paddingLeftRight}switch(o.verticalAlignment){case e:c+=v.y+v.height/2-t.y-t.height/2;break;case f:c-=n.paddingTopBottom;break;default:c+=n.paddingTopBottom+t.height}}else switch(o.verticalAlignment){case f:c+=t.height+n.paddingTopBottom-(t.y+t.height-p.orthogonalTranslator.translateSpecialCase(h+o.verticalAlignment)),a[f]<t.height+n.paddingTopBottom&&(a[f]=t.height+n.paddingTopBottom);break;default:c-=n.paddingTopBottom,a[s]<n.paddingTopBottom+t.height&&(a[s]=n.paddingTopBottom+t.height)}else if(o.position==="inside"){switch(o.horizontalAlignment){case e:l+=v.x+v.width/2-t.x-t.width/2;break;case u:l-=n.paddingLeftRight;break;default:l+=n.paddingLeftRight}switch(o.verticalAlignment){case f:c+=v.y-t.y+n.paddingTopBottom;break;default:c-=n.paddingTopBottom}}else{c+=v.y+v.height/2-t.y-t.height/2;switch(o.horizontalAlignment){case u:l+=n.paddingLeftRight,a[u]<n.paddingLeftRight+t.width&&(a[u]=n.paddingLeftRight+t.width);break;default:l-=n.paddingLeftRight,a[r]<n.paddingLeftRight+t.width&&(a[r]=n.paddingLeftRight+t.width)}}w.move(l,c)}p.padding=a}},_drawStrip:function(){var r=this,d=r.renderer,w=r.options,g=w.strips,f=r.translator,nt=r.orthogonalTranslator,h=f.getBusinessRange(),l,y=[],b=[],tt,rt=w.isHorizontal,u,e,s,t,p,k,it;if(!w.stubData){for(it=function(t,i){var s=!!(h.minVisible||h.maxVisible),c=h.categories||[],u=f.translate(r.validateUnit(t,"E2105","strip")),e=f.translate(r.validateUnit(i,"E2105","strip")),l=f.translateSpecialCase(a),y=f.translateSpecialCase(v),p=h.minVisible;return!s&&(n.inArray(t,c)===-1||n.inArray(i,c)===-1)?{stripFrom:0,stripTo:0}:(!o(u)&&s&&(u=t<p?l:y),!o(e)&&s&&(e=i<p?l:y),u<e?{stripFrom:u,stripTo:e}:{stripFrom:e,stripTo:u})},e=nt.translateSpecialCase(a),s=nt.translateSpecialCase(v),l=0;l<g.length;l++)if(u=g[l],p=u.label||{},k={fill:u.color},u.startValue!==i&&u.endValue!==i&&u.color!==i){if(t=it(u.startValue,u.endValue),t.stripTo-t.stripFrom==0||!t.stripTo&&t.stripTo!==0||!t.stripFrom&&t.stripFrom!==0){b.push(null),p.text&&y.push(null);continue}tt=rt?d.createRect(t.stripFrom,Math.min(e,s),t.stripTo-t.stripFrom,c(e-s),0,k):d.createRect(Math.min(e,s),t.stripFrom,c(e-s),t.stripTo-t.stripFrom,0,k),b.push(tt.append(r._axisStripGroup)),p.text?y.push(r._drawStripLabel(p,t.stripFrom,t.stripTo)):y.push(null)}r.stripLabels=y,r.stripRects=b}},_drawStripLabel:function(t,i,o){var v=this,y=v.orthogonalTranslator,p=v.options,w=p.isHorizontal,c={align:w?e:r,font:n.extend({},p.label.font,t.font)},l,a;return w?(t.horizontalAlignment===e?(l=i+(o-i)/2,c.align=e):t.horizontalAlignment===r?(l=i,c.align=r):t.horizontalAlignment===u&&(l=o,c.align=u),a=y.translateSpecialCase(h+t.verticalAlignment)):(l=y.translateSpecialCase(h+t.horizontalAlignment),c.align=t.horizontalAlignment,t.verticalAlignment===s?a=i:t.verticalAlignment===e?a=o+(i-o)/2:t.verticalAlignment===f&&(a=o)),v.renderer.createText(t.text,l,a,c).append(v._axisLableGroup)},_initAxisPositions:function(){var n=this,t=n.options.position,i=0;n.delta&&(i=n.delta[t]||0),n.axisPosition=n.orthogonalTranslator.translateSpecialCase(h+t)+i},_adjustLabels:function(){var o=this,w=o.options,y=w.isHorizontal,v=w.position,h=o.labels,i,l,b,k,t,a,c=o.padding&&o.padding[v]||0,p=o._axisElementsGroup&&o._axisElementsGroup.getBBox()||{},n;if(w.label.visible&&h&&h.length){for(t=0;t<h.length;t++)i=h[t],n=i.getBBox(),y&&v===f?i.applySettings({y:2*i.settings.y-n.y+c}):y?y&&v===s&&i.applySettings({y:2*i.settings.y-n.y-n.height-c}):(a=v===r?o.textOptions.align===u?n.x+n.width-c:o.textOptions.align===e?n.x+n.width/2-c-(p.width/2||0):n.x-c-(p.width||0):o.textOptions.align===e?n.x+n.width/2+(p.width/2||0)+c:o.textOptions.align===u?n.x+n.width+(p.width||0)+c:n.x+c,i.applySettings({x:a,y:i.settings.y+~~(i.settings.y-n.y-n.height/2)}));if(b=y&&o.overlappingBehavior&&o.overlappingBehavior.mode==="stagger",b){for(l=0,t=0;t<h.length;t=t+2)i=h[t],n=i.getBBox(),n.height>l&&(l=n.height);for(k=o.overlappingBehavior.staggeringSpacing,l=Math.round(l)+k,t=1;t<h.length;t=t+2)i=h[t],v===f?i.move(0,l):v===s&&i.move(0,-l);for(t=0;t<h.length;t++)h[t].rotate(0)}}},_adjustStripLabels:function(){var y=this,n,p=y.stripLabels,w=y.stripRects,c,t,l,a,o,v,h;if(p!==i||w!==i)for(t=0;t<p.length;t++)v=h=0,o=y.options.strips[t],n=o.label,c=p[t],c!==null&&(l=c.getBBox(),a=w[t].getBBox(),n.horizontalAlignment===r?v+=o.paddingLeftRight:n.horizontalAlignment===u&&(v-=o.paddingLeftRight),n.verticalAlignment===s?h+=a.y-l.y+o.paddingTopBottom:n.verticalAlignment===e?h+=a.y+a.height/2-l.y-l.height/2:n.verticalAlignment===f&&(h-=o.paddingTopBottom),c.move(v,h))},_adjustTitle:function(){var u=this,o=u.options,s=o.position,t=u.title,e=o.title.margin,n,h;t&&u._axisElementsGroup&&(h=t.getBBox(),n=u._axisElementsGroup.getBBox(),o.isHorizontal?s===f?t.applySettings({y:n.isEmpty?i:n.y+n.height,translateY:e+h.height}):t.applySettings({y:n.isEmpty?i:n.y,translateY:-e}):s===r?t.applySettings({x:n.isEmpty?i:n.x,translateX:-e}):t.applySettings({x:n.isEmpty?i:n.x+n.width,translateX:e}))},draw:function(n,t){var i=this,r=i.options,u=r.isHorizontal,f=u?"dxc-h-axis":"dxc-v-axis",e=u?"dxc-h-strips":"dxc-v-strips",o=u?"dxc-h-constant-lines":"dxc-v-constant-lines";n=n||{},i._axisGroup?(i._axisGroup.detach(),i._axisStripGroup.detach(),i._axisLableGroup.detach(),i._axisConstantLineGroup.detach(),i._axisTitleGroup?i._axisTitleGroup.clear():!t&&(i._axisTitleGroup=i.renderer.createGroup({"class":"dxc-title"}).append(i._axisGroup)),i._axisGridGroup.clear(),i._axisElementsGroup?i._axisElementsGroup.clear():!t&&(i._axisElementsGroup=i.renderer.createGroup({"class":"dxc-elements"}).append(i._axisGroup)),i._axisLineGroup.clear(),i._axisStripGroup.clear(),i._axisConstantLineGroup.clear(),i._axisLableGroup.clear()):(i._axisGroup=i.renderer.createGroup({"class":f,clipId:i.clipRectID}),i._axisStripGroup=i.renderer.createGroup({"class":e}),i._axisGridGroup=i.renderer.createGroup({"class":"dxc-grid"}).append(i._axisGroup),i._axisElementsGroup=i.renderer.createGroup({"class":"dxc-elements"}).append(i._axisGroup),i._axisLineGroup=i.renderer.createGroup({"class":"dxc-line"}).append(i._axisGroup),i._axisTitleGroup=i.renderer.createGroup({"class":"dxc-title"}).append(i._axisGroup),i._axisConstantLineGroup=i.renderer.createGroup({"class":o}),i._axisLableGroup=i.renderer.createGroup({"class":"dxc-axis-labels"})),i._initAxisPositions(),i._virtual||(i._drawAxis(),i._drawTicks(),i._drawLabels(),i._drawTitle()),r.strips&&i._drawStrip(),r.constantLines&&i._drawConstantLine(),i._drawGrid(n.borderOptions),i._axisStripGroup.append(i.stripsGroup),i._axisConstantLineGroup.append(i.constantLinesGroup),i._axisGroup.append(i.axesContainerGroup),i._axisLableGroup.append(i.labelAxesGroup),i._adjustConstantLineLabels(),i._adjustLabels(),i._adjustStripLabels(),i._adjustTitle(),i._setBoundingRect()},_setBoundingRect:function(){var n=this,s=n.options,t=n._axisElementsGroup?n._axisElementsGroup.getBBox():{x:0,y:0,width:0,height:0,isEmpty:!0},l=n._axisLineGroup.getBBox(),h=s.placeholderSize,e,c=s.isHorizontal,i=c&&"y"||"x",o=c&&"height"||"width",r=n.title&&n._axisTitleGroup?n._axisTitleGroup.getBBox():t;if(t.isEmpty&&r.isEmpty&&!h){n.boundingRect=t;return}e=l[i]||n.axisPosition,s.position===(c&&f||u)?(t[o]=h||r[i]+r[o]-e,t[i]=e):(t[o]=h||l[o]+e-r[i],t[i]=r.isEmpty?e:r[i]),n.boundingRect=t},getBoundingRect:function(){return this._axisElementsGroup?this.boundingRect:{x:0,y:0,width:0,height:0}},shift:function(n,t){var i={};n&&(i.translateX=n),t&&(i.translateY=t),this._axisGroup.applySettings(i)},applyClipRect:function(n){this._axisStripGroup.applySettings({clipId:n})},validate:function(n,t){var r=this,i=r.options,u=i.range,e=new w.ParseUtils,f=n?i.argumentType:i.valueType,o=f?e.getParser(f,"axis"):function(n){return n};r.parser=o,r.incidentOccured=t,i.dataType=f,i.min&&(i.min=r.validateUnit(i.min,"E2106")),i.max&&(i.max=r.validateUnit(i.max,"E2106")),u.min&&(u.min=r.validateUnit(u.min)),u.max&&(u.max=r.validateUnit(u.max))},validateUnit:function(n,t,r){var u=this,f=u.options.dataType;return n=u.parser(n),n===i&&t&&u.incidentOccured(t,[r]),n},adjustZoomValues:function(n,t){var r=this,i=r.options.range;return n=r.validateUnit(n),t=r.validateUnit(t),i&&o(i.min)&&(n=o(n)?i.min<n?n:i.min:n,t=o(t)?i.min<t?t:i.min:t),i&&o(i.max)&&(t=o(t)?i.max>t?t:i.max:t,n=o(n)?i.max>n?n:i.max:n),r.minRangeArg=n,r.maxRangeArg=t,{min:n,max:t}},getRangeData:function(){var r=this,i=r.options,t=i.range,n={},u,f,e=function(t){i.valueMarginsEnabled?o(i[t])&&(n[t]=i[t],n[t+"Priority"]=b):(n[t]=0,n[t+"Priority"]=b)};return o(t.min)&&o(t.max)?(u=t.min<t.max?t.min:t.max,f=t.max>t.min?t.max:t.min):(u=t.min,f=t.max),n.min=u,n.max=f,e("minValueMargin"),e("maxValueMargin"),n.stick=!i.valueMarginsEnabled,n.categories=t.categories,n.dataType=i.dataType,n.axisType=i.type,n.axisType==="logarithmic"&&(n.base=i.logarithmBase),i.isHorizontal?(n.minVisible=o(r.minRangeArg)?r.minRangeArg:t.min,n.maxVisible=o(r.maxRangeArg)?r.maxRangeArg:t.max,n.invert=i.inverted):(n.minVisible=t.min,n.maxVisible=t.max,n.invert=i.inverted||i.type==="discrete"&&i.oppositeDirectionYAxis),n}})}(jQuery,DevExpress),function(n,t,i){var f=t.ui,r=t.viz.charts,u=t.utils,s=1200,h={animate:!1,isResize:!0},o=["reinit","_reinitDataSource","_handleDataSourceChanged","force_render"],e=t.viz.core,c={asyncSeriesRendering:!0,asyncTrackersRendering:!0,trackerRenderingDelay:s};r.BaseChart=e.BaseWidget.inherit({_setDefaultOptions:function(){this.callBase(),this.option({done:n.noop,drawn:n.noop,seriesClick:null,pointClick:null,legendClick:null,argumentAxisClick:null,seriesHover:null,pointHover:null,seriesSelected:null,pointSelected:null,seriesSelectionChanged:null,pointSelectionChanged:null,seriesHoverChanged:null,pointHoverChanged:null})},_createThemeManager:function(){return r.factory.createThemeManager(this.option())},_init:function(){var n=this;n.callBase(),n.themeManager=this._createThemeManager(),n._initRenderer(),n.canvasClipRect=n.renderer.createClipRect(),n._createHtmlStructure(),n._needHandleRenderComplete=!0,n.layoutManager=r.factory.createChartLayoutManager(n.themeManager.getOptions("adaptiveLayout")),n._reinit();n._element().css({webkitUserSelect:"none"}).on("contextmenu",function(n){(f.events.isTouchEvent(n)||f.events.isPointerEvent(n))&&n.preventDefault()}).on("MSHoldVisual",function(n){n.preventDefault()})},_reinit:function(){var n=this;n.layoutManager.update(n),n._createTracker(),n._reinitDataSource()},_createHtmlStructure:function(){var n=this,t=n.renderer;n._panesBackgroundGroup=t.createGroup({"class":"dxc-background"}),n._titleGroup=t.createGroup({"class":"dxc-title"}),n._legendGroup=t.createGroup({"class":"dxc-legend",clipId:n._getCanvasClipRectID()}),n._stripsGroup=t.createGroup({"class":"dxc-strips-group"}),n._constantLinesGroup=t.createGroup({"class":"dxc-constant-lines-group"}),n._axesGroup=t.createGroup({"class":"dxc-axes-group"}),n._panesBorderGroup=t.createGroup({"class":"dxc-border"}),n._labelAxesGroup=t.createGroup({"class":"dxc-strips-labels-group"}),n._seriesGroup=t.createGroup({"class":"dxc-series-group"}),n._labelsGroup=t.createGroup({"class":"dxc-labels-group"}),n._tooltipGroup=t.createGroup({"class":"dxc-tooltip"}),n._trackerGroup=t.createGroup({"class":"dxc-trackers",opacity:.0001,stroke:"gray",fill:"gray"}),n._crosshairTrackerGroup=t.createGroup({"class":"dxc-crosshair-trackers",stroke:"none",fill:"grey"}).append(n._trackerGroup),n._seriesTrackerGroup=t.createGroup({"class":"dxc-series-trackers"}).append(n._trackerGroup),n._markerTrackerGroup=t.createGroup({"class":"dxc-markers-trackers",stroke:"none",fill:"grey"}).append(n._trackerGroup),n._crossHairCursorGroup=t.createGroup({"class":"dxc-crosshair-cursor"})},_cleanHtmlStructure:function(){var n=this;n._panesBackgroundGroup&&n._panesBackgroundGroup.clear(),n._titleGroup&&n._titleGroup.clear(),n._legendGroup&&(n._legendGroup.detach(),n._legendGroup.clear()),n._stripsGroup&&(n._stripsGroup.detach(),n._stripsGroup.clear()),n._constantLinesGroup&&(n._constantLinesGroup.detach(),n._constantLinesGroup.clear()),n._axesGroup&&(n._axesGroup.detach(),n._axesGroup.clear()),n._labelAxesGroup&&(n._labelAxesGroup.detach(),n._labelAxesGroup.clear()),n._seriesGroup&&(n._seriesGroup.detach(),n._seriesGroup.clear()),n._labelsGroup&&(n._labelsGroup.detach(),n._labelsGroup.clear()),n._trackerGroup&&(n._trackerGroup.detach(),n._seriesTrackerGroup.clear(),n._markerTrackerGroup.clear(),n._crosshairTrackerGroup.clear()),n._panesBorderGroup&&n._panesBorderGroup.clear(),n._tooltipGroup&&n._tooltipGroup.clear(),n._crossHairCursorGroup&&(n._crossHairCursorGroup.clear(),n._crossHairCursorGroup.detach())},_disposeObjectsInArray:function(t,i){n.each(this[t]||[],function(t,r){i&&r?n.each(i,function(n,t){r[t]&&r[t].dispose()}):r&&r.dispose()}),this[t]=null},_dispose:function(){var t=this,n=function(n){t[n]&&t[n].dispose(),t[n]=null},i=function(n){t[n]&&t[n].detach()},r=this._disposeObjectsInArray;clearTimeout(t.delayedRedraw),t.callBase(),r.call(t,"businessRanges",["arg","val"]),t.translators=null,r.call(t,"series"),n("layoutManager"),n("themeManager"),n("renderer"),n("tracker"),n("tooltip"),n("chartTitle"),t.paneAxis=null,t._userOptions=null,t.dirtyCanvas=null,t.canvas=null,i("_legendGroup"),i("_stripsGroup"),i("_constantLinesGroup"),i("_axesGroup"),i("_labelAxesGroup"),i("_seriesGroup"),i("_labelsGroup"),i("_trackerGroup"),i("_crossHairCursorGroup"),n("canvasClipRect"),n("_panesBackgroundGroup"),n("_titleGroup"),n("_legendGroup"),n("_stripsGroup"),n("_constantLinesGroup"),n("_axesGroup"),n("_labelAxesGroup"),n("_panesBorderGroup"),n("_seriesGroup"),n("_labelsGroup"),n("_tooltipGroup"),n("_crossHairCursorGroup"),n("_seriesTrackerGroup"),n("_markerTrackerGroup"),n("_crosshairTrackerGroup"),n("_trackerGroup"),t._disposeLoadIndicator()},_clean:function(n){this.renderer&&this.renderer.stopAllAnimations(),n&&this.hideLoadingIndicator(),this._cleanHtmlStructure(),this.callBase(),this._saveDirtyCanvas()},_getAnimationOptions:function(){return n.extend({},c,this.themeManager.getOptions("animation"))},_initRenderer:function(){this.renderer||(this.renderer=e.CoreFactory.createRenderer({animation:this._getAnimationOptions(),cssClass:"dxc dxc-chart",pathModified:this.option("pathModified"),rtl:this.themeManager.getOptions("rtlEnabled")}))},_initSeries:function(){this.series=this.series||this._populateSeries()},_reinitDataSource:function(){this._refreshDataSource()},_saveDirtyCanvas:function(){this.dirtyCanvas=n.extend({},this.canvas)},_resize:function(){this._render(h)},_calculateCanvas:function(){var t=this.themeManager.getOptions("size"),i={},r=this._element();return i.width=u.isDefined(t.width)?t.width<0?0:t.width:r.width()||400,i.height=u.isDefined(t.height)?t.height<0?0:t.height:r.height()||400,n.extend({},i,this.themeManager.getOptions("margin"))},_createTracker:function(){var n=this,t=n.themeManager.getOptions("tooltip")||{};n.tracker&&n.tracker.dispose(),n.tracker=r.factory.createTracker({series:n.series,valueAxis:n._valueAxes,argumentAxis:n._argumentAxes,seriesSelectionMode:n.themeManager.getOptions("seriesSelectionMode"),pointSelectionMode:n.themeManager.getOptions("pointSelectionMode"),tooltipShown:n.option("tooltipShown"),tooltipHidden:n.option("tooltipHidden"),markerTrackerGroup:n._markerTrackerGroup,crossHairOptions:n._crossHairOptions,seriesTrackerGroup:n._seriesTrackerGroup,seriesGroup:n._seriesGroup,tooltipEnabled:t.enabled,renderer:n.renderer,events:{seriesClick:n.option("seriesClick"),pointClick:n.option("pointClick"),argumentAxisClick:n.option("argumentAxisClick"),seriesHover:n.option("seriesHover"),seriesSelected:n.option("seriesSelected"),pointHover:n.option("pointHover"),pointSelected:n.option("pointSelected"),legendClick:n.option("legendClick"),seriesSelectionChanged:n.option("seriesSelectionChanged"),pointSelectionChanged:n.option("pointSelectionChanged"),seriesHoverChanged:n.option("seriesHoverChanged"),pointHoverChanged:n.option("pointHoverChanged")}})},_updateTracker:function(){var t=this;t.tracker?t.tracker._reinit({series:t.series,valueAxis:t._valueAxes,argumentAxis:t._argumentAxes,legendGroup:t.legend.getTrackerGroup(),legendCallback:n.proxy(t.legend.getActionCallback,t.legend)}):t._createTracker()},_render:function(n){this._optionsInitializing=!1;var t=this,u=t.renderer,r=t.canvas,o=this._element(),e=t._calculateCanvas(),f=t.dirtyCanvas;if(n=n||{recreateCanvas:!0},n.recreateCanvas=n.recreateCanvas||!u.isInitialized(),!n.force&&f&&f.width===e.width&&f.height===e.height&&!t.hiddenContainer){t.stopRedraw=!0;return}if(clearTimeout(t.delayedRedraw),n.recreateCanvas&&(t.canvas=r=t._calculateCanvas()),r.width&&r.height&&o.is(":visible"))t.hiddenContainer=!1;else{t._incidentOccured("W2001",[t.NAME]),t.hiddenContainer=!0,t.stopRedraw=!0,u.detachContainer();return}n.recreateCanvas&&(u.recreateCanvas(t.canvas.width,t.canvas.height),u.draw(t._element()[0]),t._reappendLoadIndicator(),t._updateLoadIndicator(i,r.width,r.height),t._updateCanvasClipRect()),t.renderer.stopAllAnimations(!0),t.layoutManager.update(t),t._cleanGroups(n),t._saveDirtyCanvas()},_cleanGroups:function(n){var t=this;t._stripsGroup.detach(),t._constantLinesGroup.detach(),t._axesGroup.detach(),t._labelAxesGroup.detach(),t._labelsGroup.detach(),t._tooltipGroup.detach(),t._crossHairCursorGroup.detach(),(!n||n.drawLegend)&&(t._legendGroup.detach(),t._legendGroup.clear()),(!n||n.drawTitle)&&(t._titleGroup.detach(),t._titleGroup.clear()),t._stripsGroup.clear(),t._constantLinesGroup.clear(),t._axesGroup.clear(),t._labelAxesGroup.clear(),t._labelsGroup.clear(),t._tooltipGroup.clear(),t._crossHairCursorGroup.clear(),t._crosshairTrackerGroup.clear()},_drawTitle:function(){var n=this,t=n.themeManager.getOptions("title"),i=n.canvas.width-n.canvas.left-n.canvas.right;t._incidentOccured=n._incidentOccured,n.chartTitle?n.chartTitle.update(t,i):n.chartTitle=r.factory.createTitle(n.renderer,t,i,n._titleGroup)},_createTooltip:function(){var t=this,r=n.extend(!0,{canvasWidth:t.canvas.width,canvasHeight:t.canvas.height},t.themeManager.getOptions("tooltip")||{}),f,o=this.tracker.pointAtShownTooltip;!n.isFunction(r.customizeText)&&u.isDefined(r.customizeText)&&(t._incidentOccured("E2103",["customizeText"]),r.customizeText=i),t.tooltip?t.tooltip.update(r):t.tooltip=e.CoreFactory.createTooltip(r,t._tooltipGroup,t.renderer),t.tracker.setTooltip(t.tooltip),o&&(f=o.getTooltipCoords(),t.tooltip.move(~~f.x,~~f.y,f.offset),t.tooltip.show())},_prepareDrawOptions:function(t){var r=this._getAnimationOptions(),i;return i=n.extend({},{force:!1,adjustAxes:!0,drawLegend:!0,drawTitle:!0,adjustSeriesLabels:!0,animate:r.enabled,animationPointsLimit:r.maxPointCountSupported,asyncSeriesRendering:r.asyncSeriesRendering,asyncTrackersRendering:r.asyncTrackersRendering,trackerRenderingDelay:r.trackerRenderingDelay},t),u.isDefined(i.recreateCanvas)||(i.recreateCanvas=i.adjustAxes&&i.drawLegend&&i.drawTitle),i},_processRefreshData:function(t){var i=n.inArray(this._currentRefreshData,o),r=n.inArray(t,o);(!this._currentRefreshData||i>=0&&r<i)&&(this._currentRefreshData=t)},_disposeSeries:function(){var t=this;t.tracker._clean(),n.each(t.series||[],function(n,t){t.dispose()}),t.series=null,n.each(t.seriesFamilies||[],function(n,t){t.dispose()}),t.seriesFamilies=null},_optionChanged:function(n){var t=this,i=this.themeManager;if(i.resetOptions(n),i.update(t._options),n==="animation"){t.renderer.updateAnimationOptions(this._getAnimationOptions());return}clearTimeout(t.delayedRedraw);switch(n){case"dataSource":t._needHandleRenderComplete=!0,t._processRefreshData("_reinitDataSource");break;case"palette":t.themeManager.updatePalette(this.option(n)),t._disposeSeries(),t._needHandleRenderComplete=!0,t._processRefreshData("_handleDataSourceChanged");break;case"series":case"commonSeriesSettings":case"containerBackgroundColor":case"dataPrepareSettings":t._disposeSeries(),t._needHandleRenderComplete=!0,t._processRefreshData("_handleDataSourceChanged");break;case"legend":case"seriesTemplate":t._processRefreshData("_handleDataSourceChanged");break;case"title":t._processRefreshData("force_render");break;case"valueAxis":case"argumentAxis":case"commonAxisSettings":t._needHandleRenderComplete=!0,t._processRefreshData("reinit"),t._disposeSeries(),t.paneAxis={};break;case"panes":case"defaultPane":t._disposeSeries(),t.paneAxis={},t._needHandleRenderComplete=!0,t._processRefreshData("reinit");break;case"size":t._processRefreshData("force_render");break;case"rotated":case"equalBarWidth":case"customizePoint":case"customizeLabel":t._disposeSeries(),t._needHandleRenderComplete=!0,t._processRefreshData("reinit");break;case"theme":t._disposeSeries(),i.setTheme(t.option(n)),t._processRefreshData("reinit");break;default:t._processRefreshData("reinit")}t.callBase.apply(t,arguments)},_getLoadIndicatorOption:function(){return this.themeManager.getOptions("loadingIndicator")},_refresh:function(){var n=this;if(this.renderer.stopAllAnimations(!0),n._currentRefreshData){switch(n._currentRefreshData){case"force_render":n._render({force:!0});break;case"reinit":n._reinit(!0);break;default:n[n._currentRefreshData]&&n[n._currentRefreshData]()}delete n._currentRefreshData}else n._render({force:!0})},_dataSourceOptions:function(){return{paginate:!1,_preferSync:!0}},_updateCanvasClipRect:function(n){var t=this,i,r;n=n||t.canvas,i=Math.max(n.width-n.left-n.right,0),r=Math.max(n.height-n.top-n.bottom,0),t.canvasClipRect.updateRectangle({x:n.left,y:n.top,width:i,height:r}),t.canvasClipRect.append()},_getCanvasClipRectID:function(){return this.canvasClipRect.id},_handleDataSourceChanged:function(){clearTimeout(this.delayedRedraw),this._dataSpecificInit(!0)},_groupSeries:function(){this._groupedSeries=[this.series]},_dataSpecificInit:function(n){this._initSeries(),this._repopulateSeries(),this._handleSeriesPopulated(n)},_processSingleSeries:function(){},_repopulateSeries:function(){var t=this,f,i=t._dataSource&&t._dataSource.items(),o=t.themeManager.getOptions("dataPrepareSettings"),e=t.themeManager.getOptions("seriesTemplate");t._dataSource&&e&&(t._templatedSeries=u.processSeriesTemplate(e,t._dataSource.items()),t._populateSeries(),delete t._templatedSeries,i=t.teamplateData||i),t._groupSeries(),t._dataValidator=r.factory.createDataValidator(i,t._groupedSeries,t._incidentOccured,o),f=t._dataValidator.validate(),t.themeManager.resetPalette(),n.each(t.series,function(n,i){i.updateData(f),t._processSingleSeries(i)})},_handleRenderComplete:function(){var t=this,r=this.option("done"),i=!0;t._needHandleRenderComplete&&(n.each(t.series,function(n,t){i=i&&t.canRenderCompleteHandle()}),i&&(t._needHandleRenderComplete=!1,n.isFunction(r)&&r.call(t)))},_renderTitleAndLegend:function(n,t){var i=this,f=i.themeManager.getOptions("title"),u=f.text&&n.drawTitle,e=n.drawLegend&&i.legend&&!t,r=[];u&&(i._titleGroup.append(),i._drawTitle(),r.push(i.chartTitle)),e&&(i._legendGroup.append(),r.push(i.legend)),r.length&&i.layoutManager.drawElements(r,i.canvas),u&&i.layoutManager.correctSizeElement(i.chartTitle,i.canvas)},getAllSeries:function(){return this.series.slice()},getSeriesByName:function(t){var i=null;return n.each(this.series,function(n,r){if(r.name===t)return i=r,!1}),i},getSeriesByPos:function(n){return this.series[n]},getSelectedSeries:function(){return null},clearSelection:function(){this.tracker.clearSelection()},hideTooltip:function(){this.tracker._hideTooltip()},showLoadingIndicator:function(){this._showLoadIndicator(this.themeManager.getOptions("loadingIndicator"),this.canvas||{})},render:function(n){this._render(n)},getSize:function(){var n=this.canvas||{};return{width:n.width,height:n.height}}}).include(f.DataHelperMixin)}(jQuery,DevExpress),function(n,t,i){function h(t){return n.isArray(t)?t.length===0?[{}]:t:[t]}var f=t.viz.core,e=t.viz.charts,u=t.utils,c=5,s="default",l="defaultAxisName",o=.1,a=25,r=n.each;e.Chart=e.BaseChart.inherit({_setDefaultOptions:function(){this.callBase(),this.option({defaultPane:s,panes:[{name:s,border:{}}]})},_dispose:function(){var n=this,t=this._disposeObjectsInArray;n.callBase(),n.panes=null,n.legend&&(n.legend.dispose(),n.legend=null),t.call(n,"panesBackground"),t.call(n,"panesClipRects"),t.call(n,"financialPanesClipRects"),t.call(n,"_argumentAxes"),t.call(n,"_valueAxes"),t.call(n,"seriesFamilies"),r(n._paneTrackerGroups||[],function(n,t){t.paneSeriesGroup.dispose(),t.paneMarkerGroup.dispose()}),n._paneTrackerGroups=null},_init:function(){this.paneAxis={},this._crossHairOptions={},this.callBase()},_reinit:function(n){var t=this;t.translators={},t.panes=t._createPanes(),t._populateAxes(),t.callBase(),delete t._seriesInitializing,t.series?t._correctValueAxes():t._dataSpecificInit(),t._endLoading(function(){n&&t._render({force:!0})})},_correctBusinessRange:function(t,i,r){var f="min",o="max",e,s;return!i||!u.isDefined(t[f])||!u.isDefined(t[o])?!1:(e={},s=i,i=n.isNumeric(i)?i:u.convertDateTickIntervalToMilliseconds(i),i>=Math.abs(t[o]-t[f]))?(u.isDate(t[f])?(n.isNumeric(s)?(e[f]=new Date(t[f].valueOf()-i),e[o]=new Date(t[o].valueOf()+i)):(e[f]=u.addInterval(t[f],s,!0),e[o]=u.addInterval(t[o],s,!1)),r&&(u.correctDateWithUnitBeginning(e[o],s),u.correctDateWithUnitBeginning(e[f],s))):(e[f]=t[f]-i,e[o]=t[o]+i),t.addRange(e),!0):!1},_seriesVisibilityChanged:function(){this._processSeriesFamilies(),this._populateBusinessRange(),this.renderer.stopAllAnimations(!0),this._render({force:!0,asyncSeriesRendering:!1,asyncTrackersRendering:!1})},_populateBusinessRange:function(n){var t=this,h=[],c,a,v,s,y=t.themeManager,p=y.getOptions("rotated"),l,w=t._valueAxes,b={},k=t._argumentAxes,tt=y.getOptions("useAggregation"),d,g,it=t.paneAxis,rt=t._groupedSeries,e,nt;t._disposeObjectsInArray("businessRanges",["arg","val"]),e=new f.Range({rotated:!!p,minValueMargin:o,maxValueMargin:o}),r(w,function(n,t){b[t.name]=t}),r(it,function(y,b){r(b,function(b){var ut=[],et,ft,ot,it=new f.Range({isValueRange:!0,rotated:!!p,pane:y,axis:b,minValueMargin:o,maxValueMargin:o}),st,ht,ct;for(r(rt,function(n,t){t[0].pane===y&&t[0].axis===b&&(ut=t)}),r(w,function(n,t){if(t.pane===y&&t.name===b)return ot=t,!1}),et=ut&&ut.length?ut[0]:{},r(k,function(n,i){var r=i.options;r.type=et.argumentAxisType||r.type,r.argumentType=et.argumentType||r.argumentType,i.validate(!0,t._incidentOccured),e=e.addRange(i.getRangeData()),d=r.tickInterval,g=r.setTicksAtUnitBeginning,ht=i.calcInterval}),ft=ot.options,ft.type=et.valueAxisType||ft.type,ft.valueType=et.valueType||ft.valueType,ot.validate(!1,t._incidentOccured),ct=new f.Range(ot.getRangeData()),st=st||ft.valueType==="datetime"?"datetime":i,it=it.addRange(ct),a=it.min,v=it.max,s=0;s<ut.length;s++)n&&(n.minVal=a,n.maxVal=v,tt&&!n.adjustOnZoom&&(c=ut[s]._originalBusinessRange,n.minVal=u.isDefined(n.minVal)?n.minVal:c.val.min,n.maxVal=u.isDefined(n.maxVal)?n.maxVal:c.val.max)),l=ut[s].getRangeData(n,ht),it=it.addRange(l.val),e=e.addRange(l.arg);it.isDefined()||it.setStubData(st),h.push({val:it})})}),e.isDefined()||e.setStubData(k[0].options.argumentType),nt=t._correctBusinessRange(e,d,g),nt||e.applyValueMargins(),r(h,function(n,t){var i=t.val,r=b[i.axis];i.applyValueMargins(),r&&r.options.showZero&&i.correctValueZeroLevel(),t.arg=e}),t.businessRanges=h},_groupSeries:function(){var t=this,o=t.panes,u=t._valueAxes,s=n.map(o,function(n){return n.name}),f=t.series,i=t.paneAxis,h=t._groupedSeries=[],c=function(n,t){for(var r,i=0;i<n.length;i++)if(n[i].pane===t){r=n[i].name;break}return r||(r=u[0].name),r},e;r(f,function(n,t){t.axis=t.axis||c(u,t.pane),t.axis&&(i[t.pane]=i[t.pane]||{},i[t.pane][t.axis]=!0)}),r(u,function(t,r){r.name&&r.pane&&n.inArray(r.pane,s)!=-1&&(i[r.pane]=i[r.pane]||{},i[r.pane][r.name]=!0)}),t._correctValueAxes(),e=function(n){var f=[],i;r(u,function(t,i){i.pane===n&&f.push(i)}),f.length>1&&t.themeManager.getOptions("synchronizeMultiAxes")&&r(f,function(n,t){var r=t.options.grid;i&&r&&r.visible?r.visible=!1:i=i?i:r&&r.visible})},r(i,function(n,t){e(n),r(t,function(t){var u=[];r(f,function(i,r){r.pane===n&&r.axis===t&&u.push(r)}),u.length&&h.push(u)})})},_cleanPanesClipRects:function(n){var t=this,i=t[n];r(i||[],function(n,t){t&&t.remove()}),t[n]=[]},_createPanes:function(){var i=this,t=i.option("panes"),e=0,f;return(t&&u.isArray(t)&&!t.length||n.isEmptyObject(t))&&(t=i.initialOption("panes")),i._cleanPanesClipRects("panesClipRects"),i._cleanPanesClipRects("financialPanesClipRects"),i.defaultPane=i.option("defaultPane"),t=n.isArray(t)?t:t?[t]:[],r(t,function(n,t){t.name=u.isDefined(t.name)?t.name:s+e++}),!i._doesPaneExists(t,i.defaultPane)&&t.length>0&&(f=t[t.length-1].name,i._incidentOccured("W2101",[i.defaultPane,f]),i.defaultPane=f),t=i.themeManager.getOptions("rotated")?t.reverse():t},_doesPaneExists:function(n,t){var i=!1;return r(n,function(n,r){if(r.name===t)return i=!0,!1}),i},_populateSeries:function(){var i=this,o=i.themeManager,p=!!o.getOptions("seriesTemplate"),l=p?i._templatedSeries:i.option("series"),w=n.isArray(l)?l:l?[l]:[],a=i.option("argumentAxis"),s=i.option("valueAxis"),b,t,h,k=o.getOptions("rotated"),c,d=n.map(i.panes,function(n){return n.name}),v,y,e;for(i.teamplateData=[],r(i._paneTrackerGroups||[],function(n,t){t.paneSeriesGroup.remove(),t.paneMarkerGroup.remove()}),i._paneTrackerGroups=[],r(i.panes,function(){var r=i.renderer.createGroup({"class":"dxc-pane-tracker"}),u=i.renderer.createGroup({"class":"dxc-pane-tracker"});i._paneTrackerGroups.push({paneSeriesGroup:r,paneMarkerGroup:u})}),i._disposeSeries(),i.series=[],o.resetPalette(),c=0;c<w.length;c++)(t=n.extend(!0,{},w[c]),t.type&&!u.isString(t.type)&&(t.type=""),b=t.data,t.data=null,t.rotated=k,t.customizePoint=o.getOptions("customizePoint"),t.customizeLabel=o.getOptions("customizeLabel"),t.visibilityChanged=n.proxy(this._seriesVisibilityChanged,this),t.resolveLabelsOverlapping=o.getOptions("resolveLabelsOverlapping"),a&&(t.argumentCategories=a.categories,t.argumentAxisType=a.type,t.argumentType=a.argumentType),s&&(u.isArray(s)?r(s,function(n,i){(t.axis||n)&&t.axis!==i.name||(t.valueCategories=i.categories,t.valueAxisType=i.type,t.valueType=i.valueType,t.showZero=i.showZero)}):(t.valueCategories=s.categories,t.valueAxisType=s.type,t.valueType=s.valueType,t.showZero=s.showZero)),t.incidentOccured=i._incidentOccured,t.name||(t.name="Series "+(c+1).toString()),e=o.getOptions("series",t),e.pane=e.pane||i.defaultPane,v=e.pane,y=i._getPaneIndex(v),n.inArray(v,d)!==-1)&&(e.seriesGroup=i._seriesGroup,e.labelsGroup=i._labelsGroup,e.trackersGroup=i._paneTrackerGroups[y].paneSeriesGroup,e.markerTrackerGroup=i._paneTrackerGroups[y].paneMarkerGroup,h=f.CoreFactory.createSeries(i.renderer,e),h.isUpdated?(h.index=c,i.series.push(h)):i._incidentOccured("E2101",[e.type]),p&&(r(b,function(n,t){r(h.getTeamplatedFields(),function(n,i){t[i.teamplateField]=t[i.originalField]}),i.teamplateData.push(t)}),h.updateTeamplateFieldNames()));return i.series},_createValueAxis:function(t,i,u){var o=this,f;return t=o.themeManager.getOptions("valueAxis",n.extend({isHorizontal:i,tickProvider:u,incidentOccured:o._incidentOccured},t),i),t.strips&&r(t.strips,function(i){t.strips[i]=n.extend(!0,{},t.stripStyle,t.strips[i])}),t.constantLines&&r(t.constantLines,function(i,r){t.constantLines[i]=n.extend(!0,{},t.constantLineStyle,r)}),f=e.factory.createAxis(o.renderer,t),f.name=t.name,f.pane=f.pane||t.pane,f.priority=t.priority,f},_disposeAxes:function(){var n=this;r(n._valueAxes||[],function(n,t){t.dispose()}),r(n._argumentAxes||[],function(n,t){t.dispose()}),n._valueAxes=null,n._argumentAxes=null},_populateAxes:function(){var t=this,v=[],y=[],u=t.panes,k=t.themeManager,o=k.getOptions("rotated"),d=t.option("valueAxis")||{},g=t.option("argumentAxis")||{},c=h(g),nt=h(d),s,p=[],w=f.CoreFactory.getTickProvider(),a,b;t._disposeAxes(),b=function(i,u){return i=t.themeManager.getOptions("argumentAxis",n.extend(!0,{isHorizontal:!o,tickProvider:w,pane:t.defaultPane,incidentOccured:t._incidentOccured},i),o),i.strips&&r(i.strips,function(t){i.strips[t]=n.extend(!0,{},i.stripStyle,i.strips[t])}),i.constantLines&&r(i.constantLines,function(t,r){i.constantLines[t]=n.extend(!0,{},i.constantLineStyle,r)}),s=e.factory.createAxis(t.renderer,i),s._virtual=u,y.push(s),s},a=o?c[0].position==="right"?u[u.length-1].name:u[0].name:c[0].position==="top"?u[0].name:u[u.length-1].name,r(u,function(t,i){var r=i.name,u=r!=a,f=n.extend(!0,{},c[0],{pane:r});b(f,u)});var tt=0,it=function(){return l+tt++},rt=function(t){for(var r={},u=t.length,i=0;i<u;i++)r[t[i]]=!0;return n.map(r,function(n,t){return t})};r(nt,function(u,f){var e=[],s=f.name;if(s&&n.inArray(s,p)!=-1){t._incidentOccured("E2102");return}s&&p.push(s),f.pane&&e.push(f.pane),f.panes&&f.panes.length&&(e=e.concat(f.panes.slice(0))),e=rt(e),e.length||e.push(i),r(e,function(i,r){v.push(t._createValueAxis(n.extend(!0,{},f,{name:s||it(),pane:r,priority:u}),o,w))})}),t._valueAxes=v,t._argumentAxes=y},_correctValueAxes:function(){var i=this,v=i.themeManager.getOptions("rotated"),s=i.option("valueAxis")||{},h=n.isArray(s)?s:[s],y=f.CoreFactory.getTickProvider(),t=i._valueAxes||[],p=t[0].name,e=i.paneAxis||{},o=i.panes,u,c={},w=function(n){var t;return r(i.paneAxis,function(i,u){r(u,function(r){if(n==r)return t=i,!1})}),t},b=n.map(t,function(n){return n.pane?null:n}),l,a;for(r(b,function(n,t){t.pane=w(t.name),t.pane||(t.pane=i.defaultPane,e[t.pane]=e[t.pane]||{},e[t.pane][t.name]=!0),t.options.pane=t.pane}),u=0;u<o.length;u++)e[o[u].name]||(e[o[u].name]={},e[o[u].name][p]=!0);l=function(n){for(var u,r=0;r<h.length;r++)if(h[r].name==n){u=h[r],u.priority=r;break}if(!u)for(r=0;r<t.length;r++)if(t[r].name==n){u=t[r].options,u.priority=t[r].priority;break}return u||(i._incidentOccured("W2102",[n]),u={name:n,priority:t.length}),u},a=function(n,i){var r;for(u=0;u<t.length;u++)if(r=t[u],r.name===i&&r.pane===n)return r},r(i.paneAxis,function(u,f){r(f,function(r){if(c[r+"-"+u]=!0,!a(u,r)){var e=l(r);e&&t.push(i._createValueAxis(n.extend(!0,{},e,{pane:u,name:r}),v,y))}})}),t=n.grep(t,function(n){return!!c[n.name+"-"+n.pane]}),t.sort(function(n,t){return n.priority-t.priority}),i._valueAxes=t},_processSeriesFamilies:function(){var t=this,u=[],o=[],e,i=t.themeManager,s=i.getOptions("rotated");if(t.seriesFamilies&&t.seriesFamilies.length){r(t.seriesFamilies,function(n,t){t.adjustSeriesValues()});return}r(t.series,function(t,i){n.inArray(i.type,u)===-1&&u.push(i.type)}),r(t.panes,function(n,h){e=[],r(t.series,function(n,t){t.pane===h.name&&e.push(t)}),r(u,function(n,t){var r=f.CoreFactory.createSeriesFamily({type:t,pane:h.name,rotated:s,equalBarWidth:i.getOptions("equalBarWidth"),minBubbleSize:i.getOptions("minBubbleSize"),maxBubbleSize:i.getOptions("maxBubbleSize")});r.add(e),r.adjustSeriesValues(),o.push(r)})}),t.seriesFamilies=o},_createLegend:function(){var t=this,r=[],i=t.themeManager.getOptions("legend");r=n.map(t.series,function(n){if(n.getOptions().showInLegend)return{text:n.name,color:n.getColor(),id:n.index,states:n.getLegendStyles()}}),i.containerBackgroundColor=t.themeManager.getOptions("containerBackgroundColor"),i._incidentOccured=t._incidentOccured,t.legend?t.legend.update(r,i):t.legend=f.CoreFactory.createLegend(r,i,t.renderer,t._legendGroup)},_createTranslator:function(n,t,i){return f.CoreFactory.createTranslator2D(n,t,i)},_createPanesBorderOptions:function(){var i=this.themeManager.getOptions("commonPaneSettings").border,t={};return r(this.panes,function(r,u){var f=n.extend(!0,{},i,u.border);t[u.name]=f}),t},_render:function(i){var f=this,l=f.themeManager,o=l.getOptions("rotated"),s,h=f.layoutManager,v=f._createPanesBorderOptions(),y,c=f.legend&&f.legend.getPosition()==="inside",p=function(){function b(n){var t=f._getPaneIndex(n.pane);n.setClippingParams(n.isFinancialSeries()?f.financialPanesClipRects[t].id:f.panesClipRects[t].id,f._getPaneBorderVisibility(t))}function k(n,i){if(l.getOptions("tooltip").shared){var f=n.getPoints(),u=n.getStackName();r(f,function(n,f){var e=f.argument;i[e]||(i[e]={},i[e][null]=[]),u&&!t.utils.isArray(i[e][u])&&(i[e][u]=[],r(i[e][null],function(n,t){t.stackName||i[e][u].push(t)})),u?(i[e][u].push(f),i[e][null].push(f)):r(i[e],function(n,t){t.push(f)}),f.stackPoints=i[e][u],f.stackName=u})}}var u=f.panes,v=f.layoutManager.needMoreSpaceForPanesCanvas(f.panes,o)&&!f.themeManager.getOptions("adaptiveLayout").keepLabels,w={},s,h,a;r(f.seriesFamilies||[],function(n,t){var r=f._getTranslator(t.pane)||{},i={};i[o?"x":"y"]=r.val,i[o?"y":"x"]=r.arg,t.updateSeriesValues(i),t.adjustSeriesDimensions(i)}),f._createCrossHairCursor(),r(f.series,function(n,t){k(t,w),b(t),t.setAdjustSeriesLabels(i.adjustSeriesLabels);var u=f._getTranslator(t.pane,t.axis),r={};r[o?"x":"y"]=u.val,r[o?"y":"x"]=u.arg,t.draw(r,i.animate&&t.getPoints().length<=i.animationPointsLimit&&f.renderer.animationEnabled(),v,f.legend&&f.legend.getActionCallback(t))}),f._trackerGroup.append(),i.drawLegend&&f.legend&&c&&(s=n.extend({},u[0].canvas),h=e.factory.createChartLayoutManager(),s.right=u[u.length-1].canvas.right,s.bottom=u[u.length-1].canvas.bottom,f._legendGroup.append(),f._tooltipGroup.append(),h.drawElements([f.legend],s),h.placeDrawnElements(s)),y&&f.hideLoadingIndicator(),f._drawn(),a=function(){for(var n=0;n<f.series.length;n++)f.series[n].drawTrackers();f.legend&&(f.legend.drawTrackers(),c&&f._legendGroup.append(),c&&f._tooltipGroup.append()),f.tracker._prepare(),r(f._paneTrackerGroups,function(n,t){t.paneSeriesGroup.append(f._seriesTrackerGroup),t.paneMarkerGroup.append(f._markerTrackerGroup)}),f._handleRenderComplete()},f._createTooltip(),i.asyncTrackersRendering?f.delayedRedraw=setTimeout(a,i.trackerRenderingDelay):a()};if(i=f._prepareDrawOptions(i),f.callBase(i),f.stopRedraw){f.stopRedraw=!1;return}for(f._createPanesBackground(),f._stripsGroup.append(),f._axesGroup.append(),f._constantLinesGroup.append(),f._labelAxesGroup.append(),f._createTranslators(i),f._options.useAggregation&&r(f.series,function(n,t){t._originalBusinessRange=t._originalBusinessRange||t.getRangeData();var r=f._getTranslator(t.pane,t.axis),i={};i[o?"x":"y"]=r.val,i[o?"y":"x"]=r.arg,t.resamplePoints(i,f._zoomMinArg,f._zoomMaxArg)}),(u.isDefined(f._zoomMinArg)||u.isDefined(f._zoomMaxArg))&&f._populateBusinessRange({adjustOnZoom:l.getOptions("adjustOnZoom"),minArg:f._zoomMinArg,maxArg:f._zoomMaxArg}),(f._options.useAggregation||u.isDefined(f._zoomMinArg)||u.isDefined(f._zoomMaxArg))&&f._updateTranslators(),f._renderTitleAndLegend(i,c),i&&i.recreateCanvas&&h.updatePanesCanvases(f.panes,f.canvas,o),f._drawAxes(v,i),h.needMoreSpaceForPanesCanvas(f.panes,o)&&(h.updateDrawnElements(f._argumentAxes,f._valueAxes,f.canvas,f.dirtyCanvas,f.panes,o),f.chartTitle&&f.layoutManager.correctSizeElement(f.chartTitle,f.canvas),f._updateCanvasClipRect(f.dirtyCanvas),h.updatePanesCanvases(f.panes,f.canvas,o),f._drawAxes(v,i,!0)),h.placeDrawnElements(f.canvas),f._drawPanesBorders(v),f._createClipRectsForPanes(),s=0;s<f._argumentAxes.length;s++)f._argumentAxes[s].applyClipRect(f._getElementsClipRectID(f._argumentAxes[s].pane));for(s=0;s<f._valueAxes.length;s++)f._valueAxes[s].applyClipRect(f._getElementsClipRectID(f._valueAxes[s].pane));f._fillPanesBackground(),f._seriesGroup.append(),f._labelsGroup.append(),f._crossHairCursorGroup.append(),f._legendGroup.append(),f._tooltipGroup.append(),y=f._loadIndicator&&f._loadIndicator.isShown&&f._dataSource&&f._dataSource.isLoaded()&&!i.isResize,i.asyncSeriesRendering?f.delayedRedraw=setTimeout(p,a):p()},_createTranslators:function(n){var t=this,u=t.themeManager.getOptions("rotated"),i;n.recreateCanvas&&(t.translators=i={},t.layoutManager.updatePanesCanvases(t.panes,t.canvas,u),r(t.paneAxis,function(n,e){i[n]=i[n]||{},r(e,function(r){var o=t._createTranslator(new f.Range(t._getBusinessRange(n,r).val),t._getCanvasForPane(n),u?{direction:"horizontal"}:{});o.pane=n,o.axis=r,i[n][r]={val:o}})}),r(t._argumentAxes,function(n,e){var o=t._createTranslator(new f.Range(t._getBusinessRange(e.pane).arg),t._getCanvasForPane(e.pane),u?{}:{direction:"horizontal"});r(i[e.pane],function(n,t){t.arg=o})}))},_updateTranslators:function(){var n=this;r(n.translators,function(t,i){r(i,function(i,r){r.arg.updateBusinessRange(new f.Range(n._getBusinessRange(t).arg)),delete r.arg._originalBusinessRange,r.val.updateBusinessRange(new f.Range(n._getBusinessRange(t,i).val)),delete r.val._originalBusinessRange})})},_reinitTranslators:function(){var n=this;r(n._argumentAxes,function(t,i){var r=n._getTranslator(i.pane);r&&(r.arg.reinit(),i.setRange(r.arg.getBusinessRange()),i.setTranslator(r.arg,r.val))}),r(n._valueAxes,function(t,i){var r=n._getTranslator(i.pane,i.name);r&&(r.val.reinit(),i.setRange(r.val.getBusinessRange()),i.setTranslator(r.val,r.arg))})},_drawAxes:function(n,t,i){function a(t){r(t,function(t,r){r.clipRectID=u._getCanvasClipRectID(),r.stripsGroup=u._stripsGroup,r.labelAxesGroup=u._labelAxesGroup,r.constantLinesGroup=u._constantLinesGroup,r.axesContainerGroup=u._axesGroup,r.draw({borderOptions:n[r.pane]},i)})}var u=this,f=0,o=u.layoutManager,s=u.themeManager.getOptions("rotated"),l=u.translators,h=0,v=u.themeManager.getOptions("synchronizeMultiAxes");u._reinitTranslators();do{for(f=0;f<u._argumentAxes.length;f++)u._argumentAxes[f].resetTicks();for(f=0;f<u._valueAxes.length;f++)u._valueAxes[f].resetTicks();v&&e.multiAxesSynchronizer.synchronize(u._valueAxes),a(s?u._valueAxes:u._argumentAxes),o.requireAxesRedraw=!1,t.adjustAxes&&(o.applyHorizontalAxesLayout(s?u._valueAxes:u._argumentAxes),o.stopDrawAxes||r(l,function(n,t){r(t,function(n,t){t.arg.reinit(),t.val.reinit()})})),a(s?u._argumentAxes:u._valueAxes),t.adjustAxes&&!o.stopDrawAxes&&(o.applyVerticalAxesLayout(s?u._argumentAxes:u._valueAxes),o.stopDrawAxes||r(l,function(n,t){r(t,function(n,t){t.arg.reinit(),t.val.reinit()})})),h=h+1}while(!o.stopDrawAxes&&o.requireAxesRedraw&&h<c)},_createCrossHairCursor:function(){var u=this,e=u.renderer,o=u.panes,i,r,t=u.themeManager.getOptions("crosshair")||{},s,h,c,l,f;if(t&&t.enabled){for(c={stroke:t.horizontalLine.color||t.color,strokeWidth:t.horizontalLine.width||t.width,dashStyle:t.horizontalLine.dashStyle||t.dashStyle,visibility:"hidden",opacity:t.horizontalLine.opacity||t.opacity},l={stroke:t.verticalLine.color||t.color,strokeWidth:t.verticalLine.width||t.width,dashStyle:t.verticalLine.dashStyle||t.dashStyle,visibility:"hidden",opacity:t.verticalLine.opacity||t.opacity},f=0;f<o.length;f++)r=o[f].canvas,i?(i.right=r.right,i.bottom=r.bottom):i=n.extend({},r),e.createRect(r.left,r.top,r.width-r.right-r.left,r.height-r.bottom-r.top,0).append(this._crosshairTrackerGroup);t.horizontalLine&&t.horizontalLine.visible&&(s=e.createLine(i.left,i.top,i.width-i.right,i.top,c).append(u._crossHairCursorGroup)),t.verticalLine&&t.verticalLine.visible&&(h=e.createLine(i.left,i.top,i.left,i.height-i.bottom,l).append(u._crossHairCursorGroup)),u._crossHairOptions.horizontalLine=s,u._crossHairOptions.verticalLine=h,u._crossHairOptions.canvas=i}},_createPanesBackground:function(){var n=this,f=n.themeManager.getOptions("commonPaneSettings").backgroundColor,t,e=n.renderer,u,i,r=[];for(n._panesBackgroundGroup&&n._panesBackgroundGroup.clear(),i=0;i<n.panes.length;i++){if(t=n.panes[i].backgroundColor||f,!t||t==="none"){r.push(null);continue}u=e.createRect(0,0,0,0,0,{fill:t,strokeWidth:0}).append(n._panesBackgroundGroup),r.push(u)}n.panesBackground=r,n._panesBackgroundGroup.append()},_fillPanesBackground:function(){var t=this,n;r(t.panes,function(i,r){n=r.borderCoords,t.panesBackground[i]!=null&&t.panesBackground[i].applySettings({x:n.left,y:n.top,width:n.width,height:n.height})})},_calcPaneBorderCoords:function(n){var r=n.canvas,i=n.borderCoords=n.borderCoords||{};i.left=r.left,i.top=r.top,i.right=r.width-r.right,i.bottom=r.height-r.bottom,i.width=Math.max(i.right-i.left,0),i.height=Math.max(i.bottom-i.top,0)},_drawPanesBorders:function(n){var t=this,i=t.themeManager.getOptions("rotated");t._panesBorderGroup&&(t._panesBorderGroup.detach(),t._panesBorderGroup.clear()),r(t.panes,function(r,u){var e,f=n[u.name],o={fill:"none",stroke:f.color,strokeOpacity:f.opacity,strokeWidth:f.width,dashStyle:f.dashStyle};(t._calcPaneBorderCoords(u,i),f.visible)&&(e=u.borderCoords,t.renderer.createSegmentRect(e.left,e.top,e.width,e.height,0,f,o).append(t._panesBorderGroup))}),t._panesBorderGroup.append()},_createClipRect:function(n,t,i,r,u,f){var o=this,e=n[t];e?e.updateRectangle({x:i,y:r,width:u,height:f}):(e=o.renderer.createClipRect(i,r,u,f),n[t]=e),e.append()},_createClipRectsForPanes:function(){var n=this,t=n.canvas;r(n.panes,function(i,u){var c=!1,f=u.borderCoords,e=f.left,o=f.top,s=f.width,h=f.height;n._createClipRect(n.panesClipRects,i,e,o,s,h),r(n.series,function(n,t){t.pane===u.name&&t.isFinancialSeries()&&(c=!0)}),c?(n.themeManager.getOptions("rotated")?(o=0,h=t.height):(e=0,s=t.width),n._createClipRect(n.financialPanesClipRects,i,e,o,s,h)):n.financialPanesClipRects.push(null)})},_getPaneIndex:function(n){var t;return r(this.panes,function(i,r){if(r.name===n)return t=i,!1}),t},_getPaneBorderVisibility:function(n){var i=this.themeManager.getOptions("commonPaneSettings").border.visible,r=this.panes[n]||{},t=r.border||{};return"visible"in t?t.visible:i},_getElementsClipRectID:function(n){return this.panesClipRects[this._getPaneIndex(n)].id},_getTranslator:function(n,t){var u=this.translators[n],i=null;return u?(i=u[t],i||r(u,function(n,t){return i=t,!1}),i):i},_getCanvasForPane:function(n){for(var i=this.panes,r=i.length,t=0;t<r;t++)if(i[t].name===n)return i[t].canvas},_getBusinessRange:function(n,t){for(var r=this.businessRanges||[],f=r.length,u,i=0;i<f;i++)if(r[i].val.pane===n&&r[i].val.axis===t){u=r[i];break}if(!u)for(i=0;i<f;i++)if(r[i].val.pane===n){u=r[i];break}return u},_handleSeriesPopulated:function(n){var t=this;t._processSeriesFamilies(),t._createLegend(),t._populateBusinessRange(),t._processValueAxisFormat(),t._updateTracker(),t._endLoading(function(){n&&t._render({force:!0})})},_processValueAxisFormat:function(){var i=this,u=i._valueAxes,t=[];r(i.series,function(){this.isFullStackedSeries()&&n.inArray(this.axis,t)===-1&&t.push(this.axis)}),r(u,function(){n.inArray(this.name,t)!==-1?this.setPercentLabelFormat():this.resetAutoLabelFormat()})},zoomArgument:function(n,t){var i=this,r=i._argumentAxes[0].adjustZoomValues(n,t);i._zoomMinArg=r.min,i._zoomMaxArg=r.max,i._render({force:!0,drawTitle:!1,drawLegend:!1,adjustAxes:!1,animate:!1,adjustSeriesLabels:!1,asyncSeriesRendering:!1})}})}(jQuery,DevExpress),function(n,t){var r=t.viz.core,u=t.viz.charts,f=t.utils;u.PieChart=u.BaseChart.inherit({_createThemeManager:function(){return u.factory.createThemeManager(this.option(),"pie")},_reinit:function(n){var t=this;t.callBase(),t.series||t._dataSpecificInit(),t._endLoading(function(){n&&t._render({force:!0})})},_populateBusinessRange:function(){var i=[],f=this.series,t=f[0],n,u;this._disposeObjectsInArray("businessRanges"),t&&(n=new r.Range({series:t}),u=t.getRangeData(),n=n.addRange(u.val),n.isDefined()||n.setStubData(),i.push(n)),this.businessRanges=i},_seriesVisibilytyChanged:function(){this.series[0].arrangePoints(),this._populateBusinessRange(),this._refresh()},_createTranslator:function(n){return r.CoreFactory.createTranslator1D(n.min,n.max,360,0)},_populateSeries:function(){var t=this,l=t.renderer,e=t.themeManager,a=!!e.getOptions("seriesTemplate"),o=a?t._templatedSeries:t.option("series"),h=n.isArray(o)?o:o?[o]:[],c,u,s,i;return t._disposeSeries(),t.series=[],e.resetPalette(),h.length&&(u=n.extend(!0,{},h[0]),u.type&&!f.isString(u.type)&&(u.type=""),c=u.data,u.data=null,u.incidentOccured=t._incidentOccured,i=e.getOptions("series",u,!0),i.seriesGroup=t._seriesGroup,i.trackerGroup=t._trackerGroup,i.seriesLabelsGroup=t._labelsGroup,i.seriesTrackerGroup=t._seriesTrackerGroup,i.markerTrackerGroup=t._markerTrackerGroup,i.visibilityChanged=n.proxy(this._seriesVisibilytyChanged,this),i.customizePoint=e.getOptions("customizePoint"),i.customizeLabel=e.getOptions("customizeLabel"),s=r.CoreFactory.createSeries(l,i),s.isUpdated?(t._processSingleSeries(s),t.series.push(s)):t._incidentOccured("E2101",[i.type]),u.data=c),t.series},_processSingleSeries:function(n){n.arrangePoints()},_handleSeriesPopulated:function(n){var t=this;t._populateBusinessRange(),t._createLegend(),t._updateTracker(),t._endLoading(function(){n&&t._render({force:!0,recreateCanvas:!0})})},_createLegend:function(){var t=this,i=t.themeManager.getOptions("legend"),u=n.map(t.series[0]?t.series[0].getPoints():[],function(n){return{text:n.argument,color:n.getColor(),id:n.index,states:n.getLegendStyles()}});i._incidentOccured=t._incidentOccured,t.legend=r.CoreFactory.createLegend(u,i,t.renderer,t._legendGroup)},_render:function(n){var t=this,i=t.series&&t.series[0],r=t.layoutManager,u;if(n=t._prepareDrawOptions(n),t.callBase(n),t.stopRedraw){t.stopRedraw=!1;return}t._renderTitleAndLegend(n),r.needMoreSpaceForPanesCanvas([t])&&(r.updateDrawnElements([],[],t.canvas,t.dirtyCanvas,[t]),t.chartTitle&&t.layoutManager.correctSizeElement(t.chartTitle,t.canvas),t._updateCanvasClipRect(t.dirtyCanvas)),r.placeDrawnElements(t.canvas),i&&(u=r.needMoreSpaceForPanesCanvas([t])&&!t.themeManager.getOptions("adaptiveLayout").keepLabels,r.applyPieChartSeriesLayout(t.canvas,i,!0),t._seriesGroup.append(),t._labelsGroup.append(),i.canvas=t.canvas,i.resetLabelEllipsis(),i.draw(t._createTranslator(t.businessRanges[0],t.canvas),n.animate&&t.renderer.animationEnabled(),u),i.redraw&&(t.renderer.stopAllAnimations(!0),r.applyPieChartSeriesLayout(t.canvas,i,u),i.draw(t._createTranslator(t.businessRanges[0],t.canvas),n.animate&&t.renderer.animationEnabled(),u)),t._tooltipGroup.append(),t._trackerGroup.append(),t._createTooltip(),i.drawTrackers(),t.tracker._prepare("pieChart")),t._dataSource&&t._dataSource.isLoaded()&&!n.isResize&&t.hideLoadingIndicator(),t._drawn(),t._handleRenderComplete()},getSeries:function(){return this.series&&this.series[0]}})}(jQuery,DevExpress),function(n,t){var e=t.utils.isNumber,r=Math,f=DevExpress.viz.core.utils.decreaseGaps,o=10,u=r.round;t.viz.charts.LayoutManager=t.Class.inherit(function(){var h=function(n){this.verticalElements=[],this.horizontalElements=[],this._options=n},c=function(n){this.chart=n,t(n&&n.canvas)},l=function(){this.chart=null},t=function(n){n&&(n.originalTop=n.top,n.originalBottom=n.bottom,n.originalLeft=n.left,n.originalRight=n.right)},i=function(i,r){n.each(i,function(n,i){var e,o,f=i.getLayoutOptions(),h=s(f.cutLayoutSide);if(f.width){switch(f.horizontalAlignment){case"left":e=r.left;break;case"center":e=(r.width-r.left-r.right-f.width)/2+r.left;break;case"right":e=r.width-r.right-f.width}switch(f.verticalAlignment){case"top":o=r.top;break;case"bottom":o=r.height-r.bottom-f.height}i.shift(u(e),u(o)),r[f.cutLayoutSide]+=f[h],t(r)}})},a=function(i,r){var u=this,f=u.verticalElements=[],e=u.horizontalElements=[];n.each(i,function(n,i){var c=r.height-r.top-r.bottom,l=r.width-r.left-r.right,u,o,h;i.setSize({height:c,width:l}),i.draw(),u=i.getLayoutOptions(),o=s(u.cutLayoutSide),h=o==="width"?e:f,h.push(i),r[u.cutLayoutSide]+=u[o],t(r)})},s=function(n){var t="height";return(n==="left"||n==="right")&&(t="width"),t},v=function(i,r,f){function c(i,f,e,o){var c=0,l=(f-h*(i.length-1))/s;n.each(i,function(i,s){var a=u(s.weight*l);s.canvas=s.canvas||{},n.extend(s.canvas,{deltaLeft:0,deltaRight:0,deltaTop:0,deltaBottom:0},r),s.canvas[e]=r[e]+c,s.canvas[o]=r[o]+(f-a-c),c=c+a+h,t(s.canvas)})}for(var e,l=r.height-r.top-r.bottom,a=r.width-r.left-r.right,s=0,h=i.padding||10,o=0;o<i.length;o++)e=i[o],e.weight=e.weight||1,s=s+e.weight;f?c(i,a,"left","right"):c(i,l,"top","bottom")},y=function(t,i,u){function a(n,t,i){var r;return r=i<n?n:t<i?t:i}function p(n,t){return Math.sqrt(Math.pow(n-s,2)+Math.pow(t-h,2))}function w(){var t;return i.type==="pie"?t=0:(t=i.innerRadius,e(t)?(t=Number(t),t<.2&&(t=.2),t>.8&&(t=.8)):t=.5),t}var c=t.height-t.top-t.bottom,l=t.width-t.left-t.right,s=l/2+t.left,h=c/2+t.top,f=Math.min(l,c)/2,v=.7*f,y=w(i);u?n.each(i.getPoints(),function(n,t){if(i.getOptions().label.position==="inside")return!1;t._label.originalPosition=t._label.getPosition(),t._label.setPosition("outside")}):n.each(i.getPoints(),function(n,t){if(t._label.hasText()&&t.isVisible()){var i=t._label._getOutsideGroupLabelPosition(),r=a(i.x,i.x+i.width,s),u=a(i.y,i.y+i.height,h),e=Math.max(p(r,u)-o,v);f=Math.min(f,e)}t._label.setPosition(t._label.originalPosition)}),i.correctPosition({centerX:r.floor(s),centerY:r.floor(h),radiusInner:r.floor(f*y),radiusOuter:r.floor(f)})},p=function(n){return!!(n.x||n.y||n.width||n.height)},w=function(t,i){var e,o,r,u,f;return n.each(t,function(t,e){r=e.canvas,n.each(i,function(n,t){u="delta"+t,r[u]=Math.max(r[u]-(r[t.toLowerCase()]-r["original"+t]),0),r[u]>0&&(f=!0)})}),f},b=function(t,i){var r=i[0];return n.each(i,function(n,i){t===i.name&&(r=i)}),r},k=function(t,i,r){var h=this,u,d,s,g,e,o,f,v,c,l,y=[],k,a;for(n.each(i,function(t,i){n.extend(i.canvas,{deltaLeft:0,deltaRight:0,deltaTop:0,deltaBottom:0})}),a=0;a<t.length;a++)if(f=t[a],s=f.options.position||"left",f.delta={},e=f.getBoundingRect(),k=b(f.pane,i),u=k.canvas,p(e)){c="delta"+s.slice(0,1).toUpperCase()+s.slice(1);switch(s){case"right":l=1,u.deltaLeft+=f.padding?f.padding.left:0;break;case"left":l=-1,u.deltaRight+=f.padding?f.padding.right:0;break;case"top":l=-1,u.deltaBottom+=f.padding?f.padding.bottom:0;break;case"bottom":l=1,u.deltaTop+=f.padding?f.padding.top:0}switch(s){case"right":case"left":e.isEmpty||(o=e.y+e.height-(u.height-u.originalBottom),o>0&&(h.requireAxesRedraw=!0,u.deltaBottom+=o),o=u.originalTop-e.y,o>0&&(h.requireAxesRedraw=!0,u.deltaTop+=o)),v=e.width,y=["Left","Right"];break;case"top":case"bottom":e.isEmpty||(o=e.x+e.width-(u.width-u.originalRight),o>0&&(h.requireAxesRedraw=!0,u.deltaRight+=o),o=u.originalLeft-e.x,o>0&&(h.requireAxesRedraw=!0,u.deltaLeft+=o)),y=["Bottom","Top"],v=e.height}!f.delta[s]&&u[c]>0&&(u[c]+=f.getMultipleAxesSpacing()),f.delta[s]=f.delta[s]||0,f.delta[s]+=u[c]*l,u[c]+=v}h.requireAxesRedraw=w(i,y)||h.requireAxesRedraw,this.stopDrawAxes=ut(i,r)},d=function(n){var t=this.chart;this.applyAxesLayout(n,t.panes,t.option("rotated"))},g=function(n){var t=this.chart;n.reverse(),this.applyAxesLayout(n,t.panes,t.option("rotated")),n.reverse()},nt=function(t){function e(i,r){n.each(i,function(n,i){var u=i.getLayoutOptions(),f=u.cutLayoutSide;t[f]-=u[r]})}var r=this,u=r.horizontalElements,f=r.verticalElements;e(u,"width"),i(u,t),e(f,"height"),i(f,t)},tt=function(t,i){var f=this,r=0,u=0;return n.each(t,function(n,t){var e=t.canvas,o=f._options.width-(e.width-e.left-e.right),s=f._options.height-(e.height-e.top-e.bottom);i?(r+=o>0?o:0,u=Math.max(s>0?s:0,u)):(r=Math.max(o>0?o:0,r),u+=s>0?s:0)}),r>0||u>0?{width:r,height:u}:!1},it=function(t,i,r,u,e,o){function l(t,i){t&&s[i]>0&&(n.each(t,function(n,t){var r=t.getBoundingRect();t.updateSize(),s[i]-=r[i]-t.getBoundingRect()[i]}),s[i]>0&&n.each(t,function(n,t){t.updateSize(!0)}))}function a(t,i,f){n.each(t,function(n,t){var e=t.getLayoutOptions(),h=e.cutLayoutSide,c=u.width-u.left-u.right,l=u.height-u.top-u.bottom,o={};t.setSize({width:c,height:l}),o[f]=0,o[i]=s[i],t.changeSize(o),r[h]-=e[i]-t.getLayoutOptions()[i],s[i]-=e[i]-t.getLayoutOptions()[i]})}var c=this,s,h=n.extend({},u),v=o?t:i,y=o?i:t;(s=this.needMoreSpaceForPanesCanvas(e,o),s)&&(s.height=f(u,["top","bottom"],s.height),s.width=f(u,["left","right"],s.width),r.top-=h.top-u.top,r.bottom-=h.bottom-u.bottom,r.left-=h.left-u.left,r.right-=h.right-u.right,a(c.horizontalElements,"width","height"),a(c.verticalElements,"height","width"),l(v,"width"),l(y,"height"))},rt=function(n,t){n.setSize({width:t.width-t.right-t.left,height:t.width-t.right-t.left}),n.changeSize({width:0,height:0})},ut=function(t,i){var s,h,r,u=0,f=0,e=0,o=0,c=0;return n.each(t,function(n,t){u=Math.max(u,t.canvas.deltaLeft),f=Math.max(f,t.canvas.deltaRight),e=Math.max(e,t.canvas.deltaTop),o=Math.max(o,t.canvas.deltaBottom)}),i?n.each(t,function(n,t){t.canvas.top+=e,t.canvas.bottom+=o,t.canvas.right+=t.canvas.deltaRight,t.canvas.left+=t.canvas.deltaLeft}):n.each(t,function(n,t){t.canvas.top+=t.canvas.deltaTop,t.canvas.bottom+=t.canvas.deltaBottom,t.canvas.right+=f,t.canvas.left+=u}),n.each(t,function(n,t){t.canvas.top+t.canvas.bottom>t.canvas.height&&(r=!0),t.canvas.left+t.canvas.right>t.canvas.width&&(r=!0)}),r};return{ctor:h,update:c,drawElements:a,updatePanesCanvases:v,applyVerticalAxesLayout:d,applyHorizontalAxesLayout:g,applyAxesLayout:k,applyPieChartSeriesLayout:y,dispose:l,updateDrawnElements:it,placeDrawnElements:nt,needMoreSpaceForPanesCanvas:tt,correctSizeElement:rt}}())}(jQuery,DevExpress),function(n,t){var c=t.viz.core.Range,u=t.utils,f=u.adjustValue,l=u.applyPrecisionByMinDelta,o=u.isDefined,e=Math,s=e.floor,h=e.max,y=.1,p=function(t){var i={};return n.each(t,function(n,t){var r=t.pane;i[r]||(i[r]=[]),i[r].push(t)}),i},w=function(n){var t;n.translator._originalBusinessRange?(t=new c(n.translator._originalBusinessRange),n.translator.updateBusinessRange(t),n.setRange(t)):n.translator._originalBusinessRange=new c(n.translator.getBusinessRange())},b={transform:function(n,t){return u.getLog(n,t)},addInterval:function(n,t){return n+t},getInterval:function(n,t){return t},adjustValue:s},k={transform:function(n,t){return u.raiseTo(n,t)},addInterval:function(n,t){return n*t},getInterval:function(n,t){return e.pow(n,t)},adjustValue:f},a=function(n,t){if(n.isLogarithmic){var i=n.logarithmicBase,f=n.tickValues,r,u=[],o;for(n.minValue=t.transform(n.minValue,i),n.oldMinValue=t.transform(n.oldMinValue,i),n.maxValue=t.transform(n.maxValue,i),n.oldMaxValue=t.transform(n.oldMaxValue,i),n.tickInterval=e.round(n.tickInterval),n.tickInterval<1&&(n.tickInterval=1),o=t.getInterval(i,n.tickInterval),r=t.adjustValue(t.transform(f[0],i));u.length<f.length;r=t.addInterval(r,o))u.push(r);u.tickInterval=n.tickInterval,n.tickValues=u}},d=function(t){return n.map(t,function(n){w(n);var r=n.getTickValues(),f=n.options,e,o,t=null,i;return r&&r.length>0&&u.isNumber(r[0])&&f.type!=="discrete"&&(i=n.translator.getBusinessRange(),e=i.minVisible,o=i.maxVisible,t={axis:n,isLogarithmic:f.type==="logarithmic",logarithmicBase:i.base,tickValues:r,minValue:e,oldMinValue:e,maxValue:o,oldMaxValue:o,inverted:i.invert,tickInterval:r.tickInterval,synchronizedValue:f.synchronizedValue},i.stubData&&(t.stubData=!0,t.tickInterval=t.tickInterval||f.tickInterval,t.isLogarithmic=!1),a(t,b)),t})},g=function(t){var i=0;n.each(t,function(n,t){i=h(i,t.tickValues.length)}),n.each(t,function(n,t){var f,e,h=0,c=t.synchronizedValue,r=t.tickValues,u=t.tickInterval;if(o(c))t.baseTickValue=c,t.invertedBaseTickValue=c,t.tickValues=[t.baseTickValue];else{if(r.length>1&&u){for(f=s((i+1)/r.length),e=f>1?s((i+1)/f):i,h=s((e-r.length)/2);h>0&&r[0]!==0;)r.unshift(l(r[0],u,r[0]-u)),h--;while(r.length<e)r.push(l(r[0],u,r[r.length-1]+u));t.tickInterval=u/f}t.baseTickValue=r[0],t.invertedBaseTickValue=r[r.length-1]}})},r=function(n){return n.maxValue-n.minValue},v=function(n){for(var t=0;t<n.length;t++)if(!n[t].stubData)return n[t];return null},nt=function(t){var i=v(t);n.each(t,function(n,t){var e,u,f;t!==i&&(i.tickInterval&&t.tickInterval&&(t.stubData&&o(t.synchronizedValue)&&(t.oldMinValue=t.minValue=t.baseTickValue-(i.baseTickValue-i.minValue)/i.tickInterval*t.tickInterval,t.oldMaxValue=t.maxValue=t.baseTickValue-(i.baseTickValue-i.maxValue)/i.tickInterval*t.tickInterval),e=i.tickInterval/r(i)/t.tickInterval*r(t),t.maxValue=t.minValue+r(t)/e),f=i.inverted&&!t.inverted||!i.inverted&&t.inverted?i.maxValue-i.invertedBaseTickValue:i.baseTickValue-i.minValue,u=(f/r(i)-(t.baseTickValue-t.minValue)/r(t))*r(t),t.minValue-=u,t.maxValue-=u)})},tt=function(t){var i,u,f=0,e=0;return n.each(t,function(n,t){var o=t.inverted;i=t.minValue>t.oldMinValue?(t.minValue-t.oldMinValue)/r(t):0,u=t.maxValue<t.oldMaxValue?(t.oldMaxValue-t.maxValue)/r(t):0,f=h(f,o?u:i),e=h(e,o?i:u)}),{start:f,end:e}},it=function(t,i){n.each(t,function(n,t){var u=r(t),o=t.inverted;t.minValue-=i[o?"end":"start"]*u,t.maxValue+=i[o?"start":"end"]*u,u>y&&(t.minValue=e.min(t.minValue,f(t.minValue)),t.maxValue=h(t.maxValue,f(t.maxValue)))})},rt=function(t){var i=!1;n.each(t,function(n,t){i=i||o(t.synchronizedValue)}),n.each(t,function(n,t){var e,o=t.tickInterval,r=t.tickValues,h=t.maxValue,s=t.minValue;if(i&&o){while(r[0]-o>=s)r.unshift(f(r[0]-o));for(e=r[r.length-1];(e=e+o)<=h;)r.push(u.isExponential(e)?f(e):u.applyPrecisionByMinDelta(s,o,e))}while(r[0]<s)r.shift();while(r[r.length-1]>h)r.pop()})},ut=function(t){n.each(t,function(n,t){var r=t.axis,i=r.translator.getBusinessRange();i.min===i.minVisible&&(i.min=t.minValue),i.max===i.maxVisible&&(i.max=t.maxValue),i.minVisible=t.minValue,i.maxVisible=t.maxValue,o(t.stubData)&&(i.stubData=t.stubData),i.min>i.minVisible&&(i.min=i.minVisible),i.max<i.maxVisible&&(i.max=i.maxVisible),r.translator.updateBusinessRange(i),r.setRange(i),r.setTickValues(t.tickValues)})};t.viz.charts.multiAxesSynchronizer={synchronize:function(t){n.each(p(t),function(t,i){var r,u;if(i.length>1){if(r=d(i),r.length===0||!v(r))return;g(r),nt(r),u=tt(r),it(r,u),rt(r),n.each(r,function(){a(this,k)}),ut(r)}})}}}(jQuery,DevExpress),function(n,t){var y=t.viz.charts,u=t.viz.core.series.helpers.consts.events,e=t.utils,c=e.isFunction,o=e.isDefined,r="multiple",s="single",h="allargumentpoints",l="allseriespoints",i=window.navigator.msPointerEnabled&&window.navigator.msMaxTouchPoints||window.navigator.pointerEnabled&&window.navigator.maxTouchPoints||null,p=1e3,w=600,a=100,b=200,k=400,v="none",f=function(n){return(n+"").toLowerCase()};y.Tracker=t.Class.inherit({ctor:function(n){var t=this,i=n.events=n.events||{},f=function(n){return n&&n.call?function(){var t=this,i=arguments;setTimeout(function(){n.apply(t,i)})}:null};t._reinit(n),t.pointSelectionMode=t._prepareMode(n.pointSelectionMode),t.seriesSelectionMode=t._prepareMode(n.seriesSelectionMode),t.hoverStartDelay=0,t.sensitivity=7,t.pointSelectionMode===r?(t._releaseSelectedPoint=t._releaseSelectedPointMultiMode,t.selectedPoint=[]):t._releaseSelectedPoint=t._releaseSelectedPointSingleMode,t.seriesSelectionMode===r?(t._releaseSelectedSeries=t._releaseSelectedSeriesMultiMode,t.selectedSeries=[]):t._releaseSelectedSeries=t._releaseSelectedSeriesSingleMode,t.tooltipEnabled=n.tooltipEnabled,t.tooltipShown=n.tooltipShown,t.tooltipHidden=n.tooltipHidden,t.seriesClick=f(i.seriesClick),t.pointClick=f(i.pointClick),t.legendClick=f(i.legendClick),t.argumentAxisClick=f(i.argumentAxisClick),t.seriesHover=f(i.seriesHover),t.seriesSelected=f(i.seriesSelected),t.pointHover=f(i.pointHover),t.seriesSelectionChanged=f(i.seriesSelectionChanged),t.pointSelectionChanged=f(i.pointSelectionChanged),t.seriesHoverChanged=f(i.seriesHoverChanged),t.pointHoverChanged=f(i.pointHoverChanged),t.pointSelected=f(i.pointSelected),t.renderer=n.renderer,t.seriesTrackerGroup=n.seriesTrackerGroup,t.markerTrackerGroup=n.markerTrackerGroup,t.seriesGroup=n.seriesGroup;t.seriesGroup.on(u.selectSeries,{tracker:t},t._selectSeries);t.seriesGroup.on(u.deselectSeries,{tracker:t},t._deselectSeries);t.seriesGroup.on(u.selectPoint,{tracker:t},t._selectPoint);t.seriesGroup.on(u.deselectPoint,{tracker:t},t._deselectPoint);t.seriesGroup.on(u.showPointTooltip,{tracker:t},t._showPointTooltip);t.seriesGroup.on(u.hidePointTooltip,{tracker:t},t._hidePointTooltip);t.crossHairOptions=n.crossHairOptions},_clean:function(){var n=this;n.selectedPoint=n.pointSelectionMode===r?[]:null,n.selectedSeries=n.seriesSelectionMode===r?[]:null,n.hoveredPoint=null,n.hoveredSeries=null,n._hideTooltip(n.pointAtShownTooltip),n._clearTimeouts()},_reinit:function(t){var i=this;t=t||{},i.storedSeries!==t.series?(i.storedSeries=t.series||[],i._clean()):o(i.storedSeries)&&(i._clearPointSelection(),i._clearHover(i),i._clearTimeouts()),i.argumentAxis=t.argumentAxis||[],i.legendGroup=t.legendGroup,i.legendCallback=t.legendCallback||n.noop},_clearTimeouts:function(){var n=this,t=clearTimeout;t(n.tooltipHoldTimeout),t(n.cmpCoordTimeout),t(n.hoverStartTimeOut),t(n.hoverHoldTimeOut)},dispose:function(){var t=this;t._clearTimeouts(),clearTimeout(t.unlockMouseTimer),clearTimeout(t.lockClickTimer),n.each(t.argumentAxis,function(n,t){t._axisElementsGroup&&t._axisElementsGroup.off()}),t.seriesTrackerGroup.off(),t.markerTrackerGroup.off(),t.legendGroup&&t.legendGroup.off(),t.seriesGroup.off(),t.rootTracker&&t.rootTracker.off(),t.argumentAxis=null,t.seriesTrackerGroup=null,t.markerTrackerGroup=null,t.legendGroup=null,t.legendCallback=null,t.seriesGroup=null,t.crossHairOptions=null,t.selectedPoint=null,t.selectedSeries=null,t.hoveredSeries=null,t.hoveredPoint=null,t.storedSeries=null,t.argumentAxis=null,t.hoveredObject=null,t.pointAtShownTooltip=null},_prepareMode:function(n){return n=(n||"").toLowerCase(),n=n!==s&&n!==r?s:n},_prepare:function(t){var i=this;i.rootTracker=i.renderer.getRoot(),n.each(i.argumentAxis,function(n,t){t._axisElementsGroup&&i._eventHandler(t._axisElementsGroup,{parser:i._getOptionsAxis,condition:i._axisCondition,execute:i._axisEvent},{tracker:i,axis:t})}),i._eventHandler(i.seriesTrackerGroup,{parser:i._getOptionsPointSeries,condition:i._seriesCondition,execute:i._seriesEvent},{tracker:i}),i._eventHandler(i.markerTrackerGroup,{parser:i._getOptionsPointSeries,condition:i._pointCondition,execute:i._pointEvent},{tracker:i}),i.legendGroup&&i._eventHandler(i.legendGroup,{parser:i._getLegendData(t),condition:i._seriesCondition,execute:i._getLegendEvent(t)},{tracker:i}),i._eventHandler(i.rootTracker,{parser:i._getOptionsCrossHair,execute:i._crossHairEvent},{tracker:i})},_getLegendData:function(t){return function(i){var f=n(i.target),u=f.data("itemIndex"),r=i.data.tracker,o=e.isNumber(u)&&f.data("mode");return i.type==="mousemove"?[r,i.pageX,i.pageY,i.offsetX,i.offsetY]:e.isNumber(u)?t==="pieChart"?[r,r.storedSeries[0].getPoints()[u],o,i]:[r,r.storedSeries[u],o,i]:null}},_getLegendEvent:function(t){var r=this,i;return i=t==="pieChart"?n.extend({},this._pointEvent,{touchend:function(n,t,i,r){n.showHoldTooltip||n._legendClick(n,t,!0,r)||n._pointClick(n,t,!0,r),clearTimeout(n.tooltipHoldTimeout),n._clickLock(n),n._clearHover(n)},click:function(n,t,i,r){n._legendClick(n,t,!1,r)||n._pointClick(n,t,!1,r)}}):n.extend({},this._seriesEvent,{click:function(n,t,i,r){n._legendClick(n,t,!1,r)||n._seriesClick(n,t,!1,r)},touchend:function(n,t,i,r){n._legendClick(n,t,!0,r)||n._seriesClick(n,t,!0,r),n._clickLock(n)}})},_eventHandler:function(n,t,i){var r=this._designerHandlers(t);n.off(".dxc-tracker");n.on(r,i)},_designerHandlers:function(t){var r={},u=t.parser,i=t.condition,f=t.execute,e=function(n,t){i&&i[n]===null||(r[n+".dxc-tracker"]=function(r){var f=u?u(r):r;f&&(i&&i[n]&&i[n].call?i[n].apply(null,f.concat([t])):t.apply(null,f))})};return n.each(f,e),r},_getOptionsCrossHair:function(n){var t=n.data.tracker,i=e.getRootOffset(t.renderer),r=n.pageX-i.left,u=n.pageY-i.top;return[t,r,u]},_getOptionsPointSeries:function(t){var i=n(t.target).data("point")||n(t.target).data("series"),r=t.data.tracker,u=i&&f(n(t.target).data("mode")||i.getOptions().hoverMode);return t.type==="mousemove"?[r,t.pageX,t.pageY,t.offsetX,t.offsetY]:i?[r,i,u,t]:null},_getOptionsAxis:function(t){var u=t.data.tracker,i=t.data.axis,f=i.options.hoverMode,r;return(r=t.target.tagName==="tspan"?n(t.target).parent().data("argument"):n(t.target).data("argument"),t.type==="mousemove")?[u,t.pageX,t.pageY]:i?[u,i,f,r,t]:null},_pointEvent:{mouseover:function(n,t,i){n.mouseLocked||(n._setHoveredPoint(t,i),n.tooltipEnabled&&t&&t.getOptions()&&n._compareCoords(n,function(){n._showTooltip(n.tooltip,t)}))},mouseout:function(n){n.mouseLocked||n._clearHover(n)},touchmove:function(n){clearTimeout(n.tooltipHoldTimeout),n.tooltipHoldTimeout=null,n.showHoldTooltip=!0},mousemove:function(n,t,i){n._setCurCoords(n,t,i)},touchstart:function(n,t){n.showHoldTooltip=!1,n._mouseLock(n),n.tooltipEnabled&&(n.tooltipHoldTimeout=setTimeout(function(){n.showHoldTooltip=!0,n._showTooltip(n.tooltip,t)},k))},touchend:function(n,t,i,r){n.showHoldTooltip||n._pointClick(n,t,!0,r),clearTimeout(n.tooltipHoldTimeout),n._clickLock(n),n._clearHover(n)},click:function(n,t,i,r){n._pointClick(n,t,!1,r)},mousedown:function(n,t,i){n._pointEvent.touchstart(n,t,i)},mouseup:function(n,t,i,r){n._pointEvent.touchend(n,t,i,r)}},_pointCondition:{mouseover:function(n,t,i,r,u){if(i===h&&n.hoveredPoint&&n.hoveredPoint.argument===t.argument){n.hoverHoldTimeOut=clearTimeout(n.hoverHoldTimeOut),n.hoveredObject=t,u(n,t,i);return}n._setHover(n,t,i,u)},mouseout:function(n,t,i,r,u){n._releaseHover(n,t,i,u)},touchstart:!i,touchend:!i,mousedown:i,mouseup:i},_seriesEvent:{mouseover:function(n,t,i){n.mouseLocked||n._setHoveredSeries(t,i)},mouseout:function(n){n._clearHover(n)},mousemove:function(n,t,i){n._setCurCoords(n,t,i)},touchstart:function(n){n._mouseLock(n)},touchend:function(n,t,i,r){n._seriesClick(n,t,!0,r),n._clickLock(n)},click:function(n,t,i,r){n._seriesClick(n,t,!1,r)},mousedown:function(n,t,i){n._seriesEvent.touchstart(n,t,i)},mouseup:function(n,t,i){n._seriesEvent.touchend(n,t,i)}},_crossHairEvent:{mousemove:function(n,t,i){if(n.eventType){if(n.eventType==="touch")return;n.eventType==="mouse"&&(n._moveCrossHair(n,t,i),n.eventType=null)}else{n.eventType="mouse";return}},mouseout:function(n){n._hideCrossHair(n),n.eventType=null},touchstart:function(n){n.eventType="touch"},touchend:function(n){n.eventType=null},mousedown:function(n,t,i){n._crossHairEvent.touchstart(n,t,i)},mouseup:function(n,t,i){n._crossHairEvent.touchend(n,t,i)}},_hideCrossHair:function(n){if(n.crossHairOptions){var t=n.crossHairOptions.horizontalLine,i=n.crossHairOptions.verticalLine;t&&t.applySettings({visibility:"hidden"}),i&&i.applySettings({visibility:"hidden"})}},_moveCrossHair:function(n,t,i){if(n.crossHairOptions){var u=n.crossHairOptions.horizontalLine,f=n.crossHairOptions.verticalLine,r=n.crossHairOptions.canvas||{};t>r.left&&t<r.width-r.right&&i>r.top&&i<r.height-r.bottom?(u&&u.applySettings({visibility:"visible"}),f&&f.applySettings({visibility:"visible"}),u&&u.applySettings({translateY:i-r.top}),f&&f.applySettings({translateX:t-r.left})):(u&&u.applySettings({visibility:"hidden"}),f&&f.applySettings({visibility:"hidden"}))}},_seriesCondition:{mouseover:function(n,t,i,r,u){n.hoverStartDelay=0,n._setHover(n,t,i,u)},mouseout:function(n,t,i,r,u){n.hoverStartDelay=a,n._releaseHover(n,t,i,u)},touchstart:!i,touchend:!i,mousedown:i,mouseup:i},_axisEvent:{mouseover:function(n,t,i){n.mouseLocked||o(n.hoveredArgument)&&n.hoveredArgument===i||(n._clearHover(n),o(n.hoveredArgument)&&n._toAllArgumentPoints(n.hoveredArgument,"releasePointHoverState"),n._toAllArgumentPoints(i,"setPointHoverState"),n.hoveredArgument=i)},mouseout:function(n){!n.mouseLocked&&o(n.hoveredArgument)&&(n._toAllArgumentPoints(n.hoveredArgument,"releasePointHoverState"),n.hoveredArgument=null)},mousemove:function(n,t,i){n._setCurCoords(n,t,i)},touchstart:function(n){n._mouseLock(n)},touchend:function(n,t,i,r,u){n._argumentAxisClick(n,t,r,!0,u),n._clearHover(n),n._clickLock(n)},click:function(n,t,i,r,u){n._clearHover(n),n._argumentAxisClick(n,t,r,!1,u)},mousedown:function(n){n._axisEvent.touchstart(n)},mouseup:function(n,t,i,r,u){n._axisEvent.touchend(n,t,i,r,u)}},_axisCondition:{mouseover:function(n,t,i,r,u,f){n._hideCrossHair(n),i===h&&n._setHover(n,t,r,f)},mouseout:function(n,t,i,r,u,f){n._releaseHover(n,t,r,f)},touchstart:!i,touchend:!i,mousedown:i,mouseup:i},_setHover:function(n,t,i,r){(t!==n.hoveredObject||(n.hoverHoldTimeOut=clearTimeout(n.hoverHoldTimeOut),i!==t.lastHoverMode))&&(n.mouseLocked||(clearTimeout(n.cmpCoordTimeout),clearTimeout(n.hoverStartTimeOut),n.hoverStartTimeOut=setTimeout(function(){clearTimeout(n.hoverHoldTimeOut),n.hoveredObject=t,r(n,t,i)},n.hoverStartDelay)))},_releaseHover:function(n,t,i,r){n.mouseLocked||(clearTimeout(n.cmpCoordTimeout),clearTimeout(n.hoverStartTimeOut),t===n.hoveredObject&&(n.hoverHoldTimeOut=setTimeout(function(){n.hoveredObject=null,r(n,t,i),n.hoverStartDelay=0},b)))},_compareCoords:function(n,t){if(clearTimeout(n.cmpCoordTimeout),Math.abs(n.pX-n.cX)+Math.abs(n.pY-n.cY)<n.sensitivity){if(n.mouseLocked)return;t()}else n.pX=n.cX,n.pY=n.cY,n.cmpCoordTimeout=setTimeout(function(){n._compareCoords(n,t)},n.hoverStartDelay===0?a:0)},_seriesClick:function(n,t,i,r){(!n.lockClick||i)&&n.seriesClick&&n.seriesClick.call(t,t,r)},_legendClick:function(n,t,i,r){var u=n.legendClick;return n.lockClick&&!i?!0:u?(u.call(t,t,r),!0):!1},_pointClick:function(n,t,i,r){var u=t.series;if(!n.lockClick||i){if(n.pointClick){n.pointClick.call(t,t,r);return}n.seriesClick&&n.seriesClick.call(u,u,r);return}},_argumentAxisClick:function(n,t,i,r,u){(!n.lockClick||r)&&n.argumentAxisClick&&n.argumentAxisClick.call(t,t,i,u)},_selectSeries:function(n,t){n.data.tracker._setSelectedSeries(n.target,t)},_deselectSeries:function(n,t){n.data.tracker._releaseSelectedSeries(n.target,t)},_selectPoint:function(n,t){n.data.tracker._setSelectedPoint(t)},_deselectPoint:function(n,t){n.data.tracker._releaseSelectedPoint(t)},_showPointTooltip:function(n,t){var i=n.data.tracker;i._showTooltip(i.tooltip,t)},_hidePointTooltip:function(n,t){n.data.tracker._hideTooltip(t)},_hideTooltip:function(n){var t=this&&this.tooltip;t&&(!n||this.pointAtShownTooltip===n)&&(n=n||this.pointAtShownTooltip,t.hide(),this.pointAtShownTooltip&&(this.pointAtShownTooltip=null,c(this.tooltipHidden)&&this.tooltipHidden.call(n,n)))},_showTooltip:function(n,t){var r=t.getTooltipFormatObject(n),i;if((o(r.valueText)||r.points)&&t.isVisible()&&(this.pointAtShownTooltip&&this._hideTooltip(this.pointAtShownTooltip),t&&t.getOptions())){if(i=t.getTooltipCoords(),!n.prepare(r,{x:i.x,y:i.y,offset:i.offset}))return;n.show(),!this.pointAtShownTooltip&&c(this.tooltipShown)&&this.tooltipShown.call(t,t),this.pointAtShownTooltip=t}},_setHoveredSeries:function(n,t){var i=this;(t!==v&&i.hoveredSeries!==n||n.lastHoverMode!==t)&&(i._clearHover(i),i.hoveredSeries=n,n.setHoverState(t,i.legendCallback(n)),i.seriesHover&&i.seriesHover.call(n,n),i.seriesHoverChanged&&i.seriesHoverChanged.call(n,n))},_setSelectedSeries:function(t,i){var u=this,f=!1;this.seriesSelectionMode===r?n.each(u.selectedSeries,function(n,i){if(i==t)return f=!0,!1}):u.selectedSeries==t&&(f=!0),f&&t.lastSelectionMode===i||(u.seriesSelectionMode===s?(this._releaseSelectedSeries(),u.selectedSeries=t):u.selectedSeries.push(t),t.setSelectedState(i,u.legendCallback(t)),u.seriesSelected&&u.seriesSelected.call(t,t),u.seriesSelectionChanged&&u.seriesSelectionChanged.call(t,t))},_setHoveredPoint:function(n,t){var i=this;(i.hoveredPoint!==n||n.series)&&(i._clearHover(i),i.hoveredPoint=n,n&&n.getOptions()&&i._setHoverStylePointWithMode(n,"setPointHoverState",t||f(n.getOptions().hoverMode),i.pointHoverChanged,i.legendCallback(n)),i.pointHover&&i.pointHover.call(n,n))},_toAllArgumentPoints:function(t,i,r){var u=this;n.each(u.storedSeries,function(n,u){var f=u.getPointByArg(t);f&&(u[i](f),r&&r.call(f,f))})},_setHoverStylePointWithMode:function(t,i,r,u,f){var e=this;switch(r){case h:this._toAllArgumentPoints(t.argument,i,u);break;case l:n.each(t.series.getPoints(),function(n,t){t.series[i](t),u&&u.call(t,t)});break;case v:break;default:t.series[i](t,f),u&&u.call(t,t)}},_setSelectedPoint:function(t){var i=this,u=!1;this.pointSelectionMode===r?(n.each(i.selectedPoint,function(n,i){if(i==t)return u=!0,!1}),u||i.selectedPoint.push(t)):i.selectedPoint!==t?(this._releaseSelectedPoint(),i.selectedPoint=t):u=!0,u||(i._setHoverStylePointWithMode(t,"setPointSelectedState",f(t.getOptions().selectionMode),i.pointSelectionChanged,i.legendCallback(t)),i.pointSelected&&i.pointSelected.call(t,t))},_releaseHoveredSeries:function(){var n=this;n.hoveredSeries&&(n.hoveredSeries.releaseHoverState(undefined,n.legendCallback(n.hoveredSeries)),n.seriesHoverChanged&&n.seriesHoverChanged.call(n.hoveredSeries,n.hoveredSeries),n.hoveredSeries=null)},_releaseSelectedSeriesMultiMode:function(t){var i=this;i.selectedSeries&&(t.releaseSelectedState(undefined,i.legendCallback(t)),i.seriesSelectionChanged&&i.seriesSelectionChanged.call(t,t),i.selectedSeries=n.map(i.selectedSeries,function(n){if(n!==t)return n}))},_releaseSelectedSeriesSingleMode:function(){var t=this,n=this.selectedSeries;n&&(n.releaseSelectedState(undefined,t.legendCallback(n)),t.seriesSelectionChanged&&t.seriesSelectionChanged.call(n,n),t.selectedSeries=null)},_releaseHoveredPoint:function(){var t=this,i=t.hoveredPoint,r;i&&i.getOptions()&&(r=f(i.getOptions().hoverMode),r===l?n.each(i.series.getPoints(),function(n,i){i.series.releasePointHoverState(i),t.pointHoverChanged&&t.pointHoverChanged.call(i,i)}):r===h?t._toAllArgumentPoints(i.argument,"releasePointHoverState",t.pointHoverChanged):(i.releaseHoverState(t.legendCallback(i)),t.pointHoverChanged&&t.pointHoverChanged.call(i,i)),t.tooltipEnabled&&!t.showHoldTooltip&&t._hideTooltip(i),t.hoveredPoint=null)},_releaseSelectedPointMultiMode:function(t){var i=this,r=i.selectedPoint;r&&(i._setHoverStylePointWithMode(t,"releasePointSelectedState",f(t.getOptions().selectionMode),i.pointSelectionChanged,i.legendCallback(t)),this.selectedPoint=n.map(this.selectedPoint,function(n){if(n!==t)return n}))},_releaseSelectedPointSingleMode:function(){var n=this,t=n.selectedPoint;t&&(n._setHoverStylePointWithMode(t,"releasePointSelectedState",f(t.getOptions().selectionMode),n.pointSelectionChanged,n.legendCallback(t)),this.selectedPoint=null)},_clearPointSelection:function(){var t=this;t.pointSelectionMode===s?t._releaseSelectedPoint():n.each(t.selectedPoint||[],function(n,i){t._releaseSelectedPoint(i)})},clearSelection:function(){var t=this;t._clearPointSelection(),t.seriesSelectionMode===s?t._releaseSelectedSeries():n.each(t.selectedSeries,function(n,i){t._releaseSelectedSeries(i)})},setTooltip:function(n){this.tooltip=n},_mouseLock:function(n){n.unlockMouseTimer&&clearTimeout(n.unlockMouseTimer),n.mouseLocked=!0,n.unlockMouseTimer=setTimeout(function(){n.mouseLocked=!1},p)},_clickLock:function(n){n.lockClick=!0,n.lockClickTimer&&clearTimeout(n.lockClickTimer),n.lockClickTimer=setTimeout(function(){n.lockClick=!1},w)},_setCurCoords:function(n,t,i){n.cX=t,n.cY=i},_clearHover:function(n){n._releaseHoveredSeries(),n._releaseHoveredPoint()}})}(jQuery,DevExpress),function(n,t){var u=t.ui,r=t.viz;t.registerComponent("dxChart",r.charts.Chart)}(jQuery,DevExpress),function(n,t){var u=t.ui,r=t.viz;t.registerComponent("dxPieChart",r.charts.PieChart)}(jQuery,DevExpress),DevExpress.MOD_VIZ_CHARTS=!0}