import Handsontable from 'handsontable';

const domElement = new HTMLElement();
const domEvent = new Event('foo');

const htmlCharacters = Handsontable.dom.HTML_CHARACTERS;

Handsontable.dom.addEvent(domElement, 'foo', () => {});
Handsontable.dom.addClass(domElement, ['foo', 'bar']);
Handsontable.dom.clearTextSelection();
Handsontable.dom.clearTextSelection(window);
Handsontable.dom.closest(domElement, ['foo']);
Handsontable.dom.closest(domElement, ['foo'], domElement);
Handsontable.dom.closestDown(domElement, ['foo', 'bar']);
Handsontable.dom.closestDown(domElement, ['foo', 'bar'], domElement);
Handsontable.dom.empty(domElement);
Handsontable.dom.fastInnerHTML(domElement, 'foo');
Handsontable.dom.fastInnerText(domElement, 'foo');
Handsontable.dom.getCaretPosition(domElement);
Handsontable.dom.getComputedStyle(domElement);
Handsontable.dom.getComputedStyle(domElement, window);
Handsontable.dom.getCssTransform(domElement);
Handsontable.dom.getParent(domElement, 1);
Handsontable.dom.getScrollLeft(domElement);
Handsontable.dom.getScrollLeft(domElement, window);
Handsontable.dom.getScrollTop(domElement);
Handsontable.dom.getScrollTop(domElement, window);
Handsontable.dom.getScrollableElement(domElement);
Handsontable.dom.getScrollbarWidth();
Handsontable.dom.getScrollbarWidth(document);
Handsontable.dom.getSelectionEndPosition(domElement);
Handsontable.dom.getSelectionText();
Handsontable.dom.getSelectionText(window);
Handsontable.dom.getStyle(domElement, 'foo');
Handsontable.dom.getStyle(domElement, 'foo', window);
Handsontable.dom.getTrimmingContainer(domElement);
Handsontable.dom.getWindowScrollLeft();
Handsontable.dom.getWindowScrollLeft(window);
Handsontable.dom.getWindowScrollTop();
Handsontable.dom.getWindowScrollTop(window);
Handsontable.dom.hasClass(domElement, 'foo');
Handsontable.dom.hasHorizontalScrollbar(domElement);
Handsontable.dom.hasVerticalScrollbar(domElement);
Handsontable.dom.index(domElement);
Handsontable.dom.innerHeight(domElement);
Handsontable.dom.innerWidth(domElement);
Handsontable.dom.isChildOf(domElement, 'foo');
Handsontable.dom.isChildOfWebComponentTable(domElement);
Handsontable.dom.isImmediatePropagationStopped(domEvent);
Handsontable.dom.isInput(domElement);
Handsontable.dom.isLeftClick(domEvent);
Handsontable.dom.isOutsideInput(domElement);
Handsontable.dom.isRightClick(domEvent);
Handsontable.dom.isVisible(domElement);
Handsontable.dom.offset(domElement);
Handsontable.dom.outerHeight(domElement);
Handsontable.dom.outerWidth(domElement);
Handsontable.dom.overlayContainsElement('top', domElement, domElement);
Handsontable.dom.pageX(domEvent);
Handsontable.dom.pageY(domEvent);
Handsontable.dom.polymerUnwrap(domElement);
Handsontable.dom.polymerWrap(domElement);
Handsontable.dom.removeClass(domElement, ['foo', 'bar']);
Handsontable.dom.removeEvent(domElement, 'foo', () => {});
Handsontable.dom.removeTextNodes(domElement, domElement);
Handsontable.dom.resetCssTransform(domElement);
Handsontable.dom.setCaretPosition(domElement, 0, 0);
Handsontable.dom.setOverlayPosition(domElement, 0, 0);
Handsontable.dom.stopImmediatePropagation(domEvent);
Handsontable.dom.stopPropagation(domEvent);
