# This is a generated file. Changes made here will be overwritten.

from cqlpy._internal.context.fhir.fhir_cql_type import (
    FhirCqlType,
    FhirList,
    FhirInterval,
    FhirChoice,
)

FHIR_TO_CQL_MAP: dict[str, dict[str, FhirCqlType]] = {
    "Account": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "status": FhirCqlType(name="String", is_backbone_element=False),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "name": FhirCqlType(name="String", is_backbone_element=False),
        "subject": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "servicePeriod": FhirInterval(
            name="Interval",
            is_backbone_element=False,
            item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
        ),
        "coverage": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Account_Coverage", is_backbone_element=True),
        ),
        "owner": FhirCqlType(name="Reference", is_backbone_element=True),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "guarantor": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Account_Guarantor", is_backbone_element=True),
        ),
        "partOf": FhirCqlType(name="Reference", is_backbone_element=True),
    },
    "ActivityDefinition": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "url": FhirCqlType(name="String", is_backbone_element=False),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "version": FhirCqlType(name="String", is_backbone_element=False),
        "name": FhirCqlType(name="String", is_backbone_element=False),
        "title": FhirCqlType(name="String", is_backbone_element=False),
        "subtitle": FhirCqlType(name="String", is_backbone_element=False),
        "status": FhirCqlType(name="String", is_backbone_element=False),
        "experimental": FhirCqlType(name="Boolean", is_backbone_element=False),
        "subject": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Concept", is_backbone_element=False),
                FhirCqlType(name="Reference", is_backbone_element=True),
            ],
        ),
        "date": FhirCqlType(name="DateTime", is_backbone_element=False),
        "publisher": FhirCqlType(name="String", is_backbone_element=False),
        "contact": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactDetail", is_backbone_element=True),
        ),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "useContext": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="UsageContext", is_backbone_element=True),
        ),
        "jurisdiction": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "purpose": FhirCqlType(name="String", is_backbone_element=False),
        "usage": FhirCqlType(name="String", is_backbone_element=False),
        "copyright": FhirCqlType(name="String", is_backbone_element=False),
        "approvalDate": FhirCqlType(name="Date", is_backbone_element=False),
        "lastReviewDate": FhirCqlType(name="Date", is_backbone_element=False),
        "effectivePeriod": FhirInterval(
            name="Interval",
            is_backbone_element=False,
            item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
        ),
        "topic": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "author": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactDetail", is_backbone_element=True),
        ),
        "editor": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactDetail", is_backbone_element=True),
        ),
        "reviewer": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactDetail", is_backbone_element=True),
        ),
        "endorser": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactDetail", is_backbone_element=True),
        ),
        "relatedArtifact": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="RelatedArtifact", is_backbone_element=True),
        ),
        "library": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "kind": FhirCqlType(name="Code", is_backbone_element=False),
        "profile": FhirCqlType(name="String", is_backbone_element=False),
        "code": FhirCqlType(name="Concept", is_backbone_element=False),
        "intent": FhirCqlType(name="Code", is_backbone_element=False),
        "priority": FhirCqlType(name="Code", is_backbone_element=False),
        "doNotPerform": FhirCqlType(name="Boolean", is_backbone_element=False),
        "timing": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="Decimal", is_backbone_element=False),
                ),
                FhirCqlType(name="Duration", is_backbone_element=True),
                FhirCqlType(name="Age", is_backbone_element=True),
                FhirCqlType(name="Timing", is_backbone_element=True),
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
                ),
                FhirCqlType(name="DateTime", is_backbone_element=False),
            ],
        ),
        "location": FhirCqlType(name="Reference", is_backbone_element=True),
        "participant": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ActivityDefinition_Participant", is_backbone_element=True
            ),
        ),
        "product": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Concept", is_backbone_element=False),
                FhirCqlType(name="Reference", is_backbone_element=True),
            ],
        ),
        "quantity": FhirCqlType(name="Decimal", is_backbone_element=False),
        "dosage": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Dosage", is_backbone_element=True),
        ),
        "bodySite": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "specimenRequirement": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "observationRequirement": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "observationResultRequirement": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "transform": FhirCqlType(name="String", is_backbone_element=False),
        "dynamicValue": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ActivityDefinition_DynamicValue", is_backbone_element=True
            ),
        ),
    },
    "AdverseEvent": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirCqlType(name="Identifier", is_backbone_element=True),
        "actuality": FhirCqlType(name="String", is_backbone_element=False),
        "category": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "event": FhirCqlType(name="Concept", is_backbone_element=False),
        "subject": FhirCqlType(name="Reference", is_backbone_element=True),
        "encounter": FhirCqlType(name="Reference", is_backbone_element=True),
        "date": FhirCqlType(name="DateTime", is_backbone_element=False),
        "detected": FhirCqlType(name="DateTime", is_backbone_element=False),
        "recordedDate": FhirCqlType(name="DateTime", is_backbone_element=False),
        "resultingCondition": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "location": FhirCqlType(name="Reference", is_backbone_element=True),
        "seriousness": FhirCqlType(name="Concept", is_backbone_element=False),
        "severity": FhirCqlType(name="Concept", is_backbone_element=False),
        "outcome": FhirCqlType(name="Concept", is_backbone_element=False),
        "recorder": FhirCqlType(name="Reference", is_backbone_element=True),
        "contributor": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "suspectEntity": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="AdverseEvent_SuspectEntity", is_backbone_element=True
            ),
        ),
        "subjectMedicalHistory": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "referenceDocument": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "study": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
    },
    "AllergyIntolerance": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "clinicalStatus": FhirCqlType(name="Concept", is_backbone_element=False),
        "verificationStatus": FhirCqlType(name="Concept", is_backbone_element=False),
        "type": FhirCqlType(name="String", is_backbone_element=False),
        "category": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "criticality": FhirCqlType(name="String", is_backbone_element=False),
        "code": FhirCqlType(name="Concept", is_backbone_element=False),
        "patient": FhirCqlType(name="Reference", is_backbone_element=True),
        "encounter": FhirCqlType(name="Reference", is_backbone_element=True),
        "onset": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="Decimal", is_backbone_element=False),
                ),
                FhirCqlType(name="String", is_backbone_element=False),
                FhirCqlType(name="Age", is_backbone_element=True),
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
                ),
                FhirCqlType(name="DateTime", is_backbone_element=False),
            ],
        ),
        "recordedDate": FhirCqlType(name="DateTime", is_backbone_element=False),
        "recorder": FhirCqlType(name="Reference", is_backbone_element=True),
        "asserter": FhirCqlType(name="Reference", is_backbone_element=True),
        "lastOccurrence": FhirCqlType(name="DateTime", is_backbone_element=False),
        "note": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Annotation", is_backbone_element=True),
        ),
        "reaction": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="AllergyIntolerance_Reaction", is_backbone_element=True
            ),
        ),
    },
    "Appointment": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "status": FhirCqlType(name="String", is_backbone_element=False),
        "cancelationReason": FhirCqlType(name="Concept", is_backbone_element=False),
        "serviceCategory": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "serviceType": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "specialty": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "appointmentType": FhirCqlType(name="Concept", is_backbone_element=False),
        "reasonCode": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "reasonReference": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "priority": FhirCqlType(name="String", is_backbone_element=False),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "supportingInformation": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "start": FhirCqlType(name="String", is_backbone_element=False),
        "end": FhirCqlType(name="String", is_backbone_element=False),
        "minutesDuration": FhirCqlType(name="String", is_backbone_element=False),
        "slot": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "created": FhirCqlType(name="DateTime", is_backbone_element=False),
        "comment": FhirCqlType(name="String", is_backbone_element=False),
        "patientInstruction": FhirCqlType(name="String", is_backbone_element=False),
        "basedOn": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "participant": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="Appointment_Participant", is_backbone_element=True
            ),
        ),
        "requestedPeriod": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirInterval(
                name="Interval",
                is_backbone_element=False,
                item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
            ),
        ),
    },
    "AppointmentResponse": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "appointment": FhirCqlType(name="Reference", is_backbone_element=True),
        "start": FhirCqlType(name="String", is_backbone_element=False),
        "end": FhirCqlType(name="String", is_backbone_element=False),
        "participantType": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "actor": FhirCqlType(name="Reference", is_backbone_element=True),
        "participantStatus": FhirCqlType(name="Code", is_backbone_element=False),
        "comment": FhirCqlType(name="String", is_backbone_element=False),
    },
    "AuditEvent": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "type": FhirCqlType(name="Code", is_backbone_element=False),
        "subtype": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Code", is_backbone_element=False),
        ),
        "action": FhirCqlType(name="String", is_backbone_element=False),
        "period": FhirInterval(
            name="Interval",
            is_backbone_element=False,
            item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
        ),
        "recorded": FhirCqlType(name="String", is_backbone_element=False),
        "outcome": FhirCqlType(name="String", is_backbone_element=False),
        "outcomeDesc": FhirCqlType(name="String", is_backbone_element=False),
        "purposeOfEvent": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "agent": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="AuditEvent_Agent", is_backbone_element=True),
        ),
        "source": FhirCqlType(name="AuditEvent_Source", is_backbone_element=True),
        "entity": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="AuditEvent_Entity", is_backbone_element=True),
        ),
    },
    "Basic": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "code": FhirCqlType(name="Concept", is_backbone_element=False),
        "subject": FhirCqlType(name="Reference", is_backbone_element=True),
        "created": FhirCqlType(name="Date", is_backbone_element=False),
        "author": FhirCqlType(name="Reference", is_backbone_element=True),
    },
    "Binary": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "contentType": FhirCqlType(name="Code", is_backbone_element=False),
        "securityContext": FhirCqlType(name="Reference", is_backbone_element=True),
        "data": FhirCqlType(name="String", is_backbone_element=False),
    },
    "BiologicallyDerivedProduct": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "productCategory": FhirCqlType(name="String", is_backbone_element=False),
        "productCode": FhirCqlType(name="Concept", is_backbone_element=False),
        "status": FhirCqlType(name="String", is_backbone_element=False),
        "request": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "quantity": FhirCqlType(name="Integer", is_backbone_element=False),
        "parent": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "collection": FhirCqlType(
            name="BiologicallyDerivedProduct_Collection", is_backbone_element=True
        ),
        "processing": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="BiologicallyDerivedProduct_Processing", is_backbone_element=True
            ),
        ),
        "manipulation": FhirCqlType(
            name="BiologicallyDerivedProduct_Manipulation", is_backbone_element=True
        ),
        "storage": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="BiologicallyDerivedProduct_Storage", is_backbone_element=True
            ),
        ),
    },
    "BodyStructure": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "active": FhirCqlType(name="Boolean", is_backbone_element=False),
        "morphology": FhirCqlType(name="Concept", is_backbone_element=False),
        "location": FhirCqlType(name="Concept", is_backbone_element=False),
        "locationQualifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "image": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Attachment", is_backbone_element=True),
        ),
        "patient": FhirCqlType(name="Reference", is_backbone_element=True),
    },
    "Bundle": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "identifier": FhirCqlType(name="Identifier", is_backbone_element=True),
        "type": FhirCqlType(name="String", is_backbone_element=False),
        "timestamp": FhirCqlType(name="String", is_backbone_element=False),
        "total": FhirCqlType(name="String", is_backbone_element=False),
        "link": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Bundle_Link", is_backbone_element=True),
        ),
        "entry": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Bundle_Entry", is_backbone_element=True),
        ),
        "signature": FhirCqlType(name="Signature", is_backbone_element=True),
    },
    "CapabilityStatement": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "url": FhirCqlType(name="String", is_backbone_element=False),
        "version": FhirCqlType(name="String", is_backbone_element=False),
        "name": FhirCqlType(name="String", is_backbone_element=False),
        "title": FhirCqlType(name="String", is_backbone_element=False),
        "status": FhirCqlType(name="String", is_backbone_element=False),
        "experimental": FhirCqlType(name="Boolean", is_backbone_element=False),
        "date": FhirCqlType(name="DateTime", is_backbone_element=False),
        "publisher": FhirCqlType(name="String", is_backbone_element=False),
        "contact": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactDetail", is_backbone_element=True),
        ),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "useContext": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="UsageContext", is_backbone_element=True),
        ),
        "jurisdiction": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "purpose": FhirCqlType(name="String", is_backbone_element=False),
        "copyright": FhirCqlType(name="String", is_backbone_element=False),
        "kind": FhirCqlType(name="String", is_backbone_element=False),
        "instantiates": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "imports": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "software": FhirCqlType(
            name="CapabilityStatement_Software", is_backbone_element=True
        ),
        "implementation": FhirCqlType(
            name="CapabilityStatement_Implementation", is_backbone_element=True
        ),
        "fhirVersion": FhirCqlType(name="String", is_backbone_element=False),
        "format": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Code", is_backbone_element=False),
        ),
        "patchFormat": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Code", is_backbone_element=False),
        ),
        "implementationGuide": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "rest": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="CapabilityStatement_Rest", is_backbone_element=True
            ),
        ),
        "messaging": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="CapabilityStatement_Messaging", is_backbone_element=True
            ),
        ),
        "document": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="CapabilityStatement_Document", is_backbone_element=True
            ),
        ),
    },
    "CarePlan": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "instantiatesCanonical": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "instantiatesUri": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "basedOn": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "replaces": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "partOf": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "status": FhirCqlType(name="Code", is_backbone_element=False),
        "intent": FhirCqlType(name="Code", is_backbone_element=False),
        "category": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "title": FhirCqlType(name="String", is_backbone_element=False),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "subject": FhirCqlType(name="Reference", is_backbone_element=True),
        "encounter": FhirCqlType(name="Reference", is_backbone_element=True),
        "period": FhirInterval(
            name="Interval",
            is_backbone_element=False,
            item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
        ),
        "created": FhirCqlType(name="DateTime", is_backbone_element=False),
        "author": FhirCqlType(name="Reference", is_backbone_element=True),
        "contributor": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "careTeam": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "addresses": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "supportingInfo": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "goal": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "activity": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="CarePlan_Activity", is_backbone_element=True),
        ),
        "note": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Annotation", is_backbone_element=True),
        ),
    },
    "CareTeam": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "status": FhirCqlType(name="String", is_backbone_element=False),
        "category": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "name": FhirCqlType(name="String", is_backbone_element=False),
        "subject": FhirCqlType(name="Reference", is_backbone_element=True),
        "encounter": FhirCqlType(name="Reference", is_backbone_element=True),
        "period": FhirInterval(
            name="Interval",
            is_backbone_element=False,
            item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
        ),
        "participant": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="CareTeam_Participant", is_backbone_element=True
            ),
        ),
        "reasonCode": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "reasonReference": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "managingOrganization": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "telecom": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactPoint", is_backbone_element=True),
        ),
        "note": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Annotation", is_backbone_element=True),
        ),
    },
    "CatalogEntry": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "orderable": FhirCqlType(name="Boolean", is_backbone_element=False),
        "referencedItem": FhirCqlType(name="Reference", is_backbone_element=True),
        "additionalIdentifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "classification": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "status": FhirCqlType(name="String", is_backbone_element=False),
        "validityPeriod": FhirInterval(
            name="Interval",
            is_backbone_element=False,
            item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
        ),
        "validTo": FhirCqlType(name="DateTime", is_backbone_element=False),
        "lastUpdated": FhirCqlType(name="DateTime", is_backbone_element=False),
        "additionalCharacteristic": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "additionalClassification": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "relatedEntry": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="CatalogEntry_RelatedEntry", is_backbone_element=True
            ),
        ),
    },
    "ChargeItem": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "definitionUri": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "definitionCanonical": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "status": FhirCqlType(name="String", is_backbone_element=False),
        "partOf": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "code": FhirCqlType(name="Concept", is_backbone_element=False),
        "subject": FhirCqlType(name="Reference", is_backbone_element=True),
        "context": FhirCqlType(name="Reference", is_backbone_element=True),
        "occurrence": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Timing", is_backbone_element=True),
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
                ),
                FhirCqlType(name="DateTime", is_backbone_element=False),
            ],
        ),
        "performer": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ChargeItem_Performer", is_backbone_element=True
            ),
        ),
        "performingOrganization": FhirCqlType(
            name="Reference", is_backbone_element=True
        ),
        "requestingOrganization": FhirCqlType(
            name="Reference", is_backbone_element=True
        ),
        "costCenter": FhirCqlType(name="Reference", is_backbone_element=True),
        "quantity": FhirCqlType(name="Decimal", is_backbone_element=False),
        "bodysite": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "factorOverride": FhirCqlType(name="Decimal", is_backbone_element=False),
        "priceOverride": FhirCqlType(name="Money", is_backbone_element=True),
        "overrideReason": FhirCqlType(name="String", is_backbone_element=False),
        "enterer": FhirCqlType(name="Reference", is_backbone_element=True),
        "enteredDate": FhirCqlType(name="DateTime", is_backbone_element=False),
        "reason": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "service": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "product": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Concept", is_backbone_element=False),
                FhirCqlType(name="Reference", is_backbone_element=True),
            ],
        ),
        "account": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "note": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Annotation", is_backbone_element=True),
        ),
        "supportingInformation": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
    },
    "ChargeItemDefinition": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "url": FhirCqlType(name="String", is_backbone_element=False),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "version": FhirCqlType(name="String", is_backbone_element=False),
        "title": FhirCqlType(name="String", is_backbone_element=False),
        "derivedFromUri": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "partOf": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "replaces": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "status": FhirCqlType(name="String", is_backbone_element=False),
        "experimental": FhirCqlType(name="Boolean", is_backbone_element=False),
        "date": FhirCqlType(name="DateTime", is_backbone_element=False),
        "publisher": FhirCqlType(name="String", is_backbone_element=False),
        "contact": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactDetail", is_backbone_element=True),
        ),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "useContext": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="UsageContext", is_backbone_element=True),
        ),
        "jurisdiction": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "copyright": FhirCqlType(name="String", is_backbone_element=False),
        "approvalDate": FhirCqlType(name="Date", is_backbone_element=False),
        "lastReviewDate": FhirCqlType(name="Date", is_backbone_element=False),
        "effectivePeriod": FhirInterval(
            name="Interval",
            is_backbone_element=False,
            item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
        ),
        "code": FhirCqlType(name="Concept", is_backbone_element=False),
        "instance": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "applicability": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ChargeItemDefinition_Applicability", is_backbone_element=True
            ),
        ),
        "propertyGroup": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ChargeItemDefinition_PropertyGroup", is_backbone_element=True
            ),
        ),
    },
    "Claim": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "status": FhirCqlType(name="Code", is_backbone_element=False),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "subType": FhirCqlType(name="Concept", is_backbone_element=False),
        "use": FhirCqlType(name="String", is_backbone_element=False),
        "patient": FhirCqlType(name="Reference", is_backbone_element=True),
        "billablePeriod": FhirInterval(
            name="Interval",
            is_backbone_element=False,
            item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
        ),
        "created": FhirCqlType(name="DateTime", is_backbone_element=False),
        "enterer": FhirCqlType(name="Reference", is_backbone_element=True),
        "insurer": FhirCqlType(name="Reference", is_backbone_element=True),
        "provider": FhirCqlType(name="Reference", is_backbone_element=True),
        "priority": FhirCqlType(name="Concept", is_backbone_element=False),
        "fundsReserve": FhirCqlType(name="Concept", is_backbone_element=False),
        "related": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Claim_Related", is_backbone_element=True),
        ),
        "prescription": FhirCqlType(name="Reference", is_backbone_element=True),
        "originalPrescription": FhirCqlType(name="Reference", is_backbone_element=True),
        "payee": FhirCqlType(name="Claim_Payee", is_backbone_element=True),
        "referral": FhirCqlType(name="Reference", is_backbone_element=True),
        "facility": FhirCqlType(name="Reference", is_backbone_element=True),
        "careTeam": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Claim_CareTeam", is_backbone_element=True),
        ),
        "supportingInfo": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="Claim_SupportingInfo", is_backbone_element=True
            ),
        ),
        "diagnosis": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Claim_Diagnosis", is_backbone_element=True),
        ),
        "procedure": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Claim_Procedure", is_backbone_element=True),
        ),
        "insurance": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Claim_Insurance", is_backbone_element=True),
        ),
        "accident": FhirCqlType(name="Claim_Accident", is_backbone_element=True),
        "item": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Claim_Item", is_backbone_element=True),
        ),
        "total": FhirCqlType(name="Money", is_backbone_element=True),
    },
    "ClaimResponse": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "status": FhirCqlType(name="Code", is_backbone_element=False),
        "": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[FhirCqlType(name="Concept", is_backbone_element=False)],
        ),
        "use": FhirCqlType(name="Code", is_backbone_element=False),
        "patient": FhirCqlType(name="Reference", is_backbone_element=True),
        "created": FhirCqlType(name="DateTime", is_backbone_element=False),
        "insurer": FhirCqlType(name="Reference", is_backbone_element=True),
        "requestor": FhirCqlType(name="Reference", is_backbone_element=True),
        "request": FhirCqlType(name="Reference", is_backbone_element=True),
        "outcome": FhirCqlType(name="Code", is_backbone_element=False),
        "disposition": FhirCqlType(name="String", is_backbone_element=False),
        "preAuthRef": FhirCqlType(name="String", is_backbone_element=False),
        "preAuthPeriod": FhirInterval(
            name="Interval",
            is_backbone_element=False,
            item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
        ),
        "payeeType": FhirCqlType(name="Concept", is_backbone_element=False),
        "item": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ClaimResponse_Item", is_backbone_element=True),
        ),
        "addItem": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ClaimResponse_AddItem", is_backbone_element=True
            ),
        ),
        "adjudication": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ClaimResponse_Adjudication", is_backbone_element=True
            ),
        ),
        "total": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ClaimResponse_Total", is_backbone_element=True),
        ),
        "payment": FhirCqlType(name="ClaimResponse_Payment", is_backbone_element=True),
        "fundsReserve": FhirCqlType(name="Concept", is_backbone_element=False),
        "formCode": FhirCqlType(name="Concept", is_backbone_element=False),
        "form": FhirCqlType(name="Attachment", is_backbone_element=True),
        "processNote": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ClaimResponse_ProcessNote", is_backbone_element=True
            ),
        ),
        "communicationRequest": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "insurance": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ClaimResponse_Insurance", is_backbone_element=True
            ),
        ),
        "error": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ClaimResponse_Error", is_backbone_element=True),
        ),
    },
    "ClinicalImpression": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "status": FhirCqlType(name="Code", is_backbone_element=False),
        "statusReason": FhirCqlType(name="Concept", is_backbone_element=False),
        "code": FhirCqlType(name="Concept", is_backbone_element=False),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "subject": FhirCqlType(name="Reference", is_backbone_element=True),
        "encounter": FhirCqlType(name="Reference", is_backbone_element=True),
        "effective": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
                ),
                FhirCqlType(name="DateTime", is_backbone_element=False),
            ],
        ),
        "date": FhirCqlType(name="DateTime", is_backbone_element=False),
        "assessor": FhirCqlType(name="Reference", is_backbone_element=True),
        "previous": FhirCqlType(name="Reference", is_backbone_element=True),
        "problem": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "investigation": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ClinicalImpression_Investigation", is_backbone_element=True
            ),
        ),
        "protocol": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "summary": FhirCqlType(name="String", is_backbone_element=False),
        "finding": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ClinicalImpression_Finding", is_backbone_element=True
            ),
        ),
        "prognosisCodeableConcept": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "prognosisReference": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "supportingInfo": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "note": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Annotation", is_backbone_element=True),
        ),
    },
    "CodeSystem": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "url": FhirCqlType(name="String", is_backbone_element=False),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "version": FhirCqlType(name="String", is_backbone_element=False),
        "name": FhirCqlType(name="String", is_backbone_element=False),
        "title": FhirCqlType(name="String", is_backbone_element=False),
        "status": FhirCqlType(name="String", is_backbone_element=False),
        "experimental": FhirCqlType(name="Boolean", is_backbone_element=False),
        "date": FhirCqlType(name="DateTime", is_backbone_element=False),
        "publisher": FhirCqlType(name="String", is_backbone_element=False),
        "contact": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactDetail", is_backbone_element=True),
        ),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "useContext": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="UsageContext", is_backbone_element=True),
        ),
        "jurisdiction": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "purpose": FhirCqlType(name="String", is_backbone_element=False),
        "copyright": FhirCqlType(name="String", is_backbone_element=False),
        "caseSensitive": FhirCqlType(name="Boolean", is_backbone_element=False),
        "valueSet": FhirCqlType(name="String", is_backbone_element=False),
        "hierarchyMeaning": FhirCqlType(name="String", is_backbone_element=False),
        "compositional": FhirCqlType(name="Boolean", is_backbone_element=False),
        "versionNeeded": FhirCqlType(name="Boolean", is_backbone_element=False),
        "content": FhirCqlType(name="String", is_backbone_element=False),
        "supplements": FhirCqlType(name="String", is_backbone_element=False),
        "count": FhirCqlType(name="String", is_backbone_element=False),
        "filter": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="CodeSystem_Filter", is_backbone_element=True),
        ),
        "property": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="CodeSystem_Property", is_backbone_element=True),
        ),
        "concept": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="CodeSystem_Concept", is_backbone_element=True),
        ),
    },
    "Communication": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "instantiatesCanonical": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "instantiatesUri": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "basedOn": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "partOf": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "inResponseTo": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "status": FhirCqlType(name="Code", is_backbone_element=False),
        "statusReason": FhirCqlType(name="Concept", is_backbone_element=False),
        "category": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "priority": FhirCqlType(name="Code", is_backbone_element=False),
        "medium": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "subject": FhirCqlType(name="Reference", is_backbone_element=True),
        "topic": FhirCqlType(name="Concept", is_backbone_element=False),
        "about": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "encounter": FhirCqlType(name="Reference", is_backbone_element=True),
        "sent": FhirCqlType(name="DateTime", is_backbone_element=False),
        "received": FhirCqlType(name="DateTime", is_backbone_element=False),
        "recipient": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "sender": FhirCqlType(name="Reference", is_backbone_element=True),
        "reasonCode": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "reasonReference": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "payload": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="Communication_Payload", is_backbone_element=True
            ),
        ),
        "note": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Annotation", is_backbone_element=True),
        ),
    },
    "CommunicationRequest": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "basedOn": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "replaces": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "groupIdentifier": FhirCqlType(name="Identifier", is_backbone_element=True),
        "status": FhirCqlType(name="Code", is_backbone_element=False),
        "statusReason": FhirCqlType(name="Concept", is_backbone_element=False),
        "category": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "priority": FhirCqlType(name="Code", is_backbone_element=False),
        "doNotPerform": FhirCqlType(name="Boolean", is_backbone_element=False),
        "medium": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "subject": FhirCqlType(name="Reference", is_backbone_element=True),
        "about": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "encounter": FhirCqlType(name="Reference", is_backbone_element=True),
        "payload": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="CommunicationRequest_Payload", is_backbone_element=True
            ),
        ),
        "occurrence": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
                ),
                FhirCqlType(name="DateTime", is_backbone_element=False),
            ],
        ),
        "authoredOn": FhirCqlType(name="DateTime", is_backbone_element=False),
        "requester": FhirCqlType(name="Reference", is_backbone_element=True),
        "recipient": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "sender": FhirCqlType(name="Reference", is_backbone_element=True),
        "reasonCode": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "reasonReference": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "note": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Annotation", is_backbone_element=True),
        ),
    },
    "CompartmentDefinition": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "url": FhirCqlType(name="String", is_backbone_element=False),
        "version": FhirCqlType(name="String", is_backbone_element=False),
        "name": FhirCqlType(name="String", is_backbone_element=False),
        "status": FhirCqlType(name="String", is_backbone_element=False),
        "experimental": FhirCqlType(name="Boolean", is_backbone_element=False),
        "date": FhirCqlType(name="DateTime", is_backbone_element=False),
        "publisher": FhirCqlType(name="String", is_backbone_element=False),
        "contact": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactDetail", is_backbone_element=True),
        ),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "useContext": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="UsageContext", is_backbone_element=True),
        ),
        "purpose": FhirCqlType(name="String", is_backbone_element=False),
        "code": FhirCqlType(name="String", is_backbone_element=False),
        "search": FhirCqlType(name="Boolean", is_backbone_element=False),
        "resource": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="CompartmentDefinition_Resource", is_backbone_element=True
            ),
        ),
    },
    "Composition": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirCqlType(name="Identifier", is_backbone_element=True),
        "status": FhirCqlType(name="String", is_backbone_element=False),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "category": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "subject": FhirCqlType(name="Reference", is_backbone_element=True),
        "encounter": FhirCqlType(name="Reference", is_backbone_element=True),
        "date": FhirCqlType(name="DateTime", is_backbone_element=False),
        "author": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "title": FhirCqlType(name="String", is_backbone_element=False),
        "confidentiality": FhirCqlType(name="Code", is_backbone_element=False),
        "attester": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="Composition_Attester", is_backbone_element=True
            ),
        ),
        "custodian": FhirCqlType(name="Reference", is_backbone_element=True),
        "relatesTo": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="Composition_RelatesTo", is_backbone_element=True
            ),
        ),
        "event": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Composition_Event", is_backbone_element=True),
        ),
        "section": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Composition_Section", is_backbone_element=True),
        ),
    },
    "ConceptMap": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "url": FhirCqlType(name="String", is_backbone_element=False),
        "identifier": FhirCqlType(name="Identifier", is_backbone_element=True),
        "version": FhirCqlType(name="String", is_backbone_element=False),
        "name": FhirCqlType(name="String", is_backbone_element=False),
        "title": FhirCqlType(name="String", is_backbone_element=False),
        "status": FhirCqlType(name="String", is_backbone_element=False),
        "experimental": FhirCqlType(name="Boolean", is_backbone_element=False),
        "date": FhirCqlType(name="DateTime", is_backbone_element=False),
        "publisher": FhirCqlType(name="String", is_backbone_element=False),
        "contact": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactDetail", is_backbone_element=True),
        ),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "useContext": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="UsageContext", is_backbone_element=True),
        ),
        "jurisdiction": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "purpose": FhirCqlType(name="String", is_backbone_element=False),
        "copyright": FhirCqlType(name="String", is_backbone_element=False),
        "source": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[FhirCqlType(name="String", is_backbone_element=False)],
        ),
        "target": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[FhirCqlType(name="String", is_backbone_element=False)],
        ),
        "group": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ConceptMap_Group", is_backbone_element=True),
        ),
    },
    "Condition": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "clinicalStatus": FhirCqlType(name="Concept", is_backbone_element=False),
        "verificationStatus": FhirCqlType(name="Concept", is_backbone_element=False),
        "category": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "severity": FhirCqlType(name="Concept", is_backbone_element=False),
        "code": FhirCqlType(name="Concept", is_backbone_element=False),
        "bodySite": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "subject": FhirCqlType(name="Reference", is_backbone_element=True),
        "encounter": FhirCqlType(name="Reference", is_backbone_element=True),
        "onset": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="Decimal", is_backbone_element=False),
                ),
                FhirCqlType(name="String", is_backbone_element=False),
                FhirCqlType(name="Age", is_backbone_element=True),
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
                ),
                FhirCqlType(name="DateTime", is_backbone_element=False),
            ],
        ),
        "abatement": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="Decimal", is_backbone_element=False),
                ),
                FhirCqlType(name="String", is_backbone_element=False),
                FhirCqlType(name="Age", is_backbone_element=True),
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
                ),
                FhirCqlType(name="DateTime", is_backbone_element=False),
            ],
        ),
        "recordedDate": FhirCqlType(name="DateTime", is_backbone_element=False),
        "recorder": FhirCqlType(name="Reference", is_backbone_element=True),
        "asserter": FhirCqlType(name="Reference", is_backbone_element=True),
        "stage": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Condition_Stage", is_backbone_element=True),
        ),
        "evidence": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Condition_Evidence", is_backbone_element=True),
        ),
        "note": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Annotation", is_backbone_element=True),
        ),
    },
    "Consent": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "status": FhirCqlType(name="String", is_backbone_element=False),
        "scope": FhirCqlType(name="Concept", is_backbone_element=False),
        "category": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "patient": FhirCqlType(name="Reference", is_backbone_element=True),
        "dateTime": FhirCqlType(name="DateTime", is_backbone_element=False),
        "performer": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "organization": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "source": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Reference", is_backbone_element=True),
                FhirCqlType(name="Attachment", is_backbone_element=True),
            ],
        ),
        "policy": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Consent_Policy", is_backbone_element=True),
        ),
        "policyRule": FhirCqlType(name="Concept", is_backbone_element=False),
        "verification": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="Consent_Verification", is_backbone_element=True
            ),
        ),
        "provision": FhirCqlType(name="Consent_Provision", is_backbone_element=True),
    },
    "Contract": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "url": FhirCqlType(name="String", is_backbone_element=False),
        "version": FhirCqlType(name="String", is_backbone_element=False),
        "status": FhirCqlType(name="Code", is_backbone_element=False),
        "legalState": FhirCqlType(name="Concept", is_backbone_element=False),
        "instantiatesCanonical": FhirCqlType(
            name="Reference", is_backbone_element=True
        ),
        "instantiatesUri": FhirCqlType(name="String", is_backbone_element=False),
        "contentDerivative": FhirCqlType(name="Concept", is_backbone_element=False),
        "issued": FhirCqlType(name="DateTime", is_backbone_element=False),
        "applies": FhirInterval(
            name="Interval",
            is_backbone_element=False,
            item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
        ),
        "expirationType": FhirCqlType(name="Concept", is_backbone_element=False),
        "subject": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "authority": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "domain": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "site": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "name": FhirCqlType(name="String", is_backbone_element=False),
        "title": FhirCqlType(name="String", is_backbone_element=False),
        "subtitle": FhirCqlType(name="String", is_backbone_element=False),
        "alias": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "author": FhirCqlType(name="Reference", is_backbone_element=True),
        "scope": FhirCqlType(name="Concept", is_backbone_element=False),
        "topic": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Concept", is_backbone_element=False),
                FhirCqlType(name="Reference", is_backbone_element=True),
            ],
        ),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "subType": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "contentDefinition": FhirCqlType(
            name="Contract_ContentDefinition", is_backbone_element=True
        ),
        "term": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Contract_Term", is_backbone_element=True),
        ),
        "supportingInfo": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "relevantHistory": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "signer": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Contract_Signer", is_backbone_element=True),
        ),
        "friendly": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Contract_Friendly", is_backbone_element=True),
        ),
        "legal": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Contract_Legal", is_backbone_element=True),
        ),
        "rule": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Contract_Rule", is_backbone_element=True),
        ),
        "legallyBinding": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Reference", is_backbone_element=True),
                FhirCqlType(name="Attachment", is_backbone_element=True),
            ],
        ),
    },
    "Coverage": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "status": FhirCqlType(name="Code", is_backbone_element=False),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "policyHolder": FhirCqlType(name="Reference", is_backbone_element=True),
        "subscriber": FhirCqlType(name="Reference", is_backbone_element=True),
        "subscriberId": FhirCqlType(name="String", is_backbone_element=False),
        "beneficiary": FhirCqlType(name="Reference", is_backbone_element=True),
        "dependent": FhirCqlType(name="String", is_backbone_element=False),
        "relationship": FhirCqlType(name="Concept", is_backbone_element=False),
        "period": FhirInterval(
            name="Interval",
            is_backbone_element=False,
            item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
        ),
        "payor": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "class": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Coverage_Class", is_backbone_element=True),
        ),
        "order": FhirCqlType(name="String", is_backbone_element=False),
        "network": FhirCqlType(name="String", is_backbone_element=False),
        "costToBeneficiary": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="Coverage_CostToBeneficiary", is_backbone_element=True
            ),
        ),
        "subrogation": FhirCqlType(name="Boolean", is_backbone_element=False),
        "contract": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
    },
    "CoverageEligibilityRequest": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "status": FhirCqlType(name="Code", is_backbone_element=False),
        "priority": FhirCqlType(name="Concept", is_backbone_element=False),
        "purpose": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "patient": FhirCqlType(name="Reference", is_backbone_element=True),
        "serviced": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Date", is_backbone_element=False),
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
                ),
            ],
        ),
        "created": FhirCqlType(name="DateTime", is_backbone_element=False),
        "enterer": FhirCqlType(name="Reference", is_backbone_element=True),
        "provider": FhirCqlType(name="Reference", is_backbone_element=True),
        "insurer": FhirCqlType(name="Reference", is_backbone_element=True),
        "facility": FhirCqlType(name="Reference", is_backbone_element=True),
        "supportingInfo": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="CoverageEligibilityRequest_SupportingInfo",
                is_backbone_element=True,
            ),
        ),
        "insurance": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="CoverageEligibilityRequest_Insurance", is_backbone_element=True
            ),
        ),
        "item": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="CoverageEligibilityRequest_Item", is_backbone_element=True
            ),
        ),
    },
    "CoverageEligibilityResponse": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "status": FhirCqlType(name="Code", is_backbone_element=False),
        "purpose": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "patient": FhirCqlType(name="Reference", is_backbone_element=True),
        "serviced": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Date", is_backbone_element=False),
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
                ),
            ],
        ),
        "created": FhirCqlType(name="DateTime", is_backbone_element=False),
        "requestor": FhirCqlType(name="Reference", is_backbone_element=True),
        "request": FhirCqlType(name="Reference", is_backbone_element=True),
        "outcome": FhirCqlType(name="String", is_backbone_element=False),
        "disposition": FhirCqlType(name="String", is_backbone_element=False),
        "insurer": FhirCqlType(name="Reference", is_backbone_element=True),
        "insurance": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="CoverageEligibilityResponse_Insurance", is_backbone_element=True
            ),
        ),
        "preAuthRef": FhirCqlType(name="String", is_backbone_element=False),
        "form": FhirCqlType(name="Concept", is_backbone_element=False),
        "error": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="CoverageEligibilityResponse_Error", is_backbone_element=True
            ),
        ),
    },
    "DetectedIssue": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "status": FhirCqlType(name="Code", is_backbone_element=False),
        "code": FhirCqlType(name="Concept", is_backbone_element=False),
        "severity": FhirCqlType(name="String", is_backbone_element=False),
        "patient": FhirCqlType(name="Reference", is_backbone_element=True),
        "identified": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
                ),
                FhirCqlType(name="DateTime", is_backbone_element=False),
            ],
        ),
        "author": FhirCqlType(name="Reference", is_backbone_element=True),
        "implicated": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "evidence": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="DetectedIssue_Evidence", is_backbone_element=True
            ),
        ),
        "detail": FhirCqlType(name="String", is_backbone_element=False),
        "reference": FhirCqlType(name="String", is_backbone_element=False),
        "mitigation": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="DetectedIssue_Mitigation", is_backbone_element=True
            ),
        ),
    },
    "Device": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "definition": FhirCqlType(name="Reference", is_backbone_element=True),
        "udiCarrier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Device_UdiCarrier", is_backbone_element=True),
        ),
        "status": FhirCqlType(name="String", is_backbone_element=False),
        "statusReason": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "distinctIdentifier": FhirCqlType(name="String", is_backbone_element=False),
        "manufacturer": FhirCqlType(name="String", is_backbone_element=False),
        "manufactureDate": FhirCqlType(name="DateTime", is_backbone_element=False),
        "expirationDate": FhirCqlType(name="DateTime", is_backbone_element=False),
        "lotNumber": FhirCqlType(name="String", is_backbone_element=False),
        "serialNumber": FhirCqlType(name="String", is_backbone_element=False),
        "deviceName": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Device_DeviceName", is_backbone_element=True),
        ),
        "modelNumber": FhirCqlType(name="String", is_backbone_element=False),
        "partNumber": FhirCqlType(name="String", is_backbone_element=False),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "specialization": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="Device_Specialization", is_backbone_element=True
            ),
        ),
        "version": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Device_Version", is_backbone_element=True),
        ),
        "property": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Device_Property", is_backbone_element=True),
        ),
        "patient": FhirCqlType(name="Reference", is_backbone_element=True),
        "owner": FhirCqlType(name="Reference", is_backbone_element=True),
        "contact": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactPoint", is_backbone_element=True),
        ),
        "location": FhirCqlType(name="Reference", is_backbone_element=True),
        "url": FhirCqlType(name="String", is_backbone_element=False),
        "note": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Annotation", is_backbone_element=True),
        ),
        "safety": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "parent": FhirCqlType(name="Reference", is_backbone_element=True),
    },
    "DeviceDefinition": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "udiDeviceIdentifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="DeviceDefinition_UdiDeviceIdentifier", is_backbone_element=True
            ),
        ),
        "manufacturer": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Reference", is_backbone_element=True),
                FhirCqlType(name="String", is_backbone_element=False),
            ],
        ),
        "deviceName": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="DeviceDefinition_DeviceName", is_backbone_element=True
            ),
        ),
        "modelNumber": FhirCqlType(name="String", is_backbone_element=False),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "specialization": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="DeviceDefinition_Specialization", is_backbone_element=True
            ),
        ),
        "version": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "safety": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "shelfLifeStorage": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ProductShelfLife", is_backbone_element=True),
        ),
        "physicalCharacteristics": FhirCqlType(
            name="ProdCharacteristic", is_backbone_element=True
        ),
        "languageCode": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "capability": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="DeviceDefinition_Capability", is_backbone_element=True
            ),
        ),
        "property": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="DeviceDefinition_Property", is_backbone_element=True
            ),
        ),
        "owner": FhirCqlType(name="Reference", is_backbone_element=True),
        "contact": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactPoint", is_backbone_element=True),
        ),
        "url": FhirCqlType(name="String", is_backbone_element=False),
        "onlineInformation": FhirCqlType(name="String", is_backbone_element=False),
        "note": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Annotation", is_backbone_element=True),
        ),
        "quantity": FhirCqlType(name="Decimal", is_backbone_element=False),
        "parentDevice": FhirCqlType(name="Reference", is_backbone_element=True),
        "material": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="DeviceDefinition_Material", is_backbone_element=True
            ),
        ),
    },
    "DeviceMetric": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "unit": FhirCqlType(name="Concept", is_backbone_element=False),
        "source": FhirCqlType(name="Reference", is_backbone_element=True),
        "parent": FhirCqlType(name="Reference", is_backbone_element=True),
        "operationalStatus": FhirCqlType(name="String", is_backbone_element=False),
        "color": FhirCqlType(name="String", is_backbone_element=False),
        "category": FhirCqlType(name="String", is_backbone_element=False),
        "measurementPeriod": FhirCqlType(name="Timing", is_backbone_element=True),
        "calibration": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="DeviceMetric_Calibration", is_backbone_element=True
            ),
        ),
    },
    "DeviceRequest": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "instantiatesCanonical": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "instantiatesUri": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "basedOn": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "priorRequest": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "groupIdentifier": FhirCqlType(name="Identifier", is_backbone_element=True),
        "status": FhirCqlType(name="Code", is_backbone_element=False),
        "intent": FhirCqlType(name="Code", is_backbone_element=False),
        "priority": FhirCqlType(name="Code", is_backbone_element=False),
        "code": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Concept", is_backbone_element=False),
                FhirCqlType(name="Reference", is_backbone_element=True),
            ],
        ),
        "parameter": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="DeviceRequest_Parameter", is_backbone_element=True
            ),
        ),
        "subject": FhirCqlType(name="Reference", is_backbone_element=True),
        "encounter": FhirCqlType(name="Reference", is_backbone_element=True),
        "occurrence": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Timing", is_backbone_element=True),
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
                ),
                FhirCqlType(name="DateTime", is_backbone_element=False),
            ],
        ),
        "authoredOn": FhirCqlType(name="DateTime", is_backbone_element=False),
        "requester": FhirCqlType(name="Reference", is_backbone_element=True),
        "performerType": FhirCqlType(name="Concept", is_backbone_element=False),
        "performer": FhirCqlType(name="Reference", is_backbone_element=True),
        "reason": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirList(
                    name="List",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="Concept", is_backbone_element=False),
                ),
                FhirList(
                    name="List",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="Reference", is_backbone_element=True),
                ),
            ],
        ),
        "insurance": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "supportingInfo": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "note": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Annotation", is_backbone_element=True),
        ),
        "relevantHistory": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
    },
    "DeviceUseStatement": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "basedOn": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "status": FhirCqlType(name="String", is_backbone_element=False),
        "subject": FhirCqlType(name="Reference", is_backbone_element=True),
        "derivedFrom": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "timing": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Timing", is_backbone_element=True),
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
                ),
                FhirCqlType(name="DateTime", is_backbone_element=False),
            ],
        ),
        "recordedOn": FhirCqlType(name="DateTime", is_backbone_element=False),
        "source": FhirCqlType(name="Reference", is_backbone_element=True),
        "device": FhirCqlType(name="Reference", is_backbone_element=True),
        "reasonCode": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "reasonReference": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "bodySite": FhirCqlType(name="Concept", is_backbone_element=False),
        "note": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Annotation", is_backbone_element=True),
        ),
    },
    "DiagnosticReport": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "basedOn": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "status": FhirCqlType(name="String", is_backbone_element=False),
        "category": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "code": FhirCqlType(name="Concept", is_backbone_element=False),
        "subject": FhirCqlType(name="Reference", is_backbone_element=True),
        "encounter": FhirCqlType(name="Reference", is_backbone_element=True),
        "effective": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
                ),
                FhirCqlType(name="DateTime", is_backbone_element=False),
            ],
        ),
        "issued": FhirCqlType(name="String", is_backbone_element=False),
        "performer": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "resultsInterpreter": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "specimen": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "result": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "imagingStudy": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "media": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="DiagnosticReport_Media", is_backbone_element=True
            ),
        ),
        "conclusion": FhirCqlType(name="String", is_backbone_element=False),
        "conclusionCode": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "presentedForm": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Attachment", is_backbone_element=True),
        ),
    },
    "DocumentManifest": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "masterIdentifier": FhirCqlType(name="Identifier", is_backbone_element=True),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "status": FhirCqlType(name="String", is_backbone_element=False),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "subject": FhirCqlType(name="Reference", is_backbone_element=True),
        "created": FhirCqlType(name="DateTime", is_backbone_element=False),
        "author": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "recipient": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "source": FhirCqlType(name="String", is_backbone_element=False),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "content": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "related": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="DocumentManifest_Related", is_backbone_element=True
            ),
        ),
    },
    "DocumentReference": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "masterIdentifier": FhirCqlType(name="Identifier", is_backbone_element=True),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "status": FhirCqlType(name="String", is_backbone_element=False),
        "docStatus": FhirCqlType(name="Code", is_backbone_element=False),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "category": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "subject": FhirCqlType(name="Reference", is_backbone_element=True),
        "date": FhirCqlType(name="String", is_backbone_element=False),
        "author": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "authenticator": FhirCqlType(name="Reference", is_backbone_element=True),
        "custodian": FhirCqlType(name="Reference", is_backbone_element=True),
        "relatesTo": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="DocumentReference_RelatesTo", is_backbone_element=True
            ),
        ),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "securityLabel": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "content": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="DocumentReference_Content", is_backbone_element=True
            ),
        ),
        "context": FhirCqlType(
            name="DocumentReference_Context", is_backbone_element=True
        ),
    },
    "EffectEvidenceSynthesis": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "url": FhirCqlType(name="String", is_backbone_element=False),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "version": FhirCqlType(name="String", is_backbone_element=False),
        "name": FhirCqlType(name="String", is_backbone_element=False),
        "title": FhirCqlType(name="String", is_backbone_element=False),
        "status": FhirCqlType(name="String", is_backbone_element=False),
        "date": FhirCqlType(name="DateTime", is_backbone_element=False),
        "publisher": FhirCqlType(name="String", is_backbone_element=False),
        "contact": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactDetail", is_backbone_element=True),
        ),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "note": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Annotation", is_backbone_element=True),
        ),
        "useContext": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="UsageContext", is_backbone_element=True),
        ),
        "jurisdiction": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "copyright": FhirCqlType(name="String", is_backbone_element=False),
        "approvalDate": FhirCqlType(name="Date", is_backbone_element=False),
        "lastReviewDate": FhirCqlType(name="Date", is_backbone_element=False),
        "effectivePeriod": FhirInterval(
            name="Interval",
            is_backbone_element=False,
            item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
        ),
        "topic": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "author": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactDetail", is_backbone_element=True),
        ),
        "editor": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactDetail", is_backbone_element=True),
        ),
        "reviewer": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactDetail", is_backbone_element=True),
        ),
        "endorser": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactDetail", is_backbone_element=True),
        ),
        "relatedArtifact": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="RelatedArtifact", is_backbone_element=True),
        ),
        "synthesisType": FhirCqlType(name="Concept", is_backbone_element=False),
        "studyType": FhirCqlType(name="Concept", is_backbone_element=False),
        "population": FhirCqlType(name="Reference", is_backbone_element=True),
        "exposure": FhirCqlType(name="Reference", is_backbone_element=True),
        "exposureAlternative": FhirCqlType(name="Reference", is_backbone_element=True),
        "outcome": FhirCqlType(name="Reference", is_backbone_element=True),
        "sampleSize": FhirCqlType(
            name="EffectEvidenceSynthesis_SampleSize", is_backbone_element=True
        ),
        "resultsByExposure": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="EffectEvidenceSynthesis_ResultsByExposure",
                is_backbone_element=True,
            ),
        ),
        "effectEstimate": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="EffectEvidenceSynthesis_EffectEstimate", is_backbone_element=True
            ),
        ),
        "certainty": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="EffectEvidenceSynthesis_Certainty", is_backbone_element=True
            ),
        ),
    },
    "Encounter": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "status": FhirCqlType(name="String", is_backbone_element=False),
        "statusHistory": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="Encounter_StatusHistory", is_backbone_element=True
            ),
        ),
        "class": FhirCqlType(name="Code", is_backbone_element=False),
        "classHistory": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="Encounter_ClassHistory", is_backbone_element=True
            ),
        ),
        "type": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "serviceType": FhirCqlType(name="Concept", is_backbone_element=False),
        "priority": FhirCqlType(name="Concept", is_backbone_element=False),
        "subject": FhirCqlType(name="Reference", is_backbone_element=True),
        "episodeOfCare": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "basedOn": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "participant": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="Encounter_Participant", is_backbone_element=True
            ),
        ),
        "appointment": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "period": FhirInterval(
            name="Interval",
            is_backbone_element=False,
            item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
        ),
        "length": FhirCqlType(name="Duration", is_backbone_element=True),
        "reason": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirList(
                    name="List",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="Concept", is_backbone_element=False),
                ),
                FhirList(
                    name="List",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="Reference", is_backbone_element=True),
                ),
            ],
        ),
        "diagnosis": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Encounter_Diagnosis", is_backbone_element=True),
        ),
        "account": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "hospitalization": FhirCqlType(
            name="Encounter_Hospitalization", is_backbone_element=True
        ),
        "location": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Encounter_Location", is_backbone_element=True),
        ),
        "serviceProvider": FhirCqlType(name="Reference", is_backbone_element=True),
        "partOf": FhirCqlType(name="Reference", is_backbone_element=True),
    },
    "Endpoint": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "status": FhirCqlType(name="String", is_backbone_element=False),
        "connectionType": FhirCqlType(name="Code", is_backbone_element=False),
        "name": FhirCqlType(name="String", is_backbone_element=False),
        "managingOrganization": FhirCqlType(name="Reference", is_backbone_element=True),
        "contact": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactPoint", is_backbone_element=True),
        ),
        "period": FhirInterval(
            name="Interval",
            is_backbone_element=False,
            item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
        ),
        "payloadType": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "payloadMimeType": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Code", is_backbone_element=False),
        ),
        "address": FhirCqlType(name="String", is_backbone_element=False),
        "header": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
    },
    "EnrollmentRequest": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "status": FhirCqlType(name="Code", is_backbone_element=False),
        "created": FhirCqlType(name="DateTime", is_backbone_element=False),
        "insurer": FhirCqlType(name="Reference", is_backbone_element=True),
        "provider": FhirCqlType(name="Reference", is_backbone_element=True),
        "candidate": FhirCqlType(name="Reference", is_backbone_element=True),
        "coverage": FhirCqlType(name="Reference", is_backbone_element=True),
    },
    "EnrollmentResponse": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "status": FhirCqlType(name="Code", is_backbone_element=False),
        "request": FhirCqlType(name="Reference", is_backbone_element=True),
        "outcome": FhirCqlType(name="String", is_backbone_element=False),
        "disposition": FhirCqlType(name="String", is_backbone_element=False),
        "created": FhirCqlType(name="DateTime", is_backbone_element=False),
        "organization": FhirCqlType(name="Reference", is_backbone_element=True),
        "requestProvider": FhirCqlType(name="Reference", is_backbone_element=True),
    },
    "EpisodeOfCare": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "status": FhirCqlType(name="String", is_backbone_element=False),
        "statusHistory": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="EpisodeOfCare_StatusHistory", is_backbone_element=True
            ),
        ),
        "type": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "diagnosis": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="EpisodeOfCare_Diagnosis", is_backbone_element=True
            ),
        ),
        "patient": FhirCqlType(name="Reference", is_backbone_element=True),
        "managingOrganization": FhirCqlType(name="Reference", is_backbone_element=True),
        "period": FhirInterval(
            name="Interval",
            is_backbone_element=False,
            item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
        ),
        "referralRequest": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "careManager": FhirCqlType(name="Reference", is_backbone_element=True),
        "team": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "account": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
    },
    "EventDefinition": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "url": FhirCqlType(name="String", is_backbone_element=False),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "version": FhirCqlType(name="String", is_backbone_element=False),
        "name": FhirCqlType(name="String", is_backbone_element=False),
        "title": FhirCqlType(name="String", is_backbone_element=False),
        "subtitle": FhirCqlType(name="String", is_backbone_element=False),
        "status": FhirCqlType(name="String", is_backbone_element=False),
        "experimental": FhirCqlType(name="Boolean", is_backbone_element=False),
        "subject": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Concept", is_backbone_element=False),
                FhirCqlType(name="Reference", is_backbone_element=True),
            ],
        ),
        "date": FhirCqlType(name="DateTime", is_backbone_element=False),
        "publisher": FhirCqlType(name="String", is_backbone_element=False),
        "contact": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactDetail", is_backbone_element=True),
        ),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "useContext": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="UsageContext", is_backbone_element=True),
        ),
        "jurisdiction": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "purpose": FhirCqlType(name="String", is_backbone_element=False),
        "usage": FhirCqlType(name="String", is_backbone_element=False),
        "copyright": FhirCqlType(name="String", is_backbone_element=False),
        "approvalDate": FhirCqlType(name="Date", is_backbone_element=False),
        "lastReviewDate": FhirCqlType(name="Date", is_backbone_element=False),
        "effectivePeriod": FhirInterval(
            name="Interval",
            is_backbone_element=False,
            item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
        ),
        "topic": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "author": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactDetail", is_backbone_element=True),
        ),
        "editor": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactDetail", is_backbone_element=True),
        ),
        "reviewer": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactDetail", is_backbone_element=True),
        ),
        "endorser": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactDetail", is_backbone_element=True),
        ),
        "relatedArtifact": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="RelatedArtifact", is_backbone_element=True),
        ),
        "trigger": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="TriggerDefinition", is_backbone_element=True),
        ),
    },
    "Evidence": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "url": FhirCqlType(name="String", is_backbone_element=False),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "version": FhirCqlType(name="String", is_backbone_element=False),
        "name": FhirCqlType(name="String", is_backbone_element=False),
        "title": FhirCqlType(name="String", is_backbone_element=False),
        "shortTitle": FhirCqlType(name="String", is_backbone_element=False),
        "subtitle": FhirCqlType(name="String", is_backbone_element=False),
        "status": FhirCqlType(name="String", is_backbone_element=False),
        "date": FhirCqlType(name="DateTime", is_backbone_element=False),
        "publisher": FhirCqlType(name="String", is_backbone_element=False),
        "contact": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactDetail", is_backbone_element=True),
        ),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "note": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Annotation", is_backbone_element=True),
        ),
        "useContext": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="UsageContext", is_backbone_element=True),
        ),
        "jurisdiction": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "copyright": FhirCqlType(name="String", is_backbone_element=False),
        "approvalDate": FhirCqlType(name="Date", is_backbone_element=False),
        "lastReviewDate": FhirCqlType(name="Date", is_backbone_element=False),
        "effectivePeriod": FhirInterval(
            name="Interval",
            is_backbone_element=False,
            item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
        ),
        "topic": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "author": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactDetail", is_backbone_element=True),
        ),
        "editor": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactDetail", is_backbone_element=True),
        ),
        "reviewer": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactDetail", is_backbone_element=True),
        ),
        "endorser": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactDetail", is_backbone_element=True),
        ),
        "relatedArtifact": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="RelatedArtifact", is_backbone_element=True),
        ),
        "exposureBackground": FhirCqlType(name="Reference", is_backbone_element=True),
        "exposureVariant": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "outcome": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
    },
    "EvidenceVariable": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "url": FhirCqlType(name="String", is_backbone_element=False),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "version": FhirCqlType(name="String", is_backbone_element=False),
        "name": FhirCqlType(name="String", is_backbone_element=False),
        "title": FhirCqlType(name="String", is_backbone_element=False),
        "shortTitle": FhirCqlType(name="String", is_backbone_element=False),
        "subtitle": FhirCqlType(name="String", is_backbone_element=False),
        "status": FhirCqlType(name="String", is_backbone_element=False),
        "date": FhirCqlType(name="DateTime", is_backbone_element=False),
        "publisher": FhirCqlType(name="String", is_backbone_element=False),
        "contact": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactDetail", is_backbone_element=True),
        ),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "note": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Annotation", is_backbone_element=True),
        ),
        "useContext": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="UsageContext", is_backbone_element=True),
        ),
        "jurisdiction": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "copyright": FhirCqlType(name="String", is_backbone_element=False),
        "approvalDate": FhirCqlType(name="Date", is_backbone_element=False),
        "lastReviewDate": FhirCqlType(name="Date", is_backbone_element=False),
        "effectivePeriod": FhirInterval(
            name="Interval",
            is_backbone_element=False,
            item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
        ),
        "topic": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "author": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactDetail", is_backbone_element=True),
        ),
        "editor": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactDetail", is_backbone_element=True),
        ),
        "reviewer": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactDetail", is_backbone_element=True),
        ),
        "endorser": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactDetail", is_backbone_element=True),
        ),
        "relatedArtifact": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="RelatedArtifact", is_backbone_element=True),
        ),
        "type": FhirCqlType(name="String", is_backbone_element=False),
        "characteristic": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="EvidenceVariable_Characteristic", is_backbone_element=True
            ),
        ),
    },
    "ExampleScenario": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "url": FhirCqlType(name="String", is_backbone_element=False),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "version": FhirCqlType(name="String", is_backbone_element=False),
        "name": FhirCqlType(name="String", is_backbone_element=False),
        "status": FhirCqlType(name="String", is_backbone_element=False),
        "experimental": FhirCqlType(name="Boolean", is_backbone_element=False),
        "date": FhirCqlType(name="DateTime", is_backbone_element=False),
        "publisher": FhirCqlType(name="String", is_backbone_element=False),
        "contact": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactDetail", is_backbone_element=True),
        ),
        "useContext": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="UsageContext", is_backbone_element=True),
        ),
        "jurisdiction": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "copyright": FhirCqlType(name="String", is_backbone_element=False),
        "purpose": FhirCqlType(name="String", is_backbone_element=False),
        "actor": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ExampleScenario_Actor", is_backbone_element=True
            ),
        ),
        "instance": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ExampleScenario_Instance", is_backbone_element=True
            ),
        ),
        "process": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ExampleScenario_Process", is_backbone_element=True
            ),
        ),
        "workflow": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
    },
    "ExplanationOfBenefit": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "status": FhirCqlType(name="String", is_backbone_element=False),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "subType": FhirCqlType(name="Concept", is_backbone_element=False),
        "use": FhirCqlType(name="Code", is_backbone_element=False),
        "patient": FhirCqlType(name="Reference", is_backbone_element=True),
        "billablePeriod": FhirInterval(
            name="Interval",
            is_backbone_element=False,
            item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
        ),
        "created": FhirCqlType(name="DateTime", is_backbone_element=False),
        "enterer": FhirCqlType(name="Reference", is_backbone_element=True),
        "insurer": FhirCqlType(name="Reference", is_backbone_element=True),
        "provider": FhirCqlType(name="Reference", is_backbone_element=True),
        "priority": FhirCqlType(name="Concept", is_backbone_element=False),
        "fundsReserveRequested": FhirCqlType(name="Concept", is_backbone_element=False),
        "fundsReserve": FhirCqlType(name="Concept", is_backbone_element=False),
        "related": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ExplanationOfBenefit_Related", is_backbone_element=True
            ),
        ),
        "prescription": FhirCqlType(name="Reference", is_backbone_element=True),
        "originalPrescription": FhirCqlType(name="Reference", is_backbone_element=True),
        "payee": FhirCqlType(
            name="ExplanationOfBenefit_Payee", is_backbone_element=True
        ),
        "referral": FhirCqlType(name="Reference", is_backbone_element=True),
        "facility": FhirCqlType(name="Reference", is_backbone_element=True),
        "claim": FhirCqlType(name="Reference", is_backbone_element=True),
        "claimResponse": FhirCqlType(name="Reference", is_backbone_element=True),
        "outcome": FhirCqlType(name="Code", is_backbone_element=False),
        "disposition": FhirCqlType(name="String", is_backbone_element=False),
        "preAuthRef": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "preAuthRefPeriod": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirInterval(
                name="Interval",
                is_backbone_element=False,
                item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
            ),
        ),
        "careTeam": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ExplanationOfBenefit_CareTeam", is_backbone_element=True
            ),
        ),
        "supportingInfo": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ExplanationOfBenefit_SupportingInfo", is_backbone_element=True
            ),
        ),
        "diagnosis": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ExplanationOfBenefit_Diagnosis", is_backbone_element=True
            ),
        ),
        "procedure": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ExplanationOfBenefit_Procedure", is_backbone_element=True
            ),
        ),
        "precedence": FhirCqlType(name="String", is_backbone_element=False),
        "insurance": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ExplanationOfBenefit_Insurance", is_backbone_element=True
            ),
        ),
        "accident": FhirCqlType(
            name="ExplanationOfBenefit_Accident", is_backbone_element=True
        ),
        "item": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ExplanationOfBenefit_Item", is_backbone_element=True
            ),
        ),
        "addItem": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ExplanationOfBenefit_AddItem", is_backbone_element=True
            ),
        ),
        "adjudication": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ExplanationOfBenefit_Adjudication", is_backbone_element=True
            ),
        ),
        "total": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ExplanationOfBenefit_Total", is_backbone_element=True
            ),
        ),
        "payment": FhirCqlType(
            name="ExplanationOfBenefit_Payment", is_backbone_element=True
        ),
        "formCode": FhirCqlType(name="Concept", is_backbone_element=False),
        "form": FhirCqlType(name="Attachment", is_backbone_element=True),
        "processNote": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ExplanationOfBenefit_ProcessNote", is_backbone_element=True
            ),
        ),
        "benefitPeriod": FhirInterval(
            name="Interval",
            is_backbone_element=False,
            item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
        ),
        "benefitBalance": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ExplanationOfBenefit_BenefitBalance", is_backbone_element=True
            ),
        ),
    },
    "FamilyMemberHistory": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "instantiatesCanonical": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "instantiatesUri": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "status": FhirCqlType(name="String", is_backbone_element=False),
        "dataAbsentReason": FhirCqlType(name="Concept", is_backbone_element=False),
        "patient": FhirCqlType(name="Reference", is_backbone_element=True),
        "date": FhirCqlType(name="DateTime", is_backbone_element=False),
        "name": FhirCqlType(name="String", is_backbone_element=False),
        "relationship": FhirCqlType(name="Concept", is_backbone_element=False),
        "sex": FhirCqlType(name="Concept", is_backbone_element=False),
        "born": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Date", is_backbone_element=False),
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
                ),
                FhirCqlType(name="String", is_backbone_element=False),
            ],
        ),
        "age": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Age", is_backbone_element=True),
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="Decimal", is_backbone_element=False),
                ),
                FhirCqlType(name="String", is_backbone_element=False),
            ],
        ),
        "estimatedAge": FhirCqlType(name="Boolean", is_backbone_element=False),
        "deceased": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="Decimal", is_backbone_element=False),
                ),
                FhirCqlType(name="String", is_backbone_element=False),
                FhirCqlType(name="Date", is_backbone_element=False),
                FhirCqlType(name="Boolean", is_backbone_element=False),
                FhirCqlType(name="Age", is_backbone_element=True),
            ],
        ),
        "reasonCode": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "reasonReference": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "note": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Annotation", is_backbone_element=True),
        ),
        "condition": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="FamilyMemberHistory_Condition", is_backbone_element=True
            ),
        ),
    },
    "Flag": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "status": FhirCqlType(name="String", is_backbone_element=False),
        "category": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "code": FhirCqlType(name="Concept", is_backbone_element=False),
        "subject": FhirCqlType(name="Reference", is_backbone_element=True),
        "period": FhirInterval(
            name="Interval",
            is_backbone_element=False,
            item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
        ),
        "encounter": FhirCqlType(name="Reference", is_backbone_element=True),
        "author": FhirCqlType(name="Reference", is_backbone_element=True),
    },
    "Goal": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "lifecycleStatus": FhirCqlType(name="String", is_backbone_element=False),
        "achievementStatus": FhirCqlType(name="Concept", is_backbone_element=False),
        "category": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "priority": FhirCqlType(name="Concept", is_backbone_element=False),
        "description": FhirCqlType(name="Concept", is_backbone_element=False),
        "subject": FhirCqlType(name="Reference", is_backbone_element=True),
        "start": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Date", is_backbone_element=False),
                FhirCqlType(name="Concept", is_backbone_element=False),
            ],
        ),
        "target": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Goal_Target", is_backbone_element=True),
        ),
        "statusDate": FhirCqlType(name="Date", is_backbone_element=False),
        "statusReason": FhirCqlType(name="String", is_backbone_element=False),
        "expressedBy": FhirCqlType(name="Reference", is_backbone_element=True),
        "addresses": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "note": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Annotation", is_backbone_element=True),
        ),
        "outcomeCode": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "outcomeReference": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
    },
    "GraphDefinition": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "url": FhirCqlType(name="String", is_backbone_element=False),
        "version": FhirCqlType(name="String", is_backbone_element=False),
        "name": FhirCqlType(name="String", is_backbone_element=False),
        "status": FhirCqlType(name="String", is_backbone_element=False),
        "experimental": FhirCqlType(name="Boolean", is_backbone_element=False),
        "date": FhirCqlType(name="DateTime", is_backbone_element=False),
        "publisher": FhirCqlType(name="String", is_backbone_element=False),
        "contact": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactDetail", is_backbone_element=True),
        ),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "useContext": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="UsageContext", is_backbone_element=True),
        ),
        "jurisdiction": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "purpose": FhirCqlType(name="String", is_backbone_element=False),
        "start": FhirCqlType(name="Code", is_backbone_element=False),
        "profile": FhirCqlType(name="String", is_backbone_element=False),
        "link": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="GraphDefinition_Link", is_backbone_element=True
            ),
        ),
    },
    "Group": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "active": FhirCqlType(name="Boolean", is_backbone_element=False),
        "type": FhirCqlType(name="String", is_backbone_element=False),
        "actual": FhirCqlType(name="Boolean", is_backbone_element=False),
        "code": FhirCqlType(name="Concept", is_backbone_element=False),
        "name": FhirCqlType(name="String", is_backbone_element=False),
        "quantity": FhirCqlType(name="String", is_backbone_element=False),
        "managingEntity": FhirCqlType(name="Reference", is_backbone_element=True),
        "characteristic": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="Group_Characteristic", is_backbone_element=True
            ),
        ),
        "member": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Group_Member", is_backbone_element=True),
        ),
    },
    "GuidanceResponse": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "requestIdentifier": FhirCqlType(name="Identifier", is_backbone_element=True),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "module": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Concept", is_backbone_element=False),
                FhirCqlType(name="String", is_backbone_element=False),
            ],
        ),
        "status": FhirCqlType(name="String", is_backbone_element=False),
        "subject": FhirCqlType(name="Reference", is_backbone_element=True),
        "encounter": FhirCqlType(name="Reference", is_backbone_element=True),
        "occurrenceDateTime": FhirCqlType(name="DateTime", is_backbone_element=False),
        "performer": FhirCqlType(name="Reference", is_backbone_element=True),
        "reasonCode": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "reasonReference": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "note": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Annotation", is_backbone_element=True),
        ),
        "evaluationMessage": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "outputParameters": FhirCqlType(name="Reference", is_backbone_element=True),
        "result": FhirCqlType(name="Reference", is_backbone_element=True),
        "dataRequirement": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="DataRequirement", is_backbone_element=True),
        ),
    },
    "HealthcareService": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "active": FhirCqlType(name="Boolean", is_backbone_element=False),
        "providedBy": FhirCqlType(name="Reference", is_backbone_element=True),
        "category": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "type": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "specialty": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "location": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "name": FhirCqlType(name="String", is_backbone_element=False),
        "comment": FhirCqlType(name="String", is_backbone_element=False),
        "extraDetails": FhirCqlType(name="String", is_backbone_element=False),
        "photo": FhirCqlType(name="Attachment", is_backbone_element=True),
        "telecom": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactPoint", is_backbone_element=True),
        ),
        "coverageArea": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "serviceProvisionCode": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "eligibility": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="HealthcareService_Eligibility", is_backbone_element=True
            ),
        ),
        "program": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "characteristic": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "communication": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "referralMethod": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "appointmentRequired": FhirCqlType(name="Boolean", is_backbone_element=False),
        "availableTime": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="HealthcareService_AvailableTime", is_backbone_element=True
            ),
        ),
        "notAvailable": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="HealthcareService_NotAvailable", is_backbone_element=True
            ),
        ),
        "availabilityExceptions": FhirCqlType(name="String", is_backbone_element=False),
        "endpoint": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
    },
    "ImagingStudy": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "status": FhirCqlType(name="String", is_backbone_element=False),
        "modality": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Code", is_backbone_element=False),
        ),
        "subject": FhirCqlType(name="Reference", is_backbone_element=True),
        "encounter": FhirCqlType(name="Reference", is_backbone_element=True),
        "started": FhirCqlType(name="DateTime", is_backbone_element=False),
        "basedOn": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "referrer": FhirCqlType(name="Reference", is_backbone_element=True),
        "interpreter": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "endpoint": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "numberOfSeries": FhirCqlType(name="String", is_backbone_element=False),
        "numberOfInstances": FhirCqlType(name="String", is_backbone_element=False),
        "procedureReference": FhirCqlType(name="Reference", is_backbone_element=True),
        "procedureCode": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "location": FhirCqlType(name="Reference", is_backbone_element=True),
        "reasonCode": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "reasonReference": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "note": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Annotation", is_backbone_element=True),
        ),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "series": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ImagingStudy_Series", is_backbone_element=True),
        ),
    },
    "Immunization": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "status": FhirCqlType(name="Code", is_backbone_element=False),
        "statusReason": FhirCqlType(name="Concept", is_backbone_element=False),
        "vaccineCode": FhirCqlType(name="Concept", is_backbone_element=False),
        "patient": FhirCqlType(name="Reference", is_backbone_element=True),
        "encounter": FhirCqlType(name="Reference", is_backbone_element=True),
        "occurrence": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="String", is_backbone_element=False),
                FhirCqlType(name="DateTime", is_backbone_element=False),
            ],
        ),
        "recorded": FhirCqlType(name="DateTime", is_backbone_element=False),
        "primarySource": FhirCqlType(name="Boolean", is_backbone_element=False),
        "reportOrigin": FhirCqlType(name="Concept", is_backbone_element=False),
        "location": FhirCqlType(name="Reference", is_backbone_element=True),
        "manufacturer": FhirCqlType(name="Reference", is_backbone_element=True),
        "lotNumber": FhirCqlType(name="String", is_backbone_element=False),
        "expirationDate": FhirCqlType(name="Date", is_backbone_element=False),
        "site": FhirCqlType(name="Concept", is_backbone_element=False),
        "route": FhirCqlType(name="Concept", is_backbone_element=False),
        "doseQuantity": FhirCqlType(name="Decimal", is_backbone_element=False),
        "performer": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="Immunization_Performer", is_backbone_element=True
            ),
        ),
        "note": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Annotation", is_backbone_element=True),
        ),
        "reasonCode": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "reasonReference": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "isSubpotent": FhirCqlType(name="Boolean", is_backbone_element=False),
        "subpotentReason": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "education": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="Immunization_Education", is_backbone_element=True
            ),
        ),
        "programEligibility": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "fundingSource": FhirCqlType(name="Concept", is_backbone_element=False),
        "reaction": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="Immunization_Reaction", is_backbone_element=True
            ),
        ),
        "protocolApplied": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="Immunization_ProtocolApplied", is_backbone_element=True
            ),
        ),
    },
    "ImmunizationEvaluation": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "status": FhirCqlType(name="Code", is_backbone_element=False),
        "patient": FhirCqlType(name="Reference", is_backbone_element=True),
        "date": FhirCqlType(name="DateTime", is_backbone_element=False),
        "authority": FhirCqlType(name="Reference", is_backbone_element=True),
        "targetDisease": FhirCqlType(name="Concept", is_backbone_element=False),
        "immunizationEvent": FhirCqlType(name="Reference", is_backbone_element=True),
        "doseStatus": FhirCqlType(name="Concept", is_backbone_element=False),
        "doseStatusReason": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "series": FhirCqlType(name="String", is_backbone_element=False),
        "doseNumber": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[FhirCqlType(name="String", is_backbone_element=False)],
        ),
        "seriesDoses": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[FhirCqlType(name="String", is_backbone_element=False)],
        ),
    },
    "ImmunizationRecommendation": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "patient": FhirCqlType(name="Reference", is_backbone_element=True),
        "date": FhirCqlType(name="DateTime", is_backbone_element=False),
        "authority": FhirCqlType(name="Reference", is_backbone_element=True),
        "recommendation": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ImmunizationRecommendation_Recommendation",
                is_backbone_element=True,
            ),
        ),
    },
    "ImplementationGuide": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "url": FhirCqlType(name="String", is_backbone_element=False),
        "version": FhirCqlType(name="String", is_backbone_element=False),
        "name": FhirCqlType(name="String", is_backbone_element=False),
        "title": FhirCqlType(name="String", is_backbone_element=False),
        "status": FhirCqlType(name="String", is_backbone_element=False),
        "experimental": FhirCqlType(name="Boolean", is_backbone_element=False),
        "date": FhirCqlType(name="DateTime", is_backbone_element=False),
        "publisher": FhirCqlType(name="String", is_backbone_element=False),
        "contact": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactDetail", is_backbone_element=True),
        ),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "useContext": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="UsageContext", is_backbone_element=True),
        ),
        "jurisdiction": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "copyright": FhirCqlType(name="String", is_backbone_element=False),
        "packageId": FhirCqlType(name="String", is_backbone_element=False),
        "license": FhirCqlType(name="String", is_backbone_element=False),
        "fhirVersion": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "dependsOn": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ImplementationGuide_DependsOn", is_backbone_element=True
            ),
        ),
        "global": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ImplementationGuide_Global", is_backbone_element=True
            ),
        ),
        "definition": FhirCqlType(
            name="ImplementationGuide_Definition", is_backbone_element=True
        ),
        "manifest": FhirCqlType(
            name="ImplementationGuide_Manifest", is_backbone_element=True
        ),
    },
    "InsurancePlan": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "status": FhirCqlType(name="String", is_backbone_element=False),
        "type": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "name": FhirCqlType(name="String", is_backbone_element=False),
        "alias": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "period": FhirInterval(
            name="Interval",
            is_backbone_element=False,
            item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
        ),
        "ownedBy": FhirCqlType(name="Reference", is_backbone_element=True),
        "administeredBy": FhirCqlType(name="Reference", is_backbone_element=True),
        "coverageArea": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "contact": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="InsurancePlan_Contact", is_backbone_element=True
            ),
        ),
        "endpoint": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "network": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "coverage": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="InsurancePlan_Coverage", is_backbone_element=True
            ),
        ),
        "plan": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="InsurancePlan_Plan", is_backbone_element=True),
        ),
    },
    "Invoice": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "status": FhirCqlType(name="String", is_backbone_element=False),
        "cancelledReason": FhirCqlType(name="String", is_backbone_element=False),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "subject": FhirCqlType(name="Reference", is_backbone_element=True),
        "recipient": FhirCqlType(name="Reference", is_backbone_element=True),
        "date": FhirCqlType(name="DateTime", is_backbone_element=False),
        "participant": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Invoice_Participant", is_backbone_element=True),
        ),
        "issuer": FhirCqlType(name="Reference", is_backbone_element=True),
        "account": FhirCqlType(name="Reference", is_backbone_element=True),
        "lineItem": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Invoice_LineItem", is_backbone_element=True),
        ),
        "totalPriceComponent": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="Invoice_PriceComponent", is_backbone_element=True
            ),
        ),
        "totalNet": FhirCqlType(name="Money", is_backbone_element=True),
        "totalGross": FhirCqlType(name="Money", is_backbone_element=True),
        "paymentTerms": FhirCqlType(name="String", is_backbone_element=False),
        "note": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Annotation", is_backbone_element=True),
        ),
    },
    "Library": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "url": FhirCqlType(name="String", is_backbone_element=False),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "version": FhirCqlType(name="String", is_backbone_element=False),
        "name": FhirCqlType(name="String", is_backbone_element=False),
        "title": FhirCqlType(name="String", is_backbone_element=False),
        "subtitle": FhirCqlType(name="String", is_backbone_element=False),
        "status": FhirCqlType(name="String", is_backbone_element=False),
        "experimental": FhirCqlType(name="Boolean", is_backbone_element=False),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "subject": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Concept", is_backbone_element=False),
                FhirCqlType(name="Reference", is_backbone_element=True),
            ],
        ),
        "date": FhirCqlType(name="DateTime", is_backbone_element=False),
        "publisher": FhirCqlType(name="String", is_backbone_element=False),
        "contact": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactDetail", is_backbone_element=True),
        ),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "useContext": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="UsageContext", is_backbone_element=True),
        ),
        "jurisdiction": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "purpose": FhirCqlType(name="String", is_backbone_element=False),
        "usage": FhirCqlType(name="String", is_backbone_element=False),
        "copyright": FhirCqlType(name="String", is_backbone_element=False),
        "approvalDate": FhirCqlType(name="Date", is_backbone_element=False),
        "lastReviewDate": FhirCqlType(name="Date", is_backbone_element=False),
        "effectivePeriod": FhirInterval(
            name="Interval",
            is_backbone_element=False,
            item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
        ),
        "topic": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "author": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactDetail", is_backbone_element=True),
        ),
        "editor": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactDetail", is_backbone_element=True),
        ),
        "reviewer": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactDetail", is_backbone_element=True),
        ),
        "endorser": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactDetail", is_backbone_element=True),
        ),
        "relatedArtifact": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="RelatedArtifact", is_backbone_element=True),
        ),
        "parameter": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ParameterDefinition", is_backbone_element=True),
        ),
        "dataRequirement": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="DataRequirement", is_backbone_element=True),
        ),
        "content": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Attachment", is_backbone_element=True),
        ),
    },
    "Linkage": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "active": FhirCqlType(name="Boolean", is_backbone_element=False),
        "author": FhirCqlType(name="Reference", is_backbone_element=True),
        "item": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Linkage_Item", is_backbone_element=True),
        ),
    },
    "List": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "status": FhirCqlType(name="String", is_backbone_element=False),
        "mode": FhirCqlType(name="String", is_backbone_element=False),
        "title": FhirCqlType(name="String", is_backbone_element=False),
        "code": FhirCqlType(name="Concept", is_backbone_element=False),
        "subject": FhirCqlType(name="Reference", is_backbone_element=True),
        "encounter": FhirCqlType(name="Reference", is_backbone_element=True),
        "date": FhirCqlType(name="DateTime", is_backbone_element=False),
        "source": FhirCqlType(name="Reference", is_backbone_element=True),
        "orderedBy": FhirCqlType(name="Concept", is_backbone_element=False),
        "note": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Annotation", is_backbone_element=True),
        ),
        "entry": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="List_Entry", is_backbone_element=True),
        ),
        "emptyReason": FhirCqlType(name="Concept", is_backbone_element=False),
    },
    "Location": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "status": FhirCqlType(name="String", is_backbone_element=False),
        "operationalStatus": FhirCqlType(name="Code", is_backbone_element=False),
        "name": FhirCqlType(name="String", is_backbone_element=False),
        "alias": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "mode": FhirCqlType(name="String", is_backbone_element=False),
        "type": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "telecom": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactPoint", is_backbone_element=True),
        ),
        "address": FhirCqlType(name="Address", is_backbone_element=True),
        "physicalType": FhirCqlType(name="Concept", is_backbone_element=False),
        "position": FhirCqlType(name="Location_Position", is_backbone_element=True),
        "managingOrganization": FhirCqlType(name="Reference", is_backbone_element=True),
        "partOf": FhirCqlType(name="Reference", is_backbone_element=True),
        "hoursOfOperation": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="Location_HoursOfOperation", is_backbone_element=True
            ),
        ),
        "availabilityExceptions": FhirCqlType(name="String", is_backbone_element=False),
        "endpoint": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
    },
    "Measure": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "url": FhirCqlType(name="String", is_backbone_element=False),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "version": FhirCqlType(name="String", is_backbone_element=False),
        "name": FhirCqlType(name="String", is_backbone_element=False),
        "title": FhirCqlType(name="String", is_backbone_element=False),
        "subtitle": FhirCqlType(name="String", is_backbone_element=False),
        "status": FhirCqlType(name="String", is_backbone_element=False),
        "experimental": FhirCqlType(name="Boolean", is_backbone_element=False),
        "subject": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Concept", is_backbone_element=False),
                FhirCqlType(name="Reference", is_backbone_element=True),
            ],
        ),
        "date": FhirCqlType(name="DateTime", is_backbone_element=False),
        "publisher": FhirCqlType(name="String", is_backbone_element=False),
        "contact": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactDetail", is_backbone_element=True),
        ),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "useContext": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="UsageContext", is_backbone_element=True),
        ),
        "jurisdiction": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "purpose": FhirCqlType(name="String", is_backbone_element=False),
        "usage": FhirCqlType(name="String", is_backbone_element=False),
        "copyright": FhirCqlType(name="String", is_backbone_element=False),
        "approvalDate": FhirCqlType(name="Date", is_backbone_element=False),
        "lastReviewDate": FhirCqlType(name="Date", is_backbone_element=False),
        "effectivePeriod": FhirInterval(
            name="Interval",
            is_backbone_element=False,
            item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
        ),
        "topic": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "author": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactDetail", is_backbone_element=True),
        ),
        "editor": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactDetail", is_backbone_element=True),
        ),
        "reviewer": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactDetail", is_backbone_element=True),
        ),
        "endorser": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactDetail", is_backbone_element=True),
        ),
        "relatedArtifact": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="RelatedArtifact", is_backbone_element=True),
        ),
        "library": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "disclaimer": FhirCqlType(name="String", is_backbone_element=False),
        "scoring": FhirCqlType(name="Concept", is_backbone_element=False),
        "compositeScoring": FhirCqlType(name="Concept", is_backbone_element=False),
        "type": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "riskAdjustment": FhirCqlType(name="String", is_backbone_element=False),
        "rateAggregation": FhirCqlType(name="String", is_backbone_element=False),
        "rationale": FhirCqlType(name="String", is_backbone_element=False),
        "clinicalRecommendationStatement": FhirCqlType(
            name="String", is_backbone_element=False
        ),
        "improvementNotation": FhirCqlType(name="Concept", is_backbone_element=False),
        "definition": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "guidance": FhirCqlType(name="String", is_backbone_element=False),
        "group": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Measure_Group", is_backbone_element=True),
        ),
        "supplementalData": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="Measure_SupplementalData", is_backbone_element=True
            ),
        ),
    },
    "MeasureReport": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "status": FhirCqlType(name="String", is_backbone_element=False),
        "type": FhirCqlType(name="String", is_backbone_element=False),
        "measure": FhirCqlType(name="String", is_backbone_element=False),
        "subject": FhirCqlType(name="Reference", is_backbone_element=True),
        "date": FhirCqlType(name="DateTime", is_backbone_element=False),
        "reporter": FhirCqlType(name="Reference", is_backbone_element=True),
        "period": FhirInterval(
            name="Interval",
            is_backbone_element=False,
            item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
        ),
        "improvementNotation": FhirCqlType(name="Concept", is_backbone_element=False),
        "group": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="MeasureReport_Group", is_backbone_element=True),
        ),
        "evaluatedResource": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
    },
    "Media": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "basedOn": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "partOf": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "status": FhirCqlType(name="Code", is_backbone_element=False),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "modality": FhirCqlType(name="Concept", is_backbone_element=False),
        "view": FhirCqlType(name="Concept", is_backbone_element=False),
        "subject": FhirCqlType(name="Reference", is_backbone_element=True),
        "encounter": FhirCqlType(name="Reference", is_backbone_element=True),
        "created": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
                ),
                FhirCqlType(name="DateTime", is_backbone_element=False),
            ],
        ),
        "issued": FhirCqlType(name="String", is_backbone_element=False),
        "operator": FhirCqlType(name="Reference", is_backbone_element=True),
        "reasonCode": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "bodySite": FhirCqlType(name="Concept", is_backbone_element=False),
        "deviceName": FhirCqlType(name="String", is_backbone_element=False),
        "device": FhirCqlType(name="Reference", is_backbone_element=True),
        "height": FhirCqlType(name="String", is_backbone_element=False),
        "width": FhirCqlType(name="String", is_backbone_element=False),
        "frames": FhirCqlType(name="String", is_backbone_element=False),
        "duration": FhirCqlType(name="Decimal", is_backbone_element=False),
        "content": FhirCqlType(name="Attachment", is_backbone_element=True),
        "note": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Annotation", is_backbone_element=True),
        ),
    },
    "Medication": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "code": FhirCqlType(name="Concept", is_backbone_element=False),
        "status": FhirCqlType(name="Code", is_backbone_element=False),
        "manufacturer": FhirCqlType(name="Reference", is_backbone_element=True),
        "form": FhirCqlType(name="Concept", is_backbone_element=False),
        "amount": FhirCqlType(name="Ratio", is_backbone_element=True),
        "ingredient": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="Medication_Ingredient", is_backbone_element=True
            ),
        ),
        "batch": FhirCqlType(name="Medication_Batch", is_backbone_element=True),
    },
    "MedicationAdministration": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "instantiates": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "partOf": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "status": FhirCqlType(name="Code", is_backbone_element=False),
        "statusReason": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "category": FhirCqlType(name="Concept", is_backbone_element=False),
        "medication": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Concept", is_backbone_element=False),
                FhirCqlType(name="Reference", is_backbone_element=True),
            ],
        ),
        "subject": FhirCqlType(name="Reference", is_backbone_element=True),
        "context": FhirCqlType(name="Reference", is_backbone_element=True),
        "supportingInformation": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "effective": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
                ),
                FhirCqlType(name="DateTime", is_backbone_element=False),
            ],
        ),
        "performer": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="MedicationAdministration_Performer", is_backbone_element=True
            ),
        ),
        "reasonCode": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "reasonReference": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "request": FhirCqlType(name="Reference", is_backbone_element=True),
        "device": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "note": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Annotation", is_backbone_element=True),
        ),
        "dosage": FhirCqlType(
            name="MedicationAdministration_Dosage", is_backbone_element=True
        ),
        "eventHistory": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
    },
    "MedicationDispense": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "partOf": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "status": FhirCqlType(name="Code", is_backbone_element=False),
        "statusReason": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Concept", is_backbone_element=False),
                FhirCqlType(name="Reference", is_backbone_element=True),
            ],
        ),
        "category": FhirCqlType(name="Concept", is_backbone_element=False),
        "medication": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Concept", is_backbone_element=False),
                FhirCqlType(name="Reference", is_backbone_element=True),
            ],
        ),
        "subject": FhirCqlType(name="Reference", is_backbone_element=True),
        "context": FhirCqlType(name="Reference", is_backbone_element=True),
        "supportingInformation": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "performer": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="MedicationDispense_Performer", is_backbone_element=True
            ),
        ),
        "location": FhirCqlType(name="Reference", is_backbone_element=True),
        "authorizingPrescription": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "quantity": FhirCqlType(name="Decimal", is_backbone_element=False),
        "daysSupply": FhirCqlType(name="Decimal", is_backbone_element=False),
        "whenPrepared": FhirCqlType(name="DateTime", is_backbone_element=False),
        "whenHandedOver": FhirCqlType(name="DateTime", is_backbone_element=False),
        "destination": FhirCqlType(name="Reference", is_backbone_element=True),
        "receiver": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "note": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Annotation", is_backbone_element=True),
        ),
        "dosageInstruction": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Dosage", is_backbone_element=True),
        ),
        "substitution": FhirCqlType(
            name="MedicationDispense_Substitution", is_backbone_element=True
        ),
        "detectedIssue": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "eventHistory": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
    },
    "MedicationKnowledge": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "code": FhirCqlType(name="Concept", is_backbone_element=False),
        "status": FhirCqlType(name="Code", is_backbone_element=False),
        "manufacturer": FhirCqlType(name="Reference", is_backbone_element=True),
        "doseForm": FhirCqlType(name="Concept", is_backbone_element=False),
        "amount": FhirCqlType(name="Decimal", is_backbone_element=False),
        "synonym": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "relatedMedicationKnowledge": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="MedicationKnowledge_RelatedMedicationKnowledge",
                is_backbone_element=True,
            ),
        ),
        "associatedMedication": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "productType": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "monograph": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="MedicationKnowledge_Monograph", is_backbone_element=True
            ),
        ),
        "ingredient": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="MedicationKnowledge_Ingredient", is_backbone_element=True
            ),
        ),
        "preparationInstruction": FhirCqlType(name="String", is_backbone_element=False),
        "intendedRoute": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "cost": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="MedicationKnowledge_Cost", is_backbone_element=True
            ),
        ),
        "monitoringProgram": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="MedicationKnowledge_MonitoringProgram", is_backbone_element=True
            ),
        ),
        "administrationGuidelines": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="MedicationKnowledge_AdministrationGuidelines",
                is_backbone_element=True,
            ),
        ),
        "medicineClassification": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="MedicationKnowledge_MedicineClassification",
                is_backbone_element=True,
            ),
        ),
        "packaging": FhirCqlType(
            name="MedicationKnowledge_Packaging", is_backbone_element=True
        ),
        "drugCharacteristic": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="MedicationKnowledge_DrugCharacteristic", is_backbone_element=True
            ),
        ),
        "contraindication": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "regulatory": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="MedicationKnowledge_Regulatory", is_backbone_element=True
            ),
        ),
        "kinetics": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="MedicationKnowledge_Kinetics", is_backbone_element=True
            ),
        ),
    },
    "MedicationRequest": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "status": FhirCqlType(name="Code", is_backbone_element=False),
        "statusReason": FhirCqlType(name="Concept", is_backbone_element=False),
        "intent": FhirCqlType(name="Code", is_backbone_element=False),
        "category": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "priority": FhirCqlType(name="Code", is_backbone_element=False),
        "doNotPerform": FhirCqlType(name="Boolean", is_backbone_element=False),
        "reported": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Boolean", is_backbone_element=False),
                FhirCqlType(name="Reference", is_backbone_element=True),
            ],
        ),
        "medication": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Concept", is_backbone_element=False),
                FhirCqlType(name="Reference", is_backbone_element=True),
            ],
        ),
        "subject": FhirCqlType(name="Reference", is_backbone_element=True),
        "encounter": FhirCqlType(name="Reference", is_backbone_element=True),
        "supportingInformation": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "authoredOn": FhirCqlType(name="DateTime", is_backbone_element=False),
        "requester": FhirCqlType(name="Reference", is_backbone_element=True),
        "performer": FhirCqlType(name="Reference", is_backbone_element=True),
        "performerType": FhirCqlType(name="Concept", is_backbone_element=False),
        "recorder": FhirCqlType(name="Reference", is_backbone_element=True),
        "reasonCode": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "reasonReference": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "instantiatesCanonical": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "instantiatesUri": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "basedOn": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "groupIdentifier": FhirCqlType(name="Identifier", is_backbone_element=True),
        "courseOfTherapyType": FhirCqlType(name="Concept", is_backbone_element=False),
        "insurance": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "note": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Annotation", is_backbone_element=True),
        ),
        "dosageInstruction": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Dosage", is_backbone_element=True),
        ),
        "dispenseRequest": FhirCqlType(
            name="MedicationRequest_DispenseRequest", is_backbone_element=True
        ),
        "substitution": FhirCqlType(
            name="MedicationRequest_Substitution", is_backbone_element=True
        ),
        "priorPrescription": FhirCqlType(name="Reference", is_backbone_element=True),
        "detectedIssue": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "eventHistory": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
    },
    "MedicationStatement": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "basedOn": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "partOf": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "status": FhirCqlType(name="Code", is_backbone_element=False),
        "statusReason": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "category": FhirCqlType(name="Concept", is_backbone_element=False),
        "medication": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Concept", is_backbone_element=False),
                FhirCqlType(name="Reference", is_backbone_element=True),
            ],
        ),
        "subject": FhirCqlType(name="Reference", is_backbone_element=True),
        "context": FhirCqlType(name="Reference", is_backbone_element=True),
        "effective": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
                ),
                FhirCqlType(name="DateTime", is_backbone_element=False),
            ],
        ),
        "dateAsserted": FhirCqlType(name="DateTime", is_backbone_element=False),
        "informationSource": FhirCqlType(name="Reference", is_backbone_element=True),
        "derivedFrom": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "reasonCode": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "reasonReference": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "note": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Annotation", is_backbone_element=True),
        ),
        "dosage": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Dosage", is_backbone_element=True),
        ),
    },
    "MedicinalProduct": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "domain": FhirCqlType(name="Code", is_backbone_element=False),
        "combinedPharmaceuticalDoseForm": FhirCqlType(
            name="Concept", is_backbone_element=False
        ),
        "legalStatusOfSupply": FhirCqlType(name="Concept", is_backbone_element=False),
        "additionalMonitoringIndicator": FhirCqlType(
            name="Concept", is_backbone_element=False
        ),
        "specialMeasures": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "paediatricUseIndicator": FhirCqlType(
            name="Concept", is_backbone_element=False
        ),
        "productClassification": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "marketingStatus": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="MarketingStatus", is_backbone_element=True),
        ),
        "pharmaceuticalProduct": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "packagedMedicinalProduct": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "attachedDocument": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "masterFile": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "contact": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "clinicalTrial": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "name": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="MedicinalProduct_Name", is_backbone_element=True
            ),
        ),
        "crossReference": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "manufacturingBusinessOperation": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="MedicinalProduct_ManufacturingBusinessOperation",
                is_backbone_element=True,
            ),
        ),
        "specialDesignation": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="MedicinalProduct_SpecialDesignation", is_backbone_element=True
            ),
        ),
    },
    "MedicinalProductAuthorization": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "subject": FhirCqlType(name="Reference", is_backbone_element=True),
        "country": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "jurisdiction": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "status": FhirCqlType(name="Concept", is_backbone_element=False),
        "statusDate": FhirCqlType(name="DateTime", is_backbone_element=False),
        "restoreDate": FhirCqlType(name="DateTime", is_backbone_element=False),
        "validityPeriod": FhirInterval(
            name="Interval",
            is_backbone_element=False,
            item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
        ),
        "dataExclusivityPeriod": FhirInterval(
            name="Interval",
            is_backbone_element=False,
            item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
        ),
        "dateOfFirstAuthorization": FhirCqlType(
            name="DateTime", is_backbone_element=False
        ),
        "internationalBirthDate": FhirCqlType(
            name="DateTime", is_backbone_element=False
        ),
        "legalBasis": FhirCqlType(name="Concept", is_backbone_element=False),
        "jurisdictionalAuthorization": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="MedicinalProductAuthorization_JurisdictionalAuthorization",
                is_backbone_element=True,
            ),
        ),
        "holder": FhirCqlType(name="Reference", is_backbone_element=True),
        "regulator": FhirCqlType(name="Reference", is_backbone_element=True),
        "procedure": FhirCqlType(
            name="MedicinalProductAuthorization_Procedure", is_backbone_element=True
        ),
    },
    "MedicinalProductContraindication": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "subject": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "disease": FhirCqlType(name="Concept", is_backbone_element=False),
        "diseaseStatus": FhirCqlType(name="Concept", is_backbone_element=False),
        "comorbidity": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "therapeuticIndication": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "otherTherapy": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="MedicinalProductContraindication_OtherTherapy",
                is_backbone_element=True,
            ),
        ),
        "population": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Population", is_backbone_element=True),
        ),
    },
    "MedicinalProductIndication": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "subject": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "diseaseSymptomProcedure": FhirCqlType(
            name="Concept", is_backbone_element=False
        ),
        "diseaseStatus": FhirCqlType(name="Concept", is_backbone_element=False),
        "comorbidity": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "intendedEffect": FhirCqlType(name="Concept", is_backbone_element=False),
        "duration": FhirCqlType(name="Decimal", is_backbone_element=False),
        "otherTherapy": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="MedicinalProductIndication_OtherTherapy", is_backbone_element=True
            ),
        ),
        "undesirableEffect": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "population": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Population", is_backbone_element=True),
        ),
    },
    "MedicinalProductIngredient": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirCqlType(name="Identifier", is_backbone_element=True),
        "role": FhirCqlType(name="Concept", is_backbone_element=False),
        "allergenicIndicator": FhirCqlType(name="Boolean", is_backbone_element=False),
        "manufacturer": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "specifiedSubstance": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="MedicinalProductIngredient_SpecifiedSubstance",
                is_backbone_element=True,
            ),
        ),
        "substance": FhirCqlType(
            name="MedicinalProductIngredient_Substance", is_backbone_element=True
        ),
    },
    "MedicinalProductInteraction": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "subject": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "interactant": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="MedicinalProductInteraction_Interactant", is_backbone_element=True
            ),
        ),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "effect": FhirCqlType(name="Concept", is_backbone_element=False),
        "incidence": FhirCqlType(name="Concept", is_backbone_element=False),
        "management": FhirCqlType(name="Concept", is_backbone_element=False),
    },
    "MedicinalProductManufactured": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "manufacturedDoseForm": FhirCqlType(name="Concept", is_backbone_element=False),
        "unitOfPresentation": FhirCqlType(name="Concept", is_backbone_element=False),
        "quantity": FhirCqlType(name="Decimal", is_backbone_element=False),
        "manufacturer": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "ingredient": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "physicalCharacteristics": FhirCqlType(
            name="ProdCharacteristic", is_backbone_element=True
        ),
        "otherCharacteristics": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
    },
    "MedicinalProductPackaged": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "subject": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "legalStatusOfSupply": FhirCqlType(name="Concept", is_backbone_element=False),
        "marketingStatus": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="MarketingStatus", is_backbone_element=True),
        ),
        "ma": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Reference", is_backbone_element=True),
                FhirList(
                    name="List",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="Reference", is_backbone_element=True),
                ),
            ],
        ),
        "batchIdentifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="MedicinalProductPackaged_BatchIdentifier",
                is_backbone_element=True,
            ),
        ),
        "packageItem": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="MedicinalProductPackaged_PackageItem", is_backbone_element=True
            ),
        ),
    },
    "MedicinalProductPharmaceutical": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "administrableDoseForm": FhirCqlType(name="Concept", is_backbone_element=False),
        "unitOfPresentation": FhirCqlType(name="Concept", is_backbone_element=False),
        "ingredient": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "device": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "characteristics": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="MedicinalProductPharmaceutical_Characteristics",
                is_backbone_element=True,
            ),
        ),
        "routeOfAdministration": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="MedicinalProductPharmaceutical_RouteOfAdministration",
                is_backbone_element=True,
            ),
        ),
    },
    "MedicinalProductUndesirableEffect": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "subject": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "symptomConditionEffect": FhirCqlType(
            name="Concept", is_backbone_element=False
        ),
        "classification": FhirCqlType(name="Concept", is_backbone_element=False),
        "frequencyOfOccurrence": FhirCqlType(name="Concept", is_backbone_element=False),
        "population": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Population", is_backbone_element=True),
        ),
    },
    "MessageDefinition": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "url": FhirCqlType(name="String", is_backbone_element=False),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "version": FhirCqlType(name="String", is_backbone_element=False),
        "name": FhirCqlType(name="String", is_backbone_element=False),
        "title": FhirCqlType(name="String", is_backbone_element=False),
        "replaces": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "status": FhirCqlType(name="String", is_backbone_element=False),
        "experimental": FhirCqlType(name="Boolean", is_backbone_element=False),
        "date": FhirCqlType(name="DateTime", is_backbone_element=False),
        "publisher": FhirCqlType(name="String", is_backbone_element=False),
        "contact": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactDetail", is_backbone_element=True),
        ),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "useContext": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="UsageContext", is_backbone_element=True),
        ),
        "jurisdiction": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "purpose": FhirCqlType(name="String", is_backbone_element=False),
        "copyright": FhirCqlType(name="String", is_backbone_element=False),
        "base": FhirCqlType(name="String", is_backbone_element=False),
        "parent": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "event": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Code", is_backbone_element=False),
                FhirCqlType(name="String", is_backbone_element=False),
            ],
        ),
        "category": FhirCqlType(name="String", is_backbone_element=False),
        "focus": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="MessageDefinition_Focus", is_backbone_element=True
            ),
        ),
        "responseRequired": FhirCqlType(name="String", is_backbone_element=False),
        "allowedResponse": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="MessageDefinition_AllowedResponse", is_backbone_element=True
            ),
        ),
        "graph": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
    },
    "MessageHeader": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "event": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Code", is_backbone_element=False),
                FhirCqlType(name="String", is_backbone_element=False),
            ],
        ),
        "destination": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="MessageHeader_Destination", is_backbone_element=True
            ),
        ),
        "sender": FhirCqlType(name="Reference", is_backbone_element=True),
        "enterer": FhirCqlType(name="Reference", is_backbone_element=True),
        "author": FhirCqlType(name="Reference", is_backbone_element=True),
        "source": FhirCqlType(name="MessageHeader_Source", is_backbone_element=True),
        "responsible": FhirCqlType(name="Reference", is_backbone_element=True),
        "reason": FhirCqlType(name="Concept", is_backbone_element=False),
        "response": FhirCqlType(
            name="MessageHeader_Response", is_backbone_element=True
        ),
        "focus": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "definition": FhirCqlType(name="String", is_backbone_element=False),
    },
    "MolecularSequence": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "type": FhirCqlType(name="String", is_backbone_element=False),
        "coordinateSystem": FhirCqlType(name="Integer", is_backbone_element=False),
        "patient": FhirCqlType(name="Reference", is_backbone_element=True),
        "specimen": FhirCqlType(name="Reference", is_backbone_element=True),
        "device": FhirCqlType(name="Reference", is_backbone_element=True),
        "performer": FhirCqlType(name="Reference", is_backbone_element=True),
        "quantity": FhirCqlType(name="Decimal", is_backbone_element=False),
        "referenceSeq": FhirCqlType(
            name="MolecularSequence_ReferenceSeq", is_backbone_element=True
        ),
        "variant": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="MolecularSequence_Variant", is_backbone_element=True
            ),
        ),
        "observedSeq": FhirCqlType(name="String", is_backbone_element=False),
        "quality": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="MolecularSequence_Quality", is_backbone_element=True
            ),
        ),
        "readCoverage": FhirCqlType(name="Integer", is_backbone_element=False),
        "repository": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="MolecularSequence_Repository", is_backbone_element=True
            ),
        ),
        "pointer": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "structureVariant": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="MolecularSequence_StructureVariant", is_backbone_element=True
            ),
        ),
    },
    "NamingSystem": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "name": FhirCqlType(name="String", is_backbone_element=False),
        "status": FhirCqlType(name="String", is_backbone_element=False),
        "kind": FhirCqlType(name="String", is_backbone_element=False),
        "date": FhirCqlType(name="DateTime", is_backbone_element=False),
        "publisher": FhirCqlType(name="String", is_backbone_element=False),
        "contact": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactDetail", is_backbone_element=True),
        ),
        "responsible": FhirCqlType(name="String", is_backbone_element=False),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "useContext": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="UsageContext", is_backbone_element=True),
        ),
        "jurisdiction": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "usage": FhirCqlType(name="String", is_backbone_element=False),
        "uniqueId": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="NamingSystem_UniqueId", is_backbone_element=True
            ),
        ),
    },
    "NutritionOrder": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "instantiatesCanonical": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "instantiatesUri": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "instantiates": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "status": FhirCqlType(name="Code", is_backbone_element=False),
        "intent": FhirCqlType(name="Code", is_backbone_element=False),
        "patient": FhirCqlType(name="Reference", is_backbone_element=True),
        "encounter": FhirCqlType(name="Reference", is_backbone_element=True),
        "dateTime": FhirCqlType(name="DateTime", is_backbone_element=False),
        "orderer": FhirCqlType(name="Reference", is_backbone_element=True),
        "allergyIntolerance": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "foodPreferenceModifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "excludeFoodModifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "oralDiet": FhirCqlType(
            name="NutritionOrder_OralDiet", is_backbone_element=True
        ),
        "supplement": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="NutritionOrder_Supplement", is_backbone_element=True
            ),
        ),
        "enteralFormula": FhirCqlType(
            name="NutritionOrder_EnteralFormula", is_backbone_element=True
        ),
        "note": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Annotation", is_backbone_element=True),
        ),
    },
    "Observation": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "basedOn": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "partOf": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "status": FhirCqlType(name="String", is_backbone_element=False),
        "category": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "code": FhirCqlType(name="Concept", is_backbone_element=False),
        "subject": FhirCqlType(name="Reference", is_backbone_element=True),
        "focus": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "encounter": FhirCqlType(name="Reference", is_backbone_element=True),
        "effective": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Timing", is_backbone_element=True),
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
                ),
                FhirCqlType(name="String", is_backbone_element=False),
                FhirCqlType(name="DateTime", is_backbone_element=False),
            ],
        ),
        "issued": FhirCqlType(name="String", is_backbone_element=False),
        "performer": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "value": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="Decimal", is_backbone_element=False),
                ),
                FhirCqlType(name="String", is_backbone_element=False),
                FhirCqlType(name="Ratio", is_backbone_element=True),
                FhirCqlType(name="Decimal", is_backbone_element=False),
                FhirCqlType(name="Boolean", is_backbone_element=False),
                FhirCqlType(name="Concept", is_backbone_element=False),
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
                ),
                FhirCqlType(name="SampledData", is_backbone_element=True),
                FhirCqlType(name="DateTime", is_backbone_element=False),
            ],
        ),
        "dataAbsentReason": FhirCqlType(name="Concept", is_backbone_element=False),
        "interpretation": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "note": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Annotation", is_backbone_element=True),
        ),
        "bodySite": FhirCqlType(name="Concept", is_backbone_element=False),
        "method": FhirCqlType(name="Concept", is_backbone_element=False),
        "specimen": FhirCqlType(name="Reference", is_backbone_element=True),
        "device": FhirCqlType(name="Reference", is_backbone_element=True),
        "referenceRange": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="Observation_ReferenceRange", is_backbone_element=True
            ),
        ),
        "hasMember": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "derivedFrom": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "component": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="Observation_Component", is_backbone_element=True
            ),
        ),
    },
    "ObservationDefinition": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "category": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "code": FhirCqlType(name="Concept", is_backbone_element=False),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "permittedDataType": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "multipleResultsAllowed": FhirCqlType(
            name="Boolean", is_backbone_element=False
        ),
        "method": FhirCqlType(name="Concept", is_backbone_element=False),
        "preferredReportName": FhirCqlType(name="String", is_backbone_element=False),
        "quantitativeDetails": FhirCqlType(
            name="ObservationDefinition_QuantitativeDetails", is_backbone_element=True
        ),
        "qualifiedInterval": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ObservationDefinition_QualifiedInterval", is_backbone_element=True
            ),
        ),
        "validCodedValueSet": FhirCqlType(name="Reference", is_backbone_element=True),
        "normalCodedValueSet": FhirCqlType(name="Reference", is_backbone_element=True),
        "abnormalCodedValueSet": FhirCqlType(
            name="Reference", is_backbone_element=True
        ),
        "criticalCodedValueSet": FhirCqlType(
            name="Reference", is_backbone_element=True
        ),
    },
    "OperationDefinition": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "url": FhirCqlType(name="String", is_backbone_element=False),
        "version": FhirCqlType(name="String", is_backbone_element=False),
        "name": FhirCqlType(name="String", is_backbone_element=False),
        "title": FhirCqlType(name="String", is_backbone_element=False),
        "status": FhirCqlType(name="String", is_backbone_element=False),
        "kind": FhirCqlType(name="String", is_backbone_element=False),
        "experimental": FhirCqlType(name="Boolean", is_backbone_element=False),
        "date": FhirCqlType(name="DateTime", is_backbone_element=False),
        "publisher": FhirCqlType(name="String", is_backbone_element=False),
        "contact": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactDetail", is_backbone_element=True),
        ),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "useContext": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="UsageContext", is_backbone_element=True),
        ),
        "jurisdiction": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "purpose": FhirCqlType(name="String", is_backbone_element=False),
        "affectsState": FhirCqlType(name="Boolean", is_backbone_element=False),
        "code": FhirCqlType(name="Code", is_backbone_element=False),
        "comment": FhirCqlType(name="String", is_backbone_element=False),
        "base": FhirCqlType(name="String", is_backbone_element=False),
        "resource": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Code", is_backbone_element=False),
        ),
        "system": FhirCqlType(name="Boolean", is_backbone_element=False),
        "type": FhirCqlType(name="Boolean", is_backbone_element=False),
        "instance": FhirCqlType(name="Boolean", is_backbone_element=False),
        "inputProfile": FhirCqlType(name="String", is_backbone_element=False),
        "outputProfile": FhirCqlType(name="String", is_backbone_element=False),
        "parameter": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="OperationDefinition_Parameter", is_backbone_element=True
            ),
        ),
        "overload": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="OperationDefinition_Overload", is_backbone_element=True
            ),
        ),
    },
    "OperationOutcome": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "issue": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="OperationOutcome_Issue", is_backbone_element=True
            ),
        ),
    },
    "Organization": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "active": FhirCqlType(name="Boolean", is_backbone_element=False),
        "type": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "name": FhirCqlType(name="String", is_backbone_element=False),
        "alias": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "telecom": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactPoint", is_backbone_element=True),
        ),
        "address": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Address", is_backbone_element=True),
        ),
        "partOf": FhirCqlType(name="Reference", is_backbone_element=True),
        "contact": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="Organization_Contact", is_backbone_element=True
            ),
        ),
        "endpoint": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
    },
    "OrganizationAffiliation": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "active": FhirCqlType(name="Boolean", is_backbone_element=False),
        "period": FhirInterval(
            name="Interval",
            is_backbone_element=False,
            item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
        ),
        "organization": FhirCqlType(name="Reference", is_backbone_element=True),
        "participatingOrganization": FhirCqlType(
            name="Reference", is_backbone_element=True
        ),
        "network": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "code": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "specialty": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "location": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "healthcareService": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "telecom": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactPoint", is_backbone_element=True),
        ),
        "endpoint": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
    },
    "Parameters": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "parameter": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="Parameters_Parameter", is_backbone_element=True
            ),
        ),
    },
    "Patient": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "active": FhirCqlType(name="Boolean", is_backbone_element=False),
        "name": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="HumanName", is_backbone_element=True),
        ),
        "telecom": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactPoint", is_backbone_element=True),
        ),
        "gender": FhirCqlType(name="String", is_backbone_element=False),
        "birthDate": FhirCqlType(name="Date", is_backbone_element=False),
        "deceased": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Boolean", is_backbone_element=False),
                FhirCqlType(name="DateTime", is_backbone_element=False),
            ],
        ),
        "address": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Address", is_backbone_element=True),
        ),
        "maritalStatus": FhirCqlType(name="Concept", is_backbone_element=False),
        "multipleBirth": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Boolean", is_backbone_element=False),
                FhirCqlType(name="String", is_backbone_element=False),
            ],
        ),
        "photo": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Attachment", is_backbone_element=True),
        ),
        "contact": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Patient_Contact", is_backbone_element=True),
        ),
        "communication": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="Patient_Communication", is_backbone_element=True
            ),
        ),
        "generalPractitioner": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "managingOrganization": FhirCqlType(name="Reference", is_backbone_element=True),
        "link": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Patient_Link", is_backbone_element=True),
        ),
    },
    "PaymentNotice": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "status": FhirCqlType(name="Code", is_backbone_element=False),
        "request": FhirCqlType(name="Reference", is_backbone_element=True),
        "response": FhirCqlType(name="Reference", is_backbone_element=True),
        "created": FhirCqlType(name="DateTime", is_backbone_element=False),
        "provider": FhirCqlType(name="Reference", is_backbone_element=True),
        "payment": FhirCqlType(name="Reference", is_backbone_element=True),
        "paymentDate": FhirCqlType(name="Date", is_backbone_element=False),
        "payee": FhirCqlType(name="Reference", is_backbone_element=True),
        "recipient": FhirCqlType(name="Reference", is_backbone_element=True),
        "amount": FhirCqlType(name="Money", is_backbone_element=True),
        "paymentStatus": FhirCqlType(name="Concept", is_backbone_element=False),
    },
    "PaymentReconciliation": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "status": FhirCqlType(name="Code", is_backbone_element=False),
        "period": FhirInterval(
            name="Interval",
            is_backbone_element=False,
            item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
        ),
        "created": FhirCqlType(name="DateTime", is_backbone_element=False),
        "paymentIssuer": FhirCqlType(name="Reference", is_backbone_element=True),
        "request": FhirCqlType(name="Reference", is_backbone_element=True),
        "requestor": FhirCqlType(name="Reference", is_backbone_element=True),
        "outcome": FhirCqlType(name="String", is_backbone_element=False),
        "disposition": FhirCqlType(name="String", is_backbone_element=False),
        "paymentDate": FhirCqlType(name="Date", is_backbone_element=False),
        "paymentAmount": FhirCqlType(name="Money", is_backbone_element=True),
        "paymentIdentifier": FhirCqlType(name="Identifier", is_backbone_element=True),
        "detail": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="PaymentReconciliation_Detail", is_backbone_element=True
            ),
        ),
        "formCode": FhirCqlType(name="Concept", is_backbone_element=False),
        "processNote": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="PaymentReconciliation_ProcessNote", is_backbone_element=True
            ),
        ),
    },
    "Person": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "name": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="HumanName", is_backbone_element=True),
        ),
        "telecom": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactPoint", is_backbone_element=True),
        ),
        "gender": FhirCqlType(name="String", is_backbone_element=False),
        "birthDate": FhirCqlType(name="Date", is_backbone_element=False),
        "address": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Address", is_backbone_element=True),
        ),
        "photo": FhirCqlType(name="Attachment", is_backbone_element=True),
        "managingOrganization": FhirCqlType(name="Reference", is_backbone_element=True),
        "active": FhirCqlType(name="Boolean", is_backbone_element=False),
        "link": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Person_Link", is_backbone_element=True),
        ),
    },
    "PlanDefinition": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "url": FhirCqlType(name="String", is_backbone_element=False),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "version": FhirCqlType(name="String", is_backbone_element=False),
        "name": FhirCqlType(name="String", is_backbone_element=False),
        "title": FhirCqlType(name="String", is_backbone_element=False),
        "subtitle": FhirCqlType(name="String", is_backbone_element=False),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "status": FhirCqlType(name="String", is_backbone_element=False),
        "experimental": FhirCqlType(name="Boolean", is_backbone_element=False),
        "subject": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Concept", is_backbone_element=False),
                FhirCqlType(name="Reference", is_backbone_element=True),
            ],
        ),
        "date": FhirCqlType(name="DateTime", is_backbone_element=False),
        "publisher": FhirCqlType(name="String", is_backbone_element=False),
        "contact": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactDetail", is_backbone_element=True),
        ),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "useContext": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="UsageContext", is_backbone_element=True),
        ),
        "jurisdiction": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "purpose": FhirCqlType(name="String", is_backbone_element=False),
        "usage": FhirCqlType(name="String", is_backbone_element=False),
        "copyright": FhirCqlType(name="String", is_backbone_element=False),
        "approvalDate": FhirCqlType(name="Date", is_backbone_element=False),
        "lastReviewDate": FhirCqlType(name="Date", is_backbone_element=False),
        "effectivePeriod": FhirInterval(
            name="Interval",
            is_backbone_element=False,
            item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
        ),
        "topic": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "author": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactDetail", is_backbone_element=True),
        ),
        "editor": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactDetail", is_backbone_element=True),
        ),
        "reviewer": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactDetail", is_backbone_element=True),
        ),
        "endorser": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactDetail", is_backbone_element=True),
        ),
        "relatedArtifact": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="RelatedArtifact", is_backbone_element=True),
        ),
        "library": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "goal": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="PlanDefinition_Goal", is_backbone_element=True),
        ),
        "action": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="PlanDefinition_Action", is_backbone_element=True
            ),
        ),
    },
    "Practitioner": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "active": FhirCqlType(name="Boolean", is_backbone_element=False),
        "name": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="HumanName", is_backbone_element=True),
        ),
        "telecom": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactPoint", is_backbone_element=True),
        ),
        "address": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Address", is_backbone_element=True),
        ),
        "gender": FhirCqlType(name="String", is_backbone_element=False),
        "birthDate": FhirCqlType(name="Date", is_backbone_element=False),
        "photo": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Attachment", is_backbone_element=True),
        ),
        "qualification": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="Practitioner_Qualification", is_backbone_element=True
            ),
        ),
        "communication": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
    },
    "PractitionerRole": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "active": FhirCqlType(name="Boolean", is_backbone_element=False),
        "period": FhirInterval(
            name="Interval",
            is_backbone_element=False,
            item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
        ),
        "practitioner": FhirCqlType(name="Reference", is_backbone_element=True),
        "organization": FhirCqlType(name="Reference", is_backbone_element=True),
        "code": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "specialty": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "location": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "healthcareService": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "telecom": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactPoint", is_backbone_element=True),
        ),
        "availableTime": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="PractitionerRole_AvailableTime", is_backbone_element=True
            ),
        ),
        "notAvailable": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="PractitionerRole_NotAvailable", is_backbone_element=True
            ),
        ),
        "availabilityExceptions": FhirCqlType(name="String", is_backbone_element=False),
        "endpoint": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
    },
    "Procedure": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "instantiatesCanonical": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "instantiatesUri": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "basedOn": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "partOf": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "status": FhirCqlType(name="Code", is_backbone_element=False),
        "statusReason": FhirCqlType(name="Concept", is_backbone_element=False),
        "category": FhirCqlType(name="Concept", is_backbone_element=False),
        "code": FhirCqlType(name="Concept", is_backbone_element=False),
        "subject": FhirCqlType(name="Reference", is_backbone_element=True),
        "encounter": FhirCqlType(name="Reference", is_backbone_element=True),
        "performed": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="Decimal", is_backbone_element=False),
                ),
                FhirCqlType(name="String", is_backbone_element=False),
                FhirCqlType(name="Age", is_backbone_element=True),
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
                ),
                FhirCqlType(name="DateTime", is_backbone_element=False),
            ],
        ),
        "recorder": FhirCqlType(name="Reference", is_backbone_element=True),
        "asserter": FhirCqlType(name="Reference", is_backbone_element=True),
        "performer": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Procedure_Performer", is_backbone_element=True),
        ),
        "location": FhirCqlType(name="Reference", is_backbone_element=True),
        "reasonCode": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "reasonReference": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "bodySite": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "outcome": FhirCqlType(name="Concept", is_backbone_element=False),
        "report": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "complication": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "complicationDetail": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "followUp": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "note": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Annotation", is_backbone_element=True),
        ),
        "focalDevice": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="Procedure_FocalDevice", is_backbone_element=True
            ),
        ),
        "usedReference": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "usedCode": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
    },
    "Provenance": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "target": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "occurred": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
                ),
                FhirCqlType(name="DateTime", is_backbone_element=False),
            ],
        ),
        "recorded": FhirCqlType(name="String", is_backbone_element=False),
        "policy": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "location": FhirCqlType(name="Reference", is_backbone_element=True),
        "reason": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "activity": FhirCqlType(name="Concept", is_backbone_element=False),
        "agent": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Provenance_Agent", is_backbone_element=True),
        ),
        "entity": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Provenance_Entity", is_backbone_element=True),
        ),
        "signature": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Signature", is_backbone_element=True),
        ),
    },
    "Questionnaire": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "url": FhirCqlType(name="String", is_backbone_element=False),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "version": FhirCqlType(name="String", is_backbone_element=False),
        "name": FhirCqlType(name="String", is_backbone_element=False),
        "title": FhirCqlType(name="String", is_backbone_element=False),
        "derivedFrom": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "status": FhirCqlType(name="String", is_backbone_element=False),
        "experimental": FhirCqlType(name="Boolean", is_backbone_element=False),
        "subjectType": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Code", is_backbone_element=False),
        ),
        "date": FhirCqlType(name="DateTime", is_backbone_element=False),
        "publisher": FhirCqlType(name="String", is_backbone_element=False),
        "contact": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactDetail", is_backbone_element=True),
        ),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "useContext": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="UsageContext", is_backbone_element=True),
        ),
        "jurisdiction": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "purpose": FhirCqlType(name="String", is_backbone_element=False),
        "copyright": FhirCqlType(name="String", is_backbone_element=False),
        "approvalDate": FhirCqlType(name="Date", is_backbone_element=False),
        "lastReviewDate": FhirCqlType(name="Date", is_backbone_element=False),
        "effectivePeriod": FhirInterval(
            name="Interval",
            is_backbone_element=False,
            item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
        ),
        "code": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Code", is_backbone_element=False),
        ),
        "item": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Questionnaire_Item", is_backbone_element=True),
        ),
    },
    "QuestionnaireResponse": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirCqlType(name="Identifier", is_backbone_element=True),
        "basedOn": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "partOf": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "questionnaire": FhirCqlType(name="String", is_backbone_element=False),
        "status": FhirCqlType(name="String", is_backbone_element=False),
        "subject": FhirCqlType(name="Reference", is_backbone_element=True),
        "encounter": FhirCqlType(name="Reference", is_backbone_element=True),
        "authored": FhirCqlType(name="DateTime", is_backbone_element=False),
        "author": FhirCqlType(name="Reference", is_backbone_element=True),
        "source": FhirCqlType(name="Reference", is_backbone_element=True),
        "item": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="QuestionnaireResponse_Item", is_backbone_element=True
            ),
        ),
    },
    "RelatedPerson": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "active": FhirCqlType(name="Boolean", is_backbone_element=False),
        "patient": FhirCqlType(name="Reference", is_backbone_element=True),
        "relationship": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "name": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="HumanName", is_backbone_element=True),
        ),
        "telecom": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactPoint", is_backbone_element=True),
        ),
        "gender": FhirCqlType(name="String", is_backbone_element=False),
        "birthDate": FhirCqlType(name="Date", is_backbone_element=False),
        "address": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Address", is_backbone_element=True),
        ),
        "photo": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Attachment", is_backbone_element=True),
        ),
        "period": FhirInterval(
            name="Interval",
            is_backbone_element=False,
            item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
        ),
        "communication": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="RelatedPerson_Communication", is_backbone_element=True
            ),
        ),
    },
    "RequestGroup": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "instantiatesCanonical": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "instantiatesUri": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "basedOn": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "replaces": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "groupIdentifier": FhirCqlType(name="Identifier", is_backbone_element=True),
        "status": FhirCqlType(name="Code", is_backbone_element=False),
        "intent": FhirCqlType(name="Code", is_backbone_element=False),
        "priority": FhirCqlType(name="Code", is_backbone_element=False),
        "code": FhirCqlType(name="Concept", is_backbone_element=False),
        "subject": FhirCqlType(name="Reference", is_backbone_element=True),
        "encounter": FhirCqlType(name="Reference", is_backbone_element=True),
        "authoredOn": FhirCqlType(name="DateTime", is_backbone_element=False),
        "author": FhirCqlType(name="Reference", is_backbone_element=True),
        "reasonCode": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "reasonReference": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "note": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Annotation", is_backbone_element=True),
        ),
        "action": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="RequestGroup_Action", is_backbone_element=True),
        ),
    },
    "ResearchDefinition": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "url": FhirCqlType(name="String", is_backbone_element=False),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "version": FhirCqlType(name="String", is_backbone_element=False),
        "name": FhirCqlType(name="String", is_backbone_element=False),
        "title": FhirCqlType(name="String", is_backbone_element=False),
        "shortTitle": FhirCqlType(name="String", is_backbone_element=False),
        "subtitle": FhirCqlType(name="String", is_backbone_element=False),
        "status": FhirCqlType(name="String", is_backbone_element=False),
        "experimental": FhirCqlType(name="Boolean", is_backbone_element=False),
        "subject": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Concept", is_backbone_element=False),
                FhirCqlType(name="Reference", is_backbone_element=True),
            ],
        ),
        "date": FhirCqlType(name="DateTime", is_backbone_element=False),
        "publisher": FhirCqlType(name="String", is_backbone_element=False),
        "contact": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactDetail", is_backbone_element=True),
        ),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "comment": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "useContext": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="UsageContext", is_backbone_element=True),
        ),
        "jurisdiction": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "purpose": FhirCqlType(name="String", is_backbone_element=False),
        "usage": FhirCqlType(name="String", is_backbone_element=False),
        "copyright": FhirCqlType(name="String", is_backbone_element=False),
        "approvalDate": FhirCqlType(name="Date", is_backbone_element=False),
        "lastReviewDate": FhirCqlType(name="Date", is_backbone_element=False),
        "effectivePeriod": FhirInterval(
            name="Interval",
            is_backbone_element=False,
            item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
        ),
        "topic": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "author": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactDetail", is_backbone_element=True),
        ),
        "editor": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactDetail", is_backbone_element=True),
        ),
        "reviewer": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactDetail", is_backbone_element=True),
        ),
        "endorser": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactDetail", is_backbone_element=True),
        ),
        "relatedArtifact": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="RelatedArtifact", is_backbone_element=True),
        ),
        "library": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "population": FhirCqlType(name="Reference", is_backbone_element=True),
        "exposure": FhirCqlType(name="Reference", is_backbone_element=True),
        "exposureAlternative": FhirCqlType(name="Reference", is_backbone_element=True),
        "outcome": FhirCqlType(name="Reference", is_backbone_element=True),
    },
    "ResearchElementDefinition": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "url": FhirCqlType(name="String", is_backbone_element=False),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "version": FhirCqlType(name="String", is_backbone_element=False),
        "name": FhirCqlType(name="String", is_backbone_element=False),
        "title": FhirCqlType(name="String", is_backbone_element=False),
        "shortTitle": FhirCqlType(name="String", is_backbone_element=False),
        "subtitle": FhirCqlType(name="String", is_backbone_element=False),
        "status": FhirCqlType(name="String", is_backbone_element=False),
        "experimental": FhirCqlType(name="Boolean", is_backbone_element=False),
        "subject": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Concept", is_backbone_element=False),
                FhirCqlType(name="Reference", is_backbone_element=True),
            ],
        ),
        "date": FhirCqlType(name="DateTime", is_backbone_element=False),
        "publisher": FhirCqlType(name="String", is_backbone_element=False),
        "contact": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactDetail", is_backbone_element=True),
        ),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "comment": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "useContext": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="UsageContext", is_backbone_element=True),
        ),
        "jurisdiction": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "purpose": FhirCqlType(name="String", is_backbone_element=False),
        "usage": FhirCqlType(name="String", is_backbone_element=False),
        "copyright": FhirCqlType(name="String", is_backbone_element=False),
        "approvalDate": FhirCqlType(name="Date", is_backbone_element=False),
        "lastReviewDate": FhirCqlType(name="Date", is_backbone_element=False),
        "effectivePeriod": FhirInterval(
            name="Interval",
            is_backbone_element=False,
            item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
        ),
        "topic": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "author": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactDetail", is_backbone_element=True),
        ),
        "editor": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactDetail", is_backbone_element=True),
        ),
        "reviewer": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactDetail", is_backbone_element=True),
        ),
        "endorser": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactDetail", is_backbone_element=True),
        ),
        "relatedArtifact": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="RelatedArtifact", is_backbone_element=True),
        ),
        "library": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "type": FhirCqlType(name="String", is_backbone_element=False),
        "variableType": FhirCqlType(name="String", is_backbone_element=False),
        "characteristic": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ResearchElementDefinition_Characteristic",
                is_backbone_element=True,
            ),
        ),
    },
    "ResearchStudy": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "title": FhirCqlType(name="String", is_backbone_element=False),
        "protocol": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "partOf": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "status": FhirCqlType(name="String", is_backbone_element=False),
        "primaryPurposeType": FhirCqlType(name="Concept", is_backbone_element=False),
        "phase": FhirCqlType(name="Concept", is_backbone_element=False),
        "category": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "focus": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "condition": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "contact": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactDetail", is_backbone_element=True),
        ),
        "relatedArtifact": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="RelatedArtifact", is_backbone_element=True),
        ),
        "keyword": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "location": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "enrollment": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "period": FhirInterval(
            name="Interval",
            is_backbone_element=False,
            item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
        ),
        "sponsor": FhirCqlType(name="Reference", is_backbone_element=True),
        "principalInvestigator": FhirCqlType(
            name="Reference", is_backbone_element=True
        ),
        "site": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "reasonStopped": FhirCqlType(name="Concept", is_backbone_element=False),
        "note": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Annotation", is_backbone_element=True),
        ),
        "arm": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ResearchStudy_Arm", is_backbone_element=True),
        ),
        "objective": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ResearchStudy_Objective", is_backbone_element=True
            ),
        ),
    },
    "ResearchSubject": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "status": FhirCqlType(name="String", is_backbone_element=False),
        "period": FhirInterval(
            name="Interval",
            is_backbone_element=False,
            item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
        ),
        "study": FhirCqlType(name="Reference", is_backbone_element=True),
        "individual": FhirCqlType(name="Reference", is_backbone_element=True),
        "assignedArm": FhirCqlType(name="String", is_backbone_element=False),
        "actualArm": FhirCqlType(name="String", is_backbone_element=False),
        "consent": FhirCqlType(name="Reference", is_backbone_element=True),
    },
    "RiskAssessment": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "basedOn": FhirCqlType(name="Reference", is_backbone_element=True),
        "parent": FhirCqlType(name="Reference", is_backbone_element=True),
        "status": FhirCqlType(name="Code", is_backbone_element=False),
        "method": FhirCqlType(name="Concept", is_backbone_element=False),
        "code": FhirCqlType(name="Concept", is_backbone_element=False),
        "subject": FhirCqlType(name="Reference", is_backbone_element=True),
        "encounter": FhirCqlType(name="Reference", is_backbone_element=True),
        "occurrence": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
                ),
                FhirCqlType(name="DateTime", is_backbone_element=False),
            ],
        ),
        "condition": FhirCqlType(name="Reference", is_backbone_element=True),
        "performer": FhirCqlType(name="Reference", is_backbone_element=True),
        "reasonCode": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "reasonReference": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "basis": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "prediction": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="RiskAssessment_Prediction", is_backbone_element=True
            ),
        ),
        "mitigation": FhirCqlType(name="String", is_backbone_element=False),
        "note": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Annotation", is_backbone_element=True),
        ),
    },
    "RiskEvidenceSynthesis": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "url": FhirCqlType(name="String", is_backbone_element=False),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "version": FhirCqlType(name="String", is_backbone_element=False),
        "name": FhirCqlType(name="String", is_backbone_element=False),
        "title": FhirCqlType(name="String", is_backbone_element=False),
        "status": FhirCqlType(name="String", is_backbone_element=False),
        "date": FhirCqlType(name="DateTime", is_backbone_element=False),
        "publisher": FhirCqlType(name="String", is_backbone_element=False),
        "contact": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactDetail", is_backbone_element=True),
        ),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "note": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Annotation", is_backbone_element=True),
        ),
        "useContext": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="UsageContext", is_backbone_element=True),
        ),
        "jurisdiction": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "copyright": FhirCqlType(name="String", is_backbone_element=False),
        "approvalDate": FhirCqlType(name="Date", is_backbone_element=False),
        "lastReviewDate": FhirCqlType(name="Date", is_backbone_element=False),
        "effectivePeriod": FhirInterval(
            name="Interval",
            is_backbone_element=False,
            item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
        ),
        "topic": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "author": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactDetail", is_backbone_element=True),
        ),
        "editor": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactDetail", is_backbone_element=True),
        ),
        "reviewer": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactDetail", is_backbone_element=True),
        ),
        "endorser": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactDetail", is_backbone_element=True),
        ),
        "relatedArtifact": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="RelatedArtifact", is_backbone_element=True),
        ),
        "synthesisType": FhirCqlType(name="Concept", is_backbone_element=False),
        "studyType": FhirCqlType(name="Concept", is_backbone_element=False),
        "population": FhirCqlType(name="Reference", is_backbone_element=True),
        "exposure": FhirCqlType(name="Reference", is_backbone_element=True),
        "outcome": FhirCqlType(name="Reference", is_backbone_element=True),
        "sampleSize": FhirCqlType(
            name="RiskEvidenceSynthesis_SampleSize", is_backbone_element=True
        ),
        "riskEstimate": FhirCqlType(
            name="RiskEvidenceSynthesis_RiskEstimate", is_backbone_element=True
        ),
        "certainty": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="RiskEvidenceSynthesis_Certainty", is_backbone_element=True
            ),
        ),
    },
    "Schedule": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "active": FhirCqlType(name="Boolean", is_backbone_element=False),
        "serviceCategory": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "serviceType": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "specialty": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "actor": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "planningHorizon": FhirInterval(
            name="Interval",
            is_backbone_element=False,
            item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
        ),
        "comment": FhirCqlType(name="String", is_backbone_element=False),
    },
    "SearchParameter": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "url": FhirCqlType(name="String", is_backbone_element=False),
        "version": FhirCqlType(name="String", is_backbone_element=False),
        "name": FhirCqlType(name="String", is_backbone_element=False),
        "derivedFrom": FhirCqlType(name="String", is_backbone_element=False),
        "status": FhirCqlType(name="String", is_backbone_element=False),
        "experimental": FhirCqlType(name="Boolean", is_backbone_element=False),
        "date": FhirCqlType(name="DateTime", is_backbone_element=False),
        "publisher": FhirCqlType(name="String", is_backbone_element=False),
        "contact": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactDetail", is_backbone_element=True),
        ),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "useContext": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="UsageContext", is_backbone_element=True),
        ),
        "jurisdiction": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "purpose": FhirCqlType(name="String", is_backbone_element=False),
        "code": FhirCqlType(name="Code", is_backbone_element=False),
        "base": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Code", is_backbone_element=False),
        ),
        "type": FhirCqlType(name="String", is_backbone_element=False),
        "expression": FhirCqlType(name="String", is_backbone_element=False),
        "xpath": FhirCqlType(name="String", is_backbone_element=False),
        "xpathUsage": FhirCqlType(name="String", is_backbone_element=False),
        "target": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Code", is_backbone_element=False),
        ),
        "multipleOr": FhirCqlType(name="Boolean", is_backbone_element=False),
        "multipleAnd": FhirCqlType(name="Boolean", is_backbone_element=False),
        "comparator": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "modifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "chain": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "component": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="SearchParameter_Component", is_backbone_element=True
            ),
        ),
    },
    "ServiceRequest": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "instantiatesCanonical": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "instantiatesUri": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "basedOn": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "replaces": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "requisition": FhirCqlType(name="Identifier", is_backbone_element=True),
        "status": FhirCqlType(name="Code", is_backbone_element=False),
        "intent": FhirCqlType(name="Code", is_backbone_element=False),
        "category": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "priority": FhirCqlType(name="Code", is_backbone_element=False),
        "doNotPerform": FhirCqlType(name="Boolean", is_backbone_element=False),
        "code": FhirCqlType(name="Concept", is_backbone_element=False),
        "orderDetail": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "quantity": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Ratio", is_backbone_element=True),
                FhirCqlType(name="Decimal", is_backbone_element=False),
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="Decimal", is_backbone_element=False),
                ),
            ],
        ),
        "subject": FhirCqlType(name="Reference", is_backbone_element=True),
        "encounter": FhirCqlType(name="Reference", is_backbone_element=True),
        "occurrence": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Timing", is_backbone_element=True),
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
                ),
                FhirCqlType(name="DateTime", is_backbone_element=False),
            ],
        ),
        "asNeeded": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Boolean", is_backbone_element=False),
                FhirCqlType(name="Concept", is_backbone_element=False),
            ],
        ),
        "authoredOn": FhirCqlType(name="DateTime", is_backbone_element=False),
        "requester": FhirCqlType(name="Reference", is_backbone_element=True),
        "performerType": FhirCqlType(name="Concept", is_backbone_element=False),
        "performer": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "locationCode": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "locationReference": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "reasonCode": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "reasonReference": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "insurance": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "supportingInfo": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "specimen": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "bodySite": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "note": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Annotation", is_backbone_element=True),
        ),
        "patientInstruction": FhirCqlType(name="String", is_backbone_element=False),
        "relevantHistory": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
    },
    "Slot": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "serviceCategory": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "serviceType": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "specialty": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "appointmentType": FhirCqlType(name="Concept", is_backbone_element=False),
        "schedule": FhirCqlType(name="Reference", is_backbone_element=True),
        "status": FhirCqlType(name="String", is_backbone_element=False),
        "start": FhirCqlType(name="String", is_backbone_element=False),
        "end": FhirCqlType(name="String", is_backbone_element=False),
        "overbooked": FhirCqlType(name="Boolean", is_backbone_element=False),
        "comment": FhirCqlType(name="String", is_backbone_element=False),
    },
    "Specimen": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "accessionIdentifier": FhirCqlType(name="Identifier", is_backbone_element=True),
        "status": FhirCqlType(name="String", is_backbone_element=False),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "subject": FhirCqlType(name="Reference", is_backbone_element=True),
        "receivedTime": FhirCqlType(name="DateTime", is_backbone_element=False),
        "parent": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "request": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "collection": FhirCqlType(name="Specimen_Collection", is_backbone_element=True),
        "processing": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Specimen_Processing", is_backbone_element=True),
        ),
        "container": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Specimen_Container", is_backbone_element=True),
        ),
        "condition": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "note": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Annotation", is_backbone_element=True),
        ),
    },
    "SpecimenDefinition": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirCqlType(name="Identifier", is_backbone_element=True),
        "typeCollected": FhirCqlType(name="Concept", is_backbone_element=False),
        "patientPreparation": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "timeAspect": FhirCqlType(name="String", is_backbone_element=False),
        "collection": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "typeTested": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="SpecimenDefinition_TypeTested", is_backbone_element=True
            ),
        ),
    },
    "StructureDefinition": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "url": FhirCqlType(name="String", is_backbone_element=False),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "version": FhirCqlType(name="String", is_backbone_element=False),
        "name": FhirCqlType(name="String", is_backbone_element=False),
        "title": FhirCqlType(name="String", is_backbone_element=False),
        "status": FhirCqlType(name="String", is_backbone_element=False),
        "experimental": FhirCqlType(name="Boolean", is_backbone_element=False),
        "date": FhirCqlType(name="DateTime", is_backbone_element=False),
        "publisher": FhirCqlType(name="String", is_backbone_element=False),
        "contact": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactDetail", is_backbone_element=True),
        ),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "useContext": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="UsageContext", is_backbone_element=True),
        ),
        "jurisdiction": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "purpose": FhirCqlType(name="String", is_backbone_element=False),
        "copyright": FhirCqlType(name="String", is_backbone_element=False),
        "keyword": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Code", is_backbone_element=False),
        ),
        "fhirVersion": FhirCqlType(name="String", is_backbone_element=False),
        "mapping": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="StructureDefinition_Mapping", is_backbone_element=True
            ),
        ),
        "kind": FhirCqlType(name="String", is_backbone_element=False),
        "abstract": FhirCqlType(name="Boolean", is_backbone_element=False),
        "context": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="StructureDefinition_Context", is_backbone_element=True
            ),
        ),
        "contextInvariant": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "type": FhirCqlType(name="String", is_backbone_element=False),
        "baseDefinition": FhirCqlType(name="String", is_backbone_element=False),
        "derivation": FhirCqlType(name="String", is_backbone_element=False),
        "snapshot": FhirCqlType(
            name="StructureDefinition_Snapshot", is_backbone_element=True
        ),
        "differential": FhirCqlType(
            name="StructureDefinition_Differential", is_backbone_element=True
        ),
    },
    "StructureMap": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "url": FhirCqlType(name="String", is_backbone_element=False),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "version": FhirCqlType(name="String", is_backbone_element=False),
        "name": FhirCqlType(name="String", is_backbone_element=False),
        "title": FhirCqlType(name="String", is_backbone_element=False),
        "status": FhirCqlType(name="String", is_backbone_element=False),
        "experimental": FhirCqlType(name="Boolean", is_backbone_element=False),
        "date": FhirCqlType(name="DateTime", is_backbone_element=False),
        "publisher": FhirCqlType(name="String", is_backbone_element=False),
        "contact": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactDetail", is_backbone_element=True),
        ),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "useContext": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="UsageContext", is_backbone_element=True),
        ),
        "jurisdiction": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "purpose": FhirCqlType(name="String", is_backbone_element=False),
        "copyright": FhirCqlType(name="String", is_backbone_element=False),
        "structure": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="StructureMap_Structure", is_backbone_element=True
            ),
        ),
        "import": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "group": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="StructureMap_Group", is_backbone_element=True),
        ),
    },
    "Subscription": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "status": FhirCqlType(name="String", is_backbone_element=False),
        "contact": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactPoint", is_backbone_element=True),
        ),
        "end": FhirCqlType(name="String", is_backbone_element=False),
        "reason": FhirCqlType(name="String", is_backbone_element=False),
        "criteria": FhirCqlType(name="String", is_backbone_element=False),
        "error": FhirCqlType(name="String", is_backbone_element=False),
        "channel": FhirCqlType(name="Subscription_Channel", is_backbone_element=True),
    },
    "Substance": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "status": FhirCqlType(name="String", is_backbone_element=False),
        "category": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "code": FhirCqlType(name="Concept", is_backbone_element=False),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "instance": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Substance_Instance", is_backbone_element=True),
        ),
        "ingredient": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="Substance_Ingredient", is_backbone_element=True
            ),
        ),
    },
    "SubstanceNucleicAcid": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "sequenceType": FhirCqlType(name="Concept", is_backbone_element=False),
        "numberOfSubunits": FhirCqlType(name="Integer", is_backbone_element=False),
        "areaOfHybridisation": FhirCqlType(name="String", is_backbone_element=False),
        "oligoNucleotideType": FhirCqlType(name="Concept", is_backbone_element=False),
        "subunit": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="SubstanceNucleicAcid_Subunit", is_backbone_element=True
            ),
        ),
    },
    "SubstancePolymer": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirList(
                    name="List",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="String", is_backbone_element=False),
                ),
                FhirCqlType(name="Concept", is_backbone_element=False),
                FhirList(
                    name="List",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="Concept", is_backbone_element=False),
                ),
                FhirList(
                    name="List",
                    is_backbone_element=False,
                    item_type=FhirCqlType(
                        name="SubstancePolymer_Repeat", is_backbone_element=True
                    ),
                ),
                FhirList(
                    name="List",
                    is_backbone_element=False,
                    item_type=FhirCqlType(
                        name="SubstancePolymer_MonomerSet", is_backbone_element=True
                    ),
                ),
            ],
        ),
    },
    "SubstanceProtein": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "sequenceType": FhirCqlType(name="Concept", is_backbone_element=False),
        "numberOfSubunits": FhirCqlType(name="Integer", is_backbone_element=False),
        "disulfideLinkage": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "subunit": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="SubstanceProtein_Subunit", is_backbone_element=True
            ),
        ),
    },
    "SubstanceReferenceInformation": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirList(
                    name="List",
                    is_backbone_element=False,
                    item_type=FhirCqlType(
                        name="SubstanceReferenceInformation_Gene",
                        is_backbone_element=True,
                    ),
                ),
                FhirList(
                    name="List",
                    is_backbone_element=False,
                    item_type=FhirCqlType(
                        name="SubstanceReferenceInformation_GeneElement",
                        is_backbone_element=True,
                    ),
                ),
                FhirCqlType(name="String", is_backbone_element=False),
                FhirList(
                    name="List",
                    is_backbone_element=False,
                    item_type=FhirCqlType(
                        name="SubstanceReferenceInformation_Classification",
                        is_backbone_element=True,
                    ),
                ),
                FhirList(
                    name="List",
                    is_backbone_element=False,
                    item_type=FhirCqlType(
                        name="SubstanceReferenceInformation_Target",
                        is_backbone_element=True,
                    ),
                ),
            ],
        ),
    },
    "SubstanceSourceMaterial": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "sourceMaterialClass": FhirCqlType(name="Concept", is_backbone_element=False),
        "sourceMaterialType": FhirCqlType(name="Concept", is_backbone_element=False),
        "sourceMaterialState": FhirCqlType(name="Concept", is_backbone_element=False),
        "organismId": FhirCqlType(name="Identifier", is_backbone_element=True),
        "organismName": FhirCqlType(name="String", is_backbone_element=False),
        "parentSubstanceId": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "parentSubstanceName": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "countryOfOrigin": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "geographicalLocation": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "developmentStage": FhirCqlType(name="Concept", is_backbone_element=False),
        "fractionDescription": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="SubstanceSourceMaterial_FractionDescription",
                is_backbone_element=True,
            ),
        ),
        "organism": FhirCqlType(
            name="SubstanceSourceMaterial_Organism", is_backbone_element=True
        ),
        "partDescription": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="SubstanceSourceMaterial_PartDescription", is_backbone_element=True
            ),
        ),
    },
    "SubstanceSpecification": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirCqlType(name="Identifier", is_backbone_element=True),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "status": FhirCqlType(name="Concept", is_backbone_element=False),
        "domain": FhirCqlType(name="Concept", is_backbone_element=False),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "source": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "comment": FhirCqlType(name="String", is_backbone_element=False),
        "moiety": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="SubstanceSpecification_Moiety", is_backbone_element=True
            ),
        ),
        "property": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="SubstanceSpecification_Property", is_backbone_element=True
            ),
        ),
        "referenceInformation": FhirCqlType(name="Reference", is_backbone_element=True),
        "structure": FhirCqlType(
            name="SubstanceSpecification_Structure", is_backbone_element=True
        ),
        "code": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="SubstanceSpecification_Code", is_backbone_element=True
            ),
        ),
        "name": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="SubstanceSpecification_Name", is_backbone_element=True
            ),
        ),
        "molecularWeight": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="SubstanceSpecification_MolecularWeight", is_backbone_element=True
            ),
        ),
        "relationship": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="SubstanceSpecification_Relationship", is_backbone_element=True
            ),
        ),
        "nucleicAcid": FhirCqlType(name="Reference", is_backbone_element=True),
        "polymer": FhirCqlType(name="Reference", is_backbone_element=True),
        "protein": FhirCqlType(name="Reference", is_backbone_element=True),
        "sourceMaterial": FhirCqlType(name="Reference", is_backbone_element=True),
    },
    "SupplyDelivery": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "basedOn": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "partOf": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "status": FhirCqlType(name="String", is_backbone_element=False),
        "patient": FhirCqlType(name="Reference", is_backbone_element=True),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "suppliedItem": FhirCqlType(
            name="SupplyDelivery_SuppliedItem", is_backbone_element=True
        ),
        "occurrence": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Timing", is_backbone_element=True),
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
                ),
                FhirCqlType(name="DateTime", is_backbone_element=False),
            ],
        ),
        "supplier": FhirCqlType(name="Reference", is_backbone_element=True),
        "destination": FhirCqlType(name="Reference", is_backbone_element=True),
        "receiver": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
    },
    "SupplyRequest": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "status": FhirCqlType(name="String", is_backbone_element=False),
        "category": FhirCqlType(name="Concept", is_backbone_element=False),
        "priority": FhirCqlType(name="Code", is_backbone_element=False),
        "item": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Concept", is_backbone_element=False),
                FhirCqlType(name="Reference", is_backbone_element=True),
            ],
        ),
        "quantity": FhirCqlType(name="Decimal", is_backbone_element=False),
        "parameter": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="SupplyRequest_Parameter", is_backbone_element=True
            ),
        ),
        "occurrence": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Timing", is_backbone_element=True),
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
                ),
                FhirCqlType(name="DateTime", is_backbone_element=False),
            ],
        ),
        "authoredOn": FhirCqlType(name="DateTime", is_backbone_element=False),
        "requester": FhirCqlType(name="Reference", is_backbone_element=True),
        "supplier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "reason": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirList(
                    name="List",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="Concept", is_backbone_element=False),
                ),
                FhirList(
                    name="List",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="Reference", is_backbone_element=True),
                ),
            ],
        ),
        "deliverFrom": FhirCqlType(name="Reference", is_backbone_element=True),
        "deliverTo": FhirCqlType(name="Reference", is_backbone_element=True),
    },
    "Task": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "instantiatesCanonical": FhirCqlType(name="String", is_backbone_element=False),
        "instantiatesUri": FhirCqlType(name="String", is_backbone_element=False),
        "basedOn": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "groupIdentifier": FhirCqlType(name="Identifier", is_backbone_element=True),
        "partOf": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "status": FhirCqlType(name="String", is_backbone_element=False),
        "statusReason": FhirCqlType(name="Concept", is_backbone_element=False),
        "businessStatus": FhirCqlType(name="Concept", is_backbone_element=False),
        "intent": FhirCqlType(name="String", is_backbone_element=False),
        "priority": FhirCqlType(name="Code", is_backbone_element=False),
        "code": FhirCqlType(name="Concept", is_backbone_element=False),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "focus": FhirCqlType(name="Reference", is_backbone_element=True),
        "for": FhirCqlType(name="Reference", is_backbone_element=True),
        "encounter": FhirCqlType(name="Reference", is_backbone_element=True),
        "executionPeriod": FhirInterval(
            name="Interval",
            is_backbone_element=False,
            item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
        ),
        "authoredOn": FhirCqlType(name="DateTime", is_backbone_element=False),
        "lastModified": FhirCqlType(name="DateTime", is_backbone_element=False),
        "requester": FhirCqlType(name="Reference", is_backbone_element=True),
        "performerType": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "owner": FhirCqlType(name="Reference", is_backbone_element=True),
        "location": FhirCqlType(name="Reference", is_backbone_element=True),
        "reasonCode": FhirCqlType(name="Concept", is_backbone_element=False),
        "reasonReference": FhirCqlType(name="Reference", is_backbone_element=True),
        "insurance": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "note": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Annotation", is_backbone_element=True),
        ),
        "relevantHistory": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "restriction": FhirCqlType(name="Task_Restriction", is_backbone_element=True),
        "input": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Task_Input", is_backbone_element=True),
        ),
        "output": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Task_Output", is_backbone_element=True),
        ),
    },
    "TerminologyCapabilities": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "url": FhirCqlType(name="String", is_backbone_element=False),
        "version": FhirCqlType(name="String", is_backbone_element=False),
        "name": FhirCqlType(name="String", is_backbone_element=False),
        "title": FhirCqlType(name="String", is_backbone_element=False),
        "status": FhirCqlType(name="String", is_backbone_element=False),
        "experimental": FhirCqlType(name="Boolean", is_backbone_element=False),
        "date": FhirCqlType(name="DateTime", is_backbone_element=False),
        "publisher": FhirCqlType(name="String", is_backbone_element=False),
        "contact": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactDetail", is_backbone_element=True),
        ),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "useContext": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="UsageContext", is_backbone_element=True),
        ),
        "jurisdiction": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "purpose": FhirCqlType(name="String", is_backbone_element=False),
        "copyright": FhirCqlType(name="String", is_backbone_element=False),
        "kind": FhirCqlType(name="Code", is_backbone_element=False),
        "software": FhirCqlType(
            name="TerminologyCapabilities_Software", is_backbone_element=True
        ),
        "implementation": FhirCqlType(
            name="TerminologyCapabilities_Implementation", is_backbone_element=True
        ),
        "lockedDate": FhirCqlType(name="Boolean", is_backbone_element=False),
        "codeSystem": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="TerminologyCapabilities_CodeSystem", is_backbone_element=True
            ),
        ),
        "expansion": FhirCqlType(
            name="TerminologyCapabilities_Expansion", is_backbone_element=True
        ),
        "codeSearch": FhirCqlType(name="String", is_backbone_element=False),
        "validateCode": FhirCqlType(
            name="TerminologyCapabilities_ValidateCode", is_backbone_element=True
        ),
        "translation": FhirCqlType(
            name="TerminologyCapabilities_Translation", is_backbone_element=True
        ),
        "closure": FhirCqlType(
            name="TerminologyCapabilities_Closure", is_backbone_element=True
        ),
    },
    "TestReport": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirCqlType(name="Identifier", is_backbone_element=True),
        "name": FhirCqlType(name="String", is_backbone_element=False),
        "status": FhirCqlType(name="String", is_backbone_element=False),
        "testScript": FhirCqlType(name="Reference", is_backbone_element=True),
        "result": FhirCqlType(name="String", is_backbone_element=False),
        "score": FhirCqlType(name="Decimal", is_backbone_element=False),
        "tester": FhirCqlType(name="String", is_backbone_element=False),
        "issued": FhirCqlType(name="DateTime", is_backbone_element=False),
        "participant": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="TestReport_Participant", is_backbone_element=True
            ),
        ),
        "setup": FhirCqlType(name="TestReport_Setup", is_backbone_element=True),
        "test": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="TestReport_Test", is_backbone_element=True),
        ),
        "teardown": FhirCqlType(name="TestReport_Teardown", is_backbone_element=True),
    },
    "TestScript": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "url": FhirCqlType(name="String", is_backbone_element=False),
        "identifier": FhirCqlType(name="Identifier", is_backbone_element=True),
        "version": FhirCqlType(name="String", is_backbone_element=False),
        "name": FhirCqlType(name="String", is_backbone_element=False),
        "title": FhirCqlType(name="String", is_backbone_element=False),
        "status": FhirCqlType(name="String", is_backbone_element=False),
        "experimental": FhirCqlType(name="Boolean", is_backbone_element=False),
        "date": FhirCqlType(name="DateTime", is_backbone_element=False),
        "publisher": FhirCqlType(name="String", is_backbone_element=False),
        "contact": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactDetail", is_backbone_element=True),
        ),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "useContext": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="UsageContext", is_backbone_element=True),
        ),
        "jurisdiction": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "purpose": FhirCqlType(name="String", is_backbone_element=False),
        "copyright": FhirCqlType(name="String", is_backbone_element=False),
        "origin": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="TestScript_Origin", is_backbone_element=True),
        ),
        "destination": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="TestScript_Destination", is_backbone_element=True
            ),
        ),
        "metadata": FhirCqlType(name="TestScript_Metadata", is_backbone_element=True),
        "fixture": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="TestScript_Fixture", is_backbone_element=True),
        ),
        "profile": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "variable": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="TestScript_Variable", is_backbone_element=True),
        ),
        "setup": FhirCqlType(name="TestScript_Setup", is_backbone_element=True),
        "test": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="TestScript_Test", is_backbone_element=True),
        ),
        "teardown": FhirCqlType(name="TestScript_Teardown", is_backbone_element=True),
    },
    "ValueSet": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "url": FhirCqlType(name="String", is_backbone_element=False),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "version": FhirCqlType(name="String", is_backbone_element=False),
        "name": FhirCqlType(name="String", is_backbone_element=False),
        "title": FhirCqlType(name="String", is_backbone_element=False),
        "status": FhirCqlType(name="String", is_backbone_element=False),
        "experimental": FhirCqlType(name="Boolean", is_backbone_element=False),
        "date": FhirCqlType(name="DateTime", is_backbone_element=False),
        "publisher": FhirCqlType(name="String", is_backbone_element=False),
        "contact": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactDetail", is_backbone_element=True),
        ),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "useContext": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="UsageContext", is_backbone_element=True),
        ),
        "jurisdiction": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "immutable": FhirCqlType(name="Boolean", is_backbone_element=False),
        "purpose": FhirCqlType(name="String", is_backbone_element=False),
        "copyright": FhirCqlType(name="String", is_backbone_element=False),
        "compose": FhirCqlType(name="ValueSet_Compose", is_backbone_element=True),
        "expansion": FhirCqlType(name="ValueSet_Expansion", is_backbone_element=True),
    },
    "VerificationResult": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "target": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "targetLocation": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "need": FhirCqlType(name="Concept", is_backbone_element=False),
        "status": FhirCqlType(name="Code", is_backbone_element=False),
        "statusDate": FhirCqlType(name="DateTime", is_backbone_element=False),
        "validationType": FhirCqlType(name="Concept", is_backbone_element=False),
        "validationProcess": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "frequency": FhirCqlType(name="Timing", is_backbone_element=True),
        "lastPerformed": FhirCqlType(name="DateTime", is_backbone_element=False),
        "nextScheduled": FhirCqlType(name="Date", is_backbone_element=False),
        "failureAction": FhirCqlType(name="Concept", is_backbone_element=False),
        "primarySource": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="VerificationResult_PrimarySource", is_backbone_element=True
            ),
        ),
        "attestation": FhirCqlType(
            name="VerificationResult_Attestation", is_backbone_element=True
        ),
        "validator": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="VerificationResult_Validator", is_backbone_element=True
            ),
        ),
    },
    "VisionPrescription": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "meta": FhirCqlType(name="Meta", is_backbone_element=True),
        "implicitRules": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "contained": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "status": FhirCqlType(name="Code", is_backbone_element=False),
        "created": FhirCqlType(name="DateTime", is_backbone_element=False),
        "patient": FhirCqlType(name="Reference", is_backbone_element=True),
        "encounter": FhirCqlType(name="Reference", is_backbone_element=True),
        "dateWritten": FhirCqlType(name="DateTime", is_backbone_element=False),
        "prescriber": FhirCqlType(name="Reference", is_backbone_element=True),
        "lensSpecification": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="VisionPrescription_LensSpecification", is_backbone_element=True
            ),
        ),
    },
    "Account_Coverage": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "coverage": FhirCqlType(name="Reference", is_backbone_element=True),
        "priority": FhirCqlType(name="String", is_backbone_element=False),
    },
    "Account_Guarantor": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "party": FhirCqlType(name="Reference", is_backbone_element=True),
        "onHold": FhirCqlType(name="Boolean", is_backbone_element=False),
        "period": FhirInterval(
            name="Interval",
            is_backbone_element=False,
            item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
        ),
    },
    "ActivityDefinition_DynamicValue": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "path": FhirCqlType(name="String", is_backbone_element=False),
        "expression": FhirCqlType(name="Expression", is_backbone_element=True),
    },
    "ActivityDefinition_Participant": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "type": FhirCqlType(name="Code", is_backbone_element=False),
        "role": FhirCqlType(name="Concept", is_backbone_element=False),
    },
    "Address": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "use": FhirCqlType(name="String", is_backbone_element=False),
        "type": FhirCqlType(name="String", is_backbone_element=False),
        "text": FhirCqlType(name="String", is_backbone_element=False),
        "line": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "city": FhirCqlType(name="String", is_backbone_element=False),
        "district": FhirCqlType(name="String", is_backbone_element=False),
        "state": FhirCqlType(name="String", is_backbone_element=False),
        "postalCode": FhirCqlType(name="String", is_backbone_element=False),
        "country": FhirCqlType(name="String", is_backbone_element=False),
        "period": FhirInterval(
            name="Interval",
            is_backbone_element=False,
            item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
        ),
    },
    "AdverseEvent_Causality": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "assessment": FhirCqlType(name="Concept", is_backbone_element=False),
        "productRelatedness": FhirCqlType(name="String", is_backbone_element=False),
        "author": FhirCqlType(name="Reference", is_backbone_element=True),
        "method": FhirCqlType(name="Concept", is_backbone_element=False),
    },
    "AdverseEvent_SuspectEntity": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "instance": FhirCqlType(name="Reference", is_backbone_element=True),
        "causality": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="AdverseEvent_Causality", is_backbone_element=True
            ),
        ),
    },
    "Age": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "value": FhirCqlType(name="Decimal", is_backbone_element=False),
        "comparator": FhirCqlType(name="String", is_backbone_element=False),
        "unit": FhirCqlType(name="String", is_backbone_element=False),
        "system": FhirCqlType(name="String", is_backbone_element=False),
        "code": FhirCqlType(name="Code", is_backbone_element=False),
    },
    "AllergyIntolerance_Reaction": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "substance": FhirCqlType(name="Concept", is_backbone_element=False),
        "manifestation": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "onset": FhirCqlType(name="DateTime", is_backbone_element=False),
        "severity": FhirCqlType(name="String", is_backbone_element=False),
        "exposureRoute": FhirCqlType(name="Concept", is_backbone_element=False),
        "note": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Annotation", is_backbone_element=True),
        ),
    },
    "Annotation": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "author": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Reference", is_backbone_element=True),
                FhirCqlType(name="String", is_backbone_element=False),
            ],
        ),
        "time": FhirCqlType(name="DateTime", is_backbone_element=False),
        "text": FhirCqlType(name="String", is_backbone_element=False),
    },
    "Appointment_Participant": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "type": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "actor": FhirCqlType(name="Reference", is_backbone_element=True),
        "required": FhirCqlType(name="String", is_backbone_element=False),
        "status": FhirCqlType(name="String", is_backbone_element=False),
        "period": FhirInterval(
            name="Interval",
            is_backbone_element=False,
            item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
        ),
    },
    "Attachment": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "contentType": FhirCqlType(name="Code", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "data": FhirCqlType(name="String", is_backbone_element=False),
        "url": FhirCqlType(name="String", is_backbone_element=False),
        "size": FhirCqlType(name="String", is_backbone_element=False),
        "hash": FhirCqlType(name="String", is_backbone_element=False),
        "title": FhirCqlType(name="String", is_backbone_element=False),
        "creation": FhirCqlType(name="DateTime", is_backbone_element=False),
    },
    "AuditEvent_Agent": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "role": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "who": FhirCqlType(name="Reference", is_backbone_element=True),
        "altId": FhirCqlType(name="String", is_backbone_element=False),
        "name": FhirCqlType(name="String", is_backbone_element=False),
        "requestor": FhirCqlType(name="Boolean", is_backbone_element=False),
        "location": FhirCqlType(name="Reference", is_backbone_element=True),
        "policy": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "media": FhirCqlType(name="Code", is_backbone_element=False),
        "network": FhirCqlType(name="AuditEvent_Network", is_backbone_element=True),
        "purposeOfUse": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
    },
    "AuditEvent_Detail": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "type": FhirCqlType(name="String", is_backbone_element=False),
        "value": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[FhirCqlType(name="String", is_backbone_element=False)],
        ),
    },
    "AuditEvent_Entity": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "what": FhirCqlType(name="Reference", is_backbone_element=True),
        "type": FhirCqlType(name="Code", is_backbone_element=False),
        "role": FhirCqlType(name="Code", is_backbone_element=False),
        "lifecycle": FhirCqlType(name="Code", is_backbone_element=False),
        "securityLabel": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Code", is_backbone_element=False),
        ),
        "name": FhirCqlType(name="String", is_backbone_element=False),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "query": FhirCqlType(name="String", is_backbone_element=False),
        "detail": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="AuditEvent_Detail", is_backbone_element=True),
        ),
    },
    "AuditEvent_Network": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "address": FhirCqlType(name="String", is_backbone_element=False),
        "type": FhirCqlType(name="String", is_backbone_element=False),
    },
    "AuditEvent_Source": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "site": FhirCqlType(name="String", is_backbone_element=False),
        "observer": FhirCqlType(name="Reference", is_backbone_element=True),
        "type": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Code", is_backbone_element=False),
        ),
    },
    "BiologicallyDerivedProduct_Collection": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "collector": FhirCqlType(name="Reference", is_backbone_element=True),
        "source": FhirCqlType(name="Reference", is_backbone_element=True),
        "collected": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
                ),
                FhirCqlType(name="DateTime", is_backbone_element=False),
            ],
        ),
    },
    "BiologicallyDerivedProduct_Manipulation": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "time": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
                ),
                FhirCqlType(name="DateTime", is_backbone_element=False),
            ],
        ),
    },
    "BiologicallyDerivedProduct_Processing": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "procedure": FhirCqlType(name="Concept", is_backbone_element=False),
        "additive": FhirCqlType(name="Reference", is_backbone_element=True),
        "time": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
                ),
                FhirCqlType(name="DateTime", is_backbone_element=False),
            ],
        ),
    },
    "BiologicallyDerivedProduct_Storage": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "temperature": FhirCqlType(name="Decimal", is_backbone_element=False),
        "scale": FhirCqlType(name="String", is_backbone_element=False),
        "duration": FhirInterval(
            name="Interval",
            is_backbone_element=False,
            item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
        ),
    },
    "Bundle_Entry": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "link": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Bundle_Link", is_backbone_element=True),
        ),
        "fullUrl": FhirCqlType(name="String", is_backbone_element=False),
        "resource": FhirCqlType(name="String", is_backbone_element=False),
        "search": FhirCqlType(name="Bundle_Search", is_backbone_element=True),
        "request": FhirCqlType(name="Bundle_Request", is_backbone_element=True),
        "response": FhirCqlType(name="Bundle_Response", is_backbone_element=True),
    },
    "Bundle_Link": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "relation": FhirCqlType(name="String", is_backbone_element=False),
        "url": FhirCqlType(name="String", is_backbone_element=False),
    },
    "Bundle_Request": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "method": FhirCqlType(name="String", is_backbone_element=False),
        "url": FhirCqlType(name="String", is_backbone_element=False),
        "ifNoneMatch": FhirCqlType(name="String", is_backbone_element=False),
        "ifModifiedSince": FhirCqlType(name="String", is_backbone_element=False),
        "ifMatch": FhirCqlType(name="String", is_backbone_element=False),
        "ifNoneExist": FhirCqlType(name="String", is_backbone_element=False),
    },
    "Bundle_Response": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "status": FhirCqlType(name="String", is_backbone_element=False),
        "location": FhirCqlType(name="String", is_backbone_element=False),
        "etag": FhirCqlType(name="String", is_backbone_element=False),
        "lastModified": FhirCqlType(name="String", is_backbone_element=False),
        "outcome": FhirCqlType(name="String", is_backbone_element=False),
    },
    "Bundle_Search": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "mode": FhirCqlType(name="String", is_backbone_element=False),
        "score": FhirCqlType(name="Decimal", is_backbone_element=False),
    },
    "CapabilityStatement_Document": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "mode": FhirCqlType(name="String", is_backbone_element=False),
        "documentation": FhirCqlType(name="String", is_backbone_element=False),
        "profile": FhirCqlType(name="String", is_backbone_element=False),
    },
    "CapabilityStatement_Endpoint": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "protocol": FhirCqlType(name="Code", is_backbone_element=False),
        "address": FhirCqlType(name="String", is_backbone_element=False),
    },
    "CapabilityStatement_Implementation": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "url": FhirCqlType(name="String", is_backbone_element=False),
        "custodian": FhirCqlType(name="Reference", is_backbone_element=True),
    },
    "CapabilityStatement_Interaction": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "code": FhirCqlType(name="String", is_backbone_element=False),
        "documentation": FhirCqlType(name="String", is_backbone_element=False),
    },
    "CapabilityStatement_Interaction1": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "code": FhirCqlType(name="String", is_backbone_element=False),
        "documentation": FhirCqlType(name="String", is_backbone_element=False),
    },
    "CapabilityStatement_Messaging": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "endpoint": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="CapabilityStatement_Endpoint", is_backbone_element=True
            ),
        ),
        "reliableCache": FhirCqlType(name="String", is_backbone_element=False),
        "documentation": FhirCqlType(name="String", is_backbone_element=False),
        "supportedMessage": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="CapabilityStatement_SupportedMessage", is_backbone_element=True
            ),
        ),
    },
    "CapabilityStatement_Operation": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "name": FhirCqlType(name="String", is_backbone_element=False),
        "definition": FhirCqlType(name="String", is_backbone_element=False),
        "documentation": FhirCqlType(name="String", is_backbone_element=False),
    },
    "CapabilityStatement_Resource": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "type": FhirCqlType(name="Code", is_backbone_element=False),
        "profile": FhirCqlType(name="String", is_backbone_element=False),
        "supportedProfile": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "documentation": FhirCqlType(name="String", is_backbone_element=False),
        "interaction": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="CapabilityStatement_Interaction", is_backbone_element=True
            ),
        ),
        "versioning": FhirCqlType(name="String", is_backbone_element=False),
        "readHistory": FhirCqlType(name="Boolean", is_backbone_element=False),
        "updateCreate": FhirCqlType(name="Boolean", is_backbone_element=False),
        "conditionalCreate": FhirCqlType(name="Boolean", is_backbone_element=False),
        "conditionalRead": FhirCqlType(name="String", is_backbone_element=False),
        "conditionalUpdate": FhirCqlType(name="Boolean", is_backbone_element=False),
        "conditionalDelete": FhirCqlType(name="String", is_backbone_element=False),
        "referencePolicy": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "searchInclude": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "searchRevInclude": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "searchParam": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="CapabilityStatement_SearchParam", is_backbone_element=True
            ),
        ),
        "operation": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="CapabilityStatement_Operation", is_backbone_element=True
            ),
        ),
    },
    "CapabilityStatement_Rest": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "mode": FhirCqlType(name="String", is_backbone_element=False),
        "documentation": FhirCqlType(name="String", is_backbone_element=False),
        "security": FhirCqlType(
            name="CapabilityStatement_Security", is_backbone_element=True
        ),
        "resource": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="CapabilityStatement_Resource", is_backbone_element=True
            ),
        ),
        "interaction": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="CapabilityStatement_Interaction1", is_backbone_element=True
            ),
        ),
        "searchParam": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="CapabilityStatement_SearchParam", is_backbone_element=True
            ),
        ),
        "operation": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="CapabilityStatement_Operation", is_backbone_element=True
            ),
        ),
        "compartment": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
    },
    "CapabilityStatement_SearchParam": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "name": FhirCqlType(name="String", is_backbone_element=False),
        "definition": FhirCqlType(name="String", is_backbone_element=False),
        "type": FhirCqlType(name="String", is_backbone_element=False),
        "documentation": FhirCqlType(name="String", is_backbone_element=False),
    },
    "CapabilityStatement_Security": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "cors": FhirCqlType(name="Boolean", is_backbone_element=False),
        "service": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "description": FhirCqlType(name="String", is_backbone_element=False),
    },
    "CapabilityStatement_Software": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "name": FhirCqlType(name="String", is_backbone_element=False),
        "version": FhirCqlType(name="String", is_backbone_element=False),
        "releaseDate": FhirCqlType(name="DateTime", is_backbone_element=False),
    },
    "CapabilityStatement_SupportedMessage": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "mode": FhirCqlType(name="String", is_backbone_element=False),
        "definition": FhirCqlType(name="String", is_backbone_element=False),
    },
    "CarePlan_Activity": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "outcomeCodeableConcept": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "outcomeReference": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "progress": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Annotation", is_backbone_element=True),
        ),
        "reference": FhirCqlType(name="Reference", is_backbone_element=True),
        "detail": FhirCqlType(name="CarePlan_Detail", is_backbone_element=True),
    },
    "CarePlan_Detail": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "kind": FhirCqlType(name="Code", is_backbone_element=False),
        "instantiatesCanonical": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "instantiatesUri": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "code": FhirCqlType(name="Concept", is_backbone_element=False),
        "reasonCode": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "reasonReference": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "goal": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "status": FhirCqlType(name="String", is_backbone_element=False),
        "statusReason": FhirCqlType(name="Concept", is_backbone_element=False),
        "doNotPerform": FhirCqlType(name="Boolean", is_backbone_element=False),
        "scheduled": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Timing", is_backbone_element=True),
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
                ),
                FhirCqlType(name="String", is_backbone_element=False),
            ],
        ),
        "location": FhirCqlType(name="Reference", is_backbone_element=True),
        "performer": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "product": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Concept", is_backbone_element=False),
                FhirCqlType(name="Reference", is_backbone_element=True),
            ],
        ),
        "dailyAmount": FhirCqlType(name="Decimal", is_backbone_element=False),
        "quantity": FhirCqlType(name="Decimal", is_backbone_element=False),
        "description": FhirCqlType(name="String", is_backbone_element=False),
    },
    "CareTeam_Participant": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "role": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "member": FhirCqlType(name="Reference", is_backbone_element=True),
        "onBehalfOf": FhirCqlType(name="Reference", is_backbone_element=True),
        "period": FhirInterval(
            name="Interval",
            is_backbone_element=False,
            item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
        ),
    },
    "CatalogEntry_RelatedEntry": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "relationtype": FhirCqlType(name="String", is_backbone_element=False),
        "item": FhirCqlType(name="Reference", is_backbone_element=True),
    },
    "ChargeItemDefinition_Applicability": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="String", is_backbone_element=False),
        "expression": FhirCqlType(name="String", is_backbone_element=False),
    },
    "ChargeItemDefinition_PriceComponent": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "type": FhirCqlType(name="Code", is_backbone_element=False),
        "code": FhirCqlType(name="Concept", is_backbone_element=False),
        "factor": FhirCqlType(name="Decimal", is_backbone_element=False),
        "amount": FhirCqlType(name="Money", is_backbone_element=True),
    },
    "ChargeItemDefinition_PropertyGroup": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "applicability": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ChargeItemDefinition_Applicability", is_backbone_element=True
            ),
        ),
        "priceComponent": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ChargeItemDefinition_PriceComponent", is_backbone_element=True
            ),
        ),
    },
    "ChargeItem_Performer": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "function": FhirCqlType(name="Concept", is_backbone_element=False),
        "actor": FhirCqlType(name="Reference", is_backbone_element=True),
    },
    "ClaimResponse_AddItem": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "itemSequence": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "detailSequence": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "subdetailSequence": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "provider": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "productOrService": FhirCqlType(name="Concept", is_backbone_element=False),
        "modifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "programCode": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "serviced": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Date", is_backbone_element=False),
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
                ),
            ],
        ),
        "location": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Address", is_backbone_element=True),
                FhirCqlType(name="Concept", is_backbone_element=False),
                FhirCqlType(name="Reference", is_backbone_element=True),
            ],
        ),
        "quantity": FhirCqlType(name="Decimal", is_backbone_element=False),
        "unitPrice": FhirCqlType(name="Money", is_backbone_element=True),
        "factor": FhirCqlType(name="Decimal", is_backbone_element=False),
        "net": FhirCqlType(name="Money", is_backbone_element=True),
        "bodySite": FhirCqlType(name="Concept", is_backbone_element=False),
        "subSite": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "noteNumber": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "adjudication": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ClaimResponse_Adjudication", is_backbone_element=True
            ),
        ),
        "detail": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ClaimResponse_Detail1", is_backbone_element=True
            ),
        ),
    },
    "ClaimResponse_Adjudication": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "category": FhirCqlType(name="Concept", is_backbone_element=False),
        "reason": FhirCqlType(name="Concept", is_backbone_element=False),
        "amount": FhirCqlType(name="Money", is_backbone_element=True),
        "value": FhirCqlType(name="Decimal", is_backbone_element=False),
    },
    "ClaimResponse_Detail": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "detailSequence": FhirCqlType(name="String", is_backbone_element=False),
        "noteNumber": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "adjudication": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ClaimResponse_Adjudication", is_backbone_element=True
            ),
        ),
        "subDetail": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ClaimResponse_SubDetail", is_backbone_element=True
            ),
        ),
    },
    "ClaimResponse_Detail1": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "productOrService": FhirCqlType(name="Concept", is_backbone_element=False),
        "modifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "quantity": FhirCqlType(name="Decimal", is_backbone_element=False),
        "unitPrice": FhirCqlType(name="Money", is_backbone_element=True),
        "factor": FhirCqlType(name="Decimal", is_backbone_element=False),
        "net": FhirCqlType(name="Money", is_backbone_element=True),
        "noteNumber": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "adjudication": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ClaimResponse_Adjudication", is_backbone_element=True
            ),
        ),
        "subDetail": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ClaimResponse_SubDetail1", is_backbone_element=True
            ),
        ),
    },
    "ClaimResponse_Error": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "itemSequence": FhirCqlType(name="String", is_backbone_element=False),
        "detailSequence": FhirCqlType(name="String", is_backbone_element=False),
        "subDetailSequence": FhirCqlType(name="String", is_backbone_element=False),
        "code": FhirCqlType(name="Concept", is_backbone_element=False),
    },
    "ClaimResponse_Insurance": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "sequence": FhirCqlType(name="String", is_backbone_element=False),
        "focal": FhirCqlType(name="Boolean", is_backbone_element=False),
        "coverage": FhirCqlType(name="Reference", is_backbone_element=True),
        "businessArrangement": FhirCqlType(name="String", is_backbone_element=False),
        "claimResponse": FhirCqlType(name="Reference", is_backbone_element=True),
    },
    "ClaimResponse_Item": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "itemSequence": FhirCqlType(name="String", is_backbone_element=False),
        "noteNumber": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "adjudication": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ClaimResponse_Adjudication", is_backbone_element=True
            ),
        ),
        "detail": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ClaimResponse_Detail", is_backbone_element=True
            ),
        ),
    },
    "ClaimResponse_Payment": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "adjustment": FhirCqlType(name="Money", is_backbone_element=True),
        "adjustmentReason": FhirCqlType(name="Concept", is_backbone_element=False),
        "date": FhirCqlType(name="Date", is_backbone_element=False),
        "amount": FhirCqlType(name="Money", is_backbone_element=True),
        "identifier": FhirCqlType(name="Identifier", is_backbone_element=True),
    },
    "ClaimResponse_ProcessNote": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "number": FhirCqlType(name="String", is_backbone_element=False),
        "type": FhirCqlType(name="String", is_backbone_element=False),
        "text": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Concept", is_backbone_element=False),
    },
    "ClaimResponse_SubDetail": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "subDetailSequence": FhirCqlType(name="String", is_backbone_element=False),
        "noteNumber": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "adjudication": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ClaimResponse_Adjudication", is_backbone_element=True
            ),
        ),
    },
    "ClaimResponse_SubDetail1": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "productOrService": FhirCqlType(name="Concept", is_backbone_element=False),
        "modifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "quantity": FhirCqlType(name="Decimal", is_backbone_element=False),
        "unitPrice": FhirCqlType(name="Money", is_backbone_element=True),
        "factor": FhirCqlType(name="Decimal", is_backbone_element=False),
        "net": FhirCqlType(name="Money", is_backbone_element=True),
        "noteNumber": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "adjudication": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ClaimResponse_Adjudication", is_backbone_element=True
            ),
        ),
    },
    "ClaimResponse_Total": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "category": FhirCqlType(name="Concept", is_backbone_element=False),
        "amount": FhirCqlType(name="Money", is_backbone_element=True),
    },
    "Claim_Accident": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "date": FhirCqlType(name="Date", is_backbone_element=False),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "location": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Address", is_backbone_element=True),
                FhirCqlType(name="Reference", is_backbone_element=True),
            ],
        ),
    },
    "Claim_CareTeam": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "sequence": FhirCqlType(name="String", is_backbone_element=False),
        "provider": FhirCqlType(name="Reference", is_backbone_element=True),
        "responsible": FhirCqlType(name="Boolean", is_backbone_element=False),
        "role": FhirCqlType(name="Concept", is_backbone_element=False),
        "qualification": FhirCqlType(name="Concept", is_backbone_element=False),
    },
    "Claim_Detail": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "sequence": FhirCqlType(name="String", is_backbone_element=False),
        "revenue": FhirCqlType(name="Concept", is_backbone_element=False),
        "category": FhirCqlType(name="Concept", is_backbone_element=False),
        "productOrService": FhirCqlType(name="Concept", is_backbone_element=False),
        "modifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "programCode": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "quantity": FhirCqlType(name="Decimal", is_backbone_element=False),
        "unitPrice": FhirCqlType(name="Money", is_backbone_element=True),
        "factor": FhirCqlType(name="Decimal", is_backbone_element=False),
        "net": FhirCqlType(name="Money", is_backbone_element=True),
        "udi": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "subDetail": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Claim_SubDetail", is_backbone_element=True),
        ),
    },
    "Claim_Diagnosis": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "sequence": FhirCqlType(name="String", is_backbone_element=False),
        "diagnosis": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Concept", is_backbone_element=False),
                FhirCqlType(name="Reference", is_backbone_element=True),
            ],
        ),
        "type": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "onAdmission": FhirCqlType(name="Concept", is_backbone_element=False),
        "packageCode": FhirCqlType(name="Concept", is_backbone_element=False),
    },
    "Claim_Insurance": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "sequence": FhirCqlType(name="String", is_backbone_element=False),
        "focal": FhirCqlType(name="Boolean", is_backbone_element=False),
        "identifier": FhirCqlType(name="Identifier", is_backbone_element=True),
        "coverage": FhirCqlType(name="Reference", is_backbone_element=True),
        "businessArrangement": FhirCqlType(name="String", is_backbone_element=False),
        "preAuthRef": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "claimResponse": FhirCqlType(name="Reference", is_backbone_element=True),
    },
    "Claim_Item": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "sequence": FhirCqlType(name="String", is_backbone_element=False),
        "careTeamSequence": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "diagnosisSequence": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "procedureSequence": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "informationSequence": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "revenue": FhirCqlType(name="Concept", is_backbone_element=False),
        "category": FhirCqlType(name="Concept", is_backbone_element=False),
        "productOrService": FhirCqlType(name="Concept", is_backbone_element=False),
        "modifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "programCode": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "serviced": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Date", is_backbone_element=False),
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
                ),
            ],
        ),
        "location": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Address", is_backbone_element=True),
                FhirCqlType(name="Concept", is_backbone_element=False),
                FhirCqlType(name="Reference", is_backbone_element=True),
            ],
        ),
        "quantity": FhirCqlType(name="Decimal", is_backbone_element=False),
        "unitPrice": FhirCqlType(name="Money", is_backbone_element=True),
        "factor": FhirCqlType(name="Decimal", is_backbone_element=False),
        "net": FhirCqlType(name="Money", is_backbone_element=True),
        "udi": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "bodySite": FhirCqlType(name="Concept", is_backbone_element=False),
        "subSite": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "encounter": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "detail": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Claim_Detail", is_backbone_element=True),
        ),
    },
    "Claim_Payee": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "party": FhirCqlType(name="Reference", is_backbone_element=True),
    },
    "Claim_Procedure": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "sequence": FhirCqlType(name="String", is_backbone_element=False),
        "type": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "date": FhirCqlType(name="DateTime", is_backbone_element=False),
        "procedure": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Concept", is_backbone_element=False),
                FhirCqlType(name="Reference", is_backbone_element=True),
            ],
        ),
        "udi": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
    },
    "Claim_Related": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "claim": FhirCqlType(name="Reference", is_backbone_element=True),
        "relationship": FhirCqlType(name="Concept", is_backbone_element=False),
        "reference": FhirCqlType(name="Identifier", is_backbone_element=True),
    },
    "Claim_SubDetail": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "sequence": FhirCqlType(name="String", is_backbone_element=False),
        "revenue": FhirCqlType(name="Concept", is_backbone_element=False),
        "category": FhirCqlType(name="Concept", is_backbone_element=False),
        "productOrService": FhirCqlType(name="Concept", is_backbone_element=False),
        "modifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "programCode": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "quantity": FhirCqlType(name="Decimal", is_backbone_element=False),
        "unitPrice": FhirCqlType(name="Money", is_backbone_element=True),
        "factor": FhirCqlType(name="Decimal", is_backbone_element=False),
        "net": FhirCqlType(name="Money", is_backbone_element=True),
        "udi": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
    },
    "Claim_SupportingInfo": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "sequence": FhirCqlType(name="String", is_backbone_element=False),
        "category": FhirCqlType(name="Concept", is_backbone_element=False),
        "code": FhirCqlType(name="Concept", is_backbone_element=False),
        "timing": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Date", is_backbone_element=False),
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
                ),
            ],
        ),
        "value": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Reference", is_backbone_element=True),
                FhirCqlType(name="Attachment", is_backbone_element=True),
                FhirCqlType(name="String", is_backbone_element=False),
                FhirCqlType(name="Decimal", is_backbone_element=False),
                FhirCqlType(name="Boolean", is_backbone_element=False),
            ],
        ),
        "reason": FhirCqlType(name="Concept", is_backbone_element=False),
    },
    "ClinicalImpression_Finding": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "itemCodeableConcept": FhirCqlType(name="Concept", is_backbone_element=False),
        "itemReference": FhirCqlType(name="Reference", is_backbone_element=True),
        "basis": FhirCqlType(name="String", is_backbone_element=False),
    },
    "ClinicalImpression_Investigation": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "code": FhirCqlType(name="Concept", is_backbone_element=False),
        "item": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
    },
    "CodeSystem_Concept": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "code": FhirCqlType(name="Code", is_backbone_element=False),
        "display": FhirCqlType(name="String", is_backbone_element=False),
        "definition": FhirCqlType(name="String", is_backbone_element=False),
        "designation": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="CodeSystem_Designation", is_backbone_element=True
            ),
        ),
        "property": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="CodeSystem_Property1", is_backbone_element=True
            ),
        ),
        "concept": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="CodeSystem_Concept", is_backbone_element=True),
        ),
    },
    "CodeSystem_Designation": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "use": FhirCqlType(name="Code", is_backbone_element=False),
        "value": FhirCqlType(name="String", is_backbone_element=False),
    },
    "CodeSystem_Filter": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "code": FhirCqlType(name="Code", is_backbone_element=False),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "operator": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Code", is_backbone_element=False),
        ),
        "value": FhirCqlType(name="String", is_backbone_element=False),
    },
    "CodeSystem_Property": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "code": FhirCqlType(name="Code", is_backbone_element=False),
        "uri": FhirCqlType(name="String", is_backbone_element=False),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "type": FhirCqlType(name="String", is_backbone_element=False),
    },
    "CodeSystem_Property1": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "code": FhirCqlType(name="Code", is_backbone_element=False),
        "value": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Code", is_backbone_element=False),
                FhirCqlType(name="Boolean", is_backbone_element=False),
                FhirCqlType(name="String", is_backbone_element=False),
                FhirCqlType(name="DateTime", is_backbone_element=False),
            ],
        ),
    },
    "CodeableConcept": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "coding": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Code", is_backbone_element=False),
        ),
        "text": FhirCqlType(name="String", is_backbone_element=False),
    },
    "Coding": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "system": FhirCqlType(name="String", is_backbone_element=False),
        "version": FhirCqlType(name="String", is_backbone_element=False),
        "code": FhirCqlType(name="Code", is_backbone_element=False),
        "display": FhirCqlType(name="String", is_backbone_element=False),
        "userSelected": FhirCqlType(name="Boolean", is_backbone_element=False),
    },
    "CommunicationRequest_Payload": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "content": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Reference", is_backbone_element=True),
                FhirCqlType(name="Attachment", is_backbone_element=True),
                FhirCqlType(name="String", is_backbone_element=False),
            ],
        ),
    },
    "Communication_Payload": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "content": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Reference", is_backbone_element=True),
                FhirCqlType(name="Attachment", is_backbone_element=True),
                FhirCqlType(name="String", is_backbone_element=False),
            ],
        ),
    },
    "CompartmentDefinition_Resource": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "code": FhirCqlType(name="Code", is_backbone_element=False),
        "param": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "documentation": FhirCqlType(name="String", is_backbone_element=False),
    },
    "Composition_Attester": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "mode": FhirCqlType(name="String", is_backbone_element=False),
        "time": FhirCqlType(name="DateTime", is_backbone_element=False),
        "party": FhirCqlType(name="Reference", is_backbone_element=True),
    },
    "Composition_Event": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "code": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "period": FhirInterval(
            name="Interval",
            is_backbone_element=False,
            item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
        ),
        "detail": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
    },
    "Composition_RelatesTo": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "code": FhirCqlType(name="Code", is_backbone_element=False),
        "target": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Reference", is_backbone_element=True),
                FhirCqlType(name="Identifier", is_backbone_element=True),
            ],
        ),
    },
    "Composition_Section": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "title": FhirCqlType(name="String", is_backbone_element=False),
        "code": FhirCqlType(name="Concept", is_backbone_element=False),
        "author": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "focus": FhirCqlType(name="Reference", is_backbone_element=True),
        "text": FhirCqlType(name="Narrative", is_backbone_element=True),
        "mode": FhirCqlType(name="Code", is_backbone_element=False),
        "orderedBy": FhirCqlType(name="Concept", is_backbone_element=False),
        "entry": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "emptyReason": FhirCqlType(name="Concept", is_backbone_element=False),
        "section": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Composition_Section", is_backbone_element=True),
        ),
    },
    "ConceptMap_DependsOn": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "property": FhirCqlType(name="String", is_backbone_element=False),
        "system": FhirCqlType(name="String", is_backbone_element=False),
        "value": FhirCqlType(name="String", is_backbone_element=False),
        "display": FhirCqlType(name="String", is_backbone_element=False),
    },
    "ConceptMap_Element": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "code": FhirCqlType(name="Code", is_backbone_element=False),
        "display": FhirCqlType(name="String", is_backbone_element=False),
        "target": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ConceptMap_Target", is_backbone_element=True),
        ),
    },
    "ConceptMap_Group": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "source": FhirCqlType(name="String", is_backbone_element=False),
        "": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[FhirCqlType(name="String", is_backbone_element=False)],
        ),
        "target": FhirCqlType(name="String", is_backbone_element=False),
        "element": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ConceptMap_Element", is_backbone_element=True),
        ),
        "unmapped": FhirCqlType(name="ConceptMap_Unmapped", is_backbone_element=True),
    },
    "ConceptMap_Target": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "code": FhirCqlType(name="Code", is_backbone_element=False),
        "display": FhirCqlType(name="String", is_backbone_element=False),
        "equivalence": FhirCqlType(name="String", is_backbone_element=False),
        "comment": FhirCqlType(name="String", is_backbone_element=False),
        "dependsOn": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ConceptMap_DependsOn", is_backbone_element=True
            ),
        ),
        "product": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ConceptMap_DependsOn", is_backbone_element=True
            ),
        ),
    },
    "ConceptMap_Unmapped": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "mode": FhirCqlType(name="String", is_backbone_element=False),
        "code": FhirCqlType(name="Code", is_backbone_element=False),
        "display": FhirCqlType(name="String", is_backbone_element=False),
        "url": FhirCqlType(name="String", is_backbone_element=False),
    },
    "Condition_Evidence": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "code": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "detail": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
    },
    "Condition_Stage": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "summary": FhirCqlType(name="Concept", is_backbone_element=False),
        "assessment": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
    },
    "Consent_Actor": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "role": FhirCqlType(name="Concept", is_backbone_element=False),
        "reference": FhirCqlType(name="Reference", is_backbone_element=True),
    },
    "Consent_Data": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "meaning": FhirCqlType(name="String", is_backbone_element=False),
        "reference": FhirCqlType(name="Reference", is_backbone_element=True),
    },
    "Consent_Policy": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "authority": FhirCqlType(name="String", is_backbone_element=False),
        "uri": FhirCqlType(name="String", is_backbone_element=False),
    },
    "Consent_Provision": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "type": FhirCqlType(name="String", is_backbone_element=False),
        "period": FhirInterval(
            name="Interval",
            is_backbone_element=False,
            item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
        ),
        "actor": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Consent_Actor", is_backbone_element=True),
        ),
        "action": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "securityLabel": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Code", is_backbone_element=False),
        ),
        "purpose": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Code", is_backbone_element=False),
        ),
        "class": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Code", is_backbone_element=False),
        ),
        "code": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "dataPeriod": FhirInterval(
            name="Interval",
            is_backbone_element=False,
            item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
        ),
        "data": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Consent_Data", is_backbone_element=True),
        ),
        "provision": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Consent_Provision", is_backbone_element=True),
        ),
    },
    "Consent_Verification": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "verified": FhirCqlType(name="Boolean", is_backbone_element=False),
        "verifiedWith": FhirCqlType(name="Reference", is_backbone_element=True),
        "verificationDate": FhirCqlType(name="DateTime", is_backbone_element=False),
    },
    "ContactDetail": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "name": FhirCqlType(name="String", is_backbone_element=False),
        "telecom": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactPoint", is_backbone_element=True),
        ),
    },
    "ContactPoint": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "system": FhirCqlType(name="String", is_backbone_element=False),
        "value": FhirCqlType(name="String", is_backbone_element=False),
        "use": FhirCqlType(name="String", is_backbone_element=False),
        "rank": FhirCqlType(name="String", is_backbone_element=False),
        "period": FhirInterval(
            name="Interval",
            is_backbone_element=False,
            item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
        ),
    },
    "Contract_Action": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "doNotPerform": FhirCqlType(name="Boolean", is_backbone_element=False),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "subject": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Contract_Subject", is_backbone_element=True),
        ),
        "intent": FhirCqlType(name="Concept", is_backbone_element=False),
        "linkId": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "status": FhirCqlType(name="Concept", is_backbone_element=False),
        "context": FhirCqlType(name="Reference", is_backbone_element=True),
        "": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirList(
                    name="List",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="String", is_backbone_element=False),
                )
            ],
        ),
        "occurrence": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Timing", is_backbone_element=True),
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
                ),
                FhirCqlType(name="DateTime", is_backbone_element=False),
            ],
        ),
        "requester": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "performerType": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "performerRole": FhirCqlType(name="Concept", is_backbone_element=False),
        "performer": FhirCqlType(name="Reference", is_backbone_element=True),
        "performerLinkId": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "reasonCode": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "reasonReference": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "reason": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "reasonLinkId": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "note": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Annotation", is_backbone_element=True),
        ),
        "securityLabelNumber": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
    },
    "Contract_Answer": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "value": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Attachment", is_backbone_element=True),
                FhirCqlType(name="String", is_backbone_element=False),
                FhirCqlType(name="Reference", is_backbone_element=True),
                FhirCqlType(name="Date", is_backbone_element=False),
                FhirCqlType(name="Decimal", is_backbone_element=False),
                FhirCqlType(name="Boolean", is_backbone_element=False),
                FhirCqlType(name="Code", is_backbone_element=False),
                FhirCqlType(name="DateTime", is_backbone_element=False),
            ],
        ),
    },
    "Contract_Asset": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "scope": FhirCqlType(name="Concept", is_backbone_element=False),
        "type": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "typeReference": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "subtype": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "relationship": FhirCqlType(name="Code", is_backbone_element=False),
        "context": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Contract_Context", is_backbone_element=True),
        ),
        "condition": FhirCqlType(name="String", is_backbone_element=False),
        "periodType": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "period": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirInterval(
                name="Interval",
                is_backbone_element=False,
                item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
            ),
        ),
        "usePeriod": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirInterval(
                name="Interval",
                is_backbone_element=False,
                item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
            ),
        ),
        "text": FhirCqlType(name="String", is_backbone_element=False),
        "linkId": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "answer": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Contract_Answer", is_backbone_element=True),
        ),
        "securityLabelNumber": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "valuedItem": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Contract_ValuedItem", is_backbone_element=True),
        ),
    },
    "Contract_ContentDefinition": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "subType": FhirCqlType(name="Concept", is_backbone_element=False),
        "publisher": FhirCqlType(name="Reference", is_backbone_element=True),
        "publicationDate": FhirCqlType(name="DateTime", is_backbone_element=False),
        "publicationStatus": FhirCqlType(name="Code", is_backbone_element=False),
        "copyright": FhirCqlType(name="String", is_backbone_element=False),
    },
    "Contract_Context": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "reference": FhirCqlType(name="Reference", is_backbone_element=True),
        "code": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "text": FhirCqlType(name="String", is_backbone_element=False),
    },
    "Contract_Friendly": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "content": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Reference", is_backbone_element=True),
                FhirCqlType(name="Attachment", is_backbone_element=True),
            ],
        ),
    },
    "Contract_Legal": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "content": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Reference", is_backbone_element=True),
                FhirCqlType(name="Attachment", is_backbone_element=True),
            ],
        ),
    },
    "Contract_Offer": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "party": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Contract_Party", is_backbone_element=True),
        ),
        "topic": FhirCqlType(name="Reference", is_backbone_element=True),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "decision": FhirCqlType(name="Concept", is_backbone_element=False),
        "decisionMode": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "answer": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Contract_Answer", is_backbone_element=True),
        ),
        "text": FhirCqlType(name="String", is_backbone_element=False),
        "linkId": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "securityLabelNumber": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
    },
    "Contract_Party": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "reference": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "role": FhirCqlType(name="Concept", is_backbone_element=False),
    },
    "Contract_Rule": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "content": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Reference", is_backbone_element=True),
                FhirCqlType(name="Attachment", is_backbone_element=True),
            ],
        ),
    },
    "Contract_SecurityLabel": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "number": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "classification": FhirCqlType(name="Code", is_backbone_element=False),
        "category": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Code", is_backbone_element=False),
        ),
        "control": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Code", is_backbone_element=False),
        ),
    },
    "Contract_Signer": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "type": FhirCqlType(name="Code", is_backbone_element=False),
        "party": FhirCqlType(name="Reference", is_backbone_element=True),
        "signature": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Signature", is_backbone_element=True),
        ),
    },
    "Contract_Subject": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "reference": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "role": FhirCqlType(name="Concept", is_backbone_element=False),
    },
    "Contract_Term": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirCqlType(name="Identifier", is_backbone_element=True),
        "issued": FhirCqlType(name="DateTime", is_backbone_element=False),
        "applies": FhirInterval(
            name="Interval",
            is_backbone_element=False,
            item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
        ),
        "topic": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Concept", is_backbone_element=False),
                FhirCqlType(name="Reference", is_backbone_element=True),
            ],
        ),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "subType": FhirCqlType(name="Concept", is_backbone_element=False),
        "text": FhirCqlType(name="String", is_backbone_element=False),
        "securityLabel": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="Contract_SecurityLabel", is_backbone_element=True
            ),
        ),
        "offer": FhirCqlType(name="Contract_Offer", is_backbone_element=True),
        "asset": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Contract_Asset", is_backbone_element=True),
        ),
        "action": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Contract_Action", is_backbone_element=True),
        ),
        "group": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Contract_Term", is_backbone_element=True),
        ),
    },
    "Contract_ValuedItem": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "entity": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Concept", is_backbone_element=False),
                FhirCqlType(name="Reference", is_backbone_element=True),
            ],
        ),
        "identifier": FhirCqlType(name="Identifier", is_backbone_element=True),
        "effectiveTime": FhirCqlType(name="DateTime", is_backbone_element=False),
        "quantity": FhirCqlType(name="Decimal", is_backbone_element=False),
        "unitPrice": FhirCqlType(name="Money", is_backbone_element=True),
        "factor": FhirCqlType(name="Decimal", is_backbone_element=False),
        "points": FhirCqlType(name="Decimal", is_backbone_element=False),
        "net": FhirCqlType(name="Money", is_backbone_element=True),
        "payment": FhirCqlType(name="String", is_backbone_element=False),
        "paymentDate": FhirCqlType(name="DateTime", is_backbone_element=False),
        "responsible": FhirCqlType(name="Reference", is_backbone_element=True),
        "recipient": FhirCqlType(name="Reference", is_backbone_element=True),
        "linkId": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "securityLabelNumber": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
    },
    "Contributor": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "type": FhirCqlType(name="String", is_backbone_element=False),
        "name": FhirCqlType(name="String", is_backbone_element=False),
        "contact": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactDetail", is_backbone_element=True),
        ),
    },
    "Count": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "value": FhirCqlType(name="Decimal", is_backbone_element=False),
        "comparator": FhirCqlType(name="String", is_backbone_element=False),
        "unit": FhirCqlType(name="String", is_backbone_element=False),
        "system": FhirCqlType(name="String", is_backbone_element=False),
        "code": FhirCqlType(name="Code", is_backbone_element=False),
    },
    "CoverageEligibilityRequest_Diagnosis": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "diagnosis": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Concept", is_backbone_element=False),
                FhirCqlType(name="Reference", is_backbone_element=True),
            ],
        ),
    },
    "CoverageEligibilityRequest_Insurance": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "focal": FhirCqlType(name="Boolean", is_backbone_element=False),
        "coverage": FhirCqlType(name="Reference", is_backbone_element=True),
        "businessArrangement": FhirCqlType(name="String", is_backbone_element=False),
    },
    "CoverageEligibilityRequest_Item": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "supportingInfoSequence": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "category": FhirCqlType(name="Concept", is_backbone_element=False),
        "productOrService": FhirCqlType(name="Concept", is_backbone_element=False),
        "modifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "provider": FhirCqlType(name="Reference", is_backbone_element=True),
        "quantity": FhirCqlType(name="Decimal", is_backbone_element=False),
        "unitPrice": FhirCqlType(name="Money", is_backbone_element=True),
        "facility": FhirCqlType(name="Reference", is_backbone_element=True),
        "diagnosis": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="CoverageEligibilityRequest_Diagnosis", is_backbone_element=True
            ),
        ),
        "detail": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
    },
    "CoverageEligibilityRequest_SupportingInfo": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "sequence": FhirCqlType(name="String", is_backbone_element=False),
        "information": FhirCqlType(name="Reference", is_backbone_element=True),
        "appliesToAll": FhirCqlType(name="Boolean", is_backbone_element=False),
    },
    "CoverageEligibilityResponse_Benefit": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "allowed": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Money", is_backbone_element=True),
                FhirCqlType(name="String", is_backbone_element=False),
            ],
        ),
        "used": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Money", is_backbone_element=True),
                FhirCqlType(name="String", is_backbone_element=False),
            ],
        ),
    },
    "CoverageEligibilityResponse_Error": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "code": FhirCqlType(name="Concept", is_backbone_element=False),
    },
    "CoverageEligibilityResponse_Insurance": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "coverage": FhirCqlType(name="Reference", is_backbone_element=True),
        "inforce": FhirCqlType(name="Boolean", is_backbone_element=False),
        "benefitPeriod": FhirInterval(
            name="Interval",
            is_backbone_element=False,
            item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
        ),
        "item": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="CoverageEligibilityResponse_Item", is_backbone_element=True
            ),
        ),
    },
    "CoverageEligibilityResponse_Item": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "category": FhirCqlType(name="Concept", is_backbone_element=False),
        "productOrService": FhirCqlType(name="Concept", is_backbone_element=False),
        "modifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "provider": FhirCqlType(name="Reference", is_backbone_element=True),
        "excluded": FhirCqlType(name="Boolean", is_backbone_element=False),
        "name": FhirCqlType(name="String", is_backbone_element=False),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "network": FhirCqlType(name="Concept", is_backbone_element=False),
        "unit": FhirCqlType(name="Concept", is_backbone_element=False),
        "term": FhirCqlType(name="Concept", is_backbone_element=False),
        "benefit": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="CoverageEligibilityResponse_Benefit", is_backbone_element=True
            ),
        ),
        "authorizationRequired": FhirCqlType(name="Boolean", is_backbone_element=False),
        "authorizationSupporting": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "authorizationUrl": FhirCqlType(name="String", is_backbone_element=False),
    },
    "Coverage_Class": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "value": FhirCqlType(name="String", is_backbone_element=False),
        "name": FhirCqlType(name="String", is_backbone_element=False),
    },
    "Coverage_CostToBeneficiary": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "value": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Money", is_backbone_element=True),
                FhirCqlType(name="Decimal", is_backbone_element=False),
            ],
        ),
        "exception": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Coverage_Exception", is_backbone_element=True),
        ),
    },
    "Coverage_Exception": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "period": FhirInterval(
            name="Interval",
            is_backbone_element=False,
            item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
        ),
    },
    "DataRequirement": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "type": FhirCqlType(name="Code", is_backbone_element=False),
        "profile": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "subject": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Concept", is_backbone_element=False),
                FhirCqlType(name="Reference", is_backbone_element=True),
            ],
        ),
        "mustSupport": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "codeFilter": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="DataRequirement_CodeFilter", is_backbone_element=True
            ),
        ),
        "dateFilter": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="DataRequirement_DateFilter", is_backbone_element=True
            ),
        ),
        "limit": FhirCqlType(name="String", is_backbone_element=False),
        "sort": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="DataRequirement_Sort", is_backbone_element=True
            ),
        ),
    },
    "DataRequirement_CodeFilter": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "path": FhirCqlType(name="String", is_backbone_element=False),
        "searchParam": FhirCqlType(name="String", is_backbone_element=False),
        "valueSet": FhirCqlType(name="String", is_backbone_element=False),
        "code": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Code", is_backbone_element=False),
        ),
    },
    "DataRequirement_DateFilter": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "path": FhirCqlType(name="String", is_backbone_element=False),
        "searchParam": FhirCqlType(name="String", is_backbone_element=False),
        "value": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Duration", is_backbone_element=True),
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
                ),
                FhirCqlType(name="DateTime", is_backbone_element=False),
            ],
        ),
    },
    "DataRequirement_Sort": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "path": FhirCqlType(name="String", is_backbone_element=False),
        "direction": FhirCqlType(name="String", is_backbone_element=False),
    },
    "DetectedIssue_Evidence": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "code": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "detail": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
    },
    "DetectedIssue_Mitigation": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "action": FhirCqlType(name="Concept", is_backbone_element=False),
        "date": FhirCqlType(name="DateTime", is_backbone_element=False),
        "author": FhirCqlType(name="Reference", is_backbone_element=True),
    },
    "DeviceDefinition_Capability": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "description": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
    },
    "DeviceDefinition_DeviceName": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "name": FhirCqlType(name="String", is_backbone_element=False),
        "type": FhirCqlType(name="String", is_backbone_element=False),
    },
    "DeviceDefinition_Material": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "substance": FhirCqlType(name="Concept", is_backbone_element=False),
        "alternate": FhirCqlType(name="Boolean", is_backbone_element=False),
        "allergenicIndicator": FhirCqlType(name="Boolean", is_backbone_element=False),
    },
    "DeviceDefinition_Property": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "valueQuantity": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Decimal", is_backbone_element=False),
        ),
        "valueCode": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
    },
    "DeviceDefinition_Specialization": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "systemType": FhirCqlType(name="String", is_backbone_element=False),
        "version": FhirCqlType(name="String", is_backbone_element=False),
    },
    "DeviceDefinition_UdiDeviceIdentifier": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "deviceIdentifier": FhirCqlType(name="String", is_backbone_element=False),
        "issuer": FhirCqlType(name="String", is_backbone_element=False),
        "jurisdiction": FhirCqlType(name="String", is_backbone_element=False),
    },
    "DeviceMetric_Calibration": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "type": FhirCqlType(name="String", is_backbone_element=False),
        "state": FhirCqlType(name="String", is_backbone_element=False),
        "time": FhirCqlType(name="String", is_backbone_element=False),
    },
    "DeviceRequest_Parameter": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "code": FhirCqlType(name="Concept", is_backbone_element=False),
        "value": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Decimal", is_backbone_element=False),
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="Decimal", is_backbone_element=False),
                ),
                FhirCqlType(name="Concept", is_backbone_element=False),
                FhirCqlType(name="Boolean", is_backbone_element=False),
            ],
        ),
    },
    "Device_DeviceName": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "name": FhirCqlType(name="String", is_backbone_element=False),
        "type": FhirCqlType(name="String", is_backbone_element=False),
    },
    "Device_Property": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "valueQuantity": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Decimal", is_backbone_element=False),
        ),
        "valueCode": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
    },
    "Device_Specialization": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "systemType": FhirCqlType(name="Concept", is_backbone_element=False),
        "version": FhirCqlType(name="String", is_backbone_element=False),
    },
    "Device_UdiCarrier": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "deviceIdentifier": FhirCqlType(name="String", is_backbone_element=False),
        "issuer": FhirCqlType(name="String", is_backbone_element=False),
        "jurisdiction": FhirCqlType(name="String", is_backbone_element=False),
        "carrierAIDC": FhirCqlType(name="String", is_backbone_element=False),
        "carrierHRF": FhirCqlType(name="String", is_backbone_element=False),
        "entryType": FhirCqlType(name="String", is_backbone_element=False),
    },
    "Device_Version": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "component": FhirCqlType(name="Identifier", is_backbone_element=True),
        "value": FhirCqlType(name="String", is_backbone_element=False),
    },
    "DiagnosticReport_Media": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "comment": FhirCqlType(name="String", is_backbone_element=False),
        "link": FhirCqlType(name="Reference", is_backbone_element=True),
    },
    "Distance": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "value": FhirCqlType(name="Decimal", is_backbone_element=False),
        "comparator": FhirCqlType(name="String", is_backbone_element=False),
        "unit": FhirCqlType(name="String", is_backbone_element=False),
        "system": FhirCqlType(name="String", is_backbone_element=False),
        "code": FhirCqlType(name="Code", is_backbone_element=False),
    },
    "DocumentManifest_Related": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirCqlType(name="Identifier", is_backbone_element=True),
        "ref": FhirCqlType(name="Reference", is_backbone_element=True),
    },
    "DocumentReference_Content": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "attachment": FhirCqlType(name="Attachment", is_backbone_element=True),
        "format": FhirCqlType(name="Code", is_backbone_element=False),
    },
    "DocumentReference_Context": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "encounter": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "event": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "period": FhirInterval(
            name="Interval",
            is_backbone_element=False,
            item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
        ),
        "facilityType": FhirCqlType(name="Concept", is_backbone_element=False),
        "practiceSetting": FhirCqlType(name="Concept", is_backbone_element=False),
        "sourcePatientInfo": FhirCqlType(name="Reference", is_backbone_element=True),
        "related": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
    },
    "DocumentReference_RelatesTo": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "code": FhirCqlType(name="String", is_backbone_element=False),
        "target": FhirCqlType(name="Reference", is_backbone_element=True),
    },
    "Dosage": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "sequence": FhirCqlType(name="Integer", is_backbone_element=False),
        "text": FhirCqlType(name="String", is_backbone_element=False),
        "additionalInstruction": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "patientInstruction": FhirCqlType(name="String", is_backbone_element=False),
        "timing": FhirCqlType(name="Timing", is_backbone_element=True),
        "asNeeded": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Boolean", is_backbone_element=False),
                FhirCqlType(name="Concept", is_backbone_element=False),
            ],
        ),
        "site": FhirCqlType(name="Concept", is_backbone_element=False),
        "route": FhirCqlType(name="Concept", is_backbone_element=False),
        "method": FhirCqlType(name="Concept", is_backbone_element=False),
        "doseAndRate": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Dosage_DoseAndRate", is_backbone_element=True),
        ),
        "maxDosePerPeriod": FhirCqlType(name="Ratio", is_backbone_element=True),
        "maxDosePerAdministration": FhirCqlType(
            name="Decimal", is_backbone_element=False
        ),
        "maxDosePerLifetime": FhirCqlType(name="Decimal", is_backbone_element=False),
    },
    "Dosage_DoseAndRate": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "dose": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Decimal", is_backbone_element=False),
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="Decimal", is_backbone_element=False),
                ),
            ],
        ),
        "rate": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Ratio", is_backbone_element=True),
                FhirCqlType(name="Decimal", is_backbone_element=False),
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="Decimal", is_backbone_element=False),
                ),
            ],
        ),
    },
    "Duration": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "value": FhirCqlType(name="Decimal", is_backbone_element=False),
        "comparator": FhirCqlType(name="String", is_backbone_element=False),
        "unit": FhirCqlType(name="String", is_backbone_element=False),
        "system": FhirCqlType(name="String", is_backbone_element=False),
        "code": FhirCqlType(name="Code", is_backbone_element=False),
    },
    "EffectEvidenceSynthesis_Certainty": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "rating": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "note": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Annotation", is_backbone_element=True),
        ),
        "certaintySubcomponent": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="EffectEvidenceSynthesis_CertaintySubcomponent",
                is_backbone_element=True,
            ),
        ),
    },
    "EffectEvidenceSynthesis_CertaintySubcomponent": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "rating": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "note": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Annotation", is_backbone_element=True),
        ),
    },
    "EffectEvidenceSynthesis_EffectEstimate": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "variantState": FhirCqlType(name="Concept", is_backbone_element=False),
        "value": FhirCqlType(name="Decimal", is_backbone_element=False),
        "unitOfMeasure": FhirCqlType(name="Concept", is_backbone_element=False),
        "precisionEstimate": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="EffectEvidenceSynthesis_PrecisionEstimate",
                is_backbone_element=True,
            ),
        ),
    },
    "EffectEvidenceSynthesis_PrecisionEstimate": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "level": FhirCqlType(name="Decimal", is_backbone_element=False),
        "from": FhirCqlType(name="Decimal", is_backbone_element=False),
        "to": FhirCqlType(name="Decimal", is_backbone_element=False),
    },
    "EffectEvidenceSynthesis_ResultsByExposure": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "exposureState": FhirCqlType(name="String", is_backbone_element=False),
        "variantState": FhirCqlType(name="Concept", is_backbone_element=False),
        "riskEvidenceSynthesis": FhirCqlType(
            name="Reference", is_backbone_element=True
        ),
    },
    "EffectEvidenceSynthesis_SampleSize": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "numberOfStudies": FhirCqlType(name="Integer", is_backbone_element=False),
        "numberOfParticipants": FhirCqlType(name="Integer", is_backbone_element=False),
    },
    "Element": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
    },
    "ElementDefinition": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "path": FhirCqlType(name="String", is_backbone_element=False),
        "representation": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "sliceName": FhirCqlType(name="String", is_backbone_element=False),
        "sliceIsConstraining": FhirCqlType(name="Boolean", is_backbone_element=False),
        "label": FhirCqlType(name="String", is_backbone_element=False),
        "code": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Code", is_backbone_element=False),
        ),
        "slicing": FhirCqlType(
            name="ElementDefinition_Slicing", is_backbone_element=True
        ),
        "short": FhirCqlType(name="String", is_backbone_element=False),
        "definition": FhirCqlType(name="String", is_backbone_element=False),
        "comment": FhirCqlType(name="String", is_backbone_element=False),
        "requirements": FhirCqlType(name="String", is_backbone_element=False),
        "alias": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "min": FhirCqlType(name="String", is_backbone_element=False),
        "max": FhirCqlType(name="String", is_backbone_element=False),
        "base": FhirCqlType(name="ElementDefinition_Base", is_backbone_element=True),
        "contentReference": FhirCqlType(name="String", is_backbone_element=False),
        "type": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ElementDefinition_Type", is_backbone_element=True
            ),
        ),
        "defaultValue": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Distance", is_backbone_element=True),
                FhirCqlType(name="Signature", is_backbone_element=True),
                FhirCqlType(name="Annotation", is_backbone_element=True),
                FhirCqlType(name="Concept", is_backbone_element=False),
                FhirCqlType(name="Age", is_backbone_element=True),
                FhirCqlType(name="HumanName", is_backbone_element=True),
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
                ),
                FhirCqlType(name="SampledData", is_backbone_element=True),
                FhirCqlType(name="Timing", is_backbone_element=True),
                FhirCqlType(name="DateTime", is_backbone_element=False),
                FhirCqlType(name="ContactDetail", is_backbone_element=True),
                FhirCqlType(name="TriggerDefinition", is_backbone_element=True),
                FhirCqlType(name="UsageContext", is_backbone_element=True),
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="Decimal", is_backbone_element=False),
                ),
                FhirCqlType(name="Meta", is_backbone_element=True),
                FhirCqlType(name="Reference", is_backbone_element=True),
                FhirCqlType(name="Date", is_backbone_element=False),
                FhirCqlType(name="Ratio", is_backbone_element=True),
                FhirCqlType(name="Decimal", is_backbone_element=False),
                FhirCqlType(name="Expression", is_backbone_element=True),
                FhirCqlType(name="ParameterDefinition", is_backbone_element=True),
                FhirCqlType(name="Identifier", is_backbone_element=True),
                FhirCqlType(name="RelatedArtifact", is_backbone_element=True),
                FhirCqlType(name="DataRequirement", is_backbone_element=True),
                FhirCqlType(name="Dosage", is_backbone_element=True),
                FhirCqlType(name="Count", is_backbone_element=True),
                FhirCqlType(name="Duration", is_backbone_element=True),
                FhirCqlType(name="ContactPoint", is_backbone_element=True),
                FhirCqlType(name="Money", is_backbone_element=True),
                FhirCqlType(name="Attachment", is_backbone_element=True),
                FhirCqlType(name="String", is_backbone_element=False),
                FhirCqlType(name="Contributor", is_backbone_element=True),
                FhirCqlType(name="Boolean", is_backbone_element=False),
                FhirCqlType(name="Code", is_backbone_element=False),
                FhirCqlType(name="Address", is_backbone_element=True),
            ],
        ),
        "meaningWhenMissing": FhirCqlType(name="String", is_backbone_element=False),
        "orderMeaning": FhirCqlType(name="String", is_backbone_element=False),
        "fixed": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Distance", is_backbone_element=True),
                FhirCqlType(name="Signature", is_backbone_element=True),
                FhirCqlType(name="Annotation", is_backbone_element=True),
                FhirCqlType(name="Concept", is_backbone_element=False),
                FhirCqlType(name="Age", is_backbone_element=True),
                FhirCqlType(name="HumanName", is_backbone_element=True),
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
                ),
                FhirCqlType(name="SampledData", is_backbone_element=True),
                FhirCqlType(name="Timing", is_backbone_element=True),
                FhirCqlType(name="DateTime", is_backbone_element=False),
                FhirCqlType(name="ContactDetail", is_backbone_element=True),
                FhirCqlType(name="TriggerDefinition", is_backbone_element=True),
                FhirCqlType(name="UsageContext", is_backbone_element=True),
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="Decimal", is_backbone_element=False),
                ),
                FhirCqlType(name="Meta", is_backbone_element=True),
                FhirCqlType(name="Reference", is_backbone_element=True),
                FhirCqlType(name="Date", is_backbone_element=False),
                FhirCqlType(name="Ratio", is_backbone_element=True),
                FhirCqlType(name="Decimal", is_backbone_element=False),
                FhirCqlType(name="Expression", is_backbone_element=True),
                FhirCqlType(name="ParameterDefinition", is_backbone_element=True),
                FhirCqlType(name="Identifier", is_backbone_element=True),
                FhirCqlType(name="RelatedArtifact", is_backbone_element=True),
                FhirCqlType(name="DataRequirement", is_backbone_element=True),
                FhirCqlType(name="Dosage", is_backbone_element=True),
                FhirCqlType(name="Count", is_backbone_element=True),
                FhirCqlType(name="Duration", is_backbone_element=True),
                FhirCqlType(name="ContactPoint", is_backbone_element=True),
                FhirCqlType(name="Money", is_backbone_element=True),
                FhirCqlType(name="Attachment", is_backbone_element=True),
                FhirCqlType(name="String", is_backbone_element=False),
                FhirCqlType(name="Contributor", is_backbone_element=True),
                FhirCqlType(name="Boolean", is_backbone_element=False),
                FhirCqlType(name="Code", is_backbone_element=False),
                FhirCqlType(name="Address", is_backbone_element=True),
            ],
        ),
        "pattern": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Distance", is_backbone_element=True),
                FhirCqlType(name="Signature", is_backbone_element=True),
                FhirCqlType(name="Annotation", is_backbone_element=True),
                FhirCqlType(name="Concept", is_backbone_element=False),
                FhirCqlType(name="Age", is_backbone_element=True),
                FhirCqlType(name="HumanName", is_backbone_element=True),
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
                ),
                FhirCqlType(name="SampledData", is_backbone_element=True),
                FhirCqlType(name="Timing", is_backbone_element=True),
                FhirCqlType(name="DateTime", is_backbone_element=False),
                FhirCqlType(name="ContactDetail", is_backbone_element=True),
                FhirCqlType(name="TriggerDefinition", is_backbone_element=True),
                FhirCqlType(name="UsageContext", is_backbone_element=True),
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="Decimal", is_backbone_element=False),
                ),
                FhirCqlType(name="Meta", is_backbone_element=True),
                FhirCqlType(name="Reference", is_backbone_element=True),
                FhirCqlType(name="Date", is_backbone_element=False),
                FhirCqlType(name="Ratio", is_backbone_element=True),
                FhirCqlType(name="Decimal", is_backbone_element=False),
                FhirCqlType(name="Expression", is_backbone_element=True),
                FhirCqlType(name="ParameterDefinition", is_backbone_element=True),
                FhirCqlType(name="Identifier", is_backbone_element=True),
                FhirCqlType(name="RelatedArtifact", is_backbone_element=True),
                FhirCqlType(name="DataRequirement", is_backbone_element=True),
                FhirCqlType(name="Dosage", is_backbone_element=True),
                FhirCqlType(name="Count", is_backbone_element=True),
                FhirCqlType(name="Duration", is_backbone_element=True),
                FhirCqlType(name="ContactPoint", is_backbone_element=True),
                FhirCqlType(name="Money", is_backbone_element=True),
                FhirCqlType(name="Attachment", is_backbone_element=True),
                FhirCqlType(name="String", is_backbone_element=False),
                FhirCqlType(name="Contributor", is_backbone_element=True),
                FhirCqlType(name="Boolean", is_backbone_element=False),
                FhirCqlType(name="Code", is_backbone_element=False),
                FhirCqlType(name="Address", is_backbone_element=True),
            ],
        ),
        "example": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ElementDefinition_Example", is_backbone_element=True
            ),
        ),
        "minValue": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Date", is_backbone_element=False),
                FhirCqlType(name="Decimal", is_backbone_element=False),
                FhirCqlType(name="String", is_backbone_element=False),
                FhirCqlType(name="DateTime", is_backbone_element=False),
            ],
        ),
        "maxValue": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Date", is_backbone_element=False),
                FhirCqlType(name="Decimal", is_backbone_element=False),
                FhirCqlType(name="String", is_backbone_element=False),
                FhirCqlType(name="DateTime", is_backbone_element=False),
            ],
        ),
        "maxLength": FhirCqlType(name="Integer", is_backbone_element=False),
        "condition": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "constraint": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ElementDefinition_Constraint", is_backbone_element=True
            ),
        ),
        "mustSupport": FhirCqlType(name="Boolean", is_backbone_element=False),
        "isModifier": FhirCqlType(name="Boolean", is_backbone_element=False),
        "isModifierReason": FhirCqlType(name="String", is_backbone_element=False),
        "isSummary": FhirCqlType(name="Boolean", is_backbone_element=False),
        "binding": FhirCqlType(
            name="ElementDefinition_Binding", is_backbone_element=True
        ),
        "mapping": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ElementDefinition_Mapping", is_backbone_element=True
            ),
        ),
    },
    "ElementDefinition_Base": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "path": FhirCqlType(name="String", is_backbone_element=False),
        "min": FhirCqlType(name="String", is_backbone_element=False),
        "max": FhirCqlType(name="String", is_backbone_element=False),
    },
    "ElementDefinition_Binding": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "strength": FhirCqlType(name="String", is_backbone_element=False),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "valueSet": FhirCqlType(name="String", is_backbone_element=False),
    },
    "ElementDefinition_Constraint": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "key": FhirCqlType(name="String", is_backbone_element=False),
        "requirements": FhirCqlType(name="String", is_backbone_element=False),
        "severity": FhirCqlType(name="String", is_backbone_element=False),
        "human": FhirCqlType(name="String", is_backbone_element=False),
        "expression": FhirCqlType(name="String", is_backbone_element=False),
        "xpath": FhirCqlType(name="String", is_backbone_element=False),
        "source": FhirCqlType(name="String", is_backbone_element=False),
    },
    "ElementDefinition_Discriminator": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "type": FhirCqlType(name="String", is_backbone_element=False),
        "path": FhirCqlType(name="String", is_backbone_element=False),
    },
    "ElementDefinition_Example": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "label": FhirCqlType(name="String", is_backbone_element=False),
        "value": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Distance", is_backbone_element=True),
                FhirCqlType(name="Signature", is_backbone_element=True),
                FhirCqlType(name="Annotation", is_backbone_element=True),
                FhirCqlType(name="Concept", is_backbone_element=False),
                FhirCqlType(name="Age", is_backbone_element=True),
                FhirCqlType(name="HumanName", is_backbone_element=True),
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
                ),
                FhirCqlType(name="SampledData", is_backbone_element=True),
                FhirCqlType(name="Timing", is_backbone_element=True),
                FhirCqlType(name="DateTime", is_backbone_element=False),
                FhirCqlType(name="ContactDetail", is_backbone_element=True),
                FhirCqlType(name="TriggerDefinition", is_backbone_element=True),
                FhirCqlType(name="UsageContext", is_backbone_element=True),
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="Decimal", is_backbone_element=False),
                ),
                FhirCqlType(name="Meta", is_backbone_element=True),
                FhirCqlType(name="Reference", is_backbone_element=True),
                FhirCqlType(name="Date", is_backbone_element=False),
                FhirCqlType(name="Ratio", is_backbone_element=True),
                FhirCqlType(name="Decimal", is_backbone_element=False),
                FhirCqlType(name="Expression", is_backbone_element=True),
                FhirCqlType(name="ParameterDefinition", is_backbone_element=True),
                FhirCqlType(name="Identifier", is_backbone_element=True),
                FhirCqlType(name="RelatedArtifact", is_backbone_element=True),
                FhirCqlType(name="DataRequirement", is_backbone_element=True),
                FhirCqlType(name="Dosage", is_backbone_element=True),
                FhirCqlType(name="Count", is_backbone_element=True),
                FhirCqlType(name="Duration", is_backbone_element=True),
                FhirCqlType(name="ContactPoint", is_backbone_element=True),
                FhirCqlType(name="Money", is_backbone_element=True),
                FhirCqlType(name="Attachment", is_backbone_element=True),
                FhirCqlType(name="String", is_backbone_element=False),
                FhirCqlType(name="Contributor", is_backbone_element=True),
                FhirCqlType(name="Boolean", is_backbone_element=False),
                FhirCqlType(name="Code", is_backbone_element=False),
                FhirCqlType(name="Address", is_backbone_element=True),
            ],
        ),
    },
    "ElementDefinition_Mapping": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identity": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Code", is_backbone_element=False),
        "map": FhirCqlType(name="String", is_backbone_element=False),
        "comment": FhirCqlType(name="String", is_backbone_element=False),
    },
    "ElementDefinition_Slicing": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "discriminator": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ElementDefinition_Discriminator", is_backbone_element=True
            ),
        ),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "ordered": FhirCqlType(name="Boolean", is_backbone_element=False),
        "rules": FhirCqlType(name="String", is_backbone_element=False),
    },
    "ElementDefinition_Type": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "code": FhirCqlType(name="String", is_backbone_element=False),
        "profile": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "targetProfile": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "aggregation": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "versioning": FhirCqlType(name="String", is_backbone_element=False),
    },
    "Encounter_ClassHistory": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "class": FhirCqlType(name="Code", is_backbone_element=False),
        "period": FhirInterval(
            name="Interval",
            is_backbone_element=False,
            item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
        ),
    },
    "Encounter_Diagnosis": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "condition": FhirCqlType(name="Reference", is_backbone_element=True),
        "use": FhirCqlType(name="Concept", is_backbone_element=False),
        "rank": FhirCqlType(name="String", is_backbone_element=False),
    },
    "Encounter_Hospitalization": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "preAdmissionIdentifier": FhirCqlType(
            name="Identifier", is_backbone_element=True
        ),
        "origin": FhirCqlType(name="Reference", is_backbone_element=True),
        "admitSource": FhirCqlType(name="Concept", is_backbone_element=False),
        "reAdmission": FhirCqlType(name="Concept", is_backbone_element=False),
        "dietPreference": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "specialCourtesy": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "specialArrangement": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "destination": FhirCqlType(name="Reference", is_backbone_element=True),
        "dischargeDisposition": FhirCqlType(name="Concept", is_backbone_element=False),
    },
    "Encounter_Location": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "location": FhirCqlType(name="Reference", is_backbone_element=True),
        "status": FhirCqlType(name="String", is_backbone_element=False),
        "physicalType": FhirCqlType(name="Concept", is_backbone_element=False),
        "period": FhirInterval(
            name="Interval",
            is_backbone_element=False,
            item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
        ),
    },
    "Encounter_Participant": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "type": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "period": FhirInterval(
            name="Interval",
            is_backbone_element=False,
            item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
        ),
        "individual": FhirCqlType(name="Reference", is_backbone_element=True),
    },
    "Encounter_StatusHistory": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "status": FhirCqlType(name="String", is_backbone_element=False),
        "period": FhirInterval(
            name="Interval",
            is_backbone_element=False,
            item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
        ),
    },
    "EpisodeOfCare_Diagnosis": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "condition": FhirCqlType(name="Reference", is_backbone_element=True),
        "role": FhirCqlType(name="Concept", is_backbone_element=False),
        "rank": FhirCqlType(name="String", is_backbone_element=False),
    },
    "EpisodeOfCare_StatusHistory": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "status": FhirCqlType(name="String", is_backbone_element=False),
        "period": FhirInterval(
            name="Interval",
            is_backbone_element=False,
            item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
        ),
    },
    "EvidenceVariable_Characteristic": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "definition": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Reference", is_backbone_element=True),
                FhirCqlType(name="String", is_backbone_element=False),
                FhirCqlType(name="Expression", is_backbone_element=True),
                FhirCqlType(name="DataRequirement", is_backbone_element=True),
                FhirCqlType(name="Concept", is_backbone_element=False),
                FhirCqlType(name="TriggerDefinition", is_backbone_element=True),
            ],
        ),
        "usageContext": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="UsageContext", is_backbone_element=True),
        ),
        "exclude": FhirCqlType(name="Boolean", is_backbone_element=False),
        "participantEffective": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Timing", is_backbone_element=True),
                FhirCqlType(name="Duration", is_backbone_element=True),
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
                ),
                FhirCqlType(name="DateTime", is_backbone_element=False),
            ],
        ),
        "timeFromStart": FhirCqlType(name="Duration", is_backbone_element=True),
        "groupMeasure": FhirCqlType(name="String", is_backbone_element=False),
    },
    "ExampleScenario_Actor": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "actorId": FhirCqlType(name="String", is_backbone_element=False),
        "type": FhirCqlType(name="String", is_backbone_element=False),
        "name": FhirCqlType(name="String", is_backbone_element=False),
        "description": FhirCqlType(name="String", is_backbone_element=False),
    },
    "ExampleScenario_Alternative": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "title": FhirCqlType(name="String", is_backbone_element=False),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "step": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ExampleScenario_Step", is_backbone_element=True
            ),
        ),
    },
    "ExampleScenario_ContainedInstance": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "resourceId": FhirCqlType(name="String", is_backbone_element=False),
        "versionId": FhirCqlType(name="String", is_backbone_element=False),
    },
    "ExampleScenario_Instance": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "resourceId": FhirCqlType(name="String", is_backbone_element=False),
        "resourceType": FhirCqlType(name="Code", is_backbone_element=False),
        "name": FhirCqlType(name="String", is_backbone_element=False),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "version": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ExampleScenario_Version", is_backbone_element=True
            ),
        ),
        "containedInstance": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ExampleScenario_ContainedInstance", is_backbone_element=True
            ),
        ),
    },
    "ExampleScenario_Operation": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "number": FhirCqlType(name="String", is_backbone_element=False),
        "type": FhirCqlType(name="String", is_backbone_element=False),
        "name": FhirCqlType(name="String", is_backbone_element=False),
        "initiator": FhirCqlType(name="String", is_backbone_element=False),
        "receiver": FhirCqlType(name="String", is_backbone_element=False),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "initiatorActive": FhirCqlType(name="Boolean", is_backbone_element=False),
        "receiverActive": FhirCqlType(name="Boolean", is_backbone_element=False),
        "request": FhirCqlType(
            name="ExampleScenario_ContainedInstance", is_backbone_element=True
        ),
        "response": FhirCqlType(
            name="ExampleScenario_ContainedInstance", is_backbone_element=True
        ),
    },
    "ExampleScenario_Process": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "title": FhirCqlType(name="String", is_backbone_element=False),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "preConditions": FhirCqlType(name="String", is_backbone_element=False),
        "postConditions": FhirCqlType(name="String", is_backbone_element=False),
        "step": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ExampleScenario_Step", is_backbone_element=True
            ),
        ),
    },
    "ExampleScenario_Step": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "process": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ExampleScenario_Process", is_backbone_element=True
            ),
        ),
        "pause": FhirCqlType(name="Boolean", is_backbone_element=False),
        "operation": FhirCqlType(
            name="ExampleScenario_Operation", is_backbone_element=True
        ),
        "alternative": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ExampleScenario_Alternative", is_backbone_element=True
            ),
        ),
    },
    "ExampleScenario_Version": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "versionId": FhirCqlType(name="String", is_backbone_element=False),
        "description": FhirCqlType(name="String", is_backbone_element=False),
    },
    "ExplanationOfBenefit_Accident": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "date": FhirCqlType(name="Date", is_backbone_element=False),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "location": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Address", is_backbone_element=True),
                FhirCqlType(name="Reference", is_backbone_element=True),
            ],
        ),
    },
    "ExplanationOfBenefit_AddItem": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "itemSequence": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "detailSequence": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "subDetailSequence": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "provider": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "productOrService": FhirCqlType(name="Concept", is_backbone_element=False),
        "modifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "programCode": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "serviced": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Date", is_backbone_element=False),
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
                ),
            ],
        ),
        "location": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Address", is_backbone_element=True),
                FhirCqlType(name="Concept", is_backbone_element=False),
                FhirCqlType(name="Reference", is_backbone_element=True),
            ],
        ),
        "quantity": FhirCqlType(name="Decimal", is_backbone_element=False),
        "unitPrice": FhirCqlType(name="Money", is_backbone_element=True),
        "factor": FhirCqlType(name="Decimal", is_backbone_element=False),
        "net": FhirCqlType(name="Money", is_backbone_element=True),
        "bodySite": FhirCqlType(name="Concept", is_backbone_element=False),
        "subSite": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "noteNumber": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "adjudication": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ExplanationOfBenefit_Adjudication", is_backbone_element=True
            ),
        ),
        "detail": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ExplanationOfBenefit_Detail1", is_backbone_element=True
            ),
        ),
    },
    "ExplanationOfBenefit_Adjudication": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "category": FhirCqlType(name="Concept", is_backbone_element=False),
        "reason": FhirCqlType(name="Concept", is_backbone_element=False),
        "amount": FhirCqlType(name="Money", is_backbone_element=True),
        "value": FhirCqlType(name="Decimal", is_backbone_element=False),
    },
    "ExplanationOfBenefit_BenefitBalance": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "category": FhirCqlType(name="Concept", is_backbone_element=False),
        "excluded": FhirCqlType(name="Boolean", is_backbone_element=False),
        "name": FhirCqlType(name="String", is_backbone_element=False),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "network": FhirCqlType(name="Concept", is_backbone_element=False),
        "unit": FhirCqlType(name="Concept", is_backbone_element=False),
        "term": FhirCqlType(name="Concept", is_backbone_element=False),
        "financial": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ExplanationOfBenefit_Financial", is_backbone_element=True
            ),
        ),
    },
    "ExplanationOfBenefit_CareTeam": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "sequence": FhirCqlType(name="String", is_backbone_element=False),
        "provider": FhirCqlType(name="Reference", is_backbone_element=True),
        "responsible": FhirCqlType(name="Boolean", is_backbone_element=False),
        "role": FhirCqlType(name="Concept", is_backbone_element=False),
        "qualification": FhirCqlType(name="Concept", is_backbone_element=False),
    },
    "ExplanationOfBenefit_Detail": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "sequence": FhirCqlType(name="String", is_backbone_element=False),
        "revenue": FhirCqlType(name="Concept", is_backbone_element=False),
        "category": FhirCqlType(name="Concept", is_backbone_element=False),
        "productOrService": FhirCqlType(name="Concept", is_backbone_element=False),
        "modifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "programCode": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "quantity": FhirCqlType(name="Decimal", is_backbone_element=False),
        "unitPrice": FhirCqlType(name="Money", is_backbone_element=True),
        "factor": FhirCqlType(name="Decimal", is_backbone_element=False),
        "net": FhirCqlType(name="Money", is_backbone_element=True),
        "udi": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "noteNumber": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "adjudication": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ExplanationOfBenefit_Adjudication", is_backbone_element=True
            ),
        ),
        "subDetail": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ExplanationOfBenefit_SubDetail", is_backbone_element=True
            ),
        ),
    },
    "ExplanationOfBenefit_Detail1": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "productOrService": FhirCqlType(name="Concept", is_backbone_element=False),
        "modifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "quantity": FhirCqlType(name="Decimal", is_backbone_element=False),
        "unitPrice": FhirCqlType(name="Money", is_backbone_element=True),
        "factor": FhirCqlType(name="Decimal", is_backbone_element=False),
        "net": FhirCqlType(name="Money", is_backbone_element=True),
        "noteNumber": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "adjudication": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ExplanationOfBenefit_Adjudication", is_backbone_element=True
            ),
        ),
        "subDetail": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ExplanationOfBenefit_SubDetail1", is_backbone_element=True
            ),
        ),
    },
    "ExplanationOfBenefit_Diagnosis": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "sequence": FhirCqlType(name="String", is_backbone_element=False),
        "diagnosis": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Concept", is_backbone_element=False),
                FhirCqlType(name="Reference", is_backbone_element=True),
            ],
        ),
        "type": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "onAdmission": FhirCqlType(name="Concept", is_backbone_element=False),
        "packageCode": FhirCqlType(name="Concept", is_backbone_element=False),
    },
    "ExplanationOfBenefit_Financial": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "allowed": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Money", is_backbone_element=True),
                FhirCqlType(name="String", is_backbone_element=False),
            ],
        ),
        "used": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Money", is_backbone_element=True),
                FhirCqlType(name="String", is_backbone_element=False),
            ],
        ),
    },
    "ExplanationOfBenefit_Insurance": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "focal": FhirCqlType(name="Boolean", is_backbone_element=False),
        "coverage": FhirCqlType(name="Reference", is_backbone_element=True),
        "preAuthRef": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
    },
    "ExplanationOfBenefit_Item": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "sequence": FhirCqlType(name="String", is_backbone_element=False),
        "careTeamSequence": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "diagnosisSequence": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "procedureSequence": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "informationSequence": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "revenue": FhirCqlType(name="Concept", is_backbone_element=False),
        "category": FhirCqlType(name="Concept", is_backbone_element=False),
        "productOrService": FhirCqlType(name="Concept", is_backbone_element=False),
        "modifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "programCode": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "serviced": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Date", is_backbone_element=False),
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
                ),
            ],
        ),
        "location": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Address", is_backbone_element=True),
                FhirCqlType(name="Concept", is_backbone_element=False),
                FhirCqlType(name="Reference", is_backbone_element=True),
            ],
        ),
        "quantity": FhirCqlType(name="Decimal", is_backbone_element=False),
        "unitPrice": FhirCqlType(name="Money", is_backbone_element=True),
        "factor": FhirCqlType(name="Decimal", is_backbone_element=False),
        "net": FhirCqlType(name="Money", is_backbone_element=True),
        "udi": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "bodySite": FhirCqlType(name="Concept", is_backbone_element=False),
        "subSite": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "encounter": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "noteNumber": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "adjudication": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ExplanationOfBenefit_Adjudication", is_backbone_element=True
            ),
        ),
        "detail": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ExplanationOfBenefit_Detail", is_backbone_element=True
            ),
        ),
    },
    "ExplanationOfBenefit_Payee": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "party": FhirCqlType(name="Reference", is_backbone_element=True),
    },
    "ExplanationOfBenefit_Payment": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "adjustment": FhirCqlType(name="Money", is_backbone_element=True),
        "adjustmentReason": FhirCqlType(name="Concept", is_backbone_element=False),
        "date": FhirCqlType(name="Date", is_backbone_element=False),
        "amount": FhirCqlType(name="Money", is_backbone_element=True),
        "identifier": FhirCqlType(name="Identifier", is_backbone_element=True),
    },
    "ExplanationOfBenefit_Procedure": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "sequence": FhirCqlType(name="String", is_backbone_element=False),
        "type": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "date": FhirCqlType(name="DateTime", is_backbone_element=False),
        "procedure": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Concept", is_backbone_element=False),
                FhirCqlType(name="Reference", is_backbone_element=True),
            ],
        ),
        "udi": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
    },
    "ExplanationOfBenefit_ProcessNote": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "number": FhirCqlType(name="String", is_backbone_element=False),
        "type": FhirCqlType(name="String", is_backbone_element=False),
        "text": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="Concept", is_backbone_element=False),
    },
    "ExplanationOfBenefit_Related": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "claim": FhirCqlType(name="Reference", is_backbone_element=True),
        "relationship": FhirCqlType(name="Concept", is_backbone_element=False),
        "reference": FhirCqlType(name="Identifier", is_backbone_element=True),
    },
    "ExplanationOfBenefit_SubDetail": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "sequence": FhirCqlType(name="String", is_backbone_element=False),
        "revenue": FhirCqlType(name="Concept", is_backbone_element=False),
        "category": FhirCqlType(name="Concept", is_backbone_element=False),
        "productOrService": FhirCqlType(name="Concept", is_backbone_element=False),
        "modifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "programCode": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "quantity": FhirCqlType(name="Decimal", is_backbone_element=False),
        "unitPrice": FhirCqlType(name="Money", is_backbone_element=True),
        "factor": FhirCqlType(name="Decimal", is_backbone_element=False),
        "net": FhirCqlType(name="Money", is_backbone_element=True),
        "udi": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "noteNumber": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "adjudication": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ExplanationOfBenefit_Adjudication", is_backbone_element=True
            ),
        ),
    },
    "ExplanationOfBenefit_SubDetail1": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "productOrService": FhirCqlType(name="Concept", is_backbone_element=False),
        "modifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "quantity": FhirCqlType(name="Decimal", is_backbone_element=False),
        "unitPrice": FhirCqlType(name="Money", is_backbone_element=True),
        "factor": FhirCqlType(name="Decimal", is_backbone_element=False),
        "net": FhirCqlType(name="Money", is_backbone_element=True),
        "noteNumber": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "adjudication": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ExplanationOfBenefit_Adjudication", is_backbone_element=True
            ),
        ),
    },
    "ExplanationOfBenefit_SupportingInfo": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "sequence": FhirCqlType(name="String", is_backbone_element=False),
        "category": FhirCqlType(name="Concept", is_backbone_element=False),
        "code": FhirCqlType(name="Concept", is_backbone_element=False),
        "timing": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Date", is_backbone_element=False),
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
                ),
            ],
        ),
        "value": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Reference", is_backbone_element=True),
                FhirCqlType(name="Attachment", is_backbone_element=True),
                FhirCqlType(name="String", is_backbone_element=False),
                FhirCqlType(name="Decimal", is_backbone_element=False),
                FhirCqlType(name="Boolean", is_backbone_element=False),
            ],
        ),
        "reason": FhirCqlType(name="Code", is_backbone_element=False),
    },
    "ExplanationOfBenefit_Total": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "category": FhirCqlType(name="Concept", is_backbone_element=False),
        "amount": FhirCqlType(name="Money", is_backbone_element=True),
    },
    "Expression": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "name": FhirCqlType(name="String", is_backbone_element=False),
        "language": FhirCqlType(name="String", is_backbone_element=False),
        "expression": FhirCqlType(name="String", is_backbone_element=False),
        "reference": FhirCqlType(name="String", is_backbone_element=False),
    },
    "Extension": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "url": FhirCqlType(name="String", is_backbone_element=False),
        "value": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Distance", is_backbone_element=True),
                FhirCqlType(name="Signature", is_backbone_element=True),
                FhirCqlType(name="Annotation", is_backbone_element=True),
                FhirCqlType(name="Concept", is_backbone_element=False),
                FhirCqlType(name="Age", is_backbone_element=True),
                FhirCqlType(name="HumanName", is_backbone_element=True),
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
                ),
                FhirCqlType(name="SampledData", is_backbone_element=True),
                FhirCqlType(name="Timing", is_backbone_element=True),
                FhirCqlType(name="DateTime", is_backbone_element=False),
                FhirCqlType(name="ContactDetail", is_backbone_element=True),
                FhirCqlType(name="TriggerDefinition", is_backbone_element=True),
                FhirCqlType(name="UsageContext", is_backbone_element=True),
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="Decimal", is_backbone_element=False),
                ),
                FhirCqlType(name="Meta", is_backbone_element=True),
                FhirCqlType(name="Reference", is_backbone_element=True),
                FhirCqlType(name="Date", is_backbone_element=False),
                FhirCqlType(name="Ratio", is_backbone_element=True),
                FhirCqlType(name="Decimal", is_backbone_element=False),
                FhirCqlType(name="Expression", is_backbone_element=True),
                FhirCqlType(name="ParameterDefinition", is_backbone_element=True),
                FhirCqlType(name="Identifier", is_backbone_element=True),
                FhirCqlType(name="RelatedArtifact", is_backbone_element=True),
                FhirCqlType(name="DataRequirement", is_backbone_element=True),
                FhirCqlType(name="Dosage", is_backbone_element=True),
                FhirCqlType(name="Count", is_backbone_element=True),
                FhirCqlType(name="Duration", is_backbone_element=True),
                FhirCqlType(name="ContactPoint", is_backbone_element=True),
                FhirCqlType(name="Money", is_backbone_element=True),
                FhirCqlType(name="Attachment", is_backbone_element=True),
                FhirCqlType(name="String", is_backbone_element=False),
                FhirCqlType(name="Contributor", is_backbone_element=True),
                FhirCqlType(name="Boolean", is_backbone_element=False),
                FhirCqlType(name="Code", is_backbone_element=False),
                FhirCqlType(name="Address", is_backbone_element=True),
            ],
        ),
    },
    "FamilyMemberHistory_Condition": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "code": FhirCqlType(name="Concept", is_backbone_element=False),
        "outcome": FhirCqlType(name="Concept", is_backbone_element=False),
        "contributedToDeath": FhirCqlType(name="Boolean", is_backbone_element=False),
        "onset": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Age", is_backbone_element=True),
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="Decimal", is_backbone_element=False),
                ),
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
                ),
                FhirCqlType(name="String", is_backbone_element=False),
            ],
        ),
        "note": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Annotation", is_backbone_element=True),
        ),
    },
    "Goal_Target": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "measure": FhirCqlType(name="Concept", is_backbone_element=False),
        "detail": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="Decimal", is_backbone_element=False),
                ),
                FhirCqlType(name="String", is_backbone_element=False),
                FhirCqlType(name="Ratio", is_backbone_element=True),
                FhirCqlType(name="Decimal", is_backbone_element=False),
                FhirCqlType(name="Boolean", is_backbone_element=False),
                FhirCqlType(name="Concept", is_backbone_element=False),
            ],
        ),
        "dueD": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="String", is_backbone_element=False),
                FhirCqlType(name="Duration", is_backbone_element=True),
            ],
        ),
    },
    "GraphDefinition_Compartment": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "use": FhirCqlType(name="String", is_backbone_element=False),
        "code": FhirCqlType(name="Code", is_backbone_element=False),
        "rule": FhirCqlType(name="String", is_backbone_element=False),
        "expression": FhirCqlType(name="String", is_backbone_element=False),
        "description": FhirCqlType(name="String", is_backbone_element=False),
    },
    "GraphDefinition_Link": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "path": FhirCqlType(name="String", is_backbone_element=False),
        "sliceName": FhirCqlType(name="String", is_backbone_element=False),
        "min": FhirCqlType(name="Integer", is_backbone_element=False),
        "max": FhirCqlType(name="String", is_backbone_element=False),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "target": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="GraphDefinition_Target", is_backbone_element=True
            ),
        ),
    },
    "GraphDefinition_Target": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "type": FhirCqlType(name="Code", is_backbone_element=False),
        "params": FhirCqlType(name="String", is_backbone_element=False),
        "profile": FhirCqlType(name="String", is_backbone_element=False),
        "compartment": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="GraphDefinition_Compartment", is_backbone_element=True
            ),
        ),
        "link": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="GraphDefinition_Link", is_backbone_element=True
            ),
        ),
    },
    "Group_Characteristic": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "code": FhirCqlType(name="Concept", is_backbone_element=False),
        "value": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="Decimal", is_backbone_element=False),
                ),
                FhirCqlType(name="Reference", is_backbone_element=True),
                FhirCqlType(name="Decimal", is_backbone_element=False),
                FhirCqlType(name="Boolean", is_backbone_element=False),
                FhirCqlType(name="Concept", is_backbone_element=False),
            ],
        ),
        "exclude": FhirCqlType(name="Boolean", is_backbone_element=False),
        "period": FhirInterval(
            name="Interval",
            is_backbone_element=False,
            item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
        ),
    },
    "Group_Member": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "entity": FhirCqlType(name="Reference", is_backbone_element=True),
        "period": FhirInterval(
            name="Interval",
            is_backbone_element=False,
            item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
        ),
        "inactive": FhirCqlType(name="Boolean", is_backbone_element=False),
    },
    "HealthcareService_AvailableTime": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "daysOfWeek": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "allDay": FhirCqlType(name="Boolean", is_backbone_element=False),
        "availableStartTime": FhirCqlType(name="String", is_backbone_element=False),
        "availableEndTime": FhirCqlType(name="String", is_backbone_element=False),
    },
    "HealthcareService_Eligibility": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "code": FhirCqlType(name="Concept", is_backbone_element=False),
        "comment": FhirCqlType(name="String", is_backbone_element=False),
    },
    "HealthcareService_NotAvailable": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "during": FhirInterval(
            name="Interval",
            is_backbone_element=False,
            item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
        ),
    },
    "HumanName": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "use": FhirCqlType(name="String", is_backbone_element=False),
        "text": FhirCqlType(name="String", is_backbone_element=False),
        "family": FhirCqlType(name="String", is_backbone_element=False),
        "given": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "prefix": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "suffix": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "period": FhirInterval(
            name="Interval",
            is_backbone_element=False,
            item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
        ),
    },
    "Identifier": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "use": FhirCqlType(name="String", is_backbone_element=False),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "system": FhirCqlType(name="String", is_backbone_element=False),
        "value": FhirCqlType(name="String", is_backbone_element=False),
        "period": FhirInterval(
            name="Interval",
            is_backbone_element=False,
            item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
        ),
        "assigner": FhirCqlType(name="Reference", is_backbone_element=True),
    },
    "ImagingStudy_Instance": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "uid": FhirCqlType(name="String", is_backbone_element=False),
        "sopClass": FhirCqlType(name="Code", is_backbone_element=False),
        "number": FhirCqlType(name="String", is_backbone_element=False),
        "title": FhirCqlType(name="String", is_backbone_element=False),
    },
    "ImagingStudy_Performer": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "function": FhirCqlType(name="Concept", is_backbone_element=False),
        "actor": FhirCqlType(name="Reference", is_backbone_element=True),
    },
    "ImagingStudy_Series": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "uid": FhirCqlType(name="String", is_backbone_element=False),
        "number": FhirCqlType(name="String", is_backbone_element=False),
        "modality": FhirCqlType(name="Code", is_backbone_element=False),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "numberOfInstances": FhirCqlType(name="String", is_backbone_element=False),
        "endpoint": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "bodySite": FhirCqlType(name="Code", is_backbone_element=False),
        "laterality": FhirCqlType(name="Code", is_backbone_element=False),
        "specimen": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "started": FhirCqlType(name="DateTime", is_backbone_element=False),
        "performer": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ImagingStudy_Performer", is_backbone_element=True
            ),
        ),
        "instance": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ImagingStudy_Instance", is_backbone_element=True
            ),
        ),
    },
    "ImmunizationRecommendation_DateCriterion": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "code": FhirCqlType(name="Concept", is_backbone_element=False),
        "value": FhirCqlType(name="DateTime", is_backbone_element=False),
    },
    "ImmunizationRecommendation_Recommendation": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "vaccineCode": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "targetDisease": FhirCqlType(name="Concept", is_backbone_element=False),
        "contraindicatedVaccineCode": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "forecastStatus": FhirCqlType(name="Concept", is_backbone_element=False),
        "forecastReason": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "dateCriterion": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ImmunizationRecommendation_DateCriterion",
                is_backbone_element=True,
            ),
        ),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "series": FhirCqlType(name="String", is_backbone_element=False),
        "doseNumber": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[FhirCqlType(name="String", is_backbone_element=False)],
        ),
        "seriesDoses": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[FhirCqlType(name="String", is_backbone_element=False)],
        ),
        "supportingImmunization": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "supportingPatientInformation": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
    },
    "Immunization_Education": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "documentType": FhirCqlType(name="String", is_backbone_element=False),
        "reference": FhirCqlType(name="String", is_backbone_element=False),
        "publicationDate": FhirCqlType(name="DateTime", is_backbone_element=False),
        "presentationDate": FhirCqlType(name="DateTime", is_backbone_element=False),
    },
    "Immunization_Performer": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "function": FhirCqlType(name="Concept", is_backbone_element=False),
        "actor": FhirCqlType(name="Reference", is_backbone_element=True),
    },
    "Immunization_ProtocolApplied": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "series": FhirCqlType(name="String", is_backbone_element=False),
        "authority": FhirCqlType(name="Reference", is_backbone_element=True),
        "targetDisease": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "doseNumber": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[FhirCqlType(name="String", is_backbone_element=False)],
        ),
        "seriesDoses": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[FhirCqlType(name="String", is_backbone_element=False)],
        ),
    },
    "Immunization_Reaction": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "date": FhirCqlType(name="DateTime", is_backbone_element=False),
        "detail": FhirCqlType(name="Reference", is_backbone_element=True),
        "reported": FhirCqlType(name="Boolean", is_backbone_element=False),
    },
    "ImplementationGuide_Definition": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "grouping": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ImplementationGuide_Grouping", is_backbone_element=True
            ),
        ),
        "resource": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ImplementationGuide_Resource", is_backbone_element=True
            ),
        ),
        "page": FhirCqlType(name="ImplementationGuide_Page", is_backbone_element=True),
        "parameter": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ImplementationGuide_Parameter", is_backbone_element=True
            ),
        ),
        "template": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ImplementationGuide_Template", is_backbone_element=True
            ),
        ),
    },
    "ImplementationGuide_DependsOn": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "uri": FhirCqlType(name="String", is_backbone_element=False),
        "packageId": FhirCqlType(name="String", is_backbone_element=False),
        "version": FhirCqlType(name="String", is_backbone_element=False),
    },
    "ImplementationGuide_Global": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "type": FhirCqlType(name="Code", is_backbone_element=False),
        "profile": FhirCqlType(name="String", is_backbone_element=False),
    },
    "ImplementationGuide_Grouping": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "name": FhirCqlType(name="String", is_backbone_element=False),
        "description": FhirCqlType(name="String", is_backbone_element=False),
    },
    "ImplementationGuide_Manifest": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "rendering": FhirCqlType(name="String", is_backbone_element=False),
        "resource": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ImplementationGuide_Resource1", is_backbone_element=True
            ),
        ),
        "page": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ImplementationGuide_Page1", is_backbone_element=True
            ),
        ),
        "image": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "other": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
    },
    "ImplementationGuide_Page": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "name": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Reference", is_backbone_element=True),
                FhirCqlType(name="String", is_backbone_element=False),
            ],
        ),
        "title": FhirCqlType(name="String", is_backbone_element=False),
        "generation": FhirCqlType(name="String", is_backbone_element=False),
        "page": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="ImplementationGuide_Page", is_backbone_element=True
            ),
        ),
    },
    "ImplementationGuide_Page1": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "name": FhirCqlType(name="String", is_backbone_element=False),
        "title": FhirCqlType(name="String", is_backbone_element=False),
        "anchor": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
    },
    "ImplementationGuide_Parameter": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "code": FhirCqlType(name="String", is_backbone_element=False),
        "value": FhirCqlType(name="String", is_backbone_element=False),
    },
    "ImplementationGuide_Resource": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "reference": FhirCqlType(name="Reference", is_backbone_element=True),
        "fhirVersion": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "name": FhirCqlType(name="String", is_backbone_element=False),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "example": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Boolean", is_backbone_element=False),
                FhirCqlType(name="String", is_backbone_element=False),
            ],
        ),
        "groupingId": FhirCqlType(name="String", is_backbone_element=False),
    },
    "ImplementationGuide_Resource1": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "reference": FhirCqlType(name="Reference", is_backbone_element=True),
        "example": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Boolean", is_backbone_element=False),
                FhirCqlType(name="String", is_backbone_element=False),
            ],
        ),
        "relativePath": FhirCqlType(name="String", is_backbone_element=False),
    },
    "ImplementationGuide_Template": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "code": FhirCqlType(name="Code", is_backbone_element=False),
        "source": FhirCqlType(name="String", is_backbone_element=False),
        "scope": FhirCqlType(name="String", is_backbone_element=False),
    },
    "InsurancePlan_Benefit": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "requirement": FhirCqlType(name="String", is_backbone_element=False),
        "limit": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="InsurancePlan_Limit", is_backbone_element=True),
        ),
    },
    "InsurancePlan_Benefit1": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "cost": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="InsurancePlan_Cost", is_backbone_element=True),
        ),
    },
    "InsurancePlan_Contact": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "purpose": FhirCqlType(name="Concept", is_backbone_element=False),
        "name": FhirCqlType(name="HumanName", is_backbone_element=True),
        "telecom": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactPoint", is_backbone_element=True),
        ),
        "address": FhirCqlType(name="Address", is_backbone_element=True),
    },
    "InsurancePlan_Cost": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "applicability": FhirCqlType(name="Concept", is_backbone_element=False),
        "qualifiers": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "value": FhirCqlType(name="Decimal", is_backbone_element=False),
    },
    "InsurancePlan_Coverage": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "network": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "benefit": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="InsurancePlan_Benefit", is_backbone_element=True
            ),
        ),
    },
    "InsurancePlan_GeneralCost": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "groupSize": FhirCqlType(name="String", is_backbone_element=False),
        "cost": FhirCqlType(name="Money", is_backbone_element=True),
        "comment": FhirCqlType(name="String", is_backbone_element=False),
    },
    "InsurancePlan_Limit": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "value": FhirCqlType(name="Decimal", is_backbone_element=False),
        "code": FhirCqlType(name="Concept", is_backbone_element=False),
    },
    "InsurancePlan_Plan": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "coverageArea": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "network": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "generalCost": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="InsurancePlan_GeneralCost", is_backbone_element=True
            ),
        ),
        "specificCost": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="InsurancePlan_SpecificCost", is_backbone_element=True
            ),
        ),
    },
    "InsurancePlan_SpecificCost": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "category": FhirCqlType(name="Concept", is_backbone_element=False),
        "benefit": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="InsurancePlan_Benefit1", is_backbone_element=True
            ),
        ),
    },
    "Invoice_LineItem": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "sequence": FhirCqlType(name="String", is_backbone_element=False),
        "chargeItem": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Concept", is_backbone_element=False),
                FhirCqlType(name="Reference", is_backbone_element=True),
            ],
        ),
        "priceComponent": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="Invoice_PriceComponent", is_backbone_element=True
            ),
        ),
    },
    "Invoice_Participant": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "role": FhirCqlType(name="Concept", is_backbone_element=False),
        "actor": FhirCqlType(name="Reference", is_backbone_element=True),
    },
    "Invoice_PriceComponent": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "type": FhirCqlType(name="String", is_backbone_element=False),
        "code": FhirCqlType(name="Concept", is_backbone_element=False),
        "factor": FhirCqlType(name="Decimal", is_backbone_element=False),
        "amount": FhirCqlType(name="Money", is_backbone_element=True),
    },
    "Linkage_Item": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "type": FhirCqlType(name="String", is_backbone_element=False),
        "resource": FhirCqlType(name="Reference", is_backbone_element=True),
    },
    "List_Entry": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "flag": FhirCqlType(name="Concept", is_backbone_element=False),
        "deleted": FhirCqlType(name="Boolean", is_backbone_element=False),
        "date": FhirCqlType(name="DateTime", is_backbone_element=False),
        "item": FhirCqlType(name="Reference", is_backbone_element=True),
    },
    "Location_HoursOfOperation": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "daysOfWeek": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Code", is_backbone_element=False),
        ),
        "allDay": FhirCqlType(name="Boolean", is_backbone_element=False),
        "openingTime": FhirCqlType(name="String", is_backbone_element=False),
        "closingTime": FhirCqlType(name="String", is_backbone_element=False),
    },
    "Location_Position": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "longitude": FhirCqlType(name="Decimal", is_backbone_element=False),
        "latitude": FhirCqlType(name="Decimal", is_backbone_element=False),
        "altitude": FhirCqlType(name="Decimal", is_backbone_element=False),
    },
    "MarketingStatus": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "country": FhirCqlType(name="Concept", is_backbone_element=False),
        "jurisdiction": FhirCqlType(name="Concept", is_backbone_element=False),
        "status": FhirCqlType(name="Concept", is_backbone_element=False),
        "": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
                ),
                FhirCqlType(name="DateTime", is_backbone_element=False),
            ],
        ),
    },
    "MeasureReport_Component": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "code": FhirCqlType(name="Concept", is_backbone_element=False),
        "value": FhirCqlType(name="Concept", is_backbone_element=False),
    },
    "MeasureReport_Group": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "code": FhirCqlType(name="Concept", is_backbone_element=False),
        "population": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="MeasureReport_Population", is_backbone_element=True
            ),
        ),
        "measureScore": FhirCqlType(name="Decimal", is_backbone_element=False),
        "stratifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="MeasureReport_Stratifier", is_backbone_element=True
            ),
        ),
    },
    "MeasureReport_Population": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "code": FhirCqlType(name="Concept", is_backbone_element=False),
        "count": FhirCqlType(name="Integer", is_backbone_element=False),
        "subjectResults": FhirCqlType(name="Reference", is_backbone_element=True),
    },
    "MeasureReport_Population1": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "code": FhirCqlType(name="Concept", is_backbone_element=False),
        "count": FhirCqlType(name="Integer", is_backbone_element=False),
        "subjectResults": FhirCqlType(name="Reference", is_backbone_element=True),
    },
    "MeasureReport_Stratifier": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "code": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "stratum": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="MeasureReport_Stratum", is_backbone_element=True
            ),
        ),
    },
    "MeasureReport_Stratum": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "value": FhirCqlType(name="Concept", is_backbone_element=False),
        "component": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="MeasureReport_Component", is_backbone_element=True
            ),
        ),
        "population": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="MeasureReport_Population1", is_backbone_element=True
            ),
        ),
        "measureScore": FhirCqlType(name="Decimal", is_backbone_element=False),
    },
    "Measure_Component": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "code": FhirCqlType(name="Concept", is_backbone_element=False),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "criteria": FhirCqlType(name="Expression", is_backbone_element=True),
    },
    "Measure_Group": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "code": FhirCqlType(name="Concept", is_backbone_element=False),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "population": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Measure_Population", is_backbone_element=True),
        ),
        "stratifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Measure_Stratifier", is_backbone_element=True),
        ),
    },
    "Measure_Population": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "code": FhirCqlType(name="Concept", is_backbone_element=False),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "criteria": FhirCqlType(name="Expression", is_backbone_element=True),
    },
    "Measure_Stratifier": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "code": FhirCqlType(name="Concept", is_backbone_element=False),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "criteria": FhirCqlType(name="Expression", is_backbone_element=True),
        "component": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Measure_Component", is_backbone_element=True),
        ),
    },
    "Measure_SupplementalData": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "code": FhirCqlType(name="Concept", is_backbone_element=False),
        "usage": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "criteria": FhirCqlType(name="Expression", is_backbone_element=True),
    },
    "MedicationAdministration_Dosage": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "text": FhirCqlType(name="String", is_backbone_element=False),
        "site": FhirCqlType(name="Concept", is_backbone_element=False),
        "route": FhirCqlType(name="Concept", is_backbone_element=False),
        "method": FhirCqlType(name="Concept", is_backbone_element=False),
        "dose": FhirCqlType(name="Decimal", is_backbone_element=False),
        "rate": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Ratio", is_backbone_element=True),
                FhirCqlType(name="Decimal", is_backbone_element=False),
            ],
        ),
    },
    "MedicationAdministration_Performer": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "function": FhirCqlType(name="Concept", is_backbone_element=False),
        "actor": FhirCqlType(name="Reference", is_backbone_element=True),
    },
    "MedicationDispense_Performer": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "function": FhirCqlType(name="Concept", is_backbone_element=False),
        "actor": FhirCqlType(name="Reference", is_backbone_element=True),
    },
    "MedicationDispense_Substitution": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "wasSubstituted": FhirCqlType(name="Boolean", is_backbone_element=False),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "reason": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "responsibleParty": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
    },
    "MedicationKnowledge_AdministrationGuidelines": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "dosage": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="MedicationKnowledge_Dosage", is_backbone_element=True
            ),
        ),
        "indication": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Concept", is_backbone_element=False),
                FhirCqlType(name="Reference", is_backbone_element=True),
            ],
        ),
        "patientCharacteristics": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="MedicationKnowledge_PatientCharacteristics",
                is_backbone_element=True,
            ),
        ),
    },
    "MedicationKnowledge_Cost": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "source": FhirCqlType(name="String", is_backbone_element=False),
        "cost": FhirCqlType(name="Money", is_backbone_element=True),
    },
    "MedicationKnowledge_Dosage": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "dosage": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Dosage", is_backbone_element=True),
        ),
    },
    "MedicationKnowledge_DrugCharacteristic": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "value": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Decimal", is_backbone_element=False),
                FhirCqlType(name="Concept", is_backbone_element=False),
                FhirCqlType(name="String", is_backbone_element=False),
            ],
        ),
    },
    "MedicationKnowledge_Ingredient": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "item": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Concept", is_backbone_element=False),
                FhirCqlType(name="Reference", is_backbone_element=True),
            ],
        ),
        "isActive": FhirCqlType(name="Boolean", is_backbone_element=False),
        "strength": FhirCqlType(name="Ratio", is_backbone_element=True),
    },
    "MedicationKnowledge_Kinetics": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "areaUnderCurve": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Decimal", is_backbone_element=False),
        ),
        "lethalDose50": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Decimal", is_backbone_element=False),
        ),
        "halfLifePeriod": FhirCqlType(name="Duration", is_backbone_element=True),
    },
    "MedicationKnowledge_MaxDispense": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "quantity": FhirCqlType(name="Decimal", is_backbone_element=False),
        "period": FhirCqlType(name="Duration", is_backbone_element=True),
    },
    "MedicationKnowledge_MedicineClassification": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "classification": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
    },
    "MedicationKnowledge_MonitoringProgram": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "name": FhirCqlType(name="String", is_backbone_element=False),
    },
    "MedicationKnowledge_Monograph": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "source": FhirCqlType(name="Reference", is_backbone_element=True),
    },
    "MedicationKnowledge_Packaging": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "quantity": FhirCqlType(name="Decimal", is_backbone_element=False),
    },
    "MedicationKnowledge_PatientCharacteristics": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "characteristic": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Decimal", is_backbone_element=False),
                FhirCqlType(name="Concept", is_backbone_element=False),
            ],
        ),
        "value": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
    },
    "MedicationKnowledge_Regulatory": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "regulatoryAuthority": FhirCqlType(name="Reference", is_backbone_element=True),
        "substitution": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="MedicationKnowledge_Substitution", is_backbone_element=True
            ),
        ),
        "schedule": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="MedicationKnowledge_Schedule", is_backbone_element=True
            ),
        ),
        "maxDispense": FhirCqlType(
            name="MedicationKnowledge_MaxDispense", is_backbone_element=True
        ),
    },
    "MedicationKnowledge_RelatedMedicationKnowledge": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "reference": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
    },
    "MedicationKnowledge_Schedule": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "schedule": FhirCqlType(name="Concept", is_backbone_element=False),
    },
    "MedicationKnowledge_Substitution": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "allowed": FhirCqlType(name="Boolean", is_backbone_element=False),
    },
    "MedicationRequest_DispenseRequest": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "initialFill": FhirCqlType(
            name="MedicationRequest_InitialFill", is_backbone_element=True
        ),
        "dispenseInterval": FhirCqlType(name="Duration", is_backbone_element=True),
        "validityPeriod": FhirInterval(
            name="Interval",
            is_backbone_element=False,
            item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
        ),
        "numberOfRepeatsAllowed": FhirCqlType(name="String", is_backbone_element=False),
        "quantity": FhirCqlType(name="Decimal", is_backbone_element=False),
        "expectedSupplyDuration": FhirCqlType(
            name="Duration", is_backbone_element=True
        ),
        "performer": FhirCqlType(name="Reference", is_backbone_element=True),
    },
    "MedicationRequest_InitialFill": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "quantity": FhirCqlType(name="Decimal", is_backbone_element=False),
        "duration": FhirCqlType(name="Duration", is_backbone_element=True),
    },
    "MedicationRequest_Substitution": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "allowed": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Boolean", is_backbone_element=False),
                FhirCqlType(name="Concept", is_backbone_element=False),
            ],
        ),
        "reason": FhirCqlType(name="Concept", is_backbone_element=False),
    },
    "Medication_Batch": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "lotNumber": FhirCqlType(name="String", is_backbone_element=False),
        "expirationDate": FhirCqlType(name="DateTime", is_backbone_element=False),
    },
    "Medication_Ingredient": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "item": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Concept", is_backbone_element=False),
                FhirCqlType(name="Reference", is_backbone_element=True),
            ],
        ),
        "isActive": FhirCqlType(name="Boolean", is_backbone_element=False),
        "strength": FhirCqlType(name="Ratio", is_backbone_element=True),
    },
    "MedicinalProductAuthorization_JurisdictionalAuthorization": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "country": FhirCqlType(name="Concept", is_backbone_element=False),
        "jurisdiction": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "legalStatusOfSupply": FhirCqlType(name="Concept", is_backbone_element=False),
        "validityPeriod": FhirInterval(
            name="Interval",
            is_backbone_element=False,
            item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
        ),
    },
    "MedicinalProductAuthorization_Procedure": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirCqlType(name="Identifier", is_backbone_element=True),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "date": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
                ),
                FhirCqlType(name="DateTime", is_backbone_element=False),
            ],
        ),
        "application": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="MedicinalProductAuthorization_Procedure", is_backbone_element=True
            ),
        ),
    },
    "MedicinalProductContraindication_OtherTherapy": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "therapyRelationshipType": FhirCqlType(
            name="Concept", is_backbone_element=False
        ),
        "medication": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Concept", is_backbone_element=False),
                FhirCqlType(name="Reference", is_backbone_element=True),
            ],
        ),
    },
    "MedicinalProductIndication_OtherTherapy": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "therapyRelationshipType": FhirCqlType(
            name="Concept", is_backbone_element=False
        ),
        "medication": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Concept", is_backbone_element=False),
                FhirCqlType(name="Reference", is_backbone_element=True),
            ],
        ),
    },
    "MedicinalProductIngredient_ReferenceStrength": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "substance": FhirCqlType(name="Concept", is_backbone_element=False),
        "strength": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[FhirCqlType(name="Ratio", is_backbone_element=True)],
        ),
        "measurementPoint": FhirCqlType(name="String", is_backbone_element=False),
        "country": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
    },
    "MedicinalProductIngredient_SpecifiedSubstance": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "code": FhirCqlType(name="Concept", is_backbone_element=False),
        "group": FhirCqlType(name="Concept", is_backbone_element=False),
        "confidentiality": FhirCqlType(name="Concept", is_backbone_element=False),
        "strength": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="MedicinalProductIngredient_Strength", is_backbone_element=True
            ),
        ),
    },
    "MedicinalProductIngredient_Strength": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "presentation": FhirCqlType(name="Ratio", is_backbone_element=True),
        "presentationLowLimit": FhirCqlType(name="Ratio", is_backbone_element=True),
        "concentration": FhirCqlType(name="Ratio", is_backbone_element=True),
        "concentrationLowLimit": FhirCqlType(name="Ratio", is_backbone_element=True),
        "measurementPoint": FhirCqlType(name="String", is_backbone_element=False),
        "country": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "referenceStrength": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="MedicinalProductIngredient_ReferenceStrength",
                is_backbone_element=True,
            ),
        ),
    },
    "MedicinalProductIngredient_Substance": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "code": FhirCqlType(name="Concept", is_backbone_element=False),
        "strength": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="MedicinalProductIngredient_Strength", is_backbone_element=True
            ),
        ),
    },
    "MedicinalProductInteraction_Interactant": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "item": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Concept", is_backbone_element=False),
                FhirCqlType(name="Reference", is_backbone_element=True),
            ],
        ),
    },
    "MedicinalProductPackaged_BatchIdentifier": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "outerPackaging": FhirCqlType(name="Identifier", is_backbone_element=True),
        "immediatePackaging": FhirCqlType(name="Identifier", is_backbone_element=True),
    },
    "MedicinalProductPackaged_PackageItem": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "quantity": FhirCqlType(name="Decimal", is_backbone_element=False),
        "material": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "alternateMaterial": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "device": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "manufacturedItem": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "packageItem": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="MedicinalProductPackaged_PackageItem", is_backbone_element=True
            ),
        ),
        "physicalCharacteristics": FhirCqlType(
            name="ProdCharacteristic", is_backbone_element=True
        ),
        "otherCharacteristics": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "shelfLifeStorage": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ProductShelfLife", is_backbone_element=True),
        ),
        "manufacturer": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
    },
    "MedicinalProductPharmaceutical_Characteristics": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "code": FhirCqlType(name="Concept", is_backbone_element=False),
        "status": FhirCqlType(name="Concept", is_backbone_element=False),
    },
    "MedicinalProductPharmaceutical_RouteOfAdministration": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "code": FhirCqlType(name="Concept", is_backbone_element=False),
        "firstDose": FhirCqlType(name="Decimal", is_backbone_element=False),
        "maxSingleDose": FhirCqlType(name="Decimal", is_backbone_element=False),
        "maxDosePerDay": FhirCqlType(name="Decimal", is_backbone_element=False),
        "maxDosePerTreatmentPeriod": FhirCqlType(
            name="Ratio", is_backbone_element=True
        ),
        "maxTreatmentPeriod": FhirCqlType(name="Duration", is_backbone_element=True),
        "targetSpecies": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="MedicinalProductPharmaceutical_TargetSpecies",
                is_backbone_element=True,
            ),
        ),
    },
    "MedicinalProductPharmaceutical_TargetSpecies": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "code": FhirCqlType(name="Concept", is_backbone_element=False),
        "withdrawalPeriod": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="MedicinalProductPharmaceutical_WithdrawalPeriod",
                is_backbone_element=True,
            ),
        ),
    },
    "MedicinalProductPharmaceutical_WithdrawalPeriod": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "tissue": FhirCqlType(name="Concept", is_backbone_element=False),
        "value": FhirCqlType(name="Decimal", is_backbone_element=False),
        "supportingInformation": FhirCqlType(name="String", is_backbone_element=False),
    },
    "MedicinalProduct_CountryLanguage": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "country": FhirCqlType(name="Concept", is_backbone_element=False),
        "jurisdiction": FhirCqlType(name="Concept", is_backbone_element=False),
        "language": FhirCqlType(name="Concept", is_backbone_element=False),
    },
    "MedicinalProduct_ManufacturingBusinessOperation": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "operationType": FhirCqlType(name="Concept", is_backbone_element=False),
        "authorisationReferenceNumber": FhirCqlType(
            name="Identifier", is_backbone_element=True
        ),
        "effectiveDate": FhirCqlType(name="DateTime", is_backbone_element=False),
        "confidentialityIndicator": FhirCqlType(
            name="Concept", is_backbone_element=False
        ),
        "manufacturer": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "regulator": FhirCqlType(name="Reference", is_backbone_element=True),
    },
    "MedicinalProduct_Name": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "productName": FhirCqlType(name="String", is_backbone_element=False),
        "namePart": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="MedicinalProduct_NamePart", is_backbone_element=True
            ),
        ),
        "countryLanguage": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="MedicinalProduct_CountryLanguage", is_backbone_element=True
            ),
        ),
    },
    "MedicinalProduct_NamePart": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "part": FhirCqlType(name="String", is_backbone_element=False),
        "type": FhirCqlType(name="Code", is_backbone_element=False),
    },
    "MedicinalProduct_SpecialDesignation": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "intendedUse": FhirCqlType(name="Concept", is_backbone_element=False),
        "indication": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Concept", is_backbone_element=False),
                FhirCqlType(name="Reference", is_backbone_element=True),
            ],
        ),
        "status": FhirCqlType(name="Concept", is_backbone_element=False),
        "date": FhirCqlType(name="DateTime", is_backbone_element=False),
        "species": FhirCqlType(name="Concept", is_backbone_element=False),
    },
    "MessageDefinition_AllowedResponse": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "message": FhirCqlType(name="String", is_backbone_element=False),
        "situation": FhirCqlType(name="String", is_backbone_element=False),
    },
    "MessageDefinition_Focus": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "code": FhirCqlType(name="Code", is_backbone_element=False),
        "profile": FhirCqlType(name="String", is_backbone_element=False),
        "min": FhirCqlType(name="String", is_backbone_element=False),
        "max": FhirCqlType(name="String", is_backbone_element=False),
    },
    "MessageHeader_Destination": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "name": FhirCqlType(name="String", is_backbone_element=False),
        "target": FhirCqlType(name="Reference", is_backbone_element=True),
        "endpoint": FhirCqlType(name="String", is_backbone_element=False),
        "receiver": FhirCqlType(name="Reference", is_backbone_element=True),
    },
    "MessageHeader_Response": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirCqlType(name="String", is_backbone_element=False),
        "code": FhirCqlType(name="String", is_backbone_element=False),
        "details": FhirCqlType(name="Reference", is_backbone_element=True),
    },
    "MessageHeader_Source": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "name": FhirCqlType(name="String", is_backbone_element=False),
        "software": FhirCqlType(name="String", is_backbone_element=False),
        "version": FhirCqlType(name="String", is_backbone_element=False),
        "contact": FhirCqlType(name="ContactPoint", is_backbone_element=True),
        "endpoint": FhirCqlType(name="String", is_backbone_element=False),
    },
    "Meta": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "versionId": FhirCqlType(name="String", is_backbone_element=False),
        "lastUpdated": FhirCqlType(name="String", is_backbone_element=False),
        "source": FhirCqlType(name="String", is_backbone_element=False),
        "profile": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "security": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Code", is_backbone_element=False),
        ),
        "tag": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Code", is_backbone_element=False),
        ),
    },
    "MolecularSequence_Inner": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "start": FhirCqlType(name="Integer", is_backbone_element=False),
        "end": FhirCqlType(name="Integer", is_backbone_element=False),
    },
    "MolecularSequence_Outer": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "start": FhirCqlType(name="Integer", is_backbone_element=False),
        "end": FhirCqlType(name="Integer", is_backbone_element=False),
    },
    "MolecularSequence_Quality": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "type": FhirCqlType(name="String", is_backbone_element=False),
        "standardSequence": FhirCqlType(name="Concept", is_backbone_element=False),
        "start": FhirCqlType(name="Integer", is_backbone_element=False),
        "end": FhirCqlType(name="Integer", is_backbone_element=False),
        "score": FhirCqlType(name="Decimal", is_backbone_element=False),
        "method": FhirCqlType(name="Concept", is_backbone_element=False),
        "truthTP": FhirCqlType(name="Decimal", is_backbone_element=False),
        "queryTP": FhirCqlType(name="Decimal", is_backbone_element=False),
        "truthFN": FhirCqlType(name="Decimal", is_backbone_element=False),
        "queryFP": FhirCqlType(name="Decimal", is_backbone_element=False),
        "gtFP": FhirCqlType(name="Decimal", is_backbone_element=False),
        "precision": FhirCqlType(name="Decimal", is_backbone_element=False),
        "recall": FhirCqlType(name="Decimal", is_backbone_element=False),
        "fScore": FhirCqlType(name="Decimal", is_backbone_element=False),
        "roc": FhirCqlType(name="MolecularSequence_Roc", is_backbone_element=True),
    },
    "MolecularSequence_ReferenceSeq": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "chromosome": FhirCqlType(name="Concept", is_backbone_element=False),
        "genomeBuild": FhirCqlType(name="String", is_backbone_element=False),
        "orientation": FhirCqlType(name="String", is_backbone_element=False),
        "referenceSeqId": FhirCqlType(name="Concept", is_backbone_element=False),
        "referenceSeqPointer": FhirCqlType(name="Reference", is_backbone_element=True),
        "referenceSeqString": FhirCqlType(name="String", is_backbone_element=False),
        "strand": FhirCqlType(name="String", is_backbone_element=False),
        "windowStart": FhirCqlType(name="Integer", is_backbone_element=False),
        "windowEnd": FhirCqlType(name="Integer", is_backbone_element=False),
    },
    "MolecularSequence_Repository": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "type": FhirCqlType(name="String", is_backbone_element=False),
        "": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[FhirCqlType(name="String", is_backbone_element=False)],
        ),
        "datasetId": FhirCqlType(name="String", is_backbone_element=False),
        "variantsetId": FhirCqlType(name="String", is_backbone_element=False),
        "readsetId": FhirCqlType(name="String", is_backbone_element=False),
    },
    "MolecularSequence_Roc": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "score": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Integer", is_backbone_element=False),
        ),
        "numTP": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Integer", is_backbone_element=False),
        ),
        "numFP": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Integer", is_backbone_element=False),
        ),
        "numFN": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Integer", is_backbone_element=False),
        ),
        "precision": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Decimal", is_backbone_element=False),
        ),
        "sensitivity": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Decimal", is_backbone_element=False),
        ),
        "fMeasure": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Decimal", is_backbone_element=False),
        ),
    },
    "MolecularSequence_StructureVariant": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "variantType": FhirCqlType(name="Concept", is_backbone_element=False),
        "exact": FhirCqlType(name="Boolean", is_backbone_element=False),
        "length": FhirCqlType(name="Integer", is_backbone_element=False),
        "outer": FhirCqlType(name="MolecularSequence_Outer", is_backbone_element=True),
        "inner": FhirCqlType(name="MolecularSequence_Inner", is_backbone_element=True),
    },
    "MolecularSequence_Variant": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "start": FhirCqlType(name="Integer", is_backbone_element=False),
        "end": FhirCqlType(name="Integer", is_backbone_element=False),
        "observedAllele": FhirCqlType(name="String", is_backbone_element=False),
        "referenceAllele": FhirCqlType(name="String", is_backbone_element=False),
        "cigar": FhirCqlType(name="String", is_backbone_element=False),
        "variantPointer": FhirCqlType(name="Reference", is_backbone_element=True),
    },
    "Money": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "value": FhirCqlType(name="Decimal", is_backbone_element=False),
        "currency": FhirCqlType(name="Code", is_backbone_element=False),
    },
    "NamingSystem_UniqueId": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "type": FhirCqlType(name="String", is_backbone_element=False),
        "value": FhirCqlType(name="String", is_backbone_element=False),
        "preferred": FhirCqlType(name="Boolean", is_backbone_element=False),
        "comment": FhirCqlType(name="String", is_backbone_element=False),
        "period": FhirInterval(
            name="Interval",
            is_backbone_element=False,
            item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
        ),
    },
    "Narrative": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "status": FhirCqlType(name="String", is_backbone_element=False),
        "div": FhirCqlType(name="String", is_backbone_element=False),
    },
    "NutritionOrder_Administration": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "schedule": FhirCqlType(name="Timing", is_backbone_element=True),
        "quantity": FhirCqlType(name="Decimal", is_backbone_element=False),
        "rate": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Ratio", is_backbone_element=True),
                FhirCqlType(name="Decimal", is_backbone_element=False),
            ],
        ),
    },
    "NutritionOrder_EnteralFormula": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "baseFormulaType": FhirCqlType(name="Concept", is_backbone_element=False),
        "baseFormulaProductName": FhirCqlType(name="String", is_backbone_element=False),
        "additiveType": FhirCqlType(name="Concept", is_backbone_element=False),
        "additiveProductName": FhirCqlType(name="String", is_backbone_element=False),
        "caloricDensity": FhirCqlType(name="Decimal", is_backbone_element=False),
        "routeofAdministration": FhirCqlType(name="Concept", is_backbone_element=False),
        "administration": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="NutritionOrder_Administration", is_backbone_element=True
            ),
        ),
        "maxVolumeToDeliver": FhirCqlType(name="Decimal", is_backbone_element=False),
        "administrationInstruction": FhirCqlType(
            name="String", is_backbone_element=False
        ),
    },
    "NutritionOrder_Nutrient": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifier": FhirCqlType(name="Concept", is_backbone_element=False),
        "amount": FhirCqlType(name="Decimal", is_backbone_element=False),
    },
    "NutritionOrder_OralDiet": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "type": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "schedule": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Timing", is_backbone_element=True),
        ),
        "nutrient": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="NutritionOrder_Nutrient", is_backbone_element=True
            ),
        ),
        "texture": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="NutritionOrder_Texture", is_backbone_element=True
            ),
        ),
        "fluidConsistencyType": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "instruction": FhirCqlType(name="String", is_backbone_element=False),
    },
    "NutritionOrder_Supplement": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "productName": FhirCqlType(name="String", is_backbone_element=False),
        "schedule": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Timing", is_backbone_element=True),
        ),
        "quantity": FhirCqlType(name="Decimal", is_backbone_element=False),
        "instruction": FhirCqlType(name="String", is_backbone_element=False),
    },
    "NutritionOrder_Texture": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifier": FhirCqlType(name="Concept", is_backbone_element=False),
        "foodType": FhirCqlType(name="Concept", is_backbone_element=False),
    },
    "ObservationDefinition_QualifiedInterval": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "category": FhirCqlType(name="String", is_backbone_element=False),
        "range": FhirInterval(
            name="Interval",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Decimal", is_backbone_element=False),
        ),
        "context": FhirCqlType(name="Concept", is_backbone_element=False),
        "appliesTo": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "gender": FhirCqlType(name="String", is_backbone_element=False),
        "age": FhirInterval(
            name="Interval",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Decimal", is_backbone_element=False),
        ),
        "gestationalAge": FhirInterval(
            name="Interval",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Decimal", is_backbone_element=False),
        ),
        "condition": FhirCqlType(name="String", is_backbone_element=False),
    },
    "ObservationDefinition_QuantitativeDetails": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "customaryUnit": FhirCqlType(name="Concept", is_backbone_element=False),
        "unit": FhirCqlType(name="Concept", is_backbone_element=False),
        "conversionFactor": FhirCqlType(name="Decimal", is_backbone_element=False),
        "decimalPrecision": FhirCqlType(name="Integer", is_backbone_element=False),
    },
    "Observation_Component": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "code": FhirCqlType(name="Concept", is_backbone_element=False),
        "value": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="Decimal", is_backbone_element=False),
                ),
                FhirCqlType(name="String", is_backbone_element=False),
                FhirCqlType(name="Ratio", is_backbone_element=True),
                FhirCqlType(name="Decimal", is_backbone_element=False),
                FhirCqlType(name="Boolean", is_backbone_element=False),
                FhirCqlType(name="Concept", is_backbone_element=False),
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
                ),
                FhirCqlType(name="SampledData", is_backbone_element=True),
                FhirCqlType(name="DateTime", is_backbone_element=False),
            ],
        ),
        "dataAbsentReason": FhirCqlType(name="Concept", is_backbone_element=False),
        "interpretation": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "referenceRange": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="Observation_ReferenceRange", is_backbone_element=True
            ),
        ),
    },
    "Observation_ReferenceRange": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "low": FhirCqlType(name="Decimal", is_backbone_element=False),
        "high": FhirCqlType(name="Decimal", is_backbone_element=False),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "appliesTo": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "age": FhirInterval(
            name="Interval",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Decimal", is_backbone_element=False),
        ),
        "text": FhirCqlType(name="String", is_backbone_element=False),
    },
    "OperationDefinition_Binding": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "strength": FhirCqlType(name="String", is_backbone_element=False),
        "valueSet": FhirCqlType(name="String", is_backbone_element=False),
    },
    "OperationDefinition_Overload": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "parameterName": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "comment": FhirCqlType(name="String", is_backbone_element=False),
    },
    "OperationDefinition_Parameter": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "name": FhirCqlType(name="Code", is_backbone_element=False),
        "use": FhirCqlType(name="String", is_backbone_element=False),
        "min": FhirCqlType(name="Integer", is_backbone_element=False),
        "max": FhirCqlType(name="String", is_backbone_element=False),
        "documentation": FhirCqlType(name="String", is_backbone_element=False),
        "type": FhirCqlType(name="Code", is_backbone_element=False),
        "targetProfile": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "searchType": FhirCqlType(name="String", is_backbone_element=False),
        "binding": FhirCqlType(
            name="OperationDefinition_Binding", is_backbone_element=True
        ),
        "referencedFrom": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="OperationDefinition_ReferencedFrom", is_backbone_element=True
            ),
        ),
        "part": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="OperationDefinition_Parameter", is_backbone_element=True
            ),
        ),
    },
    "OperationDefinition_ReferencedFrom": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "source": FhirCqlType(name="String", is_backbone_element=False),
        "sourceId": FhirCqlType(name="String", is_backbone_element=False),
    },
    "OperationOutcome_Issue": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "severity": FhirCqlType(name="String", is_backbone_element=False),
        "code": FhirCqlType(name="String", is_backbone_element=False),
        "details": FhirCqlType(name="Concept", is_backbone_element=False),
        "diagnostics": FhirCqlType(name="String", is_backbone_element=False),
        "location": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "expression": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
    },
    "Organization_Contact": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "purpose": FhirCqlType(name="Concept", is_backbone_element=False),
        "name": FhirCqlType(name="HumanName", is_backbone_element=True),
        "telecom": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactPoint", is_backbone_element=True),
        ),
        "address": FhirCqlType(name="Address", is_backbone_element=True),
    },
    "ParameterDefinition": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "name": FhirCqlType(name="Code", is_backbone_element=False),
        "use": FhirCqlType(name="Code", is_backbone_element=False),
        "min": FhirCqlType(name="Integer", is_backbone_element=False),
        "max": FhirCqlType(name="String", is_backbone_element=False),
        "documentation": FhirCqlType(name="String", is_backbone_element=False),
        "type": FhirCqlType(name="Code", is_backbone_element=False),
        "profile": FhirCqlType(name="String", is_backbone_element=False),
    },
    "Parameters_Parameter": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "name": FhirCqlType(name="String", is_backbone_element=False),
        "value": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Distance", is_backbone_element=True),
                FhirCqlType(name="Signature", is_backbone_element=True),
                FhirCqlType(name="Annotation", is_backbone_element=True),
                FhirCqlType(name="Concept", is_backbone_element=False),
                FhirCqlType(name="Age", is_backbone_element=True),
                FhirCqlType(name="HumanName", is_backbone_element=True),
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
                ),
                FhirCqlType(name="SampledData", is_backbone_element=True),
                FhirCqlType(name="Timing", is_backbone_element=True),
                FhirCqlType(name="DateTime", is_backbone_element=False),
                FhirCqlType(name="ContactDetail", is_backbone_element=True),
                FhirCqlType(name="TriggerDefinition", is_backbone_element=True),
                FhirCqlType(name="UsageContext", is_backbone_element=True),
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="Decimal", is_backbone_element=False),
                ),
                FhirCqlType(name="Meta", is_backbone_element=True),
                FhirCqlType(name="Reference", is_backbone_element=True),
                FhirCqlType(name="Date", is_backbone_element=False),
                FhirCqlType(name="Ratio", is_backbone_element=True),
                FhirCqlType(name="Decimal", is_backbone_element=False),
                FhirCqlType(name="Expression", is_backbone_element=True),
                FhirCqlType(name="ParameterDefinition", is_backbone_element=True),
                FhirCqlType(name="Identifier", is_backbone_element=True),
                FhirCqlType(name="RelatedArtifact", is_backbone_element=True),
                FhirCqlType(name="DataRequirement", is_backbone_element=True),
                FhirCqlType(name="Dosage", is_backbone_element=True),
                FhirCqlType(name="Count", is_backbone_element=True),
                FhirCqlType(name="Duration", is_backbone_element=True),
                FhirCqlType(name="ContactPoint", is_backbone_element=True),
                FhirCqlType(name="Money", is_backbone_element=True),
                FhirCqlType(name="Attachment", is_backbone_element=True),
                FhirCqlType(name="String", is_backbone_element=False),
                FhirCqlType(name="Contributor", is_backbone_element=True),
                FhirCqlType(name="Boolean", is_backbone_element=False),
                FhirCqlType(name="Code", is_backbone_element=False),
                FhirCqlType(name="Address", is_backbone_element=True),
            ],
        ),
        "resource": FhirCqlType(name="String", is_backbone_element=False),
        "part": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="Parameters_Parameter", is_backbone_element=True
            ),
        ),
    },
    "Patient_Communication": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "language": FhirCqlType(name="Concept", is_backbone_element=False),
        "preferred": FhirCqlType(name="Boolean", is_backbone_element=False),
    },
    "Patient_Contact": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "relationship": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "name": FhirCqlType(name="HumanName", is_backbone_element=True),
        "telecom": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ContactPoint", is_backbone_element=True),
        ),
        "address": FhirCqlType(name="Address", is_backbone_element=True),
        "gender": FhirCqlType(name="String", is_backbone_element=False),
        "organization": FhirCqlType(name="Reference", is_backbone_element=True),
        "period": FhirInterval(
            name="Interval",
            is_backbone_element=False,
            item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
        ),
    },
    "Patient_Link": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "other": FhirCqlType(name="Reference", is_backbone_element=True),
        "type": FhirCqlType(name="String", is_backbone_element=False),
    },
    "PaymentReconciliation_Detail": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirCqlType(name="Identifier", is_backbone_element=True),
        "predecessor": FhirCqlType(name="Identifier", is_backbone_element=True),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "request": FhirCqlType(name="Reference", is_backbone_element=True),
        "submitter": FhirCqlType(name="Reference", is_backbone_element=True),
        "response": FhirCqlType(name="Reference", is_backbone_element=True),
        "date": FhirCqlType(name="Date", is_backbone_element=False),
        "responsible": FhirCqlType(name="Reference", is_backbone_element=True),
        "payee": FhirCqlType(name="Reference", is_backbone_element=True),
        "amount": FhirCqlType(name="Money", is_backbone_element=True),
    },
    "PaymentReconciliation_ProcessNote": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "type": FhirCqlType(name="String", is_backbone_element=False),
        "text": FhirCqlType(name="String", is_backbone_element=False),
    },
    "Period": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "start": FhirCqlType(name="DateTime", is_backbone_element=False),
        "end": FhirCqlType(name="DateTime", is_backbone_element=False),
    },
    "Person_Link": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "target": FhirCqlType(name="Reference", is_backbone_element=True),
        "assurance": FhirCqlType(name="String", is_backbone_element=False),
    },
    "PlanDefinition_Action": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "prefix": FhirCqlType(name="String", is_backbone_element=False),
        "title": FhirCqlType(name="String", is_backbone_element=False),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "textEquivalent": FhirCqlType(name="String", is_backbone_element=False),
        "priority": FhirCqlType(name="Code", is_backbone_element=False),
        "code": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "reason": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "documentation": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="RelatedArtifact", is_backbone_element=True),
        ),
        "goalId": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "subject": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Concept", is_backbone_element=False),
                FhirCqlType(name="Reference", is_backbone_element=True),
            ],
        ),
        "trigger": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="TriggerDefinition", is_backbone_element=True),
        ),
        "condition": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="PlanDefinition_Condition", is_backbone_element=True
            ),
        ),
        "input": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="DataRequirement", is_backbone_element=True),
        ),
        "output": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="DataRequirement", is_backbone_element=True),
        ),
        "relatedAction": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="PlanDefinition_RelatedAction", is_backbone_element=True
            ),
        ),
        "timing": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="Decimal", is_backbone_element=False),
                ),
                FhirCqlType(name="Timing", is_backbone_element=True),
                FhirCqlType(name="Duration", is_backbone_element=True),
                FhirCqlType(name="Age", is_backbone_element=True),
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
                ),
                FhirCqlType(name="DateTime", is_backbone_element=False),
            ],
        ),
        "participant": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="PlanDefinition_Participant", is_backbone_element=True
            ),
        ),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "groupingBehavior": FhirCqlType(name="String", is_backbone_element=False),
        "selectionBehavior": FhirCqlType(name="String", is_backbone_element=False),
        "requiredBehavior": FhirCqlType(name="String", is_backbone_element=False),
        "precheckBehavior": FhirCqlType(name="String", is_backbone_element=False),
        "cardinalityBehavior": FhirCqlType(name="String", is_backbone_element=False),
        "definition": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[FhirCqlType(name="String", is_backbone_element=False)],
        ),
        "transform": FhirCqlType(name="String", is_backbone_element=False),
        "dynamicValue": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="PlanDefinition_DynamicValue", is_backbone_element=True
            ),
        ),
        "action": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="PlanDefinition_Action", is_backbone_element=True
            ),
        ),
    },
    "PlanDefinition_Condition": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "kind": FhirCqlType(name="String", is_backbone_element=False),
        "expression": FhirCqlType(name="Expression", is_backbone_element=True),
    },
    "PlanDefinition_DynamicValue": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "path": FhirCqlType(name="String", is_backbone_element=False),
        "expression": FhirCqlType(name="Expression", is_backbone_element=True),
    },
    "PlanDefinition_Goal": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "category": FhirCqlType(name="Concept", is_backbone_element=False),
        "description": FhirCqlType(name="Concept", is_backbone_element=False),
        "priority": FhirCqlType(name="Concept", is_backbone_element=False),
        "start": FhirCqlType(name="Concept", is_backbone_element=False),
        "addresses": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "documentation": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="RelatedArtifact", is_backbone_element=True),
        ),
        "target": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="PlanDefinition_Target", is_backbone_element=True
            ),
        ),
    },
    "PlanDefinition_Participant": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "type": FhirCqlType(name="String", is_backbone_element=False),
        "role": FhirCqlType(name="Concept", is_backbone_element=False),
    },
    "PlanDefinition_RelatedAction": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "actionId": FhirCqlType(name="String", is_backbone_element=False),
        "relationship": FhirCqlType(name="String", is_backbone_element=False),
        "offset": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="Decimal", is_backbone_element=False),
                ),
                FhirCqlType(name="Duration", is_backbone_element=True),
            ],
        ),
    },
    "PlanDefinition_Target": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "measure": FhirCqlType(name="Concept", is_backbone_element=False),
        "detail": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Decimal", is_backbone_element=False),
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="Decimal", is_backbone_element=False),
                ),
                FhirCqlType(name="Concept", is_backbone_element=False),
            ],
        ),
        "due": FhirCqlType(name="Duration", is_backbone_element=True),
    },
    "Population": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "age": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="Decimal", is_backbone_element=False),
                ),
                FhirCqlType(name="Concept", is_backbone_element=False),
            ],
        ),
        "gender": FhirCqlType(name="Concept", is_backbone_element=False),
        "race": FhirCqlType(name="Concept", is_backbone_element=False),
        "physiologicalCondition": FhirCqlType(
            name="Concept", is_backbone_element=False
        ),
    },
    "PractitionerRole_AvailableTime": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "daysOfWeek": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Code", is_backbone_element=False),
        ),
        "allDay": FhirCqlType(name="Boolean", is_backbone_element=False),
        "availableStartTime": FhirCqlType(name="String", is_backbone_element=False),
        "availableEndTime": FhirCqlType(name="String", is_backbone_element=False),
    },
    "PractitionerRole_NotAvailable": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "during": FhirInterval(
            name="Interval",
            is_backbone_element=False,
            item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
        ),
    },
    "Practitioner_Qualification": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "code": FhirCqlType(name="Concept", is_backbone_element=False),
        "period": FhirInterval(
            name="Interval",
            is_backbone_element=False,
            item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
        ),
        "issuer": FhirCqlType(name="Reference", is_backbone_element=True),
    },
    "Procedure_FocalDevice": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "action": FhirCqlType(name="Concept", is_backbone_element=False),
        "manipulated": FhirCqlType(name="Reference", is_backbone_element=True),
    },
    "Procedure_Performer": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "function": FhirCqlType(name="Concept", is_backbone_element=False),
        "actor": FhirCqlType(name="Reference", is_backbone_element=True),
        "onBehalfOf": FhirCqlType(name="Reference", is_backbone_element=True),
    },
    "ProdCharacteristic": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "height": FhirCqlType(name="Decimal", is_backbone_element=False),
        "width": FhirCqlType(name="Decimal", is_backbone_element=False),
        "depth": FhirCqlType(name="Decimal", is_backbone_element=False),
        "weight": FhirCqlType(name="Decimal", is_backbone_element=False),
        "nominalVolume": FhirCqlType(name="Decimal", is_backbone_element=False),
        "externalDiameter": FhirCqlType(name="Decimal", is_backbone_element=False),
        "shape": FhirCqlType(name="String", is_backbone_element=False),
        "color": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "imprint": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "image": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Attachment", is_backbone_element=True),
        ),
        "scoring": FhirCqlType(name="Concept", is_backbone_element=False),
    },
    "ProductShelfLife": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirCqlType(name="Identifier", is_backbone_element=True),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "period": FhirCqlType(name="Decimal", is_backbone_element=False),
        "specialPrecautionsForStorage": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
    },
    "Provenance_Agent": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "role": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "who": FhirCqlType(name="Reference", is_backbone_element=True),
        "onBehalfOf": FhirCqlType(name="Reference", is_backbone_element=True),
    },
    "Provenance_Entity": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "role": FhirCqlType(name="String", is_backbone_element=False),
        "what": FhirCqlType(name="Reference", is_backbone_element=True),
        "agent": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Provenance_Agent", is_backbone_element=True),
        ),
    },
    "Quantity": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "value": FhirCqlType(name="Decimal", is_backbone_element=False),
        "comparator": FhirCqlType(name="String", is_backbone_element=False),
        "unit": FhirCqlType(name="String", is_backbone_element=False),
        "system": FhirCqlType(name="String", is_backbone_element=False),
        "code": FhirCqlType(name="Code", is_backbone_element=False),
    },
    "QuestionnaireResponse_Answer": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "value": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Attachment", is_backbone_element=True),
                FhirCqlType(name="String", is_backbone_element=False),
                FhirCqlType(name="Reference", is_backbone_element=True),
                FhirCqlType(name="Date", is_backbone_element=False),
                FhirCqlType(name="Decimal", is_backbone_element=False),
                FhirCqlType(name="Boolean", is_backbone_element=False),
                FhirCqlType(name="Code", is_backbone_element=False),
                FhirCqlType(name="DateTime", is_backbone_element=False),
            ],
        ),
        "item": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="QuestionnaireResponse_Item", is_backbone_element=True
            ),
        ),
    },
    "QuestionnaireResponse_Item": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "linkId": FhirCqlType(name="String", is_backbone_element=False),
        "definition": FhirCqlType(name="String", is_backbone_element=False),
        "text": FhirCqlType(name="String", is_backbone_element=False),
        "answer": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="QuestionnaireResponse_Answer", is_backbone_element=True
            ),
        ),
        "item": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="QuestionnaireResponse_Item", is_backbone_element=True
            ),
        ),
    },
    "Questionnaire_AnswerOption": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "value": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Date", is_backbone_element=False),
                FhirCqlType(name="Reference", is_backbone_element=True),
                FhirCqlType(name="Code", is_backbone_element=False),
                FhirCqlType(name="String", is_backbone_element=False),
            ],
        ),
        "initialSelected": FhirCqlType(name="Boolean", is_backbone_element=False),
    },
    "Questionnaire_EnableWhen": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "question": FhirCqlType(name="String", is_backbone_element=False),
        "operator": FhirCqlType(name="String", is_backbone_element=False),
        "answer": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Reference", is_backbone_element=True),
                FhirCqlType(name="String", is_backbone_element=False),
                FhirCqlType(name="Date", is_backbone_element=False),
                FhirCqlType(name="Decimal", is_backbone_element=False),
                FhirCqlType(name="Boolean", is_backbone_element=False),
                FhirCqlType(name="Code", is_backbone_element=False),
                FhirCqlType(name="DateTime", is_backbone_element=False),
            ],
        ),
    },
    "Questionnaire_Initial": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "value": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Attachment", is_backbone_element=True),
                FhirCqlType(name="String", is_backbone_element=False),
                FhirCqlType(name="Reference", is_backbone_element=True),
                FhirCqlType(name="Date", is_backbone_element=False),
                FhirCqlType(name="Decimal", is_backbone_element=False),
                FhirCqlType(name="Boolean", is_backbone_element=False),
                FhirCqlType(name="Code", is_backbone_element=False),
                FhirCqlType(name="DateTime", is_backbone_element=False),
            ],
        ),
    },
    "Questionnaire_Item": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "linkId": FhirCqlType(name="String", is_backbone_element=False),
        "definition": FhirCqlType(name="String", is_backbone_element=False),
        "code": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Code", is_backbone_element=False),
        ),
        "prefix": FhirCqlType(name="String", is_backbone_element=False),
        "text": FhirCqlType(name="String", is_backbone_element=False),
        "type": FhirCqlType(name="String", is_backbone_element=False),
        "enableWhen": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="Questionnaire_EnableWhen", is_backbone_element=True
            ),
        ),
        "enableBehavior": FhirCqlType(name="String", is_backbone_element=False),
        "required": FhirCqlType(name="Boolean", is_backbone_element=False),
        "repeats": FhirCqlType(name="Boolean", is_backbone_element=False),
        "readOnly": FhirCqlType(name="Boolean", is_backbone_element=False),
        "maxLength": FhirCqlType(name="Integer", is_backbone_element=False),
        "answerValueSet": FhirCqlType(name="String", is_backbone_element=False),
        "answerOption": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="Questionnaire_AnswerOption", is_backbone_element=True
            ),
        ),
        "initial": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="Questionnaire_Initial", is_backbone_element=True
            ),
        ),
        "item": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Questionnaire_Item", is_backbone_element=True),
        ),
    },
    "Range": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "low": FhirCqlType(name="Decimal", is_backbone_element=False),
        "high": FhirCqlType(name="Decimal", is_backbone_element=False),
    },
    "Ratio": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "numerator": FhirCqlType(name="Decimal", is_backbone_element=False),
        "denominator": FhirCqlType(name="Decimal", is_backbone_element=False),
    },
    "Reference": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "reference": FhirCqlType(name="String", is_backbone_element=False),
        "type": FhirCqlType(name="String", is_backbone_element=False),
        "identifier": FhirCqlType(name="Identifier", is_backbone_element=True),
        "display": FhirCqlType(name="String", is_backbone_element=False),
    },
    "RelatedArtifact": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "type": FhirCqlType(name="String", is_backbone_element=False),
        "label": FhirCqlType(name="String", is_backbone_element=False),
        "display": FhirCqlType(name="String", is_backbone_element=False),
        "citation": FhirCqlType(name="String", is_backbone_element=False),
        "url": FhirCqlType(name="String", is_backbone_element=False),
        "document": FhirCqlType(name="Attachment", is_backbone_element=True),
        "resource": FhirCqlType(name="String", is_backbone_element=False),
    },
    "RelatedPerson_Communication": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "language": FhirCqlType(name="Concept", is_backbone_element=False),
        "preferred": FhirCqlType(name="Boolean", is_backbone_element=False),
    },
    "RequestGroup_Action": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "prefix": FhirCqlType(name="String", is_backbone_element=False),
        "title": FhirCqlType(name="String", is_backbone_element=False),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "textEquivalent": FhirCqlType(name="String", is_backbone_element=False),
        "priority": FhirCqlType(name="Code", is_backbone_element=False),
        "code": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "documentation": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="RelatedArtifact", is_backbone_element=True),
        ),
        "condition": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="RequestGroup_Condition", is_backbone_element=True
            ),
        ),
        "relatedAction": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="RequestGroup_RelatedAction", is_backbone_element=True
            ),
        ),
        "timing": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="Decimal", is_backbone_element=False),
                ),
                FhirCqlType(name="Timing", is_backbone_element=True),
                FhirCqlType(name="Duration", is_backbone_element=True),
                FhirCqlType(name="Age", is_backbone_element=True),
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
                ),
                FhirCqlType(name="DateTime", is_backbone_element=False),
            ],
        ),
        "participant": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "groupingBehavior": FhirCqlType(name="Code", is_backbone_element=False),
        "selectionBehavior": FhirCqlType(name="Code", is_backbone_element=False),
        "requiredBehavior": FhirCqlType(name="Code", is_backbone_element=False),
        "precheckBehavior": FhirCqlType(name="Code", is_backbone_element=False),
        "cardinalityBehavior": FhirCqlType(name="Code", is_backbone_element=False),
        "resource": FhirCqlType(name="Reference", is_backbone_element=True),
        "action": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="RequestGroup_Action", is_backbone_element=True),
        ),
    },
    "RequestGroup_Condition": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "kind": FhirCqlType(name="Code", is_backbone_element=False),
        "expression": FhirCqlType(name="Expression", is_backbone_element=True),
    },
    "RequestGroup_RelatedAction": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "actionId": FhirCqlType(name="String", is_backbone_element=False),
        "relationship": FhirCqlType(name="Code", is_backbone_element=False),
        "offset": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="Decimal", is_backbone_element=False),
                ),
                FhirCqlType(name="Duration", is_backbone_element=True),
            ],
        ),
    },
    "ResearchElementDefinition_Characteristic": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "definition": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Concept", is_backbone_element=False),
                FhirCqlType(name="DataRequirement", is_backbone_element=True),
                FhirCqlType(name="String", is_backbone_element=False),
                FhirCqlType(name="Expression", is_backbone_element=True),
            ],
        ),
        "usageContext": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="UsageContext", is_backbone_element=True),
        ),
        "exclude": FhirCqlType(name="Boolean", is_backbone_element=False),
        "unitOfMeasure": FhirCqlType(name="Concept", is_backbone_element=False),
        "studyEffectiveDescription": FhirCqlType(
            name="String", is_backbone_element=False
        ),
        "": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Timing", is_backbone_element=True),
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
                ),
                FhirCqlType(name="String", is_backbone_element=False),
                FhirCqlType(name="Duration", is_backbone_element=True),
            ],
        ),
        "studyEffectiveTimeFromStart": FhirCqlType(
            name="Duration", is_backbone_element=True
        ),
        "studyEffectiveGroupMeasure": FhirCqlType(
            name="String", is_backbone_element=False
        ),
        "participantEffectiveDescription": FhirCqlType(
            name="String", is_backbone_element=False
        ),
        "participantEffectiveTimeFromStart": FhirCqlType(
            name="Duration", is_backbone_element=True
        ),
        "participantEffectiveGroupMeasure": FhirCqlType(
            name="String", is_backbone_element=False
        ),
    },
    "ResearchStudy_Arm": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "name": FhirCqlType(name="String", is_backbone_element=False),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "description": FhirCqlType(name="String", is_backbone_element=False),
    },
    "ResearchStudy_Objective": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "name": FhirCqlType(name="String", is_backbone_element=False),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
    },
    "RiskAssessment_Prediction": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "outcome": FhirCqlType(name="Concept", is_backbone_element=False),
        "probability": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="Decimal", is_backbone_element=False),
                ),
                FhirCqlType(name="String", is_backbone_element=False),
            ],
        ),
        "qualitativeRisk": FhirCqlType(name="Concept", is_backbone_element=False),
        "relativeRisk": FhirCqlType(name="Decimal", is_backbone_element=False),
        "when": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
                ),
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="Decimal", is_backbone_element=False),
                ),
            ],
        ),
        "rationale": FhirCqlType(name="String", is_backbone_element=False),
    },
    "RiskEvidenceSynthesis_Certainty": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "rating": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "note": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Annotation", is_backbone_element=True),
        ),
        "certaintySubcomponent": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="RiskEvidenceSynthesis_CertaintySubcomponent",
                is_backbone_element=True,
            ),
        ),
    },
    "RiskEvidenceSynthesis_CertaintySubcomponent": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "rating": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "note": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Annotation", is_backbone_element=True),
        ),
    },
    "RiskEvidenceSynthesis_PrecisionEstimate": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "level": FhirCqlType(name="Decimal", is_backbone_element=False),
        "from": FhirCqlType(name="Decimal", is_backbone_element=False),
        "to": FhirCqlType(name="Decimal", is_backbone_element=False),
    },
    "RiskEvidenceSynthesis_RiskEstimate": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "value": FhirCqlType(name="Decimal", is_backbone_element=False),
        "unitOfMeasure": FhirCqlType(name="Concept", is_backbone_element=False),
        "denominatorCount": FhirCqlType(name="Integer", is_backbone_element=False),
        "numeratorCount": FhirCqlType(name="Integer", is_backbone_element=False),
        "precisionEstimate": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="RiskEvidenceSynthesis_PrecisionEstimate", is_backbone_element=True
            ),
        ),
    },
    "RiskEvidenceSynthesis_SampleSize": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "numberOfStudies": FhirCqlType(name="Integer", is_backbone_element=False),
        "numberOfParticipants": FhirCqlType(name="Integer", is_backbone_element=False),
    },
    "SampledData": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "origin": FhirCqlType(name="Decimal", is_backbone_element=False),
        "period": FhirCqlType(name="Decimal", is_backbone_element=False),
        "factor": FhirCqlType(name="Decimal", is_backbone_element=False),
        "lowerLimit": FhirCqlType(name="Decimal", is_backbone_element=False),
        "upperLimit": FhirCqlType(name="Decimal", is_backbone_element=False),
        "dimensions": FhirCqlType(name="String", is_backbone_element=False),
        "data": FhirCqlType(name="String", is_backbone_element=False),
    },
    "SearchParameter_Component": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "definition": FhirCqlType(name="String", is_backbone_element=False),
        "expression": FhirCqlType(name="String", is_backbone_element=False),
    },
    "Signature": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "type": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Code", is_backbone_element=False),
        ),
        "when": FhirCqlType(name="String", is_backbone_element=False),
        "who": FhirCqlType(name="Reference", is_backbone_element=True),
        "onBehalfOf": FhirCqlType(name="Reference", is_backbone_element=True),
        "targetFormat": FhirCqlType(name="Code", is_backbone_element=False),
        "sigFormat": FhirCqlType(name="Code", is_backbone_element=False),
        "data": FhirCqlType(name="String", is_backbone_element=False),
    },
    "SpecimenDefinition_Additive": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "additive": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Concept", is_backbone_element=False),
                FhirCqlType(name="Reference", is_backbone_element=True),
            ],
        ),
    },
    "SpecimenDefinition_Container": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "material": FhirCqlType(name="Concept", is_backbone_element=False),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "cap": FhirCqlType(name="Concept", is_backbone_element=False),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "capacity": FhirCqlType(name="Decimal", is_backbone_element=False),
        "minimumVolume": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Decimal", is_backbone_element=False),
                FhirCqlType(name="String", is_backbone_element=False),
            ],
        ),
        "additive": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="SpecimenDefinition_Additive", is_backbone_element=True
            ),
        ),
        "preparation": FhirCqlType(name="String", is_backbone_element=False),
    },
    "SpecimenDefinition_Handling": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "temperatureQualifier": FhirCqlType(name="Concept", is_backbone_element=False),
        "temperatureRange": FhirInterval(
            name="Interval",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Decimal", is_backbone_element=False),
        ),
        "maxDuration": FhirCqlType(name="Duration", is_backbone_element=True),
        "instruction": FhirCqlType(name="String", is_backbone_element=False),
    },
    "SpecimenDefinition_TypeTested": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "isDerived": FhirCqlType(name="Boolean", is_backbone_element=False),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "preference": FhirCqlType(name="String", is_backbone_element=False),
        "container": FhirCqlType(
            name="SpecimenDefinition_Container", is_backbone_element=True
        ),
        "requirement": FhirCqlType(name="String", is_backbone_element=False),
        "retentionTime": FhirCqlType(name="Duration", is_backbone_element=True),
        "rejectionCriterion": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "handling": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="SpecimenDefinition_Handling", is_backbone_element=True
            ),
        ),
    },
    "Specimen_Collection": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "collector": FhirCqlType(name="Reference", is_backbone_element=True),
        "collected": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
                ),
                FhirCqlType(name="DateTime", is_backbone_element=False),
            ],
        ),
        "duration": FhirCqlType(name="Duration", is_backbone_element=True),
        "quantity": FhirCqlType(name="Decimal", is_backbone_element=False),
        "method": FhirCqlType(name="Concept", is_backbone_element=False),
        "bodySite": FhirCqlType(name="Concept", is_backbone_element=False),
        "fastingStatus": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Concept", is_backbone_element=False),
                FhirCqlType(name="Duration", is_backbone_element=True),
            ],
        ),
    },
    "Specimen_Container": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Identifier", is_backbone_element=True),
        ),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "capacity": FhirCqlType(name="Decimal", is_backbone_element=False),
        "specimenQuantity": FhirCqlType(name="Decimal", is_backbone_element=False),
        "additive": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Concept", is_backbone_element=False),
                FhirCqlType(name="Reference", is_backbone_element=True),
            ],
        ),
    },
    "Specimen_Processing": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "procedure": FhirCqlType(name="Concept", is_backbone_element=False),
        "additive": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "time": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
                ),
                FhirCqlType(name="DateTime", is_backbone_element=False),
            ],
        ),
    },
    "StructureDefinition_Context": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "type": FhirCqlType(name="String", is_backbone_element=False),
        "expression": FhirCqlType(name="String", is_backbone_element=False),
    },
    "StructureDefinition_Differential": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "element": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ElementDefinition", is_backbone_element=True),
        ),
    },
    "StructureDefinition_Mapping": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identity": FhirCqlType(name="String", is_backbone_element=False),
        "uri": FhirCqlType(name="String", is_backbone_element=False),
        "name": FhirCqlType(name="String", is_backbone_element=False),
        "comment": FhirCqlType(name="String", is_backbone_element=False),
    },
    "StructureDefinition_Snapshot": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "element": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="ElementDefinition", is_backbone_element=True),
        ),
    },
    "StructureMap_Dependent": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "name": FhirCqlType(name="String", is_backbone_element=False),
        "variable": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
    },
    "StructureMap_Group": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "name": FhirCqlType(name="String", is_backbone_element=False),
        "extends": FhirCqlType(name="String", is_backbone_element=False),
        "typeMode": FhirCqlType(name="String", is_backbone_element=False),
        "documentation": FhirCqlType(name="String", is_backbone_element=False),
        "input": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="StructureMap_Input", is_backbone_element=True),
        ),
        "rule": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="StructureMap_Rule", is_backbone_element=True),
        ),
    },
    "StructureMap_Input": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "name": FhirCqlType(name="String", is_backbone_element=False),
        "type": FhirCqlType(name="String", is_backbone_element=False),
        "mode": FhirCqlType(name="String", is_backbone_element=False),
        "documentation": FhirCqlType(name="String", is_backbone_element=False),
    },
    "StructureMap_Parameter": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "value": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Boolean", is_backbone_element=False),
                FhirCqlType(name="String", is_backbone_element=False),
            ],
        ),
    },
    "StructureMap_Rule": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "name": FhirCqlType(name="String", is_backbone_element=False),
        "source": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="StructureMap_Source", is_backbone_element=True),
        ),
        "target": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="StructureMap_Target", is_backbone_element=True),
        ),
        "rule": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="StructureMap_Rule", is_backbone_element=True),
        ),
        "dependent": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="StructureMap_Dependent", is_backbone_element=True
            ),
        ),
        "documentation": FhirCqlType(name="String", is_backbone_element=False),
    },
    "StructureMap_Source": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "context": FhirCqlType(name="String", is_backbone_element=False),
        "min": FhirCqlType(name="Integer", is_backbone_element=False),
        "max": FhirCqlType(name="String", is_backbone_element=False),
        "type": FhirCqlType(name="String", is_backbone_element=False),
        "defaultValue": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Distance", is_backbone_element=True),
                FhirCqlType(name="Signature", is_backbone_element=True),
                FhirCqlType(name="Annotation", is_backbone_element=True),
                FhirCqlType(name="Concept", is_backbone_element=False),
                FhirCqlType(name="Age", is_backbone_element=True),
                FhirCqlType(name="HumanName", is_backbone_element=True),
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
                ),
                FhirCqlType(name="SampledData", is_backbone_element=True),
                FhirCqlType(name="Timing", is_backbone_element=True),
                FhirCqlType(name="DateTime", is_backbone_element=False),
                FhirCqlType(name="ContactDetail", is_backbone_element=True),
                FhirCqlType(name="TriggerDefinition", is_backbone_element=True),
                FhirCqlType(name="UsageContext", is_backbone_element=True),
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="Decimal", is_backbone_element=False),
                ),
                FhirCqlType(name="Meta", is_backbone_element=True),
                FhirCqlType(name="Reference", is_backbone_element=True),
                FhirCqlType(name="Date", is_backbone_element=False),
                FhirCqlType(name="Ratio", is_backbone_element=True),
                FhirCqlType(name="Decimal", is_backbone_element=False),
                FhirCqlType(name="Expression", is_backbone_element=True),
                FhirCqlType(name="ParameterDefinition", is_backbone_element=True),
                FhirCqlType(name="Identifier", is_backbone_element=True),
                FhirCqlType(name="RelatedArtifact", is_backbone_element=True),
                FhirCqlType(name="DataRequirement", is_backbone_element=True),
                FhirCqlType(name="Dosage", is_backbone_element=True),
                FhirCqlType(name="Count", is_backbone_element=True),
                FhirCqlType(name="Duration", is_backbone_element=True),
                FhirCqlType(name="ContactPoint", is_backbone_element=True),
                FhirCqlType(name="Money", is_backbone_element=True),
                FhirCqlType(name="Attachment", is_backbone_element=True),
                FhirCqlType(name="String", is_backbone_element=False),
                FhirCqlType(name="Contributor", is_backbone_element=True),
                FhirCqlType(name="Boolean", is_backbone_element=False),
                FhirCqlType(name="Code", is_backbone_element=False),
                FhirCqlType(name="Address", is_backbone_element=True),
            ],
        ),
        "element": FhirCqlType(name="String", is_backbone_element=False),
        "listMode": FhirCqlType(name="String", is_backbone_element=False),
        "variable": FhirCqlType(name="String", is_backbone_element=False),
        "condition": FhirCqlType(name="String", is_backbone_element=False),
        "check": FhirCqlType(name="String", is_backbone_element=False),
        "logMessage": FhirCqlType(name="String", is_backbone_element=False),
    },
    "StructureMap_Structure": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "url": FhirCqlType(name="String", is_backbone_element=False),
        "mode": FhirCqlType(name="String", is_backbone_element=False),
        "alias": FhirCqlType(name="String", is_backbone_element=False),
        "documentation": FhirCqlType(name="String", is_backbone_element=False),
    },
    "StructureMap_Target": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "context": FhirCqlType(name="String", is_backbone_element=False),
        "contextType": FhirCqlType(name="String", is_backbone_element=False),
        "element": FhirCqlType(name="String", is_backbone_element=False),
        "variable": FhirCqlType(name="String", is_backbone_element=False),
        "listMode": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "listRuleId": FhirCqlType(name="String", is_backbone_element=False),
        "transform": FhirCqlType(name="String", is_backbone_element=False),
        "parameter": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="StructureMap_Parameter", is_backbone_element=True
            ),
        ),
    },
    "Subscription_Channel": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "type": FhirCqlType(name="String", is_backbone_element=False),
        "endpoint": FhirCqlType(name="String", is_backbone_element=False),
        "payload": FhirCqlType(name="Code", is_backbone_element=False),
        "header": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
    },
    "SubstanceAmount": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "amount": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Decimal", is_backbone_element=False),
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="Decimal", is_backbone_element=False),
                ),
                FhirCqlType(name="String", is_backbone_element=False),
            ],
        ),
        "amountType": FhirCqlType(name="Concept", is_backbone_element=False),
        "amountText": FhirCqlType(name="String", is_backbone_element=False),
        "referenceRange": FhirCqlType(
            name="SubstanceAmount_ReferenceRange", is_backbone_element=True
        ),
    },
    "SubstanceAmount_ReferenceRange": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "lowLimit": FhirCqlType(name="Decimal", is_backbone_element=False),
        "highLimit": FhirCqlType(name="Decimal", is_backbone_element=False),
    },
    "SubstanceNucleicAcid_Linkage": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "connectivity": FhirCqlType(name="String", is_backbone_element=False),
        "identifier": FhirCqlType(name="Identifier", is_backbone_element=True),
        "name": FhirCqlType(name="String", is_backbone_element=False),
        "residueSite": FhirCqlType(name="String", is_backbone_element=False),
    },
    "SubstanceNucleicAcid_Subunit": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "subunit": FhirCqlType(name="Integer", is_backbone_element=False),
        "sequence": FhirCqlType(name="String", is_backbone_element=False),
        "length": FhirCqlType(name="Integer", is_backbone_element=False),
        "sequenceAttachment": FhirCqlType(name="Attachment", is_backbone_element=True),
        "fivePrime": FhirCqlType(name="Concept", is_backbone_element=False),
        "threePrime": FhirCqlType(name="Concept", is_backbone_element=False),
        "linkage": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="SubstanceNucleicAcid_Linkage", is_backbone_element=True
            ),
        ),
        "sugar": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="SubstanceNucleicAcid_Sugar", is_backbone_element=True
            ),
        ),
    },
    "SubstanceNucleicAcid_Sugar": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirCqlType(name="Identifier", is_backbone_element=True),
        "name": FhirCqlType(name="String", is_backbone_element=False),
        "residueSite": FhirCqlType(name="String", is_backbone_element=False),
    },
    "SubstancePolymer_DegreeOfPolymerisation": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Concept", is_backbone_element=False),
                FhirCqlType(name="SubstanceAmount", is_backbone_element=True),
            ],
        ),
    },
    "SubstancePolymer_MonomerSet": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Concept", is_backbone_element=False),
                FhirList(
                    name="List",
                    is_backbone_element=False,
                    item_type=FhirCqlType(
                        name="SubstancePolymer_StartingMaterial",
                        is_backbone_element=True,
                    ),
                ),
            ],
        ),
    },
    "SubstancePolymer_Repeat": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Concept", is_backbone_element=False),
                FhirList(
                    name="List",
                    is_backbone_element=False,
                    item_type=FhirCqlType(
                        name="SubstancePolymer_RepeatUnit", is_backbone_element=True
                    ),
                ),
                FhirCqlType(name="Integer", is_backbone_element=False),
                FhirCqlType(name="String", is_backbone_element=False),
            ],
        ),
    },
    "SubstancePolymer_RepeatUnit": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="String", is_backbone_element=False),
                FhirList(
                    name="List",
                    is_backbone_element=False,
                    item_type=FhirCqlType(
                        name="SubstancePolymer_DegreeOfPolymerisation",
                        is_backbone_element=True,
                    ),
                ),
                FhirList(
                    name="List",
                    is_backbone_element=False,
                    item_type=FhirCqlType(
                        name="SubstancePolymer_StructuralRepresentation",
                        is_backbone_element=True,
                    ),
                ),
                FhirCqlType(name="Concept", is_backbone_element=False),
                FhirCqlType(name="SubstanceAmount", is_backbone_element=True),
            ],
        ),
    },
    "SubstancePolymer_StartingMaterial": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Boolean", is_backbone_element=False),
                FhirCqlType(name="Concept", is_backbone_element=False),
                FhirCqlType(name="SubstanceAmount", is_backbone_element=True),
            ],
        ),
    },
    "SubstancePolymer_StructuralRepresentation": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Concept", is_backbone_element=False),
                FhirCqlType(name="Attachment", is_backbone_element=True),
                FhirCqlType(name="String", is_backbone_element=False),
            ],
        ),
    },
    "SubstanceProtein_Subunit": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "subunit": FhirCqlType(name="Integer", is_backbone_element=False),
        "sequence": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Attachment", is_backbone_element=True),
                FhirCqlType(name="String", is_backbone_element=False),
            ],
        ),
        "length": FhirCqlType(name="Integer", is_backbone_element=False),
        "": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[FhirCqlType(name="Identifier", is_backbone_element=True)],
        ),
        "nTerminalModification": FhirCqlType(name="String", is_backbone_element=False),
        "cTerminalModification": FhirCqlType(name="String", is_backbone_element=False),
    },
    "SubstanceReferenceInformation_Classification": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Concept", is_backbone_element=False),
                FhirList(
                    name="List",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="Concept", is_backbone_element=False),
                ),
                FhirList(
                    name="List",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="Reference", is_backbone_element=True),
                ),
            ],
        ),
    },
    "SubstanceReferenceInformation_Gene": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Concept", is_backbone_element=False),
                FhirList(
                    name="List",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="Reference", is_backbone_element=True),
                ),
            ],
        ),
    },
    "SubstanceReferenceInformation_GeneElement": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirList(
                    name="List",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="Reference", is_backbone_element=True),
                ),
                FhirCqlType(name="Concept", is_backbone_element=False),
                FhirCqlType(name="Identifier", is_backbone_element=True),
            ],
        ),
    },
    "SubstanceReferenceInformation_Target": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="Decimal", is_backbone_element=False),
                ),
                FhirCqlType(name="String", is_backbone_element=False),
                FhirCqlType(name="Decimal", is_backbone_element=False),
                FhirCqlType(name="Identifier", is_backbone_element=True),
                FhirList(
                    name="List",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="Reference", is_backbone_element=True),
                ),
                FhirCqlType(name="Concept", is_backbone_element=False),
            ],
        ),
    },
    "SubstanceSourceMaterial_Author": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "authorType": FhirCqlType(name="Concept", is_backbone_element=False),
        "authorDescription": FhirCqlType(name="String", is_backbone_element=False),
    },
    "SubstanceSourceMaterial_FractionDescription": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "fraction": FhirCqlType(name="String", is_backbone_element=False),
        "materialType": FhirCqlType(name="Concept", is_backbone_element=False),
    },
    "SubstanceSourceMaterial_Hybrid": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "maternalOrganismId": FhirCqlType(name="String", is_backbone_element=False),
        "maternalOrganismName": FhirCqlType(name="String", is_backbone_element=False),
        "paternalOrganismId": FhirCqlType(name="String", is_backbone_element=False),
        "paternalOrganismName": FhirCqlType(name="String", is_backbone_element=False),
        "hybridType": FhirCqlType(name="Concept", is_backbone_element=False),
    },
    "SubstanceSourceMaterial_Organism": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "family": FhirCqlType(name="Concept", is_backbone_element=False),
        "genus": FhirCqlType(name="Concept", is_backbone_element=False),
        "species": FhirCqlType(name="Concept", is_backbone_element=False),
        "intraspecificType": FhirCqlType(name="Concept", is_backbone_element=False),
        "intraspecificDescription": FhirCqlType(
            name="String", is_backbone_element=False
        ),
        "author": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="SubstanceSourceMaterial_Author", is_backbone_element=True
            ),
        ),
        "hybrid": FhirCqlType(
            name="SubstanceSourceMaterial_Hybrid", is_backbone_element=True
        ),
        "organismGeneral": FhirCqlType(
            name="SubstanceSourceMaterial_OrganismGeneral", is_backbone_element=True
        ),
    },
    "SubstanceSourceMaterial_OrganismGeneral": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "kingdom": FhirCqlType(name="Concept", is_backbone_element=False),
        "phylum": FhirCqlType(name="Concept", is_backbone_element=False),
        "class": FhirCqlType(name="Concept", is_backbone_element=False),
        "order": FhirCqlType(name="Concept", is_backbone_element=False),
    },
    "SubstanceSourceMaterial_PartDescription": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "part": FhirCqlType(name="Concept", is_backbone_element=False),
        "partLocation": FhirCqlType(name="Concept", is_backbone_element=False),
    },
    "SubstanceSpecification_Code": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "code": FhirCqlType(name="Concept", is_backbone_element=False),
        "status": FhirCqlType(name="Concept", is_backbone_element=False),
        "statusDate": FhirCqlType(name="DateTime", is_backbone_element=False),
        "comment": FhirCqlType(name="String", is_backbone_element=False),
        "source": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
    },
    "SubstanceSpecification_Isotope": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirCqlType(name="Identifier", is_backbone_element=True),
        "name": FhirCqlType(name="Concept", is_backbone_element=False),
        "substitution": FhirCqlType(name="Concept", is_backbone_element=False),
        "halfLife": FhirCqlType(name="Decimal", is_backbone_element=False),
        "molecularWeight": FhirCqlType(
            name="SubstanceSpecification_MolecularWeight", is_backbone_element=True
        ),
    },
    "SubstanceSpecification_Moiety": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "role": FhirCqlType(name="Concept", is_backbone_element=False),
        "identifier": FhirCqlType(name="Identifier", is_backbone_element=True),
        "name": FhirCqlType(name="String", is_backbone_element=False),
        "stereochemistry": FhirCqlType(name="Concept", is_backbone_element=False),
        "opticalActivity": FhirCqlType(name="Concept", is_backbone_element=False),
        "molecularFormula": FhirCqlType(name="String", is_backbone_element=False),
        "amount": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Decimal", is_backbone_element=False),
                FhirCqlType(name="String", is_backbone_element=False),
            ],
        ),
    },
    "SubstanceSpecification_MolecularWeight": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "method": FhirCqlType(name="Concept", is_backbone_element=False),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "amount": FhirCqlType(name="Decimal", is_backbone_element=False),
    },
    "SubstanceSpecification_Name": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "name": FhirCqlType(name="String", is_backbone_element=False),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "status": FhirCqlType(name="Concept", is_backbone_element=False),
        "preferred": FhirCqlType(name="Boolean", is_backbone_element=False),
        "language": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "domain": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "jurisdiction": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Concept", is_backbone_element=False),
        ),
        "synonym": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="SubstanceSpecification_Name", is_backbone_element=True
            ),
        ),
        "translation": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="SubstanceSpecification_Name", is_backbone_element=True
            ),
        ),
        "official": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="SubstanceSpecification_Official", is_backbone_element=True
            ),
        ),
        "source": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
    },
    "SubstanceSpecification_Official": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "authority": FhirCqlType(name="Concept", is_backbone_element=False),
        "status": FhirCqlType(name="Concept", is_backbone_element=False),
        "date": FhirCqlType(name="DateTime", is_backbone_element=False),
    },
    "SubstanceSpecification_Property": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "category": FhirCqlType(name="Concept", is_backbone_element=False),
        "code": FhirCqlType(name="Concept", is_backbone_element=False),
        "parameters": FhirCqlType(name="String", is_backbone_element=False),
        "definingSubstance": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Concept", is_backbone_element=False),
                FhirCqlType(name="Reference", is_backbone_element=True),
            ],
        ),
        "amount": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Decimal", is_backbone_element=False),
                FhirCqlType(name="String", is_backbone_element=False),
            ],
        ),
    },
    "SubstanceSpecification_Relationship": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "substance": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Concept", is_backbone_element=False),
                FhirCqlType(name="Reference", is_backbone_element=True),
            ],
        ),
        "relationship": FhirCqlType(name="Concept", is_backbone_element=False),
        "isDefining": FhirCqlType(name="Boolean", is_backbone_element=False),
        "amount": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Ratio", is_backbone_element=True),
                FhirCqlType(name="Decimal", is_backbone_element=False),
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="Decimal", is_backbone_element=False),
                ),
                FhirCqlType(name="String", is_backbone_element=False),
            ],
        ),
        "amountRatioLowLimit": FhirCqlType(name="Ratio", is_backbone_element=True),
        "amountType": FhirCqlType(name="Concept", is_backbone_element=False),
        "source": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
    },
    "SubstanceSpecification_Representation": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "representation": FhirCqlType(name="String", is_backbone_element=False),
        "attachment": FhirCqlType(name="Attachment", is_backbone_element=True),
    },
    "SubstanceSpecification_Structure": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "stereochemistry": FhirCqlType(name="Concept", is_backbone_element=False),
        "opticalActivity": FhirCqlType(name="Concept", is_backbone_element=False),
        "molecularFormula": FhirCqlType(name="String", is_backbone_element=False),
        "molecularFormulaByMoiety": FhirCqlType(
            name="String", is_backbone_element=False
        ),
        "isotope": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="SubstanceSpecification_Isotope", is_backbone_element=True
            ),
        ),
        "molecularWeight": FhirCqlType(
            name="SubstanceSpecification_MolecularWeight", is_backbone_element=True
        ),
        "source": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
        "representation": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="SubstanceSpecification_Representation", is_backbone_element=True
            ),
        ),
    },
    "Substance_Ingredient": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "quantity": FhirCqlType(name="Ratio", is_backbone_element=True),
        "substance": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Concept", is_backbone_element=False),
                FhirCqlType(name="Reference", is_backbone_element=True),
            ],
        ),
    },
    "Substance_Instance": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "identifier": FhirCqlType(name="Identifier", is_backbone_element=True),
        "expiry": FhirCqlType(name="DateTime", is_backbone_element=False),
        "quantity": FhirCqlType(name="Decimal", is_backbone_element=False),
    },
    "SupplyDelivery_SuppliedItem": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "quantity": FhirCqlType(name="Decimal", is_backbone_element=False),
        "item": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Concept", is_backbone_element=False),
                FhirCqlType(name="Reference", is_backbone_element=True),
            ],
        ),
    },
    "SupplyRequest_Parameter": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "code": FhirCqlType(name="Concept", is_backbone_element=False),
        "value": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Decimal", is_backbone_element=False),
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="Decimal", is_backbone_element=False),
                ),
                FhirCqlType(name="Concept", is_backbone_element=False),
                FhirCqlType(name="Boolean", is_backbone_element=False),
            ],
        ),
    },
    "Task_Input": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "value": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Distance", is_backbone_element=True),
                FhirCqlType(name="Signature", is_backbone_element=True),
                FhirCqlType(name="Annotation", is_backbone_element=True),
                FhirCqlType(name="Concept", is_backbone_element=False),
                FhirCqlType(name="Age", is_backbone_element=True),
                FhirCqlType(name="HumanName", is_backbone_element=True),
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
                ),
                FhirCqlType(name="SampledData", is_backbone_element=True),
                FhirCqlType(name="Timing", is_backbone_element=True),
                FhirCqlType(name="DateTime", is_backbone_element=False),
                FhirCqlType(name="ContactDetail", is_backbone_element=True),
                FhirCqlType(name="TriggerDefinition", is_backbone_element=True),
                FhirCqlType(name="UsageContext", is_backbone_element=True),
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="Decimal", is_backbone_element=False),
                ),
                FhirCqlType(name="Meta", is_backbone_element=True),
                FhirCqlType(name="Reference", is_backbone_element=True),
                FhirCqlType(name="Date", is_backbone_element=False),
                FhirCqlType(name="Ratio", is_backbone_element=True),
                FhirCqlType(name="Decimal", is_backbone_element=False),
                FhirCqlType(name="Expression", is_backbone_element=True),
                FhirCqlType(name="ParameterDefinition", is_backbone_element=True),
                FhirCqlType(name="Identifier", is_backbone_element=True),
                FhirCqlType(name="RelatedArtifact", is_backbone_element=True),
                FhirCqlType(name="DataRequirement", is_backbone_element=True),
                FhirCqlType(name="Dosage", is_backbone_element=True),
                FhirCqlType(name="Count", is_backbone_element=True),
                FhirCqlType(name="Duration", is_backbone_element=True),
                FhirCqlType(name="ContactPoint", is_backbone_element=True),
                FhirCqlType(name="Money", is_backbone_element=True),
                FhirCqlType(name="Attachment", is_backbone_element=True),
                FhirCqlType(name="String", is_backbone_element=False),
                FhirCqlType(name="Contributor", is_backbone_element=True),
                FhirCqlType(name="Boolean", is_backbone_element=False),
                FhirCqlType(name="Code", is_backbone_element=False),
                FhirCqlType(name="Address", is_backbone_element=True),
            ],
        ),
    },
    "Task_Output": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "type": FhirCqlType(name="Concept", is_backbone_element=False),
        "value": FhirChoice(
            name="Choice",
            is_backbone_element=False,
            choices=[
                FhirCqlType(name="Distance", is_backbone_element=True),
                FhirCqlType(name="Signature", is_backbone_element=True),
                FhirCqlType(name="Annotation", is_backbone_element=True),
                FhirCqlType(name="Concept", is_backbone_element=False),
                FhirCqlType(name="Age", is_backbone_element=True),
                FhirCqlType(name="HumanName", is_backbone_element=True),
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
                ),
                FhirCqlType(name="SampledData", is_backbone_element=True),
                FhirCqlType(name="Timing", is_backbone_element=True),
                FhirCqlType(name="DateTime", is_backbone_element=False),
                FhirCqlType(name="ContactDetail", is_backbone_element=True),
                FhirCqlType(name="TriggerDefinition", is_backbone_element=True),
                FhirCqlType(name="UsageContext", is_backbone_element=True),
                FhirInterval(
                    name="Interval",
                    is_backbone_element=False,
                    item_type=FhirCqlType(name="Decimal", is_backbone_element=False),
                ),
                FhirCqlType(name="Meta", is_backbone_element=True),
                FhirCqlType(name="Reference", is_backbone_element=True),
                FhirCqlType(name="Date", is_backbone_element=False),
                FhirCqlType(name="Ratio", is_backbone_element=True),
                FhirCqlType(name="Decimal", is_backbone_element=False),
                FhirCqlType(name="Expression", is_backbone_element=True),
                FhirCqlType(name="ParameterDefinition", is_backbone_element=True),
                FhirCqlType(name="Identifier", is_backbone_element=True),
                FhirCqlType(name="RelatedArtifact", is_backbone_element=True),
                FhirCqlType(name="DataRequirement", is_backbone_element=True),
                FhirCqlType(name="Dosage", is_backbone_element=True),
                FhirCqlType(name="Count", is_backbone_element=True),
                FhirCqlType(name="Duration", is_backbone_element=True),
                FhirCqlType(name="ContactPoint", is_backbone_element=True),
                FhirCqlType(name="Money", is_backbone_element=True),
                FhirCqlType(name="Attachment", is_backbone_element=True),
                FhirCqlType(name="String", is_backbone_element=False),
                FhirCqlType(name="Contributor", is_backbone_element=True),
                FhirCqlType(name="Boolean", is_backbone_element=False),
                FhirCqlType(name="Code", is_backbone_element=False),
                FhirCqlType(name="Address", is_backbone_element=True),
            ],
        ),
    },
    "Task_Restriction": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "repetitions": FhirCqlType(name="String", is_backbone_element=False),
        "period": FhirInterval(
            name="Interval",
            is_backbone_element=False,
            item_type=FhirCqlType(name="DateTime", is_backbone_element=False),
        ),
        "recipient": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Reference", is_backbone_element=True),
        ),
    },
    "TerminologyCapabilities_Closure": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "translation": FhirCqlType(name="Boolean", is_backbone_element=False),
    },
    "TerminologyCapabilities_CodeSystem": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "uri": FhirCqlType(name="String", is_backbone_element=False),
        "version": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="TerminologyCapabilities_Version", is_backbone_element=True
            ),
        ),
        "subsumption": FhirCqlType(name="Boolean", is_backbone_element=False),
    },
    "TerminologyCapabilities_Expansion": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "hierarchical": FhirCqlType(name="Boolean", is_backbone_element=False),
        "paging": FhirCqlType(name="Boolean", is_backbone_element=False),
        "incomplete": FhirCqlType(name="Boolean", is_backbone_element=False),
        "parameter": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="TerminologyCapabilities_Parameter", is_backbone_element=True
            ),
        ),
        "textFilter": FhirCqlType(name="String", is_backbone_element=False),
    },
    "TerminologyCapabilities_Filter": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "code": FhirCqlType(name="Code", is_backbone_element=False),
        "op": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Code", is_backbone_element=False),
        ),
    },
    "TerminologyCapabilities_Implementation": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "url": FhirCqlType(name="String", is_backbone_element=False),
    },
    "TerminologyCapabilities_Parameter": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "name": FhirCqlType(name="Code", is_backbone_element=False),
        "documentation": FhirCqlType(name="String", is_backbone_element=False),
    },
    "TerminologyCapabilities_Software": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "name": FhirCqlType(name="String", is_backbone_element=False),
        "version": FhirCqlType(name="String", is_backbone_element=False),
    },
    "TerminologyCapabilities_Translation": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "needsMap": FhirCqlType(name="Boolean", is_backbone_element=False),
    },
    "TerminologyCapabilities_ValidateCode": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "translations": FhirCqlType(name="Boolean", is_backbone_element=False),
    },
    "TerminologyCapabilities_Version": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "code": FhirCqlType(name="String", is_backbone_element=False),
        "isDefault": FhirCqlType(name="Boolean", is_backbone_element=False),
        "compositional": FhirCqlType(name="Boolean", is_backbone_element=False),
        "language": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Code", is_backbone_element=False),
        ),
        "filter": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="TerminologyCapabilities_Filter", is_backbone_element=True
            ),
        ),
        "property": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Code", is_backbone_element=False),
        ),
    },
    "TestReport_Action": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "operation": FhirCqlType(name="TestReport_Operation", is_backbone_element=True),
        "assert": FhirCqlType(name="TestReport_Assert", is_backbone_element=True),
    },
    "TestReport_Action1": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "operation": FhirCqlType(name="TestReport_Operation", is_backbone_element=True),
        "assert": FhirCqlType(name="TestReport_Assert", is_backbone_element=True),
    },
    "TestReport_Action2": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "operation": FhirCqlType(name="TestReport_Operation", is_backbone_element=True),
    },
    "TestReport_Assert": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "result": FhirCqlType(name="String", is_backbone_element=False),
        "message": FhirCqlType(name="String", is_backbone_element=False),
        "detail": FhirCqlType(name="String", is_backbone_element=False),
    },
    "TestReport_Operation": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "result": FhirCqlType(name="String", is_backbone_element=False),
        "message": FhirCqlType(name="String", is_backbone_element=False),
        "detail": FhirCqlType(name="String", is_backbone_element=False),
    },
    "TestReport_Participant": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "type": FhirCqlType(name="String", is_backbone_element=False),
        "uri": FhirCqlType(name="String", is_backbone_element=False),
        "display": FhirCqlType(name="String", is_backbone_element=False),
    },
    "TestReport_Setup": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "action": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="TestReport_Action", is_backbone_element=True),
        ),
    },
    "TestReport_Teardown": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "action": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="TestReport_Action2", is_backbone_element=True),
        ),
    },
    "TestReport_Test": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "name": FhirCqlType(name="String", is_backbone_element=False),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "action": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="TestReport_Action1", is_backbone_element=True),
        ),
    },
    "TestScript_Action": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "operation": FhirCqlType(name="TestScript_Operation", is_backbone_element=True),
        "assert": FhirCqlType(name="TestScript_Assert", is_backbone_element=True),
    },
    "TestScript_Action1": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "operation": FhirCqlType(name="TestScript_Operation", is_backbone_element=True),
        "assert": FhirCqlType(name="TestScript_Assert", is_backbone_element=True),
    },
    "TestScript_Action2": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "operation": FhirCqlType(name="TestScript_Operation", is_backbone_element=True),
    },
    "TestScript_Assert": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "label": FhirCqlType(name="String", is_backbone_element=False),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "direction": FhirCqlType(name="String", is_backbone_element=False),
        "compareToSourceId": FhirCqlType(name="String", is_backbone_element=False),
        "compareToSourceExpression": FhirCqlType(
            name="String", is_backbone_element=False
        ),
        "compareToSourcePath": FhirCqlType(name="String", is_backbone_element=False),
        "contentType": FhirCqlType(name="Code", is_backbone_element=False),
        "expression": FhirCqlType(name="String", is_backbone_element=False),
        "headerField": FhirCqlType(name="String", is_backbone_element=False),
        "minimumId": FhirCqlType(name="String", is_backbone_element=False),
        "navigationLinks": FhirCqlType(name="Boolean", is_backbone_element=False),
        "operator": FhirCqlType(name="String", is_backbone_element=False),
        "path": FhirCqlType(name="String", is_backbone_element=False),
        "requestMethod": FhirCqlType(name="String", is_backbone_element=False),
        "requestURL": FhirCqlType(name="String", is_backbone_element=False),
        "resource": FhirCqlType(name="Code", is_backbone_element=False),
        "response": FhirCqlType(name="String", is_backbone_element=False),
        "responseCode": FhirCqlType(name="String", is_backbone_element=False),
        "sourceId": FhirCqlType(name="String", is_backbone_element=False),
        "validateProfileId": FhirCqlType(name="String", is_backbone_element=False),
        "value": FhirCqlType(name="String", is_backbone_element=False),
        "warningOnly": FhirCqlType(name="Boolean", is_backbone_element=False),
    },
    "TestScript_Capability": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "required": FhirCqlType(name="Boolean", is_backbone_element=False),
        "validated": FhirCqlType(name="Boolean", is_backbone_element=False),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "origin": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Integer", is_backbone_element=False),
        ),
        "destination": FhirCqlType(name="Integer", is_backbone_element=False),
        "link": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="String", is_backbone_element=False),
        ),
        "capabilities": FhirCqlType(name="String", is_backbone_element=False),
    },
    "TestScript_Destination": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "index": FhirCqlType(name="Integer", is_backbone_element=False),
        "profile": FhirCqlType(name="Code", is_backbone_element=False),
    },
    "TestScript_Fixture": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "autocreate": FhirCqlType(name="Boolean", is_backbone_element=False),
        "autodelete": FhirCqlType(name="Boolean", is_backbone_element=False),
        "resource": FhirCqlType(name="Reference", is_backbone_element=True),
    },
    "TestScript_Link": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "url": FhirCqlType(name="String", is_backbone_element=False),
        "description": FhirCqlType(name="String", is_backbone_element=False),
    },
    "TestScript_Metadata": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "link": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="TestScript_Link", is_backbone_element=True),
        ),
        "capability": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                name="TestScript_Capability", is_backbone_element=True
            ),
        ),
    },
    "TestScript_Operation": {
        "id": FhirCqlType(name="String", is_backbone_element=False),
        "extension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "modifierExtension": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(name="Extension", is_backbone_element=True),
        ),
        "type": FhirCqlType(name="Code", is_backbone_element=False),
        "resource": FhirCqlType(name="Code", is_backbone_element=False),
        "label": FhirCqlType(name="String", is_backbone_element=False),
        "description": FhirCqlType(name="String", is_backbone_element=False),
        "accept": FhirCqlType(name="Code", is_backbone_element=False),
        "contentType": FhirCqlType(name="Code", is_backbone_element=False),
        "destination": FhirCqlType(name="Integer", is_backbone_element=False),
        "encodeRequestUrl": FhirCqlType(name="Boolean", is_backbone_element=False),
        "method": FhirCqlType(name="String", is_backbone_element=False),
        "origin": FhirCqlType(name="Integer", is_backbone_element=False),
        "params": FhirCqlType(name="String", is_backbone_element=False),
        "requestHeader": FhirList(
            name="List",
            is_backbone_element=False,
            item_type=FhirCqlType(
                nam