﻿## What is PyCaret?
PyCaret is an open source, `low-code` machine learning library in Python that aims to reduce the cycle time from hypothesis to insights. It enables data scientists and analysts to perform iterative end-to-end data science experiments efficiently and allows them to reach conclusions faster due to far less time spent in coding. PyCaret is essentially a Python wrapper around several machine learning libraries and frameworks such as scikit-learn, XGBoost, Microsoft LightGBM, spaCy and many more.

In comparison with the other open source machine learning libraries, PyCaret is an alternate `low-code` machine learning solution that allows data scientists to perform end-to-end iterative experiments and enhances their ability to perform simple to complex operations without the need to write and maintain extra lines of code.

PyCaret is `simple`, `easy to use` and `deployment ready`. All of the operations performed in a typical experiment are executed and automatically stored in a custom pipeline which is completely orchestrated to manage dependencies. The `Pipeline` can be saved in a binary format that can be transferred into a different environment to perform experiments at scale.

The design and simplicity of PyCaret is inspired by the emerging role of citizen data scientists, a term first used by Gartner. Citizen Data Scientists are `power users` who can perform both simple and moderately sophisticated analytical tasks that would previously have required more expertise. The skills of a seasoned data scientists are often expensive and difficult to come by but citizen data scientists can be an effective way to mitigate this current skills gap and address data related challenges.

For more information on PyCaret, please visit our official website https://www.pycaret.org

## Current Release
The first stable release pycaret version `1.0.0` is now publicly available. The easiest way to install pycaret is using pip.

```python
pip install pycaret
```

## Important Links
- User Guide / Documentation: https://www.pycaret.org/guide
- Getting Started Tutorials: https://www.pycaret.org/tutorial
- Issue Logs: https://github.com/pycaret/pycaret/issues

## Who should use PyCaret?
PyCaret is an open source library that anybody can use. In our view the ideal target audience of PyCaret is: <br />

- Experienced Data Scientists who want to increase productivity.
- Citizen Data Scientists who prefer a low code machine learning solution.
- Students of Data Science.
- Data Science Professionals and Consultants involved in building Proof of Concept projects.

## Dependencies
Please read requirements.txt for list of requirements. They are automatically installed when pycaret is installed using pip.

## Contribute
If you would like to contribute to PyCaret, please visit https://www.pycaret.org/contribute

## Contributors
- pycaret.anomaly, Moez Ali <moez.ali@queensu.ca>
- pycaret.classification, Moez Ali <moez.ali@queensu.ca>
- pycaret.clustering, Moez Ali <moez.ali@queensu.ca>
- pycaret.datasets, Moez Ali <moez.ali@queensu.ca>
- pycaret.nlp, Moez Ali <moez.ali@queensu.ca>
- pycaret.preprocess, Fahad Akbar <M.akbar@queensu.ca>
- pycaret.regression, Moez Ali <moez.ali@queensu.ca>

## License

Copyright 2019-2020 Moez Ali <moez.ali@queensu.ca>

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
© 2020 GitHub, Inc.