from __future__ import annotations

from textwrap import dedent

import pandas as pd
from pandas.util._decorators import doc

from dtoolkit.accessor.register import register_series_method


@register_series_method
@doc(
    returns=dedent(
        """
    Returns
    -------
    str or None
        The name of the Series.
    """,
    ),
)
def cols(s: pd.Series) -> str | None:
    """
    An API to gather :attr:`~pandas.Series.name` and
    :attr:`~pandas.DataFrame.columns` to one.
    {returns}
    See Also
    --------
    pandas.Series.name
    pandas.DataFrame.columns
    dtoolkit.accessor.series.cols
    dtoolkit.accessor.dataframe.cols

    Examples
    --------
    >>> import dtoolkit.accessor
    >>> import pandas as pd

    Get :attr:`~pandas.Series.name`.

    >>> s = pd.Series(range(10), name="item")
    >>> s.cols()
    'item'

    Get :attr:`~pandas.DataFrame.columns`.

    >>> d = pd.DataFrame({{"a": [1, 2], "b": [3, 4]}})
    >>> d.cols()
    ['a', 'b']
    """

    return s.name
