"""DO NOT EDIT THIS FILE!

This file is auto generated by github rest api description.
See https://github.com/github/rest-api-description for more information.
"""


from typing import TYPE_CHECKING, List, Union, Literal, overload

from pydantic import BaseModel, parse_obj_as

from githubkit.utils import UNSET, Unset, exclude_unset

from .types import (
    UserMigrationsPostBodyType,
    OrgsOrgMigrationsPostBodyType,
    ReposOwnerRepoImportPutBodyType,
    ReposOwnerRepoImportPatchBodyType,
    ReposOwnerRepoImportLfsPatchBodyType,
    ReposOwnerRepoImportAuthorsAuthorIdPatchBodyType,
)
from .models import (
    Import,
    Migration,
    BasicError,
    PorterAuthor,
    PorterLargeFile,
    ValidationError,
    MinimalRepository,
    UserMigrationsPostBody,
    OrgsOrgMigrationsPostBody,
    ReposOwnerRepoImportPutBody,
    ReposOwnerRepoImportPatchBody,
    ReposOwnerRepoImportLfsPatchBody,
    ReposOwnerRepoImportAuthorsAuthorIdPatchBody,
)

if TYPE_CHECKING:
    from githubkit import GitHubCore
    from githubkit.response import Response


class MigrationsClient:
    def __init__(self, github: "GitHubCore"):
        self._github = github

    def list_for_org(
        self,
        org: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
        exclude: Union[Unset, List[Literal["repositories"]]] = UNSET,
    ) -> "Response[List[Migration]]":
        url = f"/orgs/{org}/migrations"

        params = {
            "per_page": per_page,
            "page": page,
            "exclude": exclude,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Migration],
        )

    async def async_list_for_org(
        self,
        org: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
        exclude: Union[Unset, List[Literal["repositories"]]] = UNSET,
    ) -> "Response[List[Migration]]":
        url = f"/orgs/{org}/migrations"

        params = {
            "per_page": per_page,
            "page": page,
            "exclude": exclude,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Migration],
        )

    @overload
    def start_for_org(
        self, org: str, *, data: OrgsOrgMigrationsPostBodyType
    ) -> "Response[Migration]":
        ...

    @overload
    def start_for_org(
        self,
        org: str,
        *,
        data: Unset = UNSET,
        repositories: List[str],
        lock_repositories: Union[Unset, bool] = False,
        exclude_metadata: Union[Unset, bool] = False,
        exclude_git_data: Union[Unset, bool] = False,
        exclude_attachments: Union[Unset, bool] = False,
        exclude_releases: Union[Unset, bool] = False,
        exclude_owner_projects: Union[Unset, bool] = False,
        org_metadata_only: Union[Unset, bool] = False,
        exclude: Union[Unset, List[Literal["repositories"]]] = UNSET,
    ) -> "Response[Migration]":
        ...

    def start_for_org(
        self,
        org: str,
        *,
        data: Union[Unset, OrgsOrgMigrationsPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Migration]":
        url = f"/orgs/{org}/migrations"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgMigrationsPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Migration,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_start_for_org(
        self, org: str, *, data: OrgsOrgMigrationsPostBodyType
    ) -> "Response[Migration]":
        ...

    @overload
    async def async_start_for_org(
        self,
        org: str,
        *,
        data: Unset = UNSET,
        repositories: List[str],
        lock_repositories: Union[Unset, bool] = False,
        exclude_metadata: Union[Unset, bool] = False,
        exclude_git_data: Union[Unset, bool] = False,
        exclude_attachments: Union[Unset, bool] = False,
        exclude_releases: Union[Unset, bool] = False,
        exclude_owner_projects: Union[Unset, bool] = False,
        org_metadata_only: Union[Unset, bool] = False,
        exclude: Union[Unset, List[Literal["repositories"]]] = UNSET,
    ) -> "Response[Migration]":
        ...

    async def async_start_for_org(
        self,
        org: str,
        *,
        data: Union[Unset, OrgsOrgMigrationsPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Migration]":
        url = f"/orgs/{org}/migrations"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgMigrationsPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Migration,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def get_status_for_org(
        self,
        org: str,
        migration_id: int,
        exclude: Union[Unset, List[Literal["repositories"]]] = UNSET,
    ) -> "Response[Migration]":
        url = f"/orgs/{org}/migrations/{migration_id}"

        params = {
            "exclude": exclude,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=Migration,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_status_for_org(
        self,
        org: str,
        migration_id: int,
        exclude: Union[Unset, List[Literal["repositories"]]] = UNSET,
    ) -> "Response[Migration]":
        url = f"/orgs/{org}/migrations/{migration_id}"

        params = {
            "exclude": exclude,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=Migration,
            error_models={
                "404": BasicError,
            },
        )

    def download_archive_for_org(
        self,
        org: str,
        migration_id: int,
    ) -> "Response":
        url = f"/orgs/{org}/migrations/{migration_id}/archive"

        return self._github.request(
            "GET",
            url,
            error_models={
                "404": BasicError,
            },
        )

    async def async_download_archive_for_org(
        self,
        org: str,
        migration_id: int,
    ) -> "Response":
        url = f"/orgs/{org}/migrations/{migration_id}/archive"

        return await self._github.arequest(
            "GET",
            url,
            error_models={
                "404": BasicError,
            },
        )

    def delete_archive_for_org(
        self,
        org: str,
        migration_id: int,
    ) -> "Response":
        url = f"/orgs/{org}/migrations/{migration_id}/archive"

        return self._github.request(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
            },
        )

    async def async_delete_archive_for_org(
        self,
        org: str,
        migration_id: int,
    ) -> "Response":
        url = f"/orgs/{org}/migrations/{migration_id}/archive"

        return await self._github.arequest(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
            },
        )

    def unlock_repo_for_org(
        self,
        org: str,
        migration_id: int,
        repo_name: str,
    ) -> "Response":
        url = f"/orgs/{org}/migrations/{migration_id}/repos/{repo_name}/lock"

        return self._github.request(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
            },
        )

    async def async_unlock_repo_for_org(
        self,
        org: str,
        migration_id: int,
        repo_name: str,
    ) -> "Response":
        url = f"/orgs/{org}/migrations/{migration_id}/repos/{repo_name}/lock"

        return await self._github.arequest(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
            },
        )

    def list_repos_for_org(
        self,
        org: str,
        migration_id: int,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[MinimalRepository]]":
        url = f"/orgs/{org}/migrations/{migration_id}/repositories"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[MinimalRepository],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_repos_for_org(
        self,
        org: str,
        migration_id: int,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[MinimalRepository]]":
        url = f"/orgs/{org}/migrations/{migration_id}/repositories"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[MinimalRepository],
            error_models={
                "404": BasicError,
            },
        )

    def get_import_status(
        self,
        owner: str,
        repo: str,
    ) -> "Response[Import]":
        url = f"/repos/{owner}/{repo}/import"

        return self._github.request(
            "GET",
            url,
            response_model=Import,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_import_status(
        self,
        owner: str,
        repo: str,
    ) -> "Response[Import]":
        url = f"/repos/{owner}/{repo}/import"

        return await self._github.arequest(
            "GET",
            url,
            response_model=Import,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def start_import(
        self, owner: str, repo: str, *, data: ReposOwnerRepoImportPutBodyType
    ) -> "Response[Import]":
        ...

    @overload
    def start_import(
        self,
        owner: str,
        repo: str,
        *,
        data: Unset = UNSET,
        vcs_url: str,
        vcs: Union[Unset, Literal["subversion", "git", "mercurial", "tfvc"]] = UNSET,
        vcs_username: Union[Unset, str] = UNSET,
        vcs_password: Union[Unset, str] = UNSET,
        tfvc_project: Union[Unset, str] = UNSET,
    ) -> "Response[Import]":
        ...

    def start_import(
        self,
        owner: str,
        repo: str,
        *,
        data: Union[Unset, ReposOwnerRepoImportPutBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Import]":
        url = f"/repos/{owner}/{repo}/import"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoImportPutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=Import,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    @overload
    async def async_start_import(
        self, owner: str, repo: str, *, data: ReposOwnerRepoImportPutBodyType
    ) -> "Response[Import]":
        ...

    @overload
    async def async_start_import(
        self,
        owner: str,
        repo: str,
        *,
        data: Unset = UNSET,
        vcs_url: str,
        vcs: Union[Unset, Literal["subversion", "git", "mercurial", "tfvc"]] = UNSET,
        vcs_username: Union[Unset, str] = UNSET,
        vcs_password: Union[Unset, str] = UNSET,
        tfvc_project: Union[Unset, str] = UNSET,
    ) -> "Response[Import]":
        ...

    async def async_start_import(
        self,
        owner: str,
        repo: str,
        *,
        data: Union[Unset, ReposOwnerRepoImportPutBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Import]":
        url = f"/repos/{owner}/{repo}/import"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoImportPutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=Import,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    def cancel_import(
        self,
        owner: str,
        repo: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/import"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_cancel_import(
        self,
        owner: str,
        repo: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/import"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    @overload
    def update_import(
        self,
        owner: str,
        repo: str,
        *,
        data: Union[Unset, Union[ReposOwnerRepoImportPatchBodyType, None]] = UNSET,
    ) -> "Response[Import]":
        ...

    @overload
    def update_import(
        self,
        owner: str,
        repo: str,
        *,
        data: Unset = UNSET,
        vcs_username: Union[Unset, str] = UNSET,
        vcs_password: Union[Unset, str] = UNSET,
        vcs: Union[Unset, Literal["subversion", "tfvc", "git", "mercurial"]] = UNSET,
        tfvc_project: Union[Unset, str] = UNSET,
    ) -> "Response[Import]":
        ...

    def update_import(
        self,
        owner: str,
        repo: str,
        *,
        data: Union[Unset, Union[ReposOwnerRepoImportPatchBodyType, None]] = UNSET,
        **kwargs,
    ) -> "Response[Import]":
        url = f"/repos/{owner}/{repo}/import"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Union[ReposOwnerRepoImportPatchBody, None], json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=Import,
        )

    @overload
    async def async_update_import(
        self,
        owner: str,
        repo: str,
        *,
        data: Union[Unset, Union[ReposOwnerRepoImportPatchBodyType, None]] = UNSET,
    ) -> "Response[Import]":
        ...

    @overload
    async def async_update_import(
        self,
        owner: str,
        repo: str,
        *,
        data: Unset = UNSET,
        vcs_username: Union[Unset, str] = UNSET,
        vcs_password: Union[Unset, str] = UNSET,
        vcs: Union[Unset, Literal["subversion", "tfvc", "git", "mercurial"]] = UNSET,
        tfvc_project: Union[Unset, str] = UNSET,
    ) -> "Response[Import]":
        ...

    async def async_update_import(
        self,
        owner: str,
        repo: str,
        *,
        data: Union[Unset, Union[ReposOwnerRepoImportPatchBodyType, None]] = UNSET,
        **kwargs,
    ) -> "Response[Import]":
        url = f"/repos/{owner}/{repo}/import"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Union[ReposOwnerRepoImportPatchBody, None], json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=Import,
        )

    def get_commit_authors(
        self,
        owner: str,
        repo: str,
        since: Union[Unset, int] = UNSET,
    ) -> "Response[List[PorterAuthor]]":
        url = f"/repos/{owner}/{repo}/import/authors"

        params = {
            "since": since,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[PorterAuthor],
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_commit_authors(
        self,
        owner: str,
        repo: str,
        since: Union[Unset, int] = UNSET,
    ) -> "Response[List[PorterAuthor]]":
        url = f"/repos/{owner}/{repo}/import/authors"

        params = {
            "since": since,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[PorterAuthor],
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def map_commit_author(
        self,
        owner: str,
        repo: str,
        author_id: int,
        *,
        data: Union[Unset, ReposOwnerRepoImportAuthorsAuthorIdPatchBodyType] = UNSET,
    ) -> "Response[PorterAuthor]":
        ...

    @overload
    def map_commit_author(
        self,
        owner: str,
        repo: str,
        author_id: int,
        *,
        data: Unset = UNSET,
        email: Union[Unset, str] = UNSET,
        name: Union[Unset, str] = UNSET,
    ) -> "Response[PorterAuthor]":
        ...

    def map_commit_author(
        self,
        owner: str,
        repo: str,
        author_id: int,
        *,
        data: Union[Unset, ReposOwnerRepoImportAuthorsAuthorIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response[PorterAuthor]":
        url = f"/repos/{owner}/{repo}/import/authors/{author_id}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoImportAuthorsAuthorIdPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=PorterAuthor,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    @overload
    async def async_map_commit_author(
        self,
        owner: str,
        repo: str,
        author_id: int,
        *,
        data: Union[Unset, ReposOwnerRepoImportAuthorsAuthorIdPatchBodyType] = UNSET,
    ) -> "Response[PorterAuthor]":
        ...

    @overload
    async def async_map_commit_author(
        self,
        owner: str,
        repo: str,
        author_id: int,
        *,
        data: Unset = UNSET,
        email: Union[Unset, str] = UNSET,
        name: Union[Unset, str] = UNSET,
    ) -> "Response[PorterAuthor]":
        ...

    async def async_map_commit_author(
        self,
        owner: str,
        repo: str,
        author_id: int,
        *,
        data: Union[Unset, ReposOwnerRepoImportAuthorsAuthorIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response[PorterAuthor]":
        url = f"/repos/{owner}/{repo}/import/authors/{author_id}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoImportAuthorsAuthorIdPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=PorterAuthor,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    def get_large_files(
        self,
        owner: str,
        repo: str,
    ) -> "Response[List[PorterLargeFile]]":
        url = f"/repos/{owner}/{repo}/import/large_files"

        return self._github.request(
            "GET",
            url,
            response_model=List[PorterLargeFile],
        )

    async def async_get_large_files(
        self,
        owner: str,
        repo: str,
    ) -> "Response[List[PorterLargeFile]]":
        url = f"/repos/{owner}/{repo}/import/large_files"

        return await self._github.arequest(
            "GET",
            url,
            response_model=List[PorterLargeFile],
        )

    @overload
    def set_lfs_preference(
        self, owner: str, repo: str, *, data: ReposOwnerRepoImportLfsPatchBodyType
    ) -> "Response[Import]":
        ...

    @overload
    def set_lfs_preference(
        self,
        owner: str,
        repo: str,
        *,
        data: Unset = UNSET,
        use_lfs: Literal["opt_in", "opt_out"],
    ) -> "Response[Import]":
        ...

    def set_lfs_preference(
        self,
        owner: str,
        repo: str,
        *,
        data: Union[Unset, ReposOwnerRepoImportLfsPatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Import]":
        url = f"/repos/{owner}/{repo}/import/lfs"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoImportLfsPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=Import,
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_set_lfs_preference(
        self, owner: str, repo: str, *, data: ReposOwnerRepoImportLfsPatchBodyType
    ) -> "Response[Import]":
        ...

    @overload
    async def async_set_lfs_preference(
        self,
        owner: str,
        repo: str,
        *,
        data: Unset = UNSET,
        use_lfs: Literal["opt_in", "opt_out"],
    ) -> "Response[Import]":
        ...

    async def async_set_lfs_preference(
        self,
        owner: str,
        repo: str,
        *,
        data: Union[Unset, ReposOwnerRepoImportLfsPatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Import]":
        url = f"/repos/{owner}/{repo}/import/lfs"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoImportLfsPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=Import,
            error_models={
                "422": ValidationError,
            },
        )

    def list_for_authenticated_user(
        self,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Migration]]":
        url = "/user/migrations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Migration],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_for_authenticated_user(
        self,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Migration]]":
        url = "/user/migrations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Migration],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    def start_for_authenticated_user(
        self, *, data: UserMigrationsPostBodyType
    ) -> "Response[Migration]":
        ...

    @overload
    def start_for_authenticated_user(
        self,
        *,
        data: Unset = UNSET,
        lock_repositories: Union[Unset, bool] = UNSET,
        exclude_metadata: Union[Unset, bool] = UNSET,
        exclude_git_data: Union[Unset, bool] = UNSET,
        exclude_attachments: Union[Unset, bool] = UNSET,
        exclude_releases: Union[Unset, bool] = UNSET,
        exclude_owner_projects: Union[Unset, bool] = UNSET,
        org_metadata_only: Union[Unset, bool] = False,
        exclude: Union[Unset, List[Literal["repositories"]]] = UNSET,
        repositories: List[str],
    ) -> "Response[Migration]":
        ...

    def start_for_authenticated_user(
        self, *, data: Union[Unset, UserMigrationsPostBodyType] = UNSET, **kwargs
    ) -> "Response[Migration]":
        url = "/user/migrations"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(UserMigrationsPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Migration,
            error_models={
                "422": ValidationError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    async def async_start_for_authenticated_user(
        self, *, data: UserMigrationsPostBodyType
    ) -> "Response[Migration]":
        ...

    @overload
    async def async_start_for_authenticated_user(
        self,
        *,
        data: Unset = UNSET,
        lock_repositories: Union[Unset, bool] = UNSET,
        exclude_metadata: Union[Unset, bool] = UNSET,
        exclude_git_data: Union[Unset, bool] = UNSET,
        exclude_attachments: Union[Unset, bool] = UNSET,
        exclude_releases: Union[Unset, bool] = UNSET,
        exclude_owner_projects: Union[Unset, bool] = UNSET,
        org_metadata_only: Union[Unset, bool] = False,
        exclude: Union[Unset, List[Literal["repositories"]]] = UNSET,
        repositories: List[str],
    ) -> "Response[Migration]":
        ...

    async def async_start_for_authenticated_user(
        self, *, data: Union[Unset, UserMigrationsPostBodyType] = UNSET, **kwargs
    ) -> "Response[Migration]":
        url = "/user/migrations"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(UserMigrationsPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Migration,
            error_models={
                "422": ValidationError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def get_status_for_authenticated_user(
        self,
        migration_id: int,
        exclude: Union[Unset, List[str]] = UNSET,
    ) -> "Response[Migration]":
        url = f"/user/migrations/{migration_id}"

        params = {
            "exclude": exclude,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=Migration,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_get_status_for_authenticated_user(
        self,
        migration_id: int,
        exclude: Union[Unset, List[str]] = UNSET,
    ) -> "Response[Migration]":
        url = f"/user/migrations/{migration_id}"

        params = {
            "exclude": exclude,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=Migration,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def get_archive_for_authenticated_user(
        self,
        migration_id: int,
    ) -> "Response":
        url = f"/user/migrations/{migration_id}/archive"

        return self._github.request(
            "GET",
            url,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_get_archive_for_authenticated_user(
        self,
        migration_id: int,
    ) -> "Response":
        url = f"/user/migrations/{migration_id}/archive"

        return await self._github.arequest(
            "GET",
            url,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def delete_archive_for_authenticated_user(
        self,
        migration_id: int,
    ) -> "Response":
        url = f"/user/migrations/{migration_id}/archive"

        return self._github.request(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_delete_archive_for_authenticated_user(
        self,
        migration_id: int,
    ) -> "Response":
        url = f"/user/migrations/{migration_id}/archive"

        return await self._github.arequest(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def unlock_repo_for_authenticated_user(
        self,
        migration_id: int,
        repo_name: str,
    ) -> "Response":
        url = f"/user/migrations/{migration_id}/repos/{repo_name}/lock"

        return self._github.request(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_unlock_repo_for_authenticated_user(
        self,
        migration_id: int,
        repo_name: str,
    ) -> "Response":
        url = f"/user/migrations/{migration_id}/repos/{repo_name}/lock"

        return await self._github.arequest(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def list_repos_for_authenticated_user(
        self,
        migration_id: int,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[MinimalRepository]]":
        url = f"/user/migrations/{migration_id}/repositories"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[MinimalRepository],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_repos_for_authenticated_user(
        self,
        migration_id: int,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[MinimalRepository]]":
        url = f"/user/migrations/{migration_id}/repositories"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[MinimalRepository],
            error_models={
                "404": BasicError,
            },
        )
