"""
Dictionary containing all known space groups written as :class:`Group`
along with alternative axis settings. The point groups in this dictionary
can be accessed using their short Hermann-Maugin notation, as presented below.
To access origin choice 1 or 2, append key with "#1" or "2", eg.: SG["Fd-3c#2"].

+-----+--------------+----------------+--------------------+-------------------+
| No. | CRYSTAL      | Hermann-Maugin | Additional notes   | Can be accessed   |
|     | SYSTEM       | short notation |                    | using             |
+-----+--------------+----------------+--------------------+-------------------+
| 1   | triclinic    | P1             |                    | `SG['P1']`        |
+-----+              +----------------+--------------------+-------------------+
| 2   |              | P-1            |                    | `SG['P-1']`       |
+-----+--------------+----------------+--------------------+-------------------+
| 3   | monoclinic   | P2             | unique axis b      | `SG['P2']`        |
+-----+              +----------------+--------------------+-------------------+
| 4   |              | P21            | unique axis b      | `SG['P21']`       |
+-----+              +----------------+--------------------+-------------------+
| 5   |              | C2             | unique axis b      | `SG['C2']`        |
+-----+              +----------------+--------------------+-------------------+
| 6   |              | Pm             | unique axis b      | `SG['Pm']`        |
+-----+              +----------------+--------------------+-------------------+
| 7   |              | Pc             | unique axis b      | `SG['Pc']`        |
+-----+              +----------------+--------------------+-------------------+
| 8   |              | Cm             | unique axis b      | `SG['Cm']`        |
+-----+              +----------------+--------------------+-------------------+
| 9   |              | Cc             | unique axis b      | `SG['Cc']`        |
+-----+              +----------------+--------------------+-------------------+
| 10  |              | P2/m           | unique axis b      | `SG['P2/m']`      |
+-----+              +----------------+--------------------+-------------------+
| 11  |              | P21/m          | unique axis b      | `SG['P21/m']`     |
+-----+              +----------------+--------------------+-------------------+
| 12  |              | C2/m           | unique axis b      | `SG['C2/m']`      |
+-----+              +----------------+--------------------+-------------------+
| 13  |              | P2/c           | unique axis b      | `SG['P2/c']`      |
+-----+              +----------------+--------------------+-------------------+
|     |              | P21/c          | unique axis b      | `SG['P21/c']`     |
| 14  |              +----------------+--------------------+-------------------+
|     |              | P1121/a        | z,x,y: c-unique    | `SG['P1121/a']`   |
+-----+              +----------------+--------------------+-------------------+
| 15  |              | C2/c           | unique axis b      | `SG['C2/c']`      | 
+-----+--------------+----------------+--------------------+-------------------+
| 16  | orthorhombic | P222           |                    | `SG['P222']`      |
+-----+              +----------------+--------------------+-------------------+
| 17  |              | P2221          |                    | `SG['P2221']`     |
+-----+              +----------------+--------------------+-------------------+
| 18  |              | P21212         |                    | `SG['P21212']`    |
+-----+              +----------------+--------------------+-------------------+
| 19  |              | P212121        |                    | `SG['P212121']`   |
+-----+              +----------------+--------------------+-------------------+
| 20  |              | C2221          |                    | `SG['C2221']`     |
+-----+              +----------------+--------------------+-------------------+
| 21  |              | C222           |                    | `SG['C222']`      |
+-----+              +----------------+--------------------+-------------------+
| 22  |              | F222           |                    | `SG['F222']`      |
+-----+              +----------------+--------------------+-------------------+
| 23  |              | I222           |                    | `SG['I222']`      |
+-----+              +----------------+--------------------+-------------------+
| 24  |              | I212121        |                    | `SG['I212121']`   |
+-----+              +----------------+--------------------+-------------------+
| 25  |              | Pmm2           |                    | `SG['Pmm2']`      |
+-----+              +----------------+--------------------+-------------------+
| 26  |              | Pmc21          |                    | `SG['Pmc21']`     |
+-----+              +----------------+--------------------+-------------------+
| 27  |              | Pcc2           |                    | `SG['Pcc2']`      |
+-----+              +----------------+--------------------+-------------------+
| 28  |              | Pma2           |                    | `SG['Pma2']`      |
+-----+              +----------------+--------------------+-------------------+
| 29  |              | Pca21          |                    | `SG['Pca21']`     |
+-----+              +----------------+--------------------+-------------------+
| 30  |              | Pnc2           |                    | `SG['Pnc2']`      |
+-----+              +----------------+--------------------+-------------------+
| 31  |              | Pmn21          |                    | `SG['Pmn21']`     |
+-----+              +----------------+--------------------+-------------------+
| 32  |              | Pba2           |                    | `SG['Pba2']`      |
+-----+              +----------------+--------------------+-------------------+
|     |              | Pna21          |                    | `SG['Pna21']`     |
| 33  |              +----------------+--------------------+-------------------+
|     |              | Pn21a          | x,z,-y orientation | `SG['Pn21a']`     |
+-----+              +----------------+--------------------+-------------------+
| 34  |              | Pnn2           |                    | `SG['Pnn2']`      |
+-----+              +----------------+--------------------+-------------------+
| 35  |              | Cmm2           |                    | `SG['Cmm2']`      |
+-----+              +----------------+--------------------+-------------------+
| 36  |              | Cmc21          |                    | `SG['Cmc21']`     |
+-----+              +----------------+--------------------+-------------------+
| 37  |              | Ccc2           |                    | `SG['Ccc2']`      |
+-----+              +----------------+--------------------+-------------------+
| 38  |              | Amm2           |                    | `SG['Amm2']`      |
+-----+              +----------------+--------------------+-------------------+
| 39  |              | Aem2           |                    | `SG['Aem2']`      |
+-----+              +----------------+--------------------+-------------------+
| 40  |              | Ama2           |                    | `SG['Ama2']`      |
+-----+              +----------------+--------------------+-------------------+
| 41  |              | Aea2           |                    | `SG['Aea2']`      |
+-----+              +----------------+--------------------+-------------------+
| 42  |              | Fmm2           |                    | `SG['Fmm2']`      |
+-----+              +----------------+--------------------+-------------------+
| 43  |              | Fdd2           |                    | `SG['Fdd2']`      |
+-----+              +----------------+--------------------+-------------------+
| 44  |              | Imm2           |                    | `SG['Imm2']`      |
+-----+              +----------------+--------------------+-------------------+
| 45  |              | Iba2           |                    | `SG['Iba2']`      |
+-----+              +----------------+--------------------+-------------------+
| 46  |              | Ima2           |                    | `SG['Ima2']`      |
+-----+              +----------------+--------------------+-------------------+
| 47  |              | Pmmm           |                    | `SG['Pmmm']`      |
+-----+              +----------------+--------------------+-------------------+
|     |              |                | origin at 222      | `SG['Pnnn']`      |
| 48  |              | Pnnn           +--------------------+-------------------+
|     |              |                | origin at -1       | `SG['Pnnn#2']`    |
+-----+              +----------------+--------------------+-------------------+
| 49  |              | Pccm           |                    | `SG['Pccm']`      |
+-----+              +----------------+--------------------+-------------------+
|     |              |                | origin at 222/n    | `SG['Pban']`      |
| 50  |              + Pban           +--------------------+-------------------+
|     |              |                | origin at -1       | `SG['Pban#2']`    |
+-----+              +----------------+--------------------+-------------------+
| 51  |              | Pmma           |                    | `SG['Pmma']`      |
+-----+              +----------------+--------------------+-------------------+
| 52  |              | Pnna           |                    | `SG['Pnna']`      |
+-----+              +----------------+--------------------+-------------------+
| 53  |              | Pmna           |                    | `SG['Pmna']`      |
+-----+              +----------------+--------------------+-------------------+
| 54  |              | Pcca           |                    | `SG['Pcca']`      |
+-----+              +----------------+--------------------+-------------------+
| 55  |              | Pbam           |                    | `SG['Pbam']`      |
+-----+              +----------------+--------------------+-------------------+
| 56  |              | Pccn           |                    | `SG['Pccn']`      |
+-----+              +----------------+--------------------+-------------------+
| 57  |              | Pbcm           |                    | `SG['Pbcm']`      |
+-----+              +----------------+--------------------+-------------------+
| 58  |              | Pnnm           |                    | `SG['Pnnm']`      |
+-----+              +----------------+--------------------+-------------------+
|     |              |                | origin at mm2/n    | `SG['Pmmn']`      |
| 59  |              | Pmmn           +--------------------+-------------------+
|     |              |                | origin at -1       | `SG['Pmmn#2']`    |
+-----+              +----------------+--------------------+-------------------+
| 60  |              | Pbcn           |                    | `SG['Pbcn']`      |
+-----+              +----------------+--------------------+-------------------+
| 61  |              | Pbca           |                    | `SG['Pbca']`      |
+-----+              +----------------+--------------------+-------------------+
| 62  |              | Pnma           |                    | `SG['Pnma']`      |
+-----+              +----------------+--------------------+-------------------+
| 63  |              | Cmcm           |                    | `SG['Cmcm']`      |
+-----+              +----------------+--------------------+-------------------+
| 64  |              | Cmca           |                    | `SG['Cmca']`      |
+-----+              +----------------+--------------------+-------------------+
| 65  |              | Cmmm           |                    | `SG['Cmmm']`      |
+-----+              +----------------+--------------------+-------------------+
| 66  |              | Cccm           |                    | `SG['Cccm']`      |
+-----+              +----------------+--------------------+-------------------+
| 67  |              | Cmme           |                    | `SG['Cmme']`      |
+-----+              +----------------+--------------------+-------------------+
|     |              |                | origin at 222      | `SG['Ccce']`      |
| 68  |              | Ccce           +--------------------+-------------------+
|     |              |                | origin at -1       | `SG['Ccce#2']`    |
+-----+              +----------------+--------------------+-------------------+
| 69  |              | Fmmm           |                    | `SG['Fmmm']`      |
+-----+              +----------------+--------------------+-------------------+
|     |              |                | origin at 222      | `SG['Fddd']`      |
| 70  |              | Fddd           +--------------------+-------------------+
|     |              |                | origin at -1       | `SG['Fddd#2']`    |
+-----+              +----------------+--------------------+-------------------+
| 71  |              | Immm           |                    | `SG['Immm']`      |
+-----+              +----------------+--------------------+-------------------+
| 72  |              | Ibam           |                    | `SG['Ibam']`      |
+-----+              +----------------+--------------------+-------------------+
| 73  |              | Ibca           |                    | `SG['Ibca']`      |
+-----+              +----------------+--------------------+-------------------+
| 74  |              | Imma           |                    | `SG['Imma']`      |
+-----+--------------+----------------+--------------------+-------------------+
| 75  | tetragonal   | P4             |                    | `SG['P4']`        |
+-----+              +----------------+--------------------+-------------------+
| 76  |              | P41            |                    | `SG['P41']`       |
+-----+              +----------------+--------------------+-------------------+
| 77  |              | P42            |                    | `SG['P42']`       |
+-----+              +----------------+--------------------+-------------------+
| 78  |              | P43            |                    | `SG['P43']`       |
+-----+              +----------------+--------------------+-------------------+
| 79  |              | I4             |                    | `SG['I4']`        |
+-----+              +----------------+--------------------+-------------------+
| 80  |              | I41            |                    | `SG['I41']`       |
+-----+              +----------------+--------------------+-------------------+
| 81  |              | P-4            |                    | `SG['P-4']`       |
+-----+              +----------------+--------------------+-------------------+
| 82  |              | I-4            |                    | `SG['I-4']`       |
+-----+              +----------------+--------------------+-------------------+
| 83  |              | P4/m           |                    | `SG['P4/m']`      |
+-----+              +----------------+--------------------+-------------------+
| 84  |              | P42/m          |                    | `SG['P42/m']`     |
+-----+              +----------------+--------------------+-------------------+
|     |              |                | origin at -4 on n  | `SG['P4/n']`      |
| 85  |              | P4/n           +--------------------+-------------------+
|     |              |                | origin at -1 on n  | `SG['P4/n#2']`    |
+-----+              +----------------+--------------------+-------------------+
|     |              |                | origin at -4       | `SG['P42/n']`     |
| 86  |              | P42/n          +--------------------+-------------------+
|     |              |                | origin at -1 on n  | `SG['P42/n#2']`   |
+-----+              +----------------+--------------------+-------------------+
| 87  |              | I4/m           |                    | `SG['I4/m']`      |
+-----+              +----------------+--------------------+-------------------+
|     |              |                | origin at -4       | `SG['I41/a']`     |
| 88  |              | I41/a          +--------------------+-------------------+
|     |              |                | origin at -1 on b  | `SG['I41/a#2']`   |
+-----+              +----------------+--------------------+-------------------+
| 89  |              | P422           |                    | `SG['P422']`      |
+-----+              +----------------+--------------------+-------------------+
| 90  |              | P4212          |                    | `SG['P4212']`     |
+-----+              +----------------+--------------------+-------------------+
| 91  |              | P4122          |                    | `SG['P4122']`     |
+-----+              +----------------+--------------------+-------------------+
| 92  |              | P41212         |                    | `SG['P41212']`    |
+-----+              +----------------+--------------------+-------------------+
| 93  |              | P4222          |                    | `SG['P4222']`     |
+-----+              +----------------+--------------------+-------------------+
| 94  |              | P42212         |                    | `SG['P42212']`    |
+-----+              +----------------+--------------------+-------------------+
| 95  |              | P4322          |                    | `SG['P4322']`     |
+-----+              +----------------+--------------------+-------------------+
| 96  |              | P43212         |                    | `SG['P43212']`    |
+-----+              +----------------+--------------------+-------------------+
| 97  |              | I422           |                    | `SG['I422']`      |
+-----+              +----------------+--------------------+-------------------+
| 98  |              | I4122          |                    | `SG['I4122']`     |
+-----+              +----------------+--------------------+-------------------+
| 99  |              | P4mm           |                    | `SG['P4mm']`      |
+-----+              +----------------+--------------------+-------------------+
| 100 |              | P4bm           |                    | `SG['P4bm']`      |
+-----+              +----------------+--------------------+-------------------+
| 101 |              | P42cm          |                    | `SG['P42cm']`     |
+-----+              +----------------+--------------------+-------------------+
| 102 |              | P42nm          |                    | `SG['P42nm']`     |
+-----+              +----------------+--------------------+-------------------+
| 103 |              | P4cc           |                    | `SG['P4cc']`      |
+-----+              +----------------+--------------------+-------------------+
| 104 |              | P4nc           |                    | `SG['P4nc']`      |
+-----+              +----------------+--------------------+-------------------+
| 105 |              | P42mc          |                    | `SG['P42mc']`     |
+-----+              +----------------+--------------------+-------------------+
| 106 |              | P42bc          |                    | `SG['P42bc']`     |
+-----+              +----------------+--------------------+-------------------+
| 107 |              | I4mm           |                    | `SG['I4mm']`      |
+-----+              +----------------+--------------------+-------------------+
| 108 |              | I4cm           |                    | `SG['I4cm']`      |
+-----+              +----------------+--------------------+-------------------+
| 109 |              | I41md          |                    | `SG['I41md']`     |
+-----+              +----------------+--------------------+-------------------+
| 110 |              | I41cd          |                    | `SG['I41cd']`     |
+-----+              +----------------+--------------------+-------------------+
| 111 |              | P-42m          |                    | `SG['P-42m']`     |
+-----+              +----------------+--------------------+-------------------+
| 112 |              | P-42c          |                    | `SG['P-42c']`     |
+-----+              +----------------+--------------------+-------------------+
| 113 |              | P-421m         |                    | `SG['P-421m']`    |
+-----+              +----------------+--------------------+-------------------+
| 114 |              | P-421c         |                    | `SG['P-421c']`    |
+-----+              +----------------+--------------------+-------------------+
| 115 |              | P-4m2          |                    | `SG['P-4m2']`     |
+-----+              +----------------+--------------------+-------------------+
| 116 |              | P-4c2          |                    | `SG['P-4c2']`     |
+-----+              +----------------+--------------------+-------------------+
| 117 |              | P-4b2          |                    | `SG['P-4b2']`     |
+-----+              +----------------+--------------------+-------------------+
| 118 |              | P-4n2          |                    | `SG['P-4n2']`     |
+-----+              +----------------+--------------------+-------------------+
| 119 |              | I-4m2          |                    | `SG['I-4m2']`     |
+-----+              +----------------+--------------------+-------------------+
| 120 |              | I-4c2          |                    | `SG['I-4c2']`     |
+-----+              +----------------+--------------------+-------------------+
| 121 |              | I-42m          |                    | `SG['I-42m']`     |
+-----+              +----------------+--------------------+-------------------+
| 122 |              | I-42d          |                    | `SG['I-42d']`     |
+-----+              +----------------+--------------------+-------------------+
| 123 |              | P4/mmm         |                    | `SG['P4/mmm']`    |
+-----+              +----------------+--------------------+-------------------+
| 124 |              | P4/mcc         |                    | `SG['P4/mcc']`    |
+-----+              +----------------+--------------------+-------------------+
|     |              |                | origin at 4/22     | `SG['P4/nbm']`    |
| 125 |              | P4/nbm         +--------------------+-------------------+
|     |              |                | origin at 2/m      | `SG['P4/nbm#2']`  |
+-----+              +----------------+--------------------+-------------------+
|     |              |                | origin at 422/n    | `SG['P4/nnc']`    |
| 126 |              | P4/nnc         +--------------------+-------------------+
|     |              |                | origin at -1       | `SG['P4/nnc#2']`  |
+-----+              +----------------+--------------------+-------------------+
| 127 |              | P4/mbm         |                    | `SG['P4/mbm']`    |
+-----+              +----------------+--------------------+-------------------+
| 128 |              | P4/mnc         |                    | `SG['P4/mnc']`    |
+-----+              +----------------+--------------------+-------------------+
|     |              |                | origin at -4m2     | `SG['P4/nmm']`    |
| 129 |              | P4/nmm         +--------------------+-------------------+
|     |              |                | origin at 2/m      | `SG['P4/nmm#2']`  |
+-----+              +----------------+--------------------+-------------------+
|     |              |                | origin at -4/ncn   | `SG['P4/ncc']`    |
| 130 |              | P4/ncc         +--------------------+-------------------+
|     |              |                | origin at -1       | `SG['P4/ncc#2']`  |
+-----+              +----------------+--------------------+-------------------+
| 131 |              | P42/mmc        |                    | `SG['P42/mmc']`   |
+-----+              +----------------+--------------------+-------------------+
| 132 |              | P42/mcm        |                    | `SG['P42/mcm']`   |
+-----+              +----------------+--------------------+-------------------+
|     |              |                | origin at -4121/c  | `SG['P42/nbc']`   |
| 133 |              | P42/nbc        +--------------------+-------------------+
|     |              |                | origin at -1       | `SG['P42/nbc#2']` |
+-----+              +----------------+--------------------+-------------------+
|     |              |                | origin at -42m     | `SG['P42/nnm']`   |
| 134 |              | P42/nnm        +--------------------+-------------------+
|     |              |                | origin at 2/m      | `SG['P42/nnm#2']` |
+-----+              +----------------+--------------------+-------------------+
| 135 |              | P42/mbc        |                    | `SG['P42/mbc']`   |
+-----+              +----------------+--------------------+-------------------+
| 136 |              | P42/mnm        |                    | `SG['P42/mnm']`   |
+-----+              +----------------+--------------------+-------------------+
|     |              |                | origin at -4m2/n   | `SG['P42/nmc']`   |
| 137 |              | P42/nmc        +--------------------+-------------------+
|     |              |                | origin at -1       | `SG['P42/nmc#2']` |
+-----+              +----------------+--------------------+-------------------+
|     |              |                | origin at -4cg     | `SG['P42/ncm']`   |
| 138 |              | P42/ncm        +--------------------+-------------------+
|     |              |                | origin at 2/m      | `SG['P42/ncm#2']` |
+-----+              +----------------+--------------------+-------------------+
| 139 |              | I4/mmm         |                    | `SG['I4/mmm']`    |
+-----+              +----------------+--------------------+-------------------+
| 140 |              | I4/mcm         |                    | `SG['I4/mcm']`    |
+-----+              +----------------+--------------------+-------------------+
|     |              |                | origin at -4m2     | `SG['I41/amd']`   |
| 141 |              | I41/amd        +--------------------+-------------------+
|     |              |                | origin at 2/m      | `SG['I41/amd#2']` |
+-----+              +----------------+--------------------+-------------------+
|     |              |                | origin at -4c21    | `SG['I41/acd']`   |
| 142 |              | I41/acd        +--------------------+-------------------+
|     |              |                | origin at -1       | `SG['I41/acd#2']` |
+-----+--------------+----------------+--------------------+-------------------+
| 143 | trigonal     | P3             |                    | `SG['P3']`        |
+-----+              +----------------+--------------------+-------------------+
| 144 |              | P31            |                    | `SG['P31']`       |
+-----+              +----------------+--------------------+-------------------+
| 145 |              | P32            |                    | `SG['P32']`       |
+-----+              +----------------+--------------------+-------------------+
| 146 |              | R3             | hexagonal axes     | `SG['R3']`        |
+-----+              +----------------+--------------------+-------------------+
| 147 |              | P-3            |                    | `SG['P-3']`       |
+-----+              +----------------+--------------------+-------------------+
| 148 |              | R-3            | hexagonal axes     | `SG['R-3']`       |
+-----+              +----------------+--------------------+-------------------+
| 149 |              | P312           |                    | `SG['P312']`      |
+-----+              +----------------+--------------------+-------------------+
| 150 |              | P321           |                    | `SG['P321']`      |
+-----+              +----------------+--------------------+-------------------+
| 151 |              | P3112          |                    | `SG['P3112']`     |
+-----+              +----------------+--------------------+-------------------+
| 152 |              | P3121          |                    | `SG['P3121']`     |
+-----+              +----------------+--------------------+-------------------+
| 153 |              | P3212          |                    | `SG['P3212']`     |
+-----+              +----------------+--------------------+-------------------+
| 154 |              | P3221          |                    | `SG['P3221']`     |
+-----+              +----------------+--------------------+-------------------+
| 155 |              | R32            | hexagonal axes     | `SG['R32']`       |
+-----+              +----------------+--------------------+-------------------+
| 156 |              | P3m1           |                    | `SG['P3m1']`      |
+-----+              +----------------+--------------------+-------------------+
| 157 |              | P31m           |                    | `SG['P31m']`      |
+-----+              +----------------+--------------------+-------------------+
| 158 |              | P3c1           |                    | `SG['P3c1']`      |
+-----+              +----------------+--------------------+-------------------+
| 159 |              | P31c           |                    | `SG['P31c']`      |
+-----+              +----------------+--------------------+-------------------+
| 160 |              | R3m            | hexagonal axes     | `SG['R3m']`       |
+-----+              +----------------+--------------------+-------------------+
| 161 |              | R3c            | hexagonal axes     | `SG['R3c']`       |
+-----+              +----------------+--------------------+-------------------+
| 162 |              | P-31m          |                    | `SG['P-31m']`     |
+-----+              +----------------+--------------------+-------------------+
| 163 |              | P-31c          |                    | `SG['P-31c']`     |
+-----+              +----------------+--------------------+-------------------+
| 164 |              | P-3m1          |                    | `SG['P-3m1']`     |
+-----+              +----------------+--------------------+-------------------+
| 165 |              | P-3c1          |                    | `SG['P-3c1']`     |
+-----+              +----------------+--------------------+-------------------+
| 166 |              | R-3m           | hexagonal axes     | `SG['R-3m']`      |
+-----+              +----------------+--------------------+-------------------+
| 167 |              | R-3c           | hexagonal axes     | `SG['R-3c']`      |
+-----+--------------+----------------+--------------------+-------------------+
| 168 | hexagonal    | P6             |                    | `SG['P6']`        |
+-----+              +----------------+--------------------+-------------------+
| 169 |              | P61            |                    | `SG['P61']`       |
+-----+              +----------------+--------------------+-------------------+
| 170 |              | P65            |                    | `SG['P65']`       |
+-----+              +----------------+--------------------+-------------------+
| 171 |              | P62            |                    | `SG['P62']`       |
+-----+              +----------------+--------------------+-------------------+
| 172 |              | P64            |                    | `SG['P64']`       |
+-----+              +----------------+--------------------+-------------------+
| 173 |              | P63            |                    | `SG['P63']`       |
+-----+              +----------------+--------------------+-------------------+
| 174 |              | P-6            |                    | `SG['P-6']`       |
+-----+              +----------------+--------------------+-------------------+
| 175 |              | P6/m           |                    | `SG['P6/m']`      |
+-----+              +----------------+--------------------+-------------------+
| 176 |              | P63/m          |                    | `SG['P63/m']`     |
+-----+              +----------------+--------------------+-------------------+
| 177 |              | P622           |                    | `SG['P622']`      |
+-----+              +----------------+--------------------+-------------------+
| 178 |              | P6122          |                    | `SG['P6122']`     |
+-----+              +----------------+--------------------+-------------------+
| 179 |              | P6522          |                    | `SG['P6522']`     |
+-----+              +----------------+--------------------+-------------------+
| 180 |              | P6222          |                    | `SG['P6222']`     |
+-----+              +----------------+--------------------+-------------------+
| 181 |              | P6422          |                    | `SG['P6422']`     |
+-----+              +----------------+--------------------+-------------------+
| 182 |              | P6322          |                    | `SG['P6322']`     |
+-----+              +----------------+--------------------+-------------------+
| 183 |              | P6mm           |                    | `SG['P6mm']`      |
+-----+              +----------------+--------------------+-------------------+
| 184 |              | P6cc           |                    | `SG['P6cc']`      |
+-----+              +----------------+--------------------+-------------------+
| 185 |              | P63cm          |                    | `SG['P63cm']`     |
+-----+              +----------------+--------------------+-------------------+
| 186 |              | P63mc          |                    | `SG['P63mc']`     |
+-----+              +----------------+--------------------+-------------------+
| 187 |              | P-6m2          |                    | `SG['P-6m2']`     |
+-----+              +----------------+--------------------+-------------------+
| 188 |              | P-6c2          |                    | `SG['P-6c2']`     |
+-----+              +----------------+--------------------+-------------------+
| 189 |              | P-62m          |                    | `SG['P-62m']`     |
+-----+              +----------------+--------------------+-------------------+
| 190 |              | P-62c          |                    | `SG['P-62c']`     |
+-----+              +----------------+--------------------+-------------------+
| 191 |              | P6/mmm         |                    | `SG['P6/mmm']`    |
+-----+              +----------------+--------------------+-------------------+
| 192 |              | P6/mcc         |                    | `SG['P6/mcc']`    |
+-----+              +----------------+--------------------+-------------------+
| 193 |              | P63/mcm        |                    | `SG['P63/mcm']`   |
+-----+              +----------------+--------------------+-------------------+
| 194 |              | P63/mmc        |                    | `SG['P63/mmc']`   |
+-----+--------------+----------------+--------------------+-------------------+
| 195 | cubic        | P23            |                    | `SG['P23']`       |
+-----+              +----------------+--------------------+-------------------+
| 196 |              | F23            |                    | `SG['F23']`       |
+-----+              +----------------+--------------------+-------------------+
| 197 |              | I23            |                    | `SG['I23']`       |
+-----+              +----------------+--------------------+-------------------+
| 198 |              | P213           |                    | `SG['P213']`      |
+-----+              +----------------+--------------------+-------------------+
| 199 |              | I213           |                    | `SG['I213']`      |
+-----+              +----------------+--------------------+-------------------+
| 200 |              | Pm-3           |                    | `SG['Pm-3']`      |
+-----+              +----------------+--------------------+-------------------+
|     |              |                | origin at 23       | `SG['Pn-3']`      |
| 201 |              | Pn-3           +--------------------+-------------------+
|     |              |                | origin at -3       | `SG['Pn-3#2']`    |
+-----+              +----------------+--------------------+-------------------+
| 202 |              | Fm-3           |                    | `SG['Fm-3']`      |
+-----+              +----------------+--------------------+-------------------+
|     |              |                | origin at 23       | `SG['Fd-3']`      |
| 203 |              | Fd-3           +--------------------+-------------------+
|     |              |                | origin at -3       | `SG['Fd-3#2']`    |
+-----+              +----------------+--------------------+-------------------+
| 204 |              | Im-3           |                    | `SG['Im-3']`      |
+-----+              +----------------+--------------------+-------------------+
| 205 |              | Pa-3           |                    | `SG['Pa-3']`      |
+-----+              +----------------+--------------------+-------------------+
| 206 |              | Ia-3           |                    | `SG['Ia-3']`      |
+-----+              +----------------+--------------------+-------------------+
| 207 |              | P432           |                    | `SG['P432']`      |
+-----+              +----------------+--------------------+-------------------+
| 208 |              | P4232          |                    | `SG['P4232']`     |
+-----+              +----------------+--------------------+-------------------+
| 209 |              | F432           |                    | `SG['F432']`      |
+-----+              +----------------+--------------------+-------------------+
| 210 |              | F4132          |                    | `SG['F4132']`     |
+-----+              +----------------+--------------------+-------------------+
| 211 |              | I432           |                    | `SG['I432']`      |
+-----+              +----------------+--------------------+-------------------+
| 212 |              | P4332          |                    | `SG['P4332']`     |
+-----+              +----------------+--------------------+-------------------+
| 213 |              | P4132          |                    | `SG['P4132']`     |
+-----+              +----------------+--------------------+-------------------+
| 214 |              | I4132          |                    | `SG['I4132']`     |
+-----+              +----------------+--------------------+-------------------+
| 215 |              | P-43m          |                    | `SG['P-43m']`     |
+-----+              +----------------+--------------------+-------------------+
| 216 |              | F-43m          |                    | `SG['F-43m']`     |
+-----+              +----------------+--------------------+-------------------+
| 217 |              | I-43m          |                    | `SG['I-43m']`     |
+-----+              +----------------+--------------------+-------------------+
| 218 |              | P-43n          |                    | `SG['P-43n']`     |
+-----+              +----------------+--------------------+-------------------+
| 219 |              | F-43c          |                    | `SG['F-43c']`     |
+-----+              +----------------+--------------------+-------------------+
| 220 |              | I-43d          |                    | `SG['I-43d']`     |
+-----+              +----------------+--------------------+-------------------+
| 221 |              | Pm-3m          |                    | `SG['Pm-3m']`     |
+-----+              +----------------+--------------------+-------------------+
|     |              |                | origin at 432      | `SG['Pn-3n']`     |
| 222 |              | Pn-3n          +--------------------+-------------------+
|     |              |                | origin at -3       | `SG['Pn-3n#2']`   |
+-----+              +----------------+--------------------+-------------------+
| 223 |              | Pm-3n          |                    | `SG['Pm-3n']`     |
+-----+              +----------------+--------------------+-------------------+
|     |              |                | origin at -43m     | `SG['Pn-3m']`     |
| 224 |              | Pn-3m          +--------------------+-------------------+
|     |              |                | origin at -3m      | `SG['Pn-3m#2']`   |
+-----+              +----------------+--------------------+-------------------+
| 225 |              | Fm-3m          |                    | `SG['Fm-3m']`     |
+-----+              +----------------+--------------------+-------------------+
| 226 |              | Fm-3c          |                    | `SG['Fm-3c']`     |
+-----+              +----------------+--------------------+-------------------+
|     |              |                | origin at -43m     | `SG['Fd-3m']`     |
| 227 |              | Fd-3m          +--------------------+-------------------+
|     |              |                | origin at -3m      | `SG['Fd-3m#2']`   |
+-----+              +----------------+--------------------+-------------------+
|     |              |                | origin at 23       | `SG['Fd-3c']`     |
| 228 |              | Fd-3c          +--------------------+-------------------+
|     |              |                | origin at -3       | `SG['Fd-3c#2']`   |
+-----+              +----------------+--------------------+-------------------+
| 229 |              | Im-3m          |                    | `SG['Im-3m']`     |
+-----+              +----------------+--------------------+-------------------+
| 230 |              | Ia-3d          |                    | `SG['Ia-3d']`     |
+-----+--------------+----------------+--------------------+-------------------+
"""
