
// MBT 8-18-2014
// bsg_scatter_gather
// generated by bsg_scatter_gather.py;
// python-generated Code. do not modify
//
//
// Given a bit vector, generate
// permutation vectors that perform
// concentration (fwd) and deconcentration (bkwd).
//
//
//           bit   fwd          bkwd
//   pos.   vec    vec          vec
//     3     1 --\    1      --- 2
//                \         /
//     2     1 -\  -> 3  <--  -- 1
//               \           /
//     1     0    --> 2  <---    3 --> 1

//     0     1 -----> 0  <------ 0
//
// For empty slots; we just pick an unused slot, possible
// reusing the same empty slot multiple times. This allows
// control logic to be unselected.
//


module bsg_scatter_gather #(parameter vec_size_lp="inv")
       (input [vec_size_lp-1:0] vec_i
       ,output reg [vec_size_lp*`BSG_SAFE_CLOG2(vec_size_lp)-1:0] fwd_o
       ,output reg [vec_size_lp*`BSG_SAFE_CLOG2(vec_size_lp)-1:0] fwd_datapath_o
       ,output reg [vec_size_lp*`BSG_SAFE_CLOG2(vec_size_lp)-1:0] bk_o
       ,output reg [vec_size_lp*`BSG_SAFE_CLOG2(vec_size_lp)-1:0] bk_datapath_o       
       );


if (vec_size_lp == 1)
  begin
    // backward vec
    always_comb
    unique case (vec_i) 
         1'b0: bk_o =  1'b0; //  X
         1'b1: bk_o =  1'b0; //  0
        default: bk_o= 'X;
    endcase

    // backward vec datapath
    always_comb
    unique case (vec_i) 
         1'b0: bk_datapath_o =  1'b0; //  X
         1'b1: bk_datapath_o =  1'b0; //  0
        default: bk_datapath_o= 'X;
    endcase

    // fwd vec
    always_comb
    unique case (vec_i) 
         1'b0: fwd_o =  1'b0; //  X
         1'b1: fwd_o =  1'b0; //  0
        default: fwd_o= 'X;
    endcase

    // fwd datapath vec
    always_comb
    unique case (vec_i) 
         1'b0: fwd_datapath_o =  1'b0; //  X
         1'b1: fwd_datapath_o =  1'b0; //  0
        default: fwd_datapath_o= 'X;
    endcase
  end

if (vec_size_lp == 2)
  begin
    // backward vec
    always_comb
    unique case (vec_i) 
         2'b00: bk_o =  2'b11; //  X X
         2'b01: bk_o =  2'b10; //  X 0
         2'b10: bk_o =  2'b01; //  0 X
         2'b11: bk_o =  2'b10; //  1 0
        default: bk_o= 'X;
    endcase

    // backward vec datapath
    always_comb
    unique case (vec_i) 
         2'b00: bk_datapath_o =  2'b00; //  X X
         2'b01: bk_datapath_o =  2'b00; //  X 0
         2'b10: bk_datapath_o =  2'b00; //  0 X
         2'b11: bk_datapath_o =  2'b10; //  1 0
        default: bk_datapath_o= 'X;
    endcase

    // fwd vec
    always_comb
    unique case (vec_i) 
         2'b00: fwd_o =  2'b11; //  X X
         2'b01: fwd_o =  2'b10; //  X 0
         2'b10: fwd_o =  2'b01; //  X 1
         2'b11: fwd_o =  2'b10; //  1 0
        default: fwd_o= 'X;
    endcase

    // fwd datapath vec
    always_comb
    unique case (vec_i) 
         2'b00: fwd_datapath_o =  2'b00; //  X X
         2'b01: fwd_datapath_o =  2'b00; //  X 0
         2'b10: fwd_datapath_o =  2'b01; //  X 1
         2'b11: fwd_datapath_o =  2'b00; //  0 0
        default: fwd_datapath_o= 'X;
    endcase
  end

if (vec_size_lp == 3)
  begin
    // backward vec
    always_comb
    unique case (vec_i) 
         3'b000: bk_o =  6'b101010; //  X X X
         3'b001: bk_o =  6'b101000; //  X X 0
         3'b010: bk_o =  6'b100010; //  X 0 X
         3'b011: bk_o =  6'b100100; //  X 1 0
         3'b100: bk_o =  6'b001010; //  0 X X
         3'b101: bk_o =  6'b011000; //  1 X 0
         3'b110: bk_o =  6'b010010; //  1 0 X
         3'b111: bk_o =  6'b100100; //  2 1 0
        default: bk_o= 'X;
    endcase

    // backward vec datapath
    always_comb
    unique case (vec_i) 
         3'b000: bk_datapath_o =  6'b000000; //  X X X
         3'b001: bk_datapath_o =  6'b000000; //  X X 0
         3'b010: bk_datapath_o =  6'b000000; //  X 0 X
         3'b011: bk_datapath_o =  6'b000100; //  X 1 0
         3'b100: bk_datapath_o =  6'b000000; //  0 X X
         3'b101: bk_datapath_o =  6'b010000; //  1 X 0
         3'b110: bk_datapath_o =  6'b010000; //  1 0 X
         3'b111: bk_datapath_o =  6'b100100; //  2 1 0
        default: bk_datapath_o= 'X;
    endcase

    // fwd vec
    always_comb
    unique case (vec_i) 
         3'b000: fwd_o =  6'b101010; //  X X X
         3'b001: fwd_o =  6'b101000; //  X X 0
         3'b010: fwd_o =  6'b101001; //  X X 1
         3'b011: fwd_o =  6'b100100; //  X 1 0
         3'b100: fwd_o =  6'b010110; //  X X 2
         3'b101: fwd_o =  6'b011000; //  X 2 0
         3'b110: fwd_o =  6'b001001; //  X 2 1
         3'b111: fwd_o =  6'b100100; //  2 1 0
        default: fwd_o= 'X;
    endcase

    // fwd datapath vec
    always_comb
    unique case (vec_i) 
         3'b000: fwd_datapath_o =  6'b000000; //  X X X
         3'b001: fwd_datapath_o =  6'b000000; //  X X 0
         3'b010: fwd_datapath_o =  6'b000001; //  X X 1
         3'b011: fwd_datapath_o =  6'b000000; //  X 0 0
         3'b100: fwd_datapath_o =  6'b000010; //  X X 2
         3'b101: fwd_datapath_o =  6'b000100; //  X 1 0
         3'b110: fwd_datapath_o =  6'b000101; //  X 1 1
         3'b111: fwd_datapath_o =  6'b000000; //  0 0 0
        default: fwd_datapath_o= 'X;
    endcase
  end

if (vec_size_lp == 4)
  begin
    // backward vec
    always_comb
    unique case (vec_i) 
         4'b0000: bk_o =  8'b11111111; //  X X X X
         4'b0001: bk_o =  8'b11111100; //  X X X 0
         4'b0010: bk_o =  8'b11110011; //  X X 0 X
         4'b0011: bk_o =  8'b11110100; //  X X 1 0
         4'b0100: bk_o =  8'b11001111; //  X 0 X X
         4'b0101: bk_o =  8'b11011100; //  X 1 X 0
         4'b0110: bk_o =  8'b11010011; //  X 1 0 X
         4'b0111: bk_o =  8'b11100100; //  X 2 1 0
         4'b1000: bk_o =  8'b00111111; //  0 X X X
         4'b1001: bk_o =  8'b01111100; //  1 X X 0
         4'b1010: bk_o =  8'b01110011; //  1 X 0 X
         4'b1011: bk_o =  8'b10110100; //  2 X 1 0
         4'b1100: bk_o =  8'b01001111; //  1 0 X X
         4'b1101: bk_o =  8'b10011100; //  2 1 X 0
         4'b1110: bk_o =  8'b10010011; //  2 1 0 X
         4'b1111: bk_o =  8'b11100100; //  3 2 1 0
        default: bk_o= 'X;
    endcase

    // backward vec datapath
    always_comb
    unique case (vec_i) 
         4'b0000: bk_datapath_o =  8'b00000000; //  X X X X
         4'b0001: bk_datapath_o =  8'b00000000; //  X X X 0
         4'b0010: bk_datapath_o =  8'b00000000; //  X X 0 X
         4'b0011: bk_datapath_o =  8'b00000100; //  X X 1 0
         4'b0100: bk_datapath_o =  8'b00000000; //  X 0 X X
         4'b0101: bk_datapath_o =  8'b00010000; //  X 1 X 0
         4'b0110: bk_datapath_o =  8'b00010000; //  X 1 0 X
         4'b0111: bk_datapath_o =  8'b00100100; //  X 2 1 0
         4'b1000: bk_datapath_o =  8'b00000000; //  0 X X X
         4'b1001: bk_datapath_o =  8'b01000000; //  1 X X 0
         4'b1010: bk_datapath_o =  8'b01000000; //  1 X 0 X
         4'b1011: bk_datapath_o =  8'b10000100; //  2 X 1 0
         4'b1100: bk_datapath_o =  8'b01000000; //  1 0 X X
         4'b1101: bk_datapath_o =  8'b10010000; //  2 1 X 0
         4'b1110: bk_datapath_o =  8'b10010000; //  2 1 0 X
         4'b1111: bk_datapath_o =  8'b11100100; //  3 2 1 0
        default: bk_datapath_o= 'X;
    endcase

    // fwd vec
    always_comb
    unique case (vec_i) 
         4'b0000: fwd_o =  8'b11111111; //  X X X X
         4'b0001: fwd_o =  8'b11111100; //  X X X 0
         4'b0010: fwd_o =  8'b11111101; //  X X X 1
         4'b0011: fwd_o =  8'b11110100; //  X X 1 0
         4'b0100: fwd_o =  8'b11111110; //  X X X 2
         4'b0101: fwd_o =  8'b11111000; //  X X 2 0
         4'b0110: fwd_o =  8'b11111001; //  X X 2 1
         4'b0111: fwd_o =  8'b11100100; //  X 2 1 0
         4'b1000: fwd_o =  8'b10101011; //  X X X 3
         4'b1001: fwd_o =  8'b10101100; //  X X 3 0
         4'b1010: fwd_o =  8'b10101101; //  X X 3 1
         4'b1011: fwd_o =  8'b10110100; //  X 3 1 0
         4'b1100: fwd_o =  8'b01011110; //  X X 3 2
         4'b1101: fwd_o =  8'b01111000; //  X 3 2 0
         4'b1110: fwd_o =  8'b00111001; //  X 3 2 1
         4'b1111: fwd_o =  8'b11100100; //  3 2 1 0
        default: fwd_o= 'X;
    endcase

    // fwd datapath vec
    always_comb
    unique case (vec_i) 
         4'b0000: fwd_datapath_o =  8'b00000000; //  X X X X
         4'b0001: fwd_datapath_o =  8'b00000000; //  X X X 0
         4'b0010: fwd_datapath_o =  8'b00000001; //  X X X 1
         4'b0011: fwd_datapath_o =  8'b00000000; //  X X 0 0
         4'b0100: fwd_datapath_o =  8'b00000010; //  X X X 2
         4'b0101: fwd_datapath_o =  8'b00000100; //  X X 1 0
         4'b0110: fwd_datapath_o =  8'b00000101; //  X X 1 1
         4'b0111: fwd_datapath_o =  8'b00000000; //  X 0 0 0
         4'b1000: fwd_datapath_o =  8'b00000011; //  X X X 3
         4'b1001: fwd_datapath_o =  8'b00001000; //  X X 2 0
         4'b1010: fwd_datapath_o =  8'b00001001; //  X X 2 1
         4'b1011: fwd_datapath_o =  8'b00010000; //  X 1 0 0
         4'b1100: fwd_datapath_o =  8'b00001010; //  X X 2 2
         4'b1101: fwd_datapath_o =  8'b00010100; //  X 1 1 0
         4'b1110: fwd_datapath_o =  8'b00010101; //  X 1 1 1
         4'b1111: fwd_datapath_o =  8'b00000000; //  0 0 0 0
        default: fwd_datapath_o= 'X;
    endcase
  end

if (vec_size_lp == 5)
  begin
    // backward vec
    always_comb
    unique case (vec_i) 
         5'b00000: bk_o =  15'b100100100100100; //  X X X X X
         5'b00001: bk_o =  15'b100100100100000; //  X X X X 0
         5'b00010: bk_o =  15'b100100100000100; //  X X X 0 X
         5'b00011: bk_o =  15'b100100100001000; //  X X X 1 0
         5'b00100: bk_o =  15'b100100000100100; //  X X 0 X X
         5'b00101: bk_o =  15'b100100001100000; //  X X 1 X 0
         5'b00110: bk_o =  15'b100100001000100; //  X X 1 0 X
         5'b00111: bk_o =  15'b100100010001000; //  X X 2 1 0
         5'b01000: bk_o =  15'b100000100100100; //  X 0 X X X
         5'b01001: bk_o =  15'b100001100100000; //  X 1 X X 0
         5'b01010: bk_o =  15'b100001100000100; //  X 1 X 0 X
         5'b01011: bk_o =  15'b100010100001000; //  X 2 X 1 0
         5'b01100: bk_o =  15'b100001000100100; //  X 1 0 X X
         5'b01101: bk_o =  15'b100010001100000; //  X 2 1 X 0
         5'b01110: bk_o =  15'b100010001000100; //  X 2 1 0 X
         5'b01111: bk_o =  15'b100011010001000; //  X 3 2 1 0
         5'b10000: bk_o =  15'b000100100100100; //  0 X X X X
         5'b10001: bk_o =  15'b001100100100000; //  1 X X X 0
         5'b10010: bk_o =  15'b001100100000100; //  1 X X 0 X
         5'b10011: bk_o =  15'b010100100001000; //  2 X X 1 0
         5'b10100: bk_o =  15'b001100000100100; //  1 X 0 X X
         5'b10101: bk_o =  15'b010100001100000; //  2 X 1 X 0
         5'b10110: bk_o =  15'b010100001000100; //  2 X 1 0 X
         5'b10111: bk_o =  15'b011100010001000; //  3 X 2 1 0
         5'b11000: bk_o =  15'b001000100100100; //  1 0 X X X
         5'b11001: bk_o =  15'b010001100100000; //  2 1 X X 0
         5'b11010: bk_o =  15'b010001100000100; //  2 1 X 0 X
         5'b11011: bk_o =  15'b011010100001000; //  3 2 X 1 0
         5'b11100: bk_o =  15'b010001000100100; //  2 1 0 X X
         5'b11101: bk_o =  15'b011010001100000; //  3 2 1 X 0
         5'b11110: bk_o =  15'b011010001000100; //  3 2 1 0 X
         5'b11111: bk_o =  15'b100011010001000; //  4 3 2 1 0
        default: bk_o= 'X;
    endcase

    // backward vec datapath
    always_comb
    unique case (vec_i) 
         5'b00000: bk_datapath_o =  15'b000000000000000; //  X X X X X
         5'b00001: bk_datapath_o =  15'b000000000000000; //  X X X X 0
         5'b00010: bk_datapath_o =  15'b000000000000000; //  X X X 0 X
         5'b00011: bk_datapath_o =  15'b000000000001000; //  X X X 1 0
         5'b00100: bk_datapath_o =  15'b000000000000000; //  X X 0 X X
         5'b00101: bk_datapath_o =  15'b000000001000000; //  X X 1 X 0
         5'b00110: bk_datapath_o =  15'b000000001000000; //  X X 1 0 X
         5'b00111: bk_datapath_o =  15'b000000010001000; //  X X 2 1 0
         5'b01000: bk_datapath_o =  15'b000000000000000; //  X 0 X X X
         5'b01001: bk_datapath_o =  15'b000001000000000; //  X 1 X X 0
         5'b01010: bk_datapath_o =  15'b000001000000000; //  X 1 X 0 X
         5'b01011: bk_datapath_o =  15'b000010000001000; //  X 2 X 1 0
         5'b01100: bk_datapath_o =  15'b000001000000000; //  X 1 0 X X
         5'b01101: bk_datapath_o =  15'b000010001000000; //  X 2 1 X 0
         5'b01110: bk_datapath_o =  15'b000010001000000; //  X 2 1 0 X
         5'b01111: bk_datapath_o =  15'b000011010001000; //  X 3 2 1 0
         5'b10000: bk_datapath_o =  15'b000000000000000; //  0 X X X X
         5'b10001: bk_datapath_o =  15'b001000000000000; //  1 X X X 0
         5'b10010: bk_datapath_o =  15'b001000000000000; //  1 X X 0 X
         5'b10011: bk_datapath_o =  15'b010000000001000; //  2 X X 1 0
         5'b10100: bk_datapath_o =  15'b001000000000000; //  1 X 0 X X
         5'b10101: bk_datapath_o =  15'b010000001000000; //  2 X 1 X 0
         5'b10110: bk_datapath_o =  15'b010000001000000; //  2 X 1 0 X
         5'b10111: bk_datapath_o =  15'b011000010001000; //  3 X 2 1 0
         5'b11000: bk_datapath_o =  15'b001000000000000; //  1 0 X X X
         5'b11001: bk_datapath_o =  15'b010001000000000; //  2 1 X X 0
         5'b11010: bk_datapath_o =  15'b010001000000000; //  2 1 X 0 X
         5'b11011: bk_datapath_o =  15'b011010000001000; //  3 2 X 1 0
         5'b11100: bk_datapath_o =  15'b010001000000000; //  2 1 0 X X
         5'b11101: bk_datapath_o =  15'b011010001000000; //  3 2 1 X 0
         5'b11110: bk_datapath_o =  15'b011010001000000; //  3 2 1 0 X
         5'b11111: bk_datapath_o =  15'b100011010001000; //  4 3 2 1 0
        default: bk_datapath_o= 'X;
    endcase

    // fwd vec
    always_comb
    unique case (vec_i) 
         5'b00000: fwd_o =  15'b100100100100100; //  X X X X X
         5'b00001: fwd_o =  15'b100100100100000; //  X X X X 0
         5'b00010: fwd_o =  15'b100100100100001; //  X X X X 1
         5'b00011: fwd_o =  15'b100100100001000; //  X X X 1 0
         5'b00100: fwd_o =  15'b100100100100010; //  X X X X 2
         5'b00101: fwd_o =  15'b100100100010000; //  X X X 2 0
         5'b00110: fwd_o =  15'b100100100010001; //  X X X 2 1
         5'b00111: fwd_o =  15'b100100010001000; //  X X 2 1 0
         5'b01000: fwd_o =  15'b100100100100011; //  X X X X 3
         5'b01001: fwd_o =  15'b100100100011000; //  X X X 3 0
         5'b01010: fwd_o =  15'b100100100011001; //  X X X 3 1
         5'b01011: fwd_o =  15'b100100011001000; //  X X 3 1 0
         5'b01100: fwd_o =  15'b100100100011010; //  X X X 3 2
         5'b01101: fwd_o =  15'b100100011010000; //  X X 3 2 0
         5'b01110: fwd_o =  15'b100100011010001; //  X X 3 2 1
         5'b01111: fwd_o =  15'b100011010001000; //  X 3 2 1 0
         5'b10000: fwd_o =  15'b011011011011100; //  X X X X 4
         5'b10001: fwd_o =  15'b011011011100000; //  X X X 4 0
         5'b10010: fwd_o =  15'b011011011100001; //  X X X 4 1
         5'b10011: fwd_o =  15'b011011100001000; //  X X 4 1 0
         5'b10100: fwd_o =  15'b011011011100010; //  X X X 4 2
         5'b10101: fwd_o =  15'b011011100010000; //  X X 4 2 0
         5'b10110: fwd_o =  15'b011011100010001; //  X X 4 2 1
         5'b10111: fwd_o =  15'b011100010001000; //  X 4 2 1 0
         5'b11000: fwd_o =  15'b010010010100011; //  X X X 4 3
         5'b11001: fwd_o =  15'b010010100011000; //  X X 4 3 0
         5'b11010: fwd_o =  15'b010010100011001; //  X X 4 3 1
         5'b11011: fwd_o =  15'b010100011001000; //  X 4 3 1 0
         5'b11100: fwd_o =  15'b001001100011010; //  X X 4 3 2
         5'b11101: fwd_o =  15'b001100011010000; //  X 4 3 2 0
         5'b11110: fwd_o =  15'b000100011010001; //  X 4 3 2 1
         5'b11111: fwd_o =  15'b100011010001000; //  4 3 2 1 0
        default: fwd_o= 'X;
    endcase

    // fwd datapath vec
    always_comb
    unique case (vec_i) 
         5'b00000: fwd_datapath_o =  15'b000000000000000; //  X X X X X
         5'b00001: fwd_datapath_o =  15'b000000000000000; //  X X X X 0
         5'b00010: fwd_datapath_o =  15'b000000000000001; //  X X X X 1
         5'b00011: fwd_datapath_o =  15'b000000000000000; //  X X X 0 0
         5'b00100: fwd_datapath_o =  15'b000000000000010; //  X X X X 2
         5'b00101: fwd_datapath_o =  15'b000000000001000; //  X X X 1 0
         5'b00110: fwd_datapath_o =  15'b000000000001001; //  X X X 1 1
         5'b00111: fwd_datapath_o =  15'b000000000000000; //  X X 0 0 0
         5'b01000: fwd_datapath_o =  15'b000000000000011; //  X X X X 3
         5'b01001: fwd_datapath_o =  15'b000000000010000; //  X X X 2 0
         5'b01010: fwd_datapath_o =  15'b000000000010001; //  X X X 2 1
         5'b01011: fwd_datapath_o =  15'b000000001000000; //  X X 1 0 0
         5'b01100: fwd_datapath_o =  15'b000000000010010; //  X X X 2 2
         5'b01101: fwd_datapath_o =  15'b000000001001000; //  X X 1 1 0
         5'b01110: fwd_datapath_o =  15'b000000001001001; //  X X 1 1 1
         5'b01111: fwd_datapath_o =  15'b000000000000000; //  X 0 0 0 0
         5'b10000: fwd_datapath_o =  15'b000000000000100; //  X X X X 4
         5'b10001: fwd_datapath_o =  15'b000000000011000; //  X X X 3 0
         5'b10010: fwd_datapath_o =  15'b000000000011001; //  X X X 3 1
         5'b10011: fwd_datapath_o =  15'b000000010000000; //  X X 2 0 0
         5'b10100: fwd_datapath_o =  15'b000000000011010; //  X X X 3 2
         5'b10101: fwd_datapath_o =  15'b000000010001000; //  X X 2 1 0
         5'b10110: fwd_datapath_o =  15'b000000010001001; //  X X 2 1 1
         5'b10111: fwd_datapath_o =  15'b000001000000000; //  X 1 0 0 0
         5'b11000: fwd_datapath_o =  15'b000000000011011; //  X X X 3 3
         5'b11001: fwd_datapath_o =  15'b000000010010000; //  X X 2 2 0
         5'b11010: fwd_datapath_o =  15'b000000010010001; //  X X 2 2 1
         5'b11011: fwd_datapath_o =  15'b000001001000000; //  X 1 1 0 0
         5'b11100: fwd_datapath_o =  15'b000000010010010; //  X X 2 2 2
         5'b11101: fwd_datapath_o =  15'b000001001001000; //  X 1 1 1 0
         5'b11110: fwd_datapath_o =  15'b000001001001001; //  X 1 1 1 1
         5'b11111: fwd_datapath_o =  15'b000000000000000; //  0 0 0 0 0
        default: fwd_datapath_o= 'X;
    endcase
  end

if (vec_size_lp == 6)
  begin
    // backward vec
    always_comb
    unique case (vec_i) 
         6'b000000: bk_o =  18'b101101101101101101; //  X X X X X X
         6'b000001: bk_o =  18'b101101101101101000; //  X X X X X 0
         6'b000010: bk_o =  18'b101101101101000101; //  X X X X 0 X
         6'b000011: bk_o =  18'b101101101101001000; //  X X X X 1 0
         6'b000100: bk_o =  18'b101101101000101101; //  X X X 0 X X
         6'b000101: bk_o =  18'b101101101001101000; //  X X X 1 X 0
         6'b000110: bk_o =  18'b101101101001000101; //  X X X 1 0 X
         6'b000111: bk_o =  18'b101101101010001000; //  X X X 2 1 0
         6'b001000: bk_o =  18'b101101000101101101; //  X X 0 X X X
         6'b001001: bk_o =  18'b101101001101101000; //  X X 1 X X 0
         6'b001010: bk_o =  18'b101101001101000101; //  X X 1 X 0 X
         6'b001011: bk_o =  18'b101101010101001000; //  X X 2 X 1 0
         6'b001100: bk_o =  18'b101101001000101101; //  X X 1 0 X X
         6'b001101: bk_o =  18'b101101010001101000; //  X X 2 1 X 0
         6'b001110: bk_o =  18'b101101010001000101; //  X X 2 1 0 X
         6'b001111: bk_o =  18'b101101011010001000; //  X X 3 2 1 0
         6'b010000: bk_o =  18'b101000101101101101; //  X 0 X X X X
         6'b010001: bk_o =  18'b101001101101101000; //  X 1 X X X 0
         6'b010010: bk_o =  18'b101001101101000101; //  X 1 X X 0 X
         6'b010011: bk_o =  18'b101010101101001000; //  X 2 X X 1 0
         6'b010100: bk_o =  18'b101001101000101101; //  X 1 X 0 X X
         6'b010101: bk_o =  18'b101010101001101000; //  X 2 X 1 X 0
         6'b010110: bk_o =  18'b101010101001000101; //  X 2 X 1 0 X
         6'b010111: bk_o =  18'b101011101010001000; //  X 3 X 2 1 0
         6'b011000: bk_o =  18'b101001000101101101; //  X 1 0 X X X
         6'b011001: bk_o =  18'b101010001101101000; //  X 2 1 X X 0
         6'b011010: bk_o =  18'b101010001101000101; //  X 2 1 X 0 X
         6'b011011: bk_o =  18'b101011010101001000; //  X 3 2 X 1 0
         6'b011100: bk_o =  18'b101010001000101101; //  X 2 1 0 X X
         6'b011101: bk_o =  18'b101011010001101000; //  X 3 2 1 X 0
         6'b011110: bk_o =  18'b101011010001000101; //  X 3 2 1 0 X
         6'b011111: bk_o =  18'b101100011010001000; //  X 4 3 2 1 0
         6'b100000: bk_o =  18'b000101101101101101; //  0 X X X X X
         6'b100001: bk_o =  18'b001101101101101000; //  1 X X X X 0
         6'b100010: bk_o =  18'b001101101101000101; //  1 X X X 0 X
         6'b100011: bk_o =  18'b010101101101001000; //  2 X X X 1 0
         6'b100100: bk_o =  18'b001101101000101101; //  1 X X 0 X X
         6'b100101: bk_o =  18'b010101101001101000; //  2 X X 1 X 0
         6'b100110: bk_o =  18'b010101101001000101; //  2 X X 1 0 X
         6'b100111: bk_o =  18'b011101101010001000; //  3 X X 2 1 0
         6'b101000: bk_o =  18'b001101000101101101; //  1 X 0 X X X
         6'b101001: bk_o =  18'b010101001101101000; //  2 X 1 X X 0
         6'b101010: bk_o =  18'b010101001101000101; //  2 X 1 X 0 X
         6'b101011: bk_o =  18'b011101010101001000; //  3 X 2 X 1 0
         6'b101100: bk_o =  18'b010101001000101101; //  2 X 1 0 X X
         6'b101101: bk_o =  18'b011101010001101000; //  3 X 2 1 X 0
         6'b101110: bk_o =  18'b011101010001000101; //  3 X 2 1 0 X
         6'b101111: bk_o =  18'b100101011010001000; //  4 X 3 2 1 0
         6'b110000: bk_o =  18'b001000101101101101; //  1 0 X X X X
         6'b110001: bk_o =  18'b010001101101101000; //  2 1 X X X 0
         6'b110010: bk_o =  18'b010001101101000101; //  2 1 X X 0 X
         6'b110011: bk_o =  18'b011010101101001000; //  3 2 X X 1 0
         6'b110100: bk_o =  18'b010001101000101101; //  2 1 X 0 X X
         6'b110101: bk_o =  18'b011010101001101000; //  3 2 X 1 X 0
         6'b110110: bk_o =  18'b011010101001000101; //  3 2 X 1 0 X
         6'b110111: bk_o =  18'b100011101010001000; //  4 3 X 2 1 0
         6'b111000: bk_o =  18'b010001000101101101; //  2 1 0 X X X
         6'b111001: bk_o =  18'b011010001101101000; //  3 2 1 X X 0
         6'b111010: bk_o =  18'b011010001101000101; //  3 2 1 X 0 X
         6'b111011: bk_o =  18'b100011010101001000; //  4 3 2 X 1 0
         6'b111100: bk_o =  18'b011010001000101101; //  3 2 1 0 X X
         6'b111101: bk_o =  18'b100011010001101000; //  4 3 2 1 X 0
         6'b111110: bk_o =  18'b100011010001000101; //  4 3 2 1 0 X
         6'b111111: bk_o =  18'b101100011010001000; //  5 4 3 2 1 0
        default: bk_o= 'X;
    endcase

    // backward vec datapath
    always_comb
    unique case (vec_i) 
         6'b000000: bk_datapath_o =  18'b000000000000000000; //  X X X X X X
         6'b000001: bk_datapath_o =  18'b000000000000000000; //  X X X X X 0
         6'b000010: bk_datapath_o =  18'b000000000000000000; //  X X X X 0 X
         6'b000011: bk_datapath_o =  18'b000000000000001000; //  X X X X 1 0
         6'b000100: bk_datapath_o =  18'b000000000000000000; //  X X X 0 X X
         6'b000101: bk_datapath_o =  18'b000000000001000000; //  X X X 1 X 0
         6'b000110: bk_datapath_o =  18'b000000000001000000; //  X X X 1 0 X
         6'b000111: bk_datapath_o =  18'b000000000010001000; //  X X X 2 1 0
         6'b001000: bk_datapath_o =  18'b000000000000000000; //  X X 0 X X X
         6'b001001: bk_datapath_o =  18'b000000001000000000; //  X X 1 X X 0
         6'b001010: bk_datapath_o =  18'b000000001000000000; //  X X 1 X 0 X
         6'b001011: bk_datapath_o =  18'b000000010000001000; //  X X 2 X 1 0
         6'b001100: bk_datapath_o =  18'b000000001000000000; //  X X 1 0 X X
         6'b001101: bk_datapath_o =  18'b000000010001000000; //  X X 2 1 X 0
         6'b001110: bk_datapath_o =  18'b000000010001000000; //  X X 2 1 0 X
         6'b001111: bk_datapath_o =  18'b000000011010001000; //  X X 3 2 1 0
         6'b010000: bk_datapath_o =  18'b000000000000000000; //  X 0 X X X X
         6'b010001: bk_datapath_o =  18'b000001000000000000; //  X 1 X X X 0
         6'b010010: bk_datapath_o =  18'b000001000000000000; //  X 1 X X 0 X
         6'b010011: bk_datapath_o =  18'b000010000000001000; //  X 2 X X 1 0
         6'b010100: bk_datapath_o =  18'b000001000000000000; //  X 1 X 0 X X
         6'b010101: bk_datapath_o =  18'b000010000001000000; //  X 2 X 1 X 0
         6'b010110: bk_datapath_o =  18'b000010000001000000; //  X 2 X 1 0 X
         6'b010111: bk_datapath_o =  18'b000011000010001000; //  X 3 X 2 1 0
         6'b011000: bk_datapath_o =  18'b000001000000000000; //  X 1 0 X X X
         6'b011001: bk_datapath_o =  18'b000010001000000000; //  X 2 1 X X 0
         6'b011010: bk_datapath_o =  18'b000010001000000000; //  X 2 1 X 0 X
         6'b011011: bk_datapath_o =  18'b000011010000001000; //  X 3 2 X 1 0
         6'b011100: bk_datapath_o =  18'b000010001000000000; //  X 2 1 0 X X
         6'b011101: bk_datapath_o =  18'b000011010001000000; //  X 3 2 1 X 0
         6'b011110: bk_datapath_o =  18'b000011010001000000; //  X 3 2 1 0 X
         6'b011111: bk_datapath_o =  18'b000100011010001000; //  X 4 3 2 1 0
         6'b100000: bk_datapath_o =  18'b000000000000000000; //  0 X X X X X
         6'b100001: bk_datapath_o =  18'b001000000000000000; //  1 X X X X 0
         6'b100010: bk_datapath_o =  18'b001000000000000000; //  1 X X X 0 X
         6'b100011: bk_datapath_o =  18'b010000000000001000; //  2 X X X 1 0
         6'b100100: bk_datapath_o =  18'b001000000000000000; //  1 X X 0 X X
         6'b100101: bk_datapath_o =  18'b010000000001000000; //  2 X X 1 X 0
         6'b100110: bk_datapath_o =  18'b010000000001000000; //  2 X X 1 0 X
         6'b100111: bk_datapath_o =  18'b011000000010001000; //  3 X X 2 1 0
         6'b101000: bk_datapath_o =  18'b001000000000000000; //  1 X 0 X X X
         6'b101001: bk_datapath_o =  18'b010000001000000000; //  2 X 1 X X 0
         6'b101010: bk_datapath_o =  18'b010000001000000000; //  2 X 1 X 0 X
         6'b101011: bk_datapath_o =  18'b011000010000001000; //  3 X 2 X 1 0
         6'b101100: bk_datapath_o =  18'b010000001000000000; //  2 X 1 0 X X
         6'b101101: bk_datapath_o =  18'b011000010001000000; //  3 X 2 1 X 0
         6'b101110: bk_datapath_o =  18'b011000010001000000; //  3 X 2 1 0 X
         6'b101111: bk_datapath_o =  18'b100000011010001000; //  4 X 3 2 1 0
         6'b110000: bk_datapath_o =  18'b001000000000000000; //  1 0 X X X X
         6'b110001: bk_datapath_o =  18'b010001000000000000; //  2 1 X X X 0
         6'b110010: bk_datapath_o =  18'b010001000000000000; //  2 1 X X 0 X
         6'b110011: bk_datapath_o =  18'b011010000000001000; //  3 2 X X 1 0
         6'b110100: bk_datapath_o =  18'b010001000000000000; //  2 1 X 0 X X
         6'b110101: bk_datapath_o =  18'b011010000001000000; //  3 2 X 1 X 0
         6'b110110: bk_datapath_o =  18'b011010000001000000; //  3 2 X 1 0 X
         6'b110111: bk_datapath_o =  18'b100011000010001000; //  4 3 X 2 1 0
         6'b111000: bk_datapath_o =  18'b010001000000000000; //  2 1 0 X X X
         6'b111001: bk_datapath_o =  18'b011010001000000000; //  3 2 1 X X 0
         6'b111010: bk_datapath_o =  18'b011010001000000000; //  3 2 1 X 0 X
         6'b111011: bk_datapath_o =  18'b100011010000001000; //  4 3 2 X 1 0
         6'b111100: bk_datapath_o =  18'b011010001000000000; //  3 2 1 0 X X
         6'b111101: bk_datapath_o =  18'b100011010001000000; //  4 3 2 1 X 0
         6'b111110: bk_datapath_o =  18'b100011010001000000; //  4 3 2 1 0 X
         6'b111111: bk_datapath_o =  18'b101100011010001000; //  5 4 3 2 1 0
        default: bk_datapath_o= 'X;
    endcase

    // fwd vec
    always_comb
    unique case (vec_i) 
         6'b000000: fwd_o =  18'b101101101101101101; //  X X X X X X
         6'b000001: fwd_o =  18'b101101101101101000; //  X X X X X 0
         6'b000010: fwd_o =  18'b101101101101101001; //  X X X X X 1
         6'b000011: fwd_o =  18'b101101101101001000; //  X X X X 1 0
         6'b000100: fwd_o =  18'b101101101101101010; //  X X X X X 2
         6'b000101: fwd_o =  18'b101101101101010000; //  X X X X 2 0
         6'b000110: fwd_o =  18'b101101101101010001; //  X X X X 2 1
         6'b000111: fwd_o =  18'b101101101010001000; //  X X X 2 1 0
         6'b001000: fwd_o =  18'b101101101101101011; //  X X X X X 3
         6'b001001: fwd_o =  18'b101101101101011000; //  X X X X 3 0
         6'b001010: fwd_o =  18'b101101101101011001; //  X X X X 3 1
         6'b001011: fwd_o =  18'b101101101011001000; //  X X X 3 1 0
         6'b001100: fwd_o =  18'b101101101101011010; //  X X X X 3 2
         6'b001101: fwd_o =  18'b101101101011010000; //  X X X 3 2 0
         6'b001110: fwd_o =  18'b101101101011010001; //  X X X 3 2 1
         6'b001111: fwd_o =  18'b101101011010001000; //  X X 3 2 1 0
         6'b010000: fwd_o =  18'b101101101101101100; //  X X X X X 4
         6'b010001: fwd_o =  18'b101101101101100000; //  X X X X 4 0
         6'b010010: fwd_o =  18'b101101101101100001; //  X X X X 4 1
         6'b010011: fwd_o =  18'b101101101100001000; //  X X X 4 1 0
         6'b010100: fwd_o =  18'b101101101101100010; //  X X X X 4 2
         6'b010101: fwd_o =  18'b101101101100010000; //  X X X 4 2 0
         6'b010110: fwd_o =  18'b101101101100010001; //  X X X 4 2 1
         6'b010111: fwd_o =  18'b101101100010001000; //  X X 4 2 1 0
         6'b011000: fwd_o =  18'b101101101101100011; //  X X X X 4 3
         6'b011001: fwd_o =  18'b101101101100011000; //  X X X 4 3 0
         6'b011010: fwd_o =  18'b101101101100011001; //  X X X 4 3 1
         6'b011011: fwd_o =  18'b101101100011001000; //  X X 4 3 1 0
         6'b011100: fwd_o =  18'b101101101100011010; //  X X X 4 3 2
         6'b011101: fwd_o =  18'b101101100011010000; //  X X 4 3 2 0
         6'b011110: fwd_o =  18'b101101100011010001; //  X X 4 3 2 1
         6'b011111: fwd_o =  18'b101100011010001000; //  X 4 3 2 1 0
         6'b100000: fwd_o =  18'b100100100100100101; //  X X X X X 5
         6'b100001: fwd_o =  18'b100100100100101000; //  X X X X 5 0
         6'b100010: fwd_o =  18'b100100100100101001; //  X X X X 5 1
         6'b100011: fwd_o =  18'b100100100101001000; //  X X X 5 1 0
         6'b100100: fwd_o =  18'b100100100100101010; //  X X X X 5 2
         6'b100101: fwd_o =  18'b100100100101010000; //  X X X 5 2 0
         6'b100110: fwd_o =  18'b100100100101010001; //  X X X 5 2 1
         6'b100111: fwd_o =  18'b100100101010001000; //  X X 5 2 1 0
         6'b101000: fwd_o =  18'b100100100100101011; //  X X X X 5 3
         6'b101001: fwd_o =  18'b100100100101011000; //  X X X 5 3 0
         6'b101010: fwd_o =  18'b100100100101011001; //  X X X 5 3 1
         6'b101011: fwd_o =  18'b100100101011001000; //  X X 5 3 1 0
         6'b101100: fwd_o =  18'b100100100101011010; //  X X X 5 3 2
         6'b101101: fwd_o =  18'b100100101011010000; //  X X 5 3 2 0
         6'b101110: fwd_o =  18'b100100101011010001; //  X X 5 3 2 1
         6'b101111: fwd_o =  18'b100101011010001000; //  X 5 3 2 1 0
         6'b110000: fwd_o =  18'b011011011011101100; //  X X X X 5 4
         6'b110001: fwd_o =  18'b011011011101100000; //  X X X 5 4 0
         6'b110010: fwd_o =  18'b011011011101100001; //  X X X 5 4 1
         6'b110011: fwd_o =  18'b011011101100001000; //  X X 5 4 1 0
         6'b110100: fwd_o =  18'b011011011101100010; //  X X X 5 4 2
         6'b110101: fwd_o =  18'b011011101100010000; //  X X 5 4 2 0
         6'b110110: fwd_o =  18'b011011101100010001; //  X X 5 4 2 1
         6'b110111: fwd_o =  18'b011101100010001000; //  X 5 4 2 1 0
         6'b111000: fwd_o =  18'b010010010101100011; //  X X X 5 4 3
         6'b111001: fwd_o =  18'b010010101100011000; //  X X 5 4 3 0
         6'b111010: fwd_o =  18'b010010101100011001; //  X X 5 4 3 1
         6'b111011: fwd_o =  18'b010101100011001000; //  X 5 4 3 1 0
         6'b111100: fwd_o =  18'b001001101100011010; //  X X 5 4 3 2
         6'b111101: fwd_o =  18'b001101100011010000; //  X 5 4 3 2 0
         6'b111110: fwd_o =  18'b000101100011010001; //  X 5 4 3 2 1
         6'b111111: fwd_o =  18'b101100011010001000; //  5 4 3 2 1 0
        default: fwd_o= 'X;
    endcase

    // fwd datapath vec
    always_comb
    unique case (vec_i) 
         6'b000000: fwd_datapath_o =  18'b000000000000000000; //  X X X X X X
         6'b000001: fwd_datapath_o =  18'b000000000000000000; //  X X X X X 0
         6'b000010: fwd_datapath_o =  18'b000000000000000001; //  X X X X X 1
         6'b000011: fwd_datapath_o =  18'b000000000000000000; //  X X X X 0 0
         6'b000100: fwd_datapath_o =  18'b000000000000000010; //  X X X X X 2
         6'b000101: fwd_datapath_o =  18'b000000000000001000; //  X X X X 1 0
         6'b000110: fwd_datapath_o =  18'b000000000000001001; //  X X X X 1 1
         6'b000111: fwd_datapath_o =  18'b000000000000000000; //  X X X 0 0 0
         6'b001000: fwd_datapath_o =  18'b000000000000000011; //  X X X X X 3
         6'b001001: fwd_datapath_o =  18'b000000000000010000; //  X X X X 2 0
         6'b001010: fwd_datapath_o =  18'b000000000000010001; //  X X X X 2 1
         6'b001011: fwd_datapath_o =  18'b000000000001000000; //  X X X 1 0 0
         6'b001100: fwd_datapath_o =  18'b000000000000010010; //  X X X X 2 2
         6'b001101: fwd_datapath_o =  18'b000000000001001000; //  X X X 1 1 0
         6'b001110: fwd_datapath_o =  18'b000000000001001001; //  X X X 1 1 1
         6'b001111: fwd_datapath_o =  18'b000000000000000000; //  X X 0 0 0 0
         6'b010000: fwd_datapath_o =  18'b000000000000000100; //  X X X X X 4
         6'b010001: fwd_datapath_o =  18'b000000000000011000; //  X X X X 3 0
         6'b010010: fwd_datapath_o =  18'b000000000000011001; //  X X X X 3 1
         6'b010011: fwd_datapath_o =  18'b000000000010000000; //  X X X 2 0 0
         6'b010100: fwd_datapath_o =  18'b000000000000011010; //  X X X X 3 2
         6'b010101: fwd_datapath_o =  18'b000000000010001000; //  X X X 2 1 0
         6'b010110: fwd_datapath_o =  18'b000000000010001001; //  X X X 2 1 1
         6'b010111: fwd_datapath_o =  18'b000000001000000000; //  X X 1 0 0 0
         6'b011000: fwd_datapath_o =  18'b000000000000011011; //  X X X X 3 3
         6'b011001: fwd_datapath_o =  18'b000000000010010000; //  X X X 2 2 0
         6'b011010: fwd_datapath_o =  18'b000000000010010001; //  X X X 2 2 1
         6'b011011: fwd_datapath_o =  18'b000000001001000000; //  X X 1 1 0 0
         6'b011100: fwd_datapath_o =  18'b000000000010010010; //  X X X 2 2 2
         6'b011101: fwd_datapath_o =  18'b000000001001001000; //  X X 1 1 1 0
         6'b011110: fwd_datapath_o =  18'b000000001001001001; //  X X 1 1 1 1
         6'b011111: fwd_datapath_o =  18'b000000000000000000; //  X 0 0 0 0 0
         6'b100000: fwd_datapath_o =  18'b000000000000000101; //  X X X X X 5
         6'b100001: fwd_datapath_o =  18'b000000000000100000; //  X X X X 4 0
         6'b100010: fwd_datapath_o =  18'b000000000000100001; //  X X X X 4 1
         6'b100011: fwd_datapath_o =  18'b000000000011000000; //  X X X 3 0 0
         6'b100100: fwd_datapath_o =  18'b000000000000100010; //  X X X X 4 2
         6'b100101: fwd_datapath_o =  18'b000000000011001000; //  X X X 3 1 0
         6'b100110: fwd_datapath_o =  18'b000000000011001001; //  X X X 3 1 1
         6'b100111: fwd_datapath_o =  18'b000000010000000000; //  X X 2 0 0 0
         6'b101000: fwd_datapath_o =  18'b000000000000100011; //  X X X X 4 3
         6'b101001: fwd_datapath_o =  18'b000000000011010000; //  X X X 3 2 0
         6'b101010: fwd_datapath_o =  18'b000000000011010001; //  X X X 3 2 1
         6'b101011: fwd_datapath_o =  18'b000000010001000000; //  X X 2 1 0 0
         6'b101100: fwd_datapath_o =  18'b000000000011010010; //  X X X 3 2 2
         6'b101101: fwd_datapath_o =  18'b000000010001001000; //  X X 2 1 1 0
         6'b101110: fwd_datapath_o =  18'b000000010001001001; //  X X 2 1 1 1
         6'b101111: fwd_datapath_o =  18'b000001000000000000; //  X 1 0 0 0 0
         6'b110000: fwd_datapath_o =  18'b000000000000100100; //  X X X X 4 4
         6'b110001: fwd_datapath_o =  18'b000000000011011000; //  X X X 3 3 0
         6'b110010: fwd_datapath_o =  18'b000000000011011001; //  X X X 3 3 1
         6'b110011: fwd_datapath_o =  18'b000000010010000000; //  X X 2 2 0 0
         6'b110100: fwd_datapath_o =  18'b000000000011011010; //  X X X 3 3 2
         6'b110101: fwd_datapath_o =  18'b000000010010001000; //  X X 2 2 1 0
         6'b110110: fwd_datapath_o =  18'b000000010010001001; //  X X 2 2 1 1
         6'b110111: fwd_datapath_o =  18'b000001001000000000; //  X 1 1 0 0 0
         6'b111000: fwd_datapath_o =  18'b000000000011011011; //  X X X 3 3 3
         6'b111001: fwd_datapath_o =  18'b000000010010010000; //  X X 2 2 2 0
         6'b111010: fwd_datapath_o =  18'b000000010010010001; //  X X 2 2 2 1
         6'b111011: fwd_datapath_o =  18'b000001001001000000; //  X 1 1 1 0 0
         6'b111100: fwd_datapath_o =  18'b000000010010010010; //  X X 2 2 2 2
         6'b111101: fwd_datapath_o =  18'b000001001001001000; //  X 1 1 1 1 0
         6'b111110: fwd_datapath_o =  18'b000001001001001001; //  X 1 1 1 1 1
         6'b111111: fwd_datapath_o =  18'b000000000000000000; //  0 0 0 0 0 0
        default: fwd_datapath_o= 'X;
    endcase
  end

if (vec_size_lp == 7)
  begin
    // backward vec
    always_comb
    unique case (vec_i) 
         7'b0000000: bk_o =  21'b110110110110110110110; //  X X X X X X X
         7'b0000001: bk_o =  21'b110110110110110110000; //  X X X X X X 0
         7'b0000010: bk_o =  21'b110110110110110000110; //  X X X X X 0 X
         7'b0000011: bk_o =  21'b110110110110110001000; //  X X X X X 1 0
         7'b0000100: bk_o =  21'b110110110110000110110; //  X X X X 0 X X
         7'b0000101: bk_o =  21'b110110110110001110000; //  X X X X 1 X 0
         7'b0000110: bk_o =  21'b110110110110001000110; //  X X X X 1 0 X
         7'b0000111: bk_o =  21'b110110110110010001000; //  X X X X 2 1 0
         7'b0001000: bk_o =  21'b110110110000110110110; //  X X X 0 X X X
         7'b0001001: bk_o =  21'b110110110001110110000; //  X X X 1 X X 0
         7'b0001010: bk_o =  21'b110110110001110000110; //  X X X 1 X 0 X
         7'b0001011: bk_o =  21'b110110110010110001000; //  X X X 2 X 1 0
         7'b0001100: bk_o =  21'b110110110001000110110; //  X X X 1 0 X X
         7'b0001101: bk_o =  21'b110110110010001110000; //  X X X 2 1 X 0
         7'b0001110: bk_o =  21'b110110110010001000110; //  X X X 2 1 0 X
         7'b0001111: bk_o =  21'b110110110011010001000; //  X X X 3 2 1 0
         7'b0010000: bk_o =  21'b110110000110110110110; //  X X 0 X X X X
         7'b0010001: bk_o =  21'b110110001110110110000; //  X X 1 X X X 0
         7'b0010010: bk_o =  21'b110110001110110000110; //  X X 1 X X 0 X
         7'b0010011: bk_o =  21'b110110010110110001000; //  X X 2 X X 1 0
         7'b0010100: bk_o =  21'b110110001110000110110; //  X X 1 X 0 X X
         7'b0010101: bk_o =  21'b110110010110001110000; //  X X 2 X 1 X 0
         7'b0010110: bk_o =  21'b110110010110001000110; //  X X 2 X 1 0 X
         7'b0010111: bk_o =  21'b110110011110010001000; //  X X 3 X 2 1 0
         7'b0011000: bk_o =  21'b110110001000110110110; //  X X 1 0 X X X
         7'b0011001: bk_o =  21'b110110010001110110000; //  X X 2 1 X X 0
         7'b0011010: bk_o =  21'b110110010001110000110; //  X X 2 1 X 0 X
         7'b0011011: bk_o =  21'b110110011010110001000; //  X X 3 2 X 1 0
         7'b0011100: bk_o =  21'b110110010001000110110; //  X X 2 1 0 X X
         7'b0011101: bk_o =  21'b110110011010001110000; //  X X 3 2 1 X 0
         7'b0011110: bk_o =  21'b110110011010001000110; //  X X 3 2 1 0 X
         7'b0011111: bk_o =  21'b110110100011010001000; //  X X 4 3 2 1 0
         7'b0100000: bk_o =  21'b110000110110110110110; //  X 0 X X X X X
         7'b0100001: bk_o =  21'b110001110110110110000; //  X 1 X X X X 0
         7'b0100010: bk_o =  21'b110001110110110000110; //  X 1 X X X 0 X
         7'b0100011: bk_o =  21'b110010110110110001000; //  X 2 X X X 1 0
         7'b0100100: bk_o =  21'b110001110110000110110; //  X 1 X X 0 X X
         7'b0100101: bk_o =  21'b110010110110001110000; //  X 2 X X 1 X 0
         7'b0100110: bk_o =  21'b110010110110001000110; //  X 2 X X 1 0 X
         7'b0100111: bk_o =  21'b110011110110010001000; //  X 3 X X 2 1 0
         7'b0101000: bk_o =  21'b110001110000110110110; //  X 1 X 0 X X X
         7'b0101001: bk_o =  21'b110010110001110110000; //  X 2 X 1 X X 0
         7'b0101010: bk_o =  21'b110010110001110000110; //  X 2 X 1 X 0 X
         7'b0101011: bk_o =  21'b110011110010110001000; //  X 3 X 2 X 1 0
         7'b0101100: bk_o =  21'b110010110001000110110; //  X 2 X 1 0 X X
         7'b0101101: bk_o =  21'b110011110010001110000; //  X 3 X 2 1 X 0
         7'b0101110: bk_o =  21'b110011110010001000110; //  X 3 X 2 1 0 X
         7'b0101111: bk_o =  21'b110100110011010001000; //  X 4 X 3 2 1 0
         7'b0110000: bk_o =  21'b110001000110110110110; //  X 1 0 X X X X
         7'b0110001: bk_o =  21'b110010001110110110000; //  X 2 1 X X X 0
         7'b0110010: bk_o =  21'b110010001110110000110; //  X 2 1 X X 0 X
         7'b0110011: bk_o =  21'b110011010110110001000; //  X 3 2 X X 1 0
         7'b0110100: bk_o =  21'b110010001110000110110; //  X 2 1 X 0 X X
         7'b0110101: bk_o =  21'b110011010110001110000; //  X 3 2 X 1 X 0
         7'b0110110: bk_o =  21'b110011010110001000110; //  X 3 2 X 1 0 X
         7'b0110111: bk_o =  21'b110100011110010001000; //  X 4 3 X 2 1 0
         7'b0111000: bk_o =  21'b110010001000110110110; //  X 2 1 0 X X X
         7'b0111001: bk_o =  21'b110011010001110110000; //  X 3 2 1 X X 0
         7'b0111010: bk_o =  21'b110011010001110000110; //  X 3 2 1 X 0 X
         7'b0111011: bk_o =  21'b110100011010110001000; //  X 4 3 2 X 1 0
         7'b0111100: bk_o =  21'b110011010001000110110; //  X 3 2 1 0 X X
         7'b0111101: bk_o =  21'b110100011010001110000; //  X 4 3 2 1 X 0
         7'b0111110: bk_o =  21'b110100011010001000110; //  X 4 3 2 1 0 X
         7'b0111111: bk_o =  21'b110101100011010001000; //  X 5 4 3 2 1 0
         7'b1000000: bk_o =  21'b000110110110110110110; //  0 X X X X X X
         7'b1000001: bk_o =  21'b001110110110110110000; //  1 X X X X X 0
         7'b1000010: bk_o =  21'b001110110110110000110; //  1 X X X X 0 X
         7'b1000011: bk_o =  21'b010110110110110001000; //  2 X X X X 1 0
         7'b1000100: bk_o =  21'b001110110110000110110; //  1 X X X 0 X X
         7'b1000101: bk_o =  21'b010110110110001110000; //  2 X X X 1 X 0
         7'b1000110: bk_o =  21'b010110110110001000110; //  2 X X X 1 0 X
         7'b1000111: bk_o =  21'b011110110110010001000; //  3 X X X 2 1 0
         7'b1001000: bk_o =  21'b001110110000110110110; //  1 X X 0 X X X
         7'b1001001: bk_o =  21'b010110110001110110000; //  2 X X 1 X X 0
         7'b1001010: bk_o =  21'b010110110001110000110; //  2 X X 1 X 0 X
         7'b1001011: bk_o =  21'b011110110010110001000; //  3 X X 2 X 1 0
         7'b1001100: bk_o =  21'b010110110001000110110; //  2 X X 1 0 X X
         7'b1001101: bk_o =  21'b011110110010001110000; //  3 X X 2 1 X 0
         7'b1001110: bk_o =  21'b011110110010001000110; //  3 X X 2 1 0 X
         7'b1001111: bk_o =  21'b100110110011010001000; //  4 X X 3 2 1 0
         7'b1010000: bk_o =  21'b001110000110110110110; //  1 X 0 X X X X
         7'b1010001: bk_o =  21'b010110001110110110000; //  2 X 1 X X X 0
         7'b1010010: bk_o =  21'b010110001110110000110; //  2 X 1 X X 0 X
         7'b1010011: bk_o =  21'b011110010110110001000; //  3 X 2 X X 1 0
         7'b1010100: bk_o =  21'b010110001110000110110; //  2 X 1 X 0 X X
         7'b1010101: bk_o =  21'b011110010110001110000; //  3 X 2 X 1 X 0
         7'b1010110: bk_o =  21'b011110010110001000110; //  3 X 2 X 1 0 X
         7'b1010111: bk_o =  21'b100110011110010001000; //  4 X 3 X 2 1 0
         7'b1011000: bk_o =  21'b010110001000110110110; //  2 X 1 0 X X X
         7'b1011001: bk_o =  21'b011110010001110110000; //  3 X 2 1 X X 0
         7'b1011010: bk_o =  21'b011110010001110000110; //  3 X 2 1 X 0 X
         7'b1011011: bk_o =  21'b100110011010110001000; //  4 X 3 2 X 1 0
         7'b1011100: bk_o =  21'b011110010001000110110; //  3 X 2 1 0 X X
         7'b1011101: bk_o =  21'b100110011010001110000; //  4 X 3 2 1 X 0
         7'b1011110: bk_o =  21'b100110011010001000110; //  4 X 3 2 1 0 X
         7'b1011111: bk_o =  21'b101110100011010001000; //  5 X 4 3 2 1 0
         7'b1100000: bk_o =  21'b001000110110110110110; //  1 0 X X X X X
         7'b1100001: bk_o =  21'b010001110110110110000; //  2 1 X X X X 0
         7'b1100010: bk_o =  21'b010001110110110000110; //  2 1 X X X 0 X
         7'b1100011: bk_o =  21'b011010110110110001000; //  3 2 X X X 1 0
         7'b1100100: bk_o =  21'b010001110110000110110; //  2 1 X X 0 X X
         7'b1100101: bk_o =  21'b011010110110001110000; //  3 2 X X 1 X 0
         7'b1100110: bk_o =  21'b011010110110001000110; //  3 2 X X 1 0 X
         7'b1100111: bk_o =  21'b100011110110010001000; //  4 3 X X 2 1 0
         7'b1101000: bk_o =  21'b010001110000110110110; //  2 1 X 0 X X X
         7'b1101001: bk_o =  21'b011010110001110110000; //  3 2 X 1 X X 0
         7'b1101010: bk_o =  21'b011010110001110000110; //  3 2 X 1 X 0 X
         7'b1101011: bk_o =  21'b100011110010110001000; //  4 3 X 2 X 1 0
         7'b1101100: bk_o =  21'b011010110001000110110; //  3 2 X 1 0 X X
         7'b1101101: bk_o =  21'b100011110010001110000; //  4 3 X 2 1 X 0
         7'b1101110: bk_o =  21'b100011110010001000110; //  4 3 X 2 1 0 X
         7'b1101111: bk_o =  21'b101100110011010001000; //  5 4 X 3 2 1 0
         7'b1110000: bk_o =  21'b010001000110110110110; //  2 1 0 X X X X
         7'b1110001: bk_o =  21'b011010001110110110000; //  3 2 1 X X X 0
         7'b1110010: bk_o =  21'b011010001110110000110; //  3 2 1 X X 0 X
         7'b1110011: bk_o =  21'b100011010110110001000; //  4 3 2 X X 1 0
         7'b1110100: bk_o =  21'b011010001110000110110; //  3 2 1 X 0 X X
         7'b1110101: bk_o =  21'b100011010110001110000; //  4 3 2 X 1 X 0
         7'b1110110: bk_o =  21'b100011010110001000110; //  4 3 2 X 1 0 X
         7'b1110111: bk_o =  21'b101100011110010001000; //  5 4 3 X 2 1 0
         7'b1111000: bk_o =  21'b011010001000110110110; //  3 2 1 0 X X X
         7'b1111001: bk_o =  21'b100011010001110110000; //  4 3 2 1 X X 0
         7'b1111010: bk_o =  21'b100011010001110000110; //  4 3 2 1 X 0 X
         7'b1111011: bk_o =  21'b101100011010110001000; //  5 4 3 2 X 1 0
         7'b1111100: bk_o =  21'b100011010001000110110; //  4 3 2 1 0 X X
         7'b1111101: bk_o =  21'b101100011010001110000; //  5 4 3 2 1 X 0
         7'b1111110: bk_o =  21'b101100011010001000110; //  5 4 3 2 1 0 X
         7'b1111111: bk_o =  21'b110101100011010001000; //  6 5 4 3 2 1 0
        default: bk_o= 'X;
    endcase

    // backward vec datapath
    always_comb
    unique case (vec_i) 
         7'b0000000: bk_datapath_o =  21'b000000000000000000000; //  X X X X X X X
         7'b0000001: bk_datapath_o =  21'b000000000000000000000; //  X X X X X X 0
         7'b0000010: bk_datapath_o =  21'b000000000000000000000; //  X X X X X 0 X
         7'b0000011: bk_datapath_o =  21'b000000000000000001000; //  X X X X X 1 0
         7'b0000100: bk_datapath_o =  21'b000000000000000000000; //  X X X X 0 X X
         7'b0000101: bk_datapath_o =  21'b000000000000001000000; //  X X X X 1 X 0
         7'b0000110: bk_datapath_o =  21'b000000000000001000000; //  X X X X 1 0 X
         7'b0000111: bk_datapath_o =  21'b000000000000010001000; //  X X X X 2 1 0
         7'b0001000: bk_datapath_o =  21'b000000000000000000000; //  X X X 0 X X X
         7'b0001001: bk_datapath_o =  21'b000000000001000000000; //  X X X 1 X X 0
         7'b0001010: bk_datapath_o =  21'b000000000001000000000; //  X X X 1 X 0 X
         7'b0001011: bk_datapath_o =  21'b000000000010000001000; //  X X X 2 X 1 0
         7'b0001100: bk_datapath_o =  21'b000000000001000000000; //  X X X 1 0 X X
         7'b0001101: bk_datapath_o =  21'b000000000010001000000; //  X X X 2 1 X 0
         7'b0001110: bk_datapath_o =  21'b000000000010001000000; //  X X X 2 1 0 X
         7'b0001111: bk_datapath_o =  21'b000000000011010001000; //  X X X 3 2 1 0
         7'b0010000: bk_datapath_o =  21'b000000000000000000000; //  X X 0 X X X X
         7'b0010001: bk_datapath_o =  21'b000000001000000000000; //  X X 1 X X X 0
         7'b0010010: bk_datapath_o =  21'b000000001000000000000; //  X X 1 X X 0 X
         7'b0010011: bk_datapath_o =  21'b000000010000000001000; //  X X 2 X X 1 0
         7'b0010100: bk_datapath_o =  21'b000000001000000000000; //  X X 1 X 0 X X
         7'b0010101: bk_datapath_o =  21'b000000010000001000000; //  X X 2 X 1 X 0
         7'b0010110: bk_datapath_o =  21'b000000010000001000000; //  X X 2 X 1 0 X
         7'b0010111: bk_datapath_o =  21'b000000011000010001000; //  X X 3 X 2 1 0
         7'b0011000: bk_datapath_o =  21'b000000001000000000000; //  X X 1 0 X X X
         7'b0011001: bk_datapath_o =  21'b000000010001000000000; //  X X 2 1 X X 0
         7'b0011010: bk_datapath_o =  21'b000000010001000000000; //  X X 2 1 X 0 X
         7'b0011011: bk_datapath_o =  21'b000000011010000001000; //  X X 3 2 X 1 0
         7'b0011100: bk_datapath_o =  21'b000000010001000000000; //  X X 2 1 0 X X
         7'b0011101: bk_datapath_o =  21'b000000011010001000000; //  X X 3 2 1 X 0
         7'b0011110: bk_datapath_o =  21'b000000011010001000000; //  X X 3 2 1 0 X
         7'b0011111: bk_datapath_o =  21'b000000100011010001000; //  X X 4 3 2 1 0
         7'b0100000: bk_datapath_o =  21'b000000000000000000000; //  X 0 X X X X X
         7'b0100001: bk_datapath_o =  21'b000001000000000000000; //  X 1 X X X X 0
         7'b0100010: bk_datapath_o =  21'b000001000000000000000; //  X 1 X X X 0 X
         7'b0100011: bk_datapath_o =  21'b000010000000000001000; //  X 2 X X X 1 0
         7'b0100100: bk_datapath_o =  21'b000001000000000000000; //  X 1 X X 0 X X
         7'b0100101: bk_datapath_o =  21'b000010000000001000000; //  X 2 X X 1 X 0
         7'b0100110: bk_datapath_o =  21'b000010000000001000000; //  X 2 X X 1 0 X
         7'b0100111: bk_datapath_o =  21'b000011000000010001000; //  X 3 X X 2 1 0
         7'b0101000: bk_datapath_o =  21'b000001000000000000000; //  X 1 X 0 X X X
         7'b0101001: bk_datapath_o =  21'b000010000001000000000; //  X 2 X 1 X X 0
         7'b0101010: bk_datapath_o =  21'b000010000001000000000; //  X 2 X 1 X 0 X
         7'b0101011: bk_datapath_o =  21'b000011000010000001000; //  X 3 X 2 X 1 0
         7'b0101100: bk_datapath_o =  21'b000010000001000000000; //  X 2 X 1 0 X X
         7'b0101101: bk_datapath_o =  21'b000011000010001000000; //  X 3 X 2 1 X 0
         7'b0101110: bk_datapath_o =  21'b000011000010001000000; //  X 3 X 2 1 0 X
         7'b0101111: bk_datapath_o =  21'b000100000011010001000; //  X 4 X 3 2 1 0
         7'b0110000: bk_datapath_o =  21'b000001000000000000000; //  X 1 0 X X X X
         7'b0110001: bk_datapath_o =  21'b000010001000000000000; //  X 2 1 X X X 0
         7'b0110010: bk_datapath_o =  21'b000010001000000000000; //  X 2 1 X X 0 X
         7'b0110011: bk_datapath_o =  21'b000011010000000001000; //  X 3 2 X X 1 0
         7'b0110100: bk_datapath_o =  21'b000010001000000000000; //  X 2 1 X 0 X X
         7'b0110101: bk_datapath_o =  21'b000011010000001000000; //  X 3 2 X 1 X 0
         7'b0110110: bk_datapath_o =  21'b000011010000001000000; //  X 3 2 X 1 0 X
         7'b0110111: bk_datapath_o =  21'b000100011000010001000; //  X 4 3 X 2 1 0
         7'b0111000: bk_datapath_o =  21'b000010001000000000000; //  X 2 1 0 X X X
         7'b0111001: bk_datapath_o =  21'b000011010001000000000; //  X 3 2 1 X X 0
         7'b0111010: bk_datapath_o =  21'b000011010001000000000; //  X 3 2 1 X 0 X
         7'b0111011: bk_datapath_o =  21'b000100011010000001000; //  X 4 3 2 X 1 0
         7'b0111100: bk_datapath_o =  21'b000011010001000000000; //  X 3 2 1 0 X X
         7'b0111101: bk_datapath_o =  21'b000100011010001000000; //  X 4 3 2 1 X 0
         7'b0111110: bk_datapath_o =  21'b000100011010001000000; //  X 4 3 2 1 0 X
         7'b0111111: bk_datapath_o =  21'b000101100011010001000; //  X 5 4 3 2 1 0
         7'b1000000: bk_datapath_o =  21'b000000000000000000000; //  0 X X X X X X
         7'b1000001: bk_datapath_o =  21'b001000000000000000000; //  1 X X X X X 0
         7'b1000010: bk_datapath_o =  21'b001000000000000000000; //  1 X X X X 0 X
         7'b1000011: bk_datapath_o =  21'b010000000000000001000; //  2 X X X X 1 0
         7'b1000100: bk_datapath_o =  21'b001000000000000000000; //  1 X X X 0 X X
         7'b1000101: bk_datapath_o =  21'b010000000000001000000; //  2 X X X 1 X 0
         7'b1000110: bk_datapath_o =  21'b010000000000001000000; //  2 X X X 1 0 X
         7'b1000111: bk_datapath_o =  21'b011000000000010001000; //  3 X X X 2 1 0
         7'b1001000: bk_datapath_o =  21'b001000000000000000000; //  1 X X 0 X X X
         7'b1001001: bk_datapath_o =  21'b010000000001000000000; //  2 X X 1 X X 0
         7'b1001010: bk_datapath_o =  21'b010000000001000000000; //  2 X X 1 X 0 X
         7'b1001011: bk_datapath_o =  21'b011000000010000001000; //  3 X X 2 X 1 0
         7'b1001100: bk_datapath_o =  21'b010000000001000000000; //  2 X X 1 0 X X
         7'b1001101: bk_datapath_o =  21'b011000000010001000000; //  3 X X 2 1 X 0
         7'b1001110: bk_datapath_o =  21'b011000000010001000000; //  3 X X 2 1 0 X
         7'b1001111: bk_datapath_o =  21'b100000000011010001000; //  4 X X 3 2 1 0
         7'b1010000: bk_datapath_o =  21'b001000000000000000000; //  1 X 0 X X X X
         7'b1010001: bk_datapath_o =  21'b010000001000000000000; //  2 X 1 X X X 0
         7'b1010010: bk_datapath_o =  21'b010000001000000000000; //  2 X 1 X X 0 X
         7'b1010011: bk_datapath_o =  21'b011000010000000001000; //  3 X 2 X X 1 0
         7'b1010100: bk_datapath_o =  21'b010000001000000000000; //  2 X 1 X 0 X X
         7'b1010101: bk_datapath_o =  21'b011000010000001000000; //  3 X 2 X 1 X 0
         7'b1010110: bk_datapath_o =  21'b011000010000001000000; //  3 X 2 X 1 0 X
         7'b1010111: bk_datapath_o =  21'b100000011000010001000; //  4 X 3 X 2 1 0
         7'b1011000: bk_datapath_o =  21'b010000001000000000000; //  2 X 1 0 X X X
         7'b1011001: bk_datapath_o =  21'b011000010001000000000; //  3 X 2 1 X X 0
         7'b1011010: bk_datapath_o =  21'b011000010001000000000; //  3 X 2 1 X 0 X
         7'b1011011: bk_datapath_o =  21'b100000011010000001000; //  4 X 3 2 X 1 0
         7'b1011100: bk_datapath_o =  21'b011000010001000000000; //  3 X 2 1 0 X X
         7'b1011101: bk_datapath_o =  21'b100000011010001000000; //  4 X 3 2 1 X 0
         7'b1011110: bk_datapath_o =  21'b100000011010001000000; //  4 X 3 2 1 0 X
         7'b1011111: bk_datapath_o =  21'b101000100011010001000; //  5 X 4 3 2 1 0
         7'b1100000: bk_datapath_o =  21'b001000000000000000000; //  1 0 X X X X X
         7'b1100001: bk_datapath_o =  21'b010001000000000000000; //  2 1 X X X X 0
         7'b1100010: bk_datapath_o =  21'b010001000000000000000; //  2 1 X X X 0 X
         7'b1100011: bk_datapath_o =  21'b011010000000000001000; //  3 2 X X X 1 0
         7'b1100100: bk_datapath_o =  21'b010001000000000000000; //  2 1 X X 0 X X
         7'b1100101: bk_datapath_o =  21'b011010000000001000000; //  3 2 X X 1 X 0
         7'b1100110: bk_datapath_o =  21'b011010000000001000000; //  3 2 X X 1 0 X
         7'b1100111: bk_datapath_o =  21'b100011000000010001000; //  4 3 X X 2 1 0
         7'b1101000: bk_datapath_o =  21'b010001000000000000000; //  2 1 X 0 X X X
         7'b1101001: bk_datapath_o =  21'b011010000001000000000; //  3 2 X 1 X X 0
         7'b1101010: bk_datapath_o =  21'b011010000001000000000; //  3 2 X 1 X 0 X
         7'b1101011: bk_datapath_o =  21'b100011000010000001000; //  4 3 X 2 X 1 0
         7'b1101100: bk_datapath_o =  21'b011010000001000000000; //  3 2 X 1 0 X X
         7'b1101101: bk_datapath_o =  21'b100011000010001000000; //  4 3 X 2 1 X 0
         7'b1101110: bk_datapath_o =  21'b100011000010001000000; //  4 3 X 2 1 0 X
         7'b1101111: bk_datapath_o =  21'b101100000011010001000; //  5 4 X 3 2 1 0
         7'b1110000: bk_datapath_o =  21'b010001000000000000000; //  2 1 0 X X X X
         7'b1110001: bk_datapath_o =  21'b011010001000000000000; //  3 2 1 X X X 0
         7'b1110010: bk_datapath_o =  21'b011010001000000000000; //  3 2 1 X X 0 X
         7'b1110011: bk_datapath_o =  21'b100011010000000001000; //  4 3 2 X X 1 0
         7'b1110100: bk_datapath_o =  21'b011010001000000000000; //  3 2 1 X 0 X X
         7'b1110101: bk_datapath_o =  21'b100011010000001000000; //  4 3 2 X 1 X 0
         7'b1110110: bk_datapath_o =  21'b100011010000001000000; //  4 3 2 X 1 0 X
         7'b1110111: bk_datapath_o =  21'b101100011000010001000; //  5 4 3 X 2 1 0
         7'b1111000: bk_datapath_o =  21'b011010001000000000000; //  3 2 1 0 X X X
         7'b1111001: bk_datapath_o =  21'b100011010001000000000; //  4 3 2 1 X X 0
         7'b1111010: bk_datapath_o =  21'b100011010001000000000; //  4 3 2 1 X 0 X
         7'b1111011: bk_datapath_o =  21'b101100011010000001000; //  5 4 3 2 X 1 0
         7'b1111100: bk_datapath_o =  21'b100011010001000000000; //  4 3 2 1 0 X X
         7'b1111101: bk_datapath_o =  21'b101100011010001000000; //  5 4 3 2 1 X 0
         7'b1111110: bk_datapath_o =  21'b101100011010001000000; //  5 4 3 2 1 0 X
         7'b1111111: bk_datapath_o =  21'b110101100011010001000; //  6 5 4 3 2 1 0
        default: bk_datapath_o= 'X;
    endcase

    // fwd vec
    always_comb
    unique case (vec_i) 
         7'b0000000: fwd_o =  21'b110110110110110110110; //  X X X X X X X
         7'b0000001: fwd_o =  21'b110110110110110110000; //  X X X X X X 0
         7'b0000010: fwd_o =  21'b110110110110110110001; //  X X X X X X 1
         7'b0000011: fwd_o =  21'b110110110110110001000; //  X X X X X 1 0
         7'b0000100: fwd_o =  21'b110110110110110110010; //  X X X X X X 2
         7'b0000101: fwd_o =  21'b110110110110110010000; //  X X X X X 2 0
         7'b0000110: fwd_o =  21'b110110110110110010001; //  X X X X X 2 1
         7'b0000111: fwd_o =  21'b110110110110010001000; //  X X X X 2 1 0
         7'b0001000: fwd_o =  21'b110110110110110110011; //  X X X X X X 3
         7'b0001001: fwd_o =  21'b110110110110110011000; //  X X X X X 3 0
         7'b0001010: fwd_o =  21'b110110110110110011001; //  X X X X X 3 1
         7'b0001011: fwd_o =  21'b110110110110011001000; //  X X X X 3 1 0
         7'b0001100: fwd_o =  21'b110110110110110011010; //  X X X X X 3 2
         7'b0001101: fwd_o =  21'b110110110110011010000; //  X X X X 3 2 0
         7'b0001110: fwd_o =  21'b110110110110011010001; //  X X X X 3 2 1
         7'b0001111: fwd_o =  21'b110110110011010001000; //  X X X 3 2 1 0
         7'b0010000: fwd_o =  21'b110110110110110110100; //  X X X X X X 4
         7'b0010001: fwd_o =  21'b110110110110110100000; //  X X X X X 4 0
         7'b0010010: fwd_o =  21'b110110110110110100001; //  X X X X X 4 1
         7'b0010011: fwd_o =  21'b110110110110100001000; //  X X X X 4 1 0
         7'b0010100: fwd_o =  21'b110110110110110100010; //  X X X X X 4 2
         7'b0010101: fwd_o =  21'b110110110110100010000; //  X X X X 4 2 0
         7'b0010110: fwd_o =  21'b110110110110100010001; //  X X X X 4 2 1
         7'b0010111: fwd_o =  21'b110110110100010001000; //  X X X 4 2 1 0
         7'b0011000: fwd_o =  21'b110110110110110100011; //  X X X X X 4 3
         7'b0011001: fwd_o =  21'b110110110110100011000; //  X X X X 4 3 0
         7'b0011010: fwd_o =  21'b110110110110100011001; //  X X X X 4 3 1
         7'b0011011: fwd_o =  21'b110110110100011001000; //  X X X 4 3 1 0
         7'b0011100: fwd_o =  21'b110110110110100011010; //  X X X X 4 3 2
         7'b0011101: fwd_o =  21'b110110110100011010000; //  X X X 4 3 2 0
         7'b0011110: fwd_o =  21'b110110110100011010001; //  X X X 4 3 2 1
         7'b0011111: fwd_o =  21'b110110100011010001000; //  X X 4 3 2 1 0
         7'b0100000: fwd_o =  21'b110110110110110110101; //  X X X X X X 5
         7'b0100001: fwd_o =  21'b110110110110110101000; //  X X X X X 5 0
         7'b0100010: fwd_o =  21'b110110110110110101001; //  X X X X X 5 1
         7'b0100011: fwd_o =  21'b110110110110101001000; //  X X X X 5 1 0
         7'b0100100: fwd_o =  21'b110110110110110101010; //  X X X X X 5 2
         7'b0100101: fwd_o =  21'b110110110110101010000; //  X X X X 5 2 0
         7'b0100110: fwd_o =  21'b110110110110101010001; //  X X X X 5 2 1
         7'b0100111: fwd_o =  21'b110110110101010001000; //  X X X 5 2 1 0
         7'b0101000: fwd_o =  21'b110110110110110101011; //  X X X X X 5 3
         7'b0101001: fwd_o =  21'b110110110110101011000; //  X X X X 5 3 0
         7'b0101010: fwd_o =  21'b110110110110101011001; //  X X X X 5 3 1
         7'b0101011: fwd_o =  21'b110110110101011001000; //  X X X 5 3 1 0
         7'b0101100: fwd_o =  21'b110110110110101011010; //  X X X X 5 3 2
         7'b0101101: fwd_o =  21'b110110110101011010000; //  X X X 5 3 2 0
         7'b0101110: fwd_o =  21'b110110110101011010001; //  X X X 5 3 2 1
         7'b0101111: fwd_o =  21'b110110101011010001000; //  X X 5 3 2 1 0
         7'b0110000: fwd_o =  21'b110110110110110101100; //  X X X X X 5 4
         7'b0110001: fwd_o =  21'b110110110110101100000; //  X X X X 5 4 0
         7'b0110010: fwd_o =  21'b110110110110101100001; //  X X X X 5 4 1
         7'b0110011: fwd_o =  21'b110110110101100001000; //  X X X 5 4 1 0
         7'b0110100: fwd_o =  21'b110110110110101100010; //  X X X X 5 4 2
         7'b0110101: fwd_o =  21'b110110110101100010000; //  X X X 5 4 2 0
         7'b0110110: fwd_o =  21'b110110110101100010001; //  X X X 5 4 2 1
         7'b0110111: fwd_o =  21'b110110101100010001000; //  X X 5 4 2 1 0
         7'b0111000: fwd_o =  21'b110110110110101100011; //  X X X X 5 4 3
         7'b0111001: fwd_o =  21'b110110110101100011000; //  X X X 5 4 3 0
         7'b0111010: fwd_o =  21'b110110110101100011001; //  X X X 5 4 3 1
         7'b0111011: fwd_o =  21'b110110101100011001000; //  X X 5 4 3 1 0
         7'b0111100: fwd_o =  21'b110110110101100011010; //  X X X 5 4 3 2
         7'b0111101: fwd_o =  21'b110110101100011010000; //  X X 5 4 3 2 0
         7'b0111110: fwd_o =  21'b110110101100011010001; //  X X 5 4 3 2 1
         7'b0111111: fwd_o =  21'b110101100011010001000; //  X 5 4 3 2 1 0
         7'b1000000: fwd_o =  21'b101101101101101101110; //  X X X X X X 6
         7'b1000001: fwd_o =  21'b101101101101101110000; //  X X X X X 6 0
         7'b1000010: fwd_o =  21'b101101101101101110001; //  X X X X X 6 1
         7'b1000011: fwd_o =  21'b101101101101110001000; //  X X X X 6 1 0
         7'b1000100: fwd_o =  21'b101101101101101110010; //  X X X X X 6 2
         7'b1000101: fwd_o =  21'b101101101101110010000; //  X X X X 6 2 0
         7'b1000110: fwd_o =  21'b101101101101110010001; //  X X X X 6 2 1
         7'b1000111: fwd_o =  21'b101101101110010001000; //  X X X 6 2 1 0
         7'b1001000: fwd_o =  21'b101101101101101110011; //  X X X X X 6 3
         7'b1001001: fwd_o =  21'b101101101101110011000; //  X X X X 6 3 0
         7'b1001010: fwd_o =  21'b101101101101110011001; //  X X X X 6 3 1
         7'b1001011: fwd_o =  21'b101101101110011001000; //  X X X 6 3 1 0
         7'b1001100: fwd_o =  21'b101101101101110011010; //  X X X X 6 3 2
         7'b1001101: fwd_o =  21'b101101101110011010000; //  X X X 6 3 2 0
         7'b1001110: fwd_o =  21'b101101101110011010001; //  X X X 6 3 2 1
         7'b1001111: fwd_o =  21'b101101110011010001000; //  X X 6 3 2 1 0
         7'b1010000: fwd_o =  21'b101101101101101110100; //  X X X X X 6 4
         7'b1010001: fwd_o =  21'b101101101101110100000; //  X X X X 6 4 0
         7'b1010010: fwd_o =  21'b101101101101110100001; //  X X X X 6 4 1
         7'b1010011: fwd_o =  21'b101101101110100001000; //  X X X 6 4 1 0
         7'b1010100: fwd_o =  21'b101101101101110100010; //  X X X X 6 4 2
         7'b1010101: fwd_o =  21'b101101101110100010000; //  X X X 6 4 2 0
         7'b1010110: fwd_o =  21'b101101101110100010001; //  X X X 6 4 2 1
         7'b1010111: fwd_o =  21'b101101110100010001000; //  X X 6 4 2 1 0
         7'b1011000: fwd_o =  21'b101101101101110100011; //  X X X X 6 4 3
         7'b1011001: fwd_o =  21'b101101101110100011000; //  X X X 6 4 3 0
         7'b1011010: fwd_o =  21'b101101101110100011001; //  X X X 6 4 3 1
         7'b1011011: fwd_o =  21'b101101110100011001000; //  X X 6 4 3 1 0
         7'b1011100: fwd_o =  21'b101101101110100011010; //  X X X 6 4 3 2
         7'b1011101: fwd_o =  21'b101101110100011010000; //  X X 6 4 3 2 0
         7'b1011110: fwd_o =  21'b101101110100011010001; //  X X 6 4 3 2 1
         7'b1011111: fwd_o =  21'b101110100011010001000; //  X 6 4 3 2 1 0
         7'b1100000: fwd_o =  21'b100100100100100110101; //  X X X X X 6 5
         7'b1100001: fwd_o =  21'b100100100100110101000; //  X X X X 6 5 0
         7'b1100010: fwd_o =  21'b100100100100110101001; //  X X X X 6 5 1
         7'b1100011: fwd_o =  21'b100100100110101001000; //  X X X 6 5 1 0
         7'b1100100: fwd_o =  21'b100100100100110101010; //  X X X X 6 5 2
         7'b1100101: fwd_o =  21'b100100100110101010000; //  X X X 6 5 2 0
         7'b1100110: fwd_o =  21'b100100100110101010001; //  X X X 6 5 2 1
         7'b1100111: fwd_o =  21'b100100110101010001000; //  X X 6 5 2 1 0
         7'b1101000: fwd_o =  21'b100100100100110101011; //  X X X X 6 5 3
         7'b1101001: fwd_o =  21'b100100100110101011000; //  X X X 6 5 3 0
         7'b1101010: fwd_o =  21'b100100100110101011001; //  X X X 6 5 3 1
         7'b1101011: fwd_o =  21'b100100110101011001000; //  X X 6 5 3 1 0
         7'b1101100: fwd_o =  21'b100100100110101011010; //  X X X 6 5 3 2
         7'b1101101: fwd_o =  21'b100100110101011010000; //  X X 6 5 3 2 0
         7'b1101110: fwd_o =  21'b100100110101011010001; //  X X 6 5 3 2 1
         7'b1101111: fwd_o =  21'b100110101011010001000; //  X 6 5 3 2 1 0
         7'b1110000: fwd_o =  21'b011011011011110101100; //  X X X X 6 5 4
         7'b1110001: fwd_o =  21'b011011011110101100000; //  X X X 6 5 4 0
         7'b1110010: fwd_o =  21'b011011011110101100001; //  X X X 6 5 4 1
         7'b1110011: fwd_o =  21'b011011110101100001000; //  X X 6 5 4 1 0
         7'b1110100: fwd_o =  21'b011011011110101100010; //  X X X 6 5 4 2
         7'b1110101: fwd_o =  21'b011011110101100010000; //  X X 6 5 4 2 0
         7'b1110110: fwd_o =  21'b011011110101100010001; //  X X 6 5 4 2 1
         7'b1110111: fwd_o =  21'b011110101100010001000; //  X 6 5 4 2 1 0
         7'b1111000: fwd_o =  21'b010010010110101100011; //  X X X 6 5 4 3
         7'b1111001: fwd_o =  21'b010010110101100011000; //  X X 6 5 4 3 0
         7'b1111010: fwd_o =  21'b010010110101100011001; //  X X 6 5 4 3 1
         7'b1111011: fwd_o =  21'b010110101100011001000; //  X 6 5 4 3 1 0
         7'b1111100: fwd_o =  21'b001001110101100011010; //  X X 6 5 4 3 2
         7'b1111101: fwd_o =  21'b001110101100011010000; //  X 6 5 4 3 2 0
         7'b1111110: fwd_o =  21'b000110101100011010001; //  X 6 5 4 3 2 1
         7'b1111111: fwd_o =  21'b110101100011010001000; //  6 5 4 3 2 1 0
        default: fwd_o= 'X;
    endcase

    // fwd datapath vec
    always_comb
    unique case (vec_i) 
         7'b0000000: fwd_datapath_o =  21'b000000000000000000000; //  X X X X X X X
         7'b0000001: fwd_datapath_o =  21'b000000000000000000000; //  X X X X X X 0
         7'b0000010: fwd_datapath_o =  21'b000000000000000000001; //  X X X X X X 1
         7'b0000011: fwd_datapath_o =  21'b000000000000000000000; //  X X X X X 0 0
         7'b0000100: fwd_datapath_o =  21'b000000000000000000010; //  X X X X X X 2
         7'b0000101: fwd_datapath_o =  21'b000000000000000001000; //  X X X X X 1 0
         7'b0000110: fwd_datapath_o =  21'b000000000000000001001; //  X X X X X 1 1
         7'b0000111: fwd_datapath_o =  21'b000000000000000000000; //  X X X X 0 0 0
         7'b0001000: fwd_datapath_o =  21'b000000000000000000011; //  X X X X X X 3
         7'b0001001: fwd_datapath_o =  21'b000000000000000010000; //  X X X X X 2 0
         7'b0001010: fwd_datapath_o =  21'b000000000000000010001; //  X X X X X 2 1
         7'b0001011: fwd_datapath_o =  21'b000000000000001000000; //  X X X X 1 0 0
         7'b0001100: fwd_datapath_o =  21'b000000000000000010010; //  X X X X X 2 2
         7'b0001101: fwd_datapath_o =  21'b000000000000001001000; //  X X X X 1 1 0
         7'b0001110: fwd_datapath_o =  21'b000000000000001001001; //  X X X X 1 1 1
         7'b0001111: fwd_datapath_o =  21'b000000000000000000000; //  X X X 0 0 0 0
         7'b0010000: fwd_datapath_o =  21'b000000000000000000100; //  X X X X X X 4
         7'b0010001: fwd_datapath_o =  21'b000000000000000011000; //  X X X X X 3 0
         7'b0010010: fwd_datapath_o =  21'b000000000000000011001; //  X X X X X 3 1
         7'b0010011: fwd_datapath_o =  21'b000000000000010000000; //  X X X X 2 0 0
         7'b0010100: fwd_datapath_o =  21'b000000000000000011010; //  X X X X X 3 2
         7'b0010101: fwd_datapath_o =  21'b000000000000010001000; //  X X X X 2 1 0
         7'b0010110: fwd_datapath_o =  21'b000000000000010001001; //  X X X X 2 1 1
         7'b0010111: fwd_datapath_o =  21'b000000000001000000000; //  X X X 1 0 0 0
         7'b0011000: fwd_datapath_o =  21'b000000000000000011011; //  X X X X X 3 3
         7'b0011001: fwd_datapath_o =  21'b000000000000010010000; //  X X X X 2 2 0
         7'b0011010: fwd_datapath_o =  21'b000000000000010010001; //  X X X X 2 2 1
         7'b0011011: fwd_datapath_o =  21'b000000000001001000000; //  X X X 1 1 0 0
         7'b0011100: fwd_datapath_o =  21'b000000000000010010010; //  X X X X 2 2 2
         7'b0011101: fwd_datapath_o =  21'b000000000001001001000; //  X X X 1 1 1 0
         7'b0011110: fwd_datapath_o =  21'b000000000001001001001; //  X X X 1 1 1 1
         7'b0011111: fwd_datapath_o =  21'b000000000000000000000; //  X X 0 0 0 0 0
         7'b0100000: fwd_datapath_o =  21'b000000000000000000101; //  X X X X X X 5
         7'b0100001: fwd_datapath_o =  21'b000000000000000100000; //  X X X X X 4 0
         7'b0100010: fwd_datapath_o =  21'b000000000000000100001; //  X X X X X 4 1
         7'b0100011: fwd_datapath_o =  21'b000000000000011000000; //  X X X X 3 0 0
         7'b0100100: fwd_datapath_o =  21'b000000000000000100010; //  X X X X X 4 2
         7'b0100101: fwd_datapath_o =  21'b000000000000011001000; //  X X X X 3 1 0
         7'b0100110: fwd_datapath_o =  21'b000000000000011001001; //  X X X X 3 1 1
         7'b0100111: fwd_datapath_o =  21'b000000000010000000000; //  X X X 2 0 0 0
         7'b0101000: fwd_datapath_o =  21'b000000000000000100011; //  X X X X X 4 3
         7'b0101001: fwd_datapath_o =  21'b000000000000011010000; //  X X X X 3 2 0
         7'b0101010: fwd_datapath_o =  21'b000000000000011010001; //  X X X X 3 2 1
         7'b0101011: fwd_datapath_o =  21'b000000000010001000000; //  X X X 2 1 0 0
         7'b0101100: fwd_datapath_o =  21'b000000000000011010010; //  X X X X 3 2 2
         7'b0101101: fwd_datapath_o =  21'b000000000010001001000; //  X X X 2 1 1 0
         7'b0101110: fwd_datapath_o =  21'b000000000010001001001; //  X X X 2 1 1 1
         7'b0101111: fwd_datapath_o =  21'b000000001000000000000; //  X X 1 0 0 0 0
         7'b0110000: fwd_datapath_o =  21'b000000000000000100100; //  X X X X X 4 4
         7'b0110001: fwd_datapath_o =  21'b000000000000011011000; //  X X X X 3 3 0
         7'b0110010: fwd_datapath_o =  21'b000000000000011011001; //  X X X X 3 3 1
         7'b0110011: fwd_datapath_o =  21'b000000000010010000000; //  X X X 2 2 0 0
         7'b0110100: fwd_datapath_o =  21'b000000000000011011010; //  X X X X 3 3 2
         7'b0110101: fwd_datapath_o =  21'b000000000010010001000; //  X X X 2 2 1 0
         7'b0110110: fwd_datapath_o =  21'b000000000010010001001; //  X X X 2 2 1 1
         7'b0110111: fwd_datapath_o =  21'b000000001001000000000; //  X X 1 1 0 0 0
         7'b0111000: fwd_datapath_o =  21'b000000000000011011011; //  X X X X 3 3 3
         7'b0111001: fwd_datapath_o =  21'b000000000010010010000; //  X X X 2 2 2 0
         7'b0111010: fwd_datapath_o =  21'b000000000010010010001; //  X X X 2 2 2 1
         7'b0111011: fwd_datapath_o =  21'b000000001001001000000; //  X X 1 1 1 0 0
         7'b0111100: fwd_datapath_o =  21'b000000000010010010010; //  X X X 2 2 2 2
         7'b0111101: fwd_datapath_o =  21'b000000001001001001000; //  X X 1 1 1 1 0
         7'b0111110: fwd_datapath_o =  21'b000000001001001001001; //  X X 1 1 1 1 1
         7'b0111111: fwd_datapath_o =  21'b000000000000000000000; //  X 0 0 0 0 0 0
         7'b1000000: fwd_datapath_o =  21'b000000000000000000110; //  X X X X X X 6
         7'b1000001: fwd_datapath_o =  21'b000000000000000101000; //  X X X X X 5 0
         7'b1000010: fwd_datapath_o =  21'b000000000000000101001; //  X X X X X 5 1
         7'b1000011: fwd_datapath_o =  21'b000000000000100000000; //  X X X X 4 0 0
         7'b1000100: fwd_datapath_o =  21'b000000000000000101010; //  X X X X X 5 2
         7'b1000101: fwd_datapath_o =  21'b000000000000100001000; //  X X X X 4 1 0
         7'b1000110: fwd_datapath_o =  21'b000000000000100001001; //  X X X X 4 1 1
         7'b1000111: fwd_datapath_o =  21'b000000000011000000000; //  X X X 3 0 0 0
         7'b1001000: fwd_datapath_o =  21'b000000000000000101011; //  X X X X X 5 3
         7'b1001001: fwd_datapath_o =  21'b000000000000100010000; //  X X X X 4 2 0
         7'b1001010: fwd_datapath_o =  21'b000000000000100010001; //  X X X X 4 2 1
         7'b1001011: fwd_datapath_o =  21'b000000000011001000000; //  X X X 3 1 0 0
         7'b1001100: fwd_datapath_o =  21'b000000000000100010010; //  X X X X 4 2 2
         7'b1001101: fwd_datapath_o =  21'b000000000011001001000; //  X X X 3 1 1 0
         7'b1001110: fwd_datapath_o =  21'b000000000011001001001; //  X X X 3 1 1 1
         7'b1001111: fwd_datapath_o =  21'b000000010000000000000; //  X X 2 0 0 0 0
         7'b1010000: fwd_datapath_o =  21'b000000000000000101100; //  X X X X X 5 4
         7'b1010001: fwd_datapath_o =  21'b000000000000100011000; //  X X X X 4 3 0
         7'b1010010: fwd_datapath_o =  21'b000000000000100011001; //  X X X X 4 3 1
         7'b1010011: fwd_datapath_o =  21'b000000000011010000000; //  X X X 3 2 0 0
         7'b1010100: fwd_datapath_o =  21'b000000000000100011010; //  X X X X 4 3 2
         7'b1010101: fwd_datapath_o =  21'b000000000011010001000; //  X X X 3 2 1 0
         7'b1010110: fwd_datapath_o =  21'b000000000011010001001; //  X X X 3 2 1 1
         7'b1010111: fwd_datapath_o =  21'b000000010001000000000; //  X X 2 1 0 0 0
         7'b1011000: fwd_datapath_o =  21'b000000000000100011011; //  X X X X 4 3 3
         7'b1011001: fwd_datapath_o =  21'b000000000011010010000; //  X X X 3 2 2 0
         7'b1011010: fwd_datapath_o =  21'b000000000011010010001; //  X X X 3 2 2 1
         7'b1011011: fwd_datapath_o =  21'b000000010001001000000; //  X X 2 1 1 0 0
         7'b1011100: fwd_datapath_o =  21'b000000000011010010010; //  X X X 3 2 2 2
         7'b1011101: fwd_datapath_o =  21'b000000010001001001000; //  X X 2 1 1 1 0
         7'b1011110: fwd_datapath_o =  21'b000000010001001001001; //  X X 2 1 1 1 1
         7'b1011111: fwd_datapath_o =  21'b000001000000000000000; //  X 1 0 0 0 0 0
         7'b1100000: fwd_datapath_o =  21'b000000000000000101101; //  X X X X X 5 5
         7'b1100001: fwd_datapath_o =  21'b000000000000100100000; //  X X X X 4 4 0
         7'b1100010: fwd_datapath_o =  21'b000000000000100100001; //  X X X X 4 4 1
         7'b1100011: fwd_datapath_o =  21'b000000000011011000000; //  X X X 3 3 0 0
         7'b1100100: fwd_datapath_o =  21'b000000000000100100010; //  X X X X 4 4 2
         7'b1100101: fwd_datapath_o =  21'b000000000011011001000; //  X X X 3 3 1 0
         7'b1100110: fwd_datapath_o =  21'b000000000011011001001; //  X X X 3 3 1 1
         7'b1100111: fwd_datapath_o =  21'b000000010010000000000; //  X X 2 2 0 0 0
         7'b1101000: fwd_datapath_o =  21'b000000000000100100011; //  X X X X 4 4 3
         7'b1101001: fwd_datapath_o =  21'b000000000011011010000; //  X X X 3 3 2 0
         7'b1101010: fwd_datapath_o =  21'b000000000011011010001; //  X X X 3 3 2 1
         7'b1101011: fwd_datapath_o =  21'b000000010010001000000; //  X X 2 2 1 0 0
         7'b1101100: fwd_datapath_o =  21'b000000000011011010010; //  X X X 3 3 2 2
         7'b1101101: fwd_datapath_o =  21'b000000010010001001000; //  X X 2 2 1 1 0
         7'b1101110: fwd_datapath_o =  21'b000000010010001001001; //  X X 2 2 1 1 1
         7'b1101111: fwd_datapath_o =  21'b000001001000000000000; //  X 1 1 0 0 0 0
         7'b1110000: fwd_datapath_o =  21'b000000000000100100100; //  X X X X 4 4 4
         7'b1110001: fwd_datapath_o =  21'b000000000011011011000; //  X X X 3 3 3 0
         7'b1110010: fwd_datapath_o =  21'b000000000011011011001; //  X X X 3 3 3 1
         7'b1110011: fwd_datapath_o =  21'b000000010010010000000; //  X X 2 2 2 0 0
         7'b1110100: fwd_datapath_o =  21'b000000000011011011010; //  X X X 3 3 3 2
         7'b1110101: fwd_datapath_o =  21'b000000010010010001000; //  X X 2 2 2 1 0
         7'b1110110: fwd_datapath_o =  21'b000000010010010001001; //  X X 2 2 2 1 1
         7'b1110111: fwd_datapath_o =  21'b000001001001000000000; //  X 1 1 1 0 0 0
         7'b1111000: fwd_datapath_o =  21'b000000000011011011011; //  X X X 3 3 3 3
         7'b1111001: fwd_datapath_o =  21'b000000010010010010000; //  X X 2 2 2 2 0
         7'b1111010: fwd_datapath_o =  21'b000000010010010010001; //  X X 2 2 2 2 1
         7'b1111011: fwd_datapath_o =  21'b000001001001001000000; //  X 1 1 1 1 0 0
         7'b1111100: fwd_datapath_o =  21'b000000010010010010010; //  X X 2 2 2 2 2
         7'b1111101: fwd_datapath_o =  21'b000001001001001001000; //  X 1 1 1 1 1 0
         7'b1111110: fwd_datapath_o =  21'b000001001001001001001; //  X 1 1 1 1 1 1
         7'b1111111: fwd_datapath_o =  21'b000000000000000000000; //  0 0 0 0 0 0 0
        default: fwd_datapath_o= 'X;
    endcase
  end

if (vec_size_lp == 8)
  begin
    // backward vec
    always_comb
    unique case (vec_i) 
         8'b00000000: bk_o =  24'b111111111111111111111111; //  X X X X X X X X
         8'b00000001: bk_o =  24'b111111111111111111111000; //  X X X X X X X 0
         8'b00000010: bk_o =  24'b111111111111111111000111; //  X X X X X X 0 X
         8'b00000011: bk_o =  24'b111111111111111111001000; //  X X X X X X 1 0
         8'b00000100: bk_o =  24'b111111111111111000111111; //  X X X X X 0 X X
         8'b00000101: bk_o =  24'b111111111111111001111000; //  X X X X X 1 X 0
         8'b00000110: bk_o =  24'b111111111111111001000111; //  X X X X X 1 0 X
         8'b00000111: bk_o =  24'b111111111111111010001000; //  X X X X X 2 1 0
         8'b00001000: bk_o =  24'b111111111111000111111111; //  X X X X 0 X X X
         8'b00001001: bk_o =  24'b111111111111001111111000; //  X X X X 1 X X 0
         8'b00001010: bk_o =  24'b111111111111001111000111; //  X X X X 1 X 0 X
         8'b00001011: bk_o =  24'b111111111111010111001000; //  X X X X 2 X 1 0
         8'b00001100: bk_o =  24'b111111111111001000111111; //  X X X X 1 0 X X
         8'b00001101: bk_o =  24'b111111111111010001111000; //  X X X X 2 1 X 0
         8'b00001110: bk_o =  24'b111111111111010001000111; //  X X X X 2 1 0 X
         8'b00001111: bk_o =  24'b111111111111011010001000; //  X X X X 3 2 1 0
         8'b00010000: bk_o =  24'b111111111000111111111111; //  X X X 0 X X X X
         8'b00010001: bk_o =  24'b111111111001111111111000; //  X X X 1 X X X 0
         8'b00010010: bk_o =  24'b111111111001111111000111; //  X X X 1 X X 0 X
         8'b00010011: bk_o =  24'b111111111010111111001000; //  X X X 2 X X 1 0
         8'b00010100: bk_o =  24'b111111111001111000111111; //  X X X 1 X 0 X X
         8'b00010101: bk_o =  24'b111111111010111001111000; //  X X X 2 X 1 X 0
         8'b00010110: bk_o =  24'b111111111010111001000111; //  X X X 2 X 1 0 X
         8'b00010111: bk_o =  24'b111111111011111010001000; //  X X X 3 X 2 1 0
         8'b00011000: bk_o =  24'b111111111001000111111111; //  X X X 1 0 X X X
         8'b00011001: bk_o =  24'b111111111010001111111000; //  X X X 2 1 X X 0
         8'b00011010: bk_o =  24'b111111111010001111000111; //  X X X 2 1 X 0 X
         8'b00011011: bk_o =  24'b111111111011010111001000; //  X X X 3 2 X 1 0
         8'b00011100: bk_o =  24'b111111111010001000111111; //  X X X 2 1 0 X X
         8'b00011101: bk_o =  24'b111111111011010001111000; //  X X X 3 2 1 X 0
         8'b00011110: bk_o =  24'b111111111011010001000111; //  X X X 3 2 1 0 X
         8'b00011111: bk_o =  24'b111111111100011010001000; //  X X X 4 3 2 1 0
         8'b00100000: bk_o =  24'b111111000111111111111111; //  X X 0 X X X X X
         8'b00100001: bk_o =  24'b111111001111111111111000; //  X X 1 X X X X 0
         8'b00100010: bk_o =  24'b111111001111111111000111; //  X X 1 X X X 0 X
         8'b00100011: bk_o =  24'b111111010111111111001000; //  X X 2 X X X 1 0
         8'b00100100: bk_o =  24'b111111001111111000111111; //  X X 1 X X 0 X X
         8'b00100101: bk_o =  24'b111111010111111001111000; //  X X 2 X X 1 X 0
         8'b00100110: bk_o =  24'b111111010111111001000111; //  X X 2 X X 1 0 X
         8'b00100111: bk_o =  24'b111111011111111010001000; //  X X 3 X X 2 1 0
         8'b00101000: bk_o =  24'b111111001111000111111111; //  X X 1 X 0 X X X
         8'b00101001: bk_o =  24'b111111010111001111111000; //  X X 2 X 1 X X 0
         8'b00101010: bk_o =  24'b111111010111001111000111; //  X X 2 X 1 X 0 X
         8'b00101011: bk_o =  24'b111111011111010111001000; //  X X 3 X 2 X 1 0
         8'b00101100: bk_o =  24'b111111010111001000111111; //  X X 2 X 1 0 X X
         8'b00101101: bk_o =  24'b111111011111010001111000; //  X X 3 X 2 1 X 0
         8'b00101110: bk_o =  24'b111111011111010001000111; //  X X 3 X 2 1 0 X
         8'b00101111: bk_o =  24'b111111100111011010001000; //  X X 4 X 3 2 1 0
         8'b00110000: bk_o =  24'b111111001000111111111111; //  X X 1 0 X X X X
         8'b00110001: bk_o =  24'b111111010001111111111000; //  X X 2 1 X X X 0
         8'b00110010: bk_o =  24'b111111010001111111000111; //  X X 2 1 X X 0 X
         8'b00110011: bk_o =  24'b111111011010111111001000; //  X X 3 2 X X 1 0
         8'b00110100: bk_o =  24'b111111010001111000111111; //  X X 2 1 X 0 X X
         8'b00110101: bk_o =  24'b111111011010111001111000; //  X X 3 2 X 1 X 0
         8'b00110110: bk_o =  24'b111111011010111001000111; //  X X 3 2 X 1 0 X
         8'b00110111: bk_o =  24'b111111100011111010001000; //  X X 4 3 X 2 1 0
         8'b00111000: bk_o =  24'b111111010001000111111111; //  X X 2 1 0 X X X
         8'b00111001: bk_o =  24'b111111011010001111111000; //  X X 3 2 1 X X 0
         8'b00111010: bk_o =  24'b111111011010001111000111; //  X X 3 2 1 X 0 X
         8'b00111011: bk_o =  24'b111111100011010111001000; //  X X 4 3 2 X 1 0
         8'b00111100: bk_o =  24'b111111011010001000111111; //  X X 3 2 1 0 X X
         8'b00111101: bk_o =  24'b111111100011010001111000; //  X X 4 3 2 1 X 0
         8'b00111110: bk_o =  24'b111111100011010001000111; //  X X 4 3 2 1 0 X
         8'b00111111: bk_o =  24'b111111101100011010001000; //  X X 5 4 3 2 1 0
         8'b01000000: bk_o =  24'b111000111111111111111111; //  X 0 X X X X X X
         8'b01000001: bk_o =  24'b111001111111111111111000; //  X 1 X X X X X 0
         8'b01000010: bk_o =  24'b111001111111111111000111; //  X 1 X X X X 0 X
         8'b01000011: bk_o =  24'b111010111111111111001000; //  X 2 X X X X 1 0
         8'b01000100: bk_o =  24'b111001111111111000111111; //  X 1 X X X 0 X X
         8'b01000101: bk_o =  24'b111010111111111001111000; //  X 2 X X X 1 X 0
         8'b01000110: bk_o =  24'b111010111111111001000111; //  X 2 X X X 1 0 X
         8'b01000111: bk_o =  24'b111011111111111010001000; //  X 3 X X X 2 1 0
         8'b01001000: bk_o =  24'b111001111111000111111111; //  X 1 X X 0 X X X
         8'b01001001: bk_o =  24'b111010111111001111111000; //  X 2 X X 1 X X 0
         8'b01001010: bk_o =  24'b111010111111001111000111; //  X 2 X X 1 X 0 X
         8'b01001011: bk_o =  24'b111011111111010111001000; //  X 3 X X 2 X 1 0
         8'b01001100: bk_o =  24'b111010111111001000111111; //  X 2 X X 1 0 X X
         8'b01001101: bk_o =  24'b111011111111010001111000; //  X 3 X X 2 1 X 0
         8'b01001110: bk_o =  24'b111011111111010001000111; //  X 3 X X 2 1 0 X
         8'b01001111: bk_o =  24'b111100111111011010001000; //  X 4 X X 3 2 1 0
         8'b01010000: bk_o =  24'b111001111000111111111111; //  X 1 X 0 X X X X
         8'b01010001: bk_o =  24'b111010111001111111111000; //  X 2 X 1 X X X 0
         8'b01010010: bk_o =  24'b111010111001111111000111; //  X 2 X 1 X X 0 X
         8'b01010011: bk_o =  24'b111011111010111111001000; //  X 3 X 2 X X 1 0
         8'b01010100: bk_o =  24'b111010111001111000111111; //  X 2 X 1 X 0 X X
         8'b01010101: bk_o =  24'b111011111010111001111000; //  X 3 X 2 X 1 X 0
         8'b01010110: bk_o =  24'b111011111010111001000111; //  X 3 X 2 X 1 0 X
         8'b01010111: bk_o =  24'b111100111011111010001000; //  X 4 X 3 X 2 1 0
         8'b01011000: bk_o =  24'b111010111001000111111111; //  X 2 X 1 0 X X X
         8'b01011001: bk_o =  24'b111011111010001111111000; //  X 3 X 2 1 X X 0
         8'b01011010: bk_o =  24'b111011111010001111000111; //  X 3 X 2 1 X 0 X
         8'b01011011: bk_o =  24'b111100111011010111001000; //  X 4 X 3 2 X 1 0
         8'b01011100: bk_o =  24'b111011111010001000111111; //  X 3 X 2 1 0 X X
         8'b01011101: bk_o =  24'b111100111011010001111000; //  X 4 X 3 2 1 X 0
         8'b01011110: bk_o =  24'b111100111011010001000111; //  X 4 X 3 2 1 0 X
         8'b01011111: bk_o =  24'b111101111100011010001000; //  X 5 X 4 3 2 1 0
         8'b01100000: bk_o =  24'b111001000111111111111111; //  X 1 0 X X X X X
         8'b01100001: bk_o =  24'b111010001111111111111000; //  X 2 1 X X X X 0
         8'b01100010: bk_o =  24'b111010001111111111000111; //  X 2 1 X X X 0 X
         8'b01100011: bk_o =  24'b111011010111111111001000; //  X 3 2 X X X 1 0
         8'b01100100: bk_o =  24'b111010001111111000111111; //  X 2 1 X X 0 X X
         8'b01100101: bk_o =  24'b111011010111111001111000; //  X 3 2 X X 1 X 0
         8'b01100110: bk_o =  24'b111011010111111001000111; //  X 3 2 X X 1 0 X
         8'b01100111: bk_o =  24'b111100011111111010001000; //  X 4 3 X X 2 1 0
         8'b01101000: bk_o =  24'b111010001111000111111111; //  X 2 1 X 0 X X X
         8'b01101001: bk_o =  24'b111011010111001111111000; //  X 3 2 X 1 X X 0
         8'b01101010: bk_o =  24'b111011010111001111000111; //  X 3 2 X 1 X 0 X
         8'b01101011: bk_o =  24'b111100011111010111001000; //  X 4 3 X 2 X 1 0
         8'b01101100: bk_o =  24'b111011010111001000111111; //  X 3 2 X 1 0 X X
         8'b01101101: bk_o =  24'b111100011111010001111000; //  X 4 3 X 2 1 X 0
         8'b01101110: bk_o =  24'b111100011111010001000111; //  X 4 3 X 2 1 0 X
         8'b01101111: bk_o =  24'b111101100111011010001000; //  X 5 4 X 3 2 1 0
         8'b01110000: bk_o =  24'b111010001000111111111111; //  X 2 1 0 X X X X
         8'b01110001: bk_o =  24'b111011010001111111111000; //  X 3 2 1 X X X 0
         8'b01110010: bk_o =  24'b111011010001111111000111; //  X 3 2 1 X X 0 X
         8'b01110011: bk_o =  24'b111100011010111111001000; //  X 4 3 2 X X 1 0
         8'b01110100: bk_o =  24'b111011010001111000111111; //  X 3 2 1 X 0 X X
         8'b01110101: bk_o =  24'b111100011010111001111000; //  X 4 3 2 X 1 X 0
         8'b01110110: bk_o =  24'b111100011010111001000111; //  X 4 3 2 X 1 0 X
         8'b01110111: bk_o =  24'b111101100011111010001000; //  X 5 4 3 X 2 1 0
         8'b01111000: bk_o =  24'b111011010001000111111111; //  X 3 2 1 0 X X X
         8'b01111001: bk_o =  24'b111100011010001111111000; //  X 4 3 2 1 X X 0
         8'b01111010: bk_o =  24'b111100011010001111000111; //  X 4 3 2 1 X 0 X
         8'b01111011: bk_o =  24'b111101100011010111001000; //  X 5 4 3 2 X 1 0
         8'b01111100: bk_o =  24'b111100011010001000111111; //  X 4 3 2 1 0 X X
         8'b01111101: bk_o =  24'b111101100011010001111000; //  X 5 4 3 2 1 X 0
         8'b01111110: bk_o =  24'b111101100011010001000111; //  X 5 4 3 2 1 0 X
         8'b01111111: bk_o =  24'b111110101100011010001000; //  X 6 5 4 3 2 1 0
         8'b10000000: bk_o =  24'b000111111111111111111111; //  0 X X X X X X X
         8'b10000001: bk_o =  24'b001111111111111111111000; //  1 X X X X X X 0
         8'b10000010: bk_o =  24'b001111111111111111000111; //  1 X X X X X 0 X
         8'b10000011: bk_o =  24'b010111111111111111001000; //  2 X X X X X 1 0
         8'b10000100: bk_o =  24'b001111111111111000111111; //  1 X X X X 0 X X
         8'b10000101: bk_o =  24'b010111111111111001111000; //  2 X X X X 1 X 0
         8'b10000110: bk_o =  24'b010111111111111001000111; //  2 X X X X 1 0 X
         8'b10000111: bk_o =  24'b011111111111111010001000; //  3 X X X X 2 1 0
         8'b10001000: bk_o =  24'b001111111111000111111111; //  1 X X X 0 X X X
         8'b10001001: bk_o =  24'b010111111111001111111000; //  2 X X X 1 X X 0
         8'b10001010: bk_o =  24'b010111111111001111000111; //  2 X X X 1 X 0 X
         8'b10001011: bk_o =  24'b011111111111010111001000; //  3 X X X 2 X 1 0
         8'b10001100: bk_o =  24'b010111111111001000111111; //  2 X X X 1 0 X X
         8'b10001101: bk_o =  24'b011111111111010001111000; //  3 X X X 2 1 X 0
         8'b10001110: bk_o =  24'b011111111111010001000111; //  3 X X X 2 1 0 X
         8'b10001111: bk_o =  24'b100111111111011010001000; //  4 X X X 3 2 1 0
         8'b10010000: bk_o =  24'b001111111000111111111111; //  1 X X 0 X X X X
         8'b10010001: bk_o =  24'b010111111001111111111000; //  2 X X 1 X X X 0
         8'b10010010: bk_o =  24'b010111111001111111000111; //  2 X X 1 X X 0 X
         8'b10010011: bk_o =  24'b011111111010111111001000; //  3 X X 2 X X 1 0
         8'b10010100: bk_o =  24'b010111111001111000111111; //  2 X X 1 X 0 X X
         8'b10010101: bk_o =  24'b011111111010111001111000; //  3 X X 2 X 1 X 0
         8'b10010110: bk_o =  24'b011111111010111001000111; //  3 X X 2 X 1 0 X
         8'b10010111: bk_o =  24'b100111111011111010001000; //  4 X X 3 X 2 1 0
         8'b10011000: bk_o =  24'b010111111001000111111111; //  2 X X 1 0 X X X
         8'b10011001: bk_o =  24'b011111111010001111111000; //  3 X X 2 1 X X 0
         8'b10011010: bk_o =  24'b011111111010001111000111; //  3 X X 2 1 X 0 X
         8'b10011011: bk_o =  24'b100111111011010111001000; //  4 X X 3 2 X 1 0
         8'b10011100: bk_o =  24'b011111111010001000111111; //  3 X X 2 1 0 X X
         8'b10011101: bk_o =  24'b100111111011010001111000; //  4 X X 3 2 1 X 0
         8'b10011110: bk_o =  24'b100111111011010001000111; //  4 X X 3 2 1 0 X
         8'b10011111: bk_o =  24'b101111111100011010001000; //  5 X X 4 3 2 1 0
         8'b10100000: bk_o =  24'b001111000111111111111111; //  1 X 0 X X X X X
         8'b10100001: bk_o =  24'b010111001111111111111000; //  2 X 1 X X X X 0
         8'b10100010: bk_o =  24'b010111001111111111000111; //  2 X 1 X X X 0 X
         8'b10100011: bk_o =  24'b011111010111111111001000; //  3 X 2 X X X 1 0
         8'b10100100: bk_o =  24'b010111001111111000111111; //  2 X 1 X X 0 X X
         8'b10100101: bk_o =  24'b011111010111111001111000; //  3 X 2 X X 1 X 0
         8'b10100110: bk_o =  24'b011111010111111001000111; //  3 X 2 X X 1 0 X
         8'b10100111: bk_o =  24'b100111011111111010001000; //  4 X 3 X X 2 1 0
         8'b10101000: bk_o =  24'b010111001111000111111111; //  2 X 1 X 0 X X X
         8'b10101001: bk_o =  24'b011111010111001111111000; //  3 X 2 X 1 X X 0
         8'b10101010: bk_o =  24'b011111010111001111000111; //  3 X 2 X 1 X 0 X
         8'b10101011: bk_o =  24'b100111011111010111001000; //  4 X 3 X 2 X 1 0
         8'b10101100: bk_o =  24'b011111010111001000111111; //  3 X 2 X 1 0 X X
         8'b10101101: bk_o =  24'b100111011111010001111000; //  4 X 3 X 2 1 X 0
         8'b10101110: bk_o =  24'b100111011111010001000111; //  4 X 3 X 2 1 0 X
         8'b10101111: bk_o =  24'b101111100111011010001000; //  5 X 4 X 3 2 1 0
         8'b10110000: bk_o =  24'b010111001000111111111111; //  2 X 1 0 X X X X
         8'b10110001: bk_o =  24'b011111010001111111111000; //  3 X 2 1 X X X 0
         8'b10110010: bk_o =  24'b011111010001111111000111; //  3 X 2 1 X X 0 X
         8'b10110011: bk_o =  24'b100111011010111111001000; //  4 X 3 2 X X 1 0
         8'b10110100: bk_o =  24'b011111010001111000111111; //  3 X 2 1 X 0 X X
         8'b10110101: bk_o =  24'b100111011010111001111000; //  4 X 3 2 X 1 X 0
         8'b10110110: bk_o =  24'b100111011010111001000111; //  4 X 3 2 X 1 0 X
         8'b10110111: bk_o =  24'b101111100011111010001000; //  5 X 4 3 X 2 1 0
         8'b10111000: bk_o =  24'b011111010001000111111111; //  3 X 2 1 0 X X X
         8'b10111001: bk_o =  24'b100111011010001111111000; //  4 X 3 2 1 X X 0
         8'b10111010: bk_o =  24'b100111011010001111000111; //  4 X 3 2 1 X 0 X
         8'b10111011: bk_o =  24'b101111100011010111001000; //  5 X 4 3 2 X 1 0
         8'b10111100: bk_o =  24'b100111011010001000111111; //  4 X 3 2 1 0 X X
         8'b10111101: bk_o =  24'b101111100011010001111000; //  5 X 4 3 2 1 X 0
         8'b10111110: bk_o =  24'b101111100011010001000111; //  5 X 4 3 2 1 0 X
         8'b10111111: bk_o =  24'b110111101100011010001000; //  6 X 5 4 3 2 1 0
         8'b11000000: bk_o =  24'b001000111111111111111111; //  1 0 X X X X X X
         8'b11000001: bk_o =  24'b010001111111111111111000; //  2 1 X X X X X 0
         8'b11000010: bk_o =  24'b010001111111111111000111; //  2 1 X X X X 0 X
         8'b11000011: bk_o =  24'b011010111111111111001000; //  3 2 X X X X 1 0
         8'b11000100: bk_o =  24'b010001111111111000111111; //  2 1 X X X 0 X X
         8'b11000101: bk_o =  24'b011010111111111001111000; //  3 2 X X X 1 X 0
         8'b11000110: bk_o =  24'b011010111111111001000111; //  3 2 X X X 1 0 X
         8'b11000111: bk_o =  24'b100011111111111010001000; //  4 3 X X X 2 1 0
         8'b11001000: bk_o =  24'b010001111111000111111111; //  2 1 X X 0 X X X
         8'b11001001: bk_o =  24'b011010111111001111111000; //  3 2 X X 1 X X 0
         8'b11001010: bk_o =  24'b011010111111001111000111; //  3 2 X X 1 X 0 X
         8'b11001011: bk_o =  24'b100011111111010111001000; //  4 3 X X 2 X 1 0
         8'b11001100: bk_o =  24'b011010111111001000111111; //  3 2 X X 1 0 X X
         8'b11001101: bk_o =  24'b100011111111010001111000; //  4 3 X X 2 1 X 0
         8'b11001110: bk_o =  24'b100011111111010001000111; //  4 3 X X 2 1 0 X
         8'b11001111: bk_o =  24'b101100111111011010001000; //  5 4 X X 3 2 1 0
         8'b11010000: bk_o =  24'b010001111000111111111111; //  2 1 X 0 X X X X
         8'b11010001: bk_o =  24'b011010111001111111111000; //  3 2 X 1 X X X 0
         8'b11010010: bk_o =  24'b011010111001111111000111; //  3 2 X 1 X X 0 X
         8'b11010011: bk_o =  24'b100011111010111111001000; //  4 3 X 2 X X 1 0
         8'b11010100: bk_o =  24'b011010111001111000111111; //  3 2 X 1 X 0 X X
         8'b11010101: bk_o =  24'b100011111010111001111000; //  4 3 X 2 X 1 X 0
         8'b11010110: bk_o =  24'b100011111010111001000111; //  4 3 X 2 X 1 0 X
         8'b11010111: bk_o =  24'b101100111011111010001000; //  5 4 X 3 X 2 1 0
         8'b11011000: bk_o =  24'b011010111001000111111111; //  3 2 X 1 0 X X X
         8'b11011001: bk_o =  24'b100011111010001111111000; //  4 3 X 2 1 X X 0
         8'b11011010: bk_o =  24'b100011111010001111000111; //  4 3 X 2 1 X 0 X
         8'b11011011: bk_o =  24'b101100111011010111001000; //  5 4 X 3 2 X 1 0
         8'b11011100: bk_o =  24'b100011111010001000111111; //  4 3 X 2 1 0 X X
         8'b11011101: bk_o =  24'b101100111011010001111000; //  5 4 X 3 2 1 X 0
         8'b11011110: bk_o =  24'b101100111011010001000111; //  5 4 X 3 2 1 0 X
         8'b11011111: bk_o =  24'b110101111100011010001000; //  6 5 X 4 3 2 1 0
         8'b11100000: bk_o =  24'b010001000111111111111111; //  2 1 0 X X X X X
         8'b11100001: bk_o =  24'b011010001111111111111000; //  3 2 1 X X X X 0
         8'b11100010: bk_o =  24'b011010001111111111000111; //  3 2 1 X X X 0 X
         8'b11100011: bk_o =  24'b100011010111111111001000; //  4 3 2 X X X 1 0
         8'b11100100: bk_o =  24'b011010001111111000111111; //  3 2 1 X X 0 X X
         8'b11100101: bk_o =  24'b100011010111111001111000; //  4 3 2 X X 1 X 0
         8'b11100110: bk_o =  24'b100011010111111001000111; //  4 3 2 X X 1 0 X
         8'b11100111: bk_o =  24'b101100011111111010001000; //  5 4 3 X X 2 1 0
         8'b11101000: bk_o =  24'b011010001111000111111111; //  3 2 1 X 0 X X X
         8'b11101001: bk_o =  24'b100011010111001111111000; //  4 3 2 X 1 X X 0
         8'b11101010: bk_o =  24'b100011010111001111000111; //  4 3 2 X 1 X 0 X
         8'b11101011: bk_o =  24'b101100011111010111001000; //  5 4 3 X 2 X 1 0
         8'b11101100: bk_o =  24'b100011010111001000111111; //  4 3 2 X 1 0 X X
         8'b11101101: bk_o =  24'b101100011111010001111000; //  5 4 3 X 2 1 X 0
         8'b11101110: bk_o =  24'b101100011111010001000111; //  5 4 3 X 2 1 0 X
         8'b11101111: bk_o =  24'b110101100111011010001000; //  6 5 4 X 3 2 1 0
         8'b11110000: bk_o =  24'b011010001000111111111111; //  3 2 1 0 X X X X
         8'b11110001: bk_o =  24'b100011010001111111111000; //  4 3 2 1 X X X 0
         8'b11110010: bk_o =  24'b100011010001111111000111; //  4 3 2 1 X X 0 X
         8'b11110011: bk_o =  24'b101100011010111111001000; //  5 4 3 2 X X 1 0
         8'b11110100: bk_o =  24'b100011010001111000111111; //  4 3 2 1 X 0 X X
         8'b11110101: bk_o =  24'b101100011010111001111000; //  5 4 3 2 X 1 X 0
         8'b11110110: bk_o =  24'b101100011010111001000111; //  5 4 3 2 X 1 0 X
         8'b11110111: bk_o =  24'b110101100011111010001000; //  6 5 4 3 X 2 1 0
         8'b11111000: bk_o =  24'b100011010001000111111111; //  4 3 2 1 0 X X X
         8'b11111001: bk_o =  24'b101100011010001111111000; //  5 4 3 2 1 X X 0
         8'b11111010: bk_o =  24'b101100011010001111000111; //  5 4 3 2 1 X 0 X
         8'b11111011: bk_o =  24'b110101100011010111001000; //  6 5 4 3 2 X 1 0
         8'b11111100: bk_o =  24'b101100011010001000111111; //  5 4 3 2 1 0 X X
         8'b11111101: bk_o =  24'b110101100011010001111000; //  6 5 4 3 2 1 X 0
         8'b11111110: bk_o =  24'b110101100011010001000111; //  6 5 4 3 2 1 0 X
         8'b11111111: bk_o =  24'b111110101100011010001000; //  7 6 5 4 3 2 1 0
        default: bk_o= 'X;
    endcase

    // backward vec datapath
    always_comb
    unique case (vec_i) 
         8'b00000000: bk_datapath_o =  24'b000000000000000000000000; //  X X X X X X X X
         8'b00000001: bk_datapath_o =  24'b000000000000000000000000; //  X X X X X X X 0
         8'b00000010: bk_datapath_o =  24'b000000000000000000000000; //  X X X X X X 0 X
         8'b00000011: bk_datapath_o =  24'b000000000000000000001000; //  X X X X X X 1 0
         8'b00000100: bk_datapath_o =  24'b000000000000000000000000; //  X X X X X 0 X X
         8'b00000101: bk_datapath_o =  24'b000000000000000001000000; //  X X X X X 1 X 0
         8'b00000110: bk_datapath_o =  24'b000000000000000001000000; //  X X X X X 1 0 X
         8'b00000111: bk_datapath_o =  24'b000000000000000010001000; //  X X X X X 2 1 0
         8'b00001000: bk_datapath_o =  24'b000000000000000000000000; //  X X X X 0 X X X
         8'b00001001: bk_datapath_o =  24'b000000000000001000000000; //  X X X X 1 X X 0
         8'b00001010: bk_datapath_o =  24'b000000000000001000000000; //  X X X X 1 X 0 X
         8'b00001011: bk_datapath_o =  24'b000000000000010000001000; //  X X X X 2 X 1 0
         8'b00001100: bk_datapath_o =  24'b000000000000001000000000; //  X X X X 1 0 X X
         8'b00001101: bk_datapath_o =  24'b000000000000010001000000; //  X X X X 2 1 X 0
         8'b00001110: bk_datapath_o =  24'b000000000000010001000000; //  X X X X 2 1 0 X
         8'b00001111: bk_datapath_o =  24'b000000000000011010001000; //  X X X X 3 2 1 0
         8'b00010000: bk_datapath_o =  24'b000000000000000000000000; //  X X X 0 X X X X
         8'b00010001: bk_datapath_o =  24'b000000000001000000000000; //  X X X 1 X X X 0
         8'b00010010: bk_datapath_o =  24'b000000000001000000000000; //  X X X 1 X X 0 X
         8'b00010011: bk_datapath_o =  24'b000000000010000000001000; //  X X X 2 X X 1 0
         8'b00010100: bk_datapath_o =  24'b000000000001000000000000; //  X X X 1 X 0 X X
         8'b00010101: bk_datapath_o =  24'b000000000010000001000000; //  X X X 2 X 1 X 0
         8'b00010110: bk_datapath_o =  24'b000000000010000001000000; //  X X X 2 X 1 0 X
         8'b00010111: bk_datapath_o =  24'b000000000011000010001000; //  X X X 3 X 2 1 0
         8'b00011000: bk_datapath_o =  24'b000000000001000000000000; //  X X X 1 0 X X X
         8'b00011001: bk_datapath_o =  24'b000000000010001000000000; //  X X X 2 1 X X 0
         8'b00011010: bk_datapath_o =  24'b000000000010001000000000; //  X X X 2 1 X 0 X
         8'b00011011: bk_datapath_o =  24'b000000000011010000001000; //  X X X 3 2 X 1 0
         8'b00011100: bk_datapath_o =  24'b000000000010001000000000; //  X X X 2 1 0 X X
         8'b00011101: bk_datapath_o =  24'b000000000011010001000000; //  X X X 3 2 1 X 0
         8'b00011110: bk_datapath_o =  24'b000000000011010001000000; //  X X X 3 2 1 0 X
         8'b00011111: bk_datapath_o =  24'b000000000100011010001000; //  X X X 4 3 2 1 0
         8'b00100000: bk_datapath_o =  24'b000000000000000000000000; //  X X 0 X X X X X
         8'b00100001: bk_datapath_o =  24'b000000001000000000000000; //  X X 1 X X X X 0
         8'b00100010: bk_datapath_o =  24'b000000001000000000000000; //  X X 1 X X X 0 X
         8'b00100011: bk_datapath_o =  24'b000000010000000000001000; //  X X 2 X X X 1 0
         8'b00100100: bk_datapath_o =  24'b000000001000000000000000; //  X X 1 X X 0 X X
         8'b00100101: bk_datapath_o =  24'b000000010000000001000000; //  X X 2 X X 1 X 0
         8'b00100110: bk_datapath_o =  24'b000000010000000001000000; //  X X 2 X X 1 0 X
         8'b00100111: bk_datapath_o =  24'b000000011000000010001000; //  X X 3 X X 2 1 0
         8'b00101000: bk_datapath_o =  24'b000000001000000000000000; //  X X 1 X 0 X X X
         8'b00101001: bk_datapath_o =  24'b000000010000001000000000; //  X X 2 X 1 X X 0
         8'b00101010: bk_datapath_o =  24'b000000010000001000000000; //  X X 2 X 1 X 0 X
         8'b00101011: bk_datapath_o =  24'b000000011000010000001000; //  X X 3 X 2 X 1 0
         8'b00101100: bk_datapath_o =  24'b000000010000001000000000; //  X X 2 X 1 0 X X
         8'b00101101: bk_datapath_o =  24'b000000011000010001000000; //  X X 3 X 2 1 X 0
         8'b00101110: bk_datapath_o =  24'b000000011000010001000000; //  X X 3 X 2 1 0 X
         8'b00101111: bk_datapath_o =  24'b000000100000011010001000; //  X X 4 X 3 2 1 0
         8'b00110000: bk_datapath_o =  24'b000000001000000000000000; //  X X 1 0 X X X X
         8'b00110001: bk_datapath_o =  24'b000000010001000000000000; //  X X 2 1 X X X 0
         8'b00110010: bk_datapath_o =  24'b000000010001000000000000; //  X X 2 1 X X 0 X
         8'b00110011: bk_datapath_o =  24'b000000011010000000001000; //  X X 3 2 X X 1 0
         8'b00110100: bk_datapath_o =  24'b000000010001000000000000; //  X X 2 1 X 0 X X
         8'b00110101: bk_datapath_o =  24'b000000011010000001000000; //  X X 3 2 X 1 X 0
         8'b00110110: bk_datapath_o =  24'b000000011010000001000000; //  X X 3 2 X 1 0 X
         8'b00110111: bk_datapath_o =  24'b000000100011000010001000; //  X X 4 3 X 2 1 0
         8'b00111000: bk_datapath_o =  24'b000000010001000000000000; //  X X 2 1 0 X X X
         8'b00111001: bk_datapath_o =  24'b000000011010001000000000; //  X X 3 2 1 X X 0
         8'b00111010: bk_datapath_o =  24'b000000011010001000000000; //  X X 3 2 1 X 0 X
         8'b00111011: bk_datapath_o =  24'b000000100011010000001000; //  X X 4 3 2 X 1 0
         8'b00111100: bk_datapath_o =  24'b000000011010001000000000; //  X X 3 2 1 0 X X
         8'b00111101: bk_datapath_o =  24'b000000100011010001000000; //  X X 4 3 2 1 X 0
         8'b00111110: bk_datapath_o =  24'b000000100011010001000000; //  X X 4 3 2 1 0 X
         8'b00111111: bk_datapath_o =  24'b000000101100011010001000; //  X X 5 4 3 2 1 0
         8'b01000000: bk_datapath_o =  24'b000000000000000000000000; //  X 0 X X X X X X
         8'b01000001: bk_datapath_o =  24'b000001000000000000000000; //  X 1 X X X X X 0
         8'b01000010: bk_datapath_o =  24'b000001000000000000000000; //  X 1 X X X X 0 X
         8'b01000011: bk_datapath_o =  24'b000010000000000000001000; //  X 2 X X X X 1 0
         8'b01000100: bk_datapath_o =  24'b000001000000000000000000; //  X 1 X X X 0 X X
         8'b01000101: bk_datapath_o =  24'b000010000000000001000000; //  X 2 X X X 1 X 0
         8'b01000110: bk_datapath_o =  24'b000010000000000001000000; //  X 2 X X X 1 0 X
         8'b01000111: bk_datapath_o =  24'b000011000000000010001000; //  X 3 X X X 2 1 0
         8'b01001000: bk_datapath_o =  24'b000001000000000000000000; //  X 1 X X 0 X X X
         8'b01001001: bk_datapath_o =  24'b000010000000001000000000; //  X 2 X X 1 X X 0
         8'b01001010: bk_datapath_o =  24'b000010000000001000000000; //  X 2 X X 1 X 0 X
         8'b01001011: bk_datapath_o =  24'b000011000000010000001000; //  X 3 X X 2 X 1 0
         8'b01001100: bk_datapath_o =  24'b000010000000001000000000; //  X 2 X X 1 0 X X
         8'b01001101: bk_datapath_o =  24'b000011000000010001000000; //  X 3 X X 2 1 X 0
         8'b01001110: bk_datapath_o =  24'b000011000000010001000000; //  X 3 X X 2 1 0 X
         8'b01001111: bk_datapath_o =  24'b000100000000011010001000; //  X 4 X X 3 2 1 0
         8'b01010000: bk_datapath_o =  24'b000001000000000000000000; //  X 1 X 0 X X X X
         8'b01010001: bk_datapath_o =  24'b000010000001000000000000; //  X 2 X 1 X X X 0
         8'b01010010: bk_datapath_o =  24'b000010000001000000000000; //  X 2 X 1 X X 0 X
         8'b01010011: bk_datapath_o =  24'b000011000010000000001000; //  X 3 X 2 X X 1 0
         8'b01010100: bk_datapath_o =  24'b000010000001000000000000; //  X 2 X 1 X 0 X X
         8'b01010101: bk_datapath_o =  24'b000011000010000001000000; //  X 3 X 2 X 1 X 0
         8'b01010110: bk_datapath_o =  24'b000011000010000001000000; //  X 3 X 2 X 1 0 X
         8'b01010111: bk_datapath_o =  24'b000100000011000010001000; //  X 4 X 3 X 2 1 0
         8'b01011000: bk_datapath_o =  24'b000010000001000000000000; //  X 2 X 1 0 X X X
         8'b01011001: bk_datapath_o =  24'b000011000010001000000000; //  X 3 X 2 1 X X 0
         8'b01011010: bk_datapath_o =  24'b000011000010001000000000; //  X 3 X 2 1 X 0 X
         8'b01011011: bk_datapath_o =  24'b000100000011010000001000; //  X 4 X 3 2 X 1 0
         8'b01011100: bk_datapath_o =  24'b000011000010001000000000; //  X 3 X 2 1 0 X X
         8'b01011101: bk_datapath_o =  24'b000100000011010001000000; //  X 4 X 3 2 1 X 0
         8'b01011110: bk_datapath_o =  24'b000100000011010001000000; //  X 4 X 3 2 1 0 X
         8'b01011111: bk_datapath_o =  24'b000101000100011010001000; //  X 5 X 4 3 2 1 0
         8'b01100000: bk_datapath_o =  24'b000001000000000000000000; //  X 1 0 X X X X X
         8'b01100001: bk_datapath_o =  24'b000010001000000000000000; //  X 2 1 X X X X 0
         8'b01100010: bk_datapath_o =  24'b000010001000000000000000; //  X 2 1 X X X 0 X
         8'b01100011: bk_datapath_o =  24'b000011010000000000001000; //  X 3 2 X X X 1 0
         8'b01100100: bk_datapath_o =  24'b000010001000000000000000; //  X 2 1 X X 0 X X
         8'b01100101: bk_datapath_o =  24'b000011010000000001000000; //  X 3 2 X X 1 X 0
         8'b01100110: bk_datapath_o =  24'b000011010000000001000000; //  X 3 2 X X 1 0 X
         8'b01100111: bk_datapath_o =  24'b000100011000000010001000; //  X 4 3 X X 2 1 0
         8'b01101000: bk_datapath_o =  24'b000010001000000000000000; //  X 2 1 X 0 X X X
         8'b01101001: bk_datapath_o =  24'b000011010000001000000000; //  X 3 2 X 1 X X 0
         8'b01101010: bk_datapath_o =  24'b000011010000001000000000; //  X 3 2 X 1 X 0 X
         8'b01101011: bk_datapath_o =  24'b000100011000010000001000; //  X 4 3 X 2 X 1 0
         8'b01101100: bk_datapath_o =  24'b000011010000001000000000; //  X 3 2 X 1 0 X X
         8'b01101101: bk_datapath_o =  24'b000100011000010001000000; //  X 4 3 X 2 1 X 0
         8'b01101110: bk_datapath_o =  24'b000100011000010001000000; //  X 4 3 X 2 1 0 X
         8'b01101111: bk_datapath_o =  24'b000101100000011010001000; //  X 5 4 X 3 2 1 0
         8'b01110000: bk_datapath_o =  24'b000010001000000000000000; //  X 2 1 0 X X X X
         8'b01110001: bk_datapath_o =  24'b000011010001000000000000; //  X 3 2 1 X X X 0
         8'b01110010: bk_datapath_o =  24'b000011010001000000000000; //  X 3 2 1 X X 0 X
         8'b01110011: bk_datapath_o =  24'b000100011010000000001000; //  X 4 3 2 X X 1 0
         8'b01110100: bk_datapath_o =  24'b000011010001000000000000; //  X 3 2 1 X 0 X X
         8'b01110101: bk_datapath_o =  24'b000100011010000001000000; //  X 4 3 2 X 1 X 0
         8'b01110110: bk_datapath_o =  24'b000100011010000001000000; //  X 4 3 2 X 1 0 X
         8'b01110111: bk_datapath_o =  24'b000101100011000010001000; //  X 5 4 3 X 2 1 0
         8'b01111000: bk_datapath_o =  24'b000011010001000000000000; //  X 3 2 1 0 X X X
         8'b01111001: bk_datapath_o =  24'b000100011010001000000000; //  X 4 3 2 1 X X 0
         8'b01111010: bk_datapath_o =  24'b000100011010001000000000; //  X 4 3 2 1 X 0 X
         8'b01111011: bk_datapath_o =  24'b000101100011010000001000; //  X 5 4 3 2 X 1 0
         8'b01111100: bk_datapath_o =  24'b000100011010001000000000; //  X 4 3 2 1 0 X X
         8'b01111101: bk_datapath_o =  24'b000101100011010001000000; //  X 5 4 3 2 1 X 0
         8'b01111110: bk_datapath_o =  24'b000101100011010001000000; //  X 5 4 3 2 1 0 X
         8'b01111111: bk_datapath_o =  24'b000110101100011010001000; //  X 6 5 4 3 2 1 0
         8'b10000000: bk_datapath_o =  24'b000000000000000000000000; //  0 X X X X X X X
         8'b10000001: bk_datapath_o =  24'b001000000000000000000000; //  1 X X X X X X 0
         8'b10000010: bk_datapath_o =  24'b001000000000000000000000; //  1 X X X X X 0 X
         8'b10000011: bk_datapath_o =  24'b010000000000000000001000; //  2 X X X X X 1 0
         8'b10000100: bk_datapath_o =  24'b001000000000000000000000; //  1 X X X X 0 X X
         8'b10000101: bk_datapath_o =  24'b010000000000000001000000; //  2 X X X X 1 X 0
         8'b10000110: bk_datapath_o =  24'b010000000000000001000000; //  2 X X X X 1 0 X
         8'b10000111: bk_datapath_o =  24'b011000000000000010001000; //  3 X X X X 2 1 0
         8'b10001000: bk_datapath_o =  24'b001000000000000000000000; //  1 X X X 0 X X X
         8'b10001001: bk_datapath_o =  24'b010000000000001000000000; //  2 X X X 1 X X 0
         8'b10001010: bk_datapath_o =  24'b010000000000001000000000; //  2 X X X 1 X 0 X
         8'b10001011: bk_datapath_o =  24'b011000000000010000001000; //  3 X X X 2 X 1 0
         8'b10001100: bk_datapath_o =  24'b010000000000001000000000; //  2 X X X 1 0 X X
         8'b10001101: bk_datapath_o =  24'b011000000000010001000000; //  3 X X X 2 1 X 0
         8'b10001110: bk_datapath_o =  24'b011000000000010001000000; //  3 X X X 2 1 0 X
         8'b10001111: bk_datapath_o =  24'b100000000000011010001000; //  4 X X X 3 2 1 0
         8'b10010000: bk_datapath_o =  24'b001000000000000000000000; //  1 X X 0 X X X X
         8'b10010001: bk_datapath_o =  24'b010000000001000000000000; //  2 X X 1 X X X 0
         8'b10010010: bk_datapath_o =  24'b010000000001000000000000; //  2 X X 1 X X 0 X
         8'b10010011: bk_datapath_o =  24'b011000000010000000001000; //  3 X X 2 X X 1 0
         8'b10010100: bk_datapath_o =  24'b010000000001000000000000; //  2 X X 1 X 0 X X
         8'b10010101: bk_datapath_o =  24'b011000000010000001000000; //  3 X X 2 X 1 X 0
         8'b10010110: bk_datapath_o =  24'b011000000010000001000000; //  3 X X 2 X 1 0 X
         8'b10010111: bk_datapath_o =  24'b100000000011000010001000; //  4 X X 3 X 2 1 0
         8'b10011000: bk_datapath_o =  24'b010000000001000000000000; //  2 X X 1 0 X X X
         8'b10011001: bk_datapath_o =  24'b011000000010001000000000; //  3 X X 2 1 X X 0
         8'b10011010: bk_datapath_o =  24'b011000000010001000000000; //  3 X X 2 1 X 0 X
         8'b10011011: bk_datapath_o =  24'b100000000011010000001000; //  4 X X 3 2 X 1 0
         8'b10011100: bk_datapath_o =  24'b011000000010001000000000; //  3 X X 2 1 0 X X
         8'b10011101: bk_datapath_o =  24'b100000000011010001000000; //  4 X X 3 2 1 X 0
         8'b10011110: bk_datapath_o =  24'b100000000011010001000000; //  4 X X 3 2 1 0 X
         8'b10011111: bk_datapath_o =  24'b101000000100011010001000; //  5 X X 4 3 2 1 0
         8'b10100000: bk_datapath_o =  24'b001000000000000000000000; //  1 X 0 X X X X X
         8'b10100001: bk_datapath_o =  24'b010000001000000000000000; //  2 X 1 X X X X 0
         8'b10100010: bk_datapath_o =  24'b010000001000000000000000; //  2 X 1 X X X 0 X
         8'b10100011: bk_datapath_o =  24'b011000010000000000001000; //  3 X 2 X X X 1 0
         8'b10100100: bk_datapath_o =  24'b010000001000000000000000; //  2 X 1 X X 0 X X
         8'b10100101: bk_datapath_o =  24'b011000010000000001000000; //  3 X 2 X X 1 X 0
         8'b10100110: bk_datapath_o =  24'b011000010000000001000000; //  3 X 2 X X 1 0 X
         8'b10100111: bk_datapath_o =  24'b100000011000000010001000; //  4 X 3 X X 2 1 0
         8'b10101000: bk_datapath_o =  24'b010000001000000000000000; //  2 X 1 X 0 X X X
         8'b10101001: bk_datapath_o =  24'b011000010000001000000000; //  3 X 2 X 1 X X 0
         8'b10101010: bk_datapath_o =  24'b011000010000001000000000; //  3 X 2 X 1 X 0 X
         8'b10101011: bk_datapath_o =  24'b100000011000010000001000; //  4 X 3 X 2 X 1 0
         8'b10101100: bk_datapath_o =  24'b011000010000001000000000; //  3 X 2 X 1 0 X X
         8'b10101101: bk_datapath_o =  24'b100000011000010001000000; //  4 X 3 X 2 1 X 0
         8'b10101110: bk_datapath_o =  24'b100000011000010001000000; //  4 X 3 X 2 1 0 X
         8'b10101111: bk_datapath_o =  24'b101000100000011010001000; //  5 X 4 X 3 2 1 0
         8'b10110000: bk_datapath_o =  24'b010000001000000000000000; //  2 X 1 0 X X X X
         8'b10110001: bk_datapath_o =  24'b011000010001000000000000; //  3 X 2 1 X X X 0
         8'b10110010: bk_datapath_o =  24'b011000010001000000000000; //  3 X 2 1 X X 0 X
         8'b10110011: bk_datapath_o =  24'b100000011010000000001000; //  4 X 3 2 X X 1 0
         8'b10110100: bk_datapath_o =  24'b011000010001000000000000; //  3 X 2 1 X 0 X X
         8'b10110101: bk_datapath_o =  24'b100000011010000001000000; //  4 X 3 2 X 1 X 0
         8'b10110110: bk_datapath_o =  24'b100000011010000001000000; //  4 X 3 2 X 1 0 X
         8'b10110111: bk_datapath_o =  24'b101000100011000010001000; //  5 X 4 3 X 2 1 0
         8'b10111000: bk_datapath_o =  24'b011000010001000000000000; //  3 X 2 1 0 X X X
         8'b10111001: bk_datapath_o =  24'b100000011010001000000000; //  4 X 3 2 1 X X 0
         8'b10111010: bk_datapath_o =  24'b100000011010001000000000; //  4 X 3 2 1 X 0 X
         8'b10111011: bk_datapath_o =  24'b101000100011010000001000; //  5 X 4 3 2 X 1 0
         8'b10111100: bk_datapath_o =  24'b100000011010001000000000; //  4 X 3 2 1 0 X X
         8'b10111101: bk_datapath_o =  24'b101000100011010001000000; //  5 X 4 3 2 1 X 0
         8'b10111110: bk_datapath_o =  24'b101000100011010001000000; //  5 X 4 3 2 1 0 X
         8'b10111111: bk_datapath_o =  24'b110000101100011010001000; //  6 X 5 4 3 2 1 0
         8'b11000000: bk_datapath_o =  24'b001000000000000000000000; //  1 0 X X X X X X
         8'b11000001: bk_datapath_o =  24'b010001000000000000000000; //  2 1 X X X X X 0
         8'b11000010: bk_datapath_o =  24'b010001000000000000000000; //  2 1 X X X X 0 X
         8'b11000011: bk_datapath_o =  24'b011010000000000000001000; //  3 2 X X X X 1 0
         8'b11000100: bk_datapath_o =  24'b010001000000000000000000; //  2 1 X X X 0 X X
         8'b11000101: bk_datapath_o =  24'b011010000000000001000000; //  3 2 X X X 1 X 0
         8'b11000110: bk_datapath_o =  24'b011010000000000001000000; //  3 2 X X X 1 0 X
         8'b11000111: bk_datapath_o =  24'b100011000000000010001000; //  4 3 X X X 2 1 0
         8'b11001000: bk_datapath_o =  24'b010001000000000000000000; //  2 1 X X 0 X X X
         8'b11001001: bk_datapath_o =  24'b011010000000001000000000; //  3 2 X X 1 X X 0
         8'b11001010: bk_datapath_o =  24'b011010000000001000000000; //  3 2 X X 1 X 0 X
         8'b11001011: bk_datapath_o =  24'b100011000000010000001000; //  4 3 X X 2 X 1 0
         8'b11001100: bk_datapath_o =  24'b011010000000001000000000; //  3 2 X X 1 0 X X
         8'b11001101: bk_datapath_o =  24'b100011000000010001000000; //  4 3 X X 2 1 X 0
         8'b11001110: bk_datapath_o =  24'b100011000000010001000000; //  4 3 X X 2 1 0 X
         8'b11001111: bk_datapath_o =  24'b101100000000011010001000; //  5 4 X X 3 2 1 0
         8'b11010000: bk_datapath_o =  24'b010001000000000000000000; //  2 1 X 0 X X X X
         8'b11010001: bk_datapath_o =  24'b011010000001000000000000; //  3 2 X 1 X X X 0
         8'b11010010: bk_datapath_o =  24'b011010000001000000000000; //  3 2 X 1 X X 0 X
         8'b11010011: bk_datapath_o =  24'b100011000010000000001000; //  4 3 X 2 X X 1 0
         8'b11010100: bk_datapath_o =  24'b011010000001000000000000; //  3 2 X 1 X 0 X X
         8'b11010101: bk_datapath_o =  24'b100011000010000001000000; //  4 3 X 2 X 1 X 0
         8'b11010110: bk_datapath_o =  24'b100011000010000001000000; //  4 3 X 2 X 1 0 X
         8'b11010111: bk_datapath_o =  24'b101100000011000010001000; //  5 4 X 3 X 2 1 0
         8'b11011000: bk_datapath_o =  24'b011010000001000000000000; //  3 2 X 1 0 X X X
         8'b11011001: bk_datapath_o =  24'b100011000010001000000000; //  4 3 X 2 1 X X 0
         8'b11011010: bk_datapath_o =  24'b100011000010001000000000; //  4 3 X 2 1 X 0 X
         8'b11011011: bk_datapath_o =  24'b101100000011010000001000; //  5 4 X 3 2 X 1 0
         8'b11011100: bk_datapath_o =  24'b100011000010001000000000; //  4 3 X 2 1 0 X X
         8'b11011101: bk_datapath_o =  24'b101100000011010001000000; //  5 4 X 3 2 1 X 0
         8'b11011110: bk_datapath_o =  24'b101100000011010001000000; //  5 4 X 3 2 1 0 X
         8'b11011111: bk_datapath_o =  24'b110101000100011010001000; //  6 5 X 4 3 2 1 0
         8'b11100000: bk_datapath_o =  24'b010001000000000000000000; //  2 1 0 X X X X X
         8'b11100001: bk_datapath_o =  24'b011010001000000000000000; //  3 2 1 X X X X 0
         8'b11100010: bk_datapath_o =  24'b011010001000000000000000; //  3 2 1 X X X 0 X
         8'b11100011: bk_datapath_o =  24'b100011010000000000001000; //  4 3 2 X X X 1 0
         8'b11100100: bk_datapath_o =  24'b011010001000000000000000; //  3 2 1 X X 0 X X
         8'b11100101: bk_datapath_o =  24'b100011010000000001000000; //  4 3 2 X X 1 X 0
         8'b11100110: bk_datapath_o =  24'b100011010000000001000000; //  4 3 2 X X 1 0 X
         8'b11100111: bk_datapath_o =  24'b101100011000000010001000; //  5 4 3 X X 2 1 0
         8'b11101000: bk_datapath_o =  24'b011010001000000000000000; //  3 2 1 X 0 X X X
         8'b11101001: bk_datapath_o =  24'b100011010000001000000000; //  4 3 2 X 1 X X 0
         8'b11101010: bk_datapath_o =  24'b100011010000001000000000; //  4 3 2 X 1 X 0 X
         8'b11101011: bk_datapath_o =  24'b101100011000010000001000; //  5 4 3 X 2 X 1 0
         8'b11101100: bk_datapath_o =  24'b100011010000001000000000; //  4 3 2 X 1 0 X X
         8'b11101101: bk_datapath_o =  24'b101100011000010001000000; //  5 4 3 X 2 1 X 0
         8'b11101110: bk_datapath_o =  24'b101100011000010001000000; //  5 4 3 X 2 1 0 X
         8'b11101111: bk_datapath_o =  24'b110101100000011010001000; //  6 5 4 X 3 2 1 0
         8'b11110000: bk_datapath_o =  24'b011010001000000000000000; //  3 2 1 0 X X X X
         8'b11110001: bk_datapath_o =  24'b100011010001000000000000; //  4 3 2 1 X X X 0
         8'b11110010: bk_datapath_o =  24'b100011010001000000000000; //  4 3 2 1 X X 0 X
         8'b11110011: bk_datapath_o =  24'b101100011010000000001000; //  5 4 3 2 X X 1 0
         8'b11110100: bk_datapath_o =  24'b100011010001000000000000; //  4 3 2 1 X 0 X X
         8'b11110101: bk_datapath_o =  24'b101100011010000001000000; //  5 4 3 2 X 1 X 0
         8'b11110110: bk_datapath_o =  24'b101100011010000001000000; //  5 4 3 2 X 1 0 X
         8'b11110111: bk_datapath_o =  24'b110101100011000010001000; //  6 5 4 3 X 2 1 0
         8'b11111000: bk_datapath_o =  24'b100011010001000000000000; //  4 3 2 1 0 X X X
         8'b11111001: bk_datapath_o =  24'b101100011010001000000000; //  5 4 3 2 1 X X 0
         8'b11111010: bk_datapath_o =  24'b101100011010001000000000; //  5 4 3 2 1 X 0 X
         8'b11111011: bk_datapath_o =  24'b110101100011010000001000; //  6 5 4 3 2 X 1 0
         8'b11111100: bk_datapath_o =  24'b101100011010001000000000; //  5 4 3 2 1 0 X X
         8'b11111101: bk_datapath_o =  24'b110101100011010001000000; //  6 5 4 3 2 1 X 0
         8'b11111110: bk_datapath_o =  24'b110101100011010001000000; //  6 5 4 3 2 1 0 X
         8'b11111111: bk_datapath_o =  24'b111110101100011010001000; //  7 6 5 4 3 2 1 0
        default: bk_datapath_o= 'X;
    endcase

    // fwd vec
    always_comb
    unique case (vec_i) 
         8'b00000000: fwd_o =  24'b111111111111111111111111; //  X X X X X X X X
         8'b00000001: fwd_o =  24'b111111111111111111111000; //  X X X X X X X 0
         8'b00000010: fwd_o =  24'b111111111111111111111001; //  X X X X X X X 1
         8'b00000011: fwd_o =  24'b111111111111111111001000; //  X X X X X X 1 0
         8'b00000100: fwd_o =  24'b111111111111111111111010; //  X X X X X X X 2
         8'b00000101: fwd_o =  24'b111111111111111111010000; //  X X X X X X 2 0
         8'b00000110: fwd_o =  24'b111111111111111111010001; //  X X X X X X 2 1
         8'b00000111: fwd_o =  24'b111111111111111010001000; //  X X X X X 2 1 0
         8'b00001000: fwd_o =  24'b111111111111111111111011; //  X X X X X X X 3
         8'b00001001: fwd_o =  24'b111111111111111111011000; //  X X X X X X 3 0
         8'b00001010: fwd_o =  24'b111111111111111111011001; //  X X X X X X 3 1
         8'b00001011: fwd_o =  24'b111111111111111011001000; //  X X X X X 3 1 0
         8'b00001100: fwd_o =  24'b111111111111111111011010; //  X X X X X X 3 2
         8'b00001101: fwd_o =  24'b111111111111111011010000; //  X X X X X 3 2 0
         8'b00001110: fwd_o =  24'b111111111111111011010001; //  X X X X X 3 2 1
         8'b00001111: fwd_o =  24'b111111111111011010001000; //  X X X X 3 2 1 0
         8'b00010000: fwd_o =  24'b111111111111111111111100; //  X X X X X X X 4
         8'b00010001: fwd_o =  24'b111111111111111111100000; //  X X X X X X 4 0
         8'b00010010: fwd_o =  24'b111111111111111111100001; //  X X X X X X 4 1
         8'b00010011: fwd_o =  24'b111111111111111100001000; //  X X X X X 4 1 0
         8'b00010100: fwd_o =  24'b111111111111111111100010; //  X X X X X X 4 2
         8'b00010101: fwd_o =  24'b111111111111111100010000; //  X X X X X 4 2 0
         8'b00010110: fwd_o =  24'b111111111111111100010001; //  X X X X X 4 2 1
         8'b00010111: fwd_o =  24'b111111111111100010001000; //  X X X X 4 2 1 0
         8'b00011000: fwd_o =  24'b111111111111111111100011; //  X X X X X X 4 3
         8'b00011001: fwd_o =  24'b111111111111111100011000; //  X X X X X 4 3 0
         8'b00011010: fwd_o =  24'b111111111111111100011001; //  X X X X X 4 3 1
         8'b00011011: fwd_o =  24'b111111111111100011001000; //  X X X X 4 3 1 0
         8'b00011100: fwd_o =  24'b111111111111111100011010; //  X X X X X 4 3 2
         8'b00011101: fwd_o =  24'b111111111111100011010000; //  X X X X 4 3 2 0
         8'b00011110: fwd_o =  24'b111111111111100011010001; //  X X X X 4 3 2 1
         8'b00011111: fwd_o =  24'b111111111100011010001000; //  X X X 4 3 2 1 0
         8'b00100000: fwd_o =  24'b111111111111111111111101; //  X X X X X X X 5
         8'b00100001: fwd_o =  24'b111111111111111111101000; //  X X X X X X 5 0
         8'b00100010: fwd_o =  24'b111111111111111111101001; //  X X X X X X 5 1
         8'b00100011: fwd_o =  24'b111111111111111101001000; //  X X X X X 5 1 0
         8'b00100100: fwd_o =  24'b111111111111111111101010; //  X X X X X X 5 2
         8'b00100101: fwd_o =  24'b111111111111111101010000; //  X X X X X 5 2 0
         8'b00100110: fwd_o =  24'b111111111111111101010001; //  X X X X X 5 2 1
         8'b00100111: fwd_o =  24'b111111111111101010001000; //  X X X X 5 2 1 0
         8'b00101000: fwd_o =  24'b111111111111111111101011; //  X X X X X X 5 3
         8'b00101001: fwd_o =  24'b111111111111111101011000; //  X X X X X 5 3 0
         8'b00101010: fwd_o =  24'b111111111111111101011001; //  X X X X X 5 3 1
         8'b00101011: fwd_o =  24'b111111111111101011001000; //  X X X X 5 3 1 0
         8'b00101100: fwd_o =  24'b111111111111111101011010; //  X X X X X 5 3 2
         8'b00101101: fwd_o =  24'b111111111111101011010000; //  X X X X 5 3 2 0
         8'b00101110: fwd_o =  24'b111111111111101011010001; //  X X X X 5 3 2 1
         8'b00101111: fwd_o =  24'b111111111101011010001000; //  X X X 5 3 2 1 0
         8'b00110000: fwd_o =  24'b111111111111111111101100; //  X X X X X X 5 4
         8'b00110001: fwd_o =  24'b111111111111111101100000; //  X X X X X 5 4 0
         8'b00110010: fwd_o =  24'b111111111111111101100001; //  X X X X X 5 4 1
         8'b00110011: fwd_o =  24'b111111111111101100001000; //  X X X X 5 4 1 0
         8'b00110100: fwd_o =  24'b111111111111111101100010; //  X X X X X 5 4 2
         8'b00110101: fwd_o =  24'b111111111111101100010000; //  X X X X 5 4 2 0
         8'b00110110: fwd_o =  24'b111111111111101100010001; //  X X X X 5 4 2 1
         8'b00110111: fwd_o =  24'b111111111101100010001000; //  X X X 5 4 2 1 0
         8'b00111000: fwd_o =  24'b111111111111111101100011; //  X X X X X 5 4 3
         8'b00111001: fwd_o =  24'b111111111111101100011000; //  X X X X 5 4 3 0
         8'b00111010: fwd_o =  24'b111111111111101100011001; //  X X X X 5 4 3 1
         8'b00111011: fwd_o =  24'b111111111101100011001000; //  X X X 5 4 3 1 0
         8'b00111100: fwd_o =  24'b111111111111101100011010; //  X X X X 5 4 3 2
         8'b00111101: fwd_o =  24'b111111111101100011010000; //  X X X 5 4 3 2 0
         8'b00111110: fwd_o =  24'b111111111101100011010001; //  X X X 5 4 3 2 1
         8'b00111111: fwd_o =  24'b111111101100011010001000; //  X X 5 4 3 2 1 0
         8'b01000000: fwd_o =  24'b111111111111111111111110; //  X X X X X X X 6
         8'b01000001: fwd_o =  24'b111111111111111111110000; //  X X X X X X 6 0
         8'b01000010: fwd_o =  24'b111111111111111111110001; //  X X X X X X 6 1
         8'b01000011: fwd_o =  24'b111111111111111110001000; //  X X X X X 6 1 0
         8'b01000100: fwd_o =  24'b111111111111111111110010; //  X X X X X X 6 2
         8'b01000101: fwd_o =  24'b111111111111111110010000; //  X X X X X 6 2 0
         8'b01000110: fwd_o =  24'b111111111111111110010001; //  X X X X X 6 2 1
         8'b01000111: fwd_o =  24'b111111111111110010001000; //  X X X X 6 2 1 0
         8'b01001000: fwd_o =  24'b111111111111111111110011; //  X X X X X X 6 3
         8'b01001001: fwd_o =  24'b111111111111111110011000; //  X X X X X 6 3 0
         8'b01001010: fwd_o =  24'b111111111111111110011001; //  X X X X X 6 3 1
         8'b01001011: fwd_o =  24'b111111111111110011001000; //  X X X X 6 3 1 0
         8'b01001100: fwd_o =  24'b111111111111111110011010; //  X X X X X 6 3 2
         8'b01001101: fwd_o =  24'b111111111111110011010000; //  X X X X 6 3 2 0
         8'b01001110: fwd_o =  24'b111111111111110011010001; //  X X X X 6 3 2 1
         8'b01001111: fwd_o =  24'b111111111110011010001000; //  X X X 6 3 2 1 0
         8'b01010000: fwd_o =  24'b111111111111111111110100; //  X X X X X X 6 4
         8'b01010001: fwd_o =  24'b111111111111111110100000; //  X X X X X 6 4 0
         8'b01010010: fwd_o =  24'b111111111111111110100001; //  X X X X X 6 4 1
         8'b01010011: fwd_o =  24'b111111111111110100001000; //  X X X X 6 4 1 0
         8'b01010100: fwd_o =  24'b111111111111111110100010; //  X X X X X 6 4 2
         8'b01010101: fwd_o =  24'b111111111111110100010000; //  X X X X 6 4 2 0
         8'b01010110: fwd_o =  24'b111111111111110100010001; //  X X X X 6 4 2 1
         8'b01010111: fwd_o =  24'b111111111110100010001000; //  X X X 6 4 2 1 0
         8'b01011000: fwd_o =  24'b111111111111111110100011; //  X X X X X 6 4 3
         8'b01011001: fwd_o =  24'b111111111111110100011000; //  X X X X 6 4 3 0
         8'b01011010: fwd_o =  24'b111111111111110100011001; //  X X X X 6 4 3 1
         8'b01011011: fwd_o =  24'b111111111110100011001000; //  X X X 6 4 3 1 0
         8'b01011100: fwd_o =  24'b111111111111110100011010; //  X X X X 6 4 3 2
         8'b01011101: fwd_o =  24'b111111111110100011010000; //  X X X 6 4 3 2 0
         8'b01011110: fwd_o =  24'b111111111110100011010001; //  X X X 6 4 3 2 1
         8'b01011111: fwd_o =  24'b111111110100011010001000; //  X X 6 4 3 2 1 0
         8'b01100000: fwd_o =  24'b111111111111111111110101; //  X X X X X X 6 5
         8'b01100001: fwd_o =  24'b111111111111111110101000; //  X X X X X 6 5 0
         8'b01100010: fwd_o =  24'b111111111111111110101001; //  X X X X X 6 5 1
         8'b01100011: fwd_o =  24'b111111111111110101001000; //  X X X X 6 5 1 0
         8'b01100100: fwd_o =  24'b111111111111111110101010; //  X X X X X 6 5 2
         8'b01100101: fwd_o =  24'b111111111111110101010000; //  X X X X 6 5 2 0
         8'b01100110: fwd_o =  24'b111111111111110101010001; //  X X X X 6 5 2 1
         8'b01100111: fwd_o =  24'b111111111110101010001000; //  X X X 6 5 2 1 0
         8'b01101000: fwd_o =  24'b111111111111111110101011; //  X X X X X 6 5 3
         8'b01101001: fwd_o =  24'b111111111111110101011000; //  X X X X 6 5 3 0
         8'b01101010: fwd_o =  24'b111111111111110101011001; //  X X X X 6 5 3 1
         8'b01101011: fwd_o =  24'b111111111110101011001000; //  X X X 6 5 3 1 0
         8'b01101100: fwd_o =  24'b111111111111110101011010; //  X X X X 6 5 3 2
         8'b01101101: fwd_o =  24'b111111111110101011010000; //  X X X 6 5 3 2 0
         8'b01101110: fwd_o =  24'b111111111110101011010001; //  X X X 6 5 3 2 1
         8'b01101111: fwd_o =  24'b111111110101011010001000; //  X X 6 5 3 2 1 0
         8'b01110000: fwd_o =  24'b111111111111111110101100; //  X X X X X 6 5 4
         8'b01110001: fwd_o =  24'b111111111111110101100000; //  X X X X 6 5 4 0
         8'b01110010: fwd_o =  24'b111111111111110101100001; //  X X X X 6 5 4 1
         8'b01110011: fwd_o =  24'b111111111110101100001000; //  X X X 6 5 4 1 0
         8'b01110100: fwd_o =  24'b111111111111110101100010; //  X X X X 6 5 4 2
         8'b01110101: fwd_o =  24'b111111111110101100010000; //  X X X 6 5 4 2 0
         8'b01110110: fwd_o =  24'b111111111110101100010001; //  X X X 6 5 4 2 1
         8'b01110111: fwd_o =  24'b111111110101100010001000; //  X X 6 5 4 2 1 0
         8'b01111000: fwd_o =  24'b111111111111110101100011; //  X X X X 6 5 4 3
         8'b01111001: fwd_o =  24'b111111111110101100011000; //  X X X 6 5 4 3 0
         8'b01111010: fwd_o =  24'b111111111110101100011001; //  X X X 6 5 4 3 1
         8'b01111011: fwd_o =  24'b111111110101100011001000; //  X X 6 5 4 3 1 0
         8'b01111100: fwd_o =  24'b111111111110101100011010; //  X X X 6 5 4 3 2
         8'b01111101: fwd_o =  24'b111111110101100011010000; //  X X 6 5 4 3 2 0
         8'b01111110: fwd_o =  24'b111111110101100011010001; //  X X 6 5 4 3 2 1
         8'b01111111: fwd_o =  24'b111110101100011010001000; //  X 6 5 4 3 2 1 0
         8'b10000000: fwd_o =  24'b110110110110110110110111; //  X X X X X X X 7
         8'b10000001: fwd_o =  24'b110110110110110110111000; //  X X X X X X 7 0
         8'b10000010: fwd_o =  24'b110110110110110110111001; //  X X X X X X 7 1
         8'b10000011: fwd_o =  24'b110110110110110111001000; //  X X X X X 7 1 0
         8'b10000100: fwd_o =  24'b110110110110110110111010; //  X X X X X X 7 2
         8'b10000101: fwd_o =  24'b110110110110110111010000; //  X X X X X 7 2 0
         8'b10000110: fwd_o =  24'b110110110110110111010001; //  X X X X X 7 2 1
         8'b10000111: fwd_o =  24'b110110110110111010001000; //  X X X X 7 2 1 0
         8'b10001000: fwd_o =  24'b110110110110110110111011; //  X X X X X X 7 3
         8'b10001001: fwd_o =  24'b110110110110110111011000; //  X X X X X 7 3 0
         8'b10001010: fwd_o =  24'b110110110110110111011001; //  X X X X X 7 3 1
         8'b10001011: fwd_o =  24'b110110110110111011001000; //  X X X X 7 3 1 0
         8'b10001100: fwd_o =  24'b110110110110110111011010; //  X X X X X 7 3 2
         8'b10001101: fwd_o =  24'b110110110110111011010000; //  X X X X 7 3 2 0
         8'b10001110: fwd_o =  24'b110110110110111011010001; //  X X X X 7 3 2 1
         8'b10001111: fwd_o =  24'b110110110111011010001000; //  X X X 7 3 2 1 0
         8'b10010000: fwd_o =  24'b110110110110110110111100; //  X X X X X X 7 4
         8'b10010001: fwd_o =  24'b110110110110110111100000; //  X X X X X 7 4 0
         8'b10010010: fwd_o =  24'b110110110110110111100001; //  X X X X X 7 4 1
         8'b10010011: fwd_o =  24'b110110110110111100001000; //  X X X X 7 4 1 0
         8'b10010100: fwd_o =  24'b110110110110110111100010; //  X X X X X 7 4 2
         8'b10010101: fwd_o =  24'b110110110110111100010000; //  X X X X 7 4 2 0
         8'b10010110: fwd_o =  24'b110110110110111100010001; //  X X X X 7 4 2 1
         8'b10010111: fwd_o =  24'b110110110111100010001000; //  X X X 7 4 2 1 0
         8'b10011000: fwd_o =  24'b110110110110110111100011; //  X X X X X 7 4 3
         8'b10011001: fwd_o =  24'b110110110110111100011000; //  X X X X 7 4 3 0
         8'b10011010: fwd_o =  24'b110110110110111100011001; //  X X X X 7 4 3 1
         8'b10011011: fwd_o =  24'b110110110111100011001000; //  X X X 7 4 3 1 0
         8'b10011100: fwd_o =  24'b110110110110111100011010; //  X X X X 7 4 3 2
         8'b10011101: fwd_o =  24'b110110110111100011010000; //  X X X 7 4 3 2 0
         8'b10011110: fwd_o =  24'b110110110111100011010001; //  X X X 7 4 3 2 1
         8'b10011111: fwd_o =  24'b110110111100011010001000; //  X X 7 4 3 2 1 0
         8'b10100000: fwd_o =  24'b110110110110110110111101; //  X X X X X X 7 5
         8'b10100001: fwd_o =  24'b110110110110110111101000; //  X X X X X 7 5 0
         8'b10100010: fwd_o =  24'b110110110110110111101001; //  X X X X X 7 5 1
         8'b10100011: fwd_o =  24'b110110110110111101001000; //  X X X X 7 5 1 0
         8'b10100100: fwd_o =  24'b110110110110110111101010; //  X X X X X 7 5 2
         8'b10100101: fwd_o =  24'b110110110110111101010000; //  X X X X 7 5 2 0
         8'b10100110: fwd_o =  24'b110110110110111101010001; //  X X X X 7 5 2 1
         8'b10100111: fwd_o =  24'b110110110111101010001000; //  X X X 7 5 2 1 0
         8'b10101000: fwd_o =  24'b110110110110110111101011; //  X X X X X 7 5 3
         8'b10101001: fwd_o =  24'b110110110110111101011000; //  X X X X 7 5 3 0
         8'b10101010: fwd_o =  24'b110110110110111101011001; //  X X X X 7 5 3 1
         8'b10101011: fwd_o =  24'b110110110111101011001000; //  X X X 7 5 3 1 0
         8'b10101100: fwd_o =  24'b110110110110111101011010; //  X X X X 7 5 3 2
         8'b10101101: fwd_o =  24'b110110110111101011010000; //  X X X 7 5 3 2 0
         8'b10101110: fwd_o =  24'b110110110111101011010001; //  X X X 7 5 3 2 1
         8'b10101111: fwd_o =  24'b110110111101011010001000; //  X X 7 5 3 2 1 0
         8'b10110000: fwd_o =  24'b110110110110110111101100; //  X X X X X 7 5 4
         8'b10110001: fwd_o =  24'b110110110110111101100000; //  X X X X 7 5 4 0
         8'b10110010: fwd_o =  24'b110110110110111101100001; //  X X X X 7 5 4 1
         8'b10110011: fwd_o =  24'b110110110111101100001000; //  X X X 7 5 4 1 0
         8'b10110100: fwd_o =  24'b110110110110111101100010; //  X X X X 7 5 4 2
         8'b10110101: fwd_o =  24'b110110110111101100010000; //  X X X 7 5 4 2 0
         8'b10110110: fwd_o =  24'b110110110111101100010001; //  X X X 7 5 4 2 1
         8'b10110111: fwd_o =  24'b110110111101100010001000; //  X X 7 5 4 2 1 0
         8'b10111000: fwd_o =  24'b110110110110111101100011; //  X X X X 7 5 4 3
         8'b10111001: fwd_o =  24'b110110110111101100011000; //  X X X 7 5 4 3 0
         8'b10111010: fwd_o =  24'b110110110111101100011001; //  X X X 7 5 4 3 1
         8'b10111011: fwd_o =  24'b110110111101100011001000; //  X X 7 5 4 3 1 0
         8'b10111100: fwd_o =  24'b110110110111101100011010; //  X X X 7 5 4 3 2
         8'b10111101: fwd_o =  24'b110110111101100011010000; //  X X 7 5 4 3 2 0
         8'b10111110: fwd_o =  24'b110110111101100011010001; //  X X 7 5 4 3 2 1
         8'b10111111: fwd_o =  24'b110111101100011010001000; //  X 7 5 4 3 2 1 0
         8'b11000000: fwd_o =  24'b101101101101101101111110; //  X X X X X X 7 6
         8'b11000001: fwd_o =  24'b101101101101101111110000; //  X X X X X 7 6 0
         8'b11000010: fwd_o =  24'b101101101101101111110001; //  X X X X X 7 6 1
         8'b11000011: fwd_o =  24'b101101101101111110001000; //  X X X X 7 6 1 0
         8'b11000100: fwd_o =  24'b101101101101101111110010; //  X X X X X 7 6 2
         8'b11000101: fwd_o =  24'b101101101101111110010000; //  X X X X 7 6 2 0
         8'b11000110: fwd_o =  24'b101101101101111110010001; //  X X X X 7 6 2 1
         8'b11000111: fwd_o =  24'b101101101111110010001000; //  X X X 7 6 2 1 0
         8'b11001000: fwd_o =  24'b101101101101101111110011; //  X X X X X 7 6 3
         8'b11001001: fwd_o =  24'b101101101101111110011000; //  X X X X 7 6 3 0
         8'b11001010: fwd_o =  24'b101101101101111110011001; //  X X X X 7 6 3 1
         8'b11001011: fwd_o =  24'b101101101111110011001000; //  X X X 7 6 3 1 0
         8'b11001100: fwd_o =  24'b101101101101111110011010; //  X X X X 7 6 3 2
         8'b11001101: fwd_o =  24'b101101101111110011010000; //  X X X 7 6 3 2 0
         8'b11001110: fwd_o =  24'b101101101111110011010001; //  X X X 7 6 3 2 1
         8'b11001111: fwd_o =  24'b101101111110011010001000; //  X X 7 6 3 2 1 0
         8'b11010000: fwd_o =  24'b101101101101101111110100; //  X X X X X 7 6 4
         8'b11010001: fwd_o =  24'b101101101101111110100000; //  X X X X 7 6 4 0
         8'b11010010: fwd_o =  24'b101101101101111110100001; //  X X X X 7 6 4 1
         8'b11010011: fwd_o =  24'b101101101111110100001000; //  X X X 7 6 4 1 0
         8'b11010100: fwd_o =  24'b101101101101111110100010; //  X X X X 7 6 4 2
         8'b11010101: fwd_o =  24'b101101101111110100010000; //  X X X 7 6 4 2 0
         8'b11010110: fwd_o =  24'b101101101111110100010001; //  X X X 7 6 4 2 1
         8'b11010111: fwd_o =  24'b101101111110100010001000; //  X X 7 6 4 2 1 0
         8'b11011000: fwd_o =  24'b101101101101111110100011; //  X X X X 7 6 4 3
         8'b11011001: fwd_o =  24'b101101101111110100011000; //  X X X 7 6 4 3 0
         8'b11011010: fwd_o =  24'b101101101111110100011001; //  X X X 7 6 4 3 1
         8'b11011011: fwd_o =  24'b101101111110100011001000; //  X X 7 6 4 3 1 0
         8'b11011100: fwd_o =  24'b101101101111110100011010; //  X X X 7 6 4 3 2
         8'b11011101: fwd_o =  24'b101101111110100011010000; //  X X 7 6 4 3 2 0
         8'b11011110: fwd_o =  24'b101101111110100011010001; //  X X 7 6 4 3 2 1
         8'b11011111: fwd_o =  24'b101111110100011010001000; //  X 7 6 4 3 2 1 0
         8'b11100000: fwd_o =  24'b100100100100100111110101; //  X X X X X 7 6 5
         8'b11100001: fwd_o =  24'b100100100100111110101000; //  X X X X 7 6 5 0
         8'b11100010: fwd_o =  24'b100100100100111110101001; //  X X X X 7 6 5 1
         8'b11100011: fwd_o =  24'b100100100111110101001000; //  X X X 7 6 5 1 0
         8'b11100100: fwd_o =  24'b100100100100111110101010; //  X X X X 7 6 5 2
         8'b11100101: fwd_o =  24'b100100100111110101010000; //  X X X 7 6 5 2 0
         8'b11100110: fwd_o =  24'b100100100111110101010001; //  X X X 7 6 5 2 1
         8'b11100111: fwd_o =  24'b100100111110101010001000; //  X X 7 6 5 2 1 0
         8'b11101000: fwd_o =  24'b100100100100111110101011; //  X X X X 7 6 5 3
         8'b11101001: fwd_o =  24'b100100100111110101011000; //  X X X 7 6 5 3 0
         8'b11101010: fwd_o =  24'b100100100111110101011001; //  X X X 7 6 5 3 1
         8'b11101011: fwd_o =  24'b100100111110101011001000; //  X X 7 6 5 3 1 0
         8'b11101100: fwd_o =  24'b100100100111110101011010; //  X X X 7 6 5 3 2
         8'b11101101: fwd_o =  24'b100100111110101011010000; //  X X 7 6 5 3 2 0
         8'b11101110: fwd_o =  24'b100100111110101011010001; //  X X 7 6 5 3 2 1
         8'b11101111: fwd_o =  24'b100111110101011010001000; //  X 7 6 5 3 2 1 0
         8'b11110000: fwd_o =  24'b011011011011111110101100; //  X X X X 7 6 5 4
         8'b11110001: fwd_o =  24'b011011011111110101100000; //  X X X 7 6 5 4 0
         8'b11110010: fwd_o =  24'b011011011111110101100001; //  X X X 7 6 5 4 1
         8'b11110011: fwd_o =  24'b011011111110101100001000; //  X X 7 6 5 4 1 0
         8'b11110100: fwd_o =  24'b011011011111110101100010; //  X X X 7 6 5 4 2
         8'b11110101: fwd_o =  24'b011011111110101100010000; //  X X 7 6 5 4 2 0
         8'b11110110: fwd_o =  24'b011011111110101100010001; //  X X 7 6 5 4 2 1
         8'b11110111: fwd_o =  24'b011111110101100010001000; //  X 7 6 5 4 2 1 0
         8'b11111000: fwd_o =  24'b010010010111110101100011; //  X X X 7 6 5 4 3
         8'b11111001: fwd_o =  24'b010010111110101100011000; //  X X 7 6 5 4 3 0
         8'b11111010: fwd_o =  24'b010010111110101100011001; //  X X 7 6 5 4 3 1
         8'b11111011: fwd_o =  24'b010111110101100011001000; //  X 7 6 5 4 3 1 0
         8'b11111100: fwd_o =  24'b001001111110101100011010; //  X X 7 6 5 4 3 2
         8'b11111101: fwd_o =  24'b001111110101100011010000; //  X 7 6 5 4 3 2 0
         8'b11111110: fwd_o =  24'b000111110101100011010001; //  X 7 6 5 4 3 2 1
         8'b11111111: fwd_o =  24'b111110101100011010001000; //  7 6 5 4 3 2 1 0
        default: fwd_o= 'X;
    endcase

    // fwd datapath vec
    always_comb
    unique case (vec_i) 
         8'b00000000: fwd_datapath_o =  24'b000000000000000000000000; //  X X X X X X X X
         8'b00000001: fwd_datapath_o =  24'b000000000000000000000000; //  X X X X X X X 0
         8'b00000010: fwd_datapath_o =  24'b000000000000000000000001; //  X X X X X X X 1
         8'b00000011: fwd_datapath_o =  24'b000000000000000000000000; //  X X X X X X 0 0
         8'b00000100: fwd_datapath_o =  24'b000000000000000000000010; //  X X X X X X X 2
         8'b00000101: fwd_datapath_o =  24'b000000000000000000001000; //  X X X X X X 1 0
         8'b00000110: fwd_datapath_o =  24'b000000000000000000001001; //  X X X X X X 1 1
         8'b00000111: fwd_datapath_o =  24'b000000000000000000000000; //  X X X X X 0 0 0
         8'b00001000: fwd_datapath_o =  24'b000000000000000000000011; //  X X X X X X X 3
         8'b00001001: fwd_datapath_o =  24'b000000000000000000010000; //  X X X X X X 2 0
         8'b00001010: fwd_datapath_o =  24'b000000000000000000010001; //  X X X X X X 2 1
         8'b00001011: fwd_datapath_o =  24'b000000000000000001000000; //  X X X X X 1 0 0
         8'b00001100: fwd_datapath_o =  24'b000000000000000000010010; //  X X X X X X 2 2
         8'b00001101: fwd_datapath_o =  24'b000000000000000001001000; //  X X X X X 1 1 0
         8'b00001110: fwd_datapath_o =  24'b000000000000000001001001; //  X X X X X 1 1 1
         8'b00001111: fwd_datapath_o =  24'b000000000000000000000000; //  X X X X 0 0 0 0
         8'b00010000: fwd_datapath_o =  24'b000000000000000000000100; //  X X X X X X X 4
         8'b00010001: fwd_datapath_o =  24'b000000000000000000011000; //  X X X X X X 3 0
         8'b00010010: fwd_datapath_o =  24'b000000000000000000011001; //  X X X X X X 3 1
         8'b00010011: fwd_datapath_o =  24'b000000000000000010000000; //  X X X X X 2 0 0
         8'b00010100: fwd_datapath_o =  24'b000000000000000000011010; //  X X X X X X 3 2
         8'b00010101: fwd_datapath_o =  24'b000000000000000010001000; //  X X X X X 2 1 0
         8'b00010110: fwd_datapath_o =  24'b000000000000000010001001; //  X X X X X 2 1 1
         8'b00010111: fwd_datapath_o =  24'b000000000000001000000000; //  X X X X 1 0 0 0
         8'b00011000: fwd_datapath_o =  24'b000000000000000000011011; //  X X X X X X 3 3
         8'b00011001: fwd_datapath_o =  24'b000000000000000010010000; //  X X X X X 2 2 0
         8'b00011010: fwd_datapath_o =  24'b000000000000000010010001; //  X X X X X 2 2 1
         8'b00011011: fwd_datapath_o =  24'b000000000000001001000000; //  X X X X 1 1 0 0
         8'b00011100: fwd_datapath_o =  24'b000000000000000010010010; //  X X X X X 2 2 2
         8'b00011101: fwd_datapath_o =  24'b000000000000001001001000; //  X X X X 1 1 1 0
         8'b00011110: fwd_datapath_o =  24'b000000000000001001001001; //  X X X X 1 1 1 1
         8'b00011111: fwd_datapath_o =  24'b000000000000000000000000; //  X X X 0 0 0 0 0
         8'b00100000: fwd_datapath_o =  24'b000000000000000000000101; //  X X X X X X X 5
         8'b00100001: fwd_datapath_o =  24'b000000000000000000100000; //  X X X X X X 4 0
         8'b00100010: fwd_datapath_o =  24'b000000000000000000100001; //  X X X X X X 4 1
         8'b00100011: fwd_datapath_o =  24'b000000000000000011000000; //  X X X X X 3 0 0
         8'b00100100: fwd_datapath_o =  24'b000000000000000000100010; //  X X X X X X 4 2
         8'b00100101: fwd_datapath_o =  24'b000000000000000011001000; //  X X X X X 3 1 0
         8'b00100110: fwd_datapath_o =  24'b000000000000000011001001; //  X X X X X 3 1 1
         8'b00100111: fwd_datapath_o =  24'b000000000000010000000000; //  X X X X 2 0 0 0
         8'b00101000: fwd_datapath_o =  24'b000000000000000000100011; //  X X X X X X 4 3
         8'b00101001: fwd_datapath_o =  24'b000000000000000011010000; //  X X X X X 3 2 0
         8'b00101010: fwd_datapath_o =  24'b000000000000000011010001; //  X X X X X 3 2 1
         8'b00101011: fwd_datapath_o =  24'b000000000000010001000000; //  X X X X 2 1 0 0
         8'b00101100: fwd_datapath_o =  24'b000000000000000011010010; //  X X X X X 3 2 2
         8'b00101101: fwd_datapath_o =  24'b000000000000010001001000; //  X X X X 2 1 1 0
         8'b00101110: fwd_datapath_o =  24'b000000000000010001001001; //  X X X X 2 1 1 1
         8'b00101111: fwd_datapath_o =  24'b000000000001000000000000; //  X X X 1 0 0 0 0
         8'b00110000: fwd_datapath_o =  24'b000000000000000000100100; //  X X X X X X 4 4
         8'b00110001: fwd_datapath_o =  24'b000000000000000011011000; //  X X X X X 3 3 0
         8'b00110010: fwd_datapath_o =  24'b000000000000000011011001; //  X X X X X 3 3 1
         8'b00110011: fwd_datapath_o =  24'b000000000000010010000000; //  X X X X 2 2 0 0
         8'b00110100: fwd_datapath_o =  24'b000000000000000011011010; //  X X X X X 3 3 2
         8'b00110101: fwd_datapath_o =  24'b000000000000010010001000; //  X X X X 2 2 1 0
         8'b00110110: fwd_datapath_o =  24'b000000000000010010001001; //  X X X X 2 2 1 1
         8'b00110111: fwd_datapath_o =  24'b000000000001001000000000; //  X X X 1 1 0 0 0
         8'b00111000: fwd_datapath_o =  24'b000000000000000011011011; //  X X X X X 3 3 3
         8'b00111001: fwd_datapath_o =  24'b000000000000010010010000; //  X X X X 2 2 2 0
         8'b00111010: fwd_datapath_o =  24'b000000000000010010010001; //  X X X X 2 2 2 1
         8'b00111011: fwd_datapath_o =  24'b000000000001001001000000; //  X X X 1 1 1 0 0
         8'b00111100: fwd_datapath_o =  24'b000000000000010010010010; //  X X X X 2 2 2 2
         8'b00111101: fwd_datapath_o =  24'b000000000001001001001000; //  X X X 1 1 1 1 0
         8'b00111110: fwd_datapath_o =  24'b000000000001001001001001; //  X X X 1 1 1 1 1
         8'b00111111: fwd_datapath_o =  24'b000000000000000000000000; //  X X 0 0 0 0 0 0
         8'b01000000: fwd_datapath_o =  24'b000000000000000000000110; //  X X X X X X X 6
         8'b01000001: fwd_datapath_o =  24'b000000000000000000101000; //  X X X X X X 5 0
         8'b01000010: fwd_datapath_o =  24'b000000000000000000101001; //  X X X X X X 5 1
         8'b01000011: fwd_datapath_o =  24'b000000000000000100000000; //  X X X X X 4 0 0
         8'b01000100: fwd_datapath_o =  24'b000000000000000000101010; //  X X X X X X 5 2
         8'b01000101: fwd_datapath_o =  24'b000000000000000100001000; //  X X X X X 4 1 0
         8'b01000110: fwd_datapath_o =  24'b000000000000000100001001; //  X X X X X 4 1 1
         8'b01000111: fwd_datapath_o =  24'b000000000000011000000000; //  X X X X 3 0 0 0
         8'b01001000: fwd_datapath_o =  24'b000000000000000000101011; //  X X X X X X 5 3
         8'b01001001: fwd_datapath_o =  24'b000000000000000100010000; //  X X X X X 4 2 0
         8'b01001010: fwd_datapath_o =  24'b000000000000000100010001; //  X X X X X 4 2 1
         8'b01001011: fwd_datapath_o =  24'b000000000000011001000000; //  X X X X 3 1 0 0
         8'b01001100: fwd_datapath_o =  24'b000000000000000100010010; //  X X X X X 4 2 2
         8'b01001101: fwd_datapath_o =  24'b000000000000011001001000; //  X X X X 3 1 1 0
         8'b01001110: fwd_datapath_o =  24'b000000000000011001001001; //  X X X X 3 1 1 1
         8'b01001111: fwd_datapath_o =  24'b000000000010000000000000; //  X X X 2 0 0 0 0
         8'b01010000: fwd_datapath_o =  24'b000000000000000000101100; //  X X X X X X 5 4
         8'b01010001: fwd_datapath_o =  24'b000000000000000100011000; //  X X X X X 4 3 0
         8'b01010010: fwd_datapath_o =  24'b000000000000000100011001; //  X X X X X 4 3 1
         8'b01010011: fwd_datapath_o =  24'b000000000000011010000000; //  X X X X 3 2 0 0
         8'b01010100: fwd_datapath_o =  24'b000000000000000100011010; //  X X X X X 4 3 2
         8'b01010101: fwd_datapath_o =  24'b000000000000011010001000; //  X X X X 3 2 1 0
         8'b01010110: fwd_datapath_o =  24'b000000000000011010001001; //  X X X X 3 2 1 1
         8'b01010111: fwd_datapath_o =  24'b000000000010001000000000; //  X X X 2 1 0 0 0
         8'b01011000: fwd_datapath_o =  24'b000000000000000100011011; //  X X X X X 4 3 3
         8'b01011001: fwd_datapath_o =  24'b000000000000011010010000; //  X X X X 3 2 2 0
         8'b01011010: fwd_datapath_o =  24'b000000000000011010010001; //  X X X X 3 2 2 1
         8'b01011011: fwd_datapath_o =  24'b000000000010001001000000; //  X X X 2 1 1 0 0
         8'b01011100: fwd_datapath_o =  24'b000000000000011010010010; //  X X X X 3 2 2 2
         8'b01011101: fwd_datapath_o =  24'b000000000010001001001000; //  X X X 2 1 1 1 0
         8'b01011110: fwd_datapath_o =  24'b000000000010001001001001; //  X X X 2 1 1 1 1
         8'b01011111: fwd_datapath_o =  24'b000000001000000000000000; //  X X 1 0 0 0 0 0
         8'b01100000: fwd_datapath_o =  24'b000000000000000000101101; //  X X X X X X 5 5
         8'b01100001: fwd_datapath_o =  24'b000000000000000100100000; //  X X X X X 4 4 0
         8'b01100010: fwd_datapath_o =  24'b000000000000000100100001; //  X X X X X 4 4 1
         8'b01100011: fwd_datapath_o =  24'b000000000000011011000000; //  X X X X 3 3 0 0
         8'b01100100: fwd_datapath_o =  24'b000000000000000100100010; //  X X X X X 4 4 2
         8'b01100101: fwd_datapath_o =  24'b000000000000011011001000; //  X X X X 3 3 1 0
         8'b01100110: fwd_datapath_o =  24'b000000000000011011001001; //  X X X X 3 3 1 1
         8'b01100111: fwd_datapath_o =  24'b000000000010010000000000; //  X X X 2 2 0 0 0
         8'b01101000: fwd_datapath_o =  24'b000000000000000100100011; //  X X X X X 4 4 3
         8'b01101001: fwd_datapath_o =  24'b000000000000011011010000; //  X X X X 3 3 2 0
         8'b01101010: fwd_datapath_o =  24'b000000000000011011010001; //  X X X X 3 3 2 1
         8'b01101011: fwd_datapath_o =  24'b000000000010010001000000; //  X X X 2 2 1 0 0
         8'b01101100: fwd_datapath_o =  24'b000000000000011011010010; //  X X X X 3 3 2 2
         8'b01101101: fwd_datapath_o =  24'b000000000010010001001000; //  X X X 2 2 1 1 0
         8'b01101110: fwd_datapath_o =  24'b000000000010010001001001; //  X X X 2 2 1 1 1
         8'b01101111: fwd_datapath_o =  24'b000000001001000000000000; //  X X 1 1 0 0 0 0
         8'b01110000: fwd_datapath_o =  24'b000000000000000100100100; //  X X X X X 4 4 4
         8'b01110001: fwd_datapath_o =  24'b000000000000011011011000; //  X X X X 3 3 3 0
         8'b01110010: fwd_datapath_o =  24'b000000000000011011011001; //  X X X X 3 3 3 1
         8'b01110011: fwd_datapath_o =  24'b000000000010010010000000; //  X X X 2 2 2 0 0
         8'b01110100: fwd_datapath_o =  24'b000000000000011011011010; //  X X X X 3 3 3 2
         8'b01110101: fwd_datapath_o =  24'b000000000010010010001000; //  X X X 2 2 2 1 0
         8'b01110110: fwd_datapath_o =  24'b000000000010010010001001; //  X X X 2 2 2 1 1
         8'b01110111: fwd_datapath_o =  24'b000000001001001000000000; //  X X 1 1 1 0 0 0
         8'b01111000: fwd_datapath_o =  24'b000000000000011011011011; //  X X X X 3 3 3 3
         8'b01111001: fwd_datapath_o =  24'b000000000010010010010000; //  X X X 2 2 2 2 0
         8'b01111010: fwd_datapath_o =  24'b000000000010010010010001; //  X X X 2 2 2 2 1
         8'b01111011: fwd_datapath_o =  24'b000000001001001001000000; //  X X 1 1 1 1 0 0
         8'b01111100: fwd_datapath_o =  24'b000000000010010010010010; //  X X X 2 2 2 2 2
         8'b01111101: fwd_datapath_o =  24'b000000001001001001001000; //  X X 1 1 1 1 1 0
         8'b01111110: fwd_datapath_o =  24'b000000001001001001001001; //  X X 1 1 1 1 1 1
         8'b01111111: fwd_datapath_o =  24'b000000000000000000000000; //  X 0 0 0 0 0 0 0
         8'b10000000: fwd_datapath_o =  24'b000000000000000000000111; //  X X X X X X X 7
         8'b10000001: fwd_datapath_o =  24'b000000000000000000110000; //  X X X X X X 6 0
         8'b10000010: fwd_datapath_o =  24'b000000000000000000110001; //  X X X X X X 6 1
         8'b10000011: fwd_datapath_o =  24'b000000000000000101000000; //  X X X X X 5 0 0
         8'b10000100: fwd_datapath_o =  24'b000000000000000000110010; //  X X X X X X 6 2
         8'b10000101: fwd_datapath_o =  24'b000000000000000101001000; //  X X X X X 5 1 0
         8'b10000110: fwd_datapath_o =  24'b000000000000000101001001; //  X X X X X 5 1 1
         8'b10000111: fwd_datapath_o =  24'b000000000000100000000000; //  X X X X 4 0 0 0
         8'b10001000: fwd_datapath_o =  24'b000000000000000000110011; //  X X X X X X 6 3
         8'b10001001: fwd_datapath_o =  24'b000000000000000101010000; //  X X X X X 5 2 0
         8'b10001010: fwd_datapath_o =  24'b000000000000000101010001; //  X X X X X 5 2 1
         8'b10001011: fwd_datapath_o =  24'b000000000000100001000000; //  X X X X 4 1 0 0
         8'b10001100: fwd_datapath_o =  24'b000000000000000101010010; //  X X X X X 5 2 2
         8'b10001101: fwd_datapath_o =  24'b000000000000100001001000; //  X X X X 4 1 1 0
         8'b10001110: fwd_datapath_o =  24'b000000000000100001001001; //  X X X X 4 1 1 1
         8'b10001111: fwd_datapath_o =  24'b000000000011000000000000; //  X X X 3 0 0 0 0
         8'b10010000: fwd_datapath_o =  24'b000000000000000000110100; //  X X X X X X 6 4
         8'b10010001: fwd_datapath_o =  24'b000000000000000101011000; //  X X X X X 5 3 0
         8'b10010010: fwd_datapath_o =  24'b000000000000000101011001; //  X X X X X 5 3 1
         8'b10010011: fwd_datapath_o =  24'b000000000000100010000000; //  X X X X 4 2 0 0
         8'b10010100: fwd_datapath_o =  24'b000000000000000101011010; //  X X X X X 5 3 2
         8'b10010101: fwd_datapath_o =  24'b000000000000100010001000; //  X X X X 4 2 1 0
         8'b10010110: fwd_datapath_o =  24'b000000000000100010001001; //  X X X X 4 2 1 1
         8'b10010111: fwd_datapath_o =  24'b000000000011001000000000; //  X X X 3 1 0 0 0
         8'b10011000: fwd_datapath_o =  24'b000000000000000101011011; //  X X X X X 5 3 3
         8'b10011001: fwd_datapath_o =  24'b000000000000100010010000; //  X X X X 4 2 2 0
         8'b10011010: fwd_datapath_o =  24'b000000000000100010010001; //  X X X X 4 2 2 1
         8'b10011011: fwd_datapath_o =  24'b000000000011001001000000; //  X X X 3 1 1 0 0
         8'b10011100: fwd_datapath_o =  24'b000000000000100010010010; //  X X X X 4 2 2 2
         8'b10011101: fwd_datapath_o =  24'b000000000011001001001000; //  X X X 3 1 1 1 0
         8'b10011110: fwd_datapath_o =  24'b000000000011001001001001; //  X X X 3 1 1 1 1
         8'b10011111: fwd_datapath_o =  24'b000000010000000000000000; //  X X 2 0 0 0 0 0
         8'b10100000: fwd_datapath_o =  24'b000000000000000000110101; //  X X X X X X 6 5
         8'b10100001: fwd_datapath_o =  24'b000000000000000101100000; //  X X X X X 5 4 0
         8'b10100010: fwd_datapath_o =  24'b000000000000000101100001; //  X X X X X 5 4 1
         8'b10100011: fwd_datapath_o =  24'b000000000000100011000000; //  X X X X 4 3 0 0
         8'b10100100: fwd_datapath_o =  24'b000000000000000101100010; //  X X X X X 5 4 2
         8'b10100101: fwd_datapath_o =  24'b000000000000100011001000; //  X X X X 4 3 1 0
         8'b10100110: fwd_datapath_o =  24'b000000000000100011001001; //  X X X X 4 3 1 1
         8'b10100111: fwd_datapath_o =  24'b000000000011010000000000; //  X X X 3 2 0 0 0
         8'b10101000: fwd_datapath_o =  24'b000000000000000101100011; //  X X X X X 5 4 3
         8'b10101001: fwd_datapath_o =  24'b000000000000100011010000; //  X X X X 4 3 2 0
         8'b10101010: fwd_datapath_o =  24'b000000000000100011010001; //  X X X X 4 3 2 1
         8'b10101011: fwd_datapath_o =  24'b000000000011010001000000; //  X X X 3 2 1 0 0
         8'b10101100: fwd_datapath_o =  24'b000000000000100011010010; //  X X X X 4 3 2 2
         8'b10101101: fwd_datapath_o =  24'b000000000011010001001000; //  X X X 3 2 1 1 0
         8'b10101110: fwd_datapath_o =  24'b000000000011010001001001; //  X X X 3 2 1 1 1
         8'b10101111: fwd_datapath_o =  24'b000000010001000000000000; //  X X 2 1 0 0 0 0
         8'b10110000: fwd_datapath_o =  24'b000000000000000101100100; //  X X X X X 5 4 4
         8'b10110001: fwd_datapath_o =  24'b000000000000100011011000; //  X X X X 4 3 3 0
         8'b10110010: fwd_datapath_o =  24'b000000000000100011011001; //  X X X X 4 3 3 1
         8'b10110011: fwd_datapath_o =  24'b000000000011010010000000; //  X X X 3 2 2 0 0
         8'b10110100: fwd_datapath_o =  24'b000000000000100011011010; //  X X X X 4 3 3 2
         8'b10110101: fwd_datapath_o =  24'b000000000011010010001000; //  X X X 3 2 2 1 0
         8'b10110110: fwd_datapath_o =  24'b000000000011010010001001; //  X X X 3 2 2 1 1
         8'b10110111: fwd_datapath_o =  24'b000000010001001000000000; //  X X 2 1 1 0 0 0
         8'b10111000: fwd_datapath_o =  24'b000000000000100011011011; //  X X X X 4 3 3 3
         8'b10111001: fwd_datapath_o =  24'b000000000011010010010000; //  X X X 3 2 2 2 0
         8'b10111010: fwd_datapath_o =  24'b000000000011010010010001; //  X X X 3 2 2 2 1
         8'b10111011: fwd_datapath_o =  24'b000000010001001001000000; //  X X 2 1 1 1 0 0
         8'b10111100: fwd_datapath_o =  24'b000000000011010010010010; //  X X X 3 2 2 2 2
         8'b10111101: fwd_datapath_o =  24'b000000010001001001001000; //  X X 2 1 1 1 1 0
         8'b10111110: fwd_datapath_o =  24'b000000010001001001001001; //  X X 2 1 1 1 1 1
         8'b10111111: fwd_datapath_o =  24'b000001000000000000000000; //  X 1 0 0 0 0 0 0
         8'b11000000: fwd_datapath_o =  24'b000000000000000000110110; //  X X X X X X 6 6
         8'b11000001: fwd_datapath_o =  24'b000000000000000101101000; //  X X X X X 5 5 0
         8'b11000010: fwd_datapath_o =  24'b000000000000000101101001; //  X X X X X 5 5 1
         8'b11000011: fwd_datapath_o =  24'b000000000000100100000000; //  X X X X 4 4 0 0
         8'b11000100: fwd_datapath_o =  24'b000000000000000101101010; //  X X X X X 5 5 2
         8'b11000101: fwd_datapath_o =  24'b000000000000100100001000; //  X X X X 4 4 1 0
         8'b11000110: fwd_datapath_o =  24'b000000000000100100001001; //  X X X X 4 4 1 1
         8'b11000111: fwd_datapath_o =  24'b000000000011011000000000; //  X X X 3 3 0 0 0
         8'b11001000: fwd_datapath_o =  24'b000000000000000101101011; //  X X X X X 5 5 3
         8'b11001001: fwd_datapath_o =  24'b000000000000100100010000; //  X X X X 4 4 2 0
         8'b11001010: fwd_datapath_o =  24'b000000000000100100010001; //  X X X X 4 4 2 1
         8'b11001011: fwd_datapath_o =  24'b000000000011011001000000; //  X X X 3 3 1 0 0
         8'b11001100: fwd_datapath_o =  24'b000000000000100100010010; //  X X X X 4 4 2 2
         8'b11001101: fwd_datapath_o =  24'b000000000011011001001000; //  X X X 3 3 1 1 0
         8'b11001110: fwd_datapath_o =  24'b000000000011011001001001; //  X X X 3 3 1 1 1
         8'b11001111: fwd_datapath_o =  24'b000000010010000000000000; //  X X 2 2 0 0 0 0
         8'b11010000: fwd_datapath_o =  24'b000000000000000101101100; //  X X X X X 5 5 4
         8'b11010001: fwd_datapath_o =  24'b000000000000100100011000; //  X X X X 4 4 3 0
         8'b11010010: fwd_datapath_o =  24'b000000000000100100011001; //  X X X X 4 4 3 1
         8'b11010011: fwd_datapath_o =  24'b000000000011011010000000; //  X X X 3 3 2 0 0
         8'b11010100: fwd_datapath_o =  24'b000000000000100100011010; //  X X X X 4 4 3 2
         8'b11010101: fwd_datapath_o =  24'b000000000011011010001000; //  X X X 3 3 2 1 0
         8'b11010110: fwd_datapath_o =  24'b000000000011011010001001; //  X X X 3 3 2 1 1
         8'b11010111: fwd_datapath_o =  24'b000000010010001000000000; //  X X 2 2 1 0 0 0
         8'b11011000: fwd_datapath_o =  24'b000000000000100100011011; //  X X X X 4 4 3 3
         8'b11011001: fwd_datapath_o =  24'b000000000011011010010000; //  X X X 3 3 2 2 0
         8'b11011010: fwd_datapath_o =  24'b000000000011011010010001; //  X X X 3 3 2 2 1
         8'b11011011: fwd_datapath_o =  24'b000000010010001001000000; //  X X 2 2 1 1 0 0
         8'b11011100: fwd_datapath_o =  24'b000000000011011010010010; //  X X X 3 3 2 2 2
         8'b11011101: fwd_datapath_o =  24'b000000010010001001001000; //  X X 2 2 1 1 1 0
         8'b11011110: fwd_datapath_o =  24'b000000010010001001001001; //  X X 2 2 1 1 1 1
         8'b11011111: fwd_datapath_o =  24'b000001001000000000000000; //  X 1 1 0 0 0 0 0
         8'b11100000: fwd_datapath_o =  24'b000000000000000101101101; //  X X X X X 5 5 5
         8'b11100001: fwd_datapath_o =  24'b000000000000100100100000; //  X X X X 4 4 4 0
         8'b11100010: fwd_datapath_o =  24'b000000000000100100100001; //  X X X X 4 4 4 1
         8'b11100011: fwd_datapath_o =  24'b000000000011011011000000; //  X X X 3 3 3 0 0
         8'b11100100: fwd_datapath_o =  24'b000000000000100100100010; //  X X X X 4 4 4 2
         8'b11100101: fwd_datapath_o =  24'b000000000011011011001000; //  X X X 3 3 3 1 0
         8'b11100110: fwd_datapath_o =  24'b000000000011011011001001; //  X X X 3 3 3 1 1
         8'b11100111: fwd_datapath_o =  24'b000000010010010000000000; //  X X 2 2 2 0 0 0
         8'b11101000: fwd_datapath_o =  24'b000000000000100100100011; //  X X X X 4 4 4 3
         8'b11101001: fwd_datapath_o =  24'b000000000011011011010000; //  X X X 3 3 3 2 0
         8'b11101010: fwd_datapath_o =  24'b000000000011011011010001; //  X X X 3 3 3 2 1
         8'b11101011: fwd_datapath_o =  24'b000000010010010001000000; //  X X 2 2 2 1 0 0
         8'b11101100: fwd_datapath_o =  24'b000000000011011011010010; //  X X X 3 3 3 2 2
         8'b11101101: fwd_datapath_o =  24'b000000010010010001001000; //  X X 2 2 2 1 1 0
         8'b11101110: fwd_datapath_o =  24'b000000010010010001001001; //  X X 2 2 2 1 1 1
         8'b11101111: fwd_datapath_o =  24'b000001001001000000000000; //  X 1 1 1 0 0 0 0
         8'b11110000: fwd_datapath_o =  24'b000000000000100100100100; //  X X X X 4 4 4 4
         8'b11110001: fwd_datapath_o =  24'b000000000011011011011000; //  X X X 3 3 3 3 0
         8'b11110010: fwd_datapath_o =  24'b000000000011011011011001; //  X X X 3 3 3 3 1
         8'b11110011: fwd_datapath_o =  24'b000000010010010010000000; //  X X 2 2 2 2 0 0
         8'b11110100: fwd_datapath_o =  24'b000000000011011011011010; //  X X X 3 3 3 3 2
         8'b11110101: fwd_datapath_o =  24'b000000010010010010001000; //  X X 2 2 2 2 1 0
         8'b11110110: fwd_datapath_o =  24'b000000010010010010001001; //  X X 2 2 2 2 1 1
         8'b11110111: fwd_datapath_o =  24'b000001001001001000000000; //  X 1 1 1 1 0 0 0
         8'b11111000: fwd_datapath_o =  24'b000000000011011011011011; //  X X X 3 3 3 3 3
         8'b11111001: fwd_datapath_o =  24'b000000010010010010010000; //  X X 2 2 2 2 2 0
         8'b11111010: fwd_datapath_o =  24'b000000010010010010010001; //  X X 2 2 2 2 2 1
         8'b11111011: fwd_datapath_o =  24'b000001001001001001000000; //  X 1 1 1 1 1 0 0
         8'b11111100: fwd_datapath_o =  24'b000000010010010010010010; //  X X 2 2 2 2 2 2
         8'b11111101: fwd_datapath_o =  24'b000001001001001001001000; //  X 1 1 1 1 1 1 0
         8'b11111110: fwd_datapath_o =  24'b000001001001001001001001; //  X 1 1 1 1 1 1 1
         8'b11111111: fwd_datapath_o =  24'b000000000000000000000000; //  0 0 0 0 0 0 0 0
        default: fwd_datapath_o= 'X;
    endcase
  end

if (vec_size_lp == 9)
  begin
    // backward vec
    always_comb
    unique case (vec_i) 
         9'b000000000: bk_o =  36'b100010001000100010001000100010001000; //  X X X X X X X X X
         9'b000000001: bk_o =  36'b100010001000100010001000100010000000; //  X X X X X X X X 0
         9'b000000010: bk_o =  36'b100010001000100010001000100000001000; //  X X X X X X X 0 X
         9'b000000011: bk_o =  36'b100010001000100010001000100000010000; //  X X X X X X X 1 0
         9'b000000100: bk_o =  36'b100010001000100010001000000010001000; //  X X X X X X 0 X X
         9'b000000101: bk_o =  36'b100010001000100010001000000110000000; //  X X X X X X 1 X 0
         9'b000000110: bk_o =  36'b100010001000100010001000000100001000; //  X X X X X X 1 0 X
         9'b000000111: bk_o =  36'b100010001000100010001000001000010000; //  X X X X X X 2 1 0
         9'b000001000: bk_o =  36'b100010001000100010000000100010001000; //  X X X X X 0 X X X
         9'b000001001: bk_o =  36'b100010001000100010000001100010000000; //  X X X X X 1 X X 0
         9'b000001010: bk_o =  36'b100010001000100010000001100000001000; //  X X X X X 1 X 0 X
         9'b000001011: bk_o =  36'b100010001000100010000010100000010000; //  X X X X X 2 X 1 0
         9'b000001100: bk_o =  36'b100010001000100010000001000010001000; //  X X X X X 1 0 X X
         9'b000001101: bk_o =  36'b100010001000100010000010000110000000; //  X X X X X 2 1 X 0
         9'b000001110: bk_o =  36'b100010001000100010000010000100001000; //  X X X X X 2 1 0 X
         9'b000001111: bk_o =  36'b100010001000100010000011001000010000; //  X X X X X 3 2 1 0
         9'b000010000: bk_o =  36'b100010001000100000001000100010001000; //  X X X X 0 X X X X
         9'b000010001: bk_o =  36'b100010001000100000011000100010000000; //  X X X X 1 X X X 0
         9'b000010010: bk_o =  36'b100010001000100000011000100000001000; //  X X X X 1 X X 0 X
         9'b000010011: bk_o =  36'b100010001000100000101000100000010000; //  X X X X 2 X X 1 0
         9'b000010100: bk_o =  36'b100010001000100000011000000010001000; //  X X X X 1 X 0 X X
         9'b000010101: bk_o =  36'b100010001000100000101000000110000000; //  X X X X 2 X 1 X 0
         9'b000010110: bk_o =  36'b100010001000100000101000000100001000; //  X X X X 2 X 1 0 X
         9'b000010111: bk_o =  36'b100010001000100000111000001000010000; //  X X X X 3 X 2 1 0
         9'b000011000: bk_o =  36'b100010001000100000010000100010001000; //  X X X X 1 0 X X X
         9'b000011001: bk_o =  36'b100010001000100000100001100010000000; //  X X X X 2 1 X X 0
         9'b000011010: bk_o =  36'b100010001000100000100001100000001000; //  X X X X 2 1 X 0 X
         9'b000011011: bk_o =  36'b100010001000100000110010100000010000; //  X X X X 3 2 X 1 0
         9'b000011100: bk_o =  36'b100010001000100000100001000010001000; //  X X X X 2 1 0 X X
         9'b000011101: bk_o =  36'b100010001000100000110010000110000000; //  X X X X 3 2 1 X 0
         9'b000011110: bk_o =  36'b100010001000100000110010000100001000; //  X X X X 3 2 1 0 X
         9'b000011111: bk_o =  36'b100010001000100001000011001000010000; //  X X X X 4 3 2 1 0
         9'b000100000: bk_o =  36'b100010001000000010001000100010001000; //  X X X 0 X X X X X
         9'b000100001: bk_o =  36'b100010001000000110001000100010000000; //  X X X 1 X X X X 0
         9'b000100010: bk_o =  36'b100010001000000110001000100000001000; //  X X X 1 X X X 0 X
         9'b000100011: bk_o =  36'b100010001000001010001000100000010000; //  X X X 2 X X X 1 0
         9'b000100100: bk_o =  36'b100010001000000110001000000010001000; //  X X X 1 X X 0 X X
         9'b000100101: bk_o =  36'b100010001000001010001000000110000000; //  X X X 2 X X 1 X 0
         9'b000100110: bk_o =  36'b100010001000001010001000000100001000; //  X X X 2 X X 1 0 X
         9'b000100111: bk_o =  36'b100010001000001110001000001000010000; //  X X X 3 X X 2 1 0
         9'b000101000: bk_o =  36'b100010001000000110000000100010001000; //  X X X 1 X 0 X X X
         9'b000101001: bk_o =  36'b100010001000001010000001100010000000; //  X X X 2 X 1 X X 0
         9'b000101010: bk_o =  36'b100010001000001010000001100000001000; //  X X X 2 X 1 X 0 X
         9'b000101011: bk_o =  36'b100010001000001110000010100000010000; //  X X X 3 X 2 X 1 0
         9'b000101100: bk_o =  36'b100010001000001010000001000010001000; //  X X X 2 X 1 0 X X
         9'b000101101: bk_o =  36'b100010001000001110000010000110000000; //  X X X 3 X 2 1 X 0
         9'b000101110: bk_o =  36'b100010001000001110000010000100001000; //  X X X 3 X 2 1 0 X
         9'b000101111: bk_o =  36'b100010001000010010000011001000010000; //  X X X 4 X 3 2 1 0
         9'b000110000: bk_o =  36'b100010001000000100001000100010001000; //  X X X 1 0 X X X X
         9'b000110001: bk_o =  36'b100010001000001000011000100010000000; //  X X X 2 1 X X X 0
         9'b000110010: bk_o =  36'b100010001000001000011000100000001000; //  X X X 2 1 X X 0 X
         9'b000110011: bk_o =  36'b100010001000001100101000100000010000; //  X X X 3 2 X X 1 0
         9'b000110100: bk_o =  36'b100010001000001000011000000010001000; //  X X X 2 1 X 0 X X
         9'b000110101: bk_o =  36'b100010001000001100101000000110000000; //  X X X 3 2 X 1 X 0
         9'b000110110: bk_o =  36'b100010001000001100101000000100001000; //  X X X 3 2 X 1 0 X
         9'b000110111: bk_o =  36'b100010001000010000111000001000010000; //  X X X 4 3 X 2 1 0
         9'b000111000: bk_o =  36'b100010001000001000010000100010001000; //  X X X 2 1 0 X X X
         9'b000111001: bk_o =  36'b100010001000001100100001100010000000; //  X X X 3 2 1 X X 0
         9'b000111010: bk_o =  36'b100010001000001100100001100000001000; //  X X X 3 2 1 X 0 X
         9'b000111011: bk_o =  36'b100010001000010000110010100000010000; //  X X X 4 3 2 X 1 0
         9'b000111100: bk_o =  36'b100010001000001100100001000010001000; //  X X X 3 2 1 0 X X
         9'b000111101: bk_o =  36'b100010001000010000110010000110000000; //  X X X 4 3 2 1 X 0
         9'b000111110: bk_o =  36'b100010001000010000110010000100001000; //  X X X 4 3 2 1 0 X
         9'b000111111: bk_o =  36'b100010001000010101000011001000010000; //  X X X 5 4 3 2 1 0
         9'b001000000: bk_o =  36'b100010000000100010001000100010001000; //  X X 0 X X X X X X
         9'b001000001: bk_o =  36'b100010000001100010001000100010000000; //  X X 1 X X X X X 0
         9'b001000010: bk_o =  36'b100010000001100010001000100000001000; //  X X 1 X X X X 0 X
         9'b001000011: bk_o =  36'b100010000010100010001000100000010000; //  X X 2 X X X X 1 0
         9'b001000100: bk_o =  36'b100010000001100010001000000010001000; //  X X 1 X X X 0 X X
         9'b001000101: bk_o =  36'b100010000010100010001000000110000000; //  X X 2 X X X 1 X 0
         9'b001000110: bk_o =  36'b100010000010100010001000000100001000; //  X X 2 X X X 1 0 X
         9'b001000111: bk_o =  36'b100010000011100010001000001000010000; //  X X 3 X X X 2 1 0
         9'b001001000: bk_o =  36'b100010000001100010000000100010001000; //  X X 1 X X 0 X X X
         9'b001001001: bk_o =  36'b100010000010100010000001100010000000; //  X X 2 X X 1 X X 0
         9'b001001010: bk_o =  36'b100010000010100010000001100000001000; //  X X 2 X X 1 X 0 X
         9'b001001011: bk_o =  36'b100010000011100010000010100000010000; //  X X 3 X X 2 X 1 0
         9'b001001100: bk_o =  36'b100010000010100010000001000010001000; //  X X 2 X X 1 0 X X
         9'b001001101: bk_o =  36'b100010000011100010000010000110000000; //  X X 3 X X 2 1 X 0
         9'b001001110: bk_o =  36'b100010000011100010000010000100001000; //  X X 3 X X 2 1 0 X
         9'b001001111: bk_o =  36'b100010000100100010000011001000010000; //  X X 4 X X 3 2 1 0
         9'b001010000: bk_o =  36'b100010000001100000001000100010001000; //  X X 1 X 0 X X X X
         9'b001010001: bk_o =  36'b100010000010100000011000100010000000; //  X X 2 X 1 X X X 0
         9'b001010010: bk_o =  36'b100010000010100000011000100000001000; //  X X 2 X 1 X X 0 X
         9'b001010011: bk_o =  36'b100010000011100000101000100000010000; //  X X 3 X 2 X X 1 0
         9'b001010100: bk_o =  36'b100010000010100000011000000010001000; //  X X 2 X 1 X 0 X X
         9'b001010101: bk_o =  36'b100010000011100000101000000110000000; //  X X 3 X 2 X 1 X 0
         9'b001010110: bk_o =  36'b100010000011100000101000000100001000; //  X X 3 X 2 X 1 0 X
         9'b001010111: bk_o =  36'b100010000100100000111000001000010000; //  X X 4 X 3 X 2 1 0
         9'b001011000: bk_o =  36'b100010000010100000010000100010001000; //  X X 2 X 1 0 X X X
         9'b001011001: bk_o =  36'b100010000011100000100001100010000000; //  X X 3 X 2 1 X X 0
         9'b001011010: bk_o =  36'b100010000011100000100001100000001000; //  X X 3 X 2 1 X 0 X
         9'b001011011: bk_o =  36'b100010000100100000110010100000010000; //  X X 4 X 3 2 X 1 0
         9'b001011100: bk_o =  36'b100010000011100000100001000010001000; //  X X 3 X 2 1 0 X X
         9'b001011101: bk_o =  36'b100010000100100000110010000110000000; //  X X 4 X 3 2 1 X 0
         9'b001011110: bk_o =  36'b100010000100100000110010000100001000; //  X X 4 X 3 2 1 0 X
         9'b001011111: bk_o =  36'b100010000101100001000011001000010000; //  X X 5 X 4 3 2 1 0
         9'b001100000: bk_o =  36'b100010000001000010001000100010001000; //  X X 1 0 X X X X X
         9'b001100001: bk_o =  36'b100010000010000110001000100010000000; //  X X 2 1 X X X X 0
         9'b001100010: bk_o =  36'b100010000010000110001000100000001000; //  X X 2 1 X X X 0 X
         9'b001100011: bk_o =  36'b100010000011001010001000100000010000; //  X X 3 2 X X X 1 0
         9'b001100100: bk_o =  36'b100010000010000110001000000010001000; //  X X 2 1 X X 0 X X
         9'b001100101: bk_o =  36'b100010000011001010001000000110000000; //  X X 3 2 X X 1 X 0
         9'b001100110: bk_o =  36'b100010000011001010001000000100001000; //  X X 3 2 X X 1 0 X
         9'b001100111: bk_o =  36'b100010000100001110001000001000010000; //  X X 4 3 X X 2 1 0
         9'b001101000: bk_o =  36'b100010000010000110000000100010001000; //  X X 2 1 X 0 X X X
         9'b001101001: bk_o =  36'b100010000011001010000001100010000000; //  X X 3 2 X 1 X X 0
         9'b001101010: bk_o =  36'b100010000011001010000001100000001000; //  X X 3 2 X 1 X 0 X
         9'b001101011: bk_o =  36'b100010000100001110000010100000010000; //  X X 4 3 X 2 X 1 0
         9'b001101100: bk_o =  36'b100010000011001010000001000010001000; //  X X 3 2 X 1 0 X X
         9'b001101101: bk_o =  36'b100010000100001110000010000110000000; //  X X 4 3 X 2 1 X 0
         9'b001101110: bk_o =  36'b100010000100001110000010000100001000; //  X X 4 3 X 2 1 0 X
         9'b001101111: bk_o =  36'b100010000101010010000011001000010000; //  X X 5 4 X 3 2 1 0
         9'b001110000: bk_o =  36'b100010000010000100001000100010001000; //  X X 2 1 0 X X X X
         9'b001110001: bk_o =  36'b100010000011001000011000100010000000; //  X X 3 2 1 X X X 0
         9'b001110010: bk_o =  36'b100010000011001000011000100000001000; //  X X 3 2 1 X X 0 X
         9'b001110011: bk_o =  36'b100010000100001100101000100000010000; //  X X 4 3 2 X X 1 0
         9'b001110100: bk_o =  36'b100010000011001000011000000010001000; //  X X 3 2 1 X 0 X X
         9'b001110101: bk_o =  36'b100010000100001100101000000110000000; //  X X 4 3 2 X 1 X 0
         9'b001110110: bk_o =  36'b100010000100001100101000000100001000; //  X X 4 3 2 X 1 0 X
         9'b001110111: bk_o =  36'b100010000101010000111000001000010000; //  X X 5 4 3 X 2 1 0
         9'b001111000: bk_o =  36'b100010000011001000010000100010001000; //  X X 3 2 1 0 X X X
         9'b001111001: bk_o =  36'b100010000100001100100001100010000000; //  X X 4 3 2 1 X X 0
         9'b001111010: bk_o =  36'b100010000100001100100001100000001000; //  X X 4 3 2 1 X 0 X
         9'b001111011: bk_o =  36'b100010000101010000110010100000010000; //  X X 5 4 3 2 X 1 0
         9'b001111100: bk_o =  36'b100010000100001100100001000010001000; //  X X 4 3 2 1 0 X X
         9'b001111101: bk_o =  36'b100010000101010000110010000110000000; //  X X 5 4 3 2 1 X 0
         9'b001111110: bk_o =  36'b100010000101010000110010000100001000; //  X X 5 4 3 2 1 0 X
         9'b001111111: bk_o =  36'b100010000110010101000011001000010000; //  X X 6 5 4 3 2 1 0
         9'b010000000: bk_o =  36'b100000001000100010001000100010001000; //  X 0 X X X X X X X
         9'b010000001: bk_o =  36'b100000011000100010001000100010000000; //  X 1 X X X X X X 0
         9'b010000010: bk_o =  36'b100000011000100010001000100000001000; //  X 1 X X X X X 0 X
         9'b010000011: bk_o =  36'b100000101000100010001000100000010000; //  X 2 X X X X X 1 0
         9'b010000100: bk_o =  36'b100000011000100010001000000010001000; //  X 1 X X X X 0 X X
         9'b010000101: bk_o =  36'b100000101000100010001000000110000000; //  X 2 X X X X 1 X 0
         9'b010000110: bk_o =  36'b100000101000100010001000000100001000; //  X 2 X X X X 1 0 X
         9'b010000111: bk_o =  36'b100000111000100010001000001000010000; //  X 3 X X X X 2 1 0
         9'b010001000: bk_o =  36'b100000011000100010000000100010001000; //  X 1 X X X 0 X X X
         9'b010001001: bk_o =  36'b100000101000100010000001100010000000; //  X 2 X X X 1 X X 0
         9'b010001010: bk_o =  36'b100000101000100010000001100000001000; //  X 2 X X X 1 X 0 X
         9'b010001011: bk_o =  36'b100000111000100010000010100000010000; //  X 3 X X X 2 X 1 0
         9'b010001100: bk_o =  36'b100000101000100010000001000010001000; //  X 2 X X X 1 0 X X
         9'b010001101: bk_o =  36'b100000111000100010000010000110000000; //  X 3 X X X 2 1 X 0
         9'b010001110: bk_o =  36'b100000111000100010000010000100001000; //  X 3 X X X 2 1 0 X
         9'b010001111: bk_o =  36'b100001001000100010000011001000010000; //  X 4 X X X 3 2 1 0
         9'b010010000: bk_o =  36'b100000011000100000001000100010001000; //  X 1 X X 0 X X X X
         9'b010010001: bk_o =  36'b100000101000100000011000100010000000; //  X 2 X X 1 X X X 0
         9'b010010010: bk_o =  36'b100000101000100000011000100000001000; //  X 2 X X 1 X X 0 X
         9'b010010011: bk_o =  36'b100000111000100000101000100000010000; //  X 3 X X 2 X X 1 0
         9'b010010100: bk_o =  36'b100000101000100000011000000010001000; //  X 2 X X 1 X 0 X X
         9'b010010101: bk_o =  36'b100000111000100000101000000110000000; //  X 3 X X 2 X 1 X 0
         9'b010010110: bk_o =  36'b100000111000100000101000000100001000; //  X 3 X X 2 X 1 0 X
         9'b010010111: bk_o =  36'b100001001000100000111000001000010000; //  X 4 X X 3 X 2 1 0
         9'b010011000: bk_o =  36'b100000101000100000010000100010001000; //  X 2 X X 1 0 X X X
         9'b010011001: bk_o =  36'b100000111000100000100001100010000000; //  X 3 X X 2 1 X X 0
         9'b010011010: bk_o =  36'b100000111000100000100001100000001000; //  X 3 X X 2 1 X 0 X
         9'b010011011: bk_o =  36'b100001001000100000110010100000010000; //  X 4 X X 3 2 X 1 0
         9'b010011100: bk_o =  36'b100000111000100000100001000010001000; //  X 3 X X 2 1 0 X X
         9'b010011101: bk_o =  36'b100001001000100000110010000110000000; //  X 4 X X 3 2 1 X 0
         9'b010011110: bk_o =  36'b100001001000100000110010000100001000; //  X 4 X X 3 2 1 0 X
         9'b010011111: bk_o =  36'b100001011000100001000011001000010000; //  X 5 X X 4 3 2 1 0
         9'b010100000: bk_o =  36'b100000011000000010001000100010001000; //  X 1 X 0 X X X X X
         9'b010100001: bk_o =  36'b100000101000000110001000100010000000; //  X 2 X 1 X X X X 0
         9'b010100010: bk_o =  36'b100000101000000110001000100000001000; //  X 2 X 1 X X X 0 X
         9'b010100011: bk_o =  36'b100000111000001010001000100000010000; //  X 3 X 2 X X X 1 0
         9'b010100100: bk_o =  36'b100000101000000110001000000010001000; //  X 2 X 1 X X 0 X X
         9'b010100101: bk_o =  36'b100000111000001010001000000110000000; //  X 3 X 2 X X 1 X 0
         9'b010100110: bk_o =  36'b100000111000001010001000000100001000; //  X 3 X 2 X X 1 0 X
         9'b010100111: bk_o =  36'b100001001000001110001000001000010000; //  X 4 X 3 X X 2 1 0
         9'b010101000: bk_o =  36'b100000101000000110000000100010001000; //  X 2 X 1 X 0 X X X
         9'b010101001: bk_o =  36'b100000111000001010000001100010000000; //  X 3 X 2 X 1 X X 0
         9'b010101010: bk_o =  36'b100000111000001010000001100000001000; //  X 3 X 2 X 1 X 0 X
         9'b010101011: bk_o =  36'b100001001000001110000010100000010000; //  X 4 X 3 X 2 X 1 0
         9'b010101100: bk_o =  36'b100000111000001010000001000010001000; //  X 3 X 2 X 1 0 X X
         9'b010101101: bk_o =  36'b100001001000001110000010000110000000; //  X 4 X 3 X 2 1 X 0
         9'b010101110: bk_o =  36'b100001001000001110000010000100001000; //  X 4 X 3 X 2 1 0 X
         9'b010101111: bk_o =  36'b100001011000010010000011001000010000; //  X 5 X 4 X 3 2 1 0
         9'b010110000: bk_o =  36'b100000101000000100001000100010001000; //  X 2 X 1 0 X X X X
         9'b010110001: bk_o =  36'b100000111000001000011000100010000000; //  X 3 X 2 1 X X X 0
         9'b010110010: bk_o =  36'b100000111000001000011000100000001000; //  X 3 X 2 1 X X 0 X
         9'b010110011: bk_o =  36'b100001001000001100101000100000010000; //  X 4 X 3 2 X X 1 0
         9'b010110100: bk_o =  36'b100000111000001000011000000010001000; //  X 3 X 2 1 X 0 X X
         9'b010110101: bk_o =  36'b100001001000001100101000000110000000; //  X 4 X 3 2 X 1 X 0
         9'b010110110: bk_o =  36'b100001001000001100101000000100001000; //  X 4 X 3 2 X 1 0 X
         9'b010110111: bk_o =  36'b100001011000010000111000001000010000; //  X 5 X 4 3 X 2 1 0
         9'b010111000: bk_o =  36'b100000111000001000010000100010001000; //  X 3 X 2 1 0 X X X
         9'b010111001: bk_o =  36'b100001001000001100100001100010000000; //  X 4 X 3 2 1 X X 0
         9'b010111010: bk_o =  36'b100001001000001100100001100000001000; //  X 4 X 3 2 1 X 0 X
         9'b010111011: bk_o =  36'b100001011000010000110010100000010000; //  X 5 X 4 3 2 X 1 0
         9'b010111100: bk_o =  36'b100001001000001100100001000010001000; //  X 4 X 3 2 1 0 X X
         9'b010111101: bk_o =  36'b100001011000010000110010000110000000; //  X 5 X 4 3 2 1 X 0
         9'b010111110: bk_o =  36'b100001011000010000110010000100001000; //  X 5 X 4 3 2 1 0 X
         9'b010111111: bk_o =  36'b100001101000010101000011001000010000; //  X 6 X 5 4 3 2 1 0
         9'b011000000: bk_o =  36'b100000010000100010001000100010001000; //  X 1 0 X X X X X X
         9'b011000001: bk_o =  36'b100000100001100010001000100010000000; //  X 2 1 X X X X X 0
         9'b011000010: bk_o =  36'b100000100001100010001000100000001000; //  X 2 1 X X X X 0 X
         9'b011000011: bk_o =  36'b100000110010100010001000100000010000; //  X 3 2 X X X X 1 0
         9'b011000100: bk_o =  36'b100000100001100010001000000010001000; //  X 2 1 X X X 0 X X
         9'b011000101: bk_o =  36'b100000110010100010001000000110000000; //  X 3 2 X X X 1 X 0
         9'b011000110: bk_o =  36'b100000110010100010001000000100001000; //  X 3 2 X X X 1 0 X
         9'b011000111: bk_o =  36'b100001000011100010001000001000010000; //  X 4 3 X X X 2 1 0
         9'b011001000: bk_o =  36'b100000100001100010000000100010001000; //  X 2 1 X X 0 X X X
         9'b011001001: bk_o =  36'b100000110010100010000001100010000000; //  X 3 2 X X 1 X X 0
         9'b011001010: bk_o =  36'b100000110010100010000001100000001000; //  X 3 2 X X 1 X 0 X
         9'b011001011: bk_o =  36'b100001000011100010000010100000010000; //  X 4 3 X X 2 X 1 0
         9'b011001100: bk_o =  36'b100000110010100010000001000010001000; //  X 3 2 X X 1 0 X X
         9'b011001101: bk_o =  36'b100001000011100010000010000110000000; //  X 4 3 X X 2 1 X 0
         9'b011001110: bk_o =  36'b100001000011100010000010000100001000; //  X 4 3 X X 2 1 0 X
         9'b011001111: bk_o =  36'b100001010100100010000011001000010000; //  X 5 4 X X 3 2 1 0
         9'b011010000: bk_o =  36'b100000100001100000001000100010001000; //  X 2 1 X 0 X X X X
         9'b011010001: bk_o =  36'b100000110010100000011000100010000000; //  X 3 2 X 1 X X X 0
         9'b011010010: bk_o =  36'b100000110010100000011000100000001000; //  X 3 2 X 1 X X 0 X
         9'b011010011: bk_o =  36'b100001000011100000101000100000010000; //  X 4 3 X 2 X X 1 0
         9'b011010100: bk_o =  36'b100000110010100000011000000010001000; //  X 3 2 X 1 X 0 X X
         9'b011010101: bk_o =  36'b100001000011100000101000000110000000; //  X 4 3 X 2 X 1 X 0
         9'b011010110: bk_o =  36'b100001000011100000101000000100001000; //  X 4 3 X 2 X 1 0 X
         9'b011010111: bk_o =  36'b100001010100100000111000001000010000; //  X 5 4 X 3 X 2 1 0
         9'b011011000: bk_o =  36'b100000110010100000010000100010001000; //  X 3 2 X 1 0 X X X
         9'b011011001: bk_o =  36'b100001000011100000100001100010000000; //  X 4 3 X 2 1 X X 0
         9'b011011010: bk_o =  36'b100001000011100000100001100000001000; //  X 4 3 X 2 1 X 0 X
         9'b011011011: bk_o =  36'b100001010100100000110010100000010000; //  X 5 4 X 3 2 X 1 0
         9'b011011100: bk_o =  36'b100001000011100000100001000010001000; //  X 4 3 X 2 1 0 X X
         9'b011011101: bk_o =  36'b100001010100100000110010000110000000; //  X 5 4 X 3 2 1 X 0
         9'b011011110: bk_o =  36'b100001010100100000110010000100001000; //  X 5 4 X 3 2 1 0 X
         9'b011011111: bk_o =  36'b100001100101100001000011001000010000; //  X 6 5 X 4 3 2 1 0
         9'b011100000: bk_o =  36'b100000100001000010001000100010001000; //  X 2 1 0 X X X X X
         9'b011100001: bk_o =  36'b100000110010000110001000100010000000; //  X 3 2 1 X X X X 0
         9'b011100010: bk_o =  36'b100000110010000110001000100000001000; //  X 3 2 1 X X X 0 X
         9'b011100011: bk_o =  36'b100001000011001010001000100000010000; //  X 4 3 2 X X X 1 0
         9'b011100100: bk_o =  36'b100000110010000110001000000010001000; //  X 3 2 1 X X 0 X X
         9'b011100101: bk_o =  36'b100001000011001010001000000110000000; //  X 4 3 2 X X 1 X 0
         9'b011100110: bk_o =  36'b100001000011001010001000000100001000; //  X 4 3 2 X X 1 0 X
         9'b011100111: bk_o =  36'b100001010100001110001000001000010000; //  X 5 4 3 X X 2 1 0
         9'b011101000: bk_o =  36'b100000110010000110000000100010001000; //  X 3 2 1 X 0 X X X
         9'b011101001: bk_o =  36'b100001000011001010000001100010000000; //  X 4 3 2 X 1 X X 0
         9'b011101010: bk_o =  36'b100001000011001010000001100000001000; //  X 4 3 2 X 1 X 0 X
         9'b011101011: bk_o =  36'b100001010100001110000010100000010000; //  X 5 4 3 X 2 X 1 0
         9'b011101100: bk_o =  36'b100001000011001010000001000010001000; //  X 4 3 2 X 1 0 X X
         9'b011101101: bk_o =  36'b100001010100001110000010000110000000; //  X 5 4 3 X 2 1 X 0
         9'b011101110: bk_o =  36'b100001010100001110000010000100001000; //  X 5 4 3 X 2 1 0 X
         9'b011101111: bk_o =  36'b100001100101010010000011001000010000; //  X 6 5 4 X 3 2 1 0
         9'b011110000: bk_o =  36'b100000110010000100001000100010001000; //  X 3 2 1 0 X X X X
         9'b011110001: bk_o =  36'b100001000011001000011000100010000000; //  X 4 3 2 1 X X X 0
         9'b011110010: bk_o =  36'b100001000011001000011000100000001000; //  X 4 3 2 1 X X 0 X
         9'b011110011: bk_o =  36'b100001010100001100101000100000010000; //  X 5 4 3 2 X X 1 0
         9'b011110100: bk_o =  36'b100001000011001000011000000010001000; //  X 4 3 2 1 X 0 X X
         9'b011110101: bk_o =  36'b100001010100001100101000000110000000; //  X 5 4 3 2 X 1 X 0
         9'b011110110: bk_o =  36'b100001010100001100101000000100001000; //  X 5 4 3 2 X 1 0 X
         9'b011110111: bk_o =  36'b100001100101010000111000001000010000; //  X 6 5 4 3 X 2 1 0
         9'b011111000: bk_o =  36'b100001000011001000010000100010001000; //  X 4 3 2 1 0 X X X
         9'b011111001: bk_o =  36'b100001010100001100100001100010000000; //  X 5 4 3 2 1 X X 0
         9'b011111010: bk_o =  36'b100001010100001100100001100000001000; //  X 5 4 3 2 1 X 0 X
         9'b011111011: bk_o =  36'b100001100101010000110010100000010000; //  X 6 5 4 3 2 X 1 0
         9'b011111100: bk_o =  36'b100001010100001100100001000010001000; //  X 5 4 3 2 1 0 X X
         9'b011111101: bk_o =  36'b100001100101010000110010000110000000; //  X 6 5 4 3 2 1 X 0
         9'b011111110: bk_o =  36'b100001100101010000110010000100001000; //  X 6 5 4 3 2 1 0 X
         9'b011111111: bk_o =  36'b100001110110010101000011001000010000; //  X 7 6 5 4 3 2 1 0
         9'b100000000: bk_o =  36'b000010001000100010001000100010001000; //  0 X X X X X X X X
         9'b100000001: bk_o =  36'b000110001000100010001000100010000000; //  1 X X X X X X X 0
         9'b100000010: bk_o =  36'b000110001000100010001000100000001000; //  1 X X X X X X 0 X
         9'b100000011: bk_o =  36'b001010001000100010001000100000010000; //  2 X X X X X X 1 0
         9'b100000100: bk_o =  36'b000110001000100010001000000010001000; //  1 X X X X X 0 X X
         9'b100000101: bk_o =  36'b001010001000100010001000000110000000; //  2 X X X X X 1 X 0
         9'b100000110: bk_o =  36'b001010001000100010001000000100001000; //  2 X X X X X 1 0 X
         9'b100000111: bk_o =  36'b001110001000100010001000001000010000; //  3 X X X X X 2 1 0
         9'b100001000: bk_o =  36'b000110001000100010000000100010001000; //  1 X X X X 0 X X X
         9'b100001001: bk_o =  36'b001010001000100010000001100010000000; //  2 X X X X 1 X X 0
         9'b100001010: bk_o =  36'b001010001000100010000001100000001000; //  2 X X X X 1 X 0 X
         9'b100001011: bk_o =  36'b001110001000100010000010100000010000; //  3 X X X X 2 X 1 0
         9'b100001100: bk_o =  36'b001010001000100010000001000010001000; //  2 X X X X 1 0 X X
         9'b100001101: bk_o =  36'b001110001000100010000010000110000000; //  3 X X X X 2 1 X 0
         9'b100001110: bk_o =  36'b001110001000100010000010000100001000; //  3 X X X X 2 1 0 X
         9'b100001111: bk_o =  36'b010010001000100010000011001000010000; //  4 X X X X 3 2 1 0
         9'b100010000: bk_o =  36'b000110001000100000001000100010001000; //  1 X X X 0 X X X X
         9'b100010001: bk_o =  36'b001010001000100000011000100010000000; //  2 X X X 1 X X X 0
         9'b100010010: bk_o =  36'b001010001000100000011000100000001000; //  2 X X X 1 X X 0 X
         9'b100010011: bk_o =  36'b001110001000100000101000100000010000; //  3 X X X 2 X X 1 0
         9'b100010100: bk_o =  36'b001010001000100000011000000010001000; //  2 X X X 1 X 0 X X
         9'b100010101: bk_o =  36'b001110001000100000101000000110000000; //  3 X X X 2 X 1 X 0
         9'b100010110: bk_o =  36'b001110001000100000101000000100001000; //  3 X X X 2 X 1 0 X
         9'b100010111: bk_o =  36'b010010001000100000111000001000010000; //  4 X X X 3 X 2 1 0
         9'b100011000: bk_o =  36'b001010001000100000010000100010001000; //  2 X X X 1 0 X X X
         9'b100011001: bk_o =  36'b001110001000100000100001100010000000; //  3 X X X 2 1 X X 0
         9'b100011010: bk_o =  36'b001110001000100000100001100000001000; //  3 X X X 2 1 X 0 X
         9'b100011011: bk_o =  36'b010010001000100000110010100000010000; //  4 X X X 3 2 X 1 0
         9'b100011100: bk_o =  36'b001110001000100000100001000010001000; //  3 X X X 2 1 0 X X
         9'b100011101: bk_o =  36'b010010001000100000110010000110000000; //  4 X X X 3 2 1 X 0
         9'b100011110: bk_o =  36'b010010001000100000110010000100001000; //  4 X X X 3 2 1 0 X
         9'b100011111: bk_o =  36'b010110001000100001000011001000010000; //  5 X X X 4 3 2 1 0
         9'b100100000: bk_o =  36'b000110001000000010001000100010001000; //  1 X X 0 X X X X X
         9'b100100001: bk_o =  36'b001010001000000110001000100010000000; //  2 X X 1 X X X X 0
         9'b100100010: bk_o =  36'b001010001000000110001000100000001000; //  2 X X 1 X X X 0 X
         9'b100100011: bk_o =  36'b001110001000001010001000100000010000; //  3 X X 2 X X X 1 0
         9'b100100100: bk_o =  36'b001010001000000110001000000010001000; //  2 X X 1 X X 0 X X
         9'b100100101: bk_o =  36'b001110001000001010001000000110000000; //  3 X X 2 X X 1 X 0
         9'b100100110: bk_o =  36'b001110001000001010001000000100001000; //  3 X X 2 X X 1 0 X
         9'b100100111: bk_o =  36'b010010001000001110001000001000010000; //  4 X X 3 X X 2 1 0
         9'b100101000: bk_o =  36'b001010001000000110000000100010001000; //  2 X X 1 X 0 X X X
         9'b100101001: bk_o =  36'b001110001000001010000001100010000000; //  3 X X 2 X 1 X X 0
         9'b100101010: bk_o =  36'b001110001000001010000001100000001000; //  3 X X 2 X 1 X 0 X
         9'b100101011: bk_o =  36'b010010001000001110000010100000010000; //  4 X X 3 X 2 X 1 0
         9'b100101100: bk_o =  36'b001110001000001010000001000010001000; //  3 X X 2 X 1 0 X X
         9'b100101101: bk_o =  36'b010010001000001110000010000110000000; //  4 X X 3 X 2 1 X 0
         9'b100101110: bk_o =  36'b010010001000001110000010000100001000; //  4 X X 3 X 2 1 0 X
         9'b100101111: bk_o =  36'b010110001000010010000011001000010000; //  5 X X 4 X 3 2 1 0
         9'b100110000: bk_o =  36'b001010001000000100001000100010001000; //  2 X X 1 0 X X X X
         9'b100110001: bk_o =  36'b001110001000001000011000100010000000; //  3 X X 2 1 X X X 0
         9'b100110010: bk_o =  36'b001110001000001000011000100000001000; //  3 X X 2 1 X X 0 X
         9'b100110011: bk_o =  36'b010010001000001100101000100000010000; //  4 X X 3 2 X X 1 0
         9'b100110100: bk_o =  36'b001110001000001000011000000010001000; //  3 X X 2 1 X 0 X X
         9'b100110101: bk_o =  36'b010010001000001100101000000110000000; //  4 X X 3 2 X 1 X 0
         9'b100110110: bk_o =  36'b010010001000001100101000000100001000; //  4 X X 3 2 X 1 0 X
         9'b100110111: bk_o =  36'b010110001000010000111000001000010000; //  5 X X 4 3 X 2 1 0
         9'b100111000: bk_o =  36'b001110001000001000010000100010001000; //  3 X X 2 1 0 X X X
         9'b100111001: bk_o =  36'b010010001000001100100001100010000000; //  4 X X 3 2 1 X X 0
         9'b100111010: bk_o =  36'b010010001000001100100001100000001000; //  4 X X 3 2 1 X 0 X
         9'b100111011: bk_o =  36'b010110001000010000110010100000010000; //  5 X X 4 3 2 X 1 0
         9'b100111100: bk_o =  36'b010010001000001100100001000010001000; //  4 X X 3 2 1 0 X X
         9'b100111101: bk_o =  36'b010110001000010000110010000110000000; //  5 X X 4 3 2 1 X 0
         9'b100111110: bk_o =  36'b010110001000010000110010000100001000; //  5 X X 4 3 2 1 0 X
         9'b100111111: bk_o =  36'b011010001000010101000011001000010000; //  6 X X 5 4 3 2 1 0
         9'b101000000: bk_o =  36'b000110000000100010001000100010001000; //  1 X 0 X X X X X X
         9'b101000001: bk_o =  36'b001010000001100010001000100010000000; //  2 X 1 X X X X X 0
         9'b101000010: bk_o =  36'b001010000001100010001000100000001000; //  2 X 1 X X X X 0 X
         9'b101000011: bk_o =  36'b001110000010100010001000100000010000; //  3 X 2 X X X X 1 0
         9'b101000100: bk_o =  36'b001010000001100010001000000010001000; //  2 X 1 X X X 0 X X
         9'b101000101: bk_o =  36'b001110000010100010001000000110000000; //  3 X 2 X X X 1 X 0
         9'b101000110: bk_o =  36'b001110000010100010001000000100001000; //  3 X 2 X X X 1 0 X
         9'b101000111: bk_o =  36'b010010000011100010001000001000010000; //  4 X 3 X X X 2 1 0
         9'b101001000: bk_o =  36'b001010000001100010000000100010001000; //  2 X 1 X X 0 X X X
         9'b101001001: bk_o =  36'b001110000010100010000001100010000000; //  3 X 2 X X 1 X X 0
         9'b101001010: bk_o =  36'b001110000010100010000001100000001000; //  3 X 2 X X 1 X 0 X
         9'b101001011: bk_o =  36'b010010000011100010000010100000010000; //  4 X 3 X X 2 X 1 0
         9'b101001100: bk_o =  36'b001110000010100010000001000010001000; //  3 X 2 X X 1 0 X X
         9'b101001101: bk_o =  36'b010010000011100010000010000110000000; //  4 X 3 X X 2 1 X 0
         9'b101001110: bk_o =  36'b010010000011100010000010000100001000; //  4 X 3 X X 2 1 0 X
         9'b101001111: bk_o =  36'b010110000100100010000011001000010000; //  5 X 4 X X 3 2 1 0
         9'b101010000: bk_o =  36'b001010000001100000001000100010001000; //  2 X 1 X 0 X X X X
         9'b101010001: bk_o =  36'b001110000010100000011000100010000000; //  3 X 2 X 1 X X X 0
         9'b101010010: bk_o =  36'b001110000010100000011000100000001000; //  3 X 2 X 1 X X 0 X
         9'b101010011: bk_o =  36'b010010000011100000101000100000010000; //  4 X 3 X 2 X X 1 0
         9'b101010100: bk_o =  36'b001110000010100000011000000010001000; //  3 X 2 X 1 X 0 X X
         9'b101010101: bk_o =  36'b010010000011100000101000000110000000; //  4 X 3 X 2 X 1 X 0
         9'b101010110: bk_o =  36'b010010000011100000101000000100001000; //  4 X 3 X 2 X 1 0 X
         9'b101010111: bk_o =  36'b010110000100100000111000001000010000; //  5 X 4 X 3 X 2 1 0
         9'b101011000: bk_o =  36'b001110000010100000010000100010001000; //  3 X 2 X 1 0 X X X
         9'b101011001: bk_o =  36'b010010000011100000100001100010000000; //  4 X 3 X 2 1 X X 0
         9'b101011010: bk_o =  36'b010010000011100000100001100000001000; //  4 X 3 X 2 1 X 0 X
         9'b101011011: bk_o =  36'b010110000100100000110010100000010000; //  5 X 4 X 3 2 X 1 0
         9'b101011100: bk_o =  36'b010010000011100000100001000010001000; //  4 X 3 X 2 1 0 X X
         9'b101011101: bk_o =  36'b010110000100100000110010000110000000; //  5 X 4 X 3 2 1 X 0
         9'b101011110: bk_o =  36'b010110000100100000110010000100001000; //  5 X 4 X 3 2 1 0 X
         9'b101011111: bk_o =  36'b011010000101100001000011001000010000; //  6 X 5 X 4 3 2 1 0
         9'b101100000: bk_o =  36'b001010000001000010001000100010001000; //  2 X 1 0 X X X X X
         9'b101100001: bk_o =  36'b001110000010000110001000100010000000; //  3 X 2 1 X X X X 0
         9'b101100010: bk_o =  36'b001110000010000110001000100000001000; //  3 X 2 1 X X X 0 X
         9'b101100011: bk_o =  36'b010010000011001010001000100000010000; //  4 X 3 2 X X X 1 0
         9'b101100100: bk_o =  36'b001110000010000110001000000010001000; //  3 X 2 1 X X 0 X X
         9'b101100101: bk_o =  36'b010010000011001010001000000110000000; //  4 X 3 2 X X 1 X 0
         9'b101100110: bk_o =  36'b010010000011001010001000000100001000; //  4 X 3 2 X X 1 0 X
         9'b101100111: bk_o =  36'b010110000100001110001000001000010000; //  5 X 4 3 X X 2 1 0
         9'b101101000: bk_o =  36'b001110000010000110000000100010001000; //  3 X 2 1 X 0 X X X
         9'b101101001: bk_o =  36'b010010000011001010000001100010000000; //  4 X 3 2 X 1 X X 0
         9'b101101010: bk_o =  36'b010010000011001010000001100000001000; //  4 X 3 2 X 1 X 0 X
         9'b101101011: bk_o =  36'b010110000100001110000010100000010000; //  5 X 4 3 X 2 X 1 0
         9'b101101100: bk_o =  36'b010010000011001010000001000010001000; //  4 X 3 2 X 1 0 X X
         9'b101101101: bk_o =  36'b010110000100001110000010000110000000; //  5 X 4 3 X 2 1 X 0
         9'b101101110: bk_o =  36'b010110000100001110000010000100001000; //  5 X 4 3 X 2 1 0 X
         9'b101101111: bk_o =  36'b011010000101010010000011001000010000; //  6 X 5 4 X 3 2 1 0
         9'b101110000: bk_o =  36'b001110000010000100001000100010001000; //  3 X 2 1 0 X X X X
         9'b101110001: bk_o =  36'b010010000011001000011000100010000000; //  4 X 3 2 1 X X X 0
         9'b101110010: bk_o =  36'b010010000011001000011000100000001000; //  4 X 3 2 1 X X 0 X
         9'b101110011: bk_o =  36'b010110000100001100101000100000010000; //  5 X 4 3 2 X X 1 0
         9'b101110100: bk_o =  36'b010010000011001000011000000010001000; //  4 X 3 2 1 X 0 X X
         9'b101110101: bk_o =  36'b010110000100001100101000000110000000; //  5 X 4 3 2 X 1 X 0
         9'b101110110: bk_o =  36'b010110000100001100101000000100001000; //  5 X 4 3 2 X 1 0 X
         9'b101110111: bk_o =  36'b011010000101010000111000001000010000; //  6 X 5 4 3 X 2 1 0
         9'b101111000: bk_o =  36'b010010000011001000010000100010001000; //  4 X 3 2 1 0 X X X
         9'b101111001: bk_o =  36'b010110000100001100100001100010000000; //  5 X 4 3 2 1 X X 0
         9'b101111010: bk_o =  36'b010110000100001100100001100000001000; //  5 X 4 3 2 1 X 0 X
         9'b101111011: bk_o =  36'b011010000101010000110010100000010000; //  6 X 5 4 3 2 X 1 0
         9'b101111100: bk_o =  36'b010110000100001100100001000010001000; //  5 X 4 3 2 1 0 X X
         9'b101111101: bk_o =  36'b011010000101010000110010000110000000; //  6 X 5 4 3 2 1 X 0
         9'b101111110: bk_o =  36'b011010000101010000110010000100001000; //  6 X 5 4 3 2 1 0 X
         9'b101111111: bk_o =  36'b011110000110010101000011001000010000; //  7 X 6 5 4 3 2 1 0
         9'b110000000: bk_o =  36'b000100001000100010001000100010001000; //  1 0 X X X X X X X
         9'b110000001: bk_o =  36'b001000011000100010001000100010000000; //  2 1 X X X X X X 0
         9'b110000010: bk_o =  36'b001000011000100010001000100000001000; //  2 1 X X X X X 0 X
         9'b110000011: bk_o =  36'b001100101000100010001000100000010000; //  3 2 X X X X X 1 0
         9'b110000100: bk_o =  36'b001000011000100010001000000010001000; //  2 1 X X X X 0 X X
         9'b110000101: bk_o =  36'b001100101000100010001000000110000000; //  3 2 X X X X 1 X 0
         9'b110000110: bk_o =  36'b001100101000100010001000000100001000; //  3 2 X X X X 1 0 X
         9'b110000111: bk_o =  36'b010000111000100010001000001000010000; //  4 3 X X X X 2 1 0
         9'b110001000: bk_o =  36'b001000011000100010000000100010001000; //  2 1 X X X 0 X X X
         9'b110001001: bk_o =  36'b001100101000100010000001100010000000; //  3 2 X X X 1 X X 0
         9'b110001010: bk_o =  36'b001100101000100010000001100000001000; //  3 2 X X X 1 X 0 X
         9'b110001011: bk_o =  36'b010000111000100010000010100000010000; //  4 3 X X X 2 X 1 0
         9'b110001100: bk_o =  36'b001100101000100010000001000010001000; //  3 2 X X X 1 0 X X
         9'b110001101: bk_o =  36'b010000111000100010000010000110000000; //  4 3 X X X 2 1 X 0
         9'b110001110: bk_o =  36'b010000111000100010000010000100001000; //  4 3 X X X 2 1 0 X
         9'b110001111: bk_o =  36'b010101001000100010000011001000010000; //  5 4 X X X 3 2 1 0
         9'b110010000: bk_o =  36'b001000011000100000001000100010001000; //  2 1 X X 0 X X X X
         9'b110010001: bk_o =  36'b001100101000100000011000100010000000; //  3 2 X X 1 X X X 0
         9'b110010010: bk_o =  36'b001100101000100000011000100000001000; //  3 2 X X 1 X X 0 X
         9'b110010011: bk_o =  36'b010000111000100000101000100000010000; //  4 3 X X 2 X X 1 0
         9'b110010100: bk_o =  36'b001100101000100000011000000010001000; //  3 2 X X 1 X 0 X X
         9'b110010101: bk_o =  36'b010000111000100000101000000110000000; //  4 3 X X 2 X 1 X 0
         9'b110010110: bk_o =  36'b010000111000100000101000000100001000; //  4 3 X X 2 X 1 0 X
         9'b110010111: bk_o =  36'b010101001000100000111000001000010000; //  5 4 X X 3 X 2 1 0
         9'b110011000: bk_o =  36'b001100101000100000010000100010001000; //  3 2 X X 1 0 X X X
         9'b110011001: bk_o =  36'b010000111000100000100001100010000000; //  4 3 X X 2 1 X X 0
         9'b110011010: bk_o =  36'b010000111000100000100001100000001000; //  4 3 X X 2 1 X 0 X
         9'b110011011: bk_o =  36'b010101001000100000110010100000010000; //  5 4 X X 3 2 X 1 0
         9'b110011100: bk_o =  36'b010000111000100000100001000010001000; //  4 3 X X 2 1 0 X X
         9'b110011101: bk_o =  36'b010101001000100000110010000110000000; //  5 4 X X 3 2 1 X 0
         9'b110011110: bk_o =  36'b010101001000100000110010000100001000; //  5 4 X X 3 2 1 0 X
         9'b110011111: bk_o =  36'b011001011000100001000011001000010000; //  6 5 X X 4 3 2 1 0
         9'b110100000: bk_o =  36'b001000011000000010001000100010001000; //  2 1 X 0 X X X X X
         9'b110100001: bk_o =  36'b001100101000000110001000100010000000; //  3 2 X 1 X X X X 0
         9'b110100010: bk_o =  36'b001100101000000110001000100000001000; //  3 2 X 1 X X X 0 X
         9'b110100011: bk_o =  36'b010000111000001010001000100000010000; //  4 3 X 2 X X X 1 0
         9'b110100100: bk_o =  36'b001100101000000110001000000010001000; //  3 2 X 1 X X 0 X X
         9'b110100101: bk_o =  36'b010000111000001010001000000110000000; //  4 3 X 2 X X 1 X 0
         9'b110100110: bk_o =  36'b010000111000001010001000000100001000; //  4 3 X 2 X X 1 0 X
         9'b110100111: bk_o =  36'b010101001000001110001000001000010000; //  5 4 X 3 X X 2 1 0
         9'b110101000: bk_o =  36'b001100101000000110000000100010001000; //  3 2 X 1 X 0 X X X
         9'b110101001: bk_o =  36'b010000111000001010000001100010000000; //  4 3 X 2 X 1 X X 0
         9'b110101010: bk_o =  36'b010000111000001010000001100000001000; //  4 3 X 2 X 1 X 0 X
         9'b110101011: bk_o =  36'b010101001000001110000010100000010000; //  5 4 X 3 X 2 X 1 0
         9'b110101100: bk_o =  36'b010000111000001010000001000010001000; //  4 3 X 2 X 1 0 X X
         9'b110101101: bk_o =  36'b010101001000001110000010000110000000; //  5 4 X 3 X 2 1 X 0
         9'b110101110: bk_o =  36'b010101001000001110000010000100001000; //  5 4 X 3 X 2 1 0 X
         9'b110101111: bk_o =  36'b011001011000010010000011001000010000; //  6 5 X 4 X 3 2 1 0
         9'b110110000: bk_o =  36'b001100101000000100001000100010001000; //  3 2 X 1 0 X X X X
         9'b110110001: bk_o =  36'b010000111000001000011000100010000000; //  4 3 X 2 1 X X X 0
         9'b110110010: bk_o =  36'b010000111000001000011000100000001000; //  4 3 X 2 1 X X 0 X
         9'b110110011: bk_o =  36'b010101001000001100101000100000010000; //  5 4 X 3 2 X X 1 0
         9'b110110100: bk_o =  36'b010000111000001000011000000010001000; //  4 3 X 2 1 X 0 X X
         9'b110110101: bk_o =  36'b010101001000001100101000000110000000; //  5 4 X 3 2 X 1 X 0
         9'b110110110: bk_o =  36'b010101001000001100101000000100001000; //  5 4 X 3 2 X 1 0 X
         9'b110110111: bk_o =  36'b011001011000010000111000001000010000; //  6 5 X 4 3 X 2 1 0
         9'b110111000: bk_o =  36'b010000111000001000010000100010001000; //  4 3 X 2 1 0 X X X
         9'b110111001: bk_o =  36'b010101001000001100100001100010000000; //  5 4 X 3 2 1 X X 0
         9'b110111010: bk_o =  36'b010101001000001100100001100000001000; //  5 4 X 3 2 1 X 0 X
         9'b110111011: bk_o =  36'b011001011000010000110010100000010000; //  6 5 X 4 3 2 X 1 0
         9'b110111100: bk_o =  36'b010101001000001100100001000010001000; //  5 4 X 3 2 1 0 X X
         9'b110111101: bk_o =  36'b011001011000010000110010000110000000; //  6 5 X 4 3 2 1 X 0
         9'b110111110: bk_o =  36'b011001011000010000110010000100001000; //  6 5 X 4 3 2 1 0 X
         9'b110111111: bk_o =  36'b011101101000010101000011001000010000; //  7 6 X 5 4 3 2 1 0
         9'b111000000: bk_o =  36'b001000010000100010001000100010001000; //  2 1 0 X X X X X X
         9'b111000001: bk_o =  36'b001100100001100010001000100010000000; //  3 2 1 X X X X X 0
         9'b111000010: bk_o =  36'b001100100001100010001000100000001000; //  3 2 1 X X X X 0 X
         9'b111000011: bk_o =  36'b010000110010100010001000100000010000; //  4 3 2 X X X X 1 0
         9'b111000100: bk_o =  36'b001100100001100010001000000010001000; //  3 2 1 X X X 0 X X
         9'b111000101: bk_o =  36'b010000110010100010001000000110000000; //  4 3 2 X X X 1 X 0
         9'b111000110: bk_o =  36'b010000110010100010001000000100001000; //  4 3 2 X X X 1 0 X
         9'b111000111: bk_o =  36'b010101000011100010001000001000010000; //  5 4 3 X X X 2 1 0
         9'b111001000: bk_o =  36'b001100100001100010000000100010001000; //  3 2 1 X X 0 X X X
         9'b111001001: bk_o =  36'b010000110010100010000001100010000000; //  4 3 2 X X 1 X X 0
         9'b111001010: bk_o =  36'b010000110010100010000001100000001000; //  4 3 2 X X 1 X 0 X
         9'b111001011: bk_o =  36'b010101000011100010000010100000010000; //  5 4 3 X X 2 X 1 0
         9'b111001100: bk_o =  36'b010000110010100010000001000010001000; //  4 3 2 X X 1 0 X X
         9'b111001101: bk_o =  36'b010101000011100010000010000110000000; //  5 4 3 X X 2 1 X 0
         9'b111001110: bk_o =  36'b010101000011100010000010000100001000; //  5 4 3 X X 2 1 0 X
         9'b111001111: bk_o =  36'b011001010100100010000011001000010000; //  6 5 4 X X 3 2 1 0
         9'b111010000: bk_o =  36'b001100100001100000001000100010001000; //  3 2 1 X 0 X X X X
         9'b111010001: bk_o =  36'b010000110010100000011000100010000000; //  4 3 2 X 1 X X X 0
         9'b111010010: bk_o =  36'b010000110010100000011000100000001000; //  4 3 2 X 1 X X 0 X
         9'b111010011: bk_o =  36'b010101000011100000101000100000010000; //  5 4 3 X 2 X X 1 0
         9'b111010100: bk_o =  36'b010000110010100000011000000010001000; //  4 3 2 X 1 X 0 X X
         9'b111010101: bk_o =  36'b010101000011100000101000000110000000; //  5 4 3 X 2 X 1 X 0
         9'b111010110: bk_o =  36'b010101000011100000101000000100001000; //  5 4 3 X 2 X 1 0 X
         9'b111010111: bk_o =  36'b011001010100100000111000001000010000; //  6 5 4 X 3 X 2 1 0
         9'b111011000: bk_o =  36'b010000110010100000010000100010001000; //  4 3 2 X 1 0 X X X
         9'b111011001: bk_o =  36'b010101000011100000100001100010000000; //  5 4 3 X 2 1 X X 0
         9'b111011010: bk_o =  36'b010101000011100000100001100000001000; //  5 4 3 X 2 1 X 0 X
         9'b111011011: bk_o =  36'b011001010100100000110010100000010000; //  6 5 4 X 3 2 X 1 0
         9'b111011100: bk_o =  36'b010101000011100000100001000010001000; //  5 4 3 X 2 1 0 X X
         9'b111011101: bk_o =  36'b011001010100100000110010000110000000; //  6 5 4 X 3 2 1 X 0
         9'b111011110: bk_o =  36'b011001010100100000110010000100001000; //  6 5 4 X 3 2 1 0 X
         9'b111011111: bk_o =  36'b011101100101100001000011001000010000; //  7 6 5 X 4 3 2 1 0
         9'b111100000: bk_o =  36'b001100100001000010001000100010001000; //  3 2 1 0 X X X X X
         9'b111100001: bk_o =  36'b010000110010000110001000100010000000; //  4 3 2 1 X X X X 0
         9'b111100010: bk_o =  36'b010000110010000110001000100000001000; //  4 3 2 1 X X X 0 X
         9'b111100011: bk_o =  36'b010101000011001010001000100000010000; //  5 4 3 2 X X X 1 0
         9'b111100100: bk_o =  36'b010000110010000110001000000010001000; //  4 3 2 1 X X 0 X X
         9'b111100101: bk_o =  36'b010101000011001010001000000110000000; //  5 4 3 2 X X 1 X 0
         9'b111100110: bk_o =  36'b010101000011001010001000000100001000; //  5 4 3 2 X X 1 0 X
         9'b111100111: bk_o =  36'b011001010100001110001000001000010000; //  6 5 4 3 X X 2 1 0
         9'b111101000: bk_o =  36'b010000110010000110000000100010001000; //  4 3 2 1 X 0 X X X
         9'b111101001: bk_o =  36'b010101000011001010000001100010000000; //  5 4 3 2 X 1 X X 0
         9'b111101010: bk_o =  36'b010101000011001010000001100000001000; //  5 4 3 2 X 1 X 0 X
         9'b111101011: bk_o =  36'b011001010100001110000010100000010000; //  6 5 4 3 X 2 X 1 0
         9'b111101100: bk_o =  36'b010101000011001010000001000010001000; //  5 4 3 2 X 1 0 X X
         9'b111101101: bk_o =  36'b011001010100001110000010000110000000; //  6 5 4 3 X 2 1 X 0
         9'b111101110: bk_o =  36'b011001010100001110000010000100001000; //  6 5 4 3 X 2 1 0 X
         9'b111101111: bk_o =  36'b011101100101010010000011001000010000; //  7 6 5 4 X 3 2 1 0
         9'b111110000: bk_o =  36'b010000110010000100001000100010001000; //  4 3 2 1 0 X X X X
         9'b111110001: bk_o =  36'b010101000011001000011000100010000000; //  5 4 3 2 1 X X X 0
         9'b111110010: bk_o =  36'b010101000011001000011000100000001000; //  5 4 3 2 1 X X 0 X
         9'b111110011: bk_o =  36'b011001010100001100101000100000010000; //  6 5 4 3 2 X X 1 0
         9'b111110100: bk_o =  36'b010101000011001000011000000010001000; //  5 4 3 2 1 X 0 X X
         9'b111110101: bk_o =  36'b011001010100001100101000000110000000; //  6 5 4 3 2 X 1 X 0
         9'b111110110: bk_o =  36'b011001010100001100101000000100001000; //  6 5 4 3 2 X 1 0 X
         9'b111110111: bk_o =  36'b011101100101010000111000001000010000; //  7 6 5 4 3 X 2 1 0
         9'b111111000: bk_o =  36'b010101000011001000010000100010001000; //  5 4 3 2 1 0 X X X
         9'b111111001: bk_o =  36'b011001010100001100100001100010000000; //  6 5 4 3 2 1 X X 0
         9'b111111010: bk_o =  36'b011001010100001100100001100000001000; //  6 5 4 3 2 1 X 0 X
         9'b111111011: bk_o =  36'b011101100101010000110010100000010000; //  7 6 5 4 3 2 X 1 0
         9'b111111100: bk_o =  36'b011001010100001100100001000010001000; //  6 5 4 3 2 1 0 X X
         9'b111111101: bk_o =  36'b011101100101010000110010000110000000; //  7 6 5 4 3 2 1 X 0
         9'b111111110: bk_o =  36'b011101100101010000110010000100001000; //  7 6 5 4 3 2 1 0 X
         9'b111111111: bk_o =  36'b100001110110010101000011001000010000; //  8 7 6 5 4 3 2 1 0
        default: bk_o= 'X;
    endcase

    // backward vec datapath
    always_comb
    unique case (vec_i) 
         9'b000000000: bk_datapath_o =  36'b000000000000000000000000000000000000; //  X X X X X X X X X
         9'b000000001: bk_datapath_o =  36'b000000000000000000000000000000000000; //  X X X X X X X X 0
         9'b000000010: bk_datapath_o =  36'b000000000000000000000000000000000000; //  X X X X X X X 0 X
         9'b000000011: bk_datapath_o =  36'b000000000000000000000000000000010000; //  X X X X X X X 1 0
         9'b000000100: bk_datapath_o =  36'b000000000000000000000000000000000000; //  X X X X X X 0 X X
         9'b000000101: bk_datapath_o =  36'b000000000000000000000000000100000000; //  X X X X X X 1 X 0
         9'b000000110: bk_datapath_o =  36'b000000000000000000000000000100000000; //  X X X X X X 1 0 X
         9'b000000111: bk_datapath_o =  36'b000000000000000000000000001000010000; //  X X X X X X 2 1 0
         9'b000001000: bk_datapath_o =  36'b000000000000000000000000000000000000; //  X X X X X 0 X X X
         9'b000001001: bk_datapath_o =  36'b000000000000000000000001000000000000; //  X X X X X 1 X X 0
         9'b000001010: bk_datapath_o =  36'b000000000000000000000001000000000000; //  X X X X X 1 X 0 X
         9'b000001011: bk_datapath_o =  36'b000000000000000000000010000000010000; //  X X X X X 2 X 1 0
         9'b000001100: bk_datapath_o =  36'b000000000000000000000001000000000000; //  X X X X X 1 0 X X
         9'b000001101: bk_datapath_o =  36'b000000000000000000000010000100000000; //  X X X X X 2 1 X 0
         9'b000001110: bk_datapath_o =  36'b000000000000000000000010000100000000; //  X X X X X 2 1 0 X
         9'b000001111: bk_datapath_o =  36'b000000000000000000000011001000010000; //  X X X X X 3 2 1 0
         9'b000010000: bk_datapath_o =  36'b000000000000000000000000000000000000; //  X X X X 0 X X X X
         9'b000010001: bk_datapath_o =  36'b000000000000000000010000000000000000; //  X X X X 1 X X X 0
         9'b000010010: bk_datapath_o =  36'b000000000000000000010000000000000000; //  X X X X 1 X X 0 X
         9'b000010011: bk_datapath_o =  36'b000000000000000000100000000000010000; //  X X X X 2 X X 1 0
         9'b000010100: bk_datapath_o =  36'b000000000000000000010000000000000000; //  X X X X 1 X 0 X X
         9'b000010101: bk_datapath_o =  36'b000000000000000000100000000100000000; //  X X X X 2 X 1 X 0
         9'b000010110: bk_datapath_o =  36'b000000000000000000100000000100000000; //  X X X X 2 X 1 0 X
         9'b000010111: bk_datapath_o =  36'b000000000000000000110000001000010000; //  X X X X 3 X 2 1 0
         9'b000011000: bk_datapath_o =  36'b000000000000000000010000000000000000; //  X X X X 1 0 X X X
         9'b000011001: bk_datapath_o =  36'b000000000000000000100001000000000000; //  X X X X 2 1 X X 0
         9'b000011010: bk_datapath_o =  36'b000000000000000000100001000000000000; //  X X X X 2 1 X 0 X
         9'b000011011: bk_datapath_o =  36'b000000000000000000110010000000010000; //  X X X X 3 2 X 1 0
         9'b000011100: bk_datapath_o =  36'b000000000000000000100001000000000000; //  X X X X 2 1 0 X X
         9'b000011101: bk_datapath_o =  36'b000000000000000000110010000100000000; //  X X X X 3 2 1 X 0
         9'b000011110: bk_datapath_o =  36'b000000000000000000110010000100000000; //  X X X X 3 2 1 0 X
         9'b000011111: bk_datapath_o =  36'b000000000000000001000011001000010000; //  X X X X 4 3 2 1 0
         9'b000100000: bk_datapath_o =  36'b000000000000000000000000000000000000; //  X X X 0 X X X X X
         9'b000100001: bk_datapath_o =  36'b000000000000000100000000000000000000; //  X X X 1 X X X X 0
         9'b000100010: bk_datapath_o =  36'b000000000000000100000000000000000000; //  X X X 1 X X X 0 X
         9'b000100011: bk_datapath_o =  36'b000000000000001000000000000000010000; //  X X X 2 X X X 1 0
         9'b000100100: bk_datapath_o =  36'b000000000000000100000000000000000000; //  X X X 1 X X 0 X X
         9'b000100101: bk_datapath_o =  36'b000000000000001000000000000100000000; //  X X X 2 X X 1 X 0
         9'b000100110: bk_datapath_o =  36'b000000000000001000000000000100000000; //  X X X 2 X X 1 0 X
         9'b000100111: bk_datapath_o =  36'b000000000000001100000000001000010000; //  X X X 3 X X 2 1 0
         9'b000101000: bk_datapath_o =  36'b000000000000000100000000000000000000; //  X X X 1 X 0 X X X
         9'b000101001: bk_datapath_o =  36'b000000000000001000000001000000000000; //  X X X 2 X 1 X X 0
         9'b000101010: bk_datapath_o =  36'b000000000000001000000001000000000000; //  X X X 2 X 1 X 0 X
         9'b000101011: bk_datapath_o =  36'b000000000000001100000010000000010000; //  X X X 3 X 2 X 1 0
         9'b000101100: bk_datapath_o =  36'b000000000000001000000001000000000000; //  X X X 2 X 1 0 X X
         9'b000101101: bk_datapath_o =  36'b000000000000001100000010000100000000; //  X X X 3 X 2 1 X 0
         9'b000101110: bk_datapath_o =  36'b000000000000001100000010000100000000; //  X X X 3 X 2 1 0 X
         9'b000101111: bk_datapath_o =  36'b000000000000010000000011001000010000; //  X X X 4 X 3 2 1 0
         9'b000110000: bk_datapath_o =  36'b000000000000000100000000000000000000; //  X X X 1 0 X X X X
         9'b000110001: bk_datapath_o =  36'b000000000000001000010000000000000000; //  X X X 2 1 X X X 0
         9'b000110010: bk_datapath_o =  36'b000000000000001000010000000000000000; //  X X X 2 1 X X 0 X
         9'b000110011: bk_datapath_o =  36'b000000000000001100100000000000010000; //  X X X 3 2 X X 1 0
         9'b000110100: bk_datapath_o =  36'b000000000000001000010000000000000000; //  X X X 2 1 X 0 X X
         9'b000110101: bk_datapath_o =  36'b000000000000001100100000000100000000; //  X X X 3 2 X 1 X 0
         9'b000110110: bk_datapath_o =  36'b000000000000001100100000000100000000; //  X X X 3 2 X 1 0 X
         9'b000110111: bk_datapath_o =  36'b000000000000010000110000001000010000; //  X X X 4 3 X 2 1 0
         9'b000111000: bk_datapath_o =  36'b000000000000001000010000000000000000; //  X X X 2 1 0 X X X
         9'b000111001: bk_datapath_o =  36'b000000000000001100100001000000000000; //  X X X 3 2 1 X X 0
         9'b000111010: bk_datapath_o =  36'b000000000000001100100001000000000000; //  X X X 3 2 1 X 0 X
         9'b000111011: bk_datapath_o =  36'b000000000000010000110010000000010000; //  X X X 4 3 2 X 1 0
         9'b000111100: bk_datapath_o =  36'b000000000000001100100001000000000000; //  X X X 3 2 1 0 X X
         9'b000111101: bk_datapath_o =  36'b000000000000010000110010000100000000; //  X X X 4 3 2 1 X 0
         9'b000111110: bk_datapath_o =  36'b000000000000010000110010000100000000; //  X X X 4 3 2 1 0 X
         9'b000111111: bk_datapath_o =  36'b000000000000010101000011001000010000; //  X X X 5 4 3 2 1 0
         9'b001000000: bk_datapath_o =  36'b000000000000000000000000000000000000; //  X X 0 X X X X X X
         9'b001000001: bk_datapath_o =  36'b000000000001000000000000000000000000; //  X X 1 X X X X X 0
         9'b001000010: bk_datapath_o =  36'b000000000001000000000000000000000000; //  X X 1 X X X X 0 X
         9'b001000011: bk_datapath_o =  36'b000000000010000000000000000000010000; //  X X 2 X X X X 1 0
         9'b001000100: bk_datapath_o =  36'b000000000001000000000000000000000000; //  X X 1 X X X 0 X X
         9'b001000101: bk_datapath_o =  36'b000000000010000000000000000100000000; //  X X 2 X X X 1 X 0
         9'b001000110: bk_datapath_o =  36'b000000000010000000000000000100000000; //  X X 2 X X X 1 0 X
         9'b001000111: bk_datapath_o =  36'b000000000011000000000000001000010000; //  X X 3 X X X 2 1 0
         9'b001001000: bk_datapath_o =  36'b000000000001000000000000000000000000; //  X X 1 X X 0 X X X
         9'b001001001: bk_datapath_o =  36'b000000000010000000000001000000000000; //  X X 2 X X 1 X X 0
         9'b001001010: bk_datapath_o =  36'b000000000010000000000001000000000000; //  X X 2 X X 1 X 0 X
         9'b001001011: bk_datapath_o =  36'b000000000011000000000010000000010000; //  X X 3 X X 2 X 1 0
         9'b001001100: bk_datapath_o =  36'b000000000010000000000001000000000000; //  X X 2 X X 1 0 X X
         9'b001001101: bk_datapath_o =  36'b000000000011000000000010000100000000; //  X X 3 X X 2 1 X 0
         9'b001001110: bk_datapath_o =  36'b000000000011000000000010000100000000; //  X X 3 X X 2 1 0 X
         9'b001001111: bk_datapath_o =  36'b000000000100000000000011001000010000; //  X X 4 X X 3 2 1 0
         9'b001010000: bk_datapath_o =  36'b000000000001000000000000000000000000; //  X X 1 X 0 X X X X
         9'b001010001: bk_datapath_o =  36'b000000000010000000010000000000000000; //  X X 2 X 1 X X X 0
         9'b001010010: bk_datapath_o =  36'b000000000010000000010000000000000000; //  X X 2 X 1 X X 0 X
         9'b001010011: bk_datapath_o =  36'b000000000011000000100000000000010000; //  X X 3 X 2 X X 1 0
         9'b001010100: bk_datapath_o =  36'b000000000010000000010000000000000000; //  X X 2 X 1 X 0 X X
         9'b001010101: bk_datapath_o =  36'b000000000011000000100000000100000000; //  X X 3 X 2 X 1 X 0
         9'b001010110: bk_datapath_o =  36'b000000000011000000100000000100000000; //  X X 3 X 2 X 1 0 X
         9'b001010111: bk_datapath_o =  36'b000000000100000000110000001000010000; //  X X 4 X 3 X 2 1 0
         9'b001011000: bk_datapath_o =  36'b000000000010000000010000000000000000; //  X X 2 X 1 0 X X X
         9'b001011001: bk_datapath_o =  36'b000000000011000000100001000000000000; //  X X 3 X 2 1 X X 0
         9'b001011010: bk_datapath_o =  36'b000000000011000000100001000000000000; //  X X 3 X 2 1 X 0 X
         9'b001011011: bk_datapath_o =  36'b000000000100000000110010000000010000; //  X X 4 X 3 2 X 1 0
         9'b001011100: bk_datapath_o =  36'b000000000011000000100001000000000000; //  X X 3 X 2 1 0 X X
         9'b001011101: bk_datapath_o =  36'b000000000100000000110010000100000000; //  X X 4 X 3 2 1 X 0
         9'b001011110: bk_datapath_o =  36'b000000000100000000110010000100000000; //  X X 4 X 3 2 1 0 X
         9'b001011111: bk_datapath_o =  36'b000000000101000001000011001000010000; //  X X 5 X 4 3 2 1 0
         9'b001100000: bk_datapath_o =  36'b000000000001000000000000000000000000; //  X X 1 0 X X X X X
         9'b001100001: bk_datapath_o =  36'b000000000010000100000000000000000000; //  X X 2 1 X X X X 0
         9'b001100010: bk_datapath_o =  36'b000000000010000100000000000000000000; //  X X 2 1 X X X 0 X
         9'b001100011: bk_datapath_o =  36'b000000000011001000000000000000010000; //  X X 3 2 X X X 1 0
         9'b001100100: bk_datapath_o =  36'b000000000010000100000000000000000000; //  X X 2 1 X X 0 X X
         9'b001100101: bk_datapath_o =  36'b000000000011001000000000000100000000; //  X X 3 2 X X 1 X 0
         9'b001100110: bk_datapath_o =  36'b000000000011001000000000000100000000; //  X X 3 2 X X 1 0 X
         9'b001100111: bk_datapath_o =  36'b000000000100001100000000001000010000; //  X X 4 3 X X 2 1 0
         9'b001101000: bk_datapath_o =  36'b000000000010000100000000000000000000; //  X X 2 1 X 0 X X X
         9'b001101001: bk_datapath_o =  36'b000000000011001000000001000000000000; //  X X 3 2 X 1 X X 0
         9'b001101010: bk_datapath_o =  36'b000000000011001000000001000000000000; //  X X 3 2 X 1 X 0 X
         9'b001101011: bk_datapath_o =  36'b000000000100001100000010000000010000; //  X X 4 3 X 2 X 1 0
         9'b001101100: bk_datapath_o =  36'b000000000011001000000001000000000000; //  X X 3 2 X 1 0 X X
         9'b001101101: bk_datapath_o =  36'b000000000100001100000010000100000000; //  X X 4 3 X 2 1 X 0
         9'b001101110: bk_datapath_o =  36'b000000000100001100000010000100000000; //  X X 4 3 X 2 1 0 X
         9'b001101111: bk_datapath_o =  36'b000000000101010000000011001000010000; //  X X 5 4 X 3 2 1 0
         9'b001110000: bk_datapath_o =  36'b000000000010000100000000000000000000; //  X X 2 1 0 X X X X
         9'b001110001: bk_datapath_o =  36'b000000000011001000010000000000000000; //  X X 3 2 1 X X X 0
         9'b001110010: bk_datapath_o =  36'b000000000011001000010000000000000000; //  X X 3 2 1 X X 0 X
         9'b001110011: bk_datapath_o =  36'b000000000100001100100000000000010000; //  X X 4 3 2 X X 1 0
         9'b001110100: bk_datapath_o =  36'b000000000011001000010000000000000000; //  X X 3 2 1 X 0 X X
         9'b001110101: bk_datapath_o =  36'b000000000100001100100000000100000000; //  X X 4 3 2 X 1 X 0
         9'b001110110: bk_datapath_o =  36'b000000000100001100100000000100000000; //  X X 4 3 2 X 1 0 X
         9'b001110111: bk_datapath_o =  36'b000000000101010000110000001000010000; //  X X 5 4 3 X 2 1 0
         9'b001111000: bk_datapath_o =  36'b000000000011001000010000000000000000; //  X X 3 2 1 0 X X X
         9'b001111001: bk_datapath_o =  36'b000000000100001100100001000000000000; //  X X 4 3 2 1 X X 0
         9'b001111010: bk_datapath_o =  36'b000000000100001100100001000000000000; //  X X 4 3 2 1 X 0 X
         9'b001111011: bk_datapath_o =  36'b000000000101010000110010000000010000; //  X X 5 4 3 2 X 1 0
         9'b001111100: bk_datapath_o =  36'b000000000100001100100001000000000000; //  X X 4 3 2 1 0 X X
         9'b001111101: bk_datapath_o =  36'b000000000101010000110010000100000000; //  X X 5 4 3 2 1 X 0
         9'b001111110: bk_datapath_o =  36'b000000000101010000110010000100000000; //  X X 5 4 3 2 1 0 X
         9'b001111111: bk_datapath_o =  36'b000000000110010101000011001000010000; //  X X 6 5 4 3 2 1 0
         9'b010000000: bk_datapath_o =  36'b000000000000000000000000000000000000; //  X 0 X X X X X X X
         9'b010000001: bk_datapath_o =  36'b000000010000000000000000000000000000; //  X 1 X X X X X X 0
         9'b010000010: bk_datapath_o =  36'b000000010000000000000000000000000000; //  X 1 X X X X X 0 X
         9'b010000011: bk_datapath_o =  36'b000000100000000000000000000000010000; //  X 2 X X X X X 1 0
         9'b010000100: bk_datapath_o =  36'b000000010000000000000000000000000000; //  X 1 X X X X 0 X X
         9'b010000101: bk_datapath_o =  36'b000000100000000000000000000100000000; //  X 2 X X X X 1 X 0
         9'b010000110: bk_datapath_o =  36'b000000100000000000000000000100000000; //  X 2 X X X X 1 0 X
         9'b010000111: bk_datapath_o =  36'b000000110000000000000000001000010000; //  X 3 X X X X 2 1 0
         9'b010001000: bk_datapath_o =  36'b000000010000000000000000000000000000; //  X 1 X X X 0 X X X
         9'b010001001: bk_datapath_o =  36'b000000100000000000000001000000000000; //  X 2 X X X 1 X X 0
         9'b010001010: bk_datapath_o =  36'b000000100000000000000001000000000000; //  X 2 X X X 1 X 0 X
         9'b010001011: bk_datapath_o =  36'b000000110000000000000010000000010000; //  X 3 X X X 2 X 1 0
         9'b010001100: bk_datapath_o =  36'b000000100000000000000001000000000000; //  X 2 X X X 1 0 X X
         9'b010001101: bk_datapath_o =  36'b000000110000000000000010000100000000; //  X 3 X X X 2 1 X 0
         9'b010001110: bk_datapath_o =  36'b000000110000000000000010000100000000; //  X 3 X X X 2 1 0 X
         9'b010001111: bk_datapath_o =  36'b000001000000000000000011001000010000; //  X 4 X X X 3 2 1 0
         9'b010010000: bk_datapath_o =  36'b000000010000000000000000000000000000; //  X 1 X X 0 X X X X
         9'b010010001: bk_datapath_o =  36'b000000100000000000010000000000000000; //  X 2 X X 1 X X X 0
         9'b010010010: bk_datapath_o =  36'b000000100000000000010000000000000000; //  X 2 X X 1 X X 0 X
         9'b010010011: bk_datapath_o =  36'b000000110000000000100000000000010000; //  X 3 X X 2 X X 1 0
         9'b010010100: bk_datapath_o =  36'b000000100000000000010000000000000000; //  X 2 X X 1 X 0 X X
         9'b010010101: bk_datapath_o =  36'b000000110000000000100000000100000000; //  X 3 X X 2 X 1 X 0
         9'b010010110: bk_datapath_o =  36'b000000110000000000100000000100000000; //  X 3 X X 2 X 1 0 X
         9'b010010111: bk_datapath_o =  36'b000001000000000000110000001000010000; //  X 4 X X 3 X 2 1 0
         9'b010011000: bk_datapath_o =  36'b000000100000000000010000000000000000; //  X 2 X X 1 0 X X X
         9'b010011001: bk_datapath_o =  36'b000000110000000000100001000000000000; //  X 3 X X 2 1 X X 0
         9'b010011010: bk_datapath_o =  36'b000000110000000000100001000000000000; //  X 3 X X 2 1 X 0 X
         9'b010011011: bk_datapath_o =  36'b000001000000000000110010000000010000; //  X 4 X X 3 2 X 1 0
         9'b010011100: bk_datapath_o =  36'b000000110000000000100001000000000000; //  X 3 X X 2 1 0 X X
         9'b010011101: bk_datapath_o =  36'b000001000000000000110010000100000000; //  X 4 X X 3 2 1 X 0
         9'b010011110: bk_datapath_o =  36'b000001000000000000110010000100000000; //  X 4 X X 3 2 1 0 X
         9'b010011111: bk_datapath_o =  36'b000001010000000001000011001000010000; //  X 5 X X 4 3 2 1 0
         9'b010100000: bk_datapath_o =  36'b000000010000000000000000000000000000; //  X 1 X 0 X X X X X
         9'b010100001: bk_datapath_o =  36'b000000100000000100000000000000000000; //  X 2 X 1 X X X X 0
         9'b010100010: bk_datapath_o =  36'b000000100000000100000000000000000000; //  X 2 X 1 X X X 0 X
         9'b010100011: bk_datapath_o =  36'b000000110000001000000000000000010000; //  X 3 X 2 X X X 1 0
         9'b010100100: bk_datapath_o =  36'b000000100000000100000000000000000000; //  X 2 X 1 X X 0 X X
         9'b010100101: bk_datapath_o =  36'b000000110000001000000000000100000000; //  X 3 X 2 X X 1 X 0
         9'b010100110: bk_datapath_o =  36'b000000110000001000000000000100000000; //  X 3 X 2 X X 1 0 X
         9'b010100111: bk_datapath_o =  36'b000001000000001100000000001000010000; //  X 4 X 3 X X 2 1 0
         9'b010101000: bk_datapath_o =  36'b000000100000000100000000000000000000; //  X 2 X 1 X 0 X X X
         9'b010101001: bk_datapath_o =  36'b000000110000001000000001000000000000; //  X 3 X 2 X 1 X X 0
         9'b010101010: bk_datapath_o =  36'b000000110000001000000001000000000000; //  X 3 X 2 X 1 X 0 X
         9'b010101011: bk_datapath_o =  36'b000001000000001100000010000000010000; //  X 4 X 3 X 2 X 1 0
         9'b010101100: bk_datapath_o =  36'b000000110000001000000001000000000000; //  X 3 X 2 X 1 0 X X
         9'b010101101: bk_datapath_o =  36'b000001000000001100000010000100000000; //  X 4 X 3 X 2 1 X 0
         9'b010101110: bk_datapath_o =  36'b000001000000001100000010000100000000; //  X 4 X 3 X 2 1 0 X
         9'b010101111: bk_datapath_o =  36'b000001010000010000000011001000010000; //  X 5 X 4 X 3 2 1 0
         9'b010110000: bk_datapath_o =  36'b000000100000000100000000000000000000; //  X 2 X 1 0 X X X X
         9'b010110001: bk_datapath_o =  36'b000000110000001000010000000000000000; //  X 3 X 2 1 X X X 0
         9'b010110010: bk_datapath_o =  36'b000000110000001000010000000000000000; //  X 3 X 2 1 X X 0 X
         9'b010110011: bk_datapath_o =  36'b000001000000001100100000000000010000; //  X 4 X 3 2 X X 1 0
         9'b010110100: bk_datapath_o =  36'b000000110000001000010000000000000000; //  X 3 X 2 1 X 0 X X
         9'b010110101: bk_datapath_o =  36'b000001000000001100100000000100000000; //  X 4 X 3 2 X 1 X 0
         9'b010110110: bk_datapath_o =  36'b000001000000001100100000000100000000; //  X 4 X 3 2 X 1 0 X
         9'b010110111: bk_datapath_o =  36'b000001010000010000110000001000010000; //  X 5 X 4 3 X 2 1 0
         9'b010111000: bk_datapath_o =  36'b000000110000001000010000000000000000; //  X 3 X 2 1 0 X X X
         9'b010111001: bk_datapath_o =  36'b000001000000001100100001000000000000; //  X 4 X 3 2 1 X X 0
         9'b010111010: bk_datapath_o =  36'b000001000000001100100001000000000000; //  X 4 X 3 2 1 X 0 X
         9'b010111011: bk_datapath_o =  36'b000001010000010000110010000000010000; //  X 5 X 4 3 2 X 1 0
         9'b010111100: bk_datapath_o =  36'b000001000000001100100001000000000000; //  X 4 X 3 2 1 0 X X
         9'b010111101: bk_datapath_o =  36'b000001010000010000110010000100000000; //  X 5 X 4 3 2 1 X 0
         9'b010111110: bk_datapath_o =  36'b000001010000010000110010000100000000; //  X 5 X 4 3 2 1 0 X
         9'b010111111: bk_datapath_o =  36'b000001100000010101000011001000010000; //  X 6 X 5 4 3 2 1 0
         9'b011000000: bk_datapath_o =  36'b000000010000000000000000000000000000; //  X 1 0 X X X X X X
         9'b011000001: bk_datapath_o =  36'b000000100001000000000000000000000000; //  X 2 1 X X X X X 0
         9'b011000010: bk_datapath_o =  36'b000000100001000000000000000000000000; //  X 2 1 X X X X 0 X
         9'b011000011: bk_datapath_o =  36'b000000110010000000000000000000010000; //  X 3 2 X X X X 1 0
         9'b011000100: bk_datapath_o =  36'b000000100001000000000000000000000000; //  X 2 1 X X X 0 X X
         9'b011000101: bk_datapath_o =  36'b000000110010000000000000000100000000; //  X 3 2 X X X 1 X 0
         9'b011000110: bk_datapath_o =  36'b000000110010000000000000000100000000; //  X 3 2 X X X 1 0 X
         9'b011000111: bk_datapath_o =  36'b000001000011000000000000001000010000; //  X 4 3 X X X 2 1 0
         9'b011001000: bk_datapath_o =  36'b000000100001000000000000000000000000; //  X 2 1 X X 0 X X X
         9'b011001001: bk_datapath_o =  36'b000000110010000000000001000000000000; //  X 3 2 X X 1 X X 0
         9'b011001010: bk_datapath_o =  36'b000000110010000000000001000000000000; //  X 3 2 X X 1 X 0 X
         9'b011001011: bk_datapath_o =  36'b000001000011000000000010000000010000; //  X 4 3 X X 2 X 1 0
         9'b011001100: bk_datapath_o =  36'b000000110010000000000001000000000000; //  X 3 2 X X 1 0 X X
         9'b011001101: bk_datapath_o =  36'b000001000011000000000010000100000000; //  X 4 3 X X 2 1 X 0
         9'b011001110: bk_datapath_o =  36'b000001000011000000000010000100000000; //  X 4 3 X X 2 1 0 X
         9'b011001111: bk_datapath_o =  36'b000001010100000000000011001000010000; //  X 5 4 X X 3 2 1 0
         9'b011010000: bk_datapath_o =  36'b000000100001000000000000000000000000; //  X 2 1 X 0 X X X X
         9'b011010001: bk_datapath_o =  36'b000000110010000000010000000000000000; //  X 3 2 X 1 X X X 0
         9'b011010010: bk_datapath_o =  36'b000000110010000000010000000000000000; //  X 3 2 X 1 X X 0 X
         9'b011010011: bk_datapath_o =  36'b000001000011000000100000000000010000; //  X 4 3 X 2 X X 1 0
         9'b011010100: bk_datapath_o =  36'b000000110010000000010000000000000000; //  X 3 2 X 1 X 0 X X
         9'b011010101: bk_datapath_o =  36'b000001000011000000100000000100000000; //  X 4 3 X 2 X 1 X 0
         9'b011010110: bk_datapath_o =  36'b000001000011000000100000000100000000; //  X 4 3 X 2 X 1 0 X
         9'b011010111: bk_datapath_o =  36'b000001010100000000110000001000010000; //  X 5 4 X 3 X 2 1 0
         9'b011011000: bk_datapath_o =  36'b000000110010000000010000000000000000; //  X 3 2 X 1 0 X X X
         9'b011011001: bk_datapath_o =  36'b000001000011000000100001000000000000; //  X 4 3 X 2 1 X X 0
         9'b011011010: bk_datapath_o =  36'b000001000011000000100001000000000000; //  X 4 3 X 2 1 X 0 X
         9'b011011011: bk_datapath_o =  36'b000001010100000000110010000000010000; //  X 5 4 X 3 2 X 1 0
         9'b011011100: bk_datapath_o =  36'b000001000011000000100001000000000000; //  X 4 3 X 2 1 0 X X
         9'b011011101: bk_datapath_o =  36'b000001010100000000110010000100000000; //  X 5 4 X 3 2 1 X 0
         9'b011011110: bk_datapath_o =  36'b000001010100000000110010000100000000; //  X 5 4 X 3 2 1 0 X
         9'b011011111: bk_datapath_o =  36'b000001100101000001000011001000010000; //  X 6 5 X 4 3 2 1 0
         9'b011100000: bk_datapath_o =  36'b000000100001000000000000000000000000; //  X 2 1 0 X X X X X
         9'b011100001: bk_datapath_o =  36'b000000110010000100000000000000000000; //  X 3 2 1 X X X X 0
         9'b011100010: bk_datapath_o =  36'b000000110010000100000000000000000000; //  X 3 2 1 X X X 0 X
         9'b011100011: bk_datapath_o =  36'b000001000011001000000000000000010000; //  X 4 3 2 X X X 1 0
         9'b011100100: bk_datapath_o =  36'b000000110010000100000000000000000000; //  X 3 2 1 X X 0 X X
         9'b011100101: bk_datapath_o =  36'b000001000011001000000000000100000000; //  X 4 3 2 X X 1 X 0
         9'b011100110: bk_datapath_o =  36'b000001000011001000000000000100000000; //  X 4 3 2 X X 1 0 X
         9'b011100111: bk_datapath_o =  36'b000001010100001100000000001000010000; //  X 5 4 3 X X 2 1 0
         9'b011101000: bk_datapath_o =  36'b000000110010000100000000000000000000; //  X 3 2 1 X 0 X X X
         9'b011101001: bk_datapath_o =  36'b000001000011001000000001000000000000; //  X 4 3 2 X 1 X X 0
         9'b011101010: bk_datapath_o =  36'b000001000011001000000001000000000000; //  X 4 3 2 X 1 X 0 X
         9'b011101011: bk_datapath_o =  36'b000001010100001100000010000000010000; //  X 5 4 3 X 2 X 1 0
         9'b011101100: bk_datapath_o =  36'b000001000011001000000001000000000000; //  X 4 3 2 X 1 0 X X
         9'b011101101: bk_datapath_o =  36'b000001010100001100000010000100000000; //  X 5 4 3 X 2 1 X 0
         9'b011101110: bk_datapath_o =  36'b000001010100001100000010000100000000; //  X 5 4 3 X 2 1 0 X
         9'b011101111: bk_datapath_o =  36'b000001100101010000000011001000010000; //  X 6 5 4 X 3 2 1 0
         9'b011110000: bk_datapath_o =  36'b000000110010000100000000000000000000; //  X 3 2 1 0 X X X X
         9'b011110001: bk_datapath_o =  36'b000001000011001000010000000000000000; //  X 4 3 2 1 X X X 0
         9'b011110010: bk_datapath_o =  36'b000001000011001000010000000000000000; //  X 4 3 2 1 X X 0 X
         9'b011110011: bk_datapath_o =  36'b000001010100001100100000000000010000; //  X 5 4 3 2 X X 1 0
         9'b011110100: bk_datapath_o =  36'b000001000011001000010000000000000000; //  X 4 3 2 1 X 0 X X
         9'b011110101: bk_datapath_o =  36'b000001010100001100100000000100000000; //  X 5 4 3 2 X 1 X 0
         9'b011110110: bk_datapath_o =  36'b000001010100001100100000000100000000; //  X 5 4 3 2 X 1 0 X
         9'b011110111: bk_datapath_o =  36'b000001100101010000110000001000010000; //  X 6 5 4 3 X 2 1 0
         9'b011111000: bk_datapath_o =  36'b000001000011001000010000000000000000; //  X 4 3 2 1 0 X X X
         9'b011111001: bk_datapath_o =  36'b000001010100001100100001000000000000; //  X 5 4 3 2 1 X X 0
         9'b011111010: bk_datapath_o =  36'b000001010100001100100001000000000000; //  X 5 4 3 2 1 X 0 X
         9'b011111011: bk_datapath_o =  36'b000001100101010000110010000000010000; //  X 6 5 4 3 2 X 1 0
         9'b011111100: bk_datapath_o =  36'b000001010100001100100001000000000000; //  X 5 4 3 2 1 0 X X
         9'b011111101: bk_datapath_o =  36'b000001100101010000110010000100000000; //  X 6 5 4 3 2 1 X 0
         9'b011111110: bk_datapath_o =  36'b000001100101010000110010000100000000; //  X 6 5 4 3 2 1 0 X
         9'b011111111: bk_datapath_o =  36'b000001110110010101000011001000010000; //  X 7 6 5 4 3 2 1 0
         9'b100000000: bk_datapath_o =  36'b000000000000000000000000000000000000; //  0 X X X X X X X X
         9'b100000001: bk_datapath_o =  36'b000100000000000000000000000000000000; //  1 X X X X X X X 0
         9'b100000010: bk_datapath_o =  36'b000100000000000000000000000000000000; //  1 X X X X X X 0 X
         9'b100000011: bk_datapath_o =  36'b001000000000000000000000000000010000; //  2 X X X X X X 1 0
         9'b100000100: bk_datapath_o =  36'b000100000000000000000000000000000000; //  1 X X X X X 0 X X
         9'b100000101: bk_datapath_o =  36'b001000000000000000000000000100000000; //  2 X X X X X 1 X 0
         9'b100000110: bk_datapath_o =  36'b001000000000000000000000000100000000; //  2 X X X X X 1 0 X
         9'b100000111: bk_datapath_o =  36'b001100000000000000000000001000010000; //  3 X X X X X 2 1 0
         9'b100001000: bk_datapath_o =  36'b000100000000000000000000000000000000; //  1 X X X X 0 X X X
         9'b100001001: bk_datapath_o =  36'b001000000000000000000001000000000000; //  2 X X X X 1 X X 0
         9'b100001010: bk_datapath_o =  36'b001000000000000000000001000000000000; //  2 X X X X 1 X 0 X
         9'b100001011: bk_datapath_o =  36'b001100000000000000000010000000010000; //  3 X X X X 2 X 1 0
         9'b100001100: bk_datapath_o =  36'b001000000000000000000001000000000000; //  2 X X X X 1 0 X X
         9'b100001101: bk_datapath_o =  36'b001100000000000000000010000100000000; //  3 X X X X 2 1 X 0
         9'b100001110: bk_datapath_o =  36'b001100000000000000000010000100000000; //  3 X X X X 2 1 0 X
         9'b100001111: bk_datapath_o =  36'b010000000000000000000011001000010000; //  4 X X X X 3 2 1 0
         9'b100010000: bk_datapath_o =  36'b000100000000000000000000000000000000; //  1 X X X 0 X X X X
         9'b100010001: bk_datapath_o =  36'b001000000000000000010000000000000000; //  2 X X X 1 X X X 0
         9'b100010010: bk_datapath_o =  36'b001000000000000000010000000000000000; //  2 X X X 1 X X 0 X
         9'b100010011: bk_datapath_o =  36'b001100000000000000100000000000010000; //  3 X X X 2 X X 1 0
         9'b100010100: bk_datapath_o =  36'b001000000000000000010000000000000000; //  2 X X X 1 X 0 X X
         9'b100010101: bk_datapath_o =  36'b001100000000000000100000000100000000; //  3 X X X 2 X 1 X 0
         9'b100010110: bk_datapath_o =  36'b001100000000000000100000000100000000; //  3 X X X 2 X 1 0 X
         9'b100010111: bk_datapath_o =  36'b010000000000000000110000001000010000; //  4 X X X 3 X 2 1 0
         9'b100011000: bk_datapath_o =  36'b001000000000000000010000000000000000; //  2 X X X 1 0 X X X
         9'b100011001: bk_datapath_o =  36'b001100000000000000100001000000000000; //  3 X X X 2 1 X X 0
         9'b100011010: bk_datapath_o =  36'b001100000000000000100001000000000000; //  3 X X X 2 1 X 0 X
         9'b100011011: bk_datapath_o =  36'b010000000000000000110010000000010000; //  4 X X X 3 2 X 1 0
         9'b100011100: bk_datapath_o =  36'b001100000000000000100001000000000000; //  3 X X X 2 1 0 X X
         9'b100011101: bk_datapath_o =  36'b010000000000000000110010000100000000; //  4 X X X 3 2 1 X 0
         9'b100011110: bk_datapath_o =  36'b010000000000000000110010000100000000; //  4 X X X 3 2 1 0 X
         9'b100011111: bk_datapath_o =  36'b010100000000000001000011001000010000; //  5 X X X 4 3 2 1 0
         9'b100100000: bk_datapath_o =  36'b000100000000000000000000000000000000; //  1 X X 0 X X X X X
         9'b100100001: bk_datapath_o =  36'b001000000000000100000000000000000000; //  2 X X 1 X X X X 0
         9'b100100010: bk_datapath_o =  36'b001000000000000100000000000000000000; //  2 X X 1 X X X 0 X
         9'b100100011: bk_datapath_o =  36'b001100000000001000000000000000010000; //  3 X X 2 X X X 1 0
         9'b100100100: bk_datapath_o =  36'b001000000000000100000000000000000000; //  2 X X 1 X X 0 X X
         9'b100100101: bk_datapath_o =  36'b001100000000001000000000000100000000; //  3 X X 2 X X 1 X 0
         9'b100100110: bk_datapath_o =  36'b001100000000001000000000000100000000; //  3 X X 2 X X 1 0 X
         9'b100100111: bk_datapath_o =  36'b010000000000001100000000001000010000; //  4 X X 3 X X 2 1 0
         9'b100101000: bk_datapath_o =  36'b001000000000000100000000000000000000; //  2 X X 1 X 0 X X X
         9'b100101001: bk_datapath_o =  36'b001100000000001000000001000000000000; //  3 X X 2 X 1 X X 0
         9'b100101010: bk_datapath_o =  36'b001100000000001000000001000000000000; //  3 X X 2 X 1 X 0 X
         9'b100101011: bk_datapath_o =  36'b010000000000001100000010000000010000; //  4 X X 3 X 2 X 1 0
         9'b100101100: bk_datapath_o =  36'b001100000000001000000001000000000000; //  3 X X 2 X 1 0 X X
         9'b100101101: bk_datapath_o =  36'b010000000000001100000010000100000000; //  4 X X 3 X 2 1 X 0
         9'b100101110: bk_datapath_o =  36'b010000000000001100000010000100000000; //  4 X X 3 X 2 1 0 X
         9'b100101111: bk_datapath_o =  36'b010100000000010000000011001000010000; //  5 X X 4 X 3 2 1 0
         9'b100110000: bk_datapath_o =  36'b001000000000000100000000000000000000; //  2 X X 1 0 X X X X
         9'b100110001: bk_datapath_o =  36'b001100000000001000010000000000000000; //  3 X X 2 1 X X X 0
         9'b100110010: bk_datapath_o =  36'b001100000000001000010000000000000000; //  3 X X 2 1 X X 0 X
         9'b100110011: bk_datapath_o =  36'b010000000000001100100000000000010000; //  4 X X 3 2 X X 1 0
         9'b100110100: bk_datapath_o =  36'b001100000000001000010000000000000000; //  3 X X 2 1 X 0 X X
         9'b100110101: bk_datapath_o =  36'b010000000000001100100000000100000000; //  4 X X 3 2 X 1 X 0
         9'b100110110: bk_datapath_o =  36'b010000000000001100100000000100000000; //  4 X X 3 2 X 1 0 X
         9'b100110111: bk_datapath_o =  36'b010100000000010000110000001000010000; //  5 X X 4 3 X 2 1 0
         9'b100111000: bk_datapath_o =  36'b001100000000001000010000000000000000; //  3 X X 2 1 0 X X X
         9'b100111001: bk_datapath_o =  36'b010000000000001100100001000000000000; //  4 X X 3 2 1 X X 0
         9'b100111010: bk_datapath_o =  36'b010000000000001100100001000000000000; //  4 X X 3 2 1 X 0 X
         9'b100111011: bk_datapath_o =  36'b010100000000010000110010000000010000; //  5 X X 4 3 2 X 1 0
         9'b100111100: bk_datapath_o =  36'b010000000000001100100001000000000000; //  4 X X 3 2 1 0 X X
         9'b100111101: bk_datapath_o =  36'b010100000000010000110010000100000000; //  5 X X 4 3 2 1 X 0
         9'b100111110: bk_datapath_o =  36'b010100000000010000110010000100000000; //  5 X X 4 3 2 1 0 X
         9'b100111111: bk_datapath_o =  36'b011000000000010101000011001000010000; //  6 X X 5 4 3 2 1 0
         9'b101000000: bk_datapath_o =  36'b000100000000000000000000000000000000; //  1 X 0 X X X X X X
         9'b101000001: bk_datapath_o =  36'b001000000001000000000000000000000000; //  2 X 1 X X X X X 0
         9'b101000010: bk_datapath_o =  36'b001000000001000000000000000000000000; //  2 X 1 X X X X 0 X
         9'b101000011: bk_datapath_o =  36'b001100000010000000000000000000010000; //  3 X 2 X X X X 1 0
         9'b101000100: bk_datapath_o =  36'b001000000001000000000000000000000000; //  2 X 1 X X X 0 X X
         9'b101000101: bk_datapath_o =  36'b001100000010000000000000000100000000; //  3 X 2 X X X 1 X 0
         9'b101000110: bk_datapath_o =  36'b001100000010000000000000000100000000; //  3 X 2 X X X 1 0 X
         9'b101000111: bk_datapath_o =  36'b010000000011000000000000001000010000; //  4 X 3 X X X 2 1 0
         9'b101001000: bk_datapath_o =  36'b001000000001000000000000000000000000; //  2 X 1 X X 0 X X X
         9'b101001001: bk_datapath_o =  36'b001100000010000000000001000000000000; //  3 X 2 X X 1 X X 0
         9'b101001010: bk_datapath_o =  36'b001100000010000000000001000000000000; //  3 X 2 X X 1 X 0 X
         9'b101001011: bk_datapath_o =  36'b010000000011000000000010000000010000; //  4 X 3 X X 2 X 1 0
         9'b101001100: bk_datapath_o =  36'b001100000010000000000001000000000000; //  3 X 2 X X 1 0 X X
         9'b101001101: bk_datapath_o =  36'b010000000011000000000010000100000000; //  4 X 3 X X 2 1 X 0
         9'b101001110: bk_datapath_o =  36'b010000000011000000000010000100000000; //  4 X 3 X X 2 1 0 X
         9'b101001111: bk_datapath_o =  36'b010100000100000000000011001000010000; //  5 X 4 X X 3 2 1 0
         9'b101010000: bk_datapath_o =  36'b001000000001000000000000000000000000; //  2 X 1 X 0 X X X X
         9'b101010001: bk_datapath_o =  36'b001100000010000000010000000000000000; //  3 X 2 X 1 X X X 0
         9'b101010010: bk_datapath_o =  36'b001100000010000000010000000000000000; //  3 X 2 X 1 X X 0 X
         9'b101010011: bk_datapath_o =  36'b010000000011000000100000000000010000; //  4 X 3 X 2 X X 1 0
         9'b101010100: bk_datapath_o =  36'b001100000010000000010000000000000000; //  3 X 2 X 1 X 0 X X
         9'b101010101: bk_datapath_o =  36'b010000000011000000100000000100000000; //  4 X 3 X 2 X 1 X 0
         9'b101010110: bk_datapath_o =  36'b010000000011000000100000000100000000; //  4 X 3 X 2 X 1 0 X
         9'b101010111: bk_datapath_o =  36'b010100000100000000110000001000010000; //  5 X 4 X 3 X 2 1 0
         9'b101011000: bk_datapath_o =  36'b001100000010000000010000000000000000; //  3 X 2 X 1 0 X X X
         9'b101011001: bk_datapath_o =  36'b010000000011000000100001000000000000; //  4 X 3 X 2 1 X X 0
         9'b101011010: bk_datapath_o =  36'b010000000011000000100001000000000000; //  4 X 3 X 2 1 X 0 X
         9'b101011011: bk_datapath_o =  36'b010100000100000000110010000000010000; //  5 X 4 X 3 2 X 1 0
         9'b101011100: bk_datapath_o =  36'b010000000011000000100001000000000000; //  4 X 3 X 2 1 0 X X
         9'b101011101: bk_datapath_o =  36'b010100000100000000110010000100000000; //  5 X 4 X 3 2 1 X 0
         9'b101011110: bk_datapath_o =  36'b010100000100000000110010000100000000; //  5 X 4 X 3 2 1 0 X
         9'b101011111: bk_datapath_o =  36'b011000000101000001000011001000010000; //  6 X 5 X 4 3 2 1 0
         9'b101100000: bk_datapath_o =  36'b001000000001000000000000000000000000; //  2 X 1 0 X X X X X
         9'b101100001: bk_datapath_o =  36'b001100000010000100000000000000000000; //  3 X 2 1 X X X X 0
         9'b101100010: bk_datapath_o =  36'b001100000010000100000000000000000000; //  3 X 2 1 X X X 0 X
         9'b101100011: bk_datapath_o =  36'b010000000011001000000000000000010000; //  4 X 3 2 X X X 1 0
         9'b101100100: bk_datapath_o =  36'b001100000010000100000000000000000000; //  3 X 2 1 X X 0 X X
         9'b101100101: bk_datapath_o =  36'b010000000011001000000000000100000000; //  4 X 3 2 X X 1 X 0
         9'b101100110: bk_datapath_o =  36'b010000000011001000000000000100000000; //  4 X 3 2 X X 1 0 X
         9'b101100111: bk_datapath_o =  36'b010100000100001100000000001000010000; //  5 X 4 3 X X 2 1 0
         9'b101101000: bk_datapath_o =  36'b001100000010000100000000000000000000; //  3 X 2 1 X 0 X X X
         9'b101101001: bk_datapath_o =  36'b010000000011001000000001000000000000; //  4 X 3 2 X 1 X X 0
         9'b101101010: bk_datapath_o =  36'b010000000011001000000001000000000000; //  4 X 3 2 X 1 X 0 X
         9'b101101011: bk_datapath_o =  36'b010100000100001100000010000000010000; //  5 X 4 3 X 2 X 1 0
         9'b101101100: bk_datapath_o =  36'b010000000011001000000001000000000000; //  4 X 3 2 X 1 0 X X
         9'b101101101: bk_datapath_o =  36'b010100000100001100000010000100000000; //  5 X 4 3 X 2 1 X 0
         9'b101101110: bk_datapath_o =  36'b010100000100001100000010000100000000; //  5 X 4 3 X 2 1 0 X
         9'b101101111: bk_datapath_o =  36'b011000000101010000000011001000010000; //  6 X 5 4 X 3 2 1 0
         9'b101110000: bk_datapath_o =  36'b001100000010000100000000000000000000; //  3 X 2 1 0 X X X X
         9'b101110001: bk_datapath_o =  36'b010000000011001000010000000000000000; //  4 X 3 2 1 X X X 0
         9'b101110010: bk_datapath_o =  36'b010000000011001000010000000000000000; //  4 X 3 2 1 X X 0 X
         9'b101110011: bk_datapath_o =  36'b010100000100001100100000000000010000; //  5 X 4 3 2 X X 1 0
         9'b101110100: bk_datapath_o =  36'b010000000011001000010000000000000000; //  4 X 3 2 1 X 0 X X
         9'b101110101: bk_datapath_o =  36'b010100000100001100100000000100000000; //  5 X 4 3 2 X 1 X 0
         9'b101110110: bk_datapath_o =  36'b010100000100001100100000000100000000; //  5 X 4 3 2 X 1 0 X
         9'b101110111: bk_datapath_o =  36'b011000000101010000110000001000010000; //  6 X 5 4 3 X 2 1 0
         9'b101111000: bk_datapath_o =  36'b010000000011001000010000000000000000; //  4 X 3 2 1 0 X X X
         9'b101111001: bk_datapath_o =  36'b010100000100001100100001000000000000; //  5 X 4 3 2 1 X X 0
         9'b101111010: bk_datapath_o =  36'b010100000100001100100001000000000000; //  5 X 4 3 2 1 X 0 X
         9'b101111011: bk_datapath_o =  36'b011000000101010000110010000000010000; //  6 X 5 4 3 2 X 1 0
         9'b101111100: bk_datapath_o =  36'b010100000100001100100001000000000000; //  5 X 4 3 2 1 0 X X
         9'b101111101: bk_datapath_o =  36'b011000000101010000110010000100000000; //  6 X 5 4 3 2 1 X 0
         9'b101111110: bk_datapath_o =  36'b011000000101010000110010000100000000; //  6 X 5 4 3 2 1 0 X
         9'b101111111: bk_datapath_o =  36'b011100000110010101000011001000010000; //  7 X 6 5 4 3 2 1 0
         9'b110000000: bk_datapath_o =  36'b000100000000000000000000000000000000; //  1 0 X X X X X X X
         9'b110000001: bk_datapath_o =  36'b001000010000000000000000000000000000; //  2 1 X X X X X X 0
         9'b110000010: bk_datapath_o =  36'b001000010000000000000000000000000000; //  2 1 X X X X X 0 X
         9'b110000011: bk_datapath_o =  36'b001100100000000000000000000000010000; //  3 2 X X X X X 1 0
         9'b110000100: bk_datapath_o =  36'b001000010000000000000000000000000000; //  2 1 X X X X 0 X X
         9'b110000101: bk_datapath_o =  36'b001100100000000000000000000100000000; //  3 2 X X X X 1 X 0
         9'b110000110: bk_datapath_o =  36'b001100100000000000000000000100000000; //  3 2 X X X X 1 0 X
         9'b110000111: bk_datapath_o =  36'b010000110000000000000000001000010000; //  4 3 X X X X 2 1 0
         9'b110001000: bk_datapath_o =  36'b001000010000000000000000000000000000; //  2 1 X X X 0 X X X
         9'b110001001: bk_datapath_o =  36'b001100100000000000000001000000000000; //  3 2 X X X 1 X X 0
         9'b110001010: bk_datapath_o =  36'b001100100000000000000001000000000000; //  3 2 X X X 1 X 0 X
         9'b110001011: bk_datapath_o =  36'b010000110000000000000010000000010000; //  4 3 X X X 2 X 1 0
         9'b110001100: bk_datapath_o =  36'b001100100000000000000001000000000000; //  3 2 X X X 1 0 X X
         9'b110001101: bk_datapath_o =  36'b010000110000000000000010000100000000; //  4 3 X X X 2 1 X 0
         9'b110001110: bk_datapath_o =  36'b010000110000000000000010000100000000; //  4 3 X X X 2 1 0 X
         9'b110001111: bk_datapath_o =  36'b010101000000000000000011001000010000; //  5 4 X X X 3 2 1 0
         9'b110010000: bk_datapath_o =  36'b001000010000000000000000000000000000; //  2 1 X X 0 X X X X
         9'b110010001: bk_datapath_o =  36'b001100100000000000010000000000000000; //  3 2 X X 1 X X X 0
         9'b110010010: bk_datapath_o =  36'b001100100000000000010000000000000000; //  3 2 X X 1 X X 0 X
         9'b110010011: bk_datapath_o =  36'b010000110000000000100000000000010000; //  4 3 X X 2 X X 1 0
         9'b110010100: bk_datapath_o =  36'b001100100000000000010000000000000000; //  3 2 X X 1 X 0 X X
         9'b110010101: bk_datapath_o =  36'b010000110000000000100000000100000000; //  4 3 X X 2 X 1 X 0
         9'b110010110: bk_datapath_o =  36'b010000110000000000100000000100000000; //  4 3 X X 2 X 1 0 X
         9'b110010111: bk_datapath_o =  36'b010101000000000000110000001000010000; //  5 4 X X 3 X 2 1 0
         9'b110011000: bk_datapath_o =  36'b001100100000000000010000000000000000; //  3 2 X X 1 0 X X X
         9'b110011001: bk_datapath_o =  36'b010000110000000000100001000000000000; //  4 3 X X 2 1 X X 0
         9'b110011010: bk_datapath_o =  36'b010000110000000000100001000000000000; //  4 3 X X 2 1 X 0 X
         9'b110011011: bk_datapath_o =  36'b010101000000000000110010000000010000; //  5 4 X X 3 2 X 1 0
         9'b110011100: bk_datapath_o =  36'b010000110000000000100001000000000000; //  4 3 X X 2 1 0 X X
         9'b110011101: bk_datapath_o =  36'b010101000000000000110010000100000000; //  5 4 X X 3 2 1 X 0
         9'b110011110: bk_datapath_o =  36'b010101000000000000110010000100000000; //  5 4 X X 3 2 1 0 X
         9'b110011111: bk_datapath_o =  36'b011001010000000001000011001000010000; //  6 5 X X 4 3 2 1 0
         9'b110100000: bk_datapath_o =  36'b001000010000000000000000000000000000; //  2 1 X 0 X X X X X
         9'b110100001: bk_datapath_o =  36'b001100100000000100000000000000000000; //  3 2 X 1 X X X X 0
         9'b110100010: bk_datapath_o =  36'b001100100000000100000000000000000000; //  3 2 X 1 X X X 0 X
         9'b110100011: bk_datapath_o =  36'b010000110000001000000000000000010000; //  4 3 X 2 X X X 1 0
         9'b110100100: bk_datapath_o =  36'b001100100000000100000000000000000000; //  3 2 X 1 X X 0 X X
         9'b110100101: bk_datapath_o =  36'b010000110000001000000000000100000000; //  4 3 X 2 X X 1 X 0
         9'b110100110: bk_datapath_o =  36'b010000110000001000000000000100000000; //  4 3 X 2 X X 1 0 X
         9'b110100111: bk_datapath_o =  36'b010101000000001100000000001000010000; //  5 4 X 3 X X 2 1 0
         9'b110101000: bk_datapath_o =  36'b001100100000000100000000000000000000; //  3 2 X 1 X 0 X X X
         9'b110101001: bk_datapath_o =  36'b010000110000001000000001000000000000; //  4 3 X 2 X 1 X X 0
         9'b110101010: bk_datapath_o =  36'b010000110000001000000001000000000000; //  4 3 X 2 X 1 X 0 X
         9'b110101011: bk_datapath_o =  36'b010101000000001100000010000000010000; //  5 4 X 3 X 2 X 1 0
         9'b110101100: bk_datapath_o =  36'b010000110000001000000001000000000000; //  4 3 X 2 X 1 0 X X
         9'b110101101: bk_datapath_o =  36'b010101000000001100000010000100000000; //  5 4 X 3 X 2 1 X 0
         9'b110101110: bk_datapath_o =  36'b010101000000001100000010000100000000; //  5 4 X 3 X 2 1 0 X
         9'b110101111: bk_datapath_o =  36'b011001010000010000000011001000010000; //  6 5 X 4 X 3 2 1 0
         9'b110110000: bk_datapath_o =  36'b001100100000000100000000000000000000; //  3 2 X 1 0 X X X X
         9'b110110001: bk_datapath_o =  36'b010000110000001000010000000000000000; //  4 3 X 2 1 X X X 0
         9'b110110010: bk_datapath_o =  36'b010000110000001000010000000000000000; //  4 3 X 2 1 X X 0 X
         9'b110110011: bk_datapath_o =  36'b010101000000001100100000000000010000; //  5 4 X 3 2 X X 1 0
         9'b110110100: bk_datapath_o =  36'b010000110000001000010000000000000000; //  4 3 X 2 1 X 0 X X
         9'b110110101: bk_datapath_o =  36'b010101000000001100100000000100000000; //  5 4 X 3 2 X 1 X 0
         9'b110110110: bk_datapath_o =  36'b010101000000001100100000000100000000; //  5 4 X 3 2 X 1 0 X
         9'b110110111: bk_datapath_o =  36'b011001010000010000110000001000010000; //  6 5 X 4 3 X 2 1 0
         9'b110111000: bk_datapath_o =  36'b010000110000001000010000000000000000; //  4 3 X 2 1 0 X X X
         9'b110111001: bk_datapath_o =  36'b010101000000001100100001000000000000; //  5 4 X 3 2 1 X X 0
         9'b110111010: bk_datapath_o =  36'b010101000000001100100001000000000000; //  5 4 X 3 2 1 X 0 X
         9'b110111011: bk_datapath_o =  36'b011001010000010000110010000000010000; //  6 5 X 4 3 2 X 1 0
         9'b110111100: bk_datapath_o =  36'b010101000000001100100001000000000000; //  5 4 X 3 2 1 0 X X
         9'b110111101: bk_datapath_o =  36'b011001010000010000110010000100000000; //  6 5 X 4 3 2 1 X 0
         9'b110111110: bk_datapath_o =  36'b011001010000010000110010000100000000; //  6 5 X 4 3 2 1 0 X
         9'b110111111: bk_datapath_o =  36'b011101100000010101000011001000010000; //  7 6 X 5 4 3 2 1 0
         9'b111000000: bk_datapath_o =  36'b001000010000000000000000000000000000; //  2 1 0 X X X X X X
         9'b111000001: bk_datapath_o =  36'b001100100001000000000000000000000000; //  3 2 1 X X X X X 0
         9'b111000010: bk_datapath_o =  36'b001100100001000000000000000000000000; //  3 2 1 X X X X 0 X
         9'b111000011: bk_datapath_o =  36'b010000110010000000000000000000010000; //  4 3 2 X X X X 1 0
         9'b111000100: bk_datapath_o =  36'b001100100001000000000000000000000000; //  3 2 1 X X X 0 X X
         9'b111000101: bk_datapath_o =  36'b010000110010000000000000000100000000; //  4 3 2 X X X 1 X 0
         9'b111000110: bk_datapath_o =  36'b010000110010000000000000000100000000; //  4 3 2 X X X 1 0 X
         9'b111000111: bk_datapath_o =  36'b010101000011000000000000001000010000; //  5 4 3 X X X 2 1 0
         9'b111001000: bk_datapath_o =  36'b001100100001000000000000000000000000; //  3 2 1 X X 0 X X X
         9'b111001001: bk_datapath_o =  36'b010000110010000000000001000000000000; //  4 3 2 X X 1 X X 0
         9'b111001010: bk_datapath_o =  36'b010000110010000000000001000000000000; //  4 3 2 X X 1 X 0 X
         9'b111001011: bk_datapath_o =  36'b010101000011000000000010000000010000; //  5 4 3 X X 2 X 1 0
         9'b111001100: bk_datapath_o =  36'b010000110010000000000001000000000000; //  4 3 2 X X 1 0 X X
         9'b111001101: bk_datapath_o =  36'b010101000011000000000010000100000000; //  5 4 3 X X 2 1 X 0
         9'b111001110: bk_datapath_o =  36'b010101000011000000000010000100000000; //  5 4 3 X X 2 1 0 X
         9'b111001111: bk_datapath_o =  36'b011001010100000000000011001000010000; //  6 5 4 X X 3 2 1 0
         9'b111010000: bk_datapath_o =  36'b001100100001000000000000000000000000; //  3 2 1 X 0 X X X X
         9'b111010001: bk_datapath_o =  36'b010000110010000000010000000000000000; //  4 3 2 X 1 X X X 0
         9'b111010010: bk_datapath_o =  36'b010000110010000000010000000000000000; //  4 3 2 X 1 X X 0 X
         9'b111010011: bk_datapath_o =  36'b010101000011000000100000000000010000; //  5 4 3 X 2 X X 1 0
         9'b111010100: bk_datapath_o =  36'b010000110010000000010000000000000000; //  4 3 2 X 1 X 0 X X
         9'b111010101: bk_datapath_o =  36'b010101000011000000100000000100000000; //  5 4 3 X 2 X 1 X 0
         9'b111010110: bk_datapath_o =  36'b010101000011000000100000000100000000; //  5 4 3 X 2 X 1 0 X
         9'b111010111: bk_datapath_o =  36'b011001010100000000110000001000010000; //  6 5 4 X 3 X 2 1 0
         9'b111011000: bk_datapath_o =  36'b010000110010000000010000000000000000; //  4 3 2 X 1 0 X X X
         9'b111011001: bk_datapath_o =  36'b010101000011000000100001000000000000; //  5 4 3 X 2 1 X X 0
         9'b111011010: bk_datapath_o =  36'b010101000011000000100001000000000000; //  5 4 3 X 2 1 X 0 X
         9'b111011011: bk_datapath_o =  36'b011001010100000000110010000000010000; //  6 5 4 X 3 2 X 1 0
         9'b111011100: bk_datapath_o =  36'b010101000011000000100001000000000000; //  5 4 3 X 2 1 0 X X
         9'b111011101: bk_datapath_o =  36'b011001010100000000110010000100000000; //  6 5 4 X 3 2 1 X 0
         9'b111011110: bk_datapath_o =  36'b011001010100000000110010000100000000; //  6 5 4 X 3 2 1 0 X
         9'b111011111: bk_datapath_o =  36'b011101100101000001000011001000010000; //  7 6 5 X 4 3 2 1 0
         9'b111100000: bk_datapath_o =  36'b001100100001000000000000000000000000; //  3 2 1 0 X X X X X
         9'b111100001: bk_datapath_o =  36'b010000110010000100000000000000000000; //  4 3 2 1 X X X X 0
         9'b111100010: bk_datapath_o =  36'b010000110010000100000000000000000000; //  4 3 2 1 X X X 0 X
         9'b111100011: bk_datapath_o =  36'b010101000011001000000000000000010000; //  5 4 3 2 X X X 1 0
         9'b111100100: bk_datapath_o =  36'b010000110010000100000000000000000000; //  4 3 2 1 X X 0 X X
         9'b111100101: bk_datapath_o =  36'b010101000011001000000000000100000000; //  5 4 3 2 X X 1 X 0
         9'b111100110: bk_datapath_o =  36'b010101000011001000000000000100000000; //  5 4 3 2 X X 1 0 X
         9'b111100111: bk_datapath_o =  36'b011001010100001100000000001000010000; //  6 5 4 3 X X 2 1 0
         9'b111101000: bk_datapath_o =  36'b010000110010000100000000000000000000; //  4 3 2 1 X 0 X X X
         9'b111101001: bk_datapath_o =  36'b010101000011001000000001000000000000; //  5 4 3 2 X 1 X X 0
         9'b111101010: bk_datapath_o =  36'b010101000011001000000001000000000000; //  5 4 3 2 X 1 X 0 X
         9'b111101011: bk_datapath_o =  36'b011001010100001100000010000000010000; //  6 5 4 3 X 2 X 1 0
         9'b111101100: bk_datapath_o =  36'b010101000011001000000001000000000000; //  5 4 3 2 X 1 0 X X
         9'b111101101: bk_datapath_o =  36'b011001010100001100000010000100000000; //  6 5 4 3 X 2 1 X 0
         9'b111101110: bk_datapath_o =  36'b011001010100001100000010000100000000; //  6 5 4 3 X 2 1 0 X
         9'b111101111: bk_datapath_o =  36'b011101100101010000000011001000010000; //  7 6 5 4 X 3 2 1 0
         9'b111110000: bk_datapath_o =  36'b010000110010000100000000000000000000; //  4 3 2 1 0 X X X X
         9'b111110001: bk_datapath_o =  36'b010101000011001000010000000000000000; //  5 4 3 2 1 X X X 0
         9'b111110010: bk_datapath_o =  36'b010101000011001000010000000000000000; //  5 4 3 2 1 X X 0 X
         9'b111110011: bk_datapath_o =  36'b011001010100001100100000000000010000; //  6 5 4 3 2 X X 1 0
         9'b111110100: bk_datapath_o =  36'b010101000011001000010000000000000000; //  5 4 3 2 1 X 0 X X
         9'b111110101: bk_datapath_o =  36'b011001010100001100100000000100000000; //  6 5 4 3 2 X 1 X 0
         9'b111110110: bk_datapath_o =  36'b011001010100001100100000000100000000; //  6 5 4 3 2 X 1 0 X
         9'b111110111: bk_datapath_o =  36'b011101100101010000110000001000010000; //  7 6 5 4 3 X 2 1 0
         9'b111111000: bk_datapath_o =  36'b010101000011001000010000000000000000; //  5 4 3 2 1 0 X X X
         9'b111111001: bk_datapath_o =  36'b011001010100001100100001000000000000; //  6 5 4 3 2 1 X X 0
         9'b111111010: bk_datapath_o =  36'b011001010100001100100001000000000000; //  6 5 4 3 2 1 X 0 X
         9'b111111011: bk_datapath_o =  36'b011101100101010000110010000000010000; //  7 6 5 4 3 2 X 1 0
         9'b111111100: bk_datapath_o =  36'b011001010100001100100001000000000000; //  6 5 4 3 2 1 0 X X
         9'b111111101: bk_datapath_o =  36'b011101100101010000110010000100000000; //  7 6 5 4 3 2 1 X 0
         9'b111111110: bk_datapath_o =  36'b011101100101010000110010000100000000; //  7 6 5 4 3 2 1 0 X
         9'b111111111: bk_datapath_o =  36'b100001110110010101000011001000010000; //  8 7 6 5 4 3 2 1 0
        default: bk_datapath_o= 'X;
    endcase

    // fwd vec
    always_comb
    unique case (vec_i) 
         9'b000000000: fwd_o =  36'b100010001000100010001000100010001000; //  X X X X X X X X X
         9'b000000001: fwd_o =  36'b100010001000100010001000100010000000; //  X X X X X X X X 0
         9'b000000010: fwd_o =  36'b100010001000100010001000100010000001; //  X X X X X X X X 1
         9'b000000011: fwd_o =  36'b100010001000100010001000100000010000; //  X X X X X X X 1 0
         9'b000000100: fwd_o =  36'b100010001000100010001000100010000010; //  X X X X X X X X 2
         9'b000000101: fwd_o =  36'b100010001000100010001000100000100000; //  X X X X X X X 2 0
         9'b000000110: fwd_o =  36'b100010001000100010001000100000100001; //  X X X X X X X 2 1
         9'b000000111: fwd_o =  36'b100010001000100010001000001000010000; //  X X X X X X 2 1 0
         9'b000001000: fwd_o =  36'b100010001000100010001000100010000011; //  X X X X X X X X 3
         9'b000001001: fwd_o =  36'b100010001000100010001000100000110000; //  X X X X X X X 3 0
         9'b000001010: fwd_o =  36'b100010001000100010001000100000110001; //  X X X X X X X 3 1
         9'b000001011: fwd_o =  36'b100010001000100010001000001100010000; //  X X X X X X 3 1 0
         9'b000001100: fwd_o =  36'b100010001000100010001000100000110010; //  X X X X X X X 3 2
         9'b000001101: fwd_o =  36'b100010001000100010001000001100100000; //  X X X X X X 3 2 0
         9'b000001110: fwd_o =  36'b100010001000100010001000001100100001; //  X X X X X X 3 2 1
         9'b000001111: fwd_o =  36'b100010001000100010000011001000010000; //  X X X X X 3 2 1 0
         9'b000010000: fwd_o =  36'b100010001000100010001000100010000100; //  X X X X X X X X 4
         9'b000010001: fwd_o =  36'b100010001000100010001000100001000000; //  X X X X X X X 4 0
         9'b000010010: fwd_o =  36'b100010001000100010001000100001000001; //  X X X X X X X 4 1
         9'b000010011: fwd_o =  36'b100010001000100010001000010000010000; //  X X X X X X 4 1 0
         9'b000010100: fwd_o =  36'b100010001000100010001000100001000010; //  X X X X X X X 4 2
         9'b000010101: fwd_o =  36'b100010001000100010001000010000100000; //  X X X X X X 4 2 0
         9'b000010110: fwd_o =  36'b100010001000100010001000010000100001; //  X X X X X X 4 2 1
         9'b000010111: fwd_o =  36'b100010001000100010000100001000010000; //  X X X X X 4 2 1 0
         9'b000011000: fwd_o =  36'b100010001000100010001000100001000011; //  X X X X X X X 4 3
         9'b000011001: fwd_o =  36'b100010001000100010001000010000110000; //  X X X X X X 4 3 0
         9'b000011010: fwd_o =  36'b100010001000100010001000010000110001; //  X X X X X X 4 3 1
         9'b000011011: fwd_o =  36'b100010001000100010000100001100010000; //  X X X X X 4 3 1 0
         9'b000011100: fwd_o =  36'b100010001000100010001000010000110010; //  X X X X X X 4 3 2
         9'b000011101: fwd_o =  36'b100010001000100010000100001100100000; //  X X X X X 4 3 2 0
         9'b000011110: fwd_o =  36'b100010001000100010000100001100100001; //  X X X X X 4 3 2 1
         9'b000011111: fwd_o =  36'b100010001000100001000011001000010000; //  X X X X 4 3 2 1 0
         9'b000100000: fwd_o =  36'b100010001000100010001000100010000101; //  X X X X X X X X 5
         9'b000100001: fwd_o =  36'b100010001000100010001000100001010000; //  X X X X X X X 5 0
         9'b000100010: fwd_o =  36'b100010001000100010001000100001010001; //  X X X X X X X 5 1
         9'b000100011: fwd_o =  36'b100010001000100010001000010100010000; //  X X X X X X 5 1 0
         9'b000100100: fwd_o =  36'b100010001000100010001000100001010010; //  X X X X X X X 5 2
         9'b000100101: fwd_o =  36'b100010001000100010001000010100100000; //  X X X X X X 5 2 0
         9'b000100110: fwd_o =  36'b100010001000100010001000010100100001; //  X X X X X X 5 2 1
         9'b000100111: fwd_o =  36'b100010001000100010000101001000010000; //  X X X X X 5 2 1 0
         9'b000101000: fwd_o =  36'b100010001000100010001000100001010011; //  X X X X X X X 5 3
         9'b000101001: fwd_o =  36'b100010001000100010001000010100110000; //  X X X X X X 5 3 0
         9'b000101010: fwd_o =  36'b100010001000100010001000010100110001; //  X X X X X X 5 3 1
         9'b000101011: fwd_o =  36'b100010001000100010000101001100010000; //  X X X X X 5 3 1 0
         9'b000101100: fwd_o =  36'b100010001000100010001000010100110010; //  X X X X X X 5 3 2
         9'b000101101: fwd_o =  36'b100010001000100010000101001100100000; //  X X X X X 5 3 2 0
         9'b000101110: fwd_o =  36'b100010001000100010000101001100100001; //  X X X X X 5 3 2 1
         9'b000101111: fwd_o =  36'b100010001000100001010011001000010000; //  X X X X 5 3 2 1 0
         9'b000110000: fwd_o =  36'b100010001000100010001000100001010100; //  X X X X X X X 5 4
         9'b000110001: fwd_o =  36'b100010001000100010001000010101000000; //  X X X X X X 5 4 0
         9'b000110010: fwd_o =  36'b100010001000100010001000010101000001; //  X X X X X X 5 4 1
         9'b000110011: fwd_o =  36'b100010001000100010000101010000010000; //  X X X X X 5 4 1 0
         9'b000110100: fwd_o =  36'b100010001000100010001000010101000010; //  X X X X X X 5 4 2
         9'b000110101: fwd_o =  36'b100010001000100010000101010000100000; //  X X X X X 5 4 2 0
         9'b000110110: fwd_o =  36'b100010001000100010000101010000100001; //  X X X X X 5 4 2 1
         9'b000110111: fwd_o =  36'b100010001000100001010100001000010000; //  X X X X 5 4 2 1 0
         9'b000111000: fwd_o =  36'b100010001000100010001000010101000011; //  X X X X X X 5 4 3
         9'b000111001: fwd_o =  36'b100010001000100010000101010000110000; //  X X X X X 5 4 3 0
         9'b000111010: fwd_o =  36'b100010001000100010000101010000110001; //  X X X X X 5 4 3 1
         9'b000111011: fwd_o =  36'b100010001000100001010100001100010000; //  X X X X 5 4 3 1 0
         9'b000111100: fwd_o =  36'b100010001000100010000101010000110010; //  X X X X X 5 4 3 2
         9'b000111101: fwd_o =  36'b100010001000100001010100001100100000; //  X X X X 5 4 3 2 0
         9'b000111110: fwd_o =  36'b100010001000100001010100001100100001; //  X X X X 5 4 3 2 1
         9'b000111111: fwd_o =  36'b100010001000010101000011001000010000; //  X X X 5 4 3 2 1 0
         9'b001000000: fwd_o =  36'b100010001000100010001000100010000110; //  X X X X X X X X 6
         9'b001000001: fwd_o =  36'b100010001000100010001000100001100000; //  X X X X X X X 6 0
         9'b001000010: fwd_o =  36'b100010001000100010001000100001100001; //  X X X X X X X 6 1
         9'b001000011: fwd_o =  36'b100010001000100010001000011000010000; //  X X X X X X 6 1 0
         9'b001000100: fwd_o =  36'b100010001000100010001000100001100010; //  X X X X X X X 6 2
         9'b001000101: fwd_o =  36'b100010001000100010001000011000100000; //  X X X X X X 6 2 0
         9'b001000110: fwd_o =  36'b100010001000100010001000011000100001; //  X X X X X X 6 2 1
         9'b001000111: fwd_o =  36'b100010001000100010000110001000010000; //  X X X X X 6 2 1 0
         9'b001001000: fwd_o =  36'b100010001000100010001000100001100011; //  X X X X X X X 6 3
         9'b001001001: fwd_o =  36'b100010001000100010001000011000110000; //  X X X X X X 6 3 0
         9'b001001010: fwd_o =  36'b100010001000100010001000011000110001; //  X X X X X X 6 3 1
         9'b001001011: fwd_o =  36'b100010001000100010000110001100010000; //  X X X X X 6 3 1 0
         9'b001001100: fwd_o =  36'b100010001000100010001000011000110010; //  X X X X X X 6 3 2
         9'b001001101: fwd_o =  36'b100010001000100010000110001100100000; //  X X X X X 6 3 2 0
         9'b001001110: fwd_o =  36'b100010001000100010000110001100100001; //  X X X X X 6 3 2 1
         9'b001001111: fwd_o =  36'b100010001000100001100011001000010000; //  X X X X 6 3 2 1 0
         9'b001010000: fwd_o =  36'b100010001000100010001000100001100100; //  X X X X X X X 6 4
         9'b001010001: fwd_o =  36'b100010001000100010001000011001000000; //  X X X X X X 6 4 0
         9'b001010010: fwd_o =  36'b100010001000100010001000011001000001; //  X X X X X X 6 4 1
         9'b001010011: fwd_o =  36'b100010001000100010000110010000010000; //  X X X X X 6 4 1 0
         9'b001010100: fwd_o =  36'b100010001000100010001000011001000010; //  X X X X X X 6 4 2
         9'b001010101: fwd_o =  36'b100010001000100010000110010000100000; //  X X X X X 6 4 2 0
         9'b001010110: fwd_o =  36'b100010001000100010000110010000100001; //  X X X X X 6 4 2 1
         9'b001010111: fwd_o =  36'b100010001000100001100100001000010000; //  X X X X 6 4 2 1 0
         9'b001011000: fwd_o =  36'b100010001000100010001000011001000011; //  X X X X X X 6 4 3
         9'b001011001: fwd_o =  36'b100010001000100010000110010000110000; //  X X X X X 6 4 3 0
         9'b001011010: fwd_o =  36'b100010001000100010000110010000110001; //  X X X X X 6 4 3 1
         9'b001011011: fwd_o =  36'b100010001000100001100100001100010000; //  X X X X 6 4 3 1 0
         9'b001011100: fwd_o =  36'b100010001000100010000110010000110010; //  X X X X X 6 4 3 2
         9'b001011101: fwd_o =  36'b100010001000100001100100001100100000; //  X X X X 6 4 3 2 0
         9'b001011110: fwd_o =  36'b100010001000100001100100001100100001; //  X X X X 6 4 3 2 1
         9'b001011111: fwd_o =  36'b100010001000011001000011001000010000; //  X X X 6 4 3 2 1 0
         9'b001100000: fwd_o =  36'b100010001000100010001000100001100101; //  X X X X X X X 6 5
         9'b001100001: fwd_o =  36'b100010001000100010001000011001010000; //  X X X X X X 6 5 0
         9'b001100010: fwd_o =  36'b100010001000100010001000011001010001; //  X X X X X X 6 5 1
         9'b001100011: fwd_o =  36'b100010001000100010000110010100010000; //  X X X X X 6 5 1 0
         9'b001100100: fwd_o =  36'b100010001000100010001000011001010010; //  X X X X X X 6 5 2
         9'b001100101: fwd_o =  36'b100010001000100010000110010100100000; //  X X X X X 6 5 2 0
         9'b001100110: fwd_o =  36'b100010001000100010000110010100100001; //  X X X X X 6 5 2 1
         9'b001100111: fwd_o =  36'b100010001000100001100101001000010000; //  X X X X 6 5 2 1 0
         9'b001101000: fwd_o =  36'b100010001000100010001000011001010011; //  X X X X X X 6 5 3
         9'b001101001: fwd_o =  36'b100010001000100010000110010100110000; //  X X X X X 6 5 3 0
         9'b001101010: fwd_o =  36'b100010001000100010000110010100110001; //  X X X X X 6 5 3 1
         9'b001101011: fwd_o =  36'b100010001000100001100101001100010000; //  X X X X 6 5 3 1 0
         9'b001101100: fwd_o =  36'b100010001000100010000110010100110010; //  X X X X X 6 5 3 2
         9'b001101101: fwd_o =  36'b100010001000100001100101001100100000; //  X X X X 6 5 3 2 0
         9'b001101110: fwd_o =  36'b100010001000100001100101001100100001; //  X X X X 6 5 3 2 1
         9'b001101111: fwd_o =  36'b100010001000011001010011001000010000; //  X X X 6 5 3 2 1 0
         9'b001110000: fwd_o =  36'b100010001000100010001000011001010100; //  X X X X X X 6 5 4
         9'b001110001: fwd_o =  36'b100010001000100010000110010101000000; //  X X X X X 6 5 4 0
         9'b001110010: fwd_o =  36'b100010001000100010000110010101000001; //  X X X X X 6 5 4 1
         9'b001110011: fwd_o =  36'b100010001000100001100101010000010000; //  X X X X 6 5 4 1 0
         9'b001110100: fwd_o =  36'b100010001000100010000110010101000010; //  X X X X X 6 5 4 2
         9'b001110101: fwd_o =  36'b100010001000100001100101010000100000; //  X X X X 6 5 4 2 0
         9'b001110110: fwd_o =  36'b100010001000100001100101010000100001; //  X X X X 6 5 4 2 1
         9'b001110111: fwd_o =  36'b100010001000011001010100001000010000; //  X X X 6 5 4 2 1 0
         9'b001111000: fwd_o =  36'b100010001000100010000110010101000011; //  X X X X X 6 5 4 3
         9'b001111001: fwd_o =  36'b100010001000100001100101010000110000; //  X X X X 6 5 4 3 0
         9'b001111010: fwd_o =  36'b100010001000100001100101010000110001; //  X X X X 6 5 4 3 1
         9'b001111011: fwd_o =  36'b100010001000011001010100001100010000; //  X X X 6 5 4 3 1 0
         9'b001111100: fwd_o =  36'b100010001000100001100101010000110010; //  X X X X 6 5 4 3 2
         9'b001111101: fwd_o =  36'b100010001000011001010100001100100000; //  X X X 6 5 4 3 2 0
         9'b001111110: fwd_o =  36'b100010001000011001010100001100100001; //  X X X 6 5 4 3 2 1
         9'b001111111: fwd_o =  36'b100010000110010101000011001000010000; //  X X 6 5 4 3 2 1 0
         9'b010000000: fwd_o =  36'b100010001000100010001000100010000111; //  X X X X X X X X 7
         9'b010000001: fwd_o =  36'b100010001000100010001000100001110000; //  X X X X X X X 7 0
         9'b010000010: fwd_o =  36'b100010001000100010001000100001110001; //  X X X X X X X 7 1
         9'b010000011: fwd_o =  36'b100010001000100010001000011100010000; //  X X X X X X 7 1 0
         9'b010000100: fwd_o =  36'b100010001000100010001000100001110010; //  X X X X X X X 7 2
         9'b010000101: fwd_o =  36'b100010001000100010001000011100100000; //  X X X X X X 7 2 0
         9'b010000110: fwd_o =  36'b100010001000100010001000011100100001; //  X X X X X X 7 2 1
         9'b010000111: fwd_o =  36'b100010001000100010000111001000010000; //  X X X X X 7 2 1 0
         9'b010001000: fwd_o =  36'b100010001000100010001000100001110011; //  X X X X X X X 7 3
         9'b010001001: fwd_o =  36'b100010001000100010001000011100110000; //  X X X X X X 7 3 0
         9'b010001010: fwd_o =  36'b100010001000100010001000011100110001; //  X X X X X X 7 3 1
         9'b010001011: fwd_o =  36'b100010001000100010000111001100010000; //  X X X X X 7 3 1 0
         9'b010001100: fwd_o =  36'b100010001000100010001000011100110010; //  X X X X X X 7 3 2
         9'b010001101: fwd_o =  36'b100010001000100010000111001100100000; //  X X X X X 7 3 2 0
         9'b010001110: fwd_o =  36'b100010001000100010000111001100100001; //  X X X X X 7 3 2 1
         9'b010001111: fwd_o =  36'b100010001000100001110011001000010000; //  X X X X 7 3 2 1 0
         9'b010010000: fwd_o =  36'b100010001000100010001000100001110100; //  X X X X X X X 7 4
         9'b010010001: fwd_o =  36'b100010001000100010001000011101000000; //  X X X X X X 7 4 0
         9'b010010010: fwd_o =  36'b100010001000100010001000011101000001; //  X X X X X X 7 4 1
         9'b010010011: fwd_o =  36'b100010001000100010000111010000010000; //  X X X X X 7 4 1 0
         9'b010010100: fwd_o =  36'b100010001000100010001000011101000010; //  X X X X X X 7 4 2
         9'b010010101: fwd_o =  36'b100010001000100010000111010000100000; //  X X X X X 7 4 2 0
         9'b010010110: fwd_o =  36'b100010001000100010000111010000100001; //  X X X X X 7 4 2 1
         9'b010010111: fwd_o =  36'b100010001000100001110100001000010000; //  X X X X 7 4 2 1 0
         9'b010011000: fwd_o =  36'b100010001000100010001000011101000011; //  X X X X X X 7 4 3
         9'b010011001: fwd_o =  36'b100010001000100010000111010000110000; //  X X X X X 7 4 3 0
         9'b010011010: fwd_o =  36'b100010001000100010000111010000110001; //  X X X X X 7 4 3 1
         9'b010011011: fwd_o =  36'b100010001000100001110100001100010000; //  X X X X 7 4 3 1 0
         9'b010011100: fwd_o =  36'b100010001000100010000111010000110010; //  X X X X X 7 4 3 2
         9'b010011101: fwd_o =  36'b100010001000100001110100001100100000; //  X X X X 7 4 3 2 0
         9'b010011110: fwd_o =  36'b100010001000100001110100001100100001; //  X X X X 7 4 3 2 1
         9'b010011111: fwd_o =  36'b100010001000011101000011001000010000; //  X X X 7 4 3 2 1 0
         9'b010100000: fwd_o =  36'b100010001000100010001000100001110101; //  X X X X X X X 7 5
         9'b010100001: fwd_o =  36'b100010001000100010001000011101010000; //  X X X X X X 7 5 0
         9'b010100010: fwd_o =  36'b100010001000100010001000011101010001; //  X X X X X X 7 5 1
         9'b010100011: fwd_o =  36'b100010001000100010000111010100010000; //  X X X X X 7 5 1 0
         9'b010100100: fwd_o =  36'b100010001000100010001000011101010010; //  X X X X X X 7 5 2
         9'b010100101: fwd_o =  36'b100010001000100010000111010100100000; //  X X X X X 7 5 2 0
         9'b010100110: fwd_o =  36'b100010001000100010000111010100100001; //  X X X X X 7 5 2 1
         9'b010100111: fwd_o =  36'b100010001000100001110101001000010000; //  X X X X 7 5 2 1 0
         9'b010101000: fwd_o =  36'b100010001000100010001000011101010011; //  X X X X X X 7 5 3
         9'b010101001: fwd_o =  36'b100010001000100010000111010100110000; //  X X X X X 7 5 3 0
         9'b010101010: fwd_o =  36'b100010001000100010000111010100110001; //  X X X X X 7 5 3 1
         9'b010101011: fwd_o =  36'b100010001000100001110101001100010000; //  X X X X 7 5 3 1 0
         9'b010101100: fwd_o =  36'b100010001000100010000111010100110010; //  X X X X X 7 5 3 2
         9'b010101101: fwd_o =  36'b100010001000100001110101001100100000; //  X X X X 7 5 3 2 0
         9'b010101110: fwd_o =  36'b100010001000100001110101001100100001; //  X X X X 7 5 3 2 1
         9'b010101111: fwd_o =  36'b100010001000011101010011001000010000; //  X X X 7 5 3 2 1 0
         9'b010110000: fwd_o =  36'b100010001000100010001000011101010100; //  X X X X X X 7 5 4
         9'b010110001: fwd_o =  36'b100010001000100010000111010101000000; //  X X X X X 7 5 4 0
         9'b010110010: fwd_o =  36'b100010001000100010000111010101000001; //  X X X X X 7 5 4 1
         9'b010110011: fwd_o =  36'b100010001000100001110101010000010000; //  X X X X 7 5 4 1 0
         9'b010110100: fwd_o =  36'b100010001000100010000111010101000010; //  X X X X X 7 5 4 2
         9'b010110101: fwd_o =  36'b100010001000100001110101010000100000; //  X X X X 7 5 4 2 0
         9'b010110110: fwd_o =  36'b100010001000100001110101010000100001; //  X X X X 7 5 4 2 1
         9'b010110111: fwd_o =  36'b100010001000011101010100001000010000; //  X X X 7 5 4 2 1 0
         9'b010111000: fwd_o =  36'b100010001000100010000111010101000011; //  X X X X X 7 5 4 3
         9'b010111001: fwd_o =  36'b100010001000100001110101010000110000; //  X X X X 7 5 4 3 0
         9'b010111010: fwd_o =  36'b100010001000100001110101010000110001; //  X X X X 7 5 4 3 1
         9'b010111011: fwd_o =  36'b100010001000011101010100001100010000; //  X X X 7 5 4 3 1 0
         9'b010111100: fwd_o =  36'b100010001000100001110101010000110010; //  X X X X 7 5 4 3 2
         9'b010111101: fwd_o =  36'b100010001000011101010100001100100000; //  X X X 7 5 4 3 2 0
         9'b010111110: fwd_o =  36'b100010001000011101010100001100100001; //  X X X 7 5 4 3 2 1
         9'b010111111: fwd_o =  36'b100010000111010101000011001000010000; //  X X 7 5 4 3 2 1 0
         9'b011000000: fwd_o =  36'b100010001000100010001000100001110110; //  X X X X X X X 7 6
         9'b011000001: fwd_o =  36'b100010001000100010001000011101100000; //  X X X X X X 7 6 0
         9'b011000010: fwd_o =  36'b100010001000100010001000011101100001; //  X X X X X X 7 6 1
         9'b011000011: fwd_o =  36'b100010001000100010000111011000010000; //  X X X X X 7 6 1 0
         9'b011000100: fwd_o =  36'b100010001000100010001000011101100010; //  X X X X X X 7 6 2
         9'b011000101: fwd_o =  36'b100010001000100010000111011000100000; //  X X X X X 7 6 2 0
         9'b011000110: fwd_o =  36'b100010001000100010000111011000100001; //  X X X X X 7 6 2 1
         9'b011000111: fwd_o =  36'b100010001000100001110110001000010000; //  X X X X 7 6 2 1 0
         9'b011001000: fwd_o =  36'b100010001000100010001000011101100011; //  X X X X X X 7 6 3
         9'b011001001: fwd_o =  36'b100010001000100010000111011000110000; //  X X X X X 7 6 3 0
         9'b011001010: fwd_o =  36'b100010001000100010000111011000110001; //  X X X X X 7 6 3 1
         9'b011001011: fwd_o =  36'b100010001000100001110110001100010000; //  X X X X 7 6 3 1 0
         9'b011001100: fwd_o =  36'b100010001000100010000111011000110010; //  X X X X X 7 6 3 2
         9'b011001101: fwd_o =  36'b100010001000100001110110001100100000; //  X X X X 7 6 3 2 0
         9'b011001110: fwd_o =  36'b100010001000100001110110001100100001; //  X X X X 7 6 3 2 1
         9'b011001111: fwd_o =  36'b100010001000011101100011001000010000; //  X X X 7 6 3 2 1 0
         9'b011010000: fwd_o =  36'b100010001000100010001000011101100100; //  X X X X X X 7 6 4
         9'b011010001: fwd_o =  36'b100010001000100010000111011001000000; //  X X X X X 7 6 4 0
         9'b011010010: fwd_o =  36'b100010001000100010000111011001000001; //  X X X X X 7 6 4 1
         9'b011010011: fwd_o =  36'b100010001000100001110110010000010000; //  X X X X 7 6 4 1 0
         9'b011010100: fwd_o =  36'b100010001000100010000111011001000010; //  X X X X X 7 6 4 2
         9'b011010101: fwd_o =  36'b100010001000100001110110010000100000; //  X X X X 7 6 4 2 0
         9'b011010110: fwd_o =  36'b100010001000100001110110010000100001; //  X X X X 7 6 4 2 1
         9'b011010111: fwd_o =  36'b100010001000011101100100001000010000; //  X X X 7 6 4 2 1 0
         9'b011011000: fwd_o =  36'b100010001000100010000111011001000011; //  X X X X X 7 6 4 3
         9'b011011001: fwd_o =  36'b100010001000100001110110010000110000; //  X X X X 7 6 4 3 0
         9'b011011010: fwd_o =  36'b100010001000100001110110010000110001; //  X X X X 7 6 4 3 1
         9'b011011011: fwd_o =  36'b100010001000011101100100001100010000; //  X X X 7 6 4 3 1 0
         9'b011011100: fwd_o =  36'b100010001000100001110110010000110010; //  X X X X 7 6 4 3 2
         9'b011011101: fwd_o =  36'b100010001000011101100100001100100000; //  X X X 7 6 4 3 2 0
         9'b011011110: fwd_o =  36'b100010001000011101100100001100100001; //  X X X 7 6 4 3 2 1
         9'b011011111: fwd_o =  36'b100010000111011001000011001000010000; //  X X 7 6 4 3 2 1 0
         9'b011100000: fwd_o =  36'b100010001000100010001000011101100101; //  X X X X X X 7 6 5
         9'b011100001: fwd_o =  36'b100010001000100010000111011001010000; //  X X X X X 7 6 5 0
         9'b011100010: fwd_o =  36'b100010001000100010000111011001010001; //  X X X X X 7 6 5 1
         9'b011100011: fwd_o =  36'b100010001000100001110110010100010000; //  X X X X 7 6 5 1 0
         9'b011100100: fwd_o =  36'b100010001000100010000111011001010010; //  X X X X X 7 6 5 2
         9'b011100101: fwd_o =  36'b100010001000100001110110010100100000; //  X X X X 7 6 5 2 0
         9'b011100110: fwd_o =  36'b100010001000100001110110010100100001; //  X X X X 7 6 5 2 1
         9'b011100111: fwd_o =  36'b100010001000011101100101001000010000; //  X X X 7 6 5 2 1 0
         9'b011101000: fwd_o =  36'b100010001000100010000111011001010011; //  X X X X X 7 6 5 3
         9'b011101001: fwd_o =  36'b100010001000100001110110010100110000; //  X X X X 7 6 5 3 0
         9'b011101010: fwd_o =  36'b100010001000100001110110010100110001; //  X X X X 7 6 5 3 1
         9'b011101011: fwd_o =  36'b100010001000011101100101001100010000; //  X X X 7 6 5 3 1 0
         9'b011101100: fwd_o =  36'b100010001000100001110110010100110010; //  X X X X 7 6 5 3 2
         9'b011101101: fwd_o =  36'b100010001000011101100101001100100000; //  X X X 7 6 5 3 2 0
         9'b011101110: fwd_o =  36'b100010001000011101100101001100100001; //  X X X 7 6 5 3 2 1
         9'b011101111: fwd_o =  36'b100010000111011001010011001000010000; //  X X 7 6 5 3 2 1 0
         9'b011110000: fwd_o =  36'b100010001000100010000111011001010100; //  X X X X X 7 6 5 4
         9'b011110001: fwd_o =  36'b100010001000100001110110010101000000; //  X X X X 7 6 5 4 0
         9'b011110010: fwd_o =  36'b100010001000100001110110010101000001; //  X X X X 7 6 5 4 1
         9'b011110011: fwd_o =  36'b100010001000011101100101010000010000; //  X X X 7 6 5 4 1 0
         9'b011110100: fwd_o =  36'b100010001000100001110110010101000010; //  X X X X 7 6 5 4 2
         9'b011110101: fwd_o =  36'b100010001000011101100101010000100000; //  X X X 7 6 5 4 2 0
         9'b011110110: fwd_o =  36'b100010001000011101100101010000100001; //  X X X 7 6 5 4 2 1
         9'b011110111: fwd_o =  36'b100010000111011001010100001000010000; //  X X 7 6 5 4 2 1 0
         9'b011111000: fwd_o =  36'b100010001000100001110110010101000011; //  X X X X 7 6 5 4 3
         9'b011111001: fwd_o =  36'b100010001000011101100101010000110000; //  X X X 7 6 5 4 3 0
         9'b011111010: fwd_o =  36'b100010001000011101100101010000110001; //  X X X 7 6 5 4 3 1
         9'b011111011: fwd_o =  36'b100010000111011001010100001100010000; //  X X 7 6 5 4 3 1 0
         9'b011111100: fwd_o =  36'b100010001000011101100101010000110010; //  X X X 7 6 5 4 3 2
         9'b011111101: fwd_o =  36'b100010000111011001010100001100100000; //  X X 7 6 5 4 3 2 0
         9'b011111110: fwd_o =  36'b100010000111011001010100001100100001; //  X X 7 6 5 4 3 2 1
         9'b011111111: fwd_o =  36'b100001110110010101000011001000010000; //  X 7 6 5 4 3 2 1 0
         9'b100000000: fwd_o =  36'b011101110111011101110111011101111000; //  X X X X X X X X 8
         9'b100000001: fwd_o =  36'b011101110111011101110111011110000000; //  X X X X X X X 8 0
         9'b100000010: fwd_o =  36'b011101110111011101110111011110000001; //  X X X X X X X 8 1
         9'b100000011: fwd_o =  36'b011101110111011101110111100000010000; //  X X X X X X 8 1 0
         9'b100000100: fwd_o =  36'b011101110111011101110111011110000010; //  X X X X X X X 8 2
         9'b100000101: fwd_o =  36'b011101110111011101110111100000100000; //  X X X X X X 8 2 0
         9'b100000110: fwd_o =  36'b011101110111011101110111100000100001; //  X X X X X X 8 2 1
         9'b100000111: fwd_o =  36'b011101110111011101111000001000010000; //  X X X X X 8 2 1 0
         9'b100001000: fwd_o =  36'b011101110111011101110111011110000011; //  X X X X X X X 8 3
         9'b100001001: fwd_o =  36'b011101110111011101110111100000110000; //  X X X X X X 8 3 0
         9'b100001010: fwd_o =  36'b011101110111011101110111100000110001; //  X X X X X X 8 3 1
         9'b100001011: fwd_o =  36'b011101110111011101111000001100010000; //  X X X X X 8 3 1 0
         9'b100001100: fwd_o =  36'b011101110111011101110111100000110010; //  X X X X X X 8 3 2
         9'b100001101: fwd_o =  36'b011101110111011101111000001100100000; //  X X X X X 8 3 2 0
         9'b100001110: fwd_o =  36'b011101110111011101111000001100100001; //  X X X X X 8 3 2 1
         9'b100001111: fwd_o =  36'b011101110111011110000011001000010000; //  X X X X 8 3 2 1 0
         9'b100010000: fwd_o =  36'b011101110111011101110111011110000100; //  X X X X X X X 8 4
         9'b100010001: fwd_o =  36'b011101110111011101110111100001000000; //  X X X X X X 8 4 0
         9'b100010010: fwd_o =  36'b011101110111011101110111100001000001; //  X X X X X X 8 4 1
         9'b100010011: fwd_o =  36'b011101110111011101111000010000010000; //  X X X X X 8 4 1 0
         9'b100010100: fwd_o =  36'b011101110111011101110111100001000010; //  X X X X X X 8 4 2
         9'b100010101: fwd_o =  36'b011101110111011101111000010000100000; //  X X X X X 8 4 2 0
         9'b100010110: fwd_o =  36'b011101110111011101111000010000100001; //  X X X X X 8 4 2 1
         9'b100010111: fwd_o =  36'b011101110111011110000100001000010000; //  X X X X 8 4 2 1 0
         9'b100011000: fwd_o =  36'b011101110111011101110111100001000011; //  X X X X X X 8 4 3
         9'b100011001: fwd_o =  36'b011101110111011101111000010000110000; //  X X X X X 8 4 3 0
         9'b100011010: fwd_o =  36'b011101110111011101111000010000110001; //  X X X X X 8 4 3 1
         9'b100011011: fwd_o =  36'b011101110111011110000100001100010000; //  X X X X 8 4 3 1 0
         9'b100011100: fwd_o =  36'b011101110111011101111000010000110010; //  X X X X X 8 4 3 2
         9'b100011101: fwd_o =  36'b011101110111011110000100001100100000; //  X X X X 8 4 3 2 0
         9'b100011110: fwd_o =  36'b011101110111011110000100001100100001; //  X X X X 8 4 3 2 1
         9'b100011111: fwd_o =  36'b011101110111100001000011001000010000; //  X X X 8 4 3 2 1 0
         9'b100100000: fwd_o =  36'b011101110111011101110111011110000101; //  X X X X X X X 8 5
         9'b100100001: fwd_o =  36'b011101110111011101110111100001010000; //  X X X X X X 8 5 0
         9'b100100010: fwd_o =  36'b011101110111011101110111100001010001; //  X X X X X X 8 5 1
         9'b100100011: fwd_o =  36'b011101110111011101111000010100010000; //  X X X X X 8 5 1 0
         9'b100100100: fwd_o =  36'b011101110111011101110111100001010010; //  X X X X X X 8 5 2
         9'b100100101: fwd_o =  36'b011101110111011101111000010100100000; //  X X X X X 8 5 2 0
         9'b100100110: fwd_o =  36'b011101110111011101111000010100100001; //  X X X X X 8 5 2 1
         9'b100100111: fwd_o =  36'b011101110111011110000101001000010000; //  X X X X 8 5 2 1 0
         9'b100101000: fwd_o =  36'b011101110111011101110111100001010011; //  X X X X X X 8 5 3
         9'b100101001: fwd_o =  36'b011101110111011101111000010100110000; //  X X X X X 8 5 3 0
         9'b100101010: fwd_o =  36'b011101110111011101111000010100110001; //  X X X X X 8 5 3 1
         9'b100101011: fwd_o =  36'b011101110111011110000101001100010000; //  X X X X 8 5 3 1 0
         9'b100101100: fwd_o =  36'b011101110111011101111000010100110010; //  X X X X X 8 5 3 2
         9'b100101101: fwd_o =  36'b011101110111011110000101001100100000; //  X X X X 8 5 3 2 0
         9'b100101110: fwd_o =  36'b011101110111011110000101001100100001; //  X X X X 8 5 3 2 1
         9'b100101111: fwd_o =  36'b011101110111100001010011001000010000; //  X X X 8 5 3 2 1 0
         9'b100110000: fwd_o =  36'b011101110111011101110111100001010100; //  X X X X X X 8 5 4
         9'b100110001: fwd_o =  36'b011101110111011101111000010101000000; //  X X X X X 8 5 4 0
         9'b100110010: fwd_o =  36'b011101110111011101111000010101000001; //  X X X X X 8 5 4 1
         9'b100110011: fwd_o =  36'b011101110111011110000101010000010000; //  X X X X 8 5 4 1 0
         9'b100110100: fwd_o =  36'b011101110111011101111000010101000010; //  X X X X X 8 5 4 2
         9'b100110101: fwd_o =  36'b011101110111011110000101010000100000; //  X X X X 8 5 4 2 0
         9'b100110110: fwd_o =  36'b011101110111011110000101010000100001; //  X X X X 8 5 4 2 1
         9'b100110111: fwd_o =  36'b011101110111100001010100001000010000; //  X X X 8 5 4 2 1 0
         9'b100111000: fwd_o =  36'b011101110111011101111000010101000011; //  X X X X X 8 5 4 3
         9'b100111001: fwd_o =  36'b011101110111011110000101010000110000; //  X X X X 8 5 4 3 0
         9'b100111010: fwd_o =  36'b011101110111011110000101010000110001; //  X X X X 8 5 4 3 1
         9'b100111011: fwd_o =  36'b011101110111100001010100001100010000; //  X X X 8 5 4 3 1 0
         9'b100111100: fwd_o =  36'b011101110111011110000101010000110010; //  X X X X 8 5 4 3 2
         9'b100111101: fwd_o =  36'b011101110111100001010100001100100000; //  X X X 8 5 4 3 2 0
         9'b100111110: fwd_o =  36'b011101110111100001010100001100100001; //  X X X 8 5 4 3 2 1
         9'b100111111: fwd_o =  36'b011101111000010101000011001000010000; //  X X 8 5 4 3 2 1 0
         9'b101000000: fwd_o =  36'b011101110111011101110111011110000110; //  X X X X X X X 8 6
         9'b101000001: fwd_o =  36'b011101110111011101110111100001100000; //  X X X X X X 8 6 0
         9'b101000010: fwd_o =  36'b011101110111011101110111100001100001; //  X X X X X X 8 6 1
         9'b101000011: fwd_o =  36'b011101110111011101111000011000010000; //  X X X X X 8 6 1 0
         9'b101000100: fwd_o =  36'b011101110111011101110111100001100010; //  X X X X X X 8 6 2
         9'b101000101: fwd_o =  36'b011101110111011101111000011000100000; //  X X X X X 8 6 2 0
         9'b101000110: fwd_o =  36'b011101110111011101111000011000100001; //  X X X X X 8 6 2 1
         9'b101000111: fwd_o =  36'b011101110111011110000110001000010000; //  X X X X 8 6 2 1 0
         9'b101001000: fwd_o =  36'b011101110111011101110111100001100011; //  X X X X X X 8 6 3
         9'b101001001: fwd_o =  36'b011101110111011101111000011000110000; //  X X X X X 8 6 3 0
         9'b101001010: fwd_o =  36'b011101110111011101111000011000110001; //  X X X X X 8 6 3 1
         9'b101001011: fwd_o =  36'b011101110111011110000110001100010000; //  X X X X 8 6 3 1 0
         9'b101001100: fwd_o =  36'b011101110111011101111000011000110010; //  X X X X X 8 6 3 2
         9'b101001101: fwd_o =  36'b011101110111011110000110001100100000; //  X X X X 8 6 3 2 0
         9'b101001110: fwd_o =  36'b011101110111011110000110001100100001; //  X X X X 8 6 3 2 1
         9'b101001111: fwd_o =  36'b011101110111100001100011001000010000; //  X X X 8 6 3 2 1 0
         9'b101010000: fwd_o =  36'b011101110111011101110111100001100100; //  X X X X X X 8 6 4
         9'b101010001: fwd_o =  36'b011101110111011101111000011001000000; //  X X X X X 8 6 4 0
         9'b101010010: fwd_o =  36'b011101110111011101111000011001000001; //  X X X X X 8 6 4 1
         9'b101010011: fwd_o =  36'b011101110111011110000110010000010000; //  X X X X 8 6 4 1 0
         9'b101010100: fwd_o =  36'b011101110111011101111000011001000010; //  X X X X X 8 6 4 2
         9'b101010101: fwd_o =  36'b011101110111011110000110010000100000; //  X X X X 8 6 4 2 0
         9'b101010110: fwd_o =  36'b011101110111011110000110010000100001; //  X X X X 8 6 4 2 1
         9'b101010111: fwd_o =  36'b011101110111100001100100001000010000; //  X X X 8 6 4 2 1 0
         9'b101011000: fwd_o =  36'b011101110111011101111000011001000011; //  X X X X X 8 6 4 3
         9'b101011001: fwd_o =  36'b011101110111011110000110010000110000; //  X X X X 8 6 4 3 0
         9'b101011010: fwd_o =  36'b011101110111011110000110010000110001; //  X X X X 8 6 4 3 1
         9'b101011011: fwd_o =  36'b011101110111100001100100001100010000; //  X X X 8 6 4 3 1 0
         9'b101011100: fwd_o =  36'b011101110111011110000110010000110010; //  X X X X 8 6 4 3 2
         9'b101011101: fwd_o =  36'b011101110111100001100100001100100000; //  X X X 8 6 4 3 2 0
         9'b101011110: fwd_o =  36'b011101110111100001100100001100100001; //  X X X 8 6 4 3 2 1
         9'b101011111: fwd_o =  36'b011101111000011001000011001000010000; //  X X 8 6 4 3 2 1 0
         9'b101100000: fwd_o =  36'b011101110111011101110111100001100101; //  X X X X X X 8 6 5
         9'b101100001: fwd_o =  36'b011101110111011101111000011001010000; //  X X X X X 8 6 5 0
         9'b101100010: fwd_o =  36'b011101110111011101111000011001010001; //  X X X X X 8 6 5 1
         9'b101100011: fwd_o =  36'b011101110111011110000110010100010000; //  X X X X 8 6 5 1 0
         9'b101100100: fwd_o =  36'b011101110111011101111000011001010010; //  X X X X X 8 6 5 2
         9'b101100101: fwd_o =  36'b011101110111011110000110010100100000; //  X X X X 8 6 5 2 0
         9'b101100110: fwd_o =  36'b011101110111011110000110010100100001; //  X X X X 8 6 5 2 1
         9'b101100111: fwd_o =  36'b011101110111100001100101001000010000; //  X X X 8 6 5 2 1 0
         9'b101101000: fwd_o =  36'b011101110111011101111000011001010011; //  X X X X X 8 6 5 3
         9'b101101001: fwd_o =  36'b011101110111011110000110010100110000; //  X X X X 8 6 5 3 0
         9'b101101010: fwd_o =  36'b011101110111011110000110010100110001; //  X X X X 8 6 5 3 1
         9'b101101011: fwd_o =  36'b011101110111100001100101001100010000; //  X X X 8 6 5 3 1 0
         9'b101101100: fwd_o =  36'b011101110111011110000110010100110010; //  X X X X 8 6 5 3 2
         9'b101101101: fwd_o =  36'b011101110111100001100101001100100000; //  X X X 8 6 5 3 2 0
         9'b101101110: fwd_o =  36'b011101110111100001100101001100100001; //  X X X 8 6 5 3 2 1
         9'b101101111: fwd_o =  36'b011101111000011001010011001000010000; //  X X 8 6 5 3 2 1 0
         9'b101110000: fwd_o =  36'b011101110111011101111000011001010100; //  X X X X X 8 6 5 4
         9'b101110001: fwd_o =  36'b011101110111011110000110010101000000; //  X X X X 8 6 5 4 0
         9'b101110010: fwd_o =  36'b011101110111011110000110010101000001; //  X X X X 8 6 5 4 1
         9'b101110011: fwd_o =  36'b011101110111100001100101010000010000; //  X X X 8 6 5 4 1 0
         9'b101110100: fwd_o =  36'b011101110111011110000110010101000010; //  X X X X 8 6 5 4 2
         9'b101110101: fwd_o =  36'b011101110111100001100101010000100000; //  X X X 8 6 5 4 2 0
         9'b101110110: fwd_o =  36'b011101110111100001100101010000100001; //  X X X 8 6 5 4 2 1
         9'b101110111: fwd_o =  36'b011101111000011001010100001000010000; //  X X 8 6 5 4 2 1 0
         9'b101111000: fwd_o =  36'b011101110111011110000110010101000011; //  X X X X 8 6 5 4 3
         9'b101111001: fwd_o =  36'b011101110111100001100101010000110000; //  X X X 8 6 5 4 3 0
         9'b101111010: fwd_o =  36'b011101110111100001100101010000110001; //  X X X 8 6 5 4 3 1
         9'b101111011: fwd_o =  36'b011101111000011001010100001100010000; //  X X 8 6 5 4 3 1 0
         9'b101111100: fwd_o =  36'b011101110111100001100101010000110010; //  X X X 8 6 5 4 3 2
         9'b101111101: fwd_o =  36'b011101111000011001010100001100100000; //  X X 8 6 5 4 3 2 0
         9'b101111110: fwd_o =  36'b011101111000011001010100001100100001; //  X X 8 6 5 4 3 2 1
         9'b101111111: fwd_o =  36'b011110000110010101000011001000010000; //  X 8 6 5 4 3 2 1 0
         9'b110000000: fwd_o =  36'b011001100110011001100110011010000111; //  X X X X X X X 8 7
         9'b110000001: fwd_o =  36'b011001100110011001100110100001110000; //  X X X X X X 8 7 0
         9'b110000010: fwd_o =  36'b011001100110011001100110100001110001; //  X X X X X X 8 7 1
         9'b110000011: fwd_o =  36'b011001100110011001101000011100010000; //  X X X X X 8 7 1 0
         9'b110000100: fwd_o =  36'b011001100110011001100110100001110010; //  X X X X X X 8 7 2
         9'b110000101: fwd_o =  36'b011001100110011001101000011100100000; //  X X X X X 8 7 2 0
         9'b110000110: fwd_o =  36'b011001100110011001101000011100100001; //  X X X X X 8 7 2 1
         9'b110000111: fwd_o =  36'b011001100110011010000111001000010000; //  X X X X 8 7 2 1 0
         9'b110001000: fwd_o =  36'b011001100110011001100110100001110011; //  X X X X X X 8 7 3
         9'b110001001: fwd_o =  36'b011001100110011001101000011100110000; //  X X X X X 8 7 3 0
         9'b110001010: fwd_o =  36'b011001100110011001101000011100110001; //  X X X X X 8 7 3 1
         9'b110001011: fwd_o =  36'b011001100110011010000111001100010000; //  X X X X 8 7 3 1 0
         9'b110001100: fwd_o =  36'b011001100110011001101000011100110010; //  X X X X X 8 7 3 2
         9'b110001101: fwd_o =  36'b011001100110011010000111001100100000; //  X X X X 8 7 3 2 0
         9'b110001110: fwd_o =  36'b011001100110011010000111001100100001; //  X X X X 8 7 3 2 1
         9'b110001111: fwd_o =  36'b011001100110100001110011001000010000; //  X X X 8 7 3 2 1 0
         9'b110010000: fwd_o =  36'b011001100110011001100110100001110100; //  X X X X X X 8 7 4
         9'b110010001: fwd_o =  36'b011001100110011001101000011101000000; //  X X X X X 8 7 4 0
         9'b110010010: fwd_o =  36'b011001100110011001101000011101000001; //  X X X X X 8 7 4 1
         9'b110010011: fwd_o =  36'b011001100110011010000111010000010000; //  X X X X 8 7 4 1 0
         9'b110010100: fwd_o =  36'b011001100110011001101000011101000010; //  X X X X X 8 7 4 2
         9'b110010101: fwd_o =  36'b011001100110011010000111010000100000; //  X X X X 8 7 4 2 0
         9'b110010110: fwd_o =  36'b011001100110011010000111010000100001; //  X X X X 8 7 4 2 1
         9'b110010111: fwd_o =  36'b011001100110100001110100001000010000; //  X X X 8 7 4 2 1 0
         9'b110011000: fwd_o =  36'b011001100110011001101000011101000011; //  X X X X X 8 7 4 3
         9'b110011001: fwd_o =  36'b011001100110011010000111010000110000; //  X X X X 8 7 4 3 0
         9'b110011010: fwd_o =  36'b011001100110011010000111010000110001; //  X X X X 8 7 4 3 1
         9'b110011011: fwd_o =  36'b011001100110100001110100001100010000; //  X X X 8 7 4 3 1 0
         9'b110011100: fwd_o =  36'b011001100110011010000111010000110010; //  X X X X 8 7 4 3 2
         9'b110011101: fwd_o =  36'b011001100110100001110100001100100000; //  X X X 8 7 4 3 2 0
         9'b110011110: fwd_o =  36'b011001100110100001110100001100100001; //  X X X 8 7 4 3 2 1
         9'b110011111: fwd_o =  36'b011001101000011101000011001000010000; //  X X 8 7 4 3 2 1 0
         9'b110100000: fwd_o =  36'b011001100110011001100110100001110101; //  X X X X X X 8 7 5
         9'b110100001: fwd_o =  36'b011001100110011001101000011101010000; //  X X X X X 8 7 5 0
         9'b110100010: fwd_o =  36'b011001100110011001101000011101010001; //  X X X X X 8 7 5 1
         9'b110100011: fwd_o =  36'b011001100110011010000111010100010000; //  X X X X 8 7 5 1 0
         9'b110100100: fwd_o =  36'b011001100110011001101000011101010010; //  X X X X X 8 7 5 2
         9'b110100101: fwd_o =  36'b011001100110011010000111010100100000; //  X X X X 8 7 5 2 0
         9'b110100110: fwd_o =  36'b011001100110011010000111010100100001; //  X X X X 8 7 5 2 1
         9'b110100111: fwd_o =  36'b011001100110100001110101001000010000; //  X X X 8 7 5 2 1 0
         9'b110101000: fwd_o =  36'b011001100110011001101000011101010011; //  X X X X X 8 7 5 3
         9'b110101001: fwd_o =  36'b011001100110011010000111010100110000; //  X X X X 8 7 5 3 0
         9'b110101010: fwd_o =  36'b011001100110011010000111010100110001; //  X X X X 8 7 5 3 1
         9'b110101011: fwd_o =  36'b011001100110100001110101001100010000; //  X X X 8 7 5 3 1 0
         9'b110101100: fwd_o =  36'b011001100110011010000111010100110010; //  X X X X 8 7 5 3 2
         9'b110101101: fwd_o =  36'b011001100110100001110101001100100000; //  X X X 8 7 5 3 2 0
         9'b110101110: fwd_o =  36'b011001100110100001110101001100100001; //  X X X 8 7 5 3 2 1
         9'b110101111: fwd_o =  36'b011001101000011101010011001000010000; //  X X 8 7 5 3 2 1 0
         9'b110110000: fwd_o =  36'b011001100110011001101000011101010100; //  X X X X X 8 7 5 4
         9'b110110001: fwd_o =  36'b011001100110011010000111010101000000; //  X X X X 8 7 5 4 0
         9'b110110010: fwd_o =  36'b011001100110011010000111010101000001; //  X X X X 8 7 5 4 1
         9'b110110011: fwd_o =  36'b011001100110100001110101010000010000; //  X X X 8 7 5 4 1 0
         9'b110110100: fwd_o =  36'b011001100110011010000111010101000010; //  X X X X 8 7 5 4 2
         9'b110110101: fwd_o =  36'b011001100110100001110101010000100000; //  X X X 8 7 5 4 2 0
         9'b110110110: fwd_o =  36'b011001100110100001110101010000100001; //  X X X 8 7 5 4 2 1
         9'b110110111: fwd_o =  36'b011001101000011101010100001000010000; //  X X 8 7 5 4 2 1 0
         9'b110111000: fwd_o =  36'b011001100110011010000111010101000011; //  X X X X 8 7 5 4 3
         9'b110111001: fwd_o =  36'b011001100110100001110101010000110000; //  X X X 8 7 5 4 3 0
         9'b110111010: fwd_o =  36'b011001100110100001110101010000110001; //  X X X 8 7 5 4 3 1
         9'b110111011: fwd_o =  36'b011001101000011101010100001100010000; //  X X 8 7 5 4 3 1 0
         9'b110111100: fwd_o =  36'b011001100110100001110101010000110010; //  X X X 8 7 5 4 3 2
         9'b110111101: fwd_o =  36'b011001101000011101010100001100100000; //  X X 8 7 5 4 3 2 0
         9'b110111110: fwd_o =  36'b011001101000011101010100001100100001; //  X X 8 7 5 4 3 2 1
         9'b110111111: fwd_o =  36'b011010000111010101000011001000010000; //  X 8 7 5 4 3 2 1 0
         9'b111000000: fwd_o =  36'b010101010101010101010101100001110110; //  X X X X X X 8 7 6
         9'b111000001: fwd_o =  36'b010101010101010101011000011101100000; //  X X X X X 8 7 6 0
         9'b111000010: fwd_o =  36'b010101010101010101011000011101100001; //  X X X X X 8 7 6 1
         9'b111000011: fwd_o =  36'b010101010101010110000111011000010000; //  X X X X 8 7 6 1 0
         9'b111000100: fwd_o =  36'b010101010101010101011000011101100010; //  X X X X X 8 7 6 2
         9'b111000101: fwd_o =  36'b010101010101010110000111011000100000; //  X X X X 8 7 6 2 0
         9'b111000110: fwd_o =  36'b010101010101010110000111011000100001; //  X X X X 8 7 6 2 1
         9'b111000111: fwd_o =  36'b010101010101100001110110001000010000; //  X X X 8 7 6 2 1 0
         9'b111001000: fwd_o =  36'b010101010101010101011000011101100011; //  X X X X X 8 7 6 3
         9'b111001001: fwd_o =  36'b010101010101010110000111011000110000; //  X X X X 8 7 6 3 0
         9'b111001010: fwd_o =  36'b010101010101010110000111011000110001; //  X X X X 8 7 6 3 1
         9'b111001011: fwd_o =  36'b010101010101100001110110001100010000; //  X X X 8 7 6 3 1 0
         9'b111001100: fwd_o =  36'b010101010101010110000111011000110010; //  X X X X 8 7 6 3 2
         9'b111001101: fwd_o =  36'b010101010101100001110110001100100000; //  X X X 8 7 6 3 2 0
         9'b111001110: fwd_o =  36'b010101010101100001110110001100100001; //  X X X 8 7 6 3 2 1
         9'b111001111: fwd_o =  36'b010101011000011101100011001000010000; //  X X 8 7 6 3 2 1 0
         9'b111010000: fwd_o =  36'b010101010101010101011000011101100100; //  X X X X X 8 7 6 4
         9'b111010001: fwd_o =  36'b010101010101010110000111011001000000; //  X X X X 8 7 6 4 0
         9'b111010010: fwd_o =  36'b010101010101010110000111011001000001; //  X X X X 8 7 6 4 1
         9'b111010011: fwd_o =  36'b010101010101100001110110010000010000; //  X X X 8 7 6 4 1 0
         9'b111010100: fwd_o =  36'b010101010101010110000111011001000010; //  X X X X 8 7 6 4 2
         9'b111010101: fwd_o =  36'b010101010101100001110110010000100000; //  X X X 8 7 6 4 2 0
         9'b111010110: fwd_o =  36'b010101010101100001110110010000100001; //  X X X 8 7 6 4 2 1
         9'b111010111: fwd_o =  36'b010101011000011101100100001000010000; //  X X 8 7 6 4 2 1 0
         9'b111011000: fwd_o =  36'b010101010101010110000111011001000011; //  X X X X 8 7 6 4 3
         9'b111011001: fwd_o =  36'b010101010101100001110110010000110000; //  X X X 8 7 6 4 3 0
         9'b111011010: fwd_o =  36'b010101010101100001110110010000110001; //  X X X 8 7 6 4 3 1
         9'b111011011: fwd_o =  36'b010101011000011101100100001100010000; //  X X 8 7 6 4 3 1 0
         9'b111011100: fwd_o =  36'b010101010101100001110110010000110010; //  X X X 8 7 6 4 3 2
         9'b111011101: fwd_o =  36'b010101011000011101100100001100100000; //  X X 8 7 6 4 3 2 0
         9'b111011110: fwd_o =  36'b010101011000011101100100001100100001; //  X X 8 7 6 4 3 2 1
         9'b111011111: fwd_o =  36'b010110000111011001000011001000010000; //  X 8 7 6 4 3 2 1 0
         9'b111100000: fwd_o =  36'b010001000100010001001000011101100101; //  X X X X X 8 7 6 5
         9'b111100001: fwd_o =  36'b010001000100010010000111011001010000; //  X X X X 8 7 6 5 0
         9'b111100010: fwd_o =  36'b010001000100010010000111011001010001; //  X X X X 8 7 6 5 1
         9'b111100011: fwd_o =  36'b010001000100100001110110010100010000; //  X X X 8 7 6 5 1 0
         9'b111100100: fwd_o =  36'b010001000100010010000111011001010010; //  X X X X 8 7 6 5 2
         9'b111100101: fwd_o =  36'b010001000100100001110110010100100000; //  X X X 8 7 6 5 2 0
         9'b111100110: fwd_o =  36'b010001000100100001110110010100100001; //  X X X 8 7 6 5 2 1
         9'b111100111: fwd_o =  36'b010001001000011101100101001000010000; //  X X 8 7 6 5 2 1 0
         9'b111101000: fwd_o =  36'b010001000100010010000111011001010011; //  X X X X 8 7 6 5 3
         9'b111101001: fwd_o =  36'b010001000100100001110110010100110000; //  X X X 8 7 6 5 3 0
         9'b111101010: fwd_o =  36'b010001000100100001110110010100110001; //  X X X 8 7 6 5 3 1
         9'b111101011: fwd_o =  36'b010001001000011101100101001100010000; //  X X 8 7 6 5 3 1 0
         9'b111101100: fwd_o =  36'b010001000100100001110110010100110010; //  X X X 8 7 6 5 3 2
         9'b111101101: fwd_o =  36'b010001001000011101100101001100100000; //  X X 8 7 6 5 3 2 0
         9'b111101110: fwd_o =  36'b010001001000011101100101001100100001; //  X X 8 7 6 5 3 2 1
         9'b111101111: fwd_o =  36'b010010000111011001010011001000010000; //  X 8 7 6 5 3 2 1 0
         9'b111110000: fwd_o =  36'b001100110011001110000111011001010100; //  X X X X 8 7 6 5 4
         9'b111110001: fwd_o =  36'b001100110011100001110110010101000000; //  X X X 8 7 6 5 4 0
         9'b111110010: fwd_o =  36'b001100110011100001110110010101000001; //  X X X 8 7 6 5 4 1
         9'b111110011: fwd_o =  36'b001100111000011101100101010000010000; //  X X 8 7 6 5 4 1 0
         9'b111110100: fwd_o =  36'b001100110011100001110110010101000010; //  X X X 8 7 6 5 4 2
         9'b111110101: fwd_o =  36'b001100111000011101100101010000100000; //  X X 8 7 6 5 4 2 0
         9'b111110110: fwd_o =  36'b001100111000011101100101010000100001; //  X X 8 7 6 5 4 2 1
         9'b111110111: fwd_o =  36'b001110000111011001010100001000010000; //  X 8 7 6 5 4 2 1 0
         9'b111111000: fwd_o =  36'b001000100010100001110110010101000011; //  X X X 8 7 6 5 4 3
         9'b111111001: fwd_o =  36'b001000101000011101100101010000110000; //  X X 8 7 6 5 4 3 0
         9'b111111010: fwd_o =  36'b001000101000011101100101010000110001; //  X X 8 7 6 5 4 3 1
         9'b111111011: fwd_o =  36'b001010000111011001010100001100010000; //  X 8 7 6 5 4 3 1 0
         9'b111111100: fwd_o =  36'b000100011000011101100101010000110010; //  X X 8 7 6 5 4 3 2
         9'b111111101: fwd_o =  36'b000110000111011001010100001100100000; //  X 8 7 6 5 4 3 2 0
         9'b111111110: fwd_o =  36'b000010000111011001010100001100100001; //  X 8 7 6 5 4 3 2 1
         9'b111111111: fwd_o =  36'b100001110110010101000011001000010000; //  8 7 6 5 4 3 2 1 0
        default: fwd_o= 'X;
    endcase

    // fwd datapath vec
    always_comb
    unique case (vec_i) 
         9'b000000000: fwd_datapath_o =  36'b000000000000000000000000000000000000; //  X X X X X X X X X
         9'b000000001: fwd_datapath_o =  36'b000000000000000000000000000000000000; //  X X X X X X X X 0
         9'b000000010: fwd_datapath_o =  36'b000000000000000000000000000000000001; //  X X X X X X X X 1
         9'b000000011: fwd_datapath_o =  36'b000000000000000000000000000000000000; //  X X X X X X X 0 0
         9'b000000100: fwd_datapath_o =  36'b000000000000000000000000000000000010; //  X X X X X X X X 2
         9'b000000101: fwd_datapath_o =  36'b000000000000000000000000000000010000; //  X X X X X X X 1 0
         9'b000000110: fwd_datapath_o =  36'b000000000000000000000000000000010001; //  X X X X X X X 1 1
         9'b000000111: fwd_datapath_o =  36'b000000000000000000000000000000000000; //  X X X X X X 0 0 0
         9'b000001000: fwd_datapath_o =  36'b000000000000000000000000000000000011; //  X X X X X X X X 3
         9'b000001001: fwd_datapath_o =  36'b000000000000000000000000000000100000; //  X X X X X X X 2 0
         9'b000001010: fwd_datapath_o =  36'b000000000000000000000000000000100001; //  X X X X X X X 2 1
         9'b000001011: fwd_datapath_o =  36'b000000000000000000000000000100000000; //  X X X X X X 1 0 0
         9'b000001100: fwd_datapath_o =  36'b000000000000000000000000000000100010; //  X X X X X X X 2 2
         9'b000001101: fwd_datapath_o =  36'b000000000000000000000000000100010000; //  X X X X X X 1 1 0
         9'b000001110: fwd_datapath_o =  36'b000000000000000000000000000100010001; //  X X X X X X 1 1 1
         9'b000001111: fwd_datapath_o =  36'b000000000000000000000000000000000000; //  X X X X X 0 0 0 0
         9'b000010000: fwd_datapath_o =  36'b000000000000000000000000000000000100; //  X X X X X X X X 4
         9'b000010001: fwd_datapath_o =  36'b000000000000000000000000000000110000; //  X X X X X X X 3 0
         9'b000010010: fwd_datapath_o =  36'b000000000000000000000000000000110001; //  X X X X X X X 3 1
         9'b000010011: fwd_datapath_o =  36'b000000000000000000000000001000000000; //  X X X X X X 2 0 0
         9'b000010100: fwd_datapath_o =  36'b000000000000000000000000000000110010; //  X X X X X X X 3 2
         9'b000010101: fwd_datapath_o =  36'b000000000000000000000000001000010000; //  X X X X X X 2 1 0
         9'b000010110: fwd_datapath_o =  36'b000000000000000000000000001000010001; //  X X X X X X 2 1 1
         9'b000010111: fwd_datapath_o =  36'b000000000000000000000001000000000000; //  X X X X X 1 0 0 0
         9'b000011000: fwd_datapath_o =  36'b000000000000000000000000000000110011; //  X X X X X X X 3 3
         9'b000011001: fwd_datapath_o =  36'b000000000000000000000000001000100000; //  X X X X X X 2 2 0
         9'b000011010: fwd_datapath_o =  36'b000000000000000000000000001000100001; //  X X X X X X 2 2 1
         9'b000011011: fwd_datapath_o =  36'b000000000000000000000001000100000000; //  X X X X X 1 1 0 0
         9'b000011100: fwd_datapath_o =  36'b000000000000000000000000001000100010; //  X X X X X X 2 2 2
         9'b000011101: fwd_datapath_o =  36'b000000000000000000000001000100010000; //  X X X X X 1 1 1 0
         9'b000011110: fwd_datapath_o =  36'b000000000000000000000001000100010001; //  X X X X X 1 1 1 1
         9'b000011111: fwd_datapath_o =  36'b000000000000000000000000000000000000; //  X X X X 0 0 0 0 0
         9'b000100000: fwd_datapath_o =  36'b000000000000000000000000000000000101; //  X X X X X X X X 5
         9'b000100001: fwd_datapath_o =  36'b000000000000000000000000000001000000; //  X X X X X X X 4 0
         9'b000100010: fwd_datapath_o =  36'b000000000000000000000000000001000001; //  X X X X X X X 4 1
         9'b000100011: fwd_datapath_o =  36'b000000000000000000000000001100000000; //  X X X X X X 3 0 0
         9'b000100100: fwd_datapath_o =  36'b000000000000000000000000000001000010; //  X X X X X X X 4 2
         9'b000100101: fwd_datapath_o =  36'b000000000000000000000000001100010000; //  X X X X X X 3 1 0
         9'b000100110: fwd_datapath_o =  36'b000000000000000000000000001100010001; //  X X X X X X 3 1 1
         9'b000100111: fwd_datapath_o =  36'b000000000000000000000010000000000000; //  X X X X X 2 0 0 0
         9'b000101000: fwd_datapath_o =  36'b000000000000000000000000000001000011; //  X X X X X X X 4 3
         9'b000101001: fwd_datapath_o =  36'b000000000000000000000000001100100000; //  X X X X X X 3 2 0
         9'b000101010: fwd_datapath_o =  36'b000000000000000000000000001100100001; //  X X X X X X 3 2 1
         9'b000101011: fwd_datapath_o =  36'b000000000000000000000010000100000000; //  X X X X X 2 1 0 0
         9'b000101100: fwd_datapath_o =  36'b000000000000000000000000001100100010; //  X X X X X X 3 2 2
         9'b000101101: fwd_datapath_o =  36'b000000000000000000000010000100010000; //  X X X X X 2 1 1 0
         9'b000101110: fwd_datapath_o =  36'b000000000000000000000010000100010001; //  X X X X X 2 1 1 1
         9'b000101111: fwd_datapath_o =  36'b000000000000000000010000000000000000; //  X X X X 1 0 0 0 0
         9'b000110000: fwd_datapath_o =  36'b000000000000000000000000000001000100; //  X X X X X X X 4 4
         9'b000110001: fwd_datapath_o =  36'b000000000000000000000000001100110000; //  X X X X X X 3 3 0
         9'b000110010: fwd_datapath_o =  36'b000000000000000000000000001100110001; //  X X X X X X 3 3 1
         9'b000110011: fwd_datapath_o =  36'b000000000000000000000010001000000000; //  X X X X X 2 2 0 0
         9'b000110100: fwd_datapath_o =  36'b000000000000000000000000001100110010; //  X X X X X X 3 3 2
         9'b000110101: fwd_datapath_o =  36'b000000000000000000000010001000010000; //  X X X X X 2 2 1 0
         9'b000110110: fwd_datapath_o =  36'b000000000000000000000010001000010001; //  X X X X X 2 2 1 1
         9'b000110111: fwd_datapath_o =  36'b000000000000000000010001000000000000; //  X X X X 1 1 0 0 0
         9'b000111000: fwd_datapath_o =  36'b000000000000000000000000001100110011; //  X X X X X X 3 3 3
         9'b000111001: fwd_datapath_o =  36'b000000000000000000000010001000100000; //  X X X X X 2 2 2 0
         9'b000111010: fwd_datapath_o =  36'b000000000000000000000010001000100001; //  X X X X X 2 2 2 1
         9'b000111011: fwd_datapath_o =  36'b000000000000000000010001000100000000; //  X X X X 1 1 1 0 0
         9'b000111100: fwd_datapath_o =  36'b000000000000000000000010001000100010; //  X X X X X 2 2 2 2
         9'b000111101: fwd_datapath_o =  36'b000000000000000000010001000100010000; //  X X X X 1 1 1 1 0
         9'b000111110: fwd_datapath_o =  36'b000000000000000000010001000100010001; //  X X X X 1 1 1 1 1
         9'b000111111: fwd_datapath_o =  36'b000000000000000000000000000000000000; //  X X X 0 0 0 0 0 0
         9'b001000000: fwd_datapath_o =  36'b000000000000000000000000000000000110; //  X X X X X X X X 6
         9'b001000001: fwd_datapath_o =  36'b000000000000000000000000000001010000; //  X X X X X X X 5 0
         9'b001000010: fwd_datapath_o =  36'b000000000000000000000000000001010001; //  X X X X X X X 5 1
         9'b001000011: fwd_datapath_o =  36'b000000000000000000000000010000000000; //  X X X X X X 4 0 0
         9'b001000100: fwd_datapath_o =  36'b000000000000000000000000000001010010; //  X X X X X X X 5 2
         9'b001000101: fwd_datapath_o =  36'b000000000000000000000000010000010000; //  X X X X X X 4 1 0
         9'b001000110: fwd_datapath_o =  36'b000000000000000000000000010000010001; //  X X X X X X 4 1 1
         9'b001000111: fwd_datapath_o =  36'b000000000000000000000011000000000000; //  X X X X X 3 0 0 0
         9'b001001000: fwd_datapath_o =  36'b000000000000000000000000000001010011; //  X X X X X X X 5 3
         9'b001001001: fwd_datapath_o =  36'b000000000000000000000000010000100000; //  X X X X X X 4 2 0
         9'b001001010: fwd_datapath_o =  36'b000000000000000000000000010000100001; //  X X X X X X 4 2 1
         9'b001001011: fwd_datapath_o =  36'b000000000000000000000011000100000000; //  X X X X X 3 1 0 0
         9'b001001100: fwd_datapath_o =  36'b000000000000000000000000010000100010; //  X X X X X X 4 2 2
         9'b001001101: fwd_datapath_o =  36'b000000000000000000000011000100010000; //  X X X X X 3 1 1 0
         9'b001001110: fwd_datapath_o =  36'b000000000000000000000011000100010001; //  X X X X X 3 1 1 1
         9'b001001111: fwd_datapath_o =  36'b000000000000000000100000000000000000; //  X X X X 2 0 0 0 0
         9'b001010000: fwd_datapath_o =  36'b000000000000000000000000000001010100; //  X X X X X X X 5 4
         9'b001010001: fwd_datapath_o =  36'b000000000000000000000000010000110000; //  X X X X X X 4 3 0
         9'b001010010: fwd_datapath_o =  36'b000000000000000000000000010000110001; //  X X X X X X 4 3 1
         9'b001010011: fwd_datapath_o =  36'b000000000000000000000011001000000000; //  X X X X X 3 2 0 0
         9'b001010100: fwd_datapath_o =  36'b000000000000000000000000010000110010; //  X X X X X X 4 3 2
         9'b001010101: fwd_datapath_o =  36'b000000000000000000000011001000010000; //  X X X X X 3 2 1 0
         9'b001010110: fwd_datapath_o =  36'b000000000000000000000011001000010001; //  X X X X X 3 2 1 1
         9'b001010111: fwd_datapath_o =  36'b000000000000000000100001000000000000; //  X X X X 2 1 0 0 0
         9'b001011000: fwd_datapath_o =  36'b000000000000000000000000010000110011; //  X X X X X X 4 3 3
         9'b001011001: fwd_datapath_o =  36'b000000000000000000000011001000100000; //  X X X X X 3 2 2 0
         9'b001011010: fwd_datapath_o =  36'b000000000000000000000011001000100001; //  X X X X X 3 2 2 1
         9'b001011011: fwd_datapath_o =  36'b000000000000000000100001000100000000; //  X X X X 2 1 1 0 0
         9'b001011100: fwd_datapath_o =  36'b000000000000000000000011001000100010; //  X X X X X 3 2 2 2
         9'b001011101: fwd_datapath_o =  36'b000000000000000000100001000100010000; //  X X X X 2 1 1 1 0
         9'b001011110: fwd_datapath_o =  36'b000000000000000000100001000100010001; //  X X X X 2 1 1 1 1
         9'b001011111: fwd_datapath_o =  36'b000000000000000100000000000000000000; //  X X X 1 0 0 0 0 0
         9'b001100000: fwd_datapath_o =  36'b000000000000000000000000000001010101; //  X X X X X X X 5 5
         9'b001100001: fwd_datapath_o =  36'b000000000000000000000000010001000000; //  X X X X X X 4 4 0
         9'b001100010: fwd_datapath_o =  36'b000000000000000000000000010001000001; //  X X X X X X 4 4 1
         9'b001100011: fwd_datapath_o =  36'b000000000000000000000011001100000000; //  X X X X X 3 3 0 0
         9'b001100100: fwd_datapath_o =  36'b000000000000000000000000010001000010; //  X X X X X X 4 4 2
         9'b001100101: fwd_datapath_o =  36'b000000000000000000000011001100010000; //  X X X X X 3 3 1 0
         9'b001100110: fwd_datapath_o =  36'b000000000000000000000011001100010001; //  X X X X X 3 3 1 1
         9'b001100111: fwd_datapath_o =  36'b000000000000000000100010000000000000; //  X X X X 2 2 0 0 0
         9'b001101000: fwd_datapath_o =  36'b000000000000000000000000010001000011; //  X X X X X X 4 4 3
         9'b001101001: fwd_datapath_o =  36'b000000000000000000000011001100100000; //  X X X X X 3 3 2 0
         9'b001101010: fwd_datapath_o =  36'b000000000000000000000011001100100001; //  X X X X X 3 3 2 1
         9'b001101011: fwd_datapath_o =  36'b000000000000000000100010000100000000; //  X X X X 2 2 1 0 0
         9'b001101100: fwd_datapath_o =  36'b000000000000000000000011001100100010; //  X X X X X 3 3 2 2
         9'b001101101: fwd_datapath_o =  36'b000000000000000000100010000100010000; //  X X X X 2 2 1 1 0
         9'b001101110: fwd_datapath_o =  36'b000000000000000000100010000100010001; //  X X X X 2 2 1 1 1
         9'b001101111: fwd_datapath_o =  36'b000000000000000100010000000000000000; //  X X X 1 1 0 0 0 0
         9'b001110000: fwd_datapath_o =  36'b000000000000000000000000010001000100; //  X X X X X X 4 4 4
         9'b001110001: fwd_datapath_o =  36'b000000000000000000000011001100110000; //  X X X X X 3 3 3 0
         9'b001110010: fwd_datapath_o =  36'b000000000000000000000011001100110001; //  X X X X X 3 3 3 1
         9'b001110011: fwd_datapath_o =  36'b000000000000000000100010001000000000; //  X X X X 2 2 2 0 0
         9'b001110100: fwd_datapath_o =  36'b000000000000000000000011001100110010; //  X X X X X 3 3 3 2
         9'b001110101: fwd_datapath_o =  36'b000000000000000000100010001000010000; //  X X X X 2 2 2 1 0
         9'b001110110: fwd_datapath_o =  36'b000000000000000000100010001000010001; //  X X X X 2 2 2 1 1
         9'b001110111: fwd_datapath_o =  36'b000000000000000100010001000000000000; //  X X X 1 1 1 0 0 0
         9'b001111000: fwd_datapath_o =  36'b000000000000000000000011001100110011; //  X X X X X 3 3 3 3
         9'b001111001: fwd_datapath_o =  36'b000000000000000000100010001000100000; //  X X X X 2 2 2 2 0
         9'b001111010: fwd_datapath_o =  36'b000000000000000000100010001000100001; //  X X X X 2 2 2 2 1
         9'b001111011: fwd_datapath_o =  36'b000000000000000100010001000100000000; //  X X X 1 1 1 1 0 0
         9'b001111100: fwd_datapath_o =  36'b000000000000000000100010001000100010; //  X X X X 2 2 2 2 2
         9'b001111101: fwd_datapath_o =  36'b000000000000000100010001000100010000; //  X X X 1 1 1 1 1 0
         9'b001111110: fwd_datapath_o =  36'b000000000000000100010001000100010001; //  X X X 1 1 1 1 1 1
         9'b001111111: fwd_datapath_o =  36'b000000000000000000000000000000000000; //  X X 0 0 0 0 0 0 0
         9'b010000000: fwd_datapath_o =  36'b000000000000000000000000000000000111; //  X X X X X X X X 7
         9'b010000001: fwd_datapath_o =  36'b000000000000000000000000000001100000; //  X X X X X X X 6 0
         9'b010000010: fwd_datapath_o =  36'b000000000000000000000000000001100001; //  X X X X X X X 6 1
         9'b010000011: fwd_datapath_o =  36'b000000000000000000000000010100000000; //  X X X X X X 5 0 0
         9'b010000100: fwd_datapath_o =  36'b000000000000000000000000000001100010; //  X X X X X X X 6 2
         9'b010000101: fwd_datapath_o =  36'b000000000000000000000000010100010000; //  X X X X X X 5 1 0
         9'b010000110: fwd_datapath_o =  36'b000000000000000000000000010100010001; //  X X X X X X 5 1 1
         9'b010000111: fwd_datapath_o =  36'b000000000000000000000100000000000000; //  X X X X X 4 0 0 0
         9'b010001000: fwd_datapath_o =  36'b000000000000000000000000000001100011; //  X X X X X X X 6 3
         9'b010001001: fwd_datapath_o =  36'b000000000000000000000000010100100000; //  X X X X X X 5 2 0
         9'b010001010: fwd_datapath_o =  36'b000000000000000000000000010100100001; //  X X X X X X 5 2 1
         9'b010001011: fwd_datapath_o =  36'b000000000000000000000100000100000000; //  X X X X X 4 1 0 0
         9'b010001100: fwd_datapath_o =  36'b000000000000000000000000010100100010; //  X X X X X X 5 2 2
         9'b010001101: fwd_datapath_o =  36'b000000000000000000000100000100010000; //  X X X X X 4 1 1 0
         9'b010001110: fwd_datapath_o =  36'b000000000000000000000100000100010001; //  X X X X X 4 1 1 1
         9'b010001111: fwd_datapath_o =  36'b000000000000000000110000000000000000; //  X X X X 3 0 0 0 0
         9'b010010000: fwd_datapath_o =  36'b000000000000000000000000000001100100; //  X X X X X X X 6 4
         9'b010010001: fwd_datapath_o =  36'b000000000000000000000000010100110000; //  X X X X X X 5 3 0
         9'b010010010: fwd_datapath_o =  36'b000000000000000000000000010100110001; //  X X X X X X 5 3 1
         9'b010010011: fwd_datapath_o =  36'b000000000000000000000100001000000000; //  X X X X X 4 2 0 0
         9'b010010100: fwd_datapath_o =  36'b000000000000000000000000010100110010; //  X X X X X X 5 3 2
         9'b010010101: fwd_datapath_o =  36'b000000000000000000000100001000010000; //  X X X X X 4 2 1 0
         9'b010010110: fwd_datapath_o =  36'b000000000000000000000100001000010001; //  X X X X X 4 2 1 1
         9'b010010111: fwd_datapath_o =  36'b000000000000000000110001000000000000; //  X X X X 3 1 0 0 0
         9'b010011000: fwd_datapath_o =  36'b000000000000000000000000010100110011; //  X X X X X X 5 3 3
         9'b010011001: fwd_datapath_o =  36'b000000000000000000000100001000100000; //  X X X X X 4 2 2 0
         9'b010011010: fwd_datapath_o =  36'b000000000000000000000100001000100001; //  X X X X X 4 2 2 1
         9'b010011011: fwd_datapath_o =  36'b000000000000000000110001000100000000; //  X X X X 3 1 1 0 0
         9'b010011100: fwd_datapath_o =  36'b000000000000000000000100001000100010; //  X X X X X 4 2 2 2
         9'b010011101: fwd_datapath_o =  36'b000000000000000000110001000100010000; //  X X X X 3 1 1 1 0
         9'b010011110: fwd_datapath_o =  36'b000000000000000000110001000100010001; //  X X X X 3 1 1 1 1
         9'b010011111: fwd_datapath_o =  36'b000000000000001000000000000000000000; //  X X X 2 0 0 0 0 0
         9'b010100000: fwd_datapath_o =  36'b000000000000000000000000000001100101; //  X X X X X X X 6 5
         9'b010100001: fwd_datapath_o =  36'b000000000000000000000000010101000000; //  X X X X X X 5 4 0
         9'b010100010: fwd_datapath_o =  36'b000000000000000000000000010101000001; //  X X X X X X 5 4 1
         9'b010100011: fwd_datapath_o =  36'b000000000000000000000100001100000000; //  X X X X X 4 3 0 0
         9'b010100100: fwd_datapath_o =  36'b000000000000000000000000010101000010; //  X X X X X X 5 4 2
         9'b010100101: fwd_datapath_o =  36'b000000000000000000000100001100010000; //  X X X X X 4 3 1 0
         9'b010100110: fwd_datapath_o =  36'b000000000000000000000100001100010001; //  X X X X X 4 3 1 1
         9'b010100111: fwd_datapath_o =  36'b000000000000000000110010000000000000; //  X X X X 3 2 0 0 0
         9'b010101000: fwd_datapath_o =  36'b000000000000000000000000010101000011; //  X X X X X X 5 4 3
         9'b010101001: fwd_datapath_o =  36'b000000000000000000000100001100100000; //  X X X X X 4 3 2 0
         9'b010101010: fwd_datapath_o =  36'b000000000000000000000100001100100001; //  X X X X X 4 3 2 1
         9'b010101011: fwd_datapath_o =  36'b000000000000000000110010000100000000; //  X X X X 3 2 1 0 0
         9'b010101100: fwd_datapath_o =  36'b000000000000000000000100001100100010; //  X X X X X 4 3 2 2
         9'b010101101: fwd_datapath_o =  36'b000000000000000000110010000100010000; //  X X X X 3 2 1 1 0
         9'b010101110: fwd_datapath_o =  36'b000000000000000000110010000100010001; //  X X X X 3 2 1 1 1
         9'b010101111: fwd_datapath_o =  36'b000000000000001000010000000000000000; //  X X X 2 1 0 0 0 0
         9'b010110000: fwd_datapath_o =  36'b000000000000000000000000010101000100; //  X X X X X X 5 4 4
         9'b010110001: fwd_datapath_o =  36'b000000000000000000000100001100110000; //  X X X X X 4 3 3 0
         9'b010110010: fwd_datapath_o =  36'b000000000000000000000100001100110001; //  X X X X X 4 3 3 1
         9'b010110011: fwd_datapath_o =  36'b000000000000000000110010001000000000; //  X X X X 3 2 2 0 0
         9'b010110100: fwd_datapath_o =  36'b000000000000000000000100001100110010; //  X X X X X 4 3 3 2
         9'b010110101: fwd_datapath_o =  36'b000000000000000000110010001000010000; //  X X X X 3 2 2 1 0
         9'b010110110: fwd_datapath_o =  36'b000000000000000000110010001000010001; //  X X X X 3 2 2 1 1
         9'b010110111: fwd_datapath_o =  36'b000000000000001000010001000000000000; //  X X X 2 1 1 0 0 0
         9'b010111000: fwd_datapath_o =  36'b000000000000000000000100001100110011; //  X X X X X 4 3 3 3
         9'b010111001: fwd_datapath_o =  36'b000000000000000000110010001000100000; //  X X X X 3 2 2 2 0
         9'b010111010: fwd_datapath_o =  36'b000000000000000000110010001000100001; //  X X X X 3 2 2 2 1
         9'b010111011: fwd_datapath_o =  36'b000000000000001000010001000100000000; //  X X X 2 1 1 1 0 0
         9'b010111100: fwd_datapath_o =  36'b000000000000000000110010001000100010; //  X X X X 3 2 2 2 2
         9'b010111101: fwd_datapath_o =  36'b000000000000001000010001000100010000; //  X X X 2 1 1 1 1 0
         9'b010111110: fwd_datapath_o =  36'b000000000000001000010001000100010001; //  X X X 2 1 1 1 1 1
         9'b010111111: fwd_datapath_o =  36'b000000000001000000000000000000000000; //  X X 1 0 0 0 0 0 0
         9'b011000000: fwd_datapath_o =  36'b000000000000000000000000000001100110; //  X X X X X X X 6 6
         9'b011000001: fwd_datapath_o =  36'b000000000000000000000000010101010000; //  X X X X X X 5 5 0
         9'b011000010: fwd_datapath_o =  36'b000000000000000000000000010101010001; //  X X X X X X 5 5 1
         9'b011000011: fwd_datapath_o =  36'b000000000000000000000100010000000000; //  X X X X X 4 4 0 0
         9'b011000100: fwd_datapath_o =  36'b000000000000000000000000010101010010; //  X X X X X X 5 5 2
         9'b011000101: fwd_datapath_o =  36'b000000000000000000000100010000010000; //  X X X X X 4 4 1 0
         9'b011000110: fwd_datapath_o =  36'b000000000000000000000100010000010001; //  X X X X X 4 4 1 1
         9'b011000111: fwd_datapath_o =  36'b000000000000000000110011000000000000; //  X X X X 3 3 0 0 0
         9'b011001000: fwd_datapath_o =  36'b000000000000000000000000010101010011; //  X X X X X X 5 5 3
         9'b011001001: fwd_datapath_o =  36'b000000000000000000000100010000100000; //  X X X X X 4 4 2 0
         9'b011001010: fwd_datapath_o =  36'b000000000000000000000100010000100001; //  X X X X X 4 4 2 1
         9'b011001011: fwd_datapath_o =  36'b000000000000000000110011000100000000; //  X X X X 3 3 1 0 0
         9'b011001100: fwd_datapath_o =  36'b000000000000000000000100010000100010; //  X X X X X 4 4 2 2
         9'b011001101: fwd_datapath_o =  36'b000000000000000000110011000100010000; //  X X X X 3 3 1 1 0
         9'b011001110: fwd_datapath_o =  36'b000000000000000000110011000100010001; //  X X X X 3 3 1 1 1
         9'b011001111: fwd_datapath_o =  36'b000000000000001000100000000000000000; //  X X X 2 2 0 0 0 0
         9'b011010000: fwd_datapath_o =  36'b000000000000000000000000010101010100; //  X X X X X X 5 5 4
         9'b011010001: fwd_datapath_o =  36'b000000000000000000000100010000110000; //  X X X X X 4 4 3 0
         9'b011010010: fwd_datapath_o =  36'b000000000000000000000100010000110001; //  X X X X X 4 4 3 1
         9'b011010011: fwd_datapath_o =  36'b000000000000000000110011001000000000; //  X X X X 3 3 2 0 0
         9'b011010100: fwd_datapath_o =  36'b000000000000000000000100010000110010; //  X X X X X 4 4 3 2
         9'b011010101: fwd_datapath_o =  36'b000000000000000000110011001000010000; //  X X X X 3 3 2 1 0
         9'b011010110: fwd_datapath_o =  36'b000000000000000000110011001000010001; //  X X X X 3 3 2 1 1
         9'b011010111: fwd_datapath_o =  36'b000000000000001000100001000000000000; //  X X X 2 2 1 0 0 0
         9'b011011000: fwd_datapath_o =  36'b000000000000000000000100010000110011; //  X X X X X 4 4 3 3
         9'b011011001: fwd_datapath_o =  36'b000000000000000000110011001000100000; //  X X X X 3 3 2 2 0
         9'b011011010: fwd_datapath_o =  36'b000000000000000000110011001000100001; //  X X X X 3 3 2 2 1
         9'b011011011: fwd_datapath_o =  36'b000000000000001000100001000100000000; //  X X X 2 2 1 1 0 0
         9'b011011100: fwd_datapath_o =  36'b000000000000000000110011001000100010; //  X X X X 3 3 2 2 2
         9'b011011101: fwd_datapath_o =  36'b000000000000001000100001000100010000; //  X X X 2 2 1 1 1 0
         9'b011011110: fwd_datapath_o =  36'b000000000000001000100001000100010001; //  X X X 2 2 1 1 1 1
         9'b011011111: fwd_datapath_o =  36'b000000000001000100000000000000000000; //  X X 1 1 0 0 0 0 0
         9'b011100000: fwd_datapath_o =  36'b000000000000000000000000010101010101; //  X X X X X X 5 5 5
         9'b011100001: fwd_datapath_o =  36'b000000000000000000000100010001000000; //  X X X X X 4 4 4 0
         9'b011100010: fwd_datapath_o =  36'b000000000000000000000100010001000001; //  X X X X X 4 4 4 1
         9'b011100011: fwd_datapath_o =  36'b000000000000000000110011001100000000; //  X X X X 3 3 3 0 0
         9'b011100100: fwd_datapath_o =  36'b000000000000000000000100010001000010; //  X X X X X 4 4 4 2
         9'b011100101: fwd_datapath_o =  36'b000000000000000000110011001100010000; //  X X X X 3 3 3 1 0
         9'b011100110: fwd_datapath_o =  36'b000000000000000000110011001100010001; //  X X X X 3 3 3 1 1
         9'b011100111: fwd_datapath_o =  36'b000000000000001000100010000000000000; //  X X X 2 2 2 0 0 0
         9'b011101000: fwd_datapath_o =  36'b000000000000000000000100010001000011; //  X X X X X 4 4 4 3
         9'b011101001: fwd_datapath_o =  36'b000000000000000000110011001100100000; //  X X X X 3 3 3 2 0
         9'b011101010: fwd_datapath_o =  36'b000000000000000000110011001100100001; //  X X X X 3 3 3 2 1
         9'b011101011: fwd_datapath_o =  36'b000000000000001000100010000100000000; //  X X X 2 2 2 1 0 0
         9'b011101100: fwd_datapath_o =  36'b000000000000000000110011001100100010; //  X X X X 3 3 3 2 2
         9'b011101101: fwd_datapath_o =  36'b000000000000001000100010000100010000; //  X X X 2 2 2 1 1 0
         9'b011101110: fwd_datapath_o =  36'b000000000000001000100010000100010001; //  X X X 2 2 2 1 1 1
         9'b011101111: fwd_datapath_o =  36'b000000000001000100010000000000000000; //  X X 1 1 1 0 0 0 0
         9'b011110000: fwd_datapath_o =  36'b000000000000000000000100010001000100; //  X X X X X 4 4 4 4
         9'b011110001: fwd_datapath_o =  36'b000000000000000000110011001100110000; //  X X X X 3 3 3 3 0
         9'b011110010: fwd_datapath_o =  36'b000000000000000000110011001100110001; //  X X X X 3 3 3 3 1
         9'b011110011: fwd_datapath_o =  36'b000000000000001000100010001000000000; //  X X X 2 2 2 2 0 0
         9'b011110100: fwd_datapath_o =  36'b000000000000000000110011001100110010; //  X X X X 3 3 3 3 2
         9'b011110101: fwd_datapath_o =  36'b000000000000001000100010001000010000; //  X X X 2 2 2 2 1 0
         9'b011110110: fwd_datapath_o =  36'b000000000000001000100010001000010001; //  X X X 2 2 2 2 1 1
         9'b011110111: fwd_datapath_o =  36'b000000000001000100010001000000000000; //  X X 1 1 1 1 0 0 0
         9'b011111000: fwd_datapath_o =  36'b000000000000000000110011001100110011; //  X X X X 3 3 3 3 3
         9'b011111001: fwd_datapath_o =  36'b000000000000001000100010001000100000; //  X X X 2 2 2 2 2 0
         9'b011111010: fwd_datapath_o =  36'b000000000000001000100010001000100001; //  X X X 2 2 2 2 2 1
         9'b011111011: fwd_datapath_o =  36'b000000000001000100010001000100000000; //  X X 1 1 1 1 1 0 0
         9'b011111100: fwd_datapath_o =  36'b000000000000001000100010001000100010; //  X X X 2 2 2 2 2 2
         9'b011111101: fwd_datapath_o =  36'b000000000001000100010001000100010000; //  X X 1 1 1 1 1 1 0
         9'b011111110: fwd_datapath_o =  36'b000000000001000100010001000100010001; //  X X 1 1 1 1 1 1 1
         9'b011111111: fwd_datapath_o =  36'b000000000000000000000000000000000000; //  X 0 0 0 0 0 0 0 0
         9'b100000000: fwd_datapath_o =  36'b000000000000000000000000000000001000; //  X X X X X X X X 8
         9'b100000001: fwd_datapath_o =  36'b000000000000000000000000000001110000; //  X X X X X X X 7 0
         9'b100000010: fwd_datapath_o =  36'b000000000000000000000000000001110001; //  X X X X X X X 7 1
         9'b100000011: fwd_datapath_o =  36'b000000000000000000000000011000000000; //  X X X X X X 6 0 0
         9'b100000100: fwd_datapath_o =  36'b000000000000000000000000000001110010; //  X X X X X X X 7 2
         9'b100000101: fwd_datapath_o =  36'b000000000000000000000000011000010000; //  X X X X X X 6 1 0
         9'b100000110: fwd_datapath_o =  36'b000000000000000000000000011000010001; //  X X X X X X 6 1 1
         9'b100000111: fwd_datapath_o =  36'b000000000000000000000101000000000000; //  X X X X X 5 0 0 0
         9'b100001000: fwd_datapath_o =  36'b000000000000000000000000000001110011; //  X X X X X X X 7 3
         9'b100001001: fwd_datapath_o =  36'b000000000000000000000000011000100000; //  X X X X X X 6 2 0
         9'b100001010: fwd_datapath_o =  36'b000000000000000000000000011000100001; //  X X X X X X 6 2 1
         9'b100001011: fwd_datapath_o =  36'b000000000000000000000101000100000000; //  X X X X X 5 1 0 0
         9'b100001100: fwd_datapath_o =  36'b000000000000000000000000011000100010; //  X X X X X X 6 2 2
         9'b100001101: fwd_datapath_o =  36'b000000000000000000000101000100010000; //  X X X X X 5 1 1 0
         9'b100001110: fwd_datapath_o =  36'b000000000000000000000101000100010001; //  X X X X X 5 1 1 1
         9'b100001111: fwd_datapath_o =  36'b000000000000000001000000000000000000; //  X X X X 4 0 0 0 0
         9'b100010000: fwd_datapath_o =  36'b000000000000000000000000000001110100; //  X X X X X X X 7 4
         9'b100010001: fwd_datapath_o =  36'b000000000000000000000000011000110000; //  X X X X X X 6 3 0
         9'b100010010: fwd_datapath_o =  36'b000000000000000000000000011000110001; //  X X X X X X 6 3 1
         9'b100010011: fwd_datapath_o =  36'b000000000000000000000101001000000000; //  X X X X X 5 2 0 0
         9'b100010100: fwd_datapath_o =  36'b000000000000000000000000011000110010; //  X X X X X X 6 3 2
         9'b100010101: fwd_datapath_o =  36'b000000000000000000000101001000010000; //  X X X X X 5 2 1 0
         9'b100010110: fwd_datapath_o =  36'b000000000000000000000101001000010001; //  X X X X X 5 2 1 1
         9'b100010111: fwd_datapath_o =  36'b000000000000000001000001000000000000; //  X X X X 4 1 0 0 0
         9'b100011000: fwd_datapath_o =  36'b000000000000000000000000011000110011; //  X X X X X X 6 3 3
         9'b100011001: fwd_datapath_o =  36'b000000000000000000000101001000100000; //  X X X X X 5 2 2 0
         9'b100011010: fwd_datapath_o =  36'b000000000000000000000101001000100001; //  X X X X X 5 2 2 1
         9'b100011011: fwd_datapath_o =  36'b000000000000000001000001000100000000; //  X X X X 4 1 1 0 0
         9'b100011100: fwd_datapath_o =  36'b000000000000000000000101001000100010; //  X X X X X 5 2 2 2
         9'b100011101: fwd_datapath_o =  36'b000000000000000001000001000100010000; //  X X X X 4 1 1 1 0
         9'b100011110: fwd_datapath_o =  36'b000000000000000001000001000100010001; //  X X X X 4 1 1 1 1
         9'b100011111: fwd_datapath_o =  36'b000000000000001100000000000000000000; //  X X X 3 0 0 0 0 0
         9'b100100000: fwd_datapath_o =  36'b000000000000000000000000000001110101; //  X X X X X X X 7 5
         9'b100100001: fwd_datapath_o =  36'b000000000000000000000000011001000000; //  X X X X X X 6 4 0
         9'b100100010: fwd_datapath_o =  36'b000000000000000000000000011001000001; //  X X X X X X 6 4 1
         9'b100100011: fwd_datapath_o =  36'b000000000000000000000101001100000000; //  X X X X X 5 3 0 0
         9'b100100100: fwd_datapath_o =  36'b000000000000000000000000011001000010; //  X X X X X X 6 4 2
         9'b100100101: fwd_datapath_o =  36'b000000000000000000000101001100010000; //  X X X X X 5 3 1 0
         9'b100100110: fwd_datapath_o =  36'b000000000000000000000101001100010001; //  X X X X X 5 3 1 1
         9'b100100111: fwd_datapath_o =  36'b000000000000000001000010000000000000; //  X X X X 4 2 0 0 0
         9'b100101000: fwd_datapath_o =  36'b000000000000000000000000011001000011; //  X X X X X X 6 4 3
         9'b100101001: fwd_datapath_o =  36'b000000000000000000000101001100100000; //  X X X X X 5 3 2 0
         9'b100101010: fwd_datapath_o =  36'b000000000000000000000101001100100001; //  X X X X X 5 3 2 1
         9'b100101011: fwd_datapath_o =  36'b000000000000000001000010000100000000; //  X X X X 4 2 1 0 0
         9'b100101100: fwd_datapath_o =  36'b000000000000000000000101001100100010; //  X X X X X 5 3 2 2
         9'b100101101: fwd_datapath_o =  36'b000000000000000001000010000100010000; //  X X X X 4 2 1 1 0
         9'b100101110: fwd_datapath_o =  36'b000000000000000001000010000100010001; //  X X X X 4 2 1 1 1
         9'b100101111: fwd_datapath_o =  36'b000000000000001100010000000000000000; //  X X X 3 1 0 0 0 0
         9'b100110000: fwd_datapath_o =  36'b000000000000000000000000011001000100; //  X X X X X X 6 4 4
         9'b100110001: fwd_datapath_o =  36'b000000000000000000000101001100110000; //  X X X X X 5 3 3 0
         9'b100110010: fwd_datapath_o =  36'b000000000000000000000101001100110001; //  X X X X X 5 3 3 1
         9'b100110011: fwd_datapath_o =  36'b000000000000000001000010001000000000; //  X X X X 4 2 2 0 0
         9'b100110100: fwd_datapath_o =  36'b000000000000000000000101001100110010; //  X X X X X 5 3 3 2
         9'b100110101: fwd_datapath_o =  36'b000000000000000001000010001000010000; //  X X X X 4 2 2 1 0
         9'b100110110: fwd_datapath_o =  36'b000000000000000001000010001000010001; //  X X X X 4 2 2 1 1
         9'b100110111: fwd_datapath_o =  36'b000000000000001100010001000000000000; //  X X X 3 1 1 0 0 0
         9'b100111000: fwd_datapath_o =  36'b000000000000000000000101001100110011; //  X X X X X 5 3 3 3
         9'b100111001: fwd_datapath_o =  36'b000000000000000001000010001000100000; //  X X X X 4 2 2 2 0
         9'b100111010: fwd_datapath_o =  36'b000000000000000001000010001000100001; //  X X X X 4 2 2 2 1
         9'b100111011: fwd_datapath_o =  36'b000000000000001100010001000100000000; //  X X X 3 1 1 1 0 0
         9'b100111100: fwd_datapath_o =  36'b000000000000000001000010001000100010; //  X X X X 4 2 2 2 2
         9'b100111101: fwd_datapath_o =  36'b000000000000001100010001000100010000; //  X X X 3 1 1 1 1 0
         9'b100111110: fwd_datapath_o =  36'b000000000000001100010001000100010001; //  X X X 3 1 1 1 1 1
         9'b100111111: fwd_datapath_o =  36'b000000000010000000000000000000000000; //  X X 2 0 0 0 0 0 0
         9'b101000000: fwd_datapath_o =  36'b000000000000000000000000000001110110; //  X X X X X X X 7 6
         9'b101000001: fwd_datapath_o =  36'b000000000000000000000000011001010000; //  X X X X X X 6 5 0
         9'b101000010: fwd_datapath_o =  36'b000000000000000000000000011001010001; //  X X X X X X 6 5 1
         9'b101000011: fwd_datapath_o =  36'b000000000000000000000101010000000000; //  X X X X X 5 4 0 0
         9'b101000100: fwd_datapath_o =  36'b000000000000000000000000011001010010; //  X X X X X X 6 5 2
         9'b101000101: fwd_datapath_o =  36'b000000000000000000000101010000010000; //  X X X X X 5 4 1 0
         9'b101000110: fwd_datapath_o =  36'b000000000000000000000101010000010001; //  X X X X X 5 4 1 1
         9'b101000111: fwd_datapath_o =  36'b000000000000000001000011000000000000; //  X X X X 4 3 0 0 0
         9'b101001000: fwd_datapath_o =  36'b000000000000000000000000011001010011; //  X X X X X X 6 5 3
         9'b101001001: fwd_datapath_o =  36'b000000000000000000000101010000100000; //  X X X X X 5 4 2 0
         9'b101001010: fwd_datapath_o =  36'b000000000000000000000101010000100001; //  X X X X X 5 4 2 1
         9'b101001011: fwd_datapath_o =  36'b000000000000000001000011000100000000; //  X X X X 4 3 1 0 0
         9'b101001100: fwd_datapath_o =  36'b000000000000000000000101010000100010; //  X X X X X 5 4 2 2
         9'b101001101: fwd_datapath_o =  36'b000000000000000001000011000100010000; //  X X X X 4 3 1 1 0
         9'b101001110: fwd_datapath_o =  36'b000000000000000001000011000100010001; //  X X X X 4 3 1 1 1
         9'b101001111: fwd_datapath_o =  36'b000000000000001100100000000000000000; //  X X X 3 2 0 0 0 0
         9'b101010000: fwd_datapath_o =  36'b000000000000000000000000011001010100; //  X X X X X X 6 5 4
         9'b101010001: fwd_datapath_o =  36'b000000000000000000000101010000110000; //  X X X X X 5 4 3 0
         9'b101010010: fwd_datapath_o =  36'b000000000000000000000101010000110001; //  X X X X X 5 4 3 1
         9'b101010011: fwd_datapath_o =  36'b000000000000000001000011001000000000; //  X X X X 4 3 2 0 0
         9'b101010100: fwd_datapath_o =  36'b000000000000000000000101010000110010; //  X X X X X 5 4 3 2
         9'b101010101: fwd_datapath_o =  36'b000000000000000001000011001000010000; //  X X X X 4 3 2 1 0
         9'b101010110: fwd_datapath_o =  36'b000000000000000001000011001000010001; //  X X X X 4 3 2 1 1
         9'b101010111: fwd_datapath_o =  36'b000000000000001100100001000000000000; //  X X X 3 2 1 0 0 0
         9'b101011000: fwd_datapath_o =  36'b000000000000000000000101010000110011; //  X X X X X 5 4 3 3
         9'b101011001: fwd_datapath_o =  36'b000000000000000001000011001000100000; //  X X X X 4 3 2 2 0
         9'b101011010: fwd_datapath_o =  36'b000000000000000001000011001000100001; //  X X X X 4 3 2 2 1
         9'b101011011: fwd_datapath_o =  36'b000000000000001100100001000100000000; //  X X X 3 2 1 1 0 0
         9'b101011100: fwd_datapath_o =  36'b000000000000000001000011001000100010; //  X X X X 4 3 2 2 2
         9'b101011101: fwd_datapath_o =  36'b000000000000001100100001000100010000; //  X X X 3 2 1 1 1 0
         9'b101011110: fwd_datapath_o =  36'b000000000000001100100001000100010001; //  X X X 3 2 1 1 1 1
         9'b101011111: fwd_datapath_o =  36'b000000000010000100000000000000000000; //  X X 2 1 0 0 0 0 0
         9'b101100000: fwd_datapath_o =  36'b000000000000000000000000011001010101; //  X X X X X X 6 5 5
         9'b101100001: fwd_datapath_o =  36'b000000000000000000000101010001000000; //  X X X X X 5 4 4 0
         9'b101100010: fwd_datapath_o =  36'b000000000000000000000101010001000001; //  X X X X X 5 4 4 1
         9'b101100011: fwd_datapath_o =  36'b000000000000000001000011001100000000; //  X X X X 4 3 3 0 0
         9'b101100100: fwd_datapath_o =  36'b000000000000000000000101010001000010; //  X X X X X 5 4 4 2
         9'b101100101: fwd_datapath_o =  36'b000000000000000001000011001100010000; //  X X X X 4 3 3 1 0
         9'b101100110: fwd_datapath_o =  36'b000000000000000001000011001100010001; //  X X X X 4 3 3 1 1
         9'b101100111: fwd_datapath_o =  36'b000000000000001100100010000000000000; //  X X X 3 2 2 0 0 0
         9'b101101000: fwd_datapath_o =  36'b000000000000000000000101010001000011; //  X X X X X 5 4 4 3
         9'b101101001: fwd_datapath_o =  36'b000000000000000001000011001100100000; //  X X X X 4 3 3 2 0
         9'b101101010: fwd_datapath_o =  36'b000000000000000001000011001100100001; //  X X X X 4 3 3 2 1
         9'b101101011: fwd_datapath_o =  36'b000000000000001100100010000100000000; //  X X X 3 2 2 1 0 0
         9'b101101100: fwd_datapath_o =  36'b000000000000000001000011001100100010; //  X X X X 4 3 3 2 2
         9'b101101101: fwd_datapath_o =  36'b000000000000001100100010000100010000; //  X X X 3 2 2 1 1 0
         9'b101101110: fwd_datapath_o =  36'b000000000000001100100010000100010001; //  X X X 3 2 2 1 1 1
         9'b101101111: fwd_datapath_o =  36'b000000000010000100010000000000000000; //  X X 2 1 1 0 0 0 0
         9'b101110000: fwd_datapath_o =  36'b000000000000000000000101010001000100; //  X X X X X 5 4 4 4
         9'b101110001: fwd_datapath_o =  36'b000000000000000001000011001100110000; //  X X X X 4 3 3 3 0
         9'b101110010: fwd_datapath_o =  36'b000000000000000001000011001100110001; //  X X X X 4 3 3 3 1
         9'b101110011: fwd_datapath_o =  36'b000000000000001100100010001000000000; //  X X X 3 2 2 2 0 0
         9'b101110100: fwd_datapath_o =  36'b000000000000000001000011001100110010; //  X X X X 4 3 3 3 2
         9'b101110101: fwd_datapath_o =  36'b000000000000001100100010001000010000; //  X X X 3 2 2 2 1 0
         9'b101110110: fwd_datapath_o =  36'b000000000000001100100010001000010001; //  X X X 3 2 2 2 1 1
         9'b101110111: fwd_datapath_o =  36'b000000000010000100010001000000000000; //  X X 2 1 1 1 0 0 0
         9'b101111000: fwd_datapath_o =  36'b000000000000000001000011001100110011; //  X X X X 4 3 3 3 3
         9'b101111001: fwd_datapath_o =  36'b000000000000001100100010001000100000; //  X X X 3 2 2 2 2 0
         9'b101111010: fwd_datapath_o =  36'b000000000000001100100010001000100001; //  X X X 3 2 2 2 2 1
         9'b101111011: fwd_datapath_o =  36'b000000000010000100010001000100000000; //  X X 2 1 1 1 1 0 0
         9'b101111100: fwd_datapath_o =  36'b000000000000001100100010001000100010; //  X X X 3 2 2 2 2 2
         9'b101111101: fwd_datapath_o =  36'b000000000010000100010001000100010000; //  X X 2 1 1 1 1 1 0
         9'b101111110: fwd_datapath_o =  36'b000000000010000100010001000100010001; //  X X 2 1 1 1 1 1 1
         9'b101111111: fwd_datapath_o =  36'b000000010000000000000000000000000000; //  X 1 0 0 0 0 0 0 0
         9'b110000000: fwd_datapath_o =  36'b000000000000000000000000000001110111; //  X X X X X X X 7 7
         9'b110000001: fwd_datapath_o =  36'b000000000000000000000000011001100000; //  X X X X X X 6 6 0
         9'b110000010: fwd_datapath_o =  36'b000000000000000000000000011001100001; //  X X X X X X 6 6 1
         9'b110000011: fwd_datapath_o =  36'b000000000000000000000101010100000000; //  X X X X X 5 5 0 0
         9'b110000100: fwd_datapath_o =  36'b000000000000000000000000011001100010; //  X X X X X X 6 6 2
         9'b110000101: fwd_datapath_o =  36'b000000000000000000000101010100010000; //  X X X X X 5 5 1 0
         9'b110000110: fwd_datapath_o =  36'b000000000000000000000101010100010001; //  X X X X X 5 5 1 1
         9'b110000111: fwd_datapath_o =  36'b000000000000000001000100000000000000; //  X X X X 4 4 0 0 0
         9'b110001000: fwd_datapath_o =  36'b000000000000000000000000011001100011; //  X X X X X X 6 6 3
         9'b110001001: fwd_datapath_o =  36'b000000000000000000000101010100100000; //  X X X X X 5 5 2 0
         9'b110001010: fwd_datapath_o =  36'b000000000000000000000101010100100001; //  X X X X X 5 5 2 1
         9'b110001011: fwd_datapath_o =  36'b000000000000000001000100000100000000; //  X X X X 4 4 1 0 0
         9'b110001100: fwd_datapath_o =  36'b000000000000000000000101010100100010; //  X X X X X 5 5 2 2
         9'b110001101: fwd_datapath_o =  36'b000000000000000001000100000100010000; //  X X X X 4 4 1 1 0
         9'b110001110: fwd_datapath_o =  36'b000000000000000001000100000100010001; //  X X X X 4 4 1 1 1
         9'b110001111: fwd_datapath_o =  36'b000000000000001100110000000000000000; //  X X X 3 3 0 0 0 0
         9'b110010000: fwd_datapath_o =  36'b000000000000000000000000011001100100; //  X X X X X X 6 6 4
         9'b110010001: fwd_datapath_o =  36'b000000000000000000000101010100110000; //  X X X X X 5 5 3 0
         9'b110010010: fwd_datapath_o =  36'b000000000000000000000101010100110001; //  X X X X X 5 5 3 1
         9'b110010011: fwd_datapath_o =  36'b000000000000000001000100001000000000; //  X X X X 4 4 2 0 0
         9'b110010100: fwd_datapath_o =  36'b000000000000000000000101010100110010; //  X X X X X 5 5 3 2
         9'b110010101: fwd_datapath_o =  36'b000000000000000001000100001000010000; //  X X X X 4 4 2 1 0
         9'b110010110: fwd_datapath_o =  36'b000000000000000001000100001000010001; //  X X X X 4 4 2 1 1
         9'b110010111: fwd_datapath_o =  36'b000000000000001100110001000000000000; //  X X X 3 3 1 0 0 0
         9'b110011000: fwd_datapath_o =  36'b000000000000000000000101010100110011; //  X X X X X 5 5 3 3
         9'b110011001: fwd_datapath_o =  36'b000000000000000001000100001000100000; //  X X X X 4 4 2 2 0
         9'b110011010: fwd_datapath_o =  36'b000000000000000001000100001000100001; //  X X X X 4 4 2 2 1
         9'b110011011: fwd_datapath_o =  36'b000000000000001100110001000100000000; //  X X X 3 3 1 1 0 0
         9'b110011100: fwd_datapath_o =  36'b000000000000000001000100001000100010; //  X X X X 4 4 2 2 2
         9'b110011101: fwd_datapath_o =  36'b000000000000001100110001000100010000; //  X X X 3 3 1 1 1 0
         9'b110011110: fwd_datapath_o =  36'b000000000000001100110001000100010001; //  X X X 3 3 1 1 1 1
         9'b110011111: fwd_datapath_o =  36'b000000000010001000000000000000000000; //  X X 2 2 0 0 0 0 0
         9'b110100000: fwd_datapath_o =  36'b000000000000000000000000011001100101; //  X X X X X X 6 6 5
         9'b110100001: fwd_datapath_o =  36'b000000000000000000000101010101000000; //  X X X X X 5 5 4 0
         9'b110100010: fwd_datapath_o =  36'b000000000000000000000101010101000001; //  X X X X X 5 5 4 1
         9'b110100011: fwd_datapath_o =  36'b000000000000000001000100001100000000; //  X X X X 4 4 3 0 0
         9'b110100100: fwd_datapath_o =  36'b000000000000000000000101010101000010; //  X X X X X 5 5 4 2
         9'b110100101: fwd_datapath_o =  36'b000000000000000001000100001100010000; //  X X X X 4 4 3 1 0
         9'b110100110: fwd_datapath_o =  36'b000000000000000001000100001100010001; //  X X X X 4 4 3 1 1
         9'b110100111: fwd_datapath_o =  36'b000000000000001100110010000000000000; //  X X X 3 3 2 0 0 0
         9'b110101000: fwd_datapath_o =  36'b000000000000000000000101010101000011; //  X X X X X 5 5 4 3
         9'b110101001: fwd_datapath_o =  36'b000000000000000001000100001100100000; //  X X X X 4 4 3 2 0
         9'b110101010: fwd_datapath_o =  36'b000000000000000001000100001100100001; //  X X X X 4 4 3 2 1
         9'b110101011: fwd_datapath_o =  36'b000000000000001100110010000100000000; //  X X X 3 3 2 1 0 0
         9'b110101100: fwd_datapath_o =  36'b000000000000000001000100001100100010; //  X X X X 4 4 3 2 2
         9'b110101101: fwd_datapath_o =  36'b000000000000001100110010000100010000; //  X X X 3 3 2 1 1 0
         9'b110101110: fwd_datapath_o =  36'b000000000000001100110010000100010001; //  X X X 3 3 2 1 1 1
         9'b110101111: fwd_datapath_o =  36'b000000000010001000010000000000000000; //  X X 2 2 1 0 0 0 0
         9'b110110000: fwd_datapath_o =  36'b000000000000000000000101010101000100; //  X X X X X 5 5 4 4
         9'b110110001: fwd_datapath_o =  36'b000000000000000001000100001100110000; //  X X X X 4 4 3 3 0
         9'b110110010: fwd_datapath_o =  36'b000000000000000001000100001100110001; //  X X X X 4 4 3 3 1
         9'b110110011: fwd_datapath_o =  36'b000000000000001100110010001000000000; //  X X X 3 3 2 2 0 0
         9'b110110100: fwd_datapath_o =  36'b000000000000000001000100001100110010; //  X X X X 4 4 3 3 2
         9'b110110101: fwd_datapath_o =  36'b000000000000001100110010001000010000; //  X X X 3 3 2 2 1 0
         9'b110110110: fwd_datapath_o =  36'b000000000000001100110010001000010001; //  X X X 3 3 2 2 1 1
         9'b110110111: fwd_datapath_o =  36'b000000000010001000010001000000000000; //  X X 2 2 1 1 0 0 0
         9'b110111000: fwd_datapath_o =  36'b000000000000000001000100001100110011; //  X X X X 4 4 3 3 3
         9'b110111001: fwd_datapath_o =  36'b000000000000001100110010001000100000; //  X X X 3 3 2 2 2 0
         9'b110111010: fwd_datapath_o =  36'b000000000000001100110010001000100001; //  X X X 3 3 2 2 2 1
         9'b110111011: fwd_datapath_o =  36'b000000000010001000010001000100000000; //  X X 2 2 1 1 1 0 0
         9'b110111100: fwd_datapath_o =  36'b000000000000001100110010001000100010; //  X X X 3 3 2 2 2 2
         9'b110111101: fwd_datapath_o =  36'b000000000010001000010001000100010000; //  X X 2 2 1 1 1 1 0
         9'b110111110: fwd_datapath_o =  36'b000000000010001000010001000100010001; //  X X 2 2 1 1 1 1 1
         9'b110111111: fwd_datapath_o =  36'b000000010001000000000000000000000000; //  X 1 1 0 0 0 0 0 0
         9'b111000000: fwd_datapath_o =  36'b000000000000000000000000011001100110; //  X X X X X X 6 6 6
         9'b111000001: fwd_datapath_o =  36'b000000000000000000000101010101010000; //  X X X X X 5 5 5 0
         9'b111000010: fwd_datapath_o =  36'b000000000000000000000101010101010001; //  X X X X X 5 5 5 1
         9'b111000011: fwd_datapath_o =  36'b000000000000000001000100010000000000; //  X X X X 4 4 4 0 0
         9'b111000100: fwd_datapath_o =  36'b000000000000000000000101010101010010; //  X X X X X 5 5 5 2
         9'b111000101: fwd_datapath_o =  36'b000000000000000001000100010000010000; //  X X X X 4 4 4 1 0
         9'b111000110: fwd_datapath_o =  36'b000000000000000001000100010000010001; //  X X X X 4 4 4 1 1
         9'b111000111: fwd_datapath_o =  36'b000000000000001100110011000000000000; //  X X X 3 3 3 0 0 0
         9'b111001000: fwd_datapath_o =  36'b000000000000000000000101010101010011; //  X X X X X 5 5 5 3
         9'b111001001: fwd_datapath_o =  36'b000000000000000001000100010000100000; //  X X X X 4 4 4 2 0
         9'b111001010: fwd_datapath_o =  36'b000000000000000001000100010000100001; //  X X X X 4 4 4 2 1
         9'b111001011: fwd_datapath_o =  36'b000000000000001100110011000100000000; //  X X X 3 3 3 1 0 0
         9'b111001100: fwd_datapath_o =  36'b000000000000000001000100010000100010; //  X X X X 4 4 4 2 2
         9'b111001101: fwd_datapath_o =  36'b000000000000001100110011000100010000; //  X X X 3 3 3 1 1 0
         9'b111001110: fwd_datapath_o =  36'b000000000000001100110011000100010001; //  X X X 3 3 3 1 1 1
         9'b111001111: fwd_datapath_o =  36'b000000000010001000100000000000000000; //  X X 2 2 2 0 0 0 0
         9'b111010000: fwd_datapath_o =  36'b000000000000000000000101010101010100; //  X X X X X 5 5 5 4
         9'b111010001: fwd_datapath_o =  36'b000000000000000001000100010000110000; //  X X X X 4 4 4 3 0
         9'b111010010: fwd_datapath_o =  36'b000000000000000001000100010000110001; //  X X X X 4 4 4 3 1
         9'b111010011: fwd_datapath_o =  36'b000000000000001100110011001000000000; //  X X X 3 3 3 2 0 0
         9'b111010100: fwd_datapath_o =  36'b000000000000000001000100010000110010; //  X X X X 4 4 4 3 2
         9'b111010101: fwd_datapath_o =  36'b000000000000001100110011001000010000; //  X X X 3 3 3 2 1 0
         9'b111010110: fwd_datapath_o =  36'b000000000000001100110011001000010001; //  X X X 3 3 3 2 1 1
         9'b111010111: fwd_datapath_o =  36'b000000000010001000100001000000000000; //  X X 2 2 2 1 0 0 0
         9'b111011000: fwd_datapath_o =  36'b000000000000000001000100010000110011; //  X X X X 4 4 4 3 3
         9'b111011001: fwd_datapath_o =  36'b000000000000001100110011001000100000; //  X X X 3 3 3 2 2 0
         9'b111011010: fwd_datapath_o =  36'b000000000000001100110011001000100001; //  X X X 3 3 3 2 2 1
         9'b111011011: fwd_datapath_o =  36'b000000000010001000100001000100000000; //  X X 2 2 2 1 1 0 0
         9'b111011100: fwd_datapath_o =  36'b000000000000001100110011001000100010; //  X X X 3 3 3 2 2 2
         9'b111011101: fwd_datapath_o =  36'b000000000010001000100001000100010000; //  X X 2 2 2 1 1 1 0
         9'b111011110: fwd_datapath_o =  36'b000000000010001000100001000100010001; //  X X 2 2 2 1 1 1 1
         9'b111011111: fwd_datapath_o =  36'b000000010001000100000000000000000000; //  X 1 1 1 0 0 0 0 0
         9'b111100000: fwd_datapath_o =  36'b000000000000000000000101010101010101; //  X X X X X 5 5 5 5
         9'b111100001: fwd_datapath_o =  36'b000000000000000001000100010001000000; //  X X X X 4 4 4 4 0
         9'b111100010: fwd_datapath_o =  36'b000000000000000001000100010001000001; //  X X X X 4 4 4 4 1
         9'b111100011: fwd_datapath_o =  36'b000000000000001100110011001100000000; //  X X X 3 3 3 3 0 0
         9'b111100100: fwd_datapath_o =  36'b000000000000000001000100010001000010; //  X X X X 4 4 4 4 2
         9'b111100101: fwd_datapath_o =  36'b000000000000001100110011001100010000; //  X X X 3 3 3 3 1 0
         9'b111100110: fwd_datapath_o =  36'b000000000000001100110011001100010001; //  X X X 3 3 3 3 1 1
         9'b111100111: fwd_datapath_o =  36'b000000000010001000100010000000000000; //  X X 2 2 2 2 0 0 0
         9'b111101000: fwd_datapath_o =  36'b000000000000000001000100010001000011; //  X X X X 4 4 4 4 3
         9'b111101001: fwd_datapath_o =  36'b000000000000001100110011001100100000; //  X X X 3 3 3 3 2 0
         9'b111101010: fwd_datapath_o =  36'b000000000000001100110011001100100001; //  X X X 3 3 3 3 2 1
         9'b111101011: fwd_datapath_o =  36'b000000000010001000100010000100000000; //  X X 2 2 2 2 1 0 0
         9'b111101100: fwd_datapath_o =  36'b000000000000001100110011001100100010; //  X X X 3 3 3 3 2 2
         9'b111101101: fwd_datapath_o =  36'b000000000010001000100010000100010000; //  X X 2 2 2 2 1 1 0
         9'b111101110: fwd_datapath_o =  36'b000000000010001000100010000100010001; //  X X 2 2 2 2 1 1 1
         9'b111101111: fwd_datapath_o =  36'b000000010001000100010000000000000000; //  X 1 1 1 1 0 0 0 0
         9'b111110000: fwd_datapath_o =  36'b000000000000000001000100010001000100; //  X X X X 4 4 4 4 4
         9'b111110001: fwd_datapath_o =  36'b000000000000001100110011001100110000; //  X X X 3 3 3 3 3 0
         9'b111110010: fwd_datapath_o =  36'b000000000000001100110011001100110001; //  X X X 3 3 3 3 3 1
         9'b111110011: fwd_datapath_o =  36'b000000000010001000100010001000000000; //  X X 2 2 2 2 2 0 0
         9'b111110100: fwd_datapath_o =  36'b000000000000001100110011001100110010; //  X X X 3 3 3 3 3 2
         9'b111110101: fwd_datapath_o =  36'b000000000010001000100010001000010000; //  X X 2 2 2 2 2 1 0
         9'b111110110: fwd_datapath_o =  36'b000000000010001000100010001000010001; //  X X 2 2 2 2 2 1 1
         9'b111110111: fwd_datapath_o =  36'b000000010001000100010001000000000000; //  X 1 1 1 1 1 0 0 0
         9'b111111000: fwd_datapath_o =  36'b000000000000001100110011001100110011; //  X X X 3 3 3 3 3 3
         9'b111111001: fwd_datapath_o =  36'b000000000010001000100010001000100000; //  X X 2 2 2 2 2 2 0
         9'b111111010: fwd_datapath_o =  36'b000000000010001000100010001000100001; //  X X 2 2 2 2 2 2 1
         9'b111111011: fwd_datapath_o =  36'b000000010001000100010001000100000000; //  X 1 1 1 1 1 1 0 0
         9'b111111100: fwd_datapath_o =  36'b000000000010001000100010001000100010; //  X X 2 2 2 2 2 2 2
         9'b111111101: fwd_datapath_o =  36'b000000010001000100010001000100010000; //  X 1 1 1 1 1 1 1 0
         9'b111111110: fwd_datapath_o =  36'b000000010001000100010001000100010001; //  X 1 1 1 1 1 1 1 1
         9'b111111111: fwd_datapath_o =  36'b000000000000000000000000000000000000; //  0 0 0 0 0 0 0 0 0
        default: fwd_datapath_o= 'X;
    endcase
  end

if (vec_size_lp == 10)
  begin
    // backward vec
    always_comb
    unique case (vec_i) 
         10'b0000000000: bk_o =  40'b1001100110011001100110011001100110011001; //  X X X X X X X X X X
         10'b0000000001: bk_o =  40'b1001100110011001100110011001100110010000; //  X X X X X X X X X 0
         10'b0000000010: bk_o =  40'b1001100110011001100110011001100100001001; //  X X X X X X X X 0 X
         10'b0000000011: bk_o =  40'b1001100110011001100110011001100100010000; //  X X X X X X X X 1 0
         10'b0000000100: bk_o =  40'b1001100110011001100110011001000010011001; //  X X X X X X X 0 X X
         10'b0000000101: bk_o =  40'b1001100110011001100110011001000110010000; //  X X X X X X X 1 X 0
         10'b0000000110: bk_o =  40'b1001100110011001100110011001000100001001; //  X X X X X X X 1 0 X
         10'b0000000111: bk_o =  40'b1001100110011001100110011001001000010000; //  X X X X X X X 2 1 0
         10'b0000001000: bk_o =  40'b1001100110011001100110010000100110011001; //  X X X X X X 0 X X X
         10'b0000001001: bk_o =  40'b1001100110011001100110010001100110010000; //  X X X X X X 1 X X 0
         10'b0000001010: bk_o =  40'b1001100110011001100110010001100100001001; //  X X X X X X 1 X 0 X
         10'b0000001011: bk_o =  40'b1001100110011001100110010010100100010000; //  X X X X X X 2 X 1 0
         10'b0000001100: bk_o =  40'b1001100110011001100110010001000010011001; //  X X X X X X 1 0 X X
         10'b0000001101: bk_o =  40'b1001100110011001100110010010000110010000; //  X X X X X X 2 1 X 0
         10'b0000001110: bk_o =  40'b1001100110011001100110010010000100001001; //  X X X X X X 2 1 0 X
         10'b0000001111: bk_o =  40'b1001100110011001100110010011001000010000; //  X X X X X X 3 2 1 0
         10'b0000010000: bk_o =  40'b1001100110011001100100001001100110011001; //  X X X X X 0 X X X X
         10'b0000010001: bk_o =  40'b1001100110011001100100011001100110010000; //  X X X X X 1 X X X 0
         10'b0000010010: bk_o =  40'b1001100110011001100100011001100100001001; //  X X X X X 1 X X 0 X
         10'b0000010011: bk_o =  40'b1001100110011001100100101001100100010000; //  X X X X X 2 X X 1 0
         10'b0000010100: bk_o =  40'b1001100110011001100100011001000010011001; //  X X X X X 1 X 0 X X
         10'b0000010101: bk_o =  40'b1001100110011001100100101001000110010000; //  X X X X X 2 X 1 X 0
         10'b0000010110: bk_o =  40'b1001100110011001100100101001000100001001; //  X X X X X 2 X 1 0 X
         10'b0000010111: bk_o =  40'b1001100110011001100100111001001000010000; //  X X X X X 3 X 2 1 0
         10'b0000011000: bk_o =  40'b1001100110011001100100010000100110011001; //  X X X X X 1 0 X X X
         10'b0000011001: bk_o =  40'b1001100110011001100100100001100110010000; //  X X X X X 2 1 X X 0
         10'b0000011010: bk_o =  40'b1001100110011001100100100001100100001001; //  X X X X X 2 1 X 0 X
         10'b0000011011: bk_o =  40'b1001100110011001100100110010100100010000; //  X X X X X 3 2 X 1 0
         10'b0000011100: bk_o =  40'b1001100110011001100100100001000010011001; //  X X X X X 2 1 0 X X
         10'b0000011101: bk_o =  40'b1001100110011001100100110010000110010000; //  X X X X X 3 2 1 X 0
         10'b0000011110: bk_o =  40'b1001100110011001100100110010000100001001; //  X X X X X 3 2 1 0 X
         10'b0000011111: bk_o =  40'b1001100110011001100101000011001000010000; //  X X X X X 4 3 2 1 0
         10'b0000100000: bk_o =  40'b1001100110011001000010011001100110011001; //  X X X X 0 X X X X X
         10'b0000100001: bk_o =  40'b1001100110011001000110011001100110010000; //  X X X X 1 X X X X 0
         10'b0000100010: bk_o =  40'b1001100110011001000110011001100100001001; //  X X X X 1 X X X 0 X
         10'b0000100011: bk_o =  40'b1001100110011001001010011001100100010000; //  X X X X 2 X X X 1 0
         10'b0000100100: bk_o =  40'b1001100110011001000110011001000010011001; //  X X X X 1 X X 0 X X
         10'b0000100101: bk_o =  40'b1001100110011001001010011001000110010000; //  X X X X 2 X X 1 X 0
         10'b0000100110: bk_o =  40'b1001100110011001001010011001000100001001; //  X X X X 2 X X 1 0 X
         10'b0000100111: bk_o =  40'b1001100110011001001110011001001000010000; //  X X X X 3 X X 2 1 0
         10'b0000101000: bk_o =  40'b1001100110011001000110010000100110011001; //  X X X X 1 X 0 X X X
         10'b0000101001: bk_o =  40'b1001100110011001001010010001100110010000; //  X X X X 2 X 1 X X 0
         10'b0000101010: bk_o =  40'b1001100110011001001010010001100100001001; //  X X X X 2 X 1 X 0 X
         10'b0000101011: bk_o =  40'b1001100110011001001110010010100100010000; //  X X X X 3 X 2 X 1 0
         10'b0000101100: bk_o =  40'b1001100110011001001010010001000010011001; //  X X X X 2 X 1 0 X X
         10'b0000101101: bk_o =  40'b1001100110011001001110010010000110010000; //  X X X X 3 X 2 1 X 0
         10'b0000101110: bk_o =  40'b1001100110011001001110010010000100001001; //  X X X X 3 X 2 1 0 X
         10'b0000101111: bk_o =  40'b1001100110011001010010010011001000010000; //  X X X X 4 X 3 2 1 0
         10'b0000110000: bk_o =  40'b1001100110011001000100001001100110011001; //  X X X X 1 0 X X X X
         10'b0000110001: bk_o =  40'b1001100110011001001000011001100110010000; //  X X X X 2 1 X X X 0
         10'b0000110010: bk_o =  40'b1001100110011001001000011001100100001001; //  X X X X 2 1 X X 0 X
         10'b0000110011: bk_o =  40'b1001100110011001001100101001100100010000; //  X X X X 3 2 X X 1 0
         10'b0000110100: bk_o =  40'b1001100110011001001000011001000010011001; //  X X X X 2 1 X 0 X X
         10'b0000110101: bk_o =  40'b1001100110011001001100101001000110010000; //  X X X X 3 2 X 1 X 0
         10'b0000110110: bk_o =  40'b1001100110011001001100101001000100001001; //  X X X X 3 2 X 1 0 X
         10'b0000110111: bk_o =  40'b1001100110011001010000111001001000010000; //  X X X X 4 3 X 2 1 0
         10'b0000111000: bk_o =  40'b1001100110011001001000010000100110011001; //  X X X X 2 1 0 X X X
         10'b0000111001: bk_o =  40'b1001100110011001001100100001100110010000; //  X X X X 3 2 1 X X 0
         10'b0000111010: bk_o =  40'b1001100110011001001100100001100100001001; //  X X X X 3 2 1 X 0 X
         10'b0000111011: bk_o =  40'b1001100110011001010000110010100100010000; //  X X X X 4 3 2 X 1 0
         10'b0000111100: bk_o =  40'b1001100110011001001100100001000010011001; //  X X X X 3 2 1 0 X X
         10'b0000111101: bk_o =  40'b1001100110011001010000110010000110010000; //  X X X X 4 3 2 1 X 0
         10'b0000111110: bk_o =  40'b1001100110011001010000110010000100001001; //  X X X X 4 3 2 1 0 X
         10'b0000111111: bk_o =  40'b1001100110011001010101000011001000010000; //  X X X X 5 4 3 2 1 0
         10'b0001000000: bk_o =  40'b1001100110010000100110011001100110011001; //  X X X 0 X X X X X X
         10'b0001000001: bk_o =  40'b1001100110010001100110011001100110010000; //  X X X 1 X X X X X 0
         10'b0001000010: bk_o =  40'b1001100110010001100110011001100100001001; //  X X X 1 X X X X 0 X
         10'b0001000011: bk_o =  40'b1001100110010010100110011001100100010000; //  X X X 2 X X X X 1 0
         10'b0001000100: bk_o =  40'b1001100110010001100110011001000010011001; //  X X X 1 X X X 0 X X
         10'b0001000101: bk_o =  40'b1001100110010010100110011001000110010000; //  X X X 2 X X X 1 X 0
         10'b0001000110: bk_o =  40'b1001100110010010100110011001000100001001; //  X X X 2 X X X 1 0 X
         10'b0001000111: bk_o =  40'b1001100110010011100110011001001000010000; //  X X X 3 X X X 2 1 0
         10'b0001001000: bk_o =  40'b1001100110010001100110010000100110011001; //  X X X 1 X X 0 X X X
         10'b0001001001: bk_o =  40'b1001100110010010100110010001100110010000; //  X X X 2 X X 1 X X 0
         10'b0001001010: bk_o =  40'b1001100110010010100110010001100100001001; //  X X X 2 X X 1 X 0 X
         10'b0001001011: bk_o =  40'b1001100110010011100110010010100100010000; //  X X X 3 X X 2 X 1 0
         10'b0001001100: bk_o =  40'b1001100110010010100110010001000010011001; //  X X X 2 X X 1 0 X X
         10'b0001001101: bk_o =  40'b1001100110010011100110010010000110010000; //  X X X 3 X X 2 1 X 0
         10'b0001001110: bk_o =  40'b1001100110010011100110010010000100001001; //  X X X 3 X X 2 1 0 X
         10'b0001001111: bk_o =  40'b1001100110010100100110010011001000010000; //  X X X 4 X X 3 2 1 0
         10'b0001010000: bk_o =  40'b1001100110010001100100001001100110011001; //  X X X 1 X 0 X X X X
         10'b0001010001: bk_o =  40'b1001100110010010100100011001100110010000; //  X X X 2 X 1 X X X 0
         10'b0001010010: bk_o =  40'b1001100110010010100100011001100100001001; //  X X X 2 X 1 X X 0 X
         10'b0001010011: bk_o =  40'b1001100110010011100100101001100100010000; //  X X X 3 X 2 X X 1 0
         10'b0001010100: bk_o =  40'b1001100110010010100100011001000010011001; //  X X X 2 X 1 X 0 X X
         10'b0001010101: bk_o =  40'b1001100110010011100100101001000110010000; //  X X X 3 X 2 X 1 X 0
         10'b0001010110: bk_o =  40'b1001100110010011100100101001000100001001; //  X X X 3 X 2 X 1 0 X
         10'b0001010111: bk_o =  40'b1001100110010100100100111001001000010000; //  X X X 4 X 3 X 2 1 0
         10'b0001011000: bk_o =  40'b1001100110010010100100010000100110011001; //  X X X 2 X 1 0 X X X
         10'b0001011001: bk_o =  40'b1001100110010011100100100001100110010000; //  X X X 3 X 2 1 X X 0
         10'b0001011010: bk_o =  40'b1001100110010011100100100001100100001001; //  X X X 3 X 2 1 X 0 X
         10'b0001011011: bk_o =  40'b1001100110010100100100110010100100010000; //  X X X 4 X 3 2 X 1 0
         10'b0001011100: bk_o =  40'b1001100110010011100100100001000010011001; //  X X X 3 X 2 1 0 X X
         10'b0001011101: bk_o =  40'b1001100110010100100100110010000110010000; //  X X X 4 X 3 2 1 X 0
         10'b0001011110: bk_o =  40'b1001100110010100100100110010000100001001; //  X X X 4 X 3 2 1 0 X
         10'b0001011111: bk_o =  40'b1001100110010101100101000011001000010000; //  X X X 5 X 4 3 2 1 0
         10'b0001100000: bk_o =  40'b1001100110010001000010011001100110011001; //  X X X 1 0 X X X X X
         10'b0001100001: bk_o =  40'b1001100110010010000110011001100110010000; //  X X X 2 1 X X X X 0
         10'b0001100010: bk_o =  40'b1001100110010010000110011001100100001001; //  X X X 2 1 X X X 0 X
         10'b0001100011: bk_o =  40'b1001100110010011001010011001100100010000; //  X X X 3 2 X X X 1 0
         10'b0001100100: bk_o =  40'b1001100110010010000110011001000010011001; //  X X X 2 1 X X 0 X X
         10'b0001100101: bk_o =  40'b1001100110010011001010011001000110010000; //  X X X 3 2 X X 1 X 0
         10'b0001100110: bk_o =  40'b1001100110010011001010011001000100001001; //  X X X 3 2 X X 1 0 X
         10'b0001100111: bk_o =  40'b1001100110010100001110011001001000010000; //  X X X 4 3 X X 2 1 0
         10'b0001101000: bk_o =  40'b1001100110010010000110010000100110011001; //  X X X 2 1 X 0 X X X
         10'b0001101001: bk_o =  40'b1001100110010011001010010001100110010000; //  X X X 3 2 X 1 X X 0
         10'b0001101010: bk_o =  40'b1001100110010011001010010001100100001001; //  X X X 3 2 X 1 X 0 X
         10'b0001101011: bk_o =  40'b1001100110010100001110010010100100010000; //  X X X 4 3 X 2 X 1 0
         10'b0001101100: bk_o =  40'b1001100110010011001010010001000010011001; //  X X X 3 2 X 1 0 X X
         10'b0001101101: bk_o =  40'b1001100110010100001110010010000110010000; //  X X X 4 3 X 2 1 X 0
         10'b0001101110: bk_o =  40'b1001100110010100001110010010000100001001; //  X X X 4 3 X 2 1 0 X
         10'b0001101111: bk_o =  40'b1001100110010101010010010011001000010000; //  X X X 5 4 X 3 2 1 0
         10'b0001110000: bk_o =  40'b1001100110010010000100001001100110011001; //  X X X 2 1 0 X X X X
         10'b0001110001: bk_o =  40'b1001100110010011001000011001100110010000; //  X X X 3 2 1 X X X 0
         10'b0001110010: bk_o =  40'b1001100110010011001000011001100100001001; //  X X X 3 2 1 X X 0 X
         10'b0001110011: bk_o =  40'b1001100110010100001100101001100100010000; //  X X X 4 3 2 X X 1 0
         10'b0001110100: bk_o =  40'b1001100110010011001000011001000010011001; //  X X X 3 2 1 X 0 X X
         10'b0001110101: bk_o =  40'b1001100110010100001100101001000110010000; //  X X X 4 3 2 X 1 X 0
         10'b0001110110: bk_o =  40'b1001100110010100001100101001000100001001; //  X X X 4 3 2 X 1 0 X
         10'b0001110111: bk_o =  40'b1001100110010101010000111001001000010000; //  X X X 5 4 3 X 2 1 0
         10'b0001111000: bk_o =  40'b1001100110010011001000010000100110011001; //  X X X 3 2 1 0 X X X
         10'b0001111001: bk_o =  40'b1001100110010100001100100001100110010000; //  X X X 4 3 2 1 X X 0
         10'b0001111010: bk_o =  40'b1001100110010100001100100001100100001001; //  X X X 4 3 2 1 X 0 X
         10'b0001111011: bk_o =  40'b1001100110010101010000110010100100010000; //  X X X 5 4 3 2 X 1 0
         10'b0001111100: bk_o =  40'b1001100110010100001100100001000010011001; //  X X X 4 3 2 1 0 X X
         10'b0001111101: bk_o =  40'b1001100110010101010000110010000110010000; //  X X X 5 4 3 2 1 X 0
         10'b0001111110: bk_o =  40'b1001100110010101010000110010000100001001; //  X X X 5 4 3 2 1 0 X
         10'b0001111111: bk_o =  40'b1001100110010110010101000011001000010000; //  X X X 6 5 4 3 2 1 0
         10'b0010000000: bk_o =  40'b1001100100001001100110011001100110011001; //  X X 0 X X X X X X X
         10'b0010000001: bk_o =  40'b1001100100011001100110011001100110010000; //  X X 1 X X X X X X 0
         10'b0010000010: bk_o =  40'b1001100100011001100110011001100100001001; //  X X 1 X X X X X 0 X
         10'b0010000011: bk_o =  40'b1001100100101001100110011001100100010000; //  X X 2 X X X X X 1 0
         10'b0010000100: bk_o =  40'b1001100100011001100110011001000010011001; //  X X 1 X X X X 0 X X
         10'b0010000101: bk_o =  40'b1001100100101001100110011001000110010000; //  X X 2 X X X X 1 X 0
         10'b0010000110: bk_o =  40'b1001100100101001100110011001000100001001; //  X X 2 X X X X 1 0 X
         10'b0010000111: bk_o =  40'b1001100100111001100110011001001000010000; //  X X 3 X X X X 2 1 0
         10'b0010001000: bk_o =  40'b1001100100011001100110010000100110011001; //  X X 1 X X X 0 X X X
         10'b0010001001: bk_o =  40'b1001100100101001100110010001100110010000; //  X X 2 X X X 1 X X 0
         10'b0010001010: bk_o =  40'b1001100100101001100110010001100100001001; //  X X 2 X X X 1 X 0 X
         10'b0010001011: bk_o =  40'b1001100100111001100110010010100100010000; //  X X 3 X X X 2 X 1 0
         10'b0010001100: bk_o =  40'b1001100100101001100110010001000010011001; //  X X 2 X X X 1 0 X X
         10'b0010001101: bk_o =  40'b1001100100111001100110010010000110010000; //  X X 3 X X X 2 1 X 0
         10'b0010001110: bk_o =  40'b1001100100111001100110010010000100001001; //  X X 3 X X X 2 1 0 X
         10'b0010001111: bk_o =  40'b1001100101001001100110010011001000010000; //  X X 4 X X X 3 2 1 0
         10'b0010010000: bk_o =  40'b1001100100011001100100001001100110011001; //  X X 1 X X 0 X X X X
         10'b0010010001: bk_o =  40'b1001100100101001100100011001100110010000; //  X X 2 X X 1 X X X 0
         10'b0010010010: bk_o =  40'b1001100100101001100100011001100100001001; //  X X 2 X X 1 X X 0 X
         10'b0010010011: bk_o =  40'b1001100100111001100100101001100100010000; //  X X 3 X X 2 X X 1 0
         10'b0010010100: bk_o =  40'b1001100100101001100100011001000010011001; //  X X 2 X X 1 X 0 X X
         10'b0010010101: bk_o =  40'b1001100100111001100100101001000110010000; //  X X 3 X X 2 X 1 X 0
         10'b0010010110: bk_o =  40'b1001100100111001100100101001000100001001; //  X X 3 X X 2 X 1 0 X
         10'b0010010111: bk_o =  40'b1001100101001001100100111001001000010000; //  X X 4 X X 3 X 2 1 0
         10'b0010011000: bk_o =  40'b1001100100101001100100010000100110011001; //  X X 2 X X 1 0 X X X
         10'b0010011001: bk_o =  40'b1001100100111001100100100001100110010000; //  X X 3 X X 2 1 X X 0
         10'b0010011010: bk_o =  40'b1001100100111001100100100001100100001001; //  X X 3 X X 2 1 X 0 X
         10'b0010011011: bk_o =  40'b1001100101001001100100110010100100010000; //  X X 4 X X 3 2 X 1 0
         10'b0010011100: bk_o =  40'b1001100100111001100100100001000010011001; //  X X 3 X X 2 1 0 X X
         10'b0010011101: bk_o =  40'b1001100101001001100100110010000110010000; //  X X 4 X X 3 2 1 X 0
         10'b0010011110: bk_o =  40'b1001100101001001100100110010000100001001; //  X X 4 X X 3 2 1 0 X
         10'b0010011111: bk_o =  40'b1001100101011001100101000011001000010000; //  X X 5 X X 4 3 2 1 0
         10'b0010100000: bk_o =  40'b1001100100011001000010011001100110011001; //  X X 1 X 0 X X X X X
         10'b0010100001: bk_o =  40'b1001100100101001000110011001100110010000; //  X X 2 X 1 X X X X 0
         10'b0010100010: bk_o =  40'b1001100100101001000110011001100100001001; //  X X 2 X 1 X X X 0 X
         10'b0010100011: bk_o =  40'b1001100100111001001010011001100100010000; //  X X 3 X 2 X X X 1 0
         10'b0010100100: bk_o =  40'b1001100100101001000110011001000010011001; //  X X 2 X 1 X X 0 X X
         10'b0010100101: bk_o =  40'b1001100100111001001010011001000110010000; //  X X 3 X 2 X X 1 X 0
         10'b0010100110: bk_o =  40'b1001100100111001001010011001000100001001; //  X X 3 X 2 X X 1 0 X
         10'b0010100111: bk_o =  40'b1001100101001001001110011001001000010000; //  X X 4 X 3 X X 2 1 0
         10'b0010101000: bk_o =  40'b1001100100101001000110010000100110011001; //  X X 2 X 1 X 0 X X X
         10'b0010101001: bk_o =  40'b1001100100111001001010010001100110010000; //  X X 3 X 2 X 1 X X 0
         10'b0010101010: bk_o =  40'b1001100100111001001010010001100100001001; //  X X 3 X 2 X 1 X 0 X
         10'b0010101011: bk_o =  40'b1001100101001001001110010010100100010000; //  X X 4 X 3 X 2 X 1 0
         10'b0010101100: bk_o =  40'b1001100100111001001010010001000010011001; //  X X 3 X 2 X 1 0 X X
         10'b0010101101: bk_o =  40'b1001100101001001001110010010000110010000; //  X X 4 X 3 X 2 1 X 0
         10'b0010101110: bk_o =  40'b1001100101001001001110010010000100001001; //  X X 4 X 3 X 2 1 0 X
         10'b0010101111: bk_o =  40'b1001100101011001010010010011001000010000; //  X X 5 X 4 X 3 2 1 0
         10'b0010110000: bk_o =  40'b1001100100101001000100001001100110011001; //  X X 2 X 1 0 X X X X
         10'b0010110001: bk_o =  40'b1001100100111001001000011001100110010000; //  X X 3 X 2 1 X X X 0
         10'b0010110010: bk_o =  40'b1001100100111001001000011001100100001001; //  X X 3 X 2 1 X X 0 X
         10'b0010110011: bk_o =  40'b1001100101001001001100101001100100010000; //  X X 4 X 3 2 X X 1 0
         10'b0010110100: bk_o =  40'b1001100100111001001000011001000010011001; //  X X 3 X 2 1 X 0 X X
         10'b0010110101: bk_o =  40'b1001100101001001001100101001000110010000; //  X X 4 X 3 2 X 1 X 0
         10'b0010110110: bk_o =  40'b1001100101001001001100101001000100001001; //  X X 4 X 3 2 X 1 0 X
         10'b0010110111: bk_o =  40'b1001100101011001010000111001001000010000; //  X X 5 X 4 3 X 2 1 0
         10'b0010111000: bk_o =  40'b1001100100111001001000010000100110011001; //  X X 3 X 2 1 0 X X X
         10'b0010111001: bk_o =  40'b1001100101001001001100100001100110010000; //  X X 4 X 3 2 1 X X 0
         10'b0010111010: bk_o =  40'b1001100101001001001100100001100100001001; //  X X 4 X 3 2 1 X 0 X
         10'b0010111011: bk_o =  40'b1001100101011001010000110010100100010000; //  X X 5 X 4 3 2 X 1 0
         10'b0010111100: bk_o =  40'b1001100101001001001100100001000010011001; //  X X 4 X 3 2 1 0 X X
         10'b0010111101: bk_o =  40'b1001100101011001010000110010000110010000; //  X X 5 X 4 3 2 1 X 0
         10'b0010111110: bk_o =  40'b1001100101011001010000110010000100001001; //  X X 5 X 4 3 2 1 0 X
         10'b0010111111: bk_o =  40'b1001100101101001010101000011001000010000; //  X X 6 X 5 4 3 2 1 0
         10'b0011000000: bk_o =  40'b1001100100010000100110011001100110011001; //  X X 1 0 X X X X X X
         10'b0011000001: bk_o =  40'b1001100100100001100110011001100110010000; //  X X 2 1 X X X X X 0
         10'b0011000010: bk_o =  40'b1001100100100001100110011001100100001001; //  X X 2 1 X X X X 0 X
         10'b0011000011: bk_o =  40'b1001100100110010100110011001100100010000; //  X X 3 2 X X X X 1 0
         10'b0011000100: bk_o =  40'b1001100100100001100110011001000010011001; //  X X 2 1 X X X 0 X X
         10'b0011000101: bk_o =  40'b1001100100110010100110011001000110010000; //  X X 3 2 X X X 1 X 0
         10'b0011000110: bk_o =  40'b1001100100110010100110011001000100001001; //  X X 3 2 X X X 1 0 X
         10'b0011000111: bk_o =  40'b1001100101000011100110011001001000010000; //  X X 4 3 X X X 2 1 0
         10'b0011001000: bk_o =  40'b1001100100100001100110010000100110011001; //  X X 2 1 X X 0 X X X
         10'b0011001001: bk_o =  40'b1001100100110010100110010001100110010000; //  X X 3 2 X X 1 X X 0
         10'b0011001010: bk_o =  40'b1001100100110010100110010001100100001001; //  X X 3 2 X X 1 X 0 X
         10'b0011001011: bk_o =  40'b1001100101000011100110010010100100010000; //  X X 4 3 X X 2 X 1 0
         10'b0011001100: bk_o =  40'b1001100100110010100110010001000010011001; //  X X 3 2 X X 1 0 X X
         10'b0011001101: bk_o =  40'b1001100101000011100110010010000110010000; //  X X 4 3 X X 2 1 X 0
         10'b0011001110: bk_o =  40'b1001100101000011100110010010000100001001; //  X X 4 3 X X 2 1 0 X
         10'b0011001111: bk_o =  40'b1001100101010100100110010011001000010000; //  X X 5 4 X X 3 2 1 0
         10'b0011010000: bk_o =  40'b1001100100100001100100001001100110011001; //  X X 2 1 X 0 X X X X
         10'b0011010001: bk_o =  40'b1001100100110010100100011001100110010000; //  X X 3 2 X 1 X X X 0
         10'b0011010010: bk_o =  40'b1001100100110010100100011001100100001001; //  X X 3 2 X 1 X X 0 X
         10'b0011010011: bk_o =  40'b1001100101000011100100101001100100010000; //  X X 4 3 X 2 X X 1 0
         10'b0011010100: bk_o =  40'b1001100100110010100100011001000010011001; //  X X 3 2 X 1 X 0 X X
         10'b0011010101: bk_o =  40'b1001100101000011100100101001000110010000; //  X X 4 3 X 2 X 1 X 0
         10'b0011010110: bk_o =  40'b1001100101000011100100101001000100001001; //  X X 4 3 X 2 X 1 0 X
         10'b0011010111: bk_o =  40'b1001100101010100100100111001001000010000; //  X X 5 4 X 3 X 2 1 0
         10'b0011011000: bk_o =  40'b1001100100110010100100010000100110011001; //  X X 3 2 X 1 0 X X X
         10'b0011011001: bk_o =  40'b1001100101000011100100100001100110010000; //  X X 4 3 X 2 1 X X 0
         10'b0011011010: bk_o =  40'b1001100101000011100100100001100100001001; //  X X 4 3 X 2 1 X 0 X
         10'b0011011011: bk_o =  40'b1001100101010100100100110010100100010000; //  X X 5 4 X 3 2 X 1 0
         10'b0011011100: bk_o =  40'b1001100101000011100100100001000010011001; //  X X 4 3 X 2 1 0 X X
         10'b0011011101: bk_o =  40'b1001100101010100100100110010000110010000; //  X X 5 4 X 3 2 1 X 0
         10'b0011011110: bk_o =  40'b1001100101010100100100110010000100001001; //  X X 5 4 X 3 2 1 0 X
         10'b0011011111: bk_o =  40'b1001100101100101100101000011001000010000; //  X X 6 5 X 4 3 2 1 0
         10'b0011100000: bk_o =  40'b1001100100100001000010011001100110011001; //  X X 2 1 0 X X X X X
         10'b0011100001: bk_o =  40'b1001100100110010000110011001100110010000; //  X X 3 2 1 X X X X 0
         10'b0011100010: bk_o =  40'b1001100100110010000110011001100100001001; //  X X 3 2 1 X X X 0 X
         10'b0011100011: bk_o =  40'b1001100101000011001010011001100100010000; //  X X 4 3 2 X X X 1 0
         10'b0011100100: bk_o =  40'b1001100100110010000110011001000010011001; //  X X 3 2 1 X X 0 X X
         10'b0011100101: bk_o =  40'b1001100101000011001010011001000110010000; //  X X 4 3 2 X X 1 X 0
         10'b0011100110: bk_o =  40'b1001100101000011001010011001000100001001; //  X X 4 3 2 X X 1 0 X
         10'b0011100111: bk_o =  40'b1001100101010100001110011001001000010000; //  X X 5 4 3 X X 2 1 0
         10'b0011101000: bk_o =  40'b1001100100110010000110010000100110011001; //  X X 3 2 1 X 0 X X X
         10'b0011101001: bk_o =  40'b1001100101000011001010010001100110010000; //  X X 4 3 2 X 1 X X 0
         10'b0011101010: bk_o =  40'b1001100101000011001010010001100100001001; //  X X 4 3 2 X 1 X 0 X
         10'b0011101011: bk_o =  40'b1001100101010100001110010010100100010000; //  X X 5 4 3 X 2 X 1 0
         10'b0011101100: bk_o =  40'b1001100101000011001010010001000010011001; //  X X 4 3 2 X 1 0 X X
         10'b0011101101: bk_o =  40'b1001100101010100001110010010000110010000; //  X X 5 4 3 X 2 1 X 0
         10'b0011101110: bk_o =  40'b1001100101010100001110010010000100001001; //  X X 5 4 3 X 2 1 0 X
         10'b0011101111: bk_o =  40'b1001100101100101010010010011001000010000; //  X X 6 5 4 X 3 2 1 0
         10'b0011110000: bk_o =  40'b1001100100110010000100001001100110011001; //  X X 3 2 1 0 X X X X
         10'b0011110001: bk_o =  40'b1001100101000011001000011001100110010000; //  X X 4 3 2 1 X X X 0
         10'b0011110010: bk_o =  40'b1001100101000011001000011001100100001001; //  X X 4 3 2 1 X X 0 X
         10'b0011110011: bk_o =  40'b1001100101010100001100101001100100010000; //  X X 5 4 3 2 X X 1 0
         10'b0011110100: bk_o =  40'b1001100101000011001000011001000010011001; //  X X 4 3 2 1 X 0 X X
         10'b0011110101: bk_o =  40'b1001100101010100001100101001000110010000; //  X X 5 4 3 2 X 1 X 0
         10'b0011110110: bk_o =  40'b1001100101010100001100101001000100001001; //  X X 5 4 3 2 X 1 0 X
         10'b0011110111: bk_o =  40'b1001100101100101010000111001001000010000; //  X X 6 5 4 3 X 2 1 0
         10'b0011111000: bk_o =  40'b1001100101000011001000010000100110011001; //  X X 4 3 2 1 0 X X X
         10'b0011111001: bk_o =  40'b1001100101010100001100100001100110010000; //  X X 5 4 3 2 1 X X 0
         10'b0011111010: bk_o =  40'b1001100101010100001100100001100100001001; //  X X 5 4 3 2 1 X 0 X
         10'b0011111011: bk_o =  40'b1001100101100101010000110010100100010000; //  X X 6 5 4 3 2 X 1 0
         10'b0011111100: bk_o =  40'b1001100101010100001100100001000010011001; //  X X 5 4 3 2 1 0 X X
         10'b0011111101: bk_o =  40'b1001100101100101010000110010000110010000; //  X X 6 5 4 3 2 1 X 0
         10'b0011111110: bk_o =  40'b1001100101100101010000110010000100001001; //  X X 6 5 4 3 2 1 0 X
         10'b0011111111: bk_o =  40'b1001100101110110010101000011001000010000; //  X X 7 6 5 4 3 2 1 0
         10'b0100000000: bk_o =  40'b1001000010011001100110011001100110011001; //  X 0 X X X X X X X X
         10'b0100000001: bk_o =  40'b1001000110011001100110011001100110010000; //  X 1 X X X X X X X 0
         10'b0100000010: bk_o =  40'b1001000110011001100110011001100100001001; //  X 1 X X X X X X 0 X
         10'b0100000011: bk_o =  40'b1001001010011001100110011001100100010000; //  X 2 X X X X X X 1 0
         10'b0100000100: bk_o =  40'b1001000110011001100110011001000010011001; //  X 1 X X X X X 0 X X
         10'b0100000101: bk_o =  40'b1001001010011001100110011001000110010000; //  X 2 X X X X X 1 X 0
         10'b0100000110: bk_o =  40'b1001001010011001100110011001000100001001; //  X 2 X X X X X 1 0 X
         10'b0100000111: bk_o =  40'b1001001110011001100110011001001000010000; //  X 3 X X X X X 2 1 0
         10'b0100001000: bk_o =  40'b1001000110011001100110010000100110011001; //  X 1 X X X X 0 X X X
         10'b0100001001: bk_o =  40'b1001001010011001100110010001100110010000; //  X 2 X X X X 1 X X 0
         10'b0100001010: bk_o =  40'b1001001010011001100110010001100100001001; //  X 2 X X X X 1 X 0 X
         10'b0100001011: bk_o =  40'b1001001110011001100110010010100100010000; //  X 3 X X X X 2 X 1 0
         10'b0100001100: bk_o =  40'b1001001010011001100110010001000010011001; //  X 2 X X X X 1 0 X X
         10'b0100001101: bk_o =  40'b1001001110011001100110010010000110010000; //  X 3 X X X X 2 1 X 0
         10'b0100001110: bk_o =  40'b1001001110011001100110010010000100001001; //  X 3 X X X X 2 1 0 X
         10'b0100001111: bk_o =  40'b1001010010011001100110010011001000010000; //  X 4 X X X X 3 2 1 0
         10'b0100010000: bk_o =  40'b1001000110011001100100001001100110011001; //  X 1 X X X 0 X X X X
         10'b0100010001: bk_o =  40'b1001001010011001100100011001100110010000; //  X 2 X X X 1 X X X 0
         10'b0100010010: bk_o =  40'b1001001010011001100100011001100100001001; //  X 2 X X X 1 X X 0 X
         10'b0100010011: bk_o =  40'b1001001110011001100100101001100100010000; //  X 3 X X X 2 X X 1 0
         10'b0100010100: bk_o =  40'b1001001010011001100100011001000010011001; //  X 2 X X X 1 X 0 X X
         10'b0100010101: bk_o =  40'b1001001110011001100100101001000110010000; //  X 3 X X X 2 X 1 X 0
         10'b0100010110: bk_o =  40'b1001001110011001100100101001000100001001; //  X 3 X X X 2 X 1 0 X
         10'b0100010111: bk_o =  40'b1001010010011001100100111001001000010000; //  X 4 X X X 3 X 2 1 0
         10'b0100011000: bk_o =  40'b1001001010011001100100010000100110011001; //  X 2 X X X 1 0 X X X
         10'b0100011001: bk_o =  40'b1001001110011001100100100001100110010000; //  X 3 X X X 2 1 X X 0
         10'b0100011010: bk_o =  40'b1001001110011001100100100001100100001001; //  X 3 X X X 2 1 X 0 X
         10'b0100011011: bk_o =  40'b1001010010011001100100110010100100010000; //  X 4 X X X 3 2 X 1 0
         10'b0100011100: bk_o =  40'b1001001110011001100100100001000010011001; //  X 3 X X X 2 1 0 X X
         10'b0100011101: bk_o =  40'b1001010010011001100100110010000110010000; //  X 4 X X X 3 2 1 X 0
         10'b0100011110: bk_o =  40'b1001010010011001100100110010000100001001; //  X 4 X X X 3 2 1 0 X
         10'b0100011111: bk_o =  40'b1001010110011001100101000011001000010000; //  X 5 X X X 4 3 2 1 0
         10'b0100100000: bk_o =  40'b1001000110011001000010011001100110011001; //  X 1 X X 0 X X X X X
         10'b0100100001: bk_o =  40'b1001001010011001000110011001100110010000; //  X 2 X X 1 X X X X 0
         10'b0100100010: bk_o =  40'b1001001010011001000110011001100100001001; //  X 2 X X 1 X X X 0 X
         10'b0100100011: bk_o =  40'b1001001110011001001010011001100100010000; //  X 3 X X 2 X X X 1 0
         10'b0100100100: bk_o =  40'b1001001010011001000110011001000010011001; //  X 2 X X 1 X X 0 X X
         10'b0100100101: bk_o =  40'b1001001110011001001010011001000110010000; //  X 3 X X 2 X X 1 X 0
         10'b0100100110: bk_o =  40'b1001001110011001001010011001000100001001; //  X 3 X X 2 X X 1 0 X
         10'b0100100111: bk_o =  40'b1001010010011001001110011001001000010000; //  X 4 X X 3 X X 2 1 0
         10'b0100101000: bk_o =  40'b1001001010011001000110010000100110011001; //  X 2 X X 1 X 0 X X X
         10'b0100101001: bk_o =  40'b1001001110011001001010010001100110010000; //  X 3 X X 2 X 1 X X 0
         10'b0100101010: bk_o =  40'b1001001110011001001010010001100100001001; //  X 3 X X 2 X 1 X 0 X
         10'b0100101011: bk_o =  40'b1001010010011001001110010010100100010000; //  X 4 X X 3 X 2 X 1 0
         10'b0100101100: bk_o =  40'b1001001110011001001010010001000010011001; //  X 3 X X 2 X 1 0 X X
         10'b0100101101: bk_o =  40'b1001010010011001001110010010000110010000; //  X 4 X X 3 X 2 1 X 0
         10'b0100101110: bk_o =  40'b1001010010011001001110010010000100001001; //  X 4 X X 3 X 2 1 0 X
         10'b0100101111: bk_o =  40'b1001010110011001010010010011001000010000; //  X 5 X X 4 X 3 2 1 0
         10'b0100110000: bk_o =  40'b1001001010011001000100001001100110011001; //  X 2 X X 1 0 X X X X
         10'b0100110001: bk_o =  40'b1001001110011001001000011001100110010000; //  X 3 X X 2 1 X X X 0
         10'b0100110010: bk_o =  40'b1001001110011001001000011001100100001001; //  X 3 X X 2 1 X X 0 X
         10'b0100110011: bk_o =  40'b1001010010011001001100101001100100010000; //  X 4 X X 3 2 X X 1 0
         10'b0100110100: bk_o =  40'b1001001110011001001000011001000010011001; //  X 3 X X 2 1 X 0 X X
         10'b0100110101: bk_o =  40'b1001010010011001001100101001000110010000; //  X 4 X X 3 2 X 1 X 0
         10'b0100110110: bk_o =  40'b1001010010011001001100101001000100001001; //  X 4 X X 3 2 X 1 0 X
         10'b0100110111: bk_o =  40'b1001010110011001010000111001001000010000; //  X 5 X X 4 3 X 2 1 0
         10'b0100111000: bk_o =  40'b1001001110011001001000010000100110011001; //  X 3 X X 2 1 0 X X X
         10'b0100111001: bk_o =  40'b1001010010011001001100100001100110010000; //  X 4 X X 3 2 1 X X 0
         10'b0100111010: bk_o =  40'b1001010010011001001100100001100100001001; //  X 4 X X 3 2 1 X 0 X
         10'b0100111011: bk_o =  40'b1001010110011001010000110010100100010000; //  X 5 X X 4 3 2 X 1 0
         10'b0100111100: bk_o =  40'b1001010010011001001100100001000010011001; //  X 4 X X 3 2 1 0 X X
         10'b0100111101: bk_o =  40'b1001010110011001010000110010000110010000; //  X 5 X X 4 3 2 1 X 0
         10'b0100111110: bk_o =  40'b1001010110011001010000110010000100001001; //  X 5 X X 4 3 2 1 0 X
         10'b0100111111: bk_o =  40'b1001011010011001010101000011001000010000; //  X 6 X X 5 4 3 2 1 0
         10'b0101000000: bk_o =  40'b1001000110010000100110011001100110011001; //  X 1 X 0 X X X X X X
         10'b0101000001: bk_o =  40'b1001001010010001100110011001100110010000; //  X 2 X 1 X X X X X 0
         10'b0101000010: bk_o =  40'b1001001010010001100110011001100100001001; //  X 2 X 1 X X X X 0 X
         10'b0101000011: bk_o =  40'b1001001110010010100110011001100100010000; //  X 3 X 2 X X X X 1 0
         10'b0101000100: bk_o =  40'b1001001010010001100110011001000010011001; //  X 2 X 1 X X X 0 X X
         10'b0101000101: bk_o =  40'b1001001110010010100110011001000110010000; //  X 3 X 2 X X X 1 X 0
         10'b0101000110: bk_o =  40'b1001001110010010100110011001000100001001; //  X 3 X 2 X X X 1 0 X
         10'b0101000111: bk_o =  40'b1001010010010011100110011001001000010000; //  X 4 X 3 X X X 2 1 0
         10'b0101001000: bk_o =  40'b1001001010010001100110010000100110011001; //  X 2 X 1 X X 0 X X X
         10'b0101001001: bk_o =  40'b1001001110010010100110010001100110010000; //  X 3 X 2 X X 1 X X 0
         10'b0101001010: bk_o =  40'b1001001110010010100110010001100100001001; //  X 3 X 2 X X 1 X 0 X
         10'b0101001011: bk_o =  40'b1001010010010011100110010010100100010000; //  X 4 X 3 X X 2 X 1 0
         10'b0101001100: bk_o =  40'b1001001110010010100110010001000010011001; //  X 3 X 2 X X 1 0 X X
         10'b0101001101: bk_o =  40'b1001010010010011100110010010000110010000; //  X 4 X 3 X X 2 1 X 0
         10'b0101001110: bk_o =  40'b1001010010010011100110010010000100001001; //  X 4 X 3 X X 2 1 0 X
         10'b0101001111: bk_o =  40'b1001010110010100100110010011001000010000; //  X 5 X 4 X X 3 2 1 0
         10'b0101010000: bk_o =  40'b1001001010010001100100001001100110011001; //  X 2 X 1 X 0 X X X X
         10'b0101010001: bk_o =  40'b1001001110010010100100011001100110010000; //  X 3 X 2 X 1 X X X 0
         10'b0101010010: bk_o =  40'b1001001110010010100100011001100100001001; //  X 3 X 2 X 1 X X 0 X
         10'b0101010011: bk_o =  40'b1001010010010011100100101001100100010000; //  X 4 X 3 X 2 X X 1 0
         10'b0101010100: bk_o =  40'b1001001110010010100100011001000010011001; //  X 3 X 2 X 1 X 0 X X
         10'b0101010101: bk_o =  40'b1001010010010011100100101001000110010000; //  X 4 X 3 X 2 X 1 X 0
         10'b0101010110: bk_o =  40'b1001010010010011100100101001000100001001; //  X 4 X 3 X 2 X 1 0 X
         10'b0101010111: bk_o =  40'b1001010110010100100100111001001000010000; //  X 5 X 4 X 3 X 2 1 0
         10'b0101011000: bk_o =  40'b1001001110010010100100010000100110011001; //  X 3 X 2 X 1 0 X X X
         10'b0101011001: bk_o =  40'b1001010010010011100100100001100110010000; //  X 4 X 3 X 2 1 X X 0
         10'b0101011010: bk_o =  40'b1001010010010011100100100001100100001001; //  X 4 X 3 X 2 1 X 0 X
         10'b0101011011: bk_o =  40'b1001010110010100100100110010100100010000; //  X 5 X 4 X 3 2 X 1 0
         10'b0101011100: bk_o =  40'b1001010010010011100100100001000010011001; //  X 4 X 3 X 2 1 0 X X
         10'b0101011101: bk_o =  40'b1001010110010100100100110010000110010000; //  X 5 X 4 X 3 2 1 X 0
         10'b0101011110: bk_o =  40'b1001010110010100100100110010000100001001; //  X 5 X 4 X 3 2 1 0 X
         10'b0101011111: bk_o =  40'b1001011010010101100101000011001000010000; //  X 6 X 5 X 4 3 2 1 0
         10'b0101100000: bk_o =  40'b1001001010010001000010011001100110011001; //  X 2 X 1 0 X X X X X
         10'b0101100001: bk_o =  40'b1001001110010010000110011001100110010000; //  X 3 X 2 1 X X X X 0
         10'b0101100010: bk_o =  40'b1001001110010010000110011001100100001001; //  X 3 X 2 1 X X X 0 X
         10'b0101100011: bk_o =  40'b1001010010010011001010011001100100010000; //  X 4 X 3 2 X X X 1 0
         10'b0101100100: bk_o =  40'b1001001110010010000110011001000010011001; //  X 3 X 2 1 X X 0 X X
         10'b0101100101: bk_o =  40'b1001010010010011001010011001000110010000; //  X 4 X 3 2 X X 1 X 0
         10'b0101100110: bk_o =  40'b1001010010010011001010011001000100001001; //  X 4 X 3 2 X X 1 0 X
         10'b0101100111: bk_o =  40'b1001010110010100001110011001001000010000; //  X 5 X 4 3 X X 2 1 0
         10'b0101101000: bk_o =  40'b1001001110010010000110010000100110011001; //  X 3 X 2 1 X 0 X X X
         10'b0101101001: bk_o =  40'b1001010010010011001010010001100110010000; //  X 4 X 3 2 X 1 X X 0
         10'b0101101010: bk_o =  40'b1001010010010011001010010001100100001001; //  X 4 X 3 2 X 1 X 0 X
         10'b0101101011: bk_o =  40'b1001010110010100001110010010100100010000; //  X 5 X 4 3 X 2 X 1 0
         10'b0101101100: bk_o =  40'b1001010010010011001010010001000010011001; //  X 4 X 3 2 X 1 0 X X
         10'b0101101101: bk_o =  40'b1001010110010100001110010010000110010000; //  X 5 X 4 3 X 2 1 X 0
         10'b0101101110: bk_o =  40'b1001010110010100001110010010000100001001; //  X 5 X 4 3 X 2 1 0 X
         10'b0101101111: bk_o =  40'b1001011010010101010010010011001000010000; //  X 6 X 5 4 X 3 2 1 0
         10'b0101110000: bk_o =  40'b1001001110010010000100001001100110011001; //  X 3 X 2 1 0 X X X X
         10'b0101110001: bk_o =  40'b1001010010010011001000011001100110010000; //  X 4 X 3 2 1 X X X 0
         10'b0101110010: bk_o =  40'b1001010010010011001000011001100100001001; //  X 4 X 3 2 1 X X 0 X
         10'b0101110011: bk_o =  40'b1001010110010100001100101001100100010000; //  X 5 X 4 3 2 X X 1 0
         10'b0101110100: bk_o =  40'b1001010010010011001000011001000010011001; //  X 4 X 3 2 1 X 0 X X
         10'b0101110101: bk_o =  40'b1001010110010100001100101001000110010000; //  X 5 X 4 3 2 X 1 X 0
         10'b0101110110: bk_o =  40'b1001010110010100001100101001000100001001; //  X 5 X 4 3 2 X 1 0 X
         10'b0101110111: bk_o =  40'b1001011010010101010000111001001000010000; //  X 6 X 5 4 3 X 2 1 0
         10'b0101111000: bk_o =  40'b1001010010010011001000010000100110011001; //  X 4 X 3 2 1 0 X X X
         10'b0101111001: bk_o =  40'b1001010110010100001100100001100110010000; //  X 5 X 4 3 2 1 X X 0
         10'b0101111010: bk_o =  40'b1001010110010100001100100001100100001001; //  X 5 X 4 3 2 1 X 0 X
         10'b0101111011: bk_o =  40'b1001011010010101010000110010100100010000; //  X 6 X 5 4 3 2 X 1 0
         10'b0101111100: bk_o =  40'b1001010110010100001100100001000010011001; //  X 5 X 4 3 2 1 0 X X
         10'b0101111101: bk_o =  40'b1001011010010101010000110010000110010000; //  X 6 X 5 4 3 2 1 X 0
         10'b0101111110: bk_o =  40'b1001011010010101010000110010000100001001; //  X 6 X 5 4 3 2 1 0 X
         10'b0101111111: bk_o =  40'b1001011110010110010101000011001000010000; //  X 7 X 6 5 4 3 2 1 0
         10'b0110000000: bk_o =  40'b1001000100001001100110011001100110011001; //  X 1 0 X X X X X X X
         10'b0110000001: bk_o =  40'b1001001000011001100110011001100110010000; //  X 2 1 X X X X X X 0
         10'b0110000010: bk_o =  40'b1001001000011001100110011001100100001001; //  X 2 1 X X X X X 0 X
         10'b0110000011: bk_o =  40'b1001001100101001100110011001100100010000; //  X 3 2 X X X X X 1 0
         10'b0110000100: bk_o =  40'b1001001000011001100110011001000010011001; //  X 2 1 X X X X 0 X X
         10'b0110000101: bk_o =  40'b1001001100101001100110011001000110010000; //  X 3 2 X X X X 1 X 0
         10'b0110000110: bk_o =  40'b1001001100101001100110011001000100001001; //  X 3 2 X X X X 1 0 X
         10'b0110000111: bk_o =  40'b1001010000111001100110011001001000010000; //  X 4 3 X X X X 2 1 0
         10'b0110001000: bk_o =  40'b1001001000011001100110010000100110011001; //  X 2 1 X X X 0 X X X
         10'b0110001001: bk_o =  40'b1001001100101001100110010001100110010000; //  X 3 2 X X X 1 X X 0
         10'b0110001010: bk_o =  40'b1001001100101001100110010001100100001001; //  X 3 2 X X X 1 X 0 X
         10'b0110001011: bk_o =  40'b1001010000111001100110010010100100010000; //  X 4 3 X X X 2 X 1 0
         10'b0110001100: bk_o =  40'b1001001100101001100110010001000010011001; //  X 3 2 X X X 1 0 X X
         10'b0110001101: bk_o =  40'b1001010000111001100110010010000110010000; //  X 4 3 X X X 2 1 X 0
         10'b0110001110: bk_o =  40'b1001010000111001100110010010000100001001; //  X 4 3 X X X 2 1 0 X
         10'b0110001111: bk_o =  40'b1001010101001001100110010011001000010000; //  X 5 4 X X X 3 2 1 0
         10'b0110010000: bk_o =  40'b1001001000011001100100001001100110011001; //  X 2 1 X X 0 X X X X
         10'b0110010001: bk_o =  40'b1001001100101001100100011001100110010000; //  X 3 2 X X 1 X X X 0
         10'b0110010010: bk_o =  40'b1001001100101001100100011001100100001001; //  X 3 2 X X 1 X X 0 X
         10'b0110010011: bk_o =  40'b1001010000111001100100101001100100010000; //  X 4 3 X X 2 X X 1 0
         10'b0110010100: bk_o =  40'b1001001100101001100100011001000010011001; //  X 3 2 X X 1 X 0 X X
         10'b0110010101: bk_o =  40'b1001010000111001100100101001000110010000; //  X 4 3 X X 2 X 1 X 0
         10'b0110010110: bk_o =  40'b1001010000111001100100101001000100001001; //  X 4 3 X X 2 X 1 0 X
         10'b0110010111: bk_o =  40'b1001010101001001100100111001001000010000; //  X 5 4 X X 3 X 2 1 0
         10'b0110011000: bk_o =  40'b1001001100101001100100010000100110011001; //  X 3 2 X X 1 0 X X X
         10'b0110011001: bk_o =  40'b1001010000111001100100100001100110010000; //  X 4 3 X X 2 1 X X 0
         10'b0110011010: bk_o =  40'b1001010000111001100100100001100100001001; //  X 4 3 X X 2 1 X 0 X
         10'b0110011011: bk_o =  40'b1001010101001001100100110010100100010000; //  X 5 4 X X 3 2 X 1 0
         10'b0110011100: bk_o =  40'b1001010000111001100100100001000010011001; //  X 4 3 X X 2 1 0 X X
         10'b0110011101: bk_o =  40'b1001010101001001100100110010000110010000; //  X 5 4 X X 3 2 1 X 0
         10'b0110011110: bk_o =  40'b1001010101001001100100110010000100001001; //  X 5 4 X X 3 2 1 0 X
         10'b0110011111: bk_o =  40'b1001011001011001100101000011001000010000; //  X 6 5 X X 4 3 2 1 0
         10'b0110100000: bk_o =  40'b1001001000011001000010011001100110011001; //  X 2 1 X 0 X X X X X
         10'b0110100001: bk_o =  40'b1001001100101001000110011001100110010000; //  X 3 2 X 1 X X X X 0
         10'b0110100010: bk_o =  40'b1001001100101001000110011001100100001001; //  X 3 2 X 1 X X X 0 X
         10'b0110100011: bk_o =  40'b1001010000111001001010011001100100010000; //  X 4 3 X 2 X X X 1 0
         10'b0110100100: bk_o =  40'b1001001100101001000110011001000010011001; //  X 3 2 X 1 X X 0 X X
         10'b0110100101: bk_o =  40'b1001010000111001001010011001000110010000; //  X 4 3 X 2 X X 1 X 0
         10'b0110100110: bk_o =  40'b1001010000111001001010011001000100001001; //  X 4 3 X 2 X X 1 0 X
         10'b0110100111: bk_o =  40'b1001010101001001001110011001001000010000; //  X 5 4 X 3 X X 2 1 0
         10'b0110101000: bk_o =  40'b1001001100101001000110010000100110011001; //  X 3 2 X 1 X 0 X X X
         10'b0110101001: bk_o =  40'b1001010000111001001010010001100110010000; //  X 4 3 X 2 X 1 X X 0
         10'b0110101010: bk_o =  40'b1001010000111001001010010001100100001001; //  X 4 3 X 2 X 1 X 0 X
         10'b0110101011: bk_o =  40'b1001010101001001001110010010100100010000; //  X 5 4 X 3 X 2 X 1 0
         10'b0110101100: bk_o =  40'b1001010000111001001010010001000010011001; //  X 4 3 X 2 X 1 0 X X
         10'b0110101101: bk_o =  40'b1001010101001001001110010010000110010000; //  X 5 4 X 3 X 2 1 X 0
         10'b0110101110: bk_o =  40'b1001010101001001001110010010000100001001; //  X 5 4 X 3 X 2 1 0 X
         10'b0110101111: bk_o =  40'b1001011001011001010010010011001000010000; //  X 6 5 X 4 X 3 2 1 0
         10'b0110110000: bk_o =  40'b1001001100101001000100001001100110011001; //  X 3 2 X 1 0 X X X X
         10'b0110110001: bk_o =  40'b1001010000111001001000011001100110010000; //  X 4 3 X 2 1 X X X 0
         10'b0110110010: bk_o =  40'b1001010000111001001000011001100100001001; //  X 4 3 X 2 1 X X 0 X
         10'b0110110011: bk_o =  40'b1001010101001001001100101001100100010000; //  X 5 4 X 3 2 X X 1 0
         10'b0110110100: bk_o =  40'b1001010000111001001000011001000010011001; //  X 4 3 X 2 1 X 0 X X
         10'b0110110101: bk_o =  40'b1001010101001001001100101001000110010000; //  X 5 4 X 3 2 X 1 X 0
         10'b0110110110: bk_o =  40'b1001010101001001001100101001000100001001; //  X 5 4 X 3 2 X 1 0 X
         10'b0110110111: bk_o =  40'b1001011001011001010000111001001000010000; //  X 6 5 X 4 3 X 2 1 0
         10'b0110111000: bk_o =  40'b1001010000111001001000010000100110011001; //  X 4 3 X 2 1 0 X X X
         10'b0110111001: bk_o =  40'b1001010101001001001100100001100110010000; //  X 5 4 X 3 2 1 X X 0
         10'b0110111010: bk_o =  40'b1001010101001001001100100001100100001001; //  X 5 4 X 3 2 1 X 0 X
         10'b0110111011: bk_o =  40'b1001011001011001010000110010100100010000; //  X 6 5 X 4 3 2 X 1 0
         10'b0110111100: bk_o =  40'b1001010101001001001100100001000010011001; //  X 5 4 X 3 2 1 0 X X
         10'b0110111101: bk_o =  40'b1001011001011001010000110010000110010000; //  X 6 5 X 4 3 2 1 X 0
         10'b0110111110: bk_o =  40'b1001011001011001010000110010000100001001; //  X 6 5 X 4 3 2 1 0 X
         10'b0110111111: bk_o =  40'b1001011101101001010101000011001000010000; //  X 7 6 X 5 4 3 2 1 0
         10'b0111000000: bk_o =  40'b1001001000010000100110011001100110011001; //  X 2 1 0 X X X X X X
         10'b0111000001: bk_o =  40'b1001001100100001100110011001100110010000; //  X 3 2 1 X X X X X 0
         10'b0111000010: bk_o =  40'b1001001100100001100110011001100100001001; //  X 3 2 1 X X X X 0 X
         10'b0111000011: bk_o =  40'b1001010000110010100110011001100100010000; //  X 4 3 2 X X X X 1 0
         10'b0111000100: bk_o =  40'b1001001100100001100110011001000010011001; //  X 3 2 1 X X X 0 X X
         10'b0111000101: bk_o =  40'b1001010000110010100110011001000110010000; //  X 4 3 2 X X X 1 X 0
         10'b0111000110: bk_o =  40'b1001010000110010100110011001000100001001; //  X 4 3 2 X X X 1 0 X
         10'b0111000111: bk_o =  40'b1001010101000011100110011001001000010000; //  X 5 4 3 X X X 2 1 0
         10'b0111001000: bk_o =  40'b1001001100100001100110010000100110011001; //  X 3 2 1 X X 0 X X X
         10'b0111001001: bk_o =  40'b1001010000110010100110010001100110010000; //  X 4 3 2 X X 1 X X 0
         10'b0111001010: bk_o =  40'b1001010000110010100110010001100100001001; //  X 4 3 2 X X 1 X 0 X
         10'b0111001011: bk_o =  40'b1001010101000011100110010010100100010000; //  X 5 4 3 X X 2 X 1 0
         10'b0111001100: bk_o =  40'b1001010000110010100110010001000010011001; //  X 4 3 2 X X 1 0 X X
         10'b0111001101: bk_o =  40'b1001010101000011100110010010000110010000; //  X 5 4 3 X X 2 1 X 0
         10'b0111001110: bk_o =  40'b1001010101000011100110010010000100001001; //  X 5 4 3 X X 2 1 0 X
         10'b0111001111: bk_o =  40'b1001011001010100100110010011001000010000; //  X 6 5 4 X X 3 2 1 0
         10'b0111010000: bk_o =  40'b1001001100100001100100001001100110011001; //  X 3 2 1 X 0 X X X X
         10'b0111010001: bk_o =  40'b1001010000110010100100011001100110010000; //  X 4 3 2 X 1 X X X 0
         10'b0111010010: bk_o =  40'b1001010000110010100100011001100100001001; //  X 4 3 2 X 1 X X 0 X
         10'b0111010011: bk_o =  40'b1001010101000011100100101001100100010000; //  X 5 4 3 X 2 X X 1 0
         10'b0111010100: bk_o =  40'b1001010000110010100100011001000010011001; //  X 4 3 2 X 1 X 0 X X
         10'b0111010101: bk_o =  40'b1001010101000011100100101001000110010000; //  X 5 4 3 X 2 X 1 X 0
         10'b0111010110: bk_o =  40'b1001010101000011100100101001000100001001; //  X 5 4 3 X 2 X 1 0 X
         10'b0111010111: bk_o =  40'b1001011001010100100100111001001000010000; //  X 6 5 4 X 3 X 2 1 0
         10'b0111011000: bk_o =  40'b1001010000110010100100010000100110011001; //  X 4 3 2 X 1 0 X X X
         10'b0111011001: bk_o =  40'b1001010101000011100100100001100110010000; //  X 5 4 3 X 2 1 X X 0
         10'b0111011010: bk_o =  40'b1001010101000011100100100001100100001001; //  X 5 4 3 X 2 1 X 0 X
         10'b0111011011: bk_o =  40'b1001011001010100100100110010100100010000; //  X 6 5 4 X 3 2 X 1 0
         10'b0111011100: bk_o =  40'b1001010101000011100100100001000010011001; //  X 5 4 3 X 2 1 0 X X
         10'b0111011101: bk_o =  40'b1001011001010100100100110010000110010000; //  X 6 5 4 X 3 2 1 X 0
         10'b0111011110: bk_o =  40'b1001011001010100100100110010000100001001; //  X 6 5 4 X 3 2 1 0 X
         10'b0111011111: bk_o =  40'b1001011101100101100101000011001000010000; //  X 7 6 5 X 4 3 2 1 0
         10'b0111100000: bk_o =  40'b1001001100100001000010011001100110011001; //  X 3 2 1 0 X X X X X
         10'b0111100001: bk_o =  40'b1001010000110010000110011001100110010000; //  X 4 3 2 1 X X X X 0
         10'b0111100010: bk_o =  40'b1001010000110010000110011001100100001001; //  X 4 3 2 1 X X X 0 X
         10'b0111100011: bk_o =  40'b1001010101000011001010011001100100010000; //  X 5 4 3 2 X X X 1 0
         10'b0111100100: bk_o =  40'b1001010000110010000110011001000010011001; //  X 4 3 2 1 X X 0 X X
         10'b0111100101: bk_o =  40'b1001010101000011001010011001000110010000; //  X 5 4 3 2 X X 1 X 0
         10'b0111100110: bk_o =  40'b1001010101000011001010011001000100001001; //  X 5 4 3 2 X X 1 0 X
         10'b0111100111: bk_o =  40'b1001011001010100001110011001001000010000; //  X 6 5 4 3 X X 2 1 0
         10'b0111101000: bk_o =  40'b1001010000110010000110010000100110011001; //  X 4 3 2 1 X 0 X X X
         10'b0111101001: bk_o =  40'b1001010101000011001010010001100110010000; //  X 5 4 3 2 X 1 X X 0
         10'b0111101010: bk_o =  40'b1001010101000011001010010001100100001001; //  X 5 4 3 2 X 1 X 0 X
         10'b0111101011: bk_o =  40'b1001011001010100001110010010100100010000; //  X 6 5 4 3 X 2 X 1 0
         10'b0111101100: bk_o =  40'b1001010101000011001010010001000010011001; //  X 5 4 3 2 X 1 0 X X
         10'b0111101101: bk_o =  40'b1001011001010100001110010010000110010000; //  X 6 5 4 3 X 2 1 X 0
         10'b0111101110: bk_o =  40'b1001011001010100001110010010000100001001; //  X 6 5 4 3 X 2 1 0 X
         10'b0111101111: bk_o =  40'b1001011101100101010010010011001000010000; //  X 7 6 5 4 X 3 2 1 0
         10'b0111110000: bk_o =  40'b1001010000110010000100001001100110011001; //  X 4 3 2 1 0 X X X X
         10'b0111110001: bk_o =  40'b1001010101000011001000011001100110010000; //  X 5 4 3 2 1 X X X 0
         10'b0111110010: bk_o =  40'b1001010101000011001000011001100100001001; //  X 5 4 3 2 1 X X 0 X
         10'b0111110011: bk_o =  40'b1001011001010100001100101001100100010000; //  X 6 5 4 3 2 X X 1 0
         10'b0111110100: bk_o =  40'b1001010101000011001000011001000010011001; //  X 5 4 3 2 1 X 0 X X
         10'b0111110101: bk_o =  40'b1001011001010100001100101001000110010000; //  X 6 5 4 3 2 X 1 X 0
         10'b0111110110: bk_o =  40'b1001011001010100001100101001000100001001; //  X 6 5 4 3 2 X 1 0 X
         10'b0111110111: bk_o =  40'b1001011101100101010000111001001000010000; //  X 7 6 5 4 3 X 2 1 0
         10'b0111111000: bk_o =  40'b1001010101000011001000010000100110011001; //  X 5 4 3 2 1 0 X X X
         10'b0111111001: bk_o =  40'b1001011001010100001100100001100110010000; //  X 6 5 4 3 2 1 X X 0
         10'b0111111010: bk_o =  40'b1001011001010100001100100001100100001001; //  X 6 5 4 3 2 1 X 0 X
         10'b0111111011: bk_o =  40'b1001011101100101010000110010100100010000; //  X 7 6 5 4 3 2 X 1 0
         10'b0111111100: bk_o =  40'b1001011001010100001100100001000010011001; //  X 6 5 4 3 2 1 0 X X
         10'b0111111101: bk_o =  40'b1001011101100101010000110010000110010000; //  X 7 6 5 4 3 2 1 X 0
         10'b0111111110: bk_o =  40'b1001011101100101010000110010000100001001; //  X 7 6 5 4 3 2 1 0 X
         10'b0111111111: bk_o =  40'b1001100001110110010101000011001000010000; //  X 8 7 6 5 4 3 2 1 0
         10'b1000000000: bk_o =  40'b0000100110011001100110011001100110011001; //  0 X X X X X X X X X
         10'b1000000001: bk_o =  40'b0001100110011001100110011001100110010000; //  1 X X X X X X X X 0
         10'b1000000010: bk_o =  40'b0001100110011001100110011001100100001001; //  1 X X X X X X X 0 X
         10'b1000000011: bk_o =  40'b0010100110011001100110011001100100010000; //  2 X X X X X X X 1 0
         10'b1000000100: bk_o =  40'b0001100110011001100110011001000010011001; //  1 X X X X X X 0 X X
         10'b1000000101: bk_o =  40'b0010100110011001100110011001000110010000; //  2 X X X X X X 1 X 0
         10'b1000000110: bk_o =  40'b0010100110011001100110011001000100001001; //  2 X X X X X X 1 0 X
         10'b1000000111: bk_o =  40'b0011100110011001100110011001001000010000; //  3 X X X X X X 2 1 0
         10'b1000001000: bk_o =  40'b0001100110011001100110010000100110011001; //  1 X X X X X 0 X X X
         10'b1000001001: bk_o =  40'b0010100110011001100110010001100110010000; //  2 X X X X X 1 X X 0
         10'b1000001010: bk_o =  40'b0010100110011001100110010001100100001001; //  2 X X X X X 1 X 0 X
         10'b1000001011: bk_o =  40'b0011100110011001100110010010100100010000; //  3 X X X X X 2 X 1 0
         10'b1000001100: bk_o =  40'b0010100110011001100110010001000010011001; //  2 X X X X X 1 0 X X
         10'b1000001101: bk_o =  40'b0011100110011001100110010010000110010000; //  3 X X X X X 2 1 X 0
         10'b1000001110: bk_o =  40'b0011100110011001100110010010000100001001; //  3 X X X X X 2 1 0 X
         10'b1000001111: bk_o =  40'b0100100110011001100110010011001000010000; //  4 X X X X X 3 2 1 0
         10'b1000010000: bk_o =  40'b0001100110011001100100001001100110011001; //  1 X X X X 0 X X X X
         10'b1000010001: bk_o =  40'b0010100110011001100100011001100110010000; //  2 X X X X 1 X X X 0
         10'b1000010010: bk_o =  40'b0010100110011001100100011001100100001001; //  2 X X X X 1 X X 0 X
         10'b1000010011: bk_o =  40'b0011100110011001100100101001100100010000; //  3 X X X X 2 X X 1 0
         10'b1000010100: bk_o =  40'b0010100110011001100100011001000010011001; //  2 X X X X 1 X 0 X X
         10'b1000010101: bk_o =  40'b0011100110011001100100101001000110010000; //  3 X X X X 2 X 1 X 0
         10'b1000010110: bk_o =  40'b0011100110011001100100101001000100001001; //  3 X X X X 2 X 1 0 X
         10'b1000010111: bk_o =  40'b0100100110011001100100111001001000010000; //  4 X X X X 3 X 2 1 0
         10'b1000011000: bk_o =  40'b0010100110011001100100010000100110011001; //  2 X X X X 1 0 X X X
         10'b1000011001: bk_o =  40'b0011100110011001100100100001100110010000; //  3 X X X X 2 1 X X 0
         10'b1000011010: bk_o =  40'b0011100110011001100100100001100100001001; //  3 X X X X 2 1 X 0 X
         10'b1000011011: bk_o =  40'b0100100110011001100100110010100100010000; //  4 X X X X 3 2 X 1 0
         10'b1000011100: bk_o =  40'b0011100110011001100100100001000010011001; //  3 X X X X 2 1 0 X X
         10'b1000011101: bk_o =  40'b0100100110011001100100110010000110010000; //  4 X X X X 3 2 1 X 0
         10'b1000011110: bk_o =  40'b0100100110011001100100110010000100001001; //  4 X X X X 3 2 1 0 X
         10'b1000011111: bk_o =  40'b0101100110011001100101000011001000010000; //  5 X X X X 4 3 2 1 0
         10'b1000100000: bk_o =  40'b0001100110011001000010011001100110011001; //  1 X X X 0 X X X X X
         10'b1000100001: bk_o =  40'b0010100110011001000110011001100110010000; //  2 X X X 1 X X X X 0
         10'b1000100010: bk_o =  40'b0010100110011001000110011001100100001001; //  2 X X X 1 X X X 0 X
         10'b1000100011: bk_o =  40'b0011100110011001001010011001100100010000; //  3 X X X 2 X X X 1 0
         10'b1000100100: bk_o =  40'b0010100110011001000110011001000010011001; //  2 X X X 1 X X 0 X X
         10'b1000100101: bk_o =  40'b0011100110011001001010011001000110010000; //  3 X X X 2 X X 1 X 0
         10'b1000100110: bk_o =  40'b0011100110011001001010011001000100001001; //  3 X X X 2 X X 1 0 X
         10'b1000100111: bk_o =  40'b0100100110011001001110011001001000010000; //  4 X X X 3 X X 2 1 0
         10'b1000101000: bk_o =  40'b0010100110011001000110010000100110011001; //  2 X X X 1 X 0 X X X
         10'b1000101001: bk_o =  40'b0011100110011001001010010001100110010000; //  3 X X X 2 X 1 X X 0
         10'b1000101010: bk_o =  40'b0011100110011001001010010001100100001001; //  3 X X X 2 X 1 X 0 X
         10'b1000101011: bk_o =  40'b0100100110011001001110010010100100010000; //  4 X X X 3 X 2 X 1 0
         10'b1000101100: bk_o =  40'b0011100110011001001010010001000010011001; //  3 X X X 2 X 1 0 X X
         10'b1000101101: bk_o =  40'b0100100110011001001110010010000110010000; //  4 X X X 3 X 2 1 X 0
         10'b1000101110: bk_o =  40'b0100100110011001001110010010000100001001; //  4 X X X 3 X 2 1 0 X
         10'b1000101111: bk_o =  40'b0101100110011001010010010011001000010000; //  5 X X X 4 X 3 2 1 0
         10'b1000110000: bk_o =  40'b0010100110011001000100001001100110011001; //  2 X X X 1 0 X X X X
         10'b1000110001: bk_o =  40'b0011100110011001001000011001100110010000; //  3 X X X 2 1 X X X 0
         10'b1000110010: bk_o =  40'b0011100110011001001000011001100100001001; //  3 X X X 2 1 X X 0 X
         10'b1000110011: bk_o =  40'b0100100110011001001100101001100100010000; //  4 X X X 3 2 X X 1 0
         10'b1000110100: bk_o =  40'b0011100110011001001000011001000010011001; //  3 X X X 2 1 X 0 X X
         10'b1000110101: bk_o =  40'b0100100110011001001100101001000110010000; //  4 X X X 3 2 X 1 X 0
         10'b1000110110: bk_o =  40'b0100100110011001001100101001000100001001; //  4 X X X 3 2 X 1 0 X
         10'b1000110111: bk_o =  40'b0101100110011001010000111001001000010000; //  5 X X X 4 3 X 2 1 0
         10'b1000111000: bk_o =  40'b0011100110011001001000010000100110011001; //  3 X X X 2 1 0 X X X
         10'b1000111001: bk_o =  40'b0100100110011001001100100001100110010000; //  4 X X X 3 2 1 X X 0
         10'b1000111010: bk_o =  40'b0100100110011001001100100001100100001001; //  4 X X X 3 2 1 X 0 X
         10'b1000111011: bk_o =  40'b0101100110011001010000110010100100010000; //  5 X X X 4 3 2 X 1 0
         10'b1000111100: bk_o =  40'b0100100110011001001100100001000010011001; //  4 X X X 3 2 1 0 X X
         10'b1000111101: bk_o =  40'b0101100110011001010000110010000110010000; //  5 X X X 4 3 2 1 X 0
         10'b1000111110: bk_o =  40'b0101100110011001010000110010000100001001; //  5 X X X 4 3 2 1 0 X
         10'b1000111111: bk_o =  40'b0110100110011001010101000011001000010000; //  6 X X X 5 4 3 2 1 0
         10'b1001000000: bk_o =  40'b0001100110010000100110011001100110011001; //  1 X X 0 X X X X X X
         10'b1001000001: bk_o =  40'b0010100110010001100110011001100110010000; //  2 X X 1 X X X X X 0
         10'b1001000010: bk_o =  40'b0010100110010001100110011001100100001001; //  2 X X 1 X X X X 0 X
         10'b1001000011: bk_o =  40'b0011100110010010100110011001100100010000; //  3 X X 2 X X X X 1 0
         10'b1001000100: bk_o =  40'b0010100110010001100110011001000010011001; //  2 X X 1 X X X 0 X X
         10'b1001000101: bk_o =  40'b0011100110010010100110011001000110010000; //  3 X X 2 X X X 1 X 0
         10'b1001000110: bk_o =  40'b0011100110010010100110011001000100001001; //  3 X X 2 X X X 1 0 X
         10'b1001000111: bk_o =  40'b0100100110010011100110011001001000010000; //  4 X X 3 X X X 2 1 0
         10'b1001001000: bk_o =  40'b0010100110010001100110010000100110011001; //  2 X X 1 X X 0 X X X
         10'b1001001001: bk_o =  40'b0011100110010010100110010001100110010000; //  3 X X 2 X X 1 X X 0
         10'b1001001010: bk_o =  40'b0011100110010010100110010001100100001001; //  3 X X 2 X X 1 X 0 X
         10'b1001001011: bk_o =  40'b0100100110010011100110010010100100010000; //  4 X X 3 X X 2 X 1 0
         10'b1001001100: bk_o =  40'b0011100110010010100110010001000010011001; //  3 X X 2 X X 1 0 X X
         10'b1001001101: bk_o =  40'b0100100110010011100110010010000110010000; //  4 X X 3 X X 2 1 X 0
         10'b1001001110: bk_o =  40'b0100100110010011100110010010000100001001; //  4 X X 3 X X 2 1 0 X
         10'b1001001111: bk_o =  40'b0101100110010100100110010011001000010000; //  5 X X 4 X X 3 2 1 0
         10'b1001010000: bk_o =  40'b0010100110010001100100001001100110011001; //  2 X X 1 X 0 X X X X
         10'b1001010001: bk_o =  40'b0011100110010010100100011001100110010000; //  3 X X 2 X 1 X X X 0
         10'b1001010010: bk_o =  40'b0011100110010010100100011001100100001001; //  3 X X 2 X 1 X X 0 X
         10'b1001010011: bk_o =  40'b0100100110010011100100101001100100010000; //  4 X X 3 X 2 X X 1 0
         10'b1001010100: bk_o =  40'b0011100110010010100100011001000010011001; //  3 X X 2 X 1 X 0 X X
         10'b1001010101: bk_o =  40'b0100100110010011100100101001000110010000; //  4 X X 3 X 2 X 1 X 0
         10'b1001010110: bk_o =  40'b0100100110010011100100101001000100001001; //  4 X X 3 X 2 X 1 0 X
         10'b1001010111: bk_o =  40'b0101100110010100100100111001001000010000; //  5 X X 4 X 3 X 2 1 0
         10'b1001011000: bk_o =  40'b0011100110010010100100010000100110011001; //  3 X X 2 X 1 0 X X X
         10'b1001011001: bk_o =  40'b0100100110010011100100100001100110010000; //  4 X X 3 X 2 1 X X 0
         10'b1001011010: bk_o =  40'b0100100110010011100100100001100100001001; //  4 X X 3 X 2 1 X 0 X
         10'b1001011011: bk_o =  40'b0101100110010100100100110010100100010000; //  5 X X 4 X 3 2 X 1 0
         10'b1001011100: bk_o =  40'b0100100110010011100100100001000010011001; //  4 X X 3 X 2 1 0 X X
         10'b1001011101: bk_o =  40'b0101100110010100100100110010000110010000; //  5 X X 4 X 3 2 1 X 0
         10'b1001011110: bk_o =  40'b0101100110010100100100110010000100001001; //  5 X X 4 X 3 2 1 0 X
         10'b1001011111: bk_o =  40'b0110100110010101100101000011001000010000; //  6 X X 5 X 4 3 2 1 0
         10'b1001100000: bk_o =  40'b0010100110010001000010011001100110011001; //  2 X X 1 0 X X X X X
         10'b1001100001: bk_o =  40'b0011100110010010000110011001100110010000; //  3 X X 2 1 X X X X 0
         10'b1001100010: bk_o =  40'b0011100110010010000110011001100100001001; //  3 X X 2 1 X X X 0 X
         10'b1001100011: bk_o =  40'b0100100110010011001010011001100100010000; //  4 X X 3 2 X X X 1 0
         10'b1001100100: bk_o =  40'b0011100110010010000110011001000010011001; //  3 X X 2 1 X X 0 X X
         10'b1001100101: bk_o =  40'b0100100110010011001010011001000110010000; //  4 X X 3 2 X X 1 X 0
         10'b1001100110: bk_o =  40'b0100100110010011001010011001000100001001; //  4 X X 3 2 X X 1 0 X
         10'b1001100111: bk_o =  40'b0101100110010100001110011001001000010000; //  5 X X 4 3 X X 2 1 0
         10'b1001101000: bk_o =  40'b0011100110010010000110010000100110011001; //  3 X X 2 1 X 0 X X X
         10'b1001101001: bk_o =  40'b0100100110010011001010010001100110010000; //  4 X X 3 2 X 1 X X 0
         10'b1001101010: bk_o =  40'b0100100110010011001010010001100100001001; //  4 X X 3 2 X 1 X 0 X
         10'b1001101011: bk_o =  40'b0101100110010100001110010010100100010000; //  5 X X 4 3 X 2 X 1 0
         10'b1001101100: bk_o =  40'b0100100110010011001010010001000010011001; //  4 X X 3 2 X 1 0 X X
         10'b1001101101: bk_o =  40'b0101100110010100001110010010000110010000; //  5 X X 4 3 X 2 1 X 0
         10'b1001101110: bk_o =  40'b0101100110010100001110010010000100001001; //  5 X X 4 3 X 2 1 0 X
         10'b1001101111: bk_o =  40'b0110100110010101010010010011001000010000; //  6 X X 5 4 X 3 2 1 0
         10'b1001110000: bk_o =  40'b0011100110010010000100001001100110011001; //  3 X X 2 1 0 X X X X
         10'b1001110001: bk_o =  40'b0100100110010011001000011001100110010000; //  4 X X 3 2 1 X X X 0
         10'b1001110010: bk_o =  40'b0100100110010011001000011001100100001001; //  4 X X 3 2 1 X X 0 X
         10'b1001110011: bk_o =  40'b0101100110010100001100101001100100010000; //  5 X X 4 3 2 X X 1 0
         10'b1001110100: bk_o =  40'b0100100110010011001000011001000010011001; //  4 X X 3 2 1 X 0 X X
         10'b1001110101: bk_o =  40'b0101100110010100001100101001000110010000; //  5 X X 4 3 2 X 1 X 0
         10'b1001110110: bk_o =  40'b0101100110010100001100101001000100001001; //  5 X X 4 3 2 X 1 0 X
         10'b1001110111: bk_o =  40'b0110100110010101010000111001001000010000; //  6 X X 5 4 3 X 2 1 0
         10'b1001111000: bk_o =  40'b0100100110010011001000010000100110011001; //  4 X X 3 2 1 0 X X X
         10'b1001111001: bk_o =  40'b0101100110010100001100100001100110010000; //  5 X X 4 3 2 1 X X 0
         10'b1001111010: bk_o =  40'b0101100110010100001100100001100100001001; //  5 X X 4 3 2 1 X 0 X
         10'b1001111011: bk_o =  40'b0110100110010101010000110010100100010000; //  6 X X 5 4 3 2 X 1 0
         10'b1001111100: bk_o =  40'b0101100110010100001100100001000010011001; //  5 X X 4 3 2 1 0 X X
         10'b1001111101: bk_o =  40'b0110100110010101010000110010000110010000; //  6 X X 5 4 3 2 1 X 0
         10'b1001111110: bk_o =  40'b0110100110010101010000110010000100001001; //  6 X X 5 4 3 2 1 0 X
         10'b1001111111: bk_o =  40'b0111100110010110010101000011001000010000; //  7 X X 6 5 4 3 2 1 0
         10'b1010000000: bk_o =  40'b0001100100001001100110011001100110011001; //  1 X 0 X X X X X X X
         10'b1010000001: bk_o =  40'b0010100100011001100110011001100110010000; //  2 X 1 X X X X X X 0
         10'b1010000010: bk_o =  40'b0010100100011001100110011001100100001001; //  2 X 1 X X X X X 0 X
         10'b1010000011: bk_o =  40'b0011100100101001100110011001100100010000; //  3 X 2 X X X X X 1 0
         10'b1010000100: bk_o =  40'b0010100100011001100110011001000010011001; //  2 X 1 X X X X 0 X X
         10'b1010000101: bk_o =  40'b0011100100101001100110011001000110010000; //  3 X 2 X X X X 1 X 0
         10'b1010000110: bk_o =  40'b0011100100101001100110011001000100001001; //  3 X 2 X X X X 1 0 X
         10'b1010000111: bk_o =  40'b0100100100111001100110011001001000010000; //  4 X 3 X X X X 2 1 0
         10'b1010001000: bk_o =  40'b0010100100011001100110010000100110011001; //  2 X 1 X X X 0 X X X
         10'b1010001001: bk_o =  40'b0011100100101001100110010001100110010000; //  3 X 2 X X X 1 X X 0
         10'b1010001010: bk_o =  40'b0011100100101001100110010001100100001001; //  3 X 2 X X X 1 X 0 X
         10'b1010001011: bk_o =  40'b0100100100111001100110010010100100010000; //  4 X 3 X X X 2 X 1 0
         10'b1010001100: bk_o =  40'b0011100100101001100110010001000010011001; //  3 X 2 X X X 1 0 X X
         10'b1010001101: bk_o =  40'b0100100100111001100110010010000110010000; //  4 X 3 X X X 2 1 X 0
         10'b1010001110: bk_o =  40'b0100100100111001100110010010000100001001; //  4 X 3 X X X 2 1 0 X
         10'b1010001111: bk_o =  40'b0101100101001001100110010011001000010000; //  5 X 4 X X X 3 2 1 0
         10'b1010010000: bk_o =  40'b0010100100011001100100001001100110011001; //  2 X 1 X X 0 X X X X
         10'b1010010001: bk_o =  40'b0011100100101001100100011001100110010000; //  3 X 2 X X 1 X X X 0
         10'b1010010010: bk_o =  40'b0011100100101001100100011001100100001001; //  3 X 2 X X 1 X X 0 X
         10'b1010010011: bk_o =  40'b0100100100111001100100101001100100010000; //  4 X 3 X X 2 X X 1 0
         10'b1010010100: bk_o =  40'b0011100100101001100100011001000010011001; //  3 X 2 X X 1 X 0 X X
         10'b1010010101: bk_o =  40'b0100100100111001100100101001000110010000; //  4 X 3 X X 2 X 1 X 0
         10'b1010010110: bk_o =  40'b0100100100111001100100101001000100001001; //  4 X 3 X X 2 X 1 0 X
         10'b1010010111: bk_o =  40'b0101100101001001100100111001001000010000; //  5 X 4 X X 3 X 2 1 0
         10'b1010011000: bk_o =  40'b0011100100101001100100010000100110011001; //  3 X 2 X X 1 0 X X X
         10'b1010011001: bk_o =  40'b0100100100111001100100100001100110010000; //  4 X 3 X X 2 1 X X 0
         10'b1010011010: bk_o =  40'b0100100100111001100100100001100100001001; //  4 X 3 X X 2 1 X 0 X
         10'b1010011011: bk_o =  40'b0101100101001001100100110010100100010000; //  5 X 4 X X 3 2 X 1 0
         10'b1010011100: bk_o =  40'b0100100100111001100100100001000010011001; //  4 X 3 X X 2 1 0 X X
         10'b1010011101: bk_o =  40'b0101100101001001100100110010000110010000; //  5 X 4 X X 3 2 1 X 0
         10'b1010011110: bk_o =  40'b0101100101001001100100110010000100001001; //  5 X 4 X X 3 2 1 0 X
         10'b1010011111: bk_o =  40'b0110100101011001100101000011001000010000; //  6 X 5 X X 4 3 2 1 0
         10'b1010100000: bk_o =  40'b0010100100011001000010011001100110011001; //  2 X 1 X 0 X X X X X
         10'b1010100001: bk_o =  40'b0011100100101001000110011001100110010000; //  3 X 2 X 1 X X X X 0
         10'b1010100010: bk_o =  40'b0011100100101001000110011001100100001001; //  3 X 2 X 1 X X X 0 X
         10'b1010100011: bk_o =  40'b0100100100111001001010011001100100010000; //  4 X 3 X 2 X X X 1 0
         10'b1010100100: bk_o =  40'b0011100100101001000110011001000010011001; //  3 X 2 X 1 X X 0 X X
         10'b1010100101: bk_o =  40'b0100100100111001001010011001000110010000; //  4 X 3 X 2 X X 1 X 0
         10'b1010100110: bk_o =  40'b0100100100111001001010011001000100001001; //  4 X 3 X 2 X X 1 0 X
         10'b1010100111: bk_o =  40'b0101100101001001001110011001001000010000; //  5 X 4 X 3 X X 2 1 0
         10'b1010101000: bk_o =  40'b0011100100101001000110010000100110011001; //  3 X 2 X 1 X 0 X X X
         10'b1010101001: bk_o =  40'b0100100100111001001010010001100110010000; //  4 X 3 X 2 X 1 X X 0
         10'b1010101010: bk_o =  40'b0100100100111001001010010001100100001001; //  4 X 3 X 2 X 1 X 0 X
         10'b1010101011: bk_o =  40'b0101100101001001001110010010100100010000; //  5 X 4 X 3 X 2 X 1 0
         10'b1010101100: bk_o =  40'b0100100100111001001010010001000010011001; //  4 X 3 X 2 X 1 0 X X
         10'b1010101101: bk_o =  40'b0101100101001001001110010010000110010000; //  5 X 4 X 3 X 2 1 X 0
         10'b1010101110: bk_o =  40'b0101100101001001001110010010000100001001; //  5 X 4 X 3 X 2 1 0 X
         10'b1010101111: bk_o =  40'b0110100101011001010010010011001000010000; //  6 X 5 X 4 X 3 2 1 0
         10'b1010110000: bk_o =  40'b0011100100101001000100001001100110011001; //  3 X 2 X 1 0 X X X X
         10'b1010110001: bk_o =  40'b0100100100111001001000011001100110010000; //  4 X 3 X 2 1 X X X 0
         10'b1010110010: bk_o =  40'b0100100100111001001000011001100100001001; //  4 X 3 X 2 1 X X 0 X
         10'b1010110011: bk_o =  40'b0101100101001001001100101001100100010000; //  5 X 4 X 3 2 X X 1 0
         10'b1010110100: bk_o =  40'b0100100100111001001000011001000010011001; //  4 X 3 X 2 1 X 0 X X
         10'b1010110101: bk_o =  40'b0101100101001001001100101001000110010000; //  5 X 4 X 3 2 X 1 X 0
         10'b1010110110: bk_o =  40'b0101100101001001001100101001000100001001; //  5 X 4 X 3 2 X 1 0 X
         10'b1010110111: bk_o =  40'b0110100101011001010000111001001000010000; //  6 X 5 X 4 3 X 2 1 0
         10'b1010111000: bk_o =  40'b0100100100111001001000010000100110011001; //  4 X 3 X 2 1 0 X X X
         10'b1010111001: bk_o =  40'b0101100101001001001100100001100110010000; //  5 X 4 X 3 2 1 X X 0
         10'b1010111010: bk_o =  40'b0101100101001001001100100001100100001001; //  5 X 4 X 3 2 1 X 0 X
         10'b1010111011: bk_o =  40'b0110100101011001010000110010100100010000; //  6 X 5 X 4 3 2 X 1 0
         10'b1010111100: bk_o =  40'b0101100101001001001100100001000010011001; //  5 X 4 X 3 2 1 0 X X
         10'b1010111101: bk_o =  40'b0110100101011001010000110010000110010000; //  6 X 5 X 4 3 2 1 X 0
         10'b1010111110: bk_o =  40'b0110100101011001010000110010000100001001; //  6 X 5 X 4 3 2 1 0 X
         10'b1010111111: bk_o =  40'b0111100101101001010101000011001000010000; //  7 X 6 X 5 4 3 2 1 0
         10'b1011000000: bk_o =  40'b0010100100010000100110011001100110011001; //  2 X 1 0 X X X X X X
         10'b1011000001: bk_o =  40'b0011100100100001100110011001100110010000; //  3 X 2 1 X X X X X 0
         10'b1011000010: bk_o =  40'b0011100100100001100110011001100100001001; //  3 X 2 1 X X X X 0 X
         10'b1011000011: bk_o =  40'b0100100100110010100110011001100100010000; //  4 X 3 2 X X X X 1 0
         10'b1011000100: bk_o =  40'b0011100100100001100110011001000010011001; //  3 X 2 1 X X X 0 X X
         10'b1011000101: bk_o =  40'b0100100100110010100110011001000110010000; //  4 X 3 2 X X X 1 X 0
         10'b1011000110: bk_o =  40'b0100100100110010100110011001000100001001; //  4 X 3 2 X X X 1 0 X
         10'b1011000111: bk_o =  40'b0101100101000011100110011001001000010000; //  5 X 4 3 X X X 2 1 0
         10'b1011001000: bk_o =  40'b0011100100100001100110010000100110011001; //  3 X 2 1 X X 0 X X X
         10'b1011001001: bk_o =  40'b0100100100110010100110010001100110010000; //  4 X 3 2 X X 1 X X 0
         10'b1011001010: bk_o =  40'b0100100100110010100110010001100100001001; //  4 X 3 2 X X 1 X 0 X
         10'b1011001011: bk_o =  40'b0101100101000011100110010010100100010000; //  5 X 4 3 X X 2 X 1 0
         10'b1011001100: bk_o =  40'b0100100100110010100110010001000010011001; //  4 X 3 2 X X 1 0 X X
         10'b1011001101: bk_o =  40'b0101100101000011100110010010000110010000; //  5 X 4 3 X X 2 1 X 0
         10'b1011001110: bk_o =  40'b0101100101000011100110010010000100001001; //  5 X 4 3 X X 2 1 0 X
         10'b1011001111: bk_o =  40'b0110100101010100100110010011001000010000; //  6 X 5 4 X X 3 2 1 0
         10'b1011010000: bk_o =  40'b0011100100100001100100001001100110011001; //  3 X 2 1 X 0 X X X X
         10'b1011010001: bk_o =  40'b0100100100110010100100011001100110010000; //  4 X 3 2 X 1 X X X 0
         10'b1011010010: bk_o =  40'b0100100100110010100100011001100100001001; //  4 X 3 2 X 1 X X 0 X
         10'b1011010011: bk_o =  40'b0101100101000011100100101001100100010000; //  5 X 4 3 X 2 X X 1 0
         10'b1011010100: bk_o =  40'b0100100100110010100100011001000010011001; //  4 X 3 2 X 1 X 0 X X
         10'b1011010101: bk_o =  40'b0101100101000011100100101001000110010000; //  5 X 4 3 X 2 X 1 X 0
         10'b1011010110: bk_o =  40'b0101100101000011100100101001000100001001; //  5 X 4 3 X 2 X 1 0 X
         10'b1011010111: bk_o =  40'b0110100101010100100100111001001000010000; //  6 X 5 4 X 3 X 2 1 0
         10'b1011011000: bk_o =  40'b0100100100110010100100010000100110011001; //  4 X 3 2 X 1 0 X X X
         10'b1011011001: bk_o =  40'b0101100101000011100100100001100110010000; //  5 X 4 3 X 2 1 X X 0
         10'b1011011010: bk_o =  40'b0101100101000011100100100001100100001001; //  5 X 4 3 X 2 1 X 0 X
         10'b1011011011: bk_o =  40'b0110100101010100100100110010100100010000; //  6 X 5 4 X 3 2 X 1 0
         10'b1011011100: bk_o =  40'b0101100101000011100100100001000010011001; //  5 X 4 3 X 2 1 0 X X
         10'b1011011101: bk_o =  40'b0110100101010100100100110010000110010000; //  6 X 5 4 X 3 2 1 X 0
         10'b1011011110: bk_o =  40'b0110100101010100100100110010000100001001; //  6 X 5 4 X 3 2 1 0 X
         10'b1011011111: bk_o =  40'b0111100101100101100101000011001000010000; //  7 X 6 5 X 4 3 2 1 0
         10'b1011100000: bk_o =  40'b0011100100100001000010011001100110011001; //  3 X 2 1 0 X X X X X
         10'b1011100001: bk_o =  40'b0100100100110010000110011001100110010000; //  4 X 3 2 1 X X X X 0
         10'b1011100010: bk_o =  40'b0100100100110010000110011001100100001001; //  4 X 3 2 1 X X X 0 X
         10'b1011100011: bk_o =  40'b0101100101000011001010011001100100010000; //  5 X 4 3 2 X X X 1 0
         10'b1011100100: bk_o =  40'b0100100100110010000110011001000010011001; //  4 X 3 2 1 X X 0 X X
         10'b1011100101: bk_o =  40'b0101100101000011001010011001000110010000; //  5 X 4 3 2 X X 1 X 0
         10'b1011100110: bk_o =  40'b0101100101000011001010011001000100001001; //  5 X 4 3 2 X X 1 0 X
         10'b1011100111: bk_o =  40'b0110100101010100001110011001001000010000; //  6 X 5 4 3 X X 2 1 0
         10'b1011101000: bk_o =  40'b0100100100110010000110010000100110011001; //  4 X 3 2 1 X 0 X X X
         10'b1011101001: bk_o =  40'b0101100101000011001010010001100110010000; //  5 X 4 3 2 X 1 X X 0
         10'b1011101010: bk_o =  40'b0101100101000011001010010001100100001001; //  5 X 4 3 2 X 1 X 0 X
         10'b1011101011: bk_o =  40'b0110100101010100001110010010100100010000; //  6 X 5 4 3 X 2 X 1 0
         10'b1011101100: bk_o =  40'b0101100101000011001010010001000010011001; //  5 X 4 3 2 X 1 0 X X
         10'b1011101101: bk_o =  40'b0110100101010100001110010010000110010000; //  6 X 5 4 3 X 2 1 X 0
         10'b1011101110: bk_o =  40'b0110100101010100001110010010000100001001; //  6 X 5 4 3 X 2 1 0 X
         10'b1011101111: bk_o =  40'b0111100101100101010010010011001000010000; //  7 X 6 5 4 X 3 2 1 0
         10'b1011110000: bk_o =  40'b0100100100110010000100001001100110011001; //  4 X 3 2 1 0 X X X X
         10'b1011110001: bk_o =  40'b0101100101000011001000011001100110010000; //  5 X 4 3 2 1 X X X 0
         10'b1011110010: bk_o =  40'b0101100101000011001000011001100100001001; //  5 X 4 3 2 1 X X 0 X
         10'b1011110011: bk_o =  40'b0110100101010100001100101001100100010000; //  6 X 5 4 3 2 X X 1 0
         10'b1011110100: bk_o =  40'b0101100101000011001000011001000010011001; //  5 X 4 3 2 1 X 0 X X
         10'b1011110101: bk_o =  40'b0110100101010100001100101001000110010000; //  6 X 5 4 3 2 X 1 X 0
         10'b1011110110: bk_o =  40'b0110100101010100001100101001000100001001; //  6 X 5 4 3 2 X 1 0 X
         10'b1011110111: bk_o =  40'b0111100101100101010000111001001000010000; //  7 X 6 5 4 3 X 2 1 0
         10'b1011111000: bk_o =  40'b0101100101000011001000010000100110011001; //  5 X 4 3 2 1 0 X X X
         10'b1011111001: bk_o =  40'b0110100101010100001100100001100110010000; //  6 X 5 4 3 2 1 X X 0
         10'b1011111010: bk_o =  40'b0110100101010100001100100001100100001001; //  6 X 5 4 3 2 1 X 0 X
         10'b1011111011: bk_o =  40'b0111100101100101010000110010100100010000; //  7 X 6 5 4 3 2 X 1 0
         10'b1011111100: bk_o =  40'b0110100101010100001100100001000010011001; //  6 X 5 4 3 2 1 0 X X
         10'b1011111101: bk_o =  40'b0111100101100101010000110010000110010000; //  7 X 6 5 4 3 2 1 X 0
         10'b1011111110: bk_o =  40'b0111100101100101010000110010000100001001; //  7 X 6 5 4 3 2 1 0 X
         10'b1011111111: bk_o =  40'b1000100101110110010101000011001000010000; //  8 X 7 6 5 4 3 2 1 0
         10'b1100000000: bk_o =  40'b0001000010011001100110011001100110011001; //  1 0 X X X X X X X X
         10'b1100000001: bk_o =  40'b0010000110011001100110011001100110010000; //  2 1 X X X X X X X 0
         10'b1100000010: bk_o =  40'b0010000110011001100110011001100100001001; //  2 1 X X X X X X 0 X
         10'b1100000011: bk_o =  40'b0011001010011001100110011001100100010000; //  3 2 X X X X X X 1 0
         10'b1100000100: bk_o =  40'b0010000110011001100110011001000010011001; //  2 1 X X X X X 0 X X
         10'b1100000101: bk_o =  40'b0011001010011001100110011001000110010000; //  3 2 X X X X X 1 X 0
         10'b1100000110: bk_o =  40'b0011001010011001100110011001000100001001; //  3 2 X X X X X 1 0 X
         10'b1100000111: bk_o =  40'b0100001110011001100110011001001000010000; //  4 3 X X X X X 2 1 0
         10'b1100001000: bk_o =  40'b0010000110011001100110010000100110011001; //  2 1 X X X X 0 X X X
         10'b1100001001: bk_o =  40'b0011001010011001100110010001100110010000; //  3 2 X X X X 1 X X 0
         10'b1100001010: bk_o =  40'b0011001010011001100110010001100100001001; //  3 2 X X X X 1 X 0 X
         10'b1100001011: bk_o =  40'b0100001110011001100110010010100100010000; //  4 3 X X X X 2 X 1 0
         10'b1100001100: bk_o =  40'b0011001010011001100110010001000010011001; //  3 2 X X X X 1 0 X X
         10'b1100001101: bk_o =  40'b0100001110011001100110010010000110010000; //  4 3 X X X X 2 1 X 0
         10'b1100001110: bk_o =  40'b0100001110011001100110010010000100001001; //  4 3 X X X X 2 1 0 X
         10'b1100001111: bk_o =  40'b0101010010011001100110010011001000010000; //  5 4 X X X X 3 2 1 0
         10'b1100010000: bk_o =  40'b0010000110011001100100001001100110011001; //  2 1 X X X 0 X X X X
         10'b1100010001: bk_o =  40'b0011001010011001100100011001100110010000; //  3 2 X X X 1 X X X 0
         10'b1100010010: bk_o =  40'b0011001010011001100100011001100100001001; //  3 2 X X X 1 X X 0 X
         10'b1100010011: bk_o =  40'b0100001110011001100100101001100100010000; //  4 3 X X X 2 X X 1 0
         10'b1100010100: bk_o =  40'b0011001010011001100100011001000010011001; //  3 2 X X X 1 X 0 X X
         10'b1100010101: bk_o =  40'b0100001110011001100100101001000110010000; //  4 3 X X X 2 X 1 X 0
         10'b1100010110: bk_o =  40'b0100001110011001100100101001000100001001; //  4 3 X X X 2 X 1 0 X
         10'b1100010111: bk_o =  40'b0101010010011001100100111001001000010000; //  5 4 X X X 3 X 2 1 0
         10'b1100011000: bk_o =  40'b0011001010011001100100010000100110011001; //  3 2 X X X 1 0 X X X
         10'b1100011001: bk_o =  40'b0100001110011001100100100001100110010000; //  4 3 X X X 2 1 X X 0
         10'b1100011010: bk_o =  40'b0100001110011001100100100001100100001001; //  4 3 X X X 2 1 X 0 X
         10'b1100011011: bk_o =  40'b0101010010011001100100110010100100010000; //  5 4 X X X 3 2 X 1 0
         10'b1100011100: bk_o =  40'b0100001110011001100100100001000010011001; //  4 3 X X X 2 1 0 X X
         10'b1100011101: bk_o =  40'b0101010010011001100100110010000110010000; //  5 4 X X X 3 2 1 X 0
         10'b1100011110: bk_o =  40'b0101010010011001100100110010000100001001; //  5 4 X X X 3 2 1 0 X
         10'b1100011111: bk_o =  40'b0110010110011001100101000011001000010000; //  6 5 X X X 4 3 2 1 0
         10'b1100100000: bk_o =  40'b0010000110011001000010011001100110011001; //  2 1 X X 0 X X X X X
         10'b1100100001: bk_o =  40'b0011001010011001000110011001100110010000; //  3 2 X X 1 X X X X 0
         10'b1100100010: bk_o =  40'b0011001010011001000110011001100100001001; //  3 2 X X 1 X X X 0 X
         10'b1100100011: bk_o =  40'b0100001110011001001010011001100100010000; //  4 3 X X 2 X X X 1 0
         10'b1100100100: bk_o =  40'b0011001010011001000110011001000010011001; //  3 2 X X 1 X X 0 X X
         10'b1100100101: bk_o =  40'b0100001110011001001010011001000110010000; //  4 3 X X 2 X X 1 X 0
         10'b1100100110: bk_o =  40'b0100001110011001001010011001000100001001; //  4 3 X X 2 X X 1 0 X
         10'b1100100111: bk_o =  40'b0101010010011001001110011001001000010000; //  5 4 X X 3 X X 2 1 0
         10'b1100101000: bk_o =  40'b0011001010011001000110010000100110011001; //  3 2 X X 1 X 0 X X X
         10'b1100101001: bk_o =  40'b0100001110011001001010010001100110010000; //  4 3 X X 2 X 1 X X 0
         10'b1100101010: bk_o =  40'b0100001110011001001010010001100100001001; //  4 3 X X 2 X 1 X 0 X
         10'b1100101011: bk_o =  40'b0101010010011001001110010010100100010000; //  5 4 X X 3 X 2 X 1 0
         10'b1100101100: bk_o =  40'b0100001110011001001010010001000010011001; //  4 3 X X 2 X 1 0 X X
         10'b1100101101: bk_o =  40'b0101010010011001001110010010000110010000; //  5 4 X X 3 X 2 1 X 0
         10'b1100101110: bk_o =  40'b0101010010011001001110010010000100001001; //  5 4 X X 3 X 2 1 0 X
         10'b1100101111: bk_o =  40'b0110010110011001010010010011001000010000; //  6 5 X X 4 X 3 2 1 0
         10'b1100110000: bk_o =  40'b0011001010011001000100001001100110011001; //  3 2 X X 1 0 X X X X
         10'b1100110001: bk_o =  40'b0100001110011001001000011001100110010000; //  4 3 X X 2 1 X X X 0
         10'b1100110010: bk_o =  40'b0100001110011001001000011001100100001001; //  4 3 X X 2 1 X X 0 X
         10'b1100110011: bk_o =  40'b0101010010011001001100101001100100010000; //  5 4 X X 3 2 X X 1 0
         10'b1100110100: bk_o =  40'b0100001110011001001000011001000010011001; //  4 3 X X 2 1 X 0 X X
         10'b1100110101: bk_o =  40'b0101010010011001001100101001000110010000; //  5 4 X X 3 2 X 1 X 0
         10'b1100110110: bk_o =  40'b0101010010011001001100101001000100001001; //  5 4 X X 3 2 X 1 0 X
         10'b1100110111: bk_o =  40'b0110010110011001010000111001001000010000; //  6 5 X X 4 3 X 2 1 0
         10'b1100111000: bk_o =  40'b0100001110011001001000010000100110011001; //  4 3 X X 2 1 0 X X X
         10'b1100111001: bk_o =  40'b0101010010011001001100100001100110010000; //  5 4 X X 3 2 1 X X 0
         10'b1100111010: bk_o =  40'b0101010010011001001100100001100100001001; //  5 4 X X 3 2 1 X 0 X
         10'b1100111011: bk_o =  40'b0110010110011001010000110010100100010000; //  6 5 X X 4 3 2 X 1 0
         10'b1100111100: bk_o =  40'b0101010010011001001100100001000010011001; //  5 4 X X 3 2 1 0 X X
         10'b1100111101: bk_o =  40'b0110010110011001010000110010000110010000; //  6 5 X X 4 3 2 1 X 0
         10'b1100111110: bk_o =  40'b0110010110011001010000110010000100001001; //  6 5 X X 4 3 2 1 0 X
         10'b1100111111: bk_o =  40'b0111011010011001010101000011001000010000; //  7 6 X X 5 4 3 2 1 0
         10'b1101000000: bk_o =  40'b0010000110010000100110011001100110011001; //  2 1 X 0 X X X X X X
         10'b1101000001: bk_o =  40'b0011001010010001100110011001100110010000; //  3 2 X 1 X X X X X 0
         10'b1101000010: bk_o =  40'b0011001010010001100110011001100100001001; //  3 2 X 1 X X X X 0 X
         10'b1101000011: bk_o =  40'b0100001110010010100110011001100100010000; //  4 3 X 2 X X X X 1 0
         10'b1101000100: bk_o =  40'b0011001010010001100110011001000010011001; //  3 2 X 1 X X X 0 X X
         10'b1101000101: bk_o =  40'b0100001110010010100110011001000110010000; //  4 3 X 2 X X X 1 X 0
         10'b1101000110: bk_o =  40'b0100001110010010100110011001000100001001; //  4 3 X 2 X X X 1 0 X
         10'b1101000111: bk_o =  40'b0101010010010011100110011001001000010000; //  5 4 X 3 X X X 2 1 0
         10'b1101001000: bk_o =  40'b0011001010010001100110010000100110011001; //  3 2 X 1 X X 0 X X X
         10'b1101001001: bk_o =  40'b0100001110010010100110010001100110010000; //  4 3 X 2 X X 1 X X 0
         10'b1101001010: bk_o =  40'b0100001110010010100110010001100100001001; //  4 3 X 2 X X 1 X 0 X
         10'b1101001011: bk_o =  40'b0101010010010011100110010010100100010000; //  5 4 X 3 X X 2 X 1 0
         10'b1101001100: bk_o =  40'b0100001110010010100110010001000010011001; //  4 3 X 2 X X 1 0 X X
         10'b1101001101: bk_o =  40'b0101010010010011100110010010000110010000; //  5 4 X 3 X X 2 1 X 0
         10'b1101001110: bk_o =  40'b0101010010010011100110010010000100001001; //  5 4 X 3 X X 2 1 0 X
         10'b1101001111: bk_o =  40'b0110010110010100100110010011001000010000; //  6 5 X 4 X X 3 2 1 0
         10'b1101010000: bk_o =  40'b0011001010010001100100001001100110011001; //  3 2 X 1 X 0 X X X X
         10'b1101010001: bk_o =  40'b0100001110010010100100011001100110010000; //  4 3 X 2 X 1 X X X 0
         10'b1101010010: bk_o =  40'b0100001110010010100100011001100100001001; //  4 3 X 2 X 1 X X 0 X
         10'b1101010011: bk_o =  40'b0101010010010011100100101001100100010000; //  5 4 X 3 X 2 X X 1 0
         10'b1101010100: bk_o =  40'b0100001110010010100100011001000010011001; //  4 3 X 2 X 1 X 0 X X
         10'b1101010101: bk_o =  40'b0101010010010011100100101001000110010000; //  5 4 X 3 X 2 X 1 X 0
         10'b1101010110: bk_o =  40'b0101010010010011100100101001000100001001; //  5 4 X 3 X 2 X 1 0 X
         10'b1101010111: bk_o =  40'b0110010110010100100100111001001000010000; //  6 5 X 4 X 3 X 2 1 0
         10'b1101011000: bk_o =  40'b0100001110010010100100010000100110011001; //  4 3 X 2 X 1 0 X X X
         10'b1101011001: bk_o =  40'b0101010010010011100100100001100110010000; //  5 4 X 3 X 2 1 X X 0
         10'b1101011010: bk_o =  40'b0101010010010011100100100001100100001001; //  5 4 X 3 X 2 1 X 0 X
         10'b1101011011: bk_o =  40'b0110010110010100100100110010100100010000; //  6 5 X 4 X 3 2 X 1 0
         10'b1101011100: bk_o =  40'b0101010010010011100100100001000010011001; //  5 4 X 3 X 2 1 0 X X
         10'b1101011101: bk_o =  40'b0110010110010100100100110010000110010000; //  6 5 X 4 X 3 2 1 X 0
         10'b1101011110: bk_o =  40'b0110010110010100100100110010000100001001; //  6 5 X 4 X 3 2 1 0 X
         10'b1101011111: bk_o =  40'b0111011010010101100101000011001000010000; //  7 6 X 5 X 4 3 2 1 0
         10'b1101100000: bk_o =  40'b0011001010010001000010011001100110011001; //  3 2 X 1 0 X X X X X
         10'b1101100001: bk_o =  40'b0100001110010010000110011001100110010000; //  4 3 X 2 1 X X X X 0
         10'b1101100010: bk_o =  40'b0100001110010010000110011001100100001001; //  4 3 X 2 1 X X X 0 X
         10'b1101100011: bk_o =  40'b0101010010010011001010011001100100010000; //  5 4 X 3 2 X X X 1 0
         10'b1101100100: bk_o =  40'b0100001110010010000110011001000010011001; //  4 3 X 2 1 X X 0 X X
         10'b1101100101: bk_o =  40'b0101010010010011001010011001000110010000; //  5 4 X 3 2 X X 1 X 0
         10'b1101100110: bk_o =  40'b0101010010010011001010011001000100001001; //  5 4 X 3 2 X X 1 0 X
         10'b1101100111: bk_o =  40'b0110010110010100001110011001001000010000; //  6 5 X 4 3 X X 2 1 0
         10'b1101101000: bk_o =  40'b0100001110010010000110010000100110011001; //  4 3 X 2 1 X 0 X X X
         10'b1101101001: bk_o =  40'b0101010010010011001010010001100110010000; //  5 4 X 3 2 X 1 X X 0
         10'b1101101010: bk_o =  40'b0101010010010011001010010001100100001001; //  5 4 X 3 2 X 1 X 0 X
         10'b1101101011: bk_o =  40'b0110010110010100001110010010100100010000; //  6 5 X 4 3 X 2 X 1 0
         10'b1101101100: bk_o =  40'b0101010010010011001010010001000010011001; //  5 4 X 3 2 X 1 0 X X
         10'b1101101101: bk_o =  40'b0110010110010100001110010010000110010000; //  6 5 X 4 3 X 2 1 X 0
         10'b1101101110: bk_o =  40'b0110010110010100001110010010000100001001; //  6 5 X 4 3 X 2 1 0 X
         10'b1101101111: bk_o =  40'b0111011010010101010010010011001000010000; //  7 6 X 5 4 X 3 2 1 0
         10'b1101110000: bk_o =  40'b0100001110010010000100001001100110011001; //  4 3 X 2 1 0 X X X X
         10'b1101110001: bk_o =  40'b0101010010010011001000011001100110010000; //  5 4 X 3 2 1 X X X 0
         10'b1101110010: bk_o =  40'b0101010010010011001000011001100100001001; //  5 4 X 3 2 1 X X 0 X
         10'b1101110011: bk_o =  40'b0110010110010100001100101001100100010000; //  6 5 X 4 3 2 X X 1 0
         10'b1101110100: bk_o =  40'b0101010010010011001000011001000010011001; //  5 4 X 3 2 1 X 0 X X
         10'b1101110101: bk_o =  40'b0110010110010100001100101001000110010000; //  6 5 X 4 3 2 X 1 X 0
         10'b1101110110: bk_o =  40'b0110010110010100001100101001000100001001; //  6 5 X 4 3 2 X 1 0 X
         10'b1101110111: bk_o =  40'b0111011010010101010000111001001000010000; //  7 6 X 5 4 3 X 2 1 0
         10'b1101111000: bk_o =  40'b0101010010010011001000010000100110011001; //  5 4 X 3 2 1 0 X X X
         10'b1101111001: bk_o =  40'b0110010110010100001100100001100110010000; //  6 5 X 4 3 2 1 X X 0
         10'b1101111010: bk_o =  40'b0110010110010100001100100001100100001001; //  6 5 X 4 3 2 1 X 0 X
         10'b1101111011: bk_o =  40'b0111011010010101010000110010100100010000; //  7 6 X 5 4 3 2 X 1 0
         10'b1101111100: bk_o =  40'b0110010110010100001100100001000010011001; //  6 5 X 4 3 2 1 0 X X
         10'b1101111101: bk_o =  40'b0111011010010101010000110010000110010000; //  7 6 X 5 4 3 2 1 X 0
         10'b1101111110: bk_o =  40'b0111011010010101010000110010000100001001; //  7 6 X 5 4 3 2 1 0 X
         10'b1101111111: bk_o =  40'b1000011110010110010101000011001000010000; //  8 7 X 6 5 4 3 2 1 0
         10'b1110000000: bk_o =  40'b0010000100001001100110011001100110011001; //  2 1 0 X X X X X X X
         10'b1110000001: bk_o =  40'b0011001000011001100110011001100110010000; //  3 2 1 X X X X X X 0
         10'b1110000010: bk_o =  40'b0011001000011001100110011001100100001001; //  3 2 1 X X X X X 0 X
         10'b1110000011: bk_o =  40'b0100001100101001100110011001100100010000; //  4 3 2 X X X X X 1 0
         10'b1110000100: bk_o =  40'b0011001000011001100110011001000010011001; //  3 2 1 X X X X 0 X X
         10'b1110000101: bk_o =  40'b0100001100101001100110011001000110010000; //  4 3 2 X X X X 1 X 0
         10'b1110000110: bk_o =  40'b0100001100101001100110011001000100001001; //  4 3 2 X X X X 1 0 X
         10'b1110000111: bk_o =  40'b0101010000111001100110011001001000010000; //  5 4 3 X X X X 2 1 0
         10'b1110001000: bk_o =  40'b0011001000011001100110010000100110011001; //  3 2 1 X X X 0 X X X
         10'b1110001001: bk_o =  40'b0100001100101001100110010001100110010000; //  4 3 2 X X X 1 X X 0
         10'b1110001010: bk_o =  40'b0100001100101001100110010001100100001001; //  4 3 2 X X X 1 X 0 X
         10'b1110001011: bk_o =  40'b0101010000111001100110010010100100010000; //  5 4 3 X X X 2 X 1 0
         10'b1110001100: bk_o =  40'b0100001100101001100110010001000010011001; //  4 3 2 X X X 1 0 X X
         10'b1110001101: bk_o =  40'b0101010000111001100110010010000110010000; //  5 4 3 X X X 2 1 X 0
         10'b1110001110: bk_o =  40'b0101010000111001100110010010000100001001; //  5 4 3 X X X 2 1 0 X
         10'b1110001111: bk_o =  40'b0110010101001001100110010011001000010000; //  6 5 4 X X X 3 2 1 0
         10'b1110010000: bk_o =  40'b0011001000011001100100001001100110011001; //  3 2 1 X X 0 X X X X
         10'b1110010001: bk_o =  40'b0100001100101001100100011001100110010000; //  4 3 2 X X 1 X X X 0
         10'b1110010010: bk_o =  40'b0100001100101001100100011001100100001001; //  4 3 2 X X 1 X X 0 X
         10'b1110010011: bk_o =  40'b0101010000111001100100101001100100010000; //  5 4 3 X X 2 X X 1 0
         10'b1110010100: bk_o =  40'b0100001100101001100100011001000010011001; //  4 3 2 X X 1 X 0 X X
         10'b1110010101: bk_o =  40'b0101010000111001100100101001000110010000; //  5 4 3 X X 2 X 1 X 0
         10'b1110010110: bk_o =  40'b0101010000111001100100101001000100001001; //  5 4 3 X X 2 X 1 0 X
         10'b1110010111: bk_o =  40'b0110010101001001100100111001001000010000; //  6 5 4 X X 3 X 2 1 0
         10'b1110011000: bk_o =  40'b0100001100101001100100010000100110011001; //  4 3 2 X X 1 0 X X X
         10'b1110011001: bk_o =  40'b0101010000111001100100100001100110010000; //  5 4 3 X X 2 1 X X 0
         10'b1110011010: bk_o =  40'b0101010000111001100100100001100100001001; //  5 4 3 X X 2 1 X 0 X
         10'b1110011011: bk_o =  40'b0110010101001001100100110010100100010000; //  6 5 4 X X 3 2 X 1 0
         10'b1110011100: bk_o =  40'b0101010000111001100100100001000010011001; //  5 4 3 X X 2 1 0 X X
         10'b1110011101: bk_o =  40'b0110010101001001100100110010000110010000; //  6 5 4 X X 3 2 1 X 0
         10'b1110011110: bk_o =  40'b0110010101001001100100110010000100001001; //  6 5 4 X X 3 2 1 0 X
         10'b1110011111: bk_o =  40'b0111011001011001100101000011001000010000; //  7 6 5 X X 4 3 2 1 0
         10'b1110100000: bk_o =  40'b0011001000011001000010011001100110011001; //  3 2 1 X 0 X X X X X
         10'b1110100001: bk_o =  40'b0100001100101001000110011001100110010000; //  4 3 2 X 1 X X X X 0
         10'b1110100010: bk_o =  40'b0100001100101001000110011001100100001001; //  4 3 2 X 1 X X X 0 X
         10'b1110100011: bk_o =  40'b0101010000111001001010011001100100010000; //  5 4 3 X 2 X X X 1 0
         10'b1110100100: bk_o =  40'b0100001100101001000110011001000010011001; //  4 3 2 X 1 X X 0 X X
         10'b1110100101: bk_o =  40'b0101010000111001001010011001000110010000; //  5 4 3 X 2 X X 1 X 0
         10'b1110100110: bk_o =  40'b0101010000111001001010011001000100001001; //  5 4 3 X 2 X X 1 0 X
         10'b1110100111: bk_o =  40'b0110010101001001001110011001001000010000; //  6 5 4 X 3 X X 2 1 0
         10'b1110101000: bk_o =  40'b0100001100101001000110010000100110011001; //  4 3 2 X 1 X 0 X X X
         10'b1110101001: bk_o =  40'b0101010000111001001010010001100110010000; //  5 4 3 X 2 X 1 X X 0
         10'b1110101010: bk_o =  40'b0101010000111001001010010001100100001001; //  5 4 3 X 2 X 1 X 0 X
         10'b1110101011: bk_o =  40'b0110010101001001001110010010100100010000; //  6 5 4 X 3 X 2 X 1 0
         10'b1110101100: bk_o =  40'b0101010000111001001010010001000010011001; //  5 4 3 X 2 X 1 0 X X
         10'b1110101101: bk_o =  40'b0110010101001001001110010010000110010000; //  6 5 4 X 3 X 2 1 X 0
         10'b1110101110: bk_o =  40'b0110010101001001001110010010000100001001; //  6 5 4 X 3 X 2 1 0 X
         10'b1110101111: bk_o =  40'b0111011001011001010010010011001000010000; //  7 6 5 X 4 X 3 2 1 0
         10'b1110110000: bk_o =  40'b0100001100101001000100001001100110011001; //  4 3 2 X 1 0 X X X X
         10'b1110110001: bk_o =  40'b0101010000111001001000011001100110010000; //  5 4 3 X 2 1 X X X 0
         10'b1110110010: bk_o =  40'b0101010000111001001000011001100100001001; //  5 4 3 X 2 1 X X 0 X
         10'b1110110011: bk_o =  40'b0110010101001001001100101001100100010000; //  6 5 4 X 3 2 X X 1 0
         10'b1110110100: bk_o =  40'b0101010000111001001000011001000010011001; //  5 4 3 X 2 1 X 0 X X
         10'b1110110101: bk_o =  40'b0110010101001001001100101001000110010000; //  6 5 4 X 3 2 X 1 X 0
         10'b1110110110: bk_o =  40'b0110010101001001001100101001000100001001; //  6 5 4 X 3 2 X 1 0 X
         10'b1110110111: bk_o =  40'b0111011001011001010000111001001000010000; //  7 6 5 X 4 3 X 2 1 0
         10'b1110111000: bk_o =  40'b0101010000111001001000010000100110011001; //  5 4 3 X 2 1 0 X X X
         10'b1110111001: bk_o =  40'b0110010101001001001100100001100110010000; //  6 5 4 X 3 2 1 X X 0
         10'b1110111010: bk_o =  40'b0110010101001001001100100001100100001001; //  6 5 4 X 3 2 1 X 0 X
         10'b1110111011: bk_o =  40'b0111011001011001010000110010100100010000; //  7 6 5 X 4 3 2 X 1 0
         10'b1110111100: bk_o =  40'b0110010101001001001100100001000010011001; //  6 5 4 X 3 2 1 0 X X
         10'b1110111101: bk_o =  40'b0111011001011001010000110010000110010000; //  7 6 5 X 4 3 2 1 X 0
         10'b1110111110: bk_o =  40'b0111011001011001010000110010000100001001; //  7 6 5 X 4 3 2 1 0 X
         10'b1110111111: bk_o =  40'b1000011101101001010101000011001000010000; //  8 7 6 X 5 4 3 2 1 0
         10'b1111000000: bk_o =  40'b0011001000010000100110011001100110011001; //  3 2 1 0 X X X X X X
         10'b1111000001: bk_o =  40'b0100001100100001100110011001100110010000; //  4 3 2 1 X X X X X 0
         10'b1111000010: bk_o =  40'b0100001100100001100110011001100100001001; //  4 3 2 1 X X X X 0 X
         10'b1111000011: bk_o =  40'b0101010000110010100110011001100100010000; //  5 4 3 2 X X X X 1 0
         10'b1111000100: bk_o =  40'b0100001100100001100110011001000010011001; //  4 3 2 1 X X X 0 X X
         10'b1111000101: bk_o =  40'b0101010000110010100110011001000110010000; //  5 4 3 2 X X X 1 X 0
         10'b1111000110: bk_o =  40'b0101010000110010100110011001000100001001; //  5 4 3 2 X X X 1 0 X
         10'b1111000111: bk_o =  40'b0110010101000011100110011001001000010000; //  6 5 4 3 X X X 2 1 0
         10'b1111001000: bk_o =  40'b0100001100100001100110010000100110011001; //  4 3 2 1 X X 0 X X X
         10'b1111001001: bk_o =  40'b0101010000110010100110010001100110010000; //  5 4 3 2 X X 1 X X 0
         10'b1111001010: bk_o =  40'b0101010000110010100110010001100100001001; //  5 4 3 2 X X 1 X 0 X
         10'b1111001011: bk_o =  40'b0110010101000011100110010010100100010000; //  6 5 4 3 X X 2 X 1 0
         10'b1111001100: bk_o =  40'b0101010000110010100110010001000010011001; //  5 4 3 2 X X 1 0 X X
         10'b1111001101: bk_o =  40'b0110010101000011100110010010000110010000; //  6 5 4 3 X X 2 1 X 0
         10'b1111001110: bk_o =  40'b0110010101000011100110010010000100001001; //  6 5 4 3 X X 2 1 0 X
         10'b1111001111: bk_o =  40'b0111011001010100100110010011001000010000; //  7 6 5 4 X X 3 2 1 0
         10'b1111010000: bk_o =  40'b0100001100100001100100001001100110011001; //  4 3 2 1 X 0 X X X X
         10'b1111010001: bk_o =  40'b0101010000110010100100011001100110010000; //  5 4 3 2 X 1 X X X 0
         10'b1111010010: bk_o =  40'b0101010000110010100100011001100100001001; //  5 4 3 2 X 1 X X 0 X
         10'b1111010011: bk_o =  40'b0110010101000011100100101001100100010000; //  6 5 4 3 X 2 X X 1 0
         10'b1111010100: bk_o =  40'b0101010000110010100100011001000010011001; //  5 4 3 2 X 1 X 0 X X
         10'b1111010101: bk_o =  40'b0110010101000011100100101001000110010000; //  6 5 4 3 X 2 X 1 X 0
         10'b1111010110: bk_o =  40'b0110010101000011100100101001000100001001; //  6 5 4 3 X 2 X 1 0 X
         10'b1111010111: bk_o =  40'b0111011001010100100100111001001000010000; //  7 6 5 4 X 3 X 2 1 0
         10'b1111011000: bk_o =  40'b0101010000110010100100010000100110011001; //  5 4 3 2 X 1 0 X X X
         10'b1111011001: bk_o =  40'b0110010101000011100100100001100110010000; //  6 5 4 3 X 2 1 X X 0
         10'b1111011010: bk_o =  40'b0110010101000011100100100001100100001001; //  6 5 4 3 X 2 1 X 0 X
         10'b1111011011: bk_o =  40'b0111011001010100100100110010100100010000; //  7 6 5 4 X 3 2 X 1 0
         10'b1111011100: bk_o =  40'b0110010101000011100100100001000010011001; //  6 5 4 3 X 2 1 0 X X
         10'b1111011101: bk_o =  40'b0111011001010100100100110010000110010000; //  7 6 5 4 X 3 2 1 X 0
         10'b1111011110: bk_o =  40'b0111011001010100100100110010000100001001; //  7 6 5 4 X 3 2 1 0 X
         10'b1111011111: bk_o =  40'b1000011101100101100101000011001000010000; //  8 7 6 5 X 4 3 2 1 0
         10'b1111100000: bk_o =  40'b0100001100100001000010011001100110011001; //  4 3 2 1 0 X X X X X
         10'b1111100001: bk_o =  40'b0101010000110010000110011001100110010000; //  5 4 3 2 1 X X X X 0
         10'b1111100010: bk_o =  40'b0101010000110010000110011001100100001001; //  5 4 3 2 1 X X X 0 X
         10'b1111100011: bk_o =  40'b0110010101000011001010011001100100010000; //  6 5 4 3 2 X X X 1 0
         10'b1111100100: bk_o =  40'b0101010000110010000110011001000010011001; //  5 4 3 2 1 X X 0 X X
         10'b1111100101: bk_o =  40'b0110010101000011001010011001000110010000; //  6 5 4 3 2 X X 1 X 0
         10'b1111100110: bk_o =  40'b0110010101000011001010011001000100001001; //  6 5 4 3 2 X X 1 0 X
         10'b1111100111: bk_o =  40'b0111011001010100001110011001001000010000; //  7 6 5 4 3 X X 2 1 0
         10'b1111101000: bk_o =  40'b0101010000110010000110010000100110011001; //  5 4 3 2 1 X 0 X X X
         10'b1111101001: bk_o =  40'b0110010101000011001010010001100110010000; //  6 5 4 3 2 X 1 X X 0
         10'b1111101010: bk_o =  40'b0110010101000011001010010001100100001001; //  6 5 4 3 2 X 1 X 0 X
         10'b1111101011: bk_o =  40'b0111011001010100001110010010100100010000; //  7 6 5 4 3 X 2 X 1 0
         10'b1111101100: bk_o =  40'b0110010101000011001010010001000010011001; //  6 5 4 3 2 X 1 0 X X
         10'b1111101101: bk_o =  40'b0111011001010100001110010010000110010000; //  7 6 5 4 3 X 2 1 X 0
         10'b1111101110: bk_o =  40'b0111011001010100001110010010000100001001; //  7 6 5 4 3 X 2 1 0 X
         10'b1111101111: bk_o =  40'b1000011101100101010010010011001000010000; //  8 7 6 5 4 X 3 2 1 0
         10'b1111110000: bk_o =  40'b0101010000110010000100001001100110011001; //  5 4 3 2 1 0 X X X X
         10'b1111110001: bk_o =  40'b0110010101000011001000011001100110010000; //  6 5 4 3 2 1 X X X 0
         10'b1111110010: bk_o =  40'b0110010101000011001000011001100100001001; //  6 5 4 3 2 1 X X 0 X
         10'b1111110011: bk_o =  40'b0111011001010100001100101001100100010000; //  7 6 5 4 3 2 X X 1 0
         10'b1111110100: bk_o =  40'b0110010101000011001000011001000010011001; //  6 5 4 3 2 1 X 0 X X
         10'b1111110101: bk_o =  40'b0111011001010100001100101001000110010000; //  7 6 5 4 3 2 X 1 X 0
         10'b1111110110: bk_o =  40'b0111011001010100001100101001000100001001; //  7 6 5 4 3 2 X 1 0 X
         10'b1111110111: bk_o =  40'b1000011101100101010000111001001000010000; //  8 7 6 5 4 3 X 2 1 0
         10'b1111111000: bk_o =  40'b0110010101000011001000010000100110011001; //  6 5 4 3 2 1 0 X X X
         10'b1111111001: bk_o =  40'b0111011001010100001100100001100110010000; //  7 6 5 4 3 2 1 X X 0
         10'b1111111010: bk_o =  40'b0111011001010100001100100001100100001001; //  7 6 5 4 3 2 1 X 0 X
         10'b1111111011: bk_o =  40'b1000011101100101010000110010100100010000; //  8 7 6 5 4 3 2 X 1 0
         10'b1111111100: bk_o =  40'b0111011001010100001100100001000010011001; //  7 6 5 4 3 2 1 0 X X
         10'b1111111101: bk_o =  40'b1000011101100101010000110010000110010000; //  8 7 6 5 4 3 2 1 X 0
         10'b1111111110: bk_o =  40'b1000011101100101010000110010000100001001; //  8 7 6 5 4 3 2 1 0 X
         10'b1111111111: bk_o =  40'b1001100001110110010101000011001000010000; //  9 8 7 6 5 4 3 2 1 0
        default: bk_o= 'X;
    endcase

    // backward vec datapath
    always_comb
    unique case (vec_i) 
         10'b0000000000: bk_datapath_o =  40'b0000000000000000000000000000000000000000; //  X X X X X X X X X X
         10'b0000000001: bk_datapath_o =  40'b0000000000000000000000000000000000000000; //  X X X X X X X X X 0
         10'b0000000010: bk_datapath_o =  40'b0000000000000000000000000000000000000000; //  X X X X X X X X 0 X
         10'b0000000011: bk_datapath_o =  40'b0000000000000000000000000000000000010000; //  X X X X X X X X 1 0
         10'b0000000100: bk_datapath_o =  40'b0000000000000000000000000000000000000000; //  X X X X X X X 0 X X
         10'b0000000101: bk_datapath_o =  40'b0000000000000000000000000000000100000000; //  X X X X X X X 1 X 0
         10'b0000000110: bk_datapath_o =  40'b0000000000000000000000000000000100000000; //  X X X X X X X 1 0 X
         10'b0000000111: bk_datapath_o =  40'b0000000000000000000000000000001000010000; //  X X X X X X X 2 1 0
         10'b0000001000: bk_datapath_o =  40'b0000000000000000000000000000000000000000; //  X X X X X X 0 X X X
         10'b0000001001: bk_datapath_o =  40'b0000000000000000000000000001000000000000; //  X X X X X X 1 X X 0
         10'b0000001010: bk_datapath_o =  40'b0000000000000000000000000001000000000000; //  X X X X X X 1 X 0 X
         10'b0000001011: bk_datapath_o =  40'b0000000000000000000000000010000000010000; //  X X X X X X 2 X 1 0
         10'b0000001100: bk_datapath_o =  40'b0000000000000000000000000001000000000000; //  X X X X X X 1 0 X X
         10'b0000001101: bk_datapath_o =  40'b0000000000000000000000000010000100000000; //  X X X X X X 2 1 X 0
         10'b0000001110: bk_datapath_o =  40'b0000000000000000000000000010000100000000; //  X X X X X X 2 1 0 X
         10'b0000001111: bk_datapath_o =  40'b0000000000000000000000000011001000010000; //  X X X X X X 3 2 1 0
         10'b0000010000: bk_datapath_o =  40'b0000000000000000000000000000000000000000; //  X X X X X 0 X X X X
         10'b0000010001: bk_datapath_o =  40'b0000000000000000000000010000000000000000; //  X X X X X 1 X X X 0
         10'b0000010010: bk_datapath_o =  40'b0000000000000000000000010000000000000000; //  X X X X X 1 X X 0 X
         10'b0000010011: bk_datapath_o =  40'b0000000000000000000000100000000000010000; //  X X X X X 2 X X 1 0
         10'b0000010100: bk_datapath_o =  40'b0000000000000000000000010000000000000000; //  X X X X X 1 X 0 X X
         10'b0000010101: bk_datapath_o =  40'b0000000000000000000000100000000100000000; //  X X X X X 2 X 1 X 0
         10'b0000010110: bk_datapath_o =  40'b0000000000000000000000100000000100000000; //  X X X X X 2 X 1 0 X
         10'b0000010111: bk_datapath_o =  40'b0000000000000000000000110000001000010000; //  X X X X X 3 X 2 1 0
         10'b0000011000: bk_datapath_o =  40'b0000000000000000000000010000000000000000; //  X X X X X 1 0 X X X
         10'b0000011001: bk_datapath_o =  40'b0000000000000000000000100001000000000000; //  X X X X X 2 1 X X 0
         10'b0000011010: bk_datapath_o =  40'b0000000000000000000000100001000000000000; //  X X X X X 2 1 X 0 X
         10'b0000011011: bk_datapath_o =  40'b0000000000000000000000110010000000010000; //  X X X X X 3 2 X 1 0
         10'b0000011100: bk_datapath_o =  40'b0000000000000000000000100001000000000000; //  X X X X X 2 1 0 X X
         10'b0000011101: bk_datapath_o =  40'b0000000000000000000000110010000100000000; //  X X X X X 3 2 1 X 0
         10'b0000011110: bk_datapath_o =  40'b0000000000000000000000110010000100000000; //  X X X X X 3 2 1 0 X
         10'b0000011111: bk_datapath_o =  40'b0000000000000000000001000011001000010000; //  X X X X X 4 3 2 1 0
         10'b0000100000: bk_datapath_o =  40'b0000000000000000000000000000000000000000; //  X X X X 0 X X X X X
         10'b0000100001: bk_datapath_o =  40'b0000000000000000000100000000000000000000; //  X X X X 1 X X X X 0
         10'b0000100010: bk_datapath_o =  40'b0000000000000000000100000000000000000000; //  X X X X 1 X X X 0 X
         10'b0000100011: bk_datapath_o =  40'b0000000000000000001000000000000000010000; //  X X X X 2 X X X 1 0
         10'b0000100100: bk_datapath_o =  40'b0000000000000000000100000000000000000000; //  X X X X 1 X X 0 X X
         10'b0000100101: bk_datapath_o =  40'b0000000000000000001000000000000100000000; //  X X X X 2 X X 1 X 0
         10'b0000100110: bk_datapath_o =  40'b0000000000000000001000000000000100000000; //  X X X X 2 X X 1 0 X
         10'b0000100111: bk_datapath_o =  40'b0000000000000000001100000000001000010000; //  X X X X 3 X X 2 1 0
         10'b0000101000: bk_datapath_o =  40'b0000000000000000000100000000000000000000; //  X X X X 1 X 0 X X X
         10'b0000101001: bk_datapath_o =  40'b0000000000000000001000000001000000000000; //  X X X X 2 X 1 X X 0
         10'b0000101010: bk_datapath_o =  40'b0000000000000000001000000001000000000000; //  X X X X 2 X 1 X 0 X
         10'b0000101011: bk_datapath_o =  40'b0000000000000000001100000010000000010000; //  X X X X 3 X 2 X 1 0
         10'b0000101100: bk_datapath_o =  40'b0000000000000000001000000001000000000000; //  X X X X 2 X 1 0 X X
         10'b0000101101: bk_datapath_o =  40'b0000000000000000001100000010000100000000; //  X X X X 3 X 2 1 X 0
         10'b0000101110: bk_datapath_o =  40'b0000000000000000001100000010000100000000; //  X X X X 3 X 2 1 0 X
         10'b0000101111: bk_datapath_o =  40'b0000000000000000010000000011001000010000; //  X X X X 4 X 3 2 1 0
         10'b0000110000: bk_datapath_o =  40'b0000000000000000000100000000000000000000; //  X X X X 1 0 X X X X
         10'b0000110001: bk_datapath_o =  40'b0000000000000000001000010000000000000000; //  X X X X 2 1 X X X 0
         10'b0000110010: bk_datapath_o =  40'b0000000000000000001000010000000000000000; //  X X X X 2 1 X X 0 X
         10'b0000110011: bk_datapath_o =  40'b0000000000000000001100100000000000010000; //  X X X X 3 2 X X 1 0
         10'b0000110100: bk_datapath_o =  40'b0000000000000000001000010000000000000000; //  X X X X 2 1 X 0 X X
         10'b0000110101: bk_datapath_o =  40'b0000000000000000001100100000000100000000; //  X X X X 3 2 X 1 X 0
         10'b0000110110: bk_datapath_o =  40'b0000000000000000001100100000000100000000; //  X X X X 3 2 X 1 0 X
         10'b0000110111: bk_datapath_o =  40'b0000000000000000010000110000001000010000; //  X X X X 4 3 X 2 1 0
         10'b0000111000: bk_datapath_o =  40'b0000000000000000001000010000000000000000; //  X X X X 2 1 0 X X X
         10'b0000111001: bk_datapath_o =  40'b0000000000000000001100100001000000000000; //  X X X X 3 2 1 X X 0
         10'b0000111010: bk_datapath_o =  40'b0000000000000000001100100001000000000000; //  X X X X 3 2 1 X 0 X
         10'b0000111011: bk_datapath_o =  40'b0000000000000000010000110010000000010000; //  X X X X 4 3 2 X 1 0
         10'b0000111100: bk_datapath_o =  40'b0000000000000000001100100001000000000000; //  X X X X 3 2 1 0 X X
         10'b0000111101: bk_datapath_o =  40'b0000000000000000010000110010000100000000; //  X X X X 4 3 2 1 X 0
         10'b0000111110: bk_datapath_o =  40'b0000000000000000010000110010000100000000; //  X X X X 4 3 2 1 0 X
         10'b0000111111: bk_datapath_o =  40'b0000000000000000010101000011001000010000; //  X X X X 5 4 3 2 1 0
         10'b0001000000: bk_datapath_o =  40'b0000000000000000000000000000000000000000; //  X X X 0 X X X X X X
         10'b0001000001: bk_datapath_o =  40'b0000000000000001000000000000000000000000; //  X X X 1 X X X X X 0
         10'b0001000010: bk_datapath_o =  40'b0000000000000001000000000000000000000000; //  X X X 1 X X X X 0 X
         10'b0001000011: bk_datapath_o =  40'b0000000000000010000000000000000000010000; //  X X X 2 X X X X 1 0
         10'b0001000100: bk_datapath_o =  40'b0000000000000001000000000000000000000000; //  X X X 1 X X X 0 X X
         10'b0001000101: bk_datapath_o =  40'b0000000000000010000000000000000100000000; //  X X X 2 X X X 1 X 0
         10'b0001000110: bk_datapath_o =  40'b0000000000000010000000000000000100000000; //  X X X 2 X X X 1 0 X
         10'b0001000111: bk_datapath_o =  40'b0000000000000011000000000000001000010000; //  X X X 3 X X X 2 1 0
         10'b0001001000: bk_datapath_o =  40'b0000000000000001000000000000000000000000; //  X X X 1 X X 0 X X X
         10'b0001001001: bk_datapath_o =  40'b0000000000000010000000000001000000000000; //  X X X 2 X X 1 X X 0
         10'b0001001010: bk_datapath_o =  40'b0000000000000010000000000001000000000000; //  X X X 2 X X 1 X 0 X
         10'b0001001011: bk_datapath_o =  40'b0000000000000011000000000010000000010000; //  X X X 3 X X 2 X 1 0
         10'b0001001100: bk_datapath_o =  40'b0000000000000010000000000001000000000000; //  X X X 2 X X 1 0 X X
         10'b0001001101: bk_datapath_o =  40'b0000000000000011000000000010000100000000; //  X X X 3 X X 2 1 X 0
         10'b0001001110: bk_datapath_o =  40'b0000000000000011000000000010000100000000; //  X X X 3 X X 2 1 0 X
         10'b0001001111: bk_datapath_o =  40'b0000000000000100000000000011001000010000; //  X X X 4 X X 3 2 1 0
         10'b0001010000: bk_datapath_o =  40'b0000000000000001000000000000000000000000; //  X X X 1 X 0 X X X X
         10'b0001010001: bk_datapath_o =  40'b0000000000000010000000010000000000000000; //  X X X 2 X 1 X X X 0
         10'b0001010010: bk_datapath_o =  40'b0000000000000010000000010000000000000000; //  X X X 2 X 1 X X 0 X
         10'b0001010011: bk_datapath_o =  40'b0000000000000011000000100000000000010000; //  X X X 3 X 2 X X 1 0
         10'b0001010100: bk_datapath_o =  40'b0000000000000010000000010000000000000000; //  X X X 2 X 1 X 0 X X
         10'b0001010101: bk_datapath_o =  40'b0000000000000011000000100000000100000000; //  X X X 3 X 2 X 1 X 0
         10'b0001010110: bk_datapath_o =  40'b0000000000000011000000100000000100000000; //  X X X 3 X 2 X 1 0 X
         10'b0001010111: bk_datapath_o =  40'b0000000000000100000000110000001000010000; //  X X X 4 X 3 X 2 1 0
         10'b0001011000: bk_datapath_o =  40'b0000000000000010000000010000000000000000; //  X X X 2 X 1 0 X X X
         10'b0001011001: bk_datapath_o =  40'b0000000000000011000000100001000000000000; //  X X X 3 X 2 1 X X 0
         10'b0001011010: bk_datapath_o =  40'b0000000000000011000000100001000000000000; //  X X X 3 X 2 1 X 0 X
         10'b0001011011: bk_datapath_o =  40'b0000000000000100000000110010000000010000; //  X X X 4 X 3 2 X 1 0
         10'b0001011100: bk_datapath_o =  40'b0000000000000011000000100001000000000000; //  X X X 3 X 2 1 0 X X
         10'b0001011101: bk_datapath_o =  40'b0000000000000100000000110010000100000000; //  X X X 4 X 3 2 1 X 0
         10'b0001011110: bk_datapath_o =  40'b0000000000000100000000110010000100000000; //  X X X 4 X 3 2 1 0 X
         10'b0001011111: bk_datapath_o =  40'b0000000000000101000001000011001000010000; //  X X X 5 X 4 3 2 1 0
         10'b0001100000: bk_datapath_o =  40'b0000000000000001000000000000000000000000; //  X X X 1 0 X X X X X
         10'b0001100001: bk_datapath_o =  40'b0000000000000010000100000000000000000000; //  X X X 2 1 X X X X 0
         10'b0001100010: bk_datapath_o =  40'b0000000000000010000100000000000000000000; //  X X X 2 1 X X X 0 X
         10'b0001100011: bk_datapath_o =  40'b0000000000000011001000000000000000010000; //  X X X 3 2 X X X 1 0
         10'b0001100100: bk_datapath_o =  40'b0000000000000010000100000000000000000000; //  X X X 2 1 X X 0 X X
         10'b0001100101: bk_datapath_o =  40'b0000000000000011001000000000000100000000; //  X X X 3 2 X X 1 X 0
         10'b0001100110: bk_datapath_o =  40'b0000000000000011001000000000000100000000; //  X X X 3 2 X X 1 0 X
         10'b0001100111: bk_datapath_o =  40'b0000000000000100001100000000001000010000; //  X X X 4 3 X X 2 1 0
         10'b0001101000: bk_datapath_o =  40'b0000000000000010000100000000000000000000; //  X X X 2 1 X 0 X X X
         10'b0001101001: bk_datapath_o =  40'b0000000000000011001000000001000000000000; //  X X X 3 2 X 1 X X 0
         10'b0001101010: bk_datapath_o =  40'b0000000000000011001000000001000000000000; //  X X X 3 2 X 1 X 0 X
         10'b0001101011: bk_datapath_o =  40'b0000000000000100001100000010000000010000; //  X X X 4 3 X 2 X 1 0
         10'b0001101100: bk_datapath_o =  40'b0000000000000011001000000001000000000000; //  X X X 3 2 X 1 0 X X
         10'b0001101101: bk_datapath_o =  40'b0000000000000100001100000010000100000000; //  X X X 4 3 X 2 1 X 0
         10'b0001101110: bk_datapath_o =  40'b0000000000000100001100000010000100000000; //  X X X 4 3 X 2 1 0 X
         10'b0001101111: bk_datapath_o =  40'b0000000000000101010000000011001000010000; //  X X X 5 4 X 3 2 1 0
         10'b0001110000: bk_datapath_o =  40'b0000000000000010000100000000000000000000; //  X X X 2 1 0 X X X X
         10'b0001110001: bk_datapath_o =  40'b0000000000000011001000010000000000000000; //  X X X 3 2 1 X X X 0
         10'b0001110010: bk_datapath_o =  40'b0000000000000011001000010000000000000000; //  X X X 3 2 1 X X 0 X
         10'b0001110011: bk_datapath_o =  40'b0000000000000100001100100000000000010000; //  X X X 4 3 2 X X 1 0
         10'b0001110100: bk_datapath_o =  40'b0000000000000011001000010000000000000000; //  X X X 3 2 1 X 0 X X
         10'b0001110101: bk_datapath_o =  40'b0000000000000100001100100000000100000000; //  X X X 4 3 2 X 1 X 0
         10'b0001110110: bk_datapath_o =  40'b0000000000000100001100100000000100000000; //  X X X 4 3 2 X 1 0 X
         10'b0001110111: bk_datapath_o =  40'b0000000000000101010000110000001000010000; //  X X X 5 4 3 X 2 1 0
         10'b0001111000: bk_datapath_o =  40'b0000000000000011001000010000000000000000; //  X X X 3 2 1 0 X X X
         10'b0001111001: bk_datapath_o =  40'b0000000000000100001100100001000000000000; //  X X X 4 3 2 1 X X 0
         10'b0001111010: bk_datapath_o =  40'b0000000000000100001100100001000000000000; //  X X X 4 3 2 1 X 0 X
         10'b0001111011: bk_datapath_o =  40'b0000000000000101010000110010000000010000; //  X X X 5 4 3 2 X 1 0
         10'b0001111100: bk_datapath_o =  40'b0000000000000100001100100001000000000000; //  X X X 4 3 2 1 0 X X
         10'b0001111101: bk_datapath_o =  40'b0000000000000101010000110010000100000000; //  X X X 5 4 3 2 1 X 0
         10'b0001111110: bk_datapath_o =  40'b0000000000000101010000110010000100000000; //  X X X 5 4 3 2 1 0 X
         10'b0001111111: bk_datapath_o =  40'b0000000000000110010101000011001000010000; //  X X X 6 5 4 3 2 1 0
         10'b0010000000: bk_datapath_o =  40'b0000000000000000000000000000000000000000; //  X X 0 X X X X X X X
         10'b0010000001: bk_datapath_o =  40'b0000000000010000000000000000000000000000; //  X X 1 X X X X X X 0
         10'b0010000010: bk_datapath_o =  40'b0000000000010000000000000000000000000000; //  X X 1 X X X X X 0 X
         10'b0010000011: bk_datapath_o =  40'b0000000000100000000000000000000000010000; //  X X 2 X X X X X 1 0
         10'b0010000100: bk_datapath_o =  40'b0000000000010000000000000000000000000000; //  X X 1 X X X X 0 X X
         10'b0010000101: bk_datapath_o =  40'b0000000000100000000000000000000100000000; //  X X 2 X X X X 1 X 0
         10'b0010000110: bk_datapath_o =  40'b0000000000100000000000000000000100000000; //  X X 2 X X X X 1 0 X
         10'b0010000111: bk_datapath_o =  40'b0000000000110000000000000000001000010000; //  X X 3 X X X X 2 1 0
         10'b0010001000: bk_datapath_o =  40'b0000000000010000000000000000000000000000; //  X X 1 X X X 0 X X X
         10'b0010001001: bk_datapath_o =  40'b0000000000100000000000000001000000000000; //  X X 2 X X X 1 X X 0
         10'b0010001010: bk_datapath_o =  40'b0000000000100000000000000001000000000000; //  X X 2 X X X 1 X 0 X
         10'b0010001011: bk_datapath_o =  40'b0000000000110000000000000010000000010000; //  X X 3 X X X 2 X 1 0
         10'b0010001100: bk_datapath_o =  40'b0000000000100000000000000001000000000000; //  X X 2 X X X 1 0 X X
         10'b0010001101: bk_datapath_o =  40'b0000000000110000000000000010000100000000; //  X X 3 X X X 2 1 X 0
         10'b0010001110: bk_datapath_o =  40'b0000000000110000000000000010000100000000; //  X X 3 X X X 2 1 0 X
         10'b0010001111: bk_datapath_o =  40'b0000000001000000000000000011001000010000; //  X X 4 X X X 3 2 1 0
         10'b0010010000: bk_datapath_o =  40'b0000000000010000000000000000000000000000; //  X X 1 X X 0 X X X X
         10'b0010010001: bk_datapath_o =  40'b0000000000100000000000010000000000000000; //  X X 2 X X 1 X X X 0
         10'b0010010010: bk_datapath_o =  40'b0000000000100000000000010000000000000000; //  X X 2 X X 1 X X 0 X
         10'b0010010011: bk_datapath_o =  40'b0000000000110000000000100000000000010000; //  X X 3 X X 2 X X 1 0
         10'b0010010100: bk_datapath_o =  40'b0000000000100000000000010000000000000000; //  X X 2 X X 1 X 0 X X
         10'b0010010101: bk_datapath_o =  40'b0000000000110000000000100000000100000000; //  X X 3 X X 2 X 1 X 0
         10'b0010010110: bk_datapath_o =  40'b0000000000110000000000100000000100000000; //  X X 3 X X 2 X 1 0 X
         10'b0010010111: bk_datapath_o =  40'b0000000001000000000000110000001000010000; //  X X 4 X X 3 X 2 1 0
         10'b0010011000: bk_datapath_o =  40'b0000000000100000000000010000000000000000; //  X X 2 X X 1 0 X X X
         10'b0010011001: bk_datapath_o =  40'b0000000000110000000000100001000000000000; //  X X 3 X X 2 1 X X 0
         10'b0010011010: bk_datapath_o =  40'b0000000000110000000000100001000000000000; //  X X 3 X X 2 1 X 0 X
         10'b0010011011: bk_datapath_o =  40'b0000000001000000000000110010000000010000; //  X X 4 X X 3 2 X 1 0
         10'b0010011100: bk_datapath_o =  40'b0000000000110000000000100001000000000000; //  X X 3 X X 2 1 0 X X
         10'b0010011101: bk_datapath_o =  40'b0000000001000000000000110010000100000000; //  X X 4 X X 3 2 1 X 0
         10'b0010011110: bk_datapath_o =  40'b0000000001000000000000110010000100000000; //  X X 4 X X 3 2 1 0 X
         10'b0010011111: bk_datapath_o =  40'b0000000001010000000001000011001000010000; //  X X 5 X X 4 3 2 1 0
         10'b0010100000: bk_datapath_o =  40'b0000000000010000000000000000000000000000; //  X X 1 X 0 X X X X X
         10'b0010100001: bk_datapath_o =  40'b0000000000100000000100000000000000000000; //  X X 2 X 1 X X X X 0
         10'b0010100010: bk_datapath_o =  40'b0000000000100000000100000000000000000000; //  X X 2 X 1 X X X 0 X
         10'b0010100011: bk_datapath_o =  40'b0000000000110000001000000000000000010000; //  X X 3 X 2 X X X 1 0
         10'b0010100100: bk_datapath_o =  40'b0000000000100000000100000000000000000000; //  X X 2 X 1 X X 0 X X
         10'b0010100101: bk_datapath_o =  40'b0000000000110000001000000000000100000000; //  X X 3 X 2 X X 1 X 0
         10'b0010100110: bk_datapath_o =  40'b0000000000110000001000000000000100000000; //  X X 3 X 2 X X 1 0 X
         10'b0010100111: bk_datapath_o =  40'b0000000001000000001100000000001000010000; //  X X 4 X 3 X X 2 1 0
         10'b0010101000: bk_datapath_o =  40'b0000000000100000000100000000000000000000; //  X X 2 X 1 X 0 X X X
         10'b0010101001: bk_datapath_o =  40'b0000000000110000001000000001000000000000; //  X X 3 X 2 X 1 X X 0
         10'b0010101010: bk_datapath_o =  40'b0000000000110000001000000001000000000000; //  X X 3 X 2 X 1 X 0 X
         10'b0010101011: bk_datapath_o =  40'b0000000001000000001100000010000000010000; //  X X 4 X 3 X 2 X 1 0
         10'b0010101100: bk_datapath_o =  40'b0000000000110000001000000001000000000000; //  X X 3 X 2 X 1 0 X X
         10'b0010101101: bk_datapath_o =  40'b0000000001000000001100000010000100000000; //  X X 4 X 3 X 2 1 X 0
         10'b0010101110: bk_datapath_o =  40'b0000000001000000001100000010000100000000; //  X X 4 X 3 X 2 1 0 X
         10'b0010101111: bk_datapath_o =  40'b0000000001010000010000000011001000010000; //  X X 5 X 4 X 3 2 1 0
         10'b0010110000: bk_datapath_o =  40'b0000000000100000000100000000000000000000; //  X X 2 X 1 0 X X X X
         10'b0010110001: bk_datapath_o =  40'b0000000000110000001000010000000000000000; //  X X 3 X 2 1 X X X 0
         10'b0010110010: bk_datapath_o =  40'b0000000000110000001000010000000000000000; //  X X 3 X 2 1 X X 0 X
         10'b0010110011: bk_datapath_o =  40'b0000000001000000001100100000000000010000; //  X X 4 X 3 2 X X 1 0
         10'b0010110100: bk_datapath_o =  40'b0000000000110000001000010000000000000000; //  X X 3 X 2 1 X 0 X X
         10'b0010110101: bk_datapath_o =  40'b0000000001000000001100100000000100000000; //  X X 4 X 3 2 X 1 X 0
         10'b0010110110: bk_datapath_o =  40'b0000000001000000001100100000000100000000; //  X X 4 X 3 2 X 1 0 X
         10'b0010110111: bk_datapath_o =  40'b0000000001010000010000110000001000010000; //  X X 5 X 4 3 X 2 1 0
         10'b0010111000: bk_datapath_o =  40'b0000000000110000001000010000000000000000; //  X X 3 X 2 1 0 X X X
         10'b0010111001: bk_datapath_o =  40'b0000000001000000001100100001000000000000; //  X X 4 X 3 2 1 X X 0
         10'b0010111010: bk_datapath_o =  40'b0000000001000000001100100001000000000000; //  X X 4 X 3 2 1 X 0 X
         10'b0010111011: bk_datapath_o =  40'b0000000001010000010000110010000000010000; //  X X 5 X 4 3 2 X 1 0
         10'b0010111100: bk_datapath_o =  40'b0000000001000000001100100001000000000000; //  X X 4 X 3 2 1 0 X X
         10'b0010111101: bk_datapath_o =  40'b0000000001010000010000110010000100000000; //  X X 5 X 4 3 2 1 X 0
         10'b0010111110: bk_datapath_o =  40'b0000000001010000010000110010000100000000; //  X X 5 X 4 3 2 1 0 X
         10'b0010111111: bk_datapath_o =  40'b0000000001100000010101000011001000010000; //  X X 6 X 5 4 3 2 1 0
         10'b0011000000: bk_datapath_o =  40'b0000000000010000000000000000000000000000; //  X X 1 0 X X X X X X
         10'b0011000001: bk_datapath_o =  40'b0000000000100001000000000000000000000000; //  X X 2 1 X X X X X 0
         10'b0011000010: bk_datapath_o =  40'b0000000000100001000000000000000000000000; //  X X 2 1 X X X X 0 X
         10'b0011000011: bk_datapath_o =  40'b0000000000110010000000000000000000010000; //  X X 3 2 X X X X 1 0
         10'b0011000100: bk_datapath_o =  40'b0000000000100001000000000000000000000000; //  X X 2 1 X X X 0 X X
         10'b0011000101: bk_datapath_o =  40'b0000000000110010000000000000000100000000; //  X X 3 2 X X X 1 X 0
         10'b0011000110: bk_datapath_o =  40'b0000000000110010000000000000000100000000; //  X X 3 2 X X X 1 0 X
         10'b0011000111: bk_datapath_o =  40'b0000000001000011000000000000001000010000; //  X X 4 3 X X X 2 1 0
         10'b0011001000: bk_datapath_o =  40'b0000000000100001000000000000000000000000; //  X X 2 1 X X 0 X X X
         10'b0011001001: bk_datapath_o =  40'b0000000000110010000000000001000000000000; //  X X 3 2 X X 1 X X 0
         10'b0011001010: bk_datapath_o =  40'b0000000000110010000000000001000000000000; //  X X 3 2 X X 1 X 0 X
         10'b0011001011: bk_datapath_o =  40'b0000000001000011000000000010000000010000; //  X X 4 3 X X 2 X 1 0
         10'b0011001100: bk_datapath_o =  40'b0000000000110010000000000001000000000000; //  X X 3 2 X X 1 0 X X
         10'b0011001101: bk_datapath_o =  40'b0000000001000011000000000010000100000000; //  X X 4 3 X X 2 1 X 0
         10'b0011001110: bk_datapath_o =  40'b0000000001000011000000000010000100000000; //  X X 4 3 X X 2 1 0 X
         10'b0011001111: bk_datapath_o =  40'b0000000001010100000000000011001000010000; //  X X 5 4 X X 3 2 1 0
         10'b0011010000: bk_datapath_o =  40'b0000000000100001000000000000000000000000; //  X X 2 1 X 0 X X X X
         10'b0011010001: bk_datapath_o =  40'b0000000000110010000000010000000000000000; //  X X 3 2 X 1 X X X 0
         10'b0011010010: bk_datapath_o =  40'b0000000000110010000000010000000000000000; //  X X 3 2 X 1 X X 0 X
         10'b0011010011: bk_datapath_o =  40'b0000000001000011000000100000000000010000; //  X X 4 3 X 2 X X 1 0
         10'b0011010100: bk_datapath_o =  40'b0000000000110010000000010000000000000000; //  X X 3 2 X 1 X 0 X X
         10'b0011010101: bk_datapath_o =  40'b0000000001000011000000100000000100000000; //  X X 4 3 X 2 X 1 X 0
         10'b0011010110: bk_datapath_o =  40'b0000000001000011000000100000000100000000; //  X X 4 3 X 2 X 1 0 X
         10'b0011010111: bk_datapath_o =  40'b0000000001010100000000110000001000010000; //  X X 5 4 X 3 X 2 1 0
         10'b0011011000: bk_datapath_o =  40'b0000000000110010000000010000000000000000; //  X X 3 2 X 1 0 X X X
         10'b0011011001: bk_datapath_o =  40'b0000000001000011000000100001000000000000; //  X X 4 3 X 2 1 X X 0
         10'b0011011010: bk_datapath_o =  40'b0000000001000011000000100001000000000000; //  X X 4 3 X 2 1 X 0 X
         10'b0011011011: bk_datapath_o =  40'b0000000001010100000000110010000000010000; //  X X 5 4 X 3 2 X 1 0
         10'b0011011100: bk_datapath_o =  40'b0000000001000011000000100001000000000000; //  X X 4 3 X 2 1 0 X X
         10'b0011011101: bk_datapath_o =  40'b0000000001010100000000110010000100000000; //  X X 5 4 X 3 2 1 X 0
         10'b0011011110: bk_datapath_o =  40'b0000000001010100000000110010000100000000; //  X X 5 4 X 3 2 1 0 X
         10'b0011011111: bk_datapath_o =  40'b0000000001100101000001000011001000010000; //  X X 6 5 X 4 3 2 1 0
         10'b0011100000: bk_datapath_o =  40'b0000000000100001000000000000000000000000; //  X X 2 1 0 X X X X X
         10'b0011100001: bk_datapath_o =  40'b0000000000110010000100000000000000000000; //  X X 3 2 1 X X X X 0
         10'b0011100010: bk_datapath_o =  40'b0000000000110010000100000000000000000000; //  X X 3 2 1 X X X 0 X
         10'b0011100011: bk_datapath_o =  40'b0000000001000011001000000000000000010000; //  X X 4 3 2 X X X 1 0
         10'b0011100100: bk_datapath_o =  40'b0000000000110010000100000000000000000000; //  X X 3 2 1 X X 0 X X
         10'b0011100101: bk_datapath_o =  40'b0000000001000011001000000000000100000000; //  X X 4 3 2 X X 1 X 0
         10'b0011100110: bk_datapath_o =  40'b0000000001000011001000000000000100000000; //  X X 4 3 2 X X 1 0 X
         10'b0011100111: bk_datapath_o =  40'b0000000001010100001100000000001000010000; //  X X 5 4 3 X X 2 1 0
         10'b0011101000: bk_datapath_o =  40'b0000000000110010000100000000000000000000; //  X X 3 2 1 X 0 X X X
         10'b0011101001: bk_datapath_o =  40'b0000000001000011001000000001000000000000; //  X X 4 3 2 X 1 X X 0
         10'b0011101010: bk_datapath_o =  40'b0000000001000011001000000001000000000000; //  X X 4 3 2 X 1 X 0 X
         10'b0011101011: bk_datapath_o =  40'b0000000001010100001100000010000000010000; //  X X 5 4 3 X 2 X 1 0
         10'b0011101100: bk_datapath_o =  40'b0000000001000011001000000001000000000000; //  X X 4 3 2 X 1 0 X X
         10'b0011101101: bk_datapath_o =  40'b0000000001010100001100000010000100000000; //  X X 5 4 3 X 2 1 X 0
         10'b0011101110: bk_datapath_o =  40'b0000000001010100001100000010000100000000; //  X X 5 4 3 X 2 1 0 X
         10'b0011101111: bk_datapath_o =  40'b0000000001100101010000000011001000010000; //  X X 6 5 4 X 3 2 1 0
         10'b0011110000: bk_datapath_o =  40'b0000000000110010000100000000000000000000; //  X X 3 2 1 0 X X X X
         10'b0011110001: bk_datapath_o =  40'b0000000001000011001000010000000000000000; //  X X 4 3 2 1 X X X 0
         10'b0011110010: bk_datapath_o =  40'b0000000001000011001000010000000000000000; //  X X 4 3 2 1 X X 0 X
         10'b0011110011: bk_datapath_o =  40'b0000000001010100001100100000000000010000; //  X X 5 4 3 2 X X 1 0
         10'b0011110100: bk_datapath_o =  40'b0000000001000011001000010000000000000000; //  X X 4 3 2 1 X 0 X X
         10'b0011110101: bk_datapath_o =  40'b0000000001010100001100100000000100000000; //  X X 5 4 3 2 X 1 X 0
         10'b0011110110: bk_datapath_o =  40'b0000000001010100001100100000000100000000; //  X X 5 4 3 2 X 1 0 X
         10'b0011110111: bk_datapath_o =  40'b0000000001100101010000110000001000010000; //  X X 6 5 4 3 X 2 1 0
         10'b0011111000: bk_datapath_o =  40'b0000000001000011001000010000000000000000; //  X X 4 3 2 1 0 X X X
         10'b0011111001: bk_datapath_o =  40'b0000000001010100001100100001000000000000; //  X X 5 4 3 2 1 X X 0
         10'b0011111010: bk_datapath_o =  40'b0000000001010100001100100001000000000000; //  X X 5 4 3 2 1 X 0 X
         10'b0011111011: bk_datapath_o =  40'b0000000001100101010000110010000000010000; //  X X 6 5 4 3 2 X 1 0
         10'b0011111100: bk_datapath_o =  40'b0000000001010100001100100001000000000000; //  X X 5 4 3 2 1 0 X X
         10'b0011111101: bk_datapath_o =  40'b0000000001100101010000110010000100000000; //  X X 6 5 4 3 2 1 X 0
         10'b0011111110: bk_datapath_o =  40'b0000000001100101010000110010000100000000; //  X X 6 5 4 3 2 1 0 X
         10'b0011111111: bk_datapath_o =  40'b0000000001110110010101000011001000010000; //  X X 7 6 5 4 3 2 1 0
         10'b0100000000: bk_datapath_o =  40'b0000000000000000000000000000000000000000; //  X 0 X X X X X X X X
         10'b0100000001: bk_datapath_o =  40'b0000000100000000000000000000000000000000; //  X 1 X X X X X X X 0
         10'b0100000010: bk_datapath_o =  40'b0000000100000000000000000000000000000000; //  X 1 X X X X X X 0 X
         10'b0100000011: bk_datapath_o =  40'b0000001000000000000000000000000000010000; //  X 2 X X X X X X 1 0
         10'b0100000100: bk_datapath_o =  40'b0000000100000000000000000000000000000000; //  X 1 X X X X X 0 X X
         10'b0100000101: bk_datapath_o =  40'b0000001000000000000000000000000100000000; //  X 2 X X X X X 1 X 0
         10'b0100000110: bk_datapath_o =  40'b0000001000000000000000000000000100000000; //  X 2 X X X X X 1 0 X
         10'b0100000111: bk_datapath_o =  40'b0000001100000000000000000000001000010000; //  X 3 X X X X X 2 1 0
         10'b0100001000: bk_datapath_o =  40'b0000000100000000000000000000000000000000; //  X 1 X X X X 0 X X X
         10'b0100001001: bk_datapath_o =  40'b0000001000000000000000000001000000000000; //  X 2 X X X X 1 X X 0
         10'b0100001010: bk_datapath_o =  40'b0000001000000000000000000001000000000000; //  X 2 X X X X 1 X 0 X
         10'b0100001011: bk_datapath_o =  40'b0000001100000000000000000010000000010000; //  X 3 X X X X 2 X 1 0
         10'b0100001100: bk_datapath_o =  40'b0000001000000000000000000001000000000000; //  X 2 X X X X 1 0 X X
         10'b0100001101: bk_datapath_o =  40'b0000001100000000000000000010000100000000; //  X 3 X X X X 2 1 X 0
         10'b0100001110: bk_datapath_o =  40'b0000001100000000000000000010000100000000; //  X 3 X X X X 2 1 0 X
         10'b0100001111: bk_datapath_o =  40'b0000010000000000000000000011001000010000; //  X 4 X X X X 3 2 1 0
         10'b0100010000: bk_datapath_o =  40'b0000000100000000000000000000000000000000; //  X 1 X X X 0 X X X X
         10'b0100010001: bk_datapath_o =  40'b0000001000000000000000010000000000000000; //  X 2 X X X 1 X X X 0
         10'b0100010010: bk_datapath_o =  40'b0000001000000000000000010000000000000000; //  X 2 X X X 1 X X 0 X
         10'b0100010011: bk_datapath_o =  40'b0000001100000000000000100000000000010000; //  X 3 X X X 2 X X 1 0
         10'b0100010100: bk_datapath_o =  40'b0000001000000000000000010000000000000000; //  X 2 X X X 1 X 0 X X
         10'b0100010101: bk_datapath_o =  40'b0000001100000000000000100000000100000000; //  X 3 X X X 2 X 1 X 0
         10'b0100010110: bk_datapath_o =  40'b0000001100000000000000100000000100000000; //  X 3 X X X 2 X 1 0 X
         10'b0100010111: bk_datapath_o =  40'b0000010000000000000000110000001000010000; //  X 4 X X X 3 X 2 1 0
         10'b0100011000: bk_datapath_o =  40'b0000001000000000000000010000000000000000; //  X 2 X X X 1 0 X X X
         10'b0100011001: bk_datapath_o =  40'b0000001100000000000000100001000000000000; //  X 3 X X X 2 1 X X 0
         10'b0100011010: bk_datapath_o =  40'b0000001100000000000000100001000000000000; //  X 3 X X X 2 1 X 0 X
         10'b0100011011: bk_datapath_o =  40'b0000010000000000000000110010000000010000; //  X 4 X X X 3 2 X 1 0
         10'b0100011100: bk_datapath_o =  40'b0000001100000000000000100001000000000000; //  X 3 X X X 2 1 0 X X
         10'b0100011101: bk_datapath_o =  40'b0000010000000000000000110010000100000000; //  X 4 X X X 3 2 1 X 0
         10'b0100011110: bk_datapath_o =  40'b0000010000000000000000110010000100000000; //  X 4 X X X 3 2 1 0 X
         10'b0100011111: bk_datapath_o =  40'b0000010100000000000001000011001000010000; //  X 5 X X X 4 3 2 1 0
         10'b0100100000: bk_datapath_o =  40'b0000000100000000000000000000000000000000; //  X 1 X X 0 X X X X X
         10'b0100100001: bk_datapath_o =  40'b0000001000000000000100000000000000000000; //  X 2 X X 1 X X X X 0
         10'b0100100010: bk_datapath_o =  40'b0000001000000000000100000000000000000000; //  X 2 X X 1 X X X 0 X
         10'b0100100011: bk_datapath_o =  40'b0000001100000000001000000000000000010000; //  X 3 X X 2 X X X 1 0
         10'b0100100100: bk_datapath_o =  40'b0000001000000000000100000000000000000000; //  X 2 X X 1 X X 0 X X
         10'b0100100101: bk_datapath_o =  40'b0000001100000000001000000000000100000000; //  X 3 X X 2 X X 1 X 0
         10'b0100100110: bk_datapath_o =  40'b0000001100000000001000000000000100000000; //  X 3 X X 2 X X 1 0 X
         10'b0100100111: bk_datapath_o =  40'b0000010000000000001100000000001000010000; //  X 4 X X 3 X X 2 1 0
         10'b0100101000: bk_datapath_o =  40'b0000001000000000000100000000000000000000; //  X 2 X X 1 X 0 X X X
         10'b0100101001: bk_datapath_o =  40'b0000001100000000001000000001000000000000; //  X 3 X X 2 X 1 X X 0
         10'b0100101010: bk_datapath_o =  40'b0000001100000000001000000001000000000000; //  X 3 X X 2 X 1 X 0 X
         10'b0100101011: bk_datapath_o =  40'b0000010000000000001100000010000000010000; //  X 4 X X 3 X 2 X 1 0
         10'b0100101100: bk_datapath_o =  40'b0000001100000000001000000001000000000000; //  X 3 X X 2 X 1 0 X X
         10'b0100101101: bk_datapath_o =  40'b0000010000000000001100000010000100000000; //  X 4 X X 3 X 2 1 X 0
         10'b0100101110: bk_datapath_o =  40'b0000010000000000001100000010000100000000; //  X 4 X X 3 X 2 1 0 X
         10'b0100101111: bk_datapath_o =  40'b0000010100000000010000000011001000010000; //  X 5 X X 4 X 3 2 1 0
         10'b0100110000: bk_datapath_o =  40'b0000001000000000000100000000000000000000; //  X 2 X X 1 0 X X X X
         10'b0100110001: bk_datapath_o =  40'b0000001100000000001000010000000000000000; //  X 3 X X 2 1 X X X 0
         10'b0100110010: bk_datapath_o =  40'b0000001100000000001000010000000000000000; //  X 3 X X 2 1 X X 0 X
         10'b0100110011: bk_datapath_o =  40'b0000010000000000001100100000000000010000; //  X 4 X X 3 2 X X 1 0
         10'b0100110100: bk_datapath_o =  40'b0000001100000000001000010000000000000000; //  X 3 X X 2 1 X 0 X X
         10'b0100110101: bk_datapath_o =  40'b0000010000000000001100100000000100000000; //  X 4 X X 3 2 X 1 X 0
         10'b0100110110: bk_datapath_o =  40'b0000010000000000001100100000000100000000; //  X 4 X X 3 2 X 1 0 X
         10'b0100110111: bk_datapath_o =  40'b0000010100000000010000110000001000010000; //  X 5 X X 4 3 X 2 1 0
         10'b0100111000: bk_datapath_o =  40'b0000001100000000001000010000000000000000; //  X 3 X X 2 1 0 X X X
         10'b0100111001: bk_datapath_o =  40'b0000010000000000001100100001000000000000; //  X 4 X X 3 2 1 X X 0
         10'b0100111010: bk_datapath_o =  40'b0000010000000000001100100001000000000000; //  X 4 X X 3 2 1 X 0 X
         10'b0100111011: bk_datapath_o =  40'b0000010100000000010000110010000000010000; //  X 5 X X 4 3 2 X 1 0
         10'b0100111100: bk_datapath_o =  40'b0000010000000000001100100001000000000000; //  X 4 X X 3 2 1 0 X X
         10'b0100111101: bk_datapath_o =  40'b0000010100000000010000110010000100000000; //  X 5 X X 4 3 2 1 X 0
         10'b0100111110: bk_datapath_o =  40'b0000010100000000010000110010000100000000; //  X 5 X X 4 3 2 1 0 X
         10'b0100111111: bk_datapath_o =  40'b0000011000000000010101000011001000010000; //  X 6 X X 5 4 3 2 1 0
         10'b0101000000: bk_datapath_o =  40'b0000000100000000000000000000000000000000; //  X 1 X 0 X X X X X X
         10'b0101000001: bk_datapath_o =  40'b0000001000000001000000000000000000000000; //  X 2 X 1 X X X X X 0
         10'b0101000010: bk_datapath_o =  40'b0000001000000001000000000000000000000000; //  X 2 X 1 X X X X 0 X
         10'b0101000011: bk_datapath_o =  40'b0000001100000010000000000000000000010000; //  X 3 X 2 X X X X 1 0
         10'b0101000100: bk_datapath_o =  40'b0000001000000001000000000000000000000000; //  X 2 X 1 X X X 0 X X
         10'b0101000101: bk_datapath_o =  40'b0000001100000010000000000000000100000000; //  X 3 X 2 X X X 1 X 0
         10'b0101000110: bk_datapath_o =  40'b0000001100000010000000000000000100000000; //  X 3 X 2 X X X 1 0 X
         10'b0101000111: bk_datapath_o =  40'b0000010000000011000000000000001000010000; //  X 4 X 3 X X X 2 1 0
         10'b0101001000: bk_datapath_o =  40'b0000001000000001000000000000000000000000; //  X 2 X 1 X X 0 X X X
         10'b0101001001: bk_datapath_o =  40'b0000001100000010000000000001000000000000; //  X 3 X 2 X X 1 X X 0
         10'b0101001010: bk_datapath_o =  40'b0000001100000010000000000001000000000000; //  X 3 X 2 X X 1 X 0 X
         10'b0101001011: bk_datapath_o =  40'b0000010000000011000000000010000000010000; //  X 4 X 3 X X 2 X 1 0
         10'b0101001100: bk_datapath_o =  40'b0000001100000010000000000001000000000000; //  X 3 X 2 X X 1 0 X X
         10'b0101001101: bk_datapath_o =  40'b0000010000000011000000000010000100000000; //  X 4 X 3 X X 2 1 X 0
         10'b0101001110: bk_datapath_o =  40'b0000010000000011000000000010000100000000; //  X 4 X 3 X X 2 1 0 X
         10'b0101001111: bk_datapath_o =  40'b0000010100000100000000000011001000010000; //  X 5 X 4 X X 3 2 1 0
         10'b0101010000: bk_datapath_o =  40'b0000001000000001000000000000000000000000; //  X 2 X 1 X 0 X X X X
         10'b0101010001: bk_datapath_o =  40'b0000001100000010000000010000000000000000; //  X 3 X 2 X 1 X X X 0
         10'b0101010010: bk_datapath_o =  40'b0000001100000010000000010000000000000000; //  X 3 X 2 X 1 X X 0 X
         10'b0101010011: bk_datapath_o =  40'b0000010000000011000000100000000000010000; //  X 4 X 3 X 2 X X 1 0
         10'b0101010100: bk_datapath_o =  40'b0000001100000010000000010000000000000000; //  X 3 X 2 X 1 X 0 X X
         10'b0101010101: bk_datapath_o =  40'b0000010000000011000000100000000100000000; //  X 4 X 3 X 2 X 1 X 0
         10'b0101010110: bk_datapath_o =  40'b0000010000000011000000100000000100000000; //  X 4 X 3 X 2 X 1 0 X
         10'b0101010111: bk_datapath_o =  40'b0000010100000100000000110000001000010000; //  X 5 X 4 X 3 X 2 1 0
         10'b0101011000: bk_datapath_o =  40'b0000001100000010000000010000000000000000; //  X 3 X 2 X 1 0 X X X
         10'b0101011001: bk_datapath_o =  40'b0000010000000011000000100001000000000000; //  X 4 X 3 X 2 1 X X 0
         10'b0101011010: bk_datapath_o =  40'b0000010000000011000000100001000000000000; //  X 4 X 3 X 2 1 X 0 X
         10'b0101011011: bk_datapath_o =  40'b0000010100000100000000110010000000010000; //  X 5 X 4 X 3 2 X 1 0
         10'b0101011100: bk_datapath_o =  40'b0000010000000011000000100001000000000000; //  X 4 X 3 X 2 1 0 X X
         10'b0101011101: bk_datapath_o =  40'b0000010100000100000000110010000100000000; //  X 5 X 4 X 3 2 1 X 0
         10'b0101011110: bk_datapath_o =  40'b0000010100000100000000110010000100000000; //  X 5 X 4 X 3 2 1 0 X
         10'b0101011111: bk_datapath_o =  40'b0000011000000101000001000011001000010000; //  X 6 X 5 X 4 3 2 1 0
         10'b0101100000: bk_datapath_o =  40'b0000001000000001000000000000000000000000; //  X 2 X 1 0 X X X X X
         10'b0101100001: bk_datapath_o =  40'b0000001100000010000100000000000000000000; //  X 3 X 2 1 X X X X 0
         10'b0101100010: bk_datapath_o =  40'b0000001100000010000100000000000000000000; //  X 3 X 2 1 X X X 0 X
         10'b0101100011: bk_datapath_o =  40'b0000010000000011001000000000000000010000; //  X 4 X 3 2 X X X 1 0
         10'b0101100100: bk_datapath_o =  40'b0000001100000010000100000000000000000000; //  X 3 X 2 1 X X 0 X X
         10'b0101100101: bk_datapath_o =  40'b0000010000000011001000000000000100000000; //  X 4 X 3 2 X X 1 X 0
         10'b0101100110: bk_datapath_o =  40'b0000010000000011001000000000000100000000; //  X 4 X 3 2 X X 1 0 X
         10'b0101100111: bk_datapath_o =  40'b0000010100000100001100000000001000010000; //  X 5 X 4 3 X X 2 1 0
         10'b0101101000: bk_datapath_o =  40'b0000001100000010000100000000000000000000; //  X 3 X 2 1 X 0 X X X
         10'b0101101001: bk_datapath_o =  40'b0000010000000011001000000001000000000000; //  X 4 X 3 2 X 1 X X 0
         10'b0101101010: bk_datapath_o =  40'b0000010000000011001000000001000000000000; //  X 4 X 3 2 X 1 X 0 X
         10'b0101101011: bk_datapath_o =  40'b0000010100000100001100000010000000010000; //  X 5 X 4 3 X 2 X 1 0
         10'b0101101100: bk_datapath_o =  40'b0000010000000011001000000001000000000000; //  X 4 X 3 2 X 1 0 X X
         10'b0101101101: bk_datapath_o =  40'b0000010100000100001100000010000100000000; //  X 5 X 4 3 X 2 1 X 0
         10'b0101101110: bk_datapath_o =  40'b0000010100000100001100000010000100000000; //  X 5 X 4 3 X 2 1 0 X
         10'b0101101111: bk_datapath_o =  40'b0000011000000101010000000011001000010000; //  X 6 X 5 4 X 3 2 1 0
         10'b0101110000: bk_datapath_o =  40'b0000001100000010000100000000000000000000; //  X 3 X 2 1 0 X X X X
         10'b0101110001: bk_datapath_o =  40'b0000010000000011001000010000000000000000; //  X 4 X 3 2 1 X X X 0
         10'b0101110010: bk_datapath_o =  40'b0000010000000011001000010000000000000000; //  X 4 X 3 2 1 X X 0 X
         10'b0101110011: bk_datapath_o =  40'b0000010100000100001100100000000000010000; //  X 5 X 4 3 2 X X 1 0
         10'b0101110100: bk_datapath_o =  40'b0000010000000011001000010000000000000000; //  X 4 X 3 2 1 X 0 X X
         10'b0101110101: bk_datapath_o =  40'b0000010100000100001100100000000100000000; //  X 5 X 4 3 2 X 1 X 0
         10'b0101110110: bk_datapath_o =  40'b0000010100000100001100100000000100000000; //  X 5 X 4 3 2 X 1 0 X
         10'b0101110111: bk_datapath_o =  40'b0000011000000101010000110000001000010000; //  X 6 X 5 4 3 X 2 1 0
         10'b0101111000: bk_datapath_o =  40'b0000010000000011001000010000000000000000; //  X 4 X 3 2 1 0 X X X
         10'b0101111001: bk_datapath_o =  40'b0000010100000100001100100001000000000000; //  X 5 X 4 3 2 1 X X 0
         10'b0101111010: bk_datapath_o =  40'b0000010100000100001100100001000000000000; //  X 5 X 4 3 2 1 X 0 X
         10'b0101111011: bk_datapath_o =  40'b0000011000000101010000110010000000010000; //  X 6 X 5 4 3 2 X 1 0
         10'b0101111100: bk_datapath_o =  40'b0000010100000100001100100001000000000000; //  X 5 X 4 3 2 1 0 X X
         10'b0101111101: bk_datapath_o =  40'b0000011000000101010000110010000100000000; //  X 6 X 5 4 3 2 1 X 0
         10'b0101111110: bk_datapath_o =  40'b0000011000000101010000110010000100000000; //  X 6 X 5 4 3 2 1 0 X
         10'b0101111111: bk_datapath_o =  40'b0000011100000110010101000011001000010000; //  X 7 X 6 5 4 3 2 1 0
         10'b0110000000: bk_datapath_o =  40'b0000000100000000000000000000000000000000; //  X 1 0 X X X X X X X
         10'b0110000001: bk_datapath_o =  40'b0000001000010000000000000000000000000000; //  X 2 1 X X X X X X 0
         10'b0110000010: bk_datapath_o =  40'b0000001000010000000000000000000000000000; //  X 2 1 X X X X X 0 X
         10'b0110000011: bk_datapath_o =  40'b0000001100100000000000000000000000010000; //  X 3 2 X X X X X 1 0
         10'b0110000100: bk_datapath_o =  40'b0000001000010000000000000000000000000000; //  X 2 1 X X X X 0 X X
         10'b0110000101: bk_datapath_o =  40'b0000001100100000000000000000000100000000; //  X 3 2 X X X X 1 X 0
         10'b0110000110: bk_datapath_o =  40'b0000001100100000000000000000000100000000; //  X 3 2 X X X X 1 0 X
         10'b0110000111: bk_datapath_o =  40'b0000010000110000000000000000001000010000; //  X 4 3 X X X X 2 1 0
         10'b0110001000: bk_datapath_o =  40'b0000001000010000000000000000000000000000; //  X 2 1 X X X 0 X X X
         10'b0110001001: bk_datapath_o =  40'b0000001100100000000000000001000000000000; //  X 3 2 X X X 1 X X 0
         10'b0110001010: bk_datapath_o =  40'b0000001100100000000000000001000000000000; //  X 3 2 X X X 1 X 0 X
         10'b0110001011: bk_datapath_o =  40'b0000010000110000000000000010000000010000; //  X 4 3 X X X 2 X 1 0
         10'b0110001100: bk_datapath_o =  40'b0000001100100000000000000001000000000000; //  X 3 2 X X X 1 0 X X
         10'b0110001101: bk_datapath_o =  40'b0000010000110000000000000010000100000000; //  X 4 3 X X X 2 1 X 0
         10'b0110001110: bk_datapath_o =  40'b0000010000110000000000000010000100000000; //  X 4 3 X X X 2 1 0 X
         10'b0110001111: bk_datapath_o =  40'b0000010101000000000000000011001000010000; //  X 5 4 X X X 3 2 1 0
         10'b0110010000: bk_datapath_o =  40'b0000001000010000000000000000000000000000; //  X 2 1 X X 0 X X X X
         10'b0110010001: bk_datapath_o =  40'b0000001100100000000000010000000000000000; //  X 3 2 X X 1 X X X 0
         10'b0110010010: bk_datapath_o =  40'b0000001100100000000000010000000000000000; //  X 3 2 X X 1 X X 0 X
         10'b0110010011: bk_datapath_o =  40'b0000010000110000000000100000000000010000; //  X 4 3 X X 2 X X 1 0
         10'b0110010100: bk_datapath_o =  40'b0000001100100000000000010000000000000000; //  X 3 2 X X 1 X 0 X X
         10'b0110010101: bk_datapath_o =  40'b0000010000110000000000100000000100000000; //  X 4 3 X X 2 X 1 X 0
         10'b0110010110: bk_datapath_o =  40'b0000010000110000000000100000000100000000; //  X 4 3 X X 2 X 1 0 X
         10'b0110010111: bk_datapath_o =  40'b0000010101000000000000110000001000010000; //  X 5 4 X X 3 X 2 1 0
         10'b0110011000: bk_datapath_o =  40'b0000001100100000000000010000000000000000; //  X 3 2 X X 1 0 X X X
         10'b0110011001: bk_datapath_o =  40'b0000010000110000000000100001000000000000; //  X 4 3 X X 2 1 X X 0
         10'b0110011010: bk_datapath_o =  40'b0000010000110000000000100001000000000000; //  X 4 3 X X 2 1 X 0 X
         10'b0110011011: bk_datapath_o =  40'b0000010101000000000000110010000000010000; //  X 5 4 X X 3 2 X 1 0
         10'b0110011100: bk_datapath_o =  40'b0000010000110000000000100001000000000000; //  X 4 3 X X 2 1 0 X X
         10'b0110011101: bk_datapath_o =  40'b0000010101000000000000110010000100000000; //  X 5 4 X X 3 2 1 X 0
         10'b0110011110: bk_datapath_o =  40'b0000010101000000000000110010000100000000; //  X 5 4 X X 3 2 1 0 X
         10'b0110011111: bk_datapath_o =  40'b0000011001010000000001000011001000010000; //  X 6 5 X X 4 3 2 1 0
         10'b0110100000: bk_datapath_o =  40'b0000001000010000000000000000000000000000; //  X 2 1 X 0 X X X X X
         10'b0110100001: bk_datapath_o =  40'b0000001100100000000100000000000000000000; //  X 3 2 X 1 X X X X 0
         10'b0110100010: bk_datapath_o =  40'b0000001100100000000100000000000000000000; //  X 3 2 X 1 X X X 0 X
         10'b0110100011: bk_datapath_o =  40'b0000010000110000001000000000000000010000; //  X 4 3 X 2 X X X 1 0
         10'b0110100100: bk_datapath_o =  40'b0000001100100000000100000000000000000000; //  X 3 2 X 1 X X 0 X X
         10'b0110100101: bk_datapath_o =  40'b0000010000110000001000000000000100000000; //  X 4 3 X 2 X X 1 X 0
         10'b0110100110: bk_datapath_o =  40'b0000010000110000001000000000000100000000; //  X 4 3 X 2 X X 1 0 X
         10'b0110100111: bk_datapath_o =  40'b0000010101000000001100000000001000010000; //  X 5 4 X 3 X X 2 1 0
         10'b0110101000: bk_datapath_o =  40'b0000001100100000000100000000000000000000; //  X 3 2 X 1 X 0 X X X
         10'b0110101001: bk_datapath_o =  40'b0000010000110000001000000001000000000000; //  X 4 3 X 2 X 1 X X 0
         10'b0110101010: bk_datapath_o =  40'b0000010000110000001000000001000000000000; //  X 4 3 X 2 X 1 X 0 X
         10'b0110101011: bk_datapath_o =  40'b0000010101000000001100000010000000010000; //  X 5 4 X 3 X 2 X 1 0
         10'b0110101100: bk_datapath_o =  40'b0000010000110000001000000001000000000000; //  X 4 3 X 2 X 1 0 X X
         10'b0110101101: bk_datapath_o =  40'b0000010101000000001100000010000100000000; //  X 5 4 X 3 X 2 1 X 0
         10'b0110101110: bk_datapath_o =  40'b0000010101000000001100000010000100000000; //  X 5 4 X 3 X 2 1 0 X
         10'b0110101111: bk_datapath_o =  40'b0000011001010000010000000011001000010000; //  X 6 5 X 4 X 3 2 1 0
         10'b0110110000: bk_datapath_o =  40'b0000001100100000000100000000000000000000; //  X 3 2 X 1 0 X X X X
         10'b0110110001: bk_datapath_o =  40'b0000010000110000001000010000000000000000; //  X 4 3 X 2 1 X X X 0
         10'b0110110010: bk_datapath_o =  40'b0000010000110000001000010000000000000000; //  X 4 3 X 2 1 X X 0 X
         10'b0110110011: bk_datapath_o =  40'b0000010101000000001100100000000000010000; //  X 5 4 X 3 2 X X 1 0
         10'b0110110100: bk_datapath_o =  40'b0000010000110000001000010000000000000000; //  X 4 3 X 2 1 X 0 X X
         10'b0110110101: bk_datapath_o =  40'b0000010101000000001100100000000100000000; //  X 5 4 X 3 2 X 1 X 0
         10'b0110110110: bk_datapath_o =  40'b0000010101000000001100100000000100000000; //  X 5 4 X 3 2 X 1 0 X
         10'b0110110111: bk_datapath_o =  40'b0000011001010000010000110000001000010000; //  X 6 5 X 4 3 X 2 1 0
         10'b0110111000: bk_datapath_o =  40'b0000010000110000001000010000000000000000; //  X 4 3 X 2 1 0 X X X
         10'b0110111001: bk_datapath_o =  40'b0000010101000000001100100001000000000000; //  X 5 4 X 3 2 1 X X 0
         10'b0110111010: bk_datapath_o =  40'b0000010101000000001100100001000000000000; //  X 5 4 X 3 2 1 X 0 X
         10'b0110111011: bk_datapath_o =  40'b0000011001010000010000110010000000010000; //  X 6 5 X 4 3 2 X 1 0
         10'b0110111100: bk_datapath_o =  40'b0000010101000000001100100001000000000000; //  X 5 4 X 3 2 1 0 X X
         10'b0110111101: bk_datapath_o =  40'b0000011001010000010000110010000100000000; //  X 6 5 X 4 3 2 1 X 0
         10'b0110111110: bk_datapath_o =  40'b0000011001010000010000110010000100000000; //  X 6 5 X 4 3 2 1 0 X
         10'b0110111111: bk_datapath_o =  40'b0000011101100000010101000011001000010000; //  X 7 6 X 5 4 3 2 1 0
         10'b0111000000: bk_datapath_o =  40'b0000001000010000000000000000000000000000; //  X 2 1 0 X X X X X X
         10'b0111000001: bk_datapath_o =  40'b0000001100100001000000000000000000000000; //  X 3 2 1 X X X X X 0
         10'b0111000010: bk_datapath_o =  40'b0000001100100001000000000000000000000000; //  X 3 2 1 X X X X 0 X
         10'b0111000011: bk_datapath_o =  40'b0000010000110010000000000000000000010000; //  X 4 3 2 X X X X 1 0
         10'b0111000100: bk_datapath_o =  40'b0000001100100001000000000000000000000000; //  X 3 2 1 X X X 0 X X
         10'b0111000101: bk_datapath_o =  40'b0000010000110010000000000000000100000000; //  X 4 3 2 X X X 1 X 0
         10'b0111000110: bk_datapath_o =  40'b0000010000110010000000000000000100000000; //  X 4 3 2 X X X 1 0 X
         10'b0111000111: bk_datapath_o =  40'b0000010101000011000000000000001000010000; //  X 5 4 3 X X X 2 1 0
         10'b0111001000: bk_datapath_o =  40'b0000001100100001000000000000000000000000; //  X 3 2 1 X X 0 X X X
         10'b0111001001: bk_datapath_o =  40'b0000010000110010000000000001000000000000; //  X 4 3 2 X X 1 X X 0
         10'b0111001010: bk_datapath_o =  40'b0000010000110010000000000001000000000000; //  X 4 3 2 X X 1 X 0 X
         10'b0111001011: bk_datapath_o =  40'b0000010101000011000000000010000000010000; //  X 5 4 3 X X 2 X 1 0
         10'b0111001100: bk_datapath_o =  40'b0000010000110010000000000001000000000000; //  X 4 3 2 X X 1 0 X X
         10'b0111001101: bk_datapath_o =  40'b0000010101000011000000000010000100000000; //  X 5 4 3 X X 2 1 X 0
         10'b0111001110: bk_datapath_o =  40'b0000010101000011000000000010000100000000; //  X 5 4 3 X X 2 1 0 X
         10'b0111001111: bk_datapath_o =  40'b0000011001010100000000000011001000010000; //  X 6 5 4 X X 3 2 1 0
         10'b0111010000: bk_datapath_o =  40'b0000001100100001000000000000000000000000; //  X 3 2 1 X 0 X X X X
         10'b0111010001: bk_datapath_o =  40'b0000010000110010000000010000000000000000; //  X 4 3 2 X 1 X X X 0
         10'b0111010010: bk_datapath_o =  40'b0000010000110010000000010000000000000000; //  X 4 3 2 X 1 X X 0 X
         10'b0111010011: bk_datapath_o =  40'b0000010101000011000000100000000000010000; //  X 5 4 3 X 2 X X 1 0
         10'b0111010100: bk_datapath_o =  40'b0000010000110010000000010000000000000000; //  X 4 3 2 X 1 X 0 X X
         10'b0111010101: bk_datapath_o =  40'b0000010101000011000000100000000100000000; //  X 5 4 3 X 2 X 1 X 0
         10'b0111010110: bk_datapath_o =  40'b0000010101000011000000100000000100000000; //  X 5 4 3 X 2 X 1 0 X
         10'b0111010111: bk_datapath_o =  40'b0000011001010100000000110000001000010000; //  X 6 5 4 X 3 X 2 1 0
         10'b0111011000: bk_datapath_o =  40'b0000010000110010000000010000000000000000; //  X 4 3 2 X 1 0 X X X
         10'b0111011001: bk_datapath_o =  40'b0000010101000011000000100001000000000000; //  X 5 4 3 X 2 1 X X 0
         10'b0111011010: bk_datapath_o =  40'b0000010101000011000000100001000000000000; //  X 5 4 3 X 2 1 X 0 X
         10'b0111011011: bk_datapath_o =  40'b0000011001010100000000110010000000010000; //  X 6 5 4 X 3 2 X 1 0
         10'b0111011100: bk_datapath_o =  40'b0000010101000011000000100001000000000000; //  X 5 4 3 X 2 1 0 X X
         10'b0111011101: bk_datapath_o =  40'b0000011001010100000000110010000100000000; //  X 6 5 4 X 3 2 1 X 0
         10'b0111011110: bk_datapath_o =  40'b0000011001010100000000110010000100000000; //  X 6 5 4 X 3 2 1 0 X
         10'b0111011111: bk_datapath_o =  40'b0000011101100101000001000011001000010000; //  X 7 6 5 X 4 3 2 1 0
         10'b0111100000: bk_datapath_o =  40'b0000001100100001000000000000000000000000; //  X 3 2 1 0 X X X X X
         10'b0111100001: bk_datapath_o =  40'b0000010000110010000100000000000000000000; //  X 4 3 2 1 X X X X 0
         10'b0111100010: bk_datapath_o =  40'b0000010000110010000100000000000000000000; //  X 4 3 2 1 X X X 0 X
         10'b0111100011: bk_datapath_o =  40'b0000010101000011001000000000000000010000; //  X 5 4 3 2 X X X 1 0
         10'b0111100100: bk_datapath_o =  40'b0000010000110010000100000000000000000000; //  X 4 3 2 1 X X 0 X X
         10'b0111100101: bk_datapath_o =  40'b0000010101000011001000000000000100000000; //  X 5 4 3 2 X X 1 X 0
         10'b0111100110: bk_datapath_o =  40'b0000010101000011001000000000000100000000; //  X 5 4 3 2 X X 1 0 X
         10'b0111100111: bk_datapath_o =  40'b0000011001010100001100000000001000010000; //  X 6 5 4 3 X X 2 1 0
         10'b0111101000: bk_datapath_o =  40'b0000010000110010000100000000000000000000; //  X 4 3 2 1 X 0 X X X
         10'b0111101001: bk_datapath_o =  40'b0000010101000011001000000001000000000000; //  X 5 4 3 2 X 1 X X 0
         10'b0111101010: bk_datapath_o =  40'b0000010101000011001000000001000000000000; //  X 5 4 3 2 X 1 X 0 X
         10'b0111101011: bk_datapath_o =  40'b0000011001010100001100000010000000010000; //  X 6 5 4 3 X 2 X 1 0
         10'b0111101100: bk_datapath_o =  40'b0000010101000011001000000001000000000000; //  X 5 4 3 2 X 1 0 X X
         10'b0111101101: bk_datapath_o =  40'b0000011001010100001100000010000100000000; //  X 6 5 4 3 X 2 1 X 0
         10'b0111101110: bk_datapath_o =  40'b0000011001010100001100000010000100000000; //  X 6 5 4 3 X 2 1 0 X
         10'b0111101111: bk_datapath_o =  40'b0000011101100101010000000011001000010000; //  X 7 6 5 4 X 3 2 1 0
         10'b0111110000: bk_datapath_o =  40'b0000010000110010000100000000000000000000; //  X 4 3 2 1 0 X X X X
         10'b0111110001: bk_datapath_o =  40'b0000010101000011001000010000000000000000; //  X 5 4 3 2 1 X X X 0
         10'b0111110010: bk_datapath_o =  40'b0000010101000011001000010000000000000000; //  X 5 4 3 2 1 X X 0 X
         10'b0111110011: bk_datapath_o =  40'b0000011001010100001100100000000000010000; //  X 6 5 4 3 2 X X 1 0
         10'b0111110100: bk_datapath_o =  40'b0000010101000011001000010000000000000000; //  X 5 4 3 2 1 X 0 X X
         10'b0111110101: bk_datapath_o =  40'b0000011001010100001100100000000100000000; //  X 6 5 4 3 2 X 1 X 0
         10'b0111110110: bk_datapath_o =  40'b0000011001010100001100100000000100000000; //  X 6 5 4 3 2 X 1 0 X
         10'b0111110111: bk_datapath_o =  40'b0000011101100101010000110000001000010000; //  X 7 6 5 4 3 X 2 1 0
         10'b0111111000: bk_datapath_o =  40'b0000010101000011001000010000000000000000; //  X 5 4 3 2 1 0 X X X
         10'b0111111001: bk_datapath_o =  40'b0000011001010100001100100001000000000000; //  X 6 5 4 3 2 1 X X 0
         10'b0111111010: bk_datapath_o =  40'b0000011001010100001100100001000000000000; //  X 6 5 4 3 2 1 X 0 X
         10'b0111111011: bk_datapath_o =  40'b0000011101100101010000110010000000010000; //  X 7 6 5 4 3 2 X 1 0
         10'b0111111100: bk_datapath_o =  40'b0000011001010100001100100001000000000000; //  X 6 5 4 3 2 1 0 X X
         10'b0111111101: bk_datapath_o =  40'b0000011101100101010000110010000100000000; //  X 7 6 5 4 3 2 1 X 0
         10'b0111111110: bk_datapath_o =  40'b0000011101100101010000110010000100000000; //  X 7 6 5 4 3 2 1 0 X
         10'b0111111111: bk_datapath_o =  40'b0000100001110110010101000011001000010000; //  X 8 7 6 5 4 3 2 1 0
         10'b1000000000: bk_datapath_o =  40'b0000000000000000000000000000000000000000; //  0 X X X X X X X X X
         10'b1000000001: bk_datapath_o =  40'b0001000000000000000000000000000000000000; //  1 X X X X X X X X 0
         10'b1000000010: bk_datapath_o =  40'b0001000000000000000000000000000000000000; //  1 X X X X X X X 0 X
         10'b1000000011: bk_datapath_o =  40'b0010000000000000000000000000000000010000; //  2 X X X X X X X 1 0
         10'b1000000100: bk_datapath_o =  40'b0001000000000000000000000000000000000000; //  1 X X X X X X 0 X X
         10'b1000000101: bk_datapath_o =  40'b0010000000000000000000000000000100000000; //  2 X X X X X X 1 X 0
         10'b1000000110: bk_datapath_o =  40'b0010000000000000000000000000000100000000; //  2 X X X X X X 1 0 X
         10'b1000000111: bk_datapath_o =  40'b0011000000000000000000000000001000010000; //  3 X X X X X X 2 1 0
         10'b1000001000: bk_datapath_o =  40'b0001000000000000000000000000000000000000; //  1 X X X X X 0 X X X
         10'b1000001001: bk_datapath_o =  40'b0010000000000000000000000001000000000000; //  2 X X X X X 1 X X 0
         10'b1000001010: bk_datapath_o =  40'b0010000000000000000000000001000000000000; //  2 X X X X X 1 X 0 X
         10'b1000001011: bk_datapath_o =  40'b0011000000000000000000000010000000010000; //  3 X X X X X 2 X 1 0
         10'b1000001100: bk_datapath_o =  40'b0010000000000000000000000001000000000000; //  2 X X X X X 1 0 X X
         10'b1000001101: bk_datapath_o =  40'b0011000000000000000000000010000100000000; //  3 X X X X X 2 1 X 0
         10'b1000001110: bk_datapath_o =  40'b0011000000000000000000000010000100000000; //  3 X X X X X 2 1 0 X
         10'b1000001111: bk_datapath_o =  40'b0100000000000000000000000011001000010000; //  4 X X X X X 3 2 1 0
         10'b1000010000: bk_datapath_o =  40'b0001000000000000000000000000000000000000; //  1 X X X X 0 X X X X
         10'b1000010001: bk_datapath_o =  40'b0010000000000000000000010000000000000000; //  2 X X X X 1 X X X 0
         10'b1000010010: bk_datapath_o =  40'b0010000000000000000000010000000000000000; //  2 X X X X 1 X X 0 X
         10'b1000010011: bk_datapath_o =  40'b0011000000000000000000100000000000010000; //  3 X X X X 2 X X 1 0
         10'b1000010100: bk_datapath_o =  40'b0010000000000000000000010000000000000000; //  2 X X X X 1 X 0 X X
         10'b1000010101: bk_datapath_o =  40'b0011000000000000000000100000000100000000; //  3 X X X X 2 X 1 X 0
         10'b1000010110: bk_datapath_o =  40'b0011000000000000000000100000000100000000; //  3 X X X X 2 X 1 0 X
         10'b1000010111: bk_datapath_o =  40'b0100000000000000000000110000001000010000; //  4 X X X X 3 X 2 1 0
         10'b1000011000: bk_datapath_o =  40'b0010000000000000000000010000000000000000; //  2 X X X X 1 0 X X X
         10'b1000011001: bk_datapath_o =  40'b0011000000000000000000100001000000000000; //  3 X X X X 2 1 X X 0
         10'b1000011010: bk_datapath_o =  40'b0011000000000000000000100001000000000000; //  3 X X X X 2 1 X 0 X
         10'b1000011011: bk_datapath_o =  40'b0100000000000000000000110010000000010000; //  4 X X X X 3 2 X 1 0
         10'b1000011100: bk_datapath_o =  40'b0011000000000000000000100001000000000000; //  3 X X X X 2 1 0 X X
         10'b1000011101: bk_datapath_o =  40'b0100000000000000000000110010000100000000; //  4 X X X X 3 2 1 X 0
         10'b1000011110: bk_datapath_o =  40'b0100000000000000000000110010000100000000; //  4 X X X X 3 2 1 0 X
         10'b1000011111: bk_datapath_o =  40'b0101000000000000000001000011001000010000; //  5 X X X X 4 3 2 1 0
         10'b1000100000: bk_datapath_o =  40'b0001000000000000000000000000000000000000; //  1 X X X 0 X X X X X
         10'b1000100001: bk_datapath_o =  40'b0010000000000000000100000000000000000000; //  2 X X X 1 X X X X 0
         10'b1000100010: bk_datapath_o =  40'b0010000000000000000100000000000000000000; //  2 X X X 1 X X X 0 X
         10'b1000100011: bk_datapath_o =  40'b0011000000000000001000000000000000010000; //  3 X X X 2 X X X 1 0
         10'b1000100100: bk_datapath_o =  40'b0010000000000000000100000000000000000000; //  2 X X X 1 X X 0 X X
         10'b1000100101: bk_datapath_o =  40'b0011000000000000001000000000000100000000; //  3 X X X 2 X X 1 X 0
         10'b1000100110: bk_datapath_o =  40'b0011000000000000001000000000000100000000; //  3 X X X 2 X X 1 0 X
         10'b1000100111: bk_datapath_o =  40'b0100000000000000001100000000001000010000; //  4 X X X 3 X X 2 1 0
         10'b1000101000: bk_datapath_o =  40'b0010000000000000000100000000000000000000; //  2 X X X 1 X 0 X X X
         10'b1000101001: bk_datapath_o =  40'b0011000000000000001000000001000000000000; //  3 X X X 2 X 1 X X 0
         10'b1000101010: bk_datapath_o =  40'b0011000000000000001000000001000000000000; //  3 X X X 2 X 1 X 0 X
         10'b1000101011: bk_datapath_o =  40'b0100000000000000001100000010000000010000; //  4 X X X 3 X 2 X 1 0
         10'b1000101100: bk_datapath_o =  40'b0011000000000000001000000001000000000000; //  3 X X X 2 X 1 0 X X
         10'b1000101101: bk_datapath_o =  40'b0100000000000000001100000010000100000000; //  4 X X X 3 X 2 1 X 0
         10'b1000101110: bk_datapath_o =  40'b0100000000000000001100000010000100000000; //  4 X X X 3 X 2 1 0 X
         10'b1000101111: bk_datapath_o =  40'b0101000000000000010000000011001000010000; //  5 X X X 4 X 3 2 1 0
         10'b1000110000: bk_datapath_o =  40'b0010000000000000000100000000000000000000; //  2 X X X 1 0 X X X X
         10'b1000110001: bk_datapath_o =  40'b0011000000000000001000010000000000000000; //  3 X X X 2 1 X X X 0
         10'b1000110010: bk_datapath_o =  40'b0011000000000000001000010000000000000000; //  3 X X X 2 1 X X 0 X
         10'b1000110011: bk_datapath_o =  40'b0100000000000000001100100000000000010000; //  4 X X X 3 2 X X 1 0
         10'b1000110100: bk_datapath_o =  40'b0011000000000000001000010000000000000000; //  3 X X X 2 1 X 0 X X
         10'b1000110101: bk_datapath_o =  40'b0100000000000000001100100000000100000000; //  4 X X X 3 2 X 1 X 0
         10'b1000110110: bk_datapath_o =  40'b0100000000000000001100100000000100000000; //  4 X X X 3 2 X 1 0 X
         10'b1000110111: bk_datapath_o =  40'b0101000000000000010000110000001000010000; //  5 X X X 4 3 X 2 1 0
         10'b1000111000: bk_datapath_o =  40'b0011000000000000001000010000000000000000; //  3 X X X 2 1 0 X X X
         10'b1000111001: bk_datapath_o =  40'b0100000000000000001100100001000000000000; //  4 X X X 3 2 1 X X 0
         10'b1000111010: bk_datapath_o =  40'b0100000000000000001100100001000000000000; //  4 X X X 3 2 1 X 0 X
         10'b1000111011: bk_datapath_o =  40'b0101000000000000010000110010000000010000; //  5 X X X 4 3 2 X 1 0
         10'b1000111100: bk_datapath_o =  40'b0100000000000000001100100001000000000000; //  4 X X X 3 2 1 0 X X
         10'b1000111101: bk_datapath_o =  40'b0101000000000000010000110010000100000000; //  5 X X X 4 3 2 1 X 0
         10'b1000111110: bk_datapath_o =  40'b0101000000000000010000110010000100000000; //  5 X X X 4 3 2 1 0 X
         10'b1000111111: bk_datapath_o =  40'b0110000000000000010101000011001000010000; //  6 X X X 5 4 3 2 1 0
         10'b1001000000: bk_datapath_o =  40'b0001000000000000000000000000000000000000; //  1 X X 0 X X X X X X
         10'b1001000001: bk_datapath_o =  40'b0010000000000001000000000000000000000000; //  2 X X 1 X X X X X 0
         10'b1001000010: bk_datapath_o =  40'b0010000000000001000000000000000000000000; //  2 X X 1 X X X X 0 X
         10'b1001000011: bk_datapath_o =  40'b0011000000000010000000000000000000010000; //  3 X X 2 X X X X 1 0
         10'b1001000100: bk_datapath_o =  40'b0010000000000001000000000000000000000000; //  2 X X 1 X X X 0 X X
         10'b1001000101: bk_datapath_o =  40'b0011000000000010000000000000000100000000; //  3 X X 2 X X X 1 X 0
         10'b1001000110: bk_datapath_o =  40'b0011000000000010000000000000000100000000; //  3 X X 2 X X X 1 0 X
         10'b1001000111: bk_datapath_o =  40'b0100000000000011000000000000001000010000; //  4 X X 3 X X X 2 1 0
         10'b1001001000: bk_datapath_o =  40'b0010000000000001000000000000000000000000; //  2 X X 1 X X 0 X X X
         10'b1001001001: bk_datapath_o =  40'b0011000000000010000000000001000000000000; //  3 X X 2 X X 1 X X 0
         10'b1001001010: bk_datapath_o =  40'b0011000000000010000000000001000000000000; //  3 X X 2 X X 1 X 0 X
         10'b1001001011: bk_datapath_o =  40'b0100000000000011000000000010000000010000; //  4 X X 3 X X 2 X 1 0
         10'b1001001100: bk_datapath_o =  40'b0011000000000010000000000001000000000000; //  3 X X 2 X X 1 0 X X
         10'b1001001101: bk_datapath_o =  40'b0100000000000011000000000010000100000000; //  4 X X 3 X X 2 1 X 0
         10'b1001001110: bk_datapath_o =  40'b0100000000000011000000000010000100000000; //  4 X X 3 X X 2 1 0 X
         10'b1001001111: bk_datapath_o =  40'b0101000000000100000000000011001000010000; //  5 X X 4 X X 3 2 1 0
         10'b1001010000: bk_datapath_o =  40'b0010000000000001000000000000000000000000; //  2 X X 1 X 0 X X X X
         10'b1001010001: bk_datapath_o =  40'b0011000000000010000000010000000000000000; //  3 X X 2 X 1 X X X 0
         10'b1001010010: bk_datapath_o =  40'b0011000000000010000000010000000000000000; //  3 X X 2 X 1 X X 0 X
         10'b1001010011: bk_datapath_o =  40'b0100000000000011000000100000000000010000; //  4 X X 3 X 2 X X 1 0
         10'b1001010100: bk_datapath_o =  40'b0011000000000010000000010000000000000000; //  3 X X 2 X 1 X 0 X X
         10'b1001010101: bk_datapath_o =  40'b0100000000000011000000100000000100000000; //  4 X X 3 X 2 X 1 X 0
         10'b1001010110: bk_datapath_o =  40'b0100000000000011000000100000000100000000; //  4 X X 3 X 2 X 1 0 X
         10'b1001010111: bk_datapath_o =  40'b0101000000000100000000110000001000010000; //  5 X X 4 X 3 X 2 1 0
         10'b1001011000: bk_datapath_o =  40'b0011000000000010000000010000000000000000; //  3 X X 2 X 1 0 X X X
         10'b1001011001: bk_datapath_o =  40'b0100000000000011000000100001000000000000; //  4 X X 3 X 2 1 X X 0
         10'b1001011010: bk_datapath_o =  40'b0100000000000011000000100001000000000000; //  4 X X 3 X 2 1 X 0 X
         10'b1001011011: bk_datapath_o =  40'b0101000000000100000000110010000000010000; //  5 X X 4 X 3 2 X 1 0
         10'b1001011100: bk_datapath_o =  40'b0100000000000011000000100001000000000000; //  4 X X 3 X 2 1 0 X X
         10'b1001011101: bk_datapath_o =  40'b0101000000000100000000110010000100000000; //  5 X X 4 X 3 2 1 X 0
         10'b1001011110: bk_datapath_o =  40'b0101000000000100000000110010000100000000; //  5 X X 4 X 3 2 1 0 X
         10'b1001011111: bk_datapath_o =  40'b0110000000000101000001000011001000010000; //  6 X X 5 X 4 3 2 1 0
         10'b1001100000: bk_datapath_o =  40'b0010000000000001000000000000000000000000; //  2 X X 1 0 X X X X X
         10'b1001100001: bk_datapath_o =  40'b0011000000000010000100000000000000000000; //  3 X X 2 1 X X X X 0
         10'b1001100010: bk_datapath_o =  40'b0011000000000010000100000000000000000000; //  3 X X 2 1 X X X 0 X
         10'b1001100011: bk_datapath_o =  40'b0100000000000011001000000000000000010000; //  4 X X 3 2 X X X 1 0
         10'b1001100100: bk_datapath_o =  40'b0011000000000010000100000000000000000000; //  3 X X 2 1 X X 0 X X
         10'b1001100101: bk_datapath_o =  40'b0100000000000011001000000000000100000000; //  4 X X 3 2 X X 1 X 0
         10'b1001100110: bk_datapath_o =  40'b0100000000000011001000000000000100000000; //  4 X X 3 2 X X 1 0 X
         10'b1001100111: bk_datapath_o =  40'b0101000000000100001100000000001000010000; //  5 X X 4 3 X X 2 1 0
         10'b1001101000: bk_datapath_o =  40'b0011000000000010000100000000000000000000; //  3 X X 2 1 X 0 X X X
         10'b1001101001: bk_datapath_o =  40'b0100000000000011001000000001000000000000; //  4 X X 3 2 X 1 X X 0
         10'b1001101010: bk_datapath_o =  40'b0100000000000011001000000001000000000000; //  4 X X 3 2 X 1 X 0 X
         10'b1001101011: bk_datapath_o =  40'b0101000000000100001100000010000000010000; //  5 X X 4 3 X 2 X 1 0
         10'b1001101100: bk_datapath_o =  40'b0100000000000011001000000001000000000000; //  4 X X 3 2 X 1 0 X X
         10'b1001101101: bk_datapath_o =  40'b0101000000000100001100000010000100000000; //  5 X X 4 3 X 2 1 X 0
         10'b1001101110: bk_datapath_o =  40'b0101000000000100001100000010000100000000; //  5 X X 4 3 X 2 1 0 X
         10'b1001101111: bk_datapath_o =  40'b0110000000000101010000000011001000010000; //  6 X X 5 4 X 3 2 1 0
         10'b1001110000: bk_datapath_o =  40'b0011000000000010000100000000000000000000; //  3 X X 2 1 0 X X X X
         10'b1001110001: bk_datapath_o =  40'b0100000000000011001000010000000000000000; //  4 X X 3 2 1 X X X 0
         10'b1001110010: bk_datapath_o =  40'b0100000000000011001000010000000000000000; //  4 X X 3 2 1 X X 0 X
         10'b1001110011: bk_datapath_o =  40'b0101000000000100001100100000000000010000; //  5 X X 4 3 2 X X 1 0
         10'b1001110100: bk_datapath_o =  40'b0100000000000011001000010000000000000000; //  4 X X 3 2 1 X 0 X X
         10'b1001110101: bk_datapath_o =  40'b0101000000000100001100100000000100000000; //  5 X X 4 3 2 X 1 X 0
         10'b1001110110: bk_datapath_o =  40'b0101000000000100001100100000000100000000; //  5 X X 4 3 2 X 1 0 X
         10'b1001110111: bk_datapath_o =  40'b0110000000000101010000110000001000010000; //  6 X X 5 4 3 X 2 1 0
         10'b1001111000: bk_datapath_o =  40'b0100000000000011001000010000000000000000; //  4 X X 3 2 1 0 X X X
         10'b1001111001: bk_datapath_o =  40'b0101000000000100001100100001000000000000; //  5 X X 4 3 2 1 X X 0
         10'b1001111010: bk_datapath_o =  40'b0101000000000100001100100001000000000000; //  5 X X 4 3 2 1 X 0 X
         10'b1001111011: bk_datapath_o =  40'b0110000000000101010000110010000000010000; //  6 X X 5 4 3 2 X 1 0
         10'b1001111100: bk_datapath_o =  40'b0101000000000100001100100001000000000000; //  5 X X 4 3 2 1 0 X X
         10'b1001111101: bk_datapath_o =  40'b0110000000000101010000110010000100000000; //  6 X X 5 4 3 2 1 X 0
         10'b1001111110: bk_datapath_o =  40'b0110000000000101010000110010000100000000; //  6 X X 5 4 3 2 1 0 X
         10'b1001111111: bk_datapath_o =  40'b0111000000000110010101000011001000010000; //  7 X X 6 5 4 3 2 1 0
         10'b1010000000: bk_datapath_o =  40'b0001000000000000000000000000000000000000; //  1 X 0 X X X X X X X
         10'b1010000001: bk_datapath_o =  40'b0010000000010000000000000000000000000000; //  2 X 1 X X X X X X 0
         10'b1010000010: bk_datapath_o =  40'b0010000000010000000000000000000000000000; //  2 X 1 X X X X X 0 X
         10'b1010000011: bk_datapath_o =  40'b0011000000100000000000000000000000010000; //  3 X 2 X X X X X 1 0
         10'b1010000100: bk_datapath_o =  40'b0010000000010000000000000000000000000000; //  2 X 1 X X X X 0 X X
         10'b1010000101: bk_datapath_o =  40'b0011000000100000000000000000000100000000; //  3 X 2 X X X X 1 X 0
         10'b1010000110: bk_datapath_o =  40'b0011000000100000000000000000000100000000; //  3 X 2 X X X X 1 0 X
         10'b1010000111: bk_datapath_o =  40'b0100000000110000000000000000001000010000; //  4 X 3 X X X X 2 1 0
         10'b1010001000: bk_datapath_o =  40'b0010000000010000000000000000000000000000; //  2 X 1 X X X 0 X X X
         10'b1010001001: bk_datapath_o =  40'b0011000000100000000000000001000000000000; //  3 X 2 X X X 1 X X 0
         10'b1010001010: bk_datapath_o =  40'b0011000000100000000000000001000000000000; //  3 X 2 X X X 1 X 0 X
         10'b1010001011: bk_datapath_o =  40'b0100000000110000000000000010000000010000; //  4 X 3 X X X 2 X 1 0
         10'b1010001100: bk_datapath_o =  40'b0011000000100000000000000001000000000000; //  3 X 2 X X X 1 0 X X
         10'b1010001101: bk_datapath_o =  40'b0100000000110000000000000010000100000000; //  4 X 3 X X X 2 1 X 0
         10'b1010001110: bk_datapath_o =  40'b0100000000110000000000000010000100000000; //  4 X 3 X X X 2 1 0 X
         10'b1010001111: bk_datapath_o =  40'b0101000001000000000000000011001000010000; //  5 X 4 X X X 3 2 1 0
         10'b1010010000: bk_datapath_o =  40'b0010000000010000000000000000000000000000; //  2 X 1 X X 0 X X X X
         10'b1010010001: bk_datapath_o =  40'b0011000000100000000000010000000000000000; //  3 X 2 X X 1 X X X 0
         10'b1010010010: bk_datapath_o =  40'b0011000000100000000000010000000000000000; //  3 X 2 X X 1 X X 0 X
         10'b1010010011: bk_datapath_o =  40'b0100000000110000000000100000000000010000; //  4 X 3 X X 2 X X 1 0
         10'b1010010100: bk_datapath_o =  40'b0011000000100000000000010000000000000000; //  3 X 2 X X 1 X 0 X X
         10'b1010010101: bk_datapath_o =  40'b0100000000110000000000100000000100000000; //  4 X 3 X X 2 X 1 X 0
         10'b1010010110: bk_datapath_o =  40'b0100000000110000000000100000000100000000; //  4 X 3 X X 2 X 1 0 X
         10'b1010010111: bk_datapath_o =  40'b0101000001000000000000110000001000010000; //  5 X 4 X X 3 X 2 1 0
         10'b1010011000: bk_datapath_o =  40'b0011000000100000000000010000000000000000; //  3 X 2 X X 1 0 X X X
         10'b1010011001: bk_datapath_o =  40'b0100000000110000000000100001000000000000; //  4 X 3 X X 2 1 X X 0
         10'b1010011010: bk_datapath_o =  40'b0100000000110000000000100001000000000000; //  4 X 3 X X 2 1 X 0 X
         10'b1010011011: bk_datapath_o =  40'b0101000001000000000000110010000000010000; //  5 X 4 X X 3 2 X 1 0
         10'b1010011100: bk_datapath_o =  40'b0100000000110000000000100001000000000000; //  4 X 3 X X 2 1 0 X X
         10'b1010011101: bk_datapath_o =  40'b0101000001000000000000110010000100000000; //  5 X 4 X X 3 2 1 X 0
         10'b1010011110: bk_datapath_o =  40'b0101000001000000000000110010000100000000; //  5 X 4 X X 3 2 1 0 X
         10'b1010011111: bk_datapath_o =  40'b0110000001010000000001000011001000010000; //  6 X 5 X X 4 3 2 1 0
         10'b1010100000: bk_datapath_o =  40'b0010000000010000000000000000000000000000; //  2 X 1 X 0 X X X X X
         10'b1010100001: bk_datapath_o =  40'b0011000000100000000100000000000000000000; //  3 X 2 X 1 X X X X 0
         10'b1010100010: bk_datapath_o =  40'b0011000000100000000100000000000000000000; //  3 X 2 X 1 X X X 0 X
         10'b1010100011: bk_datapath_o =  40'b0100000000110000001000000000000000010000; //  4 X 3 X 2 X X X 1 0
         10'b1010100100: bk_datapath_o =  40'b0011000000100000000100000000000000000000; //  3 X 2 X 1 X X 0 X X
         10'b1010100101: bk_datapath_o =  40'b0100000000110000001000000000000100000000; //  4 X 3 X 2 X X 1 X 0
         10'b1010100110: bk_datapath_o =  40'b0100000000110000001000000000000100000000; //  4 X 3 X 2 X X 1 0 X
         10'b1010100111: bk_datapath_o =  40'b0101000001000000001100000000001000010000; //  5 X 4 X 3 X X 2 1 0
         10'b1010101000: bk_datapath_o =  40'b0011000000100000000100000000000000000000; //  3 X 2 X 1 X 0 X X X
         10'b1010101001: bk_datapath_o =  40'b0100000000110000001000000001000000000000; //  4 X 3 X 2 X 1 X X 0
         10'b1010101010: bk_datapath_o =  40'b0100000000110000001000000001000000000000; //  4 X 3 X 2 X 1 X 0 X
         10'b1010101011: bk_datapath_o =  40'b0101000001000000001100000010000000010000; //  5 X 4 X 3 X 2 X 1 0
         10'b1010101100: bk_datapath_o =  40'b0100000000110000001000000001000000000000; //  4 X 3 X 2 X 1 0 X X
         10'b1010101101: bk_datapath_o =  40'b0101000001000000001100000010000100000000; //  5 X 4 X 3 X 2 1 X 0
         10'b1010101110: bk_datapath_o =  40'b0101000001000000001100000010000100000000; //  5 X 4 X 3 X 2 1 0 X
         10'b1010101111: bk_datapath_o =  40'b0110000001010000010000000011001000010000; //  6 X 5 X 4 X 3 2 1 0
         10'b1010110000: bk_datapath_o =  40'b0011000000100000000100000000000000000000; //  3 X 2 X 1 0 X X X X
         10'b1010110001: bk_datapath_o =  40'b0100000000110000001000010000000000000000; //  4 X 3 X 2 1 X X X 0
         10'b1010110010: bk_datapath_o =  40'b0100000000110000001000010000000000000000; //  4 X 3 X 2 1 X X 0 X
         10'b1010110011: bk_datapath_o =  40'b0101000001000000001100100000000000010000; //  5 X 4 X 3 2 X X 1 0
         10'b1010110100: bk_datapath_o =  40'b0100000000110000001000010000000000000000; //  4 X 3 X 2 1 X 0 X X
         10'b1010110101: bk_datapath_o =  40'b0101000001000000001100100000000100000000; //  5 X 4 X 3 2 X 1 X 0
         10'b1010110110: bk_datapath_o =  40'b0101000001000000001100100000000100000000; //  5 X 4 X 3 2 X 1 0 X
         10'b1010110111: bk_datapath_o =  40'b0110000001010000010000110000001000010000; //  6 X 5 X 4 3 X 2 1 0
         10'b1010111000: bk_datapath_o =  40'b0100000000110000001000010000000000000000; //  4 X 3 X 2 1 0 X X X
         10'b1010111001: bk_datapath_o =  40'b0101000001000000001100100001000000000000; //  5 X 4 X 3 2 1 X X 0
         10'b1010111010: bk_datapath_o =  40'b0101000001000000001100100001000000000000; //  5 X 4 X 3 2 1 X 0 X
         10'b1010111011: bk_datapath_o =  40'b0110000001010000010000110010000000010000; //  6 X 5 X 4 3 2 X 1 0
         10'b1010111100: bk_datapath_o =  40'b0101000001000000001100100001000000000000; //  5 X 4 X 3 2 1 0 X X
         10'b1010111101: bk_datapath_o =  40'b0110000001010000010000110010000100000000; //  6 X 5 X 4 3 2 1 X 0
         10'b1010111110: bk_datapath_o =  40'b0110000001010000010000110010000100000000; //  6 X 5 X 4 3 2 1 0 X
         10'b1010111111: bk_datapath_o =  40'b0111000001100000010101000011001000010000; //  7 X 6 X 5 4 3 2 1 0
         10'b1011000000: bk_datapath_o =  40'b0010000000010000000000000000000000000000; //  2 X 1 0 X X X X X X
         10'b1011000001: bk_datapath_o =  40'b0011000000100001000000000000000000000000; //  3 X 2 1 X X X X X 0
         10'b1011000010: bk_datapath_o =  40'b0011000000100001000000000000000000000000; //  3 X 2 1 X X X X 0 X
         10'b1011000011: bk_datapath_o =  40'b0100000000110010000000000000000000010000; //  4 X 3 2 X X X X 1 0
         10'b1011000100: bk_datapath_o =  40'b0011000000100001000000000000000000000000; //  3 X 2 1 X X X 0 X X
         10'b1011000101: bk_datapath_o =  40'b0100000000110010000000000000000100000000; //  4 X 3 2 X X X 1 X 0
         10'b1011000110: bk_datapath_o =  40'b0100000000110010000000000000000100000000; //  4 X 3 2 X X X 1 0 X
         10'b1011000111: bk_datapath_o =  40'b0101000001000011000000000000001000010000; //  5 X 4 3 X X X 2 1 0
         10'b1011001000: bk_datapath_o =  40'b0011000000100001000000000000000000000000; //  3 X 2 1 X X 0 X X X
         10'b1011001001: bk_datapath_o =  40'b0100000000110010000000000001000000000000; //  4 X 3 2 X X 1 X X 0
         10'b1011001010: bk_datapath_o =  40'b0100000000110010000000000001000000000000; //  4 X 3 2 X X 1 X 0 X
         10'b1011001011: bk_datapath_o =  40'b0101000001000011000000000010000000010000; //  5 X 4 3 X X 2 X 1 0
         10'b1011001100: bk_datapath_o =  40'b0100000000110010000000000001000000000000; //  4 X 3 2 X X 1 0 X X
         10'b1011001101: bk_datapath_o =  40'b0101000001000011000000000010000100000000; //  5 X 4 3 X X 2 1 X 0
         10'b1011001110: bk_datapath_o =  40'b0101000001000011000000000010000100000000; //  5 X 4 3 X X 2 1 0 X
         10'b1011001111: bk_datapath_o =  40'b0110000001010100000000000011001000010000; //  6 X 5 4 X X 3 2 1 0
         10'b1011010000: bk_datapath_o =  40'b0011000000100001000000000000000000000000; //  3 X 2 1 X 0 X X X X
         10'b1011010001: bk_datapath_o =  40'b0100000000110010000000010000000000000000; //  4 X 3 2 X 1 X X X 0
         10'b1011010010: bk_datapath_o =  40'b0100000000110010000000010000000000000000; //  4 X 3 2 X 1 X X 0 X
         10'b1011010011: bk_datapath_o =  40'b0101000001000011000000100000000000010000; //  5 X 4 3 X 2 X X 1 0
         10'b1011010100: bk_datapath_o =  40'b0100000000110010000000010000000000000000; //  4 X 3 2 X 1 X 0 X X
         10'b1011010101: bk_datapath_o =  40'b0101000001000011000000100000000100000000; //  5 X 4 3 X 2 X 1 X 0
         10'b1011010110: bk_datapath_o =  40'b0101000001000011000000100000000100000000; //  5 X 4 3 X 2 X 1 0 X
         10'b1011010111: bk_datapath_o =  40'b0110000001010100000000110000001000010000; //  6 X 5 4 X 3 X 2 1 0
         10'b1011011000: bk_datapath_o =  40'b0100000000110010000000010000000000000000; //  4 X 3 2 X 1 0 X X X
         10'b1011011001: bk_datapath_o =  40'b0101000001000011000000100001000000000000; //  5 X 4 3 X 2 1 X X 0
         10'b1011011010: bk_datapath_o =  40'b0101000001000011000000100001000000000000; //  5 X 4 3 X 2 1 X 0 X
         10'b1011011011: bk_datapath_o =  40'b0110000001010100000000110010000000010000; //  6 X 5 4 X 3 2 X 1 0
         10'b1011011100: bk_datapath_o =  40'b0101000001000011000000100001000000000000; //  5 X 4 3 X 2 1 0 X X
         10'b1011011101: bk_datapath_o =  40'b0110000001010100000000110010000100000000; //  6 X 5 4 X 3 2 1 X 0
         10'b1011011110: bk_datapath_o =  40'b0110000001010100000000110010000100000000; //  6 X 5 4 X 3 2 1 0 X
         10'b1011011111: bk_datapath_o =  40'b0111000001100101000001000011001000010000; //  7 X 6 5 X 4 3 2 1 0
         10'b1011100000: bk_datapath_o =  40'b0011000000100001000000000000000000000000; //  3 X 2 1 0 X X X X X
         10'b1011100001: bk_datapath_o =  40'b0100000000110010000100000000000000000000; //  4 X 3 2 1 X X X X 0
         10'b1011100010: bk_datapath_o =  40'b0100000000110010000100000000000000000000; //  4 X 3 2 1 X X X 0 X
         10'b1011100011: bk_datapath_o =  40'b0101000001000011001000000000000000010000; //  5 X 4 3 2 X X X 1 0
         10'b1011100100: bk_datapath_o =  40'b0100000000110010000100000000000000000000; //  4 X 3 2 1 X X 0 X X
         10'b1011100101: bk_datapath_o =  40'b0101000001000011001000000000000100000000; //  5 X 4 3 2 X X 1 X 0
         10'b1011100110: bk_datapath_o =  40'b0101000001000011001000000000000100000000; //  5 X 4 3 2 X X 1 0 X
         10'b1011100111: bk_datapath_o =  40'b0110000001010100001100000000001000010000; //  6 X 5 4 3 X X 2 1 0
         10'b1011101000: bk_datapath_o =  40'b0100000000110010000100000000000000000000; //  4 X 3 2 1 X 0 X X X
         10'b1011101001: bk_datapath_o =  40'b0101000001000011001000000001000000000000; //  5 X 4 3 2 X 1 X X 0
         10'b1011101010: bk_datapath_o =  40'b0101000001000011001000000001000000000000; //  5 X 4 3 2 X 1 X 0 X
         10'b1011101011: bk_datapath_o =  40'b0110000001010100001100000010000000010000; //  6 X 5 4 3 X 2 X 1 0
         10'b1011101100: bk_datapath_o =  40'b0101000001000011001000000001000000000000; //  5 X 4 3 2 X 1 0 X X
         10'b1011101101: bk_datapath_o =  40'b0110000001010100001100000010000100000000; //  6 X 5 4 3 X 2 1 X 0
         10'b1011101110: bk_datapath_o =  40'b0110000001010100001100000010000100000000; //  6 X 5 4 3 X 2 1 0 X
         10'b1011101111: bk_datapath_o =  40'b0111000001100101010000000011001000010000; //  7 X 6 5 4 X 3 2 1 0
         10'b1011110000: bk_datapath_o =  40'b0100000000110010000100000000000000000000; //  4 X 3 2 1 0 X X X X
         10'b1011110001: bk_datapath_o =  40'b0101000001000011001000010000000000000000; //  5 X 4 3 2 1 X X X 0
         10'b1011110010: bk_datapath_o =  40'b0101000001000011001000010000000000000000; //  5 X 4 3 2 1 X X 0 X
         10'b1011110011: bk_datapath_o =  40'b0110000001010100001100100000000000010000; //  6 X 5 4 3 2 X X 1 0
         10'b1011110100: bk_datapath_o =  40'b0101000001000011001000010000000000000000; //  5 X 4 3 2 1 X 0 X X
         10'b1011110101: bk_datapath_o =  40'b0110000001010100001100100000000100000000; //  6 X 5 4 3 2 X 1 X 0
         10'b1011110110: bk_datapath_o =  40'b0110000001010100001100100000000100000000; //  6 X 5 4 3 2 X 1 0 X
         10'b1011110111: bk_datapath_o =  40'b0111000001100101010000110000001000010000; //  7 X 6 5 4 3 X 2 1 0
         10'b1011111000: bk_datapath_o =  40'b0101000001000011001000010000000000000000; //  5 X 4 3 2 1 0 X X X
         10'b1011111001: bk_datapath_o =  40'b0110000001010100001100100001000000000000; //  6 X 5 4 3 2 1 X X 0
         10'b1011111010: bk_datapath_o =  40'b0110000001010100001100100001000000000000; //  6 X 5 4 3 2 1 X 0 X
         10'b1011111011: bk_datapath_o =  40'b0111000001100101010000110010000000010000; //  7 X 6 5 4 3 2 X 1 0
         10'b1011111100: bk_datapath_o =  40'b0110000001010100001100100001000000000000; //  6 X 5 4 3 2 1 0 X X
         10'b1011111101: bk_datapath_o =  40'b0111000001100101010000110010000100000000; //  7 X 6 5 4 3 2 1 X 0
         10'b1011111110: bk_datapath_o =  40'b0111000001100101010000110010000100000000; //  7 X 6 5 4 3 2 1 0 X
         10'b1011111111: bk_datapath_o =  40'b1000000001110110010101000011001000010000; //  8 X 7 6 5 4 3 2 1 0
         10'b1100000000: bk_datapath_o =  40'b0001000000000000000000000000000000000000; //  1 0 X X X X X X X X
         10'b1100000001: bk_datapath_o =  40'b0010000100000000000000000000000000000000; //  2 1 X X X X X X X 0
         10'b1100000010: bk_datapath_o =  40'b0010000100000000000000000000000000000000; //  2 1 X X X X X X 0 X
         10'b1100000011: bk_datapath_o =  40'b0011001000000000000000000000000000010000; //  3 2 X X X X X X 1 0
         10'b1100000100: bk_datapath_o =  40'b0010000100000000000000000000000000000000; //  2 1 X X X X X 0 X X
         10'b1100000101: bk_datapath_o =  40'b0011001000000000000000000000000100000000; //  3 2 X X X X X 1 X 0
         10'b1100000110: bk_datapath_o =  40'b0011001000000000000000000000000100000000; //  3 2 X X X X X 1 0 X
         10'b1100000111: bk_datapath_o =  40'b0100001100000000000000000000001000010000; //  4 3 X X X X X 2 1 0
         10'b1100001000: bk_datapath_o =  40'b0010000100000000000000000000000000000000; //  2 1 X X X X 0 X X X
         10'b1100001001: bk_datapath_o =  40'b0011001000000000000000000001000000000000; //  3 2 X X X X 1 X X 0
         10'b1100001010: bk_datapath_o =  40'b0011001000000000000000000001000000000000; //  3 2 X X X X 1 X 0 X
         10'b1100001011: bk_datapath_o =  40'b0100001100000000000000000010000000010000; //  4 3 X X X X 2 X 1 0
         10'b1100001100: bk_datapath_o =  40'b0011001000000000000000000001000000000000; //  3 2 X X X X 1 0 X X
         10'b1100001101: bk_datapath_o =  40'b0100001100000000000000000010000100000000; //  4 3 X X X X 2 1 X 0
         10'b1100001110: bk_datapath_o =  40'b0100001100000000000000000010000100000000; //  4 3 X X X X 2 1 0 X
         10'b1100001111: bk_datapath_o =  40'b0101010000000000000000000011001000010000; //  5 4 X X X X 3 2 1 0
         10'b1100010000: bk_datapath_o =  40'b0010000100000000000000000000000000000000; //  2 1 X X X 0 X X X X
         10'b1100010001: bk_datapath_o =  40'b0011001000000000000000010000000000000000; //  3 2 X X X 1 X X X 0
         10'b1100010010: bk_datapath_o =  40'b0011001000000000000000010000000000000000; //  3 2 X X X 1 X X 0 X
         10'b1100010011: bk_datapath_o =  40'b0100001100000000000000100000000000010000; //  4 3 X X X 2 X X 1 0
         10'b1100010100: bk_datapath_o =  40'b0011001000000000000000010000000000000000; //  3 2 X X X 1 X 0 X X
         10'b1100010101: bk_datapath_o =  40'b0100001100000000000000100000000100000000; //  4 3 X X X 2 X 1 X 0
         10'b1100010110: bk_datapath_o =  40'b0100001100000000000000100000000100000000; //  4 3 X X X 2 X 1 0 X
         10'b1100010111: bk_datapath_o =  40'b0101010000000000000000110000001000010000; //  5 4 X X X 3 X 2 1 0
         10'b1100011000: bk_datapath_o =  40'b0011001000000000000000010000000000000000; //  3 2 X X X 1 0 X X X
         10'b1100011001: bk_datapath_o =  40'b0100001100000000000000100001000000000000; //  4 3 X X X 2 1 X X 0
         10'b1100011010: bk_datapath_o =  40'b0100001100000000000000100001000000000000; //  4 3 X X X 2 1 X 0 X
         10'b1100011011: bk_datapath_o =  40'b0101010000000000000000110010000000010000; //  5 4 X X X 3 2 X 1 0
         10'b1100011100: bk_datapath_o =  40'b0100001100000000000000100001000000000000; //  4 3 X X X 2 1 0 X X
         10'b1100011101: bk_datapath_o =  40'b0101010000000000000000110010000100000000; //  5 4 X X X 3 2 1 X 0
         10'b1100011110: bk_datapath_o =  40'b0101010000000000000000110010000100000000; //  5 4 X X X 3 2 1 0 X
         10'b1100011111: bk_datapath_o =  40'b0110010100000000000001000011001000010000; //  6 5 X X X 4 3 2 1 0
         10'b1100100000: bk_datapath_o =  40'b0010000100000000000000000000000000000000; //  2 1 X X 0 X X X X X
         10'b1100100001: bk_datapath_o =  40'b0011001000000000000100000000000000000000; //  3 2 X X 1 X X X X 0
         10'b1100100010: bk_datapath_o =  40'b0011001000000000000100000000000000000000; //  3 2 X X 1 X X X 0 X
         10'b1100100011: bk_datapath_o =  40'b0100001100000000001000000000000000010000; //  4 3 X X 2 X X X 1 0
         10'b1100100100: bk_datapath_o =  40'b0011001000000000000100000000000000000000; //  3 2 X X 1 X X 0 X X
         10'b1100100101: bk_datapath_o =  40'b0100001100000000001000000000000100000000; //  4 3 X X 2 X X 1 X 0
         10'b1100100110: bk_datapath_o =  40'b0100001100000000001000000000000100000000; //  4 3 X X 2 X X 1 0 X
         10'b1100100111: bk_datapath_o =  40'b0101010000000000001100000000001000010000; //  5 4 X X 3 X X 2 1 0
         10'b1100101000: bk_datapath_o =  40'b0011001000000000000100000000000000000000; //  3 2 X X 1 X 0 X X X
         10'b1100101001: bk_datapath_o =  40'b0100001100000000001000000001000000000000; //  4 3 X X 2 X 1 X X 0
         10'b1100101010: bk_datapath_o =  40'b0100001100000000001000000001000000000000; //  4 3 X X 2 X 1 X 0 X
         10'b1100101011: bk_datapath_o =  40'b0101010000000000001100000010000000010000; //  5 4 X X 3 X 2 X 1 0
         10'b1100101100: bk_datapath_o =  40'b0100001100000000001000000001000000000000; //  4 3 X X 2 X 1 0 X X
         10'b1100101101: bk_datapath_o =  40'b0101010000000000001100000010000100000000; //  5 4 X X 3 X 2 1 X 0
         10'b1100101110: bk_datapath_o =  40'b0101010000000000001100000010000100000000; //  5 4 X X 3 X 2 1 0 X
         10'b1100101111: bk_datapath_o =  40'b0110010100000000010000000011001000010000; //  6 5 X X 4 X 3 2 1 0
         10'b1100110000: bk_datapath_o =  40'b0011001000000000000100000000000000000000; //  3 2 X X 1 0 X X X X
         10'b1100110001: bk_datapath_o =  40'b0100001100000000001000010000000000000000; //  4 3 X X 2 1 X X X 0
         10'b1100110010: bk_datapath_o =  40'b0100001100000000001000010000000000000000; //  4 3 X X 2 1 X X 0 X
         10'b1100110011: bk_datapath_o =  40'b0101010000000000001100100000000000010000; //  5 4 X X 3 2 X X 1 0
         10'b1100110100: bk_datapath_o =  40'b0100001100000000001000010000000000000000; //  4 3 X X 2 1 X 0 X X
         10'b1100110101: bk_datapath_o =  40'b0101010000000000001100100000000100000000; //  5 4 X X 3 2 X 1 X 0
         10'b1100110110: bk_datapath_o =  40'b0101010000000000001100100000000100000000; //  5 4 X X 3 2 X 1 0 X
         10'b1100110111: bk_datapath_o =  40'b0110010100000000010000110000001000010000; //  6 5 X X 4 3 X 2 1 0
         10'b1100111000: bk_datapath_o =  40'b0100001100000000001000010000000000000000; //  4 3 X X 2 1 0 X X X
         10'b1100111001: bk_datapath_o =  40'b0101010000000000001100100001000000000000; //  5 4 X X 3 2 1 X X 0
         10'b1100111010: bk_datapath_o =  40'b0101010000000000001100100001000000000000; //  5 4 X X 3 2 1 X 0 X
         10'b1100111011: bk_datapath_o =  40'b0110010100000000010000110010000000010000; //  6 5 X X 4 3 2 X 1 0
         10'b1100111100: bk_datapath_o =  40'b0101010000000000001100100001000000000000; //  5 4 X X 3 2 1 0 X X
         10'b1100111101: bk_datapath_o =  40'b0110010100000000010000110010000100000000; //  6 5 X X 4 3 2 1 X 0
         10'b1100111110: bk_datapath_o =  40'b0110010100000000010000110010000100000000; //  6 5 X X 4 3 2 1 0 X
         10'b1100111111: bk_datapath_o =  40'b0111011000000000010101000011001000010000; //  7 6 X X 5 4 3 2 1 0
         10'b1101000000: bk_datapath_o =  40'b0010000100000000000000000000000000000000; //  2 1 X 0 X X X X X X
         10'b1101000001: bk_datapath_o =  40'b0011001000000001000000000000000000000000; //  3 2 X 1 X X X X X 0
         10'b1101000010: bk_datapath_o =  40'b0011001000000001000000000000000000000000; //  3 2 X 1 X X X X 0 X
         10'b1101000011: bk_datapath_o =  40'b0100001100000010000000000000000000010000; //  4 3 X 2 X X X X 1 0
         10'b1101000100: bk_datapath_o =  40'b0011001000000001000000000000000000000000; //  3 2 X 1 X X X 0 X X
         10'b1101000101: bk_datapath_o =  40'b0100001100000010000000000000000100000000; //  4 3 X 2 X X X 1 X 0
         10'b1101000110: bk_datapath_o =  40'b0100001100000010000000000000000100000000; //  4 3 X 2 X X X 1 0 X
         10'b1101000111: bk_datapath_o =  40'b0101010000000011000000000000001000010000; //  5 4 X 3 X X X 2 1 0
         10'b1101001000: bk_datapath_o =  40'b0011001000000001000000000000000000000000; //  3 2 X 1 X X 0 X X X
         10'b1101001001: bk_datapath_o =  40'b0100001100000010000000000001000000000000; //  4 3 X 2 X X 1 X X 0
         10'b1101001010: bk_datapath_o =  40'b0100001100000010000000000001000000000000; //  4 3 X 2 X X 1 X 0 X
         10'b1101001011: bk_datapath_o =  40'b0101010000000011000000000010000000010000; //  5 4 X 3 X X 2 X 1 0
         10'b1101001100: bk_datapath_o =  40'b0100001100000010000000000001000000000000; //  4 3 X 2 X X 1 0 X X
         10'b1101001101: bk_datapath_o =  40'b0101010000000011000000000010000100000000; //  5 4 X 3 X X 2 1 X 0
         10'b1101001110: bk_datapath_o =  40'b0101010000000011000000000010000100000000; //  5 4 X 3 X X 2 1 0 X
         10'b1101001111: bk_datapath_o =  40'b0110010100000100000000000011001000010000; //  6 5 X 4 X X 3 2 1 0
         10'b1101010000: bk_datapath_o =  40'b0011001000000001000000000000000000000000; //  3 2 X 1 X 0 X X X X
         10'b1101010001: bk_datapath_o =  40'b0100001100000010000000010000000000000000; //  4 3 X 2 X 1 X X X 0
         10'b1101010010: bk_datapath_o =  40'b0100001100000010000000010000000000000000; //  4 3 X 2 X 1 X X 0 X
         10'b1101010011: bk_datapath_o =  40'b0101010000000011000000100000000000010000; //  5 4 X 3 X 2 X X 1 0
         10'b1101010100: bk_datapath_o =  40'b0100001100000010000000010000000000000000; //  4 3 X 2 X 1 X 0 X X
         10'b1101010101: bk_datapath_o =  40'b0101010000000011000000100000000100000000; //  5 4 X 3 X 2 X 1 X 0
         10'b1101010110: bk_datapath_o =  40'b0101010000000011000000100000000100000000; //  5 4 X 3 X 2 X 1 0 X
         10'b1101010111: bk_datapath_o =  40'b0110010100000100000000110000001000010000; //  6 5 X 4 X 3 X 2 1 0
         10'b1101011000: bk_datapath_o =  40'b0100001100000010000000010000000000000000; //  4 3 X 2 X 1 0 X X X
         10'b1101011001: bk_datapath_o =  40'b0101010000000011000000100001000000000000; //  5 4 X 3 X 2 1 X X 0
         10'b1101011010: bk_datapath_o =  40'b0101010000000011000000100001000000000000; //  5 4 X 3 X 2 1 X 0 X
         10'b1101011011: bk_datapath_o =  40'b0110010100000100000000110010000000010000; //  6 5 X 4 X 3 2 X 1 0
         10'b1101011100: bk_datapath_o =  40'b0101010000000011000000100001000000000000; //  5 4 X 3 X 2 1 0 X X
         10'b1101011101: bk_datapath_o =  40'b0110010100000100000000110010000100000000; //  6 5 X 4 X 3 2 1 X 0
         10'b1101011110: bk_datapath_o =  40'b0110010100000100000000110010000100000000; //  6 5 X 4 X 3 2 1 0 X
         10'b1101011111: bk_datapath_o =  40'b0111011000000101000001000011001000010000; //  7 6 X 5 X 4 3 2 1 0
         10'b1101100000: bk_datapath_o =  40'b0011001000000001000000000000000000000000; //  3 2 X 1 0 X X X X X
         10'b1101100001: bk_datapath_o =  40'b0100001100000010000100000000000000000000; //  4 3 X 2 1 X X X X 0
         10'b1101100010: bk_datapath_o =  40'b0100001100000010000100000000000000000000; //  4 3 X 2 1 X X X 0 X
         10'b1101100011: bk_datapath_o =  40'b0101010000000011001000000000000000010000; //  5 4 X 3 2 X X X 1 0
         10'b1101100100: bk_datapath_o =  40'b0100001100000010000100000000000000000000; //  4 3 X 2 1 X X 0 X X
         10'b1101100101: bk_datapath_o =  40'b0101010000000011001000000000000100000000; //  5 4 X 3 2 X X 1 X 0
         10'b1101100110: bk_datapath_o =  40'b0101010000000011001000000000000100000000; //  5 4 X 3 2 X X 1 0 X
         10'b1101100111: bk_datapath_o =  40'b0110010100000100001100000000001000010000; //  6 5 X 4 3 X X 2 1 0
         10'b1101101000: bk_datapath_o =  40'b0100001100000010000100000000000000000000; //  4 3 X 2 1 X 0 X X X
         10'b1101101001: bk_datapath_o =  40'b0101010000000011001000000001000000000000; //  5 4 X 3 2 X 1 X X 0
         10'b1101101010: bk_datapath_o =  40'b0101010000000011001000000001000000000000; //  5 4 X 3 2 X 1 X 0 X
         10'b1101101011: bk_datapath_o =  40'b0110010100000100001100000010000000010000; //  6 5 X 4 3 X 2 X 1 0
         10'b1101101100: bk_datapath_o =  40'b0101010000000011001000000001000000000000; //  5 4 X 3 2 X 1 0 X X
         10'b1101101101: bk_datapath_o =  40'b0110010100000100001100000010000100000000; //  6 5 X 4 3 X 2 1 X 0
         10'b1101101110: bk_datapath_o =  40'b0110010100000100001100000010000100000000; //  6 5 X 4 3 X 2 1 0 X
         10'b1101101111: bk_datapath_o =  40'b0111011000000101010000000011001000010000; //  7 6 X 5 4 X 3 2 1 0
         10'b1101110000: bk_datapath_o =  40'b0100001100000010000100000000000000000000; //  4 3 X 2 1 0 X X X X
         10'b1101110001: bk_datapath_o =  40'b0101010000000011001000010000000000000000; //  5 4 X 3 2 1 X X X 0
         10'b1101110010: bk_datapath_o =  40'b0101010000000011001000010000000000000000; //  5 4 X 3 2 1 X X 0 X
         10'b1101110011: bk_datapath_o =  40'b0110010100000100001100100000000000010000; //  6 5 X 4 3 2 X X 1 0
         10'b1101110100: bk_datapath_o =  40'b0101010000000011001000010000000000000000; //  5 4 X 3 2 1 X 0 X X
         10'b1101110101: bk_datapath_o =  40'b0110010100000100001100100000000100000000; //  6 5 X 4 3 2 X 1 X 0
         10'b1101110110: bk_datapath_o =  40'b0110010100000100001100100000000100000000; //  6 5 X 4 3 2 X 1 0 X
         10'b1101110111: bk_datapath_o =  40'b0111011000000101010000110000001000010000; //  7 6 X 5 4 3 X 2 1 0
         10'b1101111000: bk_datapath_o =  40'b0101010000000011001000010000000000000000; //  5 4 X 3 2 1 0 X X X
         10'b1101111001: bk_datapath_o =  40'b0110010100000100001100100001000000000000; //  6 5 X 4 3 2 1 X X 0
         10'b1101111010: bk_datapath_o =  40'b0110010100000100001100100001000000000000; //  6 5 X 4 3 2 1 X 0 X
         10'b1101111011: bk_datapath_o =  40'b0111011000000101010000110010000000010000; //  7 6 X 5 4 3 2 X 1 0
         10'b1101111100: bk_datapath_o =  40'b0110010100000100001100100001000000000000; //  6 5 X 4 3 2 1 0 X X
         10'b1101111101: bk_datapath_o =  40'b0111011000000101010000110010000100000000; //  7 6 X 5 4 3 2 1 X 0
         10'b1101111110: bk_datapath_o =  40'b0111011000000101010000110010000100000000; //  7 6 X 5 4 3 2 1 0 X
         10'b1101111111: bk_datapath_o =  40'b1000011100000110010101000011001000010000; //  8 7 X 6 5 4 3 2 1 0
         10'b1110000000: bk_datapath_o =  40'b0010000100000000000000000000000000000000; //  2 1 0 X X X X X X X
         10'b1110000001: bk_datapath_o =  40'b0011001000010000000000000000000000000000; //  3 2 1 X X X X X X 0
         10'b1110000010: bk_datapath_o =  40'b0011001000010000000000000000000000000000; //  3 2 1 X X X X X 0 X
         10'b1110000011: bk_datapath_o =  40'b0100001100100000000000000000000000010000; //  4 3 2 X X X X X 1 0
         10'b1110000100: bk_datapath_o =  40'b0011001000010000000000000000000000000000; //  3 2 1 X X X X 0 X X
         10'b1110000101: bk_datapath_o =  40'b0100001100100000000000000000000100000000; //  4 3 2 X X X X 1 X 0
         10'b1110000110: bk_datapath_o =  40'b0100001100100000000000000000000100000000; //  4 3 2 X X X X 1 0 X
         10'b1110000111: bk_datapath_o =  40'b0101010000110000000000000000001000010000; //  5 4 3 X X X X 2 1 0
         10'b1110001000: bk_datapath_o =  40'b0011001000010000000000000000000000000000; //  3 2 1 X X X 0 X X X
         10'b1110001001: bk_datapath_o =  40'b0100001100100000000000000001000000000000; //  4 3 2 X X X 1 X X 0
         10'b1110001010: bk_datapath_o =  40'b0100001100100000000000000001000000000000; //  4 3 2 X X X 1 X 0 X
         10'b1110001011: bk_datapath_o =  40'b0101010000110000000000000010000000010000; //  5 4 3 X X X 2 X 1 0
         10'b1110001100: bk_datapath_o =  40'b0100001100100000000000000001000000000000; //  4 3 2 X X X 1 0 X X
         10'b1110001101: bk_datapath_o =  40'b0101010000110000000000000010000100000000; //  5 4 3 X X X 2 1 X 0
         10'b1110001110: bk_datapath_o =  40'b0101010000110000000000000010000100000000; //  5 4 3 X X X 2 1 0 X
         10'b1110001111: bk_datapath_o =  40'b0110010101000000000000000011001000010000; //  6 5 4 X X X 3 2 1 0
         10'b1110010000: bk_datapath_o =  40'b0011001000010000000000000000000000000000; //  3 2 1 X X 0 X X X X
         10'b1110010001: bk_datapath_o =  40'b0100001100100000000000010000000000000000; //  4 3 2 X X 1 X X X 0
         10'b1110010010: bk_datapath_o =  40'b0100001100100000000000010000000000000000; //  4 3 2 X X 1 X X 0 X
         10'b1110010011: bk_datapath_o =  40'b0101010000110000000000100000000000010000; //  5 4 3 X X 2 X X 1 0
         10'b1110010100: bk_datapath_o =  40'b0100001100100000000000010000000000000000; //  4 3 2 X X 1 X 0 X X
         10'b1110010101: bk_datapath_o =  40'b0101010000110000000000100000000100000000; //  5 4 3 X X 2 X 1 X 0
         10'b1110010110: bk_datapath_o =  40'b0101010000110000000000100000000100000000; //  5 4 3 X X 2 X 1 0 X
         10'b1110010111: bk_datapath_o =  40'b0110010101000000000000110000001000010000; //  6 5 4 X X 3 X 2 1 0
         10'b1110011000: bk_datapath_o =  40'b0100001100100000000000010000000000000000; //  4 3 2 X X 1 0 X X X
         10'b1110011001: bk_datapath_o =  40'b0101010000110000000000100001000000000000; //  5 4 3 X X 2 1 X X 0
         10'b1110011010: bk_datapath_o =  40'b0101010000110000000000100001000000000000; //  5 4 3 X X 2 1 X 0 X
         10'b1110011011: bk_datapath_o =  40'b0110010101000000000000110010000000010000; //  6 5 4 X X 3 2 X 1 0
         10'b1110011100: bk_datapath_o =  40'b0101010000110000000000100001000000000000; //  5 4 3 X X 2 1 0 X X
         10'b1110011101: bk_datapath_o =  40'b0110010101000000000000110010000100000000; //  6 5 4 X X 3 2 1 X 0
         10'b1110011110: bk_datapath_o =  40'b0110010101000000000000110010000100000000; //  6 5 4 X X 3 2 1 0 X
         10'b1110011111: bk_datapath_o =  40'b0111011001010000000001000011001000010000; //  7 6 5 X X 4 3 2 1 0
         10'b1110100000: bk_datapath_o =  40'b0011001000010000000000000000000000000000; //  3 2 1 X 0 X X X X X
         10'b1110100001: bk_datapath_o =  40'b0100001100100000000100000000000000000000; //  4 3 2 X 1 X X X X 0
         10'b1110100010: bk_datapath_o =  40'b0100001100100000000100000000000000000000; //  4 3 2 X 1 X X X 0 X
         10'b1110100011: bk_datapath_o =  40'b0101010000110000001000000000000000010000; //  5 4 3 X 2 X X X 1 0
         10'b1110100100: bk_datapath_o =  40'b0100001100100000000100000000000000000000; //  4 3 2 X 1 X X 0 X X
         10'b1110100101: bk_datapath_o =  40'b0101010000110000001000000000000100000000; //  5 4 3 X 2 X X 1 X 0
         10'b1110100110: bk_datapath_o =  40'b0101010000110000001000000000000100000000; //  5 4 3 X 2 X X 1 0 X
         10'b1110100111: bk_datapath_o =  40'b0110010101000000001100000000001000010000; //  6 5 4 X 3 X X 2 1 0
         10'b1110101000: bk_datapath_o =  40'b0100001100100000000100000000000000000000; //  4 3 2 X 1 X 0 X X X
         10'b1110101001: bk_datapath_o =  40'b0101010000110000001000000001000000000000; //  5 4 3 X 2 X 1 X X 0
         10'b1110101010: bk_datapath_o =  40'b0101010000110000001000000001000000000000; //  5 4 3 X 2 X 1 X 0 X
         10'b1110101011: bk_datapath_o =  40'b0110010101000000001100000010000000010000; //  6 5 4 X 3 X 2 X 1 0
         10'b1110101100: bk_datapath_o =  40'b0101010000110000001000000001000000000000; //  5 4 3 X 2 X 1 0 X X
         10'b1110101101: bk_datapath_o =  40'b0110010101000000001100000010000100000000; //  6 5 4 X 3 X 2 1 X 0
         10'b1110101110: bk_datapath_o =  40'b0110010101000000001100000010000100000000; //  6 5 4 X 3 X 2 1 0 X
         10'b1110101111: bk_datapath_o =  40'b0111011001010000010000000011001000010000; //  7 6 5 X 4 X 3 2 1 0
         10'b1110110000: bk_datapath_o =  40'b0100001100100000000100000000000000000000; //  4 3 2 X 1 0 X X X X
         10'b1110110001: bk_datapath_o =  40'b0101010000110000001000010000000000000000; //  5 4 3 X 2 1 X X X 0
         10'b1110110010: bk_datapath_o =  40'b0101010000110000001000010000000000000000; //  5 4 3 X 2 1 X X 0 X
         10'b1110110011: bk_datapath_o =  40'b0110010101000000001100100000000000010000; //  6 5 4 X 3 2 X X 1 0
         10'b1110110100: bk_datapath_o =  40'b0101010000110000001000010000000000000000; //  5 4 3 X 2 1 X 0 X X
         10'b1110110101: bk_datapath_o =  40'b0110010101000000001100100000000100000000; //  6 5 4 X 3 2 X 1 X 0
         10'b1110110110: bk_datapath_o =  40'b0110010101000000001100100000000100000000; //  6 5 4 X 3 2 X 1 0 X
         10'b1110110111: bk_datapath_o =  40'b0111011001010000010000110000001000010000; //  7 6 5 X 4 3 X 2 1 0
         10'b1110111000: bk_datapath_o =  40'b0101010000110000001000010000000000000000; //  5 4 3 X 2 1 0 X X X
         10'b1110111001: bk_datapath_o =  40'b0110010101000000001100100001000000000000; //  6 5 4 X 3 2 1 X X 0
         10'b1110111010: bk_datapath_o =  40'b0110010101000000001100100001000000000000; //  6 5 4 X 3 2 1 X 0 X
         10'b1110111011: bk_datapath_o =  40'b0111011001010000010000110010000000010000; //  7 6 5 X 4 3 2 X 1 0
         10'b1110111100: bk_datapath_o =  40'b0110010101000000001100100001000000000000; //  6 5 4 X 3 2 1 0 X X
         10'b1110111101: bk_datapath_o =  40'b0111011001010000010000110010000100000000; //  7 6 5 X 4 3 2 1 X 0
         10'b1110111110: bk_datapath_o =  40'b0111011001010000010000110010000100000000; //  7 6 5 X 4 3 2 1 0 X
         10'b1110111111: bk_datapath_o =  40'b1000011101100000010101000011001000010000; //  8 7 6 X 5 4 3 2 1 0
         10'b1111000000: bk_datapath_o =  40'b0011001000010000000000000000000000000000; //  3 2 1 0 X X X X X X
         10'b1111000001: bk_datapath_o =  40'b0100001100100001000000000000000000000000; //  4 3 2 1 X X X X X 0
         10'b1111000010: bk_datapath_o =  40'b0100001100100001000000000000000000000000; //  4 3 2 1 X X X X 0 X
         10'b1111000011: bk_datapath_o =  40'b0101010000110010000000000000000000010000; //  5 4 3 2 X X X X 1 0
         10'b1111000100: bk_datapath_o =  40'b0100001100100001000000000000000000000000; //  4 3 2 1 X X X 0 X X
         10'b1111000101: bk_datapath_o =  40'b0101010000110010000000000000000100000000; //  5 4 3 2 X X X 1 X 0
         10'b1111000110: bk_datapath_o =  40'b0101010000110010000000000000000100000000; //  5 4 3 2 X X X 1 0 X
         10'b1111000111: bk_datapath_o =  40'b0110010101000011000000000000001000010000; //  6 5 4 3 X X X 2 1 0
         10'b1111001000: bk_datapath_o =  40'b0100001100100001000000000000000000000000; //  4 3 2 1 X X 0 X X X
         10'b1111001001: bk_datapath_o =  40'b0101010000110010000000000001000000000000; //  5 4 3 2 X X 1 X X 0
         10'b1111001010: bk_datapath_o =  40'b0101010000110010000000000001000000000000; //  5 4 3 2 X X 1 X 0 X
         10'b1111001011: bk_datapath_o =  40'b0110010101000011000000000010000000010000; //  6 5 4 3 X X 2 X 1 0
         10'b1111001100: bk_datapath_o =  40'b0101010000110010000000000001000000000000; //  5 4 3 2 X X 1 0 X X
         10'b1111001101: bk_datapath_o =  40'b0110010101000011000000000010000100000000; //  6 5 4 3 X X 2 1 X 0
         10'b1111001110: bk_datapath_o =  40'b0110010101000011000000000010000100000000; //  6 5 4 3 X X 2 1 0 X
         10'b1111001111: bk_datapath_o =  40'b0111011001010100000000000011001000010000; //  7 6 5 4 X X 3 2 1 0
         10'b1111010000: bk_datapath_o =  40'b0100001100100001000000000000000000000000; //  4 3 2 1 X 0 X X X X
         10'b1111010001: bk_datapath_o =  40'b0101010000110010000000010000000000000000; //  5 4 3 2 X 1 X X X 0
         10'b1111010010: bk_datapath_o =  40'b0101010000110010000000010000000000000000; //  5 4 3 2 X 1 X X 0 X
         10'b1111010011: bk_datapath_o =  40'b0110010101000011000000100000000000010000; //  6 5 4 3 X 2 X X 1 0
         10'b1111010100: bk_datapath_o =  40'b0101010000110010000000010000000000000000; //  5 4 3 2 X 1 X 0 X X
         10'b1111010101: bk_datapath_o =  40'b0110010101000011000000100000000100000000; //  6 5 4 3 X 2 X 1 X 0
         10'b1111010110: bk_datapath_o =  40'b0110010101000011000000100000000100000000; //  6 5 4 3 X 2 X 1 0 X
         10'b1111010111: bk_datapath_o =  40'b0111011001010100000000110000001000010000; //  7 6 5 4 X 3 X 2 1 0
         10'b1111011000: bk_datapath_o =  40'b0101010000110010000000010000000000000000; //  5 4 3 2 X 1 0 X X X
         10'b1111011001: bk_datapath_o =  40'b0110010101000011000000100001000000000000; //  6 5 4 3 X 2 1 X X 0
         10'b1111011010: bk_datapath_o =  40'b0110010101000011000000100001000000000000; //  6 5 4 3 X 2 1 X 0 X
         10'b1111011011: bk_datapath_o =  40'b0111011001010100000000110010000000010000; //  7 6 5 4 X 3 2 X 1 0
         10'b1111011100: bk_datapath_o =  40'b0110010101000011000000100001000000000000; //  6 5 4 3 X 2 1 0 X X
         10'b1111011101: bk_datapath_o =  40'b0111011001010100000000110010000100000000; //  7 6 5 4 X 3 2 1 X 0
         10'b1111011110: bk_datapath_o =  40'b0111011001010100000000110010000100000000; //  7 6 5 4 X 3 2 1 0 X
         10'b1111011111: bk_datapath_o =  40'b1000011101100101000001000011001000010000; //  8 7 6 5 X 4 3 2 1 0
         10'b1111100000: bk_datapath_o =  40'b0100001100100001000000000000000000000000; //  4 3 2 1 0 X X X X X
         10'b1111100001: bk_datapath_o =  40'b0101010000110010000100000000000000000000; //  5 4 3 2 1 X X X X 0
         10'b1111100010: bk_datapath_o =  40'b0101010000110010000100000000000000000000; //  5 4 3 2 1 X X X 0 X
         10'b1111100011: bk_datapath_o =  40'b0110010101000011001000000000000000010000; //  6 5 4 3 2 X X X 1 0
         10'b1111100100: bk_datapath_o =  40'b0101010000110010000100000000000000000000; //  5 4 3 2 1 X X 0 X X
         10'b1111100101: bk_datapath_o =  40'b0110010101000011001000000000000100000000; //  6 5 4 3 2 X X 1 X 0
         10'b1111100110: bk_datapath_o =  40'b0110010101000011001000000000000100000000; //  6 5 4 3 2 X X 1 0 X
         10'b1111100111: bk_datapath_o =  40'b0111011001010100001100000000001000010000; //  7 6 5 4 3 X X 2 1 0
         10'b1111101000: bk_datapath_o =  40'b0101010000110010000100000000000000000000; //  5 4 3 2 1 X 0 X X X
         10'b1111101001: bk_datapath_o =  40'b0110010101000011001000000001000000000000; //  6 5 4 3 2 X 1 X X 0
         10'b1111101010: bk_datapath_o =  40'b0110010101000011001000000001000000000000; //  6 5 4 3 2 X 1 X 0 X
         10'b1111101011: bk_datapath_o =  40'b0111011001010100001100000010000000010000; //  7 6 5 4 3 X 2 X 1 0
         10'b1111101100: bk_datapath_o =  40'b0110010101000011001000000001000000000000; //  6 5 4 3 2 X 1 0 X X
         10'b1111101101: bk_datapath_o =  40'b0111011001010100001100000010000100000000; //  7 6 5 4 3 X 2 1 X 0
         10'b1111101110: bk_datapath_o =  40'b0111011001010100001100000010000100000000; //  7 6 5 4 3 X 2 1 0 X
         10'b1111101111: bk_datapath_o =  40'b1000011101100101010000000011001000010000; //  8 7 6 5 4 X 3 2 1 0
         10'b1111110000: bk_datapath_o =  40'b0101010000110010000100000000000000000000; //  5 4 3 2 1 0 X X X X
         10'b1111110001: bk_datapath_o =  40'b0110010101000011001000010000000000000000; //  6 5 4 3 2 1 X X X 0
         10'b1111110010: bk_datapath_o =  40'b0110010101000011001000010000000000000000; //  6 5 4 3 2 1 X X 0 X
         10'b1111110011: bk_datapath_o =  40'b0111011001010100001100100000000000010000; //  7 6 5 4 3 2 X X 1 0
         10'b1111110100: bk_datapath_o =  40'b0110010101000011001000010000000000000000; //  6 5 4 3 2 1 X 0 X X
         10'b1111110101: bk_datapath_o =  40'b0111011001010100001100100000000100000000; //  7 6 5 4 3 2 X 1 X 0
         10'b1111110110: bk_datapath_o =  40'b0111011001010100001100100000000100000000; //  7 6 5 4 3 2 X 1 0 X
         10'b1111110111: bk_datapath_o =  40'b1000011101100101010000110000001000010000; //  8 7 6 5 4 3 X 2 1 0
         10'b1111111000: bk_datapath_o =  40'b0110010101000011001000010000000000000000; //  6 5 4 3 2 1 0 X X X
         10'b1111111001: bk_datapath_o =  40'b0111011001010100001100100001000000000000; //  7 6 5 4 3 2 1 X X 0
         10'b1111111010: bk_datapath_o =  40'b0111011001010100001100100001000000000000; //  7 6 5 4 3 2 1 X 0 X
         10'b1111111011: bk_datapath_o =  40'b1000011101100101010000110010000000010000; //  8 7 6 5 4 3 2 X 1 0
         10'b1111111100: bk_datapath_o =  40'b0111011001010100001100100001000000000000; //  7 6 5 4 3 2 1 0 X X
         10'b1111111101: bk_datapath_o =  40'b1000011101100101010000110010000100000000; //  8 7 6 5 4 3 2 1 X 0
         10'b1111111110: bk_datapath_o =  40'b1000011101100101010000110010000100000000; //  8 7 6 5 4 3 2 1 0 X
         10'b1111111111: bk_datapath_o =  40'b1001100001110110010101000011001000010000; //  9 8 7 6 5 4 3 2 1 0
        default: bk_datapath_o= 'X;
    endcase

    // fwd vec
    always_comb
    unique case (vec_i) 
         10'b0000000000: fwd_o =  40'b1001100110011001100110011001100110011001; //  X X X X X X X X X X
         10'b0000000001: fwd_o =  40'b1001100110011001100110011001100110010000; //  X X X X X X X X X 0
         10'b0000000010: fwd_o =  40'b1001100110011001100110011001100110010001; //  X X X X X X X X X 1
         10'b0000000011: fwd_o =  40'b1001100110011001100110011001100100010000; //  X X X X X X X X 1 0
         10'b0000000100: fwd_o =  40'b1001100110011001100110011001100110010010; //  X X X X X X X X X 2
         10'b0000000101: fwd_o =  40'b1001100110011001100110011001100100100000; //  X X X X X X X X 2 0
         10'b0000000110: fwd_o =  40'b1001100110011001100110011001100100100001; //  X X X X X X X X 2 1
         10'b0000000111: fwd_o =  40'b1001100110011001100110011001001000010000; //  X X X X X X X 2 1 0
         10'b0000001000: fwd_o =  40'b1001100110011001100110011001100110010011; //  X X X X X X X X X 3
         10'b0000001001: fwd_o =  40'b1001100110011001100110011001100100110000; //  X X X X X X X X 3 0
         10'b0000001010: fwd_o =  40'b1001100110011001100110011001100100110001; //  X X X X X X X X 3 1
         10'b0000001011: fwd_o =  40'b1001100110011001100110011001001100010000; //  X X X X X X X 3 1 0
         10'b0000001100: fwd_o =  40'b1001100110011001100110011001100100110010; //  X X X X X X X X 3 2
         10'b0000001101: fwd_o =  40'b1001100110011001100110011001001100100000; //  X X X X X X X 3 2 0
         10'b0000001110: fwd_o =  40'b1001100110011001100110011001001100100001; //  X X X X X X X 3 2 1
         10'b0000001111: fwd_o =  40'b1001100110011001100110010011001000010000; //  X X X X X X 3 2 1 0
         10'b0000010000: fwd_o =  40'b1001100110011001100110011001100110010100; //  X X X X X X X X X 4
         10'b0000010001: fwd_o =  40'b1001100110011001100110011001100101000000; //  X X X X X X X X 4 0
         10'b0000010010: fwd_o =  40'b1001100110011001100110011001100101000001; //  X X X X X X X X 4 1
         10'b0000010011: fwd_o =  40'b1001100110011001100110011001010000010000; //  X X X X X X X 4 1 0
         10'b0000010100: fwd_o =  40'b1001100110011001100110011001100101000010; //  X X X X X X X X 4 2
         10'b0000010101: fwd_o =  40'b1001100110011001100110011001010000100000; //  X X X X X X X 4 2 0
         10'b0000010110: fwd_o =  40'b1001100110011001100110011001010000100001; //  X X X X X X X 4 2 1
         10'b0000010111: fwd_o =  40'b1001100110011001100110010100001000010000; //  X X X X X X 4 2 1 0
         10'b0000011000: fwd_o =  40'b1001100110011001100110011001100101000011; //  X X X X X X X X 4 3
         10'b0000011001: fwd_o =  40'b1001100110011001100110011001010000110000; //  X X X X X X X 4 3 0
         10'b0000011010: fwd_o =  40'b1001100110011001100110011001010000110001; //  X X X X X X X 4 3 1
         10'b0000011011: fwd_o =  40'b1001100110011001100110010100001100010000; //  X X X X X X 4 3 1 0
         10'b0000011100: fwd_o =  40'b1001100110011001100110011001010000110010; //  X X X X X X X 4 3 2
         10'b0000011101: fwd_o =  40'b1001100110011001100110010100001100100000; //  X X X X X X 4 3 2 0
         10'b0000011110: fwd_o =  40'b1001100110011001100110010100001100100001; //  X X X X X X 4 3 2 1
         10'b0000011111: fwd_o =  40'b1001100110011001100101000011001000010000; //  X X X X X 4 3 2 1 0
         10'b0000100000: fwd_o =  40'b1001100110011001100110011001100110010101; //  X X X X X X X X X 5
         10'b0000100001: fwd_o =  40'b1001100110011001100110011001100101010000; //  X X X X X X X X 5 0
         10'b0000100010: fwd_o =  40'b1001100110011001100110011001100101010001; //  X X X X X X X X 5 1
         10'b0000100011: fwd_o =  40'b1001100110011001100110011001010100010000; //  X X X X X X X 5 1 0
         10'b0000100100: fwd_o =  40'b1001100110011001100110011001100101010010; //  X X X X X X X X 5 2
         10'b0000100101: fwd_o =  40'b1001100110011001100110011001010100100000; //  X X X X X X X 5 2 0
         10'b0000100110: fwd_o =  40'b1001100110011001100110011001010100100001; //  X X X X X X X 5 2 1
         10'b0000100111: fwd_o =  40'b1001100110011001100110010101001000010000; //  X X X X X X 5 2 1 0
         10'b0000101000: fwd_o =  40'b1001100110011001100110011001100101010011; //  X X X X X X X X 5 3
         10'b0000101001: fwd_o =  40'b1001100110011001100110011001010100110000; //  X X X X X X X 5 3 0
         10'b0000101010: fwd_o =  40'b1001100110011001100110011001010100110001; //  X X X X X X X 5 3 1
         10'b0000101011: fwd_o =  40'b1001100110011001100110010101001100010000; //  X X X X X X 5 3 1 0
         10'b0000101100: fwd_o =  40'b1001100110011001100110011001010100110010; //  X X X X X X X 5 3 2
         10'b0000101101: fwd_o =  40'b1001100110011001100110010101001100100000; //  X X X X X X 5 3 2 0
         10'b0000101110: fwd_o =  40'b1001100110011001100110010101001100100001; //  X X X X X X 5 3 2 1
         10'b0000101111: fwd_o =  40'b1001100110011001100101010011001000010000; //  X X X X X 5 3 2 1 0
         10'b0000110000: fwd_o =  40'b1001100110011001100110011001100101010100; //  X X X X X X X X 5 4
         10'b0000110001: fwd_o =  40'b1001100110011001100110011001010101000000; //  X X X X X X X 5 4 0
         10'b0000110010: fwd_o =  40'b1001100110011001100110011001010101000001; //  X X X X X X X 5 4 1
         10'b0000110011: fwd_o =  40'b1001100110011001100110010101010000010000; //  X X X X X X 5 4 1 0
         10'b0000110100: fwd_o =  40'b1001100110011001100110011001010101000010; //  X X X X X X X 5 4 2
         10'b0000110101: fwd_o =  40'b1001100110011001100110010101010000100000; //  X X X X X X 5 4 2 0
         10'b0000110110: fwd_o =  40'b1001100110011001100110010101010000100001; //  X X X X X X 5 4 2 1
         10'b0000110111: fwd_o =  40'b1001100110011001100101010100001000010000; //  X X X X X 5 4 2 1 0
         10'b0000111000: fwd_o =  40'b1001100110011001100110011001010101000011; //  X X X X X X X 5 4 3
         10'b0000111001: fwd_o =  40'b1001100110011001100110010101010000110000; //  X X X X X X 5 4 3 0
         10'b0000111010: fwd_o =  40'b1001100110011001100110010101010000110001; //  X X X X X X 5 4 3 1
         10'b0000111011: fwd_o =  40'b1001100110011001100101010100001100010000; //  X X X X X 5 4 3 1 0
         10'b0000111100: fwd_o =  40'b1001100110011001100110010101010000110010; //  X X X X X X 5 4 3 2
         10'b0000111101: fwd_o =  40'b1001100110011001100101010100001100100000; //  X X X X X 5 4 3 2 0
         10'b0000111110: fwd_o =  40'b1001100110011001100101010100001100100001; //  X X X X X 5 4 3 2 1
         10'b0000111111: fwd_o =  40'b1001100110011001010101000011001000010000; //  X X X X 5 4 3 2 1 0
         10'b0001000000: fwd_o =  40'b1001100110011001100110011001100110010110; //  X X X X X X X X X 6
         10'b0001000001: fwd_o =  40'b1001100110011001100110011001100101100000; //  X X X X X X X X 6 0
         10'b0001000010: fwd_o =  40'b1001100110011001100110011001100101100001; //  X X X X X X X X 6 1
         10'b0001000011: fwd_o =  40'b1001100110011001100110011001011000010000; //  X X X X X X X 6 1 0
         10'b0001000100: fwd_o =  40'b1001100110011001100110011001100101100010; //  X X X X X X X X 6 2
         10'b0001000101: fwd_o =  40'b1001100110011001100110011001011000100000; //  X X X X X X X 6 2 0
         10'b0001000110: fwd_o =  40'b1001100110011001100110011001011000100001; //  X X X X X X X 6 2 1
         10'b0001000111: fwd_o =  40'b1001100110011001100110010110001000010000; //  X X X X X X 6 2 1 0
         10'b0001001000: fwd_o =  40'b1001100110011001100110011001100101100011; //  X X X X X X X X 6 3
         10'b0001001001: fwd_o =  40'b1001100110011001100110011001011000110000; //  X X X X X X X 6 3 0
         10'b0001001010: fwd_o =  40'b1001100110011001100110011001011000110001; //  X X X X X X X 6 3 1
         10'b0001001011: fwd_o =  40'b1001100110011001100110010110001100010000; //  X X X X X X 6 3 1 0
         10'b0001001100: fwd_o =  40'b1001100110011001100110011001011000110010; //  X X X X X X X 6 3 2
         10'b0001001101: fwd_o =  40'b1001100110011001100110010110001100100000; //  X X X X X X 6 3 2 0
         10'b0001001110: fwd_o =  40'b1001100110011001100110010110001100100001; //  X X X X X X 6 3 2 1
         10'b0001001111: fwd_o =  40'b1001100110011001100101100011001000010000; //  X X X X X 6 3 2 1 0
         10'b0001010000: fwd_o =  40'b1001100110011001100110011001100101100100; //  X X X X X X X X 6 4
         10'b0001010001: fwd_o =  40'b1001100110011001100110011001011001000000; //  X X X X X X X 6 4 0
         10'b0001010010: fwd_o =  40'b1001100110011001100110011001011001000001; //  X X X X X X X 6 4 1
         10'b0001010011: fwd_o =  40'b1001100110011001100110010110010000010000; //  X X X X X X 6 4 1 0
         10'b0001010100: fwd_o =  40'b1001100110011001100110011001011001000010; //  X X X X X X X 6 4 2
         10'b0001010101: fwd_o =  40'b1001100110011001100110010110010000100000; //  X X X X X X 6 4 2 0
         10'b0001010110: fwd_o =  40'b1001100110011001100110010110010000100001; //  X X X X X X 6 4 2 1
         10'b0001010111: fwd_o =  40'b1001100110011001100101100100001000010000; //  X X X X X 6 4 2 1 0
         10'b0001011000: fwd_o =  40'b1001100110011001100110011001011001000011; //  X X X X X X X 6 4 3
         10'b0001011001: fwd_o =  40'b1001100110011001100110010110010000110000; //  X X X X X X 6 4 3 0
         10'b0001011010: fwd_o =  40'b1001100110011001100110010110010000110001; //  X X X X X X 6 4 3 1
         10'b0001011011: fwd_o =  40'b1001100110011001100101100100001100010000; //  X X X X X 6 4 3 1 0
         10'b0001011100: fwd_o =  40'b1001100110011001100110010110010000110010; //  X X X X X X 6 4 3 2
         10'b0001011101: fwd_o =  40'b1001100110011001100101100100001100100000; //  X X X X X 6 4 3 2 0
         10'b0001011110: fwd_o =  40'b1001100110011001100101100100001100100001; //  X X X X X 6 4 3 2 1
         10'b0001011111: fwd_o =  40'b1001100110011001011001000011001000010000; //  X X X X 6 4 3 2 1 0
         10'b0001100000: fwd_o =  40'b1001100110011001100110011001100101100101; //  X X X X X X X X 6 5
         10'b0001100001: fwd_o =  40'b1001100110011001100110011001011001010000; //  X X X X X X X 6 5 0
         10'b0001100010: fwd_o =  40'b1001100110011001100110011001011001010001; //  X X X X X X X 6 5 1
         10'b0001100011: fwd_o =  40'b1001100110011001100110010110010100010000; //  X X X X X X 6 5 1 0
         10'b0001100100: fwd_o =  40'b1001100110011001100110011001011001010010; //  X X X X X X X 6 5 2
         10'b0001100101: fwd_o =  40'b1001100110011001100110010110010100100000; //  X X X X X X 6 5 2 0
         10'b0001100110: fwd_o =  40'b1001100110011001100110010110010100100001; //  X X X X X X 6 5 2 1
         10'b0001100111: fwd_o =  40'b1001100110011001100101100101001000010000; //  X X X X X 6 5 2 1 0
         10'b0001101000: fwd_o =  40'b1001100110011001100110011001011001010011; //  X X X X X X X 6 5 3
         10'b0001101001: fwd_o =  40'b1001100110011001100110010110010100110000; //  X X X X X X 6 5 3 0
         10'b0001101010: fwd_o =  40'b1001100110011001100110010110010100110001; //  X X X X X X 6 5 3 1
         10'b0001101011: fwd_o =  40'b1001100110011001100101100101001100010000; //  X X X X X 6 5 3 1 0
         10'b0001101100: fwd_o =  40'b1001100110011001100110010110010100110010; //  X X X X X X 6 5 3 2
         10'b0001101101: fwd_o =  40'b1001100110011001100101100101001100100000; //  X X X X X 6 5 3 2 0
         10'b0001101110: fwd_o =  40'b1001100110011001100101100101001100100001; //  X X X X X 6 5 3 2 1
         10'b0001101111: fwd_o =  40'b1001100110011001011001010011001000010000; //  X X X X 6 5 3 2 1 0
         10'b0001110000: fwd_o =  40'b1001100110011001100110011001011001010100; //  X X X X X X X 6 5 4
         10'b0001110001: fwd_o =  40'b1001100110011001100110010110010101000000; //  X X X X X X 6 5 4 0
         10'b0001110010: fwd_o =  40'b1001100110011001100110010110010101000001; //  X X X X X X 6 5 4 1
         10'b0001110011: fwd_o =  40'b1001100110011001100101100101010000010000; //  X X X X X 6 5 4 1 0
         10'b0001110100: fwd_o =  40'b1001100110011001100110010110010101000010; //  X X X X X X 6 5 4 2
         10'b0001110101: fwd_o =  40'b1001100110011001100101100101010000100000; //  X X X X X 6 5 4 2 0
         10'b0001110110: fwd_o =  40'b1001100110011001100101100101010000100001; //  X X X X X 6 5 4 2 1
         10'b0001110111: fwd_o =  40'b1001100110011001011001010100001000010000; //  X X X X 6 5 4 2 1 0
         10'b0001111000: fwd_o =  40'b1001100110011001100110010110010101000011; //  X X X X X X 6 5 4 3
         10'b0001111001: fwd_o =  40'b1001100110011001100101100101010000110000; //  X X X X X 6 5 4 3 0
         10'b0001111010: fwd_o =  40'b1001100110011001100101100101010000110001; //  X X X X X 6 5 4 3 1
         10'b0001111011: fwd_o =  40'b1001100110011001011001010100001100010000; //  X X X X 6 5 4 3 1 0
         10'b0001111100: fwd_o =  40'b1001100110011001100101100101010000110010; //  X X X X X 6 5 4 3 2
         10'b0001111101: fwd_o =  40'b1001100110011001011001010100001100100000; //  X X X X 6 5 4 3 2 0
         10'b0001111110: fwd_o =  40'b1001100110011001011001010100001100100001; //  X X X X 6 5 4 3 2 1
         10'b0001111111: fwd_o =  40'b1001100110010110010101000011001000010000; //  X X X 6 5 4 3 2 1 0
         10'b0010000000: fwd_o =  40'b1001100110011001100110011001100110010111; //  X X X X X X X X X 7
         10'b0010000001: fwd_o =  40'b1001100110011001100110011001100101110000; //  X X X X X X X X 7 0
         10'b0010000010: fwd_o =  40'b1001100110011001100110011001100101110001; //  X X X X X X X X 7 1
         10'b0010000011: fwd_o =  40'b1001100110011001100110011001011100010000; //  X X X X X X X 7 1 0
         10'b0010000100: fwd_o =  40'b1001100110011001100110011001100101110010; //  X X X X X X X X 7 2
         10'b0010000101: fwd_o =  40'b1001100110011001100110011001011100100000; //  X X X X X X X 7 2 0
         10'b0010000110: fwd_o =  40'b1001100110011001100110011001011100100001; //  X X X X X X X 7 2 1
         10'b0010000111: fwd_o =  40'b1001100110011001100110010111001000010000; //  X X X X X X 7 2 1 0
         10'b0010001000: fwd_o =  40'b1001100110011001100110011001100101110011; //  X X X X X X X X 7 3
         10'b0010001001: fwd_o =  40'b1001100110011001100110011001011100110000; //  X X X X X X X 7 3 0
         10'b0010001010: fwd_o =  40'b1001100110011001100110011001011100110001; //  X X X X X X X 7 3 1
         10'b0010001011: fwd_o =  40'b1001100110011001100110010111001100010000; //  X X X X X X 7 3 1 0
         10'b0010001100: fwd_o =  40'b1001100110011001100110011001011100110010; //  X X X X X X X 7 3 2
         10'b0010001101: fwd_o =  40'b1001100110011001100110010111001100100000; //  X X X X X X 7 3 2 0
         10'b0010001110: fwd_o =  40'b1001100110011001100110010111001100100001; //  X X X X X X 7 3 2 1
         10'b0010001111: fwd_o =  40'b1001100110011001100101110011001000010000; //  X X X X X 7 3 2 1 0
         10'b0010010000: fwd_o =  40'b1001100110011001100110011001100101110100; //  X X X X X X X X 7 4
         10'b0010010001: fwd_o =  40'b1001100110011001100110011001011101000000; //  X X X X X X X 7 4 0
         10'b0010010010: fwd_o =  40'b1001100110011001100110011001011101000001; //  X X X X X X X 7 4 1
         10'b0010010011: fwd_o =  40'b1001100110011001100110010111010000010000; //  X X X X X X 7 4 1 0
         10'b0010010100: fwd_o =  40'b1001100110011001100110011001011101000010; //  X X X X X X X 7 4 2
         10'b0010010101: fwd_o =  40'b1001100110011001100110010111010000100000; //  X X X X X X 7 4 2 0
         10'b0010010110: fwd_o =  40'b1001100110011001100110010111010000100001; //  X X X X X X 7 4 2 1
         10'b0010010111: fwd_o =  40'b1001100110011001100101110100001000010000; //  X X X X X 7 4 2 1 0
         10'b0010011000: fwd_o =  40'b1001100110011001100110011001011101000011; //  X X X X X X X 7 4 3
         10'b0010011001: fwd_o =  40'b1001100110011001100110010111010000110000; //  X X X X X X 7 4 3 0
         10'b0010011010: fwd_o =  40'b1001100110011001100110010111010000110001; //  X X X X X X 7 4 3 1
         10'b0010011011: fwd_o =  40'b1001100110011001100101110100001100010000; //  X X X X X 7 4 3 1 0
         10'b0010011100: fwd_o =  40'b1001100110011001100110010111010000110010; //  X X X X X X 7 4 3 2
         10'b0010011101: fwd_o =  40'b1001100110011001100101110100001100100000; //  X X X X X 7 4 3 2 0
         10'b0010011110: fwd_o =  40'b1001100110011001100101110100001100100001; //  X X X X X 7 4 3 2 1
         10'b0010011111: fwd_o =  40'b1001100110011001011101000011001000010000; //  X X X X 7 4 3 2 1 0
         10'b0010100000: fwd_o =  40'b1001100110011001100110011001100101110101; //  X X X X X X X X 7 5
         10'b0010100001: fwd_o =  40'b1001100110011001100110011001011101010000; //  X X X X X X X 7 5 0
         10'b0010100010: fwd_o =  40'b1001100110011001100110011001011101010001; //  X X X X X X X 7 5 1
         10'b0010100011: fwd_o =  40'b1001100110011001100110010111010100010000; //  X X X X X X 7 5 1 0
         10'b0010100100: fwd_o =  40'b1001100110011001100110011001011101010010; //  X X X X X X X 7 5 2
         10'b0010100101: fwd_o =  40'b1001100110011001100110010111010100100000; //  X X X X X X 7 5 2 0
         10'b0010100110: fwd_o =  40'b1001100110011001100110010111010100100001; //  X X X X X X 7 5 2 1
         10'b0010100111: fwd_o =  40'b1001100110011001100101110101001000010000; //  X X X X X 7 5 2 1 0
         10'b0010101000: fwd_o =  40'b1001100110011001100110011001011101010011; //  X X X X X X X 7 5 3
         10'b0010101001: fwd_o =  40'b1001100110011001100110010111010100110000; //  X X X X X X 7 5 3 0
         10'b0010101010: fwd_o =  40'b1001100110011001100110010111010100110001; //  X X X X X X 7 5 3 1
         10'b0010101011: fwd_o =  40'b1001100110011001100101110101001100010000; //  X X X X X 7 5 3 1 0
         10'b0010101100: fwd_o =  40'b1001100110011001100110010111010100110010; //  X X X X X X 7 5 3 2
         10'b0010101101: fwd_o =  40'b1001100110011001100101110101001100100000; //  X X X X X 7 5 3 2 0
         10'b0010101110: fwd_o =  40'b1001100110011001100101110101001100100001; //  X X X X X 7 5 3 2 1
         10'b0010101111: fwd_o =  40'b1001100110011001011101010011001000010000; //  X X X X 7 5 3 2 1 0
         10'b0010110000: fwd_o =  40'b1001100110011001100110011001011101010100; //  X X X X X X X 7 5 4
         10'b0010110001: fwd_o =  40'b1001100110011001100110010111010101000000; //  X X X X X X 7 5 4 0
         10'b0010110010: fwd_o =  40'b1001100110011001100110010111010101000001; //  X X X X X X 7 5 4 1
         10'b0010110011: fwd_o =  40'b1001100110011001100101110101010000010000; //  X X X X X 7 5 4 1 0
         10'b0010110100: fwd_o =  40'b1001100110011001100110010111010101000010; //  X X X X X X 7 5 4 2
         10'b0010110101: fwd_o =  40'b1001100110011001100101110101010000100000; //  X X X X X 7 5 4 2 0
         10'b0010110110: fwd_o =  40'b1001100110011001100101110101010000100001; //  X X X X X 7 5 4 2 1
         10'b0010110111: fwd_o =  40'b1001100110011001011101010100001000010000; //  X X X X 7 5 4 2 1 0
         10'b0010111000: fwd_o =  40'b1001100110011001100110010111010101000011; //  X X X X X X 7 5 4 3
         10'b0010111001: fwd_o =  40'b1001100110011001100101110101010000110000; //  X X X X X 7 5 4 3 0
         10'b0010111010: fwd_o =  40'b1001100110011001100101110101010000110001; //  X X X X X 7 5 4 3 1
         10'b0010111011: fwd_o =  40'b1001100110011001011101010100001100010000; //  X X X X 7 5 4 3 1 0
         10'b0010111100: fwd_o =  40'b1001100110011001100101110101010000110010; //  X X X X X 7 5 4 3 2
         10'b0010111101: fwd_o =  40'b1001100110011001011101010100001100100000; //  X X X X 7 5 4 3 2 0
         10'b0010111110: fwd_o =  40'b1001100110011001011101010100001100100001; //  X X X X 7 5 4 3 2 1
         10'b0010111111: fwd_o =  40'b1001100110010111010101000011001000010000; //  X X X 7 5 4 3 2 1 0
         10'b0011000000: fwd_o =  40'b1001100110011001100110011001100101110110; //  X X X X X X X X 7 6
         10'b0011000001: fwd_o =  40'b1001100110011001100110011001011101100000; //  X X X X X X X 7 6 0
         10'b0011000010: fwd_o =  40'b1001100110011001100110011001011101100001; //  X X X X X X X 7 6 1
         10'b0011000011: fwd_o =  40'b1001100110011001100110010111011000010000; //  X X X X X X 7 6 1 0
         10'b0011000100: fwd_o =  40'b1001100110011001100110011001011101100010; //  X X X X X X X 7 6 2
         10'b0011000101: fwd_o =  40'b1001100110011001100110010111011000100000; //  X X X X X X 7 6 2 0
         10'b0011000110: fwd_o =  40'b1001100110011001100110010111011000100001; //  X X X X X X 7 6 2 1
         10'b0011000111: fwd_o =  40'b1001100110011001100101110110001000010000; //  X X X X X 7 6 2 1 0
         10'b0011001000: fwd_o =  40'b1001100110011001100110011001011101100011; //  X X X X X X X 7 6 3
         10'b0011001001: fwd_o =  40'b1001100110011001100110010111011000110000; //  X X X X X X 7 6 3 0
         10'b0011001010: fwd_o =  40'b1001100110011001100110010111011000110001; //  X X X X X X 7 6 3 1
         10'b0011001011: fwd_o =  40'b1001100110011001100101110110001100010000; //  X X X X X 7 6 3 1 0
         10'b0011001100: fwd_o =  40'b1001100110011001100110010111011000110010; //  X X X X X X 7 6 3 2
         10'b0011001101: fwd_o =  40'b1001100110011001100101110110001100100000; //  X X X X X 7 6 3 2 0
         10'b0011001110: fwd_o =  40'b1001100110011001100101110110001100100001; //  X X X X X 7 6 3 2 1
         10'b0011001111: fwd_o =  40'b1001100110011001011101100011001000010000; //  X X X X 7 6 3 2 1 0
         10'b0011010000: fwd_o =  40'b1001100110011001100110011001011101100100; //  X X X X X X X 7 6 4
         10'b0011010001: fwd_o =  40'b1001100110011001100110010111011001000000; //  X X X X X X 7 6 4 0
         10'b0011010010: fwd_o =  40'b1001100110011001100110010111011001000001; //  X X X X X X 7 6 4 1
         10'b0011010011: fwd_o =  40'b1001100110011001100101110110010000010000; //  X X X X X 7 6 4 1 0
         10'b0011010100: fwd_o =  40'b1001100110011001100110010111011001000010; //  X X X X X X 7 6 4 2
         10'b0011010101: fwd_o =  40'b1001100110011001100101110110010000100000; //  X X X X X 7 6 4 2 0
         10'b0011010110: fwd_o =  40'b1001100110011001100101110110010000100001; //  X X X X X 7 6 4 2 1
         10'b0011010111: fwd_o =  40'b1001100110011001011101100100001000010000; //  X X X X 7 6 4 2 1 0
         10'b0011011000: fwd_o =  40'b1001100110011001100110010111011001000011; //  X X X X X X 7 6 4 3
         10'b0011011001: fwd_o =  40'b1001100110011001100101110110010000110000; //  X X X X X 7 6 4 3 0
         10'b0011011010: fwd_o =  40'b1001100110011001100101110110010000110001; //  X X X X X 7 6 4 3 1
         10'b0011011011: fwd_o =  40'b1001100110011001011101100100001100010000; //  X X X X 7 6 4 3 1 0
         10'b0011011100: fwd_o =  40'b1001100110011001100101110110010000110010; //  X X X X X 7 6 4 3 2
         10'b0011011101: fwd_o =  40'b1001100110011001011101100100001100100000; //  X X X X 7 6 4 3 2 0
         10'b0011011110: fwd_o =  40'b1001100110011001011101100100001100100001; //  X X X X 7 6 4 3 2 1
         10'b0011011111: fwd_o =  40'b1001100110010111011001000011001000010000; //  X X X 7 6 4 3 2 1 0
         10'b0011100000: fwd_o =  40'b1001100110011001100110011001011101100101; //  X X X X X X X 7 6 5
         10'b0011100001: fwd_o =  40'b1001100110011001100110010111011001010000; //  X X X X X X 7 6 5 0
         10'b0011100010: fwd_o =  40'b1001100110011001100110010111011001010001; //  X X X X X X 7 6 5 1
         10'b0011100011: fwd_o =  40'b1001100110011001100101110110010100010000; //  X X X X X 7 6 5 1 0
         10'b0011100100: fwd_o =  40'b1001100110011001100110010111011001010010; //  X X X X X X 7 6 5 2
         10'b0011100101: fwd_o =  40'b1001100110011001100101110110010100100000; //  X X X X X 7 6 5 2 0
         10'b0011100110: fwd_o =  40'b1001100110011001100101110110010100100001; //  X X X X X 7 6 5 2 1
         10'b0011100111: fwd_o =  40'b1001100110011001011101100101001000010000; //  X X X X 7 6 5 2 1 0
         10'b0011101000: fwd_o =  40'b1001100110011001100110010111011001010011; //  X X X X X X 7 6 5 3
         10'b0011101001: fwd_o =  40'b1001100110011001100101110110010100110000; //  X X X X X 7 6 5 3 0
         10'b0011101010: fwd_o =  40'b1001100110011001100101110110010100110001; //  X X X X X 7 6 5 3 1
         10'b0011101011: fwd_o =  40'b1001100110011001011101100101001100010000; //  X X X X 7 6 5 3 1 0
         10'b0011101100: fwd_o =  40'b1001100110011001100101110110010100110010; //  X X X X X 7 6 5 3 2
         10'b0011101101: fwd_o =  40'b1001100110011001011101100101001100100000; //  X X X X 7 6 5 3 2 0
         10'b0011101110: fwd_o =  40'b1001100110011001011101100101001100100001; //  X X X X 7 6 5 3 2 1
         10'b0011101111: fwd_o =  40'b1001100110010111011001010011001000010000; //  X X X 7 6 5 3 2 1 0
         10'b0011110000: fwd_o =  40'b1001100110011001100110010111011001010100; //  X X X X X X 7 6 5 4
         10'b0011110001: fwd_o =  40'b1001100110011001100101110110010101000000; //  X X X X X 7 6 5 4 0
         10'b0011110010: fwd_o =  40'b1001100110011001100101110110010101000001; //  X X X X X 7 6 5 4 1
         10'b0011110011: fwd_o =  40'b1001100110011001011101100101010000010000; //  X X X X 7 6 5 4 1 0
         10'b0011110100: fwd_o =  40'b1001100110011001100101110110010101000010; //  X X X X X 7 6 5 4 2
         10'b0011110101: fwd_o =  40'b1001100110011001011101100101010000100000; //  X X X X 7 6 5 4 2 0
         10'b0011110110: fwd_o =  40'b1001100110011001011101100101010000100001; //  X X X X 7 6 5 4 2 1
         10'b0011110111: fwd_o =  40'b1001100110010111011001010100001000010000; //  X X X 7 6 5 4 2 1 0
         10'b0011111000: fwd_o =  40'b1001100110011001100101110110010101000011; //  X X X X X 7 6 5 4 3
         10'b0011111001: fwd_o =  40'b1001100110011001011101100101010000110000; //  X X X X 7 6 5 4 3 0
         10'b0011111010: fwd_o =  40'b1001100110011001011101100101010000110001; //  X X X X 7 6 5 4 3 1
         10'b0011111011: fwd_o =  40'b1001100110010111011001010100001100010000; //  X X X 7 6 5 4 3 1 0
         10'b0011111100: fwd_o =  40'b1001100110011001011101100101010000110010; //  X X X X 7 6 5 4 3 2
         10'b0011111101: fwd_o =  40'b1001100110010111011001010100001100100000; //  X X X 7 6 5 4 3 2 0
         10'b0011111110: fwd_o =  40'b1001100110010111011001010100001100100001; //  X X X 7 6 5 4 3 2 1
         10'b0011111111: fwd_o =  40'b1001100101110110010101000011001000010000; //  X X 7 6 5 4 3 2 1 0
         10'b0100000000: fwd_o =  40'b1001100110011001100110011001100110011000; //  X X X X X X X X X 8
         10'b0100000001: fwd_o =  40'b1001100110011001100110011001100110000000; //  X X X X X X X X 8 0
         10'b0100000010: fwd_o =  40'b1001100110011001100110011001100110000001; //  X X X X X X X X 8 1
         10'b0100000011: fwd_o =  40'b1001100110011001100110011001100000010000; //  X X X X X X X 8 1 0
         10'b0100000100: fwd_o =  40'b1001100110011001100110011001100110000010; //  X X X X X X X X 8 2
         10'b0100000101: fwd_o =  40'b1001100110011001100110011001100000100000; //  X X X X X X X 8 2 0
         10'b0100000110: fwd_o =  40'b1001100110011001100110011001100000100001; //  X X X X X X X 8 2 1
         10'b0100000111: fwd_o =  40'b1001100110011001100110011000001000010000; //  X X X X X X 8 2 1 0
         10'b0100001000: fwd_o =  40'b1001100110011001100110011001100110000011; //  X X X X X X X X 8 3
         10'b0100001001: fwd_o =  40'b1001100110011001100110011001100000110000; //  X X X X X X X 8 3 0
         10'b0100001010: fwd_o =  40'b1001100110011001100110011001100000110001; //  X X X X X X X 8 3 1
         10'b0100001011: fwd_o =  40'b1001100110011001100110011000001100010000; //  X X X X X X 8 3 1 0
         10'b0100001100: fwd_o =  40'b1001100110011001100110011001100000110010; //  X X X X X X X 8 3 2
         10'b0100001101: fwd_o =  40'b1001100110011001100110011000001100100000; //  X X X X X X 8 3 2 0
         10'b0100001110: fwd_o =  40'b1001100110011001100110011000001100100001; //  X X X X X X 8 3 2 1
         10'b0100001111: fwd_o =  40'b1001100110011001100110000011001000010000; //  X X X X X 8 3 2 1 0
         10'b0100010000: fwd_o =  40'b1001100110011001100110011001100110000100; //  X X X X X X X X 8 4
         10'b0100010001: fwd_o =  40'b1001100110011001100110011001100001000000; //  X X X X X X X 8 4 0
         10'b0100010010: fwd_o =  40'b1001100110011001100110011001100001000001; //  X X X X X X X 8 4 1
         10'b0100010011: fwd_o =  40'b1001100110011001100110011000010000010000; //  X X X X X X 8 4 1 0
         10'b0100010100: fwd_o =  40'b1001100110011001100110011001100001000010; //  X X X X X X X 8 4 2
         10'b0100010101: fwd_o =  40'b1001100110011001100110011000010000100000; //  X X X X X X 8 4 2 0
         10'b0100010110: fwd_o =  40'b1001100110011001100110011000010000100001; //  X X X X X X 8 4 2 1
         10'b0100010111: fwd_o =  40'b1001100110011001100110000100001000010000; //  X X X X X 8 4 2 1 0
         10'b0100011000: fwd_o =  40'b1001100110011001100110011001100001000011; //  X X X X X X X 8 4 3
         10'b0100011001: fwd_o =  40'b1001100110011001100110011000010000110000; //  X X X X X X 8 4 3 0
         10'b0100011010: fwd_o =  40'b1001100110011001100110011000010000110001; //  X X X X X X 8 4 3 1
         10'b0100011011: fwd_o =  40'b1001100110011001100110000100001100010000; //  X X X X X 8 4 3 1 0
         10'b0100011100: fwd_o =  40'b1001100110011001100110011000010000110010; //  X X X X X X 8 4 3 2
         10'b0100011101: fwd_o =  40'b1001100110011001100110000100001100100000; //  X X X X X 8 4 3 2 0
         10'b0100011110: fwd_o =  40'b1001100110011001100110000100001100100001; //  X X X X X 8 4 3 2 1
         10'b0100011111: fwd_o =  40'b1001100110011001100001000011001000010000; //  X X X X 8 4 3 2 1 0
         10'b0100100000: fwd_o =  40'b1001100110011001100110011001100110000101; //  X X X X X X X X 8 5
         10'b0100100001: fwd_o =  40'b1001100110011001100110011001100001010000; //  X X X X X X X 8 5 0
         10'b0100100010: fwd_o =  40'b1001100110011001100110011001100001010001; //  X X X X X X X 8 5 1
         10'b0100100011: fwd_o =  40'b1001100110011001100110011000010100010000; //  X X X X X X 8 5 1 0
         10'b0100100100: fwd_o =  40'b1001100110011001100110011001100001010010; //  X X X X X X X 8 5 2
         10'b0100100101: fwd_o =  40'b1001100110011001100110011000010100100000; //  X X X X X X 8 5 2 0
         10'b0100100110: fwd_o =  40'b1001100110011001100110011000010100100001; //  X X X X X X 8 5 2 1
         10'b0100100111: fwd_o =  40'b1001100110011001100110000101001000010000; //  X X X X X 8 5 2 1 0
         10'b0100101000: fwd_o =  40'b1001100110011001100110011001100001010011; //  X X X X X X X 8 5 3
         10'b0100101001: fwd_o =  40'b1001100110011001100110011000010100110000; //  X X X X X X 8 5 3 0
         10'b0100101010: fwd_o =  40'b1001100110011001100110011000010100110001; //  X X X X X X 8 5 3 1
         10'b0100101011: fwd_o =  40'b1001100110011001100110000101001100010000; //  X X X X X 8 5 3 1 0
         10'b0100101100: fwd_o =  40'b1001100110011001100110011000010100110010; //  X X X X X X 8 5 3 2
         10'b0100101101: fwd_o =  40'b1001100110011001100110000101001100100000; //  X X X X X 8 5 3 2 0
         10'b0100101110: fwd_o =  40'b1001100110011001100110000101001100100001; //  X X X X X 8 5 3 2 1
         10'b0100101111: fwd_o =  40'b1001100110011001100001010011001000010000; //  X X X X 8 5 3 2 1 0
         10'b0100110000: fwd_o =  40'b1001100110011001100110011001100001010100; //  X X X X X X X 8 5 4
         10'b0100110001: fwd_o =  40'b1001100110011001100110011000010101000000; //  X X X X X X 8 5 4 0
         10'b0100110010: fwd_o =  40'b1001100110011001100110011000010101000001; //  X X X X X X 8 5 4 1
         10'b0100110011: fwd_o =  40'b1001100110011001100110000101010000010000; //  X X X X X 8 5 4 1 0
         10'b0100110100: fwd_o =  40'b1001100110011001100110011000010101000010; //  X X X X X X 8 5 4 2
         10'b0100110101: fwd_o =  40'b1001100110011001100110000101010000100000; //  X X X X X 8 5 4 2 0
         10'b0100110110: fwd_o =  40'b1001100110011001100110000101010000100001; //  X X X X X 8 5 4 2 1
         10'b0100110111: fwd_o =  40'b1001100110011001100001010100001000010000; //  X X X X 8 5 4 2 1 0
         10'b0100111000: fwd_o =  40'b1001100110011001100110011000010101000011; //  X X X X X X 8 5 4 3
         10'b0100111001: fwd_o =  40'b1001100110011001100110000101010000110000; //  X X X X X 8 5 4 3 0
         10'b0100111010: fwd_o =  40'b1001100110011001100110000101010000110001; //  X X X X X 8 5 4 3 1
         10'b0100111011: fwd_o =  40'b1001100110011001100001010100001100010000; //  X X X X 8 5 4 3 1 0
         10'b0100111100: fwd_o =  40'b1001100110011001100110000101010000110010; //  X X X X X 8 5 4 3 2
         10'b0100111101: fwd_o =  40'b1001100110011001100001010100001100100000; //  X X X X 8 5 4 3 2 0
         10'b0100111110: fwd_o =  40'b1001100110011001100001010100001100100001; //  X X X X 8 5 4 3 2 1
         10'b0100111111: fwd_o =  40'b1001100110011000010101000011001000010000; //  X X X 8 5 4 3 2 1 0
         10'b0101000000: fwd_o =  40'b1001100110011001100110011001100110000110; //  X X X X X X X X 8 6
         10'b0101000001: fwd_o =  40'b1001100110011001100110011001100001100000; //  X X X X X X X 8 6 0
         10'b0101000010: fwd_o =  40'b1001100110011001100110011001100001100001; //  X X X X X X X 8 6 1
         10'b0101000011: fwd_o =  40'b1001100110011001100110011000011000010000; //  X X X X X X 8 6 1 0
         10'b0101000100: fwd_o =  40'b1001100110011001100110011001100001100010; //  X X X X X X X 8 6 2
         10'b0101000101: fwd_o =  40'b1001100110011001100110011000011000100000; //  X X X X X X 8 6 2 0
         10'b0101000110: fwd_o =  40'b1001100110011001100110011000011000100001; //  X X X X X X 8 6 2 1
         10'b0101000111: fwd_o =  40'b1001100110011001100110000110001000010000; //  X X X X X 8 6 2 1 0
         10'b0101001000: fwd_o =  40'b1001100110011001100110011001100001100011; //  X X X X X X X 8 6 3
         10'b0101001001: fwd_o =  40'b1001100110011001100110011000011000110000; //  X X X X X X 8 6 3 0
         10'b0101001010: fwd_o =  40'b1001100110011001100110011000011000110001; //  X X X X X X 8 6 3 1
         10'b0101001011: fwd_o =  40'b1001100110011001100110000110001100010000; //  X X X X X 8 6 3 1 0
         10'b0101001100: fwd_o =  40'b1001100110011001100110011000011000110010; //  X X X X X X 8 6 3 2
         10'b0101001101: fwd_o =  40'b1001100110011001100110000110001100100000; //  X X X X X 8 6 3 2 0
         10'b0101001110: fwd_o =  40'b1001100110011001100110000110001100100001; //  X X X X X 8 6 3 2 1
         10'b0101001111: fwd_o =  40'b1001100110011001100001100011001000010000; //  X X X X 8 6 3 2 1 0
         10'b0101010000: fwd_o =  40'b1001100110011001100110011001100001100100; //  X X X X X X X 8 6 4
         10'b0101010001: fwd_o =  40'b1001100110011001100110011000011001000000; //  X X X X X X 8 6 4 0
         10'b0101010010: fwd_o =  40'b1001100110011001100110011000011001000001; //  X X X X X X 8 6 4 1
         10'b0101010011: fwd_o =  40'b1001100110011001100110000110010000010000; //  X X X X X 8 6 4 1 0
         10'b0101010100: fwd_o =  40'b1001100110011001100110011000011001000010; //  X X X X X X 8 6 4 2
         10'b0101010101: fwd_o =  40'b1001100110011001100110000110010000100000; //  X X X X X 8 6 4 2 0
         10'b0101010110: fwd_o =  40'b1001100110011001100110000110010000100001; //  X X X X X 8 6 4 2 1
         10'b0101010111: fwd_o =  40'b1001100110011001100001100100001000010000; //  X X X X 8 6 4 2 1 0
         10'b0101011000: fwd_o =  40'b1001100110011001100110011000011001000011; //  X X X X X X 8 6 4 3
         10'b0101011001: fwd_o =  40'b1001100110011001100110000110010000110000; //  X X X X X 8 6 4 3 0
         10'b0101011010: fwd_o =  40'b1001100110011001100110000110010000110001; //  X X X X X 8 6 4 3 1
         10'b0101011011: fwd_o =  40'b1001100110011001100001100100001100010000; //  X X X X 8 6 4 3 1 0
         10'b0101011100: fwd_o =  40'b1001100110011001100110000110010000110010; //  X X X X X 8 6 4 3 2
         10'b0101011101: fwd_o =  40'b1001100110011001100001100100001100100000; //  X X X X 8 6 4 3 2 0
         10'b0101011110: fwd_o =  40'b1001100110011001100001100100001100100001; //  X X X X 8 6 4 3 2 1
         10'b0101011111: fwd_o =  40'b1001100110011000011001000011001000010000; //  X X X 8 6 4 3 2 1 0
         10'b0101100000: fwd_o =  40'b1001100110011001100110011001100001100101; //  X X X X X X X 8 6 5
         10'b0101100001: fwd_o =  40'b1001100110011001100110011000011001010000; //  X X X X X X 8 6 5 0
         10'b0101100010: fwd_o =  40'b1001100110011001100110011000011001010001; //  X X X X X X 8 6 5 1
         10'b0101100011: fwd_o =  40'b1001100110011001100110000110010100010000; //  X X X X X 8 6 5 1 0
         10'b0101100100: fwd_o =  40'b1001100110011001100110011000011001010010; //  X X X X X X 8 6 5 2
         10'b0101100101: fwd_o =  40'b1001100110011001100110000110010100100000; //  X X X X X 8 6 5 2 0
         10'b0101100110: fwd_o =  40'b1001100110011001100110000110010100100001; //  X X X X X 8 6 5 2 1
         10'b0101100111: fwd_o =  40'b1001100110011001100001100101001000010000; //  X X X X 8 6 5 2 1 0
         10'b0101101000: fwd_o =  40'b1001100110011001100110011000011001010011; //  X X X X X X 8 6 5 3
         10'b0101101001: fwd_o =  40'b1001100110011001100110000110010100110000; //  X X X X X 8 6 5 3 0
         10'b0101101010: fwd_o =  40'b1001100110011001100110000110010100110001; //  X X X X X 8 6 5 3 1
         10'b0101101011: fwd_o =  40'b1001100110011001100001100101001100010000; //  X X X X 8 6 5 3 1 0
         10'b0101101100: fwd_o =  40'b1001100110011001100110000110010100110010; //  X X X X X 8 6 5 3 2
         10'b0101101101: fwd_o =  40'b1001100110011001100001100101001100100000; //  X X X X 8 6 5 3 2 0
         10'b0101101110: fwd_o =  40'b1001100110011001100001100101001100100001; //  X X X X 8 6 5 3 2 1
         10'b0101101111: fwd_o =  40'b1001100110011000011001010011001000010000; //  X X X 8 6 5 3 2 1 0
         10'b0101110000: fwd_o =  40'b1001100110011001100110011000011001010100; //  X X X X X X 8 6 5 4
         10'b0101110001: fwd_o =  40'b1001100110011001100110000110010101000000; //  X X X X X 8 6 5 4 0
         10'b0101110010: fwd_o =  40'b1001100110011001100110000110010101000001; //  X X X X X 8 6 5 4 1
         10'b0101110011: fwd_o =  40'b1001100110011001100001100101010000010000; //  X X X X 8 6 5 4 1 0
         10'b0101110100: fwd_o =  40'b1001100110011001100110000110010101000010; //  X X X X X 8 6 5 4 2
         10'b0101110101: fwd_o =  40'b1001100110011001100001100101010000100000; //  X X X X 8 6 5 4 2 0
         10'b0101110110: fwd_o =  40'b1001100110011001100001100101010000100001; //  X X X X 8 6 5 4 2 1
         10'b0101110111: fwd_o =  40'b1001100110011000011001010100001000010000; //  X X X 8 6 5 4 2 1 0
         10'b0101111000: fwd_o =  40'b1001100110011001100110000110010101000011; //  X X X X X 8 6 5 4 3
         10'b0101111001: fwd_o =  40'b1001100110011001100001100101010000110000; //  X X X X 8 6 5 4 3 0
         10'b0101111010: fwd_o =  40'b1001100110011001100001100101010000110001; //  X X X X 8 6 5 4 3 1
         10'b0101111011: fwd_o =  40'b1001100110011000011001010100001100010000; //  X X X 8 6 5 4 3 1 0
         10'b0101111100: fwd_o =  40'b1001100110011001100001100101010000110010; //  X X X X 8 6 5 4 3 2
         10'b0101111101: fwd_o =  40'b1001100110011000011001010100001100100000; //  X X X 8 6 5 4 3 2 0
         10'b0101111110: fwd_o =  40'b1001100110011000011001010100001100100001; //  X X X 8 6 5 4 3 2 1
         10'b0101111111: fwd_o =  40'b1001100110000110010101000011001000010000; //  X X 8 6 5 4 3 2 1 0
         10'b0110000000: fwd_o =  40'b1001100110011001100110011001100110000111; //  X X X X X X X X 8 7
         10'b0110000001: fwd_o =  40'b1001100110011001100110011001100001110000; //  X X X X X X X 8 7 0
         10'b0110000010: fwd_o =  40'b1001100110011001100110011001100001110001; //  X X X X X X X 8 7 1
         10'b0110000011: fwd_o =  40'b1001100110011001100110011000011100010000; //  X X X X X X 8 7 1 0
         10'b0110000100: fwd_o =  40'b1001100110011001100110011001100001110010; //  X X X X X X X 8 7 2
         10'b0110000101: fwd_o =  40'b1001100110011001100110011000011100100000; //  X X X X X X 8 7 2 0
         10'b0110000110: fwd_o =  40'b1001100110011001100110011000011100100001; //  X X X X X X 8 7 2 1
         10'b0110000111: fwd_o =  40'b1001100110011001100110000111001000010000; //  X X X X X 8 7 2 1 0
         10'b0110001000: fwd_o =  40'b1001100110011001100110011001100001110011; //  X X X X X X X 8 7 3
         10'b0110001001: fwd_o =  40'b1001100110011001100110011000011100110000; //  X X X X X X 8 7 3 0
         10'b0110001010: fwd_o =  40'b1001100110011001100110011000011100110001; //  X X X X X X 8 7 3 1
         10'b0110001011: fwd_o =  40'b1001100110011001100110000111001100010000; //  X X X X X 8 7 3 1 0
         10'b0110001100: fwd_o =  40'b1001100110011001100110011000011100110010; //  X X X X X X 8 7 3 2
         10'b0110001101: fwd_o =  40'b1001100110011001100110000111001100100000; //  X X X X X 8 7 3 2 0
         10'b0110001110: fwd_o =  40'b1001100110011001100110000111001100100001; //  X X X X X 8 7 3 2 1
         10'b0110001111: fwd_o =  40'b1001100110011001100001110011001000010000; //  X X X X 8 7 3 2 1 0
         10'b0110010000: fwd_o =  40'b1001100110011001100110011001100001110100; //  X X X X X X X 8 7 4
         10'b0110010001: fwd_o =  40'b1001100110011001100110011000011101000000; //  X X X X X X 8 7 4 0
         10'b0110010010: fwd_o =  40'b1001100110011001100110011000011101000001; //  X X X X X X 8 7 4 1
         10'b0110010011: fwd_o =  40'b1001100110011001100110000111010000010000; //  X X X X X 8 7 4 1 0
         10'b0110010100: fwd_o =  40'b1001100110011001100110011000011101000010; //  X X X X X X 8 7 4 2
         10'b0110010101: fwd_o =  40'b1001100110011001100110000111010000100000; //  X X X X X 8 7 4 2 0
         10'b0110010110: fwd_o =  40'b1001100110011001100110000111010000100001; //  X X X X X 8 7 4 2 1
         10'b0110010111: fwd_o =  40'b1001100110011001100001110100001000010000; //  X X X X 8 7 4 2 1 0
         10'b0110011000: fwd_o =  40'b1001100110011001100110011000011101000011; //  X X X X X X 8 7 4 3
         10'b0110011001: fwd_o =  40'b1001100110011001100110000111010000110000; //  X X X X X 8 7 4 3 0
         10'b0110011010: fwd_o =  40'b1001100110011001100110000111010000110001; //  X X X X X 8 7 4 3 1
         10'b0110011011: fwd_o =  40'b1001100110011001100001110100001100010000; //  X X X X 8 7 4 3 1 0
         10'b0110011100: fwd_o =  40'b1001100110011001100110000111010000110010; //  X X X X X 8 7 4 3 2
         10'b0110011101: fwd_o =  40'b1001100110011001100001110100001100100000; //  X X X X 8 7 4 3 2 0
         10'b0110011110: fwd_o =  40'b1001100110011001100001110100001100100001; //  X X X X 8 7 4 3 2 1
         10'b0110011111: fwd_o =  40'b1001100110011000011101000011001000010000; //  X X X 8 7 4 3 2 1 0
         10'b0110100000: fwd_o =  40'b1001100110011001100110011001100001110101; //  X X X X X X X 8 7 5
         10'b0110100001: fwd_o =  40'b1001100110011001100110011000011101010000; //  X X X X X X 8 7 5 0
         10'b0110100010: fwd_o =  40'b1001100110011001100110011000011101010001; //  X X X X X X 8 7 5 1
         10'b0110100011: fwd_o =  40'b1001100110011001100110000111010100010000; //  X X X X X 8 7 5 1 0
         10'b0110100100: fwd_o =  40'b1001100110011001100110011000011101010010; //  X X X X X X 8 7 5 2
         10'b0110100101: fwd_o =  40'b1001100110011001100110000111010100100000; //  X X X X X 8 7 5 2 0
         10'b0110100110: fwd_o =  40'b1001100110011001100110000111010100100001; //  X X X X X 8 7 5 2 1
         10'b0110100111: fwd_o =  40'b1001100110011001100001110101001000010000; //  X X X X 8 7 5 2 1 0
         10'b0110101000: fwd_o =  40'b1001100110011001100110011000011101010011; //  X X X X X X 8 7 5 3
         10'b0110101001: fwd_o =  40'b1001100110011001100110000111010100110000; //  X X X X X 8 7 5 3 0
         10'b0110101010: fwd_o =  40'b1001100110011001100110000111010100110001; //  X X X X X 8 7 5 3 1
         10'b0110101011: fwd_o =  40'b1001100110011001100001110101001100010000; //  X X X X 8 7 5 3 1 0
         10'b0110101100: fwd_o =  40'b1001100110011001100110000111010100110010; //  X X X X X 8 7 5 3 2
         10'b0110101101: fwd_o =  40'b1001100110011001100001110101001100100000; //  X X X X 8 7 5 3 2 0
         10'b0110101110: fwd_o =  40'b1001100110011001100001110101001100100001; //  X X X X 8 7 5 3 2 1
         10'b0110101111: fwd_o =  40'b1001100110011000011101010011001000010000; //  X X X 8 7 5 3 2 1 0
         10'b0110110000: fwd_o =  40'b1001100110011001100110011000011101010100; //  X X X X X X 8 7 5 4
         10'b0110110001: fwd_o =  40'b1001100110011001100110000111010101000000; //  X X X X X 8 7 5 4 0
         10'b0110110010: fwd_o =  40'b1001100110011001100110000111010101000001; //  X X X X X 8 7 5 4 1
         10'b0110110011: fwd_o =  40'b1001100110011001100001110101010000010000; //  X X X X 8 7 5 4 1 0
         10'b0110110100: fwd_o =  40'b1001100110011001100110000111010101000010; //  X X X X X 8 7 5 4 2
         10'b0110110101: fwd_o =  40'b1001100110011001100001110101010000100000; //  X X X X 8 7 5 4 2 0
         10'b0110110110: fwd_o =  40'b1001100110011001100001110101010000100001; //  X X X X 8 7 5 4 2 1
         10'b0110110111: fwd_o =  40'b1001100110011000011101010100001000010000; //  X X X 8 7 5 4 2 1 0
         10'b0110111000: fwd_o =  40'b1001100110011001100110000111010101000011; //  X X X X X 8 7 5 4 3
         10'b0110111001: fwd_o =  40'b1001100110011001100001110101010000110000; //  X X X X 8 7 5 4 3 0
         10'b0110111010: fwd_o =  40'b1001100110011001100001110101010000110001; //  X X X X 8 7 5 4 3 1
         10'b0110111011: fwd_o =  40'b1001100110011000011101010100001100010000; //  X X X 8 7 5 4 3 1 0
         10'b0110111100: fwd_o =  40'b1001100110011001100001110101010000110010; //  X X X X 8 7 5 4 3 2
         10'b0110111101: fwd_o =  40'b1001100110011000011101010100001100100000; //  X X X 8 7 5 4 3 2 0
         10'b0110111110: fwd_o =  40'b1001100110011000011101010100001100100001; //  X X X 8 7 5 4 3 2 1
         10'b0110111111: fwd_o =  40'b1001100110000111010101000011001000010000; //  X X 8 7 5 4 3 2 1 0
         10'b0111000000: fwd_o =  40'b1001100110011001100110011001100001110110; //  X X X X X X X 8 7 6
         10'b0111000001: fwd_o =  40'b1001100110011001100110011000011101100000; //  X X X X X X 8 7 6 0
         10'b0111000010: fwd_o =  40'b1001100110011001100110011000011101100001; //  X X X X X X 8 7 6 1
         10'b0111000011: fwd_o =  40'b1001100110011001100110000111011000010000; //  X X X X X 8 7 6 1 0
         10'b0111000100: fwd_o =  40'b1001100110011001100110011000011101100010; //  X X X X X X 8 7 6 2
         10'b0111000101: fwd_o =  40'b1001100110011001100110000111011000100000; //  X X X X X 8 7 6 2 0
         10'b0111000110: fwd_o =  40'b1001100110011001100110000111011000100001; //  X X X X X 8 7 6 2 1
         10'b0111000111: fwd_o =  40'b1001100110011001100001110110001000010000; //  X X X X 8 7 6 2 1 0
         10'b0111001000: fwd_o =  40'b1001100110011001100110011000011101100011; //  X X X X X X 8 7 6 3
         10'b0111001001: fwd_o =  40'b1001100110011001100110000111011000110000; //  X X X X X 8 7 6 3 0
         10'b0111001010: fwd_o =  40'b1001100110011001100110000111011000110001; //  X X X X X 8 7 6 3 1
         10'b0111001011: fwd_o =  40'b1001100110011001100001110110001100010000; //  X X X X 8 7 6 3 1 0
         10'b0111001100: fwd_o =  40'b1001100110011001100110000111011000110010; //  X X X X X 8 7 6 3 2
         10'b0111001101: fwd_o =  40'b1001100110011001100001110110001100100000; //  X X X X 8 7 6 3 2 0
         10'b0111001110: fwd_o =  40'b1001100110011001100001110110001100100001; //  X X X X 8 7 6 3 2 1
         10'b0111001111: fwd_o =  40'b1001100110011000011101100011001000010000; //  X X X 8 7 6 3 2 1 0
         10'b0111010000: fwd_o =  40'b1001100110011001100110011000011101100100; //  X X X X X X 8 7 6 4
         10'b0111010001: fwd_o =  40'b1001100110011001100110000111011001000000; //  X X X X X 8 7 6 4 0
         10'b0111010010: fwd_o =  40'b1001100110011001100110000111011001000001; //  X X X X X 8 7 6 4 1
         10'b0111010011: fwd_o =  40'b1001100110011001100001110110010000010000; //  X X X X 8 7 6 4 1 0
         10'b0111010100: fwd_o =  40'b1001100110011001100110000111011001000010; //  X X X X X 8 7 6 4 2
         10'b0111010101: fwd_o =  40'b1001100110011001100001110110010000100000; //  X X X X 8 7 6 4 2 0
         10'b0111010110: fwd_o =  40'b1001100110011001100001110110010000100001; //  X X X X 8 7 6 4 2 1
         10'b0111010111: fwd_o =  40'b1001100110011000011101100100001000010000; //  X X X 8 7 6 4 2 1 0
         10'b0111011000: fwd_o =  40'b1001100110011001100110000111011001000011; //  X X X X X 8 7 6 4 3
         10'b0111011001: fwd_o =  40'b1001100110011001100001110110010000110000; //  X X X X 8 7 6 4 3 0
         10'b0111011010: fwd_o =  40'b1001100110011001100001110110010000110001; //  X X X X 8 7 6 4 3 1
         10'b0111011011: fwd_o =  40'b1001100110011000011101100100001100010000; //  X X X 8 7 6 4 3 1 0
         10'b0111011100: fwd_o =  40'b1001100110011001100001110110010000110010; //  X X X X 8 7 6 4 3 2
         10'b0111011101: fwd_o =  40'b1001100110011000011101100100001100100000; //  X X X 8 7 6 4 3 2 0
         10'b0111011110: fwd_o =  40'b1001100110011000011101100100001100100001; //  X X X 8 7 6 4 3 2 1
         10'b0111011111: fwd_o =  40'b1001100110000111011001000011001000010000; //  X X 8 7 6 4 3 2 1 0
         10'b0111100000: fwd_o =  40'b1001100110011001100110011000011101100101; //  X X X X X X 8 7 6 5
         10'b0111100001: fwd_o =  40'b1001100110011001100110000111011001010000; //  X X X X X 8 7 6 5 0
         10'b0111100010: fwd_o =  40'b1001100110011001100110000111011001010001; //  X X X X X 8 7 6 5 1
         10'b0111100011: fwd_o =  40'b1001100110011001100001110110010100010000; //  X X X X 8 7 6 5 1 0
         10'b0111100100: fwd_o =  40'b1001100110011001100110000111011001010010; //  X X X X X 8 7 6 5 2
         10'b0111100101: fwd_o =  40'b1001100110011001100001110110010100100000; //  X X X X 8 7 6 5 2 0
         10'b0111100110: fwd_o =  40'b1001100110011001100001110110010100100001; //  X X X X 8 7 6 5 2 1
         10'b0111100111: fwd_o =  40'b1001100110011000011101100101001000010000; //  X X X 8 7 6 5 2 1 0
         10'b0111101000: fwd_o =  40'b1001100110011001100110000111011001010011; //  X X X X X 8 7 6 5 3
         10'b0111101001: fwd_o =  40'b1001100110011001100001110110010100110000; //  X X X X 8 7 6 5 3 0
         10'b0111101010: fwd_o =  40'b1001100110011001100001110110010100110001; //  X X X X 8 7 6 5 3 1
         10'b0111101011: fwd_o =  40'b1001100110011000011101100101001100010000; //  X X X 8 7 6 5 3 1 0
         10'b0111101100: fwd_o =  40'b1001100110011001100001110110010100110010; //  X X X X 8 7 6 5 3 2
         10'b0111101101: fwd_o =  40'b1001100110011000011101100101001100100000; //  X X X 8 7 6 5 3 2 0
         10'b0111101110: fwd_o =  40'b1001100110011000011101100101001100100001; //  X X X 8 7 6 5 3 2 1
         10'b0111101111: fwd_o =  40'b1001100110000111011001010011001000010000; //  X X 8 7 6 5 3 2 1 0
         10'b0111110000: fwd_o =  40'b1001100110011001100110000111011001010100; //  X X X X X 8 7 6 5 4
         10'b0111110001: fwd_o =  40'b1001100110011001100001110110010101000000; //  X X X X 8 7 6 5 4 0
         10'b0111110010: fwd_o =  40'b1001100110011001100001110110010101000001; //  X X X X 8 7 6 5 4 1
         10'b0111110011: fwd_o =  40'b1001100110011000011101100101010000010000; //  X X X 8 7 6 5 4 1 0
         10'b0111110100: fwd_o =  40'b1001100110011001100001110110010101000010; //  X X X X 8 7 6 5 4 2
         10'b0111110101: fwd_o =  40'b1001100110011000011101100101010000100000; //  X X X 8 7 6 5 4 2 0
         10'b0111110110: fwd_o =  40'b1001100110011000011101100101010000100001; //  X X X 8 7 6 5 4 2 1
         10'b0111110111: fwd_o =  40'b1001100110000111011001010100001000010000; //  X X 8 7 6 5 4 2 1 0
         10'b0111111000: fwd_o =  40'b1001100110011001100001110110010101000011; //  X X X X 8 7 6 5 4 3
         10'b0111111001: fwd_o =  40'b1001100110011000011101100101010000110000; //  X X X 8 7 6 5 4 3 0
         10'b0111111010: fwd_o =  40'b1001100110011000011101100101010000110001; //  X X X 8 7 6 5 4 3 1
         10'b0111111011: fwd_o =  40'b1001100110000111011001010100001100010000; //  X X 8 7 6 5 4 3 1 0
         10'b0111111100: fwd_o =  40'b1001100110011000011101100101010000110010; //  X X X 8 7 6 5 4 3 2
         10'b0111111101: fwd_o =  40'b1001100110000111011001010100001100100000; //  X X 8 7 6 5 4 3 2 0
         10'b0111111110: fwd_o =  40'b1001100110000111011001010100001100100001; //  X X 8 7 6 5 4 3 2 1
         10'b0111111111: fwd_o =  40'b1001100001110110010101000011001000010000; //  X 8 7 6 5 4 3 2 1 0
         10'b1000000000: fwd_o =  40'b1000100010001000100010001000100010001001; //  X X X X X X X X X 9
         10'b1000000001: fwd_o =  40'b1000100010001000100010001000100010010000; //  X X X X X X X X 9 0
         10'b1000000010: fwd_o =  40'b1000100010001000100010001000100010010001; //  X X X X X X X X 9 1
         10'b1000000011: fwd_o =  40'b1000100010001000100010001000100100010000; //  X X X X X X X 9 1 0
         10'b1000000100: fwd_o =  40'b1000100010001000100010001000100010010010; //  X X X X X X X X 9 2
         10'b1000000101: fwd_o =  40'b1000100010001000100010001000100100100000; //  X X X X X X X 9 2 0
         10'b1000000110: fwd_o =  40'b1000100010001000100010001000100100100001; //  X X X X X X X 9 2 1
         10'b1000000111: fwd_o =  40'b1000100010001000100010001001001000010000; //  X X X X X X 9 2 1 0
         10'b1000001000: fwd_o =  40'b1000100010001000100010001000100010010011; //  X X X X X X X X 9 3
         10'b1000001001: fwd_o =  40'b1000100010001000100010001000100100110000; //  X X X X X X X 9 3 0
         10'b1000001010: fwd_o =  40'b1000100010001000100010001000100100110001; //  X X X X X X X 9 3 1
         10'b1000001011: fwd_o =  40'b1000100010001000100010001001001100010000; //  X X X X X X 9 3 1 0
         10'b1000001100: fwd_o =  40'b1000100010001000100010001000100100110010; //  X X X X X X X 9 3 2
         10'b1000001101: fwd_o =  40'b1000100010001000100010001001001100100000; //  X X X X X X 9 3 2 0
         10'b1000001110: fwd_o =  40'b1000100010001000100010001001001100100001; //  X X X X X X 9 3 2 1
         10'b1000001111: fwd_o =  40'b1000100010001000100010010011001000010000; //  X X X X X 9 3 2 1 0
         10'b1000010000: fwd_o =  40'b1000100010001000100010001000100010010100; //  X X X X X X X X 9 4
         10'b1000010001: fwd_o =  40'b1000100010001000100010001000100101000000; //  X X X X X X X 9 4 0
         10'b1000010010: fwd_o =  40'b1000100010001000100010001000100101000001; //  X X X X X X X 9 4 1
         10'b1000010011: fwd_o =  40'b1000100010001000100010001001010000010000; //  X X X X X X 9 4 1 0
         10'b1000010100: fwd_o =  40'b1000100010001000100010001000100101000010; //  X X X X X X X 9 4 2
         10'b1000010101: fwd_o =  40'b1000100010001000100010001001010000100000; //  X X X X X X 9 4 2 0
         10'b1000010110: fwd_o =  40'b1000100010001000100010001001010000100001; //  X X X X X X 9 4 2 1
         10'b1000010111: fwd_o =  40'b1000100010001000100010010100001000010000; //  X X X X X 9 4 2 1 0
         10'b1000011000: fwd_o =  40'b1000100010001000100010001000100101000011; //  X X X X X X X 9 4 3
         10'b1000011001: fwd_o =  40'b1000100010001000100010001001010000110000; //  X X X X X X 9 4 3 0
         10'b1000011010: fwd_o =  40'b1000100010001000100010001001010000110001; //  X X X X X X 9 4 3 1
         10'b1000011011: fwd_o =  40'b1000100010001000100010010100001100010000; //  X X X X X 9 4 3 1 0
         10'b1000011100: fwd_o =  40'b1000100010001000100010001001010000110010; //  X X X X X X 9 4 3 2
         10'b1000011101: fwd_o =  40'b1000100010001000100010010100001100100000; //  X X X X X 9 4 3 2 0
         10'b1000011110: fwd_o =  40'b1000100010001000100010010100001100100001; //  X X X X X 9 4 3 2 1
         10'b1000011111: fwd_o =  40'b1000100010001000100101000011001000010000; //  X X X X 9 4 3 2 1 0
         10'b1000100000: fwd_o =  40'b1000100010001000100010001000100010010101; //  X X X X X X X X 9 5
         10'b1000100001: fwd_o =  40'b1000100010001000100010001000100101010000; //  X X X X X X X 9 5 0
         10'b1000100010: fwd_o =  40'b1000100010001000100010001000100101010001; //  X X X X X X X 9 5 1
         10'b1000100011: fwd_o =  40'b1000100010001000100010001001010100010000; //  X X X X X X 9 5 1 0
         10'b1000100100: fwd_o =  40'b1000100010001000100010001000100101010010; //  X X X X X X X 9 5 2
         10'b1000100101: fwd_o =  40'b1000100010001000100010001001010100100000; //  X X X X X X 9 5 2 0
         10'b1000100110: fwd_o =  40'b1000100010001000100010001001010100100001; //  X X X X X X 9 5 2 1
         10'b1000100111: fwd_o =  40'b1000100010001000100010010101001000010000; //  X X X X X 9 5 2 1 0
         10'b1000101000: fwd_o =  40'b1000100010001000100010001000100101010011; //  X X X X X X X 9 5 3
         10'b1000101001: fwd_o =  40'b1000100010001000100010001001010100110000; //  X X X X X X 9 5 3 0
         10'b1000101010: fwd_o =  40'b1000100010001000100010001001010100110001; //  X X X X X X 9 5 3 1
         10'b1000101011: fwd_o =  40'b1000100010001000100010010101001100010000; //  X X X X X 9 5 3 1 0
         10'b1000101100: fwd_o =  40'b1000100010001000100010001001010100110010; //  X X X X X X 9 5 3 2
         10'b1000101101: fwd_o =  40'b1000100010001000100010010101001100100000; //  X X X X X 9 5 3 2 0
         10'b1000101110: fwd_o =  40'b1000100010001000100010010101001100100001; //  X X X X X 9 5 3 2 1
         10'b1000101111: fwd_o =  40'b1000100010001000100101010011001000010000; //  X X X X 9 5 3 2 1 0
         10'b1000110000: fwd_o =  40'b1000100010001000100010001000100101010100; //  X X X X X X X 9 5 4
         10'b1000110001: fwd_o =  40'b1000100010001000100010001001010101000000; //  X X X X X X 9 5 4 0
         10'b1000110010: fwd_o =  40'b1000100010001000100010001001010101000001; //  X X X X X X 9 5 4 1
         10'b1000110011: fwd_o =  40'b1000100010001000100010010101010000010000; //  X X X X X 9 5 4 1 0
         10'b1000110100: fwd_o =  40'b1000100010001000100010001001010101000010; //  X X X X X X 9 5 4 2
         10'b1000110101: fwd_o =  40'b1000100010001000100010010101010000100000; //  X X X X X 9 5 4 2 0
         10'b1000110110: fwd_o =  40'b1000100010001000100010010101010000100001; //  X X X X X 9 5 4 2 1
         10'b1000110111: fwd_o =  40'b1000100010001000100101010100001000010000; //  X X X X 9 5 4 2 1 0
         10'b1000111000: fwd_o =  40'b1000100010001000100010001001010101000011; //  X X X X X X 9 5 4 3
         10'b1000111001: fwd_o =  40'b1000100010001000100010010101010000110000; //  X X X X X 9 5 4 3 0
         10'b1000111010: fwd_o =  40'b1000100010001000100010010101010000110001; //  X X X X X 9 5 4 3 1
         10'b1000111011: fwd_o =  40'b1000100010001000100101010100001100010000; //  X X X X 9 5 4 3 1 0
         10'b1000111100: fwd_o =  40'b1000100010001000100010010101010000110010; //  X X X X X 9 5 4 3 2
         10'b1000111101: fwd_o =  40'b1000100010001000100101010100001100100000; //  X X X X 9 5 4 3 2 0
         10'b1000111110: fwd_o =  40'b1000100010001000100101010100001100100001; //  X X X X 9 5 4 3 2 1
         10'b1000111111: fwd_o =  40'b1000100010001001010101000011001000010000; //  X X X 9 5 4 3 2 1 0
         10'b1001000000: fwd_o =  40'b1000100010001000100010001000100010010110; //  X X X X X X X X 9 6
         10'b1001000001: fwd_o =  40'b1000100010001000100010001000100101100000; //  X X X X X X X 9 6 0
         10'b1001000010: fwd_o =  40'b1000100010001000100010001000100101100001; //  X X X X X X X 9 6 1
         10'b1001000011: fwd_o =  40'b1000100010001000100010001001011000010000; //  X X X X X X 9 6 1 0
         10'b1001000100: fwd_o =  40'b1000100010001000100010001000100101100010; //  X X X X X X X 9 6 2
         10'b1001000101: fwd_o =  40'b1000100010001000100010001001011000100000; //  X X X X X X 9 6 2 0
         10'b1001000110: fwd_o =  40'b1000100010001000100010001001011000100001; //  X X X X X X 9 6 2 1
         10'b1001000111: fwd_o =  40'b1000100010001000100010010110001000010000; //  X X X X X 9 6 2 1 0
         10'b1001001000: fwd_o =  40'b1000100010001000100010001000100101100011; //  X X X X X X X 9 6 3
         10'b1001001001: fwd_o =  40'b1000100010001000100010001001011000110000; //  X X X X X X 9 6 3 0
         10'b1001001010: fwd_o =  40'b1000100010001000100010001001011000110001; //  X X X X X X 9 6 3 1
         10'b1001001011: fwd_o =  40'b1000100010001000100010010110001100010000; //  X X X X X 9 6 3 1 0
         10'b1001001100: fwd_o =  40'b1000100010001000100010001001011000110010; //  X X X X X X 9 6 3 2
         10'b1001001101: fwd_o =  40'b1000100010001000100010010110001100100000; //  X X X X X 9 6 3 2 0
         10'b1001001110: fwd_o =  40'b1000100010001000100010010110001100100001; //  X X X X X 9 6 3 2 1
         10'b1001001111: fwd_o =  40'b1000100010001000100101100011001000010000; //  X X X X 9 6 3 2 1 0
         10'b1001010000: fwd_o =  40'b1000100010001000100010001000100101100100; //  X X X X X X X 9 6 4
         10'b1001010001: fwd_o =  40'b1000100010001000100010001001011001000000; //  X X X X X X 9 6 4 0
         10'b1001010010: fwd_o =  40'b1000100010001000100010001001011001000001; //  X X X X X X 9 6 4 1
         10'b1001010011: fwd_o =  40'b1000100010001000100010010110010000010000; //  X X X X X 9 6 4 1 0
         10'b1001010100: fwd_o =  40'b1000100010001000100010001001011001000010; //  X X X X X X 9 6 4 2
         10'b1001010101: fwd_o =  40'b1000100010001000100010010110010000100000; //  X X X X X 9 6 4 2 0
         10'b1001010110: fwd_o =  40'b1000100010001000100010010110010000100001; //  X X X X X 9 6 4 2 1
         10'b1001010111: fwd_o =  40'b1000100010001000100101100100001000010000; //  X X X X 9 6 4 2 1 0
         10'b1001011000: fwd_o =  40'b1000100010001000100010001001011001000011; //  X X X X X X 9 6 4 3
         10'b1001011001: fwd_o =  40'b1000100010001000100010010110010000110000; //  X X X X X 9 6 4 3 0
         10'b1001011010: fwd_o =  40'b1000100010001000100010010110010000110001; //  X X X X X 9 6 4 3 1
         10'b1001011011: fwd_o =  40'b1000100010001000100101100100001100010000; //  X X X X 9 6 4 3 1 0
         10'b1001011100: fwd_o =  40'b1000100010001000100010010110010000110010; //  X X X X X 9 6 4 3 2
         10'b1001011101: fwd_o =  40'b1000100010001000100101100100001100100000; //  X X X X 9 6 4 3 2 0
         10'b1001011110: fwd_o =  40'b1000100010001000100101100100001100100001; //  X X X X 9 6 4 3 2 1
         10'b1001011111: fwd_o =  40'b1000100010001001011001000011001000010000; //  X X X 9 6 4 3 2 1 0
         10'b1001100000: fwd_o =  40'b1000100010001000100010001000100101100101; //  X X X X X X X 9 6 5
         10'b1001100001: fwd_o =  40'b1000100010001000100010001001011001010000; //  X X X X X X 9 6 5 0
         10'b1001100010: fwd_o =  40'b1000100010001000100010001001011001010001; //  X X X X X X 9 6 5 1
         10'b1001100011: fwd_o =  40'b1000100010001000100010010110010100010000; //  X X X X X 9 6 5 1 0
         10'b1001100100: fwd_o =  40'b1000100010001000100010001001011001010010; //  X X X X X X 9 6 5 2
         10'b1001100101: fwd_o =  40'b1000100010001000100010010110010100100000; //  X X X X X 9 6 5 2 0
         10'b1001100110: fwd_o =  40'b1000100010001000100010010110010100100001; //  X X X X X 9 6 5 2 1
         10'b1001100111: fwd_o =  40'b1000100010001000100101100101001000010000; //  X X X X 9 6 5 2 1 0
         10'b1001101000: fwd_o =  40'b1000100010001000100010001001011001010011; //  X X X X X X 9 6 5 3
         10'b1001101001: fwd_o =  40'b1000100010001000100010010110010100110000; //  X X X X X 9 6 5 3 0
         10'b1001101010: fwd_o =  40'b1000100010001000100010010110010100110001; //  X X X X X 9 6 5 3 1
         10'b1001101011: fwd_o =  40'b1000100010001000100101100101001100010000; //  X X X X 9 6 5 3 1 0
         10'b1001101100: fwd_o =  40'b1000100010001000100010010110010100110010; //  X X X X X 9 6 5 3 2
         10'b1001101101: fwd_o =  40'b1000100010001000100101100101001100100000; //  X X X X 9 6 5 3 2 0
         10'b1001101110: fwd_o =  40'b1000100010001000100101100101001100100001; //  X X X X 9 6 5 3 2 1
         10'b1001101111: fwd_o =  40'b1000100010001001011001010011001000010000; //  X X X 9 6 5 3 2 1 0
         10'b1001110000: fwd_o =  40'b1000100010001000100010001001011001010100; //  X X X X X X 9 6 5 4
         10'b1001110001: fwd_o =  40'b1000100010001000100010010110010101000000; //  X X X X X 9 6 5 4 0
         10'b1001110010: fwd_o =  40'b1000100010001000100010010110010101000001; //  X X X X X 9 6 5 4 1
         10'b1001110011: fwd_o =  40'b1000100010001000100101100101010000010000; //  X X X X 9 6 5 4 1 0
         10'b1001110100: fwd_o =  40'b1000100010001000100010010110010101000010; //  X X X X X 9 6 5 4 2
         10'b1001110101: fwd_o =  40'b1000100010001000100101100101010000100000; //  X X X X 9 6 5 4 2 0
         10'b1001110110: fwd_o =  40'b1000100010001000100101100101010000100001; //  X X X X 9 6 5 4 2 1
         10'b1001110111: fwd_o =  40'b1000100010001001011001010100001000010000; //  X X X 9 6 5 4 2 1 0
         10'b1001111000: fwd_o =  40'b1000100010001000100010010110010101000011; //  X X X X X 9 6 5 4 3
         10'b1001111001: fwd_o =  40'b1000100010001000100101100101010000110000; //  X X X X 9 6 5 4 3 0
         10'b1001111010: fwd_o =  40'b1000100010001000100101100101010000110001; //  X X X X 9 6 5 4 3 1
         10'b1001111011: fwd_o =  40'b1000100010001001011001010100001100010000; //  X X X 9 6 5 4 3 1 0
         10'b1001111100: fwd_o =  40'b1000100010001000100101100101010000110010; //  X X X X 9 6 5 4 3 2
         10'b1001111101: fwd_o =  40'b1000100010001001011001010100001100100000; //  X X X 9 6 5 4 3 2 0
         10'b1001111110: fwd_o =  40'b1000100010001001011001010100001100100001; //  X X X 9 6 5 4 3 2 1
         10'b1001111111: fwd_o =  40'b1000100010010110010101000011001000010000; //  X X 9 6 5 4 3 2 1 0
         10'b1010000000: fwd_o =  40'b1000100010001000100010001000100010010111; //  X X X X X X X X 9 7
         10'b1010000001: fwd_o =  40'b1000100010001000100010001000100101110000; //  X X X X X X X 9 7 0
         10'b1010000010: fwd_o =  40'b1000100010001000100010001000100101110001; //  X X X X X X X 9 7 1
         10'b1010000011: fwd_o =  40'b1000100010001000100010001001011100010000; //  X X X X X X 9 7 1 0
         10'b1010000100: fwd_o =  40'b1000100010001000100010001000100101110010; //  X X X X X X X 9 7 2
         10'b1010000101: fwd_o =  40'b1000100010001000100010001001011100100000; //  X X X X X X 9 7 2 0
         10'b1010000110: fwd_o =  40'b1000100010001000100010001001011100100001; //  X X X X X X 9 7 2 1
         10'b1010000111: fwd_o =  40'b1000100010001000100010010111001000010000; //  X X X X X 9 7 2 1 0
         10'b1010001000: fwd_o =  40'b1000100010001000100010001000100101110011; //  X X X X X X X 9 7 3
         10'b1010001001: fwd_o =  40'b1000100010001000100010001001011100110000; //  X X X X X X 9 7 3 0
         10'b1010001010: fwd_o =  40'b1000100010001000100010001001011100110001; //  X X X X X X 9 7 3 1
         10'b1010001011: fwd_o =  40'b1000100010001000100010010111001100010000; //  X X X X X 9 7 3 1 0
         10'b1010001100: fwd_o =  40'b1000100010001000100010001001011100110010; //  X X X X X X 9 7 3 2
         10'b1010001101: fwd_o =  40'b1000100010001000100010010111001100100000; //  X X X X X 9 7 3 2 0
         10'b1010001110: fwd_o =  40'b1000100010001000100010010111001100100001; //  X X X X X 9 7 3 2 1
         10'b1010001111: fwd_o =  40'b1000100010001000100101110011001000010000; //  X X X X 9 7 3 2 1 0
         10'b1010010000: fwd_o =  40'b1000100010001000100010001000100101110100; //  X X X X X X X 9 7 4
         10'b1010010001: fwd_o =  40'b1000100010001000100010001001011101000000; //  X X X X X X 9 7 4 0
         10'b1010010010: fwd_o =  40'b1000100010001000100010001001011101000001; //  X X X X X X 9 7 4 1
         10'b1010010011: fwd_o =  40'b1000100010001000100010010111010000010000; //  X X X X X 9 7 4 1 0
         10'b1010010100: fwd_o =  40'b1000100010001000100010001001011101000010; //  X X X X X X 9 7 4 2
         10'b1010010101: fwd_o =  40'b1000100010001000100010010111010000100000; //  X X X X X 9 7 4 2 0
         10'b1010010110: fwd_o =  40'b1000100010001000100010010111010000100001; //  X X X X X 9 7 4 2 1
         10'b1010010111: fwd_o =  40'b1000100010001000100101110100001000010000; //  X X X X 9 7 4 2 1 0
         10'b1010011000: fwd_o =  40'b1000100010001000100010001001011101000011; //  X X X X X X 9 7 4 3
         10'b1010011001: fwd_o =  40'b1000100010001000100010010111010000110000; //  X X X X X 9 7 4 3 0
         10'b1010011010: fwd_o =  40'b1000100010001000100010010111010000110001; //  X X X X X 9 7 4 3 1
         10'b1010011011: fwd_o =  40'b1000100010001000100101110100001100010000; //  X X X X 9 7 4 3 1 0
         10'b1010011100: fwd_o =  40'b1000100010001000100010010111010000110010; //  X X X X X 9 7 4 3 2
         10'b1010011101: fwd_o =  40'b1000100010001000100101110100001100100000; //  X X X X 9 7 4 3 2 0
         10'b1010011110: fwd_o =  40'b1000100010001000100101110100001100100001; //  X X X X 9 7 4 3 2 1
         10'b1010011111: fwd_o =  40'b1000100010001001011101000011001000010000; //  X X X 9 7 4 3 2 1 0
         10'b1010100000: fwd_o =  40'b1000100010001000100010001000100101110101; //  X X X X X X X 9 7 5
         10'b1010100001: fwd_o =  40'b1000100010001000100010001001011101010000; //  X X X X X X 9 7 5 0
         10'b1010100010: fwd_o =  40'b1000100010001000100010001001011101010001; //  X X X X X X 9 7 5 1
         10'b1010100011: fwd_o =  40'b1000100010001000100010010111010100010000; //  X X X X X 9 7 5 1 0
         10'b1010100100: fwd_o =  40'b1000100010001000100010001001011101010010; //  X X X X X X 9 7 5 2
         10'b1010100101: fwd_o =  40'b1000100010001000100010010111010100100000; //  X X X X X 9 7 5 2 0
         10'b1010100110: fwd_o =  40'b1000100010001000100010010111010100100001; //  X X X X X 9 7 5 2 1
         10'b1010100111: fwd_o =  40'b1000100010001000100101110101001000010000; //  X X X X 9 7 5 2 1 0
         10'b1010101000: fwd_o =  40'b1000100010001000100010001001011101010011; //  X X X X X X 9 7 5 3
         10'b1010101001: fwd_o =  40'b1000100010001000100010010111010100110000; //  X X X X X 9 7 5 3 0
         10'b1010101010: fwd_o =  40'b1000100010001000100010010111010100110001; //  X X X X X 9 7 5 3 1
         10'b1010101011: fwd_o =  40'b1000100010001000100101110101001100010000; //  X X X X 9 7 5 3 1 0
         10'b1010101100: fwd_o =  40'b1000100010001000100010010111010100110010; //  X X X X X 9 7 5 3 2
         10'b1010101101: fwd_o =  40'b1000100010001000100101110101001100100000; //  X X X X 9 7 5 3 2 0
         10'b1010101110: fwd_o =  40'b1000100010001000100101110101001100100001; //  X X X X 9 7 5 3 2 1
         10'b1010101111: fwd_o =  40'b1000100010001001011101010011001000010000; //  X X X 9 7 5 3 2 1 0
         10'b1010110000: fwd_o =  40'b1000100010001000100010001001011101010100; //  X X X X X X 9 7 5 4
         10'b1010110001: fwd_o =  40'b1000100010001000100010010111010101000000; //  X X X X X 9 7 5 4 0
         10'b1010110010: fwd_o =  40'b1000100010001000100010010111010101000001; //  X X X X X 9 7 5 4 1
         10'b1010110011: fwd_o =  40'b1000100010001000100101110101010000010000; //  X X X X 9 7 5 4 1 0
         10'b1010110100: fwd_o =  40'b1000100010001000100010010111010101000010; //  X X X X X 9 7 5 4 2
         10'b1010110101: fwd_o =  40'b1000100010001000100101110101010000100000; //  X X X X 9 7 5 4 2 0
         10'b1010110110: fwd_o =  40'b1000100010001000100101110101010000100001; //  X X X X 9 7 5 4 2 1
         10'b1010110111: fwd_o =  40'b1000100010001001011101010100001000010000; //  X X X 9 7 5 4 2 1 0
         10'b1010111000: fwd_o =  40'b1000100010001000100010010111010101000011; //  X X X X X 9 7 5 4 3
         10'b1010111001: fwd_o =  40'b1000100010001000100101110101010000110000; //  X X X X 9 7 5 4 3 0
         10'b1010111010: fwd_o =  40'b1000100010001000100101110101010000110001; //  X X X X 9 7 5 4 3 1
         10'b1010111011: fwd_o =  40'b1000100010001001011101010100001100010000; //  X X X 9 7 5 4 3 1 0
         10'b1010111100: fwd_o =  40'b1000100010001000100101110101010000110010; //  X X X X 9 7 5 4 3 2
         10'b1010111101: fwd_o =  40'b1000100010001001011101010100001100100000; //  X X X 9 7 5 4 3 2 0
         10'b1010111110: fwd_o =  40'b1000100010001001011101010100001100100001; //  X X X 9 7 5 4 3 2 1
         10'b1010111111: fwd_o =  40'b1000100010010111010101000011001000010000; //  X X 9 7 5 4 3 2 1 0
         10'b1011000000: fwd_o =  40'b1000100010001000100010001000100101110110; //  X X X X X X X 9 7 6
         10'b1011000001: fwd_o =  40'b1000100010001000100010001001011101100000; //  X X X X X X 9 7 6 0
         10'b1011000010: fwd_o =  40'b1000100010001000100010001001011101100001; //  X X X X X X 9 7 6 1
         10'b1011000011: fwd_o =  40'b1000100010001000100010010111011000010000; //  X X X X X 9 7 6 1 0
         10'b1011000100: fwd_o =  40'b1000100010001000100010001001011101100010; //  X X X X X X 9 7 6 2
         10'b1011000101: fwd_o =  40'b1000100010001000100010010111011000100000; //  X X X X X 9 7 6 2 0
         10'b1011000110: fwd_o =  40'b1000100010001000100010010111011000100001; //  X X X X X 9 7 6 2 1
         10'b1011000111: fwd_o =  40'b1000100010001000100101110110001000010000; //  X X X X 9 7 6 2 1 0
         10'b1011001000: fwd_o =  40'b1000100010001000100010001001011101100011; //  X X X X X X 9 7 6 3
         10'b1011001001: fwd_o =  40'b1000100010001000100010010111011000110000; //  X X X X X 9 7 6 3 0
         10'b1011001010: fwd_o =  40'b1000100010001000100010010111011000110001; //  X X X X X 9 7 6 3 1
         10'b1011001011: fwd_o =  40'b1000100010001000100101110110001100010000; //  X X X X 9 7 6 3 1 0
         10'b1011001100: fwd_o =  40'b1000100010001000100010010111011000110010; //  X X X X X 9 7 6 3 2
         10'b1011001101: fwd_o =  40'b1000100010001000100101110110001100100000; //  X X X X 9 7 6 3 2 0
         10'b1011001110: fwd_o =  40'b1000100010001000100101110110001100100001; //  X X X X 9 7 6 3 2 1
         10'b1011001111: fwd_o =  40'b1000100010001001011101100011001000010000; //  X X X 9 7 6 3 2 1 0
         10'b1011010000: fwd_o =  40'b1000100010001000100010001001011101100100; //  X X X X X X 9 7 6 4
         10'b1011010001: fwd_o =  40'b1000100010001000100010010111011001000000; //  X X X X X 9 7 6 4 0
         10'b1011010010: fwd_o =  40'b1000100010001000100010010111011001000001; //  X X X X X 9 7 6 4 1
         10'b1011010011: fwd_o =  40'b1000100010001000100101110110010000010000; //  X X X X 9 7 6 4 1 0
         10'b1011010100: fwd_o =  40'b1000100010001000100010010111011001000010; //  X X X X X 9 7 6 4 2
         10'b1011010101: fwd_o =  40'b1000100010001000100101110110010000100000; //  X X X X 9 7 6 4 2 0
         10'b1011010110: fwd_o =  40'b1000100010001000100101110110010000100001; //  X X X X 9 7 6 4 2 1
         10'b1011010111: fwd_o =  40'b1000100010001001011101100100001000010000; //  X X X 9 7 6 4 2 1 0
         10'b1011011000: fwd_o =  40'b1000100010001000100010010111011001000011; //  X X X X X 9 7 6 4 3
         10'b1011011001: fwd_o =  40'b1000100010001000100101110110010000110000; //  X X X X 9 7 6 4 3 0
         10'b1011011010: fwd_o =  40'b1000100010001000100101110110010000110001; //  X X X X 9 7 6 4 3 1
         10'b1011011011: fwd_o =  40'b1000100010001001011101100100001100010000; //  X X X 9 7 6 4 3 1 0
         10'b1011011100: fwd_o =  40'b1000100010001000100101110110010000110010; //  X X X X 9 7 6 4 3 2
         10'b1011011101: fwd_o =  40'b1000100010001001011101100100001100100000; //  X X X 9 7 6 4 3 2 0
         10'b1011011110: fwd_o =  40'b1000100010001001011101100100001100100001; //  X X X 9 7 6 4 3 2 1
         10'b1011011111: fwd_o =  40'b1000100010010111011001000011001000010000; //  X X 9 7 6 4 3 2 1 0
         10'b1011100000: fwd_o =  40'b1000100010001000100010001001011101100101; //  X X X X X X 9 7 6 5
         10'b1011100001: fwd_o =  40'b1000100010001000100010010111011001010000; //  X X X X X 9 7 6 5 0
         10'b1011100010: fwd_o =  40'b1000100010001000100010010111011001010001; //  X X X X X 9 7 6 5 1
         10'b1011100011: fwd_o =  40'b1000100010001000100101110110010100010000; //  X X X X 9 7 6 5 1 0
         10'b1011100100: fwd_o =  40'b1000100010001000100010010111011001010010; //  X X X X X 9 7 6 5 2
         10'b1011100101: fwd_o =  40'b1000100010001000100101110110010100100000; //  X X X X 9 7 6 5 2 0
         10'b1011100110: fwd_o =  40'b1000100010001000100101110110010100100001; //  X X X X 9 7 6 5 2 1
         10'b1011100111: fwd_o =  40'b1000100010001001011101100101001000010000; //  X X X 9 7 6 5 2 1 0
         10'b1011101000: fwd_o =  40'b1000100010001000100010010111011001010011; //  X X X X X 9 7 6 5 3
         10'b1011101001: fwd_o =  40'b1000100010001000100101110110010100110000; //  X X X X 9 7 6 5 3 0
         10'b1011101010: fwd_o =  40'b1000100010001000100101110110010100110001; //  X X X X 9 7 6 5 3 1
         10'b1011101011: fwd_o =  40'b1000100010001001011101100101001100010000; //  X X X 9 7 6 5 3 1 0
         10'b1011101100: fwd_o =  40'b1000100010001000100101110110010100110010; //  X X X X 9 7 6 5 3 2
         10'b1011101101: fwd_o =  40'b1000100010001001011101100101001100100000; //  X X X 9 7 6 5 3 2 0
         10'b1011101110: fwd_o =  40'b1000100010001001011101100101001100100001; //  X X X 9 7 6 5 3 2 1
         10'b1011101111: fwd_o =  40'b1000100010010111011001010011001000010000; //  X X 9 7 6 5 3 2 1 0
         10'b1011110000: fwd_o =  40'b1000100010001000100010010111011001010100; //  X X X X X 9 7 6 5 4
         10'b1011110001: fwd_o =  40'b1000100010001000100101110110010101000000; //  X X X X 9 7 6 5 4 0
         10'b1011110010: fwd_o =  40'b1000100010001000100101110110010101000001; //  X X X X 9 7 6 5 4 1
         10'b1011110011: fwd_o =  40'b1000100010001001011101100101010000010000; //  X X X 9 7 6 5 4 1 0
         10'b1011110100: fwd_o =  40'b1000100010001000100101110110010101000010; //  X X X X 9 7 6 5 4 2
         10'b1011110101: fwd_o =  40'b1000100010001001011101100101010000100000; //  X X X 9 7 6 5 4 2 0
         10'b1011110110: fwd_o =  40'b1000100010001001011101100101010000100001; //  X X X 9 7 6 5 4 2 1
         10'b1011110111: fwd_o =  40'b1000100010010111011001010100001000010000; //  X X 9 7 6 5 4 2 1 0
         10'b1011111000: fwd_o =  40'b1000100010001000100101110110010101000011; //  X X X X 9 7 6 5 4 3
         10'b1011111001: fwd_o =  40'b1000100010001001011101100101010000110000; //  X X X 9 7 6 5 4 3 0
         10'b1011111010: fwd_o =  40'b1000100010001001011101100101010000110001; //  X X X 9 7 6 5 4 3 1
         10'b1011111011: fwd_o =  40'b1000100010010111011001010100001100010000; //  X X 9 7 6 5 4 3 1 0
         10'b1011111100: fwd_o =  40'b1000100010001001011101100101010000110010; //  X X X 9 7 6 5 4 3 2
         10'b1011111101: fwd_o =  40'b1000100010010111011001010100001100100000; //  X X 9 7 6 5 4 3 2 0
         10'b1011111110: fwd_o =  40'b1000100010010111011001010100001100100001; //  X X 9 7 6 5 4 3 2 1
         10'b1011111111: fwd_o =  40'b1000100101110110010101000011001000010000; //  X 9 7 6 5 4 3 2 1 0
         10'b1100000000: fwd_o =  40'b0111011101110111011101110111011110011000; //  X X X X X X X X 9 8
         10'b1100000001: fwd_o =  40'b0111011101110111011101110111100110000000; //  X X X X X X X 9 8 0
         10'b1100000010: fwd_o =  40'b0111011101110111011101110111100110000001; //  X X X X X X X 9 8 1
         10'b1100000011: fwd_o =  40'b0111011101110111011101111001100000010000; //  X X X X X X 9 8 1 0
         10'b1100000100: fwd_o =  40'b0111011101110111011101110111100110000010; //  X X X X X X X 9 8 2
         10'b1100000101: fwd_o =  40'b0111011101110111011101111001100000100000; //  X X X X X X 9 8 2 0
         10'b1100000110: fwd_o =  40'b0111011101110111011101111001100000100001; //  X X X X X X 9 8 2 1
         10'b1100000111: fwd_o =  40'b0111011101110111011110011000001000010000; //  X X X X X 9 8 2 1 0
         10'b1100001000: fwd_o =  40'b0111011101110111011101110111100110000011; //  X X X X X X X 9 8 3
         10'b1100001001: fwd_o =  40'b0111011101110111011101111001100000110000; //  X X X X X X 9 8 3 0
         10'b1100001010: fwd_o =  40'b0111011101110111011101111001100000110001; //  X X X X X X 9 8 3 1
         10'b1100001011: fwd_o =  40'b0111011101110111011110011000001100010000; //  X X X X X 9 8 3 1 0
         10'b1100001100: fwd_o =  40'b0111011101110111011101111001100000110010; //  X X X X X X 9 8 3 2
         10'b1100001101: fwd_o =  40'b0111011101110111011110011000001100100000; //  X X X X X 9 8 3 2 0
         10'b1100001110: fwd_o =  40'b0111011101110111011110011000001100100001; //  X X X X X 9 8 3 2 1
         10'b1100001111: fwd_o =  40'b0111011101110111100110000011001000010000; //  X X X X 9 8 3 2 1 0
         10'b1100010000: fwd_o =  40'b0111011101110111011101110111100110000100; //  X X X X X X X 9 8 4
         10'b1100010001: fwd_o =  40'b0111011101110111011101111001100001000000; //  X X X X X X 9 8 4 0
         10'b1100010010: fwd_o =  40'b0111011101110111011101111001100001000001; //  X X X X X X 9 8 4 1
         10'b1100010011: fwd_o =  40'b0111011101110111011110011000010000010000; //  X X X X X 9 8 4 1 0
         10'b1100010100: fwd_o =  40'b0111011101110111011101111001100001000010; //  X X X X X X 9 8 4 2
         10'b1100010101: fwd_o =  40'b0111011101110111011110011000010000100000; //  X X X X X 9 8 4 2 0
         10'b1100010110: fwd_o =  40'b0111011101110111011110011000010000100001; //  X X X X X 9 8 4 2 1
         10'b1100010111: fwd_o =  40'b0111011101110111100110000100001000010000; //  X X X X 9 8 4 2 1 0
         10'b1100011000: fwd_o =  40'b0111011101110111011101111001100001000011; //  X X X X X X 9 8 4 3
         10'b1100011001: fwd_o =  40'b0111011101110111011110011000010000110000; //  X X X X X 9 8 4 3 0
         10'b1100011010: fwd_o =  40'b0111011101110111011110011000010000110001; //  X X X X X 9 8 4 3 1
         10'b1100011011: fwd_o =  40'b0111011101110111100110000100001100010000; //  X X X X 9 8 4 3 1 0
         10'b1100011100: fwd_o =  40'b0111011101110111011110011000010000110010; //  X X X X X 9 8 4 3 2
         10'b1100011101: fwd_o =  40'b0111011101110111100110000100001100100000; //  X X X X 9 8 4 3 2 0
         10'b1100011110: fwd_o =  40'b0111011101110111100110000100001100100001; //  X X X X 9 8 4 3 2 1
         10'b1100011111: fwd_o =  40'b0111011101111001100001000011001000010000; //  X X X 9 8 4 3 2 1 0
         10'b1100100000: fwd_o =  40'b0111011101110111011101110111100110000101; //  X X X X X X X 9 8 5
         10'b1100100001: fwd_o =  40'b0111011101110111011101111001100001010000; //  X X X X X X 9 8 5 0
         10'b1100100010: fwd_o =  40'b0111011101110111011101111001100001010001; //  X X X X X X 9 8 5 1
         10'b1100100011: fwd_o =  40'b0111011101110111011110011000010100010000; //  X X X X X 9 8 5 1 0
         10'b1100100100: fwd_o =  40'b0111011101110111011101111001100001010010; //  X X X X X X 9 8 5 2
         10'b1100100101: fwd_o =  40'b0111011101110111011110011000010100100000; //  X X X X X 9 8 5 2 0
         10'b1100100110: fwd_o =  40'b0111011101110111011110011000010100100001; //  X X X X X 9 8 5 2 1
         10'b1100100111: fwd_o =  40'b0111011101110111100110000101001000010000; //  X X X X 9 8 5 2 1 0
         10'b1100101000: fwd_o =  40'b0111011101110111011101111001100001010011; //  X X X X X X 9 8 5 3
         10'b1100101001: fwd_o =  40'b0111011101110111011110011000010100110000; //  X X X X X 9 8 5 3 0
         10'b1100101010: fwd_o =  40'b0111011101110111011110011000010100110001; //  X X X X X 9 8 5 3 1
         10'b1100101011: fwd_o =  40'b0111011101110111100110000101001100010000; //  X X X X 9 8 5 3 1 0
         10'b1100101100: fwd_o =  40'b0111011101110111011110011000010100110010; //  X X X X X 9 8 5 3 2
         10'b1100101101: fwd_o =  40'b0111011101110111100110000101001100100000; //  X X X X 9 8 5 3 2 0
         10'b1100101110: fwd_o =  40'b0111011101110111100110000101001100100001; //  X X X X 9 8 5 3 2 1
         10'b1100101111: fwd_o =  40'b0111011101111001100001010011001000010000; //  X X X 9 8 5 3 2 1 0
         10'b1100110000: fwd_o =  40'b0111011101110111011101111001100001010100; //  X X X X X X 9 8 5 4
         10'b1100110001: fwd_o =  40'b0111011101110111011110011000010101000000; //  X X X X X 9 8 5 4 0
         10'b1100110010: fwd_o =  40'b0111011101110111011110011000010101000001; //  X X X X X 9 8 5 4 1
         10'b1100110011: fwd_o =  40'b0111011101110111100110000101010000010000; //  X X X X 9 8 5 4 1 0
         10'b1100110100: fwd_o =  40'b0111011101110111011110011000010101000010; //  X X X X X 9 8 5 4 2
         10'b1100110101: fwd_o =  40'b0111011101110111100110000101010000100000; //  X X X X 9 8 5 4 2 0
         10'b1100110110: fwd_o =  40'b0111011101110111100110000101010000100001; //  X X X X 9 8 5 4 2 1
         10'b1100110111: fwd_o =  40'b0111011101111001100001010100001000010000; //  X X X 9 8 5 4 2 1 0
         10'b1100111000: fwd_o =  40'b0111011101110111011110011000010101000011; //  X X X X X 9 8 5 4 3
         10'b1100111001: fwd_o =  40'b0111011101110111100110000101010000110000; //  X X X X 9 8 5 4 3 0
         10'b1100111010: fwd_o =  40'b0111011101110111100110000101010000110001; //  X X X X 9 8 5 4 3 1
         10'b1100111011: fwd_o =  40'b0111011101111001100001010100001100010000; //  X X X 9 8 5 4 3 1 0
         10'b1100111100: fwd_o =  40'b0111011101110111100110000101010000110010; //  X X X X 9 8 5 4 3 2
         10'b1100111101: fwd_o =  40'b0111011101111001100001010100001100100000; //  X X X 9 8 5 4 3 2 0
         10'b1100111110: fwd_o =  40'b0111011101111001100001010100001100100001; //  X X X 9 8 5 4 3 2 1
         10'b1100111111: fwd_o =  40'b0111011110011000010101000011001000010000; //  X X 9 8 5 4 3 2 1 0
         10'b1101000000: fwd_o =  40'b0111011101110111011101110111100110000110; //  X X X X X X X 9 8 6
         10'b1101000001: fwd_o =  40'b0111011101110111011101111001100001100000; //  X X X X X X 9 8 6 0
         10'b1101000010: fwd_o =  40'b0111011101110111011101111001100001100001; //  X X X X X X 9 8 6 1
         10'b1101000011: fwd_o =  40'b0111011101110111011110011000011000010000; //  X X X X X 9 8 6 1 0
         10'b1101000100: fwd_o =  40'b0111011101110111011101111001100001100010; //  X X X X X X 9 8 6 2
         10'b1101000101: fwd_o =  40'b0111011101110111011110011000011000100000; //  X X X X X 9 8 6 2 0
         10'b1101000110: fwd_o =  40'b0111011101110111011110011000011000100001; //  X X X X X 9 8 6 2 1
         10'b1101000111: fwd_o =  40'b0111011101110111100110000110001000010000; //  X X X X 9 8 6 2 1 0
         10'b1101001000: fwd_o =  40'b0111011101110111011101111001100001100011; //  X X X X X X 9 8 6 3
         10'b1101001001: fwd_o =  40'b0111011101110111011110011000011000110000; //  X X X X X 9 8 6 3 0
         10'b1101001010: fwd_o =  40'b0111011101110111011110011000011000110001; //  X X X X X 9 8 6 3 1
         10'b1101001011: fwd_o =  40'b0111011101110111100110000110001100010000; //  X X X X 9 8 6 3 1 0
         10'b1101001100: fwd_o =  40'b0111011101110111011110011000011000110010; //  X X X X X 9 8 6 3 2
         10'b1101001101: fwd_o =  40'b0111011101110111100110000110001100100000; //  X X X X 9 8 6 3 2 0
         10'b1101001110: fwd_o =  40'b0111011101110111100110000110001100100001; //  X X X X 9 8 6 3 2 1
         10'b1101001111: fwd_o =  40'b0111011101111001100001100011001000010000; //  X X X 9 8 6 3 2 1 0
         10'b1101010000: fwd_o =  40'b0111011101110111011101111001100001100100; //  X X X X X X 9 8 6 4
         10'b1101010001: fwd_o =  40'b0111011101110111011110011000011001000000; //  X X X X X 9 8 6 4 0
         10'b1101010010: fwd_o =  40'b0111011101110111011110011000011001000001; //  X X X X X 9 8 6 4 1
         10'b1101010011: fwd_o =  40'b0111011101110111100110000110010000010000; //  X X X X 9 8 6 4 1 0
         10'b1101010100: fwd_o =  40'b0111011101110111011110011000011001000010; //  X X X X X 9 8 6 4 2
         10'b1101010101: fwd_o =  40'b0111011101110111100110000110010000100000; //  X X X X 9 8 6 4 2 0
         10'b1101010110: fwd_o =  40'b0111011101110111100110000110010000100001; //  X X X X 9 8 6 4 2 1
         10'b1101010111: fwd_o =  40'b0111011101111001100001100100001000010000; //  X X X 9 8 6 4 2 1 0
         10'b1101011000: fwd_o =  40'b0111011101110111011110011000011001000011; //  X X X X X 9 8 6 4 3
         10'b1101011001: fwd_o =  40'b0111011101110111100110000110010000110000; //  X X X X 9 8 6 4 3 0
         10'b1101011010: fwd_o =  40'b0111011101110111100110000110010000110001; //  X X X X 9 8 6 4 3 1
         10'b1101011011: fwd_o =  40'b0111011101111001100001100100001100010000; //  X X X 9 8 6 4 3 1 0
         10'b1101011100: fwd_o =  40'b0111011101110111100110000110010000110010; //  X X X X 9 8 6 4 3 2
         10'b1101011101: fwd_o =  40'b0111011101111001100001100100001100100000; //  X X X 9 8 6 4 3 2 0
         10'b1101011110: fwd_o =  40'b0111011101111001100001100100001100100001; //  X X X 9 8 6 4 3 2 1
         10'b1101011111: fwd_o =  40'b0111011110011000011001000011001000010000; //  X X 9 8 6 4 3 2 1 0
         10'b1101100000: fwd_o =  40'b0111011101110111011101111001100001100101; //  X X X X X X 9 8 6 5
         10'b1101100001: fwd_o =  40'b0111011101110111011110011000011001010000; //  X X X X X 9 8 6 5 0
         10'b1101100010: fwd_o =  40'b0111011101110111011110011000011001010001; //  X X X X X 9 8 6 5 1
         10'b1101100011: fwd_o =  40'b0111011101110111100110000110010100010000; //  X X X X 9 8 6 5 1 0
         10'b1101100100: fwd_o =  40'b0111011101110111011110011000011001010010; //  X X X X X 9 8 6 5 2
         10'b1101100101: fwd_o =  40'b0111011101110111100110000110010100100000; //  X X X X 9 8 6 5 2 0
         10'b1101100110: fwd_o =  40'b0111011101110111100110000110010100100001; //  X X X X 9 8 6 5 2 1
         10'b1101100111: fwd_o =  40'b0111011101111001100001100101001000010000; //  X X X 9 8 6 5 2 1 0
         10'b1101101000: fwd_o =  40'b0111011101110111011110011000011001010011; //  X X X X X 9 8 6 5 3
         10'b1101101001: fwd_o =  40'b0111011101110111100110000110010100110000; //  X X X X 9 8 6 5 3 0
         10'b1101101010: fwd_o =  40'b0111011101110111100110000110010100110001; //  X X X X 9 8 6 5 3 1
         10'b1101101011: fwd_o =  40'b0111011101111001100001100101001100010000; //  X X X 9 8 6 5 3 1 0
         10'b1101101100: fwd_o =  40'b0111011101110111100110000110010100110010; //  X X X X 9 8 6 5 3 2
         10'b1101101101: fwd_o =  40'b0111011101111001100001100101001100100000; //  X X X 9 8 6 5 3 2 0
         10'b1101101110: fwd_o =  40'b0111011101111001100001100101001100100001; //  X X X 9 8 6 5 3 2 1
         10'b1101101111: fwd_o =  40'b0111011110011000011001010011001000010000; //  X X 9 8 6 5 3 2 1 0
         10'b1101110000: fwd_o =  40'b0111011101110111011110011000011001010100; //  X X X X X 9 8 6 5 4
         10'b1101110001: fwd_o =  40'b0111011101110111100110000110010101000000; //  X X X X 9 8 6 5 4 0
         10'b1101110010: fwd_o =  40'b0111011101110111100110000110010101000001; //  X X X X 9 8 6 5 4 1
         10'b1101110011: fwd_o =  40'b0111011101111001100001100101010000010000; //  X X X 9 8 6 5 4 1 0
         10'b1101110100: fwd_o =  40'b0111011101110111100110000110010101000010; //  X X X X 9 8 6 5 4 2
         10'b1101110101: fwd_o =  40'b0111011101111001100001100101010000100000; //  X X X 9 8 6 5 4 2 0
         10'b1101110110: fwd_o =  40'b0111011101111001100001100101010000100001; //  X X X 9 8 6 5 4 2 1
         10'b1101110111: fwd_o =  40'b0111011110011000011001010100001000010000; //  X X 9 8 6 5 4 2 1 0
         10'b1101111000: fwd_o =  40'b0111011101110111100110000110010101000011; //  X X X X 9 8 6 5 4 3
         10'b1101111001: fwd_o =  40'b0111011101111001100001100101010000110000; //  X X X 9 8 6 5 4 3 0
         10'b1101111010: fwd_o =  40'b0111011101111001100001100101010000110001; //  X X X 9 8 6 5 4 3 1
         10'b1101111011: fwd_o =  40'b0111011110011000011001010100001100010000; //  X X 9 8 6 5 4 3 1 0
         10'b1101111100: fwd_o =  40'b0111011101111001100001100101010000110010; //  X X X 9 8 6 5 4 3 2
         10'b1101111101: fwd_o =  40'b0111011110011000011001010100001100100000; //  X X 9 8 6 5 4 3 2 0
         10'b1101111110: fwd_o =  40'b0111011110011000011001010100001100100001; //  X X 9 8 6 5 4 3 2 1
         10'b1101111111: fwd_o =  40'b0111100110000110010101000011001000010000; //  X 9 8 6 5 4 3 2 1 0
         10'b1110000000: fwd_o =  40'b0110011001100110011001100110100110000111; //  X X X X X X X 9 8 7
         10'b1110000001: fwd_o =  40'b0110011001100110011001101001100001110000; //  X X X X X X 9 8 7 0
         10'b1110000010: fwd_o =  40'b0110011001100110011001101001100001110001; //  X X X X X X 9 8 7 1
         10'b1110000011: fwd_o =  40'b0110011001100110011010011000011100010000; //  X X X X X 9 8 7 1 0
         10'b1110000100: fwd_o =  40'b0110011001100110011001101001100001110010; //  X X X X X X 9 8 7 2
         10'b1110000101: fwd_o =  40'b0110011001100110011010011000011100100000; //  X X X X X 9 8 7 2 0
         10'b1110000110: fwd_o =  40'b0110011001100110011010011000011100100001; //  X X X X X 9 8 7 2 1
         10'b1110000111: fwd_o =  40'b0110011001100110100110000111001000010000; //  X X X X 9 8 7 2 1 0
         10'b1110001000: fwd_o =  40'b0110011001100110011001101001100001110011; //  X X X X X X 9 8 7 3
         10'b1110001001: fwd_o =  40'b0110011001100110011010011000011100110000; //  X X X X X 9 8 7 3 0
         10'b1110001010: fwd_o =  40'b0110011001100110011010011000011100110001; //  X X X X X 9 8 7 3 1
         10'b1110001011: fwd_o =  40'b0110011001100110100110000111001100010000; //  X X X X 9 8 7 3 1 0
         10'b1110001100: fwd_o =  40'b0110011001100110011010011000011100110010; //  X X X X X 9 8 7 3 2
         10'b1110001101: fwd_o =  40'b0110011001100110100110000111001100100000; //  X X X X 9 8 7 3 2 0
         10'b1110001110: fwd_o =  40'b0110011001100110100110000111001100100001; //  X X X X 9 8 7 3 2 1
         10'b1110001111: fwd_o =  40'b0110011001101001100001110011001000010000; //  X X X 9 8 7 3 2 1 0
         10'b1110010000: fwd_o =  40'b0110011001100110011001101001100001110100; //  X X X X X X 9 8 7 4
         10'b1110010001: fwd_o =  40'b0110011001100110011010011000011101000000; //  X X X X X 9 8 7 4 0
         10'b1110010010: fwd_o =  40'b0110011001100110011010011000011101000001; //  X X X X X 9 8 7 4 1
         10'b1110010011: fwd_o =  40'b0110011001100110100110000111010000010000; //  X X X X 9 8 7 4 1 0
         10'b1110010100: fwd_o =  40'b0110011001100110011010011000011101000010; //  X X X X X 9 8 7 4 2
         10'b1110010101: fwd_o =  40'b0110011001100110100110000111010000100000; //  X X X X 9 8 7 4 2 0
         10'b1110010110: fwd_o =  40'b0110011001100110100110000111010000100001; //  X X X X 9 8 7 4 2 1
         10'b1110010111: fwd_o =  40'b0110011001101001100001110100001000010000; //  X X X 9 8 7 4 2 1 0
         10'b1110011000: fwd_o =  40'b0110011001100110011010011000011101000011; //  X X X X X 9 8 7 4 3
         10'b1110011001: fwd_o =  40'b0110011001100110100110000111010000110000; //  X X X X 9 8 7 4 3 0
         10'b1110011010: fwd_o =  40'b0110011001100110100110000111010000110001; //  X X X X 9 8 7 4 3 1
         10'b1110011011: fwd_o =  40'b0110011001101001100001110100001100010000; //  X X X 9 8 7 4 3 1 0
         10'b1110011100: fwd_o =  40'b0110011001100110100110000111010000110010; //  X X X X 9 8 7 4 3 2
         10'b1110011101: fwd_o =  40'b0110011001101001100001110100001100100000; //  X X X 9 8 7 4 3 2 0
         10'b1110011110: fwd_o =  40'b0110011001101001100001110100001100100001; //  X X X 9 8 7 4 3 2 1
         10'b1110011111: fwd_o =  40'b0110011010011000011101000011001000010000; //  X X 9 8 7 4 3 2 1 0
         10'b1110100000: fwd_o =  40'b0110011001100110011001101001100001110101; //  X X X X X X 9 8 7 5
         10'b1110100001: fwd_o =  40'b0110011001100110011010011000011101010000; //  X X X X X 9 8 7 5 0
         10'b1110100010: fwd_o =  40'b0110011001100110011010011000011101010001; //  X X X X X 9 8 7 5 1
         10'b1110100011: fwd_o =  40'b0110011001100110100110000111010100010000; //  X X X X 9 8 7 5 1 0
         10'b1110100100: fwd_o =  40'b0110011001100110011010011000011101010010; //  X X X X X 9 8 7 5 2
         10'b1110100101: fwd_o =  40'b0110011001100110100110000111010100100000; //  X X X X 9 8 7 5 2 0
         10'b1110100110: fwd_o =  40'b0110011001100110100110000111010100100001; //  X X X X 9 8 7 5 2 1
         10'b1110100111: fwd_o =  40'b0110011001101001100001110101001000010000; //  X X X 9 8 7 5 2 1 0
         10'b1110101000: fwd_o =  40'b0110011001100110011010011000011101010011; //  X X X X X 9 8 7 5 3
         10'b1110101001: fwd_o =  40'b0110011001100110100110000111010100110000; //  X X X X 9 8 7 5 3 0
         10'b1110101010: fwd_o =  40'b0110011001100110100110000111010100110001; //  X X X X 9 8 7 5 3 1
         10'b1110101011: fwd_o =  40'b0110011001101001100001110101001100010000; //  X X X 9 8 7 5 3 1 0
         10'b1110101100: fwd_o =  40'b0110011001100110100110000111010100110010; //  X X X X 9 8 7 5 3 2
         10'b1110101101: fwd_o =  40'b0110011001101001100001110101001100100000; //  X X X 9 8 7 5 3 2 0
         10'b1110101110: fwd_o =  40'b0110011001101001100001110101001100100001; //  X X X 9 8 7 5 3 2 1
         10'b1110101111: fwd_o =  40'b0110011010011000011101010011001000010000; //  X X 9 8 7 5 3 2 1 0
         10'b1110110000: fwd_o =  40'b0110011001100110011010011000011101010100; //  X X X X X 9 8 7 5 4
         10'b1110110001: fwd_o =  40'b0110011001100110100110000111010101000000; //  X X X X 9 8 7 5 4 0
         10'b1110110010: fwd_o =  40'b0110011001100110100110000111010101000001; //  X X X X 9 8 7 5 4 1
         10'b1110110011: fwd_o =  40'b0110011001101001100001110101010000010000; //  X X X 9 8 7 5 4 1 0
         10'b1110110100: fwd_o =  40'b0110011001100110100110000111010101000010; //  X X X X 9 8 7 5 4 2
         10'b1110110101: fwd_o =  40'b0110011001101001100001110101010000100000; //  X X X 9 8 7 5 4 2 0
         10'b1110110110: fwd_o =  40'b0110011001101001100001110101010000100001; //  X X X 9 8 7 5 4 2 1
         10'b1110110111: fwd_o =  40'b0110011010011000011101010100001000010000; //  X X 9 8 7 5 4 2 1 0
         10'b1110111000: fwd_o =  40'b0110011001100110100110000111010101000011; //  X X X X 9 8 7 5 4 3
         10'b1110111001: fwd_o =  40'b0110011001101001100001110101010000110000; //  X X X 9 8 7 5 4 3 0
         10'b1110111010: fwd_o =  40'b0110011001101001100001110101010000110001; //  X X X 9 8 7 5 4 3 1
         10'b1110111011: fwd_o =  40'b0110011010011000011101010100001100010000; //  X X 9 8 7 5 4 3 1 0
         10'b1110111100: fwd_o =  40'b0110011001101001100001110101010000110010; //  X X X 9 8 7 5 4 3 2
         10'b1110111101: fwd_o =  40'b0110011010011000011101010100001100100000; //  X X 9 8 7 5 4 3 2 0
         10'b1110111110: fwd_o =  40'b0110011010011000011101010100001100100001; //  X X 9 8 7 5 4 3 2 1
         10'b1110111111: fwd_o =  40'b0110100110000111010101000011001000010000; //  X 9 8 7 5 4 3 2 1 0
         10'b1111000000: fwd_o =  40'b0101010101010101010101011001100001110110; //  X X X X X X 9 8 7 6
         10'b1111000001: fwd_o =  40'b0101010101010101010110011000011101100000; //  X X X X X 9 8 7 6 0
         10'b1111000010: fwd_o =  40'b0101010101010101010110011000011101100001; //  X X X X X 9 8 7 6 1
         10'b1111000011: fwd_o =  40'b0101010101010101100110000111011000010000; //  X X X X 9 8 7 6 1 0
         10'b1111000100: fwd_o =  40'b0101010101010101010110011000011101100010; //  X X X X X 9 8 7 6 2
         10'b1111000101: fwd_o =  40'b0101010101010101100110000111011000100000; //  X X X X 9 8 7 6 2 0
         10'b1111000110: fwd_o =  40'b0101010101010101100110000111011000100001; //  X X X X 9 8 7 6 2 1
         10'b1111000111: fwd_o =  40'b0101010101011001100001110110001000010000; //  X X X 9 8 7 6 2 1 0
         10'b1111001000: fwd_o =  40'b0101010101010101010110011000011101100011; //  X X X X X 9 8 7 6 3
         10'b1111001001: fwd_o =  40'b0101010101010101100110000111011000110000; //  X X X X 9 8 7 6 3 0
         10'b1111001010: fwd_o =  40'b0101010101010101100110000111011000110001; //  X X X X 9 8 7 6 3 1
         10'b1111001011: fwd_o =  40'b0101010101011001100001110110001100010000; //  X X X 9 8 7 6 3 1 0
         10'b1111001100: fwd_o =  40'b0101010101010101100110000111011000110010; //  X X X X 9 8 7 6 3 2
         10'b1111001101: fwd_o =  40'b0101010101011001100001110110001100100000; //  X X X 9 8 7 6 3 2 0
         10'b1111001110: fwd_o =  40'b0101010101011001100001110110001100100001; //  X X X 9 8 7 6 3 2 1
         10'b1111001111: fwd_o =  40'b0101010110011000011101100011001000010000; //  X X 9 8 7 6 3 2 1 0
         10'b1111010000: fwd_o =  40'b0101010101010101010110011000011101100100; //  X X X X X 9 8 7 6 4
         10'b1111010001: fwd_o =  40'b0101010101010101100110000111011001000000; //  X X X X 9 8 7 6 4 0
         10'b1111010010: fwd_o =  40'b0101010101010101100110000111011001000001; //  X X X X 9 8 7 6 4 1
         10'b1111010011: fwd_o =  40'b0101010101011001100001110110010000010000; //  X X X 9 8 7 6 4 1 0
         10'b1111010100: fwd_o =  40'b0101010101010101100110000111011001000010; //  X X X X 9 8 7 6 4 2
         10'b1111010101: fwd_o =  40'b0101010101011001100001110110010000100000; //  X X X 9 8 7 6 4 2 0
         10'b1111010110: fwd_o =  40'b0101010101011001100001110110010000100001; //  X X X 9 8 7 6 4 2 1
         10'b1111010111: fwd_o =  40'b0101010110011000011101100100001000010000; //  X X 9 8 7 6 4 2 1 0
         10'b1111011000: fwd_o =  40'b0101010101010101100110000111011001000011; //  X X X X 9 8 7 6 4 3
         10'b1111011001: fwd_o =  40'b0101010101011001100001110110010000110000; //  X X X 9 8 7 6 4 3 0
         10'b1111011010: fwd_o =  40'b0101010101011001100001110110010000110001; //  X X X 9 8 7 6 4 3 1
         10'b1111011011: fwd_o =  40'b0101010110011000011101100100001100010000; //  X X 9 8 7 6 4 3 1 0
         10'b1111011100: fwd_o =  40'b0101010101011001100001110110010000110010; //  X X X 9 8 7 6 4 3 2
         10'b1111011101: fwd_o =  40'b0101010110011000011101100100001100100000; //  X X 9 8 7 6 4 3 2 0
         10'b1111011110: fwd_o =  40'b0101010110011000011101100100001100100001; //  X X 9 8 7 6 4 3 2 1
         10'b1111011111: fwd_o =  40'b0101100110000111011001000011001000010000; //  X 9 8 7 6 4 3 2 1 0
         10'b1111100000: fwd_o =  40'b0100010001000100010010011000011101100101; //  X X X X X 9 8 7 6 5
         10'b1111100001: fwd_o =  40'b0100010001000100100110000111011001010000; //  X X X X 9 8 7 6 5 0
         10'b1111100010: fwd_o =  40'b0100010001000100100110000111011001010001; //  X X X X 9 8 7 6 5 1
         10'b1111100011: fwd_o =  40'b0100010001001001100001110110010100010000; //  X X X 9 8 7 6 5 1 0
         10'b1111100100: fwd_o =  40'b0100010001000100100110000111011001010010; //  X X X X 9 8 7 6 5 2
         10'b1111100101: fwd_o =  40'b0100010001001001100001110110010100100000; //  X X X 9 8 7 6 5 2 0
         10'b1111100110: fwd_o =  40'b0100010001001001100001110110010100100001; //  X X X 9 8 7 6 5 2 1
         10'b1111100111: fwd_o =  40'b0100010010011000011101100101001000010000; //  X X 9 8 7 6 5 2 1 0
         10'b1111101000: fwd_o =  40'b0100010001000100100110000111011001010011; //  X X X X 9 8 7 6 5 3
         10'b1111101001: fwd_o =  40'b0100010001001001100001110110010100110000; //  X X X 9 8 7 6 5 3 0
         10'b1111101010: fwd_o =  40'b0100010001001001100001110110010100110001; //  X X X 9 8 7 6 5 3 1
         10'b1111101011: fwd_o =  40'b0100010010011000011101100101001100010000; //  X X 9 8 7 6 5 3 1 0
         10'b1111101100: fwd_o =  40'b0100010001001001100001110110010100110010; //  X X X 9 8 7 6 5 3 2
         10'b1111101101: fwd_o =  40'b0100010010011000011101100101001100100000; //  X X 9 8 7 6 5 3 2 0
         10'b1111101110: fwd_o =  40'b0100010010011000011101100101001100100001; //  X X 9 8 7 6 5 3 2 1
         10'b1111101111: fwd_o =  40'b0100100110000111011001010011001000010000; //  X 9 8 7 6 5 3 2 1 0
         10'b1111110000: fwd_o =  40'b0011001100110011100110000111011001010100; //  X X X X 9 8 7 6 5 4
         10'b1111110001: fwd_o =  40'b0011001100111001100001110110010101000000; //  X X X 9 8 7 6 5 4 0
         10'b1111110010: fwd_o =  40'b0011001100111001100001110110010101000001; //  X X X 9 8 7 6 5 4 1
         10'b1111110011: fwd_o =  40'b0011001110011000011101100101010000010000; //  X X 9 8 7 6 5 4 1 0
         10'b1111110100: fwd_o =  40'b0011001100111001100001110110010101000010; //  X X X 9 8 7 6 5 4 2
         10'b1111110101: fwd_o =  40'b0011001110011000011101100101010000100000; //  X X 9 8 7 6 5 4 2 0
         10'b1111110110: fwd_o =  40'b0011001110011000011101100101010000100001; //  X X 9 8 7 6 5 4 2 1
         10'b1111110111: fwd_o =  40'b0011100110000111011001010100001000010000; //  X 9 8 7 6 5 4 2 1 0
         10'b1111111000: fwd_o =  40'b0010001000101001100001110110010101000011; //  X X X 9 8 7 6 5 4 3
         10'b1111111001: fwd_o =  40'b0010001010011000011101100101010000110000; //  X X 9 8 7 6 5 4 3 0
         10'b1111111010: fwd_o =  40'b0010001010011000011101100101010000110001; //  X X 9 8 7 6 5 4 3 1
         10'b1111111011: fwd_o =  40'b0010100110000111011001010100001100010000; //  X 9 8 7 6 5 4 3 1 0
         10'b1111111100: fwd_o =  40'b0001000110011000011101100101010000110010; //  X X 9 8 7 6 5 4 3 2
         10'b1111111101: fwd_o =  40'b0001100110000111011001010100001100100000; //  X 9 8 7 6 5 4 3 2 0
         10'b1111111110: fwd_o =  40'b0000100110000111011001010100001100100001; //  X 9 8 7 6 5 4 3 2 1
         10'b1111111111: fwd_o =  40'b1001100001110110010101000011001000010000; //  9 8 7 6 5 4 3 2 1 0
        default: fwd_o= 'X;
    endcase

    // fwd datapath vec
    always_comb
    unique case (vec_i) 
         10'b0000000000: fwd_datapath_o =  40'b0000000000000000000000000000000000000000; //  X X X X X X X X X X
         10'b0000000001: fwd_datapath_o =  40'b0000000000000000000000000000000000000000; //  X X X X X X X X X 0
         10'b0000000010: fwd_datapath_o =  40'b0000000000000000000000000000000000000001; //  X X X X X X X X X 1
         10'b0000000011: fwd_datapath_o =  40'b0000000000000000000000000000000000000000; //  X X X X X X X X 0 0
         10'b0000000100: fwd_datapath_o =  40'b0000000000000000000000000000000000000010; //  X X X X X X X X X 2
         10'b0000000101: fwd_datapath_o =  40'b0000000000000000000000000000000000010000; //  X X X X X X X X 1 0
         10'b0000000110: fwd_datapath_o =  40'b0000000000000000000000000000000000010001; //  X X X X X X X X 1 1
         10'b0000000111: fwd_datapath_o =  40'b0000000000000000000000000000000000000000; //  X X X X X X X 0 0 0
         10'b0000001000: fwd_datapath_o =  40'b0000000000000000000000000000000000000011; //  X X X X X X X X X 3
         10'b0000001001: fwd_datapath_o =  40'b0000000000000000000000000000000000100000; //  X X X X X X X X 2 0
         10'b0000001010: fwd_datapath_o =  40'b0000000000000000000000000000000000100001; //  X X X X X X X X 2 1
         10'b0000001011: fwd_datapath_o =  40'b0000000000000000000000000000000100000000; //  X X X X X X X 1 0 0
         10'b0000001100: fwd_datapath_o =  40'b0000000000000000000000000000000000100010; //  X X X X X X X X 2 2
         10'b0000001101: fwd_datapath_o =  40'b0000000000000000000000000000000100010000; //  X X X X X X X 1 1 0
         10'b0000001110: fwd_datapath_o =  40'b0000000000000000000000000000000100010001; //  X X X X X X X 1 1 1
         10'b0000001111: fwd_datapath_o =  40'b0000000000000000000000000000000000000000; //  X X X X X X 0 0 0 0
         10'b0000010000: fwd_datapath_o =  40'b0000000000000000000000000000000000000100; //  X X X X X X X X X 4
         10'b0000010001: fwd_datapath_o =  40'b0000000000000000000000000000000000110000; //  X X X X X X X X 3 0
         10'b0000010010: fwd_datapath_o =  40'b0000000000000000000000000000000000110001; //  X X X X X X X X 3 1
         10'b0000010011: fwd_datapath_o =  40'b0000000000000000000000000000001000000000; //  X X X X X X X 2 0 0
         10'b0000010100: fwd_datapath_o =  40'b0000000000000000000000000000000000110010; //  X X X X X X X X 3 2
         10'b0000010101: fwd_datapath_o =  40'b0000000000000000000000000000001000010000; //  X X X X X X X 2 1 0
         10'b0000010110: fwd_datapath_o =  40'b0000000000000000000000000000001000010001; //  X X X X X X X 2 1 1
         10'b0000010111: fwd_datapath_o =  40'b0000000000000000000000000001000000000000; //  X X X X X X 1 0 0 0
         10'b0000011000: fwd_datapath_o =  40'b0000000000000000000000000000000000110011; //  X X X X X X X X 3 3
         10'b0000011001: fwd_datapath_o =  40'b0000000000000000000000000000001000100000; //  X X X X X X X 2 2 0
         10'b0000011010: fwd_datapath_o =  40'b0000000000000000000000000000001000100001; //  X X X X X X X 2 2 1
         10'b0000011011: fwd_datapath_o =  40'b0000000000000000000000000001000100000000; //  X X X X X X 1 1 0 0
         10'b0000011100: fwd_datapath_o =  40'b0000000000000000000000000000001000100010; //  X X X X X X X 2 2 2
         10'b0000011101: fwd_datapath_o =  40'b0000000000000000000000000001000100010000; //  X X X X X X 1 1 1 0
         10'b0000011110: fwd_datapath_o =  40'b0000000000000000000000000001000100010001; //  X X X X X X 1 1 1 1
         10'b0000011111: fwd_datapath_o =  40'b0000000000000000000000000000000000000000; //  X X X X X 0 0 0 0 0
         10'b0000100000: fwd_datapath_o =  40'b0000000000000000000000000000000000000101; //  X X X X X X X X X 5
         10'b0000100001: fwd_datapath_o =  40'b0000000000000000000000000000000001000000; //  X X X X X X X X 4 0
         10'b0000100010: fwd_datapath_o =  40'b0000000000000000000000000000000001000001; //  X X X X X X X X 4 1
         10'b0000100011: fwd_datapath_o =  40'b0000000000000000000000000000001100000000; //  X X X X X X X 3 0 0
         10'b0000100100: fwd_datapath_o =  40'b0000000000000000000000000000000001000010; //  X X X X X X X X 4 2
         10'b0000100101: fwd_datapath_o =  40'b0000000000000000000000000000001100010000; //  X X X X X X X 3 1 0
         10'b0000100110: fwd_datapath_o =  40'b0000000000000000000000000000001100010001; //  X X X X X X X 3 1 1
         10'b0000100111: fwd_datapath_o =  40'b0000000000000000000000000010000000000000; //  X X X X X X 2 0 0 0
         10'b0000101000: fwd_datapath_o =  40'b0000000000000000000000000000000001000011; //  X X X X X X X X 4 3
         10'b0000101001: fwd_datapath_o =  40'b0000000000000000000000000000001100100000; //  X X X X X X X 3 2 0
         10'b0000101010: fwd_datapath_o =  40'b0000000000000000000000000000001100100001; //  X X X X X X X 3 2 1
         10'b0000101011: fwd_datapath_o =  40'b0000000000000000000000000010000100000000; //  X X X X X X 2 1 0 0
         10'b0000101100: fwd_datapath_o =  40'b0000000000000000000000000000001100100010; //  X X X X X X X 3 2 2
         10'b0000101101: fwd_datapath_o =  40'b0000000000000000000000000010000100010000; //  X X X X X X 2 1 1 0
         10'b0000101110: fwd_datapath_o =  40'b0000000000000000000000000010000100010001; //  X X X X X X 2 1 1 1
         10'b0000101111: fwd_datapath_o =  40'b0000000000000000000000010000000000000000; //  X X X X X 1 0 0 0 0
         10'b0000110000: fwd_datapath_o =  40'b0000000000000000000000000000000001000100; //  X X X X X X X X 4 4
         10'b0000110001: fwd_datapath_o =  40'b0000000000000000000000000000001100110000; //  X X X X X X X 3 3 0
         10'b0000110010: fwd_datapath_o =  40'b0000000000000000000000000000001100110001; //  X X X X X X X 3 3 1
         10'b0000110011: fwd_datapath_o =  40'b0000000000000000000000000010001000000000; //  X X X X X X 2 2 0 0
         10'b0000110100: fwd_datapath_o =  40'b0000000000000000000000000000001100110010; //  X X X X X X X 3 3 2
         10'b0000110101: fwd_datapath_o =  40'b0000000000000000000000000010001000010000; //  X X X X X X 2 2 1 0
         10'b0000110110: fwd_datapath_o =  40'b0000000000000000000000000010001000010001; //  X X X X X X 2 2 1 1
         10'b0000110111: fwd_datapath_o =  40'b0000000000000000000000010001000000000000; //  X X X X X 1 1 0 0 0
         10'b0000111000: fwd_datapath_o =  40'b0000000000000000000000000000001100110011; //  X X X X X X X 3 3 3
         10'b0000111001: fwd_datapath_o =  40'b0000000000000000000000000010001000100000; //  X X X X X X 2 2 2 0
         10'b0000111010: fwd_datapath_o =  40'b0000000000000000000000000010001000100001; //  X X X X X X 2 2 2 1
         10'b0000111011: fwd_datapath_o =  40'b0000000000000000000000010001000100000000; //  X X X X X 1 1 1 0 0
         10'b0000111100: fwd_datapath_o =  40'b0000000000000000000000000010001000100010; //  X X X X X X 2 2 2 2
         10'b0000111101: fwd_datapath_o =  40'b0000000000000000000000010001000100010000; //  X X X X X 1 1 1 1 0
         10'b0000111110: fwd_datapath_o =  40'b0000000000000000000000010001000100010001; //  X X X X X 1 1 1 1 1
         10'b0000111111: fwd_datapath_o =  40'b0000000000000000000000000000000000000000; //  X X X X 0 0 0 0 0 0
         10'b0001000000: fwd_datapath_o =  40'b0000000000000000000000000000000000000110; //  X X X X X X X X X 6
         10'b0001000001: fwd_datapath_o =  40'b0000000000000000000000000000000001010000; //  X X X X X X X X 5 0
         10'b0001000010: fwd_datapath_o =  40'b0000000000000000000000000000000001010001; //  X X X X X X X X 5 1
         10'b0001000011: fwd_datapath_o =  40'b0000000000000000000000000000010000000000; //  X X X X X X X 4 0 0
         10'b0001000100: fwd_datapath_o =  40'b0000000000000000000000000000000001010010; //  X X X X X X X X 5 2
         10'b0001000101: fwd_datapath_o =  40'b0000000000000000000000000000010000010000; //  X X X X X X X 4 1 0
         10'b0001000110: fwd_datapath_o =  40'b0000000000000000000000000000010000010001; //  X X X X X X X 4 1 1
         10'b0001000111: fwd_datapath_o =  40'b0000000000000000000000000011000000000000; //  X X X X X X 3 0 0 0
         10'b0001001000: fwd_datapath_o =  40'b0000000000000000000000000000000001010011; //  X X X X X X X X 5 3
         10'b0001001001: fwd_datapath_o =  40'b0000000000000000000000000000010000100000; //  X X X X X X X 4 2 0
         10'b0001001010: fwd_datapath_o =  40'b0000000000000000000000000000010000100001; //  X X X X X X X 4 2 1
         10'b0001001011: fwd_datapath_o =  40'b0000000000000000000000000011000100000000; //  X X X X X X 3 1 0 0
         10'b0001001100: fwd_datapath_o =  40'b0000000000000000000000000000010000100010; //  X X X X X X X 4 2 2
         10'b0001001101: fwd_datapath_o =  40'b0000000000000000000000000011000100010000; //  X X X X X X 3 1 1 0
         10'b0001001110: fwd_datapath_o =  40'b0000000000000000000000000011000100010001; //  X X X X X X 3 1 1 1
         10'b0001001111: fwd_datapath_o =  40'b0000000000000000000000100000000000000000; //  X X X X X 2 0 0 0 0
         10'b0001010000: fwd_datapath_o =  40'b0000000000000000000000000000000001010100; //  X X X X X X X X 5 4
         10'b0001010001: fwd_datapath_o =  40'b0000000000000000000000000000010000110000; //  X X X X X X X 4 3 0
         10'b0001010010: fwd_datapath_o =  40'b0000000000000000000000000000010000110001; //  X X X X X X X 4 3 1
         10'b0001010011: fwd_datapath_o =  40'b0000000000000000000000000011001000000000; //  X X X X X X 3 2 0 0
         10'b0001010100: fwd_datapath_o =  40'b0000000000000000000000000000010000110010; //  X X X X X X X 4 3 2
         10'b0001010101: fwd_datapath_o =  40'b0000000000000000000000000011001000010000; //  X X X X X X 3 2 1 0
         10'b0001010110: fwd_datapath_o =  40'b0000000000000000000000000011001000010001; //  X X X X X X 3 2 1 1
         10'b0001010111: fwd_datapath_o =  40'b0000000000000000000000100001000000000000; //  X X X X X 2 1 0 0 0
         10'b0001011000: fwd_datapath_o =  40'b0000000000000000000000000000010000110011; //  X X X X X X X 4 3 3
         10'b0001011001: fwd_datapath_o =  40'b0000000000000000000000000011001000100000; //  X X X X X X 3 2 2 0
         10'b0001011010: fwd_datapath_o =  40'b0000000000000000000000000011001000100001; //  X X X X X X 3 2 2 1
         10'b0001011011: fwd_datapath_o =  40'b0000000000000000000000100001000100000000; //  X X X X X 2 1 1 0 0
         10'b0001011100: fwd_datapath_o =  40'b0000000000000000000000000011001000100010; //  X X X X X X 3 2 2 2
         10'b0001011101: fwd_datapath_o =  40'b0000000000000000000000100001000100010000; //  X X X X X 2 1 1 1 0
         10'b0001011110: fwd_datapath_o =  40'b0000000000000000000000100001000100010001; //  X X X X X 2 1 1 1 1
         10'b0001011111: fwd_datapath_o =  40'b0000000000000000000100000000000000000000; //  X X X X 1 0 0 0 0 0
         10'b0001100000: fwd_datapath_o =  40'b0000000000000000000000000000000001010101; //  X X X X X X X X 5 5
         10'b0001100001: fwd_datapath_o =  40'b0000000000000000000000000000010001000000; //  X X X X X X X 4 4 0
         10'b0001100010: fwd_datapath_o =  40'b0000000000000000000000000000010001000001; //  X X X X X X X 4 4 1
         10'b0001100011: fwd_datapath_o =  40'b0000000000000000000000000011001100000000; //  X X X X X X 3 3 0 0
         10'b0001100100: fwd_datapath_o =  40'b0000000000000000000000000000010001000010; //  X X X X X X X 4 4 2
         10'b0001100101: fwd_datapath_o =  40'b0000000000000000000000000011001100010000; //  X X X X X X 3 3 1 0
         10'b0001100110: fwd_datapath_o =  40'b0000000000000000000000000011001100010001; //  X X X X X X 3 3 1 1
         10'b0001100111: fwd_datapath_o =  40'b0000000000000000000000100010000000000000; //  X X X X X 2 2 0 0 0
         10'b0001101000: fwd_datapath_o =  40'b0000000000000000000000000000010001000011; //  X X X X X X X 4 4 3
         10'b0001101001: fwd_datapath_o =  40'b0000000000000000000000000011001100100000; //  X X X X X X 3 3 2 0
         10'b0001101010: fwd_datapath_o =  40'b0000000000000000000000000011001100100001; //  X X X X X X 3 3 2 1
         10'b0001101011: fwd_datapath_o =  40'b0000000000000000000000100010000100000000; //  X X X X X 2 2 1 0 0
         10'b0001101100: fwd_datapath_o =  40'b0000000000000000000000000011001100100010; //  X X X X X X 3 3 2 2
         10'b0001101101: fwd_datapath_o =  40'b0000000000000000000000100010000100010000; //  X X X X X 2 2 1 1 0
         10'b0001101110: fwd_datapath_o =  40'b0000000000000000000000100010000100010001; //  X X X X X 2 2 1 1 1
         10'b0001101111: fwd_datapath_o =  40'b0000000000000000000100010000000000000000; //  X X X X 1 1 0 0 0 0
         10'b0001110000: fwd_datapath_o =  40'b0000000000000000000000000000010001000100; //  X X X X X X X 4 4 4
         10'b0001110001: fwd_datapath_o =  40'b0000000000000000000000000011001100110000; //  X X X X X X 3 3 3 0
         10'b0001110010: fwd_datapath_o =  40'b0000000000000000000000000011001100110001; //  X X X X X X 3 3 3 1
         10'b0001110011: fwd_datapath_o =  40'b0000000000000000000000100010001000000000; //  X X X X X 2 2 2 0 0
         10'b0001110100: fwd_datapath_o =  40'b0000000000000000000000000011001100110010; //  X X X X X X 3 3 3 2
         10'b0001110101: fwd_datapath_o =  40'b0000000000000000000000100010001000010000; //  X X X X X 2 2 2 1 0
         10'b0001110110: fwd_datapath_o =  40'b0000000000000000000000100010001000010001; //  X X X X X 2 2 2 1 1
         10'b0001110111: fwd_datapath_o =  40'b0000000000000000000100010001000000000000; //  X X X X 1 1 1 0 0 0
         10'b0001111000: fwd_datapath_o =  40'b0000000000000000000000000011001100110011; //  X X X X X X 3 3 3 3
         10'b0001111001: fwd_datapath_o =  40'b0000000000000000000000100010001000100000; //  X X X X X 2 2 2 2 0
         10'b0001111010: fwd_datapath_o =  40'b0000000000000000000000100010001000100001; //  X X X X X 2 2 2 2 1
         10'b0001111011: fwd_datapath_o =  40'b0000000000000000000100010001000100000000; //  X X X X 1 1 1 1 0 0
         10'b0001111100: fwd_datapath_o =  40'b0000000000000000000000100010001000100010; //  X X X X X 2 2 2 2 2
         10'b0001111101: fwd_datapath_o =  40'b0000000000000000000100010001000100010000; //  X X X X 1 1 1 1 1 0
         10'b0001111110: fwd_datapath_o =  40'b0000000000000000000100010001000100010001; //  X X X X 1 1 1 1 1 1
         10'b0001111111: fwd_datapath_o =  40'b0000000000000000000000000000000000000000; //  X X X 0 0 0 0 0 0 0
         10'b0010000000: fwd_datapath_o =  40'b0000000000000000000000000000000000000111; //  X X X X X X X X X 7
         10'b0010000001: fwd_datapath_o =  40'b0000000000000000000000000000000001100000; //  X X X X X X X X 6 0
         10'b0010000010: fwd_datapath_o =  40'b0000000000000000000000000000000001100001; //  X X X X X X X X 6 1
         10'b0010000011: fwd_datapath_o =  40'b0000000000000000000000000000010100000000; //  X X X X X X X 5 0 0
         10'b0010000100: fwd_datapath_o =  40'b0000000000000000000000000000000001100010; //  X X X X X X X X 6 2
         10'b0010000101: fwd_datapath_o =  40'b0000000000000000000000000000010100010000; //  X X X X X X X 5 1 0
         10'b0010000110: fwd_datapath_o =  40'b0000000000000000000000000000010100010001; //  X X X X X X X 5 1 1
         10'b0010000111: fwd_datapath_o =  40'b0000000000000000000000000100000000000000; //  X X X X X X 4 0 0 0
         10'b0010001000: fwd_datapath_o =  40'b0000000000000000000000000000000001100011; //  X X X X X X X X 6 3
         10'b0010001001: fwd_datapath_o =  40'b0000000000000000000000000000010100100000; //  X X X X X X X 5 2 0
         10'b0010001010: fwd_datapath_o =  40'b0000000000000000000000000000010100100001; //  X X X X X X X 5 2 1
         10'b0010001011: fwd_datapath_o =  40'b0000000000000000000000000100000100000000; //  X X X X X X 4 1 0 0
         10'b0010001100: fwd_datapath_o =  40'b0000000000000000000000000000010100100010; //  X X X X X X X 5 2 2
         10'b0010001101: fwd_datapath_o =  40'b0000000000000000000000000100000100010000; //  X X X X X X 4 1 1 0
         10'b0010001110: fwd_datapath_o =  40'b0000000000000000000000000100000100010001; //  X X X X X X 4 1 1 1
         10'b0010001111: fwd_datapath_o =  40'b0000000000000000000000110000000000000000; //  X X X X X 3 0 0 0 0
         10'b0010010000: fwd_datapath_o =  40'b0000000000000000000000000000000001100100; //  X X X X X X X X 6 4
         10'b0010010001: fwd_datapath_o =  40'b0000000000000000000000000000010100110000; //  X X X X X X X 5 3 0
         10'b0010010010: fwd_datapath_o =  40'b0000000000000000000000000000010100110001; //  X X X X X X X 5 3 1
         10'b0010010011: fwd_datapath_o =  40'b0000000000000000000000000100001000000000; //  X X X X X X 4 2 0 0
         10'b0010010100: fwd_datapath_o =  40'b0000000000000000000000000000010100110010; //  X X X X X X X 5 3 2
         10'b0010010101: fwd_datapath_o =  40'b0000000000000000000000000100001000010000; //  X X X X X X 4 2 1 0
         10'b0010010110: fwd_datapath_o =  40'b0000000000000000000000000100001000010001; //  X X X X X X 4 2 1 1
         10'b0010010111: fwd_datapath_o =  40'b0000000000000000000000110001000000000000; //  X X X X X 3 1 0 0 0
         10'b0010011000: fwd_datapath_o =  40'b0000000000000000000000000000010100110011; //  X X X X X X X 5 3 3
         10'b0010011001: fwd_datapath_o =  40'b0000000000000000000000000100001000100000; //  X X X X X X 4 2 2 0
         10'b0010011010: fwd_datapath_o =  40'b0000000000000000000000000100001000100001; //  X X X X X X 4 2 2 1
         10'b0010011011: fwd_datapath_o =  40'b0000000000000000000000110001000100000000; //  X X X X X 3 1 1 0 0
         10'b0010011100: fwd_datapath_o =  40'b0000000000000000000000000100001000100010; //  X X X X X X 4 2 2 2
         10'b0010011101: fwd_datapath_o =  40'b0000000000000000000000110001000100010000; //  X X X X X 3 1 1 1 0
         10'b0010011110: fwd_datapath_o =  40'b0000000000000000000000110001000100010001; //  X X X X X 3 1 1 1 1
         10'b0010011111: fwd_datapath_o =  40'b0000000000000000001000000000000000000000; //  X X X X 2 0 0 0 0 0
         10'b0010100000: fwd_datapath_o =  40'b0000000000000000000000000000000001100101; //  X X X X X X X X 6 5
         10'b0010100001: fwd_datapath_o =  40'b0000000000000000000000000000010101000000; //  X X X X X X X 5 4 0
         10'b0010100010: fwd_datapath_o =  40'b0000000000000000000000000000010101000001; //  X X X X X X X 5 4 1
         10'b0010100011: fwd_datapath_o =  40'b0000000000000000000000000100001100000000; //  X X X X X X 4 3 0 0
         10'b0010100100: fwd_datapath_o =  40'b0000000000000000000000000000010101000010; //  X X X X X X X 5 4 2
         10'b0010100101: fwd_datapath_o =  40'b0000000000000000000000000100001100010000; //  X X X X X X 4 3 1 0
         10'b0010100110: fwd_datapath_o =  40'b0000000000000000000000000100001100010001; //  X X X X X X 4 3 1 1
         10'b0010100111: fwd_datapath_o =  40'b0000000000000000000000110010000000000000; //  X X X X X 3 2 0 0 0
         10'b0010101000: fwd_datapath_o =  40'b0000000000000000000000000000010101000011; //  X X X X X X X 5 4 3
         10'b0010101001: fwd_datapath_o =  40'b0000000000000000000000000100001100100000; //  X X X X X X 4 3 2 0
         10'b0010101010: fwd_datapath_o =  40'b0000000000000000000000000100001100100001; //  X X X X X X 4 3 2 1
         10'b0010101011: fwd_datapath_o =  40'b0000000000000000000000110010000100000000; //  X X X X X 3 2 1 0 0
         10'b0010101100: fwd_datapath_o =  40'b0000000000000000000000000100001100100010; //  X X X X X X 4 3 2 2
         10'b0010101101: fwd_datapath_o =  40'b0000000000000000000000110010000100010000; //  X X X X X 3 2 1 1 0
         10'b0010101110: fwd_datapath_o =  40'b0000000000000000000000110010000100010001; //  X X X X X 3 2 1 1 1
         10'b0010101111: fwd_datapath_o =  40'b0000000000000000001000010000000000000000; //  X X X X 2 1 0 0 0 0
         10'b0010110000: fwd_datapath_o =  40'b0000000000000000000000000000010101000100; //  X X X X X X X 5 4 4
         10'b0010110001: fwd_datapath_o =  40'b0000000000000000000000000100001100110000; //  X X X X X X 4 3 3 0
         10'b0010110010: fwd_datapath_o =  40'b0000000000000000000000000100001100110001; //  X X X X X X 4 3 3 1
         10'b0010110011: fwd_datapath_o =  40'b0000000000000000000000110010001000000000; //  X X X X X 3 2 2 0 0
         10'b0010110100: fwd_datapath_o =  40'b0000000000000000000000000100001100110010; //  X X X X X X 4 3 3 2
         10'b0010110101: fwd_datapath_o =  40'b0000000000000000000000110010001000010000; //  X X X X X 3 2 2 1 0
         10'b0010110110: fwd_datapath_o =  40'b0000000000000000000000110010001000010001; //  X X X X X 3 2 2 1 1
         10'b0010110111: fwd_datapath_o =  40'b0000000000000000001000010001000000000000; //  X X X X 2 1 1 0 0 0
         10'b0010111000: fwd_datapath_o =  40'b0000000000000000000000000100001100110011; //  X X X X X X 4 3 3 3
         10'b0010111001: fwd_datapath_o =  40'b0000000000000000000000110010001000100000; //  X X X X X 3 2 2 2 0
         10'b0010111010: fwd_datapath_o =  40'b0000000000000000000000110010001000100001; //  X X X X X 3 2 2 2 1
         10'b0010111011: fwd_datapath_o =  40'b0000000000000000001000010001000100000000; //  X X X X 2 1 1 1 0 0
         10'b0010111100: fwd_datapath_o =  40'b0000000000000000000000110010001000100010; //  X X X X X 3 2 2 2 2
         10'b0010111101: fwd_datapath_o =  40'b0000000000000000001000010001000100010000; //  X X X X 2 1 1 1 1 0
         10'b0010111110: fwd_datapath_o =  40'b0000000000000000001000010001000100010001; //  X X X X 2 1 1 1 1 1
         10'b0010111111: fwd_datapath_o =  40'b0000000000000001000000000000000000000000; //  X X X 1 0 0 0 0 0 0
         10'b0011000000: fwd_datapath_o =  40'b0000000000000000000000000000000001100110; //  X X X X X X X X 6 6
         10'b0011000001: fwd_datapath_o =  40'b0000000000000000000000000000010101010000; //  X X X X X X X 5 5 0
         10'b0011000010: fwd_datapath_o =  40'b0000000000000000000000000000010101010001; //  X X X X X X X 5 5 1
         10'b0011000011: fwd_datapath_o =  40'b0000000000000000000000000100010000000000; //  X X X X X X 4 4 0 0
         10'b0011000100: fwd_datapath_o =  40'b0000000000000000000000000000010101010010; //  X X X X X X X 5 5 2
         10'b0011000101: fwd_datapath_o =  40'b0000000000000000000000000100010000010000; //  X X X X X X 4 4 1 0
         10'b0011000110: fwd_datapath_o =  40'b0000000000000000000000000100010000010001; //  X X X X X X 4 4 1 1
         10'b0011000111: fwd_datapath_o =  40'b0000000000000000000000110011000000000000; //  X X X X X 3 3 0 0 0
         10'b0011001000: fwd_datapath_o =  40'b0000000000000000000000000000010101010011; //  X X X X X X X 5 5 3
         10'b0011001001: fwd_datapath_o =  40'b0000000000000000000000000100010000100000; //  X X X X X X 4 4 2 0
         10'b0011001010: fwd_datapath_o =  40'b0000000000000000000000000100010000100001; //  X X X X X X 4 4 2 1
         10'b0011001011: fwd_datapath_o =  40'b0000000000000000000000110011000100000000; //  X X X X X 3 3 1 0 0
         10'b0011001100: fwd_datapath_o =  40'b0000000000000000000000000100010000100010; //  X X X X X X 4 4 2 2
         10'b0011001101: fwd_datapath_o =  40'b0000000000000000000000110011000100010000; //  X X X X X 3 3 1 1 0
         10'b0011001110: fwd_datapath_o =  40'b0000000000000000000000110011000100010001; //  X X X X X 3 3 1 1 1
         10'b0011001111: fwd_datapath_o =  40'b0000000000000000001000100000000000000000; //  X X X X 2 2 0 0 0 0
         10'b0011010000: fwd_datapath_o =  40'b0000000000000000000000000000010101010100; //  X X X X X X X 5 5 4
         10'b0011010001: fwd_datapath_o =  40'b0000000000000000000000000100010000110000; //  X X X X X X 4 4 3 0
         10'b0011010010: fwd_datapath_o =  40'b0000000000000000000000000100010000110001; //  X X X X X X 4 4 3 1
         10'b0011010011: fwd_datapath_o =  40'b0000000000000000000000110011001000000000; //  X X X X X 3 3 2 0 0
         10'b0011010100: fwd_datapath_o =  40'b0000000000000000000000000100010000110010; //  X X X X X X 4 4 3 2
         10'b0011010101: fwd_datapath_o =  40'b0000000000000000000000110011001000010000; //  X X X X X 3 3 2 1 0
         10'b0011010110: fwd_datapath_o =  40'b0000000000000000000000110011001000010001; //  X X X X X 3 3 2 1 1
         10'b0011010111: fwd_datapath_o =  40'b0000000000000000001000100001000000000000; //  X X X X 2 2 1 0 0 0
         10'b0011011000: fwd_datapath_o =  40'b0000000000000000000000000100010000110011; //  X X X X X X 4 4 3 3
         10'b0011011001: fwd_datapath_o =  40'b0000000000000000000000110011001000100000; //  X X X X X 3 3 2 2 0
         10'b0011011010: fwd_datapath_o =  40'b0000000000000000000000110011001000100001; //  X X X X X 3 3 2 2 1
         10'b0011011011: fwd_datapath_o =  40'b0000000000000000001000100001000100000000; //  X X X X 2 2 1 1 0 0
         10'b0011011100: fwd_datapath_o =  40'b0000000000000000000000110011001000100010; //  X X X X X 3 3 2 2 2
         10'b0011011101: fwd_datapath_o =  40'b0000000000000000001000100001000100010000; //  X X X X 2 2 1 1 1 0
         10'b0011011110: fwd_datapath_o =  40'b0000000000000000001000100001000100010001; //  X X X X 2 2 1 1 1 1
         10'b0011011111: fwd_datapath_o =  40'b0000000000000001000100000000000000000000; //  X X X 1 1 0 0 0 0 0
         10'b0011100000: fwd_datapath_o =  40'b0000000000000000000000000000010101010101; //  X X X X X X X 5 5 5
         10'b0011100001: fwd_datapath_o =  40'b0000000000000000000000000100010001000000; //  X X X X X X 4 4 4 0
         10'b0011100010: fwd_datapath_o =  40'b0000000000000000000000000100010001000001; //  X X X X X X 4 4 4 1
         10'b0011100011: fwd_datapath_o =  40'b0000000000000000000000110011001100000000; //  X X X X X 3 3 3 0 0
         10'b0011100100: fwd_datapath_o =  40'b0000000000000000000000000100010001000010; //  X X X X X X 4 4 4 2
         10'b0011100101: fwd_datapath_o =  40'b0000000000000000000000110011001100010000; //  X X X X X 3 3 3 1 0
         10'b0011100110: fwd_datapath_o =  40'b0000000000000000000000110011001100010001; //  X X X X X 3 3 3 1 1
         10'b0011100111: fwd_datapath_o =  40'b0000000000000000001000100010000000000000; //  X X X X 2 2 2 0 0 0
         10'b0011101000: fwd_datapath_o =  40'b0000000000000000000000000100010001000011; //  X X X X X X 4 4 4 3
         10'b0011101001: fwd_datapath_o =  40'b0000000000000000000000110011001100100000; //  X X X X X 3 3 3 2 0
         10'b0011101010: fwd_datapath_o =  40'b0000000000000000000000110011001100100001; //  X X X X X 3 3 3 2 1
         10'b0011101011: fwd_datapath_o =  40'b0000000000000000001000100010000100000000; //  X X X X 2 2 2 1 0 0
         10'b0011101100: fwd_datapath_o =  40'b0000000000000000000000110011001100100010; //  X X X X X 3 3 3 2 2
         10'b0011101101: fwd_datapath_o =  40'b0000000000000000001000100010000100010000; //  X X X X 2 2 2 1 1 0
         10'b0011101110: fwd_datapath_o =  40'b0000000000000000001000100010000100010001; //  X X X X 2 2 2 1 1 1
         10'b0011101111: fwd_datapath_o =  40'b0000000000000001000100010000000000000000; //  X X X 1 1 1 0 0 0 0
         10'b0011110000: fwd_datapath_o =  40'b0000000000000000000000000100010001000100; //  X X X X X X 4 4 4 4
         10'b0011110001: fwd_datapath_o =  40'b0000000000000000000000110011001100110000; //  X X X X X 3 3 3 3 0
         10'b0011110010: fwd_datapath_o =  40'b0000000000000000000000110011001100110001; //  X X X X X 3 3 3 3 1
         10'b0011110011: fwd_datapath_o =  40'b0000000000000000001000100010001000000000; //  X X X X 2 2 2 2 0 0
         10'b0011110100: fwd_datapath_o =  40'b0000000000000000000000110011001100110010; //  X X X X X 3 3 3 3 2
         10'b0011110101: fwd_datapath_o =  40'b0000000000000000001000100010001000010000; //  X X X X 2 2 2 2 1 0
         10'b0011110110: fwd_datapath_o =  40'b0000000000000000001000100010001000010001; //  X X X X 2 2 2 2 1 1
         10'b0011110111: fwd_datapath_o =  40'b0000000000000001000100010001000000000000; //  X X X 1 1 1 1 0 0 0
         10'b0011111000: fwd_datapath_o =  40'b0000000000000000000000110011001100110011; //  X X X X X 3 3 3 3 3
         10'b0011111001: fwd_datapath_o =  40'b0000000000000000001000100010001000100000; //  X X X X 2 2 2 2 2 0
         10'b0011111010: fwd_datapath_o =  40'b0000000000000000001000100010001000100001; //  X X X X 2 2 2 2 2 1
         10'b0011111011: fwd_datapath_o =  40'b0000000000000001000100010001000100000000; //  X X X 1 1 1 1 1 0 0
         10'b0011111100: fwd_datapath_o =  40'b0000000000000000001000100010001000100010; //  X X X X 2 2 2 2 2 2
         10'b0011111101: fwd_datapath_o =  40'b0000000000000001000100010001000100010000; //  X X X 1 1 1 1 1 1 0
         10'b0011111110: fwd_datapath_o =  40'b0000000000000001000100010001000100010001; //  X X X 1 1 1 1 1 1 1
         10'b0011111111: fwd_datapath_o =  40'b0000000000000000000000000000000000000000; //  X X 0 0 0 0 0 0 0 0
         10'b0100000000: fwd_datapath_o =  40'b0000000000000000000000000000000000001000; //  X X X X X X X X X 8
         10'b0100000001: fwd_datapath_o =  40'b0000000000000000000000000000000001110000; //  X X X X X X X X 7 0
         10'b0100000010: fwd_datapath_o =  40'b0000000000000000000000000000000001110001; //  X X X X X X X X 7 1
         10'b0100000011: fwd_datapath_o =  40'b0000000000000000000000000000011000000000; //  X X X X X X X 6 0 0
         10'b0100000100: fwd_datapath_o =  40'b0000000000000000000000000000000001110010; //  X X X X X X X X 7 2
         10'b0100000101: fwd_datapath_o =  40'b0000000000000000000000000000011000010000; //  X X X X X X X 6 1 0
         10'b0100000110: fwd_datapath_o =  40'b0000000000000000000000000000011000010001; //  X X X X X X X 6 1 1
         10'b0100000111: fwd_datapath_o =  40'b0000000000000000000000000101000000000000; //  X X X X X X 5 0 0 0
         10'b0100001000: fwd_datapath_o =  40'b0000000000000000000000000000000001110011; //  X X X X X X X X 7 3
         10'b0100001001: fwd_datapath_o =  40'b0000000000000000000000000000011000100000; //  X X X X X X X 6 2 0
         10'b0100001010: fwd_datapath_o =  40'b0000000000000000000000000000011000100001; //  X X X X X X X 6 2 1
         10'b0100001011: fwd_datapath_o =  40'b0000000000000000000000000101000100000000; //  X X X X X X 5 1 0 0
         10'b0100001100: fwd_datapath_o =  40'b0000000000000000000000000000011000100010; //  X X X X X X X 6 2 2
         10'b0100001101: fwd_datapath_o =  40'b0000000000000000000000000101000100010000; //  X X X X X X 5 1 1 0
         10'b0100001110: fwd_datapath_o =  40'b0000000000000000000000000101000100010001; //  X X X X X X 5 1 1 1
         10'b0100001111: fwd_datapath_o =  40'b0000000000000000000001000000000000000000; //  X X X X X 4 0 0 0 0
         10'b0100010000: fwd_datapath_o =  40'b0000000000000000000000000000000001110100; //  X X X X X X X X 7 4
         10'b0100010001: fwd_datapath_o =  40'b0000000000000000000000000000011000110000; //  X X X X X X X 6 3 0
         10'b0100010010: fwd_datapath_o =  40'b0000000000000000000000000000011000110001; //  X X X X X X X 6 3 1
         10'b0100010011: fwd_datapath_o =  40'b0000000000000000000000000101001000000000; //  X X X X X X 5 2 0 0
         10'b0100010100: fwd_datapath_o =  40'b0000000000000000000000000000011000110010; //  X X X X X X X 6 3 2
         10'b0100010101: fwd_datapath_o =  40'b0000000000000000000000000101001000010000; //  X X X X X X 5 2 1 0
         10'b0100010110: fwd_datapath_o =  40'b0000000000000000000000000101001000010001; //  X X X X X X 5 2 1 1
         10'b0100010111: fwd_datapath_o =  40'b0000000000000000000001000001000000000000; //  X X X X X 4 1 0 0 0
         10'b0100011000: fwd_datapath_o =  40'b0000000000000000000000000000011000110011; //  X X X X X X X 6 3 3
         10'b0100011001: fwd_datapath_o =  40'b0000000000000000000000000101001000100000; //  X X X X X X 5 2 2 0
         10'b0100011010: fwd_datapath_o =  40'b0000000000000000000000000101001000100001; //  X X X X X X 5 2 2 1
         10'b0100011011: fwd_datapath_o =  40'b0000000000000000000001000001000100000000; //  X X X X X 4 1 1 0 0
         10'b0100011100: fwd_datapath_o =  40'b0000000000000000000000000101001000100010; //  X X X X X X 5 2 2 2
         10'b0100011101: fwd_datapath_o =  40'b0000000000000000000001000001000100010000; //  X X X X X 4 1 1 1 0
         10'b0100011110: fwd_datapath_o =  40'b0000000000000000000001000001000100010001; //  X X X X X 4 1 1 1 1
         10'b0100011111: fwd_datapath_o =  40'b0000000000000000001100000000000000000000; //  X X X X 3 0 0 0 0 0
         10'b0100100000: fwd_datapath_o =  40'b0000000000000000000000000000000001110101; //  X X X X X X X X 7 5
         10'b0100100001: fwd_datapath_o =  40'b0000000000000000000000000000011001000000; //  X X X X X X X 6 4 0
         10'b0100100010: fwd_datapath_o =  40'b0000000000000000000000000000011001000001; //  X X X X X X X 6 4 1
         10'b0100100011: fwd_datapath_o =  40'b0000000000000000000000000101001100000000; //  X X X X X X 5 3 0 0
         10'b0100100100: fwd_datapath_o =  40'b0000000000000000000000000000011001000010; //  X X X X X X X 6 4 2
         10'b0100100101: fwd_datapath_o =  40'b0000000000000000000000000101001100010000; //  X X X X X X 5 3 1 0
         10'b0100100110: fwd_datapath_o =  40'b0000000000000000000000000101001100010001; //  X X X X X X 5 3 1 1
         10'b0100100111: fwd_datapath_o =  40'b0000000000000000000001000010000000000000; //  X X X X X 4 2 0 0 0
         10'b0100101000: fwd_datapath_o =  40'b0000000000000000000000000000011001000011; //  X X X X X X X 6 4 3
         10'b0100101001: fwd_datapath_o =  40'b0000000000000000000000000101001100100000; //  X X X X X X 5 3 2 0
         10'b0100101010: fwd_datapath_o =  40'b0000000000000000000000000101001100100001; //  X X X X X X 5 3 2 1
         10'b0100101011: fwd_datapath_o =  40'b0000000000000000000001000010000100000000; //  X X X X X 4 2 1 0 0
         10'b0100101100: fwd_datapath_o =  40'b0000000000000000000000000101001100100010; //  X X X X X X 5 3 2 2
         10'b0100101101: fwd_datapath_o =  40'b0000000000000000000001000010000100010000; //  X X X X X 4 2 1 1 0
         10'b0100101110: fwd_datapath_o =  40'b0000000000000000000001000010000100010001; //  X X X X X 4 2 1 1 1
         10'b0100101111: fwd_datapath_o =  40'b0000000000000000001100010000000000000000; //  X X X X 3 1 0 0 0 0
         10'b0100110000: fwd_datapath_o =  40'b0000000000000000000000000000011001000100; //  X X X X X X X 6 4 4
         10'b0100110001: fwd_datapath_o =  40'b0000000000000000000000000101001100110000; //  X X X X X X 5 3 3 0
         10'b0100110010: fwd_datapath_o =  40'b0000000000000000000000000101001100110001; //  X X X X X X 5 3 3 1
         10'b0100110011: fwd_datapath_o =  40'b0000000000000000000001000010001000000000; //  X X X X X 4 2 2 0 0
         10'b0100110100: fwd_datapath_o =  40'b0000000000000000000000000101001100110010; //  X X X X X X 5 3 3 2
         10'b0100110101: fwd_datapath_o =  40'b0000000000000000000001000010001000010000; //  X X X X X 4 2 2 1 0
         10'b0100110110: fwd_datapath_o =  40'b0000000000000000000001000010001000010001; //  X X X X X 4 2 2 1 1
         10'b0100110111: fwd_datapath_o =  40'b0000000000000000001100010001000000000000; //  X X X X 3 1 1 0 0 0
         10'b0100111000: fwd_datapath_o =  40'b0000000000000000000000000101001100110011; //  X X X X X X 5 3 3 3
         10'b0100111001: fwd_datapath_o =  40'b0000000000000000000001000010001000100000; //  X X X X X 4 2 2 2 0
         10'b0100111010: fwd_datapath_o =  40'b0000000000000000000001000010001000100001; //  X X X X X 4 2 2 2 1
         10'b0100111011: fwd_datapath_o =  40'b0000000000000000001100010001000100000000; //  X X X X 3 1 1 1 0 0
         10'b0100111100: fwd_datapath_o =  40'b0000000000000000000001000010001000100010; //  X X X X X 4 2 2 2 2
         10'b0100111101: fwd_datapath_o =  40'b0000000000000000001100010001000100010000; //  X X X X 3 1 1 1 1 0
         10'b0100111110: fwd_datapath_o =  40'b0000000000000000001100010001000100010001; //  X X X X 3 1 1 1 1 1
         10'b0100111111: fwd_datapath_o =  40'b0000000000000010000000000000000000000000; //  X X X 2 0 0 0 0 0 0
         10'b0101000000: fwd_datapath_o =  40'b0000000000000000000000000000000001110110; //  X X X X X X X X 7 6
         10'b0101000001: fwd_datapath_o =  40'b0000000000000000000000000000011001010000; //  X X X X X X X 6 5 0
         10'b0101000010: fwd_datapath_o =  40'b0000000000000000000000000000011001010001; //  X X X X X X X 6 5 1
         10'b0101000011: fwd_datapath_o =  40'b0000000000000000000000000101010000000000; //  X X X X X X 5 4 0 0
         10'b0101000100: fwd_datapath_o =  40'b0000000000000000000000000000011001010010; //  X X X X X X X 6 5 2
         10'b0101000101: fwd_datapath_o =  40'b0000000000000000000000000101010000010000; //  X X X X X X 5 4 1 0
         10'b0101000110: fwd_datapath_o =  40'b0000000000000000000000000101010000010001; //  X X X X X X 5 4 1 1
         10'b0101000111: fwd_datapath_o =  40'b0000000000000000000001000011000000000000; //  X X X X X 4 3 0 0 0
         10'b0101001000: fwd_datapath_o =  40'b0000000000000000000000000000011001010011; //  X X X X X X X 6 5 3
         10'b0101001001: fwd_datapath_o =  40'b0000000000000000000000000101010000100000; //  X X X X X X 5 4 2 0
         10'b0101001010: fwd_datapath_o =  40'b0000000000000000000000000101010000100001; //  X X X X X X 5 4 2 1
         10'b0101001011: fwd_datapath_o =  40'b0000000000000000000001000011000100000000; //  X X X X X 4 3 1 0 0
         10'b0101001100: fwd_datapath_o =  40'b0000000000000000000000000101010000100010; //  X X X X X X 5 4 2 2
         10'b0101001101: fwd_datapath_o =  40'b0000000000000000000001000011000100010000; //  X X X X X 4 3 1 1 0
         10'b0101001110: fwd_datapath_o =  40'b0000000000000000000001000011000100010001; //  X X X X X 4 3 1 1 1
         10'b0101001111: fwd_datapath_o =  40'b0000000000000000001100100000000000000000; //  X X X X 3 2 0 0 0 0
         10'b0101010000: fwd_datapath_o =  40'b0000000000000000000000000000011001010100; //  X X X X X X X 6 5 4
         10'b0101010001: fwd_datapath_o =  40'b0000000000000000000000000101010000110000; //  X X X X X X 5 4 3 0
         10'b0101010010: fwd_datapath_o =  40'b0000000000000000000000000101010000110001; //  X X X X X X 5 4 3 1
         10'b0101010011: fwd_datapath_o =  40'b0000000000000000000001000011001000000000; //  X X X X X 4 3 2 0 0
         10'b0101010100: fwd_datapath_o =  40'b0000000000000000000000000101010000110010; //  X X X X X X 5 4 3 2
         10'b0101010101: fwd_datapath_o =  40'b0000000000000000000001000011001000010000; //  X X X X X 4 3 2 1 0
         10'b0101010110: fwd_datapath_o =  40'b0000000000000000000001000011001000010001; //  X X X X X 4 3 2 1 1
         10'b0101010111: fwd_datapath_o =  40'b0000000000000000001100100001000000000000; //  X X X X 3 2 1 0 0 0
         10'b0101011000: fwd_datapath_o =  40'b0000000000000000000000000101010000110011; //  X X X X X X 5 4 3 3
         10'b0101011001: fwd_datapath_o =  40'b0000000000000000000001000011001000100000; //  X X X X X 4 3 2 2 0
         10'b0101011010: fwd_datapath_o =  40'b0000000000000000000001000011001000100001; //  X X X X X 4 3 2 2 1
         10'b0101011011: fwd_datapath_o =  40'b0000000000000000001100100001000100000000; //  X X X X 3 2 1 1 0 0
         10'b0101011100: fwd_datapath_o =  40'b0000000000000000000001000011001000100010; //  X X X X X 4 3 2 2 2
         10'b0101011101: fwd_datapath_o =  40'b0000000000000000001100100001000100010000; //  X X X X 3 2 1 1 1 0
         10'b0101011110: fwd_datapath_o =  40'b0000000000000000001100100001000100010001; //  X X X X 3 2 1 1 1 1
         10'b0101011111: fwd_datapath_o =  40'b0000000000000010000100000000000000000000; //  X X X 2 1 0 0 0 0 0
         10'b0101100000: fwd_datapath_o =  40'b0000000000000000000000000000011001010101; //  X X X X X X X 6 5 5
         10'b0101100001: fwd_datapath_o =  40'b0000000000000000000000000101010001000000; //  X X X X X X 5 4 4 0
         10'b0101100010: fwd_datapath_o =  40'b0000000000000000000000000101010001000001; //  X X X X X X 5 4 4 1
         10'b0101100011: fwd_datapath_o =  40'b0000000000000000000001000011001100000000; //  X X X X X 4 3 3 0 0
         10'b0101100100: fwd_datapath_o =  40'b0000000000000000000000000101010001000010; //  X X X X X X 5 4 4 2
         10'b0101100101: fwd_datapath_o =  40'b0000000000000000000001000011001100010000; //  X X X X X 4 3 3 1 0
         10'b0101100110: fwd_datapath_o =  40'b0000000000000000000001000011001100010001; //  X X X X X 4 3 3 1 1
         10'b0101100111: fwd_datapath_o =  40'b0000000000000000001100100010000000000000; //  X X X X 3 2 2 0 0 0
         10'b0101101000: fwd_datapath_o =  40'b0000000000000000000000000101010001000011; //  X X X X X X 5 4 4 3
         10'b0101101001: fwd_datapath_o =  40'b0000000000000000000001000011001100100000; //  X X X X X 4 3 3 2 0
         10'b0101101010: fwd_datapath_o =  40'b0000000000000000000001000011001100100001; //  X X X X X 4 3 3 2 1
         10'b0101101011: fwd_datapath_o =  40'b0000000000000000001100100010000100000000; //  X X X X 3 2 2 1 0 0
         10'b0101101100: fwd_datapath_o =  40'b0000000000000000000001000011001100100010; //  X X X X X 4 3 3 2 2
         10'b0101101101: fwd_datapath_o =  40'b0000000000000000001100100010000100010000; //  X X X X 3 2 2 1 1 0
         10'b0101101110: fwd_datapath_o =  40'b0000000000000000001100100010000100010001; //  X X X X 3 2 2 1 1 1
         10'b0101101111: fwd_datapath_o =  40'b0000000000000010000100010000000000000000; //  X X X 2 1 1 0 0 0 0
         10'b0101110000: fwd_datapath_o =  40'b0000000000000000000000000101010001000100; //  X X X X X X 5 4 4 4
         10'b0101110001: fwd_datapath_o =  40'b0000000000000000000001000011001100110000; //  X X X X X 4 3 3 3 0
         10'b0101110010: fwd_datapath_o =  40'b0000000000000000000001000011001100110001; //  X X X X X 4 3 3 3 1
         10'b0101110011: fwd_datapath_o =  40'b0000000000000000001100100010001000000000; //  X X X X 3 2 2 2 0 0
         10'b0101110100: fwd_datapath_o =  40'b0000000000000000000001000011001100110010; //  X X X X X 4 3 3 3 2
         10'b0101110101: fwd_datapath_o =  40'b0000000000000000001100100010001000010000; //  X X X X 3 2 2 2 1 0
         10'b0101110110: fwd_datapath_o =  40'b0000000000000000001100100010001000010001; //  X X X X 3 2 2 2 1 1
         10'b0101110111: fwd_datapath_o =  40'b0000000000000010000100010001000000000000; //  X X X 2 1 1 1 0 0 0
         10'b0101111000: fwd_datapath_o =  40'b0000000000000000000001000011001100110011; //  X X X X X 4 3 3 3 3
         10'b0101111001: fwd_datapath_o =  40'b0000000000000000001100100010001000100000; //  X X X X 3 2 2 2 2 0
         10'b0101111010: fwd_datapath_o =  40'b0000000000000000001100100010001000100001; //  X X X X 3 2 2 2 2 1
         10'b0101111011: fwd_datapath_o =  40'b0000000000000010000100010001000100000000; //  X X X 2 1 1 1 1 0 0
         10'b0101111100: fwd_datapath_o =  40'b0000000000000000001100100010001000100010; //  X X X X 3 2 2 2 2 2
         10'b0101111101: fwd_datapath_o =  40'b0000000000000010000100010001000100010000; //  X X X 2 1 1 1 1 1 0
         10'b0101111110: fwd_datapath_o =  40'b0000000000000010000100010001000100010001; //  X X X 2 1 1 1 1 1 1
         10'b0101111111: fwd_datapath_o =  40'b0000000000010000000000000000000000000000; //  X X 1 0 0 0 0 0 0 0
         10'b0110000000: fwd_datapath_o =  40'b0000000000000000000000000000000001110111; //  X X X X X X X X 7 7
         10'b0110000001: fwd_datapath_o =  40'b0000000000000000000000000000011001100000; //  X X X X X X X 6 6 0
         10'b0110000010: fwd_datapath_o =  40'b0000000000000000000000000000011001100001; //  X X X X X X X 6 6 1
         10'b0110000011: fwd_datapath_o =  40'b0000000000000000000000000101010100000000; //  X X X X X X 5 5 0 0
         10'b0110000100: fwd_datapath_o =  40'b0000000000000000000000000000011001100010; //  X X X X X X X 6 6 2
         10'b0110000101: fwd_datapath_o =  40'b0000000000000000000000000101010100010000; //  X X X X X X 5 5 1 0
         10'b0110000110: fwd_datapath_o =  40'b0000000000000000000000000101010100010001; //  X X X X X X 5 5 1 1
         10'b0110000111: fwd_datapath_o =  40'b0000000000000000000001000100000000000000; //  X X X X X 4 4 0 0 0
         10'b0110001000: fwd_datapath_o =  40'b0000000000000000000000000000011001100011; //  X X X X X X X 6 6 3
         10'b0110001001: fwd_datapath_o =  40'b0000000000000000000000000101010100100000; //  X X X X X X 5 5 2 0
         10'b0110001010: fwd_datapath_o =  40'b0000000000000000000000000101010100100001; //  X X X X X X 5 5 2 1
         10'b0110001011: fwd_datapath_o =  40'b0000000000000000000001000100000100000000; //  X X X X X 4 4 1 0 0
         10'b0110001100: fwd_datapath_o =  40'b0000000000000000000000000101010100100010; //  X X X X X X 5 5 2 2
         10'b0110001101: fwd_datapath_o =  40'b0000000000000000000001000100000100010000; //  X X X X X 4 4 1 1 0
         10'b0110001110: fwd_datapath_o =  40'b0000000000000000000001000100000100010001; //  X X X X X 4 4 1 1 1
         10'b0110001111: fwd_datapath_o =  40'b0000000000000000001100110000000000000000; //  X X X X 3 3 0 0 0 0
         10'b0110010000: fwd_datapath_o =  40'b0000000000000000000000000000011001100100; //  X X X X X X X 6 6 4
         10'b0110010001: fwd_datapath_o =  40'b0000000000000000000000000101010100110000; //  X X X X X X 5 5 3 0
         10'b0110010010: fwd_datapath_o =  40'b0000000000000000000000000101010100110001; //  X X X X X X 5 5 3 1
         10'b0110010011: fwd_datapath_o =  40'b0000000000000000000001000100001000000000; //  X X X X X 4 4 2 0 0
         10'b0110010100: fwd_datapath_o =  40'b0000000000000000000000000101010100110010; //  X X X X X X 5 5 3 2
         10'b0110010101: fwd_datapath_o =  40'b0000000000000000000001000100001000010000; //  X X X X X 4 4 2 1 0
         10'b0110010110: fwd_datapath_o =  40'b0000000000000000000001000100001000010001; //  X X X X X 4 4 2 1 1
         10'b0110010111: fwd_datapath_o =  40'b0000000000000000001100110001000000000000; //  X X X X 3 3 1 0 0 0
         10'b0110011000: fwd_datapath_o =  40'b0000000000000000000000000101010100110011; //  X X X X X X 5 5 3 3
         10'b0110011001: fwd_datapath_o =  40'b0000000000000000000001000100001000100000; //  X X X X X 4 4 2 2 0
         10'b0110011010: fwd_datapath_o =  40'b0000000000000000000001000100001000100001; //  X X X X X 4 4 2 2 1
         10'b0110011011: fwd_datapath_o =  40'b0000000000000000001100110001000100000000; //  X X X X 3 3 1 1 0 0
         10'b0110011100: fwd_datapath_o =  40'b0000000000000000000001000100001000100010; //  X X X X X 4 4 2 2 2
         10'b0110011101: fwd_datapath_o =  40'b0000000000000000001100110001000100010000; //  X X X X 3 3 1 1 1 0
         10'b0110011110: fwd_datapath_o =  40'b0000000000000000001100110001000100010001; //  X X X X 3 3 1 1 1 1
         10'b0110011111: fwd_datapath_o =  40'b0000000000000010001000000000000000000000; //  X X X 2 2 0 0 0 0 0
         10'b0110100000: fwd_datapath_o =  40'b0000000000000000000000000000011001100101; //  X X X X X X X 6 6 5
         10'b0110100001: fwd_datapath_o =  40'b0000000000000000000000000101010101000000; //  X X X X X X 5 5 4 0
         10'b0110100010: fwd_datapath_o =  40'b0000000000000000000000000101010101000001; //  X X X X X X 5 5 4 1
         10'b0110100011: fwd_datapath_o =  40'b0000000000000000000001000100001100000000; //  X X X X X 4 4 3 0 0
         10'b0110100100: fwd_datapath_o =  40'b0000000000000000000000000101010101000010; //  X X X X X X 5 5 4 2
         10'b0110100101: fwd_datapath_o =  40'b0000000000000000000001000100001100010000; //  X X X X X 4 4 3 1 0
         10'b0110100110: fwd_datapath_o =  40'b0000000000000000000001000100001100010001; //  X X X X X 4 4 3 1 1
         10'b0110100111: fwd_datapath_o =  40'b0000000000000000001100110010000000000000; //  X X X X 3 3 2 0 0 0
         10'b0110101000: fwd_datapath_o =  40'b0000000000000000000000000101010101000011; //  X X X X X X 5 5 4 3
         10'b0110101001: fwd_datapath_o =  40'b0000000000000000000001000100001100100000; //  X X X X X 4 4 3 2 0
         10'b0110101010: fwd_datapath_o =  40'b0000000000000000000001000100001100100001; //  X X X X X 4 4 3 2 1
         10'b0110101011: fwd_datapath_o =  40'b0000000000000000001100110010000100000000; //  X X X X 3 3 2 1 0 0
         10'b0110101100: fwd_datapath_o =  40'b0000000000000000000001000100001100100010; //  X X X X X 4 4 3 2 2
         10'b0110101101: fwd_datapath_o =  40'b0000000000000000001100110010000100010000; //  X X X X 3 3 2 1 1 0
         10'b0110101110: fwd_datapath_o =  40'b0000000000000000001100110010000100010001; //  X X X X 3 3 2 1 1 1
         10'b0110101111: fwd_datapath_o =  40'b0000000000000010001000010000000000000000; //  X X X 2 2 1 0 0 0 0
         10'b0110110000: fwd_datapath_o =  40'b0000000000000000000000000101010101000100; //  X X X X X X 5 5 4 4
         10'b0110110001: fwd_datapath_o =  40'b0000000000000000000001000100001100110000; //  X X X X X 4 4 3 3 0
         10'b0110110010: fwd_datapath_o =  40'b0000000000000000000001000100001100110001; //  X X X X X 4 4 3 3 1
         10'b0110110011: fwd_datapath_o =  40'b0000000000000000001100110010001000000000; //  X X X X 3 3 2 2 0 0
         10'b0110110100: fwd_datapath_o =  40'b0000000000000000000001000100001100110010; //  X X X X X 4 4 3 3 2
         10'b0110110101: fwd_datapath_o =  40'b0000000000000000001100110010001000010000; //  X X X X 3 3 2 2 1 0
         10'b0110110110: fwd_datapath_o =  40'b0000000000000000001100110010001000010001; //  X X X X 3 3 2 2 1 1
         10'b0110110111: fwd_datapath_o =  40'b0000000000000010001000010001000000000000; //  X X X 2 2 1 1 0 0 0
         10'b0110111000: fwd_datapath_o =  40'b0000000000000000000001000100001100110011; //  X X X X X 4 4 3 3 3
         10'b0110111001: fwd_datapath_o =  40'b0000000000000000001100110010001000100000; //  X X X X 3 3 2 2 2 0
         10'b0110111010: fwd_datapath_o =  40'b0000000000000000001100110010001000100001; //  X X X X 3 3 2 2 2 1
         10'b0110111011: fwd_datapath_o =  40'b0000000000000010001000010001000100000000; //  X X X 2 2 1 1 1 0 0
         10'b0110111100: fwd_datapath_o =  40'b0000000000000000001100110010001000100010; //  X X X X 3 3 2 2 2 2
         10'b0110111101: fwd_datapath_o =  40'b0000000000000010001000010001000100010000; //  X X X 2 2 1 1 1 1 0
         10'b0110111110: fwd_datapath_o =  40'b0000000000000010001000010001000100010001; //  X X X 2 2 1 1 1 1 1
         10'b0110111111: fwd_datapath_o =  40'b0000000000010001000000000000000000000000; //  X X 1 1 0 0 0 0 0 0
         10'b0111000000: fwd_datapath_o =  40'b0000000000000000000000000000011001100110; //  X X X X X X X 6 6 6
         10'b0111000001: fwd_datapath_o =  40'b0000000000000000000000000101010101010000; //  X X X X X X 5 5 5 0
         10'b0111000010: fwd_datapath_o =  40'b0000000000000000000000000101010101010001; //  X X X X X X 5 5 5 1
         10'b0111000011: fwd_datapath_o =  40'b0000000000000000000001000100010000000000; //  X X X X X 4 4 4 0 0
         10'b0111000100: fwd_datapath_o =  40'b0000000000000000000000000101010101010010; //  X X X X X X 5 5 5 2
         10'b0111000101: fwd_datapath_o =  40'b0000000000000000000001000100010000010000; //  X X X X X 4 4 4 1 0
         10'b0111000110: fwd_datapath_o =  40'b0000000000000000000001000100010000010001; //  X X X X X 4 4 4 1 1
         10'b0111000111: fwd_datapath_o =  40'b0000000000000000001100110011000000000000; //  X X X X 3 3 3 0 0 0
         10'b0111001000: fwd_datapath_o =  40'b0000000000000000000000000101010101010011; //  X X X X X X 5 5 5 3
         10'b0111001001: fwd_datapath_o =  40'b0000000000000000000001000100010000100000; //  X X X X X 4 4 4 2 0
         10'b0111001010: fwd_datapath_o =  40'b0000000000000000000001000100010000100001; //  X X X X X 4 4 4 2 1
         10'b0111001011: fwd_datapath_o =  40'b0000000000000000001100110011000100000000; //  X X X X 3 3 3 1 0 0
         10'b0111001100: fwd_datapath_o =  40'b0000000000000000000001000100010000100010; //  X X X X X 4 4 4 2 2
         10'b0111001101: fwd_datapath_o =  40'b0000000000000000001100110011000100010000; //  X X X X 3 3 3 1 1 0
         10'b0111001110: fwd_datapath_o =  40'b0000000000000000001100110011000100010001; //  X X X X 3 3 3 1 1 1
         10'b0111001111: fwd_datapath_o =  40'b0000000000000010001000100000000000000000; //  X X X 2 2 2 0 0 0 0
         10'b0111010000: fwd_datapath_o =  40'b0000000000000000000000000101010101010100; //  X X X X X X 5 5 5 4
         10'b0111010001: fwd_datapath_o =  40'b0000000000000000000001000100010000110000; //  X X X X X 4 4 4 3 0
         10'b0111010010: fwd_datapath_o =  40'b0000000000000000000001000100010000110001; //  X X X X X 4 4 4 3 1
         10'b0111010011: fwd_datapath_o =  40'b0000000000000000001100110011001000000000; //  X X X X 3 3 3 2 0 0
         10'b0111010100: fwd_datapath_o =  40'b0000000000000000000001000100010000110010; //  X X X X X 4 4 4 3 2
         10'b0111010101: fwd_datapath_o =  40'b0000000000000000001100110011001000010000; //  X X X X 3 3 3 2 1 0
         10'b0111010110: fwd_datapath_o =  40'b0000000000000000001100110011001000010001; //  X X X X 3 3 3 2 1 1
         10'b0111010111: fwd_datapath_o =  40'b0000000000000010001000100001000000000000; //  X X X 2 2 2 1 0 0 0
         10'b0111011000: fwd_datapath_o =  40'b0000000000000000000001000100010000110011; //  X X X X X 4 4 4 3 3
         10'b0111011001: fwd_datapath_o =  40'b0000000000000000001100110011001000100000; //  X X X X 3 3 3 2 2 0
         10'b0111011010: fwd_datapath_o =  40'b0000000000000000001100110011001000100001; //  X X X X 3 3 3 2 2 1
         10'b0111011011: fwd_datapath_o =  40'b0000000000000010001000100001000100000000; //  X X X 2 2 2 1 1 0 0
         10'b0111011100: fwd_datapath_o =  40'b0000000000000000001100110011001000100010; //  X X X X 3 3 3 2 2 2
         10'b0111011101: fwd_datapath_o =  40'b0000000000000010001000100001000100010000; //  X X X 2 2 2 1 1 1 0
         10'b0111011110: fwd_datapath_o =  40'b0000000000000010001000100001000100010001; //  X X X 2 2 2 1 1 1 1
         10'b0111011111: fwd_datapath_o =  40'b0000000000010001000100000000000000000000; //  X X 1 1 1 0 0 0 0 0
         10'b0111100000: fwd_datapath_o =  40'b0000000000000000000000000101010101010101; //  X X X X X X 5 5 5 5
         10'b0111100001: fwd_datapath_o =  40'b0000000000000000000001000100010001000000; //  X X X X X 4 4 4 4 0
         10'b0111100010: fwd_datapath_o =  40'b0000000000000000000001000100010001000001; //  X X X X X 4 4 4 4 1
         10'b0111100011: fwd_datapath_o =  40'b0000000000000000001100110011001100000000; //  X X X X 3 3 3 3 0 0
         10'b0111100100: fwd_datapath_o =  40'b0000000000000000000001000100010001000010; //  X X X X X 4 4 4 4 2
         10'b0111100101: fwd_datapath_o =  40'b0000000000000000001100110011001100010000; //  X X X X 3 3 3 3 1 0
         10'b0111100110: fwd_datapath_o =  40'b0000000000000000001100110011001100010001; //  X X X X 3 3 3 3 1 1
         10'b0111100111: fwd_datapath_o =  40'b0000000000000010001000100010000000000000; //  X X X 2 2 2 2 0 0 0
         10'b0111101000: fwd_datapath_o =  40'b0000000000000000000001000100010001000011; //  X X X X X 4 4 4 4 3
         10'b0111101001: fwd_datapath_o =  40'b0000000000000000001100110011001100100000; //  X X X X 3 3 3 3 2 0
         10'b0111101010: fwd_datapath_o =  40'b0000000000000000001100110011001100100001; //  X X X X 3 3 3 3 2 1
         10'b0111101011: fwd_datapath_o =  40'b0000000000000010001000100010000100000000; //  X X X 2 2 2 2 1 0 0
         10'b0111101100: fwd_datapath_o =  40'b0000000000000000001100110011001100100010; //  X X X X 3 3 3 3 2 2
         10'b0111101101: fwd_datapath_o =  40'b0000000000000010001000100010000100010000; //  X X X 2 2 2 2 1 1 0
         10'b0111101110: fwd_datapath_o =  40'b0000000000000010001000100010000100010001; //  X X X 2 2 2 2 1 1 1
         10'b0111101111: fwd_datapath_o =  40'b0000000000010001000100010000000000000000; //  X X 1 1 1 1 0 0 0 0
         10'b0111110000: fwd_datapath_o =  40'b0000000000000000000001000100010001000100; //  X X X X X 4 4 4 4 4
         10'b0111110001: fwd_datapath_o =  40'b0000000000000000001100110011001100110000; //  X X X X 3 3 3 3 3 0
         10'b0111110010: fwd_datapath_o =  40'b0000000000000000001100110011001100110001; //  X X X X 3 3 3 3 3 1
         10'b0111110011: fwd_datapath_o =  40'b0000000000000010001000100010001000000000; //  X X X 2 2 2 2 2 0 0
         10'b0111110100: fwd_datapath_o =  40'b0000000000000000001100110011001100110010; //  X X X X 3 3 3 3 3 2
         10'b0111110101: fwd_datapath_o =  40'b0000000000000010001000100010001000010000; //  X X X 2 2 2 2 2 1 0
         10'b0111110110: fwd_datapath_o =  40'b0000000000000010001000100010001000010001; //  X X X 2 2 2 2 2 1 1
         10'b0111110111: fwd_datapath_o =  40'b0000000000010001000100010001000000000000; //  X X 1 1 1 1 1 0 0 0
         10'b0111111000: fwd_datapath_o =  40'b0000000000000000001100110011001100110011; //  X X X X 3 3 3 3 3 3
         10'b0111111001: fwd_datapath_o =  40'b0000000000000010001000100010001000100000; //  X X X 2 2 2 2 2 2 0
         10'b0111111010: fwd_datapath_o =  40'b0000000000000010001000100010001000100001; //  X X X 2 2 2 2 2 2 1
         10'b0111111011: fwd_datapath_o =  40'b0000000000010001000100010001000100000000; //  X X 1 1 1 1 1 1 0 0
         10'b0111111100: fwd_datapath_o =  40'b0000000000000010001000100010001000100010; //  X X X 2 2 2 2 2 2 2
         10'b0111111101: fwd_datapath_o =  40'b0000000000010001000100010001000100010000; //  X X 1 1 1 1 1 1 1 0
         10'b0111111110: fwd_datapath_o =  40'b0000000000010001000100010001000100010001; //  X X 1 1 1 1 1 1 1 1
         10'b0111111111: fwd_datapath_o =  40'b0000000000000000000000000000000000000000; //  X 0 0 0 0 0 0 0 0 0
         10'b1000000000: fwd_datapath_o =  40'b0000000000000000000000000000000000001001; //  X X X X X X X X X 9
         10'b1000000001: fwd_datapath_o =  40'b0000000000000000000000000000000010000000; //  X X X X X X X X 8 0
         10'b1000000010: fwd_datapath_o =  40'b0000000000000000000000000000000010000001; //  X X X X X X X X 8 1
         10'b1000000011: fwd_datapath_o =  40'b0000000000000000000000000000011100000000; //  X X X X X X X 7 0 0
         10'b1000000100: fwd_datapath_o =  40'b0000000000000000000000000000000010000010; //  X X X X X X X X 8 2
         10'b1000000101: fwd_datapath_o =  40'b0000000000000000000000000000011100010000; //  X X X X X X X 7 1 0
         10'b1000000110: fwd_datapath_o =  40'b0000000000000000000000000000011100010001; //  X X X X X X X 7 1 1
         10'b1000000111: fwd_datapath_o =  40'b0000000000000000000000000110000000000000; //  X X X X X X 6 0 0 0
         10'b1000001000: fwd_datapath_o =  40'b0000000000000000000000000000000010000011; //  X X X X X X X X 8 3
         10'b1000001001: fwd_datapath_o =  40'b0000000000000000000000000000011100100000; //  X X X X X X X 7 2 0
         10'b1000001010: fwd_datapath_o =  40'b0000000000000000000000000000011100100001; //  X X X X X X X 7 2 1
         10'b1000001011: fwd_datapath_o =  40'b0000000000000000000000000110000100000000; //  X X X X X X 6 1 0 0
         10'b1000001100: fwd_datapath_o =  40'b0000000000000000000000000000011100100010; //  X X X X X X X 7 2 2
         10'b1000001101: fwd_datapath_o =  40'b0000000000000000000000000110000100010000; //  X X X X X X 6 1 1 0
         10'b1000001110: fwd_datapath_o =  40'b0000000000000000000000000110000100010001; //  X X X X X X 6 1 1 1
         10'b1000001111: fwd_datapath_o =  40'b0000000000000000000001010000000000000000; //  X X X X X 5 0 0 0 0
         10'b1000010000: fwd_datapath_o =  40'b0000000000000000000000000000000010000100; //  X X X X X X X X 8 4
         10'b1000010001: fwd_datapath_o =  40'b0000000000000000000000000000011100110000; //  X X X X X X X 7 3 0
         10'b1000010010: fwd_datapath_o =  40'b0000000000000000000000000000011100110001; //  X X X X X X X 7 3 1
         10'b1000010011: fwd_datapath_o =  40'b0000000000000000000000000110001000000000; //  X X X X X X 6 2 0 0
         10'b1000010100: fwd_datapath_o =  40'b0000000000000000000000000000011100110010; //  X X X X X X X 7 3 2
         10'b1000010101: fwd_datapath_o =  40'b0000000000000000000000000110001000010000; //  X X X X X X 6 2 1 0
         10'b1000010110: fwd_datapath_o =  40'b0000000000000000000000000110001000010001; //  X X X X X X 6 2 1 1
         10'b1000010111: fwd_datapath_o =  40'b0000000000000000000001010001000000000000; //  X X X X X 5 1 0 0 0
         10'b1000011000: fwd_datapath_o =  40'b0000000000000000000000000000011100110011; //  X X X X X X X 7 3 3
         10'b1000011001: fwd_datapath_o =  40'b0000000000000000000000000110001000100000; //  X X X X X X 6 2 2 0
         10'b1000011010: fwd_datapath_o =  40'b0000000000000000000000000110001000100001; //  X X X X X X 6 2 2 1
         10'b1000011011: fwd_datapath_o =  40'b0000000000000000000001010001000100000000; //  X X X X X 5 1 1 0 0
         10'b1000011100: fwd_datapath_o =  40'b0000000000000000000000000110001000100010; //  X X X X X X 6 2 2 2
         10'b1000011101: fwd_datapath_o =  40'b0000000000000000000001010001000100010000; //  X X X X X 5 1 1 1 0
         10'b1000011110: fwd_datapath_o =  40'b0000000000000000000001010001000100010001; //  X X X X X 5 1 1 1 1
         10'b1000011111: fwd_datapath_o =  40'b0000000000000000010000000000000000000000; //  X X X X 4 0 0 0 0 0
         10'b1000100000: fwd_datapath_o =  40'b0000000000000000000000000000000010000101; //  X X X X X X X X 8 5
         10'b1000100001: fwd_datapath_o =  40'b0000000000000000000000000000011101000000; //  X X X X X X X 7 4 0
         10'b1000100010: fwd_datapath_o =  40'b0000000000000000000000000000011101000001; //  X X X X X X X 7 4 1
         10'b1000100011: fwd_datapath_o =  40'b0000000000000000000000000110001100000000; //  X X X X X X 6 3 0 0
         10'b1000100100: fwd_datapath_o =  40'b0000000000000000000000000000011101000010; //  X X X X X X X 7 4 2
         10'b1000100101: fwd_datapath_o =  40'b0000000000000000000000000110001100010000; //  X X X X X X 6 3 1 0
         10'b1000100110: fwd_datapath_o =  40'b0000000000000000000000000110001100010001; //  X X X X X X 6 3 1 1
         10'b1000100111: fwd_datapath_o =  40'b0000000000000000000001010010000000000000; //  X X X X X 5 2 0 0 0
         10'b1000101000: fwd_datapath_o =  40'b0000000000000000000000000000011101000011; //  X X X X X X X 7 4 3
         10'b1000101001: fwd_datapath_o =  40'b0000000000000000000000000110001100100000; //  X X X X X X 6 3 2 0
         10'b1000101010: fwd_datapath_o =  40'b0000000000000000000000000110001100100001; //  X X X X X X 6 3 2 1
         10'b1000101011: fwd_datapath_o =  40'b0000000000000000000001010010000100000000; //  X X X X X 5 2 1 0 0
         10'b1000101100: fwd_datapath_o =  40'b0000000000000000000000000110001100100010; //  X X X X X X 6 3 2 2
         10'b1000101101: fwd_datapath_o =  40'b0000000000000000000001010010000100010000; //  X X X X X 5 2 1 1 0
         10'b1000101110: fwd_datapath_o =  40'b0000000000000000000001010010000100010001; //  X X X X X 5 2 1 1 1
         10'b1000101111: fwd_datapath_o =  40'b0000000000000000010000010000000000000000; //  X X X X 4 1 0 0 0 0
         10'b1000110000: fwd_datapath_o =  40'b0000000000000000000000000000011101000100; //  X X X X X X X 7 4 4
         10'b1000110001: fwd_datapath_o =  40'b0000000000000000000000000110001100110000; //  X X X X X X 6 3 3 0
         10'b1000110010: fwd_datapath_o =  40'b0000000000000000000000000110001100110001; //  X X X X X X 6 3 3 1
         10'b1000110011: fwd_datapath_o =  40'b0000000000000000000001010010001000000000; //  X X X X X 5 2 2 0 0
         10'b1000110100: fwd_datapath_o =  40'b0000000000000000000000000110001100110010; //  X X X X X X 6 3 3 2
         10'b1000110101: fwd_datapath_o =  40'b0000000000000000000001010010001000010000; //  X X X X X 5 2 2 1 0
         10'b1000110110: fwd_datapath_o =  40'b0000000000000000000001010010001000010001; //  X X X X X 5 2 2 1 1
         10'b1000110111: fwd_datapath_o =  40'b0000000000000000010000010001000000000000; //  X X X X 4 1 1 0 0 0
         10'b1000111000: fwd_datapath_o =  40'b0000000000000000000000000110001100110011; //  X X X X X X 6 3 3 3
         10'b1000111001: fwd_datapath_o =  40'b0000000000000000000001010010001000100000; //  X X X X X 5 2 2 2 0
         10'b1000111010: fwd_datapath_o =  40'b0000000000000000000001010010001000100001; //  X X X X X 5 2 2 2 1
         10'b1000111011: fwd_datapath_o =  40'b0000000000000000010000010001000100000000; //  X X X X 4 1 1 1 0 0
         10'b1000111100: fwd_datapath_o =  40'b0000000000000000000001010010001000100010; //  X X X X X 5 2 2 2 2
         10'b1000111101: fwd_datapath_o =  40'b0000000000000000010000010001000100010000; //  X X X X 4 1 1 1 1 0
         10'b1000111110: fwd_datapath_o =  40'b0000000000000000010000010001000100010001; //  X X X X 4 1 1 1 1 1
         10'b1000111111: fwd_datapath_o =  40'b0000000000000011000000000000000000000000; //  X X X 3 0 0 0 0 0 0
         10'b1001000000: fwd_datapath_o =  40'b0000000000000000000000000000000010000110; //  X X X X X X X X 8 6
         10'b1001000001: fwd_datapath_o =  40'b0000000000000000000000000000011101010000; //  X X X X X X X 7 5 0
         10'b1001000010: fwd_datapath_o =  40'b0000000000000000000000000000011101010001; //  X X X X X X X 7 5 1
         10'b1001000011: fwd_datapath_o =  40'b0000000000000000000000000110010000000000; //  X X X X X X 6 4 0 0
         10'b1001000100: fwd_datapath_o =  40'b0000000000000000000000000000011101010010; //  X X X X X X X 7 5 2
         10'b1001000101: fwd_datapath_o =  40'b0000000000000000000000000110010000010000; //  X X X X X X 6 4 1 0
         10'b1001000110: fwd_datapath_o =  40'b0000000000000000000000000110010000010001; //  X X X X X X 6 4 1 1
         10'b1001000111: fwd_datapath_o =  40'b0000000000000000000001010011000000000000; //  X X X X X 5 3 0 0 0
         10'b1001001000: fwd_datapath_o =  40'b0000000000000000000000000000011101010011; //  X X X X X X X 7 5 3
         10'b1001001001: fwd_datapath_o =  40'b0000000000000000000000000110010000100000; //  X X X X X X 6 4 2 0
         10'b1001001010: fwd_datapath_o =  40'b0000000000000000000000000110010000100001; //  X X X X X X 6 4 2 1
         10'b1001001011: fwd_datapath_o =  40'b0000000000000000000001010011000100000000; //  X X X X X 5 3 1 0 0
         10'b1001001100: fwd_datapath_o =  40'b0000000000000000000000000110010000100010; //  X X X X X X 6 4 2 2
         10'b1001001101: fwd_datapath_o =  40'b0000000000000000000001010011000100010000; //  X X X X X 5 3 1 1 0
         10'b1001001110: fwd_datapath_o =  40'b0000000000000000000001010011000100010001; //  X X X X X 5 3 1 1 1
         10'b1001001111: fwd_datapath_o =  40'b0000000000000000010000100000000000000000; //  X X X X 4 2 0 0 0 0
         10'b1001010000: fwd_datapath_o =  40'b0000000000000000000000000000011101010100; //  X X X X X X X 7 5 4
         10'b1001010001: fwd_datapath_o =  40'b0000000000000000000000000110010000110000; //  X X X X X X 6 4 3 0
         10'b1001010010: fwd_datapath_o =  40'b0000000000000000000000000110010000110001; //  X X X X X X 6 4 3 1
         10'b1001010011: fwd_datapath_o =  40'b0000000000000000000001010011001000000000; //  X X X X X 5 3 2 0 0
         10'b1001010100: fwd_datapath_o =  40'b0000000000000000000000000110010000110010; //  X X X X X X 6 4 3 2
         10'b1001010101: fwd_datapath_o =  40'b0000000000000000000001010011001000010000; //  X X X X X 5 3 2 1 0
         10'b1001010110: fwd_datapath_o =  40'b0000000000000000000001010011001000010001; //  X X X X X 5 3 2 1 1
         10'b1001010111: fwd_datapath_o =  40'b0000000000000000010000100001000000000000; //  X X X X 4 2 1 0 0 0
         10'b1001011000: fwd_datapath_o =  40'b0000000000000000000000000110010000110011; //  X X X X X X 6 4 3 3
         10'b1001011001: fwd_datapath_o =  40'b0000000000000000000001010011001000100000; //  X X X X X 5 3 2 2 0
         10'b1001011010: fwd_datapath_o =  40'b0000000000000000000001010011001000100001; //  X X X X X 5 3 2 2 1
         10'b1001011011: fwd_datapath_o =  40'b0000000000000000010000100001000100000000; //  X X X X 4 2 1 1 0 0
         10'b1001011100: fwd_datapath_o =  40'b0000000000000000000001010011001000100010; //  X X X X X 5 3 2 2 2
         10'b1001011101: fwd_datapath_o =  40'b0000000000000000010000100001000100010000; //  X X X X 4 2 1 1 1 0
         10'b1001011110: fwd_datapath_o =  40'b0000000000000000010000100001000100010001; //  X X X X 4 2 1 1 1 1
         10'b1001011111: fwd_datapath_o =  40'b0000000000000011000100000000000000000000; //  X X X 3 1 0 0 0 0 0
         10'b1001100000: fwd_datapath_o =  40'b0000000000000000000000000000011101010101; //  X X X X X X X 7 5 5
         10'b1001100001: fwd_datapath_o =  40'b0000000000000000000000000110010001000000; //  X X X X X X 6 4 4 0
         10'b1001100010: fwd_datapath_o =  40'b0000000000000000000000000110010001000001; //  X X X X X X 6 4 4 1
         10'b1001100011: fwd_datapath_o =  40'b0000000000000000000001010011001100000000; //  X X X X X 5 3 3 0 0
         10'b1001100100: fwd_datapath_o =  40'b0000000000000000000000000110010001000010; //  X X X X X X 6 4 4 2
         10'b1001100101: fwd_datapath_o =  40'b0000000000000000000001010011001100010000; //  X X X X X 5 3 3 1 0
         10'b1001100110: fwd_datapath_o =  40'b0000000000000000000001010011001100010001; //  X X X X X 5 3 3 1 1
         10'b1001100111: fwd_datapath_o =  40'b0000000000000000010000100010000000000000; //  X X X X 4 2 2 0 0 0
         10'b1001101000: fwd_datapath_o =  40'b0000000000000000000000000110010001000011; //  X X X X X X 6 4 4 3
         10'b1001101001: fwd_datapath_o =  40'b0000000000000000000001010011001100100000; //  X X X X X 5 3 3 2 0
         10'b1001101010: fwd_datapath_o =  40'b0000000000000000000001010011001100100001; //  X X X X X 5 3 3 2 1
         10'b1001101011: fwd_datapath_o =  40'b0000000000000000010000100010000100000000; //  X X X X 4 2 2 1 0 0
         10'b1001101100: fwd_datapath_o =  40'b0000000000000000000001010011001100100010; //  X X X X X 5 3 3 2 2
         10'b1001101101: fwd_datapath_o =  40'b0000000000000000010000100010000100010000; //  X X X X 4 2 2 1 1 0
         10'b1001101110: fwd_datapath_o =  40'b0000000000000000010000100010000100010001; //  X X X X 4 2 2 1 1 1
         10'b1001101111: fwd_datapath_o =  40'b0000000000000011000100010000000000000000; //  X X X 3 1 1 0 0 0 0
         10'b1001110000: fwd_datapath_o =  40'b0000000000000000000000000110010001000100; //  X X X X X X 6 4 4 4
         10'b1001110001: fwd_datapath_o =  40'b0000000000000000000001010011001100110000; //  X X X X X 5 3 3 3 0
         10'b1001110010: fwd_datapath_o =  40'b0000000000000000000001010011001100110001; //  X X X X X 5 3 3 3 1
         10'b1001110011: fwd_datapath_o =  40'b0000000000000000010000100010001000000000; //  X X X X 4 2 2 2 0 0
         10'b1001110100: fwd_datapath_o =  40'b0000000000000000000001010011001100110010; //  X X X X X 5 3 3 3 2
         10'b1001110101: fwd_datapath_o =  40'b0000000000000000010000100010001000010000; //  X X X X 4 2 2 2 1 0
         10'b1001110110: fwd_datapath_o =  40'b0000000000000000010000100010001000010001; //  X X X X 4 2 2 2 1 1
         10'b1001110111: fwd_datapath_o =  40'b0000000000000011000100010001000000000000; //  X X X 3 1 1 1 0 0 0
         10'b1001111000: fwd_datapath_o =  40'b0000000000000000000001010011001100110011; //  X X X X X 5 3 3 3 3
         10'b1001111001: fwd_datapath_o =  40'b0000000000000000010000100010001000100000; //  X X X X 4 2 2 2 2 0
         10'b1001111010: fwd_datapath_o =  40'b0000000000000000010000100010001000100001; //  X X X X 4 2 2 2 2 1
         10'b1001111011: fwd_datapath_o =  40'b0000000000000011000100010001000100000000; //  X X X 3 1 1 1 1 0 0
         10'b1001111100: fwd_datapath_o =  40'b0000000000000000010000100010001000100010; //  X X X X 4 2 2 2 2 2
         10'b1001111101: fwd_datapath_o =  40'b0000000000000011000100010001000100010000; //  X X X 3 1 1 1 1 1 0
         10'b1001111110: fwd_datapath_o =  40'b0000000000000011000100010001000100010001; //  X X X 3 1 1 1 1 1 1
         10'b1001111111: fwd_datapath_o =  40'b0000000000100000000000000000000000000000; //  X X 2 0 0 0 0 0 0 0
         10'b1010000000: fwd_datapath_o =  40'b0000000000000000000000000000000010000111; //  X X X X X X X X 8 7
         10'b1010000001: fwd_datapath_o =  40'b0000000000000000000000000000011101100000; //  X X X X X X X 7 6 0
         10'b1010000010: fwd_datapath_o =  40'b0000000000000000000000000000011101100001; //  X X X X X X X 7 6 1
         10'b1010000011: fwd_datapath_o =  40'b0000000000000000000000000110010100000000; //  X X X X X X 6 5 0 0
         10'b1010000100: fwd_datapath_o =  40'b0000000000000000000000000000011101100010; //  X X X X X X X 7 6 2
         10'b1010000101: fwd_datapath_o =  40'b0000000000000000000000000110010100010000; //  X X X X X X 6 5 1 0
         10'b1010000110: fwd_datapath_o =  40'b0000000000000000000000000110010100010001; //  X X X X X X 6 5 1 1
         10'b1010000111: fwd_datapath_o =  40'b0000000000000000000001010100000000000000; //  X X X X X 5 4 0 0 0
         10'b1010001000: fwd_datapath_o =  40'b0000000000000000000000000000011101100011; //  X X X X X X X 7 6 3
         10'b1010001001: fwd_datapath_o =  40'b0000000000000000000000000110010100100000; //  X X X X X X 6 5 2 0
         10'b1010001010: fwd_datapath_o =  40'b0000000000000000000000000110010100100001; //  X X X X X X 6 5 2 1
         10'b1010001011: fwd_datapath_o =  40'b0000000000000000000001010100000100000000; //  X X X X X 5 4 1 0 0
         10'b1010001100: fwd_datapath_o =  40'b0000000000000000000000000110010100100010; //  X X X X X X 6 5 2 2
         10'b1010001101: fwd_datapath_o =  40'b0000000000000000000001010100000100010000; //  X X X X X 5 4 1 1 0
         10'b1010001110: fwd_datapath_o =  40'b0000000000000000000001010100000100010001; //  X X X X X 5 4 1 1 1
         10'b1010001111: fwd_datapath_o =  40'b0000000000000000010000110000000000000000; //  X X X X 4 3 0 0 0 0
         10'b1010010000: fwd_datapath_o =  40'b0000000000000000000000000000011101100100; //  X X X X X X X 7 6 4
         10'b1010010001: fwd_datapath_o =  40'b0000000000000000000000000110010100110000; //  X X X X X X 6 5 3 0
         10'b1010010010: fwd_datapath_o =  40'b0000000000000000000000000110010100110001; //  X X X X X X 6 5 3 1
         10'b1010010011: fwd_datapath_o =  40'b0000000000000000000001010100001000000000; //  X X X X X 5 4 2 0 0
         10'b1010010100: fwd_datapath_o =  40'b0000000000000000000000000110010100110010; //  X X X X X X 6 5 3 2
         10'b1010010101: fwd_datapath_o =  40'b0000000000000000000001010100001000010000; //  X X X X X 5 4 2 1 0
         10'b1010010110: fwd_datapath_o =  40'b0000000000000000000001010100001000010001; //  X X X X X 5 4 2 1 1
         10'b1010010111: fwd_datapath_o =  40'b0000000000000000010000110001000000000000; //  X X X X 4 3 1 0 0 0
         10'b1010011000: fwd_datapath_o =  40'b0000000000000000000000000110010100110011; //  X X X X X X 6 5 3 3
         10'b1010011001: fwd_datapath_o =  40'b0000000000000000000001010100001000100000; //  X X X X X 5 4 2 2 0
         10'b1010011010: fwd_datapath_o =  40'b0000000000000000000001010100001000100001; //  X X X X X 5 4 2 2 1
         10'b1010011011: fwd_datapath_o =  40'b0000000000000000010000110001000100000000; //  X X X X 4 3 1 1 0 0
         10'b1010011100: fwd_datapath_o =  40'b0000000000000000000001010100001000100010; //  X X X X X 5 4 2 2 2
         10'b1010011101: fwd_datapath_o =  40'b0000000000000000010000110001000100010000; //  X X X X 4 3 1 1 1 0
         10'b1010011110: fwd_datapath_o =  40'b0000000000000000010000110001000100010001; //  X X X X 4 3 1 1 1 1
         10'b1010011111: fwd_datapath_o =  40'b0000000000000011001000000000000000000000; //  X X X 3 2 0 0 0 0 0
         10'b1010100000: fwd_datapath_o =  40'b0000000000000000000000000000011101100101; //  X X X X X X X 7 6 5
         10'b1010100001: fwd_datapath_o =  40'b0000000000000000000000000110010101000000; //  X X X X X X 6 5 4 0
         10'b1010100010: fwd_datapath_o =  40'b0000000000000000000000000110010101000001; //  X X X X X X 6 5 4 1
         10'b1010100011: fwd_datapath_o =  40'b0000000000000000000001010100001100000000; //  X X X X X 5 4 3 0 0
         10'b1010100100: fwd_datapath_o =  40'b0000000000000000000000000110010101000010; //  X X X X X X 6 5 4 2
         10'b1010100101: fwd_datapath_o =  40'b0000000000000000000001010100001100010000; //  X X X X X 5 4 3 1 0
         10'b1010100110: fwd_datapath_o =  40'b0000000000000000000001010100001100010001; //  X X X X X 5 4 3 1 1
         10'b1010100111: fwd_datapath_o =  40'b0000000000000000010000110010000000000000; //  X X X X 4 3 2 0 0 0
         10'b1010101000: fwd_datapath_o =  40'b0000000000000000000000000110010101000011; //  X X X X X X 6 5 4 3
         10'b1010101001: fwd_datapath_o =  40'b0000000000000000000001010100001100100000; //  X X X X X 5 4 3 2 0
         10'b1010101010: fwd_datapath_o =  40'b0000000000000000000001010100001100100001; //  X X X X X 5 4 3 2 1
         10'b1010101011: fwd_datapath_o =  40'b0000000000000000010000110010000100000000; //  X X X X 4 3 2 1 0 0
         10'b1010101100: fwd_datapath_o =  40'b0000000000000000000001010100001100100010; //  X X X X X 5 4 3 2 2
         10'b1010101101: fwd_datapath_o =  40'b0000000000000000010000110010000100010000; //  X X X X 4 3 2 1 1 0
         10'b1010101110: fwd_datapath_o =  40'b0000000000000000010000110010000100010001; //  X X X X 4 3 2 1 1 1
         10'b1010101111: fwd_datapath_o =  40'b0000000000000011001000010000000000000000; //  X X X 3 2 1 0 0 0 0
         10'b1010110000: fwd_datapath_o =  40'b0000000000000000000000000110010101000100; //  X X X X X X 6 5 4 4
         10'b1010110001: fwd_datapath_o =  40'b0000000000000000000001010100001100110000; //  X X X X X 5 4 3 3 0
         10'b1010110010: fwd_datapath_o =  40'b0000000000000000000001010100001100110001; //  X X X X X 5 4 3 3 1
         10'b1010110011: fwd_datapath_o =  40'b0000000000000000010000110010001000000000; //  X X X X 4 3 2 2 0 0
         10'b1010110100: fwd_datapath_o =  40'b0000000000000000000001010100001100110010; //  X X X X X 5 4 3 3 2
         10'b1010110101: fwd_datapath_o =  40'b0000000000000000010000110010001000010000; //  X X X X 4 3 2 2 1 0
         10'b1010110110: fwd_datapath_o =  40'b0000000000000000010000110010001000010001; //  X X X X 4 3 2 2 1 1
         10'b1010110111: fwd_datapath_o =  40'b0000000000000011001000010001000000000000; //  X X X 3 2 1 1 0 0 0
         10'b1010111000: fwd_datapath_o =  40'b0000000000000000000001010100001100110011; //  X X X X X 5 4 3 3 3
         10'b1010111001: fwd_datapath_o =  40'b0000000000000000010000110010001000100000; //  X X X X 4 3 2 2 2 0
         10'b1010111010: fwd_datapath_o =  40'b0000000000000000010000110010001000100001; //  X X X X 4 3 2 2 2 1
         10'b1010111011: fwd_datapath_o =  40'b0000000000000011001000010001000100000000; //  X X X 3 2 1 1 1 0 0
         10'b1010111100: fwd_datapath_o =  40'b0000000000000000010000110010001000100010; //  X X X X 4 3 2 2 2 2
         10'b1010111101: fwd_datapath_o =  40'b0000000000000011001000010001000100010000; //  X X X 3 2 1 1 1 1 0
         10'b1010111110: fwd_datapath_o =  40'b0000000000000011001000010001000100010001; //  X X X 3 2 1 1 1 1 1
         10'b1010111111: fwd_datapath_o =  40'b0000000000100001000000000000000000000000; //  X X 2 1 0 0 0 0 0 0
         10'b1011000000: fwd_datapath_o =  40'b0000000000000000000000000000011101100110; //  X X X X X X X 7 6 6
         10'b1011000001: fwd_datapath_o =  40'b0000000000000000000000000110010101010000; //  X X X X X X 6 5 5 0
         10'b1011000010: fwd_datapath_o =  40'b0000000000000000000000000110010101010001; //  X X X X X X 6 5 5 1
         10'b1011000011: fwd_datapath_o =  40'b0000000000000000000001010100010000000000; //  X X X X X 5 4 4 0 0
         10'b1011000100: fwd_datapath_o =  40'b0000000000000000000000000110010101010010; //  X X X X X X 6 5 5 2
         10'b1011000101: fwd_datapath_o =  40'b0000000000000000000001010100010000010000; //  X X X X X 5 4 4 1 0
         10'b1011000110: fwd_datapath_o =  40'b0000000000000000000001010100010000010001; //  X X X X X 5 4 4 1 1
         10'b1011000111: fwd_datapath_o =  40'b0000000000000000010000110011000000000000; //  X X X X 4 3 3 0 0 0
         10'b1011001000: fwd_datapath_o =  40'b0000000000000000000000000110010101010011; //  X X X X X X 6 5 5 3
         10'b1011001001: fwd_datapath_o =  40'b0000000000000000000001010100010000100000; //  X X X X X 5 4 4 2 0
         10'b1011001010: fwd_datapath_o =  40'b0000000000000000000001010100010000100001; //  X X X X X 5 4 4 2 1
         10'b1011001011: fwd_datapath_o =  40'b0000000000000000010000110011000100000000; //  X X X X 4 3 3 1 0 0
         10'b1011001100: fwd_datapath_o =  40'b0000000000000000000001010100010000100010; //  X X X X X 5 4 4 2 2
         10'b1011001101: fwd_datapath_o =  40'b0000000000000000010000110011000100010000; //  X X X X 4 3 3 1 1 0
         10'b1011001110: fwd_datapath_o =  40'b0000000000000000010000110011000100010001; //  X X X X 4 3 3 1 1 1
         10'b1011001111: fwd_datapath_o =  40'b0000000000000011001000100000000000000000; //  X X X 3 2 2 0 0 0 0
         10'b1011010000: fwd_datapath_o =  40'b0000000000000000000000000110010101010100; //  X X X X X X 6 5 5 4
         10'b1011010001: fwd_datapath_o =  40'b0000000000000000000001010100010000110000; //  X X X X X 5 4 4 3 0
         10'b1011010010: fwd_datapath_o =  40'b0000000000000000000001010100010000110001; //  X X X X X 5 4 4 3 1
         10'b1011010011: fwd_datapath_o =  40'b0000000000000000010000110011001000000000; //  X X X X 4 3 3 2 0 0
         10'b1011010100: fwd_datapath_o =  40'b0000000000000000000001010100010000110010; //  X X X X X 5 4 4 3 2
         10'b1011010101: fwd_datapath_o =  40'b0000000000000000010000110011001000010000; //  X X X X 4 3 3 2 1 0
         10'b1011010110: fwd_datapath_o =  40'b0000000000000000010000110011001000010001; //  X X X X 4 3 3 2 1 1
         10'b1011010111: fwd_datapath_o =  40'b0000000000000011001000100001000000000000; //  X X X 3 2 2 1 0 0 0
         10'b1011011000: fwd_datapath_o =  40'b0000000000000000000001010100010000110011; //  X X X X X 5 4 4 3 3
         10'b1011011001: fwd_datapath_o =  40'b0000000000000000010000110011001000100000; //  X X X X 4 3 3 2 2 0
         10'b1011011010: fwd_datapath_o =  40'b0000000000000000010000110011001000100001; //  X X X X 4 3 3 2 2 1
         10'b1011011011: fwd_datapath_o =  40'b0000000000000011001000100001000100000000; //  X X X 3 2 2 1 1 0 0
         10'b1011011100: fwd_datapath_o =  40'b0000000000000000010000110011001000100010; //  X X X X 4 3 3 2 2 2
         10'b1011011101: fwd_datapath_o =  40'b0000000000000011001000100001000100010000; //  X X X 3 2 2 1 1 1 0
         10'b1011011110: fwd_datapath_o =  40'b0000000000000011001000100001000100010001; //  X X X 3 2 2 1 1 1 1
         10'b1011011111: fwd_datapath_o =  40'b0000000000100001000100000000000000000000; //  X X 2 1 1 0 0 0 0 0
         10'b1011100000: fwd_datapath_o =  40'b0000000000000000000000000110010101010101; //  X X X X X X 6 5 5 5
         10'b1011100001: fwd_datapath_o =  40'b0000000000000000000001010100010001000000; //  X X X X X 5 4 4 4 0
         10'b1011100010: fwd_datapath_o =  40'b0000000000000000000001010100010001000001; //  X X X X X 5 4 4 4 1
         10'b1011100011: fwd_datapath_o =  40'b0000000000000000010000110011001100000000; //  X X X X 4 3 3 3 0 0
         10'b1011100100: fwd_datapath_o =  40'b0000000000000000000001010100010001000010; //  X X X X X 5 4 4 4 2
         10'b1011100101: fwd_datapath_o =  40'b0000000000000000010000110011001100010000; //  X X X X 4 3 3 3 1 0
         10'b1011100110: fwd_datapath_o =  40'b0000000000000000010000110011001100010001; //  X X X X 4 3 3 3 1 1
         10'b1011100111: fwd_datapath_o =  40'b0000000000000011001000100010000000000000; //  X X X 3 2 2 2 0 0 0
         10'b1011101000: fwd_datapath_o =  40'b0000000000000000000001010100010001000011; //  X X X X X 5 4 4 4 3
         10'b1011101001: fwd_datapath_o =  40'b0000000000000000010000110011001100100000; //  X X X X 4 3 3 3 2 0
         10'b1011101010: fwd_datapath_o =  40'b0000000000000000010000110011001100100001; //  X X X X 4 3 3 3 2 1
         10'b1011101011: fwd_datapath_o =  40'b0000000000000011001000100010000100000000; //  X X X 3 2 2 2 1 0 0
         10'b1011101100: fwd_datapath_o =  40'b0000000000000000010000110011001100100010; //  X X X X 4 3 3 3 2 2
         10'b1011101101: fwd_datapath_o =  40'b0000000000000011001000100010000100010000; //  X X X 3 2 2 2 1 1 0
         10'b1011101110: fwd_datapath_o =  40'b0000000000000011001000100010000100010001; //  X X X 3 2 2 2 1 1 1
         10'b1011101111: fwd_datapath_o =  40'b0000000000100001000100010000000000000000; //  X X 2 1 1 1 0 0 0 0
         10'b1011110000: fwd_datapath_o =  40'b0000000000000000000001010100010001000100; //  X X X X X 5 4 4 4 4
         10'b1011110001: fwd_datapath_o =  40'b0000000000000000010000110011001100110000; //  X X X X 4 3 3 3 3 0
         10'b1011110010: fwd_datapath_o =  40'b0000000000000000010000110011001100110001; //  X X X X 4 3 3 3 3 1
         10'b1011110011: fwd_datapath_o =  40'b0000000000000011001000100010001000000000; //  X X X 3 2 2 2 2 0 0
         10'b1011110100: fwd_datapath_o =  40'b0000000000000000010000110011001100110010; //  X X X X 4 3 3 3 3 2
         10'b1011110101: fwd_datapath_o =  40'b0000000000000011001000100010001000010000; //  X X X 3 2 2 2 2 1 0
         10'b1011110110: fwd_datapath_o =  40'b0000000000000011001000100010001000010001; //  X X X 3 2 2 2 2 1 1
         10'b1011110111: fwd_datapath_o =  40'b0000000000100001000100010001000000000000; //  X X 2 1 1 1 1 0 0 0
         10'b1011111000: fwd_datapath_o =  40'b0000000000000000010000110011001100110011; //  X X X X 4 3 3 3 3 3
         10'b1011111001: fwd_datapath_o =  40'b0000000000000011001000100010001000100000; //  X X X 3 2 2 2 2 2 0
         10'b1011111010: fwd_datapath_o =  40'b0000000000000011001000100010001000100001; //  X X X 3 2 2 2 2 2 1
         10'b1011111011: fwd_datapath_o =  40'b0000000000100001000100010001000100000000; //  X X 2 1 1 1 1 1 0 0
         10'b1011111100: fwd_datapath_o =  40'b0000000000000011001000100010001000100010; //  X X X 3 2 2 2 2 2 2
         10'b1011111101: fwd_datapath_o =  40'b0000000000100001000100010001000100010000; //  X X 2 1 1 1 1 1 1 0
         10'b1011111110: fwd_datapath_o =  40'b0000000000100001000100010001000100010001; //  X X 2 1 1 1 1 1 1 1
         10'b1011111111: fwd_datapath_o =  40'b0000000100000000000000000000000000000000; //  X 1 0 0 0 0 0 0 0 0
         10'b1100000000: fwd_datapath_o =  40'b0000000000000000000000000000000010001000; //  X X X X X X X X 8 8
         10'b1100000001: fwd_datapath_o =  40'b0000000000000000000000000000011101110000; //  X X X X X X X 7 7 0
         10'b1100000010: fwd_datapath_o =  40'b0000000000000000000000000000011101110001; //  X X X X X X X 7 7 1
         10'b1100000011: fwd_datapath_o =  40'b0000000000000000000000000110011000000000; //  X X X X X X 6 6 0 0
         10'b1100000100: fwd_datapath_o =  40'b0000000000000000000000000000011101110010; //  X X X X X X X 7 7 2
         10'b1100000101: fwd_datapath_o =  40'b0000000000000000000000000110011000010000; //  X X X X X X 6 6 1 0
         10'b1100000110: fwd_datapath_o =  40'b0000000000000000000000000110011000010001; //  X X X X X X 6 6 1 1
         10'b1100000111: fwd_datapath_o =  40'b0000000000000000000001010101000000000000; //  X X X X X 5 5 0 0 0
         10'b1100001000: fwd_datapath_o =  40'b0000000000000000000000000000011101110011; //  X X X X X X X 7 7 3
         10'b1100001001: fwd_datapath_o =  40'b0000000000000000000000000110011000100000; //  X X X X X X 6 6 2 0
         10'b1100001010: fwd_datapath_o =  40'b0000000000000000000000000110011000100001; //  X X X X X X 6 6 2 1
         10'b1100001011: fwd_datapath_o =  40'b0000000000000000000001010101000100000000; //  X X X X X 5 5 1 0 0
         10'b1100001100: fwd_datapath_o =  40'b0000000000000000000000000110011000100010; //  X X X X X X 6 6 2 2
         10'b1100001101: fwd_datapath_o =  40'b0000000000000000000001010101000100010000; //  X X X X X 5 5 1 1 0
         10'b1100001110: fwd_datapath_o =  40'b0000000000000000000001010101000100010001; //  X X X X X 5 5 1 1 1
         10'b1100001111: fwd_datapath_o =  40'b0000000000000000010001000000000000000000; //  X X X X 4 4 0 0 0 0
         10'b1100010000: fwd_datapath_o =  40'b0000000000000000000000000000011101110100; //  X X X X X X X 7 7 4
         10'b1100010001: fwd_datapath_o =  40'b0000000000000000000000000110011000110000; //  X X X X X X 6 6 3 0
         10'b1100010010: fwd_datapath_o =  40'b0000000000000000000000000110011000110001; //  X X X X X X 6 6 3 1
         10'b1100010011: fwd_datapath_o =  40'b0000000000000000000001010101001000000000; //  X X X X X 5 5 2 0 0
         10'b1100010100: fwd_datapath_o =  40'b0000000000000000000000000110011000110010; //  X X X X X X 6 6 3 2
         10'b1100010101: fwd_datapath_o =  40'b0000000000000000000001010101001000010000; //  X X X X X 5 5 2 1 0
         10'b1100010110: fwd_datapath_o =  40'b0000000000000000000001010101001000010001; //  X X X X X 5 5 2 1 1
         10'b1100010111: fwd_datapath_o =  40'b0000000000000000010001000001000000000000; //  X X X X 4 4 1 0 0 0
         10'b1100011000: fwd_datapath_o =  40'b0000000000000000000000000110011000110011; //  X X X X X X 6 6 3 3
         10'b1100011001: fwd_datapath_o =  40'b0000000000000000000001010101001000100000; //  X X X X X 5 5 2 2 0
         10'b1100011010: fwd_datapath_o =  40'b0000000000000000000001010101001000100001; //  X X X X X 5 5 2 2 1
         10'b1100011011: fwd_datapath_o =  40'b0000000000000000010001000001000100000000; //  X X X X 4 4 1 1 0 0
         10'b1100011100: fwd_datapath_o =  40'b0000000000000000000001010101001000100010; //  X X X X X 5 5 2 2 2
         10'b1100011101: fwd_datapath_o =  40'b0000000000000000010001000001000100010000; //  X X X X 4 4 1 1 1 0
         10'b1100011110: fwd_datapath_o =  40'b0000000000000000010001000001000100010001; //  X X X X 4 4 1 1 1 1
         10'b1100011111: fwd_datapath_o =  40'b0000000000000011001100000000000000000000; //  X X X 3 3 0 0 0 0 0
         10'b1100100000: fwd_datapath_o =  40'b0000000000000000000000000000011101110101; //  X X X X X X X 7 7 5
         10'b1100100001: fwd_datapath_o =  40'b0000000000000000000000000110011001000000; //  X X X X X X 6 6 4 0
         10'b1100100010: fwd_datapath_o =  40'b0000000000000000000000000110011001000001; //  X X X X X X 6 6 4 1
         10'b1100100011: fwd_datapath_o =  40'b0000000000000000000001010101001100000000; //  X X X X X 5 5 3 0 0
         10'b1100100100: fwd_datapath_o =  40'b0000000000000000000000000110011001000010; //  X X X X X X 6 6 4 2
         10'b1100100101: fwd_datapath_o =  40'b0000000000000000000001010101001100010000; //  X X X X X 5 5 3 1 0
         10'b1100100110: fwd_datapath_o =  40'b0000000000000000000001010101001100010001; //  X X X X X 5 5 3 1 1
         10'b1100100111: fwd_datapath_o =  40'b0000000000000000010001000010000000000000; //  X X X X 4 4 2 0 0 0
         10'b1100101000: fwd_datapath_o =  40'b0000000000000000000000000110011001000011; //  X X X X X X 6 6 4 3
         10'b1100101001: fwd_datapath_o =  40'b0000000000000000000001010101001100100000; //  X X X X X 5 5 3 2 0
         10'b1100101010: fwd_datapath_o =  40'b0000000000000000000001010101001100100001; //  X X X X X 5 5 3 2 1
         10'b1100101011: fwd_datapath_o =  40'b0000000000000000010001000010000100000000; //  X X X X 4 4 2 1 0 0
         10'b1100101100: fwd_datapath_o =  40'b0000000000000000000001010101001100100010; //  X X X X X 5 5 3 2 2
         10'b1100101101: fwd_datapath_o =  40'b0000000000000000010001000010000100010000; //  X X X X 4 4 2 1 1 0
         10'b1100101110: fwd_datapath_o =  40'b0000000000000000010001000010000100010001; //  X X X X 4 4 2 1 1 1
         10'b1100101111: fwd_datapath_o =  40'b0000000000000011001100010000000000000000; //  X X X 3 3 1 0 0 0 0
         10'b1100110000: fwd_datapath_o =  40'b0000000000000000000000000110011001000100; //  X X X X X X 6 6 4 4
         10'b1100110001: fwd_datapath_o =  40'b0000000000000000000001010101001100110000; //  X X X X X 5 5 3 3 0
         10'b1100110010: fwd_datapath_o =  40'b0000000000000000000001010101001100110001; //  X X X X X 5 5 3 3 1
         10'b1100110011: fwd_datapath_o =  40'b0000000000000000010001000010001000000000; //  X X X X 4 4 2 2 0 0
         10'b1100110100: fwd_datapath_o =  40'b0000000000000000000001010101001100110010; //  X X X X X 5 5 3 3 2
         10'b1100110101: fwd_datapath_o =  40'b0000000000000000010001000010001000010000; //  X X X X 4 4 2 2 1 0
         10'b1100110110: fwd_datapath_o =  40'b0000000000000000010001000010001000010001; //  X X X X 4 4 2 2 1 1
         10'b1100110111: fwd_datapath_o =  40'b0000000000000011001100010001000000000000; //  X X X 3 3 1 1 0 0 0
         10'b1100111000: fwd_datapath_o =  40'b0000000000000000000001010101001100110011; //  X X X X X 5 5 3 3 3
         10'b1100111001: fwd_datapath_o =  40'b0000000000000000010001000010001000100000; //  X X X X 4 4 2 2 2 0
         10'b1100111010: fwd_datapath_o =  40'b0000000000000000010001000010001000100001; //  X X X X 4 4 2 2 2 1
         10'b1100111011: fwd_datapath_o =  40'b0000000000000011001100010001000100000000; //  X X X 3 3 1 1 1 0 0
         10'b1100111100: fwd_datapath_o =  40'b0000000000000000010001000010001000100010; //  X X X X 4 4 2 2 2 2
         10'b1100111101: fwd_datapath_o =  40'b0000000000000011001100010001000100010000; //  X X X 3 3 1 1 1 1 0
         10'b1100111110: fwd_datapath_o =  40'b0000000000000011001100010001000100010001; //  X X X 3 3 1 1 1 1 1
         10'b1100111111: fwd_datapath_o =  40'b0000000000100010000000000000000000000000; //  X X 2 2 0 0 0 0 0 0
         10'b1101000000: fwd_datapath_o =  40'b0000000000000000000000000000011101110110; //  X X X X X X X 7 7 6
         10'b1101000001: fwd_datapath_o =  40'b0000000000000000000000000110011001010000; //  X X X X X X 6 6 5 0
         10'b1101000010: fwd_datapath_o =  40'b0000000000000000000000000110011001010001; //  X X X X X X 6 6 5 1
         10'b1101000011: fwd_datapath_o =  40'b0000000000000000000001010101010000000000; //  X X X X X 5 5 4 0 0
         10'b1101000100: fwd_datapath_o =  40'b0000000000000000000000000110011001010010; //  X X X X X X 6 6 5 2
         10'b1101000101: fwd_datapath_o =  40'b0000000000000000000001010101010000010000; //  X X X X X 5 5 4 1 0
         10'b1101000110: fwd_datapath_o =  40'b0000000000000000000001010101010000010001; //  X X X X X 5 5 4 1 1
         10'b1101000111: fwd_datapath_o =  40'b0000000000000000010001000011000000000000; //  X X X X 4 4 3 0 0 0
         10'b1101001000: fwd_datapath_o =  40'b0000000000000000000000000110011001010011; //  X X X X X X 6 6 5 3
         10'b1101001001: fwd_datapath_o =  40'b0000000000000000000001010101010000100000; //  X X X X X 5 5 4 2 0
         10'b1101001010: fwd_datapath_o =  40'b0000000000000000000001010101010000100001; //  X X X X X 5 5 4 2 1
         10'b1101001011: fwd_datapath_o =  40'b0000000000000000010001000011000100000000; //  X X X X 4 4 3 1 0 0
         10'b1101001100: fwd_datapath_o =  40'b0000000000000000000001010101010000100010; //  X X X X X 5 5 4 2 2
         10'b1101001101: fwd_datapath_o =  40'b0000000000000000010001000011000100010000; //  X X X X 4 4 3 1 1 0
         10'b1101001110: fwd_datapath_o =  40'b0000000000000000010001000011000100010001; //  X X X X 4 4 3 1 1 1
         10'b1101001111: fwd_datapath_o =  40'b0000000000000011001100100000000000000000; //  X X X 3 3 2 0 0 0 0
         10'b1101010000: fwd_datapath_o =  40'b0000000000000000000000000110011001010100; //  X X X X X X 6 6 5 4
         10'b1101010001: fwd_datapath_o =  40'b0000000000000000000001010101010000110000; //  X X X X X 5 5 4 3 0
         10'b1101010010: fwd_datapath_o =  40'b0000000000000000000001010101010000110001; //  X X X X X 5 5 4 3 1
         10'b1101010011: fwd_datapath_o =  40'b0000000000000000010001000011001000000000; //  X X X X 4 4 3 2 0 0
         10'b1101010100: fwd_datapath_o =  40'b0000000000000000000001010101010000110010; //  X X X X X 5 5 4 3 2
         10'b1101010101: fwd_datapath_o =  40'b0000000000000000010001000011001000010000; //  X X X X 4 4 3 2 1 0
         10'b1101010110: fwd_datapath_o =  40'b0000000000000000010001000011001000010001; //  X X X X 4 4 3 2 1 1
         10'b1101010111: fwd_datapath_o =  40'b0000000000000011001100100001000000000000; //  X X X 3 3 2 1 0 0 0
         10'b1101011000: fwd_datapath_o =  40'b0000000000000000000001010101010000110011; //  X X X X X 5 5 4 3 3
         10'b1101011001: fwd_datapath_o =  40'b0000000000000000010001000011001000100000; //  X X X X 4 4 3 2 2 0
         10'b1101011010: fwd_datapath_o =  40'b0000000000000000010001000011001000100001; //  X X X X 4 4 3 2 2 1
         10'b1101011011: fwd_datapath_o =  40'b0000000000000011001100100001000100000000; //  X X X 3 3 2 1 1 0 0
         10'b1101011100: fwd_datapath_o =  40'b0000000000000000010001000011001000100010; //  X X X X 4 4 3 2 2 2
         10'b1101011101: fwd_datapath_o =  40'b0000000000000011001100100001000100010000; //  X X X 3 3 2 1 1 1 0
         10'b1101011110: fwd_datapath_o =  40'b0000000000000011001100100001000100010001; //  X X X 3 3 2 1 1 1 1
         10'b1101011111: fwd_datapath_o =  40'b0000000000100010000100000000000000000000; //  X X 2 2 1 0 0 0 0 0
         10'b1101100000: fwd_datapath_o =  40'b0000000000000000000000000110011001010101; //  X X X X X X 6 6 5 5
         10'b1101100001: fwd_datapath_o =  40'b0000000000000000000001010101010001000000; //  X X X X X 5 5 4 4 0
         10'b1101100010: fwd_datapath_o =  40'b0000000000000000000001010101010001000001; //  X X X X X 5 5 4 4 1
         10'b1101100011: fwd_datapath_o =  40'b0000000000000000010001000011001100000000; //  X X X X 4 4 3 3 0 0
         10'b1101100100: fwd_datapath_o =  40'b0000000000000000000001010101010001000010; //  X X X X X 5 5 4 4 2
         10'b1101100101: fwd_datapath_o =  40'b0000000000000000010001000011001100010000; //  X X X X 4 4 3 3 1 0
         10'b1101100110: fwd_datapath_o =  40'b0000000000000000010001000011001100010001; //  X X X X 4 4 3 3 1 1
         10'b1101100111: fwd_datapath_o =  40'b0000000000000011001100100010000000000000; //  X X X 3 3 2 2 0 0 0
         10'b1101101000: fwd_datapath_o =  40'b0000000000000000000001010101010001000011; //  X X X X X 5 5 4 4 3
         10'b1101101001: fwd_datapath_o =  40'b0000000000000000010001000011001100100000; //  X X X X 4 4 3 3 2 0
         10'b1101101010: fwd_datapath_o =  40'b0000000000000000010001000011001100100001; //  X X X X 4 4 3 3 2 1
         10'b1101101011: fwd_datapath_o =  40'b0000000000000011001100100010000100000000; //  X X X 3 3 2 2 1 0 0
         10'b1101101100: fwd_datapath_o =  40'b0000000000000000010001000011001100100010; //  X X X X 4 4 3 3 2 2
         10'b1101101101: fwd_datapath_o =  40'b0000000000000011001100100010000100010000; //  X X X 3 3 2 2 1 1 0
         10'b1101101110: fwd_datapath_o =  40'b0000000000000011001100100010000100010001; //  X X X 3 3 2 2 1 1 1
         10'b1101101111: fwd_datapath_o =  40'b0000000000100010000100010000000000000000; //  X X 2 2 1 1 0 0 0 0
         10'b1101110000: fwd_datapath_o =  40'b0000000000000000000001010101010001000100; //  X X X X X 5 5 4 4 4
         10'b1101110001: fwd_datapath_o =  40'b0000000000000000010001000011001100110000; //  X X X X 4 4 3 3 3 0
         10'b1101110010: fwd_datapath_o =  40'b0000000000000000010001000011001100110001; //  X X X X 4 4 3 3 3 1
         10'b1101110011: fwd_datapath_o =  40'b0000000000000011001100100010001000000000; //  X X X 3 3 2 2 2 0 0
         10'b1101110100: fwd_datapath_o =  40'b0000000000000000010001000011001100110010; //  X X X X 4 4 3 3 3 2
         10'b1101110101: fwd_datapath_o =  40'b0000000000000011001100100010001000010000; //  X X X 3 3 2 2 2 1 0
         10'b1101110110: fwd_datapath_o =  40'b0000000000000011001100100010001000010001; //  X X X 3 3 2 2 2 1 1
         10'b1101110111: fwd_datapath_o =  40'b0000000000100010000100010001000000000000; //  X X 2 2 1 1 1 0 0 0
         10'b1101111000: fwd_datapath_o =  40'b0000000000000000010001000011001100110011; //  X X X X 4 4 3 3 3 3
         10'b1101111001: fwd_datapath_o =  40'b0000000000000011001100100010001000100000; //  X X X 3 3 2 2 2 2 0
         10'b1101111010: fwd_datapath_o =  40'b0000000000000011001100100010001000100001; //  X X X 3 3 2 2 2 2 1
         10'b1101111011: fwd_datapath_o =  40'b0000000000100010000100010001000100000000; //  X X 2 2 1 1 1 1 0 0
         10'b1101111100: fwd_datapath_o =  40'b0000000000000011001100100010001000100010; //  X X X 3 3 2 2 2 2 2
         10'b1101111101: fwd_datapath_o =  40'b0000000000100010000100010001000100010000; //  X X 2 2 1 1 1 1 1 0
         10'b1101111110: fwd_datapath_o =  40'b0000000000100010000100010001000100010001; //  X X 2 2 1 1 1 1 1 1
         10'b1101111111: fwd_datapath_o =  40'b0000000100010000000000000000000000000000; //  X 1 1 0 0 0 0 0 0 0
         10'b1110000000: fwd_datapath_o =  40'b0000000000000000000000000000011101110111; //  X X X X X X X 7 7 7
         10'b1110000001: fwd_datapath_o =  40'b0000000000000000000000000110011001100000; //  X X X X X X 6 6 6 0
         10'b1110000010: fwd_datapath_o =  40'b0000000000000000000000000110011001100001; //  X X X X X X 6 6 6 1
         10'b1110000011: fwd_datapath_o =  40'b0000000000000000000001010101010100000000; //  X X X X X 5 5 5 0 0
         10'b1110000100: fwd_datapath_o =  40'b0000000000000000000000000110011001100010; //  X X X X X X 6 6 6 2
         10'b1110000101: fwd_datapath_o =  40'b0000000000000000000001010101010100010000; //  X X X X X 5 5 5 1 0
         10'b1110000110: fwd_datapath_o =  40'b0000000000000000000001010101010100010001; //  X X X X X 5 5 5 1 1
         10'b1110000111: fwd_datapath_o =  40'b0000000000000000010001000100000000000000; //  X X X X 4 4 4 0 0 0
         10'b1110001000: fwd_datapath_o =  40'b0000000000000000000000000110011001100011; //  X X X X X X 6 6 6 3
         10'b1110001001: fwd_datapath_o =  40'b0000000000000000000001010101010100100000; //  X X X X X 5 5 5 2 0
         10'b1110001010: fwd_datapath_o =  40'b0000000000000000000001010101010100100001; //  X X X X X 5 5 5 2 1
         10'b1110001011: fwd_datapath_o =  40'b0000000000000000010001000100000100000000; //  X X X X 4 4 4 1 0 0
         10'b1110001100: fwd_datapath_o =  40'b0000000000000000000001010101010100100010; //  X X X X X 5 5 5 2 2
         10'b1110001101: fwd_datapath_o =  40'b0000000000000000010001000100000100010000; //  X X X X 4 4 4 1 1 0
         10'b1110001110: fwd_datapath_o =  40'b0000000000000000010001000100000100010001; //  X X X X 4 4 4 1 1 1
         10'b1110001111: fwd_datapath_o =  40'b0000000000000011001100110000000000000000; //  X X X 3 3 3 0 0 0 0
         10'b1110010000: fwd_datapath_o =  40'b0000000000000000000000000110011001100100; //  X X X X X X 6 6 6 4
         10'b1110010001: fwd_datapath_o =  40'b0000000000000000000001010101010100110000; //  X X X X X 5 5 5 3 0
         10'b1110010010: fwd_datapath_o =  40'b0000000000000000000001010101010100110001; //  X X X X X 5 5 5 3 1
         10'b1110010011: fwd_datapath_o =  40'b0000000000000000010001000100001000000000; //  X X X X 4 4 4 2 0 0
         10'b1110010100: fwd_datapath_o =  40'b0000000000000000000001010101010100110010; //  X X X X X 5 5 5 3 2
         10'b1110010101: fwd_datapath_o =  40'b0000000000000000010001000100001000010000; //  X X X X 4 4 4 2 1 0
         10'b1110010110: fwd_datapath_o =  40'b0000000000000000010001000100001000010001; //  X X X X 4 4 4 2 1 1
         10'b1110010111: fwd_datapath_o =  40'b0000000000000011001100110001000000000000; //  X X X 3 3 3 1 0 0 0
         10'b1110011000: fwd_datapath_o =  40'b0000000000000000000001010101010100110011; //  X X X X X 5 5 5 3 3
         10'b1110011001: fwd_datapath_o =  40'b0000000000000000010001000100001000100000; //  X X X X 4 4 4 2 2 0
         10'b1110011010: fwd_datapath_o =  40'b0000000000000000010001000100001000100001; //  X X X X 4 4 4 2 2 1
         10'b1110011011: fwd_datapath_o =  40'b0000000000000011001100110001000100000000; //  X X X 3 3 3 1 1 0 0
         10'b1110011100: fwd_datapath_o =  40'b0000000000000000010001000100001000100010; //  X X X X 4 4 4 2 2 2
         10'b1110011101: fwd_datapath_o =  40'b0000000000000011001100110001000100010000; //  X X X 3 3 3 1 1 1 0
         10'b1110011110: fwd_datapath_o =  40'b0000000000000011001100110001000100010001; //  X X X 3 3 3 1 1 1 1
         10'b1110011111: fwd_datapath_o =  40'b0000000000100010001000000000000000000000; //  X X 2 2 2 0 0 0 0 0
         10'b1110100000: fwd_datapath_o =  40'b0000000000000000000000000110011001100101; //  X X X X X X 6 6 6 5
         10'b1110100001: fwd_datapath_o =  40'b0000000000000000000001010101010101000000; //  X X X X X 5 5 5 4 0
         10'b1110100010: fwd_datapath_o =  40'b0000000000000000000001010101010101000001; //  X X X X X 5 5 5 4 1
         10'b1110100011: fwd_datapath_o =  40'b0000000000000000010001000100001100000000; //  X X X X 4 4 4 3 0 0
         10'b1110100100: fwd_datapath_o =  40'b0000000000000000000001010101010101000010; //  X X X X X 5 5 5 4 2
         10'b1110100101: fwd_datapath_o =  40'b0000000000000000010001000100001100010000; //  X X X X 4 4 4 3 1 0
         10'b1110100110: fwd_datapath_o =  40'b0000000000000000010001000100001100010001; //  X X X X 4 4 4 3 1 1
         10'b1110100111: fwd_datapath_o =  40'b0000000000000011001100110010000000000000; //  X X X 3 3 3 2 0 0 0
         10'b1110101000: fwd_datapath_o =  40'b0000000000000000000001010101010101000011; //  X X X X X 5 5 5 4 3
         10'b1110101001: fwd_datapath_o =  40'b0000000000000000010001000100001100100000; //  X X X X 4 4 4 3 2 0
         10'b1110101010: fwd_datapath_o =  40'b0000000000000000010001000100001100100001; //  X X X X 4 4 4 3 2 1
         10'b1110101011: fwd_datapath_o =  40'b0000000000000011001100110010000100000000; //  X X X 3 3 3 2 1 0 0
         10'b1110101100: fwd_datapath_o =  40'b0000000000000000010001000100001100100010; //  X X X X 4 4 4 3 2 2
         10'b1110101101: fwd_datapath_o =  40'b0000000000000011001100110010000100010000; //  X X X 3 3 3 2 1 1 0
         10'b1110101110: fwd_datapath_o =  40'b0000000000000011001100110010000100010001; //  X X X 3 3 3 2 1 1 1
         10'b1110101111: fwd_datapath_o =  40'b0000000000100010001000010000000000000000; //  X X 2 2 2 1 0 0 0 0
         10'b1110110000: fwd_datapath_o =  40'b0000000000000000000001010101010101000100; //  X X X X X 5 5 5 4 4
         10'b1110110001: fwd_datapath_o =  40'b0000000000000000010001000100001100110000; //  X X X X 4 4 4 3 3 0
         10'b1110110010: fwd_datapath_o =  40'b0000000000000000010001000100001100110001; //  X X X X 4 4 4 3 3 1
         10'b1110110011: fwd_datapath_o =  40'b0000000000000011001100110010001000000000; //  X X X 3 3 3 2 2 0 0
         10'b1110110100: fwd_datapath_o =  40'b0000000000000000010001000100001100110010; //  X X X X 4 4 4 3 3 2
         10'b1110110101: fwd_datapath_o =  40'b0000000000000011001100110010001000010000; //  X X X 3 3 3 2 2 1 0
         10'b1110110110: fwd_datapath_o =  40'b0000000000000011001100110010001000010001; //  X X X 3 3 3 2 2 1 1
         10'b1110110111: fwd_datapath_o =  40'b0000000000100010001000010001000000000000; //  X X 2 2 2 1 1 0 0 0
         10'b1110111000: fwd_datapath_o =  40'b0000000000000000010001000100001100110011; //  X X X X 4 4 4 3 3 3
         10'b1110111001: fwd_datapath_o =  40'b0000000000000011001100110010001000100000; //  X X X 3 3 3 2 2 2 0
         10'b1110111010: fwd_datapath_o =  40'b0000000000000011001100110010001000100001; //  X X X 3 3 3 2 2 2 1
         10'b1110111011: fwd_datapath_o =  40'b0000000000100010001000010001000100000000; //  X X 2 2 2 1 1 1 0 0
         10'b1110111100: fwd_datapath_o =  40'b0000000000000011001100110010001000100010; //  X X X 3 3 3 2 2 2 2
         10'b1110111101: fwd_datapath_o =  40'b0000000000100010001000010001000100010000; //  X X 2 2 2 1 1 1 1 0
         10'b1110111110: fwd_datapath_o =  40'b0000000000100010001000010001000100010001; //  X X 2 2 2 1 1 1 1 1
         10'b1110111111: fwd_datapath_o =  40'b0000000100010001000000000000000000000000; //  X 1 1 1 0 0 0 0 0 0
         10'b1111000000: fwd_datapath_o =  40'b0000000000000000000000000110011001100110; //  X X X X X X 6 6 6 6
         10'b1111000001: fwd_datapath_o =  40'b0000000000000000000001010101010101010000; //  X X X X X 5 5 5 5 0
         10'b1111000010: fwd_datapath_o =  40'b0000000000000000000001010101010101010001; //  X X X X X 5 5 5 5 1
         10'b1111000011: fwd_datapath_o =  40'b0000000000000000010001000100010000000000; //  X X X X 4 4 4 4 0 0
         10'b1111000100: fwd_datapath_o =  40'b0000000000000000000001010101010101010010; //  X X X X X 5 5 5 5 2
         10'b1111000101: fwd_datapath_o =  40'b0000000000000000010001000100010000010000; //  X X X X 4 4 4 4 1 0
         10'b1111000110: fwd_datapath_o =  40'b0000000000000000010001000100010000010001; //  X X X X 4 4 4 4 1 1
         10'b1111000111: fwd_datapath_o =  40'b0000000000000011001100110011000000000000; //  X X X 3 3 3 3 0 0 0
         10'b1111001000: fwd_datapath_o =  40'b0000000000000000000001010101010101010011; //  X X X X X 5 5 5 5 3
         10'b1111001001: fwd_datapath_o =  40'b0000000000000000010001000100010000100000; //  X X X X 4 4 4 4 2 0
         10'b1111001010: fwd_datapath_o =  40'b0000000000000000010001000100010000100001; //  X X X X 4 4 4 4 2 1
         10'b1111001011: fwd_datapath_o =  40'b0000000000000011001100110011000100000000; //  X X X 3 3 3 3 1 0 0
         10'b1111001100: fwd_datapath_o =  40'b0000000000000000010001000100010000100010; //  X X X X 4 4 4 4 2 2
         10'b1111001101: fwd_datapath_o =  40'b0000000000000011001100110011000100010000; //  X X X 3 3 3 3 1 1 0
         10'b1111001110: fwd_datapath_o =  40'b0000000000000011001100110011000100010001; //  X X X 3 3 3 3 1 1 1
         10'b1111001111: fwd_datapath_o =  40'b0000000000100010001000100000000000000000; //  X X 2 2 2 2 0 0 0 0
         10'b1111010000: fwd_datapath_o =  40'b0000000000000000000001010101010101010100; //  X X X X X 5 5 5 5 4
         10'b1111010001: fwd_datapath_o =  40'b0000000000000000010001000100010000110000; //  X X X X 4 4 4 4 3 0
         10'b1111010010: fwd_datapath_o =  40'b0000000000000000010001000100010000110001; //  X X X X 4 4 4 4 3 1
         10'b1111010011: fwd_datapath_o =  40'b0000000000000011001100110011001000000000; //  X X X 3 3 3 3 2 0 0
         10'b1111010100: fwd_datapath_o =  40'b0000000000000000010001000100010000110010; //  X X X X 4 4 4 4 3 2
         10'b1111010101: fwd_datapath_o =  40'b0000000000000011001100110011001000010000; //  X X X 3 3 3 3 2 1 0
         10'b1111010110: fwd_datapath_o =  40'b0000000000000011001100110011001000010001; //  X X X 3 3 3 3 2 1 1
         10'b1111010111: fwd_datapath_o =  40'b0000000000100010001000100001000000000000; //  X X 2 2 2 2 1 0 0 0
         10'b1111011000: fwd_datapath_o =  40'b0000000000000000010001000100010000110011; //  X X X X 4 4 4 4 3 3
         10'b1111011001: fwd_datapath_o =  40'b0000000000000011001100110011001000100000; //  X X X 3 3 3 3 2 2 0
         10'b1111011010: fwd_datapath_o =  40'b0000000000000011001100110011001000100001; //  X X X 3 3 3 3 2 2 1
         10'b1111011011: fwd_datapath_o =  40'b0000000000100010001000100001000100000000; //  X X 2 2 2 2 1 1 0 0
         10'b1111011100: fwd_datapath_o =  40'b0000000000000011001100110011001000100010; //  X X X 3 3 3 3 2 2 2
         10'b1111011101: fwd_datapath_o =  40'b0000000000100010001000100001000100010000; //  X X 2 2 2 2 1 1 1 0
         10'b1111011110: fwd_datapath_o =  40'b0000000000100010001000100001000100010001; //  X X 2 2 2 2 1 1 1 1
         10'b1111011111: fwd_datapath_o =  40'b0000000100010001000100000000000000000000; //  X 1 1 1 1 0 0 0 0 0
         10'b1111100000: fwd_datapath_o =  40'b0000000000000000000001010101010101010101; //  X X X X X 5 5 5 5 5
         10'b1111100001: fwd_datapath_o =  40'b0000000000000000010001000100010001000000; //  X X X X 4 4 4 4 4 0
         10'b1111100010: fwd_datapath_o =  40'b0000000000000000010001000100010001000001; //  X X X X 4 4 4 4 4 1
         10'b1111100011: fwd_datapath_o =  40'b0000000000000011001100110011001100000000; //  X X X 3 3 3 3 3 0 0
         10'b1111100100: fwd_datapath_o =  40'b0000000000000000010001000100010001000010; //  X X X X 4 4 4 4 4 2
         10'b1111100101: fwd_datapath_o =  40'b0000000000000011001100110011001100010000; //  X X X 3 3 3 3 3 1 0
         10'b1111100110: fwd_datapath_o =  40'b0000000000000011001100110011001100010001; //  X X X 3 3 3 3 3 1 1
         10'b1111100111: fwd_datapath_o =  40'b0000000000100010001000100010000000000000; //  X X 2 2 2 2 2 0 0 0
         10'b1111101000: fwd_datapath_o =  40'b0000000000000000010001000100010001000011; //  X X X X 4 4 4 4 4 3
         10'b1111101001: fwd_datapath_o =  40'b0000000000000011001100110011001100100000; //  X X X 3 3 3 3 3 2 0
         10'b1111101010: fwd_datapath_o =  40'b0000000000000011001100110011001100100001; //  X X X 3 3 3 3 3 2 1
         10'b1111101011: fwd_datapath_o =  40'b0000000000100010001000100010000100000000; //  X X 2 2 2 2 2 1 0 0
         10'b1111101100: fwd_datapath_o =  40'b0000000000000011001100110011001100100010; //  X X X 3 3 3 3 3 2 2
         10'b1111101101: fwd_datapath_o =  40'b0000000000100010001000100010000100010000; //  X X 2 2 2 2 2 1 1 0
         10'b1111101110: fwd_datapath_o =  40'b0000000000100010001000100010000100010001; //  X X 2 2 2 2 2 1 1 1
         10'b1111101111: fwd_datapath_o =  40'b0000000100010001000100010000000000000000; //  X 1 1 1 1 1 0 0 0 0
         10'b1111110000: fwd_datapath_o =  40'b0000000000000000010001000100010001000100; //  X X X X 4 4 4 4 4 4
         10'b1111110001: fwd_datapath_o =  40'b0000000000000011001100110011001100110000; //  X X X 3 3 3 3 3 3 0
         10'b1111110010: fwd_datapath_o =  40'b0000000000000011001100110011001100110001; //  X X X 3 3 3 3 3 3 1
         10'b1111110011: fwd_datapath_o =  40'b0000000000100010001000100010001000000000; //  X X 2 2 2 2 2 2 0 0
         10'b1111110100: fwd_datapath_o =  40'b0000000000000011001100110011001100110010; //  X X X 3 3 3 3 3 3 2
         10'b1111110101: fwd_datapath_o =  40'b0000000000100010001000100010001000010000; //  X X 2 2 2 2 2 2 1 0
         10'b1111110110: fwd_datapath_o =  40'b0000000000100010001000100010001000010001; //  X X 2 2 2 2 2 2 1 1
         10'b1111110111: fwd_datapath_o =  40'b0000000100010001000100010001000000000000; //  X 1 1 1 1 1 1 0 0 0
         10'b1111111000: fwd_datapath_o =  40'b0000000000000011001100110011001100110011; //  X X X 3 3 3 3 3 3 3
         10'b1111111001: fwd_datapath_o =  40'b0000000000100010001000100010001000100000; //  X X 2 2 2 2 2 2 2 0
         10'b1111111010: fwd_datapath_o =  40'b0000000000100010001000100010001000100001; //  X X 2 2 2 2 2 2 2 1
         10'b1111111011: fwd_datapath_o =  40'b0000000100010001000100010001000100000000; //  X 1 1 1 1 1 1 1 0 0
         10'b1111111100: fwd_datapath_o =  40'b0000000000100010001000100010001000100010; //  X X 2 2 2 2 2 2 2 2
         10'b1111111101: fwd_datapath_o =  40'b0000000100010001000100010001000100010000; //  X 1 1 1 1 1 1 1 1 0
         10'b1111111110: fwd_datapath_o =  40'b0000000100010001000100010001000100010001; //  X 1 1 1 1 1 1 1 1 1
         10'b1111111111: fwd_datapath_o =  40'b0000000000000000000000000000000000000000; //  0 0 0 0 0 0 0 0 0 0
        default: fwd_datapath_o= 'X;
    endcase
  end

if (vec_size_lp == 11)
  begin
    // backward vec
    always_comb
    unique case (vec_i) 
         11'b00000000000: bk_o =  44'b10101010101010101010101010101010101010101010; //  X X X X X X X X X X X
         11'b00000000001: bk_o =  44'b10101010101010101010101010101010101010100000; //  X X X X X X X X X X 0
         11'b00000000010: bk_o =  44'b10101010101010101010101010101010101000001010; //  X X X X X X X X X 0 X
         11'b00000000011: bk_o =  44'b10101010101010101010101010101010101000010000; //  X X X X X X X X X 1 0
         11'b00000000100: bk_o =  44'b10101010101010101010101010101010000010101010; //  X X X X X X X X 0 X X
         11'b00000000101: bk_o =  44'b10101010101010101010101010101010000110100000; //  X X X X X X X X 1 X 0
         11'b00000000110: bk_o =  44'b10101010101010101010101010101010000100001010; //  X X X X X X X X 1 0 X
         11'b00000000111: bk_o =  44'b10101010101010101010101010101010001000010000; //  X X X X X X X X 2 1 0
         11'b00000001000: bk_o =  44'b10101010101010101010101010100000101010101010; //  X X X X X X X 0 X X X
         11'b00000001001: bk_o =  44'b10101010101010101010101010100001101010100000; //  X X X X X X X 1 X X 0
         11'b00000001010: bk_o =  44'b10101010101010101010101010100001101000001010; //  X X X X X X X 1 X 0 X
         11'b00000001011: bk_o =  44'b10101010101010101010101010100010101000010000; //  X X X X X X X 2 X 1 0
         11'b00000001100: bk_o =  44'b10101010101010101010101010100001000010101010; //  X X X X X X X 1 0 X X
         11'b00000001101: bk_o =  44'b10101010101010101010101010100010000110100000; //  X X X X X X X 2 1 X 0
         11'b00000001110: bk_o =  44'b10101010101010101010101010100010000100001010; //  X X X X X X X 2 1 0 X
         11'b00000001111: bk_o =  44'b10101010101010101010101010100011001000010000; //  X X X X X X X 3 2 1 0
         11'b00000010000: bk_o =  44'b10101010101010101010101000001010101010101010; //  X X X X X X 0 X X X X
         11'b00000010001: bk_o =  44'b10101010101010101010101000011010101010100000; //  X X X X X X 1 X X X 0
         11'b00000010010: bk_o =  44'b10101010101010101010101000011010101000001010; //  X X X X X X 1 X X 0 X
         11'b00000010011: bk_o =  44'b10101010101010101010101000101010101000010000; //  X X X X X X 2 X X 1 0
         11'b00000010100: bk_o =  44'b10101010101010101010101000011010000010101010; //  X X X X X X 1 X 0 X X
         11'b00000010101: bk_o =  44'b10101010101010101010101000101010000110100000; //  X X X X X X 2 X 1 X 0
         11'b00000010110: bk_o =  44'b10101010101010101010101000101010000100001010; //  X X X X X X 2 X 1 0 X
         11'b00000010111: bk_o =  44'b10101010101010101010101000111010001000010000; //  X X X X X X 3 X 2 1 0
         11'b00000011000: bk_o =  44'b10101010101010101010101000010000101010101010; //  X X X X X X 1 0 X X X
         11'b00000011001: bk_o =  44'b10101010101010101010101000100001101010100000; //  X X X X X X 2 1 X X 0
         11'b00000011010: bk_o =  44'b10101010101010101010101000100001101000001010; //  X X X X X X 2 1 X 0 X
         11'b00000011011: bk_o =  44'b10101010101010101010101000110010101000010000; //  X X X X X X 3 2 X 1 0
         11'b00000011100: bk_o =  44'b10101010101010101010101000100001000010101010; //  X X X X X X 2 1 0 X X
         11'b00000011101: bk_o =  44'b10101010101010101010101000110010000110100000; //  X X X X X X 3 2 1 X 0
         11'b00000011110: bk_o =  44'b10101010101010101010101000110010000100001010; //  X X X X X X 3 2 1 0 X
         11'b00000011111: bk_o =  44'b10101010101010101010101001000011001000010000; //  X X X X X X 4 3 2 1 0
         11'b00000100000: bk_o =  44'b10101010101010101010000010101010101010101010; //  X X X X X 0 X X X X X
         11'b00000100001: bk_o =  44'b10101010101010101010000110101010101010100000; //  X X X X X 1 X X X X 0
         11'b00000100010: bk_o =  44'b10101010101010101010000110101010101000001010; //  X X X X X 1 X X X 0 X
         11'b00000100011: bk_o =  44'b10101010101010101010001010101010101000010000; //  X X X X X 2 X X X 1 0
         11'b00000100100: bk_o =  44'b10101010101010101010000110101010000010101010; //  X X X X X 1 X X 0 X X
         11'b00000100101: bk_o =  44'b10101010101010101010001010101010000110100000; //  X X X X X 2 X X 1 X 0
         11'b00000100110: bk_o =  44'b10101010101010101010001010101010000100001010; //  X X X X X 2 X X 1 0 X
         11'b00000100111: bk_o =  44'b10101010101010101010001110101010001000010000; //  X X X X X 3 X X 2 1 0
         11'b00000101000: bk_o =  44'b10101010101010101010000110100000101010101010; //  X X X X X 1 X 0 X X X
         11'b00000101001: bk_o =  44'b10101010101010101010001010100001101010100000; //  X X X X X 2 X 1 X X 0
         11'b00000101010: bk_o =  44'b10101010101010101010001010100001101000001010; //  X X X X X 2 X 1 X 0 X
         11'b00000101011: bk_o =  44'b10101010101010101010001110100010101000010000; //  X X X X X 3 X 2 X 1 0
         11'b00000101100: bk_o =  44'b10101010101010101010001010100001000010101010; //  X X X X X 2 X 1 0 X X
         11'b00000101101: bk_o =  44'b10101010101010101010001110100010000110100000; //  X X X X X 3 X 2 1 X 0
         11'b00000101110: bk_o =  44'b10101010101010101010001110100010000100001010; //  X X X X X 3 X 2 1 0 X
         11'b00000101111: bk_o =  44'b10101010101010101010010010100011001000010000; //  X X X X X 4 X 3 2 1 0
         11'b00000110000: bk_o =  44'b10101010101010101010000100001010101010101010; //  X X X X X 1 0 X X X X
         11'b00000110001: bk_o =  44'b10101010101010101010001000011010101010100000; //  X X X X X 2 1 X X X 0
         11'b00000110010: bk_o =  44'b10101010101010101010001000011010101000001010; //  X X X X X 2 1 X X 0 X
         11'b00000110011: bk_o =  44'b10101010101010101010001100101010101000010000; //  X X X X X 3 2 X X 1 0
         11'b00000110100: bk_o =  44'b10101010101010101010001000011010000010101010; //  X X X X X 2 1 X 0 X X
         11'b00000110101: bk_o =  44'b10101010101010101010001100101010000110100000; //  X X X X X 3 2 X 1 X 0
         11'b00000110110: bk_o =  44'b10101010101010101010001100101010000100001010; //  X X X X X 3 2 X 1 0 X
         11'b00000110111: bk_o =  44'b10101010101010101010010000111010001000010000; //  X X X X X 4 3 X 2 1 0
         11'b00000111000: bk_o =  44'b10101010101010101010001000010000101010101010; //  X X X X X 2 1 0 X X X
         11'b00000111001: bk_o =  44'b10101010101010101010001100100001101010100000; //  X X X X X 3 2 1 X X 0
         11'b00000111010: bk_o =  44'b10101010101010101010001100100001101000001010; //  X X X X X 3 2 1 X 0 X
         11'b00000111011: bk_o =  44'b10101010101010101010010000110010101000010000; //  X X X X X 4 3 2 X 1 0
         11'b00000111100: bk_o =  44'b10101010101010101010001100100001000010101010; //  X X X X X 3 2 1 0 X X
         11'b00000111101: bk_o =  44'b10101010101010101010010000110010000110100000; //  X X X X X 4 3 2 1 X 0
         11'b00000111110: bk_o =  44'b10101010101010101010010000110010000100001010; //  X X X X X 4 3 2 1 0 X
         11'b00000111111: bk_o =  44'b10101010101010101010010101000011001000010000; //  X X X X X 5 4 3 2 1 0
         11'b00001000000: bk_o =  44'b10101010101010100000101010101010101010101010; //  X X X X 0 X X X X X X
         11'b00001000001: bk_o =  44'b10101010101010100001101010101010101010100000; //  X X X X 1 X X X X X 0
         11'b00001000010: bk_o =  44'b10101010101010100001101010101010101000001010; //  X X X X 1 X X X X 0 X
         11'b00001000011: bk_o =  44'b10101010101010100010101010101010101000010000; //  X X X X 2 X X X X 1 0
         11'b00001000100: bk_o =  44'b10101010101010100001101010101010000010101010; //  X X X X 1 X X X 0 X X
         11'b00001000101: bk_o =  44'b10101010101010100010101010101010000110100000; //  X X X X 2 X X X 1 X 0
         11'b00001000110: bk_o =  44'b10101010101010100010101010101010000100001010; //  X X X X 2 X X X 1 0 X
         11'b00001000111: bk_o =  44'b10101010101010100011101010101010001000010000; //  X X X X 3 X X X 2 1 0
         11'b00001001000: bk_o =  44'b10101010101010100001101010100000101010101010; //  X X X X 1 X X 0 X X X
         11'b00001001001: bk_o =  44'b10101010101010100010101010100001101010100000; //  X X X X 2 X X 1 X X 0
         11'b00001001010: bk_o =  44'b10101010101010100010101010100001101000001010; //  X X X X 2 X X 1 X 0 X
         11'b00001001011: bk_o =  44'b10101010101010100011101010100010101000010000; //  X X X X 3 X X 2 X 1 0
         11'b00001001100: bk_o =  44'b10101010101010100010101010100001000010101010; //  X X X X 2 X X 1 0 X X
         11'b00001001101: bk_o =  44'b10101010101010100011101010100010000110100000; //  X X X X 3 X X 2 1 X 0
         11'b00001001110: bk_o =  44'b10101010101010100011101010100010000100001010; //  X X X X 3 X X 2 1 0 X
         11'b00001001111: bk_o =  44'b10101010101010100100101010100011001000010000; //  X X X X 4 X X 3 2 1 0
         11'b00001010000: bk_o =  44'b10101010101010100001101000001010101010101010; //  X X X X 1 X 0 X X X X
         11'b00001010001: bk_o =  44'b10101010101010100010101000011010101010100000; //  X X X X 2 X 1 X X X 0
         11'b00001010010: bk_o =  44'b10101010101010100010101000011010101000001010; //  X X X X 2 X 1 X X 0 X
         11'b00001010011: bk_o =  44'b10101010101010100011101000101010101000010000; //  X X X X 3 X 2 X X 1 0
         11'b00001010100: bk_o =  44'b10101010101010100010101000011010000010101010; //  X X X X 2 X 1 X 0 X X
         11'b00001010101: bk_o =  44'b10101010101010100011101000101010000110100000; //  X X X X 3 X 2 X 1 X 0
         11'b00001010110: bk_o =  44'b10101010101010100011101000101010000100001010; //  X X X X 3 X 2 X 1 0 X
         11'b00001010111: bk_o =  44'b10101010101010100100101000111010001000010000; //  X X X X 4 X 3 X 2 1 0
         11'b00001011000: bk_o =  44'b10101010101010100010101000010000101010101010; //  X X X X 2 X 1 0 X X X
         11'b00001011001: bk_o =  44'b10101010101010100011101000100001101010100000; //  X X X X 3 X 2 1 X X 0
         11'b00001011010: bk_o =  44'b10101010101010100011101000100001101000001010; //  X X X X 3 X 2 1 X 0 X
         11'b00001011011: bk_o =  44'b10101010101010100100101000110010101000010000; //  X X X X 4 X 3 2 X 1 0
         11'b00001011100: bk_o =  44'b10101010101010100011101000100001000010101010; //  X X X X 3 X 2 1 0 X X
         11'b00001011101: bk_o =  44'b10101010101010100100101000110010000110100000; //  X X X X 4 X 3 2 1 X 0
         11'b00001011110: bk_o =  44'b10101010101010100100101000110010000100001010; //  X X X X 4 X 3 2 1 0 X
         11'b00001011111: bk_o =  44'b10101010101010100101101001000011001000010000; //  X X X X 5 X 4 3 2 1 0
         11'b00001100000: bk_o =  44'b10101010101010100001000010101010101010101010; //  X X X X 1 0 X X X X X
         11'b00001100001: bk_o =  44'b10101010101010100010000110101010101010100000; //  X X X X 2 1 X X X X 0
         11'b00001100010: bk_o =  44'b10101010101010100010000110101010101000001010; //  X X X X 2 1 X X X 0 X
         11'b00001100011: bk_o =  44'b10101010101010100011001010101010101000010000; //  X X X X 3 2 X X X 1 0
         11'b00001100100: bk_o =  44'b10101010101010100010000110101010000010101010; //  X X X X 2 1 X X 0 X X
         11'b00001100101: bk_o =  44'b10101010101010100011001010101010000110100000; //  X X X X 3 2 X X 1 X 0
         11'b00001100110: bk_o =  44'b10101010101010100011001010101010000100001010; //  X X X X 3 2 X X 1 0 X
         11'b00001100111: bk_o =  44'b10101010101010100100001110101010001000010000; //  X X X X 4 3 X X 2 1 0
         11'b00001101000: bk_o =  44'b10101010101010100010000110100000101010101010; //  X X X X 2 1 X 0 X X X
         11'b00001101001: bk_o =  44'b10101010101010100011001010100001101010100000; //  X X X X 3 2 X 1 X X 0
         11'b00001101010: bk_o =  44'b10101010101010100011001010100001101000001010; //  X X X X 3 2 X 1 X 0 X
         11'b00001101011: bk_o =  44'b10101010101010100100001110100010101000010000; //  X X X X 4 3 X 2 X 1 0
         11'b00001101100: bk_o =  44'b10101010101010100011001010100001000010101010; //  X X X X 3 2 X 1 0 X X
         11'b00001101101: bk_o =  44'b10101010101010100100001110100010000110100000; //  X X X X 4 3 X 2 1 X 0
         11'b00001101110: bk_o =  44'b10101010101010100100001110100010000100001010; //  X X X X 4 3 X 2 1 0 X
         11'b00001101111: bk_o =  44'b10101010101010100101010010100011001000010000; //  X X X X 5 4 X 3 2 1 0
         11'b00001110000: bk_o =  44'b10101010101010100010000100001010101010101010; //  X X X X 2 1 0 X X X X
         11'b00001110001: bk_o =  44'b10101010101010100011001000011010101010100000; //  X X X X 3 2 1 X X X 0
         11'b00001110010: bk_o =  44'b10101010101010100011001000011010101000001010; //  X X X X 3 2 1 X X 0 X
         11'b00001110011: bk_o =  44'b10101010101010100100001100101010101000010000; //  X X X X 4 3 2 X X 1 0
         11'b00001110100: bk_o =  44'b10101010101010100011001000011010000010101010; //  X X X X 3 2 1 X 0 X X
         11'b00001110101: bk_o =  44'b10101010101010100100001100101010000110100000; //  X X X X 4 3 2 X 1 X 0
         11'b00001110110: bk_o =  44'b10101010101010100100001100101010000100001010; //  X X X X 4 3 2 X 1 0 X
         11'b00001110111: bk_o =  44'b10101010101010100101010000111010001000010000; //  X X X X 5 4 3 X 2 1 0
         11'b00001111000: bk_o =  44'b10101010101010100011001000010000101010101010; //  X X X X 3 2 1 0 X X X
         11'b00001111001: bk_o =  44'b10101010101010100100001100100001101010100000; //  X X X X 4 3 2 1 X X 0
         11'b00001111010: bk_o =  44'b10101010101010100100001100100001101000001010; //  X X X X 4 3 2 1 X 0 X
         11'b00001111011: bk_o =  44'b10101010101010100101010000110010101000010000; //  X X X X 5 4 3 2 X 1 0
         11'b00001111100: bk_o =  44'b10101010101010100100001100100001000010101010; //  X X X X 4 3 2 1 0 X X
         11'b00001111101: bk_o =  44'b10101010101010100101010000110010000110100000; //  X X X X 5 4 3 2 1 X 0
         11'b00001111110: bk_o =  44'b10101010101010100101010000110010000100001010; //  X X X X 5 4 3 2 1 0 X
         11'b00001111111: bk_o =  44'b10101010101010100110010101000011001000010000; //  X X X X 6 5 4 3 2 1 0
         11'b00010000000: bk_o =  44'b10101010101000001010101010101010101010101010; //  X X X 0 X X X X X X X
         11'b00010000001: bk_o =  44'b10101010101000011010101010101010101010100000; //  X X X 1 X X X X X X 0
         11'b00010000010: bk_o =  44'b10101010101000011010101010101010101000001010; //  X X X 1 X X X X X 0 X
         11'b00010000011: bk_o =  44'b10101010101000101010101010101010101000010000; //  X X X 2 X X X X X 1 0
         11'b00010000100: bk_o =  44'b10101010101000011010101010101010000010101010; //  X X X 1 X X X X 0 X X
         11'b00010000101: bk_o =  44'b10101010101000101010101010101010000110100000; //  X X X 2 X X X X 1 X 0
         11'b00010000110: bk_o =  44'b10101010101000101010101010101010000100001010; //  X X X 2 X X X X 1 0 X
         11'b00010000111: bk_o =  44'b10101010101000111010101010101010001000010000; //  X X X 3 X X X X 2 1 0
         11'b00010001000: bk_o =  44'b10101010101000011010101010100000101010101010; //  X X X 1 X X X 0 X X X
         11'b00010001001: bk_o =  44'b10101010101000101010101010100001101010100000; //  X X X 2 X X X 1 X X 0
         11'b00010001010: bk_o =  44'b10101010101000101010101010100001101000001010; //  X X X 2 X X X 1 X 0 X
         11'b00010001011: bk_o =  44'b10101010101000111010101010100010101000010000; //  X X X 3 X X X 2 X 1 0
         11'b00010001100: bk_o =  44'b10101010101000101010101010100001000010101010; //  X X X 2 X X X 1 0 X X
         11'b00010001101: bk_o =  44'b10101010101000111010101010100010000110100000; //  X X X 3 X X X 2 1 X 0
         11'b00010001110: bk_o =  44'b10101010101000111010101010100010000100001010; //  X X X 3 X X X 2 1 0 X
         11'b00010001111: bk_o =  44'b10101010101001001010101010100011001000010000; //  X X X 4 X X X 3 2 1 0
         11'b00010010000: bk_o =  44'b10101010101000011010101000001010101010101010; //  X X X 1 X X 0 X X X X
         11'b00010010001: bk_o =  44'b10101010101000101010101000011010101010100000; //  X X X 2 X X 1 X X X 0
         11'b00010010010: bk_o =  44'b10101010101000101010101000011010101000001010; //  X X X 2 X X 1 X X 0 X
         11'b00010010011: bk_o =  44'b10101010101000111010101000101010101000010000; //  X X X 3 X X 2 X X 1 0
         11'b00010010100: bk_o =  44'b10101010101000101010101000011010000010101010; //  X X X 2 X X 1 X 0 X X
         11'b00010010101: bk_o =  44'b10101010101000111010101000101010000110100000; //  X X X 3 X X 2 X 1 X 0
         11'b00010010110: bk_o =  44'b10101010101000111010101000101010000100001010; //  X X X 3 X X 2 X 1 0 X
         11'b00010010111: bk_o =  44'b10101010101001001010101000111010001000010000; //  X X X 4 X X 3 X 2 1 0
         11'b00010011000: bk_o =  44'b10101010101000101010101000010000101010101010; //  X X X 2 X X 1 0 X X X
         11'b00010011001: bk_o =  44'b10101010101000111010101000100001101010100000; //  X X X 3 X X 2 1 X X 0
         11'b00010011010: bk_o =  44'b10101010101000111010101000100001101000001010; //  X X X 3 X X 2 1 X 0 X
         11'b00010011011: bk_o =  44'b10101010101001001010101000110010101000010000; //  X X X 4 X X 3 2 X 1 0
         11'b00010011100: bk_o =  44'b10101010101000111010101000100001000010101010; //  X X X 3 X X 2 1 0 X X
         11'b00010011101: bk_o =  44'b10101010101001001010101000110010000110100000; //  X X X 4 X X 3 2 1 X 0
         11'b00010011110: bk_o =  44'b10101010101001001010101000110010000100001010; //  X X X 4 X X 3 2 1 0 X
         11'b00010011111: bk_o =  44'b10101010101001011010101001000011001000010000; //  X X X 5 X X 4 3 2 1 0
         11'b00010100000: bk_o =  44'b10101010101000011010000010101010101010101010; //  X X X 1 X 0 X X X X X
         11'b00010100001: bk_o =  44'b10101010101000101010000110101010101010100000; //  X X X 2 X 1 X X X X 0
         11'b00010100010: bk_o =  44'b10101010101000101010000110101010101000001010; //  X X X 2 X 1 X X X 0 X
         11'b00010100011: bk_o =  44'b10101010101000111010001010101010101000010000; //  X X X 3 X 2 X X X 1 0
         11'b00010100100: bk_o =  44'b10101010101000101010000110101010000010101010; //  X X X 2 X 1 X X 0 X X
         11'b00010100101: bk_o =  44'b10101010101000111010001010101010000110100000; //  X X X 3 X 2 X X 1 X 0
         11'b00010100110: bk_o =  44'b10101010101000111010001010101010000100001010; //  X X X 3 X 2 X X 1 0 X
         11'b00010100111: bk_o =  44'b10101010101001001010001110101010001000010000; //  X X X 4 X 3 X X 2 1 0
         11'b00010101000: bk_o =  44'b10101010101000101010000110100000101010101010; //  X X X 2 X 1 X 0 X X X
         11'b00010101001: bk_o =  44'b10101010101000111010001010100001101010100000; //  X X X 3 X 2 X 1 X X 0
         11'b00010101010: bk_o =  44'b10101010101000111010001010100001101000001010; //  X X X 3 X 2 X 1 X 0 X
         11'b00010101011: bk_o =  44'b10101010101001001010001110100010101000010000; //  X X X 4 X 3 X 2 X 1 0
         11'b00010101100: bk_o =  44'b10101010101000111010001010100001000010101010; //  X X X 3 X 2 X 1 0 X X
         11'b00010101101: bk_o =  44'b10101010101001001010001110100010000110100000; //  X X X 4 X 3 X 2 1 X 0
         11'b00010101110: bk_o =  44'b10101010101001001010001110100010000100001010; //  X X X 4 X 3 X 2 1 0 X
         11'b00010101111: bk_o =  44'b10101010101001011010010010100011001000010000; //  X X X 5 X 4 X 3 2 1 0
         11'b00010110000: bk_o =  44'b10101010101000101010000100001010101010101010; //  X X X 2 X 1 0 X X X X
         11'b00010110001: bk_o =  44'b10101010101000111010001000011010101010100000; //  X X X 3 X 2 1 X X X 0
         11'b00010110010: bk_o =  44'b10101010101000111010001000011010101000001010; //  X X X 3 X 2 1 X X 0 X
         11'b00010110011: bk_o =  44'b10101010101001001010001100101010101000010000; //  X X X 4 X 3 2 X X 1 0
         11'b00010110100: bk_o =  44'b10101010101000111010001000011010000010101010; //  X X X 3 X 2 1 X 0 X X
         11'b00010110101: bk_o =  44'b10101010101001001010001100101010000110100000; //  X X X 4 X 3 2 X 1 X 0
         11'b00010110110: bk_o =  44'b10101010101001001010001100101010000100001010; //  X X X 4 X 3 2 X 1 0 X
         11'b00010110111: bk_o =  44'b10101010101001011010010000111010001000010000; //  X X X 5 X 4 3 X 2 1 0
         11'b00010111000: bk_o =  44'b10101010101000111010001000010000101010101010; //  X X X 3 X 2 1 0 X X X
         11'b00010111001: bk_o =  44'b10101010101001001010001100100001101010100000; //  X X X 4 X 3 2 1 X X 0
         11'b00010111010: bk_o =  44'b10101010101001001010001100100001101000001010; //  X X X 4 X 3 2 1 X 0 X
         11'b00010111011: bk_o =  44'b10101010101001011010010000110010101000010000; //  X X X 5 X 4 3 2 X 1 0
         11'b00010111100: bk_o =  44'b10101010101001001010001100100001000010101010; //  X X X 4 X 3 2 1 0 X X
         11'b00010111101: bk_o =  44'b10101010101001011010010000110010000110100000; //  X X X 5 X 4 3 2 1 X 0
         11'b00010111110: bk_o =  44'b10101010101001011010010000110010000100001010; //  X X X 5 X 4 3 2 1 0 X
         11'b00010111111: bk_o =  44'b10101010101001101010010101000011001000010000; //  X X X 6 X 5 4 3 2 1 0
         11'b00011000000: bk_o =  44'b10101010101000010000101010101010101010101010; //  X X X 1 0 X X X X X X
         11'b00011000001: bk_o =  44'b10101010101000100001101010101010101010100000; //  X X X 2 1 X X X X X 0
         11'b00011000010: bk_o =  44'b10101010101000100001101010101010101000001010; //  X X X 2 1 X X X X 0 X
         11'b00011000011: bk_o =  44'b10101010101000110010101010101010101000010000; //  X X X 3 2 X X X X 1 0
         11'b00011000100: bk_o =  44'b10101010101000100001101010101010000010101010; //  X X X 2 1 X X X 0 X X
         11'b00011000101: bk_o =  44'b10101010101000110010101010101010000110100000; //  X X X 3 2 X X X 1 X 0
         11'b00011000110: bk_o =  44'b10101010101000110010101010101010000100001010; //  X X X 3 2 X X X 1 0 X
         11'b00011000111: bk_o =  44'b10101010101001000011101010101010001000010000; //  X X X 4 3 X X X 2 1 0
         11'b00011001000: bk_o =  44'b10101010101000100001101010100000101010101010; //  X X X 2 1 X X 0 X X X
         11'b00011001001: bk_o =  44'b10101010101000110010101010100001101010100000; //  X X X 3 2 X X 1 X X 0
         11'b00011001010: bk_o =  44'b10101010101000110010101010100001101000001010; //  X X X 3 2 X X 1 X 0 X
         11'b00011001011: bk_o =  44'b10101010101001000011101010100010101000010000; //  X X X 4 3 X X 2 X 1 0
         11'b00011001100: bk_o =  44'b10101010101000110010101010100001000010101010; //  X X X 3 2 X X 1 0 X X
         11'b00011001101: bk_o =  44'b10101010101001000011101010100010000110100000; //  X X X 4 3 X X 2 1 X 0
         11'b00011001110: bk_o =  44'b10101010101001000011101010100010000100001010; //  X X X 4 3 X X 2 1 0 X
         11'b00011001111: bk_o =  44'b10101010101001010100101010100011001000010000; //  X X X 5 4 X X 3 2 1 0
         11'b00011010000: bk_o =  44'b10101010101000100001101000001010101010101010; //  X X X 2 1 X 0 X X X X
         11'b00011010001: bk_o =  44'b10101010101000110010101000011010101010100000; //  X X X 3 2 X 1 X X X 0
         11'b00011010010: bk_o =  44'b10101010101000110010101000011010101000001010; //  X X X 3 2 X 1 X X 0 X
         11'b00011010011: bk_o =  44'b10101010101001000011101000101010101000010000; //  X X X 4 3 X 2 X X 1 0
         11'b00011010100: bk_o =  44'b10101010101000110010101000011010000010101010; //  X X X 3 2 X 1 X 0 X X
         11'b00011010101: bk_o =  44'b10101010101001000011101000101010000110100000; //  X X X 4 3 X 2 X 1 X 0
         11'b00011010110: bk_o =  44'b10101010101001000011101000101010000100001010; //  X X X 4 3 X 2 X 1 0 X
         11'b00011010111: bk_o =  44'b10101010101001010100101000111010001000010000; //  X X X 5 4 X 3 X 2 1 0
         11'b00011011000: bk_o =  44'b10101010101000110010101000010000101010101010; //  X X X 3 2 X 1 0 X X X
         11'b00011011001: bk_o =  44'b10101010101001000011101000100001101010100000; //  X X X 4 3 X 2 1 X X 0
         11'b00011011010: bk_o =  44'b10101010101001000011101000100001101000001010; //  X X X 4 3 X 2 1 X 0 X
         11'b00011011011: bk_o =  44'b10101010101001010100101000110010101000010000; //  X X X 5 4 X 3 2 X 1 0
         11'b00011011100: bk_o =  44'b10101010101001000011101000100001000010101010; //  X X X 4 3 X 2 1 0 X X
         11'b00011011101: bk_o =  44'b10101010101001010100101000110010000110100000; //  X X X 5 4 X 3 2 1 X 0
         11'b00011011110: bk_o =  44'b10101010101001010100101000110010000100001010; //  X X X 5 4 X 3 2 1 0 X
         11'b00011011111: bk_o =  44'b10101010101001100101101001000011001000010000; //  X X X 6 5 X 4 3 2 1 0
         11'b00011100000: bk_o =  44'b10101010101000100001000010101010101010101010; //  X X X 2 1 0 X X X X X
         11'b00011100001: bk_o =  44'b10101010101000110010000110101010101010100000; //  X X X 3 2 1 X X X X 0
         11'b00011100010: bk_o =  44'b10101010101000110010000110101010101000001010; //  X X X 3 2 1 X X X 0 X
         11'b00011100011: bk_o =  44'b10101010101001000011001010101010101000010000; //  X X X 4 3 2 X X X 1 0
         11'b00011100100: bk_o =  44'b10101010101000110010000110101010000010101010; //  X X X 3 2 1 X X 0 X X
         11'b00011100101: bk_o =  44'b10101010101001000011001010101010000110100000; //  X X X 4 3 2 X X 1 X 0
         11'b00011100110: bk_o =  44'b10101010101001000011001010101010000100001010; //  X X X 4 3 2 X X 1 0 X
         11'b00011100111: bk_o =  44'b10101010101001010100001110101010001000010000; //  X X X 5 4 3 X X 2 1 0
         11'b00011101000: bk_o =  44'b10101010101000110010000110100000101010101010; //  X X X 3 2 1 X 0 X X X
         11'b00011101001: bk_o =  44'b10101010101001000011001010100001101010100000; //  X X X 4 3 2 X 1 X X 0
         11'b00011101010: bk_o =  44'b10101010101001000011001010100001101000001010; //  X X X 4 3 2 X 1 X 0 X
         11'b00011101011: bk_o =  44'b10101010101001010100001110100010101000010000; //  X X X 5 4 3 X 2 X 1 0
         11'b00011101100: bk_o =  44'b10101010101001000011001010100001000010101010; //  X X X 4 3 2 X 1 0 X X
         11'b00011101101: bk_o =  44'b10101010101001010100001110100010000110100000; //  X X X 5 4 3 X 2 1 X 0
         11'b00011101110: bk_o =  44'b10101010101001010100001110100010000100001010; //  X X X 5 4 3 X 2 1 0 X
         11'b00011101111: bk_o =  44'b10101010101001100101010010100011001000010000; //  X X X 6 5 4 X 3 2 1 0
         11'b00011110000: bk_o =  44'b10101010101000110010000100001010101010101010; //  X X X 3 2 1 0 X X X X
         11'b00011110001: bk_o =  44'b10101010101001000011001000011010101010100000; //  X X X 4 3 2 1 X X X 0
         11'b00011110010: bk_o =  44'b10101010101001000011001000011010101000001010; //  X X X 4 3 2 1 X X 0 X
         11'b00011110011: bk_o =  44'b10101010101001010100001100101010101000010000; //  X X X 5 4 3 2 X X 1 0
         11'b00011110100: bk_o =  44'b10101010101001000011001000011010000010101010; //  X X X 4 3 2 1 X 0 X X
         11'b00011110101: bk_o =  44'b10101010101001010100001100101010000110100000; //  X X X 5 4 3 2 X 1 X 0
         11'b00011110110: bk_o =  44'b10101010101001010100001100101010000100001010; //  X X X 5 4 3 2 X 1 0 X
         11'b00011110111: bk_o =  44'b10101010101001100101010000111010001000010000; //  X X X 6 5 4 3 X 2 1 0
         11'b00011111000: bk_o =  44'b10101010101001000011001000010000101010101010; //  X X X 4 3 2 1 0 X X X
         11'b00011111001: bk_o =  44'b10101010101001010100001100100001101010100000; //  X X X 5 4 3 2 1 X X 0
         11'b00011111010: bk_o =  44'b10101010101001010100001100100001101000001010; //  X X X 5 4 3 2 1 X 0 X
         11'b00011111011: bk_o =  44'b10101010101001100101010000110010101000010000; //  X X X 6 5 4 3 2 X 1 0
         11'b00011111100: bk_o =  44'b10101010101001010100001100100001000010101010; //  X X X 5 4 3 2 1 0 X X
         11'b00011111101: bk_o =  44'b10101010101001100101010000110010000110100000; //  X X X 6 5 4 3 2 1 X 0
         11'b00011111110: bk_o =  44'b10101010101001100101010000110010000100001010; //  X X X 6 5 4 3 2 1 0 X
         11'b00011111111: bk_o =  44'b10101010101001110110010101000011001000010000; //  X X X 7 6 5 4 3 2 1 0
         11'b00100000000: bk_o =  44'b10101010000010101010101010101010101010101010; //  X X 0 X X X X X X X X
         11'b00100000001: bk_o =  44'b10101010000110101010101010101010101010100000; //  X X 1 X X X X X X X 0
         11'b00100000010: bk_o =  44'b10101010000110101010101010101010101000001010; //  X X 1 X X X X X X 0 X
         11'b00100000011: bk_o =  44'b10101010001010101010101010101010101000010000; //  X X 2 X X X X X X 1 0
         11'b00100000100: bk_o =  44'b10101010000110101010101010101010000010101010; //  X X 1 X X X X X 0 X X
         11'b00100000101: bk_o =  44'b10101010001010101010101010101010000110100000; //  X X 2 X X X X X 1 X 0
         11'b00100000110: bk_o =  44'b10101010001010101010101010101010000100001010; //  X X 2 X X X X X 1 0 X
         11'b00100000111: bk_o =  44'b10101010001110101010101010101010001000010000; //  X X 3 X X X X X 2 1 0
         11'b00100001000: bk_o =  44'b10101010000110101010101010100000101010101010; //  X X 1 X X X X 0 X X X
         11'b00100001001: bk_o =  44'b10101010001010101010101010100001101010100000; //  X X 2 X X X X 1 X X 0
         11'b00100001010: bk_o =  44'b10101010001010101010101010100001101000001010; //  X X 2 X X X X 1 X 0 X
         11'b00100001011: bk_o =  44'b10101010001110101010101010100010101000010000; //  X X 3 X X X X 2 X 1 0
         11'b00100001100: bk_o =  44'b10101010001010101010101010100001000010101010; //  X X 2 X X X X 1 0 X X
         11'b00100001101: bk_o =  44'b10101010001110101010101010100010000110100000; //  X X 3 X X X X 2 1 X 0
         11'b00100001110: bk_o =  44'b10101010001110101010101010100010000100001010; //  X X 3 X X X X 2 1 0 X
         11'b00100001111: bk_o =  44'b10101010010010101010101010100011001000010000; //  X X 4 X X X X 3 2 1 0
         11'b00100010000: bk_o =  44'b10101010000110101010101000001010101010101010; //  X X 1 X X X 0 X X X X
         11'b00100010001: bk_o =  44'b10101010001010101010101000011010101010100000; //  X X 2 X X X 1 X X X 0
         11'b00100010010: bk_o =  44'b10101010001010101010101000011010101000001010; //  X X 2 X X X 1 X X 0 X
         11'b00100010011: bk_o =  44'b10101010001110101010101000101010101000010000; //  X X 3 X X X 2 X X 1 0
         11'b00100010100: bk_o =  44'b10101010001010101010101000011010000010101010; //  X X 2 X X X 1 X 0 X X
         11'b00100010101: bk_o =  44'b10101010001110101010101000101010000110100000; //  X X 3 X X X 2 X 1 X 0
         11'b00100010110: bk_o =  44'b10101010001110101010101000101010000100001010; //  X X 3 X X X 2 X 1 0 X
         11'b00100010111: bk_o =  44'b10101010010010101010101000111010001000010000; //  X X 4 X X X 3 X 2 1 0
         11'b00100011000: bk_o =  44'b10101010001010101010101000010000101010101010; //  X X 2 X X X 1 0 X X X
         11'b00100011001: bk_o =  44'b10101010001110101010101000100001101010100000; //  X X 3 X X X 2 1 X X 0
         11'b00100011010: bk_o =  44'b10101010001110101010101000100001101000001010; //  X X 3 X X X 2 1 X 0 X
         11'b00100011011: bk_o =  44'b10101010010010101010101000110010101000010000; //  X X 4 X X X 3 2 X 1 0
         11'b00100011100: bk_o =  44'b10101010001110101010101000100001000010101010; //  X X 3 X X X 2 1 0 X X
         11'b00100011101: bk_o =  44'b10101010010010101010101000110010000110100000; //  X X 4 X X X 3 2 1 X 0
         11'b00100011110: bk_o =  44'b10101010010010101010101000110010000100001010; //  X X 4 X X X 3 2 1 0 X
         11'b00100011111: bk_o =  44'b10101010010110101010101001000011001000010000; //  X X 5 X X X 4 3 2 1 0
         11'b00100100000: bk_o =  44'b10101010000110101010000010101010101010101010; //  X X 1 X X 0 X X X X X
         11'b00100100001: bk_o =  44'b10101010001010101010000110101010101010100000; //  X X 2 X X 1 X X X X 0
         11'b00100100010: bk_o =  44'b10101010001010101010000110101010101000001010; //  X X 2 X X 1 X X X 0 X
         11'b00100100011: bk_o =  44'b10101010001110101010001010101010101000010000; //  X X 3 X X 2 X X X 1 0
         11'b00100100100: bk_o =  44'b10101010001010101010000110101010000010101010; //  X X 2 X X 1 X X 0 X X
         11'b00100100101: bk_o =  44'b10101010001110101010001010101010000110100000; //  X X 3 X X 2 X X 1 X 0
         11'b00100100110: bk_o =  44'b10101010001110101010001010101010000100001010; //  X X 3 X X 2 X X 1 0 X
         11'b00100100111: bk_o =  44'b10101010010010101010001110101010001000010000; //  X X 4 X X 3 X X 2 1 0
         11'b00100101000: bk_o =  44'b10101010001010101010000110100000101010101010; //  X X 2 X X 1 X 0 X X X
         11'b00100101001: bk_o =  44'b10101010001110101010001010100001101010100000; //  X X 3 X X 2 X 1 X X 0
         11'b00100101010: bk_o =  44'b10101010001110101010001010100001101000001010; //  X X 3 X X 2 X 1 X 0 X
         11'b00100101011: bk_o =  44'b10101010010010101010001110100010101000010000; //  X X 4 X X 3 X 2 X 1 0
         11'b00100101100: bk_o =  44'b10101010001110101010001010100001000010101010; //  X X 3 X X 2 X 1 0 X X
         11'b00100101101: bk_o =  44'b10101010010010101010001110100010000110100000; //  X X 4 X X 3 X 2 1 X 0
         11'b00100101110: bk_o =  44'b10101010010010101010001110100010000100001010; //  X X 4 X X 3 X 2 1 0 X
         11'b00100101111: bk_o =  44'b10101010010110101010010010100011001000010000; //  X X 5 X X 4 X 3 2 1 0
         11'b00100110000: bk_o =  44'b10101010001010101010000100001010101010101010; //  X X 2 X X 1 0 X X X X
         11'b00100110001: bk_o =  44'b10101010001110101010001000011010101010100000; //  X X 3 X X 2 1 X X X 0
         11'b00100110010: bk_o =  44'b10101010001110101010001000011010101000001010; //  X X 3 X X 2 1 X X 0 X
         11'b00100110011: bk_o =  44'b10101010010010101010001100101010101000010000; //  X X 4 X X 3 2 X X 1 0
         11'b00100110100: bk_o =  44'b10101010001110101010001000011010000010101010; //  X X 3 X X 2 1 X 0 X X
         11'b00100110101: bk_o =  44'b10101010010010101010001100101010000110100000; //  X X 4 X X 3 2 X 1 X 0
         11'b00100110110: bk_o =  44'b10101010010010101010001100101010000100001010; //  X X 4 X X 3 2 X 1 0 X
         11'b00100110111: bk_o =  44'b10101010010110101010010000111010001000010000; //  X X 5 X X 4 3 X 2 1 0
         11'b00100111000: bk_o =  44'b10101010001110101010001000010000101010101010; //  X X 3 X X 2 1 0 X X X
         11'b00100111001: bk_o =  44'b10101010010010101010001100100001101010100000; //  X X 4 X X 3 2 1 X X 0
         11'b00100111010: bk_o =  44'b10101010010010101010001100100001101000001010; //  X X 4 X X 3 2 1 X 0 X
         11'b00100111011: bk_o =  44'b10101010010110101010010000110010101000010000; //  X X 5 X X 4 3 2 X 1 0
         11'b00100111100: bk_o =  44'b10101010010010101010001100100001000010101010; //  X X 4 X X 3 2 1 0 X X
         11'b00100111101: bk_o =  44'b10101010010110101010010000110010000110100000; //  X X 5 X X 4 3 2 1 X 0
         11'b00100111110: bk_o =  44'b10101010010110101010010000110010000100001010; //  X X 5 X X 4 3 2 1 0 X
         11'b00100111111: bk_o =  44'b10101010011010101010010101000011001000010000; //  X X 6 X X 5 4 3 2 1 0
         11'b00101000000: bk_o =  44'b10101010000110100000101010101010101010101010; //  X X 1 X 0 X X X X X X
         11'b00101000001: bk_o =  44'b10101010001010100001101010101010101010100000; //  X X 2 X 1 X X X X X 0
         11'b00101000010: bk_o =  44'b10101010001010100001101010101010101000001010; //  X X 2 X 1 X X X X 0 X
         11'b00101000011: bk_o =  44'b10101010001110100010101010101010101000010000; //  X X 3 X 2 X X X X 1 0
         11'b00101000100: bk_o =  44'b10101010001010100001101010101010000010101010; //  X X 2 X 1 X X X 0 X X
         11'b00101000101: bk_o =  44'b10101010001110100010101010101010000110100000; //  X X 3 X 2 X X X 1 X 0
         11'b00101000110: bk_o =  44'b10101010001110100010101010101010000100001010; //  X X 3 X 2 X X X 1 0 X
         11'b00101000111: bk_o =  44'b10101010010010100011101010101010001000010000; //  X X 4 X 3 X X X 2 1 0
         11'b00101001000: bk_o =  44'b10101010001010100001101010100000101010101010; //  X X 2 X 1 X X 0 X X X
         11'b00101001001: bk_o =  44'b10101010001110100010101010100001101010100000; //  X X 3 X 2 X X 1 X X 0
         11'b00101001010: bk_o =  44'b10101010001110100010101010100001101000001010; //  X X 3 X 2 X X 1 X 0 X
         11'b00101001011: bk_o =  44'b10101010010010100011101010100010101000010000; //  X X 4 X 3 X X 2 X 1 0
         11'b00101001100: bk_o =  44'b10101010001110100010101010100001000010101010; //  X X 3 X 2 X X 1 0 X X
         11'b00101001101: bk_o =  44'b10101010010010100011101010100010000110100000; //  X X 4 X 3 X X 2 1 X 0
         11'b00101001110: bk_o =  44'b10101010010010100011101010100010000100001010; //  X X 4 X 3 X X 2 1 0 X
         11'b00101001111: bk_o =  44'b10101010010110100100101010100011001000010000; //  X X 5 X 4 X X 3 2 1 0
         11'b00101010000: bk_o =  44'b10101010001010100001101000001010101010101010; //  X X 2 X 1 X 0 X X X X
         11'b00101010001: bk_o =  44'b10101010001110100010101000011010101010100000; //  X X 3 X 2 X 1 X X X 0
         11'b00101010010: bk_o =  44'b10101010001110100010101000011010101000001010; //  X X 3 X 2 X 1 X X 0 X
         11'b00101010011: bk_o =  44'b10101010010010100011101000101010101000010000; //  X X 4 X 3 X 2 X X 1 0
         11'b00101010100: bk_o =  44'b10101010001110100010101000011010000010101010; //  X X 3 X 2 X 1 X 0 X X
         11'b00101010101: bk_o =  44'b10101010010010100011101000101010000110100000; //  X X 4 X 3 X 2 X 1 X 0
         11'b00101010110: bk_o =  44'b10101010010010100011101000101010000100001010; //  X X 4 X 3 X 2 X 1 0 X
         11'b00101010111: bk_o =  44'b10101010010110100100101000111010001000010000; //  X X 5 X 4 X 3 X 2 1 0
         11'b00101011000: bk_o =  44'b10101010001110100010101000010000101010101010; //  X X 3 X 2 X 1 0 X X X
         11'b00101011001: bk_o =  44'b10101010010010100011101000100001101010100000; //  X X 4 X 3 X 2 1 X X 0
         11'b00101011010: bk_o =  44'b10101010010010100011101000100001101000001010; //  X X 4 X 3 X 2 1 X 0 X
         11'b00101011011: bk_o =  44'b10101010010110100100101000110010101000010000; //  X X 5 X 4 X 3 2 X 1 0
         11'b00101011100: bk_o =  44'b10101010010010100011101000100001000010101010; //  X X 4 X 3 X 2 1 0 X X
         11'b00101011101: bk_o =  44'b10101010010110100100101000110010000110100000; //  X X 5 X 4 X 3 2 1 X 0
         11'b00101011110: bk_o =  44'b10101010010110100100101000110010000100001010; //  X X 5 X 4 X 3 2 1 0 X
         11'b00101011111: bk_o =  44'b10101010011010100101101001000011001000010000; //  X X 6 X 5 X 4 3 2 1 0
         11'b00101100000: bk_o =  44'b10101010001010100001000010101010101010101010; //  X X 2 X 1 0 X X X X X
         11'b00101100001: bk_o =  44'b10101010001110100010000110101010101010100000; //  X X 3 X 2 1 X X X X 0
         11'b00101100010: bk_o =  44'b10101010001110100010000110101010101000001010; //  X X 3 X 2 1 X X X 0 X
         11'b00101100011: bk_o =  44'b10101010010010100011001010101010101000010000; //  X X 4 X 3 2 X X X 1 0
         11'b00101100100: bk_o =  44'b10101010001110100010000110101010000010101010; //  X X 3 X 2 1 X X 0 X X
         11'b00101100101: bk_o =  44'b10101010010010100011001010101010000110100000; //  X X 4 X 3 2 X X 1 X 0
         11'b00101100110: bk_o =  44'b10101010010010100011001010101010000100001010; //  X X 4 X 3 2 X X 1 0 X
         11'b00101100111: bk_o =  44'b10101010010110100100001110101010001000010000; //  X X 5 X 4 3 X X 2 1 0
         11'b00101101000: bk_o =  44'b10101010001110100010000110100000101010101010; //  X X 3 X 2 1 X 0 X X X
         11'b00101101001: bk_o =  44'b10101010010010100011001010100001101010100000; //  X X 4 X 3 2 X 1 X X 0
         11'b00101101010: bk_o =  44'b10101010010010100011001010100001101000001010; //  X X 4 X 3 2 X 1 X 0 X
         11'b00101101011: bk_o =  44'b10101010010110100100001110100010101000010000; //  X X 5 X 4 3 X 2 X 1 0
         11'b00101101100: bk_o =  44'b10101010010010100011001010100001000010101010; //  X X 4 X 3 2 X 1 0 X X
         11'b00101101101: bk_o =  44'b10101010010110100100001110100010000110100000; //  X X 5 X 4 3 X 2 1 X 0
         11'b00101101110: bk_o =  44'b10101010010110100100001110100010000100001010; //  X X 5 X 4 3 X 2 1 0 X
         11'b00101101111: bk_o =  44'b10101010011010100101010010100011001000010000; //  X X 6 X 5 4 X 3 2 1 0
         11'b00101110000: bk_o =  44'b10101010001110100010000100001010101010101010; //  X X 3 X 2 1 0 X X X X
         11'b00101110001: bk_o =  44'b10101010010010100011001000011010101010100000; //  X X 4 X 3 2 1 X X X 0
         11'b00101110010: bk_o =  44'b10101010010010100011001000011010101000001010; //  X X 4 X 3 2 1 X X 0 X
         11'b00101110011: bk_o =  44'b10101010010110100100001100101010101000010000; //  X X 5 X 4 3 2 X X 1 0
         11'b00101110100: bk_o =  44'b10101010010010100011001000011010000010101010; //  X X 4 X 3 2 1 X 0 X X
         11'b00101110101: bk_o =  44'b10101010010110100100001100101010000110100000; //  X X 5 X 4 3 2 X 1 X 0
         11'b00101110110: bk_o =  44'b10101010010110100100001100101010000100001010; //  X X 5 X 4 3 2 X 1 0 X
         11'b00101110111: bk_o =  44'b10101010011010100101010000111010001000010000; //  X X 6 X 5 4 3 X 2 1 0
         11'b00101111000: bk_o =  44'b10101010010010100011001000010000101010101010; //  X X 4 X 3 2 1 0 X X X
         11'b00101111001: bk_o =  44'b10101010010110100100001100100001101010100000; //  X X 5 X 4 3 2 1 X X 0
         11'b00101111010: bk_o =  44'b10101010010110100100001100100001101000001010; //  X X 5 X 4 3 2 1 X 0 X
         11'b00101111011: bk_o =  44'b10101010011010100101010000110010101000010000; //  X X 6 X 5 4 3 2 X 1 0
         11'b00101111100: bk_o =  44'b10101010010110100100001100100001000010101010; //  X X 5 X 4 3 2 1 0 X X
         11'b00101111101: bk_o =  44'b10101010011010100101010000110010000110100000; //  X X 6 X 5 4 3 2 1 X 0
         11'b00101111110: bk_o =  44'b10101010011010100101010000110010000100001010; //  X X 6 X 5 4 3 2 1 0 X
         11'b00101111111: bk_o =  44'b10101010011110100110010101000011001000010000; //  X X 7 X 6 5 4 3 2 1 0
         11'b00110000000: bk_o =  44'b10101010000100001010101010101010101010101010; //  X X 1 0 X X X X X X X
         11'b00110000001: bk_o =  44'b10101010001000011010101010101010101010100000; //  X X 2 1 X X X X X X 0
         11'b00110000010: bk_o =  44'b10101010001000011010101010101010101000001010; //  X X 2 1 X X X X X 0 X
         11'b00110000011: bk_o =  44'b10101010001100101010101010101010101000010000; //  X X 3 2 X X X X X 1 0
         11'b00110000100: bk_o =  44'b10101010001000011010101010101010000010101010; //  X X 2 1 X X X X 0 X X
         11'b00110000101: bk_o =  44'b10101010001100101010101010101010000110100000; //  X X 3 2 X X X X 1 X 0
         11'b00110000110: bk_o =  44'b10101010001100101010101010101010000100001010; //  X X 3 2 X X X X 1 0 X
         11'b00110000111: bk_o =  44'b10101010010000111010101010101010001000010000; //  X X 4 3 X X X X 2 1 0
         11'b00110001000: bk_o =  44'b10101010001000011010101010100000101010101010; //  X X 2 1 X X X 0 X X X
         11'b00110001001: bk_o =  44'b10101010001100101010101010100001101010100000; //  X X 3 2 X X X 1 X X 0
         11'b00110001010: bk_o =  44'b10101010001100101010101010100001101000001010; //  X X 3 2 X X X 1 X 0 X
         11'b00110001011: bk_o =  44'b10101010010000111010101010100010101000010000; //  X X 4 3 X X X 2 X 1 0
         11'b00110001100: bk_o =  44'b10101010001100101010101010100001000010101010; //  X X 3 2 X X X 1 0 X X
         11'b00110001101: bk_o =  44'b10101010010000111010101010100010000110100000; //  X X 4 3 X X X 2 1 X 0
         11'b00110001110: bk_o =  44'b10101010010000111010101010100010000100001010; //  X X 4 3 X X X 2 1 0 X
         11'b00110001111: bk_o =  44'b10101010010101001010101010100011001000010000; //  X X 5 4 X X X 3 2 1 0
         11'b00110010000: bk_o =  44'b10101010001000011010101000001010101010101010; //  X X 2 1 X X 0 X X X X
         11'b00110010001: bk_o =  44'b10101010001100101010101000011010101010100000; //  X X 3 2 X X 1 X X X 0
         11'b00110010010: bk_o =  44'b10101010001100101010101000011010101000001010; //  X X 3 2 X X 1 X X 0 X
         11'b00110010011: bk_o =  44'b10101010010000111010101000101010101000010000; //  X X 4 3 X X 2 X X 1 0
         11'b00110010100: bk_o =  44'b10101010001100101010101000011010000010101010; //  X X 3 2 X X 1 X 0 X X
         11'b00110010101: bk_o =  44'b10101010010000111010101000101010000110100000; //  X X 4 3 X X 2 X 1 X 0
         11'b00110010110: bk_o =  44'b10101010010000111010101000101010000100001010; //  X X 4 3 X X 2 X 1 0 X
         11'b00110010111: bk_o =  44'b10101010010101001010101000111010001000010000; //  X X 5 4 X X 3 X 2 1 0
         11'b00110011000: bk_o =  44'b10101010001100101010101000010000101010101010; //  X X 3 2 X X 1 0 X X X
         11'b00110011001: bk_o =  44'b10101010010000111010101000100001101010100000; //  X X 4 3 X X 2 1 X X 0
         11'b00110011010: bk_o =  44'b10101010010000111010101000100001101000001010; //  X X 4 3 X X 2 1 X 0 X
         11'b00110011011: bk_o =  44'b10101010010101001010101000110010101000010000; //  X X 5 4 X X 3 2 X 1 0
         11'b00110011100: bk_o =  44'b10101010010000111010101000100001000010101010; //  X X 4 3 X X 2 1 0 X X
         11'b00110011101: bk_o =  44'b10101010010101001010101000110010000110100000; //  X X 5 4 X X 3 2 1 X 0
         11'b00110011110: bk_o =  44'b10101010010101001010101000110010000100001010; //  X X 5 4 X X 3 2 1 0 X
         11'b00110011111: bk_o =  44'b10101010011001011010101001000011001000010000; //  X X 6 5 X X 4 3 2 1 0
         11'b00110100000: bk_o =  44'b10101010001000011010000010101010101010101010; //  X X 2 1 X 0 X X X X X
         11'b00110100001: bk_o =  44'b10101010001100101010000110101010101010100000; //  X X 3 2 X 1 X X X X 0
         11'b00110100010: bk_o =  44'b10101010001100101010000110101010101000001010; //  X X 3 2 X 1 X X X 0 X
         11'b00110100011: bk_o =  44'b10101010010000111010001010101010101000010000; //  X X 4 3 X 2 X X X 1 0
         11'b00110100100: bk_o =  44'b10101010001100101010000110101010000010101010; //  X X 3 2 X 1 X X 0 X X
         11'b00110100101: bk_o =  44'b10101010010000111010001010101010000110100000; //  X X 4 3 X 2 X X 1 X 0
         11'b00110100110: bk_o =  44'b10101010010000111010001010101010000100001010; //  X X 4 3 X 2 X X 1 0 X
         11'b00110100111: bk_o =  44'b10101010010101001010001110101010001000010000; //  X X 5 4 X 3 X X 2 1 0
         11'b00110101000: bk_o =  44'b10101010001100101010000110100000101010101010; //  X X 3 2 X 1 X 0 X X X
         11'b00110101001: bk_o =  44'b10101010010000111010001010100001101010100000; //  X X 4 3 X 2 X 1 X X 0
         11'b00110101010: bk_o =  44'b10101010010000111010001010100001101000001010; //  X X 4 3 X 2 X 1 X 0 X
         11'b00110101011: bk_o =  44'b10101010010101001010001110100010101000010000; //  X X 5 4 X 3 X 2 X 1 0
         11'b00110101100: bk_o =  44'b10101010010000111010001010100001000010101010; //  X X 4 3 X 2 X 1 0 X X
         11'b00110101101: bk_o =  44'b10101010010101001010001110100010000110100000; //  X X 5 4 X 3 X 2 1 X 0
         11'b00110101110: bk_o =  44'b10101010010101001010001110100010000100001010; //  X X 5 4 X 3 X 2 1 0 X
         11'b00110101111: bk_o =  44'b10101010011001011010010010100011001000010000; //  X X 6 5 X 4 X 3 2 1 0
         11'b00110110000: bk_o =  44'b10101010001100101010000100001010101010101010; //  X X 3 2 X 1 0 X X X X
         11'b00110110001: bk_o =  44'b10101010010000111010001000011010101010100000; //  X X 4 3 X 2 1 X X X 0
         11'b00110110010: bk_o =  44'b10101010010000111010001000011010101000001010; //  X X 4 3 X 2 1 X X 0 X
         11'b00110110011: bk_o =  44'b10101010010101001010001100101010101000010000; //  X X 5 4 X 3 2 X X 1 0
         11'b00110110100: bk_o =  44'b10101010010000111010001000011010000010101010; //  X X 4 3 X 2 1 X 0 X X
         11'b00110110101: bk_o =  44'b10101010010101001010001100101010000110100000; //  X X 5 4 X 3 2 X 1 X 0
         11'b00110110110: bk_o =  44'b10101010010101001010001100101010000100001010; //  X X 5 4 X 3 2 X 1 0 X
         11'b00110110111: bk_o =  44'b10101010011001011010010000111010001000010000; //  X X 6 5 X 4 3 X 2 1 0
         11'b00110111000: bk_o =  44'b10101010010000111010001000010000101010101010; //  X X 4 3 X 2 1 0 X X X
         11'b00110111001: bk_o =  44'b10101010010101001010001100100001101010100000; //  X X 5 4 X 3 2 1 X X 0
         11'b00110111010: bk_o =  44'b10101010010101001010001100100001101000001010; //  X X 5 4 X 3 2 1 X 0 X
         11'b00110111011: bk_o =  44'b10101010011001011010010000110010101000010000; //  X X 6 5 X 4 3 2 X 1 0
         11'b00110111100: bk_o =  44'b10101010010101001010001100100001000010101010; //  X X 5 4 X 3 2 1 0 X X
         11'b00110111101: bk_o =  44'b10101010011001011010010000110010000110100000; //  X X 6 5 X 4 3 2 1 X 0
         11'b00110111110: bk_o =  44'b10101010011001011010010000110010000100001010; //  X X 6 5 X 4 3 2 1 0 X
         11'b00110111111: bk_o =  44'b10101010011101101010010101000011001000010000; //  X X 7 6 X 5 4 3 2 1 0
         11'b00111000000: bk_o =  44'b10101010001000010000101010101010101010101010; //  X X 2 1 0 X X X X X X
         11'b00111000001: bk_o =  44'b10101010001100100001101010101010101010100000; //  X X 3 2 1 X X X X X 0
         11'b00111000010: bk_o =  44'b10101010001100100001101010101010101000001010; //  X X 3 2 1 X X X X 0 X
         11'b00111000011: bk_o =  44'b10101010010000110010101010101010101000010000; //  X X 4 3 2 X X X X 1 0
         11'b00111000100: bk_o =  44'b10101010001100100001101010101010000010101010; //  X X 3 2 1 X X X 0 X X
         11'b00111000101: bk_o =  44'b10101010010000110010101010101010000110100000; //  X X 4 3 2 X X X 1 X 0
         11'b00111000110: bk_o =  44'b10101010010000110010101010101010000100001010; //  X X 4 3 2 X X X 1 0 X
         11'b00111000111: bk_o =  44'b10101010010101000011101010101010001000010000; //  X X 5 4 3 X X X 2 1 0
         11'b00111001000: bk_o =  44'b10101010001100100001101010100000101010101010; //  X X 3 2 1 X X 0 X X X
         11'b00111001001: bk_o =  44'b10101010010000110010101010100001101010100000; //  X X 4 3 2 X X 1 X X 0
         11'b00111001010: bk_o =  44'b10101010010000110010101010100001101000001010; //  X X 4 3 2 X X 1 X 0 X
         11'b00111001011: bk_o =  44'b10101010010101000011101010100010101000010000; //  X X 5 4 3 X X 2 X 1 0
         11'b00111001100: bk_o =  44'b10101010010000110010101010100001000010101010; //  X X 4 3 2 X X 1 0 X X
         11'b00111001101: bk_o =  44'b10101010010101000011101010100010000110100000; //  X X 5 4 3 X X 2 1 X 0
         11'b00111001110: bk_o =  44'b10101010010101000011101010100010000100001010; //  X X 5 4 3 X X 2 1 0 X
         11'b00111001111: bk_o =  44'b10101010011001010100101010100011001000010000; //  X X 6 5 4 X X 3 2 1 0
         11'b00111010000: bk_o =  44'b10101010001100100001101000001010101010101010; //  X X 3 2 1 X 0 X X X X
         11'b00111010001: bk_o =  44'b10101010010000110010101000011010101010100000; //  X X 4 3 2 X 1 X X X 0
         11'b00111010010: bk_o =  44'b10101010010000110010101000011010101000001010; //  X X 4 3 2 X 1 X X 0 X
         11'b00111010011: bk_o =  44'b10101010010101000011101000101010101000010000; //  X X 5 4 3 X 2 X X 1 0
         11'b00111010100: bk_o =  44'b10101010010000110010101000011010000010101010; //  X X 4 3 2 X 1 X 0 X X
         11'b00111010101: bk_o =  44'b10101010010101000011101000101010000110100000; //  X X 5 4 3 X 2 X 1 X 0
         11'b00111010110: bk_o =  44'b10101010010101000011101000101010000100001010; //  X X 5 4 3 X 2 X 1 0 X
         11'b00111010111: bk_o =  44'b10101010011001010100101000111010001000010000; //  X X 6 5 4 X 3 X 2 1 0
         11'b00111011000: bk_o =  44'b10101010010000110010101000010000101010101010; //  X X 4 3 2 X 1 0 X X X
         11'b00111011001: bk_o =  44'b10101010010101000011101000100001101010100000; //  X X 5 4 3 X 2 1 X X 0
         11'b00111011010: bk_o =  44'b10101010010101000011101000100001101000001010; //  X X 5 4 3 X 2 1 X 0 X
         11'b00111011011: bk_o =  44'b10101010011001010100101000110010101000010000; //  X X 6 5 4 X 3 2 X 1 0
         11'b00111011100: bk_o =  44'b10101010010101000011101000100001000010101010; //  X X 5 4 3 X 2 1 0 X X
         11'b00111011101: bk_o =  44'b10101010011001010100101000110010000110100000; //  X X 6 5 4 X 3 2 1 X 0
         11'b00111011110: bk_o =  44'b10101010011001010100101000110010000100001010; //  X X 6 5 4 X 3 2 1 0 X
         11'b00111011111: bk_o =  44'b10101010011101100101101001000011001000010000; //  X X 7 6 5 X 4 3 2 1 0
         11'b00111100000: bk_o =  44'b10101010001100100001000010101010101010101010; //  X X 3 2 1 0 X X X X X
         11'b00111100001: bk_o =  44'b10101010010000110010000110101010101010100000; //  X X 4 3 2 1 X X X X 0
         11'b00111100010: bk_o =  44'b10101010010000110010000110101010101000001010; //  X X 4 3 2 1 X X X 0 X
         11'b00111100011: bk_o =  44'b10101010010101000011001010101010101000010000; //  X X 5 4 3 2 X X X 1 0
         11'b00111100100: bk_o =  44'b10101010010000110010000110101010000010101010; //  X X 4 3 2 1 X X 0 X X
         11'b00111100101: bk_o =  44'b10101010010101000011001010101010000110100000; //  X X 5 4 3 2 X X 1 X 0
         11'b00111100110: bk_o =  44'b10101010010101000011001010101010000100001010; //  X X 5 4 3 2 X X 1 0 X
         11'b00111100111: bk_o =  44'b10101010011001010100001110101010001000010000; //  X X 6 5 4 3 X X 2 1 0
         11'b00111101000: bk_o =  44'b10101010010000110010000110100000101010101010; //  X X 4 3 2 1 X 0 X X X
         11'b00111101001: bk_o =  44'b10101010010101000011001010100001101010100000; //  X X 5 4 3 2 X 1 X X 0
         11'b00111101010: bk_o =  44'b10101010010101000011001010100001101000001010; //  X X 5 4 3 2 X 1 X 0 X
         11'b00111101011: bk_o =  44'b10101010011001010100001110100010101000010000; //  X X 6 5 4 3 X 2 X 1 0
         11'b00111101100: bk_o =  44'b10101010010101000011001010100001000010101010; //  X X 5 4 3 2 X 1 0 X X
         11'b00111101101: bk_o =  44'b10101010011001010100001110100010000110100000; //  X X 6 5 4 3 X 2 1 X 0
         11'b00111101110: bk_o =  44'b10101010011001010100001110100010000100001010; //  X X 6 5 4 3 X 2 1 0 X
         11'b00111101111: bk_o =  44'b10101010011101100101010010100011001000010000; //  X X 7 6 5 4 X 3 2 1 0
         11'b00111110000: bk_o =  44'b10101010010000110010000100001010101010101010; //  X X 4 3 2 1 0 X X X X
         11'b00111110001: bk_o =  44'b10101010010101000011001000011010101010100000; //  X X 5 4 3 2 1 X X X 0
         11'b00111110010: bk_o =  44'b10101010010101000011001000011010101000001010; //  X X 5 4 3 2 1 X X 0 X
         11'b00111110011: bk_o =  44'b10101010011001010100001100101010101000010000; //  X X 6 5 4 3 2 X X 1 0
         11'b00111110100: bk_o =  44'b10101010010101000011001000011010000010101010; //  X X 5 4 3 2 1 X 0 X X
         11'b00111110101: bk_o =  44'b10101010011001010100001100101010000110100000; //  X X 6 5 4 3 2 X 1 X 0
         11'b00111110110: bk_o =  44'b10101010011001010100001100101010000100001010; //  X X 6 5 4 3 2 X 1 0 X
         11'b00111110111: bk_o =  44'b10101010011101100101010000111010001000010000; //  X X 7 6 5 4 3 X 2 1 0
         11'b00111111000: bk_o =  44'b10101010010101000011001000010000101010101010; //  X X 5 4 3 2 1 0 X X X
         11'b00111111001: bk_o =  44'b10101010011001010100001100100001101010100000; //  X X 6 5 4 3 2 1 X X 0
         11'b00111111010: bk_o =  44'b10101010011001010100001100100001101000001010; //  X X 6 5 4 3 2 1 X 0 X
         11'b00111111011: bk_o =  44'b10101010011101100101010000110010101000010000; //  X X 7 6 5 4 3 2 X 1 0
         11'b00111111100: bk_o =  44'b10101010011001010100001100100001000010101010; //  X X 6 5 4 3 2 1 0 X X
         11'b00111111101: bk_o =  44'b10101010011101100101010000110010000110100000; //  X X 7 6 5 4 3 2 1 X 0
         11'b00111111110: bk_o =  44'b10101010011101100101010000110010000100001010; //  X X 7 6 5 4 3 2 1 0 X
         11'b00111111111: bk_o =  44'b10101010100001110110010101000011001000010000; //  X X 8 7 6 5 4 3 2 1 0
         11'b01000000000: bk_o =  44'b10100000101010101010101010101010101010101010; //  X 0 X X X X X X X X X
         11'b01000000001: bk_o =  44'b10100001101010101010101010101010101010100000; //  X 1 X X X X X X X X 0
         11'b01000000010: bk_o =  44'b10100001101010101010101010101010101000001010; //  X 1 X X X X X X X 0 X
         11'b01000000011: bk_o =  44'b10100010101010101010101010101010101000010000; //  X 2 X X X X X X X 1 0
         11'b01000000100: bk_o =  44'b10100001101010101010101010101010000010101010; //  X 1 X X X X X X 0 X X
         11'b01000000101: bk_o =  44'b10100010101010101010101010101010000110100000; //  X 2 X X X X X X 1 X 0
         11'b01000000110: bk_o =  44'b10100010101010101010101010101010000100001010; //  X 2 X X X X X X 1 0 X
         11'b01000000111: bk_o =  44'b10100011101010101010101010101010001000010000; //  X 3 X X X X X X 2 1 0
         11'b01000001000: bk_o =  44'b10100001101010101010101010100000101010101010; //  X 1 X X X X X 0 X X X
         11'b01000001001: bk_o =  44'b10100010101010101010101010100001101010100000; //  X 2 X X X X X 1 X X 0
         11'b01000001010: bk_o =  44'b10100010101010101010101010100001101000001010; //  X 2 X X X X X 1 X 0 X
         11'b01000001011: bk_o =  44'b10100011101010101010101010100010101000010000; //  X 3 X X X X X 2 X 1 0
         11'b01000001100: bk_o =  44'b10100010101010101010101010100001000010101010; //  X 2 X X X X X 1 0 X X
         11'b01000001101: bk_o =  44'b10100011101010101010101010100010000110100000; //  X 3 X X X X X 2 1 X 0
         11'b01000001110: bk_o =  44'b10100011101010101010101010100010000100001010; //  X 3 X X X X X 2 1 0 X
         11'b01000001111: bk_o =  44'b10100100101010101010101010100011001000010000; //  X 4 X X X X X 3 2 1 0
         11'b01000010000: bk_o =  44'b10100001101010101010101000001010101010101010; //  X 1 X X X X 0 X X X X
         11'b01000010001: bk_o =  44'b10100010101010101010101000011010101010100000; //  X 2 X X X X 1 X X X 0
         11'b01000010010: bk_o =  44'b10100010101010101010101000011010101000001010; //  X 2 X X X X 1 X X 0 X
         11'b01000010011: bk_o =  44'b10100011101010101010101000101010101000010000; //  X 3 X X X X 2 X X 1 0
         11'b01000010100: bk_o =  44'b10100010101010101010101000011010000010101010; //  X 2 X X X X 1 X 0 X X
         11'b01000010101: bk_o =  44'b10100011101010101010101000101010000110100000; //  X 3 X X X X 2 X 1 X 0
         11'b01000010110: bk_o =  44'b10100011101010101010101000101010000100001010; //  X 3 X X X X 2 X 1 0 X
         11'b01000010111: bk_o =  44'b10100100101010101010101000111010001000010000; //  X 4 X X X X 3 X 2 1 0
         11'b01000011000: bk_o =  44'b10100010101010101010101000010000101010101010; //  X 2 X X X X 1 0 X X X
         11'b01000011001: bk_o =  44'b10100011101010101010101000100001101010100000; //  X 3 X X X X 2 1 X X 0
         11'b01000011010: bk_o =  44'b10100011101010101010101000100001101000001010; //  X 3 X X X X 2 1 X 0 X
         11'b01000011011: bk_o =  44'b10100100101010101010101000110010101000010000; //  X 4 X X X X 3 2 X 1 0
         11'b01000011100: bk_o =  44'b10100011101010101010101000100001000010101010; //  X 3 X X X X 2 1 0 X X
         11'b01000011101: bk_o =  44'b10100100101010101010101000110010000110100000; //  X 4 X X X X 3 2 1 X 0
         11'b01000011110: bk_o =  44'b10100100101010101010101000110010000100001010; //  X 4 X X X X 3 2 1 0 X
         11'b01000011111: bk_o =  44'b10100101101010101010101001000011001000010000; //  X 5 X X X X 4 3 2 1 0
         11'b01000100000: bk_o =  44'b10100001101010101010000010101010101010101010; //  X 1 X X X 0 X X X X X
         11'b01000100001: bk_o =  44'b10100010101010101010000110101010101010100000; //  X 2 X X X 1 X X X X 0
         11'b01000100010: bk_o =  44'b10100010101010101010000110101010101000001010; //  X 2 X X X 1 X X X 0 X
         11'b01000100011: bk_o =  44'b10100011101010101010001010101010101000010000; //  X 3 X X X 2 X X X 1 0
         11'b01000100100: bk_o =  44'b10100010101010101010000110101010000010101010; //  X 2 X X X 1 X X 0 X X
         11'b01000100101: bk_o =  44'b10100011101010101010001010101010000110100000; //  X 3 X X X 2 X X 1 X 0
         11'b01000100110: bk_o =  44'b10100011101010101010001010101010000100001010; //  X 3 X X X 2 X X 1 0 X
         11'b01000100111: bk_o =  44'b10100100101010101010001110101010001000010000; //  X 4 X X X 3 X X 2 1 0
         11'b01000101000: bk_o =  44'b10100010101010101010000110100000101010101010; //  X 2 X X X 1 X 0 X X X
         11'b01000101001: bk_o =  44'b10100011101010101010001010100001101010100000; //  X 3 X X X 2 X 1 X X 0
         11'b01000101010: bk_o =  44'b10100011101010101010001010100001101000001010; //  X 3 X X X 2 X 1 X 0 X
         11'b01000101011: bk_o =  44'b10100100101010101010001110100010101000010000; //  X 4 X X X 3 X 2 X 1 0
         11'b01000101100: bk_o =  44'b10100011101010101010001010100001000010101010; //  X 3 X X X 2 X 1 0 X X
         11'b01000101101: bk_o =  44'b10100100101010101010001110100010000110100000; //  X 4 X X X 3 X 2 1 X 0
         11'b01000101110: bk_o =  44'b10100100101010101010001110100010000100001010; //  X 4 X X X 3 X 2 1 0 X
         11'b01000101111: bk_o =  44'b10100101101010101010010010100011001000010000; //  X 5 X X X 4 X 3 2 1 0
         11'b01000110000: bk_o =  44'b10100010101010101010000100001010101010101010; //  X 2 X X X 1 0 X X X X
         11'b01000110001: bk_o =  44'b10100011101010101010001000011010101010100000; //  X 3 X X X 2 1 X X X 0
         11'b01000110010: bk_o =  44'b10100011101010101010001000011010101000001010; //  X 3 X X X 2 1 X X 0 X
         11'b01000110011: bk_o =  44'b10100100101010101010001100101010101000010000; //  X 4 X X X 3 2 X X 1 0
         11'b01000110100: bk_o =  44'b10100011101010101010001000011010000010101010; //  X 3 X X X 2 1 X 0 X X
         11'b01000110101: bk_o =  44'b10100100101010101010001100101010000110100000; //  X 4 X X X 3 2 X 1 X 0
         11'b01000110110: bk_o =  44'b10100100101010101010001100101010000100001010; //  X 4 X X X 3 2 X 1 0 X
         11'b01000110111: bk_o =  44'b10100101101010101010010000111010001000010000; //  X 5 X X X 4 3 X 2 1 0
         11'b01000111000: bk_o =  44'b10100011101010101010001000010000101010101010; //  X 3 X X X 2 1 0 X X X
         11'b01000111001: bk_o =  44'b10100100101010101010001100100001101010100000; //  X 4 X X X 3 2 1 X X 0
         11'b01000111010: bk_o =  44'b10100100101010101010001100100001101000001010; //  X 4 X X X 3 2 1 X 0 X
         11'b01000111011: bk_o =  44'b10100101101010101010010000110010101000010000; //  X 5 X X X 4 3 2 X 1 0
         11'b01000111100: bk_o =  44'b10100100101010101010001100100001000010101010; //  X 4 X X X 3 2 1 0 X X
         11'b01000111101: bk_o =  44'b10100101101010101010010000110010000110100000; //  X 5 X X X 4 3 2 1 X 0
         11'b01000111110: bk_o =  44'b10100101101010101010010000110010000100001010; //  X 5 X X X 4 3 2 1 0 X
         11'b01000111111: bk_o =  44'b10100110101010101010010101000011001000010000; //  X 6 X X X 5 4 3 2 1 0
         11'b01001000000: bk_o =  44'b10100001101010100000101010101010101010101010; //  X 1 X X 0 X X X X X X
         11'b01001000001: bk_o =  44'b10100010101010100001101010101010101010100000; //  X 2 X X 1 X X X X X 0
         11'b01001000010: bk_o =  44'b10100010101010100001101010101010101000001010; //  X 2 X X 1 X X X X 0 X
         11'b01001000011: bk_o =  44'b10100011101010100010101010101010101000010000; //  X 3 X X 2 X X X X 1 0
         11'b01001000100: bk_o =  44'b10100010101010100001101010101010000010101010; //  X 2 X X 1 X X X 0 X X
         11'b01001000101: bk_o =  44'b10100011101010100010101010101010000110100000; //  X 3 X X 2 X X X 1 X 0
         11'b01001000110: bk_o =  44'b10100011101010100010101010101010000100001010; //  X 3 X X 2 X X X 1 0 X
         11'b01001000111: bk_o =  44'b10100100101010100011101010101010001000010000; //  X 4 X X 3 X X X 2 1 0
         11'b01001001000: bk_o =  44'b10100010101010100001101010100000101010101010; //  X 2 X X 1 X X 0 X X X
         11'b01001001001: bk_o =  44'b10100011101010100010101010100001101010100000; //  X 3 X X 2 X X 1 X X 0
         11'b01001001010: bk_o =  44'b10100011101010100010101010100001101000001010; //  X 3 X X 2 X X 1 X 0 X
         11'b01001001011: bk_o =  44'b10100100101010100011101010100010101000010000; //  X 4 X X 3 X X 2 X 1 0
         11'b01001001100: bk_o =  44'b10100011101010100010101010100001000010101010; //  X 3 X X 2 X X 1 0 X X
         11'b01001001101: bk_o =  44'b10100100101010100011101010100010000110100000; //  X 4 X X 3 X X 2 1 X 0
         11'b01001001110: bk_o =  44'b10100100101010100011101010100010000100001010; //  X 4 X X 3 X X 2 1 0 X
         11'b01001001111: bk_o =  44'b10100101101010100100101010100011001000010000; //  X 5 X X 4 X X 3 2 1 0
         11'b01001010000: bk_o =  44'b10100010101010100001101000001010101010101010; //  X 2 X X 1 X 0 X X X X
         11'b01001010001: bk_o =  44'b10100011101010100010101000011010101010100000; //  X 3 X X 2 X 1 X X X 0
         11'b01001010010: bk_o =  44'b10100011101010100010101000011010101000001010; //  X 3 X X 2 X 1 X X 0 X
         11'b01001010011: bk_o =  44'b10100100101010100011101000101010101000010000; //  X 4 X X 3 X 2 X X 1 0
         11'b01001010100: bk_o =  44'b10100011101010100010101000011010000010101010; //  X 3 X X 2 X 1 X 0 X X
         11'b01001010101: bk_o =  44'b10100100101010100011101000101010000110100000; //  X 4 X X 3 X 2 X 1 X 0
         11'b01001010110: bk_o =  44'b10100100101010100011101000101010000100001010; //  X 4 X X 3 X 2 X 1 0 X
         11'b01001010111: bk_o =  44'b10100101101010100100101000111010001000010000; //  X 5 X X 4 X 3 X 2 1 0
         11'b01001011000: bk_o =  44'b10100011101010100010101000010000101010101010; //  X 3 X X 2 X 1 0 X X X
         11'b01001011001: bk_o =  44'b10100100101010100011101000100001101010100000; //  X 4 X X 3 X 2 1 X X 0
         11'b01001011010: bk_o =  44'b10100100101010100011101000100001101000001010; //  X 4 X X 3 X 2 1 X 0 X
         11'b01001011011: bk_o =  44'b10100101101010100100101000110010101000010000; //  X 5 X X 4 X 3 2 X 1 0
         11'b01001011100: bk_o =  44'b10100100101010100011101000100001000010101010; //  X 4 X X 3 X 2 1 0 X X
         11'b01001011101: bk_o =  44'b10100101101010100100101000110010000110100000; //  X 5 X X 4 X 3 2 1 X 0
         11'b01001011110: bk_o =  44'b10100101101010100100101000110010000100001010; //  X 5 X X 4 X 3 2 1 0 X
         11'b01001011111: bk_o =  44'b10100110101010100101101001000011001000010000; //  X 6 X X 5 X 4 3 2 1 0
         11'b01001100000: bk_o =  44'b10100010101010100001000010101010101010101010; //  X 2 X X 1 0 X X X X X
         11'b01001100001: bk_o =  44'b10100011101010100010000110101010101010100000; //  X 3 X X 2 1 X X X X 0
         11'b01001100010: bk_o =  44'b10100011101010100010000110101010101000001010; //  X 3 X X 2 1 X X X 0 X
         11'b01001100011: bk_o =  44'b10100100101010100011001010101010101000010000; //  X 4 X X 3 2 X X X 1 0
         11'b01001100100: bk_o =  44'b10100011101010100010000110101010000010101010; //  X 3 X X 2 1 X X 0 X X
         11'b01001100101: bk_o =  44'b10100100101010100011001010101010000110100000; //  X 4 X X 3 2 X X 1 X 0
         11'b01001100110: bk_o =  44'b10100100101010100011001010101010000100001010; //  X 4 X X 3 2 X X 1 0 X
         11'b01001100111: bk_o =  44'b10100101101010100100001110101010001000010000; //  X 5 X X 4 3 X X 2 1 0
         11'b01001101000: bk_o =  44'b10100011101010100010000110100000101010101010; //  X 3 X X 2 1 X 0 X X X
         11'b01001101001: bk_o =  44'b10100100101010100011001010100001101010100000; //  X 4 X X 3 2 X 1 X X 0
         11'b01001101010: bk_o =  44'b10100100101010100011001010100001101000001010; //  X 4 X X 3 2 X 1 X 0 X
         11'b01001101011: bk_o =  44'b10100101101010100100001110100010101000010000; //  X 5 X X 4 3 X 2 X 1 0
         11'b01001101100: bk_o =  44'b10100100101010100011001010100001000010101010; //  X 4 X X 3 2 X 1 0 X X
         11'b01001101101: bk_o =  44'b10100101101010100100001110100010000110100000; //  X 5 X X 4 3 X 2 1 X 0
         11'b01001101110: bk_o =  44'b10100101101010100100001110100010000100001010; //  X 5 X X 4 3 X 2 1 0 X
         11'b01001101111: bk_o =  44'b10100110101010100101010010100011001000010000; //  X 6 X X 5 4 X 3 2 1 0
         11'b01001110000: bk_o =  44'b10100011101010100010000100001010101010101010; //  X 3 X X 2 1 0 X X X X
         11'b01001110001: bk_o =  44'b10100100101010100011001000011010101010100000; //  X 4 X X 3 2 1 X X X 0
         11'b01001110010: bk_o =  44'b10100100101010100011001000011010101000001010; //  X 4 X X 3 2 1 X X 0 X
         11'b01001110011: bk_o =  44'b10100101101010100100001100101010101000010000; //  X 5 X X 4 3 2 X X 1 0
         11'b01001110100: bk_o =  44'b10100100101010100011001000011010000010101010; //  X 4 X X 3 2 1 X 0 X X
         11'b01001110101: bk_o =  44'b10100101101010100100001100101010000110100000; //  X 5 X X 4 3 2 X 1 X 0
         11'b01001110110: bk_o =  44'b10100101101010100100001100101010000100001010; //  X 5 X X 4 3 2 X 1 0 X
         11'b01001110111: bk_o =  44'b10100110101010100101010000111010001000010000; //  X 6 X X 5 4 3 X 2 1 0
         11'b01001111000: bk_o =  44'b10100100101010100011001000010000101010101010; //  X 4 X X 3 2 1 0 X X X
         11'b01001111001: bk_o =  44'b10100101101010100100001100100001101010100000; //  X 5 X X 4 3 2 1 X X 0
         11'b01001111010: bk_o =  44'b10100101101010100100001100100001101000001010; //  X 5 X X 4 3 2 1 X 0 X
         11'b01001111011: bk_o =  44'b10100110101010100101010000110010101000010000; //  X 6 X X 5 4 3 2 X 1 0
         11'b01001111100: bk_o =  44'b10100101101010100100001100100001000010101010; //  X 5 X X 4 3 2 1 0 X X
         11'b01001111101: bk_o =  44'b10100110101010100101010000110010000110100000; //  X 6 X X 5 4 3 2 1 X 0
         11'b01001111110: bk_o =  44'b10100110101010100101010000110010000100001010; //  X 6 X X 5 4 3 2 1 0 X
         11'b01001111111: bk_o =  44'b10100111101010100110010101000011001000010000; //  X 7 X X 6 5 4 3 2 1 0
         11'b01010000000: bk_o =  44'b10100001101000001010101010101010101010101010; //  X 1 X 0 X X X X X X X
         11'b01010000001: bk_o =  44'b10100010101000011010101010101010101010100000; //  X 2 X 1 X X X X X X 0
         11'b01010000010: bk_o =  44'b10100010101000011010101010101010101000001010; //  X 2 X 1 X X X X X 0 X
         11'b01010000011: bk_o =  44'b10100011101000101010101010101010101000010000; //  X 3 X 2 X X X X X 1 0
         11'b01010000100: bk_o =  44'b10100010101000011010101010101010000010101010; //  X 2 X 1 X X X X 0 X X
         11'b01010000101: bk_o =  44'b10100011101000101010101010101010000110100000; //  X 3 X 2 X X X X 1 X 0
         11'b01010000110: bk_o =  44'b10100011101000101010101010101010000100001010; //  X 3 X 2 X X X X 1 0 X
         11'b01010000111: bk_o =  44'b10100100101000111010101010101010001000010000; //  X 4 X 3 X X X X 2 1 0
         11'b01010001000: bk_o =  44'b10100010101000011010101010100000101010101010; //  X 2 X 1 X X X 0 X X X
         11'b01010001001: bk_o =  44'b10100011101000101010101010100001101010100000; //  X 3 X 2 X X X 1 X X 0
         11'b01010001010: bk_o =  44'b10100011101000101010101010100001101000001010; //  X 3 X 2 X X X 1 X 0 X
         11'b01010001011: bk_o =  44'b10100100101000111010101010100010101000010000; //  X 4 X 3 X X X 2 X 1 0
         11'b01010001100: bk_o =  44'b10100011101000101010101010100001000010101010; //  X 3 X 2 X X X 1 0 X X
         11'b01010001101: bk_o =  44'b10100100101000111010101010100010000110100000; //  X 4 X 3 X X X 2 1 X 0
         11'b01010001110: bk_o =  44'b10100100101000111010101010100010000100001010; //  X 4 X 3 X X X 2 1 0 X
         11'b01010001111: bk_o =  44'b10100101101001001010101010100011001000010000; //  X 5 X 4 X X X 3 2 1 0
         11'b01010010000: bk_o =  44'b10100010101000011010101000001010101010101010; //  X 2 X 1 X X 0 X X X X
         11'b01010010001: bk_o =  44'b10100011101000101010101000011010101010100000; //  X 3 X 2 X X 1 X X X 0
         11'b01010010010: bk_o =  44'b10100011101000101010101000011010101000001010; //  X 3 X 2 X X 1 X X 0 X
         11'b01010010011: bk_o =  44'b10100100101000111010101000101010101000010000; //  X 4 X 3 X X 2 X X 1 0
         11'b01010010100: bk_o =  44'b10100011101000101010101000011010000010101010; //  X 3 X 2 X X 1 X 0 X X
         11'b01010010101: bk_o =  44'b10100100101000111010101000101010000110100000; //  X 4 X 3 X X 2 X 1 X 0
         11'b01010010110: bk_o =  44'b10100100101000111010101000101010000100001010; //  X 4 X 3 X X 2 X 1 0 X
         11'b01010010111: bk_o =  44'b10100101101001001010101000111010001000010000; //  X 5 X 4 X X 3 X 2 1 0
         11'b01010011000: bk_o =  44'b10100011101000101010101000010000101010101010; //  X 3 X 2 X X 1 0 X X X
         11'b01010011001: bk_o =  44'b10100100101000111010101000100001101010100000; //  X 4 X 3 X X 2 1 X X 0
         11'b01010011010: bk_o =  44'b10100100101000111010101000100001101000001010; //  X 4 X 3 X X 2 1 X 0 X
         11'b01010011011: bk_o =  44'b10100101101001001010101000110010101000010000; //  X 5 X 4 X X 3 2 X 1 0
         11'b01010011100: bk_o =  44'b10100100101000111010101000100001000010101010; //  X 4 X 3 X X 2 1 0 X X
         11'b01010011101: bk_o =  44'b10100101101001001010101000110010000110100000; //  X 5 X 4 X X 3 2 1 X 0
         11'b01010011110: bk_o =  44'b10100101101001001010101000110010000100001010; //  X 5 X 4 X X 3 2 1 0 X
         11'b01010011111: bk_o =  44'b10100110101001011010101001000011001000010000; //  X 6 X 5 X X 4 3 2 1 0
         11'b01010100000: bk_o =  44'b10100010101000011010000010101010101010101010; //  X 2 X 1 X 0 X X X X X
         11'b01010100001: bk_o =  44'b10100011101000101010000110101010101010100000; //  X 3 X 2 X 1 X X X X 0
         11'b01010100010: bk_o =  44'b10100011101000101010000110101010101000001010; //  X 3 X 2 X 1 X X X 0 X
         11'b01010100011: bk_o =  44'b10100100101000111010001010101010101000010000; //  X 4 X 3 X 2 X X X 1 0
         11'b01010100100: bk_o =  44'b10100011101000101010000110101010000010101010; //  X 3 X 2 X 1 X X 0 X X
         11'b01010100101: bk_o =  44'b10100100101000111010001010101010000110100000; //  X 4 X 3 X 2 X X 1 X 0
         11'b01010100110: bk_o =  44'b10100100101000111010001010101010000100001010; //  X 4 X 3 X 2 X X 1 0 X
         11'b01010100111: bk_o =  44'b10100101101001001010001110101010001000010000; //  X 5 X 4 X 3 X X 2 1 0
         11'b01010101000: bk_o =  44'b10100011101000101010000110100000101010101010; //  X 3 X 2 X 1 X 0 X X X
         11'b01010101001: bk_o =  44'b10100100101000111010001010100001101010100000; //  X 4 X 3 X 2 X 1 X X 0
         11'b01010101010: bk_o =  44'b10100100101000111010001010100001101000001010; //  X 4 X 3 X 2 X 1 X 0 X
         11'b01010101011: bk_o =  44'b10100101101001001010001110100010101000010000; //  X 5 X 4 X 3 X 2 X 1 0
         11'b01010101100: bk_o =  44'b10100100101000111010001010100001000010101010; //  X 4 X 3 X 2 X 1 0 X X
         11'b01010101101: bk_o =  44'b10100101101001001010001110100010000110100000; //  X 5 X 4 X 3 X 2 1 X 0
         11'b01010101110: bk_o =  44'b10100101101001001010001110100010000100001010; //  X 5 X 4 X 3 X 2 1 0 X
         11'b01010101111: bk_o =  44'b10100110101001011010010010100011001000010000; //  X 6 X 5 X 4 X 3 2 1 0
         11'b01010110000: bk_o =  44'b10100011101000101010000100001010101010101010; //  X 3 X 2 X 1 0 X X X X
         11'b01010110001: bk_o =  44'b10100100101000111010001000011010101010100000; //  X 4 X 3 X 2 1 X X X 0
         11'b01010110010: bk_o =  44'b10100100101000111010001000011010101000001010; //  X 4 X 3 X 2 1 X X 0 X
         11'b01010110011: bk_o =  44'b10100101101001001010001100101010101000010000; //  X 5 X 4 X 3 2 X X 1 0
         11'b01010110100: bk_o =  44'b10100100101000111010001000011010000010101010; //  X 4 X 3 X 2 1 X 0 X X
         11'b01010110101: bk_o =  44'b10100101101001001010001100101010000110100000; //  X 5 X 4 X 3 2 X 1 X 0
         11'b01010110110: bk_o =  44'b10100101101001001010001100101010000100001010; //  X 5 X 4 X 3 2 X 1 0 X
         11'b01010110111: bk_o =  44'b10100110101001011010010000111010001000010000; //  X 6 X 5 X 4 3 X 2 1 0
         11'b01010111000: bk_o =  44'b10100100101000111010001000010000101010101010; //  X 4 X 3 X 2 1 0 X X X
         11'b01010111001: bk_o =  44'b10100101101001001010001100100001101010100000; //  X 5 X 4 X 3 2 1 X X 0
         11'b01010111010: bk_o =  44'b10100101101001001010001100100001101000001010; //  X 5 X 4 X 3 2 1 X 0 X
         11'b01010111011: bk_o =  44'b10100110101001011010010000110010101000010000; //  X 6 X 5 X 4 3 2 X 1 0
         11'b01010111100: bk_o =  44'b10100101101001001010001100100001000010101010; //  X 5 X 4 X 3 2 1 0 X X
         11'b01010111101: bk_o =  44'b10100110101001011010010000110010000110100000; //  X 6 X 5 X 4 3 2 1 X 0
         11'b01010111110: bk_o =  44'b10100110101001011010010000110010000100001010; //  X 6 X 5 X 4 3 2 1 0 X
         11'b01010111111: bk_o =  44'b10100111101001101010010101000011001000010000; //  X 7 X 6 X 5 4 3 2 1 0
         11'b01011000000: bk_o =  44'b10100010101000010000101010101010101010101010; //  X 2 X 1 0 X X X X X X
         11'b01011000001: bk_o =  44'b10100011101000100001101010101010101010100000; //  X 3 X 2 1 X X X X X 0
         11'b01011000010: bk_o =  44'b10100011101000100001101010101010101000001010; //  X 3 X 2 1 X X X X 0 X
         11'b01011000011: bk_o =  44'b10100100101000110010101010101010101000010000; //  X 4 X 3 2 X X X X 1 0
         11'b01011000100: bk_o =  44'b10100011101000100001101010101010000010101010; //  X 3 X 2 1 X X X 0 X X
         11'b01011000101: bk_o =  44'b10100100101000110010101010101010000110100000; //  X 4 X 3 2 X X X 1 X 0
         11'b01011000110: bk_o =  44'b10100100101000110010101010101010000100001010; //  X 4 X 3 2 X X X 1 0 X
         11'b01011000111: bk_o =  44'b10100101101001000011101010101010001000010000; //  X 5 X 4 3 X X X 2 1 0
         11'b01011001000: bk_o =  44'b10100011101000100001101010100000101010101010; //  X 3 X 2 1 X X 0 X X X
         11'b01011001001: bk_o =  44'b10100100101000110010101010100001101010100000; //  X 4 X 3 2 X X 1 X X 0
         11'b01011001010: bk_o =  44'b10100100101000110010101010100001101000001010; //  X 4 X 3 2 X X 1 X 0 X
         11'b01011001011: bk_o =  44'b10100101101001000011101010100010101000010000; //  X 5 X 4 3 X X 2 X 1 0
         11'b01011001100: bk_o =  44'b10100100101000110010101010100001000010101010; //  X 4 X 3 2 X X 1 0 X X
         11'b01011001101: bk_o =  44'b10100101101001000011101010100010000110100000; //  X 5 X 4 3 X X 2 1 X 0
         11'b01011001110: bk_o =  44'b10100101101001000011101010100010000100001010; //  X 5 X 4 3 X X 2 1 0 X
         11'b01011001111: bk_o =  44'b10100110101001010100101010100011001000010000; //  X 6 X 5 4 X X 3 2 1 0
         11'b01011010000: bk_o =  44'b10100011101000100001101000001010101010101010; //  X 3 X 2 1 X 0 X X X X
         11'b01011010001: bk_o =  44'b10100100101000110010101000011010101010100000; //  X 4 X 3 2 X 1 X X X 0
         11'b01011010010: bk_o =  44'b10100100101000110010101000011010101000001010; //  X 4 X 3 2 X 1 X X 0 X
         11'b01011010011: bk_o =  44'b10100101101001000011101000101010101000010000; //  X 5 X 4 3 X 2 X X 1 0
         11'b01011010100: bk_o =  44'b10100100101000110010101000011010000010101010; //  X 4 X 3 2 X 1 X 0 X X
         11'b01011010101: bk_o =  44'b10100101101001000011101000101010000110100000; //  X 5 X 4 3 X 2 X 1 X 0
         11'b01011010110: bk_o =  44'b10100101101001000011101000101010000100001010; //  X 5 X 4 3 X 2 X 1 0 X
         11'b01011010111: bk_o =  44'b10100110101001010100101000111010001000010000; //  X 6 X 5 4 X 3 X 2 1 0
         11'b01011011000: bk_o =  44'b10100100101000110010101000010000101010101010; //  X 4 X 3 2 X 1 0 X X X
         11'b01011011001: bk_o =  44'b10100101101001000011101000100001101010100000; //  X 5 X 4 3 X 2 1 X X 0
         11'b01011011010: bk_o =  44'b10100101101001000011101000100001101000001010; //  X 5 X 4 3 X 2 1 X 0 X
         11'b01011011011: bk_o =  44'b10100110101001010100101000110010101000010000; //  X 6 X 5 4 X 3 2 X 1 0
         11'b01011011100: bk_o =  44'b10100101101001000011101000100001000010101010; //  X 5 X 4 3 X 2 1 0 X X
         11'b01011011101: bk_o =  44'b10100110101001010100101000110010000110100000; //  X 6 X 5 4 X 3 2 1 X 0
         11'b01011011110: bk_o =  44'b10100110101001010100101000110010000100001010; //  X 6 X 5 4 X 3 2 1 0 X
         11'b01011011111: bk_o =  44'b10100111101001100101101001000011001000010000; //  X 7 X 6 5 X 4 3 2 1 0
         11'b01011100000: bk_o =  44'b10100011101000100001000010101010101010101010; //  X 3 X 2 1 0 X X X X X
         11'b01011100001: bk_o =  44'b10100100101000110010000110101010101010100000; //  X 4 X 3 2 1 X X X X 0
         11'b01011100010: bk_o =  44'b10100100101000110010000110101010101000001010; //  X 4 X 3 2 1 X X X 0 X
         11'b01011100011: bk_o =  44'b10100101101001000011001010101010101000010000; //  X 5 X 4 3 2 X X X 1 0
         11'b01011100100: bk_o =  44'b10100100101000110010000110101010000010101010; //  X 4 X 3 2 1 X X 0 X X
         11'b01011100101: bk_o =  44'b10100101101001000011001010101010000110100000; //  X 5 X 4 3 2 X X 1 X 0
         11'b01011100110: bk_o =  44'b10100101101001000011001010101010000100001010; //  X 5 X 4 3 2 X X 1 0 X
         11'b01011100111: bk_o =  44'b10100110101001010100001110101010001000010000; //  X 6 X 5 4 3 X X 2 1 0
         11'b01011101000: bk_o =  44'b10100100101000110010000110100000101010101010; //  X 4 X 3 2 1 X 0 X X X
         11'b01011101001: bk_o =  44'b10100101101001000011001010100001101010100000; //  X 5 X 4 3 2 X 1 X X 0
         11'b01011101010: bk_o =  44'b10100101101001000011001010100001101000001010; //  X 5 X 4 3 2 X 1 X 0 X
         11'b01011101011: bk_o =  44'b10100110101001010100001110100010101000010000; //  X 6 X 5 4 3 X 2 X 1 0
         11'b01011101100: bk_o =  44'b10100101101001000011001010100001000010101010; //  X 5 X 4 3 2 X 1 0 X X
         11'b01011101101: bk_o =  44'b10100110101001010100001110100010000110100000; //  X 6 X 5 4 3 X 2 1 X 0
         11'b01011101110: bk_o =  44'b10100110101001010100001110100010000100001010; //  X 6 X 5 4 3 X 2 1 0 X
         11'b01011101111: bk_o =  44'b10100111101001100101010010100011001000010000; //  X 7 X 6 5 4 X 3 2 1 0
         11'b01011110000: bk_o =  44'b10100100101000110010000100001010101010101010; //  X 4 X 3 2 1 0 X X X X
         11'b01011110001: bk_o =  44'b10100101101001000011001000011010101010100000; //  X 5 X 4 3 2 1 X X X 0
         11'b01011110010: bk_o =  44'b10100101101001000011001000011010101000001010; //  X 5 X 4 3 2 1 X X 0 X
         11'b01011110011: bk_o =  44'b10100110101001010100001100101010101000010000; //  X 6 X 5 4 3 2 X X 1 0
         11'b01011110100: bk_o =  44'b10100101101001000011001000011010000010101010; //  X 5 X 4 3 2 1 X 0 X X
         11'b01011110101: bk_o =  44'b10100110101001010100001100101010000110100000; //  X 6 X 5 4 3 2 X 1 X 0
         11'b01011110110: bk_o =  44'b10100110101001010100001100101010000100001010; //  X 6 X 5 4 3 2 X 1 0 X
         11'b01011110111: bk_o =  44'b10100111101001100101010000111010001000010000; //  X 7 X 6 5 4 3 X 2 1 0
         11'b01011111000: bk_o =  44'b10100101101001000011001000010000101010101010; //  X 5 X 4 3 2 1 0 X X X
         11'b01011111001: bk_o =  44'b10100110101001010100001100100001101010100000; //  X 6 X 5 4 3 2 1 X X 0
         11'b01011111010: bk_o =  44'b10100110101001010100001100100001101000001010; //  X 6 X 5 4 3 2 1 X 0 X
         11'b01011111011: bk_o =  44'b10100111101001100101010000110010101000010000; //  X 7 X 6 5 4 3 2 X 1 0
         11'b01011111100: bk_o =  44'b10100110101001010100001100100001000010101010; //  X 6 X 5 4 3 2 1 0 X X
         11'b01011111101: bk_o =  44'b10100111101001100101010000110010000110100000; //  X 7 X 6 5 4 3 2 1 X 0
         11'b01011111110: bk_o =  44'b10100111101001100101010000110010000100001010; //  X 7 X 6 5 4 3 2 1 0 X
         11'b01011111111: bk_o =  44'b10101000101001110110010101000011001000010000; //  X 8 X 7 6 5 4 3 2 1 0
         11'b01100000000: bk_o =  44'b10100001000010101010101010101010101010101010; //  X 1 0 X X X X X X X X
         11'b01100000001: bk_o =  44'b10100010000110101010101010101010101010100000; //  X 2 1 X X X X X X X 0
         11'b01100000010: bk_o =  44'b10100010000110101010101010101010101000001010; //  X 2 1 X X X X X X 0 X
         11'b01100000011: bk_o =  44'b10100011001010101010101010101010101000010000; //  X 3 2 X X X X X X 1 0
         11'b01100000100: bk_o =  44'b10100010000110101010101010101010000010101010; //  X 2 1 X X X X X 0 X X
         11'b01100000101: bk_o =  44'b10100011001010101010101010101010000110100000; //  X 3 2 X X X X X 1 X 0
         11'b01100000110: bk_o =  44'b10100011001010101010101010101010000100001010; //  X 3 2 X X X X X 1 0 X
         11'b01100000111: bk_o =  44'b10100100001110101010101010101010001000010000; //  X 4 3 X X X X X 2 1 0
         11'b01100001000: bk_o =  44'b10100010000110101010101010100000101010101010; //  X 2 1 X X X X 0 X X X
         11'b01100001001: bk_o =  44'b10100011001010101010101010100001101010100000; //  X 3 2 X X X X 1 X X 0
         11'b01100001010: bk_o =  44'b10100011001010101010101010100001101000001010; //  X 3 2 X X X X 1 X 0 X
         11'b01100001011: bk_o =  44'b10100100001110101010101010100010101000010000; //  X 4 3 X X X X 2 X 1 0
         11'b01100001100: bk_o =  44'b10100011001010101010101010100001000010101010; //  X 3 2 X X X X 1 0 X X
         11'b01100001101: bk_o =  44'b10100100001110101010101010100010000110100000; //  X 4 3 X X X X 2 1 X 0
         11'b01100001110: bk_o =  44'b10100100001110101010101010100010000100001010; //  X 4 3 X X X X 2 1 0 X
         11'b01100001111: bk_o =  44'b10100101010010101010101010100011001000010000; //  X 5 4 X X X X 3 2 1 0
         11'b01100010000: bk_o =  44'b10100010000110101010101000001010101010101010; //  X 2 1 X X X 0 X X X X
         11'b01100010001: bk_o =  44'b10100011001010101010101000011010101010100000; //  X 3 2 X X X 1 X X X 0
         11'b01100010010: bk_o =  44'b10100011001010101010101000011010101000001010; //  X 3 2 X X X 1 X X 0 X
         11'b01100010011: bk_o =  44'b10100100001110101010101000101010101000010000; //  X 4 3 X X X 2 X X 1 0
         11'b01100010100: bk_o =  44'b10100011001010101010101000011010000010101010; //  X 3 2 X X X 1 X 0 X X
         11'b01100010101: bk_o =  44'b10100100001110101010101000101010000110100000; //  X 4 3 X X X 2 X 1 X 0
         11'b01100010110: bk_o =  44'b10100100001110101010101000101010000100001010; //  X 4 3 X X X 2 X 1 0 X
         11'b01100010111: bk_o =  44'b10100101010010101010101000111010001000010000; //  X 5 4 X X X 3 X 2 1 0
         11'b01100011000: bk_o =  44'b10100011001010101010101000010000101010101010; //  X 3 2 X X X 1 0 X X X
         11'b01100011001: bk_o =  44'b10100100001110101010101000100001101010100000; //  X 4 3 X X X 2 1 X X 0
         11'b01100011010: bk_o =  44'b10100100001110101010101000100001101000001010; //  X 4 3 X X X 2 1 X 0 X
         11'b01100011011: bk_o =  44'b10100101010010101010101000110010101000010000; //  X 5 4 X X X 3 2 X 1 0
         11'b01100011100: bk_o =  44'b10100100001110101010101000100001000010101010; //  X 4 3 X X X 2 1 0 X X
         11'b01100011101: bk_o =  44'b10100101010010101010101000110010000110100000; //  X 5 4 X X X 3 2 1 X 0
         11'b01100011110: bk_o =  44'b10100101010010101010101000110010000100001010; //  X 5 4 X X X 3 2 1 0 X
         11'b01100011111: bk_o =  44'b10100110010110101010101001000011001000010000; //  X 6 5 X X X 4 3 2 1 0
         11'b01100100000: bk_o =  44'b10100010000110101010000010101010101010101010; //  X 2 1 X X 0 X X X X X
         11'b01100100001: bk_o =  44'b10100011001010101010000110101010101010100000; //  X 3 2 X X 1 X X X X 0
         11'b01100100010: bk_o =  44'b10100011001010101010000110101010101000001010; //  X 3 2 X X 1 X X X 0 X
         11'b01100100011: bk_o =  44'b10100100001110101010001010101010101000010000; //  X 4 3 X X 2 X X X 1 0
         11'b01100100100: bk_o =  44'b10100011001010101010000110101010000010101010; //  X 3 2 X X 1 X X 0 X X
         11'b01100100101: bk_o =  44'b10100100001110101010001010101010000110100000; //  X 4 3 X X 2 X X 1 X 0
         11'b01100100110: bk_o =  44'b10100100001110101010001010101010000100001010; //  X 4 3 X X 2 X X 1 0 X
         11'b01100100111: bk_o =  44'b10100101010010101010001110101010001000010000; //  X 5 4 X X 3 X X 2 1 0
         11'b01100101000: bk_o =  44'b10100011001010101010000110100000101010101010; //  X 3 2 X X 1 X 0 X X X
         11'b01100101001: bk_o =  44'b10100100001110101010001010100001101010100000; //  X 4 3 X X 2 X 1 X X 0
         11'b01100101010: bk_o =  44'b10100100001110101010001010100001101000001010; //  X 4 3 X X 2 X 1 X 0 X
         11'b01100101011: bk_o =  44'b10100101010010101010001110100010101000010000; //  X 5 4 X X 3 X 2 X 1 0
         11'b01100101100: bk_o =  44'b10100100001110101010001010100001000010101010; //  X 4 3 X X 2 X 1 0 X X
         11'b01100101101: bk_o =  44'b10100101010010101010001110100010000110100000; //  X 5 4 X X 3 X 2 1 X 0
         11'b01100101110: bk_o =  44'b10100101010010101010001110100010000100001010; //  X 5 4 X X 3 X 2 1 0 X
         11'b01100101111: bk_o =  44'b10100110010110101010010010100011001000010000; //  X 6 5 X X 4 X 3 2 1 0
         11'b01100110000: bk_o =  44'b10100011001010101010000100001010101010101010; //  X 3 2 X X 1 0 X X X X
         11'b01100110001: bk_o =  44'b10100100001110101010001000011010101010100000; //  X 4 3 X X 2 1 X X X 0
         11'b01100110010: bk_o =  44'b10100100001110101010001000011010101000001010; //  X 4 3 X X 2 1 X X 0 X
         11'b01100110011: bk_o =  44'b10100101010010101010001100101010101000010000; //  X 5 4 X X 3 2 X X 1 0
         11'b01100110100: bk_o =  44'b10100100001110101010001000011010000010101010; //  X 4 3 X X 2 1 X 0 X X
         11'b01100110101: bk_o =  44'b10100101010010101010001100101010000110100000; //  X 5 4 X X 3 2 X 1 X 0
         11'b01100110110: bk_o =  44'b10100101010010101010001100101010000100001010; //  X 5 4 X X 3 2 X 1 0 X
         11'b01100110111: bk_o =  44'b10100110010110101010010000111010001000010000; //  X 6 5 X X 4 3 X 2 1 0
         11'b01100111000: bk_o =  44'b10100100001110101010001000010000101010101010; //  X 4 3 X X 2 1 0 X X X
         11'b01100111001: bk_o =  44'b10100101010010101010001100100001101010100000; //  X 5 4 X X 3 2 1 X X 0
         11'b01100111010: bk_o =  44'b10100101010010101010001100100001101000001010; //  X 5 4 X X 3 2 1 X 0 X
         11'b01100111011: bk_o =  44'b10100110010110101010010000110010101000010000; //  X 6 5 X X 4 3 2 X 1 0
         11'b01100111100: bk_o =  44'b10100101010010101010001100100001000010101010; //  X 5 4 X X 3 2 1 0 X X
         11'b01100111101: bk_o =  44'b10100110010110101010010000110010000110100000; //  X 6 5 X X 4 3 2 1 X 0
         11'b01100111110: bk_o =  44'b10100110010110101010010000110010000100001010; //  X 6 5 X X 4 3 2 1 0 X
         11'b01100111111: bk_o =  44'b10100111011010101010010101000011001000010000; //  X 7 6 X X 5 4 3 2 1 0
         11'b01101000000: bk_o =  44'b10100010000110100000101010101010101010101010; //  X 2 1 X 0 X X X X X X
         11'b01101000001: bk_o =  44'b10100011001010100001101010101010101010100000; //  X 3 2 X 1 X X X X X 0
         11'b01101000010: bk_o =  44'b10100011001010100001101010101010101000001010; //  X 3 2 X 1 X X X X 0 X
         11'b01101000011: bk_o =  44'b10100100001110100010101010101010101000010000; //  X 4 3 X 2 X X X X 1 0
         11'b01101000100: bk_o =  44'b10100011001010100001101010101010000010101010; //  X 3 2 X 1 X X X 0 X X
         11'b01101000101: bk_o =  44'b10100100001110100010101010101010000110100000; //  X 4 3 X 2 X X X 1 X 0
         11'b01101000110: bk_o =  44'b10100100001110100010101010101010000100001010; //  X 4 3 X 2 X X X 1 0 X
         11'b01101000111: bk_o =  44'b10100101010010100011101010101010001000010000; //  X 5 4 X 3 X X X 2 1 0
         11'b01101001000: bk_o =  44'b10100011001010100001101010100000101010101010; //  X 3 2 X 1 X X 0 X X X
         11'b01101001001: bk_o =  44'b10100100001110100010101010100001101010100000; //  X 4 3 X 2 X X 1 X X 0
         11'b01101001010: bk_o =  44'b10100100001110100010101010100001101000001010; //  X 4 3 X 2 X X 1 X 0 X
         11'b01101001011: bk_o =  44'b10100101010010100011101010100010101000010000; //  X 5 4 X 3 X X 2 X 1 0
         11'b01101001100: bk_o =  44'b10100100001110100010101010100001000010101010; //  X 4 3 X 2 X X 1 0 X X
         11'b01101001101: bk_o =  44'b10100101010010100011101010100010000110100000; //  X 5 4 X 3 X X 2 1 X 0
         11'b01101001110: bk_o =  44'b10100101010010100011101010100010000100001010; //  X 5 4 X 3 X X 2 1 0 X
         11'b01101001111: bk_o =  44'b10100110010110100100101010100011001000010000; //  X 6 5 X 4 X X 3 2 1 0
         11'b01101010000: bk_o =  44'b10100011001010100001101000001010101010101010; //  X 3 2 X 1 X 0 X X X X
         11'b01101010001: bk_o =  44'b10100100001110100010101000011010101010100000; //  X 4 3 X 2 X 1 X X X 0
         11'b01101010010: bk_o =  44'b10100100001110100010101000011010101000001010; //  X 4 3 X 2 X 1 X X 0 X
         11'b01101010011: bk_o =  44'b10100101010010100011101000101010101000010000; //  X 5 4 X 3 X 2 X X 1 0
         11'b01101010100: bk_o =  44'b10100100001110100010101000011010000010101010; //  X 4 3 X 2 X 1 X 0 X X
         11'b01101010101: bk_o =  44'b10100101010010100011101000101010000110100000; //  X 5 4 X 3 X 2 X 1 X 0
         11'b01101010110: bk_o =  44'b10100101010010100011101000101010000100001010; //  X 5 4 X 3 X 2 X 1 0 X
         11'b01101010111: bk_o =  44'b10100110010110100100101000111010001000010000; //  X 6 5 X 4 X 3 X 2 1 0
         11'b01101011000: bk_o =  44'b10100100001110100010101000010000101010101010; //  X 4 3 X 2 X 1 0 X X X
         11'b01101011001: bk_o =  44'b10100101010010100011101000100001101010100000; //  X 5 4 X 3 X 2 1 X X 0
         11'b01101011010: bk_o =  44'b10100101010010100011101000100001101000001010; //  X 5 4 X 3 X 2 1 X 0 X
         11'b01101011011: bk_o =  44'b10100110010110100100101000110010101000010000; //  X 6 5 X 4 X 3 2 X 1 0
         11'b01101011100: bk_o =  44'b10100101010010100011101000100001000010101010; //  X 5 4 X 3 X 2 1 0 X X
         11'b01101011101: bk_o =  44'b10100110010110100100101000110010000110100000; //  X 6 5 X 4 X 3 2 1 X 0
         11'b01101011110: bk_o =  44'b10100110010110100100101000110010000100001010; //  X 6 5 X 4 X 3 2 1 0 X
         11'b01101011111: bk_o =  44'b10100111011010100101101001000011001000010000; //  X 7 6 X 5 X 4 3 2 1 0
         11'b01101100000: bk_o =  44'b10100011001010100001000010101010101010101010; //  X 3 2 X 1 0 X X X X X
         11'b01101100001: bk_o =  44'b10100100001110100010000110101010101010100000; //  X 4 3 X 2 1 X X X X 0
         11'b01101100010: bk_o =  44'b10100100001110100010000110101010101000001010; //  X 4 3 X 2 1 X X X 0 X
         11'b01101100011: bk_o =  44'b10100101010010100011001010101010101000010000; //  X 5 4 X 3 2 X X X 1 0
         11'b01101100100: bk_o =  44'b10100100001110100010000110101010000010101010; //  X 4 3 X 2 1 X X 0 X X
         11'b01101100101: bk_o =  44'b10100101010010100011001010101010000110100000; //  X 5 4 X 3 2 X X 1 X 0
         11'b01101100110: bk_o =  44'b10100101010010100011001010101010000100001010; //  X 5 4 X 3 2 X X 1 0 X
         11'b01101100111: bk_o =  44'b10100110010110100100001110101010001000010000; //  X 6 5 X 4 3 X X 2 1 0
         11'b01101101000: bk_o =  44'b10100100001110100010000110100000101010101010; //  X 4 3 X 2 1 X 0 X X X
         11'b01101101001: bk_o =  44'b10100101010010100011001010100001101010100000; //  X 5 4 X 3 2 X 1 X X 0
         11'b01101101010: bk_o =  44'b10100101010010100011001010100001101000001010; //  X 5 4 X 3 2 X 1 X 0 X
         11'b01101101011: bk_o =  44'b10100110010110100100001110100010101000010000; //  X 6 5 X 4 3 X 2 X 1 0
         11'b01101101100: bk_o =  44'b10100101010010100011001010100001000010101010; //  X 5 4 X 3 2 X 1 0 X X
         11'b01101101101: bk_o =  44'b10100110010110100100001110100010000110100000; //  X 6 5 X 4 3 X 2 1 X 0
         11'b01101101110: bk_o =  44'b10100110010110100100001110100010000100001010; //  X 6 5 X 4 3 X 2 1 0 X
         11'b01101101111: bk_o =  44'b10100111011010100101010010100011001000010000; //  X 7 6 X 5 4 X 3 2 1 0
         11'b01101110000: bk_o =  44'b10100100001110100010000100001010101010101010; //  X 4 3 X 2 1 0 X X X X
         11'b01101110001: bk_o =  44'b10100101010010100011001000011010101010100000; //  X 5 4 X 3 2 1 X X X 0
         11'b01101110010: bk_o =  44'b10100101010010100011001000011010101000001010; //  X 5 4 X 3 2 1 X X 0 X
         11'b01101110011: bk_o =  44'b10100110010110100100001100101010101000010000; //  X 6 5 X 4 3 2 X X 1 0
         11'b01101110100: bk_o =  44'b10100101010010100011001000011010000010101010; //  X 5 4 X 3 2 1 X 0 X X
         11'b01101110101: bk_o =  44'b10100110010110100100001100101010000110100000; //  X 6 5 X 4 3 2 X 1 X 0
         11'b01101110110: bk_o =  44'b10100110010110100100001100101010000100001010; //  X 6 5 X 4 3 2 X 1 0 X
         11'b01101110111: bk_o =  44'b10100111011010100101010000111010001000010000; //  X 7 6 X 5 4 3 X 2 1 0
         11'b01101111000: bk_o =  44'b10100101010010100011001000010000101010101010; //  X 5 4 X 3 2 1 0 X X X
         11'b01101111001: bk_o =  44'b10100110010110100100001100100001101010100000; //  X 6 5 X 4 3 2 1 X X 0
         11'b01101111010: bk_o =  44'b10100110010110100100001100100001101000001010; //  X 6 5 X 4 3 2 1 X 0 X
         11'b01101111011: bk_o =  44'b10100111011010100101010000110010101000010000; //  X 7 6 X 5 4 3 2 X 1 0
         11'b01101111100: bk_o =  44'b10100110010110100100001100100001000010101010; //  X 6 5 X 4 3 2 1 0 X X
         11'b01101111101: bk_o =  44'b10100111011010100101010000110010000110100000; //  X 7 6 X 5 4 3 2 1 X 0
         11'b01101111110: bk_o =  44'b10100111011010100101010000110010000100001010; //  X 7 6 X 5 4 3 2 1 0 X
         11'b01101111111: bk_o =  44'b10101000011110100110010101000011001000010000; //  X 8 7 X 6 5 4 3 2 1 0
         11'b01110000000: bk_o =  44'b10100010000100001010101010101010101010101010; //  X 2 1 0 X X X X X X X
         11'b01110000001: bk_o =  44'b10100011001000011010101010101010101010100000; //  X 3 2 1 X X X X X X 0
         11'b01110000010: bk_o =  44'b10100011001000011010101010101010101000001010; //  X 3 2 1 X X X X X 0 X
         11'b01110000011: bk_o =  44'b10100100001100101010101010101010101000010000; //  X 4 3 2 X X X X X 1 0
         11'b01110000100: bk_o =  44'b10100011001000011010101010101010000010101010; //  X 3 2 1 X X X X 0 X X
         11'b01110000101: bk_o =  44'b10100100001100101010101010101010000110100000; //  X 4 3 2 X X X X 1 X 0
         11'b01110000110: bk_o =  44'b10100100001100101010101010101010000100001010; //  X 4 3 2 X X X X 1 0 X
         11'b01110000111: bk_o =  44'b10100101010000111010101010101010001000010000; //  X 5 4 3 X X X X 2 1 0
         11'b01110001000: bk_o =  44'b10100011001000011010101010100000101010101010; //  X 3 2 1 X X X 0 X X X
         11'b01110001001: bk_o =  44'b10100100001100101010101010100001101010100000; //  X 4 3 2 X X X 1 X X 0
         11'b01110001010: bk_o =  44'b10100100001100101010101010100001101000001010; //  X 4 3 2 X X X 1 X 0 X
         11'b01110001011: bk_o =  44'b10100101010000111010101010100010101000010000; //  X 5 4 3 X X X 2 X 1 0
         11'b01110001100: bk_o =  44'b10100100001100101010101010100001000010101010; //  X 4 3 2 X X X 1 0 X X
         11'b01110001101: bk_o =  44'b10100101010000111010101010100010000110100000; //  X 5 4 3 X X X 2 1 X 0
         11'b01110001110: bk_o =  44'b10100101010000111010101010100010000100001010; //  X 5 4 3 X X X 2 1 0 X
         11'b01110001111: bk_o =  44'b10100110010101001010101010100011001000010000; //  X 6 5 4 X X X 3 2 1 0
         11'b01110010000: bk_o =  44'b10100011001000011010101000001010101010101010; //  X 3 2 1 X X 0 X X X X
         11'b01110010001: bk_o =  44'b10100100001100101010101000011010101010100000; //  X 4 3 2 X X 1 X X X 0
         11'b01110010010: bk_o =  44'b10100100001100101010101000011010101000001010; //  X 4 3 2 X X 1 X X 0 X
         11'b01110010011: bk_o =  44'b10100101010000111010101000101010101000010000; //  X 5 4 3 X X 2 X X 1 0
         11'b01110010100: bk_o =  44'b10100100001100101010101000011010000010101010; //  X 4 3 2 X X 1 X 0 X X
         11'b01110010101: bk_o =  44'b10100101010000111010101000101010000110100000; //  X 5 4 3 X X 2 X 1 X 0
         11'b01110010110: bk_o =  44'b10100101010000111010101000101010000100001010; //  X 5 4 3 X X 2 X 1 0 X
         11'b01110010111: bk_o =  44'b10100110010101001010101000111010001000010000; //  X 6 5 4 X X 3 X 2 1 0
         11'b01110011000: bk_o =  44'b10100100001100101010101000010000101010101010; //  X 4 3 2 X X 1 0 X X X
         11'b01110011001: bk_o =  44'b10100101010000111010101000100001101010100000; //  X 5 4 3 X X 2 1 X X 0
         11'b01110011010: bk_o =  44'b10100101010000111010101000100001101000001010; //  X 5 4 3 X X 2 1 X 0 X
         11'b01110011011: bk_o =  44'b10100110010101001010101000110010101000010000; //  X 6 5 4 X X 3 2 X 1 0
         11'b01110011100: bk_o =  44'b10100101010000111010101000100001000010101010; //  X 5 4 3 X X 2 1 0 X X
         11'b01110011101: bk_o =  44'b10100110010101001010101000110010000110100000; //  X 6 5 4 X X 3 2 1 X 0
         11'b01110011110: bk_o =  44'b10100110010101001010101000110010000100001010; //  X 6 5 4 X X 3 2 1 0 X
         11'b01110011111: bk_o =  44'b10100111011001011010101001000011001000010000; //  X 7 6 5 X X 4 3 2 1 0
         11'b01110100000: bk_o =  44'b10100011001000011010000010101010101010101010; //  X 3 2 1 X 0 X X X X X
         11'b01110100001: bk_o =  44'b10100100001100101010000110101010101010100000; //  X 4 3 2 X 1 X X X X 0
         11'b01110100010: bk_o =  44'b10100100001100101010000110101010101000001010; //  X 4 3 2 X 1 X X X 0 X
         11'b01110100011: bk_o =  44'b10100101010000111010001010101010101000010000; //  X 5 4 3 X 2 X X X 1 0
         11'b01110100100: bk_o =  44'b10100100001100101010000110101010000010101010; //  X 4 3 2 X 1 X X 0 X X
         11'b01110100101: bk_o =  44'b10100101010000111010001010101010000110100000; //  X 5 4 3 X 2 X X 1 X 0
         11'b01110100110: bk_o =  44'b10100101010000111010001010101010000100001010; //  X 5 4 3 X 2 X X 1 0 X
         11'b01110100111: bk_o =  44'b10100110010101001010001110101010001000010000; //  X 6 5 4 X 3 X X 2 1 0
         11'b01110101000: bk_o =  44'b10100100001100101010000110100000101010101010; //  X 4 3 2 X 1 X 0 X X X
         11'b01110101001: bk_o =  44'b10100101010000111010001010100001101010100000; //  X 5 4 3 X 2 X 1 X X 0
         11'b01110101010: bk_o =  44'b10100101010000111010001010100001101000001010; //  X 5 4 3 X 2 X 1 X 0 X
         11'b01110101011: bk_o =  44'b10100110010101001010001110100010101000010000; //  X 6 5 4 X 3 X 2 X 1 0
         11'b01110101100: bk_o =  44'b10100101010000111010001010100001000010101010; //  X 5 4 3 X 2 X 1 0 X X
         11'b01110101101: bk_o =  44'b10100110010101001010001110100010000110100000; //  X 6 5 4 X 3 X 2 1 X 0
         11'b01110101110: bk_o =  44'b10100110010101001010001110100010000100001010; //  X 6 5 4 X 3 X 2 1 0 X
         11'b01110101111: bk_o =  44'b10100111011001011010010010100011001000010000; //  X 7 6 5 X 4 X 3 2 1 0
         11'b01110110000: bk_o =  44'b10100100001100101010000100001010101010101010; //  X 4 3 2 X 1 0 X X X X
         11'b01110110001: bk_o =  44'b10100101010000111010001000011010101010100000; //  X 5 4 3 X 2 1 X X X 0
         11'b01110110010: bk_o =  44'b10100101010000111010001000011010101000001010; //  X 5 4 3 X 2 1 X X 0 X
         11'b01110110011: bk_o =  44'b10100110010101001010001100101010101000010000; //  X 6 5 4 X 3 2 X X 1 0
         11'b01110110100: bk_o =  44'b10100101010000111010001000011010000010101010; //  X 5 4 3 X 2 1 X 0 X X
         11'b01110110101: bk_o =  44'b10100110010101001010001100101010000110100000; //  X 6 5 4 X 3 2 X 1 X 0
         11'b01110110110: bk_o =  44'b10100110010101001010001100101010000100001010; //  X 6 5 4 X 3 2 X 1 0 X
         11'b01110110111: bk_o =  44'b10100111011001011010010000111010001000010000; //  X 7 6 5 X 4 3 X 2 1 0
         11'b01110111000: bk_o =  44'b10100101010000111010001000010000101010101010; //  X 5 4 3 X 2 1 0 X X X
         11'b01110111001: bk_o =  44'b10100110010101001010001100100001101010100000; //  X 6 5 4 X 3 2 1 X X 0
         11'b01110111010: bk_o =  44'b10100110010101001010001100100001101000001010; //  X 6 5 4 X 3 2 1 X 0 X
         11'b01110111011: bk_o =  44'b10100111011001011010010000110010101000010000; //  X 7 6 5 X 4 3 2 X 1 0
         11'b01110111100: bk_o =  44'b10100110010101001010001100100001000010101010; //  X 6 5 4 X 3 2 1 0 X X
         11'b01110111101: bk_o =  44'b10100111011001011010010000110010000110100000; //  X 7 6 5 X 4 3 2 1 X 0
         11'b01110111110: bk_o =  44'b10100111011001011010010000110010000100001010; //  X 7 6 5 X 4 3 2 1 0 X
         11'b01110111111: bk_o =  44'b10101000011101101010010101000011001000010000; //  X 8 7 6 X 5 4 3 2 1 0
         11'b01111000000: bk_o =  44'b10100011001000010000101010101010101010101010; //  X 3 2 1 0 X X X X X X
         11'b01111000001: bk_o =  44'b10100100001100100001101010101010101010100000; //  X 4 3 2 1 X X X X X 0
         11'b01111000010: bk_o =  44'b10100100001100100001101010101010101000001010; //  X 4 3 2 1 X X X X 0 X
         11'b01111000011: bk_o =  44'b10100101010000110010101010101010101000010000; //  X 5 4 3 2 X X X X 1 0
         11'b01111000100: bk_o =  44'b10100100001100100001101010101010000010101010; //  X 4 3 2 1 X X X 0 X X
         11'b01111000101: bk_o =  44'b10100101010000110010101010101010000110100000; //  X 5 4 3 2 X X X 1 X 0
         11'b01111000110: bk_o =  44'b10100101010000110010101010101010000100001010; //  X 5 4 3 2 X X X 1 0 X
         11'b01111000111: bk_o =  44'b10100110010101000011101010101010001000010000; //  X 6 5 4 3 X X X 2 1 0
         11'b01111001000: bk_o =  44'b10100100001100100001101010100000101010101010; //  X 4 3 2 1 X X 0 X X X
         11'b01111001001: bk_o =  44'b10100101010000110010101010100001101010100000; //  X 5 4 3 2 X X 1 X X 0
         11'b01111001010: bk_o =  44'b10100101010000110010101010100001101000001010; //  X 5 4 3 2 X X 1 X 0 X
         11'b01111001011: bk_o =  44'b10100110010101000011101010100010101000010000; //  X 6 5 4 3 X X 2 X 1 0
         11'b01111001100: bk_o =  44'b10100101010000110010101010100001000010101010; //  X 5 4 3 2 X X 1 0 X X
         11'b01111001101: bk_o =  44'b10100110010101000011101010100010000110100000; //  X 6 5 4 3 X X 2 1 X 0
         11'b01111001110: bk_o =  44'b10100110010101000011101010100010000100001010; //  X 6 5 4 3 X X 2 1 0 X
         11'b01111001111: bk_o =  44'b10100111011001010100101010100011001000010000; //  X 7 6 5 4 X X 3 2 1 0
         11'b01111010000: bk_o =  44'b10100100001100100001101000001010101010101010; //  X 4 3 2 1 X 0 X X X X
         11'b01111010001: bk_o =  44'b10100101010000110010101000011010101010100000; //  X 5 4 3 2 X 1 X X X 0
         11'b01111010010: bk_o =  44'b10100101010000110010101000011010101000001010; //  X 5 4 3 2 X 1 X X 0 X
         11'b01111010011: bk_o =  44'b10100110010101000011101000101010101000010000; //  X 6 5 4 3 X 2 X X 1 0
         11'b01111010100: bk_o =  44'b10100101010000110010101000011010000010101010; //  X 5 4 3 2 X 1 X 0 X X
         11'b01111010101: bk_o =  44'b10100110010101000011101000101010000110100000; //  X 6 5 4 3 X 2 X 1 X 0
         11'b01111010110: bk_o =  44'b10100110010101000011101000101010000100001010; //  X 6 5 4 3 X 2 X 1 0 X
         11'b01111010111: bk_o =  44'b10100111011001010100101000111010001000010000; //  X 7 6 5 4 X 3 X 2 1 0
         11'b01111011000: bk_o =  44'b10100101010000110010101000010000101010101010; //  X 5 4 3 2 X 1 0 X X X
         11'b01111011001: bk_o =  44'b10100110010101000011101000100001101010100000; //  X 6 5 4 3 X 2 1 X X 0
         11'b01111011010: bk_o =  44'b10100110010101000011101000100001101000001010; //  X 6 5 4 3 X 2 1 X 0 X
         11'b01111011011: bk_o =  44'b10100111011001010100101000110010101000010000; //  X 7 6 5 4 X 3 2 X 1 0
         11'b01111011100: bk_o =  44'b10100110010101000011101000100001000010101010; //  X 6 5 4 3 X 2 1 0 X X
         11'b01111011101: bk_o =  44'b10100111011001010100101000110010000110100000; //  X 7 6 5 4 X 3 2 1 X 0
         11'b01111011110: bk_o =  44'b10100111011001010100101000110010000100001010; //  X 7 6 5 4 X 3 2 1 0 X
         11'b01111011111: bk_o =  44'b10101000011101100101101001000011001000010000; //  X 8 7 6 5 X 4 3 2 1 0
         11'b01111100000: bk_o =  44'b10100100001100100001000010101010101010101010; //  X 4 3 2 1 0 X X X X X
         11'b01111100001: bk_o =  44'b10100101010000110010000110101010101010100000; //  X 5 4 3 2 1 X X X X 0
         11'b01111100010: bk_o =  44'b10100101010000110010000110101010101000001010; //  X 5 4 3 2 1 X X X 0 X
         11'b01111100011: bk_o =  44'b10100110010101000011001010101010101000010000; //  X 6 5 4 3 2 X X X 1 0
         11'b01111100100: bk_o =  44'b10100101010000110010000110101010000010101010; //  X 5 4 3 2 1 X X 0 X X
         11'b01111100101: bk_o =  44'b10100110010101000011001010101010000110100000; //  X 6 5 4 3 2 X X 1 X 0
         11'b01111100110: bk_o =  44'b10100110010101000011001010101010000100001010; //  X 6 5 4 3 2 X X 1 0 X
         11'b01111100111: bk_o =  44'b10100111011001010100001110101010001000010000; //  X 7 6 5 4 3 X X 2 1 0
         11'b01111101000: bk_o =  44'b10100101010000110010000110100000101010101010; //  X 5 4 3 2 1 X 0 X X X
         11'b01111101001: bk_o =  44'b10100110010101000011001010100001101010100000; //  X 6 5 4 3 2 X 1 X X 0
         11'b01111101010: bk_o =  44'b10100110010101000011001010100001101000001010; //  X 6 5 4 3 2 X 1 X 0 X
         11'b01111101011: bk_o =  44'b10100111011001010100001110100010101000010000; //  X 7 6 5 4 3 X 2 X 1 0
         11'b01111101100: bk_o =  44'b10100110010101000011001010100001000010101010; //  X 6 5 4 3 2 X 1 0 X X
         11'b01111101101: bk_o =  44'b10100111011001010100001110100010000110100000; //  X 7 6 5 4 3 X 2 1 X 0
         11'b01111101110: bk_o =  44'b10100111011001010100001110100010000100001010; //  X 7 6 5 4 3 X 2 1 0 X
         11'b01111101111: bk_o =  44'b10101000011101100101010010100011001000010000; //  X 8 7 6 5 4 X 3 2 1 0
         11'b01111110000: bk_o =  44'b10100101010000110010000100001010101010101010; //  X 5 4 3 2 1 0 X X X X
         11'b01111110001: bk_o =  44'b10100110010101000011001000011010101010100000; //  X 6 5 4 3 2 1 X X X 0
         11'b01111110010: bk_o =  44'b10100110010101000011001000011010101000001010; //  X 6 5 4 3 2 1 X X 0 X
         11'b01111110011: bk_o =  44'b10100111011001010100001100101010101000010000; //  X 7 6 5 4 3 2 X X 1 0
         11'b01111110100: bk_o =  44'b10100110010101000011001000011010000010101010; //  X 6 5 4 3 2 1 X 0 X X
         11'b01111110101: bk_o =  44'b10100111011001010100001100101010000110100000; //  X 7 6 5 4 3 2 X 1 X 0
         11'b01111110110: bk_o =  44'b10100111011001010100001100101010000100001010; //  X 7 6 5 4 3 2 X 1 0 X
         11'b01111110111: bk_o =  44'b10101000011101100101010000111010001000010000; //  X 8 7 6 5 4 3 X 2 1 0
         11'b01111111000: bk_o =  44'b10100110010101000011001000010000101010101010; //  X 6 5 4 3 2 1 0 X X X
         11'b01111111001: bk_o =  44'b10100111011001010100001100100001101010100000; //  X 7 6 5 4 3 2 1 X X 0
         11'b01111111010: bk_o =  44'b10100111011001010100001100100001101000001010; //  X 7 6 5 4 3 2 1 X 0 X
         11'b01111111011: bk_o =  44'b10101000011101100101010000110010101000010000; //  X 8 7 6 5 4 3 2 X 1 0
         11'b01111111100: bk_o =  44'b10100111011001010100001100100001000010101010; //  X 7 6 5 4 3 2 1 0 X X
         11'b01111111101: bk_o =  44'b10101000011101100101010000110010000110100000; //  X 8 7 6 5 4 3 2 1 X 0
         11'b01111111110: bk_o =  44'b10101000011101100101010000110010000100001010; //  X 8 7 6 5 4 3 2 1 0 X
         11'b01111111111: bk_o =  44'b10101001100001110110010101000011001000010000; //  X 9 8 7 6 5 4 3 2 1 0
         11'b10000000000: bk_o =  44'b00001010101010101010101010101010101010101010; //  0 X X X X X X X X X X
         11'b10000000001: bk_o =  44'b00011010101010101010101010101010101010100000; //  1 X X X X X X X X X 0
         11'b10000000010: bk_o =  44'b00011010101010101010101010101010101000001010; //  1 X X X X X X X X 0 X
         11'b10000000011: bk_o =  44'b00101010101010101010101010101010101000010000; //  2 X X X X X X X X 1 0
         11'b10000000100: bk_o =  44'b00011010101010101010101010101010000010101010; //  1 X X X X X X X 0 X X
         11'b10000000101: bk_o =  44'b00101010101010101010101010101010000110100000; //  2 X X X X X X X 1 X 0
         11'b10000000110: bk_o =  44'b00101010101010101010101010101010000100001010; //  2 X X X X X X X 1 0 X
         11'b10000000111: bk_o =  44'b00111010101010101010101010101010001000010000; //  3 X X X X X X X 2 1 0
         11'b10000001000: bk_o =  44'b00011010101010101010101010100000101010101010; //  1 X X X X X X 0 X X X
         11'b10000001001: bk_o =  44'b00101010101010101010101010100001101010100000; //  2 X X X X X X 1 X X 0
         11'b10000001010: bk_o =  44'b00101010101010101010101010100001101000001010; //  2 X X X X X X 1 X 0 X
         11'b10000001011: bk_o =  44'b00111010101010101010101010100010101000010000; //  3 X X X X X X 2 X 1 0
         11'b10000001100: bk_o =  44'b00101010101010101010101010100001000010101010; //  2 X X X X X X 1 0 X X
         11'b10000001101: bk_o =  44'b00111010101010101010101010100010000110100000; //  3 X X X X X X 2 1 X 0
         11'b10000001110: bk_o =  44'b00111010101010101010101010100010000100001010; //  3 X X X X X X 2 1 0 X
         11'b10000001111: bk_o =  44'b01001010101010101010101010100011001000010000; //  4 X X X X X X 3 2 1 0
         11'b10000010000: bk_o =  44'b00011010101010101010101000001010101010101010; //  1 X X X X X 0 X X X X
         11'b10000010001: bk_o =  44'b00101010101010101010101000011010101010100000; //  2 X X X X X 1 X X X 0
         11'b10000010010: bk_o =  44'b00101010101010101010101000011010101000001010; //  2 X X X X X 1 X X 0 X
         11'b10000010011: bk_o =  44'b00111010101010101010101000101010101000010000; //  3 X X X X X 2 X X 1 0
         11'b10000010100: bk_o =  44'b00101010101010101010101000011010000010101010; //  2 X X X X X 1 X 0 X X
         11'b10000010101: bk_o =  44'b00111010101010101010101000101010000110100000; //  3 X X X X X 2 X 1 X 0
         11'b10000010110: bk_o =  44'b00111010101010101010101000101010000100001010; //  3 X X X X X 2 X 1 0 X
         11'b10000010111: bk_o =  44'b01001010101010101010101000111010001000010000; //  4 X X X X X 3 X 2 1 0
         11'b10000011000: bk_o =  44'b00101010101010101010101000010000101010101010; //  2 X X X X X 1 0 X X X
         11'b10000011001: bk_o =  44'b00111010101010101010101000100001101010100000; //  3 X X X X X 2 1 X X 0
         11'b10000011010: bk_o =  44'b00111010101010101010101000100001101000001010; //  3 X X X X X 2 1 X 0 X
         11'b10000011011: bk_o =  44'b01001010101010101010101000110010101000010000; //  4 X X X X X 3 2 X 1 0
         11'b10000011100: bk_o =  44'b00111010101010101010101000100001000010101010; //  3 X X X X X 2 1 0 X X
         11'b10000011101: bk_o =  44'b01001010101010101010101000110010000110100000; //  4 X X X X X 3 2 1 X 0
         11'b10000011110: bk_o =  44'b01001010101010101010101000110010000100001010; //  4 X X X X X 3 2 1 0 X
         11'b10000011111: bk_o =  44'b01011010101010101010101001000011001000010000; //  5 X X X X X 4 3 2 1 0
         11'b10000100000: bk_o =  44'b00011010101010101010000010101010101010101010; //  1 X X X X 0 X X X X X
         11'b10000100001: bk_o =  44'b00101010101010101010000110101010101010100000; //  2 X X X X 1 X X X X 0
         11'b10000100010: bk_o =  44'b00101010101010101010000110101010101000001010; //  2 X X X X 1 X X X 0 X
         11'b10000100011: bk_o =  44'b00111010101010101010001010101010101000010000; //  3 X X X X 2 X X X 1 0
         11'b10000100100: bk_o =  44'b00101010101010101010000110101010000010101010; //  2 X X X X 1 X X 0 X X
         11'b10000100101: bk_o =  44'b00111010101010101010001010101010000110100000; //  3 X X X X 2 X X 1 X 0
         11'b10000100110: bk_o =  44'b00111010101010101010001010101010000100001010; //  3 X X X X 2 X X 1 0 X
         11'b10000100111: bk_o =  44'b01001010101010101010001110101010001000010000; //  4 X X X X 3 X X 2 1 0
         11'b10000101000: bk_o =  44'b00101010101010101010000110100000101010101010; //  2 X X X X 1 X 0 X X X
         11'b10000101001: bk_o =  44'b00111010101010101010001010100001101010100000; //  3 X X X X 2 X 1 X X 0
         11'b10000101010: bk_o =  44'b00111010101010101010001010100001101000001010; //  3 X X X X 2 X 1 X 0 X
         11'b10000101011: bk_o =  44'b01001010101010101010001110100010101000010000; //  4 X X X X 3 X 2 X 1 0
         11'b10000101100: bk_o =  44'b00111010101010101010001010100001000010101010; //  3 X X X X 2 X 1 0 X X
         11'b10000101101: bk_o =  44'b01001010101010101010001110100010000110100000; //  4 X X X X 3 X 2 1 X 0
         11'b10000101110: bk_o =  44'b01001010101010101010001110100010000100001010; //  4 X X X X 3 X 2 1 0 X
         11'b10000101111: bk_o =  44'b01011010101010101010010010100011001000010000; //  5 X X X X 4 X 3 2 1 0
         11'b10000110000: bk_o =  44'b00101010101010101010000100001010101010101010; //  2 X X X X 1 0 X X X X
         11'b10000110001: bk_o =  44'b00111010101010101010001000011010101010100000; //  3 X X X X 2 1 X X X 0
         11'b10000110010: bk_o =  44'b00111010101010101010001000011010101000001010; //  3 X X X X 2 1 X X 0 X
         11'b10000110011: bk_o =  44'b01001010101010101010001100101010101000010000; //  4 X X X X 3 2 X X 1 0
         11'b10000110100: bk_o =  44'b00111010101010101010001000011010000010101010; //  3 X X X X 2 1 X 0 X X
         11'b10000110101: bk_o =  44'b01001010101010101010001100101010000110100000; //  4 X X X X 3 2 X 1 X 0
         11'b10000110110: bk_o =  44'b01001010101010101010001100101010000100001010; //  4 X X X X 3 2 X 1 0 X
         11'b10000110111: bk_o =  44'b01011010101010101010010000111010001000010000; //  5 X X X X 4 3 X 2 1 0
         11'b10000111000: bk_o =  44'b00111010101010101010001000010000101010101010; //  3 X X X X 2 1 0 X X X
         11'b10000111001: bk_o =  44'b01001010101010101010001100100001101010100000; //  4 X X X X 3 2 1 X X 0
         11'b10000111010: bk_o =  44'b01001010101010101010001100100001101000001010; //  4 X X X X 3 2 1 X 0 X
         11'b10000111011: bk_o =  44'b01011010101010101010010000110010101000010000; //  5 X X X X 4 3 2 X 1 0
         11'b10000111100: bk_o =  44'b01001010101010101010001100100001000010101010; //  4 X X X X 3 2 1 0 X X
         11'b10000111101: bk_o =  44'b01011010101010101010010000110010000110100000; //  5 X X X X 4 3 2 1 X 0
         11'b10000111110: bk_o =  44'b01011010101010101010010000110010000100001010; //  5 X X X X 4 3 2 1 0 X
         11'b10000111111: bk_o =  44'b01101010101010101010010101000011001000010000; //  6 X X X X 5 4 3 2 1 0
         11'b10001000000: bk_o =  44'b00011010101010100000101010101010101010101010; //  1 X X X 0 X X X X X X
         11'b10001000001: bk_o =  44'b00101010101010100001101010101010101010100000; //  2 X X X 1 X X X X X 0
         11'b10001000010: bk_o =  44'b00101010101010100001101010101010101000001010; //  2 X X X 1 X X X X 0 X
         11'b10001000011: bk_o =  44'b00111010101010100010101010101010101000010000; //  3 X X X 2 X X X X 1 0
         11'b10001000100: bk_o =  44'b00101010101010100001101010101010000010101010; //  2 X X X 1 X X X 0 X X
         11'b10001000101: bk_o =  44'b00111010101010100010101010101010000110100000; //  3 X X X 2 X X X 1 X 0
         11'b10001000110: bk_o =  44'b00111010101010100010101010101010000100001010; //  3 X X X 2 X X X 1 0 X
         11'b10001000111: bk_o =  44'b01001010101010100011101010101010001000010000; //  4 X X X 3 X X X 2 1 0
         11'b10001001000: bk_o =  44'b00101010101010100001101010100000101010101010; //  2 X X X 1 X X 0 X X X
         11'b10001001001: bk_o =  44'b00111010101010100010101010100001101010100000; //  3 X X X 2 X X 1 X X 0
         11'b10001001010: bk_o =  44'b00111010101010100010101010100001101000001010; //  3 X X X 2 X X 1 X 0 X
         11'b10001001011: bk_o =  44'b01001010101010100011101010100010101000010000; //  4 X X X 3 X X 2 X 1 0
         11'b10001001100: bk_o =  44'b00111010101010100010101010100001000010101010; //  3 X X X 2 X X 1 0 X X
         11'b10001001101: bk_o =  44'b01001010101010100011101010100010000110100000; //  4 X X X 3 X X 2 1 X 0
         11'b10001001110: bk_o =  44'b01001010101010100011101010100010000100001010; //  4 X X X 3 X X 2 1 0 X
         11'b10001001111: bk_o =  44'b01011010101010100100101010100011001000010000; //  5 X X X 4 X X 3 2 1 0
         11'b10001010000: bk_o =  44'b00101010101010100001101000001010101010101010; //  2 X X X 1 X 0 X X X X
         11'b10001010001: bk_o =  44'b00111010101010100010101000011010101010100000; //  3 X X X 2 X 1 X X X 0
         11'b10001010010: bk_o =  44'b00111010101010100010101000011010101000001010; //  3 X X X 2 X 1 X X 0 X
         11'b10001010011: bk_o =  44'b01001010101010100011101000101010101000010000; //  4 X X X 3 X 2 X X 1 0
         11'b10001010100: bk_o =  44'b00111010101010100010101000011010000010101010; //  3 X X X 2 X 1 X 0 X X
         11'b10001010101: bk_o =  44'b01001010101010100011101000101010000110100000; //  4 X X X 3 X 2 X 1 X 0
         11'b10001010110: bk_o =  44'b01001010101010100011101000101010000100001010; //  4 X X X 3 X 2 X 1 0 X
         11'b10001010111: bk_o =  44'b01011010101010100100101000111010001000010000; //  5 X X X 4 X 3 X 2 1 0
         11'b10001011000: bk_o =  44'b00111010101010100010101000010000101010101010; //  3 X X X 2 X 1 0 X X X
         11'b10001011001: bk_o =  44'b01001010101010100011101000100001101010100000; //  4 X X X 3 X 2 1 X X 0
         11'b10001011010: bk_o =  44'b01001010101010100011101000100001101000001010; //  4 X X X 3 X 2 1 X 0 X
         11'b10001011011: bk_o =  44'b01011010101010100100101000110010101000010000; //  5 X X X 4 X 3 2 X 1 0
         11'b10001011100: bk_o =  44'b01001010101010100011101000100001000010101010; //  4 X X X 3 X 2 1 0 X X
         11'b10001011101: bk_o =  44'b01011010101010100100101000110010000110100000; //  5 X X X 4 X 3 2 1 X 0
         11'b10001011110: bk_o =  44'b01011010101010100100101000110010000100001010; //  5 X X X 4 X 3 2 1 0 X
         11'b10001011111: bk_o =  44'b01101010101010100101101001000011001000010000; //  6 X X X 5 X 4 3 2 1 0
         11'b10001100000: bk_o =  44'b00101010101010100001000010101010101010101010; //  2 X X X 1 0 X X X X X
         11'b10001100001: bk_o =  44'b00111010101010100010000110101010101010100000; //  3 X X X 2 1 X X X X 0
         11'b10001100010: bk_o =  44'b00111010101010100010000110101010101000001010; //  3 X X X 2 1 X X X 0 X
         11'b10001100011: bk_o =  44'b01001010101010100011001010101010101000010000; //  4 X X X 3 2 X X X 1 0
         11'b10001100100: bk_o =  44'b00111010101010100010000110101010000010101010; //  3 X X X 2 1 X X 0 X X
         11'b10001100101: bk_o =  44'b01001010101010100011001010101010000110100000; //  4 X X X 3 2 X X 1 X 0
         11'b10001100110: bk_o =  44'b01001010101010100011001010101010000100001010; //  4 X X X 3 2 X X 1 0 X
         11'b10001100111: bk_o =  44'b01011010101010100100001110101010001000010000; //  5 X X X 4 3 X X 2 1 0
         11'b10001101000: bk_o =  44'b00111010101010100010000110100000101010101010; //  3 X X X 2 1 X 0 X X X
         11'b10001101001: bk_o =  44'b01001010101010100011001010100001101010100000; //  4 X X X 3 2 X 1 X X 0
         11'b10001101010: bk_o =  44'b01001010101010100011001010100001101000001010; //  4 X X X 3 2 X 1 X 0 X
         11'b10001101011: bk_o =  44'b01011010101010100100001110100010101000010000; //  5 X X X 4 3 X 2 X 1 0
         11'b10001101100: bk_o =  44'b01001010101010100011001010100001000010101010; //  4 X X X 3 2 X 1 0 X X
         11'b10001101101: bk_o =  44'b01011010101010100100001110100010000110100000; //  5 X X X 4 3 X 2 1 X 0
         11'b10001101110: bk_o =  44'b01011010101010100100001110100010000100001010; //  5 X X X 4 3 X 2 1 0 X
         11'b10001101111: bk_o =  44'b01101010101010100101010010100011001000010000; //  6 X X X 5 4 X 3 2 1 0
         11'b10001110000: bk_o =  44'b00111010101010100010000100001010101010101010; //  3 X X X 2 1 0 X X X X
         11'b10001110001: bk_o =  44'b01001010101010100011001000011010101010100000; //  4 X X X 3 2 1 X X X 0
         11'b10001110010: bk_o =  44'b01001010101010100011001000011010101000001010; //  4 X X X 3 2 1 X X 0 X
         11'b10001110011: bk_o =  44'b01011010101010100100001100101010101000010000; //  5 X X X 4 3 2 X X 1 0
         11'b10001110100: bk_o =  44'b01001010101010100011001000011010000010101010; //  4 X X X 3 2 1 X 0 X X
         11'b10001110101: bk_o =  44'b01011010101010100100001100101010000110100000; //  5 X X X 4 3 2 X 1 X 0
         11'b10001110110: bk_o =  44'b01011010101010100100001100101010000100001010; //  5 X X X 4 3 2 X 1 0 X
         11'b10001110111: bk_o =  44'b01101010101010100101010000111010001000010000; //  6 X X X 5 4 3 X 2 1 0
         11'b10001111000: bk_o =  44'b01001010101010100011001000010000101010101010; //  4 X X X 3 2 1 0 X X X
         11'b10001111001: bk_o =  44'b01011010101010100100001100100001101010100000; //  5 X X X 4 3 2 1 X X 0
         11'b10001111010: bk_o =  44'b01011010101010100100001100100001101000001010; //  5 X X X 4 3 2 1 X 0 X
         11'b10001111011: bk_o =  44'b01101010101010100101010000110010101000010000; //  6 X X X 5 4 3 2 X 1 0
         11'b10001111100: bk_o =  44'b01011010101010100100001100100001000010101010; //  5 X X X 4 3 2 1 0 X X
         11'b10001111101: bk_o =  44'b01101010101010100101010000110010000110100000; //  6 X X X 5 4 3 2 1 X 0
         11'b10001111110: bk_o =  44'b01101010101010100101010000110010000100001010; //  6 X X X 5 4 3 2 1 0 X
         11'b10001111111: bk_o =  44'b01111010101010100110010101000011001000010000; //  7 X X X 6 5 4 3 2 1 0
         11'b10010000000: bk_o =  44'b00011010101000001010101010101010101010101010; //  1 X X 0 X X X X X X X
         11'b10010000001: bk_o =  44'b00101010101000011010101010101010101010100000; //  2 X X 1 X X X X X X 0
         11'b10010000010: bk_o =  44'b00101010101000011010101010101010101000001010; //  2 X X 1 X X X X X 0 X
         11'b10010000011: bk_o =  44'b00111010101000101010101010101010101000010000; //  3 X X 2 X X X X X 1 0
         11'b10010000100: bk_o =  44'b00101010101000011010101010101010000010101010; //  2 X X 1 X X X X 0 X X
         11'b10010000101: bk_o =  44'b00111010101000101010101010101010000110100000; //  3 X X 2 X X X X 1 X 0
         11'b10010000110: bk_o =  44'b00111010101000101010101010101010000100001010; //  3 X X 2 X X X X 1 0 X
         11'b10010000111: bk_o =  44'b01001010101000111010101010101010001000010000; //  4 X X 3 X X X X 2 1 0
         11'b10010001000: bk_o =  44'b00101010101000011010101010100000101010101010; //  2 X X 1 X X X 0 X X X
         11'b10010001001: bk_o =  44'b00111010101000101010101010100001101010100000; //  3 X X 2 X X X 1 X X 0
         11'b10010001010: bk_o =  44'b00111010101000101010101010100001101000001010; //  3 X X 2 X X X 1 X 0 X
         11'b10010001011: bk_o =  44'b01001010101000111010101010100010101000010000; //  4 X X 3 X X X 2 X 1 0
         11'b10010001100: bk_o =  44'b00111010101000101010101010100001000010101010; //  3 X X 2 X X X 1 0 X X
         11'b10010001101: bk_o =  44'b01001010101000111010101010100010000110100000; //  4 X X 3 X X X 2 1 X 0
         11'b10010001110: bk_o =  44'b01001010101000111010101010100010000100001010; //  4 X X 3 X X X 2 1 0 X
         11'b10010001111: bk_o =  44'b01011010101001001010101010100011001000010000; //  5 X X 4 X X X 3 2 1 0
         11'b10010010000: bk_o =  44'b00101010101000011010101000001010101010101010; //  2 X X 1 X X 0 X X X X
         11'b10010010001: bk_o =  44'b00111010101000101010101000011010101010100000; //  3 X X 2 X X 1 X X X 0
         11'b10010010010: bk_o =  44'b00111010101000101010101000011010101000001010; //  3 X X 2 X X 1 X X 0 X
         11'b10010010011: bk_o =  44'b01001010101000111010101000101010101000010000; //  4 X X 3 X X 2 X X 1 0
         11'b10010010100: bk_o =  44'b00111010101000101010101000011010000010101010; //  3 X X 2 X X 1 X 0 X X
         11'b10010010101: bk_o =  44'b01001010101000111010101000101010000110100000; //  4 X X 3 X X 2 X 1 X 0
         11'b10010010110: bk_o =  44'b01001010101000111010101000101010000100001010; //  4 X X 3 X X 2 X 1 0 X
         11'b10010010111: bk_o =  44'b01011010101001001010101000111010001000010000; //  5 X X 4 X X 3 X 2 1 0
         11'b10010011000: bk_o =  44'b00111010101000101010101000010000101010101010; //  3 X X 2 X X 1 0 X X X
         11'b10010011001: bk_o =  44'b01001010101000111010101000100001101010100000; //  4 X X 3 X X 2 1 X X 0
         11'b10010011010: bk_o =  44'b01001010101000111010101000100001101000001010; //  4 X X 3 X X 2 1 X 0 X
         11'b10010011011: bk_o =  44'b01011010101001001010101000110010101000010000; //  5 X X 4 X X 3 2 X 1 0
         11'b10010011100: bk_o =  44'b01001010101000111010101000100001000010101010; //  4 X X 3 X X 2 1 0 X X
         11'b10010011101: bk_o =  44'b01011010101001001010101000110010000110100000; //  5 X X 4 X X 3 2 1 X 0
         11'b10010011110: bk_o =  44'b01011010101001001010101000110010000100001010; //  5 X X 4 X X 3 2 1 0 X
         11'b10010011111: bk_o =  44'b01101010101001011010101001000011001000010000; //  6 X X 5 X X 4 3 2 1 0
         11'b10010100000: bk_o =  44'b00101010101000011010000010101010101010101010; //  2 X X 1 X 0 X X X X X
         11'b10010100001: bk_o =  44'b00111010101000101010000110101010101010100000; //  3 X X 2 X 1 X X X X 0
         11'b10010100010: bk_o =  44'b00111010101000101010000110101010101000001010; //  3 X X 2 X 1 X X X 0 X
         11'b10010100011: bk_o =  44'b01001010101000111010001010101010101000010000; //  4 X X 3 X 2 X X X 1 0
         11'b10010100100: bk_o =  44'b00111010101000101010000110101010000010101010; //  3 X X 2 X 1 X X 0 X X
         11'b10010100101: bk_o =  44'b01001010101000111010001010101010000110100000; //  4 X X 3 X 2 X X 1 X 0
         11'b10010100110: bk_o =  44'b01001010101000111010001010101010000100001010; //  4 X X 3 X 2 X X 1 0 X
         11'b10010100111: bk_o =  44'b01011010101001001010001110101010001000010000; //  5 X X 4 X 3 X X 2 1 0
         11'b10010101000: bk_o =  44'b00111010101000101010000110100000101010101010; //  3 X X 2 X 1 X 0 X X X
         11'b10010101001: bk_o =  44'b01001010101000111010001010100001101010100000; //  4 X X 3 X 2 X 1 X X 0
         11'b10010101010: bk_o =  44'b01001010101000111010001010100001101000001010; //  4 X X 3 X 2 X 1 X 0 X
         11'b10010101011: bk_o =  44'b01011010101001001010001110100010101000010000; //  5 X X 4 X 3 X 2 X 1 0
         11'b10010101100: bk_o =  44'b01001010101000111010001010100001000010101010; //  4 X X 3 X 2 X 1 0 X X
         11'b10010101101: bk_o =  44'b01011010101001001010001110100010000110100000; //  5 X X 4 X 3 X 2 1 X 0
         11'b10010101110: bk_o =  44'b01011010101001001010001110100010000100001010; //  5 X X 4 X 3 X 2 1 0 X
         11'b10010101111: bk_o =  44'b01101010101001011010010010100011001000010000; //  6 X X 5 X 4 X 3 2 1 0
         11'b10010110000: bk_o =  44'b00111010101000101010000100001010101010101010; //  3 X X 2 X 1 0 X X X X
         11'b10010110001: bk_o =  44'b01001010101000111010001000011010101010100000; //  4 X X 3 X 2 1 X X X 0
         11'b10010110010: bk_o =  44'b01001010101000111010001000011010101000001010; //  4 X X 3 X 2 1 X X 0 X
         11'b10010110011: bk_o =  44'b01011010101001001010001100101010101000010000; //  5 X X 4 X 3 2 X X 1 0
         11'b10010110100: bk_o =  44'b01001010101000111010001000011010000010101010; //  4 X X 3 X 2 1 X 0 X X
         11'b10010110101: bk_o =  44'b01011010101001001010001100101010000110100000; //  5 X X 4 X 3 2 X 1 X 0
         11'b10010110110: bk_o =  44'b01011010101001001010001100101010000100001010; //  5 X X 4 X 3 2 X 1 0 X
         11'b10010110111: bk_o =  44'b01101010101001011010010000111010001000010000; //  6 X X 5 X 4 3 X 2 1 0
         11'b10010111000: bk_o =  44'b01001010101000111010001000010000101010101010; //  4 X X 3 X 2 1 0 X X X
         11'b10010111001: bk_o =  44'b01011010101001001010001100100001101010100000; //  5 X X 4 X 3 2 1 X X 0
         11'b10010111010: bk_o =  44'b01011010101001001010001100100001101000001010; //  5 X X 4 X 3 2 1 X 0 X
         11'b10010111011: bk_o =  44'b01101010101001011010010000110010101000010000; //  6 X X 5 X 4 3 2 X 1 0
         11'b10010111100: bk_o =  44'b01011010101001001010001100100001000010101010; //  5 X X 4 X 3 2 1 0 X X
         11'b10010111101: bk_o =  44'b01101010101001011010010000110010000110100000; //  6 X X 5 X 4 3 2 1 X 0
         11'b10010111110: bk_o =  44'b01101010101001011010010000110010000100001010; //  6 X X 5 X 4 3 2 1 0 X
         11'b10010111111: bk_o =  44'b01111010101001101010010101000011001000010000; //  7 X X 6 X 5 4 3 2 1 0
         11'b10011000000: bk_o =  44'b00101010101000010000101010101010101010101010; //  2 X X 1 0 X X X X X X
         11'b10011000001: bk_o =  44'b00111010101000100001101010101010101010100000; //  3 X X 2 1 X X X X X 0
         11'b10011000010: bk_o =  44'b00111010101000100001101010101010101000001010; //  3 X X 2 1 X X X X 0 X
         11'b10011000011: bk_o =  44'b01001010101000110010101010101010101000010000; //  4 X X 3 2 X X X X 1 0
         11'b10011000100: bk_o =  44'b00111010101000100001101010101010000010101010; //  3 X X 2 1 X X X 0 X X
         11'b10011000101: bk_o =  44'b01001010101000110010101010101010000110100000; //  4 X X 3 2 X X X 1 X 0
         11'b10011000110: bk_o =  44'b01001010101000110010101010101010000100001010; //  4 X X 3 2 X X X 1 0 X
         11'b10011000111: bk_o =  44'b01011010101001000011101010101010001000010000; //  5 X X 4 3 X X X 2 1 0
         11'b10011001000: bk_o =  44'b00111010101000100001101010100000101010101010; //  3 X X 2 1 X X 0 X X X
         11'b10011001001: bk_o =  44'b01001010101000110010101010100001101010100000; //  4 X X 3 2 X X 1 X X 0
         11'b10011001010: bk_o =  44'b01001010101000110010101010100001101000001010; //  4 X X 3 2 X X 1 X 0 X
         11'b10011001011: bk_o =  44'b01011010101001000011101010100010101000010000; //  5 X X 4 3 X X 2 X 1 0
         11'b10011001100: bk_o =  44'b01001010101000110010101010100001000010101010; //  4 X X 3 2 X X 1 0 X X
         11'b10011001101: bk_o =  44'b01011010101001000011101010100010000110100000; //  5 X X 4 3 X X 2 1 X 0
         11'b10011001110: bk_o =  44'b01011010101001000011101010100010000100001010; //  5 X X 4 3 X X 2 1 0 X
         11'b10011001111: bk_o =  44'b01101010101001010100101010100011001000010000; //  6 X X 5 4 X X 3 2 1 0
         11'b10011010000: bk_o =  44'b00111010101000100001101000001010101010101010; //  3 X X 2 1 X 0 X X X X
         11'b10011010001: bk_o =  44'b01001010101000110010101000011010101010100000; //  4 X X 3 2 X 1 X X X 0
         11'b10011010010: bk_o =  44'b01001010101000110010101000011010101000001010; //  4 X X 3 2 X 1 X X 0 X
         11'b10011010011: bk_o =  44'b01011010101001000011101000101010101000010000; //  5 X X 4 3 X 2 X X 1 0
         11'b10011010100: bk_o =  44'b01001010101000110010101000011010000010101010; //  4 X X 3 2 X 1 X 0 X X
         11'b10011010101: bk_o =  44'b01011010101001000011101000101010000110100000; //  5 X X 4 3 X 2 X 1 X 0
         11'b10011010110: bk_o =  44'b01011010101001000011101000101010000100001010; //  5 X X 4 3 X 2 X 1 0 X
         11'b10011010111: bk_o =  44'b01101010101001010100101000111010001000010000; //  6 X X 5 4 X 3 X 2 1 0
         11'b10011011000: bk_o =  44'b01001010101000110010101000010000101010101010; //  4 X X 3 2 X 1 0 X X X
         11'b10011011001: bk_o =  44'b01011010101001000011101000100001101010100000; //  5 X X 4 3 X 2 1 X X 0
         11'b10011011010: bk_o =  44'b01011010101001000011101000100001101000001010; //  5 X X 4 3 X 2 1 X 0 X
         11'b10011011011: bk_o =  44'b01101010101001010100101000110010101000010000; //  6 X X 5 4 X 3 2 X 1 0
         11'b10011011100: bk_o =  44'b01011010101001000011101000100001000010101010; //  5 X X 4 3 X 2 1 0 X X
         11'b10011011101: bk_o =  44'b01101010101001010100101000110010000110100000; //  6 X X 5 4 X 3 2 1 X 0
         11'b10011011110: bk_o =  44'b01101010101001010100101000110010000100001010; //  6 X X 5 4 X 3 2 1 0 X
         11'b10011011111: bk_o =  44'b01111010101001100101101001000011001000010000; //  7 X X 6 5 X 4 3 2 1 0
         11'b10011100000: bk_o =  44'b00111010101000100001000010101010101010101010; //  3 X X 2 1 0 X X X X X
         11'b10011100001: bk_o =  44'b01001010101000110010000110101010101010100000; //  4 X X 3 2 1 X X X X 0
         11'b10011100010: bk_o =  44'b01001010101000110010000110101010101000001010; //  4 X X 3 2 1 X X X 0 X
         11'b10011100011: bk_o =  44'b01011010101001000011001010101010101000010000; //  5 X X 4 3 2 X X X 1 0
         11'b10011100100: bk_o =  44'b01001010101000110010000110101010000010101010; //  4 X X 3 2 1 X X 0 X X
         11'b10011100101: bk_o =  44'b01011010101001000011001010101010000110100000; //  5 X X 4 3 2 X X 1 X 0
         11'b10011100110: bk_o =  44'b01011010101001000011001010101010000100001010; //  5 X X 4 3 2 X X 1 0 X
         11'b10011100111: bk_o =  44'b01101010101001010100001110101010001000010000; //  6 X X 5 4 3 X X 2 1 0
         11'b10011101000: bk_o =  44'b01001010101000110010000110100000101010101010; //  4 X X 3 2 1 X 0 X X X
         11'b10011101001: bk_o =  44'b01011010101001000011001010100001101010100000; //  5 X X 4 3 2 X 1 X X 0
         11'b10011101010: bk_o =  44'b01011010101001000011001010100001101000001010; //  5 X X 4 3 2 X 1 X 0 X
         11'b10011101011: bk_o =  44'b01101010101001010100001110100010101000010000; //  6 X X 5 4 3 X 2 X 1 0
         11'b10011101100: bk_o =  44'b01011010101001000011001010100001000010101010; //  5 X X 4 3 2 X 1 0 X X
         11'b10011101101: bk_o =  44'b01101010101001010100001110100010000110100000; //  6 X X 5 4 3 X 2 1 X 0
         11'b10011101110: bk_o =  44'b01101010101001010100001110100010000100001010; //  6 X X 5 4 3 X 2 1 0 X
         11'b10011101111: bk_o =  44'b01111010101001100101010010100011001000010000; //  7 X X 6 5 4 X 3 2 1 0
         11'b10011110000: bk_o =  44'b01001010101000110010000100001010101010101010; //  4 X X 3 2 1 0 X X X X
         11'b10011110001: bk_o =  44'b01011010101001000011001000011010101010100000; //  5 X X 4 3 2 1 X X X 0
         11'b10011110010: bk_o =  44'b01011010101001000011001000011010101000001010; //  5 X X 4 3 2 1 X X 0 X
         11'b10011110011: bk_o =  44'b01101010101001010100001100101010101000010000; //  6 X X 5 4 3 2 X X 1 0
         11'b10011110100: bk_o =  44'b01011010101001000011001000011010000010101010; //  5 X X 4 3 2 1 X 0 X X
         11'b10011110101: bk_o =  44'b01101010101001010100001100101010000110100000; //  6 X X 5 4 3 2 X 1 X 0
         11'b10011110110: bk_o =  44'b01101010101001010100001100101010000100001010; //  6 X X 5 4 3 2 X 1 0 X
         11'b10011110111: bk_o =  44'b01111010101001100101010000111010001000010000; //  7 X X 6 5 4 3 X 2 1 0
         11'b10011111000: bk_o =  44'b01011010101001000011001000010000101010101010; //  5 X X 4 3 2 1 0 X X X
         11'b10011111001: bk_o =  44'b01101010101001010100001100100001101010100000; //  6 X X 5 4 3 2 1 X X 0
         11'b10011111010: bk_o =  44'b01101010101001010100001100100001101000001010; //  6 X X 5 4 3 2 1 X 0 X
         11'b10011111011: bk_o =  44'b01111010101001100101010000110010101000010000; //  7 X X 6 5 4 3 2 X 1 0
         11'b10011111100: bk_o =  44'b01101010101001010100001100100001000010101010; //  6 X X 5 4 3 2 1 0 X X
         11'b10011111101: bk_o =  44'b01111010101001100101010000110010000110100000; //  7 X X 6 5 4 3 2 1 X 0
         11'b10011111110: bk_o =  44'b01111010101001100101010000110010000100001010; //  7 X X 6 5 4 3 2 1 0 X
         11'b10011111111: bk_o =  44'b10001010101001110110010101000011001000010000; //  8 X X 7 6 5 4 3 2 1 0
         11'b10100000000: bk_o =  44'b00011010000010101010101010101010101010101010; //  1 X 0 X X X X X X X X
         11'b10100000001: bk_o =  44'b00101010000110101010101010101010101010100000; //  2 X 1 X X X X X X X 0
         11'b10100000010: bk_o =  44'b00101010000110101010101010101010101000001010; //  2 X 1 X X X X X X 0 X
         11'b10100000011: bk_o =  44'b00111010001010101010101010101010101000010000; //  3 X 2 X X X X X X 1 0
         11'b10100000100: bk_o =  44'b00101010000110101010101010101010000010101010; //  2 X 1 X X X X X 0 X X
         11'b10100000101: bk_o =  44'b00111010001010101010101010101010000110100000; //  3 X 2 X X X X X 1 X 0
         11'b10100000110: bk_o =  44'b00111010001010101010101010101010000100001010; //  3 X 2 X X X X X 1 0 X
         11'b10100000111: bk_o =  44'b01001010001110101010101010101010001000010000; //  4 X 3 X X X X X 2 1 0
         11'b10100001000: bk_o =  44'b00101010000110101010101010100000101010101010; //  2 X 1 X X X X 0 X X X
         11'b10100001001: bk_o =  44'b00111010001010101010101010100001101010100000; //  3 X 2 X X X X 1 X X 0
         11'b10100001010: bk_o =  44'b00111010001010101010101010100001101000001010; //  3 X 2 X X X X 1 X 0 X
         11'b10100001011: bk_o =  44'b01001010001110101010101010100010101000010000; //  4 X 3 X X X X 2 X 1 0
         11'b10100001100: bk_o =  44'b00111010001010101010101010100001000010101010; //  3 X 2 X X X X 1 0 X X
         11'b10100001101: bk_o =  44'b01001010001110101010101010100010000110100000; //  4 X 3 X X X X 2 1 X 0
         11'b10100001110: bk_o =  44'b01001010001110101010101010100010000100001010; //  4 X 3 X X X X 2 1 0 X
         11'b10100001111: bk_o =  44'b01011010010010101010101010100011001000010000; //  5 X 4 X X X X 3 2 1 0
         11'b10100010000: bk_o =  44'b00101010000110101010101000001010101010101010; //  2 X 1 X X X 0 X X X X
         11'b10100010001: bk_o =  44'b00111010001010101010101000011010101010100000; //  3 X 2 X X X 1 X X X 0
         11'b10100010010: bk_o =  44'b00111010001010101010101000011010101000001010; //  3 X 2 X X X 1 X X 0 X
         11'b10100010011: bk_o =  44'b01001010001110101010101000101010101000010000; //  4 X 3 X X X 2 X X 1 0
         11'b10100010100: bk_o =  44'b00111010001010101010101000011010000010101010; //  3 X 2 X X X 1 X 0 X X
         11'b10100010101: bk_o =  44'b01001010001110101010101000101010000110100000; //  4 X 3 X X X 2 X 1 X 0
         11'b10100010110: bk_o =  44'b01001010001110101010101000101010000100001010; //  4 X 3 X X X 2 X 1 0 X
         11'b10100010111: bk_o =  44'b01011010010010101010101000111010001000010000; //  5 X 4 X X X 3 X 2 1 0
         11'b10100011000: bk_o =  44'b00111010001010101010101000010000101010101010; //  3 X 2 X X X 1 0 X X X
         11'b10100011001: bk_o =  44'b01001010001110101010101000100001101010100000; //  4 X 3 X X X 2 1 X X 0
         11'b10100011010: bk_o =  44'b01001010001110101010101000100001101000001010; //  4 X 3 X X X 2 1 X 0 X
         11'b10100011011: bk_o =  44'b01011010010010101010101000110010101000010000; //  5 X 4 X X X 3 2 X 1 0
         11'b10100011100: bk_o =  44'b01001010001110101010101000100001000010101010; //  4 X 3 X X X 2 1 0 X X
         11'b10100011101: bk_o =  44'b01011010010010101010101000110010000110100000; //  5 X 4 X X X 3 2 1 X 0
         11'b10100011110: bk_o =  44'b01011010010010101010101000110010000100001010; //  5 X 4 X X X 3 2 1 0 X
         11'b10100011111: bk_o =  44'b01101010010110101010101001000011001000010000; //  6 X 5 X X X 4 3 2 1 0
         11'b10100100000: bk_o =  44'b00101010000110101010000010101010101010101010; //  2 X 1 X X 0 X X X X X
         11'b10100100001: bk_o =  44'b00111010001010101010000110101010101010100000; //  3 X 2 X X 1 X X X X 0
         11'b10100100010: bk_o =  44'b00111010001010101010000110101010101000001010; //  3 X 2 X X 1 X X X 0 X
         11'b10100100011: bk_o =  44'b01001010001110101010001010101010101000010000; //  4 X 3 X X 2 X X X 1 0
         11'b10100100100: bk_o =  44'b00111010001010101010000110101010000010101010; //  3 X 2 X X 1 X X 0 X X
         11'b10100100101: bk_o =  44'b01001010001110101010001010101010000110100000; //  4 X 3 X X 2 X X 1 X 0
         11'b10100100110: bk_o =  44'b01001010001110101010001010101010000100001010; //  4 X 3 X X 2 X X 1 0 X
         11'b10100100111: bk_o =  44'b01011010010010101010001110101010001000010000; //  5 X 4 X X 3 X X 2 1 0
         11'b10100101000: bk_o =  44'b00111010001010101010000110100000101010101010; //  3 X 2 X X 1 X 0 X X X
         11'b10100101001: bk_o =  44'b01001010001110101010001010100001101010100000; //  4 X 3 X X 2 X 1 X X 0
         11'b10100101010: bk_o =  44'b01001010001110101010001010100001101000001010; //  4 X 3 X X 2 X 1 X 0 X
         11'b10100101011: bk_o =  44'b01011010010010101010001110100010101000010000; //  5 X 4 X X 3 X 2 X 1 0
         11'b10100101100: bk_o =  44'b01001010001110101010001010100001000010101010; //  4 X 3 X X 2 X 1 0 X X
         11'b10100101101: bk_o =  44'b01011010010010101010001110100010000110100000; //  5 X 4 X X 3 X 2 1 X 0
         11'b10100101110: bk_o =  44'b01011010010010101010001110100010000100001010; //  5 X 4 X X 3 X 2 1 0 X
         11'b10100101111: bk_o =  44'b01101010010110101010010010100011001000010000; //  6 X 5 X X 4 X 3 2 1 0
         11'b10100110000: bk_o =  44'b00111010001010101010000100001010101010101010; //  3 X 2 X X 1 0 X X X X
         11'b10100110001: bk_o =  44'b01001010001110101010001000011010101010100000; //  4 X 3 X X 2 1 X X X 0
         11'b10100110010: bk_o =  44'b01001010001110101010001000011010101000001010; //  4 X 3 X X 2 1 X X 0 X
         11'b10100110011: bk_o =  44'b01011010010010101010001100101010101000010000; //  5 X 4 X X 3 2 X X 1 0
         11'b10100110100: bk_o =  44'b01001010001110101010001000011010000010101010; //  4 X 3 X X 2 1 X 0 X X
         11'b10100110101: bk_o =  44'b01011010010010101010001100101010000110100000; //  5 X 4 X X 3 2 X 1 X 0
         11'b10100110110: bk_o =  44'b01011010010010101010001100101010000100001010; //  5 X 4 X X 3 2 X 1 0 X
         11'b10100110111: bk_o =  44'b01101010010110101010010000111010001000010000; //  6 X 5 X X 4 3 X 2 1 0
         11'b10100111000: bk_o =  44'b01001010001110101010001000010000101010101010; //  4 X 3 X X 2 1 0 X X X
         11'b10100111001: bk_o =  44'b01011010010010101010001100100001101010100000; //  5 X 4 X X 3 2 1 X X 0
         11'b10100111010: bk_o =  44'b01011010010010101010001100100001101000001010; //  5 X 4 X X 3 2 1 X 0 X
         11'b10100111011: bk_o =  44'b01101010010110101010010000110010101000010000; //  6 X 5 X X 4 3 2 X 1 0
         11'b10100111100: bk_o =  44'b01011010010010101010001100100001000010101010; //  5 X 4 X X 3 2 1 0 X X
         11'b10100111101: bk_o =  44'b01101010010110101010010000110010000110100000; //  6 X 5 X X 4 3 2 1 X 0
         11'b10100111110: bk_o =  44'b01101010010110101010010000110010000100001010; //  6 X 5 X X 4 3 2 1 0 X
         11'b10100111111: bk_o =  44'b01111010011010101010010101000011001000010000; //  7 X 6 X X 5 4 3 2 1 0
         11'b10101000000: bk_o =  44'b00101010000110100000101010101010101010101010; //  2 X 1 X 0 X X X X X X
         11'b10101000001: bk_o =  44'b00111010001010100001101010101010101010100000; //  3 X 2 X 1 X X X X X 0
         11'b10101000010: bk_o =  44'b00111010001010100001101010101010101000001010; //  3 X 2 X 1 X X X X 0 X
         11'b10101000011: bk_o =  44'b01001010001110100010101010101010101000010000; //  4 X 3 X 2 X X X X 1 0
         11'b10101000100: bk_o =  44'b00111010001010100001101010101010000010101010; //  3 X 2 X 1 X X X 0 X X
         11'b10101000101: bk_o =  44'b01001010001110100010101010101010000110100000; //  4 X 3 X 2 X X X 1 X 0
         11'b10101000110: bk_o =  44'b01001010001110100010101010101010000100001010; //  4 X 3 X 2 X X X 1 0 X
         11'b10101000111: bk_o =  44'b01011010010010100011101010101010001000010000; //  5 X 4 X 3 X X X 2 1 0
         11'b10101001000: bk_o =  44'b00111010001010100001101010100000101010101010; //  3 X 2 X 1 X X 0 X X X
         11'b10101001001: bk_o =  44'b01001010001110100010101010100001101010100000; //  4 X 3 X 2 X X 1 X X 0
         11'b10101001010: bk_o =  44'b01001010001110100010101010100001101000001010; //  4 X 3 X 2 X X 1 X 0 X
         11'b10101001011: bk_o =  44'b01011010010010100011101010100010101000010000; //  5 X 4 X 3 X X 2 X 1 0
         11'b10101001100: bk_o =  44'b01001010001110100010101010100001000010101010; //  4 X 3 X 2 X X 1 0 X X
         11'b10101001101: bk_o =  44'b01011010010010100011101010100010000110100000; //  5 X 4 X 3 X X 2 1 X 0
         11'b10101001110: bk_o =  44'b01011010010010100011101010100010000100001010; //  5 X 4 X 3 X X 2 1 0 X
         11'b10101001111: bk_o =  44'b01101010010110100100101010100011001000010000; //  6 X 5 X 4 X X 3 2 1 0
         11'b10101010000: bk_o =  44'b00111010001010100001101000001010101010101010; //  3 X 2 X 1 X 0 X X X X
         11'b10101010001: bk_o =  44'b01001010001110100010101000011010101010100000; //  4 X 3 X 2 X 1 X X X 0
         11'b10101010010: bk_o =  44'b01001010001110100010101000011010101000001010; //  4 X 3 X 2 X 1 X X 0 X
         11'b10101010011: bk_o =  44'b01011010010010100011101000101010101000010000; //  5 X 4 X 3 X 2 X X 1 0
         11'b10101010100: bk_o =  44'b01001010001110100010101000011010000010101010; //  4 X 3 X 2 X 1 X 0 X X
         11'b10101010101: bk_o =  44'b01011010010010100011101000101010000110100000; //  5 X 4 X 3 X 2 X 1 X 0
         11'b10101010110: bk_o =  44'b01011010010010100011101000101010000100001010; //  5 X 4 X 3 X 2 X 1 0 X
         11'b10101010111: bk_o =  44'b01101010010110100100101000111010001000010000; //  6 X 5 X 4 X 3 X 2 1 0
         11'b10101011000: bk_o =  44'b01001010001110100010101000010000101010101010; //  4 X 3 X 2 X 1 0 X X X
         11'b10101011001: bk_o =  44'b01011010010010100011101000100001101010100000; //  5 X 4 X 3 X 2 1 X X 0
         11'b10101011010: bk_o =  44'b01011010010010100011101000100001101000001010; //  5 X 4 X 3 X 2 1 X 0 X
         11'b10101011011: bk_o =  44'b01101010010110100100101000110010101000010000; //  6 X 5 X 4 X 3 2 X 1 0
         11'b10101011100: bk_o =  44'b01011010010010100011101000100001000010101010; //  5 X 4 X 3 X 2 1 0 X X
         11'b10101011101: bk_o =  44'b01101010010110100100101000110010000110100000; //  6 X 5 X 4 X 3 2 1 X 0
         11'b10101011110: bk_o =  44'b01101010010110100100101000110010000100001010; //  6 X 5 X 4 X 3 2 1 0 X
         11'b10101011111: bk_o =  44'b01111010011010100101101001000011001000010000; //  7 X 6 X 5 X 4 3 2 1 0
         11'b10101100000: bk_o =  44'b00111010001010100001000010101010101010101010; //  3 X 2 X 1 0 X X X X X
         11'b10101100001: bk_o =  44'b01001010001110100010000110101010101010100000; //  4 X 3 X 2 1 X X X X 0
         11'b10101100010: bk_o =  44'b01001010001110100010000110101010101000001010; //  4 X 3 X 2 1 X X X 0 X
         11'b10101100011: bk_o =  44'b01011010010010100011001010101010101000010000; //  5 X 4 X 3 2 X X X 1 0
         11'b10101100100: bk_o =  44'b01001010001110100010000110101010000010101010; //  4 X 3 X 2 1 X X 0 X X
         11'b10101100101: bk_o =  44'b01011010010010100011001010101010000110100000; //  5 X 4 X 3 2 X X 1 X 0
         11'b10101100110: bk_o =  44'b01011010010010100011001010101010000100001010; //  5 X 4 X 3 2 X X 1 0 X
         11'b10101100111: bk_o =  44'b01101010010110100100001110101010001000010000; //  6 X 5 X 4 3 X X 2 1 0
         11'b10101101000: bk_o =  44'b01001010001110100010000110100000101010101010; //  4 X 3 X 2 1 X 0 X X X
         11'b10101101001: bk_o =  44'b01011010010010100011001010100001101010100000; //  5 X 4 X 3 2 X 1 X X 0
         11'b10101101010: bk_o =  44'b01011010010010100011001010100001101000001010; //  5 X 4 X 3 2 X 1 X 0 X
         11'b10101101011: bk_o =  44'b01101010010110100100001110100010101000010000; //  6 X 5 X 4 3 X 2 X 1 0
         11'b10101101100: bk_o =  44'b01011010010010100011001010100001000010101010; //  5 X 4 X 3 2 X 1 0 X X
         11'b10101101101: bk_o =  44'b01101010010110100100001110100010000110100000; //  6 X 5 X 4 3 X 2 1 X 0
         11'b10101101110: bk_o =  44'b01101010010110100100001110100010000100001010; //  6 X 5 X 4 3 X 2 1 0 X
         11'b10101101111: bk_o =  44'b01111010011010100101010010100011001000010000; //  7 X 6 X 5 4 X 3 2 1 0
         11'b10101110000: bk_o =  44'b01001010001110100010000100001010101010101010; //  4 X 3 X 2 1 0 X X X X
         11'b10101110001: bk_o =  44'b01011010010010100011001000011010101010100000; //  5 X 4 X 3 2 1 X X X 0
         11'b10101110010: bk_o =  44'b01011010010010100011001000011010101000001010; //  5 X 4 X 3 2 1 X X 0 X
         11'b10101110011: bk_o =  44'b01101010010110100100001100101010101000010000; //  6 X 5 X 4 3 2 X X 1 0
         11'b10101110100: bk_o =  44'b01011010010010100011001000011010000010101010; //  5 X 4 X 3 2 1 X 0 X X
         11'b10101110101: bk_o =  44'b01101010010110100100001100101010000110100000; //  6 X 5 X 4 3 2 X 1 X 0
         11'b10101110110: bk_o =  44'b01101010010110100100001100101010000100001010; //  6 X 5 X 4 3 2 X 1 0 X
         11'b10101110111: bk_o =  44'b01111010011010100101010000111010001000010000; //  7 X 6 X 5 4 3 X 2 1 0
         11'b10101111000: bk_o =  44'b01011010010010100011001000010000101010101010; //  5 X 4 X 3 2 1 0 X X X
         11'b10101111001: bk_o =  44'b01101010010110100100001100100001101010100000; //  6 X 5 X 4 3 2 1 X X 0
         11'b10101111010: bk_o =  44'b01101010010110100100001100100001101000001010; //  6 X 5 X 4 3 2 1 X 0 X
         11'b10101111011: bk_o =  44'b01111010011010100101010000110010101000010000; //  7 X 6 X 5 4 3 2 X 1 0
         11'b10101111100: bk_o =  44'b01101010010110100100001100100001000010101010; //  6 X 5 X 4 3 2 1 0 X X
         11'b10101111101: bk_o =  44'b01111010011010100101010000110010000110100000; //  7 X 6 X 5 4 3 2 1 X 0
         11'b10101111110: bk_o =  44'b01111010011010100101010000110010000100001010; //  7 X 6 X 5 4 3 2 1 0 X
         11'b10101111111: bk_o =  44'b10001010011110100110010101000011001000010000; //  8 X 7 X 6 5 4 3 2 1 0
         11'b10110000000: bk_o =  44'b00101010000100001010101010101010101010101010; //  2 X 1 0 X X X X X X X
         11'b10110000001: bk_o =  44'b00111010001000011010101010101010101010100000; //  3 X 2 1 X X X X X X 0
         11'b10110000010: bk_o =  44'b00111010001000011010101010101010101000001010; //  3 X 2 1 X X X X X 0 X
         11'b10110000011: bk_o =  44'b01001010001100101010101010101010101000010000; //  4 X 3 2 X X X X X 1 0
         11'b10110000100: bk_o =  44'b00111010001000011010101010101010000010101010; //  3 X 2 1 X X X X 0 X X
         11'b10110000101: bk_o =  44'b01001010001100101010101010101010000110100000; //  4 X 3 2 X X X X 1 X 0
         11'b10110000110: bk_o =  44'b01001010001100101010101010101010000100001010; //  4 X 3 2 X X X X 1 0 X
         11'b10110000111: bk_o =  44'b01011010010000111010101010101010001000010000; //  5 X 4 3 X X X X 2 1 0
         11'b10110001000: bk_o =  44'b00111010001000011010101010100000101010101010; //  3 X 2 1 X X X 0 X X X
         11'b10110001001: bk_o =  44'b01001010001100101010101010100001101010100000; //  4 X 3 2 X X X 1 X X 0
         11'b10110001010: bk_o =  44'b01001010001100101010101010100001101000001010; //  4 X 3 2 X X X 1 X 0 X
         11'b10110001011: bk_o =  44'b01011010010000111010101010100010101000010000; //  5 X 4 3 X X X 2 X 1 0
         11'b10110001100: bk_o =  44'b01001010001100101010101010100001000010101010; //  4 X 3 2 X X X 1 0 X X
         11'b10110001101: bk_o =  44'b01011010010000111010101010100010000110100000; //  5 X 4 3 X X X 2 1 X 0
         11'b10110001110: bk_o =  44'b01011010010000111010101010100010000100001010; //  5 X 4 3 X X X 2 1 0 X
         11'b10110001111: bk_o =  44'b01101010010101001010101010100011001000010000; //  6 X 5 4 X X X 3 2 1 0
         11'b10110010000: bk_o =  44'b00111010001000011010101000001010101010101010; //  3 X 2 1 X X 0 X X X X
         11'b10110010001: bk_o =  44'b01001010001100101010101000011010101010100000; //  4 X 3 2 X X 1 X X X 0
         11'b10110010010: bk_o =  44'b01001010001100101010101000011010101000001010; //  4 X 3 2 X X 1 X X 0 X
         11'b10110010011: bk_o =  44'b01011010010000111010101000101010101000010000; //  5 X 4 3 X X 2 X X 1 0
         11'b10110010100: bk_o =  44'b01001010001100101010101000011010000010101010; //  4 X 3 2 X X 1 X 0 X X
         11'b10110010101: bk_o =  44'b01011010010000111010101000101010000110100000; //  5 X 4 3 X X 2 X 1 X 0
         11'b10110010110: bk_o =  44'b01011010010000111010101000101010000100001010; //  5 X 4 3 X X 2 X 1 0 X
         11'b10110010111: bk_o =  44'b01101010010101001010101000111010001000010000; //  6 X 5 4 X X 3 X 2 1 0
         11'b10110011000: bk_o =  44'b01001010001100101010101000010000101010101010; //  4 X 3 2 X X 1 0 X X X
         11'b10110011001: bk_o =  44'b01011010010000111010101000100001101010100000; //  5 X 4 3 X X 2 1 X X 0
         11'b10110011010: bk_o =  44'b01011010010000111010101000100001101000001010; //  5 X 4 3 X X 2 1 X 0 X
         11'b10110011011: bk_o =  44'b01101010010101001010101000110010101000010000; //  6 X 5 4 X X 3 2 X 1 0
         11'b10110011100: bk_o =  44'b01011010010000111010101000100001000010101010; //  5 X 4 3 X X 2 1 0 X X
         11'b10110011101: bk_o =  44'b01101010010101001010101000110010000110100000; //  6 X 5 4 X X 3 2 1 X 0
         11'b10110011110: bk_o =  44'b01101010010101001010101000110010000100001010; //  6 X 5 4 X X 3 2 1 0 X
         11'b10110011111: bk_o =  44'b01111010011001011010101001000011001000010000; //  7 X 6 5 X X 4 3 2 1 0
         11'b10110100000: bk_o =  44'b00111010001000011010000010101010101010101010; //  3 X 2 1 X 0 X X X X X
         11'b10110100001: bk_o =  44'b01001010001100101010000110101010101010100000; //  4 X 3 2 X 1 X X X X 0
         11'b10110100010: bk_o =  44'b01001010001100101010000110101010101000001010; //  4 X 3 2 X 1 X X X 0 X
         11'b10110100011: bk_o =  44'b01011010010000111010001010101010101000010000; //  5 X 4 3 X 2 X X X 1 0
         11'b10110100100: bk_o =  44'b01001010001100101010000110101010000010101010; //  4 X 3 2 X 1 X X 0 X X
         11'b10110100101: bk_o =  44'b01011010010000111010001010101010000110100000; //  5 X 4 3 X 2 X X 1 X 0
         11'b10110100110: bk_o =  44'b01011010010000111010001010101010000100001010; //  5 X 4 3 X 2 X X 1 0 X
         11'b10110100111: bk_o =  44'b01101010010101001010001110101010001000010000; //  6 X 5 4 X 3 X X 2 1 0
         11'b10110101000: bk_o =  44'b01001010001100101010000110100000101010101010; //  4 X 3 2 X 1 X 0 X X X
         11'b10110101001: bk_o =  44'b01011010010000111010001010100001101010100000; //  5 X 4 3 X 2 X 1 X X 0
         11'b10110101010: bk_o =  44'b01011010010000111010001010100001101000001010; //  5 X 4 3 X 2 X 1 X 0 X
         11'b10110101011: bk_o =  44'b01101010010101001010001110100010101000010000; //  6 X 5 4 X 3 X 2 X 1 0
         11'b10110101100: bk_o =  44'b01011010010000111010001010100001000010101010; //  5 X 4 3 X 2 X 1 0 X X
         11'b10110101101: bk_o =  44'b01101010010101001010001110100010000110100000; //  6 X 5 4 X 3 X 2 1 X 0
         11'b10110101110: bk_o =  44'b01101010010101001010001110100010000100001010; //  6 X 5 4 X 3 X 2 1 0 X
         11'b10110101111: bk_o =  44'b01111010011001011010010010100011001000010000; //  7 X 6 5 X 4 X 3 2 1 0
         11'b10110110000: bk_o =  44'b01001010001100101010000100001010101010101010; //  4 X 3 2 X 1 0 X X X X
         11'b10110110001: bk_o =  44'b01011010010000111010001000011010101010100000; //  5 X 4 3 X 2 1 X X X 0
         11'b10110110010: bk_o =  44'b01011010010000111010001000011010101000001010; //  5 X 4 3 X 2 1 X X 0 X
         11'b10110110011: bk_o =  44'b01101010010101001010001100101010101000010000; //  6 X 5 4 X 3 2 X X 1 0
         11'b10110110100: bk_o =  44'b01011010010000111010001000011010000010101010; //  5 X 4 3 X 2 1 X 0 X X
         11'b10110110101: bk_o =  44'b01101010010101001010001100101010000110100000; //  6 X 5 4 X 3 2 X 1 X 0
         11'b10110110110: bk_o =  44'b01101010010101001010001100101010000100001010; //  6 X 5 4 X 3 2 X 1 0 X
         11'b10110110111: bk_o =  44'b01111010011001011010010000111010001000010000; //  7 X 6 5 X 4 3 X 2 1 0
         11'b10110111000: bk_o =  44'b01011010010000111010001000010000101010101010; //  5 X 4 3 X 2 1 0 X X X
         11'b10110111001: bk_o =  44'b01101010010101001010001100100001101010100000; //  6 X 5 4 X 3 2 1 X X 0
         11'b10110111010: bk_o =  44'b01101010010101001010001100100001101000001010; //  6 X 5 4 X 3 2 1 X 0 X
         11'b10110111011: bk_o =  44'b01111010011001011010010000110010101000010000; //  7 X 6 5 X 4 3 2 X 1 0
         11'b10110111100: bk_o =  44'b01101010010101001010001100100001000010101010; //  6 X 5 4 X 3 2 1 0 X X
         11'b10110111101: bk_o =  44'b01111010011001011010010000110010000110100000; //  7 X 6 5 X 4 3 2 1 X 0
         11'b10110111110: bk_o =  44'b01111010011001011010010000110010000100001010; //  7 X 6 5 X 4 3 2 1 0 X
         11'b10110111111: bk_o =  44'b10001010011101101010010101000011001000010000; //  8 X 7 6 X 5 4 3 2 1 0
         11'b10111000000: bk_o =  44'b00111010001000010000101010101010101010101010; //  3 X 2 1 0 X X X X X X
         11'b10111000001: bk_o =  44'b01001010001100100001101010101010101010100000; //  4 X 3 2 1 X X X X X 0
         11'b10111000010: bk_o =  44'b01001010001100100001101010101010101000001010; //  4 X 3 2 1 X X X X 0 X
         11'b10111000011: bk_o =  44'b01011010010000110010101010101010101000010000; //  5 X 4 3 2 X X X X 1 0
         11'b10111000100: bk_o =  44'b01001010001100100001101010101010000010101010; //  4 X 3 2 1 X X X 0 X X
         11'b10111000101: bk_o =  44'b01011010010000110010101010101010000110100000; //  5 X 4 3 2 X X X 1 X 0
         11'b10111000110: bk_o =  44'b01011010010000110010101010101010000100001010; //  5 X 4 3 2 X X X 1 0 X
         11'b10111000111: bk_o =  44'b01101010010101000011101010101010001000010000; //  6 X 5 4 3 X X X 2 1 0
         11'b10111001000: bk_o =  44'b01001010001100100001101010100000101010101010; //  4 X 3 2 1 X X 0 X X X
         11'b10111001001: bk_o =  44'b01011010010000110010101010100001101010100000; //  5 X 4 3 2 X X 1 X X 0
         11'b10111001010: bk_o =  44'b01011010010000110010101010100001101000001010; //  5 X 4 3 2 X X 1 X 0 X
         11'b10111001011: bk_o =  44'b01101010010101000011101010100010101000010000; //  6 X 5 4 3 X X 2 X 1 0
         11'b10111001100: bk_o =  44'b01011010010000110010101010100001000010101010; //  5 X 4 3 2 X X 1 0 X X
         11'b10111001101: bk_o =  44'b01101010010101000011101010100010000110100000; //  6 X 5 4 3 X X 2 1 X 0
         11'b10111001110: bk_o =  44'b01101010010101000011101010100010000100001010; //  6 X 5 4 3 X X 2 1 0 X
         11'b10111001111: bk_o =  44'b01111010011001010100101010100011001000010000; //  7 X 6 5 4 X X 3 2 1 0
         11'b10111010000: bk_o =  44'b01001010001100100001101000001010101010101010; //  4 X 3 2 1 X 0 X X X X
         11'b10111010001: bk_o =  44'b01011010010000110010101000011010101010100000; //  5 X 4 3 2 X 1 X X X 0
         11'b10111010010: bk_o =  44'b01011010010000110010101000011010101000001010; //  5 X 4 3 2 X 1 X X 0 X
         11'b10111010011: bk_o =  44'b01101010010101000011101000101010101000010000; //  6 X 5 4 3 X 2 X X 1 0
         11'b10111010100: bk_o =  44'b01011010010000110010101000011010000010101010; //  5 X 4 3 2 X 1 X 0 X X
         11'b10111010101: bk_o =  44'b01101010010101000011101000101010000110100000; //  6 X 5 4 3 X 2 X 1 X 0
         11'b10111010110: bk_o =  44'b01101010010101000011101000101010000100001010; //  6 X 5 4 3 X 2 X 1 0 X
         11'b10111010111: bk_o =  44'b01111010011001010100101000111010001000010000; //  7 X 6 5 4 X 3 X 2 1 0
         11'b10111011000: bk_o =  44'b01011010010000110010101000010000101010101010; //  5 X 4 3 2 X 1 0 X X X
         11'b10111011001: bk_o =  44'b01101010010101000011101000100001101010100000; //  6 X 5 4 3 X 2 1 X X 0
         11'b10111011010: bk_o =  44'b01101010010101000011101000100001101000001010; //  6 X 5 4 3 X 2 1 X 0 X
         11'b10111011011: bk_o =  44'b01111010011001010100101000110010101000010000; //  7 X 6 5 4 X 3 2 X 1 0
         11'b10111011100: bk_o =  44'b01101010010101000011101000100001000010101010; //  6 X 5 4 3 X 2 1 0 X X
         11'b10111011101: bk_o =  44'b01111010011001010100101000110010000110100000; //  7 X 6 5 4 X 3 2 1 X 0
         11'b10111011110: bk_o =  44'b01111010011001010100101000110010000100001010; //  7 X 6 5 4 X 3 2 1 0 X
         11'b10111011111: bk_o =  44'b10001010011101100101101001000011001000010000; //  8 X 7 6 5 X 4 3 2 1 0
         11'b10111100000: bk_o =  44'b01001010001100100001000010101010101010101010; //  4 X 3 2 1 0 X X X X X
         11'b10111100001: bk_o =  44'b01011010010000110010000110101010101010100000; //  5 X 4 3 2 1 X X X X 0
         11'b10111100010: bk_o =  44'b01011010010000110010000110101010101000001010; //  5 X 4 3 2 1 X X X 0 X
         11'b10111100011: bk_o =  44'b01101010010101000011001010101010101000010000; //  6 X 5 4 3 2 X X X 1 0
         11'b10111100100: bk_o =  44'b01011010010000110010000110101010000010101010; //  5 X 4 3 2 1 X X 0 X X
         11'b10111100101: bk_o =  44'b01101010010101000011001010101010000110100000; //  6 X 5 4 3 2 X X 1 X 0
         11'b10111100110: bk_o =  44'b01101010010101000011001010101010000100001010; //  6 X 5 4 3 2 X X 1 0 X
         11'b10111100111: bk_o =  44'b01111010011001010100001110101010001000010000; //  7 X 6 5 4 3 X X 2 1 0
         11'b10111101000: bk_o =  44'b01011010010000110010000110100000101010101010; //  5 X 4 3 2 1 X 0 X X X
         11'b10111101001: bk_o =  44'b01101010010101000011001010100001101010100000; //  6 X 5 4 3 2 X 1 X X 0
         11'b10111101010: bk_o =  44'b01101010010101000011001010100001101000001010; //  6 X 5 4 3 2 X 1 X 0 X
         11'b10111101011: bk_o =  44'b01111010011001010100001110100010101000010000; //  7 X 6 5 4 3 X 2 X 1 0
         11'b10111101100: bk_o =  44'b01101010010101000011001010100001000010101010; //  6 X 5 4 3 2 X 1 0 X X
         11'b10111101101: bk_o =  44'b01111010011001010100001110100010000110100000; //  7 X 6 5 4 3 X 2 1 X 0
         11'b10111101110: bk_o =  44'b01111010011001010100001110100010000100001010; //  7 X 6 5 4 3 X 2 1 0 X
         11'b10111101111: bk_o =  44'b10001010011101100101010010100011001000010000; //  8 X 7 6 5 4 X 3 2 1 0
         11'b10111110000: bk_o =  44'b01011010010000110010000100001010101010101010; //  5 X 4 3 2 1 0 X X X X
         11'b10111110001: bk_o =  44'b01101010010101000011001000011010101010100000; //  6 X 5 4 3 2 1 X X X 0
         11'b10111110010: bk_o =  44'b01101010010101000011001000011010101000001010; //  6 X 5 4 3 2 1 X X 0 X
         11'b10111110011: bk_o =  44'b01111010011001010100001100101010101000010000; //  7 X 6 5 4 3 2 X X 1 0
         11'b10111110100: bk_o =  44'b01101010010101000011001000011010000010101010; //  6 X 5 4 3 2 1 X 0 X X
         11'b10111110101: bk_o =  44'b01111010011001010100001100101010000110100000; //  7 X 6 5 4 3 2 X 1 X 0
         11'b10111110110: bk_o =  44'b01111010011001010100001100101010000100001010; //  7 X 6 5 4 3 2 X 1 0 X
         11'b10111110111: bk_o =  44'b10001010011101100101010000111010001000010000; //  8 X 7 6 5 4 3 X 2 1 0
         11'b10111111000: bk_o =  44'b01101010010101000011001000010000101010101010; //  6 X 5 4 3 2 1 0 X X X
         11'b10111111001: bk_o =  44'b01111010011001010100001100100001101010100000; //  7 X 6 5 4 3 2 1 X X 0
         11'b10111111010: bk_o =  44'b01111010011001010100001100100001101000001010; //  7 X 6 5 4 3 2 1 X 0 X
         11'b10111111011: bk_o =  44'b10001010011101100101010000110010101000010000; //  8 X 7 6 5 4 3 2 X 1 0
         11'b10111111100: bk_o =  44'b01111010011001010100001100100001000010101010; //  7 X 6 5 4 3 2 1 0 X X
         11'b10111111101: bk_o =  44'b10001010011101100101010000110010000110100000; //  8 X 7 6 5 4 3 2 1 X 0
         11'b10111111110: bk_o =  44'b10001010011101100101010000110010000100001010; //  8 X 7 6 5 4 3 2 1 0 X
         11'b10111111111: bk_o =  44'b10011010100001110110010101000011001000010000; //  9 X 8 7 6 5 4 3 2 1 0
         11'b11000000000: bk_o =  44'b00010000101010101010101010101010101010101010; //  1 0 X X X X X X X X X
         11'b11000000001: bk_o =  44'b00100001101010101010101010101010101010100000; //  2 1 X X X X X X X X 0
         11'b11000000010: bk_o =  44'b00100001101010101010101010101010101000001010; //  2 1 X X X X X X X 0 X
         11'b11000000011: bk_o =  44'b00110010101010101010101010101010101000010000; //  3 2 X X X X X X X 1 0
         11'b11000000100: bk_o =  44'b00100001101010101010101010101010000010101010; //  2 1 X X X X X X 0 X X
         11'b11000000101: bk_o =  44'b00110010101010101010101010101010000110100000; //  3 2 X X X X X X 1 X 0
         11'b11000000110: bk_o =  44'b00110010101010101010101010101010000100001010; //  3 2 X X X X X X 1 0 X
         11'b11000000111: bk_o =  44'b01000011101010101010101010101010001000010000; //  4 3 X X X X X X 2 1 0
         11'b11000001000: bk_o =  44'b00100001101010101010101010100000101010101010; //  2 1 X X X X X 0 X X X
         11'b11000001001: bk_o =  44'b00110010101010101010101010100001101010100000; //  3 2 X X X X X 1 X X 0
         11'b11000001010: bk_o =  44'b00110010101010101010101010100001101000001010; //  3 2 X X X X X 1 X 0 X
         11'b11000001011: bk_o =  44'b01000011101010101010101010100010101000010000; //  4 3 X X X X X 2 X 1 0
         11'b11000001100: bk_o =  44'b00110010101010101010101010100001000010101010; //  3 2 X X X X X 1 0 X X
         11'b11000001101: bk_o =  44'b01000011101010101010101010100010000110100000; //  4 3 X X X X X 2 1 X 0
         11'b11000001110: bk_o =  44'b01000011101010101010101010100010000100001010; //  4 3 X X X X X 2 1 0 X
         11'b11000001111: bk_o =  44'b01010100101010101010101010100011001000010000; //  5 4 X X X X X 3 2 1 0
         11'b11000010000: bk_o =  44'b00100001101010101010101000001010101010101010; //  2 1 X X X X 0 X X X X
         11'b11000010001: bk_o =  44'b00110010101010101010101000011010101010100000; //  3 2 X X X X 1 X X X 0
         11'b11000010010: bk_o =  44'b00110010101010101010101000011010101000001010; //  3 2 X X X X 1 X X 0 X
         11'b11000010011: bk_o =  44'b01000011101010101010101000101010101000010000; //  4 3 X X X X 2 X X 1 0
         11'b11000010100: bk_o =  44'b00110010101010101010101000011010000010101010; //  3 2 X X X X 1 X 0 X X
         11'b11000010101: bk_o =  44'b01000011101010101010101000101010000110100000; //  4 3 X X X X 2 X 1 X 0
         11'b11000010110: bk_o =  44'b01000011101010101010101000101010000100001010; //  4 3 X X X X 2 X 1 0 X
         11'b11000010111: bk_o =  44'b01010100101010101010101000111010001000010000; //  5 4 X X X X 3 X 2 1 0
         11'b11000011000: bk_o =  44'b00110010101010101010101000010000101010101010; //  3 2 X X X X 1 0 X X X
         11'b11000011001: bk_o =  44'b01000011101010101010101000100001101010100000; //  4 3 X X X X 2 1 X X 0
         11'b11000011010: bk_o =  44'b01000011101010101010101000100001101000001010; //  4 3 X X X X 2 1 X 0 X
         11'b11000011011: bk_o =  44'b01010100101010101010101000110010101000010000; //  5 4 X X X X 3 2 X 1 0
         11'b11000011100: bk_o =  44'b01000011101010101010101000100001000010101010; //  4 3 X X X X 2 1 0 X X
         11'b11000011101: bk_o =  44'b01010100101010101010101000110010000110100000; //  5 4 X X X X 3 2 1 X 0
         11'b11000011110: bk_o =  44'b01010100101010101010101000110010000100001010; //  5 4 X X X X 3 2 1 0 X
         11'b11000011111: bk_o =  44'b01100101101010101010101001000011001000010000; //  6 5 X X X X 4 3 2 1 0
         11'b11000100000: bk_o =  44'b00100001101010101010000010101010101010101010; //  2 1 X X X 0 X X X X X
         11'b11000100001: bk_o =  44'b00110010101010101010000110101010101010100000; //  3 2 X X X 1 X X X X 0
         11'b11000100010: bk_o =  44'b00110010101010101010000110101010101000001010; //  3 2 X X X 1 X X X 0 X
         11'b11000100011: bk_o =  44'b01000011101010101010001010101010101000010000; //  4 3 X X X 2 X X X 1 0
         11'b11000100100: bk_o =  44'b00110010101010101010000110101010000010101010; //  3 2 X X X 1 X X 0 X X
         11'b11000100101: bk_o =  44'b01000011101010101010001010101010000110100000; //  4 3 X X X 2 X X 1 X 0
         11'b11000100110: bk_o =  44'b01000011101010101010001010101010000100001010; //  4 3 X X X 2 X X 1 0 X
         11'b11000100111: bk_o =  44'b01010100101010101010001110101010001000010000; //  5 4 X X X 3 X X 2 1 0
         11'b11000101000: bk_o =  44'b00110010101010101010000110100000101010101010; //  3 2 X X X 1 X 0 X X X
         11'b11000101001: bk_o =  44'b01000011101010101010001010100001101010100000; //  4 3 X X X 2 X 1 X X 0
         11'b11000101010: bk_o =  44'b01000011101010101010001010100001101000001010; //  4 3 X X X 2 X 1 X 0 X
         11'b11000101011: bk_o =  44'b01010100101010101010001110100010101000010000; //  5 4 X X X 3 X 2 X 1 0
         11'b11000101100: bk_o =  44'b01000011101010101010001010100001000010101010; //  4 3 X X X 2 X 1 0 X X
         11'b11000101101: bk_o =  44'b01010100101010101010001110100010000110100000; //  5 4 X X X 3 X 2 1 X 0
         11'b11000101110: bk_o =  44'b01010100101010101010001110100010000100001010; //  5 4 X X X 3 X 2 1 0 X
         11'b11000101111: bk_o =  44'b01100101101010101010010010100011001000010000; //  6 5 X X X 4 X 3 2 1 0
         11'b11000110000: bk_o =  44'b00110010101010101010000100001010101010101010; //  3 2 X X X 1 0 X X X X
         11'b11000110001: bk_o =  44'b01000011101010101010001000011010101010100000; //  4 3 X X X 2 1 X X X 0
         11'b11000110010: bk_o =  44'b01000011101010101010001000011010101000001010; //  4 3 X X X 2 1 X X 0 X
         11'b11000110011: bk_o =  44'b01010100101010101010001100101010101000010000; //  5 4 X X X 3 2 X X 1 0
         11'b11000110100: bk_o =  44'b01000011101010101010001000011010000010101010; //  4 3 X X X 2 1 X 0 X X
         11'b11000110101: bk_o =  44'b01010100101010101010001100101010000110100000; //  5 4 X X X 3 2 X 1 X 0
         11'b11000110110: bk_o =  44'b01010100101010101010001100101010000100001010; //  5 4 X X X 3 2 X 1 0 X
         11'b11000110111: bk_o =  44'b01100101101010101010010000111010001000010000; //  6 5 X X X 4 3 X 2 1 0
         11'b11000111000: bk_o =  44'b01000011101010101010001000010000101010101010; //  4 3 X X X 2 1 0 X X X
         11'b11000111001: bk_o =  44'b01010100101010101010001100100001101010100000; //  5 4 X X X 3 2 1 X X 0
         11'b11000111010: bk_o =  44'b01010100101010101010001100100001101000001010; //  5 4 X X X 3 2 1 X 0 X
         11'b11000111011: bk_o =  44'b01100101101010101010010000110010101000010000; //  6 5 X X X 4 3 2 X 1 0
         11'b11000111100: bk_o =  44'b01010100101010101010001100100001000010101010; //  5 4 X X X 3 2 1 0 X X
         11'b11000111101: bk_o =  44'b01100101101010101010010000110010000110100000; //  6 5 X X X 4 3 2 1 X 0
         11'b11000111110: bk_o =  44'b01100101101010101010010000110010000100001010; //  6 5 X X X 4 3 2 1 0 X
         11'b11000111111: bk_o =  44'b01110110101010101010010101000011001000010000; //  7 6 X X X 5 4 3 2 1 0
         11'b11001000000: bk_o =  44'b00100001101010100000101010101010101010101010; //  2 1 X X 0 X X X X X X
         11'b11001000001: bk_o =  44'b00110010101010100001101010101010101010100000; //  3 2 X X 1 X X X X X 0
         11'b11001000010: bk_o =  44'b00110010101010100001101010101010101000001010; //  3 2 X X 1 X X X X 0 X
         11'b11001000011: bk_o =  44'b01000011101010100010101010101010101000010000; //  4 3 X X 2 X X X X 1 0
         11'b11001000100: bk_o =  44'b00110010101010100001101010101010000010101010; //  3 2 X X 1 X X X 0 X X
         11'b11001000101: bk_o =  44'b01000011101010100010101010101010000110100000; //  4 3 X X 2 X X X 1 X 0
         11'b11001000110: bk_o =  44'b01000011101010100010101010101010000100001010; //  4 3 X X 2 X X X 1 0 X
         11'b11001000111: bk_o =  44'b01010100101010100011101010101010001000010000; //  5 4 X X 3 X X X 2 1 0
         11'b11001001000: bk_o =  44'b00110010101010100001101010100000101010101010; //  3 2 X X 1 X X 0 X X X
         11'b11001001001: bk_o =  44'b01000011101010100010101010100001101010100000; //  4 3 X X 2 X X 1 X X 0
         11'b11001001010: bk_o =  44'b01000011101010100010101010100001101000001010; //  4 3 X X 2 X X 1 X 0 X
         11'b11001001011: bk_o =  44'b01010100101010100011101010100010101000010000; //  5 4 X X 3 X X 2 X 1 0
         11'b11001001100: bk_o =  44'b01000011101010100010101010100001000010101010; //  4 3 X X 2 X X 1 0 X X
         11'b11001001101: bk_o =  44'b01010100101010100011101010100010000110100000; //  5 4 X X 3 X X 2 1 X 0
         11'b11001001110: bk_o =  44'b01010100101010100011101010100010000100001010; //  5 4 X X 3 X X 2 1 0 X
         11'b11001001111: bk_o =  44'b01100101101010100100101010100011001000010000; //  6 5 X X 4 X X 3 2 1 0
         11'b11001010000: bk_o =  44'b00110010101010100001101000001010101010101010; //  3 2 X X 1 X 0 X X X X
         11'b11001010001: bk_o =  44'b01000011101010100010101000011010101010100000; //  4 3 X X 2 X 1 X X X 0
         11'b11001010010: bk_o =  44'b01000011101010100010101000011010101000001010; //  4 3 X X 2 X 1 X X 0 X
         11'b11001010011: bk_o =  44'b01010100101010100011101000101010101000010000; //  5 4 X X 3 X 2 X X 1 0
         11'b11001010100: bk_o =  44'b01000011101010100010101000011010000010101010; //  4 3 X X 2 X 1 X 0 X X
         11'b11001010101: bk_o =  44'b01010100101010100011101000101010000110100000; //  5 4 X X 3 X 2 X 1 X 0
         11'b11001010110: bk_o =  44'b01010100101010100011101000101010000100001010; //  5 4 X X 3 X 2 X 1 0 X
         11'b11001010111: bk_o =  44'b01100101101010100100101000111010001000010000; //  6 5 X X 4 X 3 X 2 1 0
         11'b11001011000: bk_o =  44'b01000011101010100010101000010000101010101010; //  4 3 X X 2 X 1 0 X X X
         11'b11001011001: bk_o =  44'b01010100101010100011101000100001101010100000; //  5 4 X X 3 X 2 1 X X 0
         11'b11001011010: bk_o =  44'b01010100101010100011101000100001101000001010; //  5 4 X X 3 X 2 1 X 0 X
         11'b11001011011: bk_o =  44'b01100101101010100100101000110010101000010000; //  6 5 X X 4 X 3 2 X 1 0
         11'b11001011100: bk_o =  44'b01010100101010100011101000100001000010101010; //  5 4 X X 3 X 2 1 0 X X
         11'b11001011101: bk_o =  44'b01100101101010100100101000110010000110100000; //  6 5 X X 4 X 3 2 1 X 0
         11'b11001011110: bk_o =  44'b01100101101010100100101000110010000100001010; //  6 5 X X 4 X 3 2 1 0 X
         11'b11001011111: bk_o =  44'b01110110101010100101101001000011001000010000; //  7 6 X X 5 X 4 3 2 1 0
         11'b11001100000: bk_o =  44'b00110010101010100001000010101010101010101010; //  3 2 X X 1 0 X X X X X
         11'b11001100001: bk_o =  44'b01000011101010100010000110101010101010100000; //  4 3 X X 2 1 X X X X 0
         11'b11001100010: bk_o =  44'b01000011101010100010000110101010101000001010; //  4 3 X X 2 1 X X X 0 X
         11'b11001100011: bk_o =  44'b01010100101010100011001010101010101000010000; //  5 4 X X 3 2 X X X 1 0
         11'b11001100100: bk_o =  44'b01000011101010100010000110101010000010101010; //  4 3 X X 2 1 X X 0 X X
         11'b11001100101: bk_o =  44'b01010100101010100011001010101010000110100000; //  5 4 X X 3 2 X X 1 X 0
         11'b11001100110: bk_o =  44'b01010100101010100011001010101010000100001010; //  5 4 X X 3 2 X X 1 0 X
         11'b11001100111: bk_o =  44'b01100101101010100100001110101010001000010000; //  6 5 X X 4 3 X X 2 1 0
         11'b11001101000: bk_o =  44'b01000011101010100010000110100000101010101010; //  4 3 X X 2 1 X 0 X X X
         11'b11001101001: bk_o =  44'b01010100101010100011001010100001101010100000; //  5 4 X X 3 2 X 1 X X 0
         11'b11001101010: bk_o =  44'b01010100101010100011001010100001101000001010; //  5 4 X X 3 2 X 1 X 0 X
         11'b11001101011: bk_o =  44'b01100101101010100100001110100010101000010000; //  6 5 X X 4 3 X 2 X 1 0
         11'b11001101100: bk_o =  44'b01010100101010100011001010100001000010101010; //  5 4 X X 3 2 X 1 0 X X
         11'b11001101101: bk_o =  44'b01100101101010100100001110100010000110100000; //  6 5 X X 4 3 X 2 1 X 0
         11'b11001101110: bk_o =  44'b01100101101010100100001110100010000100001010; //  6 5 X X 4 3 X 2 1 0 X
         11'b11001101111: bk_o =  44'b01110110101010100101010010100011001000010000; //  7 6 X X 5 4 X 3 2 1 0
         11'b11001110000: bk_o =  44'b01000011101010100010000100001010101010101010; //  4 3 X X 2 1 0 X X X X
         11'b11001110001: bk_o =  44'b01010100101010100011001000011010101010100000; //  5 4 X X 3 2 1 X X X 0
         11'b11001110010: bk_o =  44'b01010100101010100011001000011010101000001010; //  5 4 X X 3 2 1 X X 0 X
         11'b11001110011: bk_o =  44'b01100101101010100100001100101010101000010000; //  6 5 X X 4 3 2 X X 1 0
         11'b11001110100: bk_o =  44'b01010100101010100011001000011010000010101010; //  5 4 X X 3 2 1 X 0 X X
         11'b11001110101: bk_o =  44'b01100101101010100100001100101010000110100000; //  6 5 X X 4 3 2 X 1 X 0
         11'b11001110110: bk_o =  44'b01100101101010100100001100101010000100001010; //  6 5 X X 4 3 2 X 1 0 X
         11'b11001110111: bk_o =  44'b01110110101010100101010000111010001000010000; //  7 6 X X 5 4 3 X 2 1 0
         11'b11001111000: bk_o =  44'b01010100101010100011001000010000101010101010; //  5 4 X X 3 2 1 0 X X X
         11'b11001111001: bk_o =  44'b01100101101010100100001100100001101010100000; //  6 5 X X 4 3 2 1 X X 0
         11'b11001111010: bk_o =  44'b01100101101010100100001100100001101000001010; //  6 5 X X 4 3 2 1 X 0 X
         11'b11001111011: bk_o =  44'b01110110101010100101010000110010101000010000; //  7 6 X X 5 4 3 2 X 1 0
         11'b11001111100: bk_o =  44'b01100101101010100100001100100001000010101010; //  6 5 X X 4 3 2 1 0 X X
         11'b11001111101: bk_o =  44'b01110110101010100101010000110010000110100000; //  7 6 X X 5 4 3 2 1 X 0
         11'b11001111110: bk_o =  44'b01110110101010100101010000110010000100001010; //  7 6 X X 5 4 3 2 1 0 X
         11'b11001111111: bk_o =  44'b10000111101010100110010101000011001000010000; //  8 7 X X 6 5 4 3 2 1 0
         11'b11010000000: bk_o =  44'b00100001101000001010101010101010101010101010; //  2 1 X 0 X X X X X X X
         11'b11010000001: bk_o =  44'b00110010101000011010101010101010101010100000; //  3 2 X 1 X X X X X X 0
         11'b11010000010: bk_o =  44'b00110010101000011010101010101010101000001010; //  3 2 X 1 X X X X X 0 X
         11'b11010000011: bk_o =  44'b01000011101000101010101010101010101000010000; //  4 3 X 2 X X X X X 1 0
         11'b11010000100: bk_o =  44'b00110010101000011010101010101010000010101010; //  3 2 X 1 X X X X 0 X X
         11'b11010000101: bk_o =  44'b01000011101000101010101010101010000110100000; //  4 3 X 2 X X X X 1 X 0
         11'b11010000110: bk_o =  44'b01000011101000101010101010101010000100001010; //  4 3 X 2 X X X X 1 0 X
         11'b11010000111: bk_o =  44'b01010100101000111010101010101010001000010000; //  5 4 X 3 X X X X 2 1 0
         11'b11010001000: bk_o =  44'b00110010101000011010101010100000101010101010; //  3 2 X 1 X X X 0 X X X
         11'b11010001001: bk_o =  44'b01000011101000101010101010100001101010100000; //  4 3 X 2 X X X 1 X X 0
         11'b11010001010: bk_o =  44'b01000011101000101010101010100001101000001010; //  4 3 X 2 X X X 1 X 0 X
         11'b11010001011: bk_o =  44'b01010100101000111010101010100010101000010000; //  5 4 X 3 X X X 2 X 1 0
         11'b11010001100: bk_o =  44'b01000011101000101010101010100001000010101010; //  4 3 X 2 X X X 1 0 X X
         11'b11010001101: bk_o =  44'b01010100101000111010101010100010000110100000; //  5 4 X 3 X X X 2 1 X 0
         11'b11010001110: bk_o =  44'b01010100101000111010101010100010000100001010; //  5 4 X 3 X X X 2 1 0 X
         11'b11010001111: bk_o =  44'b01100101101001001010101010100011001000010000; //  6 5 X 4 X X X 3 2 1 0
         11'b11010010000: bk_o =  44'b00110010101000011010101000001010101010101010; //  3 2 X 1 X X 0 X X X X
         11'b11010010001: bk_o =  44'b01000011101000101010101000011010101010100000; //  4 3 X 2 X X 1 X X X 0
         11'b11010010010: bk_o =  44'b01000011101000101010101000011010101000001010; //  4 3 X 2 X X 1 X X 0 X
         11'b11010010011: bk_o =  44'b01010100101000111010101000101010101000010000; //  5 4 X 3 X X 2 X X 1 0
         11'b11010010100: bk_o =  44'b01000011101000101010101000011010000010101010; //  4 3 X 2 X X 1 X 0 X X
         11'b11010010101: bk_o =  44'b01010100101000111010101000101010000110100000; //  5 4 X 3 X X 2 X 1 X 0
         11'b11010010110: bk_o =  44'b01010100101000111010101000101010000100001010; //  5 4 X 3 X X 2 X 1 0 X
         11'b11010010111: bk_o =  44'b01100101101001001010101000111010001000010000; //  6 5 X 4 X X 3 X 2 1 0
         11'b11010011000: bk_o =  44'b01000011101000101010101000010000101010101010; //  4 3 X 2 X X 1 0 X X X
         11'b11010011001: bk_o =  44'b01010100101000111010101000100001101010100000; //  5 4 X 3 X X 2 1 X X 0
         11'b11010011010: bk_o =  44'b01010100101000111010