# Getting started (Quickstart)
    # Clone the latest repo
    git clone https://github.com/black-parrot/pre-alpha-release.git
    cd pre-alpha-release

    # Install a minimal set of tools
    make verilator
    make ucode
    make libs

    # Running your first test
    cd bp_top/syn
    make build.sc sim.sc PROG=hello_world

## Getting started (Full)
    # Clone the latest repo
    git clone https://github.com/black-parrot/pre-alpha-release.git
    cd pre-alpha-release

    # make tools will clone, build and install toolchains needed for BlackParrot
    # For faster builds, make tools -j is parallelizable!
    make tools
    # make tidy_tools  will remove all (10+ GB) tool build directories, while leaving the installation
    make tidy_tools
    # make progs will build all open source test programs that ship with BlackParrot
    make progs
    # make ucode will build the CCE microcode used for BlackParrot's coherence engine
    # This is necessary whenever changes are made to CCE ucode. Eventually, CCE ucode
    #  will be built 'on demand' and so this command may become unnecessary
    make ucode
    # Update hardware libraries (basejump_stl)
    make libs

The *master* branch contains most recent stable version. This is the recommended branch for someone wishing to try out BlackParrot.

The *dev* branch contains the most recent development version, being tested internally. This branch may have bugfixes or improvements not yet propagated to master.

Other branches are used for internal development and are not recommended for casual usage.

## Prerequisites
BlackParrot requires Python, Verilator and a RISCV GNU toolchain in order to build and run tests. The easiest way to get these and ensure compatibility is by using the tools in external/, which the Makefiles are automatically set up to use. One can also override these paths in Makefile.common.  Dependencies for riscv-gnu-toolchain are listed below:

### Centos

    yum install autoconf automake libmpc-devel mpfr-devel gmp-devel gawk  bison flex texinfo patchutils gcc gcc-c++ zlib-devel expat-devel

### Ubuntu

    sudo apt-get install autoconf automake autotools-dev curl libmpc-dev libmpfr-dev libgmp-dev gawk build-essential bison flex texinfo gperf libtool patchutils bc zlib1g-dev libexpat-dev

BlackParrot has been tested extensively on CentOS 7. Please raise issues with problems found on this or other platforms! 

## Running tests
BlackParrot is designed to be modular.  The main testbenches are at the FE, BE, ME and TOP levels. The general syntax for running a testbench is:
    
    cd bp_<end>/syn
    make <ACTION>.<TOOL> [TB=] [CFG=] [PROG=] [DUMP=] [COV=] [<TRACER>_P=]
    
### Supported ACTIONs
- lint (lints the DUT of a single testbench)
- build (builds a single testbench)
- sim (runs a single test)
- check_design (checks for DC elaborability, which is a proxy for synthesizability)
- regress (runs a suite of tests, only defined for select testbenches)
### Supported TOOLs
- Verilator
- Synopsys VCS
- Synopsys DC

NOTE: Verilator is the free, open-source tool used to evaluate BlackParrot.  VCS and DC are used for simulation and synthesis. If you wish to use these tools, set up the appropriate environment variables in Makefile.common

### Supported TBs
- Found in bp\_\<end\>/test/tb/
### Supported CFGs
- Found in bp\_common/src/include/bp_common_aviary_pkg.vh
- List of system parameters passed to most modules in BlackParrot
### Supported PROGs
- Found in bp\_common/test/mem
- Verilog hex format, generated by make progs
### Supported DUMP
- 1 to dump a vcd
### Supported COV
- 1 to generate line and toggle coverage data
### Supported TRACERs
- CMT\_TRACE\_P = trace each commit which writes to a GPR, used for automatic spike diffing
- CALC\_TRACE\_P = trace the Calculator pipeline (warning, large logfiles)
- CCE\_TRACE\_P = trace coherence traffic between the LCEs and CCEs

### Example commands
    make build.v sim.v PROG=hello_world DUMP=1  # Run hello_world in VCS with dumping
    make dve.v PROG=hello_world                 # Open hello_world waveform in dve
    make build.sc sim.sc PROG=hello_world COV=1 # Run hello_world in Verilator with coverage

    make regress.sc -j 10                       # Run riscv-tests in Verilator with 10 threads
    make regress_beebs.v -j 5                   # Run beebs suite in VCS with 5 threads

NOTE: pardon our dust as we update our testbenches. The main testbench bp_top testbench is well supported.

## Examining results
Running a test will generate a ton of subdirectories in bp_\<end\>/syn/

        bp_<end>/syn/results/<tool>/<tb>.<cfg>.build/sim{v,sc}
        bp_<end>/syn/results/<tool>/<tb>.<cfg>.sim.<prog>/(symlink to sim{v,sc})
        bp_<end>/syn/results/<tool>/<tb>.<cfg>.sim.<prog>/dump.vcd
        bp_<end>/syn/results/<tool>/<tb>.<cfg>.sim.<prog>/testbench.v
        bp_<end>/syn/results/<tool>/<tb>.<cfg>.sim.<prog>/etc.
        bp_<end>/syn/results/<tool>/<tb>.<cfg>.cov/*.dat

        bp_<end>/syn/logs/<tool>/<tb>.<cfg>.build.log
        bp_<end>/syn/logs/<tool>/<tb>.<cfg>.sim.<prog>.log
        bp_<end>/syn/logs/<tool>/<tb>.<cfg>.cov.log

        bp_<end>/syn/reports/<tool>/<tb>.<cfg>.build.{rpt,err}
        bp_<end>/syn/reports/<tool>/<tb>.<cfg>.sim.<prog>.{rpt,err}
        bp_<end>/syn/reports/<tool>/<tb>.<cfg>.cov.<prog>.{rpt,err}

### results
Run directory for tools, generating output artifacts
### logs
Full output of tool runs
### reports
Summary of tool runs. For example, whether tests pass or fail
