#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""
Sphinx documentation build configuration file.

Created by sphinx-quickstart on Fri Jun  9 13:47:02 2017.

This file is execfile()d with the current directory set to its
containing dir.

Note that not all possible configuration values are present in this
autogenerated file.

All configuration values have a default; values that are commented out
serve to show the default.

If extensions (or modules to document with autodoc) are in another
directory, add these directories to sys.path here. If the directory is
relative to the documentation root, use os.path.abspath to make it
absolute, like shown here.
"""

import os
import sys
from typing import Dict

# Insert Countdoom's path into the system.
sys.path.insert(0, os.path.abspath('..'))

import countdoom  # NOQA: E402

# -- General configuration ---------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
#
# needs_sphinx = '1.0'

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom ones.
extensions = [
    'sphinx.ext.autodoc',
    'sphinx_autodoc_typehints',
    'sphinx.ext.autosummary',
    'sphinx.ext.doctest',
    'sphinx.ext.intersphinx',
    'sphinx.ext.linkcode',
    'sphinx.ext.todo',
    'sphinx.ext.viewcode',
    'm2r',
]

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# The suffix(es) of source filenames.
# You can specify multiple suffix as a list of string:
#
# source_suffix = ['.rst', '.md']
source_suffix = ['.rst', '.md']

# The master toctree document.
master_doc = 'index'

# General information about the project.
project = u'Countdoom'
copyright = u"2019-present, René-Marc Simard"
author = u"René-Marc Simard"

# The version info for the project you're documenting, acts as replacement
# for |version| and |release|, also used in various other places throughout
# the built documents.
#
# The short X.Y version.
version = '0.2.1'
# The full version, including alpha/beta/rc tags.
release = version

# Global include string included in the footer of all parsed files.
rst_epilog = ''

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = None

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This patterns also effect to html_static_path and html_extra_path
exclude_patterns = ['_build', 'Thumbs.db', '.DS_Store']

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = 'sphinx'


# -- Autodoc configuration ---------------------------------------------

autoclass_content = 'class'

autodoc_member_order = 'bysource'

autodoc_default_options = {
    'members': None,
    'member-order': 'bysource',
    'special-members': None,
    'undoc-members': True,
    'exclude-members': '__dict__,__module__,__weakref__',
}


# -- Options for HTML output -------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
html_theme = 'sphinx_rtd_theme'

# Theme options are theme-specific and customize the look and feel of a
# theme further.  For a list of options available for each theme, see the
# documentation.
#
html_theme_options = {'collapse_navigation': False}

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['_static']


# -- Options for HTMLHelp output ---------------------------------------

# Output file base name for HTML help builder.
htmlhelp_basename = 'countdoomdoc'


# -- Options for LaTeX output ------------------------------------------

latex_elements = {
    # The paper size ('letterpaper' or 'a4paper').
    #
    # 'papersize': 'letterpaper',
    # The font size ('10pt', '11pt' or '12pt').
    #
    # 'pointsize': '10pt',
    # Additional stuff for the LaTeX preamble.
    #
    # 'preamble': '',
    # Latex figure (float) alignment
    #
    # 'figure_align': 'htbp',
}  # type: Dict[str, str]

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title, author, documentclass
# [howto, manual, or own class]).
latex_documents = [
    (
        master_doc,
        'countdoom.tex',
        u'Countdoom Documentation',
        u'René-Marc Simard',
        'manual',
    )
]


# -- Options for manual page output ------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [
    (master_doc, 'Countdoom', u'Countdoom Documentation', [author], 1)
]


# -- Options for Texinfo output ----------------------------------------

# Grouping the document tree into Texinfo files. List of tuples
# (source start file, target name, title, author,
#  dir menu entry, description, category)
texinfo_documents = [
    (
        master_doc,
        'Countdoom',
        u'Countdoom Documentation',
        author,
        'Countdoom',
        'Doomsday Clock client package for Python.',
        'Miscellaneous',
    )
]


# -- Intersphynx configuration -----------------------------------------

# Names and locations of other projects that should be linked to in this doc.
intersphinx_mapping = {'python': ('https://docs.python.org/3/', None)}


# -- Linkcode configuration --------------------------------------------


def linkcode_resolve(domain, info):
    """
    Resolve function for the linkcode extension.

    based on https://github.com/Lasagne/Lasagne/blob/master/docs/conf.py
    """
    module = 'countdoom'
    file = countdoom.__file__  # NOQA: F821
    repo = 'https://github.com/renemarc/countdoom'

    def find_source() -> tuple:
        """
        Try to find the file and line number.

        Based on code from numpy:
        https://github.com/numpy/numpy/blob/master/doc/source/conf.py#L286

        :return: Tuple defining the location of the source
        """
        obj = sys.modules[info['module']]
        for part in info['fullname'].split('.'):
            obj = getattr(obj, part)

        import inspect

        func = inspect.getsourcefile(obj)
        if func is not None:
            func = os.path.relpath(func, start=os.path.dirname(file))
        source, lineno = inspect.getsourcelines(obj)
        return module, func, lineno, lineno + len(source) - 1

    if domain != 'py' or not info['module']:
        return None

    try:
        filename = '%s/%s#L%d-L%d' % find_source()
    except Exception:
        filename = info['module'].replace('.', '/') + '.py'
    tag = 'master' if 'dev' in release else ('v' + release)
    return "%s/blob/%s/%s" % (repo, tag, filename)


# -- M2R configuration -------------------------------------------------

# Parse relative links into ref and doc directives.
m2r_parse_relative_links = True


# -- Todos configuration -----------------------------------------------

# If true, `todos` and `todoLists` produce output, else they produce nothing.
todo_include_todos = True
