import { IResolvable, IResolveContext } from '@aws-cdk/core';
export declare class JsonPathToken implements IResolvable {
    readonly path: string;
    static isJsonPathToken(x: IResolvable): x is JsonPathToken;
    readonly creationStack: string[];
    displayHint: string;
    constructor(path: string);
    resolve(_ctx: IResolveContext): any;
    toString(): string;
    toJSON(): string;
}
/**
 * Deep render a JSON object to expand JSON path fields, updating the key to end in '.$'
 */
export declare function renderObject(obj: object | undefined): object | undefined;
/**
 * Return all JSON paths that are used in the given structure
 */
export declare function findReferencedPaths(obj: object | undefined): Set<string>;
interface FieldHandlers {
    handleString(key: string, x: string): {
        [key: string]: string;
    };
    handleList(key: string, x: string[]): {
        [key: string]: string[] | string;
    };
    handleNumber(key: string, x: number): {
        [key: string]: number | string;
    };
    handleBoolean(key: string, x: boolean): {
        [key: string]: boolean;
    };
}
export declare function recurseObject(obj: object | undefined, handlers: FieldHandlers, visited?: object[]): object | undefined;
/**
 * If the indicated string is an encoded JSON path, return the path
 *
 * Otherwise return undefined.
 */
export declare function jsonPathString(x: string): string | undefined;
export {};
