Overview
========

You can [install](./install.md) Nx5d either from PyPI,
from its Git repository, or use our pre-packaged
Jupyter Server container image.

To get an impression, you can review quick
[in-memory examples](./quick-start.md) to find out
how Nx5d "feels like".
These will work with purely artificial data, no files
required. They're intended only as a low-effort way to
get acquaninted.

To actually work with real-life data that your experimental
endstation has produced, understanding
[Nx5d's API elements](api-guide.md) is crucial.

[Working with spice](spice-work.md) is one of the central
discipline in Nx5d -- and therefore deserves its own
section in the User's Guide.

Yes, we *are* eating our own dog food: we're using Nx5d in
our beamlines and labs. We have prepared
some smoothed-out, but otherwise [full-sized exmples](./examples.md)
for you to check out.

Nx5d supports a small number of [beamlines](./beamlines.md)
out-of-the-box. These are typically the facilities that we're
dealing with on a regular basis -- our own, but also 3rd-party
facilities we frequent often.

Finally, you're eventually going to want to
[access your own data](./extending.md)
and do your own processing. This section will help you
navigate the necessary steps and API subclassing.
