# Nx5d - Automating Data Analysis

## What & Why

Nx5d is a Python framework for rapid data processing and analysis.
It makes a high degree of automation possible by separating data
analysis in an *engineering* and a *scientific* part,
and offering fine-grained management of analysis parameters.

Nx5d enables you to:

  - access the output of a scientific facility in a physically
    meaningful coordinate system automatically, immediately,
	and transparently

  - design the scientific part of your data analysis in a
    device-agnostic way, basing it on the physical data
	representation instead of the device-dependent one
	
  - focus on your attention on a *scientist's task*, namely
    that of correlating knowledge, instead of writing
	boilerplate data transformation code.
	
The result is a drastically improved data analysis time, and the
ability to share and compare experimental data and analysis algorithms
of different scientists, from varying facilities, on similar topics -
in any combination.

## Getting Started

You can [install Nx5d](./user-guide/install.md) from PyPI or directly
from source, or you can run a pre-packaged Jupyter container image
that has Nx5d preinstalled.

Nx5d is a framework, which means there's no application to "run",
just compontents to help you define your own data processing.
See [a simple example](./spice-example) to start off, or jump right
in with [the User's Guide](./user-guide). If you're interested in a
deep dive, try reading up on [the concepts](./concepts) of Nx5d.

## How to Participate

We very much welcome 3rd-party contributions.
The main repository around which nx5d development happens is
[over at GitLab](https://gitlab.com/kmc3-xpp/nx5d).


