# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: envoy/api/v2/core/socket_option.proto, envoy/api/v2/core/address.proto, envoy/api/v2/core/backoff.proto, envoy/api/v2/core/http_uri.proto, envoy/api/v2/core/base.proto, envoy/api/v2/core/grpc_service.proto, envoy/api/v2/core/config_source.proto, envoy/api/v2/core/event_service_config.proto, envoy/api/v2/core/health_check.proto, envoy/api/v2/core/protocol.proto
# plugin: python-betterproto
import warnings
from dataclasses import dataclass
from datetime import timedelta
from typing import Dict, List, Optional

import betterproto
from betterproto.grpc.grpclib_server import ServiceBase


class SocketOptionSocketState(betterproto.Enum):
    STATE_PREBIND = 0
    STATE_BOUND = 1
    STATE_LISTENING = 2


class SocketAddressProtocol(betterproto.Enum):
    TCP = 0
    UDP = 1


class RoutingPriority(betterproto.Enum):
    DEFAULT = 0
    HIGH = 1


class RequestMethod(betterproto.Enum):
    METHOD_UNSPECIFIED = 0
    GET = 1
    HEAD = 2
    POST = 3
    PUT = 4
    DELETE = 5
    CONNECT = 6
    OPTIONS = 7
    TRACE = 8
    PATCH = 9


class TrafficDirection(betterproto.Enum):
    UNSPECIFIED = 0
    INBOUND = 1
    OUTBOUND = 2


class ApiVersion(betterproto.Enum):
    AUTO = 0
    V2 = 1
    V3 = 2


class ApiConfigSourceApiType(betterproto.Enum):
    UNSUPPORTED_REST_LEGACY = 0
    REST = 1
    GRPC = 2
    DELTA_GRPC = 3


class HealthStatus(betterproto.Enum):
    UNKNOWN = 0
    HEALTHY = 1
    UNHEALTHY = 2
    DRAINING = 3
    TIMEOUT = 4
    DEGRADED = 5


class HttpProtocolOptionsHeadersWithUnderscoresAction(betterproto.Enum):
    ALLOW = 0
    REJECT_REQUEST = 1
    DROP_HEADER = 2


@dataclass(eq=False, repr=False)
class SocketOption(betterproto.Message):
    """
    Generic socket option message. This would be used to set socket options
    that might not exist in upstream kernels or precompiled Envoy binaries.
    [#next-free-field: 7]
    """

    # An optional name to give this socket option for debugging, etc. Uniqueness
    # is not required and no special meaning is assumed.
    description: str = betterproto.string_field(1)
    # Corresponding to the level value passed to setsockopt, such as IPPROTO_TCP
    level: int = betterproto.int64_field(2)
    # The numeric name as passed to setsockopt
    name: int = betterproto.int64_field(3)
    # Because many sockopts take an int value.
    int_value: int = betterproto.int64_field(4, group="value")
    # Otherwise it's a byte buffer.
    buf_value: bytes = betterproto.bytes_field(5, group="value")
    # The state in which the option will be applied. When used in BindConfig
    # STATE_PREBIND is currently the only valid value.
    state: "SocketOptionSocketState" = betterproto.enum_field(6)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class Pipe(betterproto.Message):
    """
    Generic socket option message. This would be used to set socket options
    that might not exist in upstream kernels or precompiled Envoy binaries.
    [#next-free-field: 7]
    """

    # An optional name to give this socket option for debugging, etc. Uniqueness
    # is not required and no special meaning is assumed.
    path: str = betterproto.string_field(1)
    # Corresponding to the level value passed to setsockopt, such as IPPROTO_TCP
    mode: int = betterproto.uint32_field(2)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class SocketAddress(betterproto.Message):
    protocol: "SocketAddressProtocol" = betterproto.enum_field(1)
    address: str = betterproto.string_field(2)
    port_value: int = betterproto.uint32_field(3, group="port_specifier")
    named_port: str = betterproto.string_field(4, group="port_specifier")
    resolver_name: str = betterproto.string_field(5)
    ipv4_compat: bool = betterproto.bool_field(6)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class TcpKeepalive(betterproto.Message):
    keepalive_probes: Optional[int] = betterproto.message_field(
        1, wraps=betterproto.TYPE_UINT32
    )
    keepalive_time: Optional[int] = betterproto.message_field(
        2, wraps=betterproto.TYPE_UINT32
    )
    keepalive_interval: Optional[int] = betterproto.message_field(
        3, wraps=betterproto.TYPE_UINT32
    )

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class BindConfig(betterproto.Message):
    source_address: "SocketAddress" = betterproto.message_field(1)
    freebind: Optional[bool] = betterproto.message_field(2, wraps=betterproto.TYPE_BOOL)
    socket_options: List["SocketOption"] = betterproto.message_field(3)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class Address(betterproto.Message):
    socket_address: "SocketAddress" = betterproto.message_field(1, group="address")
    pipe: "Pipe" = betterproto.message_field(2, group="address")

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class CidrRange(betterproto.Message):
    address_prefix: str = betterproto.string_field(1)
    prefix_len: Optional[int] = betterproto.message_field(
        2, wraps=betterproto.TYPE_UINT32
    )

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class BackoffStrategy(betterproto.Message):
    """
    Generic socket option message. This would be used to set socket options
    that might not exist in upstream kernels or precompiled Envoy binaries.
    [#next-free-field: 7]
    """

    # An optional name to give this socket option for debugging, etc. Uniqueness
    # is not required and no special meaning is assumed.
    base_interval: timedelta = betterproto.message_field(1)
    # Corresponding to the level value passed to setsockopt, such as IPPROTO_TCP
    max_interval: timedelta = betterproto.message_field(2)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class HttpUri(betterproto.Message):
    """
    Generic socket option message. This would be used to set socket options
    that might not exist in upstream kernels or precompiled Envoy binaries.
    [#next-free-field: 7]
    """

    # An optional name to give this socket option for debugging, etc. Uniqueness
    # is not required and no special meaning is assumed.
    uri: str = betterproto.string_field(1)
    # Corresponding to the level value passed to setsockopt, such as IPPROTO_TCP
    cluster: str = betterproto.string_field(2, group="http_upstream_type")
    # The numeric name as passed to setsockopt
    timeout: timedelta = betterproto.message_field(3)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class Locality(betterproto.Message):
    """
    Generic socket option message. This would be used to set socket options
    that might not exist in upstream kernels or precompiled Envoy binaries.
    [#next-free-field: 7]
    """

    # An optional name to give this socket option for debugging, etc. Uniqueness
    # is not required and no special meaning is assumed.
    region: str = betterproto.string_field(1)
    # Corresponding to the level value passed to setsockopt, such as IPPROTO_TCP
    zone: str = betterproto.string_field(2)
    # The numeric name as passed to setsockopt
    sub_zone: str = betterproto.string_field(3)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class BuildVersion(betterproto.Message):
    version: "___type__.SemanticVersion" = betterproto.message_field(1)
    metadata: "betterproto_lib_google_protobuf.Struct" = betterproto.message_field(2)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class Extension(betterproto.Message):
    name: str = betterproto.string_field(1)
    category: str = betterproto.string_field(2)
    type_descriptor: str = betterproto.string_field(3)
    version: "BuildVersion" = betterproto.message_field(4)
    disabled: bool = betterproto.bool_field(5)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class Node(betterproto.Message):
    id: str = betterproto.string_field(1)
    cluster: str = betterproto.string_field(2)
    metadata: "betterproto_lib_google_protobuf.Struct" = betterproto.message_field(3)
    locality: "Locality" = betterproto.message_field(4)
    build_version: str = betterproto.string_field(5)
    user_agent_name: str = betterproto.string_field(6)
    user_agent_version: str = betterproto.string_field(
        7, group="user_agent_version_type"
    )
    user_agent_build_version: "BuildVersion" = betterproto.message_field(
        8, group="user_agent_version_type"
    )
    extensions: List["Extension"] = betterproto.message_field(9)
    client_features: List[str] = betterproto.string_field(10)
    listening_addresses: List["Address"] = betterproto.message_field(11)

    def __post_init__(self) -> None:
        super().__post_init__()
        if self.build_version:
            warnings.warn("Node.build_version is deprecated", DeprecationWarning)


@dataclass(eq=False, repr=False)
class Metadata(betterproto.Message):
    filter_metadata: Dict[
        str, "betterproto_lib_google_protobuf.Struct"
    ] = betterproto.map_field(1, betterproto.TYPE_STRING, betterproto.TYPE_MESSAGE)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class RuntimeUInt32(betterproto.Message):
    default_value: int = betterproto.uint32_field(2)
    runtime_key: str = betterproto.string_field(3)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class RuntimeDouble(betterproto.Message):
    default_value: float = betterproto.double_field(1)
    runtime_key: str = betterproto.string_field(2)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class RuntimeFeatureFlag(betterproto.Message):
    default_value: Optional[bool] = betterproto.message_field(
        1, wraps=betterproto.TYPE_BOOL
    )
    runtime_key: str = betterproto.string_field(2)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class HeaderValue(betterproto.Message):
    key: str = betterproto.string_field(1)
    value: str = betterproto.string_field(2)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class HeaderValueOption(betterproto.Message):
    header: "HeaderValue" = betterproto.message_field(1)
    append: Optional[bool] = betterproto.message_field(2, wraps=betterproto.TYPE_BOOL)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class HeaderMap(betterproto.Message):
    headers: List["HeaderValue"] = betterproto.message_field(1)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class DataSource(betterproto.Message):
    filename: str = betterproto.string_field(1, group="specifier")
    inline_bytes: bytes = betterproto.bytes_field(2, group="specifier")
    inline_string: str = betterproto.string_field(3, group="specifier")

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class RetryPolicy(betterproto.Message):
    retry_back_off: "BackoffStrategy" = betterproto.message_field(1)
    num_retries: Optional[int] = betterproto.message_field(
        2, wraps=betterproto.TYPE_UINT32
    )

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class RemoteDataSource(betterproto.Message):
    http_uri: "HttpUri" = betterproto.message_field(1)
    sha256: str = betterproto.string_field(2)
    retry_policy: "RetryPolicy" = betterproto.message_field(3)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class AsyncDataSource(betterproto.Message):
    local: "DataSource" = betterproto.message_field(1, group="specifier")
    remote: "RemoteDataSource" = betterproto.message_field(2, group="specifier")

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class TransportSocket(betterproto.Message):
    name: str = betterproto.string_field(1)
    config: "betterproto_lib_google_protobuf.Struct" = betterproto.message_field(
        2, group="config_type"
    )
    typed_config: "betterproto_lib_google_protobuf.Any" = betterproto.message_field(
        3, group="config_type"
    )

    def __post_init__(self) -> None:
        super().__post_init__()
        if self.config:
            warnings.warn("TransportSocket.config is deprecated", DeprecationWarning)


@dataclass(eq=False, repr=False)
class RuntimeFractionalPercent(betterproto.Message):
    default_value: "___type__.FractionalPercent" = betterproto.message_field(1)
    runtime_key: str = betterproto.string_field(2)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class ControlPlane(betterproto.Message):
    identifier: str = betterproto.string_field(1)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class GrpcService(betterproto.Message):
    """
    Generic socket option message. This would be used to set socket options
    that might not exist in upstream kernels or precompiled Envoy binaries.
    [#next-free-field: 7]
    """

    # An optional name to give this socket option for debugging, etc. Uniqueness
    # is not required and no special meaning is assumed.
    envoy_grpc: "GrpcServiceEnvoyGrpc" = betterproto.message_field(
        1, group="target_specifier"
    )
    # Corresponding to the level value passed to setsockopt, such as IPPROTO_TCP
    google_grpc: "GrpcServiceGoogleGrpc" = betterproto.message_field(
        2, group="target_specifier"
    )
    # The numeric name as passed to setsockopt
    timeout: timedelta = betterproto.message_field(3)
    # Because many sockopts take an int value.
    initial_metadata: List["HeaderValue"] = betterproto.message_field(5)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class GrpcServiceEnvoyGrpc(betterproto.Message):
    cluster_name: str = betterproto.string_field(1)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class GrpcServiceGoogleGrpc(betterproto.Message):
    target_uri: str = betterproto.string_field(1)
    channel_credentials: "GrpcServiceGoogleGrpcChannelCredentials" = (
        betterproto.message_field(2)
    )
    call_credentials: List[
        "GrpcServiceGoogleGrpcCallCredentials"
    ] = betterproto.message_field(3)
    stat_prefix: str = betterproto.string_field(4)
    credentials_factory_name: str = betterproto.string_field(5)
    config: "betterproto_lib_google_protobuf.Struct" = betterproto.message_field(6)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class GrpcServiceGoogleGrpcSslCredentials(betterproto.Message):
    root_certs: "DataSource" = betterproto.message_field(1)
    private_key: "DataSource" = betterproto.message_field(2)
    cert_chain: "DataSource" = betterproto.message_field(3)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class GrpcServiceGoogleGrpcGoogleLocalCredentials(betterproto.Message):
    pass

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class GrpcServiceGoogleGrpcChannelCredentials(betterproto.Message):
    ssl_credentials: "GrpcServiceGoogleGrpcSslCredentials" = betterproto.message_field(
        1, group="credential_specifier"
    )
    google_default: "betterproto_lib_google_protobuf.Empty" = betterproto.message_field(
        2, group="credential_specifier"
    )
    local_credentials: "GrpcServiceGoogleGrpcGoogleLocalCredentials" = (
        betterproto.message_field(3, group="credential_specifier")
    )

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class GrpcServiceGoogleGrpcCallCredentials(betterproto.Message):
    access_token: str = betterproto.string_field(1, group="credential_specifier")
    google_compute_engine: "betterproto_lib_google_protobuf.Empty" = (
        betterproto.message_field(2, group="credential_specifier")
    )
    google_refresh_token: str = betterproto.string_field(
        3, group="credential_specifier"
    )
    service_account_jwt_access: "GrpcServiceGoogleGrpcCallCredentialsServiceAccountJwtAccessCredentials" = betterproto.message_field(
        4, group="credential_specifier"
    )
    google_iam: "GrpcServiceGoogleGrpcCallCredentialsGoogleIamCredentials" = (
        betterproto.message_field(5, group="credential_specifier")
    )
    from_plugin: "GrpcServiceGoogleGrpcCallCredentialsMetadataCredentialsFromPlugin" = (
        betterproto.message_field(6, group="credential_specifier")
    )
    sts_service: "GrpcServiceGoogleGrpcCallCredentialsStsService" = (
        betterproto.message_field(7, group="credential_specifier")
    )

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class GrpcServiceGoogleGrpcCallCredentialsServiceAccountJwtAccessCredentials(
    betterproto.Message
):
    json_key: str = betterproto.string_field(1)
    token_lifetime_seconds: int = betterproto.uint64_field(2)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class GrpcServiceGoogleGrpcCallCredentialsGoogleIamCredentials(betterproto.Message):
    authorization_token: str = betterproto.string_field(1)
    authority_selector: str = betterproto.string_field(2)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class GrpcServiceGoogleGrpcCallCredentialsMetadataCredentialsFromPlugin(
    betterproto.Message
):
    name: str = betterproto.string_field(1)
    config: "betterproto_lib_google_protobuf.Struct" = betterproto.message_field(
        2, group="config_type"
    )
    typed_config: "betterproto_lib_google_protobuf.Any" = betterproto.message_field(
        3, group="config_type"
    )

    def __post_init__(self) -> None:
        super().__post_init__()
        if self.config:
            warnings.warn(
                "GrpcServiceGoogleGrpcCallCredentialsMetadataCredentialsFromPlugin.config is deprecated",
                DeprecationWarning,
            )


@dataclass(eq=False, repr=False)
class GrpcServiceGoogleGrpcCallCredentialsStsService(betterproto.Message):
    token_exchange_service_uri: str = betterproto.string_field(1)
    resource: str = betterproto.string_field(2)
    audience: str = betterproto.string_field(3)
    scope: str = betterproto.string_field(4)
    requested_token_type: str = betterproto.string_field(5)
    subject_token_path: str = betterproto.string_field(6)
    subject_token_type: str = betterproto.string_field(7)
    actor_token_path: str = betterproto.string_field(8)
    actor_token_type: str = betterproto.string_field(9)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class ApiConfigSource(betterproto.Message):
    """
    Generic socket option message. This would be used to set socket options
    that might not exist in upstream kernels or precompiled Envoy binaries.
    [#next-free-field: 7]
    """

    # An optional name to give this socket option for debugging, etc. Uniqueness
    # is not required and no special meaning is assumed.
    api_type: "ApiConfigSourceApiType" = betterproto.enum_field(1)
    # Corresponding to the level value passed to setsockopt, such as IPPROTO_TCP
    transport_api_version: "ApiVersion" = betterproto.enum_field(8)
    # The numeric name as passed to setsockopt
    cluster_names: List[str] = betterproto.string_field(2)
    # Because many sockopts take an int value.
    grpc_services: List["GrpcService"] = betterproto.message_field(4)
    # Otherwise it's a byte buffer.
    refresh_delay: timedelta = betterproto.message_field(3)
    # The state in which the option will be applied. When used in BindConfig
    # STATE_PREBIND is currently the only valid value.
    request_timeout: timedelta = betterproto.message_field(5)
    rate_limit_settings: "RateLimitSettings" = betterproto.message_field(6)
    set_node_on_first_message_only: bool = betterproto.bool_field(7)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class AggregatedConfigSource(betterproto.Message):
    pass

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class SelfConfigSource(betterproto.Message):
    transport_api_version: "ApiVersion" = betterproto.enum_field(1)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class RateLimitSettings(betterproto.Message):
    max_tokens: Optional[int] = betterproto.message_field(
        1, wraps=betterproto.TYPE_UINT32
    )
    fill_rate: Optional[float] = betterproto.message_field(
        2, wraps=betterproto.TYPE_DOUBLE
    )

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class ConfigSource(betterproto.Message):
    path: str = betterproto.string_field(1, group="config_source_specifier")
    api_config_source: "ApiConfigSource" = betterproto.message_field(
        2, group="config_source_specifier"
    )
    ads: "AggregatedConfigSource" = betterproto.message_field(
        3, group="config_source_specifier"
    )
    self: "SelfConfigSource" = betterproto.message_field(
        5, group="config_source_specifier"
    )
    initial_fetch_timeout: timedelta = betterproto.message_field(4)
    resource_api_version: "ApiVersion" = betterproto.enum_field(6)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class EventServiceConfig(betterproto.Message):
    """
    Generic socket option message. This would be used to set socket options
    that might not exist in upstream kernels or precompiled Envoy binaries.
    [#next-free-field: 7]
    """

    # An optional name to give this socket option for debugging, etc. Uniqueness
    # is not required and no special meaning is assumed.
    grpc_service: "GrpcService" = betterproto.message_field(
        1, group="config_source_specifier"
    )

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class HealthCheck(betterproto.Message):
    """
    Generic socket option message. This would be used to set socket options
    that might not exist in upstream kernels or precompiled Envoy binaries.
    [#next-free-field: 7]
    """

    # An optional name to give this socket option for debugging, etc. Uniqueness
    # is not required and no special meaning is assumed.
    timeout: timedelta = betterproto.message_field(1)
    # Corresponding to the level value passed to setsockopt, such as IPPROTO_TCP
    interval: timedelta = betterproto.message_field(2)
    # The numeric name as passed to setsockopt
    initial_jitter: timedelta = betterproto.message_field(20)
    # Because many sockopts take an int value.
    interval_jitter: timedelta = betterproto.message_field(3)
    # Otherwise it's a byte buffer.
    interval_jitter_percent: int = betterproto.uint32_field(18)
    # The state in which the option will be applied. When used in BindConfig
    # STATE_PREBIND is currently the only valid value.
    unhealthy_threshold: Optional[int] = betterproto.message_field(
        4, wraps=betterproto.TYPE_UINT32
    )
    healthy_threshold: Optional[int] = betterproto.message_field(
        5, wraps=betterproto.TYPE_UINT32
    )
    alt_port: Optional[int] = betterproto.message_field(
        6, wraps=betterproto.TYPE_UINT32
    )
    reuse_connection: Optional[bool] = betterproto.message_field(
        7, wraps=betterproto.TYPE_BOOL
    )
    http_health_check: "HealthCheckHttpHealthCheck" = betterproto.message_field(
        8, group="health_checker"
    )
    tcp_health_check: "HealthCheckTcpHealthCheck" = betterproto.message_field(
        9, group="health_checker"
    )
    grpc_health_check: "HealthCheckGrpcHealthCheck" = betterproto.message_field(
        11, group="health_checker"
    )
    custom_health_check: "HealthCheckCustomHealthCheck" = betterproto.message_field(
        13, group="health_checker"
    )
    no_traffic_interval: timedelta = betterproto.message_field(12)
    unhealthy_interval: timedelta = betterproto.message_field(14)
    unhealthy_edge_interval: timedelta = betterproto.message_field(15)
    healthy_edge_interval: timedelta = betterproto.message_field(16)
    event_log_path: str = betterproto.string_field(17)
    event_service: "EventServiceConfig" = betterproto.message_field(22)
    always_log_health_check_failures: bool = betterproto.bool_field(19)
    tls_options: "HealthCheckTlsOptions" = betterproto.message_field(21)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class HealthCheckPayload(betterproto.Message):
    text: str = betterproto.string_field(1, group="payload")
    binary: bytes = betterproto.bytes_field(2, group="payload")

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class HealthCheckHttpHealthCheck(betterproto.Message):
    host: str = betterproto.string_field(1)
    path: str = betterproto.string_field(2)
    send: "HealthCheckPayload" = betterproto.message_field(3)
    receive: "HealthCheckPayload" = betterproto.message_field(4)
    service_name: str = betterproto.string_field(5)
    request_headers_to_add: List["HeaderValueOption"] = betterproto.message_field(6)
    request_headers_to_remove: List[str] = betterproto.string_field(8)
    use_http2: bool = betterproto.bool_field(7)
    expected_statuses: List["___type__.Int64Range"] = betterproto.message_field(9)
    codec_client_type: "___type__.CodecClientType" = betterproto.enum_field(10)
    service_name_matcher: "___type_matcher__.StringMatcher" = betterproto.message_field(
        11
    )

    def __post_init__(self) -> None:
        super().__post_init__()
        if self.service_name:
            warnings.warn(
                "HealthCheckHttpHealthCheck.service_name is deprecated",
                DeprecationWarning,
            )
        if self.use_http2:
            warnings.warn(
                "HealthCheckHttpHealthCheck.use_http2 is deprecated", DeprecationWarning
            )


@dataclass(eq=False, repr=False)
class HealthCheckTcpHealthCheck(betterproto.Message):
    send: "HealthCheckPayload" = betterproto.message_field(1)
    receive: List["HealthCheckPayload"] = betterproto.message_field(2)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class HealthCheckRedisHealthCheck(betterproto.Message):
    key: str = betterproto.string_field(1)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class HealthCheckGrpcHealthCheck(betterproto.Message):
    service_name: str = betterproto.string_field(1)
    authority: str = betterproto.string_field(2)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class HealthCheckCustomHealthCheck(betterproto.Message):
    name: str = betterproto.string_field(1)
    config: "betterproto_lib_google_protobuf.Struct" = betterproto.message_field(
        2, group="config_type"
    )
    typed_config: "betterproto_lib_google_protobuf.Any" = betterproto.message_field(
        3, group="config_type"
    )

    def __post_init__(self) -> None:
        super().__post_init__()
        if self.config:
            warnings.warn(
                "HealthCheckCustomHealthCheck.config is deprecated", DeprecationWarning
            )


@dataclass(eq=False, repr=False)
class HealthCheckTlsOptions(betterproto.Message):
    alpn_protocols: List[str] = betterproto.string_field(1)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class TcpProtocolOptions(betterproto.Message):
    """
    Generic socket option message. This would be used to set socket options
    that might not exist in upstream kernels or precompiled Envoy binaries.
    [#next-free-field: 7]
    """

    pass

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class UpstreamHttpProtocolOptions(betterproto.Message):
    auto_sni: bool = betterproto.bool_field(1)
    auto_san_validation: bool = betterproto.bool_field(2)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class HttpProtocolOptions(betterproto.Message):
    idle_timeout: timedelta = betterproto.message_field(1)
    max_connection_duration: timedelta = betterproto.message_field(3)
    max_headers_count: Optional[int] = betterproto.message_field(
        2, wraps=betterproto.TYPE_UINT32
    )
    max_stream_duration: timedelta = betterproto.message_field(4)
    headers_with_underscores_action: "HttpProtocolOptionsHeadersWithUnderscoresAction" = betterproto.enum_field(
        5
    )

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class Http1ProtocolOptions(betterproto.Message):
    allow_absolute_url: Optional[bool] = betterproto.message_field(
        1, wraps=betterproto.TYPE_BOOL
    )
    accept_http_10: bool = betterproto.bool_field(2)
    default_host_for_http_10: str = betterproto.string_field(3)
    header_key_format: "Http1ProtocolOptionsHeaderKeyFormat" = (
        betterproto.message_field(4)
    )
    enable_trailers: bool = betterproto.bool_field(5)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class Http1ProtocolOptionsHeaderKeyFormat(betterproto.Message):
    proper_case_words: "Http1ProtocolOptionsHeaderKeyFormatProperCaseWords" = (
        betterproto.message_field(1, group="header_format")
    )

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class Http1ProtocolOptionsHeaderKeyFormatProperCaseWords(betterproto.Message):
    pass

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class Http2ProtocolOptions(betterproto.Message):
    hpack_table_size: Optional[int] = betterproto.message_field(
        1, wraps=betterproto.TYPE_UINT32
    )
    max_concurrent_streams: Optional[int] = betterproto.message_field(
        2, wraps=betterproto.TYPE_UINT32
    )
    initial_stream_window_size: Optional[int] = betterproto.message_field(
        3, wraps=betterproto.TYPE_UINT32
    )
    initial_connection_window_size: Optional[int] = betterproto.message_field(
        4, wraps=betterproto.TYPE_UINT32
    )
    allow_connect: bool = betterproto.bool_field(5)
    allow_metadata: bool = betterproto.bool_field(6)
    max_outbound_frames: Optional[int] = betterproto.message_field(
        7, wraps=betterproto.TYPE_UINT32
    )
    max_outbound_control_frames: Optional[int] = betterproto.message_field(
        8, wraps=betterproto.TYPE_UINT32
    )
    max_consecutive_inbound_frames_with_empty_payload: Optional[
        int
    ] = betterproto.message_field(9, wraps=betterproto.TYPE_UINT32)
    max_inbound_priority_frames_per_stream: Optional[int] = betterproto.message_field(
        10, wraps=betterproto.TYPE_UINT32
    )
    max_inbound_window_update_frames_per_data_frame_sent: Optional[
        int
    ] = betterproto.message_field(11, wraps=betterproto.TYPE_UINT32)
    stream_error_on_invalid_http_messaging: bool = betterproto.bool_field(12)
    custom_settings_parameters: List[
        "Http2ProtocolOptionsSettingsParameter"
    ] = betterproto.message_field(13)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class Http2ProtocolOptionsSettingsParameter(betterproto.Message):
    identifier: Optional[int] = betterproto.message_field(
        1, wraps=betterproto.TYPE_UINT32
    )
    value: Optional[int] = betterproto.message_field(2, wraps=betterproto.TYPE_UINT32)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class GrpcProtocolOptions(betterproto.Message):
    http2_protocol_options: "Http2ProtocolOptions" = betterproto.message_field(1)

    def __post_init__(self) -> None:
        super().__post_init__()


from .... import type as ___type__
from ....type import matcher as ___type_matcher__
import betterproto.lib.google.protobuf as betterproto_lib_google_protobuf
