# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: envoy/api/v2/discovery.proto, envoy/api/v2/endpoint.proto, envoy/api/v2/cluster.proto, envoy/api/v2/cds.proto, envoy/api/v2/listener.proto, envoy/api/v2/lds.proto, envoy/api/v2/route.proto, envoy/api/v2/rds.proto, envoy/api/v2/eds.proto, envoy/api/v2/scoped_route.proto, envoy/api/v2/srds.proto
# plugin: python-betterproto
import warnings
from dataclasses import dataclass
from datetime import timedelta
from typing import AsyncIterable, AsyncIterator, Dict, Iterable, List, Optional, Union

import betterproto
from betterproto.grpc.grpclib_server import ServiceBase
import grpclib


class ClusterDiscoveryType(betterproto.Enum):
    STATIC = 0
    STRICT_DNS = 1
    LOGICAL_DNS = 2
    EDS = 3
    ORIGINAL_DST = 4


class ClusterLbPolicy(betterproto.Enum):
    ROUND_ROBIN = 0
    LEAST_REQUEST = 1
    RING_HASH = 2
    RANDOM = 3
    ORIGINAL_DST_LB = 4
    MAGLEV = 5
    CLUSTER_PROVIDED = 6
    LOAD_BALANCING_POLICY_CONFIG = 7


class ClusterDnsLookupFamily(betterproto.Enum):
    AUTO = 0
    V4_ONLY = 1
    V6_ONLY = 2


class ClusterClusterProtocolSelection(betterproto.Enum):
    USE_CONFIGURED_PROTOCOL = 0
    USE_DOWNSTREAM_PROTOCOL = 1


class ClusterLbSubsetConfigLbSubsetFallbackPolicy(betterproto.Enum):
    NO_FALLBACK = 0
    ANY_ENDPOINT = 1
    DEFAULT_SUBSET = 2


class ClusterLbSubsetConfigLbSubsetSelectorLbSubsetSelectorFallbackPolicy(
    betterproto.Enum
):
    NOT_DEFINED = 0
    NO_FALLBACK = 1
    ANY_ENDPOINT = 2
    DEFAULT_SUBSET = 3
    KEYS_SUBSET = 4


class ClusterRingHashLbConfigHashFunction(betterproto.Enum):
    XX_HASH = 0
    MURMUR_HASH_2 = 1


class ListenerDrainType(betterproto.Enum):
    DEFAULT = 0
    MODIFY_ONLY = 1


@dataclass(eq=False, repr=False)
class DiscoveryRequest(betterproto.Message):
    """
    A DiscoveryRequest requests a set of versioned resources of the same type
    for a given Envoy node on some API. [#next-free-field: 7]
    """

    # The version_info provided in the request messages will be the version_info
    # received with the most recent successfully processed response or empty on
    # the first request. It is expected that no new request is sent after a
    # response is received until the Envoy instance is ready to ACK/NACK the new
    # configuration. ACK/NACK takes place by returning the new API config version
    # as applied or the previous API config version respectively. Each type_url
    # (see below) has an independent version associated with it.
    version_info: str = betterproto.string_field(1)
    # The node making the request.
    node: "core.Node" = betterproto.message_field(2)
    # List of resources to subscribe to, e.g. list of cluster names or a route
    # configuration name. If this is empty, all resources for the API are
    # returned. LDS/CDS may have empty resource_names, which will cause all
    # resources for the Envoy instance to be returned. The LDS and CDS responses
    # will then imply a number of resources that need to be fetched via EDS/RDS,
    # which will be explicitly enumerated in resource_names.
    resource_names: List[str] = betterproto.string_field(3)
    # Type of the resource that is being requested, e.g.
    # "type.googleapis.com/envoy.api.v2.ClusterLoadAssignment". This is implicit
    # in requests made via singleton xDS APIs such as CDS, LDS, etc. but is
    # required for ADS.
    type_url: str = betterproto.string_field(4)
    # nonce corresponding to DiscoveryResponse being ACK/NACKed. See above
    # discussion on version_info and the DiscoveryResponse nonce comment. This
    # may be empty only if 1) this is a non-persistent-stream xDS such as HTTP,
    # or 2) the client has not yet accepted an update in this xDS stream (unlike
    # delta, where it is populated only for new explicit ACKs).
    response_nonce: str = betterproto.string_field(5)
    # This is populated when the previous :ref:`DiscoveryResponse
    # <envoy_api_msg_DiscoveryResponse>` failed to update configuration. The
    # *message* field in *error_details* provides the Envoy internal exception
    # related to the failure. It is only intended for consumption during manual
    # debugging, the string provided is not guaranteed to be stable across Envoy
    # versions.
    error_detail: "___google_rpc__.Status" = betterproto.message_field(6)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class DiscoveryResponse(betterproto.Message):
    """[#next-free-field: 7]"""

    # The version of the response data.
    version_info: str = betterproto.string_field(1)
    # The response resources. These resources are typed and depend on the API
    # being called.
    resources: List["betterproto_lib_google_protobuf.Any"] = betterproto.message_field(
        2
    )
    # [#not-implemented-hide:] Canary is used to support two Envoy command line
    # flags: * --terminate-on-canary-transition-failure. When set, Envoy is able
    # to   terminate if it detects that configuration is stuck at canary.
    # Consider   this example sequence of updates:   - Management server applies
    # a canary config successfully.   - Management server rolls back to a
    # production config.   - Envoy rejects the new production config.   Since
    # there is no sensible way to continue receiving configuration   updates,
    # Envoy will then terminate and apply production config from a   clean slate.
    # * --dry-run-canary. When set, a canary response will never be applied, only
    # validated via a dry run.
    canary: bool = betterproto.bool_field(3)
    # Type URL for resources. Identifies the xDS API when muxing over ADS. Must
    # be consistent with the type_url in the 'resources' repeated Any (if non-
    # empty).
    type_url: str = betterproto.string_field(4)
    # For gRPC based subscriptions, the nonce provides a way to explicitly ack a
    # specific DiscoveryResponse in a following DiscoveryRequest. Additional
    # messages may have been sent by Envoy to the management server for the
    # previous version on the stream prior to this DiscoveryResponse, that were
    # unprocessed at response send time. The nonce allows the management server
    # to ignore any further DiscoveryRequests for the previous version until a
    # DiscoveryRequest bearing the nonce. The nonce is optional and is not
    # required for non-stream based xDS implementations.
    nonce: str = betterproto.string_field(5)
    # [#not-implemented-hide:] The control plane instance that sent the response.
    control_plane: "core.ControlPlane" = betterproto.message_field(6)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class DeltaDiscoveryRequest(betterproto.Message):
    """
    DeltaDiscoveryRequest and DeltaDiscoveryResponse are used in a new gRPC
    endpoint for Delta xDS. With Delta xDS, the DeltaDiscoveryResponses do not
    need to include a full snapshot of the tracked resources. Instead,
    DeltaDiscoveryResponses are a diff to the state of a xDS client. In Delta
    XDS there are per-resource versions, which allow tracking state at the
    resource granularity. An xDS Delta session is always in the context of a
    gRPC bidirectional stream. This allows the xDS server to keep track of the
    state of xDS clients connected to it. In Delta xDS the nonce field is
    required and used to pair DeltaDiscoveryResponse to a DeltaDiscoveryRequest
    ACK or NACK. Optionally, a response message level system_version_info is
    present for debugging purposes only. DeltaDiscoveryRequest plays two
    independent roles. Any DeltaDiscoveryRequest can be either or both of: [1]
    informing the server of what resources the client has gained/lost interest
    in (using resource_names_subscribe and resource_names_unsubscribe), or [2]
    (N)ACKing an earlier resource update from the server (using response_nonce,
    with presence of error_detail making it a NACK). Additionally, the first
    message (for a given type_url) of a reconnected gRPC stream has a third
    role: informing the server of the resources (and their versions) that the
    client already possesses, using the initial_resource_versions field. As
    with state-of-the-world, when multiple resource types are multiplexed
    (ADS), all requests/acknowledgments/updates are logically walled off by
    type_url: a Cluster ACK exists in a completely separate world from a prior
    Route NACK. In particular, initial_resource_versions being sent at the
    "start" of every gRPC stream actually entails a message for each type_url,
    each with its own initial_resource_versions. [#next-free-field: 8]
    """

    # The node making the request.
    node: "core.Node" = betterproto.message_field(1)
    # Type of the resource that is being requested, e.g.
    # "type.googleapis.com/envoy.api.v2.ClusterLoadAssignment".
    type_url: str = betterproto.string_field(2)
    # DeltaDiscoveryRequests allow the client to add or remove individual
    # resources to the set of tracked resources in the context of a stream. All
    # resource names in the resource_names_subscribe list are added to the set of
    # tracked resources and all resource names in the resource_names_unsubscribe
    # list are removed from the set of tracked resources. *Unlike* state-of-the-
    # world xDS, an empty resource_names_subscribe or resource_names_unsubscribe
    # list simply means that no resources are to be added or removed to the
    # resource list. *Like* state-of-the-world xDS, the server must send updates
    # for all tracked resources, but can also send updates for resources the
    # client has not subscribed to. NOTE: the server must respond with all
    # resources listed in resource_names_subscribe, even if it believes the
    # client has the most recent version of them. The reason: the client may have
    # dropped them, but then regained interest before it had a chance to send the
    # unsubscribe message. See DeltaSubscriptionStateTest.RemoveThenAdd. These
    # two fields can be set in any DeltaDiscoveryRequest, including ACKs and
    # initial_resource_versions. A list of Resource names to add to the list of
    # tracked resources.
    resource_names_subscribe: List[str] = betterproto.string_field(3)
    # A list of Resource names to remove from the list of tracked resources.
    resource_names_unsubscribe: List[str] = betterproto.string_field(4)
    # Informs the server of the versions of the resources the xDS client knows
    # of, to enable the client to continue the same logical xDS session even in
    # the face of gRPC stream reconnection. It will not be populated: [1] in the
    # very first stream of a session, since the client will not yet have any
    # resources,  [2] in any message after the first in a stream (for a given
    # type_url), since the server will already be correctly tracking the client's
    # state. (In ADS, the first message *of each type_url* of a reconnected
    # stream populates this map.) The map's keys are names of xDS resources known
    # to the xDS client. The map's values are opaque resource versions.
    initial_resource_versions: Dict[str, str] = betterproto.map_field(
        5, betterproto.TYPE_STRING, betterproto.TYPE_STRING
    )
    # When the DeltaDiscoveryRequest is a ACK or NACK message in response to a
    # previous DeltaDiscoveryResponse, the response_nonce must be the nonce in
    # the DeltaDiscoveryResponse. Otherwise (unlike in DiscoveryRequest)
    # response_nonce must be omitted.
    response_nonce: str = betterproto.string_field(6)
    # This is populated when the previous :ref:`DiscoveryResponse
    # <envoy_api_msg_DiscoveryResponse>` failed to update configuration. The
    # *message* field in *error_details* provides the Envoy internal exception
    # related to the failure.
    error_detail: "___google_rpc__.Status" = betterproto.message_field(7)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class DeltaDiscoveryResponse(betterproto.Message):
    """[#next-free-field: 7]"""

    # The version of the response data (used for debugging).
    system_version_info: str = betterproto.string_field(1)
    # The response resources. These are typed resources, whose types must match
    # the type_url field.
    resources: List["Resource"] = betterproto.message_field(2)
    # Type URL for resources. Identifies the xDS API when muxing over ADS. Must
    # be consistent with the type_url in the Any within 'resources' if
    # 'resources' is non-empty.
    type_url: str = betterproto.string_field(4)
    # Resources names of resources that have be deleted and to be removed from
    # the xDS Client. Removed resources for missing resources can be ignored.
    removed_resources: List[str] = betterproto.string_field(6)
    # The nonce provides a way for DeltaDiscoveryRequests to uniquely reference a
    # DeltaDiscoveryResponse when (N)ACKing. The nonce is required.
    nonce: str = betterproto.string_field(5)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class Resource(betterproto.Message):
    # The resource's name, to distinguish it from others of the same type of
    # resource.
    name: str = betterproto.string_field(3)
    # The aliases are a list of other names that this resource can go by.
    aliases: List[str] = betterproto.string_field(4)
    # The resource level version. It allows xDS to track the state of individual
    # resources.
    version: str = betterproto.string_field(1)
    # The resource being tracked.
    resource: "betterproto_lib_google_protobuf.Any" = betterproto.message_field(2)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class ClusterLoadAssignment(betterproto.Message):
    """
    A DiscoveryRequest requests a set of versioned resources of the same type
    for a given Envoy node on some API. [#next-free-field: 7]
    """

    # The version_info provided in the request messages will be the version_info
    # received with the most recent successfully processed response or empty on
    # the first request. It is expected that no new request is sent after a
    # response is received until the Envoy instance is ready to ACK/NACK the new
    # configuration. ACK/NACK takes place by returning the new API config version
    # as applied or the previous API config version respectively. Each type_url
    # (see below) has an independent version associated with it.
    cluster_name: str = betterproto.string_field(1)
    # The node making the request.
    endpoints: List["endpoint.LocalityLbEndpoints"] = betterproto.message_field(2)
    # List of resources to subscribe to, e.g. list of cluster names or a route
    # configuration name. If this is empty, all resources for the API are
    # returned. LDS/CDS may have empty resource_names, which will cause all
    # resources for the Envoy instance to be returned. The LDS and CDS responses
    # will then imply a number of resources that need to be fetched via EDS/RDS,
    # which will be explicitly enumerated in resource_names.
    named_endpoints: Dict[str, "endpoint.Endpoint"] = betterproto.map_field(
        5, betterproto.TYPE_STRING, betterproto.TYPE_MESSAGE
    )
    # Type of the resource that is being requested, e.g.
    # "type.googleapis.com/envoy.api.v2.ClusterLoadAssignment". This is implicit
    # in requests made via singleton xDS APIs such as CDS, LDS, etc. but is
    # required for ADS.
    policy: "ClusterLoadAssignmentPolicy" = betterproto.message_field(4)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class ClusterLoadAssignmentPolicy(betterproto.Message):
    drop_overloads: List[
        "ClusterLoadAssignmentPolicyDropOverload"
    ] = betterproto.message_field(2)
    overprovisioning_factor: Optional[int] = betterproto.message_field(
        3, wraps=betterproto.TYPE_UINT32
    )
    endpoint_stale_after: timedelta = betterproto.message_field(4)
    disable_overprovisioning: bool = betterproto.bool_field(5)

    def __post_init__(self) -> None:
        super().__post_init__()
        if self.disable_overprovisioning:
            warnings.warn(
                "ClusterLoadAssignmentPolicy.disable_overprovisioning is deprecated",
                DeprecationWarning,
            )


@dataclass(eq=False, repr=False)
class ClusterLoadAssignmentPolicyDropOverload(betterproto.Message):
    category: str = betterproto.string_field(1)
    drop_percentage: "__type__.FractionalPercent" = betterproto.message_field(2)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class Cluster(betterproto.Message):
    """
    A DiscoveryRequest requests a set of versioned resources of the same type
    for a given Envoy node on some API. [#next-free-field: 7]
    """

    # The version_info provided in the request messages will be the version_info
    # received with the most recent successfully processed response or empty on
    # the first request. It is expected that no new request is sent after a
    # response is received until the Envoy instance is ready to ACK/NACK the new
    # configuration. ACK/NACK takes place by returning the new API config version
    # as applied or the previous API config version respectively. Each type_url
    # (see below) has an independent version associated with it.
    transport_socket_matches: List[
        "ClusterTransportSocketMatch"
    ] = betterproto.message_field(43)
    # The node making the request.
    name: str = betterproto.string_field(1)
    # List of resources to subscribe to, e.g. list of cluster names or a route
    # configuration name. If this is empty, all resources for the API are
    # returned. LDS/CDS may have empty resource_names, which will cause all
    # resources for the Envoy instance to be returned. The LDS and CDS responses
    # will then imply a number of resources that need to be fetched via EDS/RDS,
    # which will be explicitly enumerated in resource_names.
    alt_stat_name: str = betterproto.string_field(28)
    # Type of the resource that is being requested, e.g.
    # "type.googleapis.com/envoy.api.v2.ClusterLoadAssignment". This is implicit
    # in requests made via singleton xDS APIs such as CDS, LDS, etc. but is
    # required for ADS.
    type: "ClusterDiscoveryType" = betterproto.enum_field(
        2, group="cluster_discovery_type"
    )
    # nonce corresponding to DiscoveryResponse being ACK/NACKed. See above
    # discussion on version_info and the DiscoveryResponse nonce comment. This
    # may be empty only if 1) this is a non-persistent-stream xDS such as HTTP,
    # or 2) the client has not yet accepted an update in this xDS stream (unlike
    # delta, where it is populated only for new explicit ACKs).
    cluster_type: "ClusterCustomClusterType" = betterproto.message_field(
        38, group="cluster_discovery_type"
    )
    # This is populated when the previous :ref:`DiscoveryResponse
    # <envoy_api_msg_DiscoveryResponse>` failed to update configuration. The
    # *message* field in *error_details* provides the Envoy internal exception
    # related to the failure. It is only intended for consumption during manual
    # debugging, the string provided is not guaranteed to be stable across Envoy
    # versions.
    eds_cluster_config: "ClusterEdsClusterConfig" = betterproto.message_field(3)
    connect_timeout: timedelta = betterproto.message_field(4)
    per_connection_buffer_limit_bytes: Optional[int] = betterproto.message_field(
        5, wraps=betterproto.TYPE_UINT32
    )
    lb_policy: "ClusterLbPolicy" = betterproto.enum_field(6)
    hosts: List["core.Address"] = betterproto.message_field(7)
    load_assignment: "ClusterLoadAssignment" = betterproto.message_field(33)
    health_checks: List["core.HealthCheck"] = betterproto.message_field(8)
    max_requests_per_connection: Optional[int] = betterproto.message_field(
        9, wraps=betterproto.TYPE_UINT32
    )
    circuit_breakers: "cluster.CircuitBreakers" = betterproto.message_field(10)
    tls_context: "auth.UpstreamTlsContext" = betterproto.message_field(11)
    upstream_http_protocol_options: "core.UpstreamHttpProtocolOptions" = (
        betterproto.message_field(46)
    )
    common_http_protocol_options: "core.HttpProtocolOptions" = (
        betterproto.message_field(29)
    )
    http_protocol_options: "core.Http1ProtocolOptions" = betterproto.message_field(13)
    http2_protocol_options: "core.Http2ProtocolOptions" = betterproto.message_field(14)
    extension_protocol_options: Dict[
        str, "betterproto_lib_google_protobuf.Struct"
    ] = betterproto.map_field(35, betterproto.TYPE_STRING, betterproto.TYPE_MESSAGE)
    typed_extension_protocol_options: Dict[
        str, "betterproto_lib_google_protobuf.Any"
    ] = betterproto.map_field(36, betterproto.TYPE_STRING, betterproto.TYPE_MESSAGE)
    dns_refresh_rate: timedelta = betterproto.message_field(16)
    dns_failure_refresh_rate: "ClusterRefreshRate" = betterproto.message_field(44)
    respect_dns_ttl: bool = betterproto.bool_field(39)
    dns_lookup_family: "ClusterDnsLookupFamily" = betterproto.enum_field(17)
    dns_resolvers: List["core.Address"] = betterproto.message_field(18)
    use_tcp_for_dns_lookups: bool = betterproto.bool_field(45)
    outlier_detection: "cluster.OutlierDetection" = betterproto.message_field(19)
    cleanup_interval: timedelta = betterproto.message_field(20)
    upstream_bind_config: "core.BindConfig" = betterproto.message_field(21)
    lb_subset_config: "ClusterLbSubsetConfig" = betterproto.message_field(22)
    ring_hash_lb_config: "ClusterRingHashLbConfig" = betterproto.message_field(
        23, group="lb_config"
    )
    original_dst_lb_config: "ClusterOriginalDstLbConfig" = betterproto.message_field(
        34, group="lb_config"
    )
    least_request_lb_config: "ClusterLeastRequestLbConfig" = betterproto.message_field(
        37, group="lb_config"
    )
    common_lb_config: "ClusterCommonLbConfig" = betterproto.message_field(27)
    transport_socket: "core.TransportSocket" = betterproto.message_field(24)
    metadata: "core.Metadata" = betterproto.message_field(25)
    protocol_selection: "ClusterClusterProtocolSelection" = betterproto.enum_field(26)
    upstream_connection_options: "UpstreamConnectionOptions" = (
        betterproto.message_field(30)
    )
    close_connections_on_host_health_failure: bool = betterproto.bool_field(31)
    drain_connections_on_host_removal: bool = betterproto.bool_field(32)
    filters: List["cluster.Filter"] = betterproto.message_field(40)
    load_balancing_policy: "LoadBalancingPolicy" = betterproto.message_field(41)
    lrs_server: "core.ConfigSource" = betterproto.message_field(42)
    track_timeout_budgets: bool = betterproto.bool_field(47)

    def __post_init__(self) -> None:
        super().__post_init__()
        if self.hosts:
            warnings.warn("Cluster.hosts is deprecated", DeprecationWarning)
        if self.tls_context:
            warnings.warn("Cluster.tls_context is deprecated", DeprecationWarning)
        if self.extension_protocol_options:
            warnings.warn(
                "Cluster.extension_protocol_options is deprecated", DeprecationWarning
            )


@dataclass(eq=False, repr=False)
class ClusterTransportSocketMatch(betterproto.Message):
    name: str = betterproto.string_field(1)
    match: "betterproto_lib_google_protobuf.Struct" = betterproto.message_field(2)
    transport_socket: "core.TransportSocket" = betterproto.message_field(3)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class ClusterCustomClusterType(betterproto.Message):
    name: str = betterproto.string_field(1)
    typed_config: "betterproto_lib_google_protobuf.Any" = betterproto.message_field(2)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class ClusterEdsClusterConfig(betterproto.Message):
    eds_config: "core.ConfigSource" = betterproto.message_field(1)
    service_name: str = betterproto.string_field(2)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class ClusterLbSubsetConfig(betterproto.Message):
    fallback_policy: "ClusterLbSubsetConfigLbSubsetFallbackPolicy" = (
        betterproto.enum_field(1)
    )
    default_subset: "betterproto_lib_google_protobuf.Struct" = (
        betterproto.message_field(2)
    )
    subset_selectors: List[
        "ClusterLbSubsetConfigLbSubsetSelector"
    ] = betterproto.message_field(3)
    locality_weight_aware: bool = betterproto.bool_field(4)
    scale_locality_weight: bool = betterproto.bool_field(5)
    panic_mode_any: bool = betterproto.bool_field(6)
    list_as_any: bool = betterproto.bool_field(7)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class ClusterLbSubsetConfigLbSubsetSelector(betterproto.Message):
    keys: List[str] = betterproto.string_field(1)
    fallback_policy: "ClusterLbSubsetConfigLbSubsetSelectorLbSubsetSelectorFallbackPolicy" = betterproto.enum_field(
        2
    )
    fallback_keys_subset: List[str] = betterproto.string_field(3)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class ClusterLeastRequestLbConfig(betterproto.Message):
    choice_count: Optional[int] = betterproto.message_field(
        1, wraps=betterproto.TYPE_UINT32
    )

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class ClusterRingHashLbConfig(betterproto.Message):
    minimum_ring_size: Optional[int] = betterproto.message_field(
        1, wraps=betterproto.TYPE_UINT64
    )
    hash_function: "ClusterRingHashLbConfigHashFunction" = betterproto.enum_field(3)
    maximum_ring_size: Optional[int] = betterproto.message_field(
        4, wraps=betterproto.TYPE_UINT64
    )

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class ClusterOriginalDstLbConfig(betterproto.Message):
    use_http_header: bool = betterproto.bool_field(1)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class ClusterCommonLbConfig(betterproto.Message):
    healthy_panic_threshold: "__type__.Percent" = betterproto.message_field(1)
    zone_aware_lb_config: "ClusterCommonLbConfigZoneAwareLbConfig" = (
        betterproto.message_field(2, group="locality_config_specifier")
    )
    locality_weighted_lb_config: "ClusterCommonLbConfigLocalityWeightedLbConfig" = (
        betterproto.message_field(3, group="locality_config_specifier")
    )
    update_merge_window: timedelta = betterproto.message_field(4)
    ignore_new_hosts_until_first_hc: bool = betterproto.bool_field(5)
    close_connections_on_host_set_change: bool = betterproto.bool_field(6)
    consistent_hashing_lb_config: "ClusterCommonLbConfigConsistentHashingLbConfig" = (
        betterproto.message_field(7)
    )

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class ClusterCommonLbConfigZoneAwareLbConfig(betterproto.Message):
    routing_enabled: "__type__.Percent" = betterproto.message_field(1)
    min_cluster_size: Optional[int] = betterproto.message_field(
        2, wraps=betterproto.TYPE_UINT64
    )
    fail_traffic_on_panic: bool = betterproto.bool_field(3)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class ClusterCommonLbConfigLocalityWeightedLbConfig(betterproto.Message):
    pass

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class ClusterCommonLbConfigConsistentHashingLbConfig(betterproto.Message):
    use_hostname_for_hashing: bool = betterproto.bool_field(1)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class ClusterRefreshRate(betterproto.Message):
    base_interval: timedelta = betterproto.message_field(1)
    max_interval: timedelta = betterproto.message_field(2)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class LoadBalancingPolicy(betterproto.Message):
    """[#next-free-field: 7]"""

    # The version of the response data.
    policies: List["LoadBalancingPolicyPolicy"] = betterproto.message_field(1)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class LoadBalancingPolicyPolicy(betterproto.Message):
    name: str = betterproto.string_field(1)
    config: "betterproto_lib_google_protobuf.Struct" = betterproto.message_field(2)
    typed_config: "betterproto_lib_google_protobuf.Any" = betterproto.message_field(3)

    def __post_init__(self) -> None:
        super().__post_init__()
        if self.config:
            warnings.warn(
                "LoadBalancingPolicyPolicy.config is deprecated", DeprecationWarning
            )


@dataclass(eq=False, repr=False)
class UpstreamBindConfig(betterproto.Message):
    """
    DeltaDiscoveryRequest and DeltaDiscoveryResponse are used in a new gRPC
    endpoint for Delta xDS. With Delta xDS, the DeltaDiscoveryResponses do not
    need to include a full snapshot of the tracked resources. Instead,
    DeltaDiscoveryResponses are a diff to the state of a xDS client. In Delta
    XDS there are per-resource versions, which allow tracking state at the
    resource granularity. An xDS Delta session is always in the context of a
    gRPC bidirectional stream. This allows the xDS server to keep track of the
    state of xDS clients connected to it. In Delta xDS the nonce field is
    required and used to pair DeltaDiscoveryResponse to a DeltaDiscoveryRequest
    ACK or NACK. Optionally, a response message level system_version_info is
    present for debugging purposes only. DeltaDiscoveryRequest plays two
    independent roles. Any DeltaDiscoveryRequest can be either or both of: [1]
    informing the server of what resources the client has gained/lost interest
    in (using resource_names_subscribe and resource_names_unsubscribe), or [2]
    (N)ACKing an earlier resource update from the server (using response_nonce,
    with presence of error_detail making it a NACK). Additionally, the first
    message (for a given type_url) of a reconnected gRPC stream has a third
    role: informing the server of the resources (and their versions) that the
    client already possesses, using the initial_resource_versions field. As
    with state-of-the-world, when multiple resource types are multiplexed
    (ADS), all requests/acknowledgments/updates are logically walled off by
    type_url: a Cluster ACK exists in a completely separate world from a prior
    Route NACK. In particular, initial_resource_versions being sent at the
    "start" of every gRPC stream actually entails a message for each type_url,
    each with its own initial_resource_versions. [#next-free-field: 8]
    """

    # The node making the request.
    source_address: "core.Address" = betterproto.message_field(1)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class UpstreamConnectionOptions(betterproto.Message):
    """[#next-free-field: 7]"""

    # The version of the response data (used for debugging).
    tcp_keepalive: "core.TcpKeepalive" = betterproto.message_field(1)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class CdsDummy(betterproto.Message):
    """
    A DiscoveryRequest requests a set of versioned resources of the same type
    for a given Envoy node on some API. [#next-free-field: 7]
    """

    pass

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class Listener(betterproto.Message):
    """
    A DiscoveryRequest requests a set of versioned resources of the same type
    for a given Envoy node on some API. [#next-free-field: 7]
    """

    # The version_info provided in the request messages will be the version_info
    # received with the most recent successfully processed response or empty on
    # the first request. It is expected that no new request is sent after a
    # response is received until the Envoy instance is ready to ACK/NACK the new
    # configuration. ACK/NACK takes place by returning the new API config version
    # as applied or the previous API config version respectively. Each type_url
    # (see below) has an independent version associated with it.
    name: str = betterproto.string_field(1)
    # The node making the request.
    address: "core.Address" = betterproto.message_field(2)
    # List of resources to subscribe to, e.g. list of cluster names or a route
    # configuration name. If this is empty, all resources for the API are
    # returned. LDS/CDS may have empty resource_names, which will cause all
    # resources for the Envoy instance to be returned. The LDS and CDS responses
    # will then imply a number of resources that need to be fetched via EDS/RDS,
    # which will be explicitly enumerated in resource_names.
    filter_chains: List["listener.FilterChain"] = betterproto.message_field(3)
    # Type of the resource that is being requested, e.g.
    # "type.googleapis.com/envoy.api.v2.ClusterLoadAssignment". This is implicit
    # in requests made via singleton xDS APIs such as CDS, LDS, etc. but is
    # required for ADS.
    use_original_dst: Optional[bool] = betterproto.message_field(
        4, wraps=betterproto.TYPE_BOOL
    )
    # nonce corresponding to DiscoveryResponse being ACK/NACKed. See above
    # discussion on version_info and the DiscoveryResponse nonce comment. This
    # may be empty only if 1) this is a non-persistent-stream xDS such as HTTP,
    # or 2) the client has not yet accepted an update in this xDS stream (unlike
    # delta, where it is populated only for new explicit ACKs).
    per_connection_buffer_limit_bytes: Optional[int] = betterproto.message_field(
        5, wraps=betterproto.TYPE_UINT32
    )
    # This is populated when the previous :ref:`DiscoveryResponse
    # <envoy_api_msg_DiscoveryResponse>` failed to update configuration. The
    # *message* field in *error_details* provides the Envoy internal exception
    # related to the failure. It is only intended for consumption during manual
    # debugging, the string provided is not guaranteed to be stable across Envoy
    # versions.
    metadata: "core.Metadata" = betterproto.message_field(6)
    deprecated_v1: "ListenerDeprecatedV1" = betterproto.message_field(7)
    drain_type: "ListenerDrainType" = betterproto.enum_field(8)
    listener_filters: List["listener.ListenerFilter"] = betterproto.message_field(9)
    listener_filters_timeout: timedelta = betterproto.message_field(15)
    continue_on_listener_filters_timeout: bool = betterproto.bool_field(17)
    transparent: Optional[bool] = betterproto.message_field(
        10, wraps=betterproto.TYPE_BOOL
    )
    freebind: Optional[bool] = betterproto.message_field(
        11, wraps=betterproto.TYPE_BOOL
    )
    socket_options: List["core.SocketOption"] = betterproto.message_field(13)
    tcp_fast_open_queue_length: Optional[int] = betterproto.message_field(
        12, wraps=betterproto.TYPE_UINT32
    )
    traffic_direction: "core.TrafficDirection" = betterproto.enum_field(16)
    udp_listener_config: "listener.UdpListenerConfig" = betterproto.message_field(18)
    api_listener: "__config_listener_v2__.ApiListener" = betterproto.message_field(19)
    connection_balance_config: "ListenerConnectionBalanceConfig" = (
        betterproto.message_field(20)
    )
    reuse_port: bool = betterproto.bool_field(21)
    access_log: List[
        "__config_filter_accesslog_v2__.AccessLog"
    ] = betterproto.message_field(22)

    def __post_init__(self) -> None:
        super().__post_init__()
        if self.use_original_dst:
            warnings.warn("Listener.use_original_dst is deprecated", DeprecationWarning)


@dataclass(eq=False, repr=False)
class ListenerDeprecatedV1(betterproto.Message):
    bind_to_port: Optional[bool] = betterproto.message_field(
        1, wraps=betterproto.TYPE_BOOL
    )

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class ListenerConnectionBalanceConfig(betterproto.Message):
    exact_balance: "ListenerConnectionBalanceConfigExactBalance" = (
        betterproto.message_field(1, group="balance_type")
    )

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class ListenerConnectionBalanceConfigExactBalance(betterproto.Message):
    pass

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class LdsDummy(betterproto.Message):
    """
    A DiscoveryRequest requests a set of versioned resources of the same type
    for a given Envoy node on some API. [#next-free-field: 7]
    """

    pass

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class RouteConfiguration(betterproto.Message):
    """
    A DiscoveryRequest requests a set of versioned resources of the same type
    for a given Envoy node on some API. [#next-free-field: 7]
    """

    # The version_info provided in the request messages will be the version_info
    # received with the most recent successfully processed response or empty on
    # the first request. It is expected that no new request is sent after a
    # response is received until the Envoy instance is ready to ACK/NACK the new
    # configuration. ACK/NACK takes place by returning the new API config version
    # as applied or the previous API config version respectively. Each type_url
    # (see below) has an independent version associated with it.
    name: str = betterproto.string_field(1)
    # The node making the request.
    virtual_hosts: List["route.VirtualHost"] = betterproto.message_field(2)
    # List of resources to subscribe to, e.g. list of cluster names or a route
    # configuration name. If this is empty, all resources for the API are
    # returned. LDS/CDS may have empty resource_names, which will cause all
    # resources for the Envoy instance to be returned. The LDS and CDS responses
    # will then imply a number of resources that need to be fetched via EDS/RDS,
    # which will be explicitly enumerated in resource_names.
    vhds: "Vhds" = betterproto.message_field(9)
    # Type of the resource that is being requested, e.g.
    # "type.googleapis.com/envoy.api.v2.ClusterLoadAssignment". This is implicit
    # in requests made via singleton xDS APIs such as CDS, LDS, etc. but is
    # required for ADS.
    internal_only_headers: List[str] = betterproto.string_field(3)
    # nonce corresponding to DiscoveryResponse being ACK/NACKed. See above
    # discussion on version_info and the DiscoveryResponse nonce comment. This
    # may be empty only if 1) this is a non-persistent-stream xDS such as HTTP,
    # or 2) the client has not yet accepted an update in this xDS stream (unlike
    # delta, where it is populated only for new explicit ACKs).
    response_headers_to_add: List["core.HeaderValueOption"] = betterproto.message_field(
        4
    )
    # This is populated when the previous :ref:`DiscoveryResponse
    # <envoy_api_msg_DiscoveryResponse>` failed to update configuration. The
    # *message* field in *error_details* provides the Envoy internal exception
    # related to the failure. It is only intended for consumption during manual
    # debugging, the string provided is not guaranteed to be stable across Envoy
    # versions.
    response_headers_to_remove: List[str] = betterproto.string_field(5)
    request_headers_to_add: List["core.HeaderValueOption"] = betterproto.message_field(
        6
    )
    request_headers_to_remove: List[str] = betterproto.string_field(8)
    most_specific_header_mutations_wins: bool = betterproto.bool_field(10)
    validate_clusters: Optional[bool] = betterproto.message_field(
        7, wraps=betterproto.TYPE_BOOL
    )

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class Vhds(betterproto.Message):
    """[#next-free-field: 7]"""

    # The version of the response data.
    config_source: "core.ConfigSource" = betterproto.message_field(1)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class RdsDummy(betterproto.Message):
    """
    A DiscoveryRequest requests a set of versioned resources of the same type
    for a given Envoy node on some API. [#next-free-field: 7]
    """

    pass

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class EdsDummy(betterproto.Message):
    """
    A DiscoveryRequest requests a set of versioned resources of the same type
    for a given Envoy node on some API. [#next-free-field: 7]
    """

    pass

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class ScopedRouteConfiguration(betterproto.Message):
    """
    A DiscoveryRequest requests a set of versioned resources of the same type
    for a given Envoy node on some API. [#next-free-field: 7]
    """

    # The version_info provided in the request messages will be the version_info
    # received with the most recent successfully processed response or empty on
    # the first request. It is expected that no new request is sent after a
    # response is received until the Envoy instance is ready to ACK/NACK the new
    # configuration. ACK/NACK takes place by returning the new API config version
    # as applied or the previous API config version respectively. Each type_url
    # (see below) has an independent version associated with it.
    name: str = betterproto.string_field(1)
    # The node making the request.
    route_configuration_name: str = betterproto.string_field(2)
    # List of resources to subscribe to, e.g. list of cluster names or a route
    # configuration name. If this is empty, all resources for the API are
    # returned. LDS/CDS may have empty resource_names, which will cause all
    # resources for the Envoy instance to be returned. The LDS and CDS responses
    # will then imply a number of resources that need to be fetched via EDS/RDS,
    # which will be explicitly enumerated in resource_names.
    key: "ScopedRouteConfigurationKey" = betterproto.message_field(3)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class ScopedRouteConfigurationKey(betterproto.Message):
    fragments: List["ScopedRouteConfigurationKeyFragment"] = betterproto.message_field(
        1
    )

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class ScopedRouteConfigurationKeyFragment(betterproto.Message):
    string_key: str = betterproto.string_field(1, group="type")

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class SrdsDummy(betterproto.Message):
    """
    A DiscoveryRequest requests a set of versioned resources of the same type
    for a given Envoy node on some API. [#next-free-field: 7]
    """

    pass

    def __post_init__(self) -> None:
        super().__post_init__()


class ClusterDiscoveryServiceStub(betterproto.ServiceStub):
    async def stream_clusters(
        self,
        request_iterator: Union[
            AsyncIterable["DiscoveryRequest"], Iterable["DiscoveryRequest"]
        ],
    ) -> AsyncIterator["DiscoveryResponse"]:

        async for response in self._stream_stream(
            "/envoy.api.v2.ClusterDiscoveryService/StreamClusters",
            request_iterator,
            DiscoveryRequest,
            DiscoveryResponse,
        ):
            yield response

    async def delta_clusters(
        self,
        request_iterator: Union[
            AsyncIterable["DeltaDiscoveryRequest"], Iterable["DeltaDiscoveryRequest"]
        ],
    ) -> AsyncIterator["DeltaDiscoveryResponse"]:

        async for response in self._stream_stream(
            "/envoy.api.v2.ClusterDiscoveryService/DeltaClusters",
            request_iterator,
            DeltaDiscoveryRequest,
            DeltaDiscoveryResponse,
        ):
            yield response

    async def fetch_clusters(
        self,
        *,
        version_info: str = "",
        node: "core.Node" = None,
        resource_names: Optional[List[str]] = None,
        type_url: str = "",
        response_nonce: str = "",
        error_detail: "___google_rpc__.Status" = None,
    ) -> "DiscoveryResponse":
        resource_names = resource_names or []

        request = DiscoveryRequest()
        request.version_info = version_info
        if node is not None:
            request.node = node
        request.resource_names = resource_names
        request.type_url = type_url
        request.response_nonce = response_nonce
        if error_detail is not None:
            request.error_detail = error_detail

        return await self._unary_unary(
            "/envoy.api.v2.ClusterDiscoveryService/FetchClusters",
            request,
            DiscoveryResponse,
        )


class ListenerDiscoveryServiceStub(betterproto.ServiceStub):
    async def delta_listeners(
        self,
        request_iterator: Union[
            AsyncIterable["DeltaDiscoveryRequest"], Iterable["DeltaDiscoveryRequest"]
        ],
    ) -> AsyncIterator["DeltaDiscoveryResponse"]:

        async for response in self._stream_stream(
            "/envoy.api.v2.ListenerDiscoveryService/DeltaListeners",
            request_iterator,
            DeltaDiscoveryRequest,
            DeltaDiscoveryResponse,
        ):
            yield response

    async def stream_listeners(
        self,
        request_iterator: Union[
            AsyncIterable["DiscoveryRequest"], Iterable["DiscoveryRequest"]
        ],
    ) -> AsyncIterator["DiscoveryResponse"]:

        async for response in self._stream_stream(
            "/envoy.api.v2.ListenerDiscoveryService/StreamListeners",
            request_iterator,
            DiscoveryRequest,
            DiscoveryResponse,
        ):
            yield response

    async def fetch_listeners(
        self,
        *,
        version_info: str = "",
        node: "core.Node" = None,
        resource_names: Optional[List[str]] = None,
        type_url: str = "",
        response_nonce: str = "",
        error_detail: "___google_rpc__.Status" = None,
    ) -> "DiscoveryResponse":
        resource_names = resource_names or []

        request = DiscoveryRequest()
        request.version_info = version_info
        if node is not None:
            request.node = node
        request.resource_names = resource_names
        request.type_url = type_url
        request.response_nonce = response_nonce
        if error_detail is not None:
            request.error_detail = error_detail

        return await self._unary_unary(
            "/envoy.api.v2.ListenerDiscoveryService/FetchListeners",
            request,
            DiscoveryResponse,
        )


class RouteDiscoveryServiceStub(betterproto.ServiceStub):
    async def stream_routes(
        self,
        request_iterator: Union[
            AsyncIterable["DiscoveryRequest"], Iterable["DiscoveryRequest"]
        ],
    ) -> AsyncIterator["DiscoveryResponse"]:

        async for response in self._stream_stream(
            "/envoy.api.v2.RouteDiscoveryService/StreamRoutes",
            request_iterator,
            DiscoveryRequest,
            DiscoveryResponse,
        ):
            yield response

    async def delta_routes(
        self,
        request_iterator: Union[
            AsyncIterable["DeltaDiscoveryRequest"], Iterable["DeltaDiscoveryRequest"]
        ],
    ) -> AsyncIterator["DeltaDiscoveryResponse"]:

        async for response in self._stream_stream(
            "/envoy.api.v2.RouteDiscoveryService/DeltaRoutes",
            request_iterator,
            DeltaDiscoveryRequest,
            DeltaDiscoveryResponse,
        ):
            yield response

    async def fetch_routes(
        self,
        *,
        version_info: str = "",
        node: "core.Node" = None,
        resource_names: Optional[List[str]] = None,
        type_url: str = "",
        response_nonce: str = "",
        error_detail: "___google_rpc__.Status" = None,
    ) -> "DiscoveryResponse":
        resource_names = resource_names or []

        request = DiscoveryRequest()
        request.version_info = version_info
        if node is not None:
            request.node = node
        request.resource_names = resource_names
        request.type_url = type_url
        request.response_nonce = response_nonce
        if error_detail is not None:
            request.error_detail = error_detail

        return await self._unary_unary(
            "/envoy.api.v2.RouteDiscoveryService/FetchRoutes",
            request,
            DiscoveryResponse,
        )


class VirtualHostDiscoveryServiceStub(betterproto.ServiceStub):
    async def delta_virtual_hosts(
        self,
        request_iterator: Union[
            AsyncIterable["DeltaDiscoveryRequest"], Iterable["DeltaDiscoveryRequest"]
        ],
    ) -> AsyncIterator["DeltaDiscoveryResponse"]:

        async for response in self._stream_stream(
            "/envoy.api.v2.VirtualHostDiscoveryService/DeltaVirtualHosts",
            request_iterator,
            DeltaDiscoveryRequest,
            DeltaDiscoveryResponse,
        ):
            yield response


class EndpointDiscoveryServiceStub(betterproto.ServiceStub):
    async def stream_endpoints(
        self,
        request_iterator: Union[
            AsyncIterable["DiscoveryRequest"], Iterable["DiscoveryRequest"]
        ],
    ) -> AsyncIterator["DiscoveryResponse"]:

        async for response in self._stream_stream(
            "/envoy.api.v2.EndpointDiscoveryService/StreamEndpoints",
            request_iterator,
            DiscoveryRequest,
            DiscoveryResponse,
        ):
            yield response

    async def delta_endpoints(
        self,
        request_iterator: Union[
            AsyncIterable["DeltaDiscoveryRequest"], Iterable["DeltaDiscoveryRequest"]
        ],
    ) -> AsyncIterator["DeltaDiscoveryResponse"]:

        async for response in self._stream_stream(
            "/envoy.api.v2.EndpointDiscoveryService/DeltaEndpoints",
            request_iterator,
            DeltaDiscoveryRequest,
            DeltaDiscoveryResponse,
        ):
            yield response

    async def fetch_endpoints(
        self,
        *,
        version_info: str = "",
        node: "core.Node" = None,
        resource_names: Optional[List[str]] = None,
        type_url: str = "",
        response_nonce: str = "",
        error_detail: "___google_rpc__.Status" = None,
    ) -> "DiscoveryResponse":
        resource_names = resource_names or []

        request = DiscoveryRequest()
        request.version_info = version_info
        if node is not None:
            request.node = node
        request.resource_names = resource_names
        request.type_url = type_url
        request.response_nonce = response_nonce
        if error_detail is not None:
            request.error_detail = error_detail

        return await self._unary_unary(
            "/envoy.api.v2.EndpointDiscoveryService/FetchEndpoints",
            request,
            DiscoveryResponse,
        )


class ScopedRoutesDiscoveryServiceStub(betterproto.ServiceStub):
    async def stream_scoped_routes(
        self,
        request_iterator: Union[
            AsyncIterable["DiscoveryRequest"], Iterable["DiscoveryRequest"]
        ],
    ) -> AsyncIterator["DiscoveryResponse"]:

        async for response in self._stream_stream(
            "/envoy.api.v2.ScopedRoutesDiscoveryService/StreamScopedRoutes",
            request_iterator,
            DiscoveryRequest,
            DiscoveryResponse,
        ):
            yield response

    async def delta_scoped_routes(
        self,
        request_iterator: Union[
            AsyncIterable["DeltaDiscoveryRequest"], Iterable["DeltaDiscoveryRequest"]
        ],
    ) -> AsyncIterator["DeltaDiscoveryResponse"]:

        async for response in self._stream_stream(
            "/envoy.api.v2.ScopedRoutesDiscoveryService/DeltaScopedRoutes",
            request_iterator,
            DeltaDiscoveryRequest,
            DeltaDiscoveryResponse,
        ):
            yield response

    async def fetch_scoped_routes(
        self,
        *,
        version_info: str = "",
        node: "core.Node" = None,
        resource_names: Optional[List[str]] = None,
        type_url: str = "",
        response_nonce: str = "",
        error_detail: "___google_rpc__.Status" = None,
    ) -> "DiscoveryResponse":
        resource_names = resource_names or []

        request = DiscoveryRequest()
        request.version_info = version_info
        if node is not None:
            request.node = node
        request.resource_names = resource_names
        request.type_url = type_url
        request.response_nonce = response_nonce
        if error_detail is not None:
            request.error_detail = error_detail

        return await self._unary_unary(
            "/envoy.api.v2.ScopedRoutesDiscoveryService/FetchScopedRoutes",
            request,
            DiscoveryResponse,
        )


class ClusterDiscoveryServiceBase(ServiceBase):
    async def stream_clusters(
        self, request_iterator: AsyncIterator["DiscoveryRequest"]
    ) -> AsyncIterator["DiscoveryResponse"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def delta_clusters(
        self, request_iterator: AsyncIterator["DeltaDiscoveryRequest"]
    ) -> AsyncIterator["DeltaDiscoveryResponse"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def fetch_clusters(
        self,
        version_info: str,
        node: "core.Node",
        resource_names: Optional[List[str]],
        type_url: str,
        response_nonce: str,
        error_detail: "___google_rpc__.Status",
    ) -> "DiscoveryResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_stream_clusters(self, stream: grpclib.server.Stream) -> None:
        request_kwargs = {"request_iterator": stream.__aiter__()}

        await self._call_rpc_handler_server_stream(
            self.stream_clusters,
            stream,
            request_kwargs,
        )

    async def __rpc_delta_clusters(self, stream: grpclib.server.Stream) -> None:
        request_kwargs = {"request_iterator": stream.__aiter__()}

        await self._call_rpc_handler_server_stream(
            self.delta_clusters,
            stream,
            request_kwargs,
        )

    async def __rpc_fetch_clusters(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "version_info": request.version_info,
            "node": request.node,
            "resource_names": request.resource_names,
            "type_url": request.type_url,
            "response_nonce": request.response_nonce,
            "error_detail": request.error_detail,
        }

        response = await self.fetch_clusters(**request_kwargs)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/envoy.api.v2.ClusterDiscoveryService/StreamClusters": grpclib.const.Handler(
                self.__rpc_stream_clusters,
                grpclib.const.Cardinality.STREAM_STREAM,
                DiscoveryRequest,
                DiscoveryResponse,
            ),
            "/envoy.api.v2.ClusterDiscoveryService/DeltaClusters": grpclib.const.Handler(
                self.__rpc_delta_clusters,
                grpclib.const.Cardinality.STREAM_STREAM,
                DeltaDiscoveryRequest,
                DeltaDiscoveryResponse,
            ),
            "/envoy.api.v2.ClusterDiscoveryService/FetchClusters": grpclib.const.Handler(
                self.__rpc_fetch_clusters,
                grpclib.const.Cardinality.UNARY_UNARY,
                DiscoveryRequest,
                DiscoveryResponse,
            ),
        }


class ListenerDiscoveryServiceBase(ServiceBase):
    async def delta_listeners(
        self, request_iterator: AsyncIterator["DeltaDiscoveryRequest"]
    ) -> AsyncIterator["DeltaDiscoveryResponse"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def stream_listeners(
        self, request_iterator: AsyncIterator["DiscoveryRequest"]
    ) -> AsyncIterator["DiscoveryResponse"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def fetch_listeners(
        self,
        version_info: str,
        node: "core.Node",
        resource_names: Optional[List[str]],
        type_url: str,
        response_nonce: str,
        error_detail: "___google_rpc__.Status",
    ) -> "DiscoveryResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_delta_listeners(self, stream: grpclib.server.Stream) -> None:
        request_kwargs = {"request_iterator": stream.__aiter__()}

        await self._call_rpc_handler_server_stream(
            self.delta_listeners,
            stream,
            request_kwargs,
        )

    async def __rpc_stream_listeners(self, stream: grpclib.server.Stream) -> None:
        request_kwargs = {"request_iterator": stream.__aiter__()}

        await self._call_rpc_handler_server_stream(
            self.stream_listeners,
            stream,
            request_kwargs,
        )

    async def __rpc_fetch_listeners(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "version_info": request.version_info,
            "node": request.node,
            "resource_names": request.resource_names,
            "type_url": request.type_url,
            "response_nonce": request.response_nonce,
            "error_detail": request.error_detail,
        }

        response = await self.fetch_listeners(**request_kwargs)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/envoy.api.v2.ListenerDiscoveryService/DeltaListeners": grpclib.const.Handler(
                self.__rpc_delta_listeners,
                grpclib.const.Cardinality.STREAM_STREAM,
                DeltaDiscoveryRequest,
                DeltaDiscoveryResponse,
            ),
            "/envoy.api.v2.ListenerDiscoveryService/StreamListeners": grpclib.const.Handler(
                self.__rpc_stream_listeners,
                grpclib.const.Cardinality.STREAM_STREAM,
                DiscoveryRequest,
                DiscoveryResponse,
            ),
            "/envoy.api.v2.ListenerDiscoveryService/FetchListeners": grpclib.const.Handler(
                self.__rpc_fetch_listeners,
                grpclib.const.Cardinality.UNARY_UNARY,
                DiscoveryRequest,
                DiscoveryResponse,
            ),
        }


class RouteDiscoveryServiceBase(ServiceBase):
    async def stream_routes(
        self, request_iterator: AsyncIterator["DiscoveryRequest"]
    ) -> AsyncIterator["DiscoveryResponse"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def delta_routes(
        self, request_iterator: AsyncIterator["DeltaDiscoveryRequest"]
    ) -> AsyncIterator["DeltaDiscoveryResponse"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def fetch_routes(
        self,
        version_info: str,
        node: "core.Node",
        resource_names: Optional[List[str]],
        type_url: str,
        response_nonce: str,
        error_detail: "___google_rpc__.Status",
    ) -> "DiscoveryResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_stream_routes(self, stream: grpclib.server.Stream) -> None:
        request_kwargs = {"request_iterator": stream.__aiter__()}

        await self._call_rpc_handler_server_stream(
            self.stream_routes,
            stream,
            request_kwargs,
        )

    async def __rpc_delta_routes(self, stream: grpclib.server.Stream) -> None:
        request_kwargs = {"request_iterator": stream.__aiter__()}

        await self._call_rpc_handler_server_stream(
            self.delta_routes,
            stream,
            request_kwargs,
        )

    async def __rpc_fetch_routes(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "version_info": request.version_info,
            "node": request.node,
            "resource_names": request.resource_names,
            "type_url": request.type_url,
            "response_nonce": request.response_nonce,
            "error_detail": request.error_detail,
        }

        response = await self.fetch_routes(**request_kwargs)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/envoy.api.v2.RouteDiscoveryService/StreamRoutes": grpclib.const.Handler(
                self.__rpc_stream_routes,
                grpclib.const.Cardinality.STREAM_STREAM,
                DiscoveryRequest,
                DiscoveryResponse,
            ),
            "/envoy.api.v2.RouteDiscoveryService/DeltaRoutes": grpclib.const.Handler(
                self.__rpc_delta_routes,
                grpclib.const.Cardinality.STREAM_STREAM,
                DeltaDiscoveryRequest,
                DeltaDiscoveryResponse,
            ),
            "/envoy.api.v2.RouteDiscoveryService/FetchRoutes": grpclib.const.Handler(
                self.__rpc_fetch_routes,
                grpclib.const.Cardinality.UNARY_UNARY,
                DiscoveryRequest,
                DiscoveryResponse,
            ),
        }


class VirtualHostDiscoveryServiceBase(ServiceBase):
    async def delta_virtual_hosts(
        self, request_iterator: AsyncIterator["DeltaDiscoveryRequest"]
    ) -> AsyncIterator["DeltaDiscoveryResponse"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_delta_virtual_hosts(self, stream: grpclib.server.Stream) -> None:
        request_kwargs = {"request_iterator": stream.__aiter__()}

        await self._call_rpc_handler_server_stream(
            self.delta_virtual_hosts,
            stream,
            request_kwargs,
        )

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/envoy.api.v2.VirtualHostDiscoveryService/DeltaVirtualHosts": grpclib.const.Handler(
                self.__rpc_delta_virtual_hosts,
                grpclib.const.Cardinality.STREAM_STREAM,
                DeltaDiscoveryRequest,
                DeltaDiscoveryResponse,
            ),
        }


class EndpointDiscoveryServiceBase(ServiceBase):
    async def stream_endpoints(
        self, request_iterator: AsyncIterator["DiscoveryRequest"]
    ) -> AsyncIterator["DiscoveryResponse"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def delta_endpoints(
        self, request_iterator: AsyncIterator["DeltaDiscoveryRequest"]
    ) -> AsyncIterator["DeltaDiscoveryResponse"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def fetch_endpoints(
        self,
        version_info: str,
        node: "core.Node",
        resource_names: Optional[List[str]],
        type_url: str,
        response_nonce: str,
        error_detail: "___google_rpc__.Status",
    ) -> "DiscoveryResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_stream_endpoints(self, stream: grpclib.server.Stream) -> None:
        request_kwargs = {"request_iterator": stream.__aiter__()}

        await self._call_rpc_handler_server_stream(
            self.stream_endpoints,
            stream,
            request_kwargs,
        )

    async def __rpc_delta_endpoints(self, stream: grpclib.server.Stream) -> None:
        request_kwargs = {"request_iterator": stream.__aiter__()}

        await self._call_rpc_handler_server_stream(
            self.delta_endpoints,
            stream,
            request_kwargs,
        )

    async def __rpc_fetch_endpoints(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "version_info": request.version_info,
            "node": request.node,
            "resource_names": request.resource_names,
            "type_url": request.type_url,
            "response_nonce": request.response_nonce,
            "error_detail": request.error_detail,
        }

        response = await self.fetch_endpoints(**request_kwargs)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/envoy.api.v2.EndpointDiscoveryService/StreamEndpoints": grpclib.const.Handler(
                self.__rpc_stream_endpoints,
                grpclib.const.Cardinality.STREAM_STREAM,
                DiscoveryRequest,
                DiscoveryResponse,
            ),
            "/envoy.api.v2.EndpointDiscoveryService/DeltaEndpoints": grpclib.const.Handler(
                self.__rpc_delta_endpoints,
                grpclib.const.Cardinality.STREAM_STREAM,
                DeltaDiscoveryRequest,
                DeltaDiscoveryResponse,
            ),
            "/envoy.api.v2.EndpointDiscoveryService/FetchEndpoints": grpclib.const.Handler(
                self.__rpc_fetch_endpoints,
                grpclib.const.Cardinality.UNARY_UNARY,
                DiscoveryRequest,
                DiscoveryResponse,
            ),
        }


class ScopedRoutesDiscoveryServiceBase(ServiceBase):
    async def stream_scoped_routes(
        self, request_iterator: AsyncIterator["DiscoveryRequest"]
    ) -> AsyncIterator["DiscoveryResponse"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def delta_scoped_routes(
        self, request_iterator: AsyncIterator["DeltaDiscoveryRequest"]
    ) -> AsyncIterator["DeltaDiscoveryResponse"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def fetch_scoped_routes(
        self,
        version_info: str,
        node: "core.Node",
        resource_names: Optional[List[str]],
        type_url: str,
        response_nonce: str,
        error_detail: "___google_rpc__.Status",
    ) -> "DiscoveryResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_stream_scoped_routes(self, stream: grpclib.server.Stream) -> None:
        request_kwargs = {"request_iterator": stream.__aiter__()}

        await self._call_rpc_handler_server_stream(
            self.stream_scoped_routes,
            stream,
            request_kwargs,
        )

    async def __rpc_delta_scoped_routes(self, stream: grpclib.server.Stream) -> None:
        request_kwargs = {"request_iterator": stream.__aiter__()}

        await self._call_rpc_handler_server_stream(
            self.delta_scoped_routes,
            stream,
            request_kwargs,
        )

    async def __rpc_fetch_scoped_routes(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "version_info": request.version_info,
            "node": request.node,
            "resource_names": request.resource_names,
            "type_url": request.type_url,
            "response_nonce": request.response_nonce,
            "error_detail": request.error_detail,
        }

        response = await self.fetch_scoped_routes(**request_kwargs)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/envoy.api.v2.ScopedRoutesDiscoveryService/StreamScopedRoutes": grpclib.const.Handler(
                self.__rpc_stream_scoped_routes,
                grpclib.const.Cardinality.STREAM_STREAM,
                DiscoveryRequest,
                DiscoveryResponse,
            ),
            "/envoy.api.v2.ScopedRoutesDiscoveryService/DeltaScopedRoutes": grpclib.const.Handler(
                self.__rpc_delta_scoped_routes,
                grpclib.const.Cardinality.STREAM_STREAM,
                DeltaDiscoveryRequest,
                DeltaDiscoveryResponse,
            ),
            "/envoy.api.v2.ScopedRoutesDiscoveryService/FetchScopedRoutes": grpclib.const.Handler(
                self.__rpc_fetch_scoped_routes,
                grpclib.const.Cardinality.UNARY_UNARY,
                DiscoveryRequest,
                DiscoveryResponse,
            ),
        }


from . import auth
from . import cluster
from . import core
from . import endpoint
from . import listener
from . import route
from ... import type as __type__
from ....google import rpc as ___google_rpc__
from ...config.filter.accesslog import v2 as __config_filter_accesslog_v2__
from ...config.listener import v2 as __config_listener_v2__
import betterproto.lib.google.protobuf as betterproto_lib_google_protobuf
